/* png.h - header file for PNG reference library
 *
 * libpng version 1.2.8 - December 3, 2004
 * Copyright (c) 1998-2004 Glenn Randers-Pehrson
 * (Version 0.96 Copyright (c) 1996, 1997 Andreas Dilger)
 * (Version 0.88 Copyright (c) 1995, 1996 Guy Eric Schalnat, Group 42, Inc.)
 *
 * Authors and maintainers:
 *  libpng versions 0.71, May 1995, through 0.88, January 1996: Guy Schalnat
 *  libpng versions 0.89c, June 1996, through 0.96, May 1997: Andreas Dilger
 *  libpng versions 0.97, January 1998, through 1.2.8 - December 3, 2004: Glenn
 *  See also "Contributing Authors", below.
 *
 * Note about libpng version numbers:
 *
 *    Due to various miscommunications, unforeseen code incompatibilities
 *    and occasional factors outside the authors' control, version numbering
 *    on the library has not always been consistent and straightforward.
 *    The following table summarizes matters since version 0.89c, which was
 *    the first widely used release:
 *
 *    source                 png.h  png.h  shared-lib
 *    version                string   int  version
 *    -------                ------ -----  ----------
 *    0.89c "1.0 beta 3"     0.89      89  1.0.89
 *    0.90  "1.0 beta 4"     0.90      90  0.90  [should have been 2.0.90]
 *    0.95  "1.0 beta 5"     0.95      95  0.95  [should have been 2.0.95]
 *    0.96  "1.0 beta 6"     0.96      96  0.96  [should have been 2.0.96]
 *    0.97b "1.00.97 beta 7" 1.00.97   97  1.0.1 [should have been 2.0.97]
 *    0.97c                  0.97      97  2.0.97
 *    0.98                   0.98      98  2.0.98
 *    0.99                   0.99      98  2.0.99
 *    0.99a-m                0.99      99  2.0.99
 *    1.00                   1.00     100  2.1.0 [100 should be 10000]
 *    1.0.0      (from here on, the   100  2.1.0 [100 should be 10000]
 *    1.0.1       png.h string is   10001  2.1.0
 *    1.0.1a-e    identical to the  10002  from here on, the shared library
 *    1.0.2       source version)   10002  is 2.V where V is the source code
 *    1.0.2a-b                      10003  version, except as noted.
 *    1.0.3                         10003
 *    1.0.3a-d                      10004
 *    1.0.4                         10004
 *    1.0.4a-f                      10005
 *    1.0.5 (+ 2 patches)           10005
 *    1.0.5a-d                      10006
 *    1.0.5e-r                      10100 (not source compatible)
 *    1.0.5s-v                      10006 (not binary compatible)
 *    1.0.6 (+ 3 patches)           10006 (still binary incompatible)
 *    1.0.6d-f                      10007 (still binary incompatible)
 *    1.0.6g                        10007
 *    1.0.6h                        10007  10.6h (testing xy.z so-numbering)
 *    1.0.6i                        10007  10.6i
 *    1.0.6j                        10007  2.1.0.6j (incompatible with 1.0.0)
 *    1.0.7beta11-14        DLLNUM  10007  2.1.0.7beta11-14 (binary compatible)
 *    1.0.7beta15-18           1    10007  2.1.0.7beta15-18 (binary compatible)
 *    1.0.7rc1-2               1    10007  2.1.0.7rc1-2 (binary compatible)
 *    1.0.7                    1    10007  (still compatible)
 *    1.0.8beta1-4             1    10008  2.1.0.8beta1-4
 *    1.0.8rc1                 1    10008  2.1.0.8rc1
 *    1.0.8                    1    10008  2.1.0.8
 *    1.0.9beta1-6             1    10009  2.1.0.9beta1-6
 *    1.0.9rc1                 1    10009  2.1.0.9rc1
 *    1.0.9beta7-10            1    10009  2.1.0.9beta7-10
 *    1.0.9rc2                 1    10009  2.1.0.9rc2
 *    1.0.9                    1    10009  2.1.0.9
 *    1.0.10beta1              1    10010  2.1.0.10beta1
 *    1.0.10rc1                1    10010  2.1.0.10rc1
 *    1.0.10                   1    10010  2.1.0.10
 *    1.0.11beta1-3            1    10011  2.1.0.11beta1-3
 *    1.0.11rc1                1    10011  2.1.0.11rc1
 *    1.0.11                   1    10011  2.1.0.11
 *    1.0.12beta1-2            2    10012  2.1.0.12beta1-2
 *    1.0.12rc1                2    10012  2.1.0.12rc1
 *    1.0.12                   2    10012  2.1.0.12
 *    1.1.0a-f                 -    10100  2.1.1.0a-f (branch abandoned)
 *    1.2.0beta1-2             2    10200  2.1.2.0beta1-2
 *    1.2.0beta3-5             3    10200  3.1.2.0beta3-5
 *    1.2.0rc1                 3    10200  3.1.2.0rc1
 *    1.2.0                    3    10200  3.1.2.0
 *    1.2.1beta1-4             3    10201  3.1.2.1beta1-4
 *    1.2.1rc1-2               3    10201  3.1.2.1rc1-2
 *    1.2.1                    3    10201  3.1.2.1
 *    1.2.2beta1-6            12    10202  12.so.0.1.2.2beta1-6
 *    1.0.13beta1             10    10013  10.so.0.1.0.13beta1
 *    1.0.13rc1               10    10013  10.so.0.1.0.13rc1
 *    1.2.2rc1                12    10202  12.so.0.1.2.2rc1
 *    1.0.13                  10    10013  10.so.0.1.0.13
 *    1.2.2                   12    10202  12.so.0.1.2.2
 *    1.2.3rc1-6              12    10203  12.so.0.1.2.3rc1-6
 *    1.2.3                   12    10203  12.so.0.1.2.3
 *    1.2.4beta1-3            13    10204  12.so.0.1.2.4beta1-3
 *    1.0.14rc1               13    10014  10.so.0.1.0.14rc1
 *    1.2.4rc1                13    10204  12.so.0.1.2.4rc1
 *    1.0.14                  10    10014  10.so.0.1.0.14
 *    1.2.4                   13    10204  12.so.0.1.2.4
 *    1.2.5beta1-2            13    10205  12.so.0.1.2.5beta1-2
 *    1.0.15rc1-3             10    10015  10.so.0.1.0.15rc1-3
 *    1.2.5rc1-3              13    10205  12.so.0.1.2.5rc1-3
 *    1.0.15                  10    10015  10.so.0.1.0.15
 *    1.2.5                   13    10205  12.so.0.1.2.5
 *    1.2.6beta1-4            13    10206  12.so.0.1.2.6beta1-4
 *    1.0.16                  10    10016  10.so.0.1.0.16
 *    1.2.6                   13    10206  12.so.0.1.2.6
 *    1.2.7beta1-2            13    10207  12.so.0.1.2.7beta1-2
 *    1.0.17rc1               10    10017  12.so.0.1.0.17rc1
 *    1.2.7rc1                13    10207  12.so.0.1.2.7rc1
 *    1.0.17                  10    10017  12.so.0.1.0.17
 *    1.2.7                   13    10207  12.so.0.1.2.7
 *    1.2.8beta1-5            13    10208  12.so.0.1.2.8beta1-5
 *    1.0.18rc1-5             10    10018  12.so.0.1.0.18rc1-5
 *    1.2.8rc1-5              13    10208  12.so.0.1.2.8rc1-5
 *    1.0.18                  10    10018  12.so.0.1.0.18
 *    1.2.8                   13    10208  12.so.0.1.2.8
 *
 *    Henceforth the source version will match the shared-library major
 *    and minor numbers; the shared-library major version number will be
 *    used for changes in backward compatibility, as it is intended.  The
 *    PNG_LIBPNG_VER macro, which is not used within libpng but is available
 *    for applications, is an unsigned integer of the form xyyzz corresponding
 *    to the source version x.y.z (leading zeros in y and z).  Beta versions
 *    were given the previous public release number plus a letter, until
 *    version 1.0.6j; from then on they were given the upcoming public
 *    release number plus "betaNN" or "rcN".
 *
 *    Binary incompatibility exists only when applications make direct access
 *    to the info_ptr or png_ptr members through png.h, and the compiled
 *    application is loaded with a different version of the library.
 *
 *    DLLNUM will change each time there are forward or backward changes
 *    in binary compatibility (e.g., when a new feature is added).
 *
 * See libpng.txt or libpng.3 for more information.  The PNG specification
 * is available as a W3C Recommendation and as an ISO Specification,
 * <http://www.w3.org/TR/2003/REC-PNG-20031110/
 */

/*
 * COPYRIGHT NOTICE, DISCLAIMER, and LICENSE:
 *
 * If you modify libpng you may insert additional notices immediately following
 * this sentence.
 *
 * libpng versions 1.2.6, August 15, 2004, through 1.2.8, December 3, 2004, are
 * Copyright (c) 2004 Glenn Randers-Pehrson, and are
 * distributed according to the same disclaimer and license as libpng-1.2.5
 * with the following individual added to the list of Contributing Authors:
 *
 *    Cosmin Truta
 *
 * libpng versions 1.0.7, July 1, 2000, through 1.2.5, October 3, 2002, are
 * Copyright (c) 2000-2002 Glenn Randers-Pehrson, and are
 * distributed according to the same disclaimer and license as libpng-1.0.6
 * with the following individuals added to the list of Contributing Authors:
 *
 *    Simon-Pierre Cadieux
 *    Eric S. Raymond
 *    Gilles Vollant
 *
 * and with the following additions to the disclaimer:
 *
 *    There is no warranty against interference with your enjoyment of the
 *    library or against infringement.  There is no warranty that our
 *    efforts or the library will fulfill any of your particular purposes
 *    or needs.  This library is provided with all faults, and the entire
 *    risk of satisfactory quality, performance, accuracy, and effort is with
 *    the user.
 *
 * libpng versions 0.97, January 1998, through 1.0.6, March 20, 2000, are
 * Copyright (c) 1998, 1999, 2000 Glenn Randers-Pehrson, and are
 * distributed according to the same disclaimer and license as libpng-0.96,
 * with the following individuals added to the list of Contributing Authors:
 *
 *    Tom Lane
 *    Glenn Randers-Pehrson
 *    Willem van Schaik
 *
 * libpng versions 0.89, June 1996, through 0.96, May 1997, are
 * Copyright (c) 1996, 1997 Andreas Dilger
 * Distributed according to the same disclaimer and license as libpng-0.88,
 * with the following individuals added to the list of Contributing Authors:
 *
 *    John Bowler
 *    Kevin Bracey
 *    Sam Bushell
 *    Magnus Holmgren
 *    Greg Roelofs
 *    Tom Tanner
 *
 * libpng versions 0.5, May 1995, through 0.88, January 1996, are
 * Copyright (c) 1995, 1996 Guy Eric Schalnat, Group 42, Inc.
 *
 * For the purposes of this copyright and license, "Contributing Authors"
 * is defined as the following set of individuals:
 *
 *    Andreas Dilger
 *    Dave Martindale
 *    Guy Eric Schalnat
 *    Paul Schmidt
 *    Tim Wegner
 *
 * The PNG Reference Library is supplied "AS IS".  The Contributing Authors
 * and Group 42, Inc. disclaim all warranties, expressed or implied,
 * including, without limitation, the warranties of merchantability and of
 * fitness for any purpose.  The Contributing Authors and Group 42, Inc.
 * assume no liability for direct, indirect, incidental, special, exemplary,
 * or consequential damages, which may result from the use of the PNG
 * Reference Library, even if advised of the possibility of such damage.
 *
 * Permission is hereby granted to use, copy, modify, and distribute this
 * source code, or portions hereof, for any purpose, without fee, subject
 * to the following restrictions:
 *
 * 1. The origin of this source code must not be misrepresented.
 *
 * 2. Altered versions must be plainly marked as such and
 * must not be misrepresented as being the original source.
 *
 * 3. This Copyright notice may not be removed or altered from
 *    any source or altered source distribution.
 *
 * The Contributing Authors and Group 42, Inc. specifically permit, without
 * fee, and encourage the use of this source code as a component to
 * supporting the PNG file format in commercial products.  If you use this
 * source code in a product, acknowledgment is not required but would be
 * appreciated.
 */

/*
 * A "png_get_copyright" function is available, for convenient use in "about"
 * boxes and the like:
 *
 * printf("%s",png_get_copyright(NULL));
 *
 * Also, the PNG logo (in PNG format, of course) is supplied in the
 * files "pngbar.png" and "pngbar.jpg (88x31) and "pngnow.png" (98x31).
 */

/*
 * Libpng is OSI Certified Open Source Software.  OSI Certified is a
 * certification mark of the Open Source Initiative.
 */

/*
 * The contributing authors would like to thank all those who helped
 * with testing, bug fixes, and patience.  This wouldn't have been
 * possible without all of you.
 *
 * Thanks to Frank J. T. Wojcik for helping with the documentation.
 */

/*
 * Y2K compliance in libpng:
 * =========================
 *
 *    December 3, 2004
 *
 *    Since the PNG Development group is an ad-hoc body, we can't make
 *    an official declaration.
 *
 *    This is your unofficial assurance that libpng from version 0.71 and
 *    upward through 1.2.8 are Y2K compliant.  It is my belief that earlier
 *    versions were also Y2K compliant.
 *
 *    Libpng only has three year fields.  One is a 2-byte unsigned integer
 *    that will hold years up to 65535.  The other two hold the date in text
 *    format, and will hold years up to 9999.
 *
 *    The integer is
 *        "png_uint_16 year" in png_time_struct.
 *
 *    The strings are
 *        "png_charp time_buffer" in png_struct and
 *        "near_time_buffer", which is a local character string in png.c.
 *
 *    There are seven time-related functions:
 *        png.c: png_convert_to_rfc_1123() in png.c
 *          (formerly png_convert_to_rfc_1152() in error)
 *        png_convert_from_struct_tm() in pngwrite.c, called in pngwrite.c
 *        png_convert_from_time_t() in pngwrite.c
 *        png_get_tIME() in pngget.c
 *        png_handle_tIME() in pngrutil.c, called in pngread.c
 *        png_set_tIME() in pngset.c
 *        png_write_tIME() in pngwutil.c, called in pngwrite.c
 *
 *    All handle dates properly in a Y2K environment.  The
 *    png_convert_from_time_t() function calls gmtime() to convert from system
 *    clock time, which returns (year - 1900), which we properly convert to
 *    the full 4-digit year.  There is a possibility that applications using
 *    libpng are not passing 4-digit years into the png_convert_to_rfc_1123()
 *    function, or that they are incorrectly passing only a 2-digit year
 *    instead of "year - 1900" into the png_convert_from_struct_tm() function,
 *    but this is not under our control.  The libpng documentation has always
 *    stated that it works with 4-digit years, and the APIs have been
 *    documented as such.
 *
 *    The tIME chunk itself is also Y2K compliant.  It uses a 2-byte unsigned
 *    integer to hold the year, and can hold years as large as 65535.
 *
 *    zlib, upon which libpng depends, is also Y2K compliant.  It contains
 *    no date-related code.
 *
 *       Glenn Randers-Pehrson
 *       libpng maintainer
 *       PNG Development Group
 */

#ifndef PNG_H
#define PNG_H

/* This is not the place to learn how to use libpng.  The file libpng.txt
 * describes how to use libpng, and the file example.c summarizes it
 * with some code on which to build.  This file is useful for looking
 * at the actual function definitions and structure components.
 */

/* Version information for png.h - this should match the version in png.c */
#define PNG_LIBPNG_VER_STRING "1.2.8"
#define PNG_HEADER_VERSION_STRING \
   " libpng version 1.2.8 - December 3, 2004 (header)\n"

#define PNG_LIBPNG_VER_SONUM   0
#define PNG_LIBPNG_VER_DLLNUM  13

/* These should match the first 3 components of PNG_LIBPNG_VER_STRING: */
#define PNG_LIBPNG_VER_MAJOR   1
#define PNG_LIBPNG_VER_MINOR   2
#define PNG_LIBPNG_VER_RELEASE 8
/* This should match the numeric part of the final component of
 * PNG_LIBPNG_VER_STRING, omitting any leading zero: */

#define PNG_LIBPNG_VER_BUILD  0

/* Release Status */
#define PNG_LIBPNG_BUILD_ALPHA    1
#define PNG_LIBPNG_BUILD_BETA     2
#define PNG_LIBPNG_BUILD_RC       3
#define PNG_LIBPNG_BUILD_STABLE   4
#define PNG_LIBPNG_BUILD_RELEASE_STATUS_MASK 7

/* Release-Specific Flags */
#define PNG_LIBPNG_BUILD_PATCH    8 /* Can be OR'ed with
                                       PNG_LIBPNG_BUILD_STABLE only */
#define PNG_LIBPNG_BUILD_PRIVATE 16 /* Cannot be OR'ed with
                                       PNG_LIBPNG_BUILD_SPECIAL */
#define PNG_LIBPNG_BUILD_SPECIAL 32 /* Cannot be OR'ed with
                                       PNG_LIBPNG_BUILD_PRIVATE */

#define PNG_LIBPNG_BUILD_BASE_TYPE PNG_LIBPNG_BUILD_STABLE

/* Careful here.  At one time, Guy wanted to use 082, but that would be octal.
 * We must not include leading zeros.
 * Versions 0.7 through 1.0.0 were in the range 0 to 100 here (only
 * version 1.0.0 was mis-numbered 100 instead of 10000).  From
 * version 1.0.1 it's    xxyyzz, where x=major, y=minor, z=release */
#define PNG_LIBPNG_VER 10208 /* 1.2.8 */

#ifndef PNG_VERSION_INFO_ONLY
/* include the compression library's header */
#include "zlib.h"
#endif

/* include all user configurable info, including optional assembler routines */
#include "pngconf.h"

/*
 * Added at libpng-1.2.8 */
/* Ref MSDN: Private as priority over Special
 * VS_FF_PRIVATEBUILD File *was not* built using standard release
 * procedures. If this value is given, the StringFileInfo block must
 * contain a PrivateBuild string.
 *
 * VS_FF_SPECIALBUILD File *was* built by the original company using
 * standard release procedures but is a variation of the standard
 * file of the same version number. If this value is given, the
 * StringFileInfo block must contain a SpecialBuild string.
 */

#if defined(PNG_USER_PRIVATEBUILD)
#  define PNG_LIBPNG_BUILD_TYPE PNG_LIBPNG_BUILD_BASE_TYPE | \
          PNG_LIBPNG_BUILD_PRIVATE
#else
#  if defined(PNG_LIBPNG_SPECIALBUILD)
#    define PNG_LIBPNG_BUILD_TYPE PNG_LIBPNG_BUILD_BASE_TYPE | \
            PNG_LIBPNG_BUILD_SPECIAL
#  else
#    define PNG_LIBPNG_BUILD_TYPE PNG_LIBPNG_BUILD_BASE_TYPE
#  endif
#endif

#ifndef PNG_VERSION_INFO_ONLY

/* Inhibit C++ name-mangling for libpng functions but not for system calls. */
#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* This file is arranged in several sections.  The first section contains
 * structure and type definitions.  The second section contains the external
 * library functions, while the third has the internal library functions,
 * which applications aren't expected to use directly.
 */

#ifndef PNG_NO_TYPECAST_NULL
#define int_p_NULL                (int *)NULL
#define png_bytep_NULL            (png_bytep)NULL
#define png_bytepp_NULL           (png_bytepp)NULL
#define png_doublep_NULL          (png_doublep)NULL
#define png_error_ptr_NULL        (png_error_ptr)NULL
#define png_flush_ptr_NULL        (png_flush_ptr)NULL
#define png_free_ptr_NULL         (png_free_ptr)NULL
#define png_infopp_NULL           (png_infopp)NULL
#define png_malloc_ptr_NULL       (png_malloc_ptr)NULL
#define png_read_status_ptr_NULL  (png_read_status_ptr)NULL
#define png_rw_ptr_NULL           (png_rw_ptr)NULL
#define png_structp_NULL          (png_structp)NULL
#define png_uint_16p_NULL         (png_uint_16p)NULL
#define png_voidp_NULL            (png_voidp)NULL
#define png_write_status_ptr_NULL (png_write_status_ptr)NULL
#else
#define int_p_NULL                NULL
#define png_bytep_NULL            NULL
#define png_bytepp_NULL           NULL
#define png_doublep_NULL          NULL
#define png_error_ptr_NULL        NULL
#define png_flush_ptr_NULL        NULL
#define png_free_ptr_NULL         NULL
#define png_infopp_NULL           NULL
#define png_malloc_ptr_NULL       NULL
#define png_read_status_ptr_NULL  NULL
#define png_rw_ptr_NULL           NULL
#define png_structp_NULL          NULL
#define png_uint_16p_NULL         NULL
#define png_voidp_NULL            NULL
#define png_write_status_ptr_NULL NULL
#endif

/* variables declared in png.c - only it needs to define PNG_NO_EXTERN */
#if !defined(PNG_NO_EXTERN) || defined(PNG_ALWAYS_EXTERN)
/* Version information for C files, stored in png.c.  This had better match
 * the version above.
 */
#ifdef PNG_USE_GLOBAL_ARRAYS
PNG_EXPORT_VAR (const char) png_libpng_ver[18];
  /* need room for 99.99.99beta99z */
#else
#define png_libpng_ver png_get_header_ver(NULL)
#endif

#ifdef PNG_USE_GLOBAL_ARRAYS
/* This was removed in version 1.0.5c */
/* Structures to facilitate easy interlacing.  See png.c for more details */
PNG_EXPORT_VAR (const int FARDATA) png_pass_start[7];
PNG_EXPORT_VAR (const int FARDATA) png_pass_inc[7];
PNG_EXPORT_VAR (const int FARDATA) png_pass_ystart[7];
PNG_EXPORT_VAR (const int FARDATA) png_pass_yinc[7];
PNG_EXPORT_VAR (const int FARDATA) png_pass_mask[7];
PNG_EXPORT_VAR (const int FARDATA) png_pass_dsp_mask[7];
#ifdef PNG_HAVE_ASSEMBLER_COMBINE_ROW
PNG_EXPORT_VAR (const int FARDATA) png_pass_width[7];
#endif
/* This isn't currently used.  If you need it, see png.c for more details.
PNG_EXPORT_VAR (const int FARDATA) png_pass_height[7];
*/
#endif

#endif /* PNG_NO_EXTERN */

/* Three color definitions.  The order of the red, green, and blue, (and the
 * exact size) is not important, although the size of the fields need to
 * be png_byte or png_uint_16 (as defined below).
 */
typedef struct png_color_struct
{
   png_byte red;
   png_byte green;
   png_byte blue;
} png_color;
typedef png_color FAR * png_colorp;
typedef png_color FAR * FAR * png_colorpp;

typedef struct png_color_16_struct
{
   png_byte index;    /* used for palette files */
   png_uint_16 red;   /* for use in red green blue files */
   png_uint_16 green;
   png_uint_16 blue;
   png_uint_16 gray;  /* for use in grayscale files */
} png_color_16;
typedef png_color_16 FAR * png_color_16p;
typedef png_color_16 FAR * FAR * png_color_16pp;

typedef struct png_color_8_struct
{
   png_byte red;   /* for use in red green blue files */
   png_byte green;
   png_byte blue;
   png_byte gray;  /* for use in grayscale files */
   png_byte alpha; /* for alpha channel files */
} png_color_8;
typedef png_color_8 FAR * png_color_8p;
typedef png_color_8 FAR * FAR * png_color_8pp;

/*
 * The following two structures are used for the in-core representation
 * of sPLT chunks.
 */
typedef struct png_sPLT_entry_struct
{
   png_uint_16 red;
   png_uint_16 green;
   png_uint_16 blue;
   png_uint_16 alpha;
   png_uint_16 frequency;
} png_sPLT_entry;
typedef png_sPLT_entry FAR * png_sPLT_entryp;
typedef png_sPLT_entry FAR * FAR * png_sPLT_entrypp;

/*  When the depth of the sPLT palette is 8 bits, the color and alpha samples
 *  occupy the LSB of their respective members, and the MSB of each member
 *  is zero-filled.  The frequency member always occupies the full 16 bits.
 */

typedef struct png_sPLT_struct
{
   png_charp name;           /* palette name */
   png_byte depth;           /* depth of palette samples */
   png_sPLT_entryp entries;  /* palette entries */
   png_int_32 nentries;      /* number of palette entries */
} png_sPLT_t;
typedef png_sPLT_t FAR * png_sPLT_tp;
typedef png_sPLT_t FAR * FAR * png_sPLT_tpp;

#ifdef PNG_TEXT_SUPPORTED
/* png_text holds the contents of a text/ztxt/itxt chunk in a PNG file,
 * and whether that contents is compressed or not.  The "key" field
 * points to a regular zero-terminated C string.  The "text", "lang", and
 * "lang_key" fields can be regular C strings, empty strings, or NULL pointers.
 * However, the * structure returned by png_get_text() will always contain
 * regular zero-terminated C strings (possibly empty), never NULL pointers,
 * so they can be safely used in printf() and other string-handling functions.
 */
typedef struct png_text_struct
{
   int  compression;       /* compression value:
                             -1: tEXt, none
                              0: zTXt, deflate
                              1: iTXt, none
                              2: iTXt, deflate  */
   png_charp key;          /* keyword, 1-79 character description of "text" */
   png_charp text;         /* comment, may be an empty string (ie "")
                              or a NULL pointer */
   png_size_t text_length; /* length of the text string */
#ifdef PNG_iTXt_SUPPORTED
   png_size_t itxt_length; /* length of the itxt string */
   png_charp lang;         /* language code, 0-79 characters
                              or a NULL pointer */
   png_charp lang_key;     /* keyword translated UTF-8 string, 0 or more
                              chars or a NULL pointer */
#endif
} png_text;
typedef png_text FAR * png_textp;
typedef png_text FAR * FAR * png_textpp;
#endif

/* Supported compression types for text in PNG files (tEXt, and zTXt).
 * The values of the PNG_TEXT_COMPRESSION_ defines should NOT be changed. */
#define PNG_TEXT_COMPRESSION_NONE_WR -3
#define PNG_TEXT_COMPRESSION_zTXt_WR -2
#define PNG_TEXT_COMPRESSION_NONE    -1
#define PNG_TEXT_COMPRESSION_zTXt     0
#define PNG_ITXT_COMPRESSION_NONE     1
#define PNG_ITXT_COMPRESSION_zTXt     2
#define PNG_TEXT_COMPRESSION_LAST     3  /* Not a valid value */

/* png_time is a way to hold the time in an machine independent way.
 * Two conversions are provided, both from time_t and struct tm.  There
 * is no portable way to convert to either of these structures, as far
 * as I know.  If you know of a portable way, send it to me.  As a side
 * note - PNG has always been Year 2000 compliant!
 */
typedef struct png_time_struct
{
   png_uint_16 year; /* full year, as in, 1995 */
   png_byte month;   /* month of year, 1 - 12 */
   png_byte day;     /* day of month, 1 - 31 */
   png_byte hour;    /* hour of day, 0 - 23 */
   png_byte minute;  /* minute of hour, 0 - 59 */
   png_byte second;  /* second of minute, 0 - 60 (for leap seconds) */
} png_time;
typedef png_time FAR * png_timep;
typedef png_time FAR * FAR * png_timepp;

#if defined(PNG_UNKNOWN_CHUNKS_SUPPORTED)
/* png_unknown_chunk is a structure to hold queued chunks for which there is
 * no specific support.  The idea is that we can use this to queue
 * up private chunks for output even though the library doesn't actually
 * know about their semantics.
 */
typedef struct png_unknown_chunk_t
{
    png_byte name[5];
    png_byte *data;
    png_size_t size;

    /* libpng-using applications should NOT directly modify this byte. */
    png_byte location; /* mode of operation at read time */
}
png_unknown_chunk;
typedef png_unknown_chunk FAR * png_unknown_chunkp;
typedef png_unknown_chunk FAR * FAR * png_unknown_chunkpp;
#endif

/* png_info is a structure that holds the information in a PNG file so
 * that the application can find out the characteristics of the image.
 * If you are reading the file, this structure will tell you what is
 * in the PNG file.  If you are writing the file, fill in the information
 * you want to put into the PNG file, then call png_write_info().
 * The names chosen should be very close to the PNG specification, so
 * consult that document for information about the meaning of each field.
 *
 * With libpng < 0.95, it was only possible to directly set and read the
 * the values in the png_info_struct, which meant that the contents and
 * order of the values had to remain fixed.  With libpng 0.95 and later,
 * however, there are now functions that abstract the contents of
 * png_info_struct from the application, so this makes it easier to use
 * libpng with dynamic libraries, and even makes it possible to use
 * libraries that don't have all of the libpng ancillary chunk-handing
 * functionality.
 *
 * In any case, the order of the parameters in png_info_struct should NOT
 * be changed for as long as possible to keep compatibility with applications
 * that use the old direct-access method with png_info_struct.
 *
 * The following members may have allocated storage attached that should be
 * cleaned up before the structure is discarded: palette, trans, text,
 * pcal_purpose, pcal_units, pcal_params, hist, iccp_name, iccp_profile,
 * splt_palettes, scal_unit, row_pointers, and unknowns.   By default, these
 * are automatically freed when the info structure is deallocated, if they were
 * allocated internally by libpng.  This behavior can be changed by means
 * of the png_data_freer() function.
 *
 * More allocation details: all the chunk-reading functions that
 * change these members go through the corresponding png_set_*
 * functions.  A function to clear these members is available: see
 * png_free_data().  The png_set_* functions do not depend on being
 * able to point info structure members to any of the storage they are
 * passed (they make their own copies), EXCEPT that the png_set_text
 * functions use the same storage passed to them in the text_ptr or
 * itxt_ptr structure argument, and the png_set_rows and png_set_unknowns
 * functions do not make their own copies.
 */
typedef struct png_info_struct
{
   /* the following are necessary for every PNG file */
   png_uint_32 width;       /* width of image in pixels (from IHDR) */
   png_uint_32 height;      /* height of image in pixels (from IHDR) */
   png_uint_32 valid;       /* valid chunk data (see PNG_INFO_ below) */
   png_uint_32 rowbytes;    /* bytes needed to hold an untransformed row */
   png_colorp palette;      /* array of color values (valid & PNG_INFO_PLTE) */
   png_uint_16 num_palette; /* number of color entries in "palette" (PLTE) */
   png_uint_16 num_trans;   /* number of transparent palette color (tRNS) */
   png_byte bit_depth;      /* 1, 2, 4, 8, or 16 bits/channel (from IHDR) */
   png_byte color_type;     /* see PNG_COLOR_TYPE_ below (from IHDR) */
   /* The following three should have been named *_method not *_type */
   png_byte compression_type; /* must be PNG_COMPRESSION_TYPE_BASE (IHDR) */
   png_byte filter_type;    /* must be PNG_FILTER_TYPE_BASE (from IHDR) */
   png_byte interlace_type; /* One of PNG_INTERLACE_NONE, PNG_INTERLACE_ADAM7 */

   /* The following is informational only on read, and not used on writes. */
   png_byte channels;       /* number of data channels per pixel (1, 2, 3, 4) */
   png_byte pixel_depth;    /* number of bits per pixel */
   png_byte spare_byte;     /* to align the data, and for future use */
   png_byte signature[8];   /* magic bytes read by libpng from start of file */

   /* The rest of the data is optional.  If you are reading, check the
    * valid field to see if the information in these are valid.  If you
    * are writing, set the valid field to those chunks you want written,
    * and initialize the appropriate fields below.
    */

#if defined(PNG_gAMA_SUPPORTED) && defined(PNG_FLOATING_POINT_SUPPORTED)
   /* The gAMA chunk describes the gamma characteristics of the system
    * on which the image was created, normally in the range [1.0, 2.5].
    * Data is valid if (valid & PNG_INFO_gAMA) is non-zero.
    */
   float gamma; /* gamma value of image, if (valid & PNG_INFO_gAMA) */
#endif

#if defined(PNG_sRGB_SUPPORTED)
    /* GR-P, 0.96a */
    /* Data valid if (valid & PNG_INFO_sRGB) non-zero. */
   png_byte srgb_intent; /* sRGB rendering intent [0, 1, 2, or 3] */
#endif

#if defined(PNG_TEXT_SUPPORTED)
   /* The tEXt, and zTXt chunks contain human-readable textual data in
    * uncompressed, compressed, and optionally compressed forms, respectively.
    * The data in "text" is an array of pointers to uncompressed,
    * null-terminated C strings. Each chunk has a keyword that describes the
    * textual data contained in that chunk.  Keywords are not required to be
    * unique, and the text string may be empty.  Any number of text chunks may
    * be in an image.
    */
   int num_text; /* number of comments read/to write */
   int max_text; /* current size of text array */
   png_textp text; /* array of comments read/to write */
#endif /* PNG_TEXT_SUPPORTED */

#if defined(PNG_tIME_SUPPORTED)
   /* The tIME chunk holds the last time the displayed image data was
    * modified.  See the png_time struct for the contents of this struct.
    */
   png_time mod_time;
#endif

#if defined(PNG_sBIT_SUPPORTED)
   /* The sBIT chunk specifies the number of significant high-order bits
    * in the pixel data.  Values are in the range [1, bit_depth], and are
    * only specified for the channels in the pixel data.  The contents of
    * the low-order bits is not specified.  Data is valid if
    * (valid & PNG_INFO_sBIT) is non-zero.
    */
   png_color_8 sig_bit; /* significant bits in color channels */
#endif

#if defined(PNG_tRNS_SUPPORTED) || defined(PNG_READ_EXPAND_SUPPORTED) || \
defined(PNG_READ_BACKGROUND_SUPPORTED)
   /* The tRNS chunk supplies transparency data for paletted images and
    * other image types that don't need a full alpha channel.  There are
    * "num_trans" transparency values for a paletted image, stored in the
    * same order as the palette colors, starting from index 0.  Values
    * for the data are in the range [0, 255], ranging from fully transparent
    * to fully opaque, respectively.  For non-paletted images, there is a
    * single color specified that should be treated as fully transparent.
    * Data is valid if (valid & PNG_INFO_tRNS) is non-zero.
    */
   png_bytep trans; /* transparent values for paletted image */
   png_color_16 trans_values; /* transparent color for non-palette image */
#endif

#if defined(PNG_bKGD_SUPPORTED) || defined(PNG_READ_BACKGROUND_SUPPORTED)
   /* The bKGD chunk gives the suggested image background color if the
    * display program does not have its own background color and the image
    * is needs to composited onto a background before display.  The colors
    * in "background" are normally in the same color space/depth as the
    * pixel data.  Data is valid if (valid & PNG_INFO_bKGD) is non-zero.
    */
   png_color_16 background;
#endif

#if defined(PNG_oFFs_SUPPORTED)
   /* The oFFs chunk gives the offset in "offset_unit_type" units rightwards
    * and downwards from the top-left corner of the display, page, or other
    * application-specific co-ordinate space.  See the PNG_OFFSET_ defines
    * below for the unit types.  Valid if (valid & PNG_INFO_oFFs) non-zero.
    */
   png_int_32 x_offset; /* x offset on page */
   png_int_32 y_offset; /* y offset on page */
   png_byte offset_unit_type; /* offset units type */
#endif

#if defined(PNG_pHYs_SUPPORTED)
   /* The pHYs chunk gives the physical pixel density of the image for
    * display or printing in "phys_unit_type" units (see PNG_RESOLUTION_
    * defines below).  Data is valid if (valid & PNG_INFO_pHYs) is non-zero.
    */
   png_uint_32 x_pixels_per_unit; /* horizontal pixel density */
   png_uint_32 y_pixels_per_unit; /* vertical pixel density */
   png_byte phys_unit_type; /* resolution type (see PNG_RESOLUTION_ below) */
#endif

#if defined(PNG_hIST_SUPPORTED)
   /* The hIST chunk contains the relative frequency or importance of the
    * various palette entries, so that a viewer can intelligently select a
    * reduced-color palette, if required.  Data is an array of "num_palette"
    * values in the range [0,65535]. Data valid if (valid & PNG_INFO_hIST)
    * is non-zero.
    */
   png_uint_16p hist;
#endif

#ifdef PNG_cHRM_SUPPORTED
   /* The cHRM chunk describes the CIE color characteristics of the monitor
    * on which the PNG was created.  This data allows the viewer to do gamut
    * mapping of the input image to ensure that the viewer sees the same
    * colors in the image as the creator.  Values are in the range
    * [0.0, 0.8].  Data valid if (valid & PNG_INFO_cHRM) non-zero.
    */
#ifdef PNG_FLOATING_POINT_SUPPORTED
   float x_white;
   float y_white;
   float x_red;
   float y_red;
   float x_green;
   float y_green;
   float x_blue;
   float y_blue;
#endif
#endif

#if defined(PNG_pCAL_SUPPORTED)
   /* The pCAL chunk describes a transformation between the stored pixel
    * values and original physical data values used to create the image.
    * The integer range [0, 2^bit_depth - 1] maps to the floating-point
    * range given by [pcal_X0, pcal_X1], and are further transformed by a
    * (possibly non-linear) transformation function given by "pcal_type"
    * and "pcal_params" into "pcal_units".  Please see the PNG_EQUATION_
    * defines below, and the PNG-Group's PNG extensions document for a
    * complete description of the transformations and how they should be
    * implemented, and for a description of the ASCII parameter strings.
    * Data values are valid if (valid & PNG_INFO_pCAL) non-zero.
    */
   png_charp pcal_purpose;  /* pCAL chunk description string */
   png_int_32 pcal_X0;      /* minimum value */
   png_int_32 pcal_X1;      /* maximum value */
   png_charp pcal_units;    /* Latin-1 string giving physical units */
   png_charpp pcal_params;  /* ASCII strings containing parameter values */
   png_byte pcal_type;      /* equation type (see PNG_EQUATION_ below) */
   png_byte pcal_nparams;   /* number of parameters given in pcal_params */
#endif

/* New members added in libpng-1.0.6 */
#ifdef PNG_FREE_ME_SUPPORTED
   png_uint_32 free_me;     /* flags items libpng is responsible for freeing */
#endif

#if defined(PNG_UNKNOWN_CHUNKS_SUPPORTED)
   /* storage for unknown chunks that the library doesn't recognize. */
   png_unknown_chunkp unknown_chunks;
   png_size_t unknown_chunks_num;
#endif

#if defined(PNG_iCCP_SUPPORTED)
   /* iCCP chunk data. */
   png_charp iccp_name;     /* profile name */
   png_charp iccp_profile;  /* International Color Consortium profile data */
                            /* Note to maintainer: should be png_bytep */
   png_uint_32 iccp_proflen;  /* ICC profile data length */
   png_byte iccp_compression; /* Always zero */
#endif

#if defined(PNG_sPLT_SUPPORTED)
   /* data on sPLT chunks (there may be more than one). */
   png_sPLT_tp splt_palettes;
   png_uint_32 splt_palettes_num;
#endif

#if defined(PNG_sCAL_SUPPORTED)
   /* The sCAL chunk describes the actual physical dimensions of the
    * subject matter of the graphic.  The chunk contains a unit specification
    * a byte value, and two ASCII strings representing floating-point
    * values.  The values are width and height corresponsing to one pixel
    * in the image.  This external representation is converted to double
    * here.  Data values are valid if (valid & PNG_INFO_sCAL) is non-zero.
    */
   png_byte scal_unit;         /* unit of physical scale */
#ifdef PNG_FLOATING_POINT_SUPPORTED
   double scal_pixel_width;    /* width of one pixel */
   double scal_pixel_height;   /* height of one pixel */
#endif
#ifdef PNG_FIXED_POINT_SUPPORTED
   png_charp scal_s_width;     /* string containing height */
   png_charp scal_s_height;    /* string containing width */
#endif
#endif

#if defined(PNG_INFO_IMAGE_SUPPORTED)
   /* Memory has been allocated if (valid & PNG_ALLOCATED_INFO_ROWS) non-zero */
   /* Data valid if (valid & PNG_INFO_IDAT) non-zero */
   png_bytepp row_pointers;        /* the image bits */
#endif

#if defined(PNG_FIXED_POINT_SUPPORTED) && defined(PNG_gAMA_SUPPORTED)
   png_fixed_point int_gamma; /* gamma of image, if (valid & PNG_INFO_gAMA) */
#endif

#if defined(PNG_cHRM_SUPPORTED) && defined(PNG_FIXED_POINT_SUPPORTED)
   png_fixed_point int_x_white;
   png_fixed_point int_y_white;
   png_fixed_point int_x_red;
   png_fixed_point int_y_red;
   png_fixed_point int_x_green;
   png_fixed_point int_y_green;
   png_fixed_point int_x_blue;
   png_fixed_point int_y_blue;
#endif

} png_info;

typedef png_info FAR * png_infop;
typedef png_info FAR * FAR * png_infopp;

/* Maximum positive integer used in PNG is (2^31)-1 */
#define PNG_UINT_31_MAX ((png_uint_32)0x7fffffffL)
#define PNG_UINT_32_MAX ((png_uint_32)(-1))
#define PNG_SIZE_MAX ((png_size_t)(-1))
/* PNG_MAX_UINT is deprecated; use PNG_UINT_31_MAX instead. */
#define PNG_MAX_UINT PNG_UINT_31_MAX

/* These describe the color_type field in png_info. */
/* color type masks */
#define PNG_COLOR_MASK_PALETTE    1
#define PNG_COLOR_MASK_COLOR      2
#define PNG_COLOR_MASK_ALPHA      4

/* color types.  Note that not all combinations are legal */
#define PNG_COLOR_TYPE_GRAY 0
#define PNG_COLOR_TYPE_PALETTE  (PNG_COLOR_MASK_COLOR | PNG_COLOR_MASK_PALETTE)
#define PNG_COLOR_TYPE_RGB        (PNG_COLOR_MASK_COLOR)
#define PNG_COLOR_TYPE_RGB_ALPHA  (PNG_COLOR_MASK_COLOR | PNG_COLOR_MASK_ALPHA)
#define PNG_COLOR_TYPE_GRAY_ALPHA (PNG_COLOR_MASK_ALPHA)
/* aliases */
#define PNG_COLOR_TYPE_RGBA  PNG_COLOR_TYPE_RGB_ALPHA
#define PNG_COLOR_TYPE_GA  PNG_COLOR_TYPE_GRAY_ALPHA

/* This is for compression type. PNG 1.0-1.2 only define the single type. */
#define PNG_COMPRESSION_TYPE_BASE 0 /* Deflate method 8, 32K window */
#define PNG_COMPRESSION_TYPE_DEFAULT PNG_COMPRESSION_TYPE_BASE

/* This is for filter type. PNG 1.0-1.2 only define the single type. */
#define PNG_FILTER_TYPE_BASE      0 /* Single row per-byte filtering */
#define PNG_INTRAPIXEL_DIFFERENCING 64 /* Used only in MNG datastreams */
#define PNG_FILTER_TYPE_DEFAULT   PNG_FILTER_TYPE_BASE

/* These are for the interlacing type.  These values should NOT be changed. */
#define PNG_INTERLACE_NONE        0 /* Non-interlaced image */
#define PNG_INTERLACE_ADAM7       1 /* Adam7 interlacing */
#define PNG_INTERLACE_LAST        2 /* Not a valid value */

/* These are for the oFFs chunk.  These values should NOT be changed. */
#define PNG_OFFSET_PIXEL          0 /* Offset in pixels */
#define PNG_OFFSET_MICROMETER     1 /* Offset in micrometers (1/10^6 meter) */
#define PNG_OFFSET_LAST           2 /* Not a valid value */

/* These are for the pCAL chunk.  These values should NOT be changed. */
#define PNG_EQUATION_LINEAR       0 /* Linear transformation */
#define PNG_EQUATION_BASE_E       1 /* Exponential base e transform */
#define PNG_EQUATION_ARBITRARY    2 /* Arbitrary base exponential transform */
#define PNG_EQUATION_HYPERBOLIC   3 /* Hyperbolic sine transformation */
#define PNG_EQUATION_LAST         4 /* Not a valid value */

/* These are for the sCAL chunk.  These values should NOT be changed. */
#define PNG_SCALE_UNKNOWN         0 /* unknown unit (image scale) */
#define PNG_SCALE_METER           1 /* meters per pixel */
#define PNG_SCALE_RADIAN          2 /* radians per pixel */
#define PNG_SCALE_LAST            3 /* Not a valid value */

/* These are for the pHYs chunk.  These values should NOT be changed. */
#define PNG_RESOLUTION_UNKNOWN    0 /* pixels/unknown unit (aspect ratio) */
#define PNG_RESOLUTION_METER      1 /* pixels/meter */
#define PNG_RESOLUTION_LAST       2 /* Not a valid value */

/* These are for the sRGB chunk.  These values should NOT be changed. */
#define PNG_sRGB_INTENT_PERCEPTUAL 0
#define PNG_sRGB_INTENT_RELATIVE   1
#define PNG_sRGB_INTENT_SATURATION 2
#define PNG_sRGB_INTENT_ABSOLUTE   3
#define PNG_sRGB_INTENT_LAST       4 /* Not a valid value */

/* This is for text chunks */
#define PNG_KEYWORD_MAX_LENGTH     79

/* Maximum number of entries in PLTE/sPLT/tRNS arrays */
#define PNG_MAX_PALETTE_LENGTH    256

/* These determine if an ancillary chunk's data has been successfully read
 * from the PNG header, or if the application has filled in the corresponding
 * data in the info_struct to be written into the output file.  The values
 * of the PNG_INFO_<chunk> defines should NOT be changed.
 */
#define PNG_INFO_gAMA 0x0001
#define PNG_INFO_sBIT 0x0002
#define PNG_INFO_cHRM 0x0004
#define PNG_INFO_PLTE 0x0008
#define PNG_INFO_tRNS 0x0010
#define PNG_INFO_bKGD 0x0020
#define PNG_INFO_hIST 0x0040
#define PNG_INFO_pHYs 0x0080
#define PNG_INFO_oFFs 0x0100
#define PNG_INFO_tIME 0x0200
#define PNG_INFO_pCAL 0x0400
#define PNG_INFO_sRGB 0x0800   /* GR-P, 0.96a */
#define PNG_INFO_iCCP 0x1000   /* ESR, 1.0.6 */
#define PNG_INFO_sPLT 0x2000   /* ESR, 1.0.6 */
#define PNG_INFO_sCAL 0x4000   /* ESR, 1.0.6 */
#define PNG_INFO_IDAT 0x8000L  /* ESR, 1.0.6 */

/* This is used for the transformation routines, as some of them
 * change these values for the row.  It also should enable using
 * the routines for other purposes.
 */
typedef struct png_row_info_struct
{
   png_uint_32 width; /* width of row */
   png_uint_32 rowbytes; /* number of bytes in row */
   png_byte color_type; /* color type of row */
   png_byte bit_depth; /* bit depth of row */
   png_byte channels; /* number of channels (1, 2, 3, or 4) */
   png_byte pixel_depth; /* bits per pixel (depth * channels) */
} png_row_info;

typedef png_row_info FAR * png_row_infop;
typedef png_row_info FAR * FAR * png_row_infopp;

/* These are the function types for the I/O functions and for the functions
 * that allow the user to override the default I/O functions with his or her
 * own.  The png_error_ptr type should match that of user-supplied warning
 * and error functions, while the png_rw_ptr type should match that of the
 * user read/write data functions.
 */
typedef struct png_struct_def png_struct;
typedef png_struct FAR * png_structp;

typedef void (PNGAPI *png_error_ptr) PNGARG((png_structp, png_const_charp));
typedef void (PNGAPI *png_rw_ptr) PNGARG((png_structp, png_bytep, png_size_t));
typedef void (PNGAPI *png_flush_ptr) PNGARG((png_structp));
typedef void (PNGAPI *png_read_status_ptr) PNGARG((png_structp, png_uint_32,
   int));
typedef void (PNGAPI *png_write_status_ptr) PNGARG((png_structp, png_uint_32,
   int));

#ifdef PNG_PROGRESSIVE_READ_SUPPORTED
typedef void (PNGAPI *png_progressive_info_ptr) PNGARG((png_structp, png_infop));
typedef void (PNGAPI *png_progressive_end_ptr) PNGARG((png_structp, png_infop));
typedef void (PNGAPI *png_progressive_row_ptr) PNGARG((png_structp, png_bytep,
   png_uint_32, int));
#endif

#if defined(PNG_READ_USER_TRANSFORM_SUPPORTED) || \
    defined(PNG_WRITE_USER_TRANSFORM_SUPPORTED) || \
    defined(PNG_LEGACY_SUPPORTED)
typedef void (PNGAPI *png_user_transform_ptr) PNGARG((png_structp,
    png_row_infop, png_bytep));
#endif

#if defined(PNG_USER_CHUNKS_SUPPORTED)
typedef int (PNGAPI *png_user_chunk_ptr) PNGARG((png_structp, png_unknown_chunkp));
#endif
#if defined(PNG_UNKNOWN_CHUNKS_SUPPORTED)
typedef void (PNGAPI *png_unknown_chunk_ptr) PNGARG((png_structp));
#endif

/* Transform masks for the high-level interface */
#define PNG_TRANSFORM_IDENTITY       0x0000    /* read and write */
#define PNG_TRANSFORM_STRIP_16       0x0001    /* read only */
#define PNG_TRANSFORM_STRIP_ALPHA    0x0002    /* read only */
#define PNG_TRANSFORM_PACKING        0x0004    /* read and write */
#define PNG_TRANSFORM_PACKSWAP       0x0008    /* read and write */
#define PNG_TRANSFORM_EXPAND         0x0010    /* read only */
#define PNG_TRANSFORM_INVERT_MONO    0x0020    /* read and write */
#define PNG_TRANSFORM_SHIFT          0x0040    /* read and write */
#define PNG_TRANSFORM_BGR            0x0080    /* read and write */
#define PNG_TRANSFORM_SWAP_ALPHA     0x0100    /* read and write */
#define PNG_TRANSFORM_SWAP_ENDIAN    0x0200    /* read and write */
#define PNG_TRANSFORM_INVERT_ALPHA   0x0400    /* read and write */
#define PNG_TRANSFORM_STRIP_FILLER   0x0800    /* WRITE only */

/* Flags for MNG supported features */
#define PNG_FLAG_MNG_EMPTY_PLTE     0x01
#define PNG_FLAG_MNG_FILTER_64      0x04
#define PNG_ALL_MNG_FEATURES        0x05

typedef png_voidp (*png_malloc_ptr) PNGARG((png_structp, png_size_t));
typedef void (*png_free_ptr) PNGARG((png_structp, png_voidp));

/* The structure that holds the information to read and write PNG files.
 * The only people who need to care about what is inside of this are the
 * people who will be modifying the library for their own special needs.
 * It should NOT be accessed directly by an application, except to store
 * the jmp_buf.
 */

struct png_struct_def
{
#ifdef PNG_SETJMP_SUPPORTED
   jmp_buf jmpbuf;            /* used in png_error */
#endif
   png_error_ptr error_fn;    /* function for printing errors and aborting */
   png_error_ptr warning_fn;  /* function for printing warnings */
   png_voidp error_ptr;       /* user supplied struct for error functions */
   png_rw_ptr write_data_fn;  /* function for writing output data */
   png_rw_ptr read_data_fn;   /* function for reading input data */
   png_voidp io_ptr;          /* ptr to application struct for I/O functions */

#if defined(PNG_READ_USER_TRANSFORM_SUPPORTED)
   png_user_transform_ptr read_user_transform_fn; /* user read transform */
#endif

#if defined(PNG_WRITE_USER_TRANSFORM_SUPPORTED)
   png_user_transform_ptr write_user_transform_fn; /* user write transform */
#endif

/* These were added in libpng-1.0.2 */
#if defined(PNG_USER_TRANSFORM_PTR_SUPPORTED)
#if defined(PNG_READ_USER_TRANSFORM_SUPPORTED) || \
    defined(PNG_WRITE_USER_TRANSFORM_SUPPORTED)
   png_voidp user_transform_ptr; /* user supplied struct for user transform */
   png_byte user_transform_depth;    /* bit depth of user transformed pixels */
   png_byte user_transform_channels; /* channels in user transformed pixels */
#endif
#endif

   png_uint_32 mode;          /* tells us where we are in the PNG file */
   png_uint_32 flags;         /* flags indicating various things to libpng */
   png_uint_32 transformations; /* which transformations to perform */

   z_stream zstream;          /* pointer to decompression structure (below) */
   png_bytep zbuf;            /* buffer for zlib */
   png_size_t zbuf_size;      /* size of zbuf */
   int zlib_level;            /* holds zlib compression level */
   int zlib_method;           /* holds zlib compression method */
   int zlib_window_bits;      /* holds zlib compression window bits */
   int zlib_mem_level;        /* holds zlib compression memory level */
   int zlib_strategy;         /* holds zlib compression strategy */

   png_uint_32 width;         /* width of image in pixels */
   png_uint_32 height;        /* height of image in pixels */
   png_uint_32 num_rows;      /* number of rows in current pass */
   png_uint_32 usr_width;     /* width of row at start of write */
   png_uint_32 rowbytes;      /* size of row in bytes */
   png_uint_32 irowbytes;     /* size of current interlaced row in bytes */
   png_uint_32 iwidth;        /* width of current interlaced row in pixels */
   png_uint_32 row_number;    /* current row in interlace pass */
   png_bytep prev_row;        /* buffer to save previous (unfiltered) row */
   png_bytep row_buf;         /* buffer to save current (unfiltered) row */
   png_bytep sub_row;         /* buffer to save "sub" row when filtering */
   png_bytep up_row;          /* buffer to save "up" row when filtering */
   png_bytep avg_row;         /* buffer to save "avg" row when filtering */
   png_bytep paeth_row;       /* buffer to save "Paeth" row when filtering */
   png_row_info row_info;     /* used for transformation routines */

   png_uint_32 idat_size;     /* current IDAT size for read */
   png_uint_32 crc;           /* current chunk CRC value */
   png_colorp palette;        /* palette from the input file */
   png_uint_16 num_palette;   /* number of color entries in palette */
   png_uint_16 num_trans;     /* number of transparency values */
   png_byte chunk_name[5];    /* null-terminated name of current chunk */
   png_byte compression;      /* file compression type (always 0) */
   png_byte filter;           /* file filter type (always 0) */
   png_byte interlaced;       /* PNG_INTERLACE_NONE, PNG_INTERLACE_ADAM7 */
   png_byte pass;             /* current interlace pass (0 - 6) */
   png_byte do_filter;        /* row filter flags (see PNG_FILTER_ below ) */
   png_byte color_type;       /* color type of file */
   png_byte bit_depth;        /* bit depth of file */
   png_byte usr_bit_depth;    /* bit depth of users row */
   png_byte pixel_depth;      /* number of bits per pixel */
   png_byte channels;         /* number of channels in file */
   png_byte usr_channels;     /* channels at start of write */
   png_byte sig_bytes;        /* magic bytes read/written from start of file */

#if defined(PNG_READ_FILLER_SUPPORTED) || defined(PNG_WRITE_FILLER_SUPPORTED)
#ifdef PNG_LEGACY_SUPPORTED
   png_byte filler;           /* filler byte for pixel expansion */
#else
   png_uint_16 filler;           /* filler bytes for pixel expansion */
#endif
#endif

#if defined(PNG_bKGD_SUPPORTED)
   png_byte background_gamma_type;
#  ifdef PNG_FLOATING_POINT_SUPPORTED
   float background_gamma;
#  endif
   png_color_16 background;   /* background color in screen gamma space */
#if defined(PNG_READ_GAMMA_SUPPORTED)
   png_color_16 background_1; /* background normalized to gamma 1.0 */
#endif
#endif /* PNG_bKGD_SUPPORTED */

#if defined(PNG_WRITE_FLUSH_SUPPORTED)
   png_flush_ptr output_flush_fn;/* Function for flushing output */
   png_uint_32 flush_dist;    /* how many rows apart to flush, 0 - no flush */
   png_uint_32 flush_rows;    /* number of rows written since last flush */
#endif

#if defined(PNG_READ_GAMMA_SUPPORTED) || defined(PNG_READ_BACKGROUND_SUPPORTED)
   int gamma_shift;      /* number of "insignificant" bits 16-bit gamma */
#ifdef PNG_FLOATING_POINT_SUPPORTED
   float gamma;          /* file gamma value */
   float screen_gamma;   /* screen gamma value (display_exponent) */
#endif
#endif

#if defined(PNG_READ_GAMMA_SUPPORTED) || defined(PNG_READ_BACKGROUND_SUPPORTED)
   png_bytep gamma_table;     /* gamma table for 8-bit depth files */
   png_bytep gamma_from_1;    /* converts from 1.0 to screen */
   png_bytep gamma_to_1;      /* converts from file to 1.0 */
   png_uint_16pp gamma_16_table; /* gamma table for 16-bit depth files */
   png_uint_16pp gamma_16_from_1; /* converts from 1.0 to screen */
   png_uint_16pp gamma_16_to_1; /* converts from file to 1.0 */
#endif

#if defined(PNG_READ_GAMMA_SUPPORTED) || defined(PNG_sBIT_SUPPORTED)
   png_color_8 sig_bit;       /* significant bits in each available channel */
#endif

#if defined(PNG_READ_SHIFT_SUPPORTED) || defined(PNG_WRITE_SHIFT_SUPPORTED)
   png_color_8 shift;         /* shift for significant bit tranformation */
#endif

#if defined(PNG_tRNS_SUPPORTED) || defined(PNG_READ_BACKGROUND_SUPPORTED) \
 || defined(PNG_READ_EXPAND_SUPPORTED) || defined(PNG_READ_BACKGROUND_SUPPORTED)
   png_bytep trans;           /* transparency values for paletted files */
   png_color_16 trans_values; /* transparency values for non-paletted files */
#endif

   png_read_status_ptr read_row_fn;   /* called after each row is decoded */
   png_write_status_ptr write_row_fn; /* called after each row is encoded */
#ifdef PNG_PROGRESSIVE_READ_SUPPORTED
   png_progressive_info_ptr info_fn; /* called after header data fully read */
   png_progressive_row_ptr row_fn;   /* called after each prog. row is decoded */
   png_progressive_end_ptr end_fn;   /* called after image is complete */
   png_bytep save_buffer_ptr;        /* current location in save_buffer */
   png_bytep save_buffer;            /* buffer for previously read data */
   png_bytep current_buffer_ptr;     /* current location in current_buffer */
   png_bytep current_buffer;         /* buffer for recently used data */
   png_uint_32 push_length;          /* size of current input chunk */
   png_uint_32 skip_length;          /* bytes to skip in input data */
   png_size_t save_buffer_size;      /* amount of data now in save_buffer */
   png_size_t save_buffer_max;       /* total size of save_buffer */
   png_size_t buffer_size;           /* total amount of available input data */
   png_size_t current_buffer_size;   /* amount of data now in current_buffer */
   int process_mode;                 /* what push library is currently doing */
   int cur_palette;                  /* current push library palette index */

#  if defined(PNG_TEXT_SUPPORTED)
     png_size_t current_text_size;   /* current size of text input data */
     png_size_t current_text_left;   /* how much text left to read in input */
     png_charp current_text;         /* current text chunk buffer */
     png_charp current_text_ptr;     /* current location in current_text */
#  endif /* PNG_PROGRESSIVE_READ_SUPPORTED && PNG_TEXT_SUPPORTED */

#endif /* PNG_PROGRESSIVE_READ_SUPPORTED */

#if defined(__TURBOC__) && !defined(_Windows) && !defined(__FLAT__)
/* for the Borland special 64K segment handler */
   png_bytepp offset_table_ptr;
   png_bytep offset_table;
   png_uint_16 offset_table_number;
   png_uint_16 offset_table_count;
   png_uint_16 offset_table_count_free;
#endif

#if defined(PNG_READ_DITHER_SUPPORTED)
   png_bytep palette_lookup;         /* lookup table for dithering */
   png_bytep dither_index;           /* index translation for palette files */
#endif

#if defined(PNG_READ_DITHER_SUPPORTED) || defined(PNG_hIST_SUPPORTED)
   png_uint_16p hist;                /* histogram */
#endif

#if defined(PNG_WRITE_WEIGHTED_FILTER_SUPPORTED)
   png_byte heuristic_method;        /* heuristic for row filter selection */
   png_byte num_prev_filters;        /* number of weights for previous rows e
 * is no portable6Tights foine Per;
   png_uint_16 ite;
  2
nt_32 iccp_proptSor dithering */
   pnd on bliable_count;
   png_uin   png_uint_16 ite;
  2
nt_32 iunt;
   2
nded */
   png_progressive_end_ptr end_fn;   /* called after image is complete */
   png_be* for the Borle20rmation in a PNG file so
 * tta e pHYs chunkEXT_SUGverts_age is /
  ef vop2
ndORTED)
#ifdef PNG_LEGACY_SUPPORTEDering */
   0x4000   /* ESR, 1.0.6_text;         /* current text chunk buffer */
     png_chassDeng_pr29 com   png_uinsuros completet));tte files */
#endif

#if defined(PNG_READ_D?ESSIVE_READ_SUPP
   png_uinm;SUPnNTE   0 /f defiSSION_zT_32 s row0#_SSIVE_READ_SUmation r /f defi row0#_SSIVE_READ_oEAD_SRevel;i png_voidp (*xt chunk buffer */
     png_ch defiytepp offset_table_er to s#deNG_READhift f ADhift f ADhift fs4_Ism/* mE_USERkholds zlib count;
   png_uin   pn PNG_LEsystem
 p (*xt chunk buffs for iema char to s#d/* ss foSInels) .NG_LEEntep, pn_ch defi. */
#define PNG_RESOLUTION_sive_end_pnes */w filte;
   f deft;
   E_NONE    es */w fghts fttypeTION_sive_end_pnes *ypeTf 2
nt_3DuFG_COLOR_ chunks png_uin  m s */wext chunk bu widtthe palette colors    /* current row iN f deft;
   E_NONE    eMS    /* read and write */
#d_SUPy.  For non-paletted images, thpROGRESrw_Fd files */
   png_color_16re in the PNG filel;
 ext chtines */SCn     2Om?tr) PNGAR*/
   png
#endif

#if defined(PNG_READ_SHIS gives the offset in "offse8hIST_SUPPORTED)
   Idefiyes, e_count;
   png_uingroundsXytep gamma_to  I
{
#_it;
   kf defined(PNG_READ_D?ESSIVE_READ_SUPP
   p)T_PERCEPTUAL 0
(endif

#if defiFo  ptr) PNGAR*/
   png
* must boptionally near!5ptr)_exponeo cptp, pnRTED)
typedef intaletmGAR*y near!5ptr)_ex/* transparency values fointaletmGAR*y near!5ptr)_ex/* transpa
   pnenear!5ptrnenear!5ptrnenear!5ptrnenear!5ptrnenear!5po cptp, pnRTED)
typedeoR_SUPPORTar!5ptr)_ex/* t_2ransparency valnenear!5ptrnenet string may be empty.  Any number of text cnenearPyG_COLOR_T
 * cRTED)fset eCY_SUPPORTED
   -mpty.  Any nach pr*/

/* These*_16p hist;                /*  png_1pny nach prrent push library palette index aD?ESSIVE_RThese*_16pay be empT
 * cuORTED
   -mptng_1paries that don't have all of theven bAe_end_ ASCII strings rCII strings rCII \r!5pt  png_bytWAP     od;      strings rCII \r!5pt  e index aD?ESSIVE_RThese*_16pet  e index ORTED)
   M

#if defined(PNG_e_end_ bo           /* index translation for palette files */
#endif

#if d2d(PmNnslation atin-1 _SUPPORTEDTd(PmD_SUPPORTEDin-1 _SUPPi defined(P>  -med(PNG_gAMA_SUPPORTED) && defined(PNG_FLOATING_POINT_SUPPOR index translation NT_SUPPOR index translation NT_SUxt" is an array x translation NT_SUxt" is an array x translation NT_Sve_en by an  0 o ndex O png_user_traach pr*/

/* These*_1PPOR in_RThesPHA)
/s in PeGi)uve_ennslation NT_SUxt" is an array x translation NT_Sve_en by an  0 o ndex O png2fU?ESSIVE_READ_SUng_user_t8_SUxt"fUxt" is an array x trEAD_SUn-LAD_SUng_user_t8ffset in "orcSUng_uf

#if d2d(P an array x  widined(PNG__t8ffset pon NT_SUxt" is an arraU   * 
/* These*_1PPOR in_RThesPHA)
/s in PeGi)uve_ennslation NT_SUtines *2lefined(PNG_tRNS_SUPPORTED) || defined(Py non-pal|TIOPPOR in_RThesPHA)
/s ioRThesPHA)
/s io ned(Py non-palLOD_SUPPOeeTf 2
nt_pf-0al|TIOPPS
 * cd2d(P an VE_RThese*_16pay be empT
 * cuORTED
   -mptng_1par an O all o(vT_PE VE_RThese*_16pa!alues fointaletmGAR*y_ioRTnk-reaee;
#en_1par an O alcuORTE:* numtraach pf data */
       sySUtines ound_1; /* bacsRTnk-reaee;
#an O all o(vT_PE d2d(iined(Py non-pal|TIOPPw */
   int zli* 
/* _pCAL 0x0400
#define PNG_INFO_sRGB 0x0800  TERLl */
   png_uint2 mode800  TERLl */
(les */
   T_SUti   /* ioRTnk-reaee;
#e;     /* see PNG_COLOR:*/
  TIOPPw INFO_sempT
 bmust bbytWAP     od;      strings rCII \r!5pt  e index aD?ESSIVE_RThese*_Reg_uin-!5pt  ;         /aa   t_gamm  e i#if oes *2lefined(PNG_tRNS_SUPPORTED) ||oeu/* Deflurist atable6Tights foine t eCY_SUPPORTED
   -mpty. \Os areoine t e.  These values shon O all o(matiberoine t e PNGt describeroie PNGt describeroiLdefie_ennslatio_16 offset_table_cougiberoine t e PNGt describeroie PNGt descr e.  Te pHYs chunkE(tble_cong_lfrom the input file */
   png_uint_16 num_palette;   /* ns you want wr?NOWN_Calnenear!5ptrnenet string may beused 5aD?ESSIV8in PeGi)uve_ennslatenable using
 * par an 2file */
   p8if d2d(PmNnslation atin-iuhese*_1rtion atin-iuhese*smi* 
/* _pCAL 0x0Lse6Ti_andler */
   p to 1.0 */
   png_uint_16pp gamma_16_table; /* gamma tableRaown.  TheTrray */
   png_textp PPtEsst bif d2d(PmN       /aa   t_gamm7LAST       4 /* iuation ma_16_tabl t_2ranspars_sempT
 bmust bbytWAP 1hAD_   aU
 * ROR index tutable;aU
 * #e;     /* see Md  png_textp PPtEsGadefina valid if (va  /* see Mthe inpuSUPP* 
/* ThshdG)U the inaorder bits
 S 1. png_user_transform_ptr read_user_transform_fn; /* uses1M;n; /* useoffset have been named *_method not *_type */TsfEAD_Qi
   pnshdG)U the inaorPORTreaee;
#an png_uiinaorPORTreaee;
#an s?ESSIV8in e inaoG)U the intion for writ

/* ThessPORTreaee_daorPORTrea:amem_leuffer to save "a(png_structp, pnD_QbS_mevreviousO write */
#definetr;     /* current loctnt loctnt aIP_ALPHA 5ickgrcribero
#defin (Ccount6 the png
   pnglor tdex aDs thlsd2
nt_32TvioknoytWAP     od;      strings rCII \r!5pt near!5ptrnenet string may beused 5aD?ESSIV8in PeGi)uve_ennslatenable using
 * par atdex aDfe Mthe istrings rCII \rnORTED
hodT   strette;  Mthe inpuf (valid & PNG_INFO_sCAL) is non-zero.
    */
  o \r!5pt near!5ptrnenet string may beused 5aD?ESSIV8in PeGi)uvMthe inpuf (valid & OC__) &CII \fe Mthe istrings rCII \rnORTED
uf (valid & OC__) &CII \fe MthinaoriMrw_ptr read_dataits
 S 1. png_ue istrings rCII \rnORTSION_TYPE_DE,ioriMrw_ArraU  ]ow_ptr read_dataits
ined(PNG_WRIlue */
   png_int_32 pcal_X1;     m  eMthe inpuf/* ESR, 1.0.6 diead_da read_dataits
ined(PNG_WRIlue */
   png_int_32 pcal_X1;     m  eMthe inpuf/* ESR, 1.0.6 diead_da read_dataim;SU       T_X1;    pLOATING_POINT_SUPPORTED)
   /* The gAMA chunk describes  /* channessive_end_pCLanspars/inimum value */
   png_int_32 pcal_X1;adataim;SU       T_X1;    pLOATING_POIp pcal_h_SUx-linear) te tr read_useielse
   png_uint  2 /* Not a valid value */

/* These  rsla_16_tabl t_2ransvalue */
   pngfgg_uintf PN*/
   int zlib_windo_y_white;
   png_fi
/** see PNGB/* iuat)OATIe the Pd_pCLanspars/inimum value *Utines ound_1; /* bacsptr) PN /*iee *Utines ound_strindefine P_Ccount6 the png
   pnsed 5aD?ESSI*_Reg_uin-!5pt  ;         /aPPORTED)lable inPoen sus iuat)OATI_bytep trans;  dss_puf/* ES PNGt descr e.png
 e  /* GR-P, 0.96a */
#deTeTite index */

#  if defined(PNGg,e  /* GR-P, lnt6slle inhe jmp_b iuat)OATI_bytep trans;  dss_pTED)
   /* The PNGt descr e.png
 e  /* GR-P, 0.96affer to nGg,e  /* GR-P, lnt6slle inhe jmp_b ctp,bacsptr) PN /*iee *Utines ound_suC* ROR_(ined rows e:OR_(ined rows e:OR_(ined rows e:OR_(ined rows e:OR_(inesuC* CION_B/*ieettee. ROR_(, d2ded(PNGg,epe. oat y_blue;
#end. ROR2ded(PN1 to 1.0 sCAL) is non-zero.8ws e:OR_(inens;  dss_typedef struct png_row_info_str
hodT n5bnon-zero.nens;  dss_typedef struct png_row_g,epe. om the input file */
   png_uint_16 num_palette;   /* e changed.
 */
#dee PNGt descr /* e changed.
 */
#dee PNGt descr /* e changed.
 */
#dee PNGt descr /* e changedPNG filel;
 cr /* i   /* buf
   png.s e:OR do_f e:OR_(iNFO_b8l/*iee *Utines ound*smi* ED)
   Idefiyes, e_c#dee PNGGt descr (edef st_fn; /* ucIdefyZd how dPPORTED)
typedef void (PNGAPI *png_unknown_chunk_ptr) PNGARG((png_str ressERLACE_ADAM7       1 /* Adam7  e:OR_(cmi* b8l/*G)U the intion for writ

/* ThessPORTreaee_daorRopufsh Te ED)
typedef void (PNGAPI *png_unknown_chung
nclumN typeunk_ptr) PNGARG((png_str ressERLACE_ADAM7    ped/*iee *Utines ound_strindefine P_Ccou  m  eMthe inpuf/* ESR,   png_rw number of  png_int_32 pcal_X1;          0tines ound_ype should l_h_SUx-linear) te tr read_useielse

gs ref/* ESR,   png_rw number of (oTYPE_RANSFORM- DEPRElue;
)k_ptr) PNGARG((png_str ressERLAype spuf//*iee *Utines       d(PNG_UNKs_tyunLOR_TYPE_PALspuf/error_fn;TYPE_PALspuf/(d(PNG_UNKNTYPE_PALspuf/_3(&d(PNG_UN,\
ee;
#endif

ofines     nhe jmp_b ctp,bacsptr) ressERLAype spuf/_3/*iee *Utines        d(PNG_UN,
ee;
#endif

#ifERLAype sOR_(inei
/** set_fn; /* sRESSI  int zlg_rw_ptr wri_offsetLOCATED_INF_ptr) PNGARG((png_str ressERLACE_ADAype s_offseist;  /* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNKs_tr) PNGARG((png_str ressERLACE_ADAype  /* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNKs_ten snus iuat)NO_SEQU* reAL/
   png_uint_32e access  png_rw_ptr wri_offsetLOCAendif
#_t bufic.  The r) PNGARG((png_str ressERLA, 0.9ype  /* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNKs_t f deft;
   E_NONE    es */w fghts fttypeTION_sig_int_32 pcal_X1;     :OR_(,ned rowarenIV8irfcts fuintf PN*/
   int zlib_windo_y_white;
chunwinchunKs_t f deft;
   GHTED_FILTEIN32_WCEee;
#"chun.h" the png
   unit_tfdef PNG_SEwriER_SUPPCE_SUPPORTEDin-1 _SUPPot a ve of               /owarenead_usaiead_da tment pushchunkhe r) PNGARG((png_str ressERLArowarenIranspOR_(inet /*iee *Utines chunwinchunU theead_da tme PeGi)tchunKs_t    /owarenead_usypeTftent pushchune MU intgmchun()khe r) PNGARG((png_str ressERLArowarenIranspypeTft/*iee *Utines chunwinchunU theypeTftenchunKs_t f defings rCIot a ve of           atable6TiingsTEIN32_WCE/
       sySUtines ound_1; after image is c
ld NOTs) isyZd nt 24_SUPPRGB(PNGA  /* s pnRNTENT,void (alpha /* GE_READ_S.set have been named *_method not *_ rowsd/*iee *Utines ound_strindefine P_have been named *_method not *_ pnRTet s4IV8i8/*iee *Utines ound_strindefine P_have been named *_method not *_ndex aD?ESSrgb/*iee *Utines ound_strindefine P_have been named *_method not *_afterESSalpha)SUx-linear) te tr read_useielse
   png_uintpet  e index ORTED)G_WRITE_FLUSH_SUPPORTED)
   png_flu)G_WRITE_FLUSH
 */

/ b;    ear!5,_SUPPNGduffer */t_siz.set have been named *_method not *_bgr)SUx-linear) te tr read_useielse
   png_uintpet  e index ORTEDoptioTO* musimage is c
ld NOTs) i_width;RNTENT nt 24_SUPPRGB /* ne;   avalid & OC__) &CII \fe Mtmethod not *_ pnRTESSrgb/*iee *Utines ound_strindefine P_   png_uintpet  e index ORTED must boptionally near! iuatPPORPRGB expoh;RNTENT. /* converts from file to 1.0 */
#endif
 OC__) &CII \fe Mtmethod not *_o cptp, pnRfEAD_Qi
   pnshdG)U the inaorPORTreaeeed(PNGacmma_16endif

rbpngendif

ear!5 e P_   png_ OC__) &CII \fe Mtmethod not *_o cptp, pnRd_ bo fEAD_Qi
   pnshdG)U the inaorPORTreaeeed(PNGacmma_16_end_ bo        rbpng_end_ bo        ear!5 e P_g_int_32 pcal_X1;     ion       T_Xo cptp, pnRTED)
tyfEAD_Qi
   pnshdG)U tmax;     ine P_   png_u OC__) &CII \fe Mtmethod nobuild_oh;RNTENT_ndex aDfEAD_Qi
  i
   pnD
   f,low ) */
   png_byte cKs_ten scoded */
#ifdef PNG0    /* rettypeTION_sig_int_32 pcal_X1; method not *_ttripSalpha)SUx-linear) te tr read_useielse
   png_uintpet  e index ORTEDThe only pED
   -mpty.  Any nach pr*/

/* These*_The only pED
   -mptyig_int_32 pcal_X1; method not *_twapSalpha)SUx-linear) te tr read_useielse
   png_uintpet  e index ORTEDneeds.
 * ItED
   -mpty.  Any nach pr*/

/* These*_needs.
 * ItED
   -mptyig_int_32 pcal_X1; method not *_iwarenIalpha)SUx-linear) te tr read_useielse
   png_uintpet  e index ORTEDd(PNG_WRITE_FLUSH_SUPPORTED)
   png_flush_ptr output_flusponendsaidist;    /* exp  /* sGloat r 24_SUPPRGB /t buz.set have been named *_method not *_dist;  /* Adam7  e:OR_(cmi* b8l/*G)U the int */
#d_SUist; 5aD?ESer_t8lse
;
#an Opng_byt* This is ush_ptr transformation routines, as sochunk.  These valueptr BEFOREnged.
 */
#defilueptr AF the1sponendsan(alpha   /* exp  /* sGloat r 24_SUPPRGB /t buz.set  in PeGi)uve_ennslation have been named *_method not *_addIalpha)SUx-linear) te tr read_useieU the int */
#d_SUist; 5aD?ESer_t8lse
dif
#endif

#if definORTEDd(PNG_WRITE_FLUS_SUP   png_flush_ptr output_fl/
       sySUtines ound_1;The oRESSIVE_READ_SUPPORTED
   png_prohe oRESSIVE_REe_ennwaptype shoulND_SUPPORTED)
   p.set have been named *_method not *_twap)SUx-linear) te tr read_useielse
   png_uintpet  e index ORTED#defoRESSIVE_READ_SUPPORTED
   png_pr#defoRESSIVE_RE
 */

/ 1   /*  endif
   oulN voidNGAP_SUPPORTED)
   p.set have been named *_method not *_pa par )SUx-linear) te tr read_useielse
   png_uintpet  e index ORTED#defThe oRESSIVE_READ_SUPPORTED
   png_pr#defThe oRESSIVE_REe_ennwaptpa par PNGduffE_REt_sizerow_info.set have been named *_method not *_pa ptwap)SUx-linear) te tr read_useielse
   png_uintpet  e index ORTEDG_PROGRESSIVE_READ_SUPPORTED
   png_progressive_info_ptaorPsparency  Borl2 wiG_COMSUPPORTEDp.set have been named *_method not *_tdata)SUx-linear) te tr read_useieU the intfn; /* rentueh of lse
   png_uintpet  e index ORTEDneLLER_Sle tD
   -mpty.  Any nach pr*/

/* These*_neLLER_Sle tD
   -mptyble u /* Ie thedee inpuS     0 /* Linearrea:amem_le    e to maintaissfo.set have been named *_P     od; *_iwf PNG_L_h png_us)SUx-linear) te tr read_useielse
   png_uintpet  e index ORTEDneeds.
RESSIVE_READ_SUPPORTED
   png_prneeds.
RESSIVE_RE
gs rearenemonochunknhe Borle20g_int_32 pcal_X1; method not *_iwarenImono)SUx-linear) te tr read_useielse
   png_uintpet  e index ORTED)
   M

#if defined(PN/ 1. pnge(alpha s) i_nfo_bprocpsform *oid (aef PNG_FLOATING_P. /* converts from file to 1.0 */
#endif
 OC__) &CII \fe Mtmethod not *_f PNG_FLOA)SUx-linear) te tr read_useieU the intfn; /* pn_amma;   /* fn; /5aD?ESPORTED) || definehedePORTreaee;eo   rowsdngendif

PORTED) || definlse
dif
#end.
 */
#defi)
   M

#ifD?ESSIThese de0nd.
 */
#defi)
   M

#ifD?ESSISCREEN01
#define PNG_I)
   M

#ifD?ESSIsh_EMPRESSION_TYPE_BAS)
   M

#ifD?ESSIThIQUENFO_P  png_uintpet  e index ORTED16st b8f defined(PN/ 1ttrip/* e cecong_struuffer_rw_ptr wriad_usaiND_SUPPORTED)
   .set have been named *_method not *_ttripS16)SUx-linear) te tr read_useielse
   png_uintpet  e index ORTED /* bacsRTnk-reaee;
#aglorle *ogressivs
inedrtPPORP    strings O_IDAT it depth of fils GE_READ_S.set have been named *_method not *_*ogres)SUx-linear) te tr read_useieU the intfn; /ng_byte c5aD?ESSIV__byte c5aD?ESm PNG_Itfn; /s,dORTED)
#ifdef PNG_LE  0x45aD?ESeull_*ogres)se
   png_uintpet  e index ORTEDogamma value */
 / 1. pnge(NG_REAe PNGx aDfe S_SUPPORTED)=     /* significant bitonverts from file to 1.0 */
#endif
 OC__) &CII \fe Mtmethod not *_definlSUx-linear) te tr read_useieU theendif

#iSUPPORTED)ngendif

   /aPP_dise definlse
dif
#end  png_uintpet  e index ORTEDCY_SUPPORTED
   -mpty.  Any nach pr*/

/* These*_16p hist;                Pe_end g_prosng_uinemptyne PN (0:it_tfAe_end_ A, 1:fAe_end_ A)

/* ThDMASK_ALPH_fn;  */
   premovtin-i

/ d_usee_end_l of theven ()ine PNG_COLOR OC__) &CII \fe Mtmethod noee_end_empty_plaDfEAD_Qi
   pnshdG)U the inaorPORTreaeeempty_plaDbAe_end_ A)se
   png_uintpet  e index ined(PNG_READ_BACKGROUN_enneta_from_1; lsformbetwr!5 0x8000L _uinorm- 0tep curmma table et have been named *_method not *_da tafEAD_Qi
   pnshdG)U the inaorPaD?ESSefiSlse
;
#F_uintIe thE:* numt zl0x8000Lher_index;r) PNGARG((png_str ressERLACE_ADAda tafEAD_Qi
   pnshdG)U the inaorss_typedef struero.nens updat  strings oid (req_byLPH__uint_32 height;et have been named *_method notwn_cA, 0.9yt bu/*iee *Utines ound_strindefine P_Ccouero.nens cESSI o updat  t_32,
  sng_rw number of  png_int_32 pcal_X1;  ressERLA, 0.9updat Aype  /* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNKs_ten snus iuat)NO_SEQU* reAL/
   png_uint_32e accessbif SUPPfsetefiSSffer to sic.  The r) PNGARG((png_str ressERLA, 0.9efiSl/* Adam7  e:OR_(cmi* b8l/*G)U the intion fle */,e intion fle    /* s */,e intiltering */
   p)se
   png_uintnus iuat)NO_SEQU* reAL/
   png_uint_32e accessata */EAD_SUP The r) PNGARG((png_str ressERLA, 0.9efi /* Adam7  e:OR_(cmi* b8l/*G)U the intion fo */, 0x0400
#define   /* s */)se
   png_uintnus iuat)NO_SEQU* reAL/
   png_uint_32e accesst_32wholeer to sav o e */
  strunce The r) PNGARG((png_str ressERLA, 0.9yt bu/*iee *Utines ound_strindefinU the intion fleyt bu/s_typedef struwt png_ra */EADr to sic. dex;r) PNGARG((png_str ressERLACE_ADAefi /* Adam7  e:OR_(cmi* b8l/*G)U the intion fo */e P_Ccouwt png_rfewtefiSSffer to sic. dex;r) PNGARG((png_str ressERLACE_ADAefiSl/* Adam7  e:OR_(cmi* b8l/*G)U the intion fle */,e intiltering */
   p)se
Ccouwt pngLOCATED_Isic. dex;r) PNGARG((png_str ressERLACE_ADAyt bu/*iee *Utines ound_strindefinU the intion fleyt bu/s_tCcouwt pnle    e 
/*f   int zlib_sNF_ptr) PNGARG((png_str ressERLACE_ADAeOA)SUx-linear) te tr read_useieU the int      d(PNG_UNKs_ten snus iuat)NO_SEQU* reAL/
   png_uint_32e access  pne 
/*f   int zlib_sNF_ptr) PNGARG((png_str ressERLA, 0.9eOA)SUx-linear) te tr read_useieU the int      d(PNG_UNKs_typedef struens;d(PNGe */
  sssociaef void (_progresSR, 1.0.6 */_ptr) PNGARG((png_str ressERLAdbyLroy_ype should lSUx-linear) te tr read_useieU the int       d(PNG_UNefine P_Ccouens;d(PNGe */
  sssociaef void (_progres.0.6 */s) i_widgresSR, 1.0.6 *s/_ptr) PNGARG((png_str ressERLAdbyLroy_aits
 S 1. pSUx-linear) te tr retmax;     in_y_white;
       d(PNG_UNefinhite;
       saved(PNG_UNefine P_Ccouens;d(SSIe */
    if bprt I/Ocess(oTYPnt_32 i-routiDLL png_st;
)k_ptr) PNGAgs */ERLA, 0.9dbyLroyf PN*/
   int zlib_windo_y_white;
      d(PNG_UNU the int      saved(PNG_UNe P_Ccouens;d(PNGe */
  sssociaef void (_progres.0.6 */s) i_widgresSR, 1.0.6 *s/_ptr) PNGARG((png_str ressERLAdbyLroy_R, 1.0.6 diead_da read_dataime tr ret;     in_y_white;
       d(PNG_UNefine P_Ccouens;d(PNGe */
  USER_TRANSFO6 diead_da (oTYPnt_32 i-routiDLL png_st;
)k_ptr) PNGAgs */ERLA_WRITE_byLroyf PN*/
   int zlib_windo_y_we P_Ccou)OATIe t thpROGnt_32 i*f h png_us(see PNG_FIr writeet have been named *_method not *_crcGacmma_fEAD_Qi
   pnshdG)U the inaorPORTreaeecWRIGacmma_16eaeeP, 0.Gacmma_f P_CcouVng_bytep sa not *_crcGacmma_()iO alcypCAL 0x0 inpuS G_FIr writeinORTED
 0.96a ** e cdatacns cNFO_hs
inedwheWRIlu0x0Lse6cIdefyZd conta e ion atinreife MNotunctionia_fn; mposfiles 0x0"e  card"0x4000   a cdatacnss and e outpFp s /* sees#if olu0x00.90,tLOCAendels *ascount6 tr wri/quig maioRTnk-azerowanspars_0.90
inedlaefr,tLOCAendels ep sG_FIr writeinED
 0.96a s and e o istre. o/e  cardutput file.  The values
 * of the PNG_s as annnnnnbit;                        endels:cdatacns     endels:D
 0.96a s aunk.  These vaG_F_DEFAULT_RELATIVEif dr wri/quig          e. o/e  cardsic. dex;k.  These vaG_F_ERROR_QUITPNG heif dr wri/quig          r wri/quig        ex;k.  These vaG_F_WARN_DISCARDsponif d(INVALI
)k          e. o/e  cardsic. dex;k.  These vaG_F_WARN_USENG_KEYWOReg_u. o/Lse6ic. d      e. o/Lse6ic. d    ex;k.  These vaG_F_QUI PNGt RNS 0x0Reg_quiet/Lse6ic. d     quiet/Lse6ic. d   ex;k.  These vaG_F_NO_CHANG RNS 05SUtines thE:* numbit;    es thE:* numbit;  nfo_struct tothe png
  giv  t_32,
   controlt));
/* e ccan-d2d(Pbyte interinORTE thpROGs) i_wid*/
   png_uint_32 s   if bpr(unfutput filthe png
   unORTEma eion atfulefine Pstaits
isdef void (PNhe valuesLl *void (2d(Pm,
  sr writios32,
  sndata
 * p/* buf   png_byead_/
  fase_en     /*a */
at
   png_expenm7LAST*/
   png_uicanpng_voictionler */
_wid*/
   png_uibytWAP png_ */
   ses1M((unfuholds z /* xpligamma_/*f   in*/
   png_ui (PNGAPI *png_pCcou)OATIe tbyte internt_32  png  if bprTi_andlerC PNG_COL,tLOCAationne PNpng_bit;  ds z"nt_32 "istr0ffset have been named *_method not *_byte ifEAD_Qi
   pnshdG)U the inaorPaD?ESnt_32 PORTreaeeVE_READee_daorRouct_def
{d not *_byte i()iO alcypuin-!5VE_READu0x0Lseng_struer_t8ORTEDing
 os3n sonctionLOCnd sn'PmNnnflida oid (rens defi row0#_8ORTE#else,dif

ase6cIdyEDinge "a(png_ne PNG_/*f   ink.  TheATINe P/
 or writinfile.  The values
 * of the PNG_s ax;k.  These vaNO_t textShat holdsed.
 */
#defilueext (PNGat hold8ed.
 */
#defilueext SUBhat hol1sed.
 */
#defilueext UPinting e2sed.
 */
#defilueext AVGnting e4sed.
 */
#defilueext PAETHing ees in row */
  /* ft textSh(defilueext (PNGa|#defilueext SUBh|#defilueext UPi Any naccccccccccccccccccccccdefilueext AVGn|#defilueext PAETH)daorRopfi roe.  Thein-!5er_t8li-rUSER_TRANSF_WRITg_lfNSF_utilgamma tnowr writinfilransformation routines, as so_s ax;k.  These valueext VALUE (PNGat0;k.  These valueext VALUE SUBhat1;k.  These valueext VALUE UPinti2;k.  These valueext VALUE AVGnti3;k.  These valueext VALUE PAETHi4;k.  These valueext VALUE LASTPN5SR, 1.0.6_text;         /* current text chunk buffUtinameERIM* rAL

/* Thstru"g_chassDeng_pr29"istrgiv ow_isbif S This is ush_ext HEURISTIC_ */
 ansfor, eiWRIlu0f void (PNG(minNG_I-s_I-of-absolute-_vofe*/
 es),ckgrcri  pnexperior ralGnt_32 i(E_USERed-minNG_I-s_I-of-absolute-_vofe*/
 es)_s as anWinm;SUPDingfendrite>=  in, strategy */CAL  mporP/
 nia_fn;0x0keep
   png_us;        /INe ass numbetwr!5    png_Larg   it depsGntantIe thE:* nupng_us;    strinatom_1; chuns
isdlikeion0x0berings rCII \rings" */
ift fs4"hodT ib countVE_READe Mthe istrcumuLUTION_so */
   pnD_oEAD_SRe*oid (aeift fsr writinuniton sn0x0ber" */
ift fs4"oe.  TheTRA"t f ADhift fs4"idNGAia_canpb png_NULL  to savwinm;SUPDinn'Pmby be  /* hfitin-iWinm;SUP  /* no d(P  T */
onrcri  pniles */
#en; /* use Thstet));tte n-iWillg
 os3n winm;SUPcanp(;     g_b)rcri mprov/
_wid*/
   png_uids z rgiv owTED_INs as anC#defPDingfendrite>=  in strategy */t I/OcLUTION_ve_bu_us(s#defPhow png_us;         locnm;   costn strategePPfsetve_bu_us(expenm7s
ined(D)
   pngroffsetl pndlikeion0x0beriles *UPPN);
/a_us;    oid (lse   computao.nenss andostnng_struniton sn0x0berg_bit;  TRA"t f ADhdostn"_so */
   ne PN_us;   
   p   /*giv ow_ise valueext VALUE LAST)idNGAia_canpb _NULL  toyouPDinn'Prcribetgy */t I/dostnng_C#defPtron0x0 mprov/
_wid /*e_/*f rows;      /* oid ouPrcriunduOLORns ousy */t I/do;     ER_TED_Isi
/*Ns as anAitogUTION_w /* buf  cost strategesdef void (PN_bit;  Tsn0x0berUSERs
inepng_bit; sd;      ras s [0in, 1e instrategePtn Opng_b Tsn0x0rema eiun, as so_s ahstruoid (PN_bit; _def
{bod (winm;SUPDOATINdefPDinge PNG_COLO in, inedma s and as s  togo2 igeneralGwinm;Sy */cost g_chassDes_canpb _f) ||ng_If{bod rcri  pnwinm;SUPDOATINdefPDing)OATIoO in, m  e degeneragesdef v/* curreGnt_32 rcri _IDAT UN/* curreGnt_32 , inedoid (apnsed /* sy */thun/computao.ne_s ax;konverts from file to 1.0 */
#endif
 OC__) &CII \fe Mtmethod not *_t f ADhg_chassDesfEAD_Qi
   pnshdG)U the inaorPORTreaeeg_chassDeng_pr295aD?ESSIV_winm;SUhite;
endif
chunk buffer */
U the intendif
chunk bufINdeflse
dif
#endif

#if d ;         /* current text chunk bufng_pCcouHnsuros coPNG_INTERtet));tte files */
#utput filransformation routines and as so_s ax;k.  These valueext HEURISTIC_DEFAULT_RELVEif dC PNG_COL "UN/* curre" ax;k.  These valueext HEURISTIC_UN/* curreGheif dU if bprTi_and <_0.95 ax;k.  These valueext HEURISTIC_/* curreGsponif dExperior ralG theven ax;k.  These valueext HEURISTIC_LASTPNG_KEYWOReg_Nng_u ne PN_bit;  nfo_strSOATIe t thWAP 1int_32 irowbytes;lerC PNG_COL,tne PN_bit; s ras s ad_us an.0 t9,Ae PNG_Fd sy */ defined( _IDAT png_uint_32 irowbytes;sn.0 t9s an(.0 to sint_32 irow, 90 t"m PNGal"sint_32 irow)e MNotunction PstUP  /*rcribh to ctionpng_uint_32 irowbytes;sn3-6oPNualutput   /* a(Py (Ccosytep pr9s anNTERt zlgt buzs
ineddo/INe a
  abutpfee   cacles */w nng_In par an*/
#drcri  pfile.  Thema it_tfe PNG_Fd s/ defined( _IDAT png_uint_32 irowbytes;sffset have been named *_method not *_ransvalue */ytes;fEAD_Qi
   pnshdG)U the inaorPORTreaeeytes;fe_dahave been named *_method not *_ransvalue */r;    /* uintf PN*/
   int zlib_windo_y_whiD?ESnt    /* ue_dahave been named *_method not *_ransvalue */*/
   pnuintf PN*/
   int zlib_windo_y_whiD?ES*/
   pnue_dahave been named *_method not *_ransvalue */* width of uintf PN*/
   int zlib_windo_y_whiD?ES* width of ue_dahave been named *_method not *_ransvalue */r;pr29fEAD_Qi
   pnshdG)U the inaorPORTreaeer;pr29f struct fosnito1.0 he png
   uni/
   pnf(tbleput/0x8000,  png_bs
inedr wripng_  png_usutput yvel */
   inses1Me iriog_lfNSF_iog_lfnput fi useofc,ORTED
d cESSI P/
dardsCels *  png_bytsORTEareadead()idf_WRIT()idinepng_fif defhunkput filthe png
  canpb _madeu0x0Lse6_WRIluls *  png_byORTEDhstun chunkma tabos32f user trantrinatoton  0x0 inpuS ls *inED */
 vofe*/
tom_1n;    rnORTED
{d not *_???_fnhunkp */
   p to 1.0 */ORTEmorpng_rw_ptr wr*png_pC in PeGi)uve_ennsNO_STDIO)
gs ref/* ESR,   png_put/0x8000mma tablet zlib_st _IDAT oid (PN_ (PNGAPI *k_ptr) PNGARG((png_str ressERLAypit_i  /* Adam7  e:OR_(cmi* b8l/*G)U b8l/sh_E_chup* see PNGB/* iuatiuhese*AT (nkE(tbined(borP)s
inedwarnar atdex aDfsdoid (,
  rcrib "a(png_ (PNGAPI *k_If{no e ss buza
 * px0berif deng_youPm */
os lss anwt png_nedLse6ocpsfoeor ro (PNGAPI *kThe6ocpsfoeor roee. ROR_mation rcribe*/
 do/a(lsngjmpt _IDAT    pnt *jmpts */
#enditoyouPDindLsy */t iyORTEnt_32 i*f nkE(tb  png_usutpIfoee. ROR_mordwarnar OR_m e NULL,
   png_oid (PN_ (PNGAPI  */
   p atinpng_pChave been named *_method not *_ e. ROR_lSUx-linear) te tr read_useieU the intd rows e:OR_(ine* CION_B/*ieettee. ROR_(, d2ded(PNGg,epe. oar OR_f struct:amem_ t_32,
   int_32 nsssociaef void (_pronkE(tbED) || defineg_int_32 pcal_X1;     d row      T_Xed(PNGg,e/*iee *Utines ound_strindefine P_Ccouatiuhese*AT oid (PN_fyZd hx8000mmdex aDfsdoid (anes *2lefined(Po   pn_s ahIf{ber_in x tra000m*_1rtirUSERs
th!5 0x8000ep gamma_ canpb _)OATIoONULL_s ahIf{dex ined(PNG_READ_BACKGROm*_1rtir.  TheATatoTi_and  pHYs c chuns ah0x8000ep gamma_  */
   pignon x (s) i_wus_canpb _NULL)ffset have been named *_method not *_CE_ADAd_lSUx-linear) te tr read_useieU the intd rowsio_(ine* CIOrwed data */
fyZd-zero.8ws TED)
   png_bytep gamma_e P_Ccouatiuhese*AT oid (PN_fyZd e of fi(PNGAPI  *d (anes *2lefined(Po  .set have been named *_method not *_, 0.9d_lSUx-linear) te tr read_useieU the intd rowsio_(ine* CIOrwed da, 0.9dyZd-zef struct:amem_ t_32,
   int_32 nsssociaef void (_prols *ED) || defineg_int_32 pcal_X1;     d row      T_XioGg,e/*iee *Utines ound_strindefine P_Chave been named *_method not *_, 0.9tly used_lSUx-linear) te tr read_useieU the intation in current_buffer */
e P_Chave been named *_method not *_ recently used_lSUx-linear) te tr read_useieU the int recently used data */
   png_pCLanspars/inimOATI_bytep trans;  couatiuhese*AT oid (PN_e */
  sls */
#endtdex aDfsdoid (,
  2lefined(Po   pn_set have been named *_method not *_nt  d_lSUx-linear) te tr read_useieU the intd rows. ROR2deN1 to 1.0 sCAL) is non-zero.8ws e:OR_(inens;  dss_tuct:amem_ t_32,
   int_32 nsssociaef void (_proe */
  ED) || defineg_int_32 pcal_X1;     d row      T_X. ROR2d)SUx-linear) te tr read_useielse
   png_uintpet  e index ORTEDOATI_TRANSFORMED
   -mpty.  Any nach pr*/

/* Tction for flushi)Chave been named *_method not *_, 0.9ned r_uint_32  d_lSUx-linear) te tr remax;     in,#if define_uint_32  READ_SHIS give_uint_32  d_lse
   png_uintpet  e index ined(POATI_TRANSFORMED
   -mpty.  Any nach pr*/

/* Tction for flushi)Chave been named *_method not *_ta */
ned r_uint_32  d_lSUx-linear) te tr remax;     in,#if define_uint_32  READta */
ned r_uint_32  d_lse
   png_uintpet  e index ORTEDOATI_TRANSFORMED
   -mpty.  Any nach pr*/

/* Tined(POATI_TRANSFORMED
   -mpty.  Any nach pr*/

/* Tction for flushi)Chave been named *_method not *_ned r_uint_32  ype  /* Adam7  e:OR_(cmi*max;     in,#if d PNGAR*/
  _uint_32  REAhiD?ES*/
  _uint_32  
   f,low D?ES*/
  _uint_32  SUPPORTEss_tuct:amem_ t_32,
   int_32 nsssociaef void (_pro,
   _uint_32  ED) || defineg_int_32 pcal_X1;     d row      T_X*/
  _uint_32  REAl_h_SUx-linear) te tr read_useielse
   png_uint  2 /* N ext chtines */SCn   Chave been named *_method not *_, 0.9ned rs the oflSUx-linear) te tr read_useieU the intd rowsefined(PNG_REA,#if defined(PNG_READ_SHIS gives the ofe P_g_int_32 pcal_X1;     d row      T_X*/
  d(PNG_REAfEAD_Qi
   pnshdG)U tmax;     ine P_   png_u current input chunk */
   png_uint_32strSOAs par an 2file nORTPORTsmma tablee_ptrr*/
  s
ined( int_32 nIoOD */
*/
 -.  TheATnumber of VE_READ_SU _IDAT nORTPORTi (PNGAPI *png_phave been named *_method not *_p;      /* am 0.9d_lSUx-linear) te tr read_useieU the intd rowsp;      /* aeieU the intength;          /* bytes to ,r_size;      /* amount of data ,max;       /* total size of save_bf structramem_le    ,
   int_32 nsssociaef void (_proe_ptrr*/
 ED) || defineg_int_32 pcal_X1;     d row      T_Xp;      /* aeiel_h_SUx-linear) te tr read_useielse

gs an 2file px0ber/
   pnwh!5 fyZd bows;es GE_READ_SOLOR OC__) &CII \fe Mtmethod noe && !de   1 /* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfointaletmGAer_in, location in current_telse

gs an 2file pnatows;bg_byt   png_Nng_ve
  PORTE vofe*/
tonsfor   png_ intfn;bg_bamou()r/
  utpIs m  e ev owUSER?????
OLOR OC__) &CII \fe Mtmethod noe &     /* afn;bg_bamou /* Adam7  e:OR_(cmi* b8l/*G)U the intion foold_ */,e intion f news */)se
   png;                /* histogram */
#endifg_int_32 pcal_X1;     d row     is non)SUx-linear) te tr read_useieU the int */
#d_St_telse

ATING_POINT_SUPPOR indG_REror_fn;TYPEis non-e. o;TYPEis nonies thaponendeATatoTi_and lette index 4fineg_int_32 pcal_X1;     d row     is non-e. o)SUx-linear) te tr read_useieU the int */
#d_St_telse
ypedef struens;sd( int_32 nsls */
if bpr    is non()khe r) PNGARG((png_str ressERLAens; /* Adam7  e:OR_(cmi* b8l/*G)U b8l/d rowspUNKs_ten sNG_POINT_SUPPOR indGorRon 2file px0sls */
ioe */
  Ea t(unfuthe r) PNGARG((png_str respfsERLAzs non)SUx-linea respf b8l/*G)U uI
 niaem
U theuI
 nt_telse

gs on 2file px0f d2d(ii/
  Ea t(unfkhe r) PNGARG((png_str ressERLAzens; /* Adam7  respf b8l/*G)U  respf bUNKs_typedef struF d2dsyZd nnato*ascous */
if t_32 nalutphe r) PNGARG((png_str ressERLAens;e   1 /* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfoint */
#d_SUPy.  F5aD?ESSIV8in   E_NONE    eMS    /* read anuct:asssignSrw_Fd fililityse*_16pay be existaitor writwheWRIluous */
ifORTE#prTi_and or bprt I/f user tran/_ptr) PNGARG((png_str ressERLAdyZd-zpayr /* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfeaeeVpayrUfoint */
#d_SmaskKs_typedef GRESssignor r_def
{d nodyZd-zpayr ax;k.  These vaDESTROY_WI* fteMS DATAt1;k.  These vae PNWI* fteMS DATAt1;k.  These va ext WI* fteMS DATAt2aorRouct_def
{d no_UN->UPy.  Fhe inpuPNG_UN->UPy.  Fhax;k.  These valeMS HISTholdsd8ed.
 */
#defileMS ICCPholds1sed.
 */
#defileMS SPLTholds2sed.
 */
#defileMS ROWSholds4sed.
 */
#defileMS PCALholds8sed.
 */
#defileMS SCALhold10sed.
 */
#defileMS Theshold20sed.
 */
#defileMS LISThold40sed.
 */
#defileMS e PN ol1s0sed.
 */
#defileMS Tnfo_ e2s0sed.
 */
#defileMS TEXTg e4s0sed.
 */
#defileMS ALLng e7fffed.
 */
#defileMS MULng e4220;       leMS SPLT|defileMS TEXT|defileMS Thesht;
   E_NONE   OATI_bytep trans;  dss_puf/* ES PNGt descd row     is non-oid (PN)SUx-linear) te tr read_useieU the int */
#d_St_telse
r) PNGARG((png_str ressERLAens;e id (PN)SUx-linear) te tr read_useieU the intd rowspUNKs_t   png_u OC__) &CII \fe Mtdescd row     iemcpyin PeGiSUx-linear) te tr read_useieU the intd rowss1U b8l/d rowss2hite;
   png_fi
/** seu OC__) &CII \fe Mtdescd row     iemt *_r PeGiSUx-linear) te tr read_useieU the intd rowss1U inumbit; ,e int */
#d_St_telse

ATING_POINT_ion FAR_KEYWOR
)k /*d(ii/
  finel /owareng_ui (PNGAPIk_ptr) PNGAgs */*ERLAearptp,nearSUx-linear) te tr read_useieU intd rowspUNPORTreaeec PeGi)uv   png;   ion FAR_KEYWOR
 nfo_strFaralGnkE(tble_t zlgt bui*f Ti_and -_can'PmNnntaiuSOLOR OC__) &CII \fe Mtmethod nonkE(t)SUx-linear) te tr read_useieU the intfnws e:OR_(ied(PNGe ss buf struct fos rCI, inedDAT nhangedPNGm*_1prep  pn  0x0_pronkE(tbsks pn_set have been named *_method noM7    pkE(t)SUx-linear) te tr read_useieU the intfnws e:OR_(ied(PNGe ss buf structNon-faralGnkE(tble_Ti_andlerCanmNnntaiuS, inedma a  /* ssp; D_SmNF_ptr) PNGARG((png_str ressERLAC. oar )SUx-linear) te tr read_useieU the intfnws e:OR_(ie. oar Oe ss buf structNon-faralGnkE(tble_Ti_and, nhangedPNGm*_1prep  pn  0x0e ss bu_set have been named *_method noM7    C. oar )SUx-linear) te tr read_useieU the intfnws e:OR_(ie. oar Oe ss buf structTprogres. *_<M7   >0 he png
   unif(tbskointerbit; sd;      gresSR, 1.0.6 *_s ahSimREArOL,tLOCA     T_X<M7   >0/
  sPDindLsn  0x0r*/
 bit; _ded_user_png_ intSR, 1.0.6 *, eiWRIluskointer    strPNGt  sng_r    st  ER_variAD_Ss,ckgrcribetgy */int_32 ssav o _progresSR, 1.0.6 */RTnk-reaeefyZd esuskoitin-iuh_png_ intg *_<M7   >0 he png
   pngloraetr;     /png_b TfreaeefyZd *ascoE_READ_Srcri n d(PNG_UNUfhe isnglor    /ineddo/t_tfe as s (PNG_fr    strPNGt  sngf
   png_oyZd *ascpng_uE_READ_S.s as anut filthe png
  ation r  p ati_ne PNG_/*f  defined(#e;   ED
{d nod(PNrcri _Iags */E; D_Smsdoid (an*/
#fe as ssng_r    t_tehe inpu32 nal lay* _pofpng_ intSR, 1.0.6 **png_pma_16_tabl "er_t"ngf
nhangefyZd esune PN_ n d(PNG_UN.1hAD_   aU
 * ROR index tutable;aU
 * g *_ne PN)SUx-linear) te tr read_useieU  int      d(PNG_UNUfoint */
#d_SUr_tf struct:amem_s it depth oype shton n  0x0 oTYPa _uint_32 n   */.1hAD_   aU
 * ROR index tutable;aU
 * g *_Uxt" is )SUx-linear) te tr read_useieU  int      d(PNG_UNKs_ten sNG_POINT_SUPPINFO_IMAGEonally near! iuatmem_s mountnt_32 s,puin-!5;n; /*uint2 intant_32 ssO alcanlsformnnato*as
isnglong_1pny nachm 0.9nachunk_ptr) PNGARG((png_str intion flU
 * g *_Uxt )SUx-linear) te tr read_useieU  int      d(PNG_UNKs_tstrSOATmountnt_32 s,puin-!5;n; /*uint2 intant_32 ssO alcanlsformf(tb at
bpr    ta */
nachunk_ptr) PNGARG((png_strmethod not *_,fiSl/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfointaletmpTmountnt_32 s* see PNGB/* iuatmem_s it depth ourist SUPPORTE_ n dED_INF_ptr) PNGARG((png_str    ion       T_XSUPPORTEsSUx-linear) te tr read_useieU  int      d(PNG_UNKs_ten s_NONE   EASY_ACCESS /* read anuct:amem_s gt buislati_TRANt_siz.set have been named *_x tutable;aU_ intg *_gt bunslatifEAD_Qi
   pnshdG)U tmndo_y_white;
      d(PNG_UNf struct:amem_s gt buioine t_TRANt_siz.set have been named *_x tutable;aU_ intg *_gt bunoine tfEAD_Qi
   pnshdG)U tmndo_y_white;
      d(PNG_UNf struct:amem_s gt bui pnD
   fNF_ptr) PNGARG((png_str    ion  _ intg *_ pnD
   ffEAD_Qi
   pnshdG)U tmndo_y_white;
      d(PNG_UNf struct:amem_s gt buifn; /*     l_ptr) PNGARG((png_str    ion  _ intg *_fn; /*    fEAD_Qi
   pnshdG)U tmndo_y_white;
      d(PNG_UNf struct:amem_s gt buiD) && defin l_ptr) PNGARG((png_str    ion  _ intg *_D) && definfEAD_Qi
   pnshdG)U tmndo_y_white;
      d(PNG_UNf struct:amem_s gt buiiwf PNG_L_efin l_ptr) PNGARG((png_str    ion  _ intg *_iwf PNG_L_efinfEAD_Qi
   pnshdG)U tmndo_y_white;
      d(PNG_UNf struct:amem_s gt buifn shon O all o( l_ptr) PNGARG((png_str    ion  _ intg *_fn shon O all o(fEAD_Qi
   pnshdG)U tmndo_y_white;
      d(PNG_UNf struct:amem_s gt buihonolut#endiRANt_siz  endNGt  ,_1pny nHYs
nhangefyZd.set have been named *_x tutable;aU_ intg *_Nt_sizbAe__NGt  fEAD_Qi
   pnshdG)U tmndo_y_white;
      d(PNG_UNf sthave been named *_x tutable;aU_ intg *_x_Nt_sizbAe__NGt  fEAD_Qi
   pnshdG)U tmndo_y_white;
      d(PNG_UNf sthave been named *_x tutable;aU_ intg *_y_Nt_sizbAe__NGt  fEAD_Qi
   pnshdG)U tmndo_y_white;
      d(PNG_UNf struct:amem_s if
   a /* ATm tra, computng_1pny nHYs
nhangefyZd.s ax;konverts from file to 1.0 */
#endif
 OC__) &CII \fe MtfloatU_ intg *_Nt_si_a /* A_m trafEAD_Qi
   pnshdG)U tmndo_y_white;
      d(PNG_UNf ste PNGB/* iuatmem_s gt buix, 2 inf)OATiRANt_siz SUPPicrg
 ,_1pny oFFs
nhangefyZd.set have been named *_x tuable;aU_ intg *_x_inf)OA_Nt_sizfEAD_Qi
   pnshdG)U tmndo_y_white;
      d(PNG_UNf sthave been named *_x tuable;aU_ intg *_y_inf)OA_Nt_sizfEAD_Qi
   pnshdG)U tmndo_y_white;
      d(PNG_UNf sthave been named *_x tuable;aU_ intg *_x_inf)OA_Picrg
 fEAD_Qi
   pnshdG)U tmndo_y_white;
      d(PNG_UNf sthave been named *_x tuable;aU_ intg *_y_inf)OA_Picrg
 fEAD_Qi
   pnshdG)U tmndo_y_white;
      d(PNG_UNf st
   png;       EASY_ACCESS /* read ation ma_16_tabl int_32 nIoOable usingsks pnrr*/
 Epny t zl */
   _ptr) PNGARG((png_str intion f      T_Xable usin)SUx-linear) te tr read_useieU  int      d(PNG_UNKs_ten sNG_POINT_SUPPbKGDttypeTION_sig_int_32 pcal_X1;     table;aU
 * g *_bKGDl/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfointfn; /* pn_*f PNG_FLOA)se
   png_uintpet  e index bKGDttypeTION_sig_int_32 pcal_X1; method not *_fKGDl/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfointfn; /* pn_f PNG_FLOA)se
   png_uintpet  e index cHRMED
   -mpty;konverts from file to 1.0 */
#endif
 OC__) &CII \fe Mtadataim;SU       T_X1HRMl/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfendif

*uin*/
xUfendif

*uin*/
yUfendif

*red
xU theendif

*red
yUfendif

*ear!5
xUfendif

*ear!5
yUfendif

*b;  
xU theendif

*b;  
ylse
dif
#endonverts froIXEDto 1.0 */
#endif
 OC__) &CII \fe Mtadataim;SU       T_X1HRMd_ bo fEAD_Qi
   pnshdG)U the inaorPORTr int      d(PNG_UNUfoint_ bo        *im;Suin*/
xUfoint_ bo       ORTr*im;Suin*/
yUfoint_ bo        *im;Sred
xUfoint_ bo        *im;Sred
yPORTr int_ bo        *im;Sear!5
xUf int_ bo        *im;Sear!5
yUfoint_ bo       ORTr*im;Sb;  
xUf int_ bo        *im;Sb;  
ylse
dif
#end  png_uintpet  e index cHRMED
   -mpty;konverts from file to 1.0 */
#endif
 OC__) &CII \fe Mtmethod not *_rHRMl/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfendif

uin*/
xUfendif

uin*/
yUfendif

red
xU theendif

red
yUfendif

ear!5
xUfendif

ear!5
yUfendif

b;  
xUfendif

b;  
ylse
dif
#endonverts froIXEDto 1.0 */
#endif
 OC__) &CII \fe Mtmethod not *_rHRMd_ bo fEAD_Qi
   pnshdG)U the inaorPORTr int      d(PNG_UNUfoint_ bo        im;Suin*/
xUfoint_ bo        im;Suin*/
yUORTr int_ bo        im;Sred
xUfoint_ bo        im;Sred
yPfoint_ bo       ORTrim;Sear!5
xUf int_ bo        im;Sear!5
yUfoint_ bo        im;Sb;  
xUORTr int_ bo        im;Sb;  
ylse
dif
#end  png_uintpet  e index gAmma value */
 konverts from file to 1.0 */
#endif
 OC__) &CII \fe Mtadataim;SU       T_XgAmml/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfendif

*dise definlse
dif
#en OC__) &CII \fe Mtadataim;SU       T_XgAmmd_ bo fEAD_Qi
   pnshdG)U the inaorPORTr int      d(PNG_UNUfoint_ bo        *im;Sdise definlse
dif
#enuintpet  e index gAmma value */
 konverts from file to 1.0 */
#endif
 OC__) &CII \fe Mtmethod not *_dAmml/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfendif

dise definlse
dif
#en OC__) &CII \fe Mtmethod not *_dAmmd_ bo fEAD_Qi
   pnshdG)U the inaorPORTr int      d(PNG_UNUfoint_ bo        im;Sdise definlse
dif
#enuintpet  e index hISTttypeTION_sig_int_32 pcal_X1;     table;aU
 * g *_hIST /* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfoint */
# pn_*G_LElse
dif
#enuintpet  e index hISTttypeTION_sig_int_32 pcal_X1; method not *_hIST /* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfoint */
# pn_G_LElse
dif
#enug_int_32 pcal_X1;     table;aU
 * g *_IHDR /* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfoint */
#d_S*slatiUfoint */
#d_S*oine tPORTreaee* pnD
   f,reaee*fn; /*    ,reaee*iwf PNG_L_nt_32 PORTreaee*ransvalue */r;pr29,reaee*D) && dr;pr29f strg_int_32 pcal_X1; method not *_IHDR /* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfoint */
#d_SslatiUfoint */
#d_Soine tP i
   pnD
   f,low eaeecn; /*    ,reaeeiwf PNG_L_nt_32 P eaeecnnsvalue */r;pr29,ORTreaeeVE_REAdr;pr29f strintpet  e index oFFsttypeTION_sig_int_32 pcal_X1;     table;aU
 * g *_oFFs /* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfoint*/
#d_S*inf)OA_xUfoint*/
#d_S*inf)OA_yPORTreaee*upit_l o(fse
dif
#enuintpet  e index oFFsttypeTION_sig_int_32 pcal_X1; method not *_oFFs /* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfoint*/
#d_Sinf)OA_xUfoint*/
#d_Sinf)OA_yPORTreaeeupit_l o(fse
dif
#enuintpet  e index pCALttypeTION_sig_int_32 pcal_X1;     table;aU
 * g *_pCALl/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfointfOR_(i*purposeUfoint*/
#d_S*X0Ufoint*/
#d_S*X1PORTreaee*    ,reaee*nstrPNsUfointfOR_(i*upitsUfointfOR_((i*ptrPNsfse
dif
#enuintpet  e index pCALttypeTION_sig_int_32 pcal_X1; method not *_pCALl/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfointfOR_(ipurposeUfoint*/
#d_SX0Ufoint*/
#d_SX1PORTreaee    ,reaeenstrPNsUfointfOR_(iupitsUfointfOR_((iptrPNsfse
dif
#enuintpet  e index pHYsttypeTION_sig_int_32 pcal_X1;     table;aU
 * g *_pHYs /* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfoint */
#d_S*val_xUfoint */
#d_S*val_y,reaee*upit_l o(fse
dif
#enuintpet  e index pHYsttypeTION_sig_int_32 pcal_X1; method not *_pHYs /* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfoint */
#d_Sval_xUfoint */
#d_Sval_y,reaeeupit_l o(fse
dif
#enug_int_32 pcal_X1;     table;aU
 * g *_st;  /* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UN,e intfn; /ng*_byte c5aD?ES*SIV__byte cf strg_int_32 pcal_X1; method not *_st;  /* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UN,e intfn; /ng_byte c5aD?ESSIV__byte cf strintpet  e index sBITttypeTION_sig_int_32 pcal_X1;     table;aU
 * g *_sBITl/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfointfn; /*8ng*sig_ pnfse
dif
#enuintpet  e index sBITttypeTION_sig_int_32 pcal_X1; method not *_tBITl/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfointfn; /*8ngsig_ pnfse
dif
#enuintpet  e index s musimage is c
g_int_32 pcal_X1;     table;aU
 * g *_s mu /* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfeaee*iwf nnfse
dif
#enuintpet  e index s musimage is c
g_int_32 pcal_X1; method not *_t mu /* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfeaeeiwf nnfse
g_int_32 pcal_X1; method not *_t mu_dAmmda/* fHRMl/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfeaeeiwf nnfse
dif
#enuintpet  e index iCCPsimage is c
g_int_32 pcal_X1;     table;aU
 * g *_iCCPl/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfointfOR_(pedPNG,reaee*ransvalue */    , the intfOR_((iprodiseUfoint */
#d_S*prodlebf st OReg_NngSU _Ima eta e r:iprodise ation r  pointaletmpTatable6Tinuintpet  e index iCCPsimage is c
g_int_32 pcal_X1; method not *_iCCPl/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfointfOR_(edPNG,reaeeransvalue */    , the intfOR_(iprodiseUfoint */
#d_Sprodlebf st OReg_NngSU _Ima eta e r:iprodise ation r  pointaletmTatable6Tinuintpet  e index sst;simage is c
g_int_32 pcal_X1;     table;aU
 * g *_sst;l/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfointsst;st   satriesfse
dif
#enuintpet  e index sst;simage is c
g_int_32 pcal_X1; method not *_tst;l/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfointsst;st  satries5aD?ESSsatriesfse
dif
#enuintpet  e index TEXTonally near! iu
 * g *_to1.0alsotramem_le    it depth oto1.0d e o isnS*SIV_to1.0hAD_   aU
 * ROR index tutable;aU
 * g *_to1.l/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfointto1.mTato1.G_UNUfeaee*SIV_to1.f ste PNGB/* is annNngSUwhes1Me iot *_ao1.()  */
 #e; pg_u number of wbos32ao1.,ORTE languag7s
ined _uintl/
if keywordsPDindNULL tnt_32 s,p    tumber ofORTE isnglong_bpr    g *_to1.0 */
 #unt6 tconta e isgulagrcrir    -te_enn/
if Cgsks pnsutput yvmne t_  pemptynsks pns inercrircIdyE */
 ne);
/bndNULL tnt_32 s*png_pC in et  e index TEXTonally near!g_int_32 pcal_X1; method not *_to1.l/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfointto1.mTto1.G_UNUfeaeeSIV_to1.f ste PNGB/* in et  e index tIMEsimage is c
g_int_32 pcal_X1;     table;aU
 * g *_tIMEl/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfointtimtmTamodttimtf ste PNGB/* in et  e index tIMEsimage is c
g_int_32 pcal_X1; method not *_tIMEl/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfointtimtmTmodttimtf ste PNGB/* in et  e index tRNSsimage is c
g_int_32 pcal_X1;     table;aU
 * g *_tRNS /* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfointaletmG*_uintUfeaee*SIV_tuintU the intfn; /* pn_*_uint_bit; _f ste PNGB/* in et  e index tRNSsimage is c
g_int_32 pcal_X1; method not *_tRNS /* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfointaletmG_uintUfeaeeSIV_tuintU the intfn; /* pn__uint_bit; _f ste PNGB/* in et  e index tRNSsimage is c
dif
#enuintpet  e index sCALttypeTION_sikonverts from file to 1.0 */
#endif
 OC__) &CII \fe Mtadataim;SU       T_XsCALl/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfeaee*upitUfendif

*ulatiUfendif

*oine tf ste  thadonverts froIXEDto 1.0 */
#endif
 OC__) &CII \fe Mtadataim;SU       T_XsCALtsl/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfeaee*upitUf intfOR_((isslatiUfointfOR_((isoine tf ste f
#end  png_   png;       sCALttypeTION_ng_pC in et  e index sCALttypeTION_sikonverts from file to 1.0 */
#endif
 OC__) &CII \fe Mtmethod not *_tCALl/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfeaeeupitUfendif

ulatiUfendif

oine tf ste f
#endonverts froIXEDto 1.0 */
#endif
 OC__) &CII \fe Mtmethod not *_sCALtsl/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfeaeeupitUf intfOR_(isslatiUfointfOR_(isoine tf ste f
#end  png;       sCALttypeTION_nSUP   png_flusCALttypeTION_ng_pC in et  e index These d chtines */SCn   r! iu
rovid* sslistth ou e o iinedCAL 0t yvel *px0ber inpuS P efr    built-inOR  h png_us(g_prid (PN_e on to nhangeh png_us(*_1rtir. siitin-iAnyou e o irtiOR  liste;  */
   p inpuS ng_r    oid (PN_e_1n; ng_struIHDRiinedIENDou e o OR  m */
rtirbe liste;.y naccckeep
= 0: fog_uinoid (PN_behavoury nacccccccc= 1:fdo/t_tfkeepy nacccccccc= 2:ckeep
ationefrsafe-to-copyy nacccccccc= 3:ckeep
ev owefrunsafe-to-copyy_ptr) PNGARG((png_strmethoMe iot *_keep_e on tooM7   s /* Adam7  e:OR_(cmi*max;     in,#eaeekeepUfointaletmGM7    listUfeaeeSIV_M7   s se
g_int_32 pcal_X1; methoMe iot *_e on tooM7   s /* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfoint  on tooM7   p_e on totUfeaeeSIV_e on tot se
g_int_32 pcal_X1; methoMe iot *_e on tooM7   _s */
#enuintf PN*/
   int zlib_windo_y_whi int      d(PNG_UNUfeaeeM7   Ufeaees */
#enu sthave been named *_x tutable;aU     T_X* on tooM7   s /* Adam7  e:OR_(cmi*max;     in,# int      d(PNG_UNUfoint  on tooM7   p  satriesfse
dif
#endonverts frHANDLE_AS These d */
#endif
en named *_ablU     inpuS_ast  on to /* Adam7  e:OR_(cmi* b8l/*G)U b8l/aletmmax;M7   _dPNGf ste PNGB/* iuPRLAens;e   1()  */
 ngloroffr    "ne PN"SUr_tlds z /ytable ieeVpays.y naItoyouPton  0x0nglornd gffrds z rnhangennatoyour/f user tran/hareadee9,ORTryouPcanpus1Me iot *_inne PN(     in,#eaPNG_UNUfSUPPINFO_CHNK); _ptr) PNGARG((png_strmethoMe iot *_inne PNl/* Adam7  e:OR_(cmi* b8l/*G)U the int      d(PNG_UNUfeaeemaskKs_ten sNG_POINT_SUPPINFO_IMAGEonally near! iustru"ptrPNs" int_32 nstrcuPNG_COL rtirUSERhe inprmf(tban*/
#f rowss/
#ut_ptr) PNGARG((png_strmethoMe iom 0.9nacl/* Adam7  e:OR_(cmi* b8l/*G)U theeeeeeeeeeeeeeeeeeeeeete;
      d(PNG_UNU theeeeeeeeeeeeeeeeeeeeeeeaee uint_32 sU theeeeeeeeeeeeeeeeeeeeeete;
d rowsptrPNsfse
r) PNGARG((png_strmethoMe iota */
nacl/* Adam7  e:OR_(cmi* b8l/*G)U theeeeeeeeeeeeeeeeeeeeeete;
      d(PNG_UNU theeeeeeeeeeeeeeeeeeeeeeeaee uint_32 sU theeeeeeeeeeeeeeeeeeeeeete;
d rowsptrPNsfse
e PNGB/* iuD  These vaDEBUG atows;Ys c chunmf(tbdebuggnterinrw_ptr wr*locnm;  rcriit depsGNTERt zaDEBUG ntantPfsetvebuggnterinrw_ptr wr*lothe ihars ah0tionbr!5 apnsedsi */
anspars_0.95 soni0m*_1rtirimpleor rn  0hroug ouPrcriTi_and yet, inedmoinge "aort  */
   papnsedashton n _s ax;konverts frDEBUGen sN(t zaDEBUG > 0)C in PeGi)uve_ennsDEBUG/sh_E) &&NG_POINT__MSC_VER)C includ* <crtdbg.h>en sN(t zaDEBUG > 1)ed.
 */
#ERLAdbbug(l,m)  _RPT0(_CRT_WARN,m)ed.
 */
#ERLAdbbug1(l,m,p1)  _RPT1(_CRT_WARN,m,p1)ed.
 */
#ERLAdbbug2(l,m,p1,p2) _RPT2(_CRT_WARN,m,p1,p2)te f
#end  th;       DEBUG/sh_EnSUP!_MSC_VER ax;konnverts frDEBUG/sh_E;k.  These vaDEBUG/sh_Enstderrnd  png;       DEBUG/sh_Enax;konN(t zaDEBUG > 1)ed.
 */
#ERLAdbbug(l,m) \
{Any nacceaeeSIV_tabs=l;Any naccfif defh    DEBUG/sh_E,"%s"m,(SIV_tabs==1 ? "\t" :Any nacccc(SIV_tabs==2 ? "\t\t":(SIV_tabs>2 ? "\t\t\t":""))));Any}ed.
 */
#ERLAdbbug1(l,m,p1) \
{Any nacceaeeSIV_tabs=l;Any naccfif defh    DEBUG/sh_E,"%s"m,(SIV_tabs==1 ? "\t" :Any nacccc(SIV_tabs==2 ? "\t\t":(SIV_tabs>2 ? "\t\t\t":""))),p1);Any}ed.
 */
#ERLAdbbug2(l,m,p1,p2) \
{Any nacceaeeSIV_tabs=l;Any naccfif defh    DEBUG/sh_E,"%s"m,(SIV_tabs==1 ? "\t" :Any nacccc(SIV_tabs==2 ? "\t\t":(SIV_tabs>2 ? "\t\t\t":""))),p1,p2);Any}ed  png;   (t zaDEBUG > 1)Tatable6Ti;   _MSC_VER ax;k  png;   (t zaDEBUG > 0)Tatable6Ti;   t zaDEBUG ax;konnvertERLAdbbuged.
 */
#ERLAdbbug(l, m)
dif
#endonnvertERLAdbbug1ed.
 */
#ERLAdbbug1(l, moMe1)
dif
#endonnvertERLAdbbug2ed.
 */
#ERLAdbbug2(l, moMe1oMe2)te f
#entr) PNGARG((png_str intion f     sig_  is )SUx-linead ro* seu OC__) &CII \fe MtdescfOR_(      T_X1opyrne tfEAD_Qi
   pnshdG)U tad_useielse
 OC__) &CII \fe MtdescfOR_(      T_X */
  _verfEAD_Qi
   pnshdG)U tad_useielse
 OC__) &CII \fe MtdescfOR_(      T_X */
  _versma_fEAD_Qi
   pnshdG)U the inaorlse
 OC__) &CII \fe MtdescfOR_(      T_XTi_and_verfEAD_Qi
   pnshdG)U tad_useielse
;konverts frM froEATURES */
#endif
 OC__) &CII \fe Mtadataim;SU      pe_ent_mRLAethevens /* Adam7  e:OR_(cmi*max;     in,# int */
#d_SmRLAethevens pe_entrn Ks_typedef struF(tb at_TRANSFOt *_keep_e on to,papnsed0x0lette index 6hax;k.  These vaHANDLE_chtin_AS DEFAULT_RE0;k.  These vaHANDLE_chtin_NEVER        1;k.  These vaHANDLE_chtin_IF_SAFENG_KEY2;k.  These vaHANDLE_chtin_ALWAYSPNG_KEYW
aponendeAT0x0lette index 0nax;konNeGi)uve_ennsASSEMBLxt cODEonally near!in row */
  /SM_FLAfrMMXonally n cOMPh_ED holdheif drtirUSEr-betgAD_SOLORin row */
  /SM_FLAfrMMXonally n IN_CPUat hold2eif drtirUSEr-betgAD_SOLORin row */
  /SM_FLAfrMMXohistocOMBINS ROW hold4Rin row */
  /SM_FLAfrMMXohistoINTERLACGat hold8ed.
 */
#defi/SM_FLAfrMMXohistolueext SUBhatol1sed.
 */
#defi/SM_FLAfrMMXohistolueext UPinti e2sed.
 */
#defi/SM_FLAfrMMXohistolueext AVGnti e4sed.
 */
#defi/SM_FLAfrMMXohistolueext PAETHi ees in row */
  /SM_FLAfSoINITIALIZreGsp_RELATIVeessssssseif drtirUSEr-betgAD_SOLOR in row */
  MMXohistolLAfS (*/
  /SM_FLAfrMMXohistocOMBINS ROW hny nacccccccccccccccccccccc n|#defi/SM_FLAfrMMXohistoINTERLACGat hny nacccccccccccccccccccccc n|#defi/SM_FLAfrMMXohistolueext SUBhatny nacccccccccccccccccccccc n|#defi/SM_FLAfrMMXohistolueext UPintiny nacccccccccccccccccccccc n|#defi/SM_FLAfrMMXohistolueext AVGntiny nacccccccccccccccccccccc n|#defi/SM_FLAfrMMXohistolueext PAETHi) in row */
  MMXoined(PNGAfS (*0i)  in row */
  MMXolLAfS (*/
  /SM_FLAfrMMXonally n cOMPh_ED ny naccccccccccccccccccc|*/
  /SM_FLAfrMMXonally n IN_CPUat ny naccccccccccccccccccc|*/
  MMXohistolLAfS                ny naccccccccccccccccccc|*/
  MMXoined(PNGAfS )  in row */
  SELECTohist   1;k.  These vaSELECToined(EY2;C in PeGi)uve_ennsOR indGorRNSF T_.c0hAD_   aU
 * ROR index tutable;aU
 * g *_mmx_Ur_tmaskKintf PN*/
  eaeeVr_t_iles *,reaee*ranss crIDf structNSF T_.c0hAD_   aU
 * ROR index tutable;aU
 * g *_asm_Ur_tmaskKintf PN*/
  eaeeVr_t_iles *f structNSF T_.c0hAD_   aU
 * ROR index tutable;aU
 * g *_asm_Ur_tsl_h_SUx-linear) te tr read_useielse

gs NSF T_.c0hAD_   aU
 * ROR index tuion       T_Xmmx_bit
   f_0hres oTYl_h_SUx-linear) te tr read_useielse

gs NSF T_.c0hAD_   aU
 * ROR index tutable;aU
 * g *_mmx_Uxt" is _0hres oTYl_h_SUx-linear) te tr read_useielse

gs NSFsT_.c0hAD_   aU
 * ROR indemethod not *_asm_Ur_tsl_h_SUx-linear) te tr read_useie,# int */
#d_Sasm_Ur_tslse

gs NSFsT_.c0hAD_   aU
 * ROR indemethod not *_mmx_0hres oTYsl_h_SUx-linear) te tr read_useie,# int" is mmx_bit
   f_0hres oTYU the int */
#d_Smmx_Uxt" is _0hres oTYl st
   png;       OR inTatable6Ti;   t zaASSEMBLxt cODEonally neang_pC in PeGi)uve_ennsOR indGorRNSFg_lfNSFgccrdg_lff
{d nvcrdg_0hAD_   aU
 * ROR indeablU    mmx_e "aort)SUx-linead ro* seustrStripr    srep  pn  nkE(tbit depsG("#nnn ") Epny nkE(tbinede. oar ORTEntss buzaboffsetst  nter   m 0x0_pronkE(tbordwarnar p inpuSN.1hADn s_NONE   ERROR_NUMBERes */SCn   Chave been named *_method not *_sks pXed(PNGit deps /* Adam7  e:OR_(cmi*max;     in,# int */
#d_Ssks pXfinef ste PNGB/*   png;       OR inTataaponendeATatoTi_and-dex 6hax;k s_NONE   e PNOATI_LIMITes */SCn   Chave been named *_method not *_*/
  limof u/* Adam7  e:OR_(cmi*max;     in,# int */
#d_S*/
  slati_max,# int */
#d_S*/
  oine t_maxu sthave been named *_x tutable;aU     T_X*/
  slati_maxfEAD_Qi
   pnshdG)U tmax;     ine P_have been named *_x tutable;aU     T_X*/
  oine t_maxuEAD_Qi
   pnshdG)U tmax;     ine P_   png_uponMa eta e r:iPuESSsw publicu
rotow0#_8 Tnk-r^,ble_Ti_andl3lfnput roj* AT_NOsht;
   E_NONE   histocOMPOSed(PNODIV /* read anuctWid (_prse6o png_bytweIags */aneiwf g   divid*,puin-!5 */
   pslse   onrcrimost machg_by*locse v  ,_iAT_oormnakePPfsetoper trantrinantIe th PNG_Fd sy * */
 vvid* nt_32 P soni0mma a  pslse   on/a_usw RISC sysaem
ng_struniel *pworcribhiftsG(by 8bord16  of u
ined(5 apnitrow, lettusd(  nteleeiwf g   divid*.s as anNotunction he6o p sy */fendriteDindNOTge "aosn  0x0berings rCI!  128dinepng_32768  uni/ PNGc0mma tableNODIVi/ de; 127
ined32767  uni/ PNGc0mma tablrcribe/
dardsnt_32 .s as an[Optimozedi/ de_bprGreg Roelof iinedMarknenuSN...blPNGmu_def
{bunsut:-) ]png_pC;   fgiinedbg ation r  ple_`definO in' space; alpha strinetopacitysssssssssst;
  REror_fn;TYPEransosRIT(ransosRIT, fg, alpha,dbg) nacccccccccccccccccccccc n ny nacc{foint */
# p aemp
= (oint */
# p)((oint */
# p)(fg) * (oint */
# p)(alpha)iny naccccccccccccccccccccc+cccccccc(oint */
# p)(bg)*(oint */
# p)(255 -       ny naccccccccccccccccccc  (oint */
# p)(alpha))c+c(oint */
# p)128);           ny nacccc(ransosRIT)
= (oint" is)((aemp
+c(aemp
>> 8))c>> 8); }
  REror_fn;TYPEransosRIT# p(ransosRIT, fg, alpha,dbg) naccccccccccccccccccccccny nacc{foint */
#d_Saemp
= (oint */
#32)((oint */
#32)(fg) * (oint */
#32)(alpha)iny naccccccccccccccccccccc+c(oint */
#32)(bg)*(oint */
#32)(65535L -           ny naccccccccccccccccccc  (oint */
#32)(alpha))c+c(oint */
#32)32768L);        ny nacccc(ransosRIT)
= (oint */
# p)((aemp
+c(aemp
>>  p))
>>  p); }
    th;;   be/
dardsnt_32 dLsy */iwf g   divisAPIk_pt  REror_fn;TYPEransosRIT(ransosRIT, fg, alpha,dbg) nacccccccccccccccccccccc n ny nacc(ransosRIT)
= (oint" is)(((oint */
# p)(fg) * (oint */
# p)(alpha)i+    ny nacccc(oint */
# p)(bg) * (oint */
# p)(255 - (oint */
# p)(alpha))c+c      ny nacccc(oint */
# p)127) / 255)
  REror_fn;TYPEransosRIT# p(ransosRIT, fg, alpha,dbg) naccccccccccccccccccccccny nacc(ransosRIT)
= (oint */
# p)(((oint */
#32)(fg) * (oint */
#32)(alpha)i+ ny nacccc(oint */
#32)(bg)*(oint */
#32)(65535L - (oint */
#32)(alpha))c+c     ny nacccc(oint */
#32)32767) / (oint */
#32)65535L)/*   png;       histocOMPOSed(PNODIV /* read aTataapon fosnito1.0 he png
   uni ati_ne32 nalutpintIe th d*.tput yvgenerallyrcribh on n'Pm  p ati_unltssoyouPDindta *ind  pdeu0x0apnfhe isiuhesesouns ah he png
alitysle_Ti_andlerMorpng_rw_ptr wrd(bonedmostlthe png
  canORTE# _f) ||*/
   inses1s/RTnk-reaee he png
   unis */
if*png_pC in et  e index INTERNAL)/*ponVariou_dfinesth ooper trane MNotunctionaf32 nsneiwitUffine esusOATIoORTE    /iutoptr calutpwh!5     tumber ofnstrcre/
if*png_pk.  These vaHAVE_IHDRcccccccccccccccoldhpk.  These vaHAVE_e PN ccccccccccccccold2pk.  These vaHAVE_IDAT ccccccccccccccold4Rin row */
  /Fext IDAT cccccccccccccold8ed.
 */
#defiHAVE_IENDo cccccccccccccol10ed.
 */
#defiHAVE_dAmmo cccccccccccccol20ed.
 */
#defiHAVE_fHRMo cccccccccccccol40ed.
 */
#defiHAVE_t muo cccccccccccccol80ed.
 */
#defiHAVE_chtin_HistER      ol1s0ed.
 */
#defiWROd(PtIMEcccccccccccccol200ed.
 */
#defiWROd(PINFO_BEFORS e PN ol40sed.
 */
#defiBACKGROUND_IS_GRAYELATIVeesspk.  These vaHAVE_e   eIGNATURE    ol1s00 strueuct_def
{     uint_32  trantrinlet zl thWAP 1_oormo5     gt buifyZd g_pk.  These vaBGRcccccccccccccccholdsdhpk.  These vaINTERLACGat hcccccholdsd2pk.  These vaPACKccccccccccccccholdsd4Rin row */
  SHIFTcccccccccccccholdsd8ed.
 */
#defiSWAP_BYTESccccccccholds10ed.
 */
#defiINVERT_MONOcccccccholds20ed.
 */
#defiDITHERccccccccccccholds4sed.
 */
#defiBACKGROUNDccccccccholds8sed.
 */
#defiBACKGROUND_ameAND holdh00 acccccccccccccccccccccc n tru hold20s_un ati_g_pk.  These va16_TO_8ccccccccccccold4sspk.  These va mumo cccccccccccccol0esspk.  These vaameAND hcccccccccccol10sspk.  These vaGAMmmo cccccccccccc e2s0sed.
 */
#defiGRAY_TO_ muo cccccc e4s0sed.
 */
#defilILLERccccccccccccholesssLpk.  These vaPACKSWAPccccccccccol10sssLpk.  These vaSWAP_ALPHAcccccccc e2s0ssLpk.  These vaSTRIP_ALPHAccccccc e4s0ssLpk.  These vaINVERT_ALPHAccccccVeessssL;k.  These va ext TRANSFORMcccol10ssssL;k.  These va mu_TO_GRAY_ERRcc e2s0sssL;k.  These va mu_TO_GRAY_WARNc e4s0sssL;k.  These va mu_TO_GRAYccccccVe6s0sssLn trupwo  of ,  mu_TO_GRAY_ERR|WARNcg_pcccccccccccccccccccc n tru hIVeesssssLcc n Un ati_g_pk.  These vaADD_ALPHAccccccc e10sssssLn truendeAT0x0Ti_and-dex 7cg_pcccccccccccccccccccc n tru h e2s0ssssLn un ati_g_pcccccccccccccccccccc n tru h e4s0ssssLn un ati_g_pcccccccccccccccccccc n tru h e8s0ssssLn un ati_g_pcccccccccccccccccccc n tru  e10ssssssLn un ati_g_pcccccccccccccccccccc n tru  e20ssssssLn un ati_g_pcccccccccccccccccccc n tru  e40ssssssLn un ati_g_pstrueuct_def
{TYPErre/
i1.0.6 */g_pk.  These vaSTRUCT_e  ccholdsdhpk.  These vaSTRUCT_INFOcholdsd2pustrScaly */fendrimf(tbaE_REA heuristac wine tind  alcula|| defined.
 */
#defiWEIGHT SHIFTc8ed.
 */
#defiWEIGHT FACTOR (1<<(defiWEIGHT SHIFT)) in row */
  COST SHIFTc3 in row */
  COST FACTOR (1<<(defiCOST SHIFT)) strueuct_def
{    d no_UN->Uuct_dr tRIluinantdeclas pnraoype def
{eachPo  hax;k.  These valLAfrZLIB_CUSTOMaSTRATEGYccccholdsdhpk.  These valLAfrZLIB_CUSTOMaLEVEL hcccccholdsd2pk.  These valLAfrZLIB_CUSTOMabyteLEVEL hccoldsd4Rin row */
  lLAfrZLIB_CUSTOMaWINDOW_BITScholdsd8ed.
 */
#defilLAfrZLIB_CUSTOMabyTHODccccccholds10ed.
 */
#defilLAfrZLIB_FINISHEDcccccccccccholds20ed.
 */
#defilLAfrROW_INIT cccccccccccccccholds40ed.
 */
#defilLAfrlILLER /Fextccccccccccccholds80ed.
 */
#defilLAfrCRC_ANCILLARYa exccccccccoldh00ed.
 */
#defilLAfrCRC_ANCILLARYaNOWARNc u hold20sed.
 */
#defilLAfrCRC_CRITICALt excccccccchold40sed.
 */
#defilLAfrCRC_CRITICALtIGNOREccccccol0esspk.  These valLAfrleMS e PN o cccccccccccccol10sspk.  These valLAfrleMS Tnfo_ o cccccccccccc e2s0sed.
 */
#defilLAfrleMS HISTho cccccccccccccol400sed.
 */
#defilLAfrKEEP These d chtinecccccholesssLpk.  These valLAfrKEEP ThSAFE chtineccccchcol10sssLpk.  These valLAfrLIBRARYaMISMATCH cccccccc e2s0ssLpk.  These valLAfrSTRIP_ERROR_NUMBERecccccc e4s0ssLpk.  These valLAfrSTRIP_ERROR_TEXTgp_RELATIVeessssLpk.  These valLAfrMALLOC_NULLabyteOKccccccc e10ssssLpk.  These valLAfrADD_ALPHAccccccc cccccccc e2s0sssLn truendeAT0x0Ti_and-dex 8hax;k.  These valLAfrSTRIP_ALPHAcccccccccccccc e4s0sssLn truendeAT0x0Ti_and-dex 8hax;                                  tru hIhIVeesssssLccun ati_g_pcccccccccccccccccccc n            tru hIh e10sssssLn un ati_g_pcccccccccccccccccccc n            tru hIh e20sssssLn un ati_g_pcccccccccccccccccccc n            tru hIh e40sssssLn un ati_g_pcccccccccccccccccccc n            tru hIh e80sssssLn un ati_g_pcccccccccccccccccccc n            tru hI e10ssssssLn un ati_g_pcccccccccccccccccccc n            tru hI e20ssssssLn un ati_g_pcccccccccccccccccccc n            tru hI e40ssssssLn un ati_g_psd.
 */
#defilLAfrCRC_ANCILLARYaMASK (t zalLAfrCRC_ANCILLARYa exc|iny nacccccccccccccccccccccc nnnnnnnnnnndefilLAfrCRC_ANCILLARYaNOWARN)
ed.
 */
#defilLAfrCRC_CRITICALtMASK  (t zalLAfrCRC_CRITICALt exc|iny nacccccccccccccccccccccc nnnnnnnnnnndefilLAfrCRC_CRITICALtIGNORE)
ed.
 */
#defilLAfrCRC_MASK  ccccccc  (defilLAfrCRC_ANCILLARYaMASK |iny nacccccccccccccccccccccc nnnnnnnnnnndefilLAfrCRC_CRITICALtMASK) strus /* typ pnrand makeP pdeueasi2 nIoOunderbe/
d_g_psd.
 */
#defiCOLOR_DIST(c1, c2) (abs  eae)((c1).ro fE-  eae)((c2).ro f)i+ ny naabs  eae)((c1).ear!5fE-  eae)((c2).ear!5f)i+ ny naabs  eae)((c1).b;  fE-  eae)((c2).b;  f)) struendeAT0x0Ti_and-dex 6 JBhax;k.  These vaROWBYTES(Nt_si_ of , slatifEny nac((Nt_si_ of ) >= 8 ?Eny nac((slatifE* (((oint */
#32)(Nt_si_ of ))
>> 3))
:Eny nac((c((slatifE* ((oint */
#32)(Nt_si_ of )))i+ 7)
>> 3) ) strue vaOUT_OF_RANGEtramem_le r_b Tfrpng_b Ts outsid*  he6oas sORTredeal-delta..edeal+delta.  EachParguor r  e evng_/
if twice.y na"edeal"rand "delta" ation r  pfnws anf , n32  lutpsimpleORTreae g   , "png_b"ra_variAD_S.uendeAT0x0Ti_and-dex 6 JBhax;k.  These vaOUT_OF_RANGE(bit; ,eedeal, delta)iny naccccc(c(bit; ) <  edeal)-(delta)i||c(bit; ) >  edeal)+(delta)i) struvariAD_SstdeclasS ng_rNSFg_E- ationethton ssO a.  These vaNO_EXTERNcg_p                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     