// SPDX-License-Identifier: GPL-2.0
/*
 * Intel Moorefield SoC pinctrl driver
 *
 * Copyright (C) 2022, Intel Corporation
 * Author: Andy Shevchenko <andriy.shevchenko@linux.intel.com>
 */

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/mod_devicetable.h>
#include <linux/module.h>
#include <linux/platform_device.h>
#include <linux/types.h>

#include <linux/pinctrl/pinctrl.h>

#include "pinctrl-tangier.h"

static const struct pinctrl_pin_desc mofld_pins[] = {
	/* ULPI (13 pins) */
	PINCTRL_PIN(0, "GP101_ULPI_CLK"),
	PINCTRL_PIN(1, "GP136_ULPI_D0"),
	PINCTRL_PIN(2, "GP143_ULPI_D1"),
	PINCTRL_PIN(3, "GP144_ULPI_D2"),
	PINCTRL_PIN(4, "GP145_ULPI_D3"),
	PINCTRL_PIN(5, "GP146_ULPI_D4"),
	PINCTRL_PIN(6, "GP147_ULPI_D5"),
	PINCTRL_PIN(7, "GP148_ULPI_D6"),
	PINCTRL_PIN(8, "GP149_ULPI_D7"),
	PINCTRL_PIN(9, "ULPI_DIR"),
	PINCTRL_PIN(10, "ULPI_NXT"),
	PINCTRL_PIN(11, "ULPI_REFCLK"),
	PINCTRL_PIN(12, "ULPI_STP"),
	/* eMMC (12 pins) */
	PINCTRL_PIN(13, "EMMC_CLK"),
	PINCTRL_PIN(14, "EMMC_CMD"),
	PINCTRL_PIN(15, "EMMC_D0"),
	PINCTRL_PIN(16, "EMMC_D1"),
	PINCTRL_PIN(17, "EMMC_D2"),
	PINCTRL_PIN(18, "EMMC_D3"),
	PINCTRL_PIN(19, "EMMC_D4"),
	PINCTRL_PIN(20, "EMMC_D5"),
	PINCTRL_PIN(21, "EMMC_D6"),
	PINCTRL_PIN(22, "EMMC_D7"),
	PINCTRL_PIN(23, "EMMC_RST_N"),
	PINCTRL_PIN(24, "EMMC_RCLK"),
	/* SDIO (20 pins) */
	PINCTRL_PIN(25, "GP77_SD_CD"),
	PINCTRL_PIN(26, "GP78_SD_CLK"),
	PINCTRL_PIN(27, "GP79_SD_CMD"),
	PINCTRL_PIN(28, "GP80_SD_D0"),
	PINCTRL_PIN(29, "GP81_SD_D1"),
	PINCTRL_PIN(30, "GP82_SD_D2"),
	PINCTRL_PIN(31, "GP83_SD_D3"),
	PINCTRL_PIN(32, "GP84_SD_LS_CLK_FB"),
	PINCTRL_PIN(33, "GP85_SD_LS_CMD_DIR"),
	PINCTRL_PIN(34, "GP86_SD_LS_D_DIR"),
	PINCTRL_PIN(35, "GP88_SD_LS_SEL"),
	PINCTRL_PIN(36, "GP87_SD_PD"),
	PINCTRL_PIN(37, "GP89_SD_WP"),
	PINCTRL_PIN(38, "GP90_SDIO_CLK"),
	PINCTRL_PIN(39, "GP91_SDIO_CMD"),
	PINCTRL_PIN(40, "GP92_SDIO_D0"),
	PINCTRL_PIN(41, "GP93_SDIO_D1"),
	PINCTRL_PIN(42, "GP94_SDIO_D2"),
	PINCTRL_PIN(43, "GP95_SDIO_D3"),
	PINCTRL_PIN(44, "GP96_SDIO_PD"),
	/* HSI (8 pins) */
	PINCTRL_PIN(45, "HSI_ACDATA"),
	PINCTRL_PIN(46, "HSI_ACFLAG"),
	PINCTRL_PIN(47, "HSI_ACREADY"),
	PINCTRL_PIN(48, "HSI_ACWAKE"),
	PINCTRL_PIN(49, "HSI_CADATA"),
	PINCTRL_PIN(50, "HSI_CAFLAG"),
	PINCTRL_PIN(51, "HSI_CAREADY"),
	PINCTRL_PIN(52, "HSI_CAWAKE"),
	/* SSP Audio (14 pins) */
	PINCTRL_PIN(53, "GP70"),
	PINCTRL_PIN(54, "GP71"),
	PINCTRL_PIN(55, "GP32_I2S_0_CLK"),
	PINCTRL_PIN(56, "GP33_I2S_0_FS"),
	PINCTRL_PIN(57, "GP34_I2S_0_RXD"),
	PINCTRL_PIN(58, "GP35_I2S_0_TXD"),
	PINCTRL_PIN(59, "GP36_I2S_1_CLK"),
	PINCTRL_PIN(60, "GP37_I2S_1_FS"),
	PINCTRL_PIN(61, "GP38_I2S_1_RXD"),
	PINCTRL_PIN(62, "GP39_I2S_1_TXD"),
	PINCTRL_PIN(63, "GP40_I2S_2_CLK"),
	PINCTRL_PIN(64, "GP41_I2S_2_FS"),
	PINCTRL_PIN(65, "GP42_I2S_2_RXD"),
	PINCTRL_PIN(66, "GP43_I2S_2_TXD"),
	/* GP SSP (22 pins) */
	PINCTRL_PIN(67, "GP120_SPI_0_CLK"),
	PINCTRL_PIN(68, "GP121_SPI_0_SS"),
	PINCTRL_PIN(69, "GP122_SPI_0_RXD"),
	PINCTRL_PIN(70, "GP123_SPI_0_TXD"),
	PINCTRL_PIN(71, "GP102_SPI_1_CLK"),
	PINCTRL_PIN(72, "GP103_SPI_1_SS0"),
	PINCTRL_PIN(73, "GP104_SPI_1_SS1"),
	PINCTRL_PIN(74, "GP105_SPI_1_SS2"),
	PINCTRL_PIN(75, "GP106_SPI_1_SS3"),
	PINCTRL_PIN(76, "GP107_SPI_1_RXD"),
	PINCTRL_PIN(77, "GP108_SPI_1_TXD"),
	PINCTRL_PIN(78, "GP109_SPI_2_CLK"),
	PINCTRL_PIN(79, "GP110_SPI_2_SS0"),
	PINCTRL_PIN(80, "GP111_SPI_2_SS1"),
	PINCTRL_PIN(81, "GP112_SPI_2_SS2"),
	PINCTRL_PIN(82, "GP113_SPI_2_SS3"),
	PINCTRL_PIN(83, "GP114_SPI_2_RXD"),
	PINCTRL_PIN(84, "GP115_SPI_2_TXD"),
	PINCTRL_PIN(85, "GP116_SPI_3_CLK"),
	PINCTRL_PIN(86, "GP117_SPI_3_SS"),
	PINCTRL_PIN(87, "GP118_SPI_3_RXD"),
	PINCTRL_PIN(88, "GP119_SPI_3_TXD"),
	/* I2C (20 pins) */
	PINCTRL_PIN(89, "I2C_0_SCL"),
	PINCTRL_PIN(90, "I2C_0_SDA"),
	PINCTRL_PIN(91, "GP19_I2C_1_SCL"),
	PINCTRL_PIN(92, "GP20_I2C_1_SDA"),
	PINCTRL_PIN(93, "GP21_I2C_2_SCL"),
	PINCTRL_PIN(94, "GP22_I2C_2_SDA"),
	PINCTRL_PIN(95, "GP17_I2C_3_SCL_HDMI"),
	PINCTRL_PIN(96, "GP18_I2C_3_SDA_HDMI"),
	PINCTRL_PIN(97, "GP23_I2C_4_SCL"),
	PINCTRL_PIN(98, "GP24_I2C_4_SDA"),
	PINCTRL_PIN(99, "GP25_I2C_5_SCL"),
	PINCTRL_PIN(100, "GP26_I2C_5_SDA"),
	PINCTRL_PIN(101, "GP27_I2C_6_SCL"),
	PINCTRL_PIN(102, "GP28_I2C_6_SDA"),
	PINCTRL_PIN(103, "GP29_I2C_7_SCL"),
	PINCTRL_PIN(104, "GP30_I2C_7_SDA"),
	PINCTRL_PIN(105, "I2C_8_SCL"),
	PINCTRL_PIN(106, "I2C_8_SDA"),
	PINCTRL_PIN(107, "I2C_9_SCL"),
	PINCTRL_PIN(108, "I2C_9_SDA"),
	/* UART (23 pins) */
	PINCTRL_PIN(109, "GP124_UART_0_CTS"),
	PINCTRL_PIN(110, "GP125_UART_0_RTS"),
	PINCTRL_PIN(111, "GP126_UART_0_RX"),
	PINCTRL_PIN(112, "GP127_UART_0_TX"),
	PINCTRL_PIN(113, "GP128_UART_1_CTS"),
	PINCTRL_PIN(114, "GP129_UART_1_RTS"),
	PINCTRL_PIN(115, "GP130_UART_1_RX"),
	PINCTRL_PIN(116, "GP131_UART_1_TX"),
	PINCTRL_PIN(117, "GP132_UART_2_CTS"),
	PINCTRL_PIN(118, "GP133_UART_2_RTS"),
	PINCTRL_PIN(119, "GP134_UART_2_RX"),
	PINCTRL_PIN(120, "GP135_UART_2_TX"),
	PINCTRL_PIN(121, "GP97"),
	PINCTRL_PIN(122, "GP154"),
	PINCTRL_PIN(123, "GP155"),
	PINCTRL_PIN(124, "GP156"),
	PINCTRL_PIN(125, "GP157"),
	PINCTRL_PIN(126, "GP158"),
	PINCTRL_PIN(127, "GP159"),
	PINCTRL_PIN(128, "GP160"),
	PINCTRL_PIN(129, "GP161"),
	PINCTRL_PIN(130, "GP12_PWM0"),
	PINCTRL_PIN(131, "GP13_PWM1"),
	/* GPIO South (20 pins) */
	PINCTRL_PIN(132, "GP176"),
	PINCTRL_PIN(133, "GP177"),
	PINCTRL_PIN(134, "GP178"),
	PINCTRL_PIN(135, "GP179"),
	PINCTRL_PIN(136, "GP180"),
	PINCTRL_PIN(137, "GP181"),
	PINCTRL_PIN(138, "GP182_PWM2"),
	PINCTRL_PIN(139, "GP183_PWM3"),
	PINCTRL_PIN(140, "GP184"),
	PINCTRL_PIN(141, "GP185"),
	PINCTRL_PIN(142, "GP186"),
	PINCTRL_PIN(143, "GP187"),
	PINCTRL_PIN(144, "GP188"),
	PINCTRL_PIN(145, "GP189"),
	PINCTRL_PIN(146, "GP190"),
	PINCTRL_PIN(147, "GP191"),
	PINCTRL_PIN(148, "GP14"),
	PINCTRL_PIN(149, "GP15"),
	PINCTRL_PIN(150, "GP162"),
	PINCTRL_PIN(151, "GP163"),
	/* Camera Sideband (15 pins) */
	PINCTRL_PIN(152, "GP0"),
	PINCTRL_PIN(153, "GP1"),
	PINCTRL_PIN(154, "GP2"),
	PINCTRL_PIN(155, "GP3"),
	PINCTRL_PIN(156, "GP4"),
	PINCTRL_PIN(157, "GP5"),
	PINCTRL_PIN(158, "GP6"),
	PINCTRL_PIN(159, "GP7"),
	PINCTRL_PIN(160, "GP8"),
	PINCTRL_PIN(161, "GP9"),
	PINCTRL_PIN(162, "GP10"),
	PINCTRL_PIN(163, "GP11"),
	PINCTRL_PIN(164, "GP16_HDMI_HPD"),
	PINCTRL_PIN(165, "GP68_DSI_A_TE"),
	PINCTRL_PIN(166, "GP69_DSI_C_TE"),
	/* Clock (14 pins) */
	PINCTRL_PIN(167, "GP137"),
	PINCTRL_PIN(168, "GP138"),
	PINCTRL_PIN(169, "GP139"),
	PINCTRL_PIN(170, "GP140"),
	PINCTRL_PIN(171, "GP141"),
	PINCTRL_PIN(172, "GP142"),
	PINCTRL_PIN(173, "GP98"),
	PINCTRL_PIN(174, "OSC_CLK_CTRL0"),
	PINCTRL_PIN(175, "OSC_CLK_CTRL1"),
	PINCTRL_PIN(176, "OSC_CLK0"),
	PINCTRL_PIN(177, "OSC_CLK1"),
	PINCTRL_PIN(178, "OSC_CLK2"),
	PINCTRL_PIN(179, "OSC_CLK3"),
	PINCTRL_PIN(180, "OSC_CLK4"),
	/* PMIC (15 pins) */
	PINCTRL_PIN(181, "PROCHOT"),
	PINCTRL_PIN(182, "RESETOUT"),
	PINCTRL_PIN(183, "RTC_CLK"),
	PINCTRL_PIN(184, "STANDBY"),
	PINCTRL_PIN(185, "SVID_ALERT"),
	PINCTRL_PIN(186, "SVID_CLK"),
	PINCTRL_PIN(187, "SVID_D"),
	PINCTRL_PIN(188, "THERMTRIP"),
	PINCTRL_PIN(189, "PREQ"),
	PINCTRL_PIN(190, "ZQ_A"),
	PINCTRL_PIN(191, "ZQ_B"),
	PINCTRL_PIN(192, "GP64_FAST_INT0"),
	PINCTRL_PIN(193, "GP65_FAST_INT1"),
	PINCTRL_PIN(194, "GP66_FAST_INT2"),
	PINCTRL_PIN(195, "GP67_FAST_INT3"),
	/* Keyboard (20 pins) */
	PINCTRL_PIN(196, "GP44"),
	PINCTRL_PIN(197, "GP45"),
	PINCTRL_PIN(198, "GP46"),
	PINCTRL_PIN(199, "GP47"),
	PINCTRL_PIN(200, "GP48"),
	PINCTRL_PIN(201, "GP49"),
	PINCTRL_PIN(202, "GP50"),
	PINCTRL_PIN(203, "GP51"),
	PINCTRL_PIN(204, "GP52"),
	PINCTRL_PIN(205, "GP53"),
	PINCTRL_PIN(206, "GP54"),
	PINCTRL_PIN(207, "GP55"),
	PINCTRL_PIN(208, "GP56"),
	PINCTRL_PIN(209, "GP57"),
	PINCTRL_PIN(210, "GP58"),
	PINCTRL_PIN(211, "GP59"),
	PINCTRL_PIN(212, "GP60"),
	PINCTRL_PIN(213, "GP61"),
	PINCTRL_PIN(214, "GP62"),
	PINCTRL_PIN(215, "GP63"),
	/* GPIO North (13 pins) */
	PINCTRL_PIN(216, "GP164"),
	PINCTRL_PIN(217, "GP165"),
	PINCTRL_PIN(218, "GP166"),
	PINCTRL_PIN(219, "GP167"),
	PINCTRL_PIN(220, "GP168_MJTAG_TCK"),
	PINCTRL_PIN(221, "GP169_MJTAG_TDI"),
	PINCTRL_PIN(222, "GP170_MJTAG_TDO"),
	PINCTRL_PIN(223, "GP171_MJTAG_TMS"),
	PINCTRL_PIN(224, "GP172_MJTAG_TRST"),
	PINCTRL_PIN(225, "GP173"),
	PINCTRL_PIN(226, "GP174"),
	PINCTRL_PIN(227, "GP175"),
	PINCTRL_PIN(228, "GP176"),
	/* PTI (22 pins) */
	PINCTRL_PIN(229, "GP72_PTI_CLK"),
	PINCTRL_PIN(230, "GP73_PTI_D0"),
	PINCTRL_PIN(231, "GP74_PTI_D1"),
	PINCTRL_PIN(232, "GP75_PTI_D2"),
	PINCTRL_PIN(233, "GP76_PTI_D3"),
	PINCTRL_PIN(234, "GP164"),
	PINCTRL_PIN(235, "GP165"),
	PINCTRL_PIN(236, "GP166"),
	PINCTRL_PIN(237, "GP167"),
	PINCTRL_PIN(238, "GP168_MJTAG_TCK"),
	PINCTRL_PIN(239, "GP169_MJTAG_TDI"),
	PINCTRL_PIN(240, "GP170_MJTAG_TDO"),
	PINCTRL_PIN(241, "GP171_MJTAG_TMS"),
	PINCTRL_PIN(242, "GP172_MJTAG_TRST"),
	PINCTRL_PIN(243, "GP173"),
	PINCTRL_PIN(244, "GP174"),
	PINCTRL_PIN(245, "GP175"),
	PINCTRL_PIN(246, "JTAG_TCK"),
	PINCTRL_PIN(247, "JTAG_TDI"),
	PINCTRL_PIN(248, "JTAG_TDO"),
	PINCTRL_PIN(249, "JTAG_TMS"),
	PINCTRL_PIN(250, "JTAG_TRST"),
};

static const struct tng_family mofld_families[] = {
	TNG_FAMILY(0, 0, 12),
	TNG_FAMILY(1, 13, 24),
	TNG_FAMILY(2, 25, 44),
	TNG_FAMILY(3, 45, 52),
	TNG_FAMILY(4, 53, 66),
	TNG_FAMILY(5, 67, 88),
	TNG_FAMILY(6, 89, 108),
	TNG_FAMILY(7, 109, 131),
	TNG_FAMILY(8, 132, 151),
	TNG_FAMILY(9, 152, 166),
	TNG_FAMILY(10, 167, 180),
	TNG_FAMILY(11, 181, 195),
	TNG_FAMILY(12, 196, 215),
	TNG_FAMILY(13, 216, 228),
	TNG_FAMILY(14, 229, 250),
};

static const struct tng_pinctrl mofld_soc_data = {
	.pins = mofld_pins,
	.npins = ARRAY_SIZE(mofld_pins),
	.families = mofld_families,
	.nfamilies = ARRAY_SIZE(mofld_families),
};

static const struct acpi_device_id mofld_acpi_table[] = {
	{ "INTC1003", (kernel_ulong_t)&mofld_soc_data },
	{ }
};
MODULE_DEVICE_TABLE(acpi, mofld_acpi_table);

static struct platform_driver mofld_pinctrl_driver = {
	.probe = devm_tng_pinctrl_probe,
	.driver = {
		.name = "pinctrl-moorefield",
		.acpi_match_table = mofld_acpi_table,
	},
};

static int __init mofld_pinctrl_init(void)
{
	return platform_driver_register(&mofld_pinctrl_driver);
}
subsys_initcall(mofld_pinctrl_init);

static void __exit mofld_pinctrl_exit(void)
{
	platform_driver_unregister(&mofld_pinctrl_driver);
}
module_exit(mofld_pinctrl_exit);

MODULE_AUTHOR("Andy Shevchenko <andriy.shevchenko@linux.intel.com>");
MODULE_DESCRIPTION("Intel Moorefield SoC pinctrl driver");
MODULE_LICENSE("GPL v2");
MODULE_ALIAS("platform:pinctrl-moorefield");
MODULE_IMPORT_NS(PINCTRL_TANGIER);
