/* SPDX-License-Identifier: GPL-2.0-or-later */
/* Copyright (c) 2024 Hisilicon Limited. */

#ifndef DP_REG_H
#define DP_REG_H

#define HIBMC_DP_AUX_CMD_ADDR			0x50
#define HIBMC_DP_AUX_WR_DATA0			0x54
#define HIBMC_DP_AUX_WR_DATA1			0x58
#define HIBMC_DP_AUX_WR_DATA2			0x5c
#define HIBMC_DP_AUX_WR_DATA3			0x60
#define HIBMC_DP_AUX_RD_DATA0			0x64
#define HIBMC_DP_AUX_REQ			0x74
#define HIBMC_DP_AUX_STATUS			0x78
#define HIBMC_DP_PHYIF_CTRL0			0xa0
#define HIBMC_DP_VIDEO_CTRL			0x100
#define HIBMC_DP_VIDEO_CONFIG0			0x104
#define HIBMC_DP_VIDEO_CONFIG1			0x108
#define HIBMC_DP_VIDEO_CONFIG2			0x10c
#define HIBMC_DP_VIDEO_CONFIG3			0x110
#define HIBMC_DP_VIDEO_PACKET			0x114
#define HIBMC_DP_VIDEO_MSA0			0x118
#define HIBMC_DP_VIDEO_MSA1			0x11c
#define HIBMC_DP_VIDEO_MSA2			0x120
#define HIBMC_DP_VIDEO_HORIZONTAL_SIZE		0X124
#define HIBMC_DP_TIMING_GEN_CONFIG0		0x26c
#define HIBMC_DP_TIMING_GEN_CONFIG2		0x274
#define HIBMC_DP_TIMING_GEN_CONFIG3		0x278
#define HIBMC_DP_HDCP_CFG			0x600
#define HIBMC_DP_DPTX_RST_CTRL			0x700
#define HIBMC_DP_DPTX_CLK_CTRL			0x704
#define HIBMC_DP_DPTX_GCTL0			0x708
#define HIBMC_DP_INTR_ENABLE			0x720
#define HIBMC_DP_INTR_ORIGINAL_STATUS		0x728
#define HIBMC_DP_TIMING_MODEL_CTRL		0x884
#define HIBMC_DP_TIMING_SYNC_CTRL		0xFF0

#define HIBMC_DP_CFG_AUX_SYNC_LEN_SEL		BIT(1)
#define HIBMC_DP_CFG_AUX_TIMER_TIMEOUT		BIT(2)
#define HIBMC_DP_CFG_STREAM_FRAME_MODE		BIT(6)
#define HIBMC_DP_CFG_AUX_MIN_PULSE_NUM		GENMASK(13, 9)
#define HIBMC_DP_CFG_LANE_DATA_EN		GENMASK(11, 8)
#define HIBMC_DP_CFG_PHY_LANE_NUM		GENMASK(2, 1)
#define HIBMC_DP_CFG_AUX_REQ			BIT(0)
#define HIBMC_DP_CFG_AUX_RST_N			BIT(4)
#define HIBMC_DP_CFG_AUX_TIMEOUT		BIT(0)
#define HIBMC_DP_CFG_AUX_READY_DATA_BYTE	GENMASK(16, 12)
#define HIBMC_DP_CFG_AUX			GENMASK(24, 17)
#define HIBMC_DP_CFG_AUX_STATUS			GENMASK(11, 4)
#define HIBMC_DP_CFG_SCRAMBLE_EN		BIT(0)
#define HIBMC_DP_CFG_PAT_SEL			GENMASK(7, 4)
#define HIBMC_DP_CFG_TIMING_GEN0_HACTIVE	GENMASK(31, 16)
#define HIBMC_DP_CFG_TIMING_GEN0_HBLANK		GENMASK(15, 0)
#define HIBMC_DP_CFG_TIMING_GEN0_VACTIVE	GENMASK(31, 16)
#define HIBMC_DP_CFG_TIMING_GEN0_VBLANK		GENMASK(15, 0)
#define HIBMC_DP_CFG_TIMING_GEN0_VFRONT_PORCH	GENMASK(31, 16)
#define HIBMC_DP_CFG_STREAM_HACTIVE		GENMASK(31, 16)
#define HIBMC_DP_CFG_STREAM_HBLANK		GENMASK(15, 0)
#define HIBMC_DP_CFG_STREAM_HSYNC_WIDTH		GENMASK(15, 0)
#define HIBMC_DP_CFG_STREAM_VACTIVE		GENMASK(31, 16)
#define HIBMC_DP_CFG_STREAM_VBLANK		GENMASK(15, 0)
#define HIBMC_DP_CFG_STREAM_VFRONT_PORCH	GENMASK(31, 16)
#define HIBMC_DP_CFG_STREAM_VSYNC_WIDTH		GENMASK(15, 0)
#define HIBMC_DP_CFG_STREAM_VSTART		GENMASK(31, 16)
#define HIBMC_DP_CFG_STREAM_HSTART		GENMASK(15, 0)
#define HIBMC_DP_CFG_STREAM_VSYNC_POLARITY	BIT(8)
#define HIBMC_DP_CFG_STREAM_HSYNC_POLARITY	BIT(7)
#define HIBMC_DP_CFG_STREAM_RGB_ENABLE		BIT(1)
#define HIBMC_DP_CFG_STREAM_VIDEO_MAPPING	GENMASK(5, 2)
#define HIBMC_DP_CFG_PIXEL_NUM_TIMING_MODE_SEL1	GENMASK(31, 16)
#define HIBMC_DP_CFG_STREAM_TU_SYMBOL_SIZE	GENMASK(5, 0)
#define HIBMC_DP_CFG_STREAM_TU_SYMBOL_FRAC_SIZE	GENMASK(9, 6)
#define HIBMC_DP_CFG_STREAM_HTOTAL_SIZE		GENMASK(31, 16)
#define HIBMC_DP_CFG_STREAM_HBLANK_SIZE		GENMASK(15, 0)

#endif
