# perf script event handlers, generated by perf script -g python
# (c) 2010, Tom Zanussi <tzanussi@gmail.com>
# Licensed under the terms of the GNU GPL License version 2
#
# This script tests basic functionality such as flag and symbol
# strings, common_xxx() calls back into perf, begin, end, unhandled
# events, etc.  Basically, if this script runs successfully and
# displays expected results, Python scripting support should be ok.

from __future__ import print_function

import os
import sys

sys.path.append(os.environ['PERF_EXEC_PATH'] + \
	'/scripts/python/Perf-Trace-Util/lib/Perf/Trace')

from Core import *
from perf_trace_context import *

unhandled = autodict()

def trace_begin():
	print("trace_begin")
	pass

def trace_end():
	print_unhandled()

def irq__softirq_entry(event_name, context, common_cpu,
		       common_secs, common_nsecs, common_pid, common_comm,
		       common_callchain, vec):
	print_header(event_name, common_cpu, common_secs, common_nsecs,
		common_pid, common_comm)

	print_uncommon(context)

	print("vec=%s" % (symbol_str("irq__softirq_entry", "vec", vec)))

def kmem__kmalloc(event_name, context, common_cpu,
		  common_secs, common_nsecs, common_pid, common_comm,
		  common_callchain, call_site, ptr, bytes_req, bytes_alloc,
		  gfp_flags):
	print_header(event_name, common_cpu, common_secs, common_nsecs,
		common_pid, common_comm)

	print_uncommon(context)

	print("call_site=%u, ptr=%u, bytes_req=%u, "
		"bytes_alloc=%u, gfp_flags=%s" %
		(call_site, ptr, bytes_req, bytes_alloc,
		flag_str("kmem__kmalloc", "gfp_flags", gfp_flags)))

def trace_unhandled(event_name, context, event_fields_dict):
	try:
		unhandled[event_name] += 1
	except TypeError:
		unhandled[event_name] = 1

def print_header(event_name, cpu, secs, nsecs, pid, comm):
	print("%-20s %5u %05u.%09u %8u %-20s " %
		(event_name, cpu, secs, nsecs, pid, comm),
		end=' ')

# print trace fields not included in handler args
def print_uncommon(context):
	print("common_preempt_count=%d, common_flags=%s, "
		"common_lock_depth=%d, " %
		(common_pc(context), trace_flag_str(common_flags(context)),
		common_lock_depth(context)))

def print_unhandled():
	keys = unhandled.keys()
	if not keys:
		return

	print("\nunhandled events:\n")

	print("%-40s  %10s" % ("event", "count"))
	print("%-40s  %10s" % ("----------------------------------------",
				"-----------"))

	for event_name in keys:
		print("%-40s  %10d\n" % (event_name, unhandled[event_name]))
