/* This define is BFD_RELOC_##x for real bfd, or -1 for everyone else. */
#define BFD_RELOC(x) -1

/* Special registers. */
#define TREG_LR 55
#define TREG_SN 56
#define TREG_ZERO 63

/* FIXME: Rename this. */
#include <asm/opcode-tile.h>

#include <linux/stddef.h>

const struct tile_opcode tile_opcodes[395] =
{
 { "bpt", TILE_OPC_BPT, 0x2, 0, TREG_ZERO, 0,
    { { 0, }, {  }, { 0, }, { 0, }, { 0, } },
  },
  { "info", TILE_OPC_INFO, 0xf, 1, TREG_ZERO, 1,
    { { 0 }, { 1 }, { 2 }, { 3 }, { 0, } },
  },
  { "infol", TILE_OPC_INFOL, 0x3, 1, TREG_ZERO, 1,
    { { 4 }, { 5 }, { 0, }, { 0, }, { 0, } },
  },
  { "j", TILE_OPC_J, 0x2, 1, TREG_ZERO, 1,
    { { 0, }, { 6 }, { 0, }, { 0, }, { 0, } },
  },
  { "jal", TILE_OPC_JAL, 0x2, 1, TREG_LR, 1,
    { { 0, }, { 6 }, { 0, }, { 0, }, { 0, } },
  },
  { "move", TILE_OPC_MOVE, 0xf, 2, TREG_ZERO, 1,
    { { 7, 8 }, { 9, 10 }, { 11, 12 }, { 13, 14 }, { 0, } },
  },
  { "move.sn", TILE_OPC_MOVE_SN, 0x3, 2, TREG_SN, 1,
    { { 7, 8 }, { 9, 10 }, { 0, }, { 0, }, { 0, } },
  },
  { "movei", TILE_OPC_MOVEI, 0xf, 2, TREG_ZERO, 1,
    { { 7, 0 }, { 9, 1 }, { 11, 2 }, { 13, 3 }, { 0, } },
  },
  { "movei.sn", TILE_OPC_MOVEI_SN, 0x3, 2, TREG_SN, 1,
    { { 7, 0 }, { 9, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "moveli", TILE_OPC_MOVELI, 0x3, 2, TREG_ZERO, 1,
    { { 7, 4 }, { 9, 5 }, { 0, }, { 0, }, { 0, } },
  },
  { "moveli.sn", TILE_OPC_MOVELI_SN, 0x3, 2, TREG_SN, 1,
    { { 7, 4 }, { 9, 5 }, { 0, }, { 0, }, { 0, } },
  },
  { "movelis", TILE_OPC_MOVELIS, 0x3, 2, TREG_SN, 1,
    { { 7, 4 }, { 9, 5 }, { 0, }, { 0, }, { 0, } },
  },
  { "prefetch", TILE_OPC_PREFETCH, 0x12, 1, TREG_ZERO, 1,
    { { 0, }, { 10 }, { 0, }, { 0, }, { 15 } },
  },
  { "raise", TILE_OPC_RAISE, 0x2, 0, TREG_ZERO, 1,
    { { 0, }, {  }, { 0, }, { 0, }, { 0, } },
  },
  { "add", TILE_OPC_ADD, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 11, 12, 18 }, { 13, 14, 19 }, { 0, } },
  },
  { "add.sn", TILE_OPC_ADD_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "addb", TILE_OPC_ADDB, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "addb.sn", TILE_OPC_ADDB_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "addbs_u", TILE_OPC_ADDBS_U, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "addbs_u.sn", TILE_OPC_ADDBS_U_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "addh", TILE_OPC_ADDH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "addh.sn", TILE_OPC_ADDH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "addhs", TILE_OPC_ADDHS, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "addhs.sn", TILE_OPC_ADDHS_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "addi", TILE_OPC_ADDI, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 11, 12, 2 }, { 13, 14, 3 }, { 0, } },
  },
  { "addi.sn", TILE_OPC_ADDI_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "addib", TILE_OPC_ADDIB, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "addib.sn", TILE_OPC_ADDIB_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "addih", TILE_OPC_ADDIH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "addih.sn", TILE_OPC_ADDIH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "addli", TILE_OPC_ADDLI, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 4 }, { 9, 10, 5 }, { 0, }, { 0, }, { 0, } },
  },
  { "addli.sn", TILE_OPC_ADDLI_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 4 }, { 9, 10, 5 }, { 0, }, { 0, }, { 0, } },
  },
  { "addlis", TILE_OPC_ADDLIS, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 4 }, { 9, 10, 5 }, { 0, }, { 0, }, { 0, } },
  },
  { "adds", TILE_OPC_ADDS, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "adds.sn", TILE_OPC_ADDS_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "adiffb_u", TILE_OPC_ADIFFB_U, 0x1, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "adiffb_u.sn", TILE_OPC_ADIFFB_U_SN, 0x1, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "adiffh", TILE_OPC_ADIFFH, 0x1, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "adiffh.sn", TILE_OPC_ADIFFH_SN, 0x1, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "and", TILE_OPC_AND, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 11, 12, 18 }, { 13, 14, 19 }, { 0, } },
  },
  { "and.sn", TILE_OPC_AND_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "andi", TILE_OPC_ANDI, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 11, 12, 2 }, { 13, 14, 3 }, { 0, } },
  },
  { "andi.sn", TILE_OPC_ANDI_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "auli", TILE_OPC_AULI, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 4 }, { 9, 10, 5 }, { 0, }, { 0, }, { 0, } },
  },
  { "avgb_u", TILE_OPC_AVGB_U, 0x1, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "avgb_u.sn", TILE_OPC_AVGB_U_SN, 0x1, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "avgh", TILE_OPC_AVGH, 0x1, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "avgh.sn", TILE_OPC_AVGH_SN, 0x1, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "bbns", TILE_OPC_BBNS, 0x2, 2, TREG_ZERO, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bbns.sn", TILE_OPC_BBNS_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bbnst", TILE_OPC_BBNST, 0x2, 2, TREG_ZERO, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bbnst.sn", TILE_OPC_BBNST_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bbs", TILE_OPC_BBS, 0x2, 2, TREG_ZERO, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bbs.sn", TILE_OPC_BBS_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bbst", TILE_OPC_BBST, 0x2, 2, TREG_ZERO, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bbst.sn", TILE_OPC_BBST_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bgez", TILE_OPC_BGEZ, 0x2, 2, TREG_ZERO, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bgez.sn", TILE_OPC_BGEZ_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bgezt", TILE_OPC_BGEZT, 0x2, 2, TREG_ZERO, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bgezt.sn", TILE_OPC_BGEZT_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bgz", TILE_OPC_BGZ, 0x2, 2, TREG_ZERO, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bgz.sn", TILE_OPC_BGZ_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bgzt", TILE_OPC_BGZT, 0x2, 2, TREG_ZERO, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bgzt.sn", TILE_OPC_BGZT_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bitx", TILE_OPC_BITX, 0x5, 2, TREG_ZERO, 1,
    { { 7, 8 }, { 0, }, { 11, 12 }, { 0, }, { 0, } },
  },
  { "bitx.sn", TILE_OPC_BITX_SN, 0x1, 2, TREG_SN, 1,
    { { 7, 8 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "blez", TILE_OPC_BLEZ, 0x2, 2, TREG_ZERO, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "blez.sn", TILE_OPC_BLEZ_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "blezt", TILE_OPC_BLEZT, 0x2, 2, TREG_ZERO, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "blezt.sn", TILE_OPC_BLEZT_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "blz", TILE_OPC_BLZ, 0x2, 2, TREG_ZERO, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "blz.sn", TILE_OPC_BLZ_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "blzt", TILE_OPC_BLZT, 0x2, 2, TREG_ZERO, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "blzt.sn", TILE_OPC_BLZT_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bnz", TILE_OPC_BNZ, 0x2, 2, TREG_ZERO, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bnz.sn", TILE_OPC_BNZ_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bnzt", TILE_OPC_BNZT, 0x2, 2, TREG_ZERO, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bnzt.sn", TILE_OPC_BNZT_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bytex", TILE_OPC_BYTEX, 0x5, 2, TREG_ZERO, 1,
    { { 7, 8 }, { 0, }, { 11, 12 }, { 0, }, { 0, } },
  },
  { "bytex.sn", TILE_OPC_BYTEX_SN, 0x1, 2, TREG_SN, 1,
    { { 7, 8 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "bz", TILE_OPC_BZ, 0x2, 2, TREG_ZERO, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bz.sn", TILE_OPC_BZ_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bzt", TILE_OPC_BZT, 0x2, 2, TREG_ZERO, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "bzt.sn", TILE_OPC_BZT_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 10, 20 }, { 0, }, { 0, }, { 0, } },
  },
  { "clz", TILE_OPC_CLZ, 0x5, 2, TREG_ZERO, 1,
    { { 7, 8 }, { 0, }, { 11, 12 }, { 0, }, { 0, } },
  },
  { "clz.sn", TILE_OPC_CLZ_SN, 0x1, 2, TREG_SN, 1,
    { { 7, 8 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "crc32_32", TILE_OPC_CRC32_32, 0x1, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "crc32_32.sn", TILE_OPC_CRC32_32_SN, 0x1, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "crc32_8", TILE_OPC_CRC32_8, 0x1, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "crc32_8.sn", TILE_OPC_CRC32_8_SN, 0x1, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "ctz", TILE_OPC_CTZ, 0x5, 2, TREG_ZERO, 1,
    { { 7, 8 }, { 0, }, { 11, 12 }, { 0, }, { 0, } },
  },
  { "ctz.sn", TILE_OPC_CTZ_SN, 0x1, 2, TREG_SN, 1,
    { { 7, 8 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "drain", TILE_OPC_DRAIN, 0x2, 0, TREG_ZERO, 0,
    { { 0, }, {  }, { 0, }, { 0, }, { 0, } },
  },
  { "dtlbpr", TILE_OPC_DTLBPR, 0x2, 1, TREG_ZERO, 1,
    { { 0, }, { 10 }, { 0, }, { 0, }, { 0, } },
  },
  { "dword_align", TILE_OPC_DWORD_ALIGN, 0x1, 3, TREG_ZERO, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "dword_align.sn", TILE_OPC_DWORD_ALIGN_SN, 0x1, 3, TREG_SN, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "finv", TILE_OPC_FINV, 0x2, 1, TREG_ZERO, 1,
    { { 0, }, { 10 }, { 0, }, { 0, }, { 0, } },
  },
  { "flush", TILE_OPC_FLUSH, 0x2, 1, TREG_ZERO, 1,
    { { 0, }, { 10 }, { 0, }, { 0, }, { 0, } },
  },
  { "fnop", TILE_OPC_FNOP, 0xf, 0, TREG_ZERO, 1,
    { {  }, {  }, {  }, {  }, { 0, } },
  },
  { "icoh", TILE_OPC_ICOH, 0x2, 1, TREG_ZERO, 1,
    { { 0, }, { 10 }, { 0, }, { 0, }, { 0, } },
  },
  { "ill", TILE_OPC_ILL, 0xa, 0, TREG_ZERO, 1,
    { { 0, }, {  }, { 0, }, {  }, { 0, } },
  },
  { "inthb", TILE_OPC_INTHB, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "inthb.sn", TILE_OPC_INTHB_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "inthh", TILE_OPC_INTHH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "inthh.sn", TILE_OPC_INTHH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "intlb", TILE_OPC_INTLB, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "intlb.sn", TILE_OPC_INTLB_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "intlh", TILE_OPC_INTLH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "intlh.sn", TILE_OPC_INTLH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "inv", TILE_OPC_INV, 0x2, 1, TREG_ZERO, 1,
    { { 0, }, { 10 }, { 0, }, { 0, }, { 0, } },
  },
  { "iret", TILE_OPC_IRET, 0x2, 0, TREG_ZERO, 1,
    { { 0, }, {  }, { 0, }, { 0, }, { 0, } },
  },
  { "jalb", TILE_OPC_JALB, 0x2, 1, TREG_LR, 1,
    { { 0, }, { 22 }, { 0, }, { 0, }, { 0, } },
  },
  { "jalf", TILE_OPC_JALF, 0x2, 1, TREG_LR, 1,
    { { 0, }, { 22 }, { 0, }, { 0, }, { 0, } },
  },
  { "jalr", TILE_OPC_JALR, 0x2, 1, TREG_LR, 1,
    { { 0, }, { 10 }, { 0, }, { 0, }, { 0, } },
  },
  { "jalrp", TILE_OPC_JALRP, 0x2, 1, TREG_LR, 1,
    { { 0, }, { 10 }, { 0, }, { 0, }, { 0, } },
  },
  { "jb", TILE_OPC_JB, 0x2, 1, TREG_ZERO, 1,
    { { 0, }, { 22 }, { 0, }, { 0, }, { 0, } },
  },
  { "jf", TILE_OPC_JF, 0x2, 1, TREG_ZERO, 1,
    { { 0, }, { 22 }, { 0, }, { 0, }, { 0, } },
  },
  { "jr", TILE_OPC_JR, 0x2, 1, TREG_ZERO, 1,
    { { 0, }, { 10 }, { 0, }, { 0, }, { 0, } },
  },
  { "jrp", TILE_OPC_JRP, 0x2, 1, TREG_ZERO, 1,
    { { 0, }, { 10 }, { 0, }, { 0, }, { 0, } },
  },
  { "lb", TILE_OPC_LB, 0x12, 2, TREG_ZERO, 1,
    { { 0, }, { 9, 10 }, { 0, }, { 0, }, { 23, 15 } },
  },
  { "lb.sn", TILE_OPC_LB_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 9, 10 }, { 0, }, { 0, }, { 0, } },
  },
  { "lb_u", TILE_OPC_LB_U, 0x12, 2, TREG_ZERO, 1,
    { { 0, }, { 9, 10 }, { 0, }, { 0, }, { 23, 15 } },
  },
  { "lb_u.sn", TILE_OPC_LB_U_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 9, 10 }, { 0, }, { 0, }, { 0, } },
  },
  { "lbadd", TILE_OPC_LBADD, 0x2, 3, TREG_ZERO, 1,
    { { 0, }, { 9, 24, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "lbadd.sn", TILE_OPC_LBADD_SN, 0x2, 3, TREG_SN, 1,
    { { 0, }, { 9, 24, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "lbadd_u", TILE_OPC_LBADD_U, 0x2, 3, TREG_ZERO, 1,
    { { 0, }, { 9, 24, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "lbadd_u.sn", TILE_OPC_LBADD_U_SN, 0x2, 3, TREG_SN, 1,
    { { 0, }, { 9, 24, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "lh", TILE_OPC_LH, 0x12, 2, TREG_ZERO, 1,
    { { 0, }, { 9, 10 }, { 0, }, { 0, }, { 23, 15 } },
  },
  { "lh.sn", TILE_OPC_LH_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 9, 10 }, { 0, }, { 0, }, { 0, } },
  },
  { "lh_u", TILE_OPC_LH_U, 0x12, 2, TREG_ZERO, 1,
    { { 0, }, { 9, 10 }, { 0, }, { 0, }, { 23, 15 } },
  },
  { "lh_u.sn", TILE_OPC_LH_U_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 9, 10 }, { 0, }, { 0, }, { 0, } },
  },
  { "lhadd", TILE_OPC_LHADD, 0x2, 3, TREG_ZERO, 1,
    { { 0, }, { 9, 24, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "lhadd.sn", TILE_OPC_LHADD_SN, 0x2, 3, TREG_SN, 1,
    { { 0, }, { 9, 24, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "lhadd_u", TILE_OPC_LHADD_U, 0x2, 3, TREG_ZERO, 1,
    { { 0, }, { 9, 24, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "lhadd_u.sn", TILE_OPC_LHADD_U_SN, 0x2, 3, TREG_SN, 1,
    { { 0, }, { 9, 24, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "lnk", TILE_OPC_LNK, 0x2, 1, TREG_ZERO, 1,
    { { 0, }, { 9 }, { 0, }, { 0, }, { 0, } },
  },
  { "lnk.sn", TILE_OPC_LNK_SN, 0x2, 1, TREG_SN, 1,
    { { 0, }, { 9 }, { 0, }, { 0, }, { 0, } },
  },
  { "lw", TILE_OPC_LW, 0x12, 2, TREG_ZERO, 1,
    { { 0, }, { 9, 10 }, { 0, }, { 0, }, { 23, 15 } },
  },
  { "lw.sn", TILE_OPC_LW_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 9, 10 }, { 0, }, { 0, }, { 0, } },
  },
  { "lw_na", TILE_OPC_LW_NA, 0x2, 2, TREG_ZERO, 1,
    { { 0, }, { 9, 10 }, { 0, }, { 0, }, { 0, } },
  },
  { "lw_na.sn", TILE_OPC_LW_NA_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 9, 10 }, { 0, }, { 0, }, { 0, } },
  },
  { "lwadd", TILE_OPC_LWADD, 0x2, 3, TREG_ZERO, 1,
    { { 0, }, { 9, 24, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "lwadd.sn", TILE_OPC_LWADD_SN, 0x2, 3, TREG_SN, 1,
    { { 0, }, { 9, 24, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "lwadd_na", TILE_OPC_LWADD_NA, 0x2, 3, TREG_ZERO, 1,
    { { 0, }, { 9, 24, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "lwadd_na.sn", TILE_OPC_LWADD_NA_SN, 0x2, 3, TREG_SN, 1,
    { { 0, }, { 9, 24, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "maxb_u", TILE_OPC_MAXB_U, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "maxb_u.sn", TILE_OPC_MAXB_U_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "maxh", TILE_OPC_MAXH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "maxh.sn", TILE_OPC_MAXH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "maxib_u", TILE_OPC_MAXIB_U, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "maxib_u.sn", TILE_OPC_MAXIB_U_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "maxih", TILE_OPC_MAXIH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "maxih.sn", TILE_OPC_MAXIH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "mf", TILE_OPC_MF, 0x2, 0, TREG_ZERO, 1,
    { { 0, }, {  }, { 0, }, { 0, }, { 0, } },
  },
  { "mfspr", TILE_OPC_MFSPR, 0x2, 2, TREG_ZERO, 1,
    { { 0, }, { 9, 25 }, { 0, }, { 0, }, { 0, } },
  },
  { "minb_u", TILE_OPC_MINB_U, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "minb_u.sn", TILE_OPC_MINB_U_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "minh", TILE_OPC_MINH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "minh.sn", TILE_OPC_MINH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "minib_u", TILE_OPC_MINIB_U, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "minib_u.sn", TILE_OPC_MINIB_U_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "minih", TILE_OPC_MINIH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "minih.sn", TILE_OPC_MINIH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "mm", TILE_OPC_MM, 0x3, 5, TREG_ZERO, 1,
    { { 7, 8, 16, 26, 27 }, { 9, 10, 17, 28, 29 }, { 0, }, { 0, }, { 0, } },
  },
  { "mnz", TILE_OPC_MNZ, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 11, 12, 18 }, { 13, 14, 19 }, { 0, } },
  },
  { "mnz.sn", TILE_OPC_MNZ_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "mnzb", TILE_OPC_MNZB, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "mnzb.sn", TILE_OPC_MNZB_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "mnzh", TILE_OPC_MNZH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "mnzh.sn", TILE_OPC_MNZH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "mtspr", TILE_OPC_MTSPR, 0x2, 2, TREG_ZERO, 1,
    { { 0, }, { 30, 10 }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhh_ss", TILE_OPC_MULHH_SS, 0x5, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 0, }, { 11, 12, 18 }, { 0, }, { 0, } },
  },
  { "mulhh_ss.sn", TILE_OPC_MULHH_SS_SN, 0x1, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhh_su", TILE_OPC_MULHH_SU, 0x1, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhh_su.sn", TILE_OPC_MULHH_SU_SN, 0x1, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhh_uu", TILE_OPC_MULHH_UU, 0x5, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 0, }, { 11, 12, 18 }, { 0, }, { 0, } },
  },
  { "mulhh_uu.sn", TILE_OPC_MULHH_UU_SN, 0x1, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhha_ss", TILE_OPC_MULHHA_SS, 0x5, 3, TREG_ZERO, 1,
    { { 21, 8, 16 }, { 0, }, { 31, 12, 18 }, { 0, }, { 0, } },
  },
  { "mulhha_ss.sn", TILE_OPC_MULHHA_SS_SN, 0x1, 3, TREG_SN, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhha_su", TILE_OPC_MULHHA_SU, 0x1, 3, TREG_ZERO, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhha_su.sn", TILE_OPC_MULHHA_SU_SN, 0x1, 3, TREG_SN, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhha_uu", TILE_OPC_MULHHA_UU, 0x5, 3, TREG_ZERO, 1,
    { { 21, 8, 16 }, { 0, }, { 31, 12, 18 }, { 0, }, { 0, } },
  },
  { "mulhha_uu.sn", TILE_OPC_MULHHA_UU_SN, 0x1, 3, TREG_SN, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhhsa_uu", TILE_OPC_MULHHSA_UU, 0x1, 3, TREG_ZERO, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhhsa_uu.sn", TILE_OPC_MULHHSA_UU_SN, 0x1, 3, TREG_SN, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhl_ss", TILE_OPC_MULHL_SS, 0x1, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhl_ss.sn", TILE_OPC_MULHL_SS_SN, 0x1, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhl_su", TILE_OPC_MULHL_SU, 0x1, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhl_su.sn", TILE_OPC_MULHL_SU_SN, 0x1, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhl_us", TILE_OPC_MULHL_US, 0x1, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhl_us.sn", TILE_OPC_MULHL_US_SN, 0x1, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhl_uu", TILE_OPC_MULHL_UU, 0x1, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhl_uu.sn", TILE_OPC_MULHL_UU_SN, 0x1, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhla_ss", TILE_OPC_MULHLA_SS, 0x1, 3, TREG_ZERO, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhla_ss.sn", TILE_OPC_MULHLA_SS_SN, 0x1, 3, TREG_SN, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhla_su", TILE_OPC_MULHLA_SU, 0x1, 3, TREG_ZERO, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhla_su.sn", TILE_OPC_MULHLA_SU_SN, 0x1, 3, TREG_SN, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhla_us", TILE_OPC_MULHLA_US, 0x1, 3, TREG_ZERO, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhla_us.sn", TILE_OPC_MULHLA_US_SN, 0x1, 3, TREG_SN, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhla_uu", TILE_OPC_MULHLA_UU, 0x1, 3, TREG_ZERO, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhla_uu.sn", TILE_OPC_MULHLA_UU_SN, 0x1, 3, TREG_SN, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulhlsa_uu", TILE_OPC_MULHLSA_UU, 0x5, 3, TREG_ZERO, 1,
    { { 21, 8, 16 }, { 0, }, { 31, 12, 18 }, { 0, }, { 0, } },
  },
  { "mulhlsa_uu.sn", TILE_OPC_MULHLSA_UU_SN, 0x1, 3, TREG_SN, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulll_ss", TILE_OPC_MULLL_SS, 0x5, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 0, }, { 11, 12, 18 }, { 0, }, { 0, } },
  },
  { "mulll_ss.sn", TILE_OPC_MULLL_SS_SN, 0x1, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulll_su", TILE_OPC_MULLL_SU, 0x1, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulll_su.sn", TILE_OPC_MULLL_SU_SN, 0x1, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulll_uu", TILE_OPC_MULLL_UU, 0x5, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 0, }, { 11, 12, 18 }, { 0, }, { 0, } },
  },
  { "mulll_uu.sn", TILE_OPC_MULLL_UU_SN, 0x1, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mullla_ss", TILE_OPC_MULLLA_SS, 0x5, 3, TREG_ZERO, 1,
    { { 21, 8, 16 }, { 0, }, { 31, 12, 18 }, { 0, }, { 0, } },
  },
  { "mullla_ss.sn", TILE_OPC_MULLLA_SS_SN, 0x1, 3, TREG_SN, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mullla_su", TILE_OPC_MULLLA_SU, 0x1, 3, TREG_ZERO, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mullla_su.sn", TILE_OPC_MULLLA_SU_SN, 0x1, 3, TREG_SN, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mullla_uu", TILE_OPC_MULLLA_UU, 0x5, 3, TREG_ZERO, 1,
    { { 21, 8, 16 }, { 0, }, { 31, 12, 18 }, { 0, }, { 0, } },
  },
  { "mullla_uu.sn", TILE_OPC_MULLLA_UU_SN, 0x1, 3, TREG_SN, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulllsa_uu", TILE_OPC_MULLLSA_UU, 0x1, 3, TREG_ZERO, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mulllsa_uu.sn", TILE_OPC_MULLLSA_UU_SN, 0x1, 3, TREG_SN, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mvnz", TILE_OPC_MVNZ, 0x5, 3, TREG_ZERO, 1,
    { { 21, 8, 16 }, { 0, }, { 31, 12, 18 }, { 0, }, { 0, } },
  },
  { "mvnz.sn", TILE_OPC_MVNZ_SN, 0x1, 3, TREG_SN, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mvz", TILE_OPC_MVZ, 0x5, 3, TREG_ZERO, 1,
    { { 21, 8, 16 }, { 0, }, { 31, 12, 18 }, { 0, }, { 0, } },
  },
  { "mvz.sn", TILE_OPC_MVZ_SN, 0x1, 3, TREG_SN, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "mz", TILE_OPC_MZ, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 11, 12, 18 }, { 13, 14, 19 }, { 0, } },
  },
  { "mz.sn", TILE_OPC_MZ_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "mzb", TILE_OPC_MZB, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "mzb.sn", TILE_OPC_MZB_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "mzh", TILE_OPC_MZH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "mzh.sn", TILE_OPC_MZH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "nap", TILE_OPC_NAP, 0x2, 0, TREG_ZERO, 0,
    { { 0, }, {  }, { 0, }, { 0, }, { 0, } },
  },
  { "nop", TILE_OPC_NOP, 0xf, 0, TREG_ZERO, 1,
    { {  }, {  }, {  }, {  }, { 0, } },
  },
  { "nor", TILE_OPC_NOR, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 11, 12, 18 }, { 13, 14, 19 }, { 0, } },
  },
  { "nor.sn", TILE_OPC_NOR_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "or", TILE_OPC_OR, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 11, 12, 18 }, { 13, 14, 19 }, { 0, } },
  },
  { "or.sn", TILE_OPC_OR_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "ori", TILE_OPC_ORI, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 11, 12, 2 }, { 13, 14, 3 }, { 0, } },
  },
  { "ori.sn", TILE_OPC_ORI_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "packbs_u", TILE_OPC_PACKBS_U, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "packbs_u.sn", TILE_OPC_PACKBS_U_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "packhb", TILE_OPC_PACKHB, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "packhb.sn", TILE_OPC_PACKHB_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "packhs", TILE_OPC_PACKHS, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "packhs.sn", TILE_OPC_PACKHS_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "packlb", TILE_OPC_PACKLB, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "packlb.sn", TILE_OPC_PACKLB_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "pcnt", TILE_OPC_PCNT, 0x5, 2, TREG_ZERO, 1,
    { { 7, 8 }, { 0, }, { 11, 12 }, { 0, }, { 0, } },
  },
  { "pcnt.sn", TILE_OPC_PCNT_SN, 0x1, 2, TREG_SN, 1,
    { { 7, 8 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "rl", TILE_OPC_RL, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 11, 12, 18 }, { 13, 14, 19 }, { 0, } },
  },
  { "rl.sn", TILE_OPC_RL_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "rli", TILE_OPC_RLI, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 32 }, { 9, 10, 33 }, { 11, 12, 34 }, { 13, 14, 35 }, { 0, } },
  },
  { "rli.sn", TILE_OPC_RLI_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 32 }, { 9, 10, 33 }, { 0, }, { 0, }, { 0, } },
  },
  { "s1a", TILE_OPC_S1A, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 11, 12, 18 }, { 13, 14, 19 }, { 0, } },
  },
  { "s1a.sn", TILE_OPC_S1A_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "s2a", TILE_OPC_S2A, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 11, 12, 18 }, { 13, 14, 19 }, { 0, } },
  },
  { "s2a.sn", TILE_OPC_S2A_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "s3a", TILE_OPC_S3A, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 11, 12, 18 }, { 13, 14, 19 }, { 0, } },
  },
  { "s3a.sn", TILE_OPC_S3A_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "sadab_u", TILE_OPC_SADAB_U, 0x1, 3, TREG_ZERO, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "sadab_u.sn", TILE_OPC_SADAB_U_SN, 0x1, 3, TREG_SN, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "sadah", TILE_OPC_SADAH, 0x1, 3, TREG_ZERO, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "sadah.sn", TILE_OPC_SADAH_SN, 0x1, 3, TREG_SN, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "sadah_u", TILE_OPC_SADAH_U, 0x1, 3, TREG_ZERO, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "sadah_u.sn", TILE_OPC_SADAH_U_SN, 0x1, 3, TREG_SN, 1,
    { { 21, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "sadb_u", TILE_OPC_SADB_U, 0x1, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "sadb_u.sn", TILE_OPC_SADB_U_SN, 0x1, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "sadh", TILE_OPC_SADH, 0x1, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "sadh.sn", TILE_OPC_SADH_SN, 0x1, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "sadh_u", TILE_OPC_SADH_U, 0x1, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "sadh_u.sn", TILE_OPC_SADH_U_SN, 0x1, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "sb", TILE_OPC_SB, 0x12, 2, TREG_ZERO, 1,
    { { 0, }, { 10, 17 }, { 0, }, { 0, }, { 15, 36 } },
  },
  { "sbadd", TILE_OPC_SBADD, 0x2, 3, TREG_ZERO, 1,
    { { 0, }, { 24, 17, 37 }, { 0, }, { 0, }, { 0, } },
  },
  { "seq", TILE_OPC_SEQ, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 11, 12, 18 }, { 13, 14, 19 }, { 0, } },
  },
  { "seq.sn", TILE_OPC_SEQ_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "seqb", TILE_OPC_SEQB, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "seqb.sn", TILE_OPC_SEQB_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "seqh", TILE_OPC_SEQH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "seqh.sn", TILE_OPC_SEQH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "seqi", TILE_OPC_SEQI, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 11, 12, 2 }, { 13, 14, 3 }, { 0, } },
  },
  { "seqi.sn", TILE_OPC_SEQI_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "seqib", TILE_OPC_SEQIB, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "seqib.sn", TILE_OPC_SEQIB_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "seqih", TILE_OPC_SEQIH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "seqih.sn", TILE_OPC_SEQIH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "sh", TILE_OPC_SH, 0x12, 2, TREG_ZERO, 1,
    { { 0, }, { 10, 17 }, { 0, }, { 0, }, { 15, 36 } },
  },
  { "shadd", TILE_OPC_SHADD, 0x2, 3, TREG_ZERO, 1,
    { { 0, }, { 24, 17, 37 }, { 0, }, { 0, }, { 0, } },
  },
  { "shl", TILE_OPC_SHL, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 11, 12, 18 }, { 13, 14, 19 }, { 0, } },
  },
  { "shl.sn", TILE_OPC_SHL_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "shlb", TILE_OPC_SHLB, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "shlb.sn", TILE_OPC_SHLB_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "shlh", TILE_OPC_SHLH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "shlh.sn", TILE_OPC_SHLH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "shli", TILE_OPC_SHLI, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 32 }, { 9, 10, 33 }, { 11, 12, 34 }, { 13, 14, 35 }, { 0, } },
  },
  { "shli.sn", TILE_OPC_SHLI_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 32 }, { 9, 10, 33 }, { 0, }, { 0, }, { 0, } },
  },
  { "shlib", TILE_OPC_SHLIB, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 32 }, { 9, 10, 33 }, { 0, }, { 0, }, { 0, } },
  },
  { "shlib.sn", TILE_OPC_SHLIB_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 32 }, { 9, 10, 33 }, { 0, }, { 0, }, { 0, } },
  },
  { "shlih", TILE_OPC_SHLIH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 32 }, { 9, 10, 33 }, { 0, }, { 0, }, { 0, } },
  },
  { "shlih.sn", TILE_OPC_SHLIH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 32 }, { 9, 10, 33 }, { 0, }, { 0, }, { 0, } },
  },
  { "shr", TILE_OPC_SHR, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 11, 12, 18 }, { 13, 14, 19 }, { 0, } },
  },
  { "shr.sn", TILE_OPC_SHR_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "shrb", TILE_OPC_SHRB, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "shrb.sn", TILE_OPC_SHRB_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "shrh", TILE_OPC_SHRH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "shrh.sn", TILE_OPC_SHRH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "shri", TILE_OPC_SHRI, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 32 }, { 9, 10, 33 }, { 11, 12, 34 }, { 13, 14, 35 }, { 0, } },
  },
  { "shri.sn", TILE_OPC_SHRI_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 32 }, { 9, 10, 33 }, { 0, }, { 0, }, { 0, } },
  },
  { "shrib", TILE_OPC_SHRIB, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 32 }, { 9, 10, 33 }, { 0, }, { 0, }, { 0, } },
  },
  { "shrib.sn", TILE_OPC_SHRIB_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 32 }, { 9, 10, 33 }, { 0, }, { 0, }, { 0, } },
  },
  { "shrih", TILE_OPC_SHRIH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 32 }, { 9, 10, 33 }, { 0, }, { 0, }, { 0, } },
  },
  { "shrih.sn", TILE_OPC_SHRIH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 32 }, { 9, 10, 33 }, { 0, }, { 0, }, { 0, } },
  },
  { "slt", TILE_OPC_SLT, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 11, 12, 18 }, { 13, 14, 19 }, { 0, } },
  },
  { "slt.sn", TILE_OPC_SLT_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "slt_u", TILE_OPC_SLT_U, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 11, 12, 18 }, { 13, 14, 19 }, { 0, } },
  },
  { "slt_u.sn", TILE_OPC_SLT_U_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "sltb", TILE_OPC_SLTB, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "sltb.sn", TILE_OPC_SLTB_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "sltb_u", TILE_OPC_SLTB_U, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "sltb_u.sn", TILE_OPC_SLTB_U_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "slte", TILE_OPC_SLTE, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 11, 12, 18 }, { 13, 14, 19 }, { 0, } },
  },
  { "slte.sn", TILE_OPC_SLTE_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "slte_u", TILE_OPC_SLTE_U, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 11, 12, 18 }, { 13, 14, 19 }, { 0, } },
  },
  { "slte_u.sn", TILE_OPC_SLTE_U_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "slteb", TILE_OPC_SLTEB, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "slteb.sn", TILE_OPC_SLTEB_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "slteb_u", TILE_OPC_SLTEB_U, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "slteb_u.sn", TILE_OPC_SLTEB_U_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "slteh", TILE_OPC_SLTEH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "slteh.sn", TILE_OPC_SLTEH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "slteh_u", TILE_OPC_SLTEH_U, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "slteh_u.sn", TILE_OPC_SLTEH_U_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "slth", TILE_OPC_SLTH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "slth.sn", TILE_OPC_SLTH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "slth_u", TILE_OPC_SLTH_U, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "slth_u.sn", TILE_OPC_SLTH_U_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "slti", TILE_OPC_SLTI, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 11, 12, 2 }, { 13, 14, 3 }, { 0, } },
  },
  { "slti.sn", TILE_OPC_SLTI_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "slti_u", TILE_OPC_SLTI_U, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 11, 12, 2 }, { 13, 14, 3 }, { 0, } },
  },
  { "slti_u.sn", TILE_OPC_SLTI_U_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "sltib", TILE_OPC_SLTIB, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "sltib.sn", TILE_OPC_SLTIB_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "sltib_u", TILE_OPC_SLTIB_U, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "sltib_u.sn", TILE_OPC_SLTIB_U_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "sltih", TILE_OPC_SLTIH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "sltih.sn", TILE_OPC_SLTIH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "sltih_u", TILE_OPC_SLTIH_U, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "sltih_u.sn", TILE_OPC_SLTIH_U_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "sne", TILE_OPC_SNE, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 11, 12, 18 }, { 13, 14, 19 }, { 0, } },
  },
  { "sne.sn", TILE_OPC_SNE_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "sneb", TILE_OPC_SNEB, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "sneb.sn", TILE_OPC_SNEB_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "sneh", TILE_OPC_SNEH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "sneh.sn", TILE_OPC_SNEH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "sra", TILE_OPC_SRA, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 11, 12, 18 }, { 13, 14, 19 }, { 0, } },
  },
  { "sra.sn", TILE_OPC_SRA_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "srab", TILE_OPC_SRAB, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "srab.sn", TILE_OPC_SRAB_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "srah", TILE_OPC_SRAH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "srah.sn", TILE_OPC_SRAH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "srai", TILE_OPC_SRAI, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 32 }, { 9, 10, 33 }, { 11, 12, 34 }, { 13, 14, 35 }, { 0, } },
  },
  { "srai.sn", TILE_OPC_SRAI_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 32 }, { 9, 10, 33 }, { 0, }, { 0, }, { 0, } },
  },
  { "sraib", TILE_OPC_SRAIB, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 32 }, { 9, 10, 33 }, { 0, }, { 0, }, { 0, } },
  },
  { "sraib.sn", TILE_OPC_SRAIB_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 32 }, { 9, 10, 33 }, { 0, }, { 0, }, { 0, } },
  },
  { "sraih", TILE_OPC_SRAIH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 32 }, { 9, 10, 33 }, { 0, }, { 0, }, { 0, } },
  },
  { "sraih.sn", TILE_OPC_SRAIH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 32 }, { 9, 10, 33 }, { 0, }, { 0, }, { 0, } },
  },
  { "sub", TILE_OPC_SUB, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 11, 12, 18 }, { 13, 14, 19 }, { 0, } },
  },
  { "sub.sn", TILE_OPC_SUB_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "subb", TILE_OPC_SUBB, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "subb.sn", TILE_OPC_SUBB_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "subbs_u", TILE_OPC_SUBBS_U, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "subbs_u.sn", TILE_OPC_SUBBS_U_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "subh", TILE_OPC_SUBH, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "subh.sn", TILE_OPC_SUBH_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "subhs", TILE_OPC_SUBHS, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "subhs.sn", TILE_OPC_SUBHS_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "subs", TILE_OPC_SUBS, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "subs.sn", TILE_OPC_SUBS_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "sw", TILE_OPC_SW, 0x12, 2, TREG_ZERO, 1,
    { { 0, }, { 10, 17 }, { 0, }, { 0, }, { 15, 36 } },
  },
  { "swadd", TILE_OPC_SWADD, 0x2, 3, TREG_ZERO, 1,
    { { 0, }, { 24, 17, 37 }, { 0, }, { 0, }, { 0, } },
  },
  { "swint0", TILE_OPC_SWINT0, 0x2, 0, TREG_ZERO, 0,
    { { 0, }, {  }, { 0, }, { 0, }, { 0, } },
  },
  { "swint1", TILE_OPC_SWINT1, 0x2, 0, TREG_ZERO, 0,
    { { 0, }, {  }, { 0, }, { 0, }, { 0, } },
  },
  { "swint2", TILE_OPC_SWINT2, 0x2, 0, TREG_ZERO, 0,
    { { 0, }, {  }, { 0, }, { 0, }, { 0, } },
  },
  { "swint3", TILE_OPC_SWINT3, 0x2, 0, TREG_ZERO, 0,
    { { 0, }, {  }, { 0, }, { 0, }, { 0, } },
  },
  { "tblidxb0", TILE_OPC_TBLIDXB0, 0x5, 2, TREG_ZERO, 1,
    { { 21, 8 }, { 0, }, { 31, 12 }, { 0, }, { 0, } },
  },
  { "tblidxb0.sn", TILE_OPC_TBLIDXB0_SN, 0x1, 2, TREG_SN, 1,
    { { 21, 8 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "tblidxb1", TILE_OPC_TBLIDXB1, 0x5, 2, TREG_ZERO, 1,
    { { 21, 8 }, { 0, }, { 31, 12 }, { 0, }, { 0, } },
  },
  { "tblidxb1.sn", TILE_OPC_TBLIDXB1_SN, 0x1, 2, TREG_SN, 1,
    { { 21, 8 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "tblidxb2", TILE_OPC_TBLIDXB2, 0x5, 2, TREG_ZERO, 1,
    { { 21, 8 }, { 0, }, { 31, 12 }, { 0, }, { 0, } },
  },
  { "tblidxb2.sn", TILE_OPC_TBLIDXB2_SN, 0x1, 2, TREG_SN, 1,
    { { 21, 8 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "tblidxb3", TILE_OPC_TBLIDXB3, 0x5, 2, TREG_ZERO, 1,
    { { 21, 8 }, { 0, }, { 31, 12 }, { 0, }, { 0, } },
  },
  { "tblidxb3.sn", TILE_OPC_TBLIDXB3_SN, 0x1, 2, TREG_SN, 1,
    { { 21, 8 }, { 0, }, { 0, }, { 0, }, { 0, } },
  },
  { "tns", TILE_OPC_TNS, 0x2, 2, TREG_ZERO, 1,
    { { 0, }, { 9, 10 }, { 0, }, { 0, }, { 0, } },
  },
  { "tns.sn", TILE_OPC_TNS_SN, 0x2, 2, TREG_SN, 1,
    { { 0, }, { 9, 10 }, { 0, }, { 0, }, { 0, } },
  },
  { "wh64", TILE_OPC_WH64, 0x2, 1, TREG_ZERO, 1,
    { { 0, }, { 10 }, { 0, }, { 0, }, { 0, } },
  },
  { "xor", TILE_OPC_XOR, 0xf, 3, TREG_ZERO, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 11, 12, 18 }, { 13, 14, 19 }, { 0, } },
  },
  { "xor.sn", TILE_OPC_XOR_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 16 }, { 9, 10, 17 }, { 0, }, { 0, }, { 0, } },
  },
  { "xori", TILE_OPC_XORI, 0x3, 3, TREG_ZERO, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { "xori.sn", TILE_OPC_XORI_SN, 0x3, 3, TREG_SN, 1,
    { { 7, 8, 0 }, { 9, 10, 1 }, { 0, }, { 0, }, { 0, } },
  },
  { NULL, TILE_OPC_NONE, 0, 0, TREG_ZERO, 0, { { 0, } },
  }
};
#define BITFIELD(start, size) ((start) | (((1 << (size)) - 1) << 6))
#define CHILD(array_index) (TILE_OPC_NONE + (array_index))

static const unsigned short decode_X0_fsm[1153] =
{
  BITFIELD(22, 9) /* index 0 */,
  CHILD(513), CHILD(530), CHILD(547), CHILD(564), CHILD(596), CHILD(613),
  CHILD(630), TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, CHILD(663), CHILD(680), CHILD(697), CHILD(714), CHILD(746),
  CHILD(763), CHILD(780), TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, CHILD(813), CHILD(813), CHILD(813),
  CHILD(813), CHILD(813), CHILD(813), CHILD(813), CHILD(813), CHILD(813),
  CHILD(813), CHILD(813), CHILD(813), CHILD(813), CHILD(813), CHILD(813),
  CHILD(813), CHILD(813), CHILD(813), CHILD(813), CHILD(813), CHILD(813),
  CHILD(813), CHILD(813), CHILD(813), CHILD(813), CHILD(813), CHILD(813),
  CHILD(813), CHILD(813), CHILD(813), CHILD(813), CHILD(813), CHILD(813),
  CHILD(813), CHILD(813), CHILD(813), CHILD(813), CHILD(813), CHILD(813),
  CHILD(813), CHILD(813), CHILD(813), CHILD(813), CHILD(813), CHILD(813),
  CHILD(813), CHILD(813), CHILD(813), CHILD(813), CHILD(813), CHILD(813),
  CHILD(813), CHILD(813), CHILD(813), CHILD(813), CHILD(813), CHILD(813),
  CHILD(813), CHILD(813), CHILD(813), CHILD(813), CHILD(813), CHILD(813),
  CHILD(813), CHILD(828), CHILD(828), CHILD(828), CHILD(828), CHILD(828),
  CHILD(828), CHILD(828), CHILD(828), CHILD(828), CHILD(828), CHILD(828),
  CHILD(828), CHILD(828), CHILD(828), CHILD(828), CHILD(828), CHILD(828),
  CHILD(828), CHILD(828), CHILD(828), CHILD(828), CHILD(828), CHILD(828),
  CHILD(828), CHILD(828), CHILD(828), CHILD(828), CHILD(828), CHILD(828),
  CHILD(828), CHILD(828), CHILD(828), CHILD(828), CHILD(828), CHILD(828),
  CHILD(828), CHILD(828), CHILD(828), CHILD(828), CHILD(828), CHILD(828),
  CHILD(828), CHILD(828), CHILD(828), CHILD(828), CHILD(828), CHILD(828),
  CHILD(828), CHILD(828), CHILD(828), CHILD(828), CHILD(828), CHILD(828),
  CHILD(828), CHILD(828), CHILD(828), CHILD(828), CHILD(828), CHILD(828),
  CHILD(828), CHILD(828), CHILD(828), CHILD(828), CHILD(828), CHILD(843),
  CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843),
  CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843),
  CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843),
  CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843),
  CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843),
  CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843),
  CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843),
  CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843),
  CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843),
  CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843),
  CHILD(843), CHILD(843), CHILD(843), CHILD(873), CHILD(878), CHILD(883),
  CHILD(903), CHILD(908), TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, CHILD(913),
  CHILD(918), CHILD(923), CHILD(943), CHILD(948), TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, CHILD(953), TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, CHILD(988), TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM,
  TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM,
  TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM,
  TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM,
  TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM,
  TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM,
  TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM,
  TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM,
  TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM,
  TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM,
  TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM,
  TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM,
  TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, CHILD(993),
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, CHILD(1076), TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  BITFIELD(18, 4) /* index 513 */,
  TILE_OPC_NONE, TILE_OPC_ADDB, TILE_OPC_ADDH, TILE_OPC_ADD,
  TILE_OPC_ADIFFB_U, TILE_OPC_ADIFFH, TILE_OPC_AND, TILE_OPC_AVGB_U,
  TILE_OPC_AVGH, TILE_OPC_CRC32_32, TILE_OPC_CRC32_8, TILE_OPC_INTHB,
  TILE_OPC_INTHH, TILE_OPC_INTLB, TILE_OPC_INTLH, TILE_OPC_MAXB_U,
  BITFIELD(18, 4) /* index 530 */,
  TILE_OPC_MAXH, TILE_OPC_MINB_U, TILE_OPC_MINH, TILE_OPC_MNZB, TILE_OPC_MNZH,
  TILE_OPC_MNZ, TILE_OPC_MULHHA_SS, TILE_OPC_MULHHA_SU, TILE_OPC_MULHHA_UU,
  TILE_OPC_MULHHSA_UU, TILE_OPC_MULHH_SS, TILE_OPC_MULHH_SU,
  TILE_OPC_MULHH_UU, TILE_OPC_MULHLA_SS, TILE_OPC_MULHLA_SU,
  TILE_OPC_MULHLA_US,
  BITFIELD(18, 4) /* index 547 */,
  TILE_OPC_MULHLA_UU, TILE_OPC_MULHLSA_UU, TILE_OPC_MULHL_SS,
  TILE_OPC_MULHL_SU, TILE_OPC_MULHL_US, TILE_OPC_MULHL_UU, TILE_OPC_MULLLA_SS,
  TILE_OPC_MULLLA_SU, TILE_OPC_MULLLA_UU, TILE_OPC_MULLLSA_UU,
  TILE_OPC_MULLL_SS, TILE_OPC_MULLL_SU, TILE_OPC_MULLL_UU, TILE_OPC_MVNZ,
  TILE_OPC_MVZ, TILE_OPC_MZB,
  BITFIELD(18, 4) /* index 564 */,
  TILE_OPC_MZH, TILE_OPC_MZ, TILE_OPC_NOR, CHILD(581), TILE_OPC_PACKHB,
  TILE_OPC_PACKLB, TILE_OPC_RL, TILE_OPC_S1A, TILE_OPC_S2A, TILE_OPC_S3A,
  TILE_OPC_SADAB_U, TILE_OPC_SADAH, TILE_OPC_SADAH_U, TILE_OPC_SADB_U,
  TILE_OPC_SADH, TILE_OPC_SADH_U,
  BITFIELD(12, 2) /* index 581 */,
  TILE_OPC_OR, TILE_OPC_OR, TILE_OPC_OR, CHILD(586),
  BITFIELD(14, 2) /* index 586 */,
  TILE_OPC_OR, TILE_OPC_OR, TILE_OPC_OR, CHILD(591),
  BITFIELD(16, 2) /* index 591 */,
  TILE_OPC_OR, TILE_OPC_OR, TILE_OPC_OR, TILE_OPC_MOVE,
  BITFIELD(18, 4) /* index 596 */,
  TILE_OPC_SEQB, TILE_OPC_SEQH, TILE_OPC_SEQ, TILE_OPC_SHLB, TILE_OPC_SHLH,
  TILE_OPC_SHL, TILE_OPC_SHRB, TILE_OPC_SHRH, TILE_OPC_SHR, TILE_OPC_SLTB,
  TILE_OPC_SLTB_U, TILE_OPC_SLTEB, TILE_OPC_SLTEB_U, TILE_OPC_SLTEH,
  TILE_OPC_SLTEH_U, TILE_OPC_SLTE,
  BITFIELD(18, 4) /* index 613 */,
  TILE_OPC_SLTE_U, TILE_OPC_SLTH, TILE_OPC_SLTH_U, TILE_OPC_SLT,
  TILE_OPC_SLT_U, TILE_OPC_SNEB, TILE_OPC_SNEH, TILE_OPC_SNE, TILE_OPC_SRAB,
  TILE_OPC_SRAH, TILE_OPC_SRA, TILE_OPC_SUBB, TILE_OPC_SUBH, TILE_OPC_SUB,
  TILE_OPC_XOR, TILE_OPC_DWORD_ALIGN,
  BITFIELD(18, 3) /* index 630 */,
  CHILD(639), CHILD(642), CHILD(645), CHILD(648), CHILD(651), CHILD(654),
  CHILD(657), CHILD(660),
  BITFIELD(21, 1) /* index 639 */,
  TILE_OPC_ADDS, TILE_OPC_NONE,
  BITFIELD(21, 1) /* index 642 */,
  TILE_OPC_SUBS, TILE_OPC_NONE,
  BITFIELD(21, 1) /* index 645 */,
  TILE_OPC_ADDBS_U, TILE_OPC_NONE,
  BITFIELD(21, 1) /* index 648 */,
  TILE_OPC_ADDHS, TILE_OPC_NONE,
  BITFIELD(21, 1) /* index 651 */,
  TILE_OPC_SUBBS_U, TILE_OPC_NONE,
  BITFIELD(21, 1) /* index 654 */,
  TILE_OPC_SUBHS, TILE_OPC_NONE,
  BITFIELD(21, 1) /* index 657 */,
  TILE_OPC_PACKHS, TILE_OPC_NONE,
  BITFIELD(21, 1) /* index 660 */,
  TILE_OPC_PACKBS_U, TILE_OPC_NONE,
  BITFIELD(18, 4) /* index 663 */,
  TILE_OPC_NONE, TILE_OPC_ADDB_SN, TILE_OPC_ADDH_SN, TILE_OPC_ADD_SN,
  TILE_OPC_ADIFFB_U_SN, TILE_OPC_ADIFFH_SN, TILE_OPC_AND_SN,
  TILE_OPC_AVGB_U_SN, TILE_OPC_AVGH_SN, TILE_OPC_CRC32_32_SN,
  TILE_OPC_CRC32_8_SN, TILE_OPC_INTHB_SN, TILE_OPC_INTHH_SN,
  TILE_OPC_INTLB_SN, TILE_OPC_INTLH_SN, TILE_OPC_MAXB_U_SN,
  BITFIELD(18, 4) /* index 680 */,
  TILE_OPC_MAXH_SN, TILE_OPC_MINB_U_SN, TILE_OPC_MINH_SN, TILE_OPC_MNZB_SN,
  TILE_OPC_MNZH_SN, TILE_OPC_MNZ_SN, TILE_OPC_MULHHA_SS_SN,
  TILE_OPC_MULHHA_SU_SN, TILE_OPC_MULHHA_UU_SN, TILE_OPC_MULHHSA_UU_SN,
  TILE_OPC_MULHH_SS_SN, TILE_OPC_MULHH_SU_SN, TILE_OPC_MULHH_UU_SN,
  TILE_OPC_MULHLA_SS_SN, TILE_OPC_MULHLA_SU_SN, TILE_OPC_MULHLA_US_SN,
  BITFIELD(18, 4) /* index 697 */,
  TILE_OPC_MULHLA_UU_SN, TILE_OPC_MULHLSA_UU_SN, TILE_OPC_MULHL_SS_SN,
  TILE_OPC_MULHL_SU_SN, TILE_OPC_MULHL_US_SN, TILE_OPC_MULHL_UU_SN,
  TILE_OPC_MULLLA_SS_SN, TILE_OPC_MULLLA_SU_SN, TILE_OPC_MULLLA_UU_SN,
  TILE_OPC_MULLLSA_UU_SN, TILE_OPC_MULLL_SS_SN, TILE_OPC_MULLL_SU_SN,
  TILE_OPC_MULLL_UU_SN, TILE_OPC_MVNZ_SN, TILE_OPC_MVZ_SN, TILE_OPC_MZB_SN,
  BITFIELD(18, 4) /* index 714 */,
  TILE_OPC_MZH_SN, TILE_OPC_MZ_SN, TILE_OPC_NOR_SN, CHILD(731),
  TILE_OPC_PACKHB_SN, TILE_OPC_PACKLB_SN, TILE_OPC_RL_SN, TILE_OPC_S1A_SN,
  TILE_OPC_S2A_SN, TILE_OPC_S3A_SN, TILE_OPC_SADAB_U_SN, TILE_OPC_SADAH_SN,
  TILE_OPC_SADAH_U_SN, TILE_OPC_SADB_U_SN, TILE_OPC_SADH_SN,
  TILE_OPC_SADH_U_SN,
  BITFIELD(12, 2) /* index 731 */,
  TILE_OPC_OR_SN, TILE_OPC_OR_SN, TILE_OPC_OR_SN, CHILD(736),
  BITFIELD(14, 2) /* index 736 */,
  TILE_OPC_OR_SN, TILE_OPC_OR_SN, TILE_OPC_OR_SN, CHILD(741),
  BITFIELD(16, 2) /* index 741 */,
  TILE_OPC_OR_SN, TILE_OPC_OR_SN, TILE_OPC_OR_SN, TILE_OPC_MOVE_SN,
  BITFIELD(18, 4) /* index 746 */,
  TILE_OPC_SEQB_SN, TILE_OPC_SEQH_SN, TILE_OPC_SEQ_SN, TILE_OPC_SHLB_SN,
  TILE_OPC_SHLH_SN, TILE_OPC_SHL_SN, TILE_OPC_SHRB_SN, TILE_OPC_SHRH_SN,
  TILE_OPC_SHR_SN, TILE_OPC_SLTB_SN, TILE_OPC_SLTB_U_SN, TILE_OPC_SLTEB_SN,
  TILE_OPC_SLTEB_U_SN, TILE_OPC_SLTEH_SN, TILE_OPC_SLTEH_U_SN,
  TILE_OPC_SLTE_SN,
  BITFIELD(18, 4) /* index 763 */,
  TILE_OPC_SLTE_U_SN, TILE_OPC_SLTH_SN, TILE_OPC_SLTH_U_SN, TILE_OPC_SLT_SN,
  TILE_OPC_SLT_U_SN, TILE_OPC_SNEB_SN, TILE_OPC_SNEH_SN, TILE_OPC_SNE_SN,
  TILE_OPC_SRAB_SN, TILE_OPC_SRAH_SN, TILE_OPC_SRA_SN, TILE_OPC_SUBB_SN,
  TILE_OPC_SUBH_SN, TILE_OPC_SUB_SN, TILE_OPC_XOR_SN, TILE_OPC_DWORD_ALIGN_SN,
  BITFIELD(18, 3) /* index 780 */,
  CHILD(789), CHILD(792), CHILD(795), CHILD(798), CHILD(801), CHILD(804),
  CHILD(807), CHILD(810),
  BITFIELD(21, 1) /* index 789 */,
  TILE_OPC_ADDS_SN, TILE_OPC_NONE,
  BITFIELD(21, 1) /* index 792 */,
  TILE_OPC_SUBS_SN, TILE_OPC_NONE,
  BITFIELD(21, 1) /* index 795 */,
  TILE_OPC_ADDBS_U_SN, TILE_OPC_NONE,
  BITFIELD(21, 1) /* index 798 */,
  TILE_OPC_ADDHS_SN, TILE_OPC_NONE,
  BITFIELD(21, 1) /* index 801 */,
  TILE_OPC_SUBBS_U_SN, TILE_OPC_NONE,
  BITFIELD(21, 1) /* index 804 */,
  TILE_OPC_SUBHS_SN, TILE_OPC_NONE,
  BITFIELD(21, 1) /* index 807 */,
  TILE_OPC_PACKHS_SN, TILE_OPC_NONE,
  BITFIELD(21, 1) /* index 810 */,
  TILE_OPC_PACKBS_U_SN, TILE_OPC_NONE,
  BITFIELD(6, 2) /* index 813 */,
  TILE_OPC_ADDLI_SN, TILE_OPC_ADDLI_SN, TILE_OPC_ADDLI_SN, CHILD(818),
  BITFIELD(8, 2) /* index 818 */,
  TILE_OPC_ADDLI_SN, TILE_OPC_ADDLI_SN, TILE_OPC_ADDLI_SN, CHILD(823),
  BITFIELD(10, 2) /* index 823 */,
  TILE_OPC_ADDLI_SN, TILE_OPC_ADDLI_SN, TILE_OPC_ADDLI_SN, TILE_OPC_MOVELI_SN,
  BITFIELD(6, 2) /* index 828 */,
  TILE_OPC_ADDLI, TILE_OPC_ADDLI, TILE_OPC_ADDLI, CHILD(833),
  BITFIELD(8, 2) /* index 833 */,
  TILE_OPC_ADDLI, TILE_OPC_ADDLI, TILE_OPC_ADDLI, CHILD(838),
  BITFIELD(10, 2) /* index 838 */,
  TILE_OPC_ADDLI, TILE_OPC_ADDLI, TILE_OPC_ADDLI, TILE_OPC_MOVELI,
  BITFIELD(0, 2) /* index 843 */,
  TILE_OPC_AULI, TILE_OPC_AULI, TILE_OPC_AULI, CHILD(848),
  BITFIELD(2, 2) /* index 848 */,
  TILE_OPC_AULI, TILE_OPC_AULI, TILE_OPC_AULI, CHILD(853),
  BITFIELD(4, 2) /* index 853 */,
  TILE_OPC_AULI, TILE_OPC_AULI, TILE_OPC_AULI, CHILD(858),
  BITFIELD(6, 2) /* index 858 */,
  TILE_OPC_AULI, TILE_OPC_AULI, TILE_OPC_AULI, CHILD(863),
  BITFIELD(8, 2) /* index 863 */,
  TILE_OPC_AULI, TILE_OPC_AULI, TILE_OPC_AULI, CHILD(868),
  BITFIELD(10, 2) /* index 868 */,
  TILE_OPC_AULI, TILE_OPC_AULI, TILE_OPC_AULI, TILE_OPC_INFOL,
  BITFIELD(20, 2) /* index 873 */,
  TILE_OPC_NONE, TILE_OPC_ADDIB, TILE_OPC_ADDIH, TILE_OPC_ADDI,
  BITFIELD(20, 2) /* index 878 */,
  TILE_OPC_MAXIB_U, TILE_OPC_MAXIH, TILE_OPC_MINIB_U, TILE_OPC_MINIH,
  BITFIELD(20, 2) /* index 883 */,
  CHILD(888), TILE_OPC_SEQIB, TILE_OPC_SEQIH, TILE_OPC_SEQI,
  BITFIELD(6, 2) /* index 888 */,
  TILE_OPC_ORI, TILE_OPC_ORI, TILE_OPC_ORI, CHILD(893),
  BITFIELD(8, 2) /* index 893 */,
  TILE_OPC_ORI, TILE_OPC_ORI, TILE_OPC_ORI, CHILD(898),
  BITFIELD(10, 2) /* index 898 */,
  TILE_OPC_ORI, TILE_OPC_ORI, TILE_OPC_ORI, TILE_OPC_MOVEI,
  BITFIELD(20, 2) /* index 903 */,
  TILE_OPC_SLTIB, TILE_OPC_SLTIB_U, TILE_OPC_SLTIH, TILE_OPC_SLTIH_U,
  BITFIELD(20, 2) /* index 908 */,
  TILE_OPC_SLTI, TILE_OPC_SLTI_U, TILE_OPC_NONE, TILE_OPC_NONE,
  BITFIELD(20, 2) /* index 913 */,
  TILE_OPC_NONE, TILE_OPC_ADDIB_SN, TILE_OPC_ADDIH_SN, TILE_OPC_ADDI_SN,
  BITFIELD(20, 2) /* index 918 */,
  TILE_OPC_MAXIB_U_SN, TILE_OPC_MAXIH_SN, TILE_OPC_MINIB_U_SN,
  TILE_OPC_MINIH_SN,
  BITFIELD(20, 2) /* index 923 */,
  CHILD(928), TILE_OPC_SEQIB_SN, TILE_OPC_SEQIH_SN, TILE_OPC_SEQI_SN,
  BITFIELD(6, 2) /* index 928 */,
  TILE_OPC_ORI_SN, TILE_OPC_ORI_SN, TILE_OPC_ORI_SN, CHILD(933),
  BITFIELD(8, 2) /* index 933 */,
  TILE_OPC_ORI_SN, TILE_OPC_ORI_SN, TILE_OPC_ORI_SN, CHILD(938),
  BITFIELD(10, 2) /* index 938 */,
  TILE_OPC_ORI_SN, TILE_OPC_ORI_SN, TILE_OPC_ORI_SN, TILE_OPC_MOVEI_SN,
  BITFIELD(20, 2) /* index 943 */,
  TILE_OPC_SLTIB_SN, TILE_OPC_SLTIB_U_SN, TILE_OPC_SLTIH_SN,
  TILE_OPC_SLTIH_U_SN,
  BITFIELD(20, 2) /* index 948 */,
  TILE_OPC_SLTI_SN, TILE_OPC_SLTI_U_SN, TILE_OPC_NONE, TILE_OPC_NONE,
  BITFIELD(20, 2) /* index 953 */,
  TILE_OPC_NONE, CHILD(958), TILE_OPC_XORI, TILE_OPC_NONE,
  BITFIELD(0, 2) /* index 958 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, CHILD(963),
  BITFIELD(2, 2) /* index 963 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, CHILD(968),
  BITFIELD(4, 2) /* index 968 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, CHILD(973),
  BITFIELD(6, 2) /* index 973 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, CHILD(978),
  BITFIELD(8, 2) /* index 978 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, CHILD(983),
  BITFIELD(10, 2) /* index 983 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_INFO,
  BITFIELD(20, 2) /* index 988 */,
  TILE_OPC_NONE, TILE_OPC_ANDI_SN, TILE_OPC_XORI_SN, TILE_OPC_NONE,
  BITFIELD(17, 5) /* index 993 */,
  TILE_OPC_NONE, TILE_OPC_RLI, TILE_OPC_SHLIB, TILE_OPC_SHLIH, TILE_OPC_SHLI,
  TILE_OPC_SHRIB, TILE_OPC_SHRIH, TILE_OPC_SHRI, TILE_OPC_SRAIB,
  TILE_OPC_SRAIH, TILE_OPC_SRAI, CHILD(1026), TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  BITFIELD(12, 4) /* index 1026 */,
  TILE_OPC_NONE, CHILD(1043), CHILD(1046), CHILD(1049), CHILD(1052),
  CHILD(1055), CHILD(1058), CHILD(1061), CHILD(1064), CHILD(1067),
  CHILD(1070), CHILD(1073), TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE,
  BITFIELD(16, 1) /* index 1043 */,
  TILE_OPC_BITX, TILE_OPC_NONE,
  BITFIELD(16, 1) /* index 1046 */,
  TILE_OPC_BYTEX, TILE_OPC_NONE,
  BITFIELD(16, 1) /* index 1049 */,
  TILE_OPC_CLZ, TILE_OPC_NONE,
  BITFIELD(16, 1) /* index 1052 */,
  TILE_OPC_CTZ, TILE_OPC_NONE,
  BITFIELD(16, 1) /* index 1055 */,
  TILE_OPC_FNOP, TILE_OPC_NONE,
  BITFIELD(16, 1) /* index 1058 */,
  TILE_OPC_NOP, TILE_OPC_NONE,
  BITFIELD(16, 1) /* index 1061 */,
  TILE_OPC_PCNT, TILE_OPC_NONE,
  BITFIELD(16, 1) /* index 1064 */,
  TILE_OPC_TBLIDXB0, TILE_OPC_NONE,
  BITFIELD(16, 1) /* index 1067 */,
  TILE_OPC_TBLIDXB1, TILE_OPC_NONE,
  BITFIELD(16, 1) /* index 1070 */,
  TILE_OPC_TBLIDXB2, TILE_OPC_NONE,
  BITFIELD(16, 1) /* index 1073 */,
  TILE_OPC_TBLIDXB3, TILE_OPC_NONE,
  BITFIELD(17, 5) /* index 1076 */,
  TILE_OPC_NONE, TILE_OPC_RLI_SN, TILE_OPC_SHLIB_SN, TILE_OPC_SHLIH_SN,
  TILE_OPC_SHLI_SN, TILE_OPC_SHRIB_SN, TILE_OPC_SHRIH_SN, TILE_OPC_SHRI_SN,
  TILE_OPC_SRAIB_SN, TILE_OPC_SRAIH_SN, TILE_OPC_SRAI_SN, CHILD(1109),
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  BITFIELD(12, 4) /* index 1109 */,
  TILE_OPC_NONE, CHILD(1126), CHILD(1129), CHILD(1132), CHILD(1135),
  CHILD(1055), CHILD(1058), CHILD(1138), CHILD(1141), CHILD(1144),
  CHILD(1147), CHILD(1150), TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE,
  BITFIELD(16, 1) /* index 1126 */,
  TILE_OPC_BITX_SN, TILE_OPC_NONE,
  BITFIELD(16, 1) /* index 1129 */,
  TILE_OPC_BYTEX_SN, TILE_OPC_NONE,
  BITFIELD(16, 1) /* index 1132 */,
  TILE_OPC_CLZ_SN, TILE_OPC_NONE,
  BITFIELD(16, 1) /* index 1135 */,
  TILE_OPC_CTZ_SN, TILE_OPC_NONE,
  BITFIELD(16, 1) /* index 1138 */,
  TILE_OPC_PCNT_SN, TILE_OPC_NONE,
  BITFIELD(16, 1) /* index 1141 */,
  TILE_OPC_TBLIDXB0_SN, TILE_OPC_NONE,
  BITFIELD(16, 1) /* index 1144 */,
  TILE_OPC_TBLIDXB1_SN, TILE_OPC_NONE,
  BITFIELD(16, 1) /* index 1147 */,
  TILE_OPC_TBLIDXB2_SN, TILE_OPC_NONE,
  BITFIELD(16, 1) /* index 1150 */,
  TILE_OPC_TBLIDXB3_SN, TILE_OPC_NONE,
};

static const unsigned short decode_X1_fsm[1540] =
{
  BITFIELD(54, 9) /* index 0 */,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, CHILD(513), CHILD(561), CHILD(594),
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, CHILD(641), CHILD(689),
  CHILD(722), TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, CHILD(766),
  CHILD(766), CHILD(766), CHILD(766), CHILD(766), CHILD(766), CHILD(766),
  CHILD(766), CHILD(766), CHILD(766), CHILD(766), CHILD(766), CHILD(766),
  CHILD(766), CHILD(766), CHILD(766), CHILD(766), CHILD(766), CHILD(766),
  CHILD(766), CHILD(766), CHILD(766), CHILD(766), CHILD(766), CHILD(766),
  CHILD(766), CHILD(766), CHILD(766), CHILD(766), CHILD(766), CHILD(766),
  CHILD(766), CHILD(781), CHILD(781), CHILD(781), CHILD(781), CHILD(781),
  CHILD(781), CHILD(781), CHILD(781), CHILD(781), CHILD(781), CHILD(781),
  CHILD(781), CHILD(781), CHILD(781), CHILD(781), CHILD(781), CHILD(781),
  CHILD(781), CHILD(781), CHILD(781), CHILD(781), CHILD(781), CHILD(781),
  CHILD(781), CHILD(781), CHILD(781), CHILD(781), CHILD(781), CHILD(781),
  CHILD(781), CHILD(781), CHILD(781), CHILD(796), CHILD(796), CHILD(796),
  CHILD(796), CHILD(796), CHILD(796), CHILD(796), CHILD(796), CHILD(796),
  CHILD(796), CHILD(796), CHILD(796), CHILD(796), CHILD(796), CHILD(796),
  CHILD(796), CHILD(796), CHILD(796), CHILD(796), CHILD(796), CHILD(796),
  CHILD(796), CHILD(796), CHILD(796), CHILD(796), CHILD(796), CHILD(796),
  CHILD(796), CHILD(796), CHILD(796), CHILD(796), CHILD(796), CHILD(826),
  CHILD(826), CHILD(826), CHILD(826), CHILD(826), CHILD(826), CHILD(826),
  CHILD(826), CHILD(826), CHILD(826), CHILD(826), CHILD(826), CHILD(826),
  CHILD(826), CHILD(826), CHILD(826), CHILD(843), CHILD(843), CHILD(843),
  CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843),
  CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843), CHILD(843),
  CHILD(843), CHILD(860), CHILD(899), CHILD(923), CHILD(932), TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, CHILD(941), CHILD(950), CHILD(974), CHILD(983),
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM,
  TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM,
  TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM,
  TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM,
  TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM,
  TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM,
  TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, TILE_OPC_MM, CHILD(992),
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  CHILD(1334), TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_J, TILE_OPC_J,
  TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J,
  TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J,
  TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J,
  TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J,
  TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J,
  TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J,
  TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J,
  TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J,
  TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J,
  TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J, TILE_OPC_J,
  TILE_OPC_J, TILE_OPC_J, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL,
  TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL,
  TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL,
  TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL,
  TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL,
  TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL,
  TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL,
  TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL,
  TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL,
  TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL,
  TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL,
  TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL,
  TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL, TILE_OPC_JAL,
  TILE_OPC_JAL, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  BITFIELD(49, 5) /* index 513 */,
  TILE_OPC_NONE, TILE_OPC_ADDB, TILE_OPC_ADDH, TILE_OPC_ADD, TILE_OPC_AND,
  TILE_OPC_INTHB, TILE_OPC_INTHH, TILE_OPC_INTLB, TILE_OPC_INTLH,
  TILE_OPC_JALRP, TILE_OPC_JALR, TILE_OPC_JRP, TILE_OPC_JR, TILE_OPC_LNK,
  TILE_OPC_MAXB_U, TILE_OPC_MAXH, TILE_OPC_MINB_U, TILE_OPC_MINH,
  TILE_OPC_MNZB, TILE_OPC_MNZH, TILE_OPC_MNZ, TILE_OPC_MZB, TILE_OPC_MZH,
  TILE_OPC_MZ, TILE_OPC_NOR, CHILD(546), TILE_OPC_PACKHB, TILE_OPC_PACKLB,
  TILE_OPC_RL, TILE_OPC_S1A, TILE_OPC_S2A, TILE_OPC_S3A,
  BITFIELD(43, 2) /* index 546 */,
  TILE_OPC_OR, TILE_OPC_OR, TILE_OPC_OR, CHILD(551),
  BITFIELD(45, 2) /* index 551 */,
  TILE_OPC_OR, TILE_OPC_OR, TILE_OPC_OR, CHILD(556),
  BITFIELD(47, 2) /* index 556 */,
  TILE_OPC_OR, TILE_OPC_OR, TILE_OPC_OR, TILE_OPC_MOVE,
  BITFIELD(49, 5) /* index 561 */,
  TILE_OPC_SB, TILE_OPC_SEQB, TILE_OPC_SEQH, TILE_OPC_SEQ, TILE_OPC_SHLB,
  TILE_OPC_SHLH, TILE_OPC_SHL, TILE_OPC_SHRB, TILE_OPC_SHRH, TILE_OPC_SHR,
  TILE_OPC_SH, TILE_OPC_SLTB, TILE_OPC_SLTB_U, TILE_OPC_SLTEB,
  TILE_OPC_SLTEB_U, TILE_OPC_SLTEH, TILE_OPC_SLTEH_U, TILE_OPC_SLTE,
  TILE_OPC_SLTE_U, TILE_OPC_SLTH, TILE_OPC_SLTH_U, TILE_OPC_SLT,
  TILE_OPC_SLT_U, TILE_OPC_SNEB, TILE_OPC_SNEH, TILE_OPC_SNE, TILE_OPC_SRAB,
  TILE_OPC_SRAH, TILE_OPC_SRA, TILE_OPC_SUBB, TILE_OPC_SUBH, TILE_OPC_SUB,
  BITFIELD(49, 4) /* index 594 */,
  CHILD(611), CHILD(614), CHILD(617), CHILD(620), CHILD(623), CHILD(626),
  CHILD(629), CHILD(632), CHILD(635), CHILD(638), TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 611 */,
  TILE_OPC_SW, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 614 */,
  TILE_OPC_XOR, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 617 */,
  TILE_OPC_ADDS, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 620 */,
  TILE_OPC_SUBS, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 623 */,
  TILE_OPC_ADDBS_U, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 626 */,
  TILE_OPC_ADDHS, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 629 */,
  TILE_OPC_SUBBS_U, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 632 */,
  TILE_OPC_SUBHS, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 635 */,
  TILE_OPC_PACKHS, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 638 */,
  TILE_OPC_PACKBS_U, TILE_OPC_NONE,
  BITFIELD(49, 5) /* index 641 */,
  TILE_OPC_NONE, TILE_OPC_ADDB_SN, TILE_OPC_ADDH_SN, TILE_OPC_ADD_SN,
  TILE_OPC_AND_SN, TILE_OPC_INTHB_SN, TILE_OPC_INTHH_SN, TILE_OPC_INTLB_SN,
  TILE_OPC_INTLH_SN, TILE_OPC_JALRP, TILE_OPC_JALR, TILE_OPC_JRP, TILE_OPC_JR,
  TILE_OPC_LNK_SN, TILE_OPC_MAXB_U_SN, TILE_OPC_MAXH_SN, TILE_OPC_MINB_U_SN,
  TILE_OPC_MINH_SN, TILE_OPC_MNZB_SN, TILE_OPC_MNZH_SN, TILE_OPC_MNZ_SN,
  TILE_OPC_MZB_SN, TILE_OPC_MZH_SN, TILE_OPC_MZ_SN, TILE_OPC_NOR_SN,
  CHILD(674), TILE_OPC_PACKHB_SN, TILE_OPC_PACKLB_SN, TILE_OPC_RL_SN,
  TILE_OPC_S1A_SN, TILE_OPC_S2A_SN, TILE_OPC_S3A_SN,
  BITFIELD(43, 2) /* index 674 */,
  TILE_OPC_OR_SN, TILE_OPC_OR_SN, TILE_OPC_OR_SN, CHILD(679),
  BITFIELD(45, 2) /* index 679 */,
  TILE_OPC_OR_SN, TILE_OPC_OR_SN, TILE_OPC_OR_SN, CHILD(684),
  BITFIELD(47, 2) /* index 684 */,
  TILE_OPC_OR_SN, TILE_OPC_OR_SN, TILE_OPC_OR_SN, TILE_OPC_MOVE_SN,
  BITFIELD(49, 5) /* index 689 */,
  TILE_OPC_SB, TILE_OPC_SEQB_SN, TILE_OPC_SEQH_SN, TILE_OPC_SEQ_SN,
  TILE_OPC_SHLB_SN, TILE_OPC_SHLH_SN, TILE_OPC_SHL_SN, TILE_OPC_SHRB_SN,
  TILE_OPC_SHRH_SN, TILE_OPC_SHR_SN, TILE_OPC_SH, TILE_OPC_SLTB_SN,
  TILE_OPC_SLTB_U_SN, TILE_OPC_SLTEB_SN, TILE_OPC_SLTEB_U_SN,
  TILE_OPC_SLTEH_SN, TILE_OPC_SLTEH_U_SN, TILE_OPC_SLTE_SN,
  TILE_OPC_SLTE_U_SN, TILE_OPC_SLTH_SN, TILE_OPC_SLTH_U_SN, TILE_OPC_SLT_SN,
  TILE_OPC_SLT_U_SN, TILE_OPC_SNEB_SN, TILE_OPC_SNEH_SN, TILE_OPC_SNE_SN,
  TILE_OPC_SRAB_SN, TILE_OPC_SRAH_SN, TILE_OPC_SRA_SN, TILE_OPC_SUBB_SN,
  TILE_OPC_SUBH_SN, TILE_OPC_SUB_SN,
  BITFIELD(49, 4) /* index 722 */,
  CHILD(611), CHILD(739), CHILD(742), CHILD(745), CHILD(748), CHILD(751),
  CHILD(754), CHILD(757), CHILD(760), CHILD(763), TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 739 */,
  TILE_OPC_XOR_SN, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 742 */,
  TILE_OPC_ADDS_SN, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 745 */,
  TILE_OPC_SUBS_SN, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 748 */,
  TILE_OPC_ADDBS_U_SN, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 751 */,
  TILE_OPC_ADDHS_SN, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 754 */,
  TILE_OPC_SUBBS_U_SN, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 757 */,
  TILE_OPC_SUBHS_SN, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 760 */,
  TILE_OPC_PACKHS_SN, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 763 */,
  TILE_OPC_PACKBS_U_SN, TILE_OPC_NONE,
  BITFIELD(37, 2) /* index 766 */,
  TILE_OPC_ADDLI_SN, TILE_OPC_ADDLI_SN, TILE_OPC_ADDLI_SN, CHILD(771),
  BITFIELD(39, 2) /* index 771 */,
  TILE_OPC_ADDLI_SN, TILE_OPC_ADDLI_SN, TILE_OPC_ADDLI_SN, CHILD(776),
  BITFIELD(41, 2) /* index 776 */,
  TILE_OPC_ADDLI_SN, TILE_OPC_ADDLI_SN, TILE_OPC_ADDLI_SN, TILE_OPC_MOVELI_SN,
  BITFIELD(37, 2) /* index 781 */,
  TILE_OPC_ADDLI, TILE_OPC_ADDLI, TILE_OPC_ADDLI, CHILD(786),
  BITFIELD(39, 2) /* index 786 */,
  TILE_OPC_ADDLI, TILE_OPC_ADDLI, TILE_OPC_ADDLI, CHILD(791),
  BITFIELD(41, 2) /* index 791 */,
  TILE_OPC_ADDLI, TILE_OPC_ADDLI, TILE_OPC_ADDLI, TILE_OPC_MOVELI,
  BITFIELD(31, 2) /* index 796 */,
  TILE_OPC_AULI, TILE_OPC_AULI, TILE_OPC_AULI, CHILD(801),
  BITFIELD(33, 2) /* index 801 */,
  TILE_OPC_AULI, TILE_OPC_AULI, TILE_OPC_AULI, CHILD(806),
  BITFIELD(35, 2) /* index 806 */,
  TILE_OPC_AULI, TILE_OPC_AULI, TILE_OPC_AULI, CHILD(811),
  BITFIELD(37, 2) /* index 811 */,
  TILE_OPC_AULI, TILE_OPC_AULI, TILE_OPC_AULI, CHILD(816),
  BITFIELD(39, 2) /* index 816 */,
  TILE_OPC_AULI, TILE_OPC_AULI, TILE_OPC_AULI, CHILD(821),
  BITFIELD(41, 2) /* index 821 */,
  TILE_OPC_AULI, TILE_OPC_AULI, TILE_OPC_AULI, TILE_OPC_INFOL,
  BITFIELD(31, 4) /* index 826 */,
  TILE_OPC_BZ, TILE_OPC_BZT, TILE_OPC_BNZ, TILE_OPC_BNZT, TILE_OPC_BGZ,
  TILE_OPC_BGZT, TILE_OPC_BGEZ, TILE_OPC_BGEZT, TILE_OPC_BLZ, TILE_OPC_BLZT,
  TILE_OPC_BLEZ, TILE_OPC_BLEZT, TILE_OPC_BBS, TILE_OPC_BBST, TILE_OPC_BBNS,
  TILE_OPC_BBNST,
  BITFIELD(31, 4) /* index 843 */,
  TILE_OPC_BZ_SN, TILE_OPC_BZT_SN, TILE_OPC_BNZ_SN, TILE_OPC_BNZT_SN,
  TILE_OPC_BGZ_SN, TILE_OPC_BGZT_SN, TILE_OPC_BGEZ_SN, TILE_OPC_BGEZT_SN,
  TILE_OPC_BLZ_SN, TILE_OPC_BLZT_SN, TILE_OPC_BLEZ_SN, TILE_OPC_BLEZT_SN,
  TILE_OPC_BBS_SN, TILE_OPC_BBST_SN, TILE_OPC_BBNS_SN, TILE_OPC_BBNST_SN,
  BITFIELD(51, 3) /* index 860 */,
  TILE_OPC_NONE, TILE_OPC_ADDIB, TILE_OPC_ADDIH, TILE_OPC_ADDI, CHILD(869),
  TILE_OPC_MAXIB_U, TILE_OPC_MAXIH, TILE_OPC_MFSPR,
  BITFIELD(31, 2) /* index 869 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, CHILD(874),
  BITFIELD(33, 2) /* index 874 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, CHILD(879),
  BITFIELD(35, 2) /* index 879 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, CHILD(884),
  BITFIELD(37, 2) /* index 884 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, CHILD(889),
  BITFIELD(39, 2) /* index 889 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, CHILD(894),
  BITFIELD(41, 2) /* index 894 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_INFO,
  BITFIELD(51, 3) /* index 899 */,
  TILE_OPC_MINIB_U, TILE_OPC_MINIH, TILE_OPC_MTSPR, CHILD(908),
  TILE_OPC_SEQIB, TILE_OPC_SEQIH, TILE_OPC_SEQI, TILE_OPC_SLTIB,
  BITFIELD(37, 2) /* index 908 */,
  TILE_OPC_ORI, TILE_OPC_ORI, TILE_OPC_ORI, CHILD(913),
  BITFIELD(39, 2) /* index 913 */,
  TILE_OPC_ORI, TILE_OPC_ORI, TILE_OPC_ORI, CHILD(918),
  BITFIELD(41, 2) /* index 918 */,
  TILE_OPC_ORI, TILE_OPC_ORI, TILE_OPC_ORI, TILE_OPC_MOVEI,
  BITFIELD(51, 3) /* index 923 */,
  TILE_OPC_SLTIB_U, TILE_OPC_SLTIH, TILE_OPC_SLTIH_U, TILE_OPC_SLTI,
  TILE_OPC_SLTI_U, TILE_OPC_XORI, TILE_OPC_LBADD, TILE_OPC_LBADD_U,
  BITFIELD(51, 3) /* index 932 */,
  TILE_OPC_LHADD, TILE_OPC_LHADD_U, TILE_OPC_LWADD, TILE_OPC_LWADD_NA,
  TILE_OPC_SBADD, TILE_OPC_SHADD, TILE_OPC_SWADD, TILE_OPC_NONE,
  BITFIELD(51, 3) /* index 941 */,
  TILE_OPC_NONE, TILE_OPC_ADDIB_SN, TILE_OPC_ADDIH_SN, TILE_OPC_ADDI_SN,
  TILE_OPC_ANDI_SN, TILE_OPC_MAXIB_U_SN, TILE_OPC_MAXIH_SN, TILE_OPC_MFSPR,
  BITFIELD(51, 3) /* index 950 */,
  TILE_OPC_MINIB_U_SN, TILE_OPC_MINIH_SN, TILE_OPC_MTSPR, CHILD(959),
  TILE_OPC_SEQIB_SN, TILE_OPC_SEQIH_SN, TILE_OPC_SEQI_SN, TILE_OPC_SLTIB_SN,
  BITFIELD(37, 2) /* index 959 */,
  TILE_OPC_ORI_SN, TILE_OPC_ORI_SN, TILE_OPC_ORI_SN, CHILD(964),
  BITFIELD(39, 2) /* index 964 */,
  TILE_OPC_ORI_SN, TILE_OPC_ORI_SN, TILE_OPC_ORI_SN, CHILD(969),
  BITFIELD(41, 2) /* index 969 */,
  TILE_OPC_ORI_SN, TILE_OPC_ORI_SN, TILE_OPC_ORI_SN, TILE_OPC_MOVEI_SN,
  BITFIELD(51, 3) /* index 974 */,
  TILE_OPC_SLTIB_U_SN, TILE_OPC_SLTIH_SN, TILE_OPC_SLTIH_U_SN,
  TILE_OPC_SLTI_SN, TILE_OPC_SLTI_U_SN, TILE_OPC_XORI_SN, TILE_OPC_LBADD_SN,
  TILE_OPC_LBADD_U_SN,
  BITFIELD(51, 3) /* index 983 */,
  TILE_OPC_LHADD_SN, TILE_OPC_LHADD_U_SN, TILE_OPC_LWADD_SN,
  TILE_OPC_LWADD_NA_SN, TILE_OPC_SBADD, TILE_OPC_SHADD, TILE_OPC_SWADD,
  TILE_OPC_NONE,
  BITFIELD(46, 7) /* index 992 */,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, CHILD(1121),
  CHILD(1121), CHILD(1121), CHILD(1121), CHILD(1124), CHILD(1124),
  CHILD(1124), CHILD(1124), CHILD(1127), CHILD(1127), CHILD(1127),
  CHILD(1127), CHILD(1130), CHILD(1130), CHILD(1130), CHILD(1130),
  CHILD(1133), CHILD(1133), CHILD(1133), CHILD(1133), CHILD(1136),
  CHILD(1136), CHILD(1136), CHILD(1136), CHILD(1139), CHILD(1139),
  CHILD(1139), CHILD(1139), CHILD(1142), CHILD(1142), CHILD(1142),
  CHILD(1142), CHILD(1145), CHILD(1145), CHILD(1145), CHILD(1145),
  CHILD(1148), CHILD(1148), CHILD(1148), CHILD(1148), CHILD(1151),
  CHILD(1242), CHILD(1290), CHILD(1323), TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1121 */,
  TILE_OPC_RLI, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1124 */,
  TILE_OPC_SHLIB, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1127 */,
  TILE_OPC_SHLIH, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1130 */,
  TILE_OPC_SHLI, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1133 */,
  TILE_OPC_SHRIB, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1136 */,
  TILE_OPC_SHRIH, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1139 */,
  TILE_OPC_SHRI, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1142 */,
  TILE_OPC_SRAIB, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1145 */,
  TILE_OPC_SRAIH, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1148 */,
  TILE_OPC_SRAI, TILE_OPC_NONE,
  BITFIELD(43, 3) /* index 1151 */,
  TILE_OPC_NONE, CHILD(1160), CHILD(1163), CHILD(1166), CHILD(1169),
  CHILD(1172), CHILD(1175), CHILD(1178),
  BITFIELD(53, 1) /* index 1160 */,
  TILE_OPC_DRAIN, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1163 */,
  TILE_OPC_DTLBPR, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1166 */,
  TILE_OPC_FINV, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1169 */,
  TILE_OPC_FLUSH, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1172 */,
  TILE_OPC_FNOP, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1175 */,
  TILE_OPC_ICOH, TILE_OPC_NONE,
  BITFIELD(31, 2) /* index 1178 */,
  CHILD(1183), CHILD(1211), CHILD(1239), CHILD(1239),
  BITFIELD(53, 1) /* index 1183 */,
  CHILD(1186), TILE_OPC_NONE,
  BITFIELD(33, 2) /* index 1186 */,
  TILE_OPC_ILL, TILE_OPC_ILL, TILE_OPC_ILL, CHILD(1191),
  BITFIELD(35, 2) /* index 1191 */,
  TILE_OPC_ILL, CHILD(1196), TILE_OPC_ILL, TILE_OPC_ILL,
  BITFIELD(37, 2) /* index 1196 */,
  TILE_OPC_ILL, CHILD(1201), TILE_OPC_ILL, TILE_OPC_ILL,
  BITFIELD(39, 2) /* index 1201 */,
  TILE_OPC_ILL, CHILD(1206), TILE_OPC_ILL, TILE_OPC_ILL,
  BITFIELD(41, 2) /* index 1206 */,
  TILE_OPC_ILL, TILE_OPC_ILL, TILE_OPC_BPT, TILE_OPC_ILL,
  BITFIELD(53, 1) /* index 1211 */,
  CHILD(1214), TILE_OPC_NONE,
  BITFIELD(33, 2) /* index 1214 */,
  TILE_OPC_ILL, TILE_OPC_ILL, TILE_OPC_ILL, CHILD(1219),
  BITFIELD(35, 2) /* index 1219 */,
  TILE_OPC_ILL, CHILD(1224), TILE_OPC_ILL, TILE_OPC_ILL,
  BITFIELD(37, 2) /* index 1224 */,
  TILE_OPC_ILL, CHILD(1229), TILE_OPC_ILL, TILE_OPC_ILL,
  BITFIELD(39, 2) /* index 1229 */,
  TILE_OPC_ILL, CHILD(1234), TILE_OPC_ILL, TILE_OPC_ILL,
  BITFIELD(41, 2) /* index 1234 */,
  TILE_OPC_ILL, TILE_OPC_ILL, TILE_OPC_RAISE, TILE_OPC_ILL,
  BITFIELD(53, 1) /* index 1239 */,
  TILE_OPC_ILL, TILE_OPC_NONE,
  BITFIELD(43, 3) /* index 1242 */,
  CHILD(1251), CHILD(1254), CHILD(1257), CHILD(1275), CHILD(1278),
  CHILD(1281), CHILD(1284), CHILD(1287),
  BITFIELD(53, 1) /* index 1251 */,
  TILE_OPC_INV, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1254 */,
  TILE_OPC_IRET, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1257 */,
  CHILD(1260), TILE_OPC_NONE,
  BITFIELD(31, 2) /* index 1260 */,
  TILE_OPC_LB, TILE_OPC_LB, TILE_OPC_LB, CHILD(1265),
  BITFIELD(33, 2) /* index 1265 */,
  TILE_OPC_LB, TILE_OPC_LB, TILE_OPC_LB, CHILD(1270),
  BITFIELD(35, 2) /* index 1270 */,
  TILE_OPC_LB, TILE_OPC_LB, TILE_OPC_LB, TILE_OPC_PREFETCH,
  BITFIELD(53, 1) /* index 1275 */,
  TILE_OPC_LB_U, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1278 */,
  TILE_OPC_LH, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1281 */,
  TILE_OPC_LH_U, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1284 */,
  TILE_OPC_LW, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1287 */,
  TILE_OPC_MF, TILE_OPC_NONE,
  BITFIELD(43, 3) /* index 1290 */,
  CHILD(1299), CHILD(1302), CHILD(1305), CHILD(1308), CHILD(1311),
  CHILD(1314), CHILD(1317), CHILD(1320),
  BITFIELD(53, 1) /* index 1299 */,
  TILE_OPC_NAP, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1302 */,
  TILE_OPC_NOP, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1305 */,
  TILE_OPC_SWINT0, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1308 */,
  TILE_OPC_SWINT1, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1311 */,
  TILE_OPC_SWINT2, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1314 */,
  TILE_OPC_SWINT3, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1317 */,
  TILE_OPC_TNS, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1320 */,
  TILE_OPC_WH64, TILE_OPC_NONE,
  BITFIELD(43, 2) /* index 1323 */,
  CHILD(1328), TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  BITFIELD(45, 1) /* index 1328 */,
  CHILD(1331), TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1331 */,
  TILE_OPC_LW_NA, TILE_OPC_NONE,
  BITFIELD(46, 7) /* index 1334 */,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, CHILD(1463),
  CHILD(1463), CHILD(1463), CHILD(1463), CHILD(1466), CHILD(1466),
  CHILD(1466), CHILD(1466), CHILD(1469), CHILD(1469), CHILD(1469),
  CHILD(1469), CHILD(1472), CHILD(1472), CHILD(1472), CHILD(1472),
  CHILD(1475), CHILD(1475), CHILD(1475), CHILD(1475), CHILD(1478),
  CHILD(1478), CHILD(1478), CHILD(1478), CHILD(1481), CHILD(1481),
  CHILD(1481), CHILD(1481), CHILD(1484), CHILD(1484), CHILD(1484),
  CHILD(1484), CHILD(1487), CHILD(1487), CHILD(1487), CHILD(1487),
  CHILD(1490), CHILD(1490), CHILD(1490), CHILD(1490), CHILD(1151),
  CHILD(1493), CHILD(1517), CHILD(1529), TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1463 */,
  TILE_OPC_RLI_SN, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1466 */,
  TILE_OPC_SHLIB_SN, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1469 */,
  TILE_OPC_SHLIH_SN, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1472 */,
  TILE_OPC_SHLI_SN, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1475 */,
  TILE_OPC_SHRIB_SN, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1478 */,
  TILE_OPC_SHRIH_SN, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1481 */,
  TILE_OPC_SHRI_SN, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1484 */,
  TILE_OPC_SRAIB_SN, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1487 */,
  TILE_OPC_SRAIH_SN, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1490 */,
  TILE_OPC_SRAI_SN, TILE_OPC_NONE,
  BITFIELD(43, 3) /* index 1493 */,
  CHILD(1251), CHILD(1254), CHILD(1502), CHILD(1505), CHILD(1508),
  CHILD(1511), CHILD(1514), CHILD(1287),
  BITFIELD(53, 1) /* index 1502 */,
  TILE_OPC_LB_SN, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1505 */,
  TILE_OPC_LB_U_SN, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1508 */,
  TILE_OPC_LH_SN, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1511 */,
  TILE_OPC_LH_U_SN, TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1514 */,
  TILE_OPC_LW_SN, TILE_OPC_NONE,
  BITFIELD(43, 3) /* index 1517 */,
  CHILD(1299), CHILD(1302), CHILD(1305), CHILD(1308), CHILD(1311),
  CHILD(1314), CHILD(1526), CHILD(1320),
  BITFIELD(53, 1) /* index 1526 */,
  TILE_OPC_TNS_SN, TILE_OPC_NONE,
  BITFIELD(43, 2) /* index 1529 */,
  CHILD(1534), TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  BITFIELD(45, 1) /* index 1534 */,
  CHILD(1537), TILE_OPC_NONE,
  BITFIELD(53, 1) /* index 1537 */,
  TILE_OPC_LW_NA_SN, TILE_OPC_NONE,
};

static const unsigned short decode_Y0_fsm[168] =
{
  BITFIELD(27, 4) /* index 0 */,
  TILE_OPC_NONE, CHILD(17), CHILD(22), CHILD(27), CHILD(47), CHILD(52),
  CHILD(57), CHILD(62), CHILD(67), TILE_OPC_ADDI, CHILD(72), CHILD(102),
  TILE_OPC_SEQI, CHILD(117), TILE_OPC_SLTI, TILE_OPC_SLTI_U,
  BITFIELD(18, 2) /* index 17 */,
  TILE_OPC_ADD, TILE_OPC_S1A, TILE_OPC_S2A, TILE_OPC_SUB,
  BITFIELD(18, 2) /* index 22 */,
  TILE_OPC_MNZ, TILE_OPC_MVNZ, TILE_OPC_MVZ, TILE_OPC_MZ,
  BITFIELD(18, 2) /* index 27 */,
  TILE_OPC_AND, TILE_OPC_NOR, CHILD(32), TILE_OPC_XOR,
  BITFIELD(12, 2) /* index 32 */,
  TILE_OPC_OR, TILE_OPC_OR, TILE_OPC_OR, CHILD(37),
  BITFIELD(14, 2) /* index 37 */,
  TILE_OPC_OR, TILE_OPC_OR, TILE_OPC_OR, CHILD(42),
  BITFIELD(16, 2) /* index 42 */,
  TILE_OPC_OR, TILE_OPC_OR, TILE_OPC_OR, TILE_OPC_MOVE,
  BITFIELD(18, 2) /* index 47 */,
  TILE_OPC_RL, TILE_OPC_SHL, TILE_OPC_SHR, TILE_OPC_SRA,
  BITFIELD(18, 2) /* index 52 */,
  TILE_OPC_SLTE, TILE_OPC_SLTE_U, TILE_OPC_SLT, TILE_OPC_SLT_U,
  BITFIELD(18, 2) /* index 57 */,
  TILE_OPC_MULHLSA_UU, TILE_OPC_S3A, TILE_OPC_SEQ, TILE_OPC_SNE,
  BITFIELD(18, 2) /* index 62 */,
  TILE_OPC_MULHH_SS, TILE_OPC_MULHH_UU, TILE_OPC_MULLL_SS, TILE_OPC_MULLL_UU,
  BITFIELD(18, 2) /* index 67 */,
  TILE_OPC_MULHHA_SS, TILE_OPC_MULHHA_UU, TILE_OPC_MULLLA_SS,
  TILE_OPC_MULLLA_UU,
  BITFIELD(0, 2) /* index 72 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, CHILD(77),
  BITFIELD(2, 2) /* index 77 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, CHILD(82),
  BITFIELD(4, 2) /* index 82 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, CHILD(87),
  BITFIELD(6, 2) /* index 87 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, CHILD(92),
  BITFIELD(8, 2) /* index 92 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, CHILD(97),
  BITFIELD(10, 2) /* index 97 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_INFO,
  BITFIELD(6, 2) /* index 102 */,
  TILE_OPC_ORI, TILE_OPC_ORI, TILE_OPC_ORI, CHILD(107),
  BITFIELD(8, 2) /* index 107 */,
  TILE_OPC_ORI, TILE_OPC_ORI, TILE_OPC_ORI, CHILD(112),
  BITFIELD(10, 2) /* index 112 */,
  TILE_OPC_ORI, TILE_OPC_ORI, TILE_OPC_ORI, TILE_OPC_MOVEI,
  BITFIELD(15, 5) /* index 117 */,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_RLI,
  TILE_OPC_RLI, TILE_OPC_RLI, TILE_OPC_RLI, TILE_OPC_SHLI, TILE_OPC_SHLI,
  TILE_OPC_SHLI, TILE_OPC_SHLI, TILE_OPC_SHRI, TILE_OPC_SHRI, TILE_OPC_SHRI,
  TILE_OPC_SHRI, TILE_OPC_SRAI, TILE_OPC_SRAI, TILE_OPC_SRAI, TILE_OPC_SRAI,
  CHILD(150), CHILD(159), TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE,
  BITFIELD(12, 3) /* index 150 */,
  TILE_OPC_NONE, TILE_OPC_BITX, TILE_OPC_BYTEX, TILE_OPC_CLZ, TILE_OPC_CTZ,
  TILE_OPC_FNOP, TILE_OPC_NOP, TILE_OPC_PCNT,
  BITFIELD(12, 3) /* index 159 */,
  TILE_OPC_TBLIDXB0, TILE_OPC_TBLIDXB1, TILE_OPC_TBLIDXB2, TILE_OPC_TBLIDXB3,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
};

static const unsigned short decode_Y1_fsm[140] =
{
  BITFIELD(59, 4) /* index 0 */,
  TILE_OPC_NONE, CHILD(17), CHILD(22), CHILD(27), CHILD(47), CHILD(52),
  CHILD(57), TILE_OPC_ADDI, CHILD(62), CHILD(92), TILE_OPC_SEQI, CHILD(107),
  TILE_OPC_SLTI, TILE_OPC_SLTI_U, TILE_OPC_NONE, TILE_OPC_NONE,
  BITFIELD(49, 2) /* index 17 */,
  TILE_OPC_ADD, TILE_OPC_S1A, TILE_OPC_S2A, TILE_OPC_SUB,
  BITFIELD(49, 2) /* index 22 */,
  TILE_OPC_NONE, TILE_OPC_MNZ, TILE_OPC_MZ, TILE_OPC_NONE,
  BITFIELD(49, 2) /* index 27 */,
  TILE_OPC_AND, TILE_OPC_NOR, CHILD(32), TILE_OPC_XOR,
  BITFIELD(43, 2) /* index 32 */,
  TILE_OPC_OR, TILE_OPC_OR, TILE_OPC_OR, CHILD(37),
  BITFIELD(45, 2) /* index 37 */,
  TILE_OPC_OR, TILE_OPC_OR, TILE_OPC_OR, CHILD(42),
  BITFIELD(47, 2) /* index 42 */,
  TILE_OPC_OR, TILE_OPC_OR, TILE_OPC_OR, TILE_OPC_MOVE,
  BITFIELD(49, 2) /* index 47 */,
  TILE_OPC_RL, TILE_OPC_SHL, TILE_OPC_SHR, TILE_OPC_SRA,
  BITFIELD(49, 2) /* index 52 */,
  TILE_OPC_SLTE, TILE_OPC_SLTE_U, TILE_OPC_SLT, TILE_OPC_SLT_U,
  BITFIELD(49, 2) /* index 57 */,
  TILE_OPC_NONE, TILE_OPC_S3A, TILE_OPC_SEQ, TILE_OPC_SNE,
  BITFIELD(31, 2) /* index 62 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, CHILD(67),
  BITFIELD(33, 2) /* index 67 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, CHILD(72),
  BITFIELD(35, 2) /* index 72 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, CHILD(77),
  BITFIELD(37, 2) /* index 77 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, CHILD(82),
  BITFIELD(39, 2) /* index 82 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, CHILD(87),
  BITFIELD(41, 2) /* index 87 */,
  TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_ANDI, TILE_OPC_INFO,
  BITFIELD(37, 2) /* index 92 */,
  TILE_OPC_ORI, TILE_OPC_ORI, TILE_OPC_ORI, CHILD(97),
  BITFIELD(39, 2) /* index 97 */,
  TILE_OPC_ORI, TILE_OPC_ORI, TILE_OPC_ORI, CHILD(102),
  BITFIELD(41, 2) /* index 102 */,
  TILE_OPC_ORI, TILE_OPC_ORI, TILE_OPC_ORI, TILE_OPC_MOVEI,
  BITFIELD(48, 3) /* index 107 */,
  TILE_OPC_NONE, TILE_OPC_RLI, TILE_OPC_SHLI, TILE_OPC_SHRI, TILE_OPC_SRAI,
  CHILD(116), TILE_OPC_NONE, TILE_OPC_NONE,
  BITFIELD(43, 3) /* index 116 */,
  TILE_OPC_NONE, CHILD(125), CHILD(130), CHILD(135), TILE_OPC_NONE,
  TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  BITFIELD(46, 2) /* index 125 */,
  TILE_OPC_FNOP, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  BITFIELD(46, 2) /* index 130 */,
  TILE_OPC_ILL, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
  BITFIELD(46, 2) /* index 135 */,
  TILE_OPC_NOP, TILE_OPC_NONE, TILE_OPC_NONE, TILE_OPC_NONE,
};

static const unsigned short decode_Y2_fsm[24] =
{
  BITFIELD(56, 3) /* index 0 */,
  CHILD(9), TILE_OPC_LB_U, TILE_OPC_LH, TILE_OPC_LH_U, TILE_OPC_LW,
  TILE_OPC_SB, TILE_OPC_SH, TILE_OPC_SW,
  BITFIELD(20, 2) /* index 9 */,
  TILE_OPC_LB, TILE_OPC_LB, TILE_OPC_LB, CHILD(14),
  BITFIELD(22, 2) /* index 14 */,
  TILE_OPC_LB, TILE_OPC_LB, TILE_OPC_LB, CHILD(19),
  BITFIELD(24, 2) /* index 19 */,
  TILE_OPC_LB, TILE_OPC_LB, TILE_OPC_LB, TILE_OPC_PREFETCH,
};

#undef BITFIELD
#undef CHILD
const unsigned short * const
tile_bundle_decoder_fsms[TILE_NUM_PIPELINE_ENCODINGS] =
{
  decode_X0_fsm,
  decode_X1_fsm,
  decode_Y0_fsm,
  decode_Y1_fsm,
  decode_Y2_fsm
};
const struct tile_operand tile_operands[43] =
{
  {
    TILE_OP_TYPE_IMMEDIATE, BFD_RELOC(TILE_IMM8_X0),
    8, 1, 0, 0, 0, 0,
    create_Imm8_X0, get_Imm8_X0
  },
  {
    TILE_OP_TYPE_IMMEDIATE, BFD_RELOC(TILE_IMM8_X1),
    8, 1, 0, 0, 0, 0,
    create_Imm8_X1, get_Imm8_X1
  },
  {
    TILE_OP_TYPE_IMMEDIATE, BFD_RELOC(TILE_IMM8_Y0),
    8, 1, 0, 0, 0, 0,
    create_Imm8_Y0, get_Imm8_Y0
  },
  {
    TILE_OP_TYPE_IMMEDIATE, BFD_RELOC(TILE_IMM8_Y1),
    8, 1, 0, 0, 0, 0,
    create_Imm8_Y1, get_Imm8_Y1
  },
  {
    TILE_OP_TYPE_IMMEDIATE, BFD_RELOC(TILE_IMM16_X0),
    16, 1, 0, 0, 0, 0,
    create_Imm16_X0, get_Imm16_X0
  },
  {
    TILE_OP_TYPE_IMMEDIATE, BFD_RELOC(TILE_IMM16_X1),
    16, 1, 0, 0, 0, 0,
    create_Imm16_X1, get_Imm16_X1
  },
  {
    TILE_OP_TYPE_ADDRESS, BFD_RELOC(TILE_JOFFLONG_X1),
    29, 1, 0, 0, 1, TILE_LOG2_BUNDLE_ALIGNMENT_IN_BYTES,
    create_JOffLong_X1, get_JOffLong_X1
  },
  {
    TILE_OP_TYPE_REGISTER, BFD_RELOC(NONE),
    6, 0, 0, 1, 0, 0,
    create_Dest_X0, get_Dest_X0
  },
  {
    TILE_OP_TYPE_REGISTER, BFD_RELOC(NONE),
    6, 0, 1, 0, 0, 0,
    create_SrcA_X0, get_SrcA_X0
  },
  {
    TILE_OP_TYPE_REGISTER, BFD_RELOC(NONE),
    6, 0, 0, 1, 0, 0,
    create_Dest_X1, get_Dest_X1
  },
  {
    TILE_OP_TYPE_REGISTER, BFD_RELOC(NONE),
    6, 0, 1, 0, 0, 0,
    create_SrcA_X1, get_SrcA_X1
  },
  {
    TILE_OP_TYPE_REGISTER, BFD_RELOC(NONE),
    6, 0, 0, 1, 0, 0,
    create_Dest_Y0, get_Dest_Y0
  },
  {
    TILE_OP_TYPE_REGISTER, BFD_RELOC(NONE),
    6, 0, 1, 0, 0, 0,
    create_SrcA_Y0, get_SrcA_Y0
  },
  {
    TILE_OP_TYPE_REGISTER, BFD_RELOC(NONE),
    6, 0, 0, 1, 0, 0,
    create_Dest_Y1, get_Dest_Y1
  },
  {
    TILE_OP_TYPE_REGISTER, BFD_RELOC(NONE),
    6, 0, 1, 0, 0, 0,
    create_SrcA_Y1, get_SrcA_Y1
  },
  {
    TILE_OP_TYPE_REGISTER, BFD_RELOC(NONE),
    6, 0, 1, 0, 0, 0,
    create_SrcA_Y2, get_SrcA_Y2
  },
  {
    TILE_OP_TYPE_REGISTER, BFD_RELOC(NONE),
    6, 0, 1, 0, 0, 0,
    create_SrcB_X0, get_SrcB_X0
  },
  {
    TILE_OP_TYPE_REGISTER, BFD_RELOC(NONE),
    6, 0, 1, 0, 0, 0,
    create_SrcB_X1, get_SrcB_X1
  },
  {
    TILE_OP_TYPE_REGISTER, BFD_RELOC(NONE),
    6, 0, 1, 0, 0, 0,
    create_SrcB_Y0, get_SrcB_Y0
  },
  {
    TILE_OP_TYPE_REGISTER, BFD_RELOC(NONE),
    6, 0, 1, 0, 0, 0,
    create_SrcB_Y1, get_SrcB_Y1
  },
  {
    TILE_OP_TYPE_ADDRESS, BFD_RELOC(TILE_BROFF_X1),
    17, 1, 0, 0, 1, TILE_LOG2_BUNDLE_ALIGNMENT_IN_BYTES,
    create_BrOff_X1, get_BrOff_X1
  },
  {
    TILE_OP_TYPE_REGISTER, BFD_RELOC(NONE),
    6, 0, 1, 1, 0, 0,
    create_Dest_X0, get_Dest_X0
  },
  {
    TILE_OP_TYPE_ADDRESS, BFD_RELOC(NONE),
    28, 1, 0, 0, 1, TILE_LOG2_BUNDLE_ALIGNMENT_IN_BYTES,
    create_JOff_X1, get_JOff_X1
  },
  {
    TILE_OP_TYPE_REGISTER, BFD_RELOC(NONE),
    6, 0, 0, 1, 0, 0,
    create_SrcBDest_Y2, get_SrcBDest_Y2
  },
  {
    TILE_OP_TYPE_REGISTER, BFD_RELOC(NONE),
    6, 0, 1, 1, 0, 0,
    create_SrcA_X1, get_SrcA_X1
  },
  {
    TILE_OP_TYPE_SPR, BFD_RELOC(TILE_MF_IMM15_X1),
    15, 0, 0, 0, 0, 0,
    create_MF_Imm15_X1, get_MF_Imm15_X1
  },
  {
    TILE_OP_TYPE_IMMEDIATE, BFD_RELOC(TILE_MMSTART_X0),
    5, 0, 0, 0, 0, 0,
    create_MMStart_X0, get_MMStart_X0
  },
  {
    TILE_OP_TYPE_IMMEDIATE, BFD_RELOC(TILE_MMEND_X0),
    5, 0, 0, 0, 0, 0,
    create_MMEnd_X0, get_MMEnd_X0
  },
  {
    TILE_OP_TYPE_IMMEDIATE, BFD_RELOC(TILE_MMSTART_X1),
    5, 0, 0, 0, 0, 0,
    create_MMStart_X1, get_MMStart_X1
  },
  {
    TILE_OP_TYPE_IMMEDIATE, BFD_RELOC(TILE_MMEND_X1),
    5, 0, 0, 0, 0, 0,
    create_MMEnd_X1, get_MMEnd_X1
  },
  {
    TILE_OP_TYPE_SPR, BFD_RELOC(TILE_MT_IMM15_X1),
    15, 0, 0, 0, 0, 0,
    create_MT_Imm15_X1, get_MT_Imm15_X1
  },
  {
    TILE_OP_TYPE_REGISTER, BFD_RELOC(NONE),
    6, 0, 1, 1, 0, 0,
    create_Dest_Y0, get_Dest_Y0
  },
  {
    TILE_OP_TYPE_IMMEDIATE, BFD_RELOC(TILE_SHAMT_X0),
    5, 0, 0, 0, 0, 0,
    create_ShAmt_X0, get_ShAmt_X0
  },
  {
    TILE_OP_TYPE_IMMEDIATE, BFD_RELOC(TILE_SHAMT_X1),
    5, 0, 0, 0, 0, 0,
    create_ShAmt_X1, get_ShAmt_X1
  },
  {
    TILE_OP_TYPE_IMMEDIATE, BFD_RELOC(TILE_SHAMT_Y0),
    5, 0, 0, 0, 0, 0,
    create_ShAmt_Y0, get_ShAmt_Y0
  },
  {
    TILE_OP_TYPE_IMMEDIATE, BFD_RELOC(TILE_SHAMT_Y1),
    5, 0, 0, 0, 0, 0,
    create_ShAmt_Y1, get_ShAmt_Y1
  },
  {
    TILE_OP_TYPE_REGISTER, BFD_RELOC(NONE),
    6, 0, 1, 0, 0, 0,
    create_SrcBDest_Y2, get_SrcBDest_Y2
  },
  {
    TILE_OP_TYPE_IMMEDIATE, BFD_RELOC(NONE),
    8, 1, 0, 0, 0, 0,
    create_Dest_Imm8_X1, get_Dest_Imm8_X1
  },
  {
    TILE_OP_TYPE_ADDRESS, BFD_RELOC(TILE_SN_BROFF),
    10, 1, 0, 0, 1, TILE_LOG2_SN_INSTRUCTION_SIZE_IN_BYTES,
    create_BrOff_SN, get_BrOff_SN
  },
  {
    TILE_OP_TYPE_IMMEDIATE, BFD_RELOC(TILE_SN_UIMM8),
    8, 0, 0, 0, 0, 0,
    create_Imm8_SN, get_Imm8_SN
  },
  {
    TILE_OP_TYPE_IMMEDIATE, BFD_RELOC(TILE_SN_IMM8),
    8, 1, 0, 0, 0, 0,
    create_Imm8_SN, get_Imm8_SN
  },
  {
    TILE_OP_TYPE_REGISTER, BFD_RELOC(NONE),
    2, 0, 0, 1, 0, 0,
    create_Dest_SN, get_Dest_SN
  },
  {
    TILE_OP_TYPE_REGISTER, BFD_RELOC(NONE),
    2, 0, 1, 0, 0, 0,
    create_Src_SN, get_Src_SN
  }
};




/* Given a set of bundle bits and the lookup FSM for a specific pipe,
 * returns which instruction the bundle contains in that pipe.
 */
static const struct tile_opcode *
find_opcode(tile_bundle_bits bits, const unsigned short *table)
{
  int index = 0;

  while (1)
  {
    unsigned short bitspec = table[index];
    unsigned int bitfield =
      ((unsigned int)(bits >> (bitspec & 63))) & (bitspec >> 6);

    unsigned short next = table[index + 1 + bitfield];
    if (next <= TILE_OPC_NONE)
      return &tile_opcodes[next];

    index = next - TILE_OPC_NONE;
  }
}


int
parse_insn_tile(tile_bundle_bits bits,
                unsigned int pc,
                struct tile_decoded_instruction
                decoded[TILE_MAX_INSTRUCTIONS_PER_BUNDLE])
{
  int num_instructions = 0;
  int pipe;

  int min_pipe, max_pipe;
  if ((bits & TILE_BUNDLE_Y_ENCODING_MASK) == 0)
  {
    min_pipe = TILE_PIPELINE_X0;
    max_pipe = TILE_PIPELINE_X1;
  }
  else
  {
    min_pipe = TILE_PIPELINE_Y0;
    max_pipe = TILE_PIPELINE_Y2;
  }

  /* For each pipe, find an instruction that fits. */
  for (pipe = min_pipe; pipe <= max_pipe; pipe++)
  {
    const struct tile_opcode *opc;
    struct tile_decoded_instruction *d;
    int i;

    d = &decoded[num_instructions++];
    opc = find_opcode (bits, tile_bundle_decoder_fsms[pipe]);
    d->opcode = opc;

    /* Decode each operand, sign extending, etc. as appropriate. */
    for (i = 0; i < opc->num_operands; i++)
    {
      const struct tile_operand *op =
        &tile_operands[opc->operands[pipe][i]];
      int opval = op->extract (bits);
      if (op->is_signed)
      {
        /* Sign-extend the operand. */
        int shift = (int)((sizeof(int) * 8) - op->num_bits);
        opval = (opval << shift) >> shift;
      }

      /* Adjust PC-relative scaled branch offsets. */
      if (op->type == TILE_OP_TYPE_ADDRESS)
      {
        opval *= TILE_BUNDLE_SIZE_IN_BYTES;
        opval += (int)pc;
      }

      /* Record the final value. */
      d->operands[i] = op;
      d->operand_values[i] = opval;
    }
  }

  return num_instructions;
}
