
/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2017, The Linux Foundation. All rights reserved.
 */

#ifndef QCOM_PHY_QMP_QSERDES_TXRX_V5_H_
#define QCOM_PHY_QMP_QSERDES_TXRX_V5_H_

/* Only for QMP V5 PHY - TX registers */
#define QSERDES_V5_TX_BIST_MODE_LANENO			0x000
#define QSERDES_V5_TX_BIST_INVERT			0x004
#define QSERDES_V5_TX_CLKBUF_ENABLE			0x008
#define QSERDES_V5_TX_TX_EMP_POST1_LVL			0x00c
#define QSERDES_V5_TX_TX_IDLE_LVL_LARGE_AMP		0x010
#define QSERDES_V5_TX_TX_DRV_LVL			0x014
#define QSERDES_V5_TX_TX_DRV_LVL_OFFSET			0x018
#define QSERDES_V5_TX_RESET_TSYNC_EN			0x01c
#define QSERDES_V5_TX_PRE_STALL_LDO_BOOST_EN		0x020
#define QSERDES_V5_TX_TX_BAND				0x024
#define QSERDES_V5_TX_SLEW_CNTL				0x028
#define QSERDES_V5_TX_INTERFACE_SELECT			0x02c
#define QSERDES_V5_TX_LPB_EN				0x030
#define QSERDES_V5_TX_RES_CODE_LANE_TX			0x034
#define QSERDES_V5_TX_RES_CODE_LANE_RX			0x038
#define QSERDES_V5_TX_RES_CODE_LANE_OFFSET_TX		0x03c
#define QSERDES_V5_TX_RES_CODE_LANE_OFFSET_RX		0x040
#define QSERDES_V5_TX_PERL_LENGTH1			0x044
#define QSERDES_V5_TX_PERL_LENGTH2			0x048
#define QSERDES_V5_TX_SERDES_BYP_EN_OUT			0x04c
#define QSERDES_V5_TX_DEBUG_BUS_SEL			0x050
#define QSERDES_V5_TX_TRANSCEIVER_BIAS_EN		0x054
#define QSERDES_V5_TX_HIGHZ_DRVR_EN			0x058
#define QSERDES_V5_TX_TX_POL_INV			0x05c
#define QSERDES_V5_TX_PARRATE_REC_DETECT_IDLE_EN	0x060
#define QSERDES_V5_TX_BIST_PATTERN1			0x064
#define QSERDES_V5_TX_BIST_PATTERN2			0x068
#define QSERDES_V5_TX_BIST_PATTERN3			0x06c
#define QSERDES_V5_TX_BIST_PATTERN4			0x070
#define QSERDES_V5_TX_BIST_PATTERN5			0x074
#define QSERDES_V5_TX_BIST_PATTERN6			0x078
#define QSERDES_V5_TX_BIST_PATTERN7			0x07c
#define QSERDES_V5_TX_BIST_PATTERN8			0x080
#define QSERDES_V5_TX_LANE_MODE_1			0x084
#define QSERDES_V5_TX_LANE_MODE_2			0x088
#define QSERDES_V5_TX_LANE_MODE_3			0x08c
#define QSERDES_V5_TX_LANE_MODE_4			0x090
#define QSERDES_V5_TX_LANE_MODE_5			0x094
#define QSERDES_V5_TX_ATB_SEL1				0x098
#define QSERDES_V5_TX_ATB_SEL2				0x09c
#define QSERDES_V5_TX_RCV_DETECT_LVL			0x0a0
#define QSERDES_V5_TX_RCV_DETECT_LVL_2			0x0a4
#define QSERDES_V5_TX_PRBS_SEED1			0x0a8
#define QSERDES_V5_TX_PRBS_SEED2			0x0ac
#define QSERDES_V5_TX_PRBS_SEED3			0x0b0
#define QSERDES_V5_TX_PRBS_SEED4			0x0b4
#define QSERDES_V5_TX_RESET_GEN				0x0b8
#define QSERDES_V5_TX_RESET_GEN_MUXES			0x0bc
#define QSERDES_V5_TX_TRAN_DRVR_EMP_EN			0x0c0
#define QSERDES_V5_TX_TX_INTERFACE_MODE			0x0c4
#define QSERDES_V5_TX_VMODE_CTRL1			0x0c8
#define QSERDES_V5_TX_ALOG_OBSV_BUS_CTRL_1		0x0cc
#define QSERDES_V5_TX_BIST_STATUS			0x0d0
#define QSERDES_V5_TX_BIST_ERROR_COUNT1			0x0d4
#define QSERDES_V5_TX_BIST_ERROR_COUNT2			0x0d8
#define QSERDES_V5_TX_ALOG_OBSV_BUS_STATUS_1		0x0dc
#define QSERDES_V5_TX_LANE_DIG_CONFIG			0x0e0
#define QSERDES_V5_TX_PI_QEC_CTRL			0x0e4
#define QSERDES_V5_TX_PRE_EMPH				0x0e8
#define QSERDES_V5_TX_SW_RESET				0x0ec
#define QSERDES_V5_TX_DCC_OFFSET			0x0f0
#define QSERDES_V5_TX_DCC_CMUX_POSTCAL_OFFSET		0x0f4
#define QSERDES_V5_TX_DCC_CMUX_CAL_CTRL1		0x0f8
#define QSERDES_V5_TX_DCC_CMUX_CAL_CTRL2		0x0fc
#define QSERDES_V5_TX_DIG_BKUP_CTRL			0x100
#define QSERDES_V5_TX_DEBUG_BUS0			0x104
#define QSERDES_V5_TX_DEBUG_BUS1			0x108
#define QSERDES_V5_TX_DEBUG_BUS2			0x10c
#define QSERDES_V5_TX_DEBUG_BUS3			0x110
#define QSERDES_V5_TX_READ_EQCODE			0x114
#define QSERDES_V5_TX_READ_OFFSETCODE			0x118
#define QSERDES_V5_TX_IA_ERROR_COUNTER_LOW		0x11c
#define QSERDES_V5_TX_IA_ERROR_COUNTER_HIGH		0x120
#define QSERDES_V5_TX_VGA_READ_CODE			0x124
#define QSERDES_V5_TX_VTH_READ_CODE			0x128
#define QSERDES_V5_TX_DFE_TAP1_READ_CODE		0x12c
#define QSERDES_V5_TX_DFE_TAP2_READ_CODE		0x130
#define QSERDES_V5_TX_IDAC_STATUS_I			0x134
#define QSERDES_V5_TX_IDAC_STATUS_IBAR			0x138
#define QSERDES_V5_TX_IDAC_STATUS_Q			0x13c
#define QSERDES_V5_TX_IDAC_STATUS_QBAR			0x140
#define QSERDES_V5_TX_IDAC_STATUS_A			0x144
#define QSERDES_V5_TX_IDAC_STATUS_ABAR			0x148
#define QSERDES_V5_TX_IDAC_STATUS_SM_ON			0x14c
#define QSERDES_V5_TX_IDAC_STATUS_CAL_DONE		0x150
#define QSERDES_V5_TX_IDAC_STATUS_SIGNERROR		0x154
#define QSERDES_V5_TX_DCC_CAL_STATUS			0x158
#define QSERDES_V5_TX_DCC_READ_CODE_STATUS		0x15c

/* Only for QMP V5 PHY - RX registers */
#define QSERDES_V5_RX_UCDR_FO_GAIN_HALF			0x000
#define QSERDES_V5_RX_UCDR_FO_GAIN_QUARTER		0x004
#define QSERDES_V5_RX_UCDR_FO_GAIN			0x008
#define QSERDES_V5_RX_UCDR_SO_GAIN_HALF			0x00c
#define QSERDES_V5_RX_UCDR_SO_GAIN_QUARTER		0x010
#define QSERDES_V5_RX_UCDR_SO_GAIN			0x014
#define QSERDES_V5_RX_UCDR_SVS_FO_GAIN_HALF		0x018
#define QSERDES_V5_RX_UCDR_SVS_FO_GAIN_QUARTER		0x01c
#define QSERDES_V5_RX_UCDR_SVS_FO_GAIN			0x020
#define QSERDES_V5_RX_UCDR_SVS_SO_GAIN_HALF		0x024
#define QSERDES_V5_RX_UCDR_SVS_SO_GAIN_QUARTER		0x028
#define QSERDES_V5_RX_UCDR_SVS_SO_GAIN			0x02c
#define QSERDES_V5_RX_UCDR_FASTLOCK_FO_GAIN		0x030
#define QSERDES_V5_RX_UCDR_SO_SATURATION_AND_ENABLE	0x034
#define QSERDES_V5_RX_UCDR_FO_TO_SO_DELAY		0x038
#define QSERDES_V5_RX_UCDR_FASTLOCK_COUNT_LOW		0x03c
#define QSERDES_V5_RX_UCDR_FASTLOCK_COUNT_HIGH		0x040
#define QSERDES_V5_RX_UCDR_PI_CONTROLS			0x044
#define QSERDES_V5_RX_UCDR_PI_CTRL2			0x048
#define QSERDES_V5_RX_UCDR_SB2_THRESH1			0x04c
#define QSERDES_V5_RX_UCDR_SB2_THRESH2			0x050
#define QSERDES_V5_RX_UCDR_SB2_GAIN1			0x054
#define QSERDES_V5_RX_UCDR_SB2_GAIN2			0x058
#define QSERDES_V5_RX_AUX_CONTROL			0x05c
#define QSERDES_V5_RX_AUX_DATA_TCOARSE_TFINE		0x060
#define QSERDES_V5_RX_RCLK_AUXDATA_SEL			0x064
#define QSERDES_V5_RX_AC_JTAG_ENABLE			0x068
#define QSERDES_V5_RX_AC_JTAG_INITP			0x06c
#define QSERDES_V5_RX_AC_JTAG_INITN			0x070
#define QSERDES_V5_RX_AC_JTAG_LVL			0x074
#define QSERDES_V5_RX_AC_JTAG_MODE			0x078
#define QSERDES_V5_RX_AC_JTAG_RESET			0x07c
#define QSERDES_V5_RX_RX_TERM_BW			0x080
#define QSERDES_V5_RX_RX_RCVR_IQ_EN			0x084
#define QSERDES_V5_RX_RX_IDAC_I_DC_OFFSETS		0x088
#define QSERDES_V5_RX_RX_IDAC_IBAR_DC_OFFSETS		0x08c
#define QSERDES_V5_RX_RX_IDAC_Q_DC_OFFSETS		0x090
#define QSERDES_V5_RX_RX_IDAC_QBAR_DC_OFFSETS		0x094
#define QSERDES_V5_RX_RX_IDAC_A_DC_OFFSETS		0x098
#define QSERDES_V5_RX_RX_IDAC_ABAR_DC_OFFSETS		0x09c
#define QSERDES_V5_RX_RX_IDAC_EN			0x0a0
#define QSERDES_V5_RX_RX_IDAC_ENABLES			0x0a4
#define QSERDES_V5_RX_RX_IDAC_SIGN			0x0a8
#define QSERDES_V5_RX_RX_HIGHZ_HIGHRATE			0x0ac
#define QSERDES_V5_RX_RX_TERM_AC_BYPASS_DC_COUPLE_OFFSET 0x0b0
#define QSERDES_V5_RX_DFE_1				0x0b4
#define QSERDES_V5_RX_DFE_2				0x0b8
#define QSERDES_V5_RX_DFE_3				0x0bc
#define QSERDES_V5_RX_DFE_4				0x0c0
#define QSERDES_V5_RX_TX_ADAPT_PRE_THRESH1		0x0c4
#define QSERDES_V5_RX_TX_ADAPT_PRE_THRESH2		0x0c8
#define QSERDES_V5_RX_TX_ADAPT_POST_THRESH		0x0cc
#define QSERDES_V5_RX_TX_ADAPT_MAIN_THRESH		0x0d0
#define QSERDES_V5_RX_VGA_CAL_CNTRL1			0x0d4
#define QSERDES_V5_RX_VGA_CAL_CNTRL2			0x0d8
#define QSERDES_V5_RX_GM_CAL				0x0dc
#define QSERDES_V5_RX_RX_VGA_GAIN2_LSB			0x0e0
#define QSERDES_V5_RX_RX_VGA_GAIN2_MSB			0x0e4
#define QSERDES_V5_RX_RX_EQU_ADAPTOR_CNTRL1		0x0e8
#define QSERDES_V5_RX_RX_EQU_ADAPTOR_CNTRL2		0x0ec
#define QSERDES_V5_RX_RX_EQU_ADAPTOR_CNTRL3		0x0f0
#define QSERDES_V5_RX_RX_EQU_ADAPTOR_CNTRL4		0x0f4
#define QSERDES_V5_RX_RX_IDAC_TSETTLE_LOW		0x0f8
#define QSERDES_V5_RX_RX_IDAC_TSETTLE_HIGH		0x0fc
#define QSERDES_V5_RX_RX_IDAC_MEASURE_TIME		0x100
#define QSERDES_V5_RX_RX_IDAC_ACCUMULATOR		0x104
#define QSERDES_V5_RX_RX_EQ_OFFSET_LSB			0x108
#define QSERDES_V5_RX_RX_EQ_OFFSET_MSB			0x10c
#define QSERDES_V5_RX_RX_EQ_OFFSET_ADAPTOR_CNTRL1	0x110
#define QSERDES_V5_RX_RX_OFFSET_ADAPTOR_CNTRL2		0x114
#define QSERDES_V5_RX_SIGDET_ENABLES			0x118
#define QSERDES_V5_RX_SIGDET_CNTRL			0x11c
#define QSERDES_V5_RX_SIGDET_LVL			0x120
#define QSERDES_V5_RX_SIGDET_DEGLITCH_CNTRL		0x124
#define QSERDES_V5_RX_RX_BAND				0x128
#define QSERDES_V5_RX_CDR_FREEZE_UP_DN			0x12c
#define QSERDES_V5_RX_CDR_RESET_OVERRIDE		0x130
#define QSERDES_V5_RX_RX_INTERFACE_MODE			0x134
#define QSERDES_V5_RX_JITTER_GEN_MODE			0x138
#define QSERDES_V5_RX_SJ_AMP1				0x13c
#define QSERDES_V5_RX_SJ_AMP2				0x140
#define QSERDES_V5_RX_SJ_PER1				0x144
#define QSERDES_V5_RX_SJ_PER2				0x148
#define QSERDES_V5_RX_PPM_OFFSET1			0x14c
#define QSERDES_V5_RX_PPM_OFFSET2			0x150
#define QSERDES_V5_RX_SIGN_PPM_PERIOD1			0x154
#define QSERDES_V5_RX_SIGN_PPM_PERIOD2			0x158
#define QSERDES_V5_RX_RX_MODE_00_LOW			0x15c
#define QSERDES_V5_RX_RX_MODE_00_HIGH			0x160
#define QSERDES_V5_RX_RX_MODE_00_HIGH2			0x164
#define QSERDES_V5_RX_RX_MODE_00_HIGH3			0x168
#define QSERDES_V5_RX_RX_MODE_00_HIGH4			0x16c
#define QSERDES_V5_RX_RX_MODE_01_LOW			0x170
#define QSERDES_V5_RX_RX_MODE_01_HIGH			0x174
#define QSERDES_V5_RX_RX_MODE_01_HIGH2			0x178
#define QSERDES_V5_RX_RX_MODE_01_HIGH3			0x17c
#define QSERDES_V5_RX_RX_MODE_01_HIGH4			0x180
#define QSERDES_V5_RX_RX_MODE_10_LOW			0x184
#define QSERDES_V5_RX_RX_MODE_10_HIGH			0x188
#define QSERDES_V5_RX_RX_MODE_10_HIGH2			0x18c
#define QSERDES_V5_RX_RX_MODE_10_HIGH3			0x190
#define QSERDES_V5_RX_RX_MODE_10_HIGH4			0x194
#define QSERDES_V5_RX_PHPRE_CTRL			0x198
#define QSERDES_V5_RX_PHPRE_INITVAL			0x19c
#define QSERDES_V5_RX_DFE_EN_TIMER			0x1a0
#define QSERDES_V5_RX_DFE_CTLE_POST_CAL_OFFSET		0x1a4
#define QSERDES_V5_RX_DCC_CTRL1				0x1a8
#define QSERDES_V5_RX_DCC_CTRL2				0x1ac
#define QSERDES_V5_RX_VTH_CODE				0x1b0
#define QSERDES_V5_RX_VTH_MIN_THRESH			0x1b4
#define QSERDES_V5_RX_VTH_MAX_THRESH			0x1b8
#define QSERDES_V5_RX_ALOG_OBSV_BUS_CTRL_1		0x1bc
#define QSERDES_V5_RX_PI_CTRL1				0x1c0
#define QSERDES_V5_RX_PI_CTRL2				0x1c4
#define QSERDES_V5_RX_PI_QUAD				0x1c8
#define QSERDES_V5_RX_IDATA1				0x1cc
#define QSERDES_V5_RX_IDATA2				0x1d0
#define QSERDES_V5_RX_AUX_DATA1				0x1d4
#define QSERDES_V5_RX_AUX_DATA2				0x1d8
#define QSERDES_V5_RX_AC_JTAG_OUTP			0x1dc
#define QSERDES_V5_RX_AC_JTAG_OUTN			0x1e0
#define QSERDES_V5_RX_RX_SIGDET				0x1e4
#define QSERDES_V5_RX_ALOG_OBSV_BUS_STATUS_1		0x1e8

/* Only for QMP V5 UFS ? */
#define QSERDES_V5_TX_PWM_GEAR_1_DIVIDER_BAND0_1	0x178
#define QSERDES_V5_TX_PWM_GEAR_2_DIVIDER_BAND0_1	0x17c
#define QSERDES_V5_TX_PWM_GEAR_3_DIVIDER_BAND0_1	0x180
#define QSERDES_V5_TX_PWM_GEAR_4_DIVIDER_BAND0_1	0x184

#endif
