// SPDX-License-Identifier: GPL-2.0
/*
 * Sophgo CV1800B SoC pinctrl driver.
 *
 * Copyright (C) 2024 Inochi Amaoto <inochiama@outlook.com>
 *
 * This file is generated from vendor pinout definition.
 */

#include <linux/module.h>
#include <linux/platform_device.h>
#include <linux/of.h>

#include <linux/pinctrl/pinctrl.h>
#include <linux/pinctrl/pinmux.h>

#include <dt-bindings/pinctrl/pinctrl-cv1800b.h>

#include "pinctrl-cv18xx.h"

enum CV1800B_POWER_DOMAIN {
	VDD18A_AUD		= 0,
	VDD18A_USB_PLL_ETH_CSI	= 1,
	VDD33A_ETH_USB_SD1	= 2,
	VDDIO_RTC		= 3,
	VDDIO_SD0_SPI		= 4
};

static const char *const cv1800b_power_domain_desc[] = {
	[VDD18A_AUD]			= "VDD18A_AUD",
	[VDD18A_USB_PLL_ETH_CSI]	= "VDD18A_USB_PLL_ETH_CSI",
	[VDD33A_ETH_USB_SD1]		= "VDD33A_ETH_USB_SD1",
	[VDDIO_RTC]			= "VDDIO_RTC",
	[VDDIO_SD0_SPI]			= "VDDIO_SD0_SPI",
};

static int cv1800b_get_pull_up(struct cv1800_pin *pin, const u32 *psmap)
{
	u32 pstate = psmap[pin->power_domain];
	enum cv1800_pin_io_type type = cv1800_pin_io_type(pin);

	if (type == IO_TYPE_1V8_ONLY)
		return 79000;

	if (type == IO_TYPE_1V8_OR_3V3) {
		if (pstate == PIN_POWER_STATE_1V8)
			return 60000;
		if (pstate == PIN_POWER_STATE_3V3)
			return 60000;

		return -EINVAL;
	}

	return -ENOTSUPP;
}

static int cv1800b_get_pull_down(struct cv1800_pin *pin, const u32 *psmap)
{
	u32 pstate = psmap[pin->power_domain];
	enum cv1800_pin_io_type type = cv1800_pin_io_type(pin);

	if (type == IO_TYPE_1V8_ONLY)
		return 87000;

	if (type == IO_TYPE_1V8_OR_3V3) {
		if (pstate == PIN_POWER_STATE_1V8)
			return 61000;
		if (pstate == PIN_POWER_STATE_3V3)
			return 62000;

		return -EINVAL;
	}

	return -ENOTSUPP;
}

static const u32 cv1800b_1v8_oc_map[] = {
	12800,
	25300,
	37400,
	49000
};

static const u32 cv1800b_18od33_1v8_oc_map[] = {
	7800,
	11700,
	15500,
	19200,
	23000,
	26600,
	30200,
	33700
};

static const u32 cv1800b_18od33_3v3_oc_map[] = {
	5500,
	8200,
	10800,
	13400,
	16100,
	18700,
	21200,
	23700
};

static const u32 cv1800b_eth_oc_map[] = {
	15700,
	17800
};

static int cv1800b_get_oc_map(struct cv1800_pin *pin, const u32 *psmap,
			      const u32 **map)
{
	enum cv1800_pin_io_type type = cv1800_pin_io_type(pin);
	u32 pstate = psmap[pin->power_domain];

	if (type == IO_TYPE_1V8_ONLY) {
		*map = cv1800b_1v8_oc_map;
		return ARRAY_SIZE(cv1800b_1v8_oc_map);
	}

	if (type == IO_TYPE_1V8_OR_3V3) {
		if (pstate == PIN_POWER_STATE_1V8) {
			*map = cv1800b_18od33_1v8_oc_map;
			return ARRAY_SIZE(cv1800b_18od33_1v8_oc_map);
		} else if (pstate == PIN_POWER_STATE_3V3) {
			*map = cv1800b_18od33_3v3_oc_map;
			return ARRAY_SIZE(cv1800b_18od33_3v3_oc_map);
		}
	}

	if (type == IO_TYPE_ETH) {
		*map = cv1800b_eth_oc_map;
		return ARRAY_SIZE(cv1800b_eth_oc_map);
	}

	return -ENOTSUPP;
}

static const u32 cv1800b_1v8_schmitt_map[] = {
	0,
	970000,
	1040000
};

static const u32 cv1800b_18od33_1v8_schmitt_map[] = {
	0,
	1070000
};

static const u32 cv1800b_18od33_3v3_schmitt_map[] = {
	0,
	1100000
};

static int cv1800b_get_schmitt_map(struct cv1800_pin *pin, const u32 *psmap,
				   const u32 **map)
{
	enum cv1800_pin_io_type type = cv1800_pin_io_type(pin);
	u32 pstate = psmap[pin->power_domain];

	if (type == IO_TYPE_1V8_ONLY) {
		*map = cv1800b_1v8_schmitt_map;
		return ARRAY_SIZE(cv1800b_1v8_schmitt_map);
	}

	if (type == IO_TYPE_1V8_OR_3V3) {
		if (pstate == PIN_POWER_STATE_1V8) {
			*map = cv1800b_18od33_1v8_schmitt_map;
			return ARRAY_SIZE(cv1800b_18od33_1v8_schmitt_map);
		} else if (pstate == PIN_POWER_STATE_3V3) {
			*map = cv1800b_18od33_3v3_schmitt_map;
			return ARRAY_SIZE(cv1800b_18od33_3v3_schmitt_map);
		}
	}

	return -ENOTSUPP;
}

static const struct cv1800_vddio_cfg_ops cv1800b_vddio_cfg_ops = {
	.get_pull_up		= cv1800b_get_pull_up,
	.get_pull_down		= cv1800b_get_pull_down,
	.get_oc_map		= cv1800b_get_oc_map,
	.get_schmitt_map		= cv1800b_get_schmitt_map,
};

static const struct pinctrl_pin_desc cv1800b_pins[] = {
	PINCTRL_PIN(PIN_AUD_AOUTR,	"AUD_AOUTR"),
	PINCTRL_PIN(PIN_SD0_CLK,	"SD0_CLK"),
	PINCTRL_PIN(PIN_SD0_CMD,	"SD0_CMD"),
	PINCTRL_PIN(PIN_SD0_D0,		"SD0_D0"),
	PINCTRL_PIN(PIN_SD0_D1,		"SD0_D1"),
	PINCTRL_PIN(PIN_SD0_D2,		"SD0_D2"),
	PINCTRL_PIN(PIN_SD0_D3,		"SD0_D3"),
	PINCTRL_PIN(PIN_SD0_CD,		"SD0_CD"),
	PINCTRL_PIN(PIN_SD0_PWR_EN,	"SD0_PWR_EN"),
	PINCTRL_PIN(PIN_SPK_EN,		"SPK_EN"),
	PINCTRL_PIN(PIN_UART0_TX,	"UART0_TX"),
	PINCTRL_PIN(PIN_UART0_RX,	"UART0_RX"),
	PINCTRL_PIN(PIN_SPINOR_HOLD_X,	"SPINOR_HOLD_X"),
	PINCTRL_PIN(PIN_SPINOR_SCK,	"SPINOR_SCK"),
	PINCTRL_PIN(PIN_SPINOR_MOSI,	"SPINOR_MOSI"),
	PINCTRL_PIN(PIN_SPINOR_WP_X,	"SPINOR_WP_X"),
	PINCTRL_PIN(PIN_SPINOR_MISO,	"SPINOR_MISO"),
	PINCTRL_PIN(PIN_SPINOR_CS_X,	"SPINOR_CS_X"),
	PINCTRL_PIN(PIN_IIC0_SCL,	"IIC0_SCL"),
	PINCTRL_PIN(PIN_IIC0_SDA,	"IIC0_SDA"),
	PINCTRL_PIN(PIN_AUX0,		"AUX0"),
	PINCTRL_PIN(PIN_PWR_VBAT_DET,	"PWR_VBAT_DET"),
	PINCTRL_PIN(PIN_PWR_SEQ2,	"PWR_SEQ2"),
	PINCTRL_PIN(PIN_XTAL_XIN,	"XTAL_XIN"),
	PINCTRL_PIN(PIN_SD1_GPIO0,	"SD1_GPIO0"),
	PINCTRL_PIN(PIN_SD1_GPIO1,	"SD1_GPIO1"),
	PINCTRL_PIN(PIN_SD1_D3,		"SD1_D3"),
	PINCTRL_PIN(PIN_SD1_D2,		"SD1_D2"),
	PINCTRL_PIN(PIN_SD1_D1,		"SD1_D1"),
	PINCTRL_PIN(PIN_SD1_D0,		"SD1_D0"),
	PINCTRL_PIN(PIN_SD1_CMD,	"SD1_CMD"),
	PINCTRL_PIN(PIN_SD1_CLK,	"SD1_CLK"),
	PINCTRL_PIN(PIN_ADC1,		"ADC1"),
	PINCTRL_PIN(PIN_USB_VBUS_DET,	"USB_VBUS_DET"),
	PINCTRL_PIN(PIN_ETH_TXP,	"ETH_TXP"),
	PINCTRL_PIN(PIN_ETH_TXM,	"ETH_TXM"),
	PINCTRL_PIN(PIN_ETH_RXP,	"ETH_RXP"),
	PINCTRL_PIN(PIN_ETH_RXM,	"ETH_RXM"),
	PINCTRL_PIN(PIN_MIPIRX4N,	"MIPIRX4N"),
	PINCTRL_PIN(PIN_MIPIRX4P,	"MIPIRX4P"),
	PINCTRL_PIN(PIN_MIPIRX3N,	"MIPIRX3N"),
	PINCTRL_PIN(PIN_MIPIRX3P,	"MIPIRX3P"),
	PINCTRL_PIN(PIN_MIPIRX2N,	"MIPIRX2N"),
	PINCTRL_PIN(PIN_MIPIRX2P,	"MIPIRX2P"),
	PINCTRL_PIN(PIN_MIPIRX1N,	"MIPIRX1N"),
	PINCTRL_PIN(PIN_MIPIRX1P,	"MIPIRX1P"),
	PINCTRL_PIN(PIN_MIPIRX0N,	"MIPIRX0N"),
	PINCTRL_PIN(PIN_MIPIRX0P,	"MIPIRX0P"),
	PINCTRL_PIN(PIN_AUD_AINL_MIC,	"AUD_AINL_MIC"),
};

static const struct cv1800_pin cv1800b_pin_data[ARRAY_SIZE(cv1800b_pins)] = {
	CV1800_FUNC_PIN(PIN_AUD_AOUTR, VDD18A_AUD,
			IO_TYPE_AUDIO,
			CV1800_PINCONF_AREA_SYS, 0x12c, 6),
	CV1800_GENERAL_PIN(PIN_SD0_CLK, VDDIO_SD0_SPI,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x000, 7,
			   CV1800_PINCONF_AREA_SYS, 0xa00),
	CV1800_GENERAL_PIN(PIN_SD0_CMD, VDDIO_SD0_SPI,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x004, 7,
			   CV1800_PINCONF_AREA_SYS, 0xa04),
	CV1800_GENERAL_PIN(PIN_SD0_D0, VDDIO_SD0_SPI,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x008, 7,
			   CV1800_PINCONF_AREA_SYS, 0xa08),
	CV1800_GENERAL_PIN(PIN_SD0_D1, VDDIO_SD0_SPI,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x00c, 7,
			   CV1800_PINCONF_AREA_SYS, 0xa0c),
	CV1800_GENERAL_PIN(PIN_SD0_D2, VDDIO_SD0_SPI,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x010, 7,
			   CV1800_PINCONF_AREA_SYS, 0xa10),
	CV1800_GENERAL_PIN(PIN_SD0_D3, VDDIO_SD0_SPI,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x014, 7,
			   CV1800_PINCONF_AREA_SYS, 0xa14),
	CV1800_GENERAL_PIN(PIN_SD0_CD, VDDIO_SD0_SPI,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x018, 3,
			   CV1800_PINCONF_AREA_SYS, 0x900),
	CV1800_GENERAL_PIN(PIN_SD0_PWR_EN, VDDIO_SD0_SPI,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x01c, 3,
			   CV1800_PINCONF_AREA_SYS, 0x904),
	CV1800_GENERAL_PIN(PIN_SPK_EN, VDDIO_SD0_SPI,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x020, 3,
			   CV1800_PINCONF_AREA_SYS, 0x908),
	CV1800_GENERAL_PIN(PIN_UART0_TX, VDDIO_SD0_SPI,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x024, 7,
			   CV1800_PINCONF_AREA_SYS, 0x90c),
	CV1800_GENERAL_PIN(PIN_UART0_RX, VDDIO_SD0_SPI,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x028, 7,
			   CV1800_PINCONF_AREA_SYS, 0x910),
	CV1800_GENERAL_PIN(PIN_SPINOR_HOLD_X, VDDIO_SD0_SPI,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x02c, 3,
			   CV1800_PINCONF_AREA_SYS, 0x914),
	CV1800_GENERAL_PIN(PIN_SPINOR_SCK, VDDIO_SD0_SPI,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x030, 3,
			   CV1800_PINCONF_AREA_SYS, 0x918),
	CV1800_GENERAL_PIN(PIN_SPINOR_MOSI, VDDIO_SD0_SPI,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x034, 3,
			   CV1800_PINCONF_AREA_SYS, 0x91c),
	CV1800_GENERAL_PIN(PIN_SPINOR_WP_X, VDDIO_SD0_SPI,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x038, 3,
			   CV1800_PINCONF_AREA_SYS, 0x920),
	CV1800_GENERAL_PIN(PIN_SPINOR_MISO, VDDIO_SD0_SPI,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x03c, 3,
			   CV1800_PINCONF_AREA_SYS, 0x924),
	CV1800_GENERAL_PIN(PIN_SPINOR_CS_X, VDDIO_SD0_SPI,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x040, 3,
			   CV1800_PINCONF_AREA_SYS, 0x928),
	CV1800_GENERAL_PIN(PIN_IIC0_SCL, VDDIO_SD0_SPI,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x04c, 7,
			   CV1800_PINCONF_AREA_SYS, 0x934),
	CV1800_GENERAL_PIN(PIN_IIC0_SDA, VDDIO_SD0_SPI,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x050, 7,
			   CV1800_PINCONF_AREA_SYS, 0x938),
	CV1800_GENERAL_PIN(PIN_AUX0, VDDIO_SD0_SPI,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x054, 7,
			   CV1800_PINCONF_AREA_SYS, 0x93c),
	CV1800_GENERAL_PIN(PIN_PWR_VBAT_DET, VDDIO_RTC,
			   IO_TYPE_1V8_ONLY,
			   CV1800_PINCONF_AREA_SYS, 0x05c, 0,
			   CV1800_PINCONF_AREA_RTC, 0x004),
	CV1800_GENERAL_PIN(PIN_PWR_SEQ2, VDDIO_RTC,
			   IO_TYPE_1V8_ONLY,
			   CV1800_PINCONF_AREA_SYS, 0x068, 3,
			   CV1800_PINCONF_AREA_RTC, 0x010),
	CV1800_GENERAL_PIN(PIN_XTAL_XIN, VDDIO_RTC,
			   IO_TYPE_1V8_ONLY,
			   CV1800_PINCONF_AREA_SYS, 0x074, 0,
			   CV1800_PINCONF_AREA_RTC, 0x020),
	CV1800_GENERAL_PIN(PIN_SD1_GPIO0, VDD33A_ETH_USB_SD1,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x088, 7,
			   CV1800_PINCONF_AREA_RTC, 0x034),
	CV1800_GENERAL_PIN(PIN_SD1_GPIO1, VDD33A_ETH_USB_SD1,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x084, 7,
			   CV1800_PINCONF_AREA_RTC, 0x030),
	CV1800_GENERAL_PIN(PIN_SD1_D3, VDD33A_ETH_USB_SD1,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x08c, 7,
			   CV1800_PINCONF_AREA_RTC, 0x038),
	CV1800_GENERAL_PIN(PIN_SD1_D2, VDD33A_ETH_USB_SD1,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x090, 7,
			   CV1800_PINCONF_AREA_RTC, 0x03c),
	CV1800_GENERAL_PIN(PIN_SD1_D1, VDD33A_ETH_USB_SD1,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x094, 7,
			   CV1800_PINCONF_AREA_RTC, 0x040),
	CV1800_GENERAL_PIN(PIN_SD1_D0, VDD33A_ETH_USB_SD1,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x098, 7,
			   CV1800_PINCONF_AREA_RTC, 0x044),
	CV1800_GENERAL_PIN(PIN_SD1_CMD, VDD33A_ETH_USB_SD1,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x09c, 7,
			   CV1800_PINCONF_AREA_RTC, 0x048),
	CV1800_GENERAL_PIN(PIN_SD1_CLK, VDD33A_ETH_USB_SD1,
			   IO_TYPE_1V8_OR_3V3,
			   CV1800_PINCONF_AREA_SYS, 0x0a0, 7,
			   CV1800_PINCONF_AREA_RTC, 0x04c),
	CV1800_GENERAL_PIN(PIN_ADC1, VDD18A_USB_PLL_ETH_CSI,
			   IO_TYPE_1V8_ONLY,
			   CV1800_PINCONF_AREA_SYS, 0x0a8, 6,
			   CV1800_PINCONF_AREA_SYS, 0x804),
	CV1800_GENERAL_PIN(PIN_USB_VBUS_DET, VDD18A_USB_PLL_ETH_CSI,
			   IO_TYPE_1V8_ONLY,
			   CV1800_PINCONF_AREA_SYS, 0x0ac, 6,
			   CV1800_PINCONF_AREA_SYS, 0x808),
	CV1800_FUNC_PIN(PIN_ETH_TXP, VDD18A_USB_PLL_ETH_CSI,
			IO_TYPE_ETH,
			CV1800_PINCONF_AREA_SYS, 0x0c0, 7),
	CV1800_FUNC_PIN(PIN_ETH_TXM, VDD18A_USB_PLL_ETH_CSI,
			IO_TYPE_ETH,
			CV1800_PINCONF_AREA_SYS, 0x0c4, 7),
	CV1800_FUNC_PIN(PIN_ETH_RXP, VDD18A_USB_PLL_ETH_CSI,
			IO_TYPE_ETH,
			CV1800_PINCONF_AREA_SYS, 0x0c8, 7),
	CV1800_FUNC_PIN(PIN_ETH_RXM, VDD18A_USB_PLL_ETH_CSI,
			IO_TYPE_ETH,
			CV1800_PINCONF_AREA_SYS, 0x0cc, 7),
	CV1800_GENERATE_PIN_MUX2(PIN_MIPIRX4N, VDD18A_USB_PLL_ETH_CSI,
				 IO_TYPE_1V8_ONLY,
				 CV1800_PINCONF_AREA_SYS, 0x0d4, 7,
				 CV1800_PINCONF_AREA_SYS, 0x0bc, 7,
				 CV1800_PINCONF_AREA_SYS, 0xc04),
	CV1800_GENERATE_PIN_MUX2(PIN_MIPIRX4P, VDD18A_USB_PLL_ETH_CSI,
				 IO_TYPE_1V8_ONLY,
				 CV1800_PINCONF_AREA_SYS, 0x0d8, 7,
				 CV1800_PINCONF_AREA_SYS, 0x0b8, 7,
				 CV1800_PINCONF_AREA_SYS, 0xc08),
	CV1800_GENERATE_PIN_MUX2(PIN_MIPIRX3N, VDD18A_USB_PLL_ETH_CSI,
				 IO_TYPE_1V8_ONLY,
				 CV1800_PINCONF_AREA_SYS, 0x0dc, 7,
				 CV1800_PINCONF_AREA_SYS, 0x0b0, 7,
				 CV1800_PINCONF_AREA_SYS, 0xc0c),
	CV1800_GENERATE_PIN_MUX2(PIN_MIPIRX3P, VDD18A_USB_PLL_ETH_CSI,
				 IO_TYPE_1V8_ONLY,
				 CV1800_PINCONF_AREA_SYS, 0x0e0, 7,
				 CV1800_PINCONF_AREA_SYS, 0x0b4, 7,
				 CV1800_PINCONF_AREA_SYS, 0xc10),
	CV1800_GENERAL_PIN(PIN_MIPIRX2N, VDD18A_USB_PLL_ETH_CSI,
			   IO_TYPE_1V8_ONLY,
			   CV1800_PINCONF_AREA_SYS, 0x0e4, 7,
			   CV1800_PINCONF_AREA_SYS, 0xc14),
	CV1800_GENERAL_PIN(PIN_MIPIRX2P, VDD18A_USB_PLL_ETH_CSI,
			   IO_TYPE_1V8_ONLY,
			   CV1800_PINCONF_AREA_SYS, 0x0e8, 7,
			   CV1800_PINCONF_AREA_SYS, 0xc18),
	CV1800_GENERAL_PIN(PIN_MIPIRX1N, VDD18A_USB_PLL_ETH_CSI,
			   IO_TYPE_1V8_ONLY,
			   CV1800_PINCONF_AREA_SYS, 0x0ec, 7,
			   CV1800_PINCONF_AREA_SYS, 0xc1c),
	CV1800_GENERAL_PIN(PIN_MIPIRX1P, VDD18A_USB_PLL_ETH_CSI,
			   IO_TYPE_1V8_ONLY,
			   CV1800_PINCONF_AREA_SYS, 0x0f0, 7,
			   CV1800_PINCONF_AREA_SYS, 0xc20),
	CV1800_GENERAL_PIN(PIN_MIPIRX0N, VDD18A_USB_PLL_ETH_CSI,
			   IO_TYPE_1V8_ONLY,
			   CV1800_PINCONF_AREA_SYS, 0x0f4, 7,
			   CV1800_PINCONF_AREA_SYS, 0xc24),
	CV1800_GENERAL_PIN(PIN_MIPIRX0P, VDD18A_USB_PLL_ETH_CSI,
			   IO_TYPE_1V8_ONLY,
			   CV1800_PINCONF_AREA_SYS, 0x0f8, 7,
			   CV1800_PINCONF_AREA_SYS, 0xc28),
	CV1800_FUNC_PIN(PIN_AUD_AINL_MIC, VDD18A_AUD,
			IO_TYPE_AUDIO,
			CV1800_PINCONF_AREA_SYS, 0x120, 5),
};

static const struct cv1800_pinctrl_data cv1800b_pindata = {
	.pins		= cv1800b_pins,
	.pindata	= cv1800b_pin_data,
	.pdnames	= cv1800b_power_domain_desc,
	.vddio_ops	= &cv1800b_vddio_cfg_ops,
	.npins		= ARRAY_SIZE(cv1800b_pins),
	.npd		= ARRAY_SIZE(cv1800b_power_domain_desc),
};

static const struct of_device_id cv1800b_pinctrl_ids[] = {
	{ .compatible = "sophgo,cv1800b-pinctrl", .data = &cv1800b_pindata },
	{ }
};
MODULE_DEVICE_TABLE(of, cv1800b_pinctrl_ids);

static struct platform_driver cv1800b_pinctrl_driver = {
	.probe	= cv1800_pinctrl_probe,
	.driver	= {
		.name			= "cv1800b-pinctrl",
		.suppress_bind_attrs	= true,
		.of_match_table		= cv1800b_pinctrl_ids,
	},
};
module_platform_driver(cv1800b_pinctrl_driver);

MODULE_DESCRIPTION("Pinctrl driver for the CV1800B series SoC");
MODULE_LICENSE("GPL");
