/* SPDX-License-Identifier: GPL-2.0+
 * Microchip Sparx5 Switch driver
 *
 * Copyright (c) 2021 Microchip Technology Inc.
 */

/* This file is autogenerated by cml-utils 2023-02-10 11:18:53 +0100.
 * Commit ID: c30fb4bf0281cd4a7133bdab6682f9e43c872ada
 */

#ifndef _SPARX5_MAIN_REGS_H_
#define _SPARX5_MAIN_REGS_H_

#include <linux/bitfield.h>
#include <linux/types.h>
#include <linux/bug.h>

enum sparx5_target {
	TARGET_ANA_AC = 1,
	TARGET_ANA_ACL = 2,
	TARGET_ANA_AC_POL = 4,
	TARGET_ANA_AC_SDLB = 5,
	TARGET_ANA_CL = 6,
	TARGET_ANA_L2 = 7,
	TARGET_ANA_L3 = 8,
	TARGET_ASM = 9,
	TARGET_CLKGEN = 11,
	TARGET_CPU = 12,
	TARGET_DEV10G = 17,
	TARGET_DEV25G = 29,
	TARGET_DEV2G5 = 37,
	TARGET_DEV5G = 102,
	TARGET_DSM = 115,
	TARGET_EACL = 116,
	TARGET_FDMA = 117,
	TARGET_GCB = 118,
	TARGET_HSCH = 119,
	TARGET_LRN = 122,
	TARGET_PCEP = 129,
	TARGET_PCS10G_BR = 132,
	TARGET_PCS25G_BR = 144,
	TARGET_PCS5G_BR = 160,
	TARGET_PORT_CONF = 173,
	TARGET_PTP = 174,
	TARGET_QFWD = 175,
	TARGET_QRES = 176,
	TARGET_QS = 177,
	TARGET_QSYS = 178,
	TARGET_REW = 179,
	TARGET_VCAP_ES0 = 323,
	TARGET_VCAP_ES2 = 324,
	TARGET_VCAP_SUPER = 326,
	TARGET_VOP = 327,
	TARGET_XQS = 331,
	NUM_TARGETS = 332
};

#define __REG(...)    __VA_ARGS__

/*      ANA_AC:RAM_CTRL:RAM_INIT */
#define ANA_AC_RAM_INIT           __REG(TARGET_ANA_AC,\
					0, 1, 839108, 0, 1, 4, 0, 0, 1, 4)

#define ANA_AC_RAM_INIT_RAM_INIT                 BIT(1)
#define ANA_AC_RAM_INIT_RAM_INIT_SET(x)\
	FIELD_PREP(ANA_AC_RAM_INIT_RAM_INIT, x)
#define ANA_AC_RAM_INIT_RAM_INIT_GET(x)\
	FIELD_GET(ANA_AC_RAM_INIT_RAM_INIT, x)

#define ANA_AC_RAM_INIT_RAM_CFG_HOOK             BIT(0)
#define ANA_AC_RAM_INIT_RAM_CFG_HOOK_SET(x)\
	FIELD_PREP(ANA_AC_RAM_INIT_RAM_CFG_HOOK, x)
#define ANA_AC_RAM_INIT_RAM_CFG_HOOK_GET(x)\
	FIELD_GET(ANA_AC_RAM_INIT_RAM_CFG_HOOK, x)

/*      ANA_AC:PS_COMMON:OWN_UPSID */
#define ANA_AC_OWN_UPSID(r)       __REG(TARGET_ANA_AC,\
					0, 1, 894472, 0, 1, 352, 52, r, 3, 4)

#define ANA_AC_OWN_UPSID_OWN_UPSID               GENMASK(4, 0)
#define ANA_AC_OWN_UPSID_OWN_UPSID_SET(x)\
	FIELD_PREP(ANA_AC_OWN_UPSID_OWN_UPSID, x)
#define ANA_AC_OWN_UPSID_OWN_UPSID_GET(x)\
	FIELD_GET(ANA_AC_OWN_UPSID_OWN_UPSID, x)

/*      ANA_AC:MIRROR_PROBE:PROBE_CFG */
#define ANA_AC_PROBE_CFG(g) \
	__REG(TARGET_ANA_AC, 0, 1, 893696, g, 3, 32, 0, 0, 1, 4)

#define ANA_AC_PROBE_CFG_PROBE_RX_CPU_AND_VD GENMASK(31, 27)
#define ANA_AC_PROBE_CFG_PROBE_RX_CPU_AND_VD_SET(x)\
	FIELD_PREP(ANA_AC_PROBE_CFG_PROBE_RX_CPU_AND_VD, x)
#define ANA_AC_PROBE_CFG_PROBE_RX_CPU_AND_VD_GET(x)\
	FIELD_GET(ANA_AC_PROBE_CFG_PROBE_RX_CPU_AND_VD, x)

#define ANA_AC_PROBE_CFG_PROBE_CPU_SET      GENMASK(26, 19)
#define ANA_AC_PROBE_CFG_PROBE_CPU_SET_SET(x)\
	FIELD_PREP(ANA_AC_PROBE_CFG_PROBE_CPU_SET, x)
#define ANA_AC_PROBE_CFG_PROBE_CPU_SET_GET(x)\
	FIELD_GET(ANA_AC_PROBE_CFG_PROBE_CPU_SET, x)

#define ANA_AC_PROBE_CFG_PROBE_VID          GENMASK(18, 6)
#define ANA_AC_PROBE_CFG_PROBE_VID_SET(x)\
	FIELD_PREP(ANA_AC_PROBE_CFG_PROBE_VID, x)
#define ANA_AC_PROBE_CFG_PROBE_VID_GET(x)\
	FIELD_GET(ANA_AC_PROBE_CFG_PROBE_VID, x)

#define ANA_AC_PROBE_CFG_PROBE_VLAN_MODE    GENMASK(5, 4)
#define ANA_AC_PROBE_CFG_PROBE_VLAN_MODE_SET(x)\
	FIELD_PREP(ANA_AC_PROBE_CFG_PROBE_VLAN_MODE, x)
#define ANA_AC_PROBE_CFG_PROBE_VLAN_MODE_GET(x)\
	FIELD_GET(ANA_AC_PROBE_CFG_PROBE_VLAN_MODE, x)

#define ANA_AC_PROBE_CFG_PROBE_MAC_MODE     GENMASK(3, 2)
#define ANA_AC_PROBE_CFG_PROBE_MAC_MODE_SET(x)\
	FIELD_PREP(ANA_AC_PROBE_CFG_PROBE_MAC_MODE, x)
#define ANA_AC_PROBE_CFG_PROBE_MAC_MODE_GET(x)\
	FIELD_GET(ANA_AC_PROBE_CFG_PROBE_MAC_MODE, x)

#define ANA_AC_PROBE_CFG_PROBE_DIRECTION    GENMASK(1, 0)
#define ANA_AC_PROBE_CFG_PROBE_DIRECTION_SET(x)\
	FIELD_PREP(ANA_AC_PROBE_CFG_PROBE_DIRECTION, x)
#define ANA_AC_PROBE_CFG_PROBE_DIRECTION_GET(x)\
	FIELD_GET(ANA_AC_PROBE_CFG_PROBE_DIRECTION, x)

/*      ANA_AC:MIRROR_PROBE:PROBE_PORT_CFG */
#define ANA_AC_PROBE_PORT_CFG(g) \
	__REG(TARGET_ANA_AC, 0, 1, 893696, g, 3, 32, 8, 0, 1, 4)

/*      ANA_AC:MIRROR_PROBE:PROBE_PORT_CFG1 */
#define ANA_AC_PROBE_PORT_CFG1(g) \
	__REG(TARGET_ANA_AC, 0, 1, 893696, g, 3, 32, 12, 0, 1, 4)

/*      ANA_AC:MIRROR_PROBE:PROBE_PORT_CFG2 */
#define ANA_AC_PROBE_PORT_CFG2(g) \
	__REG(TARGET_ANA_AC, 0, 1, 893696, g, 3, 32, 16, 0, 1, 4)

#define ANA_AC_PROBE_PORT_CFG2_PROBE_PORT_MASK2 BIT(0)
#define ANA_AC_PROBE_PORT_CFG2_PROBE_PORT_MASK2_SET(x)\
	FIELD_PREP(ANA_AC_PROBE_PORT_CFG2_PROBE_PORT_MASK2, x)
#define ANA_AC_PROBE_PORT_CFG2_PROBE_PORT_MASK2_GET(x)\
	FIELD_GET(ANA_AC_PROBE_PORT_CFG2_PROBE_PORT_MASK2, x)

/*      ANA_AC:SRC:SRC_CFG */
#define ANA_AC_SRC_CFG(g)         __REG(TARGET_ANA_AC,\
					0, 1, 849920, g, 102, 16, 0, 0, 1, 4)

/*      ANA_AC:SRC:SRC_CFG1 */
#define ANA_AC_SRC_CFG1(g)        __REG(TARGET_ANA_AC,\
					0, 1, 849920, g, 102, 16, 4, 0, 1, 4)

/*      ANA_AC:SRC:SRC_CFG2 */
#define ANA_AC_SRC_CFG2(g)        __REG(TARGET_ANA_AC,\
					0, 1, 849920, g, 102, 16, 8, 0, 1, 4)

#define ANA_AC_SRC_CFG2_PORT_MASK2               BIT(0)
#define ANA_AC_SRC_CFG2_PORT_MASK2_SET(x)\
	FIELD_PREP(ANA_AC_SRC_CFG2_PORT_MASK2, x)
#define ANA_AC_SRC_CFG2_PORT_MASK2_GET(x)\
	FIELD_GET(ANA_AC_SRC_CFG2_PORT_MASK2, x)

/*      ANA_AC:PGID:PGID_CFG */
#define ANA_AC_PGID_CFG(g)        __REG(TARGET_ANA_AC,\
					0, 1, 786432, g, 3290, 16, 0, 0, 1, 4)

/*      ANA_AC:PGID:PGID_CFG1 */
#define ANA_AC_PGID_CFG1(g)       __REG(TARGET_ANA_AC,\
					0, 1, 786432, g, 3290, 16, 4, 0, 1, 4)

/*      ANA_AC:PGID:PGID_CFG2 */
#define ANA_AC_PGID_CFG2(g)       __REG(TARGET_ANA_AC,\
					0, 1, 786432, g, 3290, 16, 8, 0, 1, 4)

#define ANA_AC_PGID_CFG2_PORT_MASK2              BIT(0)
#define ANA_AC_PGID_CFG2_PORT_MASK2_SET(x)\
	FIELD_PREP(ANA_AC_PGID_CFG2_PORT_MASK2, x)
#define ANA_AC_PGID_CFG2_PORT_MASK2_GET(x)\
	FIELD_GET(ANA_AC_PGID_CFG2_PORT_MASK2, x)

/*      ANA_AC:PGID:PGID_MISC_CFG */
#define ANA_AC_PGID_MISC_CFG(g)   __REG(TARGET_ANA_AC,\
					0, 1, 786432, g, 3290, 16, 12, 0, 1, 4)

#define ANA_AC_PGID_MISC_CFG_PGID_CPU_QU         GENMASK(6, 4)
#define ANA_AC_PGID_MISC_CFG_PGID_CPU_QU_SET(x)\
	FIELD_PREP(ANA_AC_PGID_MISC_CFG_PGID_CPU_QU, x)
#define ANA_AC_PGID_MISC_CFG_PGID_CPU_QU_GET(x)\
	FIELD_GET(ANA_AC_PGID_MISC_CFG_PGID_CPU_QU, x)

#define ANA_AC_PGID_MISC_CFG_STACK_TYPE_ENA      BIT(1)
#define ANA_AC_PGID_MISC_CFG_STACK_TYPE_ENA_SET(x)\
	FIELD_PREP(ANA_AC_PGID_MISC_CFG_STACK_TYPE_ENA, x)
#define ANA_AC_PGID_MISC_CFG_STACK_TYPE_ENA_GET(x)\
	FIELD_GET(ANA_AC_PGID_MISC_CFG_STACK_TYPE_ENA, x)

#define ANA_AC_PGID_MISC_CFG_PGID_CPU_COPY_ENA   BIT(0)
#define ANA_AC_PGID_MISC_CFG_PGID_CPU_COPY_ENA_SET(x)\
	FIELD_PREP(ANA_AC_PGID_MISC_CFG_PGID_CPU_COPY_ENA, x)
#define ANA_AC_PGID_MISC_CFG_PGID_CPU_COPY_ENA_GET(x)\
	FIELD_GET(ANA_AC_PGID_MISC_CFG_PGID_CPU_COPY_ENA, x)

/*      ANA_AC:TSN_SF:TSN_SF */
#define ANA_AC_TSN_SF             __REG(TARGET_ANA_AC,\
					0, 1, 839136, 0, 1, 4, 0, 0, 1, 4)

#define ANA_AC_TSN_SF_TSN_STREAM_BLOCK_OVERSIZE_STICKY BIT(9)
#define ANA_AC_TSN_SF_TSN_STREAM_BLOCK_OVERSIZE_STICKY_SET(x)\
	FIELD_PREP(ANA_AC_TSN_SF_TSN_STREAM_BLOCK_OVERSIZE_STICKY, x)
#define ANA_AC_TSN_SF_TSN_STREAM_BLOCK_OVERSIZE_STICKY_GET(x)\
	FIELD_GET(ANA_AC_TSN_SF_TSN_STREAM_BLOCK_OVERSIZE_STICKY, x)

#define ANA_AC_TSN_SF_PORT_NUM                   GENMASK(8, 0)
#define ANA_AC_TSN_SF_PORT_NUM_SET(x)\
	FIELD_PREP(ANA_AC_TSN_SF_PORT_NUM, x)
#define ANA_AC_TSN_SF_PORT_NUM_GET(x)\
	FIELD_GET(ANA_AC_TSN_SF_PORT_NUM, x)

/*      ANA_AC:TSN_SF_CFG:TSN_SF_CFG */
#define ANA_AC_TSN_SF_CFG(g)      __REG(TARGET_ANA_AC,\
					0, 1, 839680, g, 1024, 4, 0, 0, 1, 4)

#define ANA_AC_TSN_SF_CFG_TSN_SGID               GENMASK(25, 16)
#define ANA_AC_TSN_SF_CFG_TSN_SGID_SET(x)\
	FIELD_PREP(ANA_AC_TSN_SF_CFG_TSN_SGID, x)
#define ANA_AC_TSN_SF_CFG_TSN_SGID_GET(x)\
	FIELD_GET(ANA_AC_TSN_SF_CFG_TSN_SGID, x)

#define ANA_AC_TSN_SF_CFG_TSN_MAX_SDU            GENMASK(15, 2)
#define ANA_AC_TSN_SF_CFG_TSN_MAX_SDU_SET(x)\
	FIELD_PREP(ANA_AC_TSN_SF_CFG_TSN_MAX_SDU, x)
#define ANA_AC_TSN_SF_CFG_TSN_MAX_SDU_GET(x)\
	FIELD_GET(ANA_AC_TSN_SF_CFG_TSN_MAX_SDU, x)

#define ANA_AC_TSN_SF_CFG_BLOCK_OVERSIZE_ENA     BIT(1)
#define ANA_AC_TSN_SF_CFG_BLOCK_OVERSIZE_ENA_SET(x)\
	FIELD_PREP(ANA_AC_TSN_SF_CFG_BLOCK_OVERSIZE_ENA, x)
#define ANA_AC_TSN_SF_CFG_BLOCK_OVERSIZE_ENA_GET(x)\
	FIELD_GET(ANA_AC_TSN_SF_CFG_BLOCK_OVERSIZE_ENA, x)

#define ANA_AC_TSN_SF_CFG_BLOCK_OVERSIZE_STATE   BIT(0)
#define ANA_AC_TSN_SF_CFG_BLOCK_OVERSIZE_STATE_SET(x)\
	FIELD_PREP(ANA_AC_TSN_SF_CFG_BLOCK_OVERSIZE_STATE, x)
#define ANA_AC_TSN_SF_CFG_BLOCK_OVERSIZE_STATE_GET(x)\
	FIELD_GET(ANA_AC_TSN_SF_CFG_BLOCK_OVERSIZE_STATE, x)

/*      ANA_AC:TSN_SF_STATUS:TSN_SF_STATUS */
#define ANA_AC_TSN_SF_STATUS      __REG(TARGET_ANA_AC,\
					0, 1, 839072, 0, 1, 16, 0, 0, 1, 4)

#define ANA_AC_TSN_SF_STATUS_FRM_LEN             GENMASK(25, 12)
#define ANA_AC_TSN_SF_STATUS_FRM_LEN_SET(x)\
	FIELD_PREP(ANA_AC_TSN_SF_STATUS_FRM_LEN, x)
#define ANA_AC_TSN_SF_STATUS_FRM_LEN_GET(x)\
	FIELD_GET(ANA_AC_TSN_SF_STATUS_FRM_LEN, x)

#define ANA_AC_TSN_SF_STATUS_DLB_DROP            BIT(11)
#define ANA_AC_TSN_SF_STATUS_DLB_DROP_SET(x)\
	FIELD_PREP(ANA_AC_TSN_SF_STATUS_DLB_DROP, x)
#define ANA_AC_TSN_SF_STATUS_DLB_DROP_GET(x)\
	FIELD_GET(ANA_AC_TSN_SF_STATUS_DLB_DROP, x)

#define ANA_AC_TSN_SF_STATUS_TSN_SFID            GENMASK(10, 1)
#define ANA_AC_TSN_SF_STATUS_TSN_SFID_SET(x)\
	FIELD_PREP(ANA_AC_TSN_SF_STATUS_TSN_SFID, x)
#define ANA_AC_TSN_SF_STATUS_TSN_SFID_GET(x)\
	FIELD_GET(ANA_AC_TSN_SF_STATUS_TSN_SFID, x)

#define ANA_AC_TSN_SF_STATUS_TSTAMP_VLD          BIT(0)
#define ANA_AC_TSN_SF_STATUS_TSTAMP_VLD_SET(x)\
	FIELD_PREP(ANA_AC_TSN_SF_STATUS_TSTAMP_VLD, x)
#define ANA_AC_TSN_SF_STATUS_TSTAMP_VLD_GET(x)\
	FIELD_GET(ANA_AC_TSN_SF_STATUS_TSTAMP_VLD, x)

/*      ANA_AC:SG_ACCESS:SG_ACCESS_CTRL */
#define ANA_AC_SG_ACCESS_CTRL     __REG(TARGET_ANA_AC,\
					0, 1, 839140, 0, 1, 12, 0, 0, 1, 4)

#define ANA_AC_SG_ACCESS_CTRL_SGID               GENMASK(9, 0)
#define ANA_AC_SG_ACCESS_CTRL_SGID_SET(x)\
	FIELD_PREP(ANA_AC_SG_ACCESS_CTRL_SGID, x)
#define ANA_AC_SG_ACCESS_CTRL_SGID_GET(x)\
	FIELD_GET(ANA_AC_SG_ACCESS_CTRL_SGID, x)

#define ANA_AC_SG_ACCESS_CTRL_CONFIG_CHANGE      BIT(28)
#define ANA_AC_SG_ACCESS_CTRL_CONFIG_CHANGE_SET(x)\
	FIELD_PREP(ANA_AC_SG_ACCESS_CTRL_CONFIG_CHANGE, x)
#define ANA_AC_SG_ACCESS_CTRL_CONFIG_CHANGE_GET(x)\
	FIELD_GET(ANA_AC_SG_ACCESS_CTRL_CONFIG_CHANGE, x)

/*      ANA_AC:SG_ACCESS:SG_CYCLETIME_UPDATE_PERIOD */
#define ANA_AC_SG_CYCLETIME_UPDATE_PERIOD __REG(TARGET_ANA_AC,\
					0, 1, 839140, 0, 1, 12, 8, 0, 1, 4)

#define ANA_AC_SG_CYCLETIME_UPDATE_PERIOD_SG_CT_CLKS GENMASK(15, 0)
#define ANA_AC_SG_CYCLETIME_UPDATE_PERIOD_SG_CT_CLKS_SET(x)\
	FIELD_PREP(ANA_AC_SG_CYCLETIME_UPDATE_PERIOD_SG_CT_CLKS, x)
#define ANA_AC_SG_CYCLETIME_UPDATE_PERIOD_SG_CT_CLKS_GET(x)\
	FIELD_GET(ANA_AC_SG_CYCLETIME_UPDATE_PERIOD_SG_CT_CLKS, x)

#define ANA_AC_SG_CYCLETIME_UPDATE_PERIOD_SG_CT_UPDATE_ENA BIT(31)
#define ANA_AC_SG_CYCLETIME_UPDATE_PERIOD_SG_CT_UPDATE_ENA_SET(x)\
	FIELD_PREP(ANA_AC_SG_CYCLETIME_UPDATE_PERIOD_SG_CT_UPDATE_ENA, x)
#define ANA_AC_SG_CYCLETIME_UPDATE_PERIOD_SG_CT_UPDATE_ENA_GET(x)\
	FIELD_GET(ANA_AC_SG_CYCLETIME_UPDATE_PERIOD_SG_CT_UPDATE_ENA, x)

/*      ANA_AC:SG_CONFIG:SG_CONFIG_REG_1 */
#define ANA_AC_SG_CONFIG_REG_1    __REG(TARGET_ANA_AC,\
					0, 1, 851584, 0, 1, 128, 48, 0, 1, 4)

/*      ANA_AC:SG_CONFIG:SG_CONFIG_REG_2 */
#define ANA_AC_SG_CONFIG_REG_2    __REG(TARGET_ANA_AC,\
					0, 1, 851584, 0, 1, 128, 52, 0, 1, 4)

/*      ANA_AC:SG_CONFIG:SG_CONFIG_REG_3 */
#define ANA_AC_SG_CONFIG_REG_3    __REG(TARGET_ANA_AC,\
					0, 1, 851584, 0, 1, 128, 56, 0, 1, 4)

#define ANA_AC_SG_CONFIG_REG_3_BASE_TIME_SEC_MSB GENMASK(15, 0)
#define ANA_AC_SG_CONFIG_REG_3_BASE_TIME_SEC_MSB_SET(x)\
	FIELD_PREP(ANA_AC_SG_CONFIG_REG_3_BASE_TIME_SEC_MSB, x)
#define ANA_AC_SG_CONFIG_REG_3_BASE_TIME_SEC_MSB_GET(x)\
	FIELD_GET(ANA_AC_SG_CONFIG_REG_3_BASE_TIME_SEC_MSB, x)

#define ANA_AC_SG_CONFIG_REG_3_LIST_LENGTH       GENMASK(18, 16)
#define ANA_AC_SG_CONFIG_REG_3_LIST_LENGTH_SET(x)\
	FIELD_PREP(ANA_AC_SG_CONFIG_REG_3_LIST_LENGTH, x)
#define ANA_AC_SG_CONFIG_REG_3_LIST_LENGTH_GET(x)\
	FIELD_GET(ANA_AC_SG_CONFIG_REG_3_LIST_LENGTH, x)

#define ANA_AC_SG_CONFIG_REG_3_GATE_ENABLE       BIT(20)
#define ANA_AC_SG_CONFIG_REG_3_GATE_ENABLE_SET(x)\
	FIELD_PREP(ANA_AC_SG_CONFIG_REG_3_GATE_ENABLE, x)
#define ANA_AC_SG_CONFIG_REG_3_GATE_ENABLE_GET(x)\
	FIELD_GET(ANA_AC_SG_CONFIG_REG_3_GATE_ENABLE, x)

#define ANA_AC_SG_CONFIG_REG_3_INIT_IPS          GENMASK(24, 21)
#define ANA_AC_SG_CONFIG_REG_3_INIT_IPS_SET(x)\
	FIELD_PREP(ANA_AC_SG_CONFIG_REG_3_INIT_IPS, x)
#define ANA_AC_SG_CONFIG_REG_3_INIT_IPS_GET(x)\
	FIELD_GET(ANA_AC_SG_CONFIG_REG_3_INIT_IPS, x)

#define ANA_AC_SG_CONFIG_REG_3_INIT_GATE_STATE   BIT(25)
#define ANA_AC_SG_CONFIG_REG_3_INIT_GATE_STATE_SET(x)\
	FIELD_PREP(ANA_AC_SG_CONFIG_REG_3_INIT_GATE_STATE, x)
#define ANA_AC_SG_CONFIG_REG_3_INIT_GATE_STATE_GET(x)\
	FIELD_GET(ANA_AC_SG_CONFIG_REG_3_INIT_GATE_STATE, x)

#define ANA_AC_SG_CONFIG_REG_3_INVALID_RX_ENA    BIT(26)
#define ANA_AC_SG_CONFIG_REG_3_INVALID_RX_ENA_SET(x)\
	FIELD_PREP(ANA_AC_SG_CONFIG_REG_3_INVALID_RX_ENA, x)
#define ANA_AC_SG_CONFIG_REG_3_INVALID_RX_ENA_GET(x)\
	FIELD_GET(ANA_AC_SG_CONFIG_REG_3_INVALID_RX_ENA, x)

#define ANA_AC_SG_CONFIG_REG_3_INVALID_RX        BIT(27)
#define ANA_AC_SG_CONFIG_REG_3_INVALID_RX_SET(x)\
	FIELD_PREP(ANA_AC_SG_CONFIG_REG_3_INVALID_RX, x)
#define ANA_AC_SG_CONFIG_REG_3_INVALID_RX_GET(x)\
	FIELD_GET(ANA_AC_SG_CONFIG_REG_3_INVALID_RX, x)

#define ANA_AC_SG_CONFIG_REG_3_OCTETS_EXCEEDED_ENA BIT(28)
#define ANA_AC_SG_CONFIG_REG_3_OCTETS_EXCEEDED_ENA_SET(x)\
	FIELD_PREP(ANA_AC_SG_CONFIG_REG_3_OCTETS_EXCEEDED_ENA, x)
#define ANA_AC_SG_CONFIG_REG_3_OCTETS_EXCEEDED_ENA_GET(x)\
	FIELD_GET(ANA_AC_SG_CONFIG_REG_3_OCTETS_EXCEEDED_ENA, x)

#define ANA_AC_SG_CONFIG_REG_3_OCTETS_EXCEEDED   BIT(29)
#define ANA_AC_SG_CONFIG_REG_3_OCTETS_EXCEEDED_SET(x)\
	FIELD_PREP(ANA_AC_SG_CONFIG_REG_3_OCTETS_EXCEEDED, x)
#define ANA_AC_SG_CONFIG_REG_3_OCTETS_EXCEEDED_GET(x)\
	FIELD_GET(ANA_AC_SG_CONFIG_REG_3_OCTETS_EXCEEDED, x)

/*      ANA_AC:SG_CONFIG:SG_CONFIG_REG_4 */
#define ANA_AC_SG_CONFIG_REG_4    __REG(TARGET_ANA_AC,\
					0, 1, 851584, 0, 1, 128, 60, 0, 1, 4)

/*      ANA_AC:SG_CONFIG:SG_CONFIG_REG_5 */
#define ANA_AC_SG_CONFIG_REG_5    __REG(TARGET_ANA_AC,\
					0, 1, 851584, 0, 1, 128, 64, 0, 1, 4)

/*      ANA_AC:SG_CONFIG:SG_GCL_GS_CONFIG */
#define ANA_AC_SG_GCL_GS_CONFIG(r) __REG(TARGET_ANA_AC,\
					0, 1, 851584, 0, 1, 128, 0, r, 4, 4)

#define ANA_AC_SG_GCL_GS_CONFIG_IPS              GENMASK(3, 0)
#define ANA_AC_SG_GCL_GS_CONFIG_IPS_SET(x)\
	FIELD_PREP(ANA_AC_SG_GCL_GS_CONFIG_IPS, x)
#define ANA_AC_SG_GCL_GS_CONFIG_IPS_GET(x)\
	FIELD_GET(ANA_AC_SG_GCL_GS_CONFIG_IPS, x)

#define ANA_AC_SG_GCL_GS_CONFIG_GATE_STATE       BIT(4)
#define ANA_AC_SG_GCL_GS_CONFIG_GATE_STATE_SET(x)\
	FIELD_PREP(ANA_AC_SG_GCL_GS_CONFIG_GATE_STATE, x)
#define ANA_AC_SG_GCL_GS_CONFIG_GATE_STATE_GET(x)\
	FIELD_GET(ANA_AC_SG_GCL_GS_CONFIG_GATE_STATE, x)

/*      ANA_AC:SG_CONFIG:SG_GCL_TI_CONFIG */
#define ANA_AC_SG_GCL_TI_CONFIG(r) __REG(TARGET_ANA_AC,\
					0, 1, 851584, 0, 1, 128, 16, r, 4, 4)

/*      ANA_AC:SG_CONFIG:SG_GCL_OCT_CONFIG */
#define ANA_AC_SG_GCL_OCT_CONFIG(r) __REG(TARGET_ANA_AC,\
					0, 1, 851584, 0, 1, 128, 32, r, 4, 4)

/*      ANA_AC:SG_STATUS:SG_STATUS_REG_1 */
#define ANA_AC_SG_STATUS_REG_1    __REG(TARGET_ANA_AC,\
					0, 1, 839088, 0, 1, 16, 0, 0, 1, 4)

/*      ANA_AC:SG_STATUS:SG_STATUS_REG_2 */
#define ANA_AC_SG_STATUS_REG_2    __REG(TARGET_ANA_AC,\
					0, 1, 839088, 0, 1, 16, 4, 0, 1, 4)

/*      ANA_AC:SG_STATUS:SG_STATUS_REG_3 */
#define ANA_AC_SG_STATUS_REG_3    __REG(TARGET_ANA_AC,\
					0, 1, 839088, 0, 1, 16, 8, 0, 1, 4)

#define ANA_AC_SG_STATUS_REG_3_CFG_CHG_TIME_SEC_MSB GENMASK(15, 0)
#define ANA_AC_SG_STATUS_REG_3_CFG_CHG_TIME_SEC_MSB_SET(x)\
	FIELD_PREP(ANA_AC_SG_STATUS_REG_3_CFG_CHG_TIME_SEC_MSB, x)
#define ANA_AC_SG_STATUS_REG_3_CFG_CHG_TIME_SEC_MSB_GET(x)\
	FIELD_GET(ANA_AC_SG_STATUS_REG_3_CFG_CHG_TIME_SEC_MSB, x)

#define ANA_AC_SG_STATUS_REG_3_GATE_STATE        BIT(16)
#define ANA_AC_SG_STATUS_REG_3_GATE_STATE_SET(x)\
	FIELD_PREP(ANA_AC_SG_STATUS_REG_3_GATE_STATE, x)
#define ANA_AC_SG_STATUS_REG_3_GATE_STATE_GET(x)\
	FIELD_GET(ANA_AC_SG_STATUS_REG_3_GATE_STATE, x)

#define ANA_AC_SG_STATUS_REG_3_IPS               GENMASK(23, 20)
#define ANA_AC_SG_STATUS_REG_3_IPS_SET(x)\
	FIELD_PREP(ANA_AC_SG_STATUS_REG_3_IPS, x)
#define ANA_AC_SG_STATUS_REG_3_IPS_GET(x)\
	FIELD_GET(ANA_AC_SG_STATUS_REG_3_IPS, x)

#define ANA_AC_SG_STATUS_REG_3_CONFIG_PENDING    BIT(24)
#define ANA_AC_SG_STATUS_REG_3_CONFIG_PENDING_SET(x)\
	FIELD_PREP(ANA_AC_SG_STATUS_REG_3_CONFIG_PENDING, x)
#define ANA_AC_SG_STATUS_REG_3_CONFIG_PENDING_GET(x)\
	FIELD_GET(ANA_AC_SG_STATUS_REG_3_CONFIG_PENDING, x)

#define ANA_AC_SG_STATUS_REG_3_GCL_OCTET_INDEX   GENMASK(27, 25)
#define ANA_AC_SG_STATUS_REG_3_GCL_OCTET_INDEX_SET(x)\
	FIELD_PREP(ANA_AC_SG_STATUS_REG_3_GCL_OCTET_INDEX, x)
#define ANA_AC_SG_STATUS_REG_3_GCL_OCTET_INDEX_GET(x)\
	FIELD_GET(ANA_AC_SG_STATUS_REG_3_GCL_OCTET_INDEX, x)

/*      ANA_AC:SG_STATUS:SG_STATUS_REG_4 */
#define ANA_AC_SG_STATUS_REG_4    __REG(TARGET_ANA_AC,\
					0, 1, 839088, 0, 1, 16, 12, 0, 1, 4)

/*      ANA_AC:STAT_GLOBAL_CFG_PORT:STAT_GLOBAL_EVENT_MASK */
#define ANA_AC_PORT_SGE_CFG(r)    __REG(TARGET_ANA_AC,\
					0, 1, 851552, 0, 1, 20, 0, r, 4, 4)

#define ANA_AC_PORT_SGE_CFG_MASK                 GENMASK(15, 0)
#define ANA_AC_PORT_SGE_CFG_MASK_SET(x)\
	FIELD_PREP(ANA_AC_PORT_SGE_CFG_MASK, x)
#define ANA_AC_PORT_SGE_CFG_MASK_GET(x)\
	FIELD_GET(ANA_AC_PORT_SGE_CFG_MASK, x)

/*      ANA_AC:STAT_GLOBAL_CFG_PORT:STAT_RESET */
#define ANA_AC_STAT_RESET         __REG(TARGET_ANA_AC,\
					0, 1, 851552, 0, 1, 20, 16, 0, 1, 4)

#define ANA_AC_STAT_RESET_RESET                  BIT(0)
#define ANA_AC_STAT_RESET_RESET_SET(x)\
	FIELD_PREP(ANA_AC_STAT_RESET_RESET, x)
#define ANA_AC_STAT_RESET_RESET_GET(x)\
	FIELD_GET(ANA_AC_STAT_RESET_RESET, x)

/*      ANA_AC:STAT_CNT_CFG_PORT:STAT_CFG */
#define ANA_AC_PORT_STAT_CFG(g, r) __REG(TARGET_ANA_AC,\
					0, 1, 843776, g, 70, 64, 4, r, 4, 4)

#define ANA_AC_PORT_STAT_CFG_CFG_PRIO_MASK       GENMASK(11, 4)
#define ANA_AC_PORT_STAT_CFG_CFG_PRIO_MASK_SET(x)\
	FIELD_PREP(ANA_AC_PORT_STAT_CFG_CFG_PRIO_MASK, x)
#define ANA_AC_PORT_STAT_CFG_CFG_PRIO_MASK_GET(x)\
	FIELD_GET(ANA_AC_PORT_STAT_CFG_CFG_PRIO_MASK, x)

#define ANA_AC_PORT_STAT_CFG_CFG_CNT_FRM_TYPE    GENMASK(3, 1)
#define ANA_AC_PORT_STAT_CFG_CFG_CNT_FRM_TYPE_SET(x)\
	FIELD_PREP(ANA_AC_PORT_STAT_CFG_CFG_CNT_FRM_TYPE, x)
#define ANA_AC_PORT_STAT_CFG_CFG_CNT_FRM_TYPE_GET(x)\
	FIELD_GET(ANA_AC_PORT_STAT_CFG_CFG_CNT_FRM_TYPE, x)

#define ANA_AC_PORT_STAT_CFG_CFG_CNT_BYTE        BIT(0)
#define ANA_AC_PORT_STAT_CFG_CFG_CNT_BYTE_SET(x)\
	FIELD_PREP(ANA_AC_PORT_STAT_CFG_CFG_CNT_BYTE, x)
#define ANA_AC_PORT_STAT_CFG_CFG_CNT_BYTE_GET(x)\
	FIELD_GET(ANA_AC_PORT_STAT_CFG_CFG_CNT_BYTE, x)

/*      ANA_AC:STAT_CNT_CFG_PORT:STAT_LSB_CNT */
#define ANA_AC_PORT_STAT_LSB_CNT(g, r) __REG(TARGET_ANA_AC,\
					0, 1, 843776, g, 70, 64, 20, r, 4, 4)

/*      ANA_AC:STAT_GLOBAL_CFG_ACL:GLOBAL_CNT_FRM_TYPE_CFG */
#define ANA_AC_ACL_GLOBAL_CNT_FRM_TYPE_CFG(r) __REG(TARGET_ANA_AC,\
					0, 1, 893792, 0, 1, 24, 0, r, 2, 4)

#define ANA_AC_ACL_GLOBAL_CNT_FRM_TYPE_CFG_GLOBAL_CFG_CNT_FRM_TYPE GENMASK(2, 0)
#define ANA_AC_ACL_GLOBAL_CNT_FRM_TYPE_CFG_GLOBAL_CFG_CNT_FRM_TYPE_SET(x)\
	FIELD_PREP(ANA_AC_ACL_GLOBAL_CNT_FRM_TYPE_CFG_GLOBAL_CFG_CNT_FRM_TYPE, x)
#define ANA_AC_ACL_GLOBAL_CNT_FRM_TYPE_CFG_GLOBAL_CFG_CNT_FRM_TYPE_GET(x)\
	FIELD_GET(ANA_AC_ACL_GLOBAL_CNT_FRM_TYPE_CFG_GLOBAL_CFG_CNT_FRM_TYPE, x)

/*      ANA_AC:STAT_GLOBAL_CFG_ACL:STAT_GLOBAL_CFG */
#define ANA_AC_ACL_STAT_GLOBAL_CFG(r) __REG(TARGET_ANA_AC,\
					0, 1, 893792, 0, 1, 24, 8, r, 2, 4)

#define ANA_AC_ACL_STAT_GLOBAL_CFG_GLOBAL_CFG_CNT_BYTE BIT(0)
#define ANA_AC_ACL_STAT_GLOBAL_CFG_GLOBAL_CFG_CNT_BYTE_SET(x)\
	FIELD_PREP(ANA_AC_ACL_STAT_GLOBAL_CFG_GLOBAL_CFG_CNT_BYTE, x)
#define ANA_AC_ACL_STAT_GLOBAL_CFG_GLOBAL_CFG_CNT_BYTE_GET(x)\
	FIELD_GET(ANA_AC_ACL_STAT_GLOBAL_CFG_GLOBAL_CFG_CNT_BYTE, x)

/*      ANA_AC:STAT_GLOBAL_CFG_ACL:STAT_GLOBAL_EVENT_MASK */
#define ANA_AC_ACL_STAT_GLOBAL_EVENT_MASK(r) __REG(TARGET_ANA_AC,\
					0, 1, 893792, 0, 1, 24, 16, r, 2, 4)

#define ANA_AC_ACL_STAT_GLOBAL_EVENT_MASK_GLOBAL_EVENT_MASK GENMASK(3, 0)
#define ANA_AC_ACL_STAT_GLOBAL_EVENT_MASK_GLOBAL_EVENT_MASK_SET(x)\
	FIELD_PREP(ANA_AC_ACL_STAT_GLOBAL_EVENT_MASK_GLOBAL_EVENT_MASK, x)
#define ANA_AC_ACL_STAT_GLOBAL_EVENT_MASK_GLOBAL_EVENT_MASK_GET(x)\
	FIELD_GET(ANA_AC_ACL_STAT_GLOBAL_EVENT_MASK_GLOBAL_EVENT_MASK, x)

/*      ANA_ACL:COMMON:VCAP_S2_CFG */
#define ANA_ACL_VCAP_S2_CFG(r)    __REG(TARGET_ANA_ACL,\
					0, 1, 32768, 0, 1, 592, 0, r, 70, 4)

#define ANA_ACL_VCAP_S2_CFG_SEC_ROUTE_HANDLING_ENA BIT(28)
#define ANA_ACL_VCAP_S2_CFG_SEC_ROUTE_HANDLING_ENA_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_CFG_SEC_ROUTE_HANDLING_ENA, x)
#define ANA_ACL_VCAP_S2_CFG_SEC_ROUTE_HANDLING_ENA_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_CFG_SEC_ROUTE_HANDLING_ENA, x)

#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_OAM_ENA     GENMASK(27, 26)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_OAM_ENA_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_OAM_ENA, x)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_OAM_ENA_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_OAM_ENA, x)

#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP6_TCPUDP_OTHER_ENA GENMASK(25, 24)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP6_TCPUDP_OTHER_ENA_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP6_TCPUDP_OTHER_ENA, x)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP6_TCPUDP_OTHER_ENA_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP6_TCPUDP_OTHER_ENA, x)

#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP6_VID_ENA GENMASK(23, 22)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP6_VID_ENA_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP6_VID_ENA, x)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP6_VID_ENA_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP6_VID_ENA, x)

#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP6_STD_ENA GENMASK(21, 20)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP6_STD_ENA_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP6_STD_ENA, x)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP6_STD_ENA_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP6_STD_ENA, x)

#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP6_TCPUDP_ENA GENMASK(19, 18)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP6_TCPUDP_ENA_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP6_TCPUDP_ENA, x)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP6_TCPUDP_ENA_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP6_TCPUDP_ENA, x)

#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP_7TUPLE_ENA GENMASK(17, 16)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP_7TUPLE_ENA_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP_7TUPLE_ENA, x)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP_7TUPLE_ENA_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP_7TUPLE_ENA, x)

#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP4_VID_ENA GENMASK(15, 14)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP4_VID_ENA_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP4_VID_ENA, x)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP4_VID_ENA_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP4_VID_ENA, x)

#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP4_TCPUDP_ENA GENMASK(13, 12)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP4_TCPUDP_ENA_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP4_TCPUDP_ENA, x)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP4_TCPUDP_ENA_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP4_TCPUDP_ENA, x)

#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP4_OTHER_ENA GENMASK(11, 10)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP4_OTHER_ENA_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP4_OTHER_ENA, x)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP4_OTHER_ENA_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_IP4_OTHER_ENA, x)

#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_ARP_ENA     GENMASK(9, 8)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_ARP_ENA_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_ARP_ENA, x)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_ARP_ENA_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_ARP_ENA, x)

#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_MAC_SNAP_ENA GENMASK(7, 6)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_MAC_SNAP_ENA_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_MAC_SNAP_ENA, x)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_MAC_SNAP_ENA_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_MAC_SNAP_ENA, x)

#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_MAC_LLC_ENA GENMASK(5, 4)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_MAC_LLC_ENA_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_MAC_LLC_ENA, x)
#define ANA_ACL_VCAP_S2_CFG_SEC_TYPE_MAC_LLC_ENA_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_CFG_SEC_TYPE_MAC_LLC_ENA, x)

#define ANA_ACL_VCAP_S2_CFG_SEC_ENA              GENMASK(3, 0)
#define ANA_ACL_VCAP_S2_CFG_SEC_ENA_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_CFG_SEC_ENA, x)
#define ANA_ACL_VCAP_S2_CFG_SEC_ENA_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_CFG_SEC_ENA, x)

/*      ANA_ACL:COMMON:SWAP_IP_CTRL */
#define ANA_ACL_SWAP_IP_CTRL      __REG(TARGET_ANA_ACL,\
					0, 1, 32768, 0, 1, 592, 412, 0, 1, 4)

#define ANA_ACL_SWAP_IP_CTRL_DMAC_REPL_OFFSET_VAL GENMASK(23, 18)
#define ANA_ACL_SWAP_IP_CTRL_DMAC_REPL_OFFSET_VAL_SET(x)\
	FIELD_PREP(ANA_ACL_SWAP_IP_CTRL_DMAC_REPL_OFFSET_VAL, x)
#define ANA_ACL_SWAP_IP_CTRL_DMAC_REPL_OFFSET_VAL_GET(x)\
	FIELD_GET(ANA_ACL_SWAP_IP_CTRL_DMAC_REPL_OFFSET_VAL, x)

#define ANA_ACL_SWAP_IP_CTRL_IP_SWAP_IP6_HOPC_VAL GENMASK(17, 10)
#define ANA_ACL_SWAP_IP_CTRL_IP_SWAP_IP6_HOPC_VAL_SET(x)\
	FIELD_PREP(ANA_ACL_SWAP_IP_CTRL_IP_SWAP_IP6_HOPC_VAL, x)
#define ANA_ACL_SWAP_IP_CTRL_IP_SWAP_IP6_HOPC_VAL_GET(x)\
	FIELD_GET(ANA_ACL_SWAP_IP_CTRL_IP_SWAP_IP6_HOPC_VAL, x)

#define ANA_ACL_SWAP_IP_CTRL_IP_SWAP_IP4_TTL_VAL GENMASK(9, 2)
#define ANA_ACL_SWAP_IP_CTRL_IP_SWAP_IP4_TTL_VAL_SET(x)\
	FIELD_PREP(ANA_ACL_SWAP_IP_CTRL_IP_SWAP_IP4_TTL_VAL, x)
#define ANA_ACL_SWAP_IP_CTRL_IP_SWAP_IP4_TTL_VAL_GET(x)\
	FIELD_GET(ANA_ACL_SWAP_IP_CTRL_IP_SWAP_IP4_TTL_VAL, x)

#define ANA_ACL_SWAP_IP_CTRL_IP_SWAP_IP6_HOPC_ENA BIT(1)
#define ANA_ACL_SWAP_IP_CTRL_IP_SWAP_IP6_HOPC_ENA_SET(x)\
	FIELD_PREP(ANA_ACL_SWAP_IP_CTRL_IP_SWAP_IP6_HOPC_ENA, x)
#define ANA_ACL_SWAP_IP_CTRL_IP_SWAP_IP6_HOPC_ENA_GET(x)\
	FIELD_GET(ANA_ACL_SWAP_IP_CTRL_IP_SWAP_IP6_HOPC_ENA, x)

#define ANA_ACL_SWAP_IP_CTRL_IP_SWAP_IP4_TTL_ENA BIT(0)
#define ANA_ACL_SWAP_IP_CTRL_IP_SWAP_IP4_TTL_ENA_SET(x)\
	FIELD_PREP(ANA_ACL_SWAP_IP_CTRL_IP_SWAP_IP4_TTL_ENA, x)
#define ANA_ACL_SWAP_IP_CTRL_IP_SWAP_IP4_TTL_ENA_GET(x)\
	FIELD_GET(ANA_ACL_SWAP_IP_CTRL_IP_SWAP_IP4_TTL_ENA, x)

/*      ANA_ACL:COMMON:VCAP_S2_RLEG_STAT */
#define ANA_ACL_VCAP_S2_RLEG_STAT(r) __REG(TARGET_ANA_ACL,\
					0, 1, 32768, 0, 1, 592, 424, r, 4, 4)

#define ANA_ACL_VCAP_S2_RLEG_STAT_IRLEG_STAT_MASK GENMASK(12, 6)
#define ANA_ACL_VCAP_S2_RLEG_STAT_IRLEG_STAT_MASK_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_RLEG_STAT_IRLEG_STAT_MASK, x)
#define ANA_ACL_VCAP_S2_RLEG_STAT_IRLEG_STAT_MASK_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_RLEG_STAT_IRLEG_STAT_MASK, x)

#define ANA_ACL_VCAP_S2_RLEG_STAT_ERLEG_STAT_MASK GENMASK(5, 0)
#define ANA_ACL_VCAP_S2_RLEG_STAT_ERLEG_STAT_MASK_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_RLEG_STAT_ERLEG_STAT_MASK, x)
#define ANA_ACL_VCAP_S2_RLEG_STAT_ERLEG_STAT_MASK_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_RLEG_STAT_ERLEG_STAT_MASK, x)

/*      ANA_ACL:COMMON:VCAP_S2_FRAGMENT_CFG */
#define ANA_ACL_VCAP_S2_FRAGMENT_CFG __REG(TARGET_ANA_ACL,\
					0, 1, 32768, 0, 1, 592, 440, 0, 1, 4)

#define ANA_ACL_VCAP_S2_FRAGMENT_CFG_L4_MIN_LEN  GENMASK(9, 5)
#define ANA_ACL_VCAP_S2_FRAGMENT_CFG_L4_MIN_LEN_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_FRAGMENT_CFG_L4_MIN_LEN, x)
#define ANA_ACL_VCAP_S2_FRAGMENT_CFG_L4_MIN_LEN_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_FRAGMENT_CFG_L4_MIN_LEN, x)

#define ANA_ACL_VCAP_S2_FRAGMENT_CFG_FRAGMENT_OFFSET_THRES_DIS BIT(4)
#define ANA_ACL_VCAP_S2_FRAGMENT_CFG_FRAGMENT_OFFSET_THRES_DIS_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_FRAGMENT_CFG_FRAGMENT_OFFSET_THRES_DIS, x)
#define ANA_ACL_VCAP_S2_FRAGMENT_CFG_FRAGMENT_OFFSET_THRES_DIS_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_FRAGMENT_CFG_FRAGMENT_OFFSET_THRES_DIS, x)

#define ANA_ACL_VCAP_S2_FRAGMENT_CFG_FRAGMENT_OFFSET_THRES GENMASK(3, 0)
#define ANA_ACL_VCAP_S2_FRAGMENT_CFG_FRAGMENT_OFFSET_THRES_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_FRAGMENT_CFG_FRAGMENT_OFFSET_THRES, x)
#define ANA_ACL_VCAP_S2_FRAGMENT_CFG_FRAGMENT_OFFSET_THRES_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_FRAGMENT_CFG_FRAGMENT_OFFSET_THRES, x)

/*      ANA_ACL:COMMON:OWN_UPSID */
#define ANA_ACL_OWN_UPSID(r)      __REG(TARGET_ANA_ACL,\
					0, 1, 32768, 0, 1, 592, 580, r, 3, 4)

#define ANA_ACL_OWN_UPSID_OWN_UPSID              GENMASK(4, 0)
#define ANA_ACL_OWN_UPSID_OWN_UPSID_SET(x)\
	FIELD_PREP(ANA_ACL_OWN_UPSID_OWN_UPSID, x)
#define ANA_ACL_OWN_UPSID_OWN_UPSID_GET(x)\
	FIELD_GET(ANA_ACL_OWN_UPSID_OWN_UPSID, x)

/*      ANA_ACL:KEY_SEL:VCAP_S2_KEY_SEL */
#define ANA_ACL_VCAP_S2_KEY_SEL(g, r) __REG(TARGET_ANA_ACL,\
					0, 1, 34200, g, 134, 16, 0, r, 4, 4)

#define ANA_ACL_VCAP_S2_KEY_SEL_KEY_SEL_ENA      BIT(13)
#define ANA_ACL_VCAP_S2_KEY_SEL_KEY_SEL_ENA_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_KEY_SEL_KEY_SEL_ENA, x)
#define ANA_ACL_VCAP_S2_KEY_SEL_KEY_SEL_ENA_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_KEY_SEL_KEY_SEL_ENA, x)

#define ANA_ACL_VCAP_S2_KEY_SEL_IGR_PORT_MASK_SEL BIT(12)
#define ANA_ACL_VCAP_S2_KEY_SEL_IGR_PORT_MASK_SEL_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_KEY_SEL_IGR_PORT_MASK_SEL, x)
#define ANA_ACL_VCAP_S2_KEY_SEL_IGR_PORT_MASK_SEL_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_KEY_SEL_IGR_PORT_MASK_SEL, x)

#define ANA_ACL_VCAP_S2_KEY_SEL_NON_ETH_KEY_SEL  GENMASK(11, 10)
#define ANA_ACL_VCAP_S2_KEY_SEL_NON_ETH_KEY_SEL_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_KEY_SEL_NON_ETH_KEY_SEL, x)
#define ANA_ACL_VCAP_S2_KEY_SEL_NON_ETH_KEY_SEL_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_KEY_SEL_NON_ETH_KEY_SEL, x)

#define ANA_ACL_VCAP_S2_KEY_SEL_IP4_MC_KEY_SEL   GENMASK(9, 8)
#define ANA_ACL_VCAP_S2_KEY_SEL_IP4_MC_KEY_SEL_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_KEY_SEL_IP4_MC_KEY_SEL, x)
#define ANA_ACL_VCAP_S2_KEY_SEL_IP4_MC_KEY_SEL_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_KEY_SEL_IP4_MC_KEY_SEL, x)

#define ANA_ACL_VCAP_S2_KEY_SEL_IP4_UC_KEY_SEL   GENMASK(7, 6)
#define ANA_ACL_VCAP_S2_KEY_SEL_IP4_UC_KEY_SEL_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_KEY_SEL_IP4_UC_KEY_SEL, x)
#define ANA_ACL_VCAP_S2_KEY_SEL_IP4_UC_KEY_SEL_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_KEY_SEL_IP4_UC_KEY_SEL, x)

#define ANA_ACL_VCAP_S2_KEY_SEL_IP6_MC_KEY_SEL   GENMASK(5, 3)
#define ANA_ACL_VCAP_S2_KEY_SEL_IP6_MC_KEY_SEL_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_KEY_SEL_IP6_MC_KEY_SEL, x)
#define ANA_ACL_VCAP_S2_KEY_SEL_IP6_MC_KEY_SEL_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_KEY_SEL_IP6_MC_KEY_SEL, x)

#define ANA_ACL_VCAP_S2_KEY_SEL_IP6_UC_KEY_SEL   GENMASK(2, 1)
#define ANA_ACL_VCAP_S2_KEY_SEL_IP6_UC_KEY_SEL_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_KEY_SEL_IP6_UC_KEY_SEL, x)
#define ANA_ACL_VCAP_S2_KEY_SEL_IP6_UC_KEY_SEL_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_KEY_SEL_IP6_UC_KEY_SEL, x)

#define ANA_ACL_VCAP_S2_KEY_SEL_ARP_KEY_SEL      BIT(0)
#define ANA_ACL_VCAP_S2_KEY_SEL_ARP_KEY_SEL_SET(x)\
	FIELD_PREP(ANA_ACL_VCAP_S2_KEY_SEL_ARP_KEY_SEL, x)
#define ANA_ACL_VCAP_S2_KEY_SEL_ARP_KEY_SEL_GET(x)\
	FIELD_GET(ANA_ACL_VCAP_S2_KEY_SEL_ARP_KEY_SEL, x)

/*      ANA_ACL:CNT_A:CNT_A */
#define ANA_ACL_CNT_A(g)          __REG(TARGET_ANA_ACL,\
					0, 1, 0, g, 4096, 4, 0, 0, 1, 4)

/*      ANA_ACL:CNT_B:CNT_B */
#define ANA_ACL_CNT_B(g)          __REG(TARGET_ANA_ACL,\
					0, 1, 16384, g, 4096, 4, 0, 0, 1, 4)

/*      ANA_ACL:STICKY:SEC_LOOKUP_STICKY */
#define ANA_ACL_SEC_LOOKUP_STICKY(r) __REG(TARGET_ANA_ACL,\
					0, 1, 36408, 0, 1, 16, 0, r, 4, 4)

#define ANA_ACL_SEC_LOOKUP_STICKY_KEY_SEL_CLM_STICKY BIT(17)
#define ANA_ACL_SEC_LOOKUP_STICKY_KEY_SEL_CLM_STICKY_SET(x)\
	FIELD_PREP(ANA_ACL_SEC_LOOKUP_STICKY_KEY_SEL_CLM_STICKY, x)
#define ANA_ACL_SEC_LOOKUP_STICKY_KEY_SEL_CLM_STICKY_GET(x)\
	FIELD_GET(ANA_ACL_SEC_LOOKUP_STICKY_KEY_SEL_CLM_STICKY, x)

#define ANA_ACL_SEC_LOOKUP_STICKY_KEY_SEL_IRLEG_STICKY BIT(16)
#define ANA_ACL_SEC_LOOKUP_STICKY_KEY_SEL_IRLEG_STICKY_SET(x)\
	FIELD_PREP(ANA_ACL_SEC_LOOKUP_STICKY_KEY_SEL_IRLEG_STICKY, x)
#define ANA_ACL_SEC_LOOKUP_STICKY_KEY_SEL_IRLEG_STICKY_GET(x)\
	FIELD_GET(ANA_ACL_SEC_LOOKUP_STICKY_KEY_SEL_IRLEG_STICKY, x)

#define ANA_ACL_SEC_LOOKUP_STICKY_KEY_SEL_ERLEG_STICKY BIT(15)
#define ANA_ACL_SEC_LOOKUP_STICKY_KEY_SEL_ERLEG_STICKY_SET(x)\
	FIELD_PREP(ANA_ACL_SEC_LOOKUP_STICKY_KEY_SEL_ERLEG_STICKY, x)
#define ANA_ACL_SEC_LOOKUP_STICKY_KEY_SEL_ERLEG_STICKY_GET(x)\
	FIELD_GET(ANA_ACL_SEC_LOOKUP_STICKY_KEY_SEL_ERLEG_STICKY, x)

#define ANA_ACL_SEC_LOOKUP_STICKY_KEY_SEL_PORT_STICKY BIT(14)
#define ANA_ACL_SEC_LOOKUP_STICKY_KEY_SEL_PORT_STICKY_SET(x)\
	FIELD_PREP(ANA_ACL_SEC_LOOKUP_STICKY_KEY_SEL_PORT_STICKY, x)
#define ANA_ACL_SEC_LOOKUP_STICKY_KEY_SEL_PORT_STICKY_GET(x)\
	FIELD_GET(ANA_ACL_SEC_LOOKUP_STICKY_KEY_SEL_PORT_STICKY, x)

#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_CUSTOM2_STICKY BIT(13)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_CUSTOM2_STICKY_SET(x)\
	FIELD_PREP(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_CUSTOM2_STICKY, x)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_CUSTOM2_STICKY_GET(x)\
	FIELD_GET(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_CUSTOM2_STICKY, x)

#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_CUSTOM1_STICKY BIT(12)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_CUSTOM1_STICKY_SET(x)\
	FIELD_PREP(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_CUSTOM1_STICKY, x)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_CUSTOM1_STICKY_GET(x)\
	FIELD_GET(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_CUSTOM1_STICKY, x)

#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_OAM_STICKY BIT(11)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_OAM_STICKY_SET(x)\
	FIELD_PREP(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_OAM_STICKY, x)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_OAM_STICKY_GET(x)\
	FIELD_GET(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_OAM_STICKY, x)

#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_VID_STICKY BIT(10)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_VID_STICKY_SET(x)\
	FIELD_PREP(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_VID_STICKY, x)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_VID_STICKY_GET(x)\
	FIELD_GET(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_VID_STICKY, x)

#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_STD_STICKY BIT(9)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_STD_STICKY_SET(x)\
	FIELD_PREP(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_STD_STICKY, x)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_STD_STICKY_GET(x)\
	FIELD_GET(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_STD_STICKY, x)

#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_TCPUDP_STICKY BIT(8)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_TCPUDP_STICKY_SET(x)\
	FIELD_PREP(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_TCPUDP_STICKY, x)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_TCPUDP_STICKY_GET(x)\
	FIELD_GET(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_TCPUDP_STICKY, x)

#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP_7TUPLE_STICKY BIT(7)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP_7TUPLE_STICKY_SET(x)\
	FIELD_PREP(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP_7TUPLE_STICKY, x)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP_7TUPLE_STICKY_GET(x)\
	FIELD_GET(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP_7TUPLE_STICKY, x)

#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_VID_STICKY BIT(6)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_VID_STICKY_SET(x)\
	FIELD_PREP(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_VID_STICKY, x)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_VID_STICKY_GET(x)\
	FIELD_GET(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_VID_STICKY, x)

#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_TCPUDP_STICKY BIT(5)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_TCPUDP_STICKY_SET(x)\
	FIELD_PREP(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_TCPUDP_STICKY, x)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_TCPUDP_STICKY_GET(x)\
	FIELD_GET(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_TCPUDP_STICKY, x)

#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_OTHER_STICKY BIT(4)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_OTHER_STICKY_SET(x)\
	FIELD_PREP(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_OTHER_STICKY, x)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_OTHER_STICKY_GET(x)\
	FIELD_GET(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_OTHER_STICKY, x)

#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_ARP_STICKY BIT(3)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_ARP_STICKY_SET(x)\
	FIELD_PREP(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_ARP_STICKY, x)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_ARP_STICKY_GET(x)\
	FIELD_GET(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_ARP_STICKY, x)

#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_MAC_SNAP_STICKY BIT(2)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_MAC_SNAP_STICKY_SET(x)\
	FIELD_PREP(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_MAC_SNAP_STICKY, x)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_MAC_SNAP_STICKY_GET(x)\
	FIELD_GET(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_MAC_SNAP_STICKY, x)

#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_MAC_LLC_STICKY BIT(1)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_MAC_LLC_STICKY_SET(x)\
	FIELD_PREP(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_MAC_LLC_STICKY, x)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_MAC_LLC_STICKY_GET(x)\
	FIELD_GET(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_MAC_LLC_STICKY, x)

#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_MAC_ETYPE_STICKY BIT(0)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_MAC_ETYPE_STICKY_SET(x)\
	FIELD_PREP(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_MAC_ETYPE_STICKY, x)
#define ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_MAC_ETYPE_STICKY_GET(x)\
	FIELD_GET(ANA_ACL_SEC_LOOKUP_STICKY_SEC_TYPE_MAC_ETYPE_STICKY, x)

/*      ANA_AC_POL:POL_ALL_CFG:POL_UPD_INT_CFG */
#define ANA_AC_POL_POL_UPD_INT_CFG __REG(TARGET_ANA_AC_POL,\
					0, 1, 75968, 0, 1, 1160, 1148, 0, 1, 4)

#define ANA_AC_POL_POL_UPD_INT_CFG_POL_UPD_INT   GENMASK(9, 0)
#define ANA_AC_POL_POL_UPD_INT_CFG_POL_UPD_INT_SET(x)\
	FIELD_PREP(ANA_AC_POL_POL_UPD_INT_CFG_POL_UPD_INT, x)
#define ANA_AC_POL_POL_UPD_INT_CFG_POL_UPD_INT_GET(x)\
	FIELD_GET(ANA_AC_POL_POL_UPD_INT_CFG_POL_UPD_INT, x)

/*      ANA_AC_POL:COMMON_BDLB:DLB_CTRL */
#define ANA_AC_POL_BDLB_DLB_CTRL  __REG(TARGET_ANA_AC_POL,\
					0, 1, 79048, 0, 1, 8, 0, 0, 1, 4)

#define ANA_AC_POL_BDLB_DLB_CTRL_CLK_PERIOD_01NS GENMASK(26, 19)
#define ANA_AC_POL_BDLB_DLB_CTRL_CLK_PERIOD_01NS_SET(x)\
	FIELD_PREP(ANA_AC_POL_BDLB_DLB_CTRL_CLK_PERIOD_01NS, x)
#define ANA_AC_POL_BDLB_DLB_CTRL_CLK_PERIOD_01NS_GET(x)\
	FIELD_GET(ANA_AC_POL_BDLB_DLB_CTRL_CLK_PERIOD_01NS, x)

#define ANA_AC_POL_BDLB_DLB_CTRL_BASE_TICK_CNT   GENMASK(18, 4)
#define ANA_AC_POL_BDLB_DLB_CTRL_BASE_TICK_CNT_SET(x)\
	FIELD_PREP(ANA_AC_POL_BDLB_DLB_CTRL_BASE_TICK_CNT, x)
#define ANA_AC_POL_BDLB_DLB_CTRL_BASE_TICK_CNT_GET(x)\
	FIELD_GET(ANA_AC_POL_BDLB_DLB_CTRL_BASE_TICK_CNT, x)

#define ANA_AC_POL_BDLB_DLB_CTRL_LEAK_ENA        BIT(1)
#define ANA_AC_POL_BDLB_DLB_CTRL_LEAK_ENA_SET(x)\
	FIELD_PREP(ANA_AC_POL_BDLB_DLB_CTRL_LEAK_ENA, x)
#define ANA_AC_POL_BDLB_DLB_CTRL_LEAK_ENA_GET(x)\
	FIELD_GET(ANA_AC_POL_BDLB_DLB_CTRL_LEAK_ENA, x)

#define ANA_AC_POL_BDLB_DLB_CTRL_DLB_ADD_ENA     BIT(0)
#define ANA_AC_POL_BDLB_DLB_CTRL_DLB_ADD_ENA_SET(x)\
	FIELD_PREP(ANA_AC_POL_BDLB_DLB_CTRL_DLB_ADD_ENA, x)
#define ANA_AC_POL_BDLB_DLB_CTRL_DLB_ADD_ENA_GET(x)\
	FIELD_GET(ANA_AC_POL_BDLB_DLB_CTRL_DLB_ADD_ENA, x)

/*      ANA_AC_POL:COMMON_BUM_SLB:DLB_CTRL */
#define ANA_AC_POL_SLB_DLB_CTRL   __REG(TARGET_ANA_AC_POL,\
					0, 1, 79056, 0, 1, 20, 0, 0, 1, 4)

#define ANA_AC_POL_SLB_DLB_CTRL_CLK_PERIOD_01NS  GENMASK(26, 19)
#define ANA_AC_POL_SLB_DLB_CTRL_CLK_PERIOD_01NS_SET(x)\
	FIELD_PREP(ANA_AC_POL_SLB_DLB_CTRL_CLK_PERIOD_01NS, x)
#define ANA_AC_POL_SLB_DLB_CTRL_CLK_PERIOD_01NS_GET(x)\
	FIELD_GET(ANA_AC_POL_SLB_DLB_CTRL_CLK_PERIOD_01NS, x)

#define ANA_AC_POL_SLB_DLB_CTRL_BASE_TICK_CNT    GENMASK(18, 4)
#define ANA_AC_POL_SLB_DLB_CTRL_BASE_TICK_CNT_SET(x)\
	FIELD_PREP(ANA_AC_POL_SLB_DLB_CTRL_BASE_TICK_CNT, x)
#define ANA_AC_POL_SLB_DLB_CTRL_BASE_TICK_CNT_GET(x)\
	FIELD_GET(ANA_AC_POL_SLB_DLB_CTRL_BASE_TICK_CNT, x)

#define ANA_AC_POL_SLB_DLB_CTRL_LEAK_ENA         BIT(1)
#define ANA_AC_POL_SLB_DLB_CTRL_LEAK_ENA_SET(x)\
	FIELD_PREP(ANA_AC_POL_SLB_DLB_CTRL_LEAK_ENA, x)
#define ANA_AC_POL_SLB_DLB_CTRL_LEAK_ENA_GET(x)\
	FIELD_GET(ANA_AC_POL_SLB_DLB_CTRL_LEAK_ENA, x)

#define ANA_AC_POL_SLB_DLB_CTRL_DLB_ADD_ENA      BIT(0)
#define ANA_AC_POL_SLB_DLB_CTRL_DLB_ADD_ENA_SET(x)\
	FIELD_PREP(ANA_AC_POL_SLB_DLB_CTRL_DLB_ADD_ENA, x)
#define ANA_AC_POL_SLB_DLB_CTRL_DLB_ADD_ENA_GET(x)\
	FIELD_GET(ANA_AC_POL_SLB_DLB_CTRL_DLB_ADD_ENA, x)

/*      ANA_AC_SDLB:LBGRP_TBL:XLB_START */
#define ANA_AC_SDLB_XLB_START(g)  __REG(TARGET_ANA_AC_SDLB,\
					0, 1, 295468, g, 10, 24, 0, 0, 1, 4)

#define ANA_AC_SDLB_XLB_START_LBSET_START        GENMASK(12, 0)
#define ANA_AC_SDLB_XLB_START_LBSET_START_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_XLB_START_LBSET_START, x)
#define ANA_AC_SDLB_XLB_START_LBSET_START_GET(x)\
	FIELD_GET(ANA_AC_SDLB_XLB_START_LBSET_START, x)

/*      ANA_AC_SDLB:LBGRP_TBL:PUP_INTERVAL */
#define ANA_AC_SDLB_PUP_INTERVAL(g) __REG(TARGET_ANA_AC_SDLB,\
					0, 1, 295468, g, 10, 24, 4, 0, 1, 4)

#define ANA_AC_SDLB_PUP_INTERVAL_PUP_INTERVAL    GENMASK(19, 0)
#define ANA_AC_SDLB_PUP_INTERVAL_PUP_INTERVAL_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_PUP_INTERVAL_PUP_INTERVAL, x)
#define ANA_AC_SDLB_PUP_INTERVAL_PUP_INTERVAL_GET(x)\
	FIELD_GET(ANA_AC_SDLB_PUP_INTERVAL_PUP_INTERVAL, x)

/*      ANA_AC_SDLB:LBGRP_TBL:PUP_CTRL */
#define ANA_AC_SDLB_PUP_CTRL(g)   __REG(TARGET_ANA_AC_SDLB,\
					0, 1, 295468, g, 10, 24, 8, 0, 1, 4)

#define ANA_AC_SDLB_PUP_CTRL_PUP_LB_DT           GENMASK(18, 0)
#define ANA_AC_SDLB_PUP_CTRL_PUP_LB_DT_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_PUP_CTRL_PUP_LB_DT, x)
#define ANA_AC_SDLB_PUP_CTRL_PUP_LB_DT_GET(x)\
	FIELD_GET(ANA_AC_SDLB_PUP_CTRL_PUP_LB_DT, x)

#define ANA_AC_SDLB_PUP_CTRL_PUP_ENA             BIT(24)
#define ANA_AC_SDLB_PUP_CTRL_PUP_ENA_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_PUP_CTRL_PUP_ENA, x)
#define ANA_AC_SDLB_PUP_CTRL_PUP_ENA_GET(x)\
	FIELD_GET(ANA_AC_SDLB_PUP_CTRL_PUP_ENA, x)

/*      ANA_AC_SDLB:LBGRP_TBL:LBGRP_MISC */
#define ANA_AC_SDLB_LBGRP_MISC(g) __REG(TARGET_ANA_AC_SDLB,\
					0, 1, 295468, g, 10, 24, 12, 0, 1, 4)

#define ANA_AC_SDLB_LBGRP_MISC_THRES_SHIFT       GENMASK(12, 8)
#define ANA_AC_SDLB_LBGRP_MISC_THRES_SHIFT_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_LBGRP_MISC_THRES_SHIFT, x)
#define ANA_AC_SDLB_LBGRP_MISC_THRES_SHIFT_GET(x)\
	FIELD_GET(ANA_AC_SDLB_LBGRP_MISC_THRES_SHIFT, x)

/*      ANA_AC_SDLB:LBGRP_TBL:FRM_RATE_TOKENS */
#define ANA_AC_SDLB_FRM_RATE_TOKENS(g) __REG(TARGET_ANA_AC_SDLB,\
					0, 1, 295468, g, 10, 24, 16, 0, 1, 4)

#define ANA_AC_SDLB_FRM_RATE_TOKENS_FRM_RATE_TOKENS GENMASK(12, 0)
#define ANA_AC_SDLB_FRM_RATE_TOKENS_FRM_RATE_TOKENS_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_FRM_RATE_TOKENS_FRM_RATE_TOKENS, x)
#define ANA_AC_SDLB_FRM_RATE_TOKENS_FRM_RATE_TOKENS_GET(x)\
	FIELD_GET(ANA_AC_SDLB_FRM_RATE_TOKENS_FRM_RATE_TOKENS, x)

/*      ANA_AC_SDLB:LBGRP_TBL:LBGRP_STATE_TBL */
#define ANA_AC_SDLB_LBGRP_STATE_TBL(g) __REG(TARGET_ANA_AC_SDLB,\
					0, 1, 295468, g, 10, 24, 20, 0, 1, 4)

#define ANA_AC_SDLB_LBGRP_STATE_TBL_PUP_ONGOING  BIT(0)
#define ANA_AC_SDLB_LBGRP_STATE_TBL_PUP_ONGOING_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_LBGRP_STATE_TBL_PUP_ONGOING, x)
#define ANA_AC_SDLB_LBGRP_STATE_TBL_PUP_ONGOING_GET(x)\
	FIELD_GET(ANA_AC_SDLB_LBGRP_STATE_TBL_PUP_ONGOING, x)

#define ANA_AC_SDLB_LBGRP_STATE_TBL_PUP_WAIT_ACK BIT(1)
#define ANA_AC_SDLB_LBGRP_STATE_TBL_PUP_WAIT_ACK_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_LBGRP_STATE_TBL_PUP_WAIT_ACK, x)
#define ANA_AC_SDLB_LBGRP_STATE_TBL_PUP_WAIT_ACK_GET(x)\
	FIELD_GET(ANA_AC_SDLB_LBGRP_STATE_TBL_PUP_WAIT_ACK, x)

#define ANA_AC_SDLB_LBGRP_STATE_TBL_PUP_LBSET_NEXT GENMASK(28, 16)
#define ANA_AC_SDLB_LBGRP_STATE_TBL_PUP_LBSET_NEXT_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_LBGRP_STATE_TBL_PUP_LBSET_NEXT, x)
#define ANA_AC_SDLB_LBGRP_STATE_TBL_PUP_LBSET_NEXT_GET(x)\
	FIELD_GET(ANA_AC_SDLB_LBGRP_STATE_TBL_PUP_LBSET_NEXT, x)

/*      ANA_AC_SDLB:LBSET_TBL:PUP_TOKENS */
#define ANA_AC_SDLB_PUP_TOKENS(g, r) __REG(TARGET_ANA_AC_SDLB,\
					0, 1, 0, g, 4616, 64, 0, r, 2, 4)

#define ANA_AC_SDLB_PUP_TOKENS_PUP_TOKENS        GENMASK(12, 0)
#define ANA_AC_SDLB_PUP_TOKENS_PUP_TOKENS_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_PUP_TOKENS_PUP_TOKENS, x)
#define ANA_AC_SDLB_PUP_TOKENS_PUP_TOKENS_GET(x)\
	FIELD_GET(ANA_AC_SDLB_PUP_TOKENS_PUP_TOKENS, x)

/*      ANA_AC_SDLB:LBSET_TBL:THRES */
#define ANA_AC_SDLB_THRES(g, r)   __REG(TARGET_ANA_AC_SDLB,\
					0, 1, 0, g, 4616, 64, 8, r, 2, 4)

#define ANA_AC_SDLB_THRES_THRES                  GENMASK(9, 0)
#define ANA_AC_SDLB_THRES_THRES_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_THRES_THRES, x)
#define ANA_AC_SDLB_THRES_THRES_GET(x)\
	FIELD_GET(ANA_AC_SDLB_THRES_THRES, x)

#define ANA_AC_SDLB_THRES_THRES_HYS              GENMASK(25, 16)
#define ANA_AC_SDLB_THRES_THRES_HYS_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_THRES_THRES_HYS, x)
#define ANA_AC_SDLB_THRES_THRES_HYS_GET(x)\
	FIELD_GET(ANA_AC_SDLB_THRES_THRES_HYS, x)

/*      ANA_AC_SDLB:LBSET_TBL:XLB_NEXT */
#define ANA_AC_SDLB_XLB_NEXT(g)   __REG(TARGET_ANA_AC_SDLB,\
					0, 1, 0, g, 4616, 64, 16, 0, 1, 4)

#define ANA_AC_SDLB_XLB_NEXT_LBSET_NEXT          GENMASK(12, 0)
#define ANA_AC_SDLB_XLB_NEXT_LBSET_NEXT_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_XLB_NEXT_LBSET_NEXT, x)
#define ANA_AC_SDLB_XLB_NEXT_LBSET_NEXT_GET(x)\
	FIELD_GET(ANA_AC_SDLB_XLB_NEXT_LBSET_NEXT, x)

#define ANA_AC_SDLB_XLB_NEXT_LBGRP               GENMASK(27, 24)
#define ANA_AC_SDLB_XLB_NEXT_LBGRP_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_XLB_NEXT_LBGRP, x)
#define ANA_AC_SDLB_XLB_NEXT_LBGRP_GET(x)\
	FIELD_GET(ANA_AC_SDLB_XLB_NEXT_LBGRP, x)

/*      ANA_AC_SDLB:LBSET_TBL:INH_CTRL */
#define ANA_AC_SDLB_INH_CTRL(g, r) __REG(TARGET_ANA_AC_SDLB,\
					0, 1, 0, g, 4616, 64, 20, r, 2, 4)

#define ANA_AC_SDLB_INH_CTRL_PUP_TOKENS_MAX      GENMASK(12, 0)
#define ANA_AC_SDLB_INH_CTRL_PUP_TOKENS_MAX_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_INH_CTRL_PUP_TOKENS_MAX, x)
#define ANA_AC_SDLB_INH_CTRL_PUP_TOKENS_MAX_GET(x)\
	FIELD_GET(ANA_AC_SDLB_INH_CTRL_PUP_TOKENS_MAX, x)

#define ANA_AC_SDLB_INH_CTRL_INH_MODE            GENMASK(21, 20)
#define ANA_AC_SDLB_INH_CTRL_INH_MODE_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_INH_CTRL_INH_MODE, x)
#define ANA_AC_SDLB_INH_CTRL_INH_MODE_GET(x)\
	FIELD_GET(ANA_AC_SDLB_INH_CTRL_INH_MODE, x)

#define ANA_AC_SDLB_INH_CTRL_INH_LB              BIT(24)
#define ANA_AC_SDLB_INH_CTRL_INH_LB_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_INH_CTRL_INH_LB, x)
#define ANA_AC_SDLB_INH_CTRL_INH_LB_GET(x)\
	FIELD_GET(ANA_AC_SDLB_INH_CTRL_INH_LB, x)

/*      ANA_AC_SDLB:LBSET_TBL:INH_LBSET_ADDR */
#define ANA_AC_SDLB_INH_LBSET_ADDR(g) __REG(TARGET_ANA_AC_SDLB,\
					0, 1, 0, g, 4616, 64, 28, 0, 1, 4)

#define ANA_AC_SDLB_INH_LBSET_ADDR_INH_LBSET_ADDR GENMASK(12, 0)
#define ANA_AC_SDLB_INH_LBSET_ADDR_INH_LBSET_ADDR_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_INH_LBSET_ADDR_INH_LBSET_ADDR, x)
#define ANA_AC_SDLB_INH_LBSET_ADDR_INH_LBSET_ADDR_GET(x)\
	FIELD_GET(ANA_AC_SDLB_INH_LBSET_ADDR_INH_LBSET_ADDR, x)

/*      ANA_AC_SDLB:LBSET_TBL:DLB_MISC */
#define ANA_AC_SDLB_DLB_MISC(g)   __REG(TARGET_ANA_AC_SDLB,\
					0, 1, 0, g, 4616, 64, 32, 0, 1, 4)

#define ANA_AC_SDLB_DLB_MISC_DLB_FRM_RATE_ENA    BIT(0)
#define ANA_AC_SDLB_DLB_MISC_DLB_FRM_RATE_ENA_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_DLB_MISC_DLB_FRM_RATE_ENA, x)
#define ANA_AC_SDLB_DLB_MISC_DLB_FRM_RATE_ENA_GET(x)\
	FIELD_GET(ANA_AC_SDLB_DLB_MISC_DLB_FRM_RATE_ENA, x)

#define ANA_AC_SDLB_DLB_MISC_MARK_ALL_FRMS_RED_ENA BIT(6)
#define ANA_AC_SDLB_DLB_MISC_MARK_ALL_FRMS_RED_ENA_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_DLB_MISC_MARK_ALL_FRMS_RED_ENA, x)
#define ANA_AC_SDLB_DLB_MISC_MARK_ALL_FRMS_RED_ENA_GET(x)\
	FIELD_GET(ANA_AC_SDLB_DLB_MISC_MARK_ALL_FRMS_RED_ENA, x)

#define ANA_AC_SDLB_DLB_MISC_DLB_FRM_ADJ         GENMASK(14, 8)
#define ANA_AC_SDLB_DLB_MISC_DLB_FRM_ADJ_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_DLB_MISC_DLB_FRM_ADJ, x)
#define ANA_AC_SDLB_DLB_MISC_DLB_FRM_ADJ_GET(x)\
	FIELD_GET(ANA_AC_SDLB_DLB_MISC_DLB_FRM_ADJ, x)

/*      ANA_AC_SDLB:LBSET_TBL:DLB_CFG */
#define ANA_AC_SDLB_DLB_CFG(g)    __REG(TARGET_ANA_AC_SDLB,\
					0, 1, 0, g, 4616, 64, 36, 0, 1, 4)

#define ANA_AC_SDLB_DLB_CFG_DROP_ON_YELLOW_ENA   BIT(11)
#define ANA_AC_SDLB_DLB_CFG_DROP_ON_YELLOW_ENA_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_DLB_CFG_DROP_ON_YELLOW_ENA, x)
#define ANA_AC_SDLB_DLB_CFG_DROP_ON_YELLOW_ENA_GET(x)\
	FIELD_GET(ANA_AC_SDLB_DLB_CFG_DROP_ON_YELLOW_ENA, x)

#define ANA_AC_SDLB_DLB_CFG_DP_BYPASS_LVL        GENMASK(10, 9)
#define ANA_AC_SDLB_DLB_CFG_DP_BYPASS_LVL_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_DLB_CFG_DP_BYPASS_LVL, x)
#define ANA_AC_SDLB_DLB_CFG_DP_BYPASS_LVL_GET(x)\
	FIELD_GET(ANA_AC_SDLB_DLB_CFG_DP_BYPASS_LVL, x)

#define ANA_AC_SDLB_DLB_CFG_HIER_DLB_DIS         BIT(8)
#define ANA_AC_SDLB_DLB_CFG_HIER_DLB_DIS_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_DLB_CFG_HIER_DLB_DIS, x)
#define ANA_AC_SDLB_DLB_CFG_HIER_DLB_DIS_GET(x)\
	FIELD_GET(ANA_AC_SDLB_DLB_CFG_HIER_DLB_DIS, x)

#define ANA_AC_SDLB_DLB_CFG_ENCAP_DATA_DIS       BIT(7)
#define ANA_AC_SDLB_DLB_CFG_ENCAP_DATA_DIS_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_DLB_CFG_ENCAP_DATA_DIS, x)
#define ANA_AC_SDLB_DLB_CFG_ENCAP_DATA_DIS_GET(x)\
	FIELD_GET(ANA_AC_SDLB_DLB_CFG_ENCAP_DATA_DIS, x)

#define ANA_AC_SDLB_DLB_CFG_COLOR_AWARE_LVL      GENMASK(6, 5)
#define ANA_AC_SDLB_DLB_CFG_COLOR_AWARE_LVL_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_DLB_CFG_COLOR_AWARE_LVL, x)
#define ANA_AC_SDLB_DLB_CFG_COLOR_AWARE_LVL_GET(x)\
	FIELD_GET(ANA_AC_SDLB_DLB_CFG_COLOR_AWARE_LVL, x)

#define ANA_AC_SDLB_DLB_CFG_CIR_INC_DP_VAL       GENMASK(4, 3)
#define ANA_AC_SDLB_DLB_CFG_CIR_INC_DP_VAL_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_DLB_CFG_CIR_INC_DP_VAL, x)
#define ANA_AC_SDLB_DLB_CFG_CIR_INC_DP_VAL_GET(x)\
	FIELD_GET(ANA_AC_SDLB_DLB_CFG_CIR_INC_DP_VAL, x)

#define ANA_AC_SDLB_DLB_CFG_DLB_MODE             BIT(2)
#define ANA_AC_SDLB_DLB_CFG_DLB_MODE_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_DLB_CFG_DLB_MODE, x)
#define ANA_AC_SDLB_DLB_CFG_DLB_MODE_GET(x)\
	FIELD_GET(ANA_AC_SDLB_DLB_CFG_DLB_MODE, x)

#define ANA_AC_SDLB_DLB_CFG_TRAFFIC_TYPE_MASK    GENMASK(1, 0)
#define ANA_AC_SDLB_DLB_CFG_TRAFFIC_TYPE_MASK_SET(x)\
	FIELD_PREP(ANA_AC_SDLB_DLB_CFG_TRAFFIC_TYPE_MASK, x)
#define ANA_AC_SDLB_DLB_CFG_TRAFFIC_TYPE_MASK_GET(x)\
	FIELD_GET(ANA_AC_SDLB_DLB_CFG_TRAFFIC_TYPE_MASK, x)

/*      ANA_CL:PORT:FILTER_CTRL */
#define ANA_CL_FILTER_CTRL(g)     __REG(TARGET_ANA_CL,\
					0, 1, 131072, g, 70, 512, 4, 0, 1, 4)

#define ANA_CL_FILTER_CTRL_FILTER_SMAC_MC_DIS    BIT(2)
#define ANA_CL_FILTER_CTRL_FILTER_SMAC_MC_DIS_SET(x)\
	FIELD_PREP(ANA_CL_FILTER_CTRL_FILTER_SMAC_MC_DIS, x)
#define ANA_CL_FILTER_CTRL_FILTER_SMAC_MC_DIS_GET(x)\
	FIELD_GET(ANA_CL_FILTER_CTRL_FILTER_SMAC_MC_DIS, x)

#define ANA_CL_FILTER_CTRL_FILTER_NULL_MAC_DIS   BIT(1)
#define ANA_CL_FILTER_CTRL_FILTER_NULL_MAC_DIS_SET(x)\
	FIELD_PREP(ANA_CL_FILTER_CTRL_FILTER_NULL_MAC_DIS, x)
#define ANA_CL_FILTER_CTRL_FILTER_NULL_MAC_DIS_GET(x)\
	FIELD_GET(ANA_CL_FILTER_CTRL_FILTER_NULL_MAC_DIS, x)

#define ANA_CL_FILTER_CTRL_FORCE_FCS_UPDATE_ENA  BIT(0)
#define ANA_CL_FILTER_CTRL_FORCE_FCS_UPDATE_ENA_SET(x)\
	FIELD_PREP(ANA_CL_FILTER_CTRL_FORCE_FCS_UPDATE_ENA, x)
#define ANA_CL_FILTER_CTRL_FORCE_FCS_UPDATE_ENA_GET(x)\
	FIELD_GET(ANA_CL_FILTER_CTRL_FORCE_FCS_UPDATE_ENA, x)

/*      ANA_CL:PORT:VLAN_FILTER_CTRL */
#define ANA_CL_VLAN_FILTER_CTRL(g, r) __REG(TARGET_ANA_CL,\
					0, 1, 131072, g, 70, 512, 8, r, 3, 4)

#define ANA_CL_VLAN_FILTER_CTRL_TAG_REQUIRED_ENA BIT(10)
#define ANA_CL_VLAN_FILTER_CTRL_TAG_REQUIRED_ENA_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_FILTER_CTRL_TAG_REQUIRED_ENA, x)
#define ANA_CL_VLAN_FILTER_CTRL_TAG_REQUIRED_ENA_GET(x)\
	FIELD_GET(ANA_CL_VLAN_FILTER_CTRL_TAG_REQUIRED_ENA, x)

#define ANA_CL_VLAN_FILTER_CTRL_PRIO_CTAG_DIS    BIT(9)
#define ANA_CL_VLAN_FILTER_CTRL_PRIO_CTAG_DIS_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_FILTER_CTRL_PRIO_CTAG_DIS, x)
#define ANA_CL_VLAN_FILTER_CTRL_PRIO_CTAG_DIS_GET(x)\
	FIELD_GET(ANA_CL_VLAN_FILTER_CTRL_PRIO_CTAG_DIS, x)

#define ANA_CL_VLAN_FILTER_CTRL_CTAG_DIS         BIT(8)
#define ANA_CL_VLAN_FILTER_CTRL_CTAG_DIS_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_FILTER_CTRL_CTAG_DIS, x)
#define ANA_CL_VLAN_FILTER_CTRL_CTAG_DIS_GET(x)\
	FIELD_GET(ANA_CL_VLAN_FILTER_CTRL_CTAG_DIS, x)

#define ANA_CL_VLAN_FILTER_CTRL_PRIO_STAG_DIS    BIT(7)
#define ANA_CL_VLAN_FILTER_CTRL_PRIO_STAG_DIS_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_FILTER_CTRL_PRIO_STAG_DIS, x)
#define ANA_CL_VLAN_FILTER_CTRL_PRIO_STAG_DIS_GET(x)\
	FIELD_GET(ANA_CL_VLAN_FILTER_CTRL_PRIO_STAG_DIS, x)

#define ANA_CL_VLAN_FILTER_CTRL_PRIO_CUST1_STAG_DIS BIT(6)
#define ANA_CL_VLAN_FILTER_CTRL_PRIO_CUST1_STAG_DIS_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_FILTER_CTRL_PRIO_CUST1_STAG_DIS, x)
#define ANA_CL_VLAN_FILTER_CTRL_PRIO_CUST1_STAG_DIS_GET(x)\
	FIELD_GET(ANA_CL_VLAN_FILTER_CTRL_PRIO_CUST1_STAG_DIS, x)

#define ANA_CL_VLAN_FILTER_CTRL_PRIO_CUST2_STAG_DIS BIT(5)
#define ANA_CL_VLAN_FILTER_CTRL_PRIO_CUST2_STAG_DIS_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_FILTER_CTRL_PRIO_CUST2_STAG_DIS, x)
#define ANA_CL_VLAN_FILTER_CTRL_PRIO_CUST2_STAG_DIS_GET(x)\
	FIELD_GET(ANA_CL_VLAN_FILTER_CTRL_PRIO_CUST2_STAG_DIS, x)

#define ANA_CL_VLAN_FILTER_CTRL_PRIO_CUST3_STAG_DIS BIT(4)
#define ANA_CL_VLAN_FILTER_CTRL_PRIO_CUST3_STAG_DIS_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_FILTER_CTRL_PRIO_CUST3_STAG_DIS, x)
#define ANA_CL_VLAN_FILTER_CTRL_PRIO_CUST3_STAG_DIS_GET(x)\
	FIELD_GET(ANA_CL_VLAN_FILTER_CTRL_PRIO_CUST3_STAG_DIS, x)

#define ANA_CL_VLAN_FILTER_CTRL_STAG_DIS         BIT(3)
#define ANA_CL_VLAN_FILTER_CTRL_STAG_DIS_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_FILTER_CTRL_STAG_DIS, x)
#define ANA_CL_VLAN_FILTER_CTRL_STAG_DIS_GET(x)\
	FIELD_GET(ANA_CL_VLAN_FILTER_CTRL_STAG_DIS, x)

#define ANA_CL_VLAN_FILTER_CTRL_CUST1_STAG_DIS   BIT(2)
#define ANA_CL_VLAN_FILTER_CTRL_CUST1_STAG_DIS_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_FILTER_CTRL_CUST1_STAG_DIS, x)
#define ANA_CL_VLAN_FILTER_CTRL_CUST1_STAG_DIS_GET(x)\
	FIELD_GET(ANA_CL_VLAN_FILTER_CTRL_CUST1_STAG_DIS, x)

#define ANA_CL_VLAN_FILTER_CTRL_CUST2_STAG_DIS   BIT(1)
#define ANA_CL_VLAN_FILTER_CTRL_CUST2_STAG_DIS_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_FILTER_CTRL_CUST2_STAG_DIS, x)
#define ANA_CL_VLAN_FILTER_CTRL_CUST2_STAG_DIS_GET(x)\
	FIELD_GET(ANA_CL_VLAN_FILTER_CTRL_CUST2_STAG_DIS, x)

#define ANA_CL_VLAN_FILTER_CTRL_CUST3_STAG_DIS   BIT(0)
#define ANA_CL_VLAN_FILTER_CTRL_CUST3_STAG_DIS_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_FILTER_CTRL_CUST3_STAG_DIS, x)
#define ANA_CL_VLAN_FILTER_CTRL_CUST3_STAG_DIS_GET(x)\
	FIELD_GET(ANA_CL_VLAN_FILTER_CTRL_CUST3_STAG_DIS, x)

/*      ANA_CL:PORT:ETAG_FILTER_CTRL */
#define ANA_CL_ETAG_FILTER_CTRL(g) __REG(TARGET_ANA_CL,\
					0, 1, 131072, g, 70, 512, 20, 0, 1, 4)

#define ANA_CL_ETAG_FILTER_CTRL_ETAG_REQUIRED_ENA BIT(1)
#define ANA_CL_ETAG_FILTER_CTRL_ETAG_REQUIRED_ENA_SET(x)\
	FIELD_PREP(ANA_CL_ETAG_FILTER_CTRL_ETAG_REQUIRED_ENA, x)
#define ANA_CL_ETAG_FILTER_CTRL_ETAG_REQUIRED_ENA_GET(x)\
	FIELD_GET(ANA_CL_ETAG_FILTER_CTRL_ETAG_REQUIRED_ENA, x)

#define ANA_CL_ETAG_FILTER_CTRL_ETAG_DIS         BIT(0)
#define ANA_CL_ETAG_FILTER_CTRL_ETAG_DIS_SET(x)\
	FIELD_PREP(ANA_CL_ETAG_FILTER_CTRL_ETAG_DIS, x)
#define ANA_CL_ETAG_FILTER_CTRL_ETAG_DIS_GET(x)\
	FIELD_GET(ANA_CL_ETAG_FILTER_CTRL_ETAG_DIS, x)

/*      ANA_CL:PORT:VLAN_CTRL */
#define ANA_CL_VLAN_CTRL(g)       __REG(TARGET_ANA_CL,\
					0, 1, 131072, g, 70, 512, 32, 0, 1, 4)

#define ANA_CL_VLAN_CTRL_PORT_VOE_TPID_AWARE_DIS GENMASK(30, 26)
#define ANA_CL_VLAN_CTRL_PORT_VOE_TPID_AWARE_DIS_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_CTRL_PORT_VOE_TPID_AWARE_DIS, x)
#define ANA_CL_VLAN_CTRL_PORT_VOE_TPID_AWARE_DIS_GET(x)\
	FIELD_GET(ANA_CL_VLAN_CTRL_PORT_VOE_TPID_AWARE_DIS, x)

#define ANA_CL_VLAN_CTRL_PORT_VOE_DEFAULT_PCP    GENMASK(25, 23)
#define ANA_CL_VLAN_CTRL_PORT_VOE_DEFAULT_PCP_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_CTRL_PORT_VOE_DEFAULT_PCP, x)
#define ANA_CL_VLAN_CTRL_PORT_VOE_DEFAULT_PCP_GET(x)\
	FIELD_GET(ANA_CL_VLAN_CTRL_PORT_VOE_DEFAULT_PCP, x)

#define ANA_CL_VLAN_CTRL_PORT_VOE_DEFAULT_DEI    BIT(22)
#define ANA_CL_VLAN_CTRL_PORT_VOE_DEFAULT_DEI_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_CTRL_PORT_VOE_DEFAULT_DEI, x)
#define ANA_CL_VLAN_CTRL_PORT_VOE_DEFAULT_DEI_GET(x)\
	FIELD_GET(ANA_CL_VLAN_CTRL_PORT_VOE_DEFAULT_DEI, x)

#define ANA_CL_VLAN_CTRL_VLAN_PCP_DEI_TRANS_ENA  BIT(21)
#define ANA_CL_VLAN_CTRL_VLAN_PCP_DEI_TRANS_ENA_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_CTRL_VLAN_PCP_DEI_TRANS_ENA, x)
#define ANA_CL_VLAN_CTRL_VLAN_PCP_DEI_TRANS_ENA_GET(x)\
	FIELD_GET(ANA_CL_VLAN_CTRL_VLAN_PCP_DEI_TRANS_ENA, x)

#define ANA_CL_VLAN_CTRL_VLAN_TAG_SEL            BIT(20)
#define ANA_CL_VLAN_CTRL_VLAN_TAG_SEL_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_CTRL_VLAN_TAG_SEL, x)
#define ANA_CL_VLAN_CTRL_VLAN_TAG_SEL_GET(x)\
	FIELD_GET(ANA_CL_VLAN_CTRL_VLAN_TAG_SEL, x)

#define ANA_CL_VLAN_CTRL_VLAN_AWARE_ENA          BIT(19)
#define ANA_CL_VLAN_CTRL_VLAN_AWARE_ENA_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_CTRL_VLAN_AWARE_ENA, x)
#define ANA_CL_VLAN_CTRL_VLAN_AWARE_ENA_GET(x)\
	FIELD_GET(ANA_CL_VLAN_CTRL_VLAN_AWARE_ENA, x)

#define ANA_CL_VLAN_CTRL_VLAN_POP_CNT            GENMASK(18, 17)
#define ANA_CL_VLAN_CTRL_VLAN_POP_CNT_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_CTRL_VLAN_POP_CNT, x)
#define ANA_CL_VLAN_CTRL_VLAN_POP_CNT_GET(x)\
	FIELD_GET(ANA_CL_VLAN_CTRL_VLAN_POP_CNT, x)

#define ANA_CL_VLAN_CTRL_PORT_TAG_TYPE           BIT(16)
#define ANA_CL_VLAN_CTRL_PORT_TAG_TYPE_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_CTRL_PORT_TAG_TYPE, x)
#define ANA_CL_VLAN_CTRL_PORT_TAG_TYPE_GET(x)\
	FIELD_GET(ANA_CL_VLAN_CTRL_PORT_TAG_TYPE, x)

#define ANA_CL_VLAN_CTRL_PORT_PCP                GENMASK(15, 13)
#define ANA_CL_VLAN_CTRL_PORT_PCP_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_CTRL_PORT_PCP, x)
#define ANA_CL_VLAN_CTRL_PORT_PCP_GET(x)\
	FIELD_GET(ANA_CL_VLAN_CTRL_PORT_PCP, x)

#define ANA_CL_VLAN_CTRL_PORT_DEI                BIT(12)
#define ANA_CL_VLAN_CTRL_PORT_DEI_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_CTRL_PORT_DEI, x)
#define ANA_CL_VLAN_CTRL_PORT_DEI_GET(x)\
	FIELD_GET(ANA_CL_VLAN_CTRL_PORT_DEI, x)

#define ANA_CL_VLAN_CTRL_PORT_VID                GENMASK(11, 0)
#define ANA_CL_VLAN_CTRL_PORT_VID_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_CTRL_PORT_VID, x)
#define ANA_CL_VLAN_CTRL_PORT_VID_GET(x)\
	FIELD_GET(ANA_CL_VLAN_CTRL_PORT_VID, x)

/*      ANA_CL:PORT:VLAN_CTRL_2 */
#define ANA_CL_VLAN_CTRL_2(g)     __REG(TARGET_ANA_CL,\
					0, 1, 131072, g, 70, 512, 36, 0, 1, 4)

#define ANA_CL_VLAN_CTRL_2_VLAN_PUSH_CNT         GENMASK(1, 0)
#define ANA_CL_VLAN_CTRL_2_VLAN_PUSH_CNT_SET(x)\
	FIELD_PREP(ANA_CL_VLAN_CTRL_2_VLAN_PUSH_CNT, x)
#define ANA_CL_VLAN_CTRL_2_VLAN_PUSH_CNT_GET(x)\
	FIELD_GET(ANA_CL_VLAN_CTRL_2_VLAN_PUSH_CNT, x)

/*      ANA_CL:PORT:PCP_DEI_MAP_CFG */
#define ANA_CL_PCP_DEI_MAP_CFG(g, r) __REG(TARGET_ANA_CL,\
					0, 1, 131072, g, 70, 512, 108, r, 16, 4)

#define ANA_CL_PCP_DEI_MAP_CFG_PCP_DEI_DP_VAL    GENMASK(4, 3)
#define ANA_CL_PCP_DEI_MAP_CFG_PCP_DEI_DP_VAL_SET(x)\
	FIELD_PREP(ANA_CL_PCP_DEI_MAP_CFG_PCP_DEI_DP_VAL, x)
#define ANA_CL_PCP_DEI_MAP_CFG_PCP_DEI_DP_VAL_GET(x)\
	FIELD_GET(ANA_CL_PCP_DEI_MAP_CFG_PCP_DEI_DP_VAL, x)

#define ANA_CL_PCP_DEI_MAP_CFG_PCP_DEI_QOS_VAL   GENMASK(2, 0)
#define ANA_CL_PCP_DEI_MAP_CFG_PCP_DEI_QOS_VAL_SET(x)\
	FIELD_PREP(ANA_CL_PCP_DEI_MAP_CFG_PCP_DEI_QOS_VAL, x)
#define ANA_CL_PCP_DEI_MAP_CFG_PCP_DEI_QOS_VAL_GET(x)\
	FIELD_GET(ANA_CL_PCP_DEI_MAP_CFG_PCP_DEI_QOS_VAL, x)

/*      ANA_CL:PORT:QOS_CFG */
#define ANA_CL_QOS_CFG(g)         __REG(TARGET_ANA_CL,\
					0, 1, 131072, g, 70, 512, 172, 0, 1, 4)

#define ANA_CL_QOS_CFG_DEFAULT_COSID_ENA         BIT(17)
#define ANA_CL_QOS_CFG_DEFAULT_COSID_ENA_SET(x)\
	FIELD_PREP(ANA_CL_QOS_CFG_DEFAULT_COSID_ENA, x)
#define ANA_CL_QOS_CFG_DEFAULT_COSID_ENA_GET(x)\
	FIELD_GET(ANA_CL_QOS_CFG_DEFAULT_COSID_ENA, x)

#define ANA_CL_QOS_CFG_DEFAULT_COSID_VAL         GENMASK(16, 14)
#define ANA_CL_QOS_CFG_DEFAULT_COSID_VAL_SET(x)\
	FIELD_PREP(ANA_CL_QOS_CFG_DEFAULT_COSID_VAL, x)
#define ANA_CL_QOS_CFG_DEFAULT_COSID_VAL_GET(x)\
	FIELD_GET(ANA_CL_QOS_CFG_DEFAULT_COSID_VAL, x)

#define ANA_CL_QOS_CFG_DSCP_REWR_MODE_SEL        GENMASK(13, 12)
#define ANA_CL_QOS_CFG_DSCP_REWR_MODE_SEL_SET(x)\
	FIELD_PREP(ANA_CL_QOS_CFG_DSCP_REWR_MODE_SEL, x)
#define ANA_CL_QOS_CFG_DSCP_REWR_MODE_SEL_GET(x)\
	FIELD_GET(ANA_CL_QOS_CFG_DSCP_REWR_MODE_SEL, x)

#define ANA_CL_QOS_CFG_DSCP_TRANSLATE_ENA        BIT(11)
#define ANA_CL_QOS_CFG_DSCP_TRANSLATE_ENA_SET(x)\
	FIELD_PREP(ANA_CL_QOS_CFG_DSCP_TRANSLATE_ENA, x)
#define ANA_CL_QOS_CFG_DSCP_TRANSLATE_ENA_GET(x)\
	FIELD_GET(ANA_CL_QOS_CFG_DSCP_TRANSLATE_ENA, x)

#define ANA_CL_QOS_CFG_DSCP_KEEP_ENA             BIT(10)
#define ANA_CL_QOS_CFG_DSCP_KEEP_ENA_SET(x)\
	FIELD_PREP(ANA_CL_QOS_CFG_DSCP_KEEP_ENA, x)
#define ANA_CL_QOS_CFG_DSCP_KEEP_ENA_GET(x)\
	FIELD_GET(ANA_CL_QOS_CFG_DSCP_KEEP_ENA, x)

#define ANA_CL_QOS_CFG_KEEP_ENA                  BIT(9)
#define ANA_CL_QOS_CFG_KEEP_ENA_SET(x)\
	FIELD_PREP(ANA_CL_QOS_CFG_KEEP_ENA, x)
#define ANA_CL_QOS_CFG_KEEP_ENA_GET(x)\
	FIELD_GET(ANA_CL_QOS_CFG_KEEP_ENA, x)

#define ANA_CL_QOS_CFG_PCP_DEI_DP_ENA            BIT(8)
#define ANA_CL_QOS_CFG_PCP_DEI_DP_ENA_SET(x)\
	FIELD_PREP(ANA_CL_QOS_CFG_PCP_DEI_DP_ENA, x)
#define ANA_CL_QOS_CFG_PCP_DEI_DP_ENA_GET(x)\
	FIELD_GET(ANA_CL_QOS_CFG_PCP_DEI_DP_ENA, x)

#define ANA_CL_QOS_CFG_PCP_DEI_QOS_ENA           BIT(7)
#define ANA_CL_QOS_CFG_PCP_DEI_QOS_ENA_SET(x)\
	FIELD_PREP(ANA_CL_QOS_CFG_PCP_DEI_QOS_ENA, x)
#define ANA_CL_QOS_CFG_PCP_DEI_QOS_ENA_GET(x)\
	FIELD_GET(ANA_CL_QOS_CFG_PCP_DEI_QOS_ENA, x)

#define ANA_CL_QOS_CFG_DSCP_DP_ENA               BIT(6)
#define ANA_CL_QOS_CFG_DSCP_DP_ENA_SET(x)\
	FIELD_PREP(ANA_CL_QOS_CFG_DSCP_DP_ENA, x)
#define ANA_CL_QOS_CFG_DSCP_DP_ENA_GET(x)\
	FIELD_GET(ANA_CL_QOS_CFG_DSCP_DP_ENA, x)

#define ANA_CL_QOS_CFG_DSCP_QOS_ENA              BIT(5)
#define ANA_CL_QOS_CFG_DSCP_QOS_ENA_SET(x)\
	FIELD_PREP(ANA_CL_QOS_CFG_DSCP_QOS_ENA, x)
#define ANA_CL_QOS_CFG_DSCP_QOS_ENA_GET(x)\
	FIELD_GET(ANA_CL_QOS_CFG_DSCP_QOS_ENA, x)

#define ANA_CL_QOS_CFG_DEFAULT_DP_VAL            GENMASK(4, 3)
#define ANA_CL_QOS_CFG_DEFAULT_DP_VAL_SET(x)\
	FIELD_PREP(ANA_CL_QOS_CFG_DEFAULT_DP_VAL, x)
#define ANA_CL_QOS_CFG_DEFAULT_DP_VAL_GET(x)\
	FIELD_GET(ANA_CL_QOS_CFG_DEFAULT_DP_VAL, x)

#define ANA_CL_QOS_CFG_DEFAULT_QOS_VAL           GENMASK(2, 0)
#define ANA_CL_QOS_CFG_DEFAULT_QOS_VAL_SET(x)\
	FIELD_PREP(ANA_CL_QOS_CFG_DEFAULT_QOS_VAL, x)
#define ANA_CL_QOS_CFG_DEFAULT_QOS_VAL_GET(x)\
	FIELD_GET(ANA_CL_QOS_CFG_DEFAULT_QOS_VAL, x)

/*      ANA_CL:PORT:CAPTURE_BPDU_CFG */
#define ANA_CL_CAPTURE_BPDU_CFG(g) __REG(TARGET_ANA_CL,\
					0, 1, 131072, g, 70, 512, 196, 0, 1, 4)

/*      ANA_CL:PORT:ADV_CL_CFG_2 */
#define ANA_CL_ADV_CL_CFG_2(g, r) __REG(TARGET_ANA_CL,\
					0, 1, 131072, g, 70, 512, 200, r, 6, 4)

#define ANA_CL_ADV_CL_CFG_2_USE_CL_TCI0_ENA      BIT(1)
#define ANA_CL_ADV_CL_CFG_2_USE_CL_TCI0_ENA_SET(x)\
	FIELD_PREP(ANA_CL_ADV_CL_CFG_2_USE_CL_TCI0_ENA, x)
#define ANA_CL_ADV_CL_CFG_2_USE_CL_TCI0_ENA_GET(x)\
	FIELD_GET(ANA_CL_ADV_CL_CFG_2_USE_CL_TCI0_ENA, x)

#define ANA_CL_ADV_CL_CFG_2_USE_CL_DSCP_ENA      BIT(0)
#define ANA_CL_ADV_CL_CFG_2_USE_CL_DSCP_ENA_SET(x)\
	FIELD_PREP(ANA_CL_ADV_CL_CFG_2_USE_CL_DSCP_ENA, x)
#define ANA_CL_ADV_CL_CFG_2_USE_CL_DSCP_ENA_GET(x)\
	FIELD_GET(ANA_CL_ADV_CL_CFG_2_USE_CL_DSCP_ENA, x)

/*      ANA_CL:PORT:ADV_CL_CFG */
#define ANA_CL_ADV_CL_CFG(g, r)   __REG(TARGET_ANA_CL,\
					0, 1, 131072, g, 70, 512, 224, r, 6, 4)

#define ANA_CL_ADV_CL_CFG_IP4_CLM_KEY_SEL        GENMASK(30, 26)
#define ANA_CL_ADV_CL_CFG_IP4_CLM_KEY_SEL_SET(x)\
	FIELD_PREP(ANA_CL_ADV_CL_CFG_IP4_CLM_KEY_SEL, x)
#define ANA_CL_ADV_CL_CFG_IP4_CLM_KEY_SEL_GET(x)\
	FIELD_GET(ANA_CL_ADV_CL_CFG_IP4_CLM_KEY_SEL, x)

#define ANA_CL_ADV_CL_CFG_IP6_CLM_KEY_SEL        GENMASK(25, 21)
#define ANA_CL_ADV_CL_CFG_IP6_CLM_KEY_SEL_SET(x)\
	FIELD_PREP(ANA_CL_ADV_CL_CFG_IP6_CLM_KEY_SEL, x)
#define ANA_CL_ADV_CL_CFG_IP6_CLM_KEY_SEL_GET(x)\
	FIELD_GET(ANA_CL_ADV_CL_CFG_IP6_CLM_KEY_SEL, x)

#define ANA_CL_ADV_CL_CFG_MPLS_UC_CLM_KEY_SEL    GENMASK(20, 16)
#define ANA_CL_ADV_CL_CFG_MPLS_UC_CLM_KEY_SEL_SET(x)\
	FIELD_PREP(ANA_CL_ADV_CL_CFG_MPLS_UC_CLM_KEY_SEL, x)
#define ANA_CL_ADV_CL_CFG_MPLS_UC_CLM_KEY_SEL_GET(x)\
	FIELD_GET(ANA_CL_ADV_CL_CFG_MPLS_UC_CLM_KEY_SEL, x)

#define ANA_CL_ADV_CL_CFG_MPLS_MC_CLM_KEY_SEL    GENMASK(15, 11)
#define ANA_CL_ADV_CL_CFG_MPLS_MC_CLM_KEY_SEL_SET(x)\
	FIELD_PREP(ANA_CL_ADV_CL_CFG_MPLS_MC_CLM_KEY_SEL, x)
#define ANA_CL_ADV_CL_CFG_MPLS_MC_CLM_KEY_SEL_GET(x)\
	FIELD_GET(ANA_CL_ADV_CL_CFG_MPLS_MC_CLM_KEY_SEL, x)

#define ANA_CL_ADV_CL_CFG_MLBS_CLM_KEY_SEL       GENMASK(10, 6)
#define ANA_CL_ADV_CL_CFG_MLBS_CLM_KEY_SEL_SET(x)\
	FIELD_PREP(ANA_CL_ADV_CL_CFG_MLBS_CLM_KEY_SEL, x)
#define ANA_CL_ADV_CL_CFG_MLBS_CLM_KEY_SEL_GET(x)\
	FIELD_GET(ANA_CL_ADV_CL_CFG_MLBS_CLM_KEY_SEL, x)

#define ANA_CL_ADV_CL_CFG_ETYPE_CLM_KEY_SEL      GENMASK(5, 1)
#define ANA_CL_ADV_CL_CFG_ETYPE_CLM_KEY_SEL_SET(x)\
	FIELD_PREP(ANA_CL_ADV_CL_CFG_ETYPE_CLM_KEY_SEL, x)
#define ANA_CL_ADV_CL_CFG_ETYPE_CLM_KEY_SEL_GET(x)\
	FIELD_GET(ANA_CL_ADV_CL_CFG_ETYPE_CLM_KEY_SEL, x)

#define ANA_CL_ADV_CL_CFG_LOOKUP_ENA             BIT(0)
#define ANA_CL_ADV_CL_CFG_LOOKUP_ENA_SET(x)\
	FIELD_PREP(ANA_CL_ADV_CL_CFG_LOOKUP_ENA, x)
#define ANA_CL_ADV_CL_CFG_LOOKUP_ENA_GET(x)\
	FIELD_GET(ANA_CL_ADV_CL_CFG_LOOKUP_ENA, x)

/*      ANA_CL:COMMON:OWN_UPSID */
#define ANA_CL_OWN_UPSID(r)       __REG(TARGET_ANA_CL,\
					0, 1, 166912, 0, 1, 756, 0, r, 3, 4)

#define ANA_CL_OWN_UPSID_OWN_UPSID               GENMASK(4, 0)
#define ANA_CL_OWN_UPSID_OWN_UPSID_SET(x)\
	FIELD_PREP(ANA_CL_OWN_UPSID_OWN_UPSID, x)
#define ANA_CL_OWN_UPSID_OWN_UPSID_GET(x)\
	FIELD_GET(ANA_CL_OWN_UPSID_OWN_UPSID, x)

/*      ANA_CL:COMMON:DSCP_CFG */
#define ANA_CL_DSCP_CFG(r)        __REG(TARGET_ANA_CL,\
					0, 1, 166912, 0, 1, 756, 256, r, 64, 4)

#define ANA_CL_DSCP_CFG_DSCP_TRANSLATE_VAL       GENMASK(12, 7)
#define ANA_CL_DSCP_CFG_DSCP_TRANSLATE_VAL_SET(x)\
	FIELD_PREP(ANA_CL_DSCP_CFG_DSCP_TRANSLATE_VAL, x)
#define ANA_CL_DSCP_CFG_DSCP_TRANSLATE_VAL_GET(x)\
	FIELD_GET(ANA_CL_DSCP_CFG_DSCP_TRANSLATE_VAL, x)

#define ANA_CL_DSCP_CFG_DSCP_QOS_VAL             GENMASK(6, 4)
#define ANA_CL_DSCP_CFG_DSCP_QOS_VAL_SET(x)\
	FIELD_PREP(ANA_CL_DSCP_CFG_DSCP_QOS_VAL, x)
#define ANA_CL_DSCP_CFG_DSCP_QOS_VAL_GET(x)\
	FIELD_GET(ANA_CL_DSCP_CFG_DSCP_QOS_VAL, x)

#define ANA_CL_DSCP_CFG_DSCP_DP_VAL              GENMASK(3, 2)
#define ANA_CL_DSCP_CFG_DSCP_DP_VAL_SET(x)\
	FIELD_PREP(ANA_CL_DSCP_CFG_DSCP_DP_VAL, x)
#define ANA_CL_DSCP_CFG_DSCP_DP_VAL_GET(x)\
	FIELD_GET(ANA_CL_DSCP_CFG_DSCP_DP_VAL, x)

#define ANA_CL_DSCP_CFG_DSCP_REWR_ENA            BIT(1)
#define ANA_CL_DSCP_CFG_DSCP_REWR_ENA_SET(x)\
	FIELD_PREP(ANA_CL_DSCP_CFG_DSCP_REWR_ENA, x)
#define ANA_CL_DSCP_CFG_DSCP_REWR_ENA_GET(x)\
	FIELD_GET(ANA_CL_DSCP_CFG_DSCP_REWR_ENA, x)

#define ANA_CL_DSCP_CFG_DSCP_TRUST_ENA           BIT(0)
#define ANA_CL_DSCP_CFG_DSCP_TRUST_ENA_SET(x)\
	FIELD_PREP(ANA_CL_DSCP_CFG_DSCP_TRUST_ENA, x)
#define ANA_CL_DSCP_CFG_DSCP_TRUST_ENA_GET(x)\
	FIELD_GET(ANA_CL_DSCP_CFG_DSCP_TRUST_ENA, x)

/*      ANA_CL:COMMON:QOS_MAP_CFG */
#define ANA_CL_QOS_MAP_CFG(r)     __REG(TARGET_ANA_CL,\
					0, 1, 166912, 0, 1, 756, 512, r, 32, 4)

#define ANA_CL_QOS_MAP_CFG_DSCP_REWR_VAL         GENMASK(9, 4)
#define ANA_CL_QOS_MAP_CFG_DSCP_REWR_VAL_SET(x)\
	FIELD_PREP(ANA_CL_QOS_MAP_CFG_DSCP_REWR_VAL, x)
#define ANA_CL_QOS_MAP_CFG_DSCP_REWR_VAL_GET(x)\
	FIELD_GET(ANA_CL_QOS_MAP_CFG_DSCP_REWR_VAL, x)

/*      ANA_L2:COMMON:FWD_CFG */
#define ANA_L2_FWD_CFG            __REG(TARGET_ANA_L2,\
					0, 1, 566024, 0, 1, 700, 0, 0, 1, 4)

#define ANA_L2_FWD_CFG_MAC_TBL_SPLIT_SEL         GENMASK(21, 20)
#define ANA_L2_FWD_CFG_MAC_TBL_SPLIT_SEL_SET(x)\
	FIELD_PREP(ANA_L2_FWD_CFG_MAC_TBL_SPLIT_SEL, x)
#define ANA_L2_FWD_CFG_MAC_TBL_SPLIT_SEL_GET(x)\
	FIELD_GET(ANA_L2_FWD_CFG_MAC_TBL_SPLIT_SEL, x)

#define ANA_L2_FWD_CFG_PORT_DEFAULT_BDLB_ENA     BIT(18)
#define ANA_L2_FWD_CFG_PORT_DEFAULT_BDLB_ENA_SET(x)\
	FIELD_PREP(ANA_L2_FWD_CFG_PORT_DEFAULT_BDLB_ENA, x)
#define ANA_L2_FWD_CFG_PORT_DEFAULT_BDLB_ENA_GET(x)\
	FIELD_GET(ANA_L2_FWD_CFG_PORT_DEFAULT_BDLB_ENA, x)

#define ANA_L2_FWD_CFG_QUEUE_DEFAULT_SDLB_ENA    BIT(17)
#define ANA_L2_FWD_CFG_QUEUE_DEFAULT_SDLB_ENA_SET(x)\
	FIELD_PREP(ANA_L2_FWD_CFG_QUEUE_DEFAULT_SDLB_ENA, x)
#define ANA_L2_FWD_CFG_QUEUE_DEFAULT_SDLB_ENA_GET(x)\
	FIELD_GET(ANA_L2_FWD_CFG_QUEUE_DEFAULT_SDLB_ENA, x)

#define ANA_L2_FWD_CFG_ISDX_LOOKUP_ENA           BIT(16)
#define ANA_L2_FWD_CFG_ISDX_LOOKUP_ENA_SET(x)\
	FIELD_PREP(ANA_L2_FWD_CFG_ISDX_LOOKUP_ENA, x)
#define ANA_L2_FWD_CFG_ISDX_LOOKUP_ENA_GET(x)\
	FIELD_GET(ANA_L2_FWD_CFG_ISDX_LOOKUP_ENA, x)

#define ANA_L2_FWD_CFG_CPU_DMAC_QU               GENMASK(10, 8)
#define ANA_L2_FWD_CFG_CPU_DMAC_QU_SET(x)\
	FIELD_PREP(ANA_L2_FWD_CFG_CPU_DMAC_QU, x)
#define ANA_L2_FWD_CFG_CPU_DMAC_QU_GET(x)\
	FIELD_GET(ANA_L2_FWD_CFG_CPU_DMAC_QU, x)

#define ANA_L2_FWD_CFG_LOOPBACK_ENA              BIT(7)
#define ANA_L2_FWD_CFG_LOOPBACK_ENA_SET(x)\
	FIELD_PREP(ANA_L2_FWD_CFG_LOOPBACK_ENA, x)
#define ANA_L2_FWD_CFG_LOOPBACK_ENA_GET(x)\
	FIELD_GET(ANA_L2_FWD_CFG_LOOPBACK_ENA, x)

#define ANA_L2_FWD_CFG_CPU_DMAC_COPY_ENA         BIT(6)
#define ANA_L2_FWD_CFG_CPU_DMAC_COPY_ENA_SET(x)\
	FIELD_PREP(ANA_L2_FWD_CFG_CPU_DMAC_COPY_ENA, x)
#define ANA_L2_FWD_CFG_CPU_DMAC_COPY_ENA_GET(x)\
	FIELD_GET(ANA_L2_FWD_CFG_CPU_DMAC_COPY_ENA, x)

#define ANA_L2_FWD_CFG_FILTER_MODE_SEL           BIT(4)
#define ANA_L2_FWD_CFG_FILTER_MODE_SEL_SET(x)\
	FIELD_PREP(ANA_L2_FWD_CFG_FILTER_MODE_SEL, x)
#define ANA_L2_FWD_CFG_FILTER_MODE_SEL_GET(x)\
	FIELD_GET(ANA_L2_FWD_CFG_FILTER_MODE_SEL, x)

#define ANA_L2_FWD_CFG_FLOOD_MIRROR_ENA          BIT(3)
#define ANA_L2_FWD_CFG_FLOOD_MIRROR_ENA_SET(x)\
	FIELD_PREP(ANA_L2_FWD_CFG_FLOOD_MIRROR_ENA, x)
#define ANA_L2_FWD_CFG_FLOOD_MIRROR_ENA_GET(x)\
	FIELD_GET(ANA_L2_FWD_CFG_FLOOD_MIRROR_ENA, x)

#define ANA_L2_FWD_CFG_FLOOD_IGNORE_VLAN_ENA     BIT(2)
#define ANA_L2_FWD_CFG_FLOOD_IGNORE_VLAN_ENA_SET(x)\
	FIELD_PREP(ANA_L2_FWD_CFG_FLOOD_IGNORE_VLAN_ENA, x)
#define ANA_L2_FWD_CFG_FLOOD_IGNORE_VLAN_ENA_GET(x)\
	FIELD_GET(ANA_L2_FWD_CFG_FLOOD_IGNORE_VLAN_ENA, x)

#define ANA_L2_FWD_CFG_FLOOD_CPU_COPY_ENA        BIT(1)
#define ANA_L2_FWD_CFG_FLOOD_CPU_COPY_ENA_SET(x)\
	FIELD_PREP(ANA_L2_FWD_CFG_FLOOD_CPU_COPY_ENA, x)
#define ANA_L2_FWD_CFG_FLOOD_CPU_COPY_ENA_GET(x)\
	FIELD_GET(ANA_L2_FWD_CFG_FLOOD_CPU_COPY_ENA, x)

#define ANA_L2_FWD_CFG_FWD_ENA                   BIT(0)
#define ANA_L2_FWD_CFG_FWD_ENA_SET(x)\
	FIELD_PREP(ANA_L2_FWD_CFG_FWD_ENA, x)
#define ANA_L2_FWD_CFG_FWD_ENA_GET(x)\
	FIELD_GET(ANA_L2_FWD_CFG_FWD_ENA, x)

/*      ANA_L2:COMMON:AUTO_LRN_CFG */
#define ANA_L2_AUTO_LRN_CFG       __REG(TARGET_ANA_L2,\
					0, 1, 566024, 0, 1, 700, 24, 0, 1, 4)

/*      ANA_L2:COMMON:AUTO_LRN_CFG1 */
#define ANA_L2_AUTO_LRN_CFG1      __REG(TARGET_ANA_L2,\
					0, 1, 566024, 0, 1, 700, 28, 0, 1, 4)

/*      ANA_L2:COMMON:AUTO_LRN_CFG2 */
#define ANA_L2_AUTO_LRN_CFG2      __REG(TARGET_ANA_L2,\
					0, 1, 566024, 0, 1, 700, 32, 0, 1, 4)

#define ANA_L2_AUTO_LRN_CFG2_AUTO_LRN_ENA2       BIT(0)
#define ANA_L2_AUTO_LRN_CFG2_AUTO_LRN_ENA2_SET(x)\
	FIELD_PREP(ANA_L2_AUTO_LRN_CFG2_AUTO_LRN_ENA2, x)
#define ANA_L2_AUTO_LRN_CFG2_AUTO_LRN_ENA2_GET(x)\
	FIELD_GET(ANA_L2_AUTO_LRN_CFG2_AUTO_LRN_ENA2, x)

/*      ANA_L2:COMMON:OWN_UPSID */
#define ANA_L2_OWN_UPSID(r)       __REG(TARGET_ANA_L2,\
					0, 1, 566024, 0, 1, 700, 672, r, 3, 4)

#define ANA_L2_OWN_UPSID_OWN_UPSID               GENMASK(4, 0)
#define ANA_L2_OWN_UPSID_OWN_UPSID_SET(x)\
	FIELD_PREP(ANA_L2_OWN_UPSID_OWN_UPSID, x)
#define ANA_L2_OWN_UPSID_OWN_UPSID_GET(x)\
	FIELD_GET(ANA_L2_OWN_UPSID_OWN_UPSID, x)

/*      ANA_L2:ISDX:DLB_CFG */
#define ANA_L2_DLB_CFG(g)         __REG(TARGET_ANA_L2,\
					0, 1, 0, g, 4096, 128, 56, 0, 1, 4)

#define ANA_L2_DLB_CFG_DLB_IDX                   GENMASK(12, 0)
#define ANA_L2_DLB_CFG_DLB_IDX_SET(x)\
	FIELD_PREP(ANA_L2_DLB_CFG_DLB_IDX, x)
#define ANA_L2_DLB_CFG_DLB_IDX_GET(x)\
	FIELD_GET(ANA_L2_DLB_CFG_DLB_IDX, x)

/*      ANA_L2:ISDX:TSN_CFG */
#define ANA_L2_TSN_CFG(g)         __REG(TARGET_ANA_L2,\
					0, 1, 0, g, 4096, 128, 100, 0, 1, 4)

#define ANA_L2_TSN_CFG_TSN_SFID                  GENMASK(9, 0)
#define ANA_L2_TSN_CFG_TSN_SFID_SET(x)\
	FIELD_PREP(ANA_L2_TSN_CFG_TSN_SFID, x)
#define ANA_L2_TSN_CFG_TSN_SFID_GET(x)\
	FIELD_GET(ANA_L2_TSN_CFG_TSN_SFID, x)

/*      ANA_L3:COMMON:VLAN_CTRL */
#define ANA_L3_VLAN_CTRL          __REG(TARGET_ANA_L3,\
					0, 1, 493632, 0, 1, 184, 4, 0, 1, 4)

#define ANA_L3_VLAN_CTRL_VLAN_ENA                BIT(0)
#define ANA_L3_VLAN_CTRL_VLAN_ENA_SET(x)\
	FIELD_PREP(ANA_L3_VLAN_CTRL_VLAN_ENA, x)
#define ANA_L3_VLAN_CTRL_VLAN_ENA_GET(x)\
	FIELD_GET(ANA_L3_VLAN_CTRL_VLAN_ENA, x)

/*      ANA_L3:VLAN:VLAN_CFG */
#define ANA_L3_VLAN_CFG(g)        __REG(TARGET_ANA_L3,\
					0, 1, 0, g, 5120, 64, 8, 0, 1, 4)

#define ANA_L3_VLAN_CFG_VLAN_MSTP_PTR            GENMASK(30, 24)
#define ANA_L3_VLAN_CFG_VLAN_MSTP_PTR_SET(x)\
	FIELD_PREP(ANA_L3_VLAN_CFG_VLAN_MSTP_PTR, x)
#define ANA_L3_VLAN_CFG_VLAN_MSTP_PTR_GET(x)\
	FIELD_GET(ANA_L3_VLAN_CFG_VLAN_MSTP_PTR, x)

#define ANA_L3_VLAN_CFG_VLAN_FID                 GENMASK(20, 8)
#define ANA_L3_VLAN_CFG_VLAN_FID_SET(x)\
	FIELD_PREP(ANA_L3_VLAN_CFG_VLAN_FID, x)
#define ANA_L3_VLAN_CFG_VLAN_FID_GET(x)\
	FIELD_GET(ANA_L3_VLAN_CFG_VLAN_FID, x)

#define ANA_L3_VLAN_CFG_VLAN_IGR_FILTER_ENA      BIT(6)
#define ANA_L3_VLAN_CFG_VLAN_IGR_FILTER_ENA_SET(x)\
	FIELD_PREP(ANA_L3_VLAN_CFG_VLAN_IGR_FILTER_ENA, x)
#define ANA_L3_VLAN_CFG_VLAN_IGR_FILTER_ENA_GET(x)\
	FIELD_GET(ANA_L3_VLAN_CFG_VLAN_IGR_FILTER_ENA, x)

#define ANA_L3_VLAN_CFG_VLAN_SEC_FWD_ENA         BIT(5)
#define ANA_L3_VLAN_CFG_VLAN_SEC_FWD_ENA_SET(x)\
	FIELD_PREP(ANA_L3_VLAN_CFG_VLAN_SEC_FWD_ENA, x)
#define ANA_L3_VLAN_CFG_VLAN_SEC_FWD_ENA_GET(x)\
	FIELD_GET(ANA_L3_VLAN_CFG_VLAN_SEC_FWD_ENA, x)

#define ANA_L3_VLAN_CFG_VLAN_FLOOD_DIS           BIT(4)
#define ANA_L3_VLAN_CFG_VLAN_FLOOD_DIS_SET(x)\
	FIELD_PREP(ANA_L3_VLAN_CFG_VLAN_FLOOD_DIS, x)
#define ANA_L3_VLAN_CFG_VLAN_FLOOD_DIS_GET(x)\
	FIELD_GET(ANA_L3_VLAN_CFG_VLAN_FLOOD_DIS, x)

#define ANA_L3_VLAN_CFG_VLAN_LRN_DIS             BIT(3)
#define ANA_L3_VLAN_CFG_VLAN_LRN_DIS_SET(x)\
	FIELD_PREP(ANA_L3_VLAN_CFG_VLAN_LRN_DIS, x)
#define ANA_L3_VLAN_CFG_VLAN_LRN_DIS_GET(x)\
	FIELD_GET(ANA_L3_VLAN_CFG_VLAN_LRN_DIS, x)

#define ANA_L3_VLAN_CFG_VLAN_RLEG_ENA            BIT(2)
#define ANA_L3_VLAN_CFG_VLAN_RLEG_ENA_SET(x)\
	FIELD_PREP(ANA_L3_VLAN_CFG_VLAN_RLEG_ENA, x)
#define ANA_L3_VLAN_CFG_VLAN_RLEG_ENA_GET(x)\
	FIELD_GET(ANA_L3_VLAN_CFG_VLAN_RLEG_ENA, x)

#define ANA_L3_VLAN_CFG_VLAN_PRIVATE_ENA         BIT(1)
#define ANA_L3_VLAN_CFG_VLAN_PRIVATE_ENA_SET(x)\
	FIELD_PREP(ANA_L3_VLAN_CFG_VLAN_PRIVATE_ENA, x)
#define ANA_L3_VLAN_CFG_VLAN_PRIVATE_ENA_GET(x)\
	FIELD_GET(ANA_L3_VLAN_CFG_VLAN_PRIVATE_ENA, x)

#define ANA_L3_VLAN_CFG_VLAN_MIRROR_ENA          BIT(0)
#define ANA_L3_VLAN_CFG_VLAN_MIRROR_ENA_SET(x)\
	FIELD_PREP(ANA_L3_VLAN_CFG_VLAN_MIRROR_ENA, x)
#define ANA_L3_VLAN_CFG_VLAN_MIRROR_ENA_GET(x)\
	FIELD_GET(ANA_L3_VLAN_CFG_VLAN_MIRROR_ENA, x)

/*      ANA_L3:VLAN:VLAN_MASK_CFG */
#define ANA_L3_VLAN_MASK_CFG(g)   __REG(TARGET_ANA_L3,\
					0, 1, 0, g, 5120, 64, 16, 0, 1, 4)

/*      ANA_L3:VLAN:VLAN_MASK_CFG1 */
#define ANA_L3_VLAN_MASK_CFG1(g)  __REG(TARGET_ANA_L3,\
					0, 1, 0, g, 5120, 64, 20, 0, 1, 4)

/*      ANA_L3:VLAN:VLAN_MASK_CFG2 */
#define ANA_L3_VLAN_MASK_CFG2(g)  __REG(TARGET_ANA_L3,\
					0, 1, 0, g, 5120, 64, 24, 0, 1, 4)

#define ANA_L3_VLAN_MASK_CFG2_VLAN_PORT_MASK2    BIT(0)
#define ANA_L3_VLAN_MASK_CFG2_VLAN_PORT_MASK2_SET(x)\
	FIELD_PREP(ANA_L3_VLAN_MASK_CFG2_VLAN_PORT_MASK2, x)
#define ANA_L3_VLAN_MASK_CFG2_VLAN_PORT_MASK2_GET(x)\
	FIELD_GET(ANA_L3_VLAN_MASK_CFG2_VLAN_PORT_MASK2, x)

/*      ASM:DEV_STATISTICS:RX_IN_BYTES_CNT */
#define ASM_RX_IN_BYTES_CNT(g)    __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 0, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_SYMBOL_ERR_CNT */
#define ASM_RX_SYMBOL_ERR_CNT(g)  __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 4, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_PAUSE_CNT */
#define ASM_RX_PAUSE_CNT(g)       __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 8, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_UNSUP_OPCODE_CNT */
#define ASM_RX_UNSUP_OPCODE_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 12, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_OK_BYTES_CNT */
#define ASM_RX_OK_BYTES_CNT(g)    __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 16, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_BAD_BYTES_CNT */
#define ASM_RX_BAD_BYTES_CNT(g)   __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 20, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_UC_CNT */
#define ASM_RX_UC_CNT(g)          __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 24, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_MC_CNT */
#define ASM_RX_MC_CNT(g)          __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 28, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_BC_CNT */
#define ASM_RX_BC_CNT(g)          __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 32, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_CRC_ERR_CNT */
#define ASM_RX_CRC_ERR_CNT(g)     __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 36, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_UNDERSIZE_CNT */
#define ASM_RX_UNDERSIZE_CNT(g)   __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 40, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_FRAGMENTS_CNT */
#define ASM_RX_FRAGMENTS_CNT(g)   __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 44, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_IN_RANGE_LEN_ERR_CNT */
#define ASM_RX_IN_RANGE_LEN_ERR_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 48, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_OUT_OF_RANGE_LEN_ERR_CNT */
#define ASM_RX_OUT_OF_RANGE_LEN_ERR_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 52, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_OVERSIZE_CNT */
#define ASM_RX_OVERSIZE_CNT(g)    __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 56, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_JABBERS_CNT */
#define ASM_RX_JABBERS_CNT(g)     __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 60, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_SIZE64_CNT */
#define ASM_RX_SIZE64_CNT(g)      __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 64, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_SIZE65TO127_CNT */
#define ASM_RX_SIZE65TO127_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 68, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_SIZE128TO255_CNT */
#define ASM_RX_SIZE128TO255_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 72, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_SIZE256TO511_CNT */
#define ASM_RX_SIZE256TO511_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 76, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_SIZE512TO1023_CNT */
#define ASM_RX_SIZE512TO1023_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 80, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_SIZE1024TO1518_CNT */
#define ASM_RX_SIZE1024TO1518_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 84, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_SIZE1519TOMAX_CNT */
#define ASM_RX_SIZE1519TOMAX_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 88, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_IPG_SHRINK_CNT */
#define ASM_RX_IPG_SHRINK_CNT(g)  __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 92, 0, 1, 4)

/*      ASM:DEV_STATISTICS:TX_OUT_BYTES_CNT */
#define ASM_TX_OUT_BYTES_CNT(g)   __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 96, 0, 1, 4)

/*      ASM:DEV_STATISTICS:TX_PAUSE_CNT */
#define ASM_TX_PAUSE_CNT(g)       __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 100, 0, 1, 4)

/*      ASM:DEV_STATISTICS:TX_OK_BYTES_CNT */
#define ASM_TX_OK_BYTES_CNT(g)    __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 104, 0, 1, 4)

/*      ASM:DEV_STATISTICS:TX_UC_CNT */
#define ASM_TX_UC_CNT(g)          __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 108, 0, 1, 4)

/*      ASM:DEV_STATISTICS:TX_MC_CNT */
#define ASM_TX_MC_CNT(g)          __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 112, 0, 1, 4)

/*      ASM:DEV_STATISTICS:TX_BC_CNT */
#define ASM_TX_BC_CNT(g)          __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 116, 0, 1, 4)

/*      ASM:DEV_STATISTICS:TX_SIZE64_CNT */
#define ASM_TX_SIZE64_CNT(g)      __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 120, 0, 1, 4)

/*      ASM:DEV_STATISTICS:TX_SIZE65TO127_CNT */
#define ASM_TX_SIZE65TO127_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 124, 0, 1, 4)

/*      ASM:DEV_STATISTICS:TX_SIZE128TO255_CNT */
#define ASM_TX_SIZE128TO255_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 128, 0, 1, 4)

/*      ASM:DEV_STATISTICS:TX_SIZE256TO511_CNT */
#define ASM_TX_SIZE256TO511_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 132, 0, 1, 4)

/*      ASM:DEV_STATISTICS:TX_SIZE512TO1023_CNT */
#define ASM_TX_SIZE512TO1023_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 136, 0, 1, 4)

/*      ASM:DEV_STATISTICS:TX_SIZE1024TO1518_CNT */
#define ASM_TX_SIZE1024TO1518_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 140, 0, 1, 4)

/*      ASM:DEV_STATISTICS:TX_SIZE1519TOMAX_CNT */
#define ASM_TX_SIZE1519TOMAX_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 144, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_ALIGNMENT_LOST_CNT */
#define ASM_RX_ALIGNMENT_LOST_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 148, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_TAGGED_FRMS_CNT */
#define ASM_RX_TAGGED_FRMS_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 152, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_UNTAGGED_FRMS_CNT */
#define ASM_RX_UNTAGGED_FRMS_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 156, 0, 1, 4)

/*      ASM:DEV_STATISTICS:TX_TAGGED_FRMS_CNT */
#define ASM_TX_TAGGED_FRMS_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 160, 0, 1, 4)

/*      ASM:DEV_STATISTICS:TX_UNTAGGED_FRMS_CNT */
#define ASM_TX_UNTAGGED_FRMS_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 164, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_SYMBOL_ERR_CNT */
#define ASM_PMAC_RX_SYMBOL_ERR_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 168, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_PAUSE_CNT */
#define ASM_PMAC_RX_PAUSE_CNT(g)  __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 172, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_UNSUP_OPCODE_CNT */
#define ASM_PMAC_RX_UNSUP_OPCODE_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 176, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_OK_BYTES_CNT */
#define ASM_PMAC_RX_OK_BYTES_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 180, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_BAD_BYTES_CNT */
#define ASM_PMAC_RX_BAD_BYTES_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 184, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_UC_CNT */
#define ASM_PMAC_RX_UC_CNT(g)     __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 188, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_MC_CNT */
#define ASM_PMAC_RX_MC_CNT(g)     __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 192, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_BC_CNT */
#define ASM_PMAC_RX_BC_CNT(g)     __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 196, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_CRC_ERR_CNT */
#define ASM_PMAC_RX_CRC_ERR_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 200, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_UNDERSIZE_CNT */
#define ASM_PMAC_RX_UNDERSIZE_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 204, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_FRAGMENTS_CNT */
#define ASM_PMAC_RX_FRAGMENTS_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 208, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_IN_RANGE_LEN_ERR_CNT */
#define ASM_PMAC_RX_IN_RANGE_LEN_ERR_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 212, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_OUT_OF_RANGE_LEN_ERR_CNT */
#define ASM_PMAC_RX_OUT_OF_RANGE_LEN_ERR_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 216, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_OVERSIZE_CNT */
#define ASM_PMAC_RX_OVERSIZE_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 220, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_JABBERS_CNT */
#define ASM_PMAC_RX_JABBERS_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 224, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_SIZE64_CNT */
#define ASM_PMAC_RX_SIZE64_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 228, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_SIZE65TO127_CNT */
#define ASM_PMAC_RX_SIZE65TO127_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 232, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_SIZE128TO255_CNT */
#define ASM_PMAC_RX_SIZE128TO255_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 236, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_SIZE256TO511_CNT */
#define ASM_PMAC_RX_SIZE256TO511_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 240, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_SIZE512TO1023_CNT */
#define ASM_PMAC_RX_SIZE512TO1023_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 244, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_SIZE1024TO1518_CNT */
#define ASM_PMAC_RX_SIZE1024TO1518_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 248, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_SIZE1519TOMAX_CNT */
#define ASM_PMAC_RX_SIZE1519TOMAX_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 252, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_TX_PAUSE_CNT */
#define ASM_PMAC_TX_PAUSE_CNT(g)  __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 256, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_TX_OK_BYTES_CNT */
#define ASM_PMAC_TX_OK_BYTES_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 260, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_TX_UC_CNT */
#define ASM_PMAC_TX_UC_CNT(g)     __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 264, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_TX_MC_CNT */
#define ASM_PMAC_TX_MC_CNT(g)     __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 268, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_TX_BC_CNT */
#define ASM_PMAC_TX_BC_CNT(g)     __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 272, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_TX_SIZE64_CNT */
#define ASM_PMAC_TX_SIZE64_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 276, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_TX_SIZE65TO127_CNT */
#define ASM_PMAC_TX_SIZE65TO127_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 280, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_TX_SIZE128TO255_CNT */
#define ASM_PMAC_TX_SIZE128TO255_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 284, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_TX_SIZE256TO511_CNT */
#define ASM_PMAC_TX_SIZE256TO511_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 288, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_TX_SIZE512TO1023_CNT */
#define ASM_PMAC_TX_SIZE512TO1023_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 292, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_TX_SIZE1024TO1518_CNT */
#define ASM_PMAC_TX_SIZE1024TO1518_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 296, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_TX_SIZE1519TOMAX_CNT */
#define ASM_PMAC_TX_SIZE1519TOMAX_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 300, 0, 1, 4)

/*      ASM:DEV_STATISTICS:PMAC_RX_ALIGNMENT_LOST_CNT */
#define ASM_PMAC_RX_ALIGNMENT_LOST_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 304, 0, 1, 4)

/*      ASM:DEV_STATISTICS:MM_RX_ASSEMBLY_ERR_CNT */
#define ASM_MM_RX_ASSEMBLY_ERR_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 308, 0, 1, 4)

/*      ASM:DEV_STATISTICS:MM_RX_SMD_ERR_CNT */
#define ASM_MM_RX_SMD_ERR_CNT(g)  __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 312, 0, 1, 4)

/*      ASM:DEV_STATISTICS:MM_RX_ASSEMBLY_OK_CNT */
#define ASM_MM_RX_ASSEMBLY_OK_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 316, 0, 1, 4)

/*      ASM:DEV_STATISTICS:MM_RX_MERGE_FRAG_CNT */
#define ASM_MM_RX_MERGE_FRAG_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 320, 0, 1, 4)

/*      ASM:DEV_STATISTICS:MM_TX_PFRAGMENT_CNT */
#define ASM_MM_TX_PFRAGMENT_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 324, 0, 1, 4)

/*      ASM:DEV_STATISTICS:TX_MULTI_COLL_CNT */
#define ASM_TX_MULTI_COLL_CNT(g)  __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 328, 0, 1, 4)

/*      ASM:DEV_STATISTICS:TX_LATE_COLL_CNT */
#define ASM_TX_LATE_COLL_CNT(g)   __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 332, 0, 1, 4)

/*      ASM:DEV_STATISTICS:TX_XCOLL_CNT */
#define ASM_TX_XCOLL_CNT(g)       __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 336, 0, 1, 4)

/*      ASM:DEV_STATISTICS:TX_DEFER_CNT */
#define ASM_TX_DEFER_CNT(g)       __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 340, 0, 1, 4)

/*      ASM:DEV_STATISTICS:TX_XDEFER_CNT */
#define ASM_TX_XDEFER_CNT(g)      __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 344, 0, 1, 4)

/*      ASM:DEV_STATISTICS:TX_BACKOFF1_CNT */
#define ASM_TX_BACKOFF1_CNT(g)    __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 348, 0, 1, 4)

/*      ASM:DEV_STATISTICS:TX_CSENSE_CNT */
#define ASM_TX_CSENSE_CNT(g)      __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 352, 0, 1, 4)

/*      ASM:DEV_STATISTICS:RX_IN_BYTES_MSB_CNT */
#define ASM_RX_IN_BYTES_MSB_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 356, 0, 1, 4)

#define ASM_RX_IN_BYTES_MSB_CNT_RX_IN_BYTES_MSB_CNT GENMASK(3, 0)
#define ASM_RX_IN_BYTES_MSB_CNT_RX_IN_BYTES_MSB_CNT_SET(x)\
	FIELD_PREP(ASM_RX_IN_BYTES_MSB_CNT_RX_IN_BYTES_MSB_CNT, x)
#define ASM_RX_IN_BYTES_MSB_CNT_RX_IN_BYTES_MSB_CNT_GET(x)\
	FIELD_GET(ASM_RX_IN_BYTES_MSB_CNT_RX_IN_BYTES_MSB_CNT, x)

/*      ASM:DEV_STATISTICS:RX_OK_BYTES_MSB_CNT */
#define ASM_RX_OK_BYTES_MSB_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 360, 0, 1, 4)

#define ASM_RX_OK_BYTES_MSB_CNT_RX_OK_BYTES_MSB_CNT GENMASK(3, 0)
#define ASM_RX_OK_BYTES_MSB_CNT_RX_OK_BYTES_MSB_CNT_SET(x)\
	FIELD_PREP(ASM_RX_OK_BYTES_MSB_CNT_RX_OK_BYTES_MSB_CNT, x)
#define ASM_RX_OK_BYTES_MSB_CNT_RX_OK_BYTES_MSB_CNT_GET(x)\
	FIELD_GET(ASM_RX_OK_BYTES_MSB_CNT_RX_OK_BYTES_MSB_CNT, x)

/*      ASM:DEV_STATISTICS:PMAC_RX_OK_BYTES_MSB_CNT */
#define ASM_PMAC_RX_OK_BYTES_MSB_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 364, 0, 1, 4)

#define ASM_PMAC_RX_OK_BYTES_MSB_CNT_PMAC_RX_OK_BYTES_MSB_CNT GENMASK(3, 0)
#define ASM_PMAC_RX_OK_BYTES_MSB_CNT_PMAC_RX_OK_BYTES_MSB_CNT_SET(x)\
	FIELD_PREP(ASM_PMAC_RX_OK_BYTES_MSB_CNT_PMAC_RX_OK_BYTES_MSB_CNT, x)
#define ASM_PMAC_RX_OK_BYTES_MSB_CNT_PMAC_RX_OK_BYTES_MSB_CNT_GET(x)\
	FIELD_GET(ASM_PMAC_RX_OK_BYTES_MSB_CNT_PMAC_RX_OK_BYTES_MSB_CNT, x)

/*      ASM:DEV_STATISTICS:RX_BAD_BYTES_MSB_CNT */
#define ASM_RX_BAD_BYTES_MSB_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 368, 0, 1, 4)

#define ASM_RX_BAD_BYTES_MSB_CNT_RX_BAD_BYTES_MSB_CNT GENMASK(3, 0)
#define ASM_RX_BAD_BYTES_MSB_CNT_RX_BAD_BYTES_MSB_CNT_SET(x)\
	FIELD_PREP(ASM_RX_BAD_BYTES_MSB_CNT_RX_BAD_BYTES_MSB_CNT, x)
#define ASM_RX_BAD_BYTES_MSB_CNT_RX_BAD_BYTES_MSB_CNT_GET(x)\
	FIELD_GET(ASM_RX_BAD_BYTES_MSB_CNT_RX_BAD_BYTES_MSB_CNT, x)

/*      ASM:DEV_STATISTICS:PMAC_RX_BAD_BYTES_MSB_CNT */
#define ASM_PMAC_RX_BAD_BYTES_MSB_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 372, 0, 1, 4)

#define ASM_PMAC_RX_BAD_BYTES_MSB_CNT_PMAC_RX_BAD_BYTES_MSB_CNT GENMASK(3, 0)
#define ASM_PMAC_RX_BAD_BYTES_MSB_CNT_PMAC_RX_BAD_BYTES_MSB_CNT_SET(x)\
	FIELD_PREP(ASM_PMAC_RX_BAD_BYTES_MSB_CNT_PMAC_RX_BAD_BYTES_MSB_CNT, x)
#define ASM_PMAC_RX_BAD_BYTES_MSB_CNT_PMAC_RX_BAD_BYTES_MSB_CNT_GET(x)\
	FIELD_GET(ASM_PMAC_RX_BAD_BYTES_MSB_CNT_PMAC_RX_BAD_BYTES_MSB_CNT, x)

/*      ASM:DEV_STATISTICS:TX_OUT_BYTES_MSB_CNT */
#define ASM_TX_OUT_BYTES_MSB_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 376, 0, 1, 4)

#define ASM_TX_OUT_BYTES_MSB_CNT_TX_OUT_BYTES_MSB_CNT GENMASK(3, 0)
#define ASM_TX_OUT_BYTES_MSB_CNT_TX_OUT_BYTES_MSB_CNT_SET(x)\
	FIELD_PREP(ASM_TX_OUT_BYTES_MSB_CNT_TX_OUT_BYTES_MSB_CNT, x)
#define ASM_TX_OUT_BYTES_MSB_CNT_TX_OUT_BYTES_MSB_CNT_GET(x)\
	FIELD_GET(ASM_TX_OUT_BYTES_MSB_CNT_TX_OUT_BYTES_MSB_CNT, x)

/*      ASM:DEV_STATISTICS:TX_OK_BYTES_MSB_CNT */
#define ASM_TX_OK_BYTES_MSB_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 380, 0, 1, 4)

#define ASM_TX_OK_BYTES_MSB_CNT_TX_OK_BYTES_MSB_CNT GENMASK(3, 0)
#define ASM_TX_OK_BYTES_MSB_CNT_TX_OK_BYTES_MSB_CNT_SET(x)\
	FIELD_PREP(ASM_TX_OK_BYTES_MSB_CNT_TX_OK_BYTES_MSB_CNT, x)
#define ASM_TX_OK_BYTES_MSB_CNT_TX_OK_BYTES_MSB_CNT_GET(x)\
	FIELD_GET(ASM_TX_OK_BYTES_MSB_CNT_TX_OK_BYTES_MSB_CNT, x)

/*      ASM:DEV_STATISTICS:PMAC_TX_OK_BYTES_MSB_CNT */
#define ASM_PMAC_TX_OK_BYTES_MSB_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 384, 0, 1, 4)

#define ASM_PMAC_TX_OK_BYTES_MSB_CNT_PMAC_TX_OK_BYTES_MSB_CNT GENMASK(3, 0)
#define ASM_PMAC_TX_OK_BYTES_MSB_CNT_PMAC_TX_OK_BYTES_MSB_CNT_SET(x)\
	FIELD_PREP(ASM_PMAC_TX_OK_BYTES_MSB_CNT_PMAC_TX_OK_BYTES_MSB_CNT, x)
#define ASM_PMAC_TX_OK_BYTES_MSB_CNT_PMAC_TX_OK_BYTES_MSB_CNT_GET(x)\
	FIELD_GET(ASM_PMAC_TX_OK_BYTES_MSB_CNT_PMAC_TX_OK_BYTES_MSB_CNT, x)

/*      ASM:DEV_STATISTICS:RX_SYNC_LOST_ERR_CNT */
#define ASM_RX_SYNC_LOST_ERR_CNT(g) __REG(TARGET_ASM,\
					0, 1, 0, g, 65, 512, 388, 0, 1, 4)

/*      ASM:CFG:STAT_CFG */
#define ASM_STAT_CFG              __REG(TARGET_ASM,\
					0, 1, 33280, 0, 1, 1088, 0, 0, 1, 4)

#define ASM_STAT_CFG_STAT_CNT_CLR_SHOT           BIT(0)
#define ASM_STAT_CFG_STAT_CNT_CLR_SHOT_SET(x)\
	FIELD_PREP(ASM_STAT_CFG_STAT_CNT_CLR_SHOT, x)
#define ASM_STAT_CFG_STAT_CNT_CLR_SHOT_GET(x)\
	FIELD_GET(ASM_STAT_CFG_STAT_CNT_CLR_SHOT, x)

/*      ASM:CFG:PORT_CFG */
#define ASM_PORT_CFG(r)           __REG(TARGET_ASM,\
					0, 1, 33280, 0, 1, 1088, 540, r, 67, 4)

#define ASM_PORT_CFG_CSC_STAT_DIS                BIT(12)
#define ASM_PORT_CFG_CSC_STAT_DIS_SET(x)\
	FIELD_PREP(ASM_PORT_CFG_CSC_STAT_DIS, x)
#define ASM_PORT_CFG_CSC_STAT_DIS_GET(x)\
	FIELD_GET(ASM_PORT_CFG_CSC_STAT_DIS, x)

#define ASM_PORT_CFG_HIH_AFTER_PREAMBLE_ENA      BIT(11)
#define ASM_PORT_CFG_HIH_AFTER_PREAMBLE_ENA_SET(x)\
	FIELD_PREP(ASM_PORT_CFG_HIH_AFTER_PREAMBLE_ENA, x)
#define ASM_PORT_CFG_HIH_AFTER_PREAMBLE_ENA_GET(x)\
	FIELD_GET(ASM_PORT_CFG_HIH_AFTER_PREAMBLE_ENA, x)

#define ASM_PORT_CFG_IGN_TAXI_ABORT_ENA          BIT(10)
#define ASM_PORT_CFG_IGN_TAXI_ABORT_ENA_SET(x)\
	FIELD_PREP(ASM_PORT_CFG_IGN_TAXI_ABORT_ENA, x)
#define ASM_PORT_CFG_IGN_TAXI_ABORT_ENA_GET(x)\
	FIELD_GET(ASM_PORT_CFG_IGN_TAXI_ABORT_ENA, x)

#define ASM_PORT_CFG_NO_PREAMBLE_ENA             BIT(9)
#define ASM_PORT_CFG_NO_PREAMBLE_ENA_SET(x)\
	FIELD_PREP(ASM_PORT_CFG_NO_PREAMBLE_ENA, x)
#define ASM_PORT_CFG_NO_PREAMBLE_ENA_GET(x)\
	FIELD_GET(ASM_PORT_CFG_NO_PREAMBLE_ENA, x)

#define ASM_PORT_CFG_SKIP_PREAMBLE_ENA           BIT(8)
#define ASM_PORT_CFG_SKIP_PREAMBLE_ENA_SET(x)\
	FIELD_PREP(ASM_PORT_CFG_SKIP_PREAMBLE_ENA, x)
#define ASM_PORT_CFG_SKIP_PREAMBLE_ENA_GET(x)\
	FIELD_GET(ASM_PORT_CFG_SKIP_PREAMBLE_ENA, x)

#define ASM_PORT_CFG_FRM_AGING_DIS               BIT(7)
#define ASM_PORT_CFG_FRM_AGING_DIS_SET(x)\
	FIELD_PREP(ASM_PORT_CFG_FRM_AGING_DIS, x)
#define ASM_PORT_CFG_FRM_AGING_DIS_GET(x)\
	FIELD_GET(ASM_PORT_CFG_FRM_AGING_DIS, x)

#define ASM_PORT_CFG_PAD_ENA                     BIT(6)
#define ASM_PORT_CFG_PAD_ENA_SET(x)\
	FIELD_PREP(ASM_PORT_CFG_PAD_ENA, x)
#define ASM_PORT_CFG_PAD_ENA_GET(x)\
	FIELD_GET(ASM_PORT_CFG_PAD_ENA, x)

#define ASM_PORT_CFG_INJ_DISCARD_CFG             GENMASK(5, 4)
#define ASM_PORT_CFG_INJ_DISCARD_CFG_SET(x)\
	FIELD_PREP(ASM_PORT_CFG_INJ_DISCARD_CFG, x)
#define ASM_PORT_CFG_INJ_DISCARD_CFG_GET(x)\
	FIELD_GET(ASM_PORT_CFG_INJ_DISCARD_CFG, x)

#define ASM_PORT_CFG_INJ_FORMAT_CFG              GENMASK(3, 2)
#define ASM_PORT_CFG_INJ_FORMAT_CFG_SET(x)\
	FIELD_PREP(ASM_PORT_CFG_INJ_FORMAT_CFG, x)
#define ASM_PORT_CFG_INJ_FORMAT_CFG_GET(x)\
	FIELD_GET(ASM_PORT_CFG_INJ_FORMAT_CFG, x)

#define ASM_PORT_CFG_VSTAX2_AWR_ENA              BIT(1)
#define ASM_PORT_CFG_VSTAX2_AWR_ENA_SET(x)\
	FIELD_PREP(ASM_PORT_CFG_VSTAX2_AWR_ENA, x)
#define ASM_PORT_CFG_VSTAX2_AWR_ENA_GET(x)\
	FIELD_GET(ASM_PORT_CFG_VSTAX2_AWR_ENA, x)

#define ASM_PORT_CFG_PFRM_FLUSH                  BIT(0)
#define ASM_PORT_CFG_PFRM_FLUSH_SET(x)\
	FIELD_PREP(ASM_PORT_CFG_PFRM_FLUSH, x)
#define ASM_PORT_CFG_PFRM_FLUSH_GET(x)\
	FIELD_GET(ASM_PORT_CFG_PFRM_FLUSH, x)

/*      ASM:RAM_CTRL:RAM_INIT */
#define ASM_RAM_INIT              __REG(TARGET_ASM,\
					0, 1, 34832, 0, 1, 4, 0, 0, 1, 4)

#define ASM_RAM_INIT_RAM_INIT                    BIT(1)
#define ASM_RAM_INIT_RAM_INIT_SET(x)\
	FIELD_PREP(ASM_RAM_INIT_RAM_INIT, x)
#define ASM_RAM_INIT_RAM_INIT_GET(x)\
	FIELD_GET(ASM_RAM_INIT_RAM_INIT, x)

#define ASM_RAM_INIT_RAM_CFG_HOOK                BIT(0)
#define ASM_RAM_INIT_RAM_CFG_HOOK_SET(x)\
	FIELD_PREP(ASM_RAM_INIT_RAM_CFG_HOOK, x)
#define ASM_RAM_INIT_RAM_CFG_HOOK_GET(x)\
	FIELD_GET(ASM_RAM_INIT_RAM_CFG_HOOK, x)

/*      CLKGEN:LCPLL1:LCPLL1_CORE_CLK_CFG */
#define CLKGEN_LCPLL1_CORE_CLK_CFG __REG(TARGET_CLKGEN,\
					0, 1, 12, 0, 1, 36, 0, 0, 1, 4)

#define CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_CLK_DIV  GENMASK(7, 0)
#define CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_CLK_DIV_SET(x)\
	FIELD_PREP(CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_CLK_DIV, x)
#define CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_CLK_DIV_GET(x)\
	FIELD_GET(CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_CLK_DIV, x)

#define CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_PRE_DIV  GENMASK(10, 8)
#define CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_PRE_DIV_SET(x)\
	FIELD_PREP(CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_PRE_DIV, x)
#define CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_PRE_DIV_GET(x)\
	FIELD_GET(CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_PRE_DIV, x)

#define CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_ROT_DIR  BIT(11)
#define CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_ROT_DIR_SET(x)\
	FIELD_PREP(CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_ROT_DIR, x)
#define CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_ROT_DIR_GET(x)\
	FIELD_GET(CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_ROT_DIR, x)

#define CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_ROT_SEL  GENMASK(13, 12)
#define CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_ROT_SEL_SET(x)\
	FIELD_PREP(CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_ROT_SEL, x)
#define CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_ROT_SEL_GET(x)\
	FIELD_GET(CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_ROT_SEL, x)

#define CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_ROT_ENA  BIT(14)
#define CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_ROT_ENA_SET(x)\
	FIELD_PREP(CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_ROT_ENA, x)
#define CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_ROT_ENA_GET(x)\
	FIELD_GET(CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_ROT_ENA, x)

#define CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_CLK_ENA  BIT(15)
#define CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_CLK_ENA_SET(x)\
	FIELD_PREP(CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_CLK_ENA, x)
#define CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_CLK_ENA_GET(x)\
	FIELD_GET(CLKGEN_LCPLL1_CORE_CLK_CFG_CORE_CLK_ENA, x)

/*      CPU:CPU_REGS:PROC_CTRL */
#define CPU_PROC_CTRL             __REG(TARGET_CPU,\
					0, 1, 0, 0, 1, 204, 176, 0, 1, 4)

#define CPU_PROC_CTRL_AARCH64_MODE_ENA           BIT(12)
#define CPU_PROC_CTRL_AARCH64_MODE_ENA_SET(x)\
	FIELD_PREP(CPU_PROC_CTRL_AARCH64_MODE_ENA, x)
#define CPU_PROC_CTRL_AARCH64_MODE_ENA_GET(x)\
	FIELD_GET(CPU_PROC_CTRL_AARCH64_MODE_ENA, x)

#define CPU_PROC_CTRL_L2_RST_INVALIDATE_DIS      BIT(11)
#define CPU_PROC_CTRL_L2_RST_INVALIDATE_DIS_SET(x)\
	FIELD_PREP(CPU_PROC_CTRL_L2_RST_INVALIDATE_DIS, x)
#define CPU_PROC_CTRL_L2_RST_INVALIDATE_DIS_GET(x)\
	FIELD_GET(CPU_PROC_CTRL_L2_RST_INVALIDATE_DIS, x)

#define CPU_PROC_CTRL_L1_RST_INVALIDATE_DIS      BIT(10)
#define CPU_PROC_CTRL_L1_RST_INVALIDATE_DIS_SET(x)\
	FIELD_PREP(CPU_PROC_CTRL_L1_RST_INVALIDATE_DIS, x)
#define CPU_PROC_CTRL_L1_RST_INVALIDATE_DIS_GET(x)\
	FIELD_GET(CPU_PROC_CTRL_L1_RST_INVALIDATE_DIS, x)

#define CPU_PROC_CTRL_BE_EXCEP_MODE              BIT(9)
#define CPU_PROC_CTRL_BE_EXCEP_MODE_SET(x)\
	FIELD_PREP(CPU_PROC_CTRL_BE_EXCEP_MODE, x)
#define CPU_PROC_CTRL_BE_EXCEP_MODE_GET(x)\
	FIELD_GET(CPU_PROC_CTRL_BE_EXCEP_MODE, x)

#define CPU_PROC_CTRL_VINITHI                    BIT(8)
#define CPU_PROC_CTRL_VINITHI_SET(x)\
	FIELD_PREP(CPU_PROC_CTRL_VINITHI, x)
#define CPU_PROC_CTRL_VINITHI_GET(x)\
	FIELD_GET(CPU_PROC_CTRL_VINITHI, x)

#define CPU_PROC_CTRL_CFGTE                      BIT(7)
#define CPU_PROC_CTRL_CFGTE_SET(x)\
	FIELD_PREP(CPU_PROC_CTRL_CFGTE, x)
#define CPU_PROC_CTRL_CFGTE_GET(x)\
	FIELD_GET(CPU_PROC_CTRL_CFGTE, x)

#define CPU_PROC_CTRL_CP15S_DISABLE              BIT(6)
#define CPU_PROC_CTRL_CP15S_DISABLE_SET(x)\
	FIELD_PREP(CPU_PROC_CTRL_CP15S_DISABLE, x)
#define CPU_PROC_CTRL_CP15S_DISABLE_GET(x)\
	FIELD_GET(CPU_PROC_CTRL_CP15S_DISABLE, x)

#define CPU_PROC_CTRL_PROC_CRYPTO_DISABLE        BIT(5)
#define CPU_PROC_CTRL_PROC_CRYPTO_DISABLE_SET(x)\
	FIELD_PREP(CPU_PROC_CTRL_PROC_CRYPTO_DISABLE, x)
#define CPU_PROC_CTRL_PROC_CRYPTO_DISABLE_GET(x)\
	FIELD_GET(CPU_PROC_CTRL_PROC_CRYPTO_DISABLE, x)

#define CPU_PROC_CTRL_ACP_CACHE_FORCE_ENA        BIT(4)
#define CPU_PROC_CTRL_ACP_CACHE_FORCE_ENA_SET(x)\
	FIELD_PREP(CPU_PROC_CTRL_ACP_CACHE_FORCE_ENA, x)
#define CPU_PROC_CTRL_ACP_CACHE_FORCE_ENA_GET(x)\
	FIELD_GET(CPU_PROC_CTRL_ACP_CACHE_FORCE_ENA, x)

#define CPU_PROC_CTRL_ACP_AWCACHE                BIT(3)
#define CPU_PROC_CTRL_ACP_AWCACHE_SET(x)\
	FIELD_PREP(CPU_PROC_CTRL_ACP_AWCACHE, x)
#define CPU_PROC_CTRL_ACP_AWCACHE_GET(x)\
	FIELD_GET(CPU_PROC_CTRL_ACP_AWCACHE, x)

#define CPU_PROC_CTRL_ACP_ARCACHE                BIT(2)
#define CPU_PROC_CTRL_ACP_ARCACHE_SET(x)\
	FIELD_PREP(CPU_PROC_CTRL_ACP_ARCACHE, x)
#define CPU_PROC_CTRL_ACP_ARCACHE_GET(x)\
	FIELD_GET(CPU_PROC_CTRL_ACP_ARCACHE, x)

#define CPU_PROC_CTRL_L2_FLUSH_REQ               BIT(1)
#define CPU_PROC_CTRL_L2_FLUSH_REQ_SET(x)\
	FIELD_PREP(CPU_PROC_CTRL_L2_FLUSH_REQ, x)
#define CPU_PROC_CTRL_L2_FLUSH_REQ_GET(x)\
	FIELD_GET(CPU_PROC_CTRL_L2_FLUSH_REQ, x)

#define CPU_PROC_CTRL_ACP_DISABLE                BIT(0)
#define CPU_PROC_CTRL_ACP_DISABLE_SET(x)\
	FIELD_PREP(CPU_PROC_CTRL_ACP_DISABLE, x)
#define CPU_PROC_CTRL_ACP_DISABLE_GET(x)\
	FIELD_GET(CPU_PROC_CTRL_ACP_DISABLE, x)

/*      DEV10G:MAC_CFG_STATUS:MAC_ENA_CFG */
#define DEV10G_MAC_ENA_CFG(t)     __REG(TARGET_DEV10G,\
					t, 12, 0, 0, 1, 60, 0, 0, 1, 4)

#define DEV10G_MAC_ENA_CFG_RX_ENA                BIT(4)
#define DEV10G_MAC_ENA_CFG_RX_ENA_SET(x)\
	FIELD_PREP(DEV10G_MAC_ENA_CFG_RX_ENA, x)
#define DEV10G_MAC_ENA_CFG_RX_ENA_GET(x)\
	FIELD_GET(DEV10G_MAC_ENA_CFG_RX_ENA, x)

#define DEV10G_MAC_ENA_CFG_TX_ENA                BIT(0)
#define DEV10G_MAC_ENA_CFG_TX_ENA_SET(x)\
	FIELD_PREP(DEV10G_MAC_ENA_CFG_TX_ENA, x)
#define DEV10G_MAC_ENA_CFG_TX_ENA_GET(x)\
	FIELD_GET(DEV10G_MAC_ENA_CFG_TX_ENA, x)

/*      DEV10G:MAC_CFG_STATUS:MAC_MAXLEN_CFG */
#define DEV10G_MAC_MAXLEN_CFG(t)  __REG(TARGET_DEV10G,\
					t, 12, 0, 0, 1, 60, 8, 0, 1, 4)

#define DEV10G_MAC_MAXLEN_CFG_MAX_LEN_TAG_CHK    BIT(16)
#define DEV10G_MAC_MAXLEN_CFG_MAX_LEN_TAG_CHK_SET(x)\
	FIELD_PREP(DEV10G_MAC_MAXLEN_CFG_MAX_LEN_TAG_CHK, x)
#define DEV10G_MAC_MAXLEN_CFG_MAX_LEN_TAG_CHK_GET(x)\
	FIELD_GET(DEV10G_MAC_MAXLEN_CFG_MAX_LEN_TAG_CHK, x)

#define DEV10G_MAC_MAXLEN_CFG_MAX_LEN            GENMASK(15, 0)
#define DEV10G_MAC_MAXLEN_CFG_MAX_LEN_SET(x)\
	FIELD_PREP(DEV10G_MAC_MAXLEN_CFG_MAX_LEN, x)
#define DEV10G_MAC_MAXLEN_CFG_MAX_LEN_GET(x)\
	FIELD_GET(DEV10G_MAC_MAXLEN_CFG_MAX_LEN, x)

/*      DEV10G:MAC_CFG_STATUS:MAC_NUM_TAGS_CFG */
#define DEV10G_MAC_NUM_TAGS_CFG(t) __REG(TARGET_DEV10G,\
					t, 12, 0, 0, 1, 60, 12, 0, 1, 4)

#define DEV10G_MAC_NUM_TAGS_CFG_NUM_TAGS         GENMASK(1, 0)
#define DEV10G_MAC_NUM_TAGS_CFG_NUM_TAGS_SET(x)\
	FIELD_PREP(DEV10G_MAC_NUM_TAGS_CFG_NUM_TAGS, x)
#define DEV10G_MAC_NUM_TAGS_CFG_NUM_TAGS_GET(x)\
	FIELD_GET(DEV10G_MAC_NUM_TAGS_CFG_NUM_TAGS, x)

/*      DEV10G:MAC_CFG_STATUS:MAC_TAGS_CFG */
#define DEV10G_MAC_TAGS_CFG(t, r) __REG(TARGET_DEV10G,\
					t, 12, 0, 0, 1, 60, 16, r, 3, 4)

#define DEV10G_MAC_TAGS_CFG_TAG_ID               GENMASK(31, 16)
#define DEV10G_MAC_TAGS_CFG_TAG_ID_SET(x)\
	FIELD_PREP(DEV10G_MAC_TAGS_CFG_TAG_ID, x)
#define DEV10G_MAC_TAGS_CFG_TAG_ID_GET(x)\
	FIELD_GET(DEV10G_MAC_TAGS_CFG_TAG_ID, x)

#define DEV10G_MAC_TAGS_CFG_TAG_ENA              BIT(4)
#define DEV10G_MAC_TAGS_CFG_TAG_ENA_SET(x)\
	FIELD_PREP(DEV10G_MAC_TAGS_CFG_TAG_ENA, x)
#define DEV10G_MAC_TAGS_CFG_TAG_ENA_GET(x)\
	FIELD_GET(DEV10G_MAC_TAGS_CFG_TAG_ENA, x)

/*      DEV10G:MAC_CFG_STATUS:MAC_ADV_CHK_CFG */
#define DEV10G_MAC_ADV_CHK_CFG(t) __REG(TARGET_DEV10G,\
					t, 12, 0, 0, 1, 60, 28, 0, 1, 4)

#define DEV10G_MAC_ADV_CHK_CFG_EXT_EOP_CHK_ENA   BIT(24)
#define DEV10G_MAC_ADV_CHK_CFG_EXT_EOP_CHK_ENA_SET(x)\
	FIELD_PREP(DEV10G_MAC_ADV_CHK_CFG_EXT_EOP_CHK_ENA, x)
#define DEV10G_MAC_ADV_CHK_CFG_EXT_EOP_CHK_ENA_GET(x)\
	FIELD_GET(DEV10G_MAC_ADV_CHK_CFG_EXT_EOP_CHK_ENA, x)

#define DEV10G_MAC_ADV_CHK_CFG_EXT_SOP_CHK_ENA   BIT(20)
#define DEV10G_MAC_ADV_CHK_CFG_EXT_SOP_CHK_ENA_SET(x)\
	FIELD_PREP(DEV10G_MAC_ADV_CHK_CFG_EXT_SOP_CHK_ENA, x)
#define DEV10G_MAC_ADV_CHK_CFG_EXT_SOP_CHK_ENA_GET(x)\
	FIELD_GET(DEV10G_MAC_ADV_CHK_CFG_EXT_SOP_CHK_ENA, x)

#define DEV10G_MAC_ADV_CHK_CFG_SFD_CHK_ENA       BIT(16)
#define DEV10G_MAC_ADV_CHK_CFG_SFD_CHK_ENA_SET(x)\
	FIELD_PREP(DEV10G_MAC_ADV_CHK_CFG_SFD_CHK_ENA, x)
#define DEV10G_MAC_ADV_CHK_CFG_SFD_CHK_ENA_GET(x)\
	FIELD_GET(DEV10G_MAC_ADV_CHK_CFG_SFD_CHK_ENA, x)

#define DEV10G_MAC_ADV_CHK_CFG_PRM_SHK_CHK_DIS   BIT(12)
#define DEV10G_MAC_ADV_CHK_CFG_PRM_SHK_CHK_DIS_SET(x)\
	FIELD_PREP(DEV10G_MAC_ADV_CHK_CFG_PRM_SHK_CHK_DIS, x)
#define DEV10G_MAC_ADV_CHK_CFG_PRM_SHK_CHK_DIS_GET(x)\
	FIELD_GET(DEV10G_MAC_ADV_CHK_CFG_PRM_SHK_CHK_DIS, x)

#define DEV10G_MAC_ADV_CHK_CFG_PRM_CHK_ENA       BIT(8)
#define DEV10G_MAC_ADV_CHK_CFG_PRM_CHK_ENA_SET(x)\
	FIELD_PREP(DEV10G_MAC_ADV_CHK_CFG_PRM_CHK_ENA, x)
#define DEV10G_MAC_ADV_CHK_CFG_PRM_CHK_ENA_GET(x)\
	FIELD_GET(DEV10G_MAC_ADV_CHK_CFG_PRM_CHK_ENA, x)

#define DEV10G_MAC_ADV_CHK_CFG_OOR_ERR_ENA       BIT(4)
#define DEV10G_MAC_ADV_CHK_CFG_OOR_ERR_ENA_SET(x)\
	FIELD_PREP(DEV10G_MAC_ADV_CHK_CFG_OOR_ERR_ENA, x)
#define DEV10G_MAC_ADV_CHK_CFG_OOR_ERR_ENA_GET(x)\
	FIELD_GET(DEV10G_MAC_ADV_CHK_CFG_OOR_ERR_ENA, x)

#define DEV10G_MAC_ADV_CHK_CFG_INR_ERR_ENA       BIT(0)
#define DEV10G_MAC_ADV_CHK_CFG_INR_ERR_ENA_SET(x)\
	FIELD_PREP(DEV10G_MAC_ADV_CHK_CFG_INR_ERR_ENA, x)
#define DEV10G_MAC_ADV_CHK_CFG_INR_ERR_ENA_GET(x)\
	FIELD_GET(DEV10G_MAC_ADV_CHK_CFG_INR_ERR_ENA, x)

/*      DEV10G:MAC_CFG_STATUS:MAC_TX_MONITOR_STICKY */
#define DEV10G_MAC_TX_MONITOR_STICKY(t) __REG(TARGET_DEV10G,\
					t, 12, 0, 0, 1, 60, 48, 0, 1, 4)

#define DEV10G_MAC_TX_MONITOR_STICKY_LOCAL_ERR_STATE_STICKY BIT(4)
#define DEV10G_MAC_TX_MONITOR_STICKY_LOCAL_ERR_STATE_STICKY_SET(x)\
	FIELD_PREP(DEV10G_MAC_TX_MONITOR_STICKY_LOCAL_ERR_STATE_STICKY, x)
#define DEV10G_MAC_TX_MONITOR_STICKY_LOCAL_ERR_STATE_STICKY_GET(x)\
	FIELD_GET(DEV10G_MAC_TX_MONITOR_STICKY_LOCAL_ERR_STATE_STICKY, x)

#define DEV10G_MAC_TX_MONITOR_STICKY_REMOTE_ERR_STATE_STICKY BIT(3)
#define DEV10G_MAC_TX_MONITOR_STICKY_REMOTE_ERR_STATE_STICKY_SET(x)\
	FIELD_PREP(DEV10G_MAC_TX_MONITOR_STICKY_REMOTE_ERR_STATE_STICKY, x)
#define DEV10G_MAC_TX_MONITOR_STICKY_REMOTE_ERR_STATE_STICKY_GET(x)\
	FIELD_GET(DEV10G_MAC_TX_MONITOR_STICKY_REMOTE_ERR_STATE_STICKY, x)

#define DEV10G_MAC_TX_MONITOR_STICKY_LINK_INTERRUPTION_STATE_STICKY BIT(2)
#define DEV10G_MAC_TX_MONITOR_STICKY_LINK_INTERRUPTION_STATE_STICKY_SET(x)\
	FIELD_PREP(DEV10G_MAC_TX_MONITOR_STICKY_LINK_INTERRUPTION_STATE_STICKY, x)
#define DEV10G_MAC_TX_MONITOR_STICKY_LINK_INTERRUPTION_STATE_STICKY_GET(x)\
	FIELD_GET(DEV10G_MAC_TX_MONITOR_STICKY_LINK_INTERRUPTION_STATE_STICKY, x)

#define DEV10G_MAC_TX_MONITOR_STICKY_IDLE_STATE_STICKY BIT(1)
#define DEV10G_MAC_TX_MONITOR_STICKY_IDLE_STATE_STICKY_SET(x)\
	FIELD_PREP(DEV10G_MAC_TX_MONITOR_STICKY_IDLE_STATE_STICKY, x)
#define DEV10G_MAC_TX_MONITOR_STICKY_IDLE_STATE_STICKY_GET(x)\
	FIELD_GET(DEV10G_MAC_TX_MONITOR_STICKY_IDLE_STATE_STICKY, x)

#define DEV10G_MAC_TX_MONITOR_STICKY_DIS_STATE_STICKY BIT(0)
#define DEV10G_MAC_TX_MONITOR_STICKY_DIS_STATE_STICKY_SET(x)\
	FIELD_PREP(DEV10G_MAC_TX_MONITOR_STICKY_DIS_STATE_STICKY, x)
#define DEV10G_MAC_TX_MONITOR_STICKY_DIS_STATE_STICKY_GET(x)\
	FIELD_GET(DEV10G_MAC_TX_MONITOR_STICKY_DIS_STATE_STICKY, x)

/*      DEV10G:DEV_CFG_STATUS:DEV_RST_CTRL */
#define DEV10G_DEV_RST_CTRL(t)    __REG(TARGET_DEV10G,\
					t, 12, 436, 0, 1, 52, 0, 0, 1, 4)

#define DEV10G_DEV_RST_CTRL_PARDET_MODE_ENA      BIT(28)
#define DEV10G_DEV_RST_CTRL_PARDET_MODE_ENA_SET(x)\
	FIELD_PREP(DEV10G_DEV_RST_CTRL_PARDET_MODE_ENA, x)
#define DEV10G_DEV_RST_CTRL_PARDET_MODE_ENA_GET(x)\
	FIELD_GET(DEV10G_DEV_RST_CTRL_PARDET_MODE_ENA, x)

#define DEV10G_DEV_RST_CTRL_USXGMII_OSET_FILTER_DIS BIT(27)
#define DEV10G_DEV_RST_CTRL_USXGMII_OSET_FILTER_DIS_SET(x)\
	FIELD_PREP(DEV10G_DEV_RST_CTRL_USXGMII_OSET_FILTER_DIS, x)
#define DEV10G_DEV_RST_CTRL_USXGMII_OSET_FILTER_DIS_GET(x)\
	FIELD_GET(DEV10G_DEV_RST_CTRL_USXGMII_OSET_FILTER_DIS, x)

#define DEV10G_DEV_RST_CTRL_MUXED_USXGMII_NETWORK_PORTS GENMASK(26, 25)
#define DEV10G_DEV_RST_CTRL_MUXED_USXGMII_NETWORK_PORTS_SET(x)\
	FIELD_PREP(DEV10G_DEV_RST_CTRL_MUXED_USXGMII_NETWORK_PORTS, x)
#define DEV10G_DEV_RST_CTRL_MUXED_USXGMII_NETWORK_PORTS_GET(x)\
	FIELD_GET(DEV10G_DEV_RST_CTRL_MUXED_USXGMII_NETWORK_PORTS, x)

#define DEV10G_DEV_RST_CTRL_SERDES_SPEED_SEL     GENMASK(24, 23)
#define DEV10G_DEV_RST_CTRL_SERDES_SPEED_SEL_SET(x)\
	FIELD_PREP(DEV10G_DEV_RST_CTRL_SERDES_SPEED_SEL, x)
#define DEV10G_DEV_RST_CTRL_SERDES_SPEED_SEL_GET(x)\
	FIELD_GET(DEV10G_DEV_RST_CTRL_SERDES_SPEED_SEL, x)

#define DEV10G_DEV_RST_CTRL_SPEED_SEL            GENMASK(22, 20)
#define DEV10G_DEV_RST_CTRL_SPEED_SEL_SET(x)\
	FIELD_PREP(DEV10G_DEV_RST_CTRL_SPEED_SEL, x)
#define DEV10G_DEV_RST_CTRL_SPEED_SEL_GET(x)\
	FIELD_GET(DEV10G_DEV_RST_CTRL_SPEED_SEL, x)

#define DEV10G_DEV_RST_CTRL_PCS_TX_RST           BIT(12)
#define DEV10G_DEV_RST_CTRL_PCS_TX_RST_SET(x)\
	FIELD_PREP(DEV10G_DEV_RST_CTRL_PCS_TX_RST, x)
#define DEV10G_DEV_RST_CTRL_PCS_TX_RST_GET(x)\
	FIELD_GET(DEV10G_DEV_RST_CTRL_PCS_TX_RST, x)

#define DEV10G_DEV_RST_CTRL_PCS_RX_RST           BIT(8)
#define DEV10G_DEV_RST_CTRL_PCS_RX_RST_SET(x)\
	FIELD_PREP(DEV10G_DEV_RST_CTRL_PCS_RX_RST, x)
#define DEV10G_DEV_RST_CTRL_PCS_RX_RST_GET(x)\
	FIELD_GET(DEV10G_DEV_RST_CTRL_PCS_RX_RST, x)

#define DEV10G_DEV_RST_CTRL_MAC_TX_RST           BIT(4)
#define DEV10G_DEV_RST_CTRL_MAC_TX_RST_SET(x)\
	FIELD_PREP(DEV10G_DEV_RST_CTRL_MAC_TX_RST, x)
#define DEV10G_DEV_RST_CTRL_MAC_TX_RST_GET(x)\
	FIELD_GET(DEV10G_DEV_RST_CTRL_MAC_TX_RST, x)

#define DEV10G_DEV_RST_CTRL_MAC_RX_RST           BIT(0)
#define DEV10G_DEV_RST_CTRL_MAC_RX_RST_SET(x)\
	FIELD_PREP(DEV10G_DEV_RST_CTRL_MAC_RX_RST, x)
#define DEV10G_DEV_RST_CTRL_MAC_RX_RST_GET(x)\
	FIELD_GET(DEV10G_DEV_RST_CTRL_MAC_RX_RST, x)

/*      DEV10G:PCS25G_CFG_STATUS:PCS25G_CFG */
#define DEV10G_PCS25G_CFG(t)      __REG(TARGET_DEV10G,\
					t, 12, 488, 0, 1, 32, 0, 0, 1, 4)

#define DEV10G_PCS25G_CFG_PCS25G_ENA             BIT(0)
#define DEV10G_PCS25G_CFG_PCS25G_ENA_SET(x)\
	FIELD_PREP(DEV10G_PCS25G_CFG_PCS25G_ENA, x)
#define DEV10G_PCS25G_CFG_PCS25G_ENA_GET(x)\
	FIELD_GET(DEV10G_PCS25G_CFG_PCS25G_ENA, x)

/*      DEV10G:MAC_CFG_STATUS:MAC_ENA_CFG */
#define DEV25G_MAC_ENA_CFG(t)     __REG(TARGET_DEV25G,\
					t, 8, 0, 0, 1, 60, 0, 0, 1, 4)

#define DEV25G_MAC_ENA_CFG_RX_ENA                BIT(4)
#define DEV25G_MAC_ENA_CFG_RX_ENA_SET(x)\
	FIELD_PREP(DEV25G_MAC_ENA_CFG_RX_ENA, x)
#define DEV25G_MAC_ENA_CFG_RX_ENA_GET(x)\
	FIELD_GET(DEV25G_MAC_ENA_CFG_RX_ENA, x)

#define DEV25G_MAC_ENA_CFG_TX_ENA                BIT(0)
#define DEV25G_MAC_ENA_CFG_TX_ENA_SET(x)\
	FIELD_PREP(DEV25G_MAC_ENA_CFG_TX_ENA, x)
#define DEV25G_MAC_ENA_CFG_TX_ENA_GET(x)\
	FIELD_GET(DEV25G_MAC_ENA_CFG_TX_ENA, x)

/*      DEV10G:MAC_CFG_STATUS:MAC_MAXLEN_CFG */
#define DEV25G_MAC_MAXLEN_CFG(t)  __REG(TARGET_DEV25G,\
					t, 8, 0, 0, 1, 60, 8, 0, 1, 4)

#define DEV25G_MAC_MAXLEN_CFG_MAX_LEN_TAG_CHK    BIT(16)
#define DEV25G_MAC_MAXLEN_CFG_MAX_LEN_TAG_CHK_SET(x)\
	FIELD_PREP(DEV25G_MAC_MAXLEN_CFG_MAX_LEN_TAG_CHK, x)
#define DEV25G_MAC_MAXLEN_CFG_MAX_LEN_TAG_CHK_GET(x)\
	FIELD_GET(DEV25G_MAC_MAXLEN_CFG_MAX_LEN_TAG_CHK, x)

#define DEV25G_MAC_MAXLEN_CFG_MAX_LEN            GENMASK(15, 0)
#define DEV25G_MAC_MAXLEN_CFG_MAX_LEN_SET(x)\
	FIELD_PREP(DEV25G_MAC_MAXLEN_CFG_MAX_LEN, x)
#define DEV25G_MAC_MAXLEN_CFG_MAX_LEN_GET(x)\
	FIELD_GET(DEV25G_MAC_MAXLEN_CFG_MAX_LEN, x)

/*      DEV10G:MAC_CFG_STATUS:MAC_ADV_CHK_CFG */
#define DEV25G_MAC_ADV_CHK_CFG(t) __REG(TARGET_DEV25G,\
					t, 8, 0, 0, 1, 60, 28, 0, 1, 4)

#define DEV25G_MAC_ADV_CHK_CFG_EXT_EOP_CHK_ENA   BIT(24)
#define DEV25G_MAC_ADV_CHK_CFG_EXT_EOP_CHK_ENA_SET(x)\
	FIELD_PREP(DEV25G_MAC_ADV_CHK_CFG_EXT_EOP_CHK_ENA, x)
#define DEV25G_MAC_ADV_CHK_CFG_EXT_EOP_CHK_ENA_GET(x)\
	FIELD_GET(DEV25G_MAC_ADV_CHK_CFG_EXT_EOP_CHK_ENA, x)

#define DEV25G_MAC_ADV_CHK_CFG_EXT_SOP_CHK_ENA   BIT(20)
#define DEV25G_MAC_ADV_CHK_CFG_EXT_SOP_CHK_ENA_SET(x)\
	FIELD_PREP(DEV25G_MAC_ADV_CHK_CFG_EXT_SOP_CHK_ENA, x)
#define DEV25G_MAC_ADV_CHK_CFG_EXT_SOP_CHK_ENA_GET(x)\
	FIELD_GET(DEV25G_MAC_ADV_CHK_CFG_EXT_SOP_CHK_ENA, x)

#define DEV25G_MAC_ADV_CHK_CFG_SFD_CHK_ENA       BIT(16)
#define DEV25G_MAC_ADV_CHK_CFG_SFD_CHK_ENA_SET(x)\
	FIELD_PREP(DEV25G_MAC_ADV_CHK_CFG_SFD_CHK_ENA, x)
#define DEV25G_MAC_ADV_CHK_CFG_SFD_CHK_ENA_GET(x)\
	FIELD_GET(DEV25G_MAC_ADV_CHK_CFG_SFD_CHK_ENA, x)

#define DEV25G_MAC_ADV_CHK_CFG_PRM_SHK_CHK_DIS   BIT(12)
#define DEV25G_MAC_ADV_CHK_CFG_PRM_SHK_CHK_DIS_SET(x)\
	FIELD_PREP(DEV25G_MAC_ADV_CHK_CFG_PRM_SHK_CHK_DIS, x)
#define DEV25G_MAC_ADV_CHK_CFG_PRM_SHK_CHK_DIS_GET(x)\
	FIELD_GET(DEV25G_MAC_ADV_CHK_CFG_PRM_SHK_CHK_DIS, x)

#define DEV25G_MAC_ADV_CHK_CFG_PRM_CHK_ENA       BIT(8)
#define DEV25G_MAC_ADV_CHK_CFG_PRM_CHK_ENA_SET(x)\
	FIELD_PREP(DEV25G_MAC_ADV_CHK_CFG_PRM_CHK_ENA, x)
#define DEV25G_MAC_ADV_CHK_CFG_PRM_CHK_ENA_GET(x)\
	FIELD_GET(DEV25G_MAC_ADV_CHK_CFG_PRM_CHK_ENA, x)

#define DEV25G_MAC_ADV_CHK_CFG_OOR_ERR_ENA       BIT(4)
#define DEV25G_MAC_ADV_CHK_CFG_OOR_ERR_ENA_SET(x)\
	FIELD_PREP(DEV25G_MAC_ADV_CHK_CFG_OOR_ERR_ENA, x)
#define DEV25G_MAC_ADV_CHK_CFG_OOR_ERR_ENA_GET(x)\
	FIELD_GET(DEV25G_MAC_ADV_CHK_CFG_OOR_ERR_ENA, x)

#define DEV25G_MAC_ADV_CHK_CFG_INR_ERR_ENA       BIT(0)
#define DEV25G_MAC_ADV_CHK_CFG_INR_ERR_ENA_SET(x)\
	FIELD_PREP(DEV25G_MAC_ADV_CHK_CFG_INR_ERR_ENA, x)
#define DEV25G_MAC_ADV_CHK_CFG_INR_ERR_ENA_GET(x)\
	FIELD_GET(DEV25G_MAC_ADV_CHK_CFG_INR_ERR_ENA, x)

/*      DEV10G:DEV_CFG_STATUS:DEV_RST_CTRL */
#define DEV25G_DEV_RST_CTRL(t)    __REG(TARGET_DEV25G,\
					t, 8, 436, 0, 1, 52, 0, 0, 1, 4)

#define DEV25G_DEV_RST_CTRL_PARDET_MODE_ENA      BIT(28)
#define DEV25G_DEV_RST_CTRL_PARDET_MODE_ENA_SET(x)\
	FIELD_PREP(DEV25G_DEV_RST_CTRL_PARDET_MODE_ENA, x)
#define DEV25G_DEV_RST_CTRL_PARDET_MODE_ENA_GET(x)\
	FIELD_GET(DEV25G_DEV_RST_CTRL_PARDET_MODE_ENA, x)

#define DEV25G_DEV_RST_CTRL_USXGMII_OSET_FILTER_DIS BIT(27)
#define DEV25G_DEV_RST_CTRL_USXGMII_OSET_FILTER_DIS_SET(x)\
	FIELD_PREP(DEV25G_DEV_RST_CTRL_USXGMII_OSET_FILTER_DIS, x)
#define DEV25G_DEV_RST_CTRL_USXGMII_OSET_FILTER_DIS_GET(x)\
	FIELD_GET(DEV25G_DEV_RST_CTRL_USXGMII_OSET_FILTER_DIS, x)

#define DEV25G_DEV_RST_CTRL_MUXED_USXGMII_NETWORK_PORTS GENMASK(26, 25)
#define DEV25G_DEV_RST_CTRL_MUXED_USXGMII_NETWORK_PORTS_SET(x)\
	FIELD_PREP(DEV25G_DEV_RST_CTRL_MUXED_USXGMII_NETWORK_PORTS, x)
#define DEV25G_DEV_RST_CTRL_MUXED_USXGMII_NETWORK_PORTS_GET(x)\
	FIELD_GET(DEV25G_DEV_RST_CTRL_MUXED_USXGMII_NETWORK_PORTS, x)

#define DEV25G_DEV_RST_CTRL_SERDES_SPEED_SEL     GENMASK(24, 23)
#define DEV25G_DEV_RST_CTRL_SERDES_SPEED_SEL_SET(x)\
	FIELD_PREP(DEV25G_DEV_RST_CTRL_SERDES_SPEED_SEL, x)
#define DEV25G_DEV_RST_CTRL_SERDES_SPEED_SEL_GET(x)\
	FIELD_GET(DEV25G_DEV_RST_CTRL_SERDES_SPEED_SEL, x)

#define DEV25G_DEV_RST_CTRL_SPEED_SEL            GENMASK(22, 20)
#define DEV25G_DEV_RST_CTRL_SPEED_SEL_SET(x)\
	FIELD_PREP(DEV25G_DEV_RST_CTRL_SPEED_SEL, x)
#define DEV25G_DEV_RST_CTRL_SPEED_SEL_GET(x)\
	FIELD_GET(DEV25G_DEV_RST_CTRL_SPEED_SEL, x)

#define DEV25G_DEV_RST_CTRL_PCS_TX_RST           BIT(12)
#define DEV25G_DEV_RST_CTRL_PCS_TX_RST_SET(x)\
	FIELD_PREP(DEV25G_DEV_RST_CTRL_PCS_TX_RST, x)
#define DEV25G_DEV_RST_CTRL_PCS_TX_RST_GET(x)\
	FIELD_GET(DEV25G_DEV_RST_CTRL_PCS_TX_RST, x)

#define DEV25G_DEV_RST_CTRL_PCS_RX_RST           BIT(8)
#define DEV25G_DEV_RST_CTRL_PCS_RX_RST_SET(x)\
	FIELD_PREP(DEV25G_DEV_RST_CTRL_PCS_RX_RST, x)
#define DEV25G_DEV_RST_CTRL_PCS_RX_RST_GET(x)\
	FIELD_GET(DEV25G_DEV_RST_CTRL_PCS_RX_RST, x)

#define DEV25G_DEV_RST_CTRL_MAC_TX_RST           BIT(4)
#define DEV25G_DEV_RST_CTRL_MAC_TX_RST_SET(x)\
	FIELD_PREP(DEV25G_DEV_RST_CTRL_MAC_TX_RST, x)
#define DEV25G_DEV_RST_CTRL_MAC_TX_RST_GET(x)\
	FIELD_GET(DEV25G_DEV_RST_CTRL_MAC_TX_RST, x)

#define DEV25G_DEV_RST_CTRL_MAC_RX_RST           BIT(0)
#define DEV25G_DEV_RST_CTRL_MAC_RX_RST_SET(x)\
	FIELD_PREP(DEV25G_DEV_RST_CTRL_MAC_RX_RST, x)
#define DEV25G_DEV_RST_CTRL_MAC_RX_RST_GET(x)\
	FIELD_GET(DEV25G_DEV_RST_CTRL_MAC_RX_RST, x)

/*      DEV10G:PCS25G_CFG_STATUS:PCS25G_CFG */
#define DEV25G_PCS25G_CFG(t)      __REG(TARGET_DEV25G,\
					t, 8, 488, 0, 1, 32, 0, 0, 1, 4)

#define DEV25G_PCS25G_CFG_PCS25G_ENA             BIT(0)
#define DEV25G_PCS25G_CFG_PCS25G_ENA_SET(x)\
	FIELD_PREP(DEV25G_PCS25G_CFG_PCS25G_ENA, x)
#define DEV25G_PCS25G_CFG_PCS25G_ENA_GET(x)\
	FIELD_GET(DEV25G_PCS25G_CFG_PCS25G_ENA, x)

/*      DEV10G:PCS25G_CFG_STATUS:PCS25G_SD_CFG */
#define DEV25G_PCS25G_SD_CFG(t)   __REG(TARGET_DEV25G,\
					t, 8, 488, 0, 1, 32, 4, 0, 1, 4)

#define DEV25G_PCS25G_SD_CFG_SD_SEL              BIT(8)
#define DEV25G_PCS25G_SD_CFG_SD_SEL_SET(x)\
	FIELD_PREP(DEV25G_PCS25G_SD_CFG_SD_SEL, x)
#define DEV25G_PCS25G_SD_CFG_SD_SEL_GET(x)\
	FIELD_GET(DEV25G_PCS25G_SD_CFG_SD_SEL, x)

#define DEV25G_PCS25G_SD_CFG_SD_POL              BIT(4)
#define DEV25G_PCS25G_SD_CFG_SD_POL_SET(x)\
	FIELD_PREP(DEV25G_PCS25G_SD_CFG_SD_POL, x)
#define DEV25G_PCS25G_SD_CFG_SD_POL_GET(x)\
	FIELD_GET(DEV25G_PCS25G_SD_CFG_SD_POL, x)

#define DEV25G_PCS25G_SD_CFG_SD_ENA              BIT(0)
#define DEV25G_PCS25G_SD_CFG_SD_ENA_SET(x)\
	FIELD_PREP(DEV25G_PCS25G_SD_CFG_SD_ENA, x)
#define DEV25G_PCS25G_SD_CFG_SD_ENA_GET(x)\
	FIELD_GET(DEV25G_PCS25G_SD_CFG_SD_ENA, x)

/*      DEV1G:DEV_CFG_STATUS:DEV_RST_CTRL */
#define DEV2G5_DEV_RST_CTRL(t)    __REG(TARGET_DEV2G5,\
					t, 65, 0, 0, 1, 36, 0, 0, 1, 4)

#define DEV2G5_DEV_RST_CTRL_USXGMII_OSET_FILTER_DIS BIT(23)
#define DEV2G5_DEV_RST_CTRL_USXGMII_OSET_FILTER_DIS_SET(x)\
	FIELD_PREP(DEV2G5_DEV_RST_CTRL_USXGMII_OSET_FILTER_DIS, x)
#define DEV2G5_DEV_RST_CTRL_USXGMII_OSET_FILTER_DIS_GET(x)\
	FIELD_GET(DEV2G5_DEV_RST_CTRL_USXGMII_OSET_FILTER_DIS, x)

#define DEV2G5_DEV_RST_CTRL_SPEED_SEL            GENMASK(22, 20)
#define DEV2G5_DEV_RST_CTRL_SPEED_SEL_SET(x)\
	FIELD_PREP(DEV2G5_DEV_RST_CTRL_SPEED_SEL, x)
#define DEV2G5_DEV_RST_CTRL_SPEED_SEL_GET(x)\
	FIELD_GET(DEV2G5_DEV_RST_CTRL_SPEED_SEL, x)

#define DEV2G5_DEV_RST_CTRL_USX_PCS_TX_RST       BIT(17)
#define DEV2G5_DEV_RST_CTRL_USX_PCS_TX_RST_SET(x)\
	FIELD_PREP(DEV2G5_DEV_RST_CTRL_USX_PCS_TX_RST, x)
#define DEV2G5_DEV_RST_CTRL_USX_PCS_TX_RST_GET(x)\
	FIELD_GET(DEV2G5_DEV_RST_CTRL_USX_PCS_TX_RST, x)

#define DEV2G5_DEV_RST_CTRL_USX_PCS_RX_RST       BIT(16)
#define DEV2G5_DEV_RST_CTRL_USX_PCS_RX_RST_SET(x)\
	FIELD_PREP(DEV2G5_DEV_RST_CTRL_USX_PCS_RX_RST, x)
#define DEV2G5_DEV_RST_CTRL_USX_PCS_RX_RST_GET(x)\
	FIELD_GET(DEV2G5_DEV_RST_CTRL_USX_PCS_RX_RST, x)

#define DEV2G5_DEV_RST_CTRL_PCS_TX_RST           BIT(12)
#define DEV2G5_DEV_RST_CTRL_PCS_TX_RST_SET(x)\
	FIELD_PREP(DEV2G5_DEV_RST_CTRL_PCS_TX_RST, x)
#define DEV2G5_DEV_RST_CTRL_PCS_TX_RST_GET(x)\
	FIELD_GET(DEV2G5_DEV_RST_CTRL_PCS_TX_RST, x)

#define DEV2G5_DEV_RST_CTRL_PCS_RX_RST           BIT(8)
#define DEV2G5_DEV_RST_CTRL_PCS_RX_RST_SET(x)\
	FIELD_PREP(DEV2G5_DEV_RST_CTRL_PCS_RX_RST, x)
#define DEV2G5_DEV_RST_CTRL_PCS_RX_RST_GET(x)\
	FIELD_GET(DEV2G5_DEV_RST_CTRL_PCS_RX_RST, x)

#define DEV2G5_DEV_RST_CTRL_MAC_TX_RST           BIT(4)
#define DEV2G5_DEV_RST_CTRL_MAC_TX_RST_SET(x)\
	FIELD_PREP(DEV2G5_DEV_RST_CTRL_MAC_TX_RST, x)
#define DEV2G5_DEV_RST_CTRL_MAC_TX_RST_GET(x)\
	FIELD_GET(DEV2G5_DEV_RST_CTRL_MAC_TX_RST, x)

#define DEV2G5_DEV_RST_CTRL_MAC_RX_RST           BIT(0)
#define DEV2G5_DEV_RST_CTRL_MAC_RX_RST_SET(x)\
	FIELD_PREP(DEV2G5_DEV_RST_CTRL_MAC_RX_RST, x)
#define DEV2G5_DEV_RST_CTRL_MAC_RX_RST_GET(x)\
	FIELD_GET(DEV2G5_DEV_RST_CTRL_MAC_RX_RST, x)

/*      DEV1G:MAC_CFG_STATUS:MAC_ENA_CFG */
#define DEV2G5_MAC_ENA_CFG(t)     __REG(TARGET_DEV2G5,\
					t, 65, 52, 0, 1, 36, 0, 0, 1, 4)

#define DEV2G5_MAC_ENA_CFG_RX_ENA                BIT(4)
#define DEV2G5_MAC_ENA_CFG_RX_ENA_SET(x)\
	FIELD_PREP(DEV2G5_MAC_ENA_CFG_RX_ENA, x)
#define DEV2G5_MAC_ENA_CFG_RX_ENA_GET(x)\
	FIELD_GET(DEV2G5_MAC_ENA_CFG_RX_ENA, x)

#define DEV2G5_MAC_ENA_CFG_TX_ENA                BIT(0)
#define DEV2G5_MAC_ENA_CFG_TX_ENA_SET(x)\
	FIELD_PREP(DEV2G5_MAC_ENA_CFG_TX_ENA, x)
#define DEV2G5_MAC_ENA_CFG_TX_ENA_GET(x)\
	FIELD_GET(DEV2G5_MAC_ENA_CFG_TX_ENA, x)

/*      DEV1G:MAC_CFG_STATUS:MAC_MODE_CFG */
#define DEV2G5_MAC_MODE_CFG(t)    __REG(TARGET_DEV2G5,\
					t, 65, 52, 0, 1, 36, 4, 0, 1, 4)

#define DEV2G5_MAC_MODE_CFG_FC_WORD_SYNC_ENA     BIT(8)
#define DEV2G5_MAC_MODE_CFG_FC_WORD_SYNC_ENA_SET(x)\
	FIELD_PREP(DEV2G5_MAC_MODE_CFG_FC_WORD_SYNC_ENA, x)
#define DEV2G5_MAC_MODE_CFG_FC_WORD_SYNC_ENA_GET(x)\
	FIELD_GET(DEV2G5_MAC_MODE_CFG_FC_WORD_SYNC_ENA, x)

#define DEV2G5_MAC_MODE_CFG_GIGA_MODE_ENA        BIT(4)
#define DEV2G5_MAC_MODE_CFG_GIGA_MODE_ENA_SET(x)\
	FIELD_PREP(DEV2G5_MAC_MODE_CFG_GIGA_MODE_ENA, x)
#define DEV2G5_MAC_MODE_CFG_GIGA_MODE_ENA_GET(x)\
	FIELD_GET(DEV2G5_MAC_MODE_CFG_GIGA_MODE_ENA, x)

#define DEV2G5_MAC_MODE_CFG_FDX_ENA              BIT(0)
#define DEV2G5_MAC_MODE_CFG_FDX_ENA_SET(x)\
	FIELD_PREP(DEV2G5_MAC_MODE_CFG_FDX_ENA, x)
#define DEV2G5_MAC_MODE_CFG_FDX_ENA_GET(x)\
	FIELD_GET(DEV2G5_MAC_MODE_CFG_FDX_ENA, x)

/*      DEV1G:MAC_CFG_STATUS:MAC_MAXLEN_CFG */
#define DEV2G5_MAC_MAXLEN_CFG(t)  __REG(TARGET_DEV2G5,\
					t, 65, 52, 0, 1, 36, 8, 0, 1, 4)

#define DEV2G5_MAC_MAXLEN_CFG_MAX_LEN            GENMASK(15, 0)
#define DEV2G5_MAC_MAXLEN_CFG_MAX_LEN_SET(x)\
	FIELD_PREP(DEV2G5_MAC_MAXLEN_CFG_MAX_LEN, x)
#define DEV2G5_MAC_MAXLEN_CFG_MAX_LEN_GET(x)\
	FIELD_GET(DEV2G5_MAC_MAXLEN_CFG_MAX_LEN, x)

/*      DEV1G:MAC_CFG_STATUS:MAC_TAGS_CFG */
#define DEV2G5_MAC_TAGS_CFG(t)    __REG(TARGET_DEV2G5,\
					t, 65, 52, 0, 1, 36, 12, 0, 1, 4)

#define DEV2G5_MAC_TAGS_CFG_TAG_ID               GENMASK(31, 16)
#define DEV2G5_MAC_TAGS_CFG_TAG_ID_SET(x)\
	FIELD_PREP(DEV2G5_MAC_TAGS_CFG_TAG_ID, x)
#define DEV2G5_MAC_TAGS_CFG_TAG_ID_GET(x)\
	FIELD_GET(DEV2G5_MAC_TAGS_CFG_TAG_ID, x)

#define DEV2G5_MAC_TAGS_CFG_VLAN_LEN_AWR_ENA     BIT(3)
#define DEV2G5_MAC_TAGS_CFG_VLAN_LEN_AWR_ENA_SET(x)\
	FIELD_PREP(DEV2G5_MAC_TAGS_CFG_VLAN_LEN_AWR_ENA, x)
#define DEV2G5_MAC_TAGS_CFG_VLAN_LEN_AWR_ENA_GET(x)\
	FIELD_GET(DEV2G5_MAC_TAGS_CFG_VLAN_LEN_AWR_ENA, x)

#define DEV2G5_MAC_TAGS_CFG_PB_ENA               GENMASK(2, 1)
#define DEV2G5_MAC_TAGS_CFG_PB_ENA_SET(x)\
	FIELD_PREP(DEV2G5_MAC_TAGS_CFG_PB_ENA, x)
#define DEV2G5_MAC_TAGS_CFG_PB_ENA_GET(x)\
	FIELD_GET(DEV2G5_MAC_TAGS_CFG_PB_ENA, x)

#define DEV2G5_MAC_TAGS_CFG_VLAN_AWR_ENA         BIT(0)
#define DEV2G5_MAC_TAGS_CFG_VLAN_AWR_ENA_SET(x)\
	FIELD_PREP(DEV2G5_MAC_TAGS_CFG_VLAN_AWR_ENA, x)
#define DEV2G5_MAC_TAGS_CFG_VLAN_AWR_ENA_GET(x)\
	FIELD_GET(DEV2G5_MAC_TAGS_CFG_VLAN_AWR_ENA, x)

/*      DEV1G:MAC_CFG_STATUS:MAC_TAGS_CFG2 */
#define DEV2G5_MAC_TAGS_CFG2(t)   __REG(TARGET_DEV2G5,\
					t, 65, 52, 0, 1, 36, 16, 0, 1, 4)

#define DEV2G5_MAC_TAGS_CFG2_TAG_ID3             GENMASK(31, 16)
#define DEV2G5_MAC_TAGS_CFG2_TAG_ID3_SET(x)\
	FIELD_PREP(DEV2G5_MAC_TAGS_CFG2_TAG_ID3, x)
#define DEV2G5_MAC_TAGS_CFG2_TAG_ID3_GET(x)\
	FIELD_GET(DEV2G5_MAC_TAGS_CFG2_TAG_ID3, x)

#define DEV2G5_MAC_TAGS_CFG2_TAG_ID2             GENMASK(15, 0)
#define DEV2G5_MAC_TAGS_CFG2_TAG_ID2_SET(x)\
	FIELD_PREP(DEV2G5_MAC_TAGS_CFG2_TAG_ID2, x)
#define DEV2G5_MAC_TAGS_CFG2_TAG_ID2_GET(x)\
	FIELD_GET(DEV2G5_MAC_TAGS_CFG2_TAG_ID2, x)

/*      DEV1G:MAC_CFG_STATUS:MAC_ADV_CHK_CFG */
#define DEV2G5_MAC_ADV_CHK_CFG(t) __REG(TARGET_DEV2G5,\
					t, 65, 52, 0, 1, 36, 20, 0, 1, 4)

#define DEV2G5_MAC_ADV_CHK_CFG_LEN_DROP_ENA      BIT(0)
#define DEV2G5_MAC_ADV_CHK_CFG_LEN_DROP_ENA_SET(x)\
	FIELD_PREP(DEV2G5_MAC_ADV_CHK_CFG_LEN_DROP_ENA, x)
#define DEV2G5_MAC_ADV_CHK_CFG_LEN_DROP_ENA_GET(x)\
	FIELD_GET(DEV2G5_MAC_ADV_CHK_CFG_LEN_DROP_ENA, x)

/*      DEV1G:MAC_CFG_STATUS:MAC_IFG_CFG */
#define DEV2G5_MAC_IFG_CFG(t)     __REG(TARGET_DEV2G5,\
					t, 65, 52, 0, 1, 36, 24, 0, 1, 4)

#define DEV2G5_MAC_IFG_CFG_RESTORE_OLD_IPG_CHECK BIT(17)
#define DEV2G5_MAC_IFG_CFG_RESTORE_OLD_IPG_CHECK_SET(x)\
	FIELD_PREP(DEV2G5_MAC_IFG_CFG_RESTORE_OLD_IPG_CHECK, x)
#define DEV2G5_MAC_IFG_CFG_RESTORE_OLD_IPG_CHECK_GET(x)\
	FIELD_GET(DEV2G5_MAC_IFG_CFG_RESTORE_OLD_IPG_CHECK, x)

#define DEV2G5_MAC_IFG_CFG_TX_IFG                GENMASK(12, 8)
#define DEV2G5_MAC_IFG_CFG_TX_IFG_SET(x)\
	FIELD_PREP(DEV2G5_MAC_IFG_CFG_TX_IFG, x)
#define DEV2G5_MAC_IFG_CFG_TX_IFG_GET(x)\
	FIELD_GET(DEV2G5_MAC_IFG_CFG_TX_IFG, x)

#define DEV2G5_MAC_IFG_CFG_RX_IFG2               GENMASK(7, 4)
#define DEV2G5_MAC_IFG_CFG_RX_IFG2_SET(x)\
	FIELD_PREP(DEV2G5_MAC_IFG_CFG_RX_IFG2, x)
#define DEV2G5_MAC_IFG_CFG_RX_IFG2_GET(x)\
	FIELD_GET(DEV2G5_MAC_IFG_CFG_RX_IFG2, x)

#define DEV2G5_MAC_IFG_CFG_RX_IFG1               GENMASK(3, 0)
#define DEV2G5_MAC_IFG_CFG_RX_IFG1_SET(x)\
	FIELD_PREP(DEV2G5_MAC_IFG_CFG_RX_IFG1, x)
#define DEV2G5_MAC_IFG_CFG_RX_IFG1_GET(x)\
	FIELD_GET(DEV2G5_MAC_IFG_CFG_RX_IFG1, x)

/*      DEV1G:MAC_CFG_STATUS:MAC_HDX_CFG */
#define DEV2G5_MAC_HDX_CFG(t)     __REG(TARGET_DEV2G5,\
					t, 65, 52, 0, 1, 36, 28, 0, 1, 4)

#define DEV2G5_MAC_HDX_CFG_BYPASS_COL_SYNC       BIT(26)
#define DEV2G5_MAC_HDX_CFG_BYPASS_COL_SYNC_SET(x)\
	FIELD_PREP(DEV2G5_MAC_HDX_CFG_BYPASS_COL_SYNC, x)
#define DEV2G5_MAC_HDX_CFG_BYPASS_COL_SYNC_GET(x)\
	FIELD_GET(DEV2G5_MAC_HDX_CFG_BYPASS_COL_SYNC, x)

#define DEV2G5_MAC_HDX_CFG_SEED                  GENMASK(23, 16)
#define DEV2G5_MAC_HDX_CFG_SEED_SET(x)\
	FIELD_PREP(DEV2G5_MAC_HDX_CFG_SEED, x)
#define DEV2G5_MAC_HDX_CFG_SEED_GET(x)\
	FIELD_GET(DEV2G5_MAC_HDX_CFG_SEED, x)

#define DEV2G5_MAC_HDX_CFG_SEED_LOAD             BIT(12)
#define DEV2G5_MAC_HDX_CFG_SEED_LOAD_SET(x)\
	FIELD_PREP(DEV2G5_MAC_HDX_CFG_SEED_LOAD, x)
#define DEV2G5_MAC_HDX_CFG_SEED_LOAD_GET(x)\
	FIELD_GET(DEV2G5_MAC_HDX_CFG_SEED_LOAD, x)

#define DEV2G5_MAC_HDX_CFG_RETRY_AFTER_EXC_COL_ENA BIT(8)
#define DEV2G5_MAC_HDX_CFG_RETRY_AFTER_EXC_COL_ENA_SET(x)\
	FIELD_PREP(DEV2G5_MAC_HDX_CFG_RETRY_AFTER_EXC_COL_ENA, x)
#define DEV2G5_MAC_HDX_CFG_RETRY_AFTER_EXC_COL_ENA_GET(x)\
	FIELD_GET(DEV2G5_MAC_HDX_CFG_RETRY_AFTER_EXC_COL_ENA, x)

#define DEV2G5_MAC_HDX_CFG_LATE_COL_POS          GENMASK(6, 0)
#define DEV2G5_MAC_HDX_CFG_LATE_COL_POS_SET(x)\
	FIELD_PREP(DEV2G5_MAC_HDX_CFG_LATE_COL_POS, x)
#define DEV2G5_MAC_HDX_CFG_LATE_COL_POS_GET(x)\
	FIELD_GET(DEV2G5_MAC_HDX_CFG_LATE_COL_POS, x)

/*      DEV1G:PCS1G_CFG_STATUS:PCS1G_CFG */
#define DEV2G5_PCS1G_CFG(t)       __REG(TARGET_DEV2G5,\
					t, 65, 88, 0, 1, 68, 0, 0, 1, 4)

#define DEV2G5_PCS1G_CFG_LINK_STATUS_TYPE        BIT(4)
#define DEV2G5_PCS1G_CFG_LINK_STATUS_TYPE_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_CFG_LINK_STATUS_TYPE, x)
#define DEV2G5_PCS1G_CFG_LINK_STATUS_TYPE_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_CFG_LINK_STATUS_TYPE, x)

#define DEV2G5_PCS1G_CFG_AN_LINK_CTRL_ENA        BIT(1)
#define DEV2G5_PCS1G_CFG_AN_LINK_CTRL_ENA_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_CFG_AN_LINK_CTRL_ENA, x)
#define DEV2G5_PCS1G_CFG_AN_LINK_CTRL_ENA_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_CFG_AN_LINK_CTRL_ENA, x)

#define DEV2G5_PCS1G_CFG_PCS_ENA                 BIT(0)
#define DEV2G5_PCS1G_CFG_PCS_ENA_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_CFG_PCS_ENA, x)
#define DEV2G5_PCS1G_CFG_PCS_ENA_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_CFG_PCS_ENA, x)

/*      DEV1G:PCS1G_CFG_STATUS:PCS1G_MODE_CFG */
#define DEV2G5_PCS1G_MODE_CFG(t)  __REG(TARGET_DEV2G5,\
					t, 65, 88, 0, 1, 68, 4, 0, 1, 4)

#define DEV2G5_PCS1G_MODE_CFG_UNIDIR_MODE_ENA    BIT(4)
#define DEV2G5_PCS1G_MODE_CFG_UNIDIR_MODE_ENA_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_MODE_CFG_UNIDIR_MODE_ENA, x)
#define DEV2G5_PCS1G_MODE_CFG_UNIDIR_MODE_ENA_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_MODE_CFG_UNIDIR_MODE_ENA, x)

#define DEV2G5_PCS1G_MODE_CFG_SAVE_PREAMBLE_ENA  BIT(1)
#define DEV2G5_PCS1G_MODE_CFG_SAVE_PREAMBLE_ENA_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_MODE_CFG_SAVE_PREAMBLE_ENA, x)
#define DEV2G5_PCS1G_MODE_CFG_SAVE_PREAMBLE_ENA_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_MODE_CFG_SAVE_PREAMBLE_ENA, x)

#define DEV2G5_PCS1G_MODE_CFG_SGMII_MODE_ENA     BIT(0)
#define DEV2G5_PCS1G_MODE_CFG_SGMII_MODE_ENA_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_MODE_CFG_SGMII_MODE_ENA, x)
#define DEV2G5_PCS1G_MODE_CFG_SGMII_MODE_ENA_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_MODE_CFG_SGMII_MODE_ENA, x)

/*      DEV1G:PCS1G_CFG_STATUS:PCS1G_SD_CFG */
#define DEV2G5_PCS1G_SD_CFG(t)    __REG(TARGET_DEV2G5,\
					t, 65, 88, 0, 1, 68, 8, 0, 1, 4)

#define DEV2G5_PCS1G_SD_CFG_SD_SEL               BIT(8)
#define DEV2G5_PCS1G_SD_CFG_SD_SEL_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_SD_CFG_SD_SEL, x)
#define DEV2G5_PCS1G_SD_CFG_SD_SEL_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_SD_CFG_SD_SEL, x)

#define DEV2G5_PCS1G_SD_CFG_SD_POL               BIT(4)
#define DEV2G5_PCS1G_SD_CFG_SD_POL_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_SD_CFG_SD_POL, x)
#define DEV2G5_PCS1G_SD_CFG_SD_POL_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_SD_CFG_SD_POL, x)

#define DEV2G5_PCS1G_SD_CFG_SD_ENA               BIT(0)
#define DEV2G5_PCS1G_SD_CFG_SD_ENA_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_SD_CFG_SD_ENA, x)
#define DEV2G5_PCS1G_SD_CFG_SD_ENA_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_SD_CFG_SD_ENA, x)

/*      DEV1G:PCS1G_CFG_STATUS:PCS1G_ANEG_CFG */
#define DEV2G5_PCS1G_ANEG_CFG(t)  __REG(TARGET_DEV2G5,\
					t, 65, 88, 0, 1, 68, 12, 0, 1, 4)

#define DEV2G5_PCS1G_ANEG_CFG_ADV_ABILITY        GENMASK(31, 16)
#define DEV2G5_PCS1G_ANEG_CFG_ADV_ABILITY_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_ANEG_CFG_ADV_ABILITY, x)
#define DEV2G5_PCS1G_ANEG_CFG_ADV_ABILITY_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_ANEG_CFG_ADV_ABILITY, x)

#define DEV2G5_PCS1G_ANEG_CFG_SW_RESOLVE_ENA     BIT(8)
#define DEV2G5_PCS1G_ANEG_CFG_SW_RESOLVE_ENA_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_ANEG_CFG_SW_RESOLVE_ENA, x)
#define DEV2G5_PCS1G_ANEG_CFG_SW_RESOLVE_ENA_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_ANEG_CFG_SW_RESOLVE_ENA, x)

#define DEV2G5_PCS1G_ANEG_CFG_ANEG_RESTART_ONE_SHOT BIT(1)
#define DEV2G5_PCS1G_ANEG_CFG_ANEG_RESTART_ONE_SHOT_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_ANEG_CFG_ANEG_RESTART_ONE_SHOT, x)
#define DEV2G5_PCS1G_ANEG_CFG_ANEG_RESTART_ONE_SHOT_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_ANEG_CFG_ANEG_RESTART_ONE_SHOT, x)

#define DEV2G5_PCS1G_ANEG_CFG_ANEG_ENA           BIT(0)
#define DEV2G5_PCS1G_ANEG_CFG_ANEG_ENA_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_ANEG_CFG_ANEG_ENA, x)
#define DEV2G5_PCS1G_ANEG_CFG_ANEG_ENA_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_ANEG_CFG_ANEG_ENA, x)

/*      DEV1G:PCS1G_CFG_STATUS:PCS1G_LB_CFG */
#define DEV2G5_PCS1G_LB_CFG(t)    __REG(TARGET_DEV2G5,\
					t, 65, 88, 0, 1, 68, 20, 0, 1, 4)

#define DEV2G5_PCS1G_LB_CFG_RA_ENA               BIT(4)
#define DEV2G5_PCS1G_LB_CFG_RA_ENA_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_LB_CFG_RA_ENA, x)
#define DEV2G5_PCS1G_LB_CFG_RA_ENA_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_LB_CFG_RA_ENA, x)

#define DEV2G5_PCS1G_LB_CFG_GMII_PHY_LB_ENA      BIT(1)
#define DEV2G5_PCS1G_LB_CFG_GMII_PHY_LB_ENA_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_LB_CFG_GMII_PHY_LB_ENA, x)
#define DEV2G5_PCS1G_LB_CFG_GMII_PHY_LB_ENA_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_LB_CFG_GMII_PHY_LB_ENA, x)

#define DEV2G5_PCS1G_LB_CFG_TBI_HOST_LB_ENA      BIT(0)
#define DEV2G5_PCS1G_LB_CFG_TBI_HOST_LB_ENA_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_LB_CFG_TBI_HOST_LB_ENA, x)
#define DEV2G5_PCS1G_LB_CFG_TBI_HOST_LB_ENA_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_LB_CFG_TBI_HOST_LB_ENA, x)

/*      DEV1G:PCS1G_CFG_STATUS:PCS1G_ANEG_STATUS */
#define DEV2G5_PCS1G_ANEG_STATUS(t) __REG(TARGET_DEV2G5,\
					t, 65, 88, 0, 1, 68, 32, 0, 1, 4)

#define DEV2G5_PCS1G_ANEG_STATUS_LP_ADV_ABILITY  GENMASK(31, 16)
#define DEV2G5_PCS1G_ANEG_STATUS_LP_ADV_ABILITY_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_ANEG_STATUS_LP_ADV_ABILITY, x)
#define DEV2G5_PCS1G_ANEG_STATUS_LP_ADV_ABILITY_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_ANEG_STATUS_LP_ADV_ABILITY, x)

#define DEV2G5_PCS1G_ANEG_STATUS_PR              BIT(4)
#define DEV2G5_PCS1G_ANEG_STATUS_PR_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_ANEG_STATUS_PR, x)
#define DEV2G5_PCS1G_ANEG_STATUS_PR_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_ANEG_STATUS_PR, x)

#define DEV2G5_PCS1G_ANEG_STATUS_PAGE_RX_STICKY  BIT(3)
#define DEV2G5_PCS1G_ANEG_STATUS_PAGE_RX_STICKY_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_ANEG_STATUS_PAGE_RX_STICKY, x)
#define DEV2G5_PCS1G_ANEG_STATUS_PAGE_RX_STICKY_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_ANEG_STATUS_PAGE_RX_STICKY, x)

#define DEV2G5_PCS1G_ANEG_STATUS_ANEG_COMPLETE   BIT(0)
#define DEV2G5_PCS1G_ANEG_STATUS_ANEG_COMPLETE_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_ANEG_STATUS_ANEG_COMPLETE, x)
#define DEV2G5_PCS1G_ANEG_STATUS_ANEG_COMPLETE_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_ANEG_STATUS_ANEG_COMPLETE, x)

/*      DEV1G:PCS1G_CFG_STATUS:PCS1G_LINK_STATUS */
#define DEV2G5_PCS1G_LINK_STATUS(t) __REG(TARGET_DEV2G5,\
					t, 65, 88, 0, 1, 68, 40, 0, 1, 4)

#define DEV2G5_PCS1G_LINK_STATUS_DELAY_VAR       GENMASK(15, 12)
#define DEV2G5_PCS1G_LINK_STATUS_DELAY_VAR_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_LINK_STATUS_DELAY_VAR, x)
#define DEV2G5_PCS1G_LINK_STATUS_DELAY_VAR_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_LINK_STATUS_DELAY_VAR, x)

#define DEV2G5_PCS1G_LINK_STATUS_SIGNAL_DETECT   BIT(8)
#define DEV2G5_PCS1G_LINK_STATUS_SIGNAL_DETECT_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_LINK_STATUS_SIGNAL_DETECT, x)
#define DEV2G5_PCS1G_LINK_STATUS_SIGNAL_DETECT_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_LINK_STATUS_SIGNAL_DETECT, x)

#define DEV2G5_PCS1G_LINK_STATUS_LINK_STATUS     BIT(4)
#define DEV2G5_PCS1G_LINK_STATUS_LINK_STATUS_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_LINK_STATUS_LINK_STATUS, x)
#define DEV2G5_PCS1G_LINK_STATUS_LINK_STATUS_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_LINK_STATUS_LINK_STATUS, x)

#define DEV2G5_PCS1G_LINK_STATUS_SYNC_STATUS     BIT(0)
#define DEV2G5_PCS1G_LINK_STATUS_SYNC_STATUS_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_LINK_STATUS_SYNC_STATUS, x)
#define DEV2G5_PCS1G_LINK_STATUS_SYNC_STATUS_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_LINK_STATUS_SYNC_STATUS, x)

/*      DEV1G:PCS1G_CFG_STATUS:PCS1G_STICKY */
#define DEV2G5_PCS1G_STICKY(t)    __REG(TARGET_DEV2G5,\
					t, 65, 88, 0, 1, 68, 48, 0, 1, 4)

#define DEV2G5_PCS1G_STICKY_LINK_DOWN_STICKY     BIT(4)
#define DEV2G5_PCS1G_STICKY_LINK_DOWN_STICKY_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_STICKY_LINK_DOWN_STICKY, x)
#define DEV2G5_PCS1G_STICKY_LINK_DOWN_STICKY_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_STICKY_LINK_DOWN_STICKY, x)

#define DEV2G5_PCS1G_STICKY_OUT_OF_SYNC_STICKY   BIT(0)
#define DEV2G5_PCS1G_STICKY_OUT_OF_SYNC_STICKY_SET(x)\
	FIELD_PREP(DEV2G5_PCS1G_STICKY_OUT_OF_SYNC_STICKY, x)
#define DEV2G5_PCS1G_STICKY_OUT_OF_SYNC_STICKY_GET(x)\
	FIELD_GET(DEV2G5_PCS1G_STICKY_OUT_OF_SYNC_STICKY, x)

/*      DEV1G:PCS_FX100_CONFIGURATION:PCS_FX100_CFG */
#define DEV2G5_PCS_FX100_CFG(t)   __REG(TARGET_DEV2G5,\
					t, 65, 164, 0, 1, 4, 0, 0, 1, 4)

#define DEV2G5_PCS_FX100_CFG_SD_SEL              BIT(26)
#define DEV2G5_PCS_FX100_CFG_SD_SEL_SET(x)\
	FIELD_PREP(DEV2G5_PCS_FX100_CFG_SD_SEL, x)
#define DEV2G5_PCS_FX100_CFG_SD_SEL_GET(x)\
	FIELD_GET(DEV2G5_PCS_FX100_CFG_SD_SEL, x)

#define DEV2G5_PCS_FX100_CFG_SD_POL              BIT(25)
#define DEV2G5_PCS_FX100_CFG_SD_POL_SET(x)\
	FIELD_PREP(DEV2G5_PCS_FX100_CFG_SD_POL, x)
#define DEV2G5_PCS_FX100_CFG_SD_POL_GET(x)\
	FIELD_GET(DEV2G5_PCS_FX100_CFG_SD_POL, x)

#define DEV2G5_PCS_FX100_CFG_SD_ENA              BIT(24)
#define DEV2G5_PCS_FX100_CFG_SD_ENA_SET(x)\
	FIELD_PREP(DEV2G5_PCS_FX100_CFG_SD_ENA, x)
#define DEV2G5_PCS_FX100_CFG_SD_ENA_GET(x)\
	FIELD_GET(DEV2G5_PCS_FX100_CFG_SD_ENA, x)

#define DEV2G5_PCS_FX100_CFG_LOOPBACK_ENA        BIT(20)
#define DEV2G5_PCS_FX100_CFG_LOOPBACK_ENA_SET(x)\
	FIELD_PREP(DEV2G5_PCS_FX100_CFG_LOOPBACK_ENA, x)
#define DEV2G5_PCS_FX100_CFG_LOOPBACK_ENA_GET(x)\
	FIELD_GET(DEV2G5_PCS_FX100_CFG_LOOPBACK_ENA, x)

#define DEV2G5_PCS_FX100_CFG_SWAP_MII_ENA        BIT(16)
#define DEV2G5_PCS_FX100_CFG_SWAP_MII_ENA_SET(x)\
	FIELD_PREP(DEV2G5_PCS_FX100_CFG_SWAP_MII_ENA, x)
#define DEV2G5_PCS_FX100_CFG_SWAP_MII_ENA_GET(x)\
	FIELD_GET(DEV2G5_PCS_FX100_CFG_SWAP_MII_ENA, x)

#define DEV2G5_PCS_FX100_CFG_RXBITSEL            GENMASK(15, 12)
#define DEV2G5_PCS_FX100_CFG_RXBITSEL_SET(x)\
	FIELD_PREP(DEV2G5_PCS_FX100_CFG_RXBITSEL, x)
#define DEV2G5_PCS_FX100_CFG_RXBITSEL_GET(x)\
	FIELD_GET(DEV2G5_PCS_FX100_CFG_RXBITSEL, x)

#define DEV2G5_PCS_FX100_CFG_SIGDET_CFG          GENMASK(10, 9)
#define DEV2G5_PCS_FX100_CFG_SIGDET_CFG_SET(x)\
	FIELD_PREP(DEV2G5_PCS_FX100_CFG_SIGDET_CFG, x)
#define DEV2G5_PCS_FX100_CFG_SIGDET_CFG_GET(x)\
	FIELD_GET(DEV2G5_PCS_FX100_CFG_SIGDET_CFG, x)

#define DEV2G5_PCS_FX100_CFG_LINKHYST_TM_ENA     BIT(8)
#define DEV2G5_PCS_FX100_CFG_LINKHYST_TM_ENA_SET(x)\
	FIELD_PREP(DEV2G5_PCS_FX100_CFG_LINKHYST_TM_ENA, x)
#define DEV2G5_PCS_FX100_CFG_LINKHYST_TM_ENA_GET(x)\
	FIELD_GET(DEV2G5_PCS_FX100_CFG_LINKHYST_TM_ENA, x)

#define DEV2G5_PCS_FX100_CFG_LINKHYSTTIMER       GENMASK(7, 4)
#define DEV2G5_PCS_FX100_CFG_LINKHYSTTIMER_SET(x)\
	FIELD_PREP(DEV2G5_PCS_FX100_CFG_LINKHYSTTIMER, x)
#define DEV2G5_PCS_FX100_CFG_LINKHYSTTIMER_GET(x)\
	FIELD_GET(DEV2G5_PCS_FX100_CFG_LINKHYSTTIMER, x)

#define DEV2G5_PCS_FX100_CFG_UNIDIR_MODE_ENA     BIT(3)
#define DEV2G5_PCS_FX100_CFG_UNIDIR_MODE_ENA_SET(x)\
	FIELD_PREP(DEV2G5_PCS_FX100_CFG_UNIDIR_MODE_ENA, x)
#define DEV2G5_PCS_FX100_CFG_UNIDIR_MODE_ENA_GET(x)\
	FIELD_GET(DEV2G5_PCS_FX100_CFG_UNIDIR_MODE_ENA, x)

#define DEV2G5_PCS_FX100_CFG_FEFCHK_ENA          BIT(2)
#define DEV2G5_PCS_FX100_CFG_FEFCHK_ENA_SET(x)\
	FIELD_PREP(DEV2G5_PCS_FX100_CFG_FEFCHK_ENA, x)
#define DEV2G5_PCS_FX100_CFG_FEFCHK_ENA_GET(x)\
	FIELD_GET(DEV2G5_PCS_FX100_CFG_FEFCHK_ENA, x)

#define DEV2G5_PCS_FX100_CFG_FEFGEN_ENA          BIT(1)
#define DEV2G5_PCS_FX100_CFG_FEFGEN_ENA_SET(x)\
	FIELD_PREP(DEV2G5_PCS_FX100_CFG_FEFGEN_ENA, x)
#define DEV2G5_PCS_FX100_CFG_FEFGEN_ENA_GET(x)\
	FIELD_GET(DEV2G5_PCS_FX100_CFG_FEFGEN_ENA, x)

#define DEV2G5_PCS_FX100_CFG_PCS_ENA             BIT(0)
#define DEV2G5_PCS_FX100_CFG_PCS_ENA_SET(x)\
	FIELD_PREP(DEV2G5_PCS_FX100_CFG_PCS_ENA, x)
#define DEV2G5_PCS_FX100_CFG_PCS_ENA_GET(x)\
	FIELD_GET(DEV2G5_PCS_FX100_CFG_PCS_ENA, x)

/*      DEV1G:PCS_FX100_STATUS:PCS_FX100_STATUS */
#define DEV2G5_PCS_FX100_STATUS(t) __REG(TARGET_DEV2G5,\
					t, 65, 168, 0, 1, 4, 0, 0, 1, 4)

#define DEV2G5_PCS_FX100_STATUS_EDGE_POS_PTP     GENMASK(11, 8)
#define DEV2G5_PCS_FX100_STATUS_EDGE_POS_PTP_SET(x)\
	FIELD_PREP(DEV2G5_PCS_FX100_STATUS_EDGE_POS_PTP, x)
#define DEV2G5_PCS_FX100_STATUS_EDGE_POS_PTP_GET(x)\
	FIELD_GET(DEV2G5_PCS_FX100_STATUS_EDGE_POS_PTP, x)

#define DEV2G5_PCS_FX100_STATUS_PCS_ERROR_STICKY BIT(7)
#define DEV2G5_PCS_FX100_STATUS_PCS_ERROR_STICKY_SET(x)\
	FIELD_PREP(DEV2G5_PCS_FX100_STATUS_PCS_ERROR_STICKY, x)
#define DEV2G5_PCS_FX100_STATUS_PCS_ERROR_STICKY_GET(x)\
	FIELD_GET(DEV2G5_PCS_FX100_STATUS_PCS_ERROR_STICKY, x)

#define DEV2G5_PCS_FX100_STATUS_FEF_FOUND_STICKY BIT(6)
#define DEV2G5_PCS_FX100_STATUS_FEF_FOUND_STICKY_SET(x)\
	FIELD_PREP(DEV2G5_PCS_FX100_STATUS_FEF_FOUND_STICKY, x)
#define DEV2G5_PCS_FX100_STATUS_FEF_FOUND_STICKY_GET(x)\
	FIELD_GET(DEV2G5_PCS_FX100_STATUS_FEF_FOUND_STICKY, x)

#define DEV2G5_PCS_FX100_STATUS_SSD_ERROR_STICKY BIT(5)
#define DEV2G5_PCS_FX100_STATUS_SSD_ERROR_STICKY_SET(x)\
	FIELD_PREP(DEV2G5_PCS_FX100_STATUS_SSD_ERROR_STICKY, x)
#define DEV2G5_PCS_FX100_STATUS_SSD_ERROR_STICKY_GET(x)\
	FIELD_GET(DEV2G5_PCS_FX100_STATUS_SSD_ERROR_STICKY, x)

#define DEV2G5_PCS_FX100_STATUS_SYNC_LOST_STICKY BIT(4)
#define DEV2G5_PCS_FX100_STATUS_SYNC_LOST_STICKY_SET(x)\
	FIELD_PREP(DEV2G5_PCS_FX100_STATUS_SYNC_LOST_STICKY, x)
#define DEV2G5_PCS_FX100_STATUS_SYNC_LOST_STICKY_GET(x)\
	FIELD_GET(DEV2G5_PCS_FX100_STATUS_SYNC_LOST_STICKY, x)

#define DEV2G5_PCS_FX100_STATUS_FEF_STATUS       BIT(2)
#define DEV2G5_PCS_FX100_STATUS_FEF_STATUS_SET(x)\
	FIELD_PREP(DEV2G5_PCS_FX100_STATUS_FEF_STATUS, x)
#define DEV2G5_PCS_FX100_STATUS_FEF_STATUS_GET(x)\
	FIELD_GET(DEV2G5_PCS_FX100_STATUS_FEF_STATUS, x)

#define DEV2G5_PCS_FX100_STATUS_SIGNAL_DETECT    BIT(1)
#define DEV2G5_PCS_FX100_STATUS_SIGNAL_DETECT_SET(x)\
	FIELD_PREP(DEV2G5_PCS_FX100_STATUS_SIGNAL_DETECT, x)
#define DEV2G5_PCS_FX100_STATUS_SIGNAL_DETECT_GET(x)\
	FIELD_GET(DEV2G5_PCS_FX100_STATUS_SIGNAL_DETECT, x)

#define DEV2G5_PCS_FX100_STATUS_SYNC_STATUS      BIT(0)
#define DEV2G5_PCS_FX100_STATUS_SYNC_STATUS_SET(x)\
	FIELD_PREP(DEV2G5_PCS_FX100_STATUS_SYNC_STATUS, x)
#define DEV2G5_PCS_FX100_STATUS_SYNC_STATUS_GET(x)\
	FIELD_GET(DEV2G5_PCS_FX100_STATUS_SYNC_STATUS, x)

/*      DEV10G:MAC_CFG_STATUS:MAC_ENA_CFG */
#define DEV5G_MAC_ENA_CFG(t)      __REG(TARGET_DEV5G,\
					t, 13, 0, 0, 1, 60, 0, 0, 1, 4)

#define DEV5G_MAC_ENA_CFG_RX_ENA                 BIT(4)
#define DEV5G_MAC_ENA_CFG_RX_ENA_SET(x)\
	FIELD_PREP(DEV5G_MAC_ENA_CFG_RX_ENA, x)
#define DEV5G_MAC_ENA_CFG_RX_ENA_GET(x)\
	FIELD_GET(DEV5G_MAC_ENA_CFG_RX_ENA, x)

#define DEV5G_MAC_ENA_CFG_TX_ENA                 BIT(0)
#define DEV5G_MAC_ENA_CFG_TX_ENA_SET(x)\
	FIELD_PREP(DEV5G_MAC_ENA_CFG_TX_ENA, x)
#define DEV5G_MAC_ENA_CFG_TX_ENA_GET(x)\
	FIELD_GET(DEV5G_MAC_ENA_CFG_TX_ENA, x)

/*      DEV10G:MAC_CFG_STATUS:MAC_MAXLEN_CFG */
#define DEV5G_MAC_MAXLEN_CFG(t)   __REG(TARGET_DEV5G,\
					t, 13, 0, 0, 1, 60, 8, 0, 1, 4)

#define DEV5G_MAC_MAXLEN_CFG_MAX_LEN_TAG_CHK     BIT(16)
#define DEV5G_MAC_MAXLEN_CFG_MAX_LEN_TAG_CHK_SET(x)\
	FIELD_PREP(DEV5G_MAC_MAXLEN_CFG_MAX_LEN_TAG_CHK, x)
#define DEV5G_MAC_MAXLEN_CFG_MAX_LEN_TAG_CHK_GET(x)\
	FIELD_GET(DEV5G_MAC_MAXLEN_CFG_MAX_LEN_TAG_CHK, x)

#define DEV5G_MAC_MAXLEN_CFG_MAX_LEN             GENMASK(15, 0)
#define DEV5G_MAC_MAXLEN_CFG_MAX_LEN_SET(x)\
	FIELD_PREP(DEV5G_MAC_MAXLEN_CFG_MAX_LEN, x)
#define DEV5G_MAC_MAXLEN_CFG_MAX_LEN_GET(x)\
	FIELD_GET(DEV5G_MAC_MAXLEN_CFG_MAX_LEN, x)

/*      DEV10G:MAC_CFG_STATUS:MAC_ADV_CHK_CFG */
#define DEV5G_MAC_ADV_CHK_CFG(t)  __REG(TARGET_DEV5G,\
					t, 13, 0, 0, 1, 60, 28, 0, 1, 4)

#define DEV5G_MAC_ADV_CHK_CFG_EXT_EOP_CHK_ENA    BIT(24)
#define DEV5G_MAC_ADV_CHK_CFG_EXT_EOP_CHK_ENA_SET(x)\
	FIELD_PREP(DEV5G_MAC_ADV_CHK_CFG_EXT_EOP_CHK_ENA, x)
#define DEV5G_MAC_ADV_CHK_CFG_EXT_EOP_CHK_ENA_GET(x)\
	FIELD_GET(DEV5G_MAC_ADV_CHK_CFG_EXT_EOP_CHK_ENA, x)

#define DEV5G_MAC_ADV_CHK_CFG_EXT_SOP_CHK_ENA    BIT(20)
#define DEV5G_MAC_ADV_CHK_CFG_EXT_SOP_CHK_ENA_SET(x)\
	FIELD_PREP(DEV5G_MAC_ADV_CHK_CFG_EXT_SOP_CHK_ENA, x)
#define DEV5G_MAC_ADV_CHK_CFG_EXT_SOP_CHK_ENA_GET(x)\
	FIELD_GET(DEV5G_MAC_ADV_CHK_CFG_EXT_SOP_CHK_ENA, x)

#define DEV5G_MAC_ADV_CHK_CFG_SFD_CHK_ENA        BIT(16)
#define DEV5G_MAC_ADV_CHK_CFG_SFD_CHK_ENA_SET(x)\
	FIELD_PREP(DEV5G_MAC_ADV_CHK_CFG_SFD_CHK_ENA, x)
#define DEV5G_MAC_ADV_CHK_CFG_SFD_CHK_ENA_GET(x)\
	FIELD_GET(DEV5G_MAC_ADV_CHK_CFG_SFD_CHK_ENA, x)

#define DEV5G_MAC_ADV_CHK_CFG_PRM_SHK_CHK_DIS    BIT(12)
#define DEV5G_MAC_ADV_CHK_CFG_PRM_SHK_CHK_DIS_SET(x)\
	FIELD_PREP(DEV5G_MAC_ADV_CHK_CFG_PRM_SHK_CHK_DIS, x)
#define DEV5G_MAC_ADV_CHK_CFG_PRM_SHK_CHK_DIS_GET(x)\
	FIELD_GET(DEV5G_MAC_ADV_CHK_CFG_PRM_SHK_CHK_DIS, x)

#define DEV5G_MAC_ADV_CHK_CFG_PRM_CHK_ENA        BIT(8)
#define DEV5G_MAC_ADV_CHK_CFG_PRM_CHK_ENA_SET(x)\
	FIELD_PREP(DEV5G_MAC_ADV_CHK_CFG_PRM_CHK_ENA, x)
#define DEV5G_MAC_ADV_CHK_CFG_PRM_CHK_ENA_GET(x)\
	FIELD_GET(DEV5G_MAC_ADV_CHK_CFG_PRM_CHK_ENA, x)

#define DEV5G_MAC_ADV_CHK_CFG_OOR_ERR_ENA        BIT(4)
#define DEV5G_MAC_ADV_CHK_CFG_OOR_ERR_ENA_SET(x)\
	FIELD_PREP(DEV5G_MAC_ADV_CHK_CFG_OOR_ERR_ENA, x)
#define DEV5G_MAC_ADV_CHK_CFG_OOR_ERR_ENA_GET(x)\
	FIELD_GET(DEV5G_MAC_ADV_CHK_CFG_OOR_ERR_ENA, x)

#define DEV5G_MAC_ADV_CHK_CFG_INR_ERR_ENA        BIT(0)
#define DEV5G_MAC_ADV_CHK_CFG_INR_ERR_ENA_SET(x)\
	FIELD_PREP(DEV5G_MAC_ADV_CHK_CFG_INR_ERR_ENA, x)
#define DEV5G_MAC_ADV_CHK_CFG_INR_ERR_ENA_GET(x)\
	FIELD_GET(DEV5G_MAC_ADV_CHK_CFG_INR_ERR_ENA, x)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_SYMBOL_ERR_CNT */
#define DEV5G_RX_SYMBOL_ERR_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 0, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_PAUSE_CNT */
#define DEV5G_RX_PAUSE_CNT(t)     __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 4, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_UNSUP_OPCODE_CNT */
#define DEV5G_RX_UNSUP_OPCODE_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 8, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_UC_CNT */
#define DEV5G_RX_UC_CNT(t)        __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 12, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_MC_CNT */
#define DEV5G_RX_MC_CNT(t)        __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 16, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_BC_CNT */
#define DEV5G_RX_BC_CNT(t)        __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 20, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_CRC_ERR_CNT */
#define DEV5G_RX_CRC_ERR_CNT(t)   __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 24, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_UNDERSIZE_CNT */
#define DEV5G_RX_UNDERSIZE_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 28, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_FRAGMENTS_CNT */
#define DEV5G_RX_FRAGMENTS_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 32, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_IN_RANGE_LEN_ERR_CNT */
#define DEV5G_RX_IN_RANGE_LEN_ERR_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 36, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_OUT_OF_RANGE_LEN_ERR_CNT */
#define DEV5G_RX_OUT_OF_RANGE_LEN_ERR_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 40, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_OVERSIZE_CNT */
#define DEV5G_RX_OVERSIZE_CNT(t)  __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 44, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_JABBERS_CNT */
#define DEV5G_RX_JABBERS_CNT(t)   __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 48, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_SIZE64_CNT */
#define DEV5G_RX_SIZE64_CNT(t)    __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 52, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_SIZE65TO127_CNT */
#define DEV5G_RX_SIZE65TO127_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 56, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_SIZE128TO255_CNT */
#define DEV5G_RX_SIZE128TO255_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 60, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_SIZE256TO511_CNT */
#define DEV5G_RX_SIZE256TO511_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 64, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_SIZE512TO1023_CNT */
#define DEV5G_RX_SIZE512TO1023_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 68, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_SIZE1024TO1518_CNT */
#define DEV5G_RX_SIZE1024TO1518_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 72, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_SIZE1519TOMAX_CNT */
#define DEV5G_RX_SIZE1519TOMAX_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 76, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_IPG_SHRINK_CNT */
#define DEV5G_RX_IPG_SHRINK_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 80, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:TX_PAUSE_CNT */
#define DEV5G_TX_PAUSE_CNT(t)     __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 84, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:TX_UC_CNT */
#define DEV5G_TX_UC_CNT(t)        __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 88, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:TX_MC_CNT */
#define DEV5G_TX_MC_CNT(t)        __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 92, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:TX_BC_CNT */
#define DEV5G_TX_BC_CNT(t)        __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 96, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:TX_SIZE64_CNT */
#define DEV5G_TX_SIZE64_CNT(t)    __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 100, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:TX_SIZE65TO127_CNT */
#define DEV5G_TX_SIZE65TO127_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 104, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:TX_SIZE128TO255_CNT */
#define DEV5G_TX_SIZE128TO255_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 108, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:TX_SIZE256TO511_CNT */
#define DEV5G_TX_SIZE256TO511_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 112, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:TX_SIZE512TO1023_CNT */
#define DEV5G_TX_SIZE512TO1023_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 116, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:TX_SIZE1024TO1518_CNT */
#define DEV5G_TX_SIZE1024TO1518_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 120, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:TX_SIZE1519TOMAX_CNT */
#define DEV5G_TX_SIZE1519TOMAX_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 124, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_ALIGNMENT_LOST_CNT */
#define DEV5G_RX_ALIGNMENT_LOST_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 128, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_TAGGED_FRMS_CNT */
#define DEV5G_RX_TAGGED_FRMS_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 132, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_UNTAGGED_FRMS_CNT */
#define DEV5G_RX_UNTAGGED_FRMS_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 136, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:TX_TAGGED_FRMS_CNT */
#define DEV5G_TX_TAGGED_FRMS_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 140, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:TX_UNTAGGED_FRMS_CNT */
#define DEV5G_TX_UNTAGGED_FRMS_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 144, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_SYMBOL_ERR_CNT */
#define DEV5G_PMAC_RX_SYMBOL_ERR_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 148, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_PAUSE_CNT */
#define DEV5G_PMAC_RX_PAUSE_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 152, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_UNSUP_OPCODE_CNT */
#define DEV5G_PMAC_RX_UNSUP_OPCODE_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 156, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_UC_CNT */
#define DEV5G_PMAC_RX_UC_CNT(t)   __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 160, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_MC_CNT */
#define DEV5G_PMAC_RX_MC_CNT(t)   __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 164, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_BC_CNT */
#define DEV5G_PMAC_RX_BC_CNT(t)   __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 168, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_CRC_ERR_CNT */
#define DEV5G_PMAC_RX_CRC_ERR_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 172, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_UNDERSIZE_CNT */
#define DEV5G_PMAC_RX_UNDERSIZE_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 176, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_FRAGMENTS_CNT */
#define DEV5G_PMAC_RX_FRAGMENTS_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 180, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_IN_RANGE_LEN_ERR_CNT */
#define DEV5G_PMAC_RX_IN_RANGE_LEN_ERR_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 184, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_OUT_OF_RANGE_LEN_ERR_CNT */
#define DEV5G_PMAC_RX_OUT_OF_RANGE_LEN_ERR_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 188, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_OVERSIZE_CNT */
#define DEV5G_PMAC_RX_OVERSIZE_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 192, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_JABBERS_CNT */
#define DEV5G_PMAC_RX_JABBERS_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 196, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_SIZE64_CNT */
#define DEV5G_PMAC_RX_SIZE64_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 200, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_SIZE65TO127_CNT */
#define DEV5G_PMAC_RX_SIZE65TO127_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 204, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_SIZE128TO255_CNT */
#define DEV5G_PMAC_RX_SIZE128TO255_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 208, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_SIZE256TO511_CNT */
#define DEV5G_PMAC_RX_SIZE256TO511_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 212, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_SIZE512TO1023_CNT */
#define DEV5G_PMAC_RX_SIZE512TO1023_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 216, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_SIZE1024TO1518_CNT */
#define DEV5G_PMAC_RX_SIZE1024TO1518_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 220, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_SIZE1519TOMAX_CNT */
#define DEV5G_PMAC_RX_SIZE1519TOMAX_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 224, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_TX_PAUSE_CNT */
#define DEV5G_PMAC_TX_PAUSE_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 228, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_TX_UC_CNT */
#define DEV5G_PMAC_TX_UC_CNT(t)   __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 232, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_TX_MC_CNT */
#define DEV5G_PMAC_TX_MC_CNT(t)   __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 236, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_TX_BC_CNT */
#define DEV5G_PMAC_TX_BC_CNT(t)   __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 240, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_TX_SIZE64_CNT */
#define DEV5G_PMAC_TX_SIZE64_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 244, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_TX_SIZE65TO127_CNT */
#define DEV5G_PMAC_TX_SIZE65TO127_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 248, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_TX_SIZE128TO255_CNT */
#define DEV5G_PMAC_TX_SIZE128TO255_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 252, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_TX_SIZE256TO511_CNT */
#define DEV5G_PMAC_TX_SIZE256TO511_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 256, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_TX_SIZE512TO1023_CNT */
#define DEV5G_PMAC_TX_SIZE512TO1023_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 260, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_TX_SIZE1024TO1518_CNT */
#define DEV5G_PMAC_TX_SIZE1024TO1518_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 264, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_TX_SIZE1519TOMAX_CNT */
#define DEV5G_PMAC_TX_SIZE1519TOMAX_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 268, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_ALIGNMENT_LOST_CNT */
#define DEV5G_PMAC_RX_ALIGNMENT_LOST_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 272, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:MM_RX_ASSEMBLY_ERR_CNT */
#define DEV5G_MM_RX_ASSEMBLY_ERR_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 276, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:MM_RX_SMD_ERR_CNT */
#define DEV5G_MM_RX_SMD_ERR_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 280, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:MM_RX_ASSEMBLY_OK_CNT */
#define DEV5G_MM_RX_ASSEMBLY_OK_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 284, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:MM_RX_MERGE_FRAG_CNT */
#define DEV5G_MM_RX_MERGE_FRAG_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 288, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:MM_TX_PFRAGMENT_CNT */
#define DEV5G_MM_TX_PFRAGMENT_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 292, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_HIH_CKSM_ERR_CNT */
#define DEV5G_RX_HIH_CKSM_ERR_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 296, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:RX_XGMII_PROT_ERR_CNT */
#define DEV5G_RX_XGMII_PROT_ERR_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 300, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_HIH_CKSM_ERR_CNT */
#define DEV5G_PMAC_RX_HIH_CKSM_ERR_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 304, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_32BIT:PMAC_RX_XGMII_PROT_ERR_CNT */
#define DEV5G_PMAC_RX_XGMII_PROT_ERR_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 60, 0, 1, 312, 308, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_40BIT:RX_IN_BYTES_CNT */
#define DEV5G_RX_IN_BYTES_CNT(t)  __REG(TARGET_DEV5G,\
					t, 13, 372, 0, 1, 64, 0, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_40BIT:RX_IN_BYTES_MSB_CNT */
#define DEV5G_RX_IN_BYTES_MSB_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 372, 0, 1, 64, 4, 0, 1, 4)

#define DEV5G_RX_IN_BYTES_MSB_CNT_RX_IN_BYTES_MSB_CNT GENMASK(7, 0)
#define DEV5G_RX_IN_BYTES_MSB_CNT_RX_IN_BYTES_MSB_CNT_SET(x)\
	FIELD_PREP(DEV5G_RX_IN_BYTES_MSB_CNT_RX_IN_BYTES_MSB_CNT, x)
#define DEV5G_RX_IN_BYTES_MSB_CNT_RX_IN_BYTES_MSB_CNT_GET(x)\
	FIELD_GET(DEV5G_RX_IN_BYTES_MSB_CNT_RX_IN_BYTES_MSB_CNT, x)

/*      DEV10G:DEV_STATISTICS_40BIT:RX_OK_BYTES_CNT */
#define DEV5G_RX_OK_BYTES_CNT(t)  __REG(TARGET_DEV5G,\
					t, 13, 372, 0, 1, 64, 8, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_40BIT:RX_OK_BYTES_MSB_CNT */
#define DEV5G_RX_OK_BYTES_MSB_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 372, 0, 1, 64, 12, 0, 1, 4)

#define DEV5G_RX_OK_BYTES_MSB_CNT_RX_OK_BYTES_MSB_CNT GENMASK(7, 0)
#define DEV5G_RX_OK_BYTES_MSB_CNT_RX_OK_BYTES_MSB_CNT_SET(x)\
	FIELD_PREP(DEV5G_RX_OK_BYTES_MSB_CNT_RX_OK_BYTES_MSB_CNT, x)
#define DEV5G_RX_OK_BYTES_MSB_CNT_RX_OK_BYTES_MSB_CNT_GET(x)\
	FIELD_GET(DEV5G_RX_OK_BYTES_MSB_CNT_RX_OK_BYTES_MSB_CNT, x)

/*      DEV10G:DEV_STATISTICS_40BIT:RX_BAD_BYTES_CNT */
#define DEV5G_RX_BAD_BYTES_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 372, 0, 1, 64, 16, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_40BIT:RX_BAD_BYTES_MSB_CNT */
#define DEV5G_RX_BAD_BYTES_MSB_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 372, 0, 1, 64, 20, 0, 1, 4)

#define DEV5G_RX_BAD_BYTES_MSB_CNT_RX_BAD_BYTES_MSB_CNT GENMASK(7, 0)
#define DEV5G_RX_BAD_BYTES_MSB_CNT_RX_BAD_BYTES_MSB_CNT_SET(x)\
	FIELD_PREP(DEV5G_RX_BAD_BYTES_MSB_CNT_RX_BAD_BYTES_MSB_CNT, x)
#define DEV5G_RX_BAD_BYTES_MSB_CNT_RX_BAD_BYTES_MSB_CNT_GET(x)\
	FIELD_GET(DEV5G_RX_BAD_BYTES_MSB_CNT_RX_BAD_BYTES_MSB_CNT, x)

/*      DEV10G:DEV_STATISTICS_40BIT:TX_OUT_BYTES_CNT */
#define DEV5G_TX_OUT_BYTES_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 372, 0, 1, 64, 24, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_40BIT:TX_OUT_BYTES_MSB_CNT */
#define DEV5G_TX_OUT_BYTES_MSB_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 372, 0, 1, 64, 28, 0, 1, 4)

#define DEV5G_TX_OUT_BYTES_MSB_CNT_TX_OUT_BYTES_MSB_CNT GENMASK(7, 0)
#define DEV5G_TX_OUT_BYTES_MSB_CNT_TX_OUT_BYTES_MSB_CNT_SET(x)\
	FIELD_PREP(DEV5G_TX_OUT_BYTES_MSB_CNT_TX_OUT_BYTES_MSB_CNT, x)
#define DEV5G_TX_OUT_BYTES_MSB_CNT_TX_OUT_BYTES_MSB_CNT_GET(x)\
	FIELD_GET(DEV5G_TX_OUT_BYTES_MSB_CNT_TX_OUT_BYTES_MSB_CNT, x)

/*      DEV10G:DEV_STATISTICS_40BIT:TX_OK_BYTES_CNT */
#define DEV5G_TX_OK_BYTES_CNT(t)  __REG(TARGET_DEV5G,\
					t, 13, 372, 0, 1, 64, 32, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_40BIT:TX_OK_BYTES_MSB_CNT */
#define DEV5G_TX_OK_BYTES_MSB_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 372, 0, 1, 64, 36, 0, 1, 4)

#define DEV5G_TX_OK_BYTES_MSB_CNT_TX_OK_BYTES_MSB_CNT GENMASK(7, 0)
#define DEV5G_TX_OK_BYTES_MSB_CNT_TX_OK_BYTES_MSB_CNT_SET(x)\
	FIELD_PREP(DEV5G_TX_OK_BYTES_MSB_CNT_TX_OK_BYTES_MSB_CNT, x)
#define DEV5G_TX_OK_BYTES_MSB_CNT_TX_OK_BYTES_MSB_CNT_GET(x)\
	FIELD_GET(DEV5G_TX_OK_BYTES_MSB_CNT_TX_OK_BYTES_MSB_CNT, x)

/*      DEV10G:DEV_STATISTICS_40BIT:PMAC_RX_OK_BYTES_CNT */
#define DEV5G_PMAC_RX_OK_BYTES_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 372, 0, 1, 64, 40, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_40BIT:PMAC_RX_OK_BYTES_MSB_CNT */
#define DEV5G_PMAC_RX_OK_BYTES_MSB_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 372, 0, 1, 64, 44, 0, 1, 4)

#define DEV5G_PMAC_RX_OK_BYTES_MSB_CNT_PMAC_RX_OK_BYTES_MSB_CNT GENMASK(7, 0)
#define DEV5G_PMAC_RX_OK_BYTES_MSB_CNT_PMAC_RX_OK_BYTES_MSB_CNT_SET(x)\
	FIELD_PREP(DEV5G_PMAC_RX_OK_BYTES_MSB_CNT_PMAC_RX_OK_BYTES_MSB_CNT, x)
#define DEV5G_PMAC_RX_OK_BYTES_MSB_CNT_PMAC_RX_OK_BYTES_MSB_CNT_GET(x)\
	FIELD_GET(DEV5G_PMAC_RX_OK_BYTES_MSB_CNT_PMAC_RX_OK_BYTES_MSB_CNT, x)

/*      DEV10G:DEV_STATISTICS_40BIT:PMAC_RX_BAD_BYTES_CNT */
#define DEV5G_PMAC_RX_BAD_BYTES_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 372, 0, 1, 64, 48, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_40BIT:PMAC_RX_BAD_BYTES_MSB_CNT */
#define DEV5G_PMAC_RX_BAD_BYTES_MSB_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 372, 0, 1, 64, 52, 0, 1, 4)

#define DEV5G_PMAC_RX_BAD_BYTES_MSB_CNT_PMAC_RX_BAD_BYTES_MSB_CNT GENMASK(7, 0)
#define DEV5G_PMAC_RX_BAD_BYTES_MSB_CNT_PMAC_RX_BAD_BYTES_MSB_CNT_SET(x)\
	FIELD_PREP(DEV5G_PMAC_RX_BAD_BYTES_MSB_CNT_PMAC_RX_BAD_BYTES_MSB_CNT, x)
#define DEV5G_PMAC_RX_BAD_BYTES_MSB_CNT_PMAC_RX_BAD_BYTES_MSB_CNT_GET(x)\
	FIELD_GET(DEV5G_PMAC_RX_BAD_BYTES_MSB_CNT_PMAC_RX_BAD_BYTES_MSB_CNT, x)

/*      DEV10G:DEV_STATISTICS_40BIT:PMAC_TX_OK_BYTES_CNT */
#define DEV5G_PMAC_TX_OK_BYTES_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 372, 0, 1, 64, 56, 0, 1, 4)

/*      DEV10G:DEV_STATISTICS_40BIT:PMAC_TX_OK_BYTES_MSB_CNT */
#define DEV5G_PMAC_TX_OK_BYTES_MSB_CNT(t) __REG(TARGET_DEV5G,\
					t, 13, 372, 0, 1, 64, 60, 0, 1, 4)

#define DEV5G_PMAC_TX_OK_BYTES_MSB_CNT_PMAC_TX_OK_BYTES_MSB_CNT GENMASK(7, 0)
#define DEV5G_PMAC_TX_OK_BYTES_MSB_CNT_PMAC_TX_OK_BYTES_MSB_CNT_SET(x)\
	FIELD_PREP(DEV5G_PMAC_TX_OK_BYTES_MSB_CNT_PMAC_TX_OK_BYTES_MSB_CNT, x)
#define DEV5G_PMAC_TX_OK_BYTES_MSB_CNT_PMAC_TX_OK_BYTES_MSB_CNT_GET(x)\
	FIELD_GET(DEV5G_PMAC_TX_OK_BYTES_MSB_CNT_PMAC_TX_OK_BYTES_MSB_CNT, x)

/*      DEV10G:DEV_CFG_STATUS:DEV_RST_CTRL */
#define DEV5G_DEV_RST_CTRL(t)     __REG(TARGET_DEV5G,\
					t, 13, 436, 0, 1, 52, 0, 0, 1, 4)

#define DEV5G_DEV_RST_CTRL_PARDET_MODE_ENA       BIT(28)
#define DEV5G_DEV_RST_CTRL_PARDET_MODE_ENA_SET(x)\
	FIELD_PREP(DEV5G_DEV_RST_CTRL_PARDET_MODE_ENA, x)
#define DEV5G_DEV_RST_CTRL_PARDET_MODE_ENA_GET(x)\
	FIELD_GET(DEV5G_DEV_RST_CTRL_PARDET_MODE_ENA, x)

#define DEV5G_DEV_RST_CTRL_USXGMII_OSET_FILTER_DIS BIT(27)
#define DEV5G_DEV_RST_CTRL_USXGMII_OSET_FILTER_DIS_SET(x)\
	FIELD_PREP(DEV5G_DEV_RST_CTRL_USXGMII_OSET_FILTER_DIS, x)
#define DEV5G_DEV_RST_CTRL_USXGMII_OSET_FILTER_DIS_GET(x)\
	FIELD_GET(DEV5G_DEV_RST_CTRL_USXGMII_OSET_FILTER_DIS, x)

#define DEV5G_DEV_RST_CTRL_MUXED_USXGMII_NETWORK_PORTS GENMASK(26, 25)
#define DEV5G_DEV_RST_CTRL_MUXED_USXGMII_NETWORK_PORTS_SET(x)\
	FIELD_PREP(DEV5G_DEV_RST_CTRL_MUXED_USXGMII_NETWORK_PORTS, x)
#define DEV5G_DEV_RST_CTRL_MUXED_USXGMII_NETWORK_PORTS_GET(x)\
	FIELD_GET(DEV5G_DEV_RST_CTRL_MUXED_USXGMII_NETWORK_PORTS, x)

#define DEV5G_DEV_RST_CTRL_SERDES_SPEED_SEL      GENMASK(24, 23)
#define DEV5G_DEV_RST_CTRL_SERDES_SPEED_SEL_SET(x)\
	FIELD_PREP(DEV5G_DEV_RST_CTRL_SERDES_SPEED_SEL, x)
#define DEV5G_DEV_RST_CTRL_SERDES_SPEED_SEL_GET(x)\
	FIELD_GET(DEV5G_DEV_RST_CTRL_SERDES_SPEED_SEL, x)

#define DEV5G_DEV_RST_CTRL_SPEED_SEL             GENMASK(22, 20)
#define DEV5G_DEV_RST_CTRL_SPEED_SEL_SET(x)\
	FIELD_PREP(DEV5G_DEV_RST_CTRL_SPEED_SEL, x)
#define DEV5G_DEV_RST_CTRL_SPEED_SEL_GET(x)\
	FIELD_GET(DEV5G_DEV_RST_CTRL_SPEED_SEL, x)

#define DEV5G_DEV_RST_CTRL_PCS_TX_RST            BIT(12)
#define DEV5G_DEV_RST_CTRL_PCS_TX_RST_SET(x)\
	FIELD_PREP(DEV5G_DEV_RST_CTRL_PCS_TX_RST, x)
#define DEV5G_DEV_RST_CTRL_PCS_TX_RST_GET(x)\
	FIELD_GET(DEV5G_DEV_RST_CTRL_PCS_TX_RST, x)

#define DEV5G_DEV_RST_CTRL_PCS_RX_RST            BIT(8)
#define DEV5G_DEV_RST_CTRL_PCS_RX_RST_SET(x)\
	FIELD_PREP(DEV5G_DEV_RST_CTRL_PCS_RX_RST, x)
#define DEV5G_DEV_RST_CTRL_PCS_RX_RST_GET(x)\
	FIELD_GET(DEV5G_DEV_RST_CTRL_PCS_RX_RST, x)

#define DEV5G_DEV_RST_CTRL_MAC_TX_RST            BIT(4)
#define DEV5G_DEV_RST_CTRL_MAC_TX_RST_SET(x)\
	FIELD_PREP(DEV5G_DEV_RST_CTRL_MAC_TX_RST, x)
#define DEV5G_DEV_RST_CTRL_MAC_TX_RST_GET(x)\
	FIELD_GET(DEV5G_DEV_RST_CTRL_MAC_TX_RST, x)

#define DEV5G_DEV_RST_CTRL_MAC_RX_RST            BIT(0)
#define DEV5G_DEV_RST_CTRL_MAC_RX_RST_SET(x)\
	FIELD_PREP(DEV5G_DEV_RST_CTRL_MAC_RX_RST, x)
#define DEV5G_DEV_RST_CTRL_MAC_RX_RST_GET(x)\
	FIELD_GET(DEV5G_DEV_RST_CTRL_MAC_RX_RST, x)

/*      DSM:RAM_CTRL:RAM_INIT */
#define DSM_RAM_INIT              __REG(TARGET_DSM,\
					0, 1, 0, 0, 1, 4, 0, 0, 1, 4)

#define DSM_RAM_INIT_RAM_INIT                    BIT(1)
#define DSM_RAM_INIT_RAM_INIT_SET(x)\
	FIELD_PREP(DSM_RAM_INIT_RAM_INIT, x)
#define DSM_RAM_INIT_RAM_INIT_GET(x)\
	FIELD_GET(DSM_RAM_INIT_RAM_INIT, x)

#define DSM_RAM_INIT_RAM_CFG_HOOK                BIT(0)
#define DSM_RAM_INIT_RAM_CFG_HOOK_SET(x)\
	FIELD_PREP(DSM_RAM_INIT_RAM_CFG_HOOK, x)
#define DSM_RAM_INIT_RAM_CFG_HOOK_GET(x)\
	FIELD_GET(DSM_RAM_INIT_RAM_CFG_HOOK, x)

/*      DSM:CFG:BUF_CFG */
#define DSM_BUF_CFG(r)            __REG(TARGET_DSM,\
					0, 1, 20, 0, 1, 3528, 0, r, 67, 4)

#define DSM_BUF_CFG_CSC_STAT_DIS                 BIT(13)
#define DSM_BUF_CFG_CSC_STAT_DIS_SET(x)\
	FIELD_PREP(DSM_BUF_CFG_CSC_STAT_DIS, x)
#define DSM_BUF_CFG_CSC_STAT_DIS_GET(x)\
	FIELD_GET(DSM_BUF_CFG_CSC_STAT_DIS, x)

#define DSM_BUF_CFG_AGING_ENA                    BIT(12)
#define DSM_BUF_CFG_AGING_ENA_SET(x)\
	FIELD_PREP(DSM_BUF_CFG_AGING_ENA, x)
#define DSM_BUF_CFG_AGING_ENA_GET(x)\
	FIELD_GET(DSM_BUF_CFG_AGING_ENA, x)

#define DSM_BUF_CFG_UNDERFLOW_WATCHDOG_DIS       BIT(11)
#define DSM_BUF_CFG_UNDERFLOW_WATCHDOG_DIS_SET(x)\
	FIELD_PREP(DSM_BUF_CFG_UNDERFLOW_WATCHDOG_DIS, x)
#define DSM_BUF_CFG_UNDERFLOW_WATCHDOG_DIS_GET(x)\
	FIELD_GET(DSM_BUF_CFG_UNDERFLOW_WATCHDOG_DIS, x)

#define DSM_BUF_CFG_UNDERFLOW_WATCHDOG_TIMEOUT   GENMASK(10, 0)
#define DSM_BUF_CFG_UNDERFLOW_WATCHDOG_TIMEOUT_SET(x)\
	FIELD_PREP(DSM_BUF_CFG_UNDERFLOW_WATCHDOG_TIMEOUT, x)
#define DSM_BUF_CFG_UNDERFLOW_WATCHDOG_TIMEOUT_GET(x)\
	FIELD_GET(DSM_BUF_CFG_UNDERFLOW_WATCHDOG_TIMEOUT, x)

/*      DSM:CFG:DEV_TX_STOP_WM_CFG */
#define DSM_DEV_TX_STOP_WM_CFG(r) __REG(TARGET_DSM,\
					0, 1, 20, 0, 1, 3528, 1360, r, 67, 4)

#define DSM_DEV_TX_STOP_WM_CFG_FAST_STARTUP_ENA  BIT(9)
#define DSM_DEV_TX_STOP_WM_CFG_FAST_STARTUP_ENA_SET(x)\
	FIELD_PREP(DSM_DEV_TX_STOP_WM_CFG_FAST_STARTUP_ENA, x)
#define DSM_DEV_TX_STOP_WM_CFG_FAST_STARTUP_ENA_GET(x)\
	FIELD_GET(DSM_DEV_TX_STOP_WM_CFG_FAST_STARTUP_ENA, x)

#define DSM_DEV_TX_STOP_WM_CFG_DEV10G_SHADOW_ENA BIT(8)
#define DSM_DEV_TX_STOP_WM_CFG_DEV10G_SHADOW_ENA_SET(x)\
	FIELD_PREP(DSM_DEV_TX_STOP_WM_CFG_DEV10G_SHADOW_ENA, x)
#define DSM_DEV_TX_STOP_WM_CFG_DEV10G_SHADOW_ENA_GET(x)\
	FIELD_GET(DSM_DEV_TX_STOP_WM_CFG_DEV10G_SHADOW_ENA, x)

#define DSM_DEV_TX_STOP_WM_CFG_DEV_TX_STOP_WM    GENMASK(7, 1)
#define DSM_DEV_TX_STOP_WM_CFG_DEV_TX_STOP_WM_SET(x)\
	FIELD_PREP(DSM_DEV_TX_STOP_WM_CFG_DEV_TX_STOP_WM, x)
#define DSM_DEV_TX_STOP_WM_CFG_DEV_TX_STOP_WM_GET(x)\
	FIELD_GET(DSM_DEV_TX_STOP_WM_CFG_DEV_TX_STOP_WM, x)

#define DSM_DEV_TX_STOP_WM_CFG_DEV_TX_CNT_CLR    BIT(0)
#define DSM_DEV_TX_STOP_WM_CFG_DEV_TX_CNT_CLR_SET(x)\
	FIELD_PREP(DSM_DEV_TX_STOP_WM_CFG_DEV_TX_CNT_CLR, x)
#define DSM_DEV_TX_STOP_WM_CFG_DEV_TX_CNT_CLR_GET(x)\
	FIELD_GET(DSM_DEV_TX_STOP_WM_CFG_DEV_TX_CNT_CLR, x)

/*      DSM:CFG:RX_PAUSE_CFG */
#define DSM_RX_PAUSE_CFG(r)       __REG(TARGET_DSM,\
					0, 1, 20, 0, 1, 3528, 1628, r, 67, 4)

#define DSM_RX_PAUSE_CFG_RX_PAUSE_EN             BIT(1)
#define DSM_RX_PAUSE_CFG_RX_PAUSE_EN_SET(x)\
	FIELD_PREP(DSM_RX_PAUSE_CFG_RX_PAUSE_EN, x)
#define DSM_RX_PAUSE_CFG_RX_PAUSE_EN_GET(x)\
	FIELD_GET(DSM_RX_PAUSE_CFG_RX_PAUSE_EN, x)

#define DSM_RX_PAUSE_CFG_FC_OBEY_LOCAL           BIT(0)
#define DSM_RX_PAUSE_CFG_FC_OBEY_LOCAL_SET(x)\
	FIELD_PREP(DSM_RX_PAUSE_CFG_FC_OBEY_LOCAL, x)
#define DSM_RX_PAUSE_CFG_FC_OBEY_LOCAL_GET(x)\
	FIELD_GET(DSM_RX_PAUSE_CFG_FC_OBEY_LOCAL, x)

/*      DSM:CFG:MAC_CFG */
#define DSM_MAC_CFG(r)            __REG(TARGET_DSM,\
					0, 1, 20, 0, 1, 3528, 2432, r, 67, 4)

#define DSM_MAC_CFG_TX_PAUSE_VAL                 GENMASK(31, 16)
#define DSM_MAC_CFG_TX_PAUSE_VAL_SET(x)\
	FIELD_PREP(DSM_MAC_CFG_TX_PAUSE_VAL, x)
#define DSM_MAC_CFG_TX_PAUSE_VAL_GET(x)\
	FIELD_GET(DSM_MAC_CFG_TX_PAUSE_VAL, x)

#define DSM_MAC_CFG_HDX_BACKPREASSURE            BIT(2)
#define DSM_MAC_CFG_HDX_BACKPREASSURE_SET(x)\
	FIELD_PREP(DSM_MAC_CFG_HDX_BACKPREASSURE, x)
#define DSM_MAC_CFG_HDX_BACKPREASSURE_GET(x)\
	FIELD_GET(DSM_MAC_CFG_HDX_BACKPREASSURE, x)

#define DSM_MAC_CFG_SEND_PAUSE_FRM_TWICE         BIT(1)
#define DSM_MAC_CFG_SEND_PAUSE_FRM_TWICE_SET(x)\
	FIELD_PREP(DSM_MAC_CFG_SEND_PAUSE_FRM_TWICE, x)
#define DSM_MAC_CFG_SEND_PAUSE_FRM_TWICE_GET(x)\
	FIELD_GET(DSM_MAC_CFG_SEND_PAUSE_FRM_TWICE, x)

#define DSM_MAC_CFG_TX_PAUSE_XON_XOFF            BIT(0)
#define DSM_MAC_CFG_TX_PAUSE_XON_XOFF_SET(x)\
	FIELD_PREP(DSM_MAC_CFG_TX_PAUSE_XON_XOFF, x)
#define DSM_MAC_CFG_TX_PAUSE_XON_XOFF_GET(x)\
	FIELD_GET(DSM_MAC_CFG_TX_PAUSE_XON_XOFF, x)

/*      DSM:CFG:MAC_ADDR_BASE_HIGH_CFG */
#define DSM_MAC_ADDR_BASE_HIGH_CFG(r) __REG(TARGET_DSM,\
					0, 1, 20, 0, 1, 3528, 2700, r, 65, 4)

#define DSM_MAC_ADDR_BASE_HIGH_CFG_MAC_ADDR_HIGH GENMASK(23, 0)
#define DSM_MAC_ADDR_BASE_HIGH_CFG_MAC_ADDR_HIGH_SET(x)\
	FIELD_PREP(DSM_MAC_ADDR_BASE_HIGH_CFG_MAC_ADDR_HIGH, x)
#define DSM_MAC_ADDR_BASE_HIGH_CFG_MAC_ADDR_HIGH_GET(x)\
	FIELD_GET(DSM_MAC_ADDR_BASE_HIGH_CFG_MAC_ADDR_HIGH, x)

/*      DSM:CFG:MAC_ADDR_BASE_LOW_CFG */
#define DSM_MAC_ADDR_BASE_LOW_CFG(r) __REG(TARGET_DSM,\
					0, 1, 20, 0, 1, 3528, 2960, r, 65, 4)

#define DSM_MAC_ADDR_BASE_LOW_CFG_MAC_ADDR_LOW   GENMASK(23, 0)
#define DSM_MAC_ADDR_BASE_LOW_CFG_MAC_ADDR_LOW_SET(x)\
	FIELD_PREP(DSM_MAC_ADDR_BASE_LOW_CFG_MAC_ADDR_LOW, x)
#define DSM_MAC_ADDR_BASE_LOW_CFG_MAC_ADDR_LOW_GET(x)\
	FIELD_GET(DSM_MAC_ADDR_BASE_LOW_CFG_MAC_ADDR_LOW, x)

/*      DSM:CFG:TAXI_CAL_CFG */
#define DSM_TAXI_CAL_CFG(r)       __REG(TARGET_DSM,\
					0, 1, 20, 0, 1, 3528, 3224, r, 9, 4)

#define DSM_TAXI_CAL_CFG_CAL_IDX                 GENMASK(20, 15)
#define DSM_TAXI_CAL_CFG_CAL_IDX_SET(x)\
	FIELD_PREP(DSM_TAXI_CAL_CFG_CAL_IDX, x)
#define DSM_TAXI_CAL_CFG_CAL_IDX_GET(x)\
	FIELD_GET(DSM_TAXI_CAL_CFG_CAL_IDX, x)

#define DSM_TAXI_CAL_CFG_CAL_CUR_LEN             GENMASK(14, 9)
#define DSM_TAXI_CAL_CFG_CAL_CUR_LEN_SET(x)\
	FIELD_PREP(DSM_TAXI_CAL_CFG_CAL_CUR_LEN, x)
#define DSM_TAXI_CAL_CFG_CAL_CUR_LEN_GET(x)\
	FIELD_GET(DSM_TAXI_CAL_CFG_CAL_CUR_LEN, x)

#define DSM_TAXI_CAL_CFG_CAL_CUR_VAL             GENMASK(8, 5)
#define DSM_TAXI_CAL_CFG_CAL_CUR_VAL_SET(x)\
	FIELD_PREP(DSM_TAXI_CAL_CFG_CAL_CUR_VAL, x)
#define DSM_TAXI_CAL_CFG_CAL_CUR_VAL_GET(x)\
	FIELD_GET(DSM_TAXI_CAL_CFG_CAL_CUR_VAL, x)

#define DSM_TAXI_CAL_CFG_CAL_PGM_VAL             GENMASK(4, 1)
#define DSM_TAXI_CAL_CFG_CAL_PGM_VAL_SET(x)\
	FIELD_PREP(DSM_TAXI_CAL_CFG_CAL_PGM_VAL, x)
#define DSM_TAXI_CAL_CFG_CAL_PGM_VAL_GET(x)\
	FIELD_GET(DSM_TAXI_CAL_CFG_CAL_PGM_VAL, x)

#define DSM_TAXI_CAL_CFG_CAL_PGM_ENA             BIT(0)
#define DSM_TAXI_CAL_CFG_CAL_PGM_ENA_SET(x)\
	FIELD_PREP(DSM_TAXI_CAL_CFG_CAL_PGM_ENA, x)
#define DSM_TAXI_CAL_CFG_CAL_PGM_ENA_GET(x)\
	FIELD_GET(DSM_TAXI_CAL_CFG_CAL_PGM_ENA, x)

/*      EACL:ES2_KEY_SELECT_PROFILE:VCAP_ES2_KEY_SEL */
#define EACL_VCAP_ES2_KEY_SEL(g, r) __REG(TARGET_EACL,\
					0, 1, 149504, g, 138, 8, 0, r, 2, 4)

#define EACL_VCAP_ES2_KEY_SEL_IP6_KEY_SEL        GENMASK(7, 5)
#define EACL_VCAP_ES2_KEY_SEL_IP6_KEY_SEL_SET(x)\
	FIELD_PREP(EACL_VCAP_ES2_KEY_SEL_IP6_KEY_SEL, x)
#define EACL_VCAP_ES2_KEY_SEL_IP6_KEY_SEL_GET(x)\
	FIELD_GET(EACL_VCAP_ES2_KEY_SEL_IP6_KEY_SEL, x)

#define EACL_VCAP_ES2_KEY_SEL_IP4_KEY_SEL        GENMASK(4, 2)
#define EACL_VCAP_ES2_KEY_SEL_IP4_KEY_SEL_SET(x)\
	FIELD_PREP(EACL_VCAP_ES2_KEY_SEL_IP4_KEY_SEL, x)
#define EACL_VCAP_ES2_KEY_SEL_IP4_KEY_SEL_GET(x)\
	FIELD_GET(EACL_VCAP_ES2_KEY_SEL_IP4_KEY_SEL, x)

#define EACL_VCAP_ES2_KEY_SEL_ARP_KEY_SEL        BIT(1)
#define EACL_VCAP_ES2_KEY_SEL_ARP_KEY_SEL_SET(x)\
	FIELD_PREP(EACL_VCAP_ES2_KEY_SEL_ARP_KEY_SEL, x)
#define EACL_VCAP_ES2_KEY_SEL_ARP_KEY_SEL_GET(x)\
	FIELD_GET(EACL_VCAP_ES2_KEY_SEL_ARP_KEY_SEL, x)

#define EACL_VCAP_ES2_KEY_SEL_KEY_ENA            BIT(0)
#define EACL_VCAP_ES2_KEY_SEL_KEY_ENA_SET(x)\
	FIELD_PREP(EACL_VCAP_ES2_KEY_SEL_KEY_ENA, x)
#define EACL_VCAP_ES2_KEY_SEL_KEY_ENA_GET(x)\
	FIELD_GET(EACL_VCAP_ES2_KEY_SEL_KEY_ENA, x)

/*      EACL:CNT_TBL:ES2_CNT */
#define EACL_ES2_CNT(g)           __REG(TARGET_EACL,\
					0, 1, 122880, g, 2048, 4, 0, 0, 1, 4)

/*      EACL:POL_CFG:POL_EACL_CFG */
#define EACL_POL_EACL_CFG         __REG(TARGET_EACL,\
					0, 1, 150608, 0, 1, 780, 768, 0, 1, 4)

#define EACL_POL_EACL_CFG_EACL_CNT_MARKED_AS_DROPPED BIT(5)
#define EACL_POL_EACL_CFG_EACL_CNT_MARKED_AS_DROPPED_SET(x)\
	FIELD_PREP(EACL_POL_EACL_CFG_EACL_CNT_MARKED_AS_DROPPED, x)
#define EACL_POL_EACL_CFG_EACL_CNT_MARKED_AS_DROPPED_GET(x)\
	FIELD_GET(EACL_POL_EACL_CFG_EACL_CNT_MARKED_AS_DROPPED, x)

#define EACL_POL_EACL_CFG_EACL_ALLOW_FP_COPY     BIT(4)
#define EACL_POL_EACL_CFG_EACL_ALLOW_FP_COPY_SET(x)\
	FIELD_PREP(EACL_POL_EACL_CFG_EACL_ALLOW_FP_COPY, x)
#define EACL_POL_EACL_CFG_EACL_ALLOW_FP_COPY_GET(x)\
	FIELD_GET(EACL_POL_EACL_CFG_EACL_ALLOW_FP_COPY, x)

#define EACL_POL_EACL_CFG_EACL_ALLOW_CPU_COPY    BIT(3)
#define EACL_POL_EACL_CFG_EACL_ALLOW_CPU_COPY_SET(x)\
	FIELD_PREP(EACL_POL_EACL_CFG_EACL_ALLOW_CPU_COPY, x)
#define EACL_POL_EACL_CFG_EACL_ALLOW_CPU_COPY_GET(x)\
	FIELD_GET(EACL_POL_EACL_CFG_EACL_ALLOW_CPU_COPY, x)

#define EACL_POL_EACL_CFG_EACL_FORCE_CLOSE       BIT(2)
#define EACL_POL_EACL_CFG_EACL_FORCE_CLOSE_SET(x)\
	FIELD_PREP(EACL_POL_EACL_CFG_EACL_FORCE_CLOSE, x)
#define EACL_POL_EACL_CFG_EACL_FORCE_CLOSE_GET(x)\
	FIELD_GET(EACL_POL_EACL_CFG_EACL_FORCE_CLOSE, x)

#define EACL_POL_EACL_CFG_EACL_FORCE_OPEN        BIT(1)
#define EACL_POL_EACL_CFG_EACL_FORCE_OPEN_SET(x)\
	FIELD_PREP(EACL_POL_EACL_CFG_EACL_FORCE_OPEN, x)
#define EACL_POL_EACL_CFG_EACL_FORCE_OPEN_GET(x)\
	FIELD_GET(EACL_POL_EACL_CFG_EACL_FORCE_OPEN, x)

#define EACL_POL_EACL_CFG_EACL_FORCE_INIT        BIT(0)
#define EACL_POL_EACL_CFG_EACL_FORCE_INIT_SET(x)\
	FIELD_PREP(EACL_POL_EACL_CFG_EACL_FORCE_INIT, x)
#define EACL_POL_EACL_CFG_EACL_FORCE_INIT_GET(x)\
	FIELD_GET(EACL_POL_EACL_CFG_EACL_FORCE_INIT, x)

/*      EACL:ES2_STICKY:SEC_LOOKUP_STICKY */
#define EACL_SEC_LOOKUP_STICKY(r) __REG(TARGET_EACL,\
					0, 1, 118696, 0, 1, 8, 0, r, 2, 4)

#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP_7TUPLE_STICKY BIT(7)
#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP_7TUPLE_STICKY_SET(x)\
	FIELD_PREP(EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP_7TUPLE_STICKY, x)
#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP_7TUPLE_STICKY_GET(x)\
	FIELD_GET(EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP_7TUPLE_STICKY, x)

#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_VID_STICKY BIT(6)
#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_VID_STICKY_SET(x)\
	FIELD_PREP(EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_VID_STICKY, x)
#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_VID_STICKY_GET(x)\
	FIELD_GET(EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_VID_STICKY, x)

#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_STD_STICKY BIT(5)
#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_STD_STICKY_SET(x)\
	FIELD_PREP(EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_STD_STICKY, x)
#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_STD_STICKY_GET(x)\
	FIELD_GET(EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP6_STD_STICKY, x)

#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_TCPUDP_STICKY BIT(4)
#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_TCPUDP_STICKY_SET(x)\
	FIELD_PREP(EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_TCPUDP_STICKY, x)
#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_TCPUDP_STICKY_GET(x)\
	FIELD_GET(EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_TCPUDP_STICKY, x)

#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_VID_STICKY BIT(3)
#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_VID_STICKY_SET(x)\
	FIELD_PREP(EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_VID_STICKY, x)
#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_VID_STICKY_GET(x)\
	FIELD_GET(EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_VID_STICKY, x)

#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_OTHER_STICKY BIT(2)
#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_OTHER_STICKY_SET(x)\
	FIELD_PREP(EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_OTHER_STICKY, x)
#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_OTHER_STICKY_GET(x)\
	FIELD_GET(EACL_SEC_LOOKUP_STICKY_SEC_TYPE_IP4_OTHER_STICKY, x)

#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_ARP_STICKY BIT(1)
#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_ARP_STICKY_SET(x)\
	FIELD_PREP(EACL_SEC_LOOKUP_STICKY_SEC_TYPE_ARP_STICKY, x)
#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_ARP_STICKY_GET(x)\
	FIELD_GET(EACL_SEC_LOOKUP_STICKY_SEC_TYPE_ARP_STICKY, x)

#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_MAC_ETYPE_STICKY BIT(0)
#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_MAC_ETYPE_STICKY_SET(x)\
	FIELD_PREP(EACL_SEC_LOOKUP_STICKY_SEC_TYPE_MAC_ETYPE_STICKY, x)
#define EACL_SEC_LOOKUP_STICKY_SEC_TYPE_MAC_ETYPE_STICKY_GET(x)\
	FIELD_GET(EACL_SEC_LOOKUP_STICKY_SEC_TYPE_MAC_ETYPE_STICKY, x)

/*      EACL:RAM_CTRL:RAM_INIT */
#define EACL_RAM_INIT             __REG(TARGET_EACL,\
					0, 1, 118736, 0, 1, 4, 0, 0, 1, 4)

#define EACL_RAM_INIT_RAM_INIT                   BIT(1)
#define EACL_RAM_INIT_RAM_INIT_SET(x)\
	FIELD_PREP(EACL_RAM_INIT_RAM_INIT, x)
#define EACL_RAM_INIT_RAM_INIT_GET(x)\
	FIELD_GET(EACL_RAM_INIT_RAM_INIT, x)

#define EACL_RAM_INIT_RAM_CFG_HOOK               BIT(0)
#define EACL_RAM_INIT_RAM_CFG_HOOK_SET(x)\
	FIELD_PREP(EACL_RAM_INIT_RAM_CFG_HOOK, x)
#define EACL_RAM_INIT_RAM_CFG_HOOK_GET(x)\
	FIELD_GET(EACL_RAM_INIT_RAM_CFG_HOOK, x)

/*      FDMA:FDMA:FDMA_CH_ACTIVATE */
#define FDMA_CH_ACTIVATE          __REG(TARGET_FDMA,\
					0, 1, 8, 0, 1, 428, 0, 0, 1, 4)

#define FDMA_CH_ACTIVATE_CH_ACTIVATE             GENMASK(7, 0)
#define FDMA_CH_ACTIVATE_CH_ACTIVATE_SET(x)\
	FIELD_PREP(FDMA_CH_ACTIVATE_CH_ACTIVATE, x)
#define FDMA_CH_ACTIVATE_CH_ACTIVATE_GET(x)\
	FIELD_GET(FDMA_CH_ACTIVATE_CH_ACTIVATE, x)

/*      FDMA:FDMA:FDMA_CH_RELOAD */
#define FDMA_CH_RELOAD            __REG(TARGET_FDMA,\
					0, 1, 8, 0, 1, 428, 4, 0, 1, 4)

#define FDMA_CH_RELOAD_CH_RELOAD                 GENMASK(7, 0)
#define FDMA_CH_RELOAD_CH_RELOAD_SET(x)\
	FIELD_PREP(FDMA_CH_RELOAD_CH_RELOAD, x)
#define FDMA_CH_RELOAD_CH_RELOAD_GET(x)\
	FIELD_GET(FDMA_CH_RELOAD_CH_RELOAD, x)

/*      FDMA:FDMA:FDMA_CH_DISABLE */
#define FDMA_CH_DISABLE           __REG(TARGET_FDMA,\
					0, 1, 8, 0, 1, 428, 8, 0, 1, 4)

#define FDMA_CH_DISABLE_CH_DISABLE               GENMASK(7, 0)
#define FDMA_CH_DISABLE_CH_DISABLE_SET(x)\
	FIELD_PREP(FDMA_CH_DISABLE_CH_DISABLE, x)
#define FDMA_CH_DISABLE_CH_DISABLE_GET(x)\
	FIELD_GET(FDMA_CH_DISABLE_CH_DISABLE, x)

/*      FDMA:FDMA:FDMA_DCB_LLP */
#define FDMA_DCB_LLP(r)           __REG(TARGET_FDMA,\
					0, 1, 8, 0, 1, 428, 52, r, 8, 4)

/*      FDMA:FDMA:FDMA_DCB_LLP1 */
#define FDMA_DCB_LLP1(r)          __REG(TARGET_FDMA,\
					0, 1, 8, 0, 1, 428, 84, r, 8, 4)

/*      FDMA:FDMA:FDMA_DCB_LLP_PREV */
#define FDMA_DCB_LLP_PREV(r)      __REG(TARGET_FDMA,\
					0, 1, 8, 0, 1, 428, 116, r, 8, 4)

/*      FDMA:FDMA:FDMA_DCB_LLP_PREV1 */
#define FDMA_DCB_LLP_PREV1(r)     __REG(TARGET_FDMA,\
					0, 1, 8, 0, 1, 428, 148, r, 8, 4)

/*      FDMA:FDMA:FDMA_CH_CFG */
#define FDMA_CH_CFG(r)            __REG(TARGET_FDMA,\
					0, 1, 8, 0, 1, 428, 224, r, 8, 4)

#define FDMA_CH_CFG_CH_XTR_STATUS_MODE           BIT(7)
#define FDMA_CH_CFG_CH_XTR_STATUS_MODE_SET(x)\
	FIELD_PREP(FDMA_CH_CFG_CH_XTR_STATUS_MODE, x)
#define FDMA_CH_CFG_CH_XTR_STATUS_MODE_GET(x)\
	FIELD_GET(FDMA_CH_CFG_CH_XTR_STATUS_MODE, x)

#define FDMA_CH_CFG_CH_INTR_DB_EOF_ONLY          BIT(6)
#define FDMA_CH_CFG_CH_INTR_DB_EOF_ONLY_SET(x)\
	FIELD_PREP(FDMA_CH_CFG_CH_INTR_DB_EOF_ONLY, x)
#define FDMA_CH_CFG_CH_INTR_DB_EOF_ONLY_GET(x)\
	FIELD_GET(FDMA_CH_CFG_CH_INTR_DB_EOF_ONLY, x)

#define FDMA_CH_CFG_CH_INJ_PORT                  BIT(5)
#define FDMA_CH_CFG_CH_INJ_PORT_SET(x)\
	FIELD_PREP(FDMA_CH_CFG_CH_INJ_PORT, x)
#define FDMA_CH_CFG_CH_INJ_PORT_GET(x)\
	FIELD_GET(FDMA_CH_CFG_CH_INJ_PORT, x)

#define FDMA_CH_CFG_CH_DCB_DB_CNT                GENMASK(4, 1)
#define FDMA_CH_CFG_CH_DCB_DB_CNT_SET(x)\
	FIELD_PREP(FDMA_CH_CFG_CH_DCB_DB_CNT, x)
#define FDMA_CH_CFG_CH_DCB_DB_CNT_GET(x)\
	FIELD_GET(FDMA_CH_CFG_CH_DCB_DB_CNT, x)

#define FDMA_CH_CFG_CH_MEM                       BIT(0)
#define FDMA_CH_CFG_CH_MEM_SET(x)\
	FIELD_PREP(FDMA_CH_CFG_CH_MEM, x)
#define FDMA_CH_CFG_CH_MEM_GET(x)\
	FIELD_GET(FDMA_CH_CFG_CH_MEM, x)

/*      FDMA:FDMA:FDMA_CH_TRANSLATE */
#define FDMA_CH_TRANSLATE(r)      __REG(TARGET_FDMA,\
					0, 1, 8, 0, 1, 428, 256, r, 8, 4)

#define FDMA_CH_TRANSLATE_OFFSET                 GENMASK(15, 0)
#define FDMA_CH_TRANSLATE_OFFSET_SET(x)\
	FIELD_PREP(FDMA_CH_TRANSLATE_OFFSET, x)
#define FDMA_CH_TRANSLATE_OFFSET_GET(x)\
	FIELD_GET(FDMA_CH_TRANSLATE_OFFSET, x)

/*      FDMA:FDMA:FDMA_XTR_CFG */
#define FDMA_XTR_CFG              __REG(TARGET_FDMA,\
					0, 1, 8, 0, 1, 428, 364, 0, 1, 4)

#define FDMA_XTR_CFG_XTR_FIFO_WM                 GENMASK(15, 11)
#define FDMA_XTR_CFG_XTR_FIFO_WM_SET(x)\
	FIELD_PREP(FDMA_XTR_CFG_XTR_FIFO_WM, x)
#define FDMA_XTR_CFG_XTR_FIFO_WM_GET(x)\
	FIELD_GET(FDMA_XTR_CFG_XTR_FIFO_WM, x)

#define FDMA_XTR_CFG_XTR_ARB_SAT                 GENMASK(10, 0)
#define FDMA_XTR_CFG_XTR_ARB_SAT_SET(x)\
	FIELD_PREP(FDMA_XTR_CFG_XTR_ARB_SAT, x)
#define FDMA_XTR_CFG_XTR_ARB_SAT_GET(x)\
	FIELD_GET(FDMA_XTR_CFG_XTR_ARB_SAT, x)

/*      FDMA:FDMA:FDMA_PORT_CTRL */
#define FDMA_PORT_CTRL(r)         __REG(TARGET_FDMA,\
					0, 1, 8, 0, 1, 428, 376, r, 2, 4)

#define FDMA_PORT_CTRL_INJ_STOP                  BIT(4)
#define FDMA_PORT_CTRL_INJ_STOP_SET(x)\
	FIELD_PREP(FDMA_PORT_CTRL_INJ_STOP, x)
#define FDMA_PORT_CTRL_INJ_STOP_GET(x)\
	FIELD_GET(FDMA_PORT_CTRL_INJ_STOP, x)

#define FDMA_PORT_CTRL_INJ_STOP_FORCE            BIT(3)
#define FDMA_PORT_CTRL_INJ_STOP_FORCE_SET(x)\
	FIELD_PREP(FDMA_PORT_CTRL_INJ_STOP_FORCE, x)
#define FDMA_PORT_CTRL_INJ_STOP_FORCE_GET(x)\
	FIELD_GET(FDMA_PORT_CTRL_INJ_STOP_FORCE, x)

#define FDMA_PORT_CTRL_XTR_STOP                  BIT(2)
#define FDMA_PORT_CTRL_XTR_STOP_SET(x)\
	FIELD_PREP(FDMA_PORT_CTRL_XTR_STOP, x)
#define FDMA_PORT_CTRL_XTR_STOP_GET(x)\
	FIELD_GET(FDMA_PORT_CTRL_XTR_STOP, x)

#define FDMA_PORT_CTRL_XTR_BUF_IS_EMPTY          BIT(1)
#define FDMA_PORT_CTRL_XTR_BUF_IS_EMPTY_SET(x)\
	FIELD_PREP(FDMA_PORT_CTRL_XTR_BUF_IS_EMPTY, x)
#define FDMA_PORT_CTRL_XTR_BUF_IS_EMPTY_GET(x)\
	FIELD_GET(FDMA_PORT_CTRL_XTR_BUF_IS_EMPTY, x)

#define FDMA_PORT_CTRL_XTR_BUF_RST               BIT(0)
#define FDMA_PORT_CTRL_XTR_BUF_RST_SET(x)\
	FIELD_PREP(FDMA_PORT_CTRL_XTR_BUF_RST, x)
#define FDMA_PORT_CTRL_XTR_BUF_RST_GET(x)\
	FIELD_GET(FDMA_PORT_CTRL_XTR_BUF_RST, x)

/*      FDMA:FDMA:FDMA_INTR_DCB */
#define FDMA_INTR_DCB             __REG(TARGET_FDMA,\
					0, 1, 8, 0, 1, 428, 384, 0, 1, 4)

#define FDMA_INTR_DCB_INTR_DCB                   GENMASK(7, 0)
#define FDMA_INTR_DCB_INTR_DCB_SET(x)\
	FIELD_PREP(FDMA_INTR_DCB_INTR_DCB, x)
#define FDMA_INTR_DCB_INTR_DCB_GET(x)\
	FIELD_GET(FDMA_INTR_DCB_INTR_DCB, x)

/*      FDMA:FDMA:FDMA_INTR_DCB_ENA */
#define FDMA_INTR_DCB_ENA         __REG(TARGET_FDMA,\
					0, 1, 8, 0, 1, 428, 388, 0, 1, 4)

#define FDMA_INTR_DCB_ENA_INTR_DCB_ENA           GENMASK(7, 0)
#define FDMA_INTR_DCB_ENA_INTR_DCB_ENA_SET(x)\
	FIELD_PREP(FDMA_INTR_DCB_ENA_INTR_DCB_ENA, x)
#define FDMA_INTR_DCB_ENA_INTR_DCB_ENA_GET(x)\
	FIELD_GET(FDMA_INTR_DCB_ENA_INTR_DCB_ENA, x)

/*      FDMA:FDMA:FDMA_INTR_DB */
#define FDMA_INTR_DB              __REG(TARGET_FDMA,\
					0, 1, 8, 0, 1, 428, 392, 0, 1, 4)

#define FDMA_INTR_DB_INTR_DB                     GENMASK(7, 0)
#define FDMA_INTR_DB_INTR_DB_SET(x)\
	FIELD_PREP(FDMA_INTR_DB_INTR_DB, x)
#define FDMA_INTR_DB_INTR_DB_GET(x)\
	FIELD_GET(FDMA_INTR_DB_INTR_DB, x)

/*      FDMA:FDMA:FDMA_INTR_DB_ENA */
#define FDMA_INTR_DB_ENA          __REG(TARGET_FDMA,\
					0, 1, 8, 0, 1, 428, 396, 0, 1, 4)

#define FDMA_INTR_DB_ENA_INTR_DB_ENA             GENMASK(7, 0)
#define FDMA_INTR_DB_ENA_INTR_DB_ENA_SET(x)\
	FIELD_PREP(FDMA_INTR_DB_ENA_INTR_DB_ENA, x)
#define FDMA_INTR_DB_ENA_INTR_DB_ENA_GET(x)\
	FIELD_GET(FDMA_INTR_DB_ENA_INTR_DB_ENA, x)

/*      FDMA:FDMA:FDMA_INTR_ERR */
#define FDMA_INTR_ERR             __REG(TARGET_FDMA,\
					0, 1, 8, 0, 1, 428, 400, 0, 1, 4)

#define FDMA_INTR_ERR_INTR_PORT_ERR              GENMASK(9, 8)
#define FDMA_INTR_ERR_INTR_PORT_ERR_SET(x)\
	FIELD_PREP(FDMA_INTR_ERR_INTR_PORT_ERR, x)
#define FDMA_INTR_ERR_INTR_PORT_ERR_GET(x)\
	FIELD_GET(FDMA_INTR_ERR_INTR_PORT_ERR, x)

#define FDMA_INTR_ERR_INTR_CH_ERR                GENMASK(7, 0)
#define FDMA_INTR_ERR_INTR_CH_ERR_SET(x)\
	FIELD_PREP(FDMA_INTR_ERR_INTR_CH_ERR, x)
#define FDMA_INTR_ERR_INTR_CH_ERR_GET(x)\
	FIELD_GET(FDMA_INTR_ERR_INTR_CH_ERR, x)

/*      FDMA:FDMA:FDMA_ERRORS */
#define FDMA_ERRORS               __REG(TARGET_FDMA,\
					0, 1, 8, 0, 1, 428, 412, 0, 1, 4)

#define FDMA_ERRORS_ERR_XTR_WR                   GENMASK(31, 30)
#define FDMA_ERRORS_ERR_XTR_WR_SET(x)\
	FIELD_PREP(FDMA_ERRORS_ERR_XTR_WR, x)
#define FDMA_ERRORS_ERR_XTR_WR_GET(x)\
	FIELD_GET(FDMA_ERRORS_ERR_XTR_WR, x)

#define FDMA_ERRORS_ERR_XTR_OVF                  GENMASK(29, 28)
#define FDMA_ERRORS_ERR_XTR_OVF_SET(x)\
	FIELD_PREP(FDMA_ERRORS_ERR_XTR_OVF, x)
#define FDMA_ERRORS_ERR_XTR_OVF_GET(x)\
	FIELD_GET(FDMA_ERRORS_ERR_XTR_OVF, x)

#define FDMA_ERRORS_ERR_XTR_TAXI32_OVF           GENMASK(27, 26)
#define FDMA_ERRORS_ERR_XTR_TAXI32_OVF_SET(x)\
	FIELD_PREP(FDMA_ERRORS_ERR_XTR_TAXI32_OVF, x)
#define FDMA_ERRORS_ERR_XTR_TAXI32_OVF_GET(x)\
	FIELD_GET(FDMA_ERRORS_ERR_XTR_TAXI32_OVF, x)

#define FDMA_ERRORS_ERR_DCB_XTR_DATAL            GENMASK(25, 24)
#define FDMA_ERRORS_ERR_DCB_XTR_DATAL_SET(x)\
	FIELD_PREP(FDMA_ERRORS_ERR_DCB_XTR_DATAL, x)
#define FDMA_ERRORS_ERR_DCB_XTR_DATAL_GET(x)\
	FIELD_GET(FDMA_ERRORS_ERR_DCB_XTR_DATAL, x)

#define FDMA_ERRORS_ERR_DCB_RD                   GENMASK(23, 16)
#define FDMA_ERRORS_ERR_DCB_RD_SET(x)\
	FIELD_PREP(FDMA_ERRORS_ERR_DCB_RD, x)
#define FDMA_ERRORS_ERR_DCB_RD_GET(x)\
	FIELD_GET(FDMA_ERRORS_ERR_DCB_RD, x)

#define FDMA_ERRORS_ERR_INJ_RD                   GENMASK(15, 10)
#define FDMA_ERRORS_ERR_INJ_RD_SET(x)\
	FIELD_PREP(FDMA_ERRORS_ERR_INJ_RD, x)
#define FDMA_ERRORS_ERR_INJ_RD_GET(x)\
	FIELD_GET(FDMA_ERRORS_ERR_INJ_RD, x)

#define FDMA_ERRORS_ERR_INJ_OUT_OF_SYNC          GENMASK(9, 8)
#define FDMA_ERRORS_ERR_INJ_OUT_OF_SYNC_SET(x)\
	FIELD_PREP(FDMA_ERRORS_ERR_INJ_OUT_OF_SYNC, x)
#define FDMA_ERRORS_ERR_INJ_OUT_OF_SYNC_GET(x)\
	FIELD_GET(FDMA_ERRORS_ERR_INJ_OUT_OF_SYNC, x)

#define FDMA_ERRORS_ERR_CH_WR                    GENMASK(7, 0)
#define FDMA_ERRORS_ERR_CH_WR_SET(x)\
	FIELD_PREP(FDMA_ERRORS_ERR_CH_WR, x)
#define FDMA_ERRORS_ERR_CH_WR_GET(x)\
	FIELD_GET(FDMA_ERRORS_ERR_CH_WR, x)

/*      FDMA:FDMA:FDMA_ERRORS_2 */
#define FDMA_ERRORS_2             __REG(TARGET_FDMA,\
					0, 1, 8, 0, 1, 428, 416, 0, 1, 4)

#define FDMA_ERRORS_2_ERR_XTR_FRAG               GENMASK(1, 0)
#define FDMA_ERRORS_2_ERR_XTR_FRAG_SET(x)\
	FIELD_PREP(FDMA_ERRORS_2_ERR_XTR_FRAG, x)
#define FDMA_ERRORS_2_ERR_XTR_FRAG_GET(x)\
	FIELD_GET(FDMA_ERRORS_2_ERR_XTR_FRAG, x)

/*      FDMA:FDMA:FDMA_CTRL */
#define FDMA_CTRL                 __REG(TARGET_FDMA,\
					0, 1, 8, 0, 1, 428, 424, 0, 1, 4)

#define FDMA_CTRL_NRESET                         BIT(0)
#define FDMA_CTRL_NRESET_SET(x)\
	FIELD_PREP(FDMA_CTRL_NRESET, x)
#define FDMA_CTRL_NRESET_GET(x)\
	FIELD_GET(FDMA_CTRL_NRESET, x)

/*      DEVCPU_GCB:CHIP_REGS:CHIP_ID */
#define GCB_CHIP_ID               __REG(TARGET_GCB,\
					0, 1, 0, 0, 1, 424, 0, 0, 1, 4)

#define GCB_CHIP_ID_REV_ID                       GENMASK(31, 28)
#define GCB_CHIP_ID_REV_ID_SET(x)\
	FIELD_PREP(GCB_CHIP_ID_REV_ID, x)
#define GCB_CHIP_ID_REV_ID_GET(x)\
	FIELD_GET(GCB_CHIP_ID_REV_ID, x)

#define GCB_CHIP_ID_PART_ID                      GENMASK(27, 12)
#define GCB_CHIP_ID_PART_ID_SET(x)\
	FIELD_PREP(GCB_CHIP_ID_PART_ID, x)
#define GCB_CHIP_ID_PART_ID_GET(x)\
	FIELD_GET(GCB_CHIP_ID_PART_ID, x)

#define GCB_CHIP_ID_MFG_ID                       GENMASK(11, 1)
#define GCB_CHIP_ID_MFG_ID_SET(x)\
	FIELD_PREP(GCB_CHIP_ID_MFG_ID, x)
#define GCB_CHIP_ID_MFG_ID_GET(x)\
	FIELD_GET(GCB_CHIP_ID_MFG_ID, x)

#define GCB_CHIP_ID_ONE                          BIT(0)
#define GCB_CHIP_ID_ONE_SET(x)\
	FIELD_PREP(GCB_CHIP_ID_ONE, x)
#define GCB_CHIP_ID_ONE_GET(x)\
	FIELD_GET(GCB_CHIP_ID_ONE, x)

/*      DEVCPU_GCB:CHIP_REGS:SOFT_RST */
#define GCB_SOFT_RST              __REG(TARGET_GCB,\
					0, 1, 0, 0, 1, 424, 8, 0, 1, 4)

#define GCB_SOFT_RST_SOFT_NON_CFG_RST            BIT(2)
#define GCB_SOFT_RST_SOFT_NON_CFG_RST_SET(x)\
	FIELD_PREP(GCB_SOFT_RST_SOFT_NON_CFG_RST, x)
#define GCB_SOFT_RST_SOFT_NON_CFG_RST_GET(x)\
	FIELD_GET(GCB_SOFT_RST_SOFT_NON_CFG_RST, x)

#define GCB_SOFT_RST_SOFT_SWC_RST                BIT(1)
#define GCB_SOFT_RST_SOFT_SWC_RST_SET(x)\
	FIELD_PREP(GCB_SOFT_RST_SOFT_SWC_RST, x)
#define GCB_SOFT_RST_SOFT_SWC_RST_GET(x)\
	FIELD_GET(GCB_SOFT_RST_SOFT_SWC_RST, x)

#define GCB_SOFT_RST_SOFT_CHIP_RST               BIT(0)
#define GCB_SOFT_RST_SOFT_CHIP_RST_SET(x)\
	FIELD_PREP(GCB_SOFT_RST_SOFT_CHIP_RST, x)
#define GCB_SOFT_RST_SOFT_CHIP_RST_GET(x)\
	FIELD_GET(GCB_SOFT_RST_SOFT_CHIP_RST, x)

/*      DEVCPU_GCB:CHIP_REGS:HW_SGPIO_SD_CFG */
#define GCB_HW_SGPIO_SD_CFG       __REG(TARGET_GCB,\
					0, 1, 0, 0, 1, 424, 20, 0, 1, 4)

#define GCB_HW_SGPIO_SD_CFG_SD_HIGH_ENA          BIT(1)
#define GCB_HW_SGPIO_SD_CFG_SD_HIGH_ENA_SET(x)\
	FIELD_PREP(GCB_HW_SGPIO_SD_CFG_SD_HIGH_ENA, x)
#define GCB_HW_SGPIO_SD_CFG_SD_HIGH_ENA_GET(x)\
	FIELD_GET(GCB_HW_SGPIO_SD_CFG_SD_HIGH_ENA, x)

#define GCB_HW_SGPIO_SD_CFG_SD_MAP_SEL           BIT(0)
#define GCB_HW_SGPIO_SD_CFG_SD_MAP_SEL_SET(x)\
	FIELD_PREP(GCB_HW_SGPIO_SD_CFG_SD_MAP_SEL, x)
#define GCB_HW_SGPIO_SD_CFG_SD_MAP_SEL_GET(x)\
	FIELD_GET(GCB_HW_SGPIO_SD_CFG_SD_MAP_SEL, x)

/*      DEVCPU_GCB:CHIP_REGS:HW_SGPIO_TO_SD_MAP_CFG */
#define GCB_HW_SGPIO_TO_SD_MAP_CFG(r) __REG(TARGET_GCB,\
					0, 1, 0, 0, 1, 424, 24, r, 65, 4)

#define GCB_HW_SGPIO_TO_SD_MAP_CFG_SGPIO_TO_SD_SEL GENMASK(8, 0)
#define GCB_HW_SGPIO_TO_SD_MAP_CFG_SGPIO_TO_SD_SEL_SET(x)\
	FIELD_PREP(GCB_HW_SGPIO_TO_SD_MAP_CFG_SGPIO_TO_SD_SEL, x)
#define GCB_HW_SGPIO_TO_SD_MAP_CFG_SGPIO_TO_SD_SEL_GET(x)\
	FIELD_GET(GCB_HW_SGPIO_TO_SD_MAP_CFG_SGPIO_TO_SD_SEL, x)

/*      DEVCPU_GCB:SIO_CTRL:SIO_CLOCK */
#define GCB_SIO_CLOCK(g)          __REG(TARGET_GCB,\
					0, 1, 876, g, 3, 280, 20, 0, 1, 4)

#define GCB_SIO_CLOCK_SIO_CLK_FREQ               GENMASK(19, 8)
#define GCB_SIO_CLOCK_SIO_CLK_FREQ_SET(x)\
	FIELD_PREP(GCB_SIO_CLOCK_SIO_CLK_FREQ, x)
#define GCB_SIO_CLOCK_SIO_CLK_FREQ_GET(x)\
	FIELD_GET(GCB_SIO_CLOCK_SIO_CLK_FREQ, x)

#define GCB_SIO_CLOCK_SYS_CLK_PERIOD             GENMASK(7, 0)
#define GCB_SIO_CLOCK_SYS_CLK_PERIOD_SET(x)\
	FIELD_PREP(GCB_SIO_CLOCK_SYS_CLK_PERIOD, x)
#define GCB_SIO_CLOCK_SYS_CLK_PERIOD_GET(x)\
	FIELD_GET(GCB_SIO_CLOCK_SYS_CLK_PERIOD, x)

/*      HSCH:HSCH_CFG:CIR_CFG */
#define HSCH_CIR_CFG(g)           __REG(TARGET_HSCH,\
					0, 1, 0, g, 5040, 32, 0, 0, 1, 4)

#define HSCH_CIR_CFG_CIR_RATE                    GENMASK(22, 6)
#define HSCH_CIR_CFG_CIR_RATE_SET(x)\
	FIELD_PREP(HSCH_CIR_CFG_CIR_RATE, x)
#define HSCH_CIR_CFG_CIR_RATE_GET(x)\
	FIELD_GET(HSCH_CIR_CFG_CIR_RATE, x)

#define HSCH_CIR_CFG_CIR_BURST                   GENMASK(5, 0)
#define HSCH_CIR_CFG_CIR_BURST_SET(x)\
	FIELD_PREP(HSCH_CIR_CFG_CIR_BURST, x)
#define HSCH_CIR_CFG_CIR_BURST_GET(x)\
	FIELD_GET(HSCH_CIR_CFG_CIR_BURST, x)

/*      HSCH:HSCH_CFG:EIR_CFG */
#define HSCH_EIR_CFG(g)           __REG(TARGET_HSCH,\
					0, 1, 0, g, 5040, 32, 4, 0, 1, 4)

#define HSCH_EIR_CFG_EIR_RATE                    GENMASK(22, 6)
#define HSCH_EIR_CFG_EIR_RATE_SET(x)\
	FIELD_PREP(HSCH_EIR_CFG_EIR_RATE, x)
#define HSCH_EIR_CFG_EIR_RATE_GET(x)\
	FIELD_GET(HSCH_EIR_CFG_EIR_RATE, x)

#define HSCH_EIR_CFG_EIR_BURST                   GENMASK(5, 0)
#define HSCH_EIR_CFG_EIR_BURST_SET(x)\
	FIELD_PREP(HSCH_EIR_CFG_EIR_BURST, x)
#define HSCH_EIR_CFG_EIR_BURST_GET(x)\
	FIELD_GET(HSCH_EIR_CFG_EIR_BURST, x)

/*      HSCH:HSCH_CFG:SE_CFG */
#define HSCH_SE_CFG(g)            __REG(TARGET_HSCH,\
					0, 1, 0, g, 5040, 32, 8, 0, 1, 4)

#define HSCH_SE_CFG_SE_DWRR_CNT                  GENMASK(12, 6)
#define HSCH_SE_CFG_SE_DWRR_CNT_SET(x)\
	FIELD_PREP(HSCH_SE_CFG_SE_DWRR_CNT, x)
#define HSCH_SE_CFG_SE_DWRR_CNT_GET(x)\
	FIELD_GET(HSCH_SE_CFG_SE_DWRR_CNT, x)

#define HSCH_SE_CFG_SE_AVB_ENA                   BIT(5)
#define HSCH_SE_CFG_SE_AVB_ENA_SET(x)\
	FIELD_PREP(HSCH_SE_CFG_SE_AVB_ENA, x)
#define HSCH_SE_CFG_SE_AVB_ENA_GET(x)\
	FIELD_GET(HSCH_SE_CFG_SE_AVB_ENA, x)

#define HSCH_SE_CFG_SE_FRM_MODE                  GENMASK(4, 3)
#define HSCH_SE_CFG_SE_FRM_MODE_SET(x)\
	FIELD_PREP(HSCH_SE_CFG_SE_FRM_MODE, x)
#define HSCH_SE_CFG_SE_FRM_MODE_GET(x)\
	FIELD_GET(HSCH_SE_CFG_SE_FRM_MODE, x)

#define HSCH_SE_CFG_SE_DWRR_FRM_MODE             GENMASK(2, 1)
#define HSCH_SE_CFG_SE_DWRR_FRM_MODE_SET(x)\
	FIELD_PREP(HSCH_SE_CFG_SE_DWRR_FRM_MODE, x)
#define HSCH_SE_CFG_SE_DWRR_FRM_MODE_GET(x)\
	FIELD_GET(HSCH_SE_CFG_SE_DWRR_FRM_MODE, x)

#define HSCH_SE_CFG_SE_STOP                      BIT(0)
#define HSCH_SE_CFG_SE_STOP_SET(x)\
	FIELD_PREP(HSCH_SE_CFG_SE_STOP, x)
#define HSCH_SE_CFG_SE_STOP_GET(x)\
	FIELD_GET(HSCH_SE_CFG_SE_STOP, x)

/*      HSCH:HSCH_CFG:SE_CONNECT */
#define HSCH_SE_CONNECT(g)        __REG(TARGET_HSCH,\
					0, 1, 0, g, 5040, 32, 12, 0, 1, 4)

#define HSCH_SE_CONNECT_SE_LEAK_LINK             GENMASK(15, 0)
#define HSCH_SE_CONNECT_SE_LEAK_LINK_SET(x)\
	FIELD_PREP(HSCH_SE_CONNECT_SE_LEAK_LINK, x)
#define HSCH_SE_CONNECT_SE_LEAK_LINK_GET(x)\
	FIELD_GET(HSCH_SE_CONNECT_SE_LEAK_LINK, x)

/*      HSCH:HSCH_CFG:SE_DLB_SENSE */
#define HSCH_SE_DLB_SENSE(g)      __REG(TARGET_HSCH,\
					0, 1, 0, g, 5040, 32, 16, 0, 1, 4)

#define HSCH_SE_DLB_SENSE_SE_DLB_PRIO            GENMASK(12, 10)
#define HSCH_SE_DLB_SENSE_SE_DLB_PRIO_SET(x)\
	FIELD_PREP(HSCH_SE_DLB_SENSE_SE_DLB_PRIO, x)
#define HSCH_SE_DLB_SENSE_SE_DLB_PRIO_GET(x)\
	FIELD_GET(HSCH_SE_DLB_SENSE_SE_DLB_PRIO, x)

#define HSCH_SE_DLB_SENSE_SE_DLB_DPORT           GENMASK(9, 3)
#define HSCH_SE_DLB_SENSE_SE_DLB_DPORT_SET(x)\
	FIELD_PREP(HSCH_SE_DLB_SENSE_SE_DLB_DPORT, x)
#define HSCH_SE_DLB_SENSE_SE_DLB_DPORT_GET(x)\
	FIELD_GET(HSCH_SE_DLB_SENSE_SE_DLB_DPORT, x)

#define HSCH_SE_DLB_SENSE_SE_DLB_SE_ENA          BIT(2)
#define HSCH_SE_DLB_SENSE_SE_DLB_SE_ENA_SET(x)\
	FIELD_PREP(HSCH_SE_DLB_SENSE_SE_DLB_SE_ENA, x)
#define HSCH_SE_DLB_SENSE_SE_DLB_SE_ENA_GET(x)\
	FIELD_GET(HSCH_SE_DLB_SENSE_SE_DLB_SE_ENA, x)

#define HSCH_SE_DLB_SENSE_SE_DLB_PRIO_ENA        BIT(1)
#define HSCH_SE_DLB_SENSE_SE_DLB_PRIO_ENA_SET(x)\
	FIELD_PREP(HSCH_SE_DLB_SENSE_SE_DLB_PRIO_ENA, x)
#define HSCH_SE_DLB_SENSE_SE_DLB_PRIO_ENA_GET(x)\
	FIELD_GET(HSCH_SE_DLB_SENSE_SE_DLB_PRIO_ENA, x)

#define HSCH_SE_DLB_SENSE_SE_DLB_DPORT_ENA       BIT(0)
#define HSCH_SE_DLB_SENSE_SE_DLB_DPORT_ENA_SET(x)\
	FIELD_PREP(HSCH_SE_DLB_SENSE_SE_DLB_DPORT_ENA, x)
#define HSCH_SE_DLB_SENSE_SE_DLB_DPORT_ENA_GET(x)\
	FIELD_GET(HSCH_SE_DLB_SENSE_SE_DLB_DPORT_ENA, x)

/*      HSCH:HSCH_DWRR:DWRR_ENTRY */
#define HSCH_DWRR_ENTRY(g)        __REG(TARGET_HSCH,\
					0, 1, 162816, g, 72, 4, 0, 0, 1, 4)

#define HSCH_DWRR_ENTRY_DWRR_COST                GENMASK(24, 20)
#define HSCH_DWRR_ENTRY_DWRR_COST_SET(x)\
	FIELD_PREP(HSCH_DWRR_ENTRY_DWRR_COST, x)
#define HSCH_DWRR_ENTRY_DWRR_COST_GET(x)\
	FIELD_GET(HSCH_DWRR_ENTRY_DWRR_COST, x)

#define HSCH_DWRR_ENTRY_DWRR_BALANCE             GENMASK(19, 0)
#define HSCH_DWRR_ENTRY_DWRR_BALANCE_SET(x)\
	FIELD_PREP(HSCH_DWRR_ENTRY_DWRR_BALANCE, x)
#define HSCH_DWRR_ENTRY_DWRR_BALANCE_GET(x)\
	FIELD_GET(HSCH_DWRR_ENTRY_DWRR_BALANCE, x)

/*      HSCH:HSCH_MISC:HSCH_CFG_CFG */
#define HSCH_HSCH_CFG_CFG         __REG(TARGET_HSCH,\
					0, 1, 163104, 0, 1, 648, 284, 0, 1, 4)

#define HSCH_HSCH_CFG_CFG_CFG_SE_IDX             GENMASK(26, 14)
#define HSCH_HSCH_CFG_CFG_CFG_SE_IDX_SET(x)\
	FIELD_PREP(HSCH_HSCH_CFG_CFG_CFG_SE_IDX, x)
#define HSCH_HSCH_CFG_CFG_CFG_SE_IDX_GET(x)\
	FIELD_GET(HSCH_HSCH_CFG_CFG_CFG_SE_IDX, x)

#define HSCH_HSCH_CFG_CFG_HSCH_LAYER             GENMASK(13, 12)
#define HSCH_HSCH_CFG_CFG_HSCH_LAYER_SET(x)\
	FIELD_PREP(HSCH_HSCH_CFG_CFG_HSCH_LAYER, x)
#define HSCH_HSCH_CFG_CFG_HSCH_LAYER_GET(x)\
	FIELD_GET(HSCH_HSCH_CFG_CFG_HSCH_LAYER, x)

#define HSCH_HSCH_CFG_CFG_CSR_GRANT              GENMASK(11, 0)
#define HSCH_HSCH_CFG_CFG_CSR_GRANT_SET(x)\
	FIELD_PREP(HSCH_HSCH_CFG_CFG_CSR_GRANT, x)
#define HSCH_HSCH_CFG_CFG_CSR_GRANT_GET(x)\
	FIELD_GET(HSCH_HSCH_CFG_CFG_CSR_GRANT, x)

/*      HSCH:HSCH_MISC:SYS_CLK_PER */
#define HSCH_SYS_CLK_PER          __REG(TARGET_HSCH,\
					0, 1, 163104, 0, 1, 648, 640, 0, 1, 4)

#define HSCH_SYS_CLK_PER_100PS                   GENMASK(7, 0)
#define HSCH_SYS_CLK_PER_100PS_SET(x)\
	FIELD_PREP(HSCH_SYS_CLK_PER_100PS, x)
#define HSCH_SYS_CLK_PER_100PS_GET(x)\
	FIELD_GET(HSCH_SYS_CLK_PER_100PS, x)

/*      HSCH:HSCH_LEAK_LISTS:HSCH_TIMER_CFG */
#define HSCH_HSCH_TIMER_CFG(g, r) __REG(TARGET_HSCH,\
					0, 1, 161664, g, 4, 32, 0, r, 4, 4)

#define HSCH_HSCH_TIMER_CFG_LEAK_TIME            GENMASK(17, 0)
#define HSCH_HSCH_TIMER_CFG_LEAK_TIME_SET(x)\
	FIELD_PREP(HSCH_HSCH_TIMER_CFG_LEAK_TIME, x)
#define HSCH_HSCH_TIMER_CFG_LEAK_TIME_GET(x)\
	FIELD_GET(HSCH_HSCH_TIMER_CFG_LEAK_TIME, x)

/*      HSCH:HSCH_LEAK_LISTS:HSCH_LEAK_CFG */
#define HSCH_HSCH_LEAK_CFG(g, r)  __REG(TARGET_HSCH,\
					0, 1, 161664, g, 4, 32, 16, r, 4, 4)

#define HSCH_HSCH_LEAK_CFG_LEAK_FIRST            GENMASK(16, 1)
#define HSCH_HSCH_LEAK_CFG_LEAK_FIRST_SET(x)\
	FIELD_PREP(HSCH_HSCH_LEAK_CFG_LEAK_FIRST, x)
#define HSCH_HSCH_LEAK_CFG_LEAK_FIRST_GET(x)\
	FIELD_GET(HSCH_HSCH_LEAK_CFG_LEAK_FIRST, x)

#define HSCH_HSCH_LEAK_CFG_LEAK_ERR              BIT(0)
#define HSCH_HSCH_LEAK_CFG_LEAK_ERR_SET(x)\
	FIELD_PREP(HSCH_HSCH_LEAK_CFG_LEAK_ERR, x)
#define HSCH_HSCH_LEAK_CFG_LEAK_ERR_GET(x)\
	FIELD_GET(HSCH_HSCH_LEAK_CFG_LEAK_ERR, x)

/*      HSCH:SYSTEM:FLUSH_CTRL */
#define HSCH_FLUSH_CTRL           __REG(TARGET_HSCH,\
					0, 1, 184000, 0, 1, 312, 4, 0, 1, 4)

#define HSCH_FLUSH_CTRL_FLUSH_ENA                BIT(27)
#define HSCH_FLUSH_CTRL_FLUSH_ENA_SET(x)\
	FIELD_PREP(HSCH_FLUSH_CTRL_FLUSH_ENA, x)
#define HSCH_FLUSH_CTRL_FLUSH_ENA_GET(x)\
	FIELD_GET(HSCH_FLUSH_CTRL_FLUSH_ENA, x)

#define HSCH_FLUSH_CTRL_FLUSH_SRC                BIT(26)
#define HSCH_FLUSH_CTRL_FLUSH_SRC_SET(x)\
	FIELD_PREP(HSCH_FLUSH_CTRL_FLUSH_SRC, x)
#define HSCH_FLUSH_CTRL_FLUSH_SRC_GET(x)\
	FIELD_GET(HSCH_FLUSH_CTRL_FLUSH_SRC, x)

#define HSCH_FLUSH_CTRL_FLUSH_DST                BIT(25)
#define HSCH_FLUSH_CTRL_FLUSH_DST_SET(x)\
	FIELD_PREP(HSCH_FLUSH_CTRL_FLUSH_DST, x)
#define HSCH_FLUSH_CTRL_FLUSH_DST_GET(x)\
	FIELD_GET(HSCH_FLUSH_CTRL_FLUSH_DST, x)

#define HSCH_FLUSH_CTRL_FLUSH_PORT               GENMASK(24, 18)
#define HSCH_FLUSH_CTRL_FLUSH_PORT_SET(x)\
	FIELD_PREP(HSCH_FLUSH_CTRL_FLUSH_PORT, x)
#define HSCH_FLUSH_CTRL_FLUSH_PORT_GET(x)\
	FIELD_GET(HSCH_FLUSH_CTRL_FLUSH_PORT, x)

#define HSCH_FLUSH_CTRL_FLUSH_QUEUE              BIT(17)
#define HSCH_FLUSH_CTRL_FLUSH_QUEUE_SET(x)\
	FIELD_PREP(HSCH_FLUSH_CTRL_FLUSH_QUEUE, x)
#define HSCH_FLUSH_CTRL_FLUSH_QUEUE_GET(x)\
	FIELD_GET(HSCH_FLUSH_CTRL_FLUSH_QUEUE, x)

#define HSCH_FLUSH_CTRL_FLUSH_SE                 BIT(16)
#define HSCH_FLUSH_CTRL_FLUSH_SE_SET(x)\
	FIELD_PREP(HSCH_FLUSH_CTRL_FLUSH_SE, x)
#define HSCH_FLUSH_CTRL_FLUSH_SE_GET(x)\
	FIELD_GET(HSCH_FLUSH_CTRL_FLUSH_SE, x)

#define HSCH_FLUSH_CTRL_FLUSH_HIER               GENMASK(15, 0)
#define HSCH_FLUSH_CTRL_FLUSH_HIER_SET(x)\
	FIELD_PREP(HSCH_FLUSH_CTRL_FLUSH_HIER, x)
#define HSCH_FLUSH_CTRL_FLUSH_HIER_GET(x)\
	FIELD_GET(HSCH_FLUSH_CTRL_FLUSH_HIER, x)

/*      HSCH:SYSTEM:PORT_MODE */
#define HSCH_PORT_MODE(r)         __REG(TARGET_HSCH,\
					0, 1, 184000, 0, 1, 312, 8, r, 70, 4)

#define HSCH_PORT_MODE_DEQUEUE_DIS               BIT(4)
#define HSCH_PORT_MODE_DEQUEUE_DIS_SET(x)\
	FIELD_PREP(HSCH_PORT_MODE_DEQUEUE_DIS, x)
#define HSCH_PORT_MODE_DEQUEUE_DIS_GET(x)\
	FIELD_GET(HSCH_PORT_MODE_DEQUEUE_DIS, x)

#define HSCH_PORT_MODE_AGE_DIS                   BIT(3)
#define HSCH_PORT_MODE_AGE_DIS_SET(x)\
	FIELD_PREP(HSCH_PORT_MODE_AGE_DIS, x)
#define HSCH_PORT_MODE_AGE_DIS_GET(x)\
	FIELD_GET(HSCH_PORT_MODE_AGE_DIS, x)

#define HSCH_PORT_MODE_TRUNC_ENA                 BIT(2)
#define HSCH_PORT_MODE_TRUNC_ENA_SET(x)\
	FIELD_PREP(HSCH_PORT_MODE_TRUNC_ENA, x)
#define HSCH_PORT_MODE_TRUNC_ENA_GET(x)\
	FIELD_GET(HSCH_PORT_MODE_TRUNC_ENA, x)

#define HSCH_PORT_MODE_EIR_REMARK_ENA            BIT(1)
#define HSCH_PORT_MODE_EIR_REMARK_ENA_SET(x)\
	FIELD_PREP(HSCH_PORT_MODE_EIR_REMARK_ENA, x)
#define HSCH_PORT_MODE_EIR_REMARK_ENA_GET(x)\
	FIELD_GET(HSCH_PORT_MODE_EIR_REMARK_ENA, x)

#define HSCH_PORT_MODE_CPU_PRIO_MODE             BIT(0)
#define HSCH_PORT_MODE_CPU_PRIO_MODE_SET(x)\
	FIELD_PREP(HSCH_PORT_MODE_CPU_PRIO_MODE, x)
#define HSCH_PORT_MODE_CPU_PRIO_MODE_GET(x)\
	FIELD_GET(HSCH_PORT_MODE_CPU_PRIO_MODE, x)

/*      HSCH:SYSTEM:OUTB_SHARE_ENA */
#define HSCH_OUTB_SHARE_ENA(r)    __REG(TARGET_HSCH,\
					0, 1, 184000, 0, 1, 312, 288, r, 5, 4)

#define HSCH_OUTB_SHARE_ENA_OUTB_SHARE_ENA       GENMASK(7, 0)
#define HSCH_OUTB_SHARE_ENA_OUTB_SHARE_ENA_SET(x)\
	FIELD_PREP(HSCH_OUTB_SHARE_ENA_OUTB_SHARE_ENA, x)
#define HSCH_OUTB_SHARE_ENA_OUTB_SHARE_ENA_GET(x)\
	FIELD_GET(HSCH_OUTB_SHARE_ENA_OUTB_SHARE_ENA, x)

/*      HSCH:MMGT:RESET_CFG */
#define HSCH_RESET_CFG            __REG(TARGET_HSCH,\
					0, 1, 162368, 0, 1, 16, 8, 0, 1, 4)

#define HSCH_RESET_CFG_CORE_ENA                  BIT(0)
#define HSCH_RESET_CFG_CORE_ENA_SET(x)\
	FIELD_PREP(HSCH_RESET_CFG_CORE_ENA, x)
#define HSCH_RESET_CFG_CORE_ENA_GET(x)\
	FIELD_GET(HSCH_RESET_CFG_CORE_ENA, x)

/*      HSCH:TAS_CONFIG:TAS_STATEMACHINE_CFG */
#define HSCH_TAS_STATEMACHINE_CFG __REG(TARGET_HSCH,\
					0, 1, 162384, 0, 1, 12, 8, 0, 1, 4)

#define HSCH_TAS_STATEMACHINE_CFG_REVISIT_DLY    GENMASK(7, 0)
#define HSCH_TAS_STATEMACHINE_CFG_REVISIT_DLY_SET(x)\
	FIELD_PREP(HSCH_TAS_STATEMACHINE_CFG_REVISIT_DLY, x)
#define HSCH_TAS_STATEMACHINE_CFG_REVISIT_DLY_GET(x)\
	FIELD_GET(HSCH_TAS_STATEMACHINE_CFG_REVISIT_DLY, x)

/*      LRN:COMMON:COMMON_ACCESS_CTRL */
#define LRN_COMMON_ACCESS_CTRL    __REG(TARGET_LRN,\
					0, 1, 0, 0, 1, 72, 0, 0, 1, 4)

#define LRN_COMMON_ACCESS_CTRL_CPU_ACCESS_DIRECT_COL GENMASK(21, 20)
#define LRN_COMMON_ACCESS_CTRL_CPU_ACCESS_DIRECT_COL_SET(x)\
	FIELD_PREP(LRN_COMMON_ACCESS_CTRL_CPU_ACCESS_DIRECT_COL, x)
#define LRN_COMMON_ACCESS_CTRL_CPU_ACCESS_DIRECT_COL_GET(x)\
	FIELD_GET(LRN_COMMON_ACCESS_CTRL_CPU_ACCESS_DIRECT_COL, x)

#define LRN_COMMON_ACCESS_CTRL_CPU_ACCESS_DIRECT_TYPE BIT(19)
#define LRN_COMMON_ACCESS_CTRL_CPU_ACCESS_DIRECT_TYPE_SET(x)\
	FIELD_PREP(LRN_COMMON_ACCESS_CTRL_CPU_ACCESS_DIRECT_TYPE, x)
#define LRN_COMMON_ACCESS_CTRL_CPU_ACCESS_DIRECT_TYPE_GET(x)\
	FIELD_GET(LRN_COMMON_ACCESS_CTRL_CPU_ACCESS_DIRECT_TYPE, x)

#define LRN_COMMON_ACCESS_CTRL_CPU_ACCESS_DIRECT_ROW GENMASK(18, 5)
#define LRN_COMMON_ACCESS_CTRL_CPU_ACCESS_DIRECT_ROW_SET(x)\
	FIELD_PREP(LRN_COMMON_ACCESS_CTRL_CPU_ACCESS_DIRECT_ROW, x)
#define LRN_COMMON_ACCESS_CTRL_CPU_ACCESS_DIRECT_ROW_GET(x)\
	FIELD_GET(LRN_COMMON_ACCESS_CTRL_CPU_ACCESS_DIRECT_ROW, x)

#define LRN_COMMON_ACCESS_CTRL_CPU_ACCESS_CMD    GENMASK(4, 1)
#define LRN_COMMON_ACCESS_CTRL_CPU_ACCESS_CMD_SET(x)\
	FIELD_PREP(LRN_COMMON_ACCESS_CTRL_CPU_ACCESS_CMD, x)
#define LRN_COMMON_ACCESS_CTRL_CPU_ACCESS_CMD_GET(x)\
	FIELD_GET(LRN_COMMON_ACCESS_CTRL_CPU_ACCESS_CMD, x)

#define LRN_COMMON_ACCESS_CTRL_MAC_TABLE_ACCESS_SHOT BIT(0)
#define LRN_COMMON_ACCESS_CTRL_MAC_TABLE_ACCESS_SHOT_SET(x)\
	FIELD_PREP(LRN_COMMON_ACCESS_CTRL_MAC_TABLE_ACCESS_SHOT, x)
#define LRN_COMMON_ACCESS_CTRL_MAC_TABLE_ACCESS_SHOT_GET(x)\
	FIELD_GET(LRN_COMMON_ACCESS_CTRL_MAC_TABLE_ACCESS_SHOT, x)

/*      LRN:COMMON:MAC_ACCESS_CFG_0 */
#define LRN_MAC_ACCESS_CFG_0      __REG(TARGET_LRN,\
					0, 1, 0, 0, 1, 72, 4, 0, 1, 4)

#define LRN_MAC_ACCESS_CFG_0_MAC_ENTRY_FID       GENMASK(28, 16)
#define LRN_MAC_ACCESS_CFG_0_MAC_ENTRY_FID_SET(x)\
	FIELD_PREP(LRN_MAC_ACCESS_CFG_0_MAC_ENTRY_FID, x)
#define LRN_MAC_ACCESS_CFG_0_MAC_ENTRY_FID_GET(x)\
	FIELD_GET(LRN_MAC_ACCESS_CFG_0_MAC_ENTRY_FID, x)

#define LRN_MAC_ACCESS_CFG_0_MAC_ENTRY_MAC_MSB   GENMASK(15, 0)
#define LRN_MAC_ACCESS_CFG_0_MAC_ENTRY_MAC_MSB_SET(x)\
	FIELD_PREP(LRN_MAC_ACCESS_CFG_0_MAC_ENTRY_MAC_MSB, x)
#define LRN_MAC_ACCESS_CFG_0_MAC_ENTRY_MAC_MSB_GET(x)\
	FIELD_GET(LRN_MAC_ACCESS_CFG_0_MAC_ENTRY_MAC_MSB, x)

/*      LRN:COMMON:MAC_ACCESS_CFG_1 */
#define LRN_MAC_ACCESS_CFG_1      __REG(TARGET_LRN,\
					0, 1, 0, 0, 1, 72, 8, 0, 1, 4)

/*      LRN:COMMON:MAC_ACCESS_CFG_2 */
#define LRN_MAC_ACCESS_CFG_2      __REG(TARGET_LRN,\
					0, 1, 0, 0, 1, 72, 12, 0, 1, 4)

#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_SRC_KILL_FWD BIT(28)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_SRC_KILL_FWD_SET(x)\
	FIELD_PREP(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_SRC_KILL_FWD, x)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_SRC_KILL_FWD_GET(x)\
	FIELD_GET(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_SRC_KILL_FWD, x)

#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_NXT_LRN_ALL BIT(27)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_NXT_LRN_ALL_SET(x)\
	FIELD_PREP(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_NXT_LRN_ALL, x)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_NXT_LRN_ALL_GET(x)\
	FIELD_GET(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_NXT_LRN_ALL, x)

#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_CPU_QU    GENMASK(26, 24)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_CPU_QU_SET(x)\
	FIELD_PREP(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_CPU_QU, x)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_CPU_QU_GET(x)\
	FIELD_GET(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_CPU_QU, x)

#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_CPU_COPY  BIT(23)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_CPU_COPY_SET(x)\
	FIELD_PREP(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_CPU_COPY, x)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_CPU_COPY_GET(x)\
	FIELD_GET(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_CPU_COPY, x)

#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_VLAN_IGNORE BIT(22)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_VLAN_IGNORE_SET(x)\
	FIELD_PREP(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_VLAN_IGNORE, x)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_VLAN_IGNORE_GET(x)\
	FIELD_GET(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_VLAN_IGNORE, x)

#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_MIRROR    BIT(21)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_MIRROR_SET(x)\
	FIELD_PREP(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_MIRROR, x)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_MIRROR_GET(x)\
	FIELD_GET(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_MIRROR, x)

#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_AGE_FLAG  GENMASK(20, 19)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_AGE_FLAG_SET(x)\
	FIELD_PREP(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_AGE_FLAG, x)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_AGE_FLAG_GET(x)\
	FIELD_GET(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_AGE_FLAG, x)

#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_AGE_INTERVAL GENMASK(18, 17)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_AGE_INTERVAL_SET(x)\
	FIELD_PREP(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_AGE_INTERVAL, x)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_AGE_INTERVAL_GET(x)\
	FIELD_GET(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_AGE_INTERVAL, x)

#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_LOCKED    BIT(16)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_LOCKED_SET(x)\
	FIELD_PREP(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_LOCKED, x)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_LOCKED_GET(x)\
	FIELD_GET(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_LOCKED, x)

#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_VLD       BIT(15)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_VLD_SET(x)\
	FIELD_PREP(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_VLD, x)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_VLD_GET(x)\
	FIELD_GET(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_VLD, x)

#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_ADDR_TYPE GENMASK(14, 12)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_ADDR_TYPE_SET(x)\
	FIELD_PREP(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_ADDR_TYPE, x)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_ADDR_TYPE_GET(x)\
	FIELD_GET(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_ADDR_TYPE, x)

#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_ADDR      GENMASK(11, 0)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_ADDR_SET(x)\
	FIELD_PREP(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_ADDR, x)
#define LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_ADDR_GET(x)\
	FIELD_GET(LRN_MAC_ACCESS_CFG_2_MAC_ENTRY_ADDR, x)

/*      LRN:COMMON:MAC_ACCESS_CFG_3 */
#define LRN_MAC_ACCESS_CFG_3      __REG(TARGET_LRN,\
					0, 1, 0, 0, 1, 72, 16, 0, 1, 4)

#define LRN_MAC_ACCESS_CFG_3_MAC_ENTRY_ISDX_LIMIT_IDX GENMASK(10, 0)
#define LRN_MAC_ACCESS_CFG_3_MAC_ENTRY_ISDX_LIMIT_IDX_SET(x)\
	FIELD_PREP(LRN_MAC_ACCESS_CFG_3_MAC_ENTRY_ISDX_LIMIT_IDX, x)
#define LRN_MAC_ACCESS_CFG_3_MAC_ENTRY_ISDX_LIMIT_IDX_GET(x)\
	FIELD_GET(LRN_MAC_ACCESS_CFG_3_MAC_ENTRY_ISDX_LIMIT_IDX, x)

/*      LRN:COMMON:SCAN_NEXT_CFG */
#define LRN_SCAN_NEXT_CFG         __REG(TARGET_LRN,\
					0, 1, 0, 0, 1, 72, 20, 0, 1, 4)

#define LRN_SCAN_NEXT_CFG_SCAN_AGE_FLAG_UPDATE_SEL GENMASK(21, 19)
#define LRN_SCAN_NEXT_CFG_SCAN_AGE_FLAG_UPDATE_SEL_SET(x)\
	FIELD_PREP(LRN_SCAN_NEXT_CFG_SCAN_AGE_FLAG_UPDATE_SEL, x)
#define LRN_SCAN_NEXT_CFG_SCAN_AGE_FLAG_UPDATE_SEL_GET(x)\
	FIELD_GET(LRN_SCAN_NEXT_CFG_SCAN_AGE_FLAG_UPDATE_SEL, x)

#define LRN_SCAN_NEXT_CFG_SCAN_NXT_LRN_ALL_UPDATE_SEL GENMASK(18, 17)
#define LRN_SCAN_NEXT_CFG_SCAN_NXT_LRN_ALL_UPDATE_SEL_SET(x)\
	FIELD_PREP(LRN_SCAN_NEXT_CFG_SCAN_NXT_LRN_ALL_UPDATE_SEL, x)
#define LRN_SCAN_NEXT_CFG_SCAN_NXT_LRN_ALL_UPDATE_SEL_GET(x)\
	FIELD_GET(LRN_SCAN_NEXT_CFG_SCAN_NXT_LRN_ALL_UPDATE_SEL, x)

#define LRN_SCAN_NEXT_CFG_SCAN_AGE_FILTER_SEL    GENMASK(16, 15)
#define LRN_SCAN_NEXT_CFG_SCAN_AGE_FILTER_SEL_SET(x)\
	FIELD_PREP(LRN_SCAN_NEXT_CFG_SCAN_AGE_FILTER_SEL, x)
#define LRN_SCAN_NEXT_CFG_SCAN_AGE_FILTER_SEL_GET(x)\
	FIELD_GET(LRN_SCAN_NEXT_CFG_SCAN_AGE_FILTER_SEL, x)

#define LRN_SCAN_NEXT_CFG_SCAN_NEXT_MOVE_FOUND_ENA BIT(14)
#define LRN_SCAN_NEXT_CFG_SCAN_NEXT_MOVE_FOUND_ENA_SET(x)\
	FIELD_PREP(LRN_SCAN_NEXT_CFG_SCAN_NEXT_MOVE_FOUND_ENA, x)
#define LRN_SCAN_NEXT_CFG_SCAN_NEXT_MOVE_FOUND_ENA_GET(x)\
	FIELD_GET(LRN_SCAN_NEXT_CFG_SCAN_NEXT_MOVE_FOUND_ENA, x)

#define LRN_SCAN_NEXT_CFG_NXT_LRN_ALL_FILTER_ENA BIT(13)
#define LRN_SCAN_NEXT_CFG_NXT_LRN_ALL_FILTER_ENA_SET(x)\
	FIELD_PREP(LRN_SCAN_NEXT_CFG_NXT_LRN_ALL_FILTER_ENA, x)
#define LRN_SCAN_NEXT_CFG_NXT_LRN_ALL_FILTER_ENA_GET(x)\
	FIELD_GET(LRN_SCAN_NEXT_CFG_NXT_LRN_ALL_FILTER_ENA, x)

#define LRN_SCAN_NEXT_CFG_SCAN_USE_PORT_FILTER_ENA BIT(12)
#define LRN_SCAN_NEXT_CFG_SCAN_USE_PORT_FILTER_ENA_SET(x)\
	FIELD_PREP(LRN_SCAN_NEXT_CFG_SCAN_USE_PORT_FILTER_ENA, x)
#define LRN_SCAN_NEXT_CFG_SCAN_USE_PORT_FILTER_ENA_GET(x)\
	FIELD_GET(LRN_SCAN_NEXT_CFG_SCAN_USE_PORT_FILTER_ENA, x)

#define LRN_SCAN_NEXT_CFG_SCAN_NEXT_REMOVE_FOUND_ENA BIT(11)
#define LRN_SCAN_NEXT_CFG_SCAN_NEXT_REMOVE_FOUND_ENA_SET(x)\
	FIELD_PREP(LRN_SCAN_NEXT_CFG_SCAN_NEXT_REMOVE_FOUND_ENA, x)
#define LRN_SCAN_NEXT_CFG_SCAN_NEXT_REMOVE_FOUND_ENA_GET(x)\
	FIELD_GET(LRN_SCAN_NEXT_CFG_SCAN_NEXT_REMOVE_FOUND_ENA, x)

#define LRN_SCAN_NEXT_CFG_SCAN_NEXT_UNTIL_FOUND_ENA BIT(10)
#define LRN_SCAN_NEXT_CFG_SCAN_NEXT_UNTIL_FOUND_ENA_SET(x)\
	FIELD_PREP(LRN_SCAN_NEXT_CFG_SCAN_NEXT_UNTIL_FOUND_ENA, x)
#define LRN_SCAN_NEXT_CFG_SCAN_NEXT_UNTIL_FOUND_ENA_GET(x)\
	FIELD_GET(LRN_SCAN_NEXT_CFG_SCAN_NEXT_UNTIL_FOUND_ENA, x)

#define LRN_SCAN_NEXT_CFG_SCAN_NEXT_INC_AGE_BITS_ENA BIT(9)
#define LRN_SCAN_NEXT_CFG_SCAN_NEXT_INC_AGE_BITS_ENA_SET(x)\
	FIELD_PREP(LRN_SCAN_NEXT_CFG_SCAN_NEXT_INC_AGE_BITS_ENA, x)
#define LRN_SCAN_NEXT_CFG_SCAN_NEXT_INC_AGE_BITS_ENA_GET(x)\
	FIELD_GET(LRN_SCAN_NEXT_CFG_SCAN_NEXT_INC_AGE_BITS_ENA, x)

#define LRN_SCAN_NEXT_CFG_SCAN_NEXT_AGED_ONLY_ENA BIT(8)
#define LRN_SCAN_NEXT_CFG_SCAN_NEXT_AGED_ONLY_ENA_SET(x)\
	FIELD_PREP(LRN_SCAN_NEXT_CFG_SCAN_NEXT_AGED_ONLY_ENA, x)
#define LRN_SCAN_NEXT_CFG_SCAN_NEXT_AGED_ONLY_ENA_GET(x)\
	FIELD_GET(LRN_SCAN_NEXT_CFG_SCAN_NEXT_AGED_ONLY_ENA, x)

#define LRN_SCAN_NEXT_CFG_SCAN_NEXT_IGNORE_LOCKED_ENA BIT(7)
#define LRN_SCAN_NEXT_CFG_SCAN_NEXT_IGNORE_LOCKED_ENA_SET(x)\
	FIELD_PREP(LRN_SCAN_NEXT_CFG_SCAN_NEXT_IGNORE_LOCKED_ENA, x)
#define LRN_SCAN_NEXT_CFG_SCAN_NEXT_IGNORE_LOCKED_ENA_GET(x)\
	FIELD_GET(LRN_SCAN_NEXT_CFG_SCAN_NEXT_IGNORE_LOCKED_ENA, x)

#define LRN_SCAN_NEXT_CFG_SCAN_AGE_INTERVAL_MASK GENMASK(6, 3)
#define LRN_SCAN_NEXT_CFG_SCAN_AGE_INTERVAL_MASK_SET(x)\
	FIELD_PREP(LRN_SCAN_NEXT_CFG_SCAN_AGE_INTERVAL_MASK, x)
#define LRN_SCAN_NEXT_CFG_SCAN_AGE_INTERVAL_MASK_GET(x)\
	FIELD_GET(LRN_SCAN_NEXT_CFG_SCAN_AGE_INTERVAL_MASK, x)

#define LRN_SCAN_NEXT_CFG_ISDX_LIMIT_IDX_FILTER_ENA BIT(2)
#define LRN_SCAN_NEXT_CFG_ISDX_LIMIT_IDX_FILTER_ENA_SET(x)\
	FIELD_PREP(LRN_SCAN_NEXT_CFG_ISDX_LIMIT_IDX_FILTER_ENA, x)
#define LRN_SCAN_NEXT_CFG_ISDX_LIMIT_IDX_FILTER_ENA_GET(x)\
	FIELD_GET(LRN_SCAN_NEXT_CFG_ISDX_LIMIT_IDX_FILTER_ENA, x)

#define LRN_SCAN_NEXT_CFG_FID_FILTER_ENA         BIT(1)
#define LRN_SCAN_NEXT_CFG_FID_FILTER_ENA_SET(x)\
	FIELD_PREP(LRN_SCAN_NEXT_CFG_FID_FILTER_ENA, x)
#define LRN_SCAN_NEXT_CFG_FID_FILTER_ENA_GET(x)\
	FIELD_GET(LRN_SCAN_NEXT_CFG_FID_FILTER_ENA, x)

#define LRN_SCAN_NEXT_CFG_ADDR_FILTER_ENA        BIT(0)
#define LRN_SCAN_NEXT_CFG_ADDR_FILTER_ENA_SET(x)\
	FIELD_PREP(LRN_SCAN_NEXT_CFG_ADDR_FILTER_ENA, x)
#define LRN_SCAN_NEXT_CFG_ADDR_FILTER_ENA_GET(x)\
	FIELD_GET(LRN_SCAN_NEXT_CFG_ADDR_FILTER_ENA, x)

/*      LRN:COMMON:SCAN_NEXT_CFG_1 */
#define LRN_SCAN_NEXT_CFG_1       __REG(TARGET_LRN,\
					0, 1, 0, 0, 1, 72, 24, 0, 1, 4)

#define LRN_SCAN_NEXT_CFG_1_PORT_MOVE_NEW_ADDR   GENMASK(30, 16)
#define LRN_SCAN_NEXT_CFG_1_PORT_MOVE_NEW_ADDR_SET(x)\
	FIELD_PREP(LRN_SCAN_NEXT_CFG_1_PORT_MOVE_NEW_ADDR, x)
#define LRN_SCAN_NEXT_CFG_1_PORT_MOVE_NEW_ADDR_GET(x)\
	FIELD_GET(LRN_SCAN_NEXT_CFG_1_PORT_MOVE_NEW_ADDR, x)

#define LRN_SCAN_NEXT_CFG_1_SCAN_ENTRY_ADDR_MASK GENMASK(14, 0)
#define LRN_SCAN_NEXT_CFG_1_SCAN_ENTRY_ADDR_MASK_SET(x)\
	FIELD_PREP(LRN_SCAN_NEXT_CFG_1_SCAN_ENTRY_ADDR_MASK, x)
#define LRN_SCAN_NEXT_CFG_1_SCAN_ENTRY_ADDR_MASK_GET(x)\
	FIELD_GET(LRN_SCAN_NEXT_CFG_1_SCAN_ENTRY_ADDR_MASK, x)

/*      LRN:COMMON:AUTOAGE_CFG */
#define LRN_AUTOAGE_CFG(r)        __REG(TARGET_LRN,\
					0, 1, 0, 0, 1, 72, 36, r, 4, 4)

#define LRN_AUTOAGE_CFG_UNIT_SIZE                GENMASK(29, 28)
#define LRN_AUTOAGE_CFG_UNIT_SIZE_SET(x)\
	FIELD_PREP(LRN_AUTOAGE_CFG_UNIT_SIZE, x)
#define LRN_AUTOAGE_CFG_UNIT_SIZE_GET(x)\
	FIELD_GET(LRN_AUTOAGE_CFG_UNIT_SIZE, x)

#define LRN_AUTOAGE_CFG_PERIOD_VAL               GENMASK(27, 0)
#define LRN_AUTOAGE_CFG_PERIOD_VAL_SET(x)\
	FIELD_PREP(LRN_AUTOAGE_CFG_PERIOD_VAL, x)
#define LRN_AUTOAGE_CFG_PERIOD_VAL_GET(x)\
	FIELD_GET(LRN_AUTOAGE_CFG_PERIOD_VAL, x)

/*      LRN:COMMON:AUTOAGE_CFG_1 */
#define LRN_AUTOAGE_CFG_1         __REG(TARGET_LRN,\
					0, 1, 0, 0, 1, 72, 52, 0, 1, 4)

#define LRN_AUTOAGE_CFG_1_PAUSE_AUTO_AGE_ENA     BIT(25)
#define LRN_AUTOAGE_CFG_1_PAUSE_AUTO_AGE_ENA_SET(x)\
	FIELD_PREP(LRN_AUTOAGE_CFG_1_PAUSE_AUTO_AGE_ENA, x)
#define LRN_AUTOAGE_CFG_1_PAUSE_AUTO_AGE_ENA_GET(x)\
	FIELD_GET(LRN_AUTOAGE_CFG_1_PAUSE_AUTO_AGE_ENA, x)

#define LRN_AUTOAGE_CFG_1_CELLS_BETWEEN_ENTRY_SCAN GENMASK(24, 15)
#define LRN_AUTOAGE_CFG_1_CELLS_BETWEEN_ENTRY_SCAN_SET(x)\
	FIELD_PREP(LRN_AUTOAGE_CFG_1_CELLS_BETWEEN_ENTRY_SCAN, x)
#define LRN_AUTOAGE_CFG_1_CELLS_BETWEEN_ENTRY_SCAN_GET(x)\
	FIELD_GET(LRN_AUTOAGE_CFG_1_CELLS_BETWEEN_ENTRY_SCAN, x)

#define LRN_AUTOAGE_CFG_1_CLK_PERIOD_01NS        GENMASK(14, 7)
#define LRN_AUTOAGE_CFG_1_CLK_PERIOD_01NS_SET(x)\
	FIELD_PREP(LRN_AUTOAGE_CFG_1_CLK_PERIOD_01NS, x)
#define LRN_AUTOAGE_CFG_1_CLK_PERIOD_01NS_GET(x)\
	FIELD_GET(LRN_AUTOAGE_CFG_1_CLK_PERIOD_01NS, x)

#define LRN_AUTOAGE_CFG_1_USE_PORT_FILTER_ENA    BIT(6)
#define LRN_AUTOAGE_CFG_1_USE_PORT_FILTER_ENA_SET(x)\
	FIELD_PREP(LRN_AUTOAGE_CFG_1_USE_PORT_FILTER_ENA, x)
#define LRN_AUTOAGE_CFG_1_USE_PORT_FILTER_ENA_GET(x)\
	FIELD_GET(LRN_AUTOAGE_CFG_1_USE_PORT_FILTER_ENA, x)

#define LRN_AUTOAGE_CFG_1_FORCE_HW_SCAN_SHOT     GENMASK(5, 2)
#define LRN_AUTOAGE_CFG_1_FORCE_HW_SCAN_SHOT_SET(x)\
	FIELD_PREP(LRN_AUTOAGE_CFG_1_FORCE_HW_SCAN_SHOT, x)
#define LRN_AUTOAGE_CFG_1_FORCE_HW_SCAN_SHOT_GET(x)\
	FIELD_GET(LRN_AUTOAGE_CFG_1_FORCE_HW_SCAN_SHOT, x)

#define LRN_AUTOAGE_CFG_1_FORCE_HW_SCAN_STOP_SHOT BIT(1)
#define LRN_AUTOAGE_CFG_1_FORCE_HW_SCAN_STOP_SHOT_SET(x)\
	FIELD_PREP(LRN_AUTOAGE_CFG_1_FORCE_HW_SCAN_STOP_SHOT, x)
#define LRN_AUTOAGE_CFG_1_FORCE_HW_SCAN_STOP_SHOT_GET(x)\
	FIELD_GET(LRN_AUTOAGE_CFG_1_FORCE_HW_SCAN_STOP_SHOT, x)

#define LRN_AUTOAGE_CFG_1_FORCE_IDLE_ENA         BIT(0)
#define LRN_AUTOAGE_CFG_1_FORCE_IDLE_ENA_SET(x)\
	FIELD_PREP(LRN_AUTOAGE_CFG_1_FORCE_IDLE_ENA, x)
#define LRN_AUTOAGE_CFG_1_FORCE_IDLE_ENA_GET(x)\
	FIELD_GET(LRN_AUTOAGE_CFG_1_FORCE_IDLE_ENA, x)

/*      LRN:COMMON:AUTOAGE_CFG_2 */
#define LRN_AUTOAGE_CFG_2         __REG(TARGET_LRN,\
					0, 1, 0, 0, 1, 72, 56, 0, 1, 4)

#define LRN_AUTOAGE_CFG_2_NEXT_ROW               GENMASK(17, 4)
#define LRN_AUTOAGE_CFG_2_NEXT_ROW_SET(x)\
	FIELD_PREP(LRN_AUTOAGE_CFG_2_NEXT_ROW, x)
#define LRN_AUTOAGE_CFG_2_NEXT_ROW_GET(x)\
	FIELD_GET(LRN_AUTOAGE_CFG_2_NEXT_ROW, x)

#define LRN_AUTOAGE_CFG_2_SCAN_ONGOING_STATUS    GENMASK(3, 0)
#define LRN_AUTOAGE_CFG_2_SCAN_ONGOING_STATUS_SET(x)\
	FIELD_PREP(LRN_AUTOAGE_CFG_2_SCAN_ONGOING_STATUS, x)
#define LRN_AUTOAGE_CFG_2_SCAN_ONGOING_STATUS_GET(x)\
	FIELD_GET(LRN_AUTOAGE_CFG_2_SCAN_ONGOING_STATUS, x)

/*      PCIE_DM_EP:PF0_ATU_CAP:IATU_REGION_CTRL_2_OFF_OUTBOUND_0 */
#define PCEP_RCTRL_2_OUT_0        __REG(TARGET_PCEP,\
					0, 1, 3145728, 0, 1, 130852, 4, 0, 1, 4)

#define PCEP_RCTRL_2_OUT_0_MSG_CODE              GENMASK(7, 0)
#define PCEP_RCTRL_2_OUT_0_MSG_CODE_SET(x)\
	FIELD_PREP(PCEP_RCTRL_2_OUT_0_MSG_CODE, x)
#define PCEP_RCTRL_2_OUT_0_MSG_CODE_GET(x)\
	FIELD_GET(PCEP_RCTRL_2_OUT_0_MSG_CODE, x)

#define PCEP_RCTRL_2_OUT_0_TAG                   GENMASK(15, 8)
#define PCEP_RCTRL_2_OUT_0_TAG_SET(x)\
	FIELD_PREP(PCEP_RCTRL_2_OUT_0_TAG, x)
#define PCEP_RCTRL_2_OUT_0_TAG_GET(x)\
	FIELD_GET(PCEP_RCTRL_2_OUT_0_TAG, x)

#define PCEP_RCTRL_2_OUT_0_TAG_SUBSTITUTE_EN     BIT(16)
#define PCEP_RCTRL_2_OUT_0_TAG_SUBSTITUTE_EN_SET(x)\
	FIELD_PREP(PCEP_RCTRL_2_OUT_0_TAG_SUBSTITUTE_EN, x)
#define PCEP_RCTRL_2_OUT_0_TAG_SUBSTITUTE_EN_GET(x)\
	FIELD_GET(PCEP_RCTRL_2_OUT_0_TAG_SUBSTITUTE_EN, x)

#define PCEP_RCTRL_2_OUT_0_FUNC_BYPASS           BIT(19)
#define PCEP_RCTRL_2_OUT_0_FUNC_BYPASS_SET(x)\
	FIELD_PREP(PCEP_RCTRL_2_OUT_0_FUNC_BYPASS, x)
#define PCEP_RCTRL_2_OUT_0_FUNC_BYPASS_GET(x)\
	FIELD_GET(PCEP_RCTRL_2_OUT_0_FUNC_BYPASS, x)

#define PCEP_RCTRL_2_OUT_0_SNP                   BIT(20)
#define PCEP_RCTRL_2_OUT_0_SNP_SET(x)\
	FIELD_PREP(PCEP_RCTRL_2_OUT_0_SNP, x)
#define PCEP_RCTRL_2_OUT_0_SNP_GET(x)\
	FIELD_GET(PCEP_RCTRL_2_OUT_0_SNP, x)

#define PCEP_RCTRL_2_OUT_0_INHIBIT_PAYLOAD       BIT(22)
#define PCEP_RCTRL_2_OUT_0_INHIBIT_PAYLOAD_SET(x)\
	FIELD_PREP(PCEP_RCTRL_2_OUT_0_INHIBIT_PAYLOAD, x)
#define PCEP_RCTRL_2_OUT_0_INHIBIT_PAYLOAD_GET(x)\
	FIELD_GET(PCEP_RCTRL_2_OUT_0_INHIBIT_PAYLOAD, x)

#define PCEP_RCTRL_2_OUT_0_HEADER_SUBSTITUTE_EN  BIT(23)
#define PCEP_RCTRL_2_OUT_0_HEADER_SUBSTITUTE_EN_SET(x)\
	FIELD_PREP(PCEP_RCTRL_2_OUT_0_HEADER_SUBSTITUTE_EN, x)
#define PCEP_RCTRL_2_OUT_0_HEADER_SUBSTITUTE_EN_GET(x)\
	FIELD_GET(PCEP_RCTRL_2_OUT_0_HEADER_SUBSTITUTE_EN, x)

#define PCEP_RCTRL_2_OUT_0_CFG_SHIFT_MODE        BIT(28)
#define PCEP_RCTRL_2_OUT_0_CFG_SHIFT_MODE_SET(x)\
	FIELD_PREP(PCEP_RCTRL_2_OUT_0_CFG_SHIFT_MODE, x)
#define PCEP_RCTRL_2_OUT_0_CFG_SHIFT_MODE_GET(x)\
	FIELD_GET(PCEP_RCTRL_2_OUT_0_CFG_SHIFT_MODE, x)

#define PCEP_RCTRL_2_OUT_0_INVERT_MODE           BIT(29)
#define PCEP_RCTRL_2_OUT_0_INVERT_MODE_SET(x)\
	FIELD_PREP(PCEP_RCTRL_2_OUT_0_INVERT_MODE, x)
#define PCEP_RCTRL_2_OUT_0_INVERT_MODE_GET(x)\
	FIELD_GET(PCEP_RCTRL_2_OUT_0_INVERT_MODE, x)

#define PCEP_RCTRL_2_OUT_0_REGION_EN             BIT(31)
#define PCEP_RCTRL_2_OUT_0_REGION_EN_SET(x)\
	FIELD_PREP(PCEP_RCTRL_2_OUT_0_REGION_EN, x)
#define PCEP_RCTRL_2_OUT_0_REGION_EN_GET(x)\
	FIELD_GET(PCEP_RCTRL_2_OUT_0_REGION_EN, x)

/*      PCIE_DM_EP:PF0_ATU_CAP:IATU_LWR_BASE_ADDR_OFF_OUTBOUND_0 */
#define PCEP_ADDR_LWR_OUT_0       __REG(TARGET_PCEP,\
					0, 1, 3145728, 0, 1, 130852, 8, 0, 1, 4)

#define PCEP_ADDR_LWR_OUT_0_LWR_BASE_HW          GENMASK(15, 0)
#define PCEP_ADDR_LWR_OUT_0_LWR_BASE_HW_SET(x)\
	FIELD_PREP(PCEP_ADDR_LWR_OUT_0_LWR_BASE_HW, x)
#define PCEP_ADDR_LWR_OUT_0_LWR_BASE_HW_GET(x)\
	FIELD_GET(PCEP_ADDR_LWR_OUT_0_LWR_BASE_HW, x)

#define PCEP_ADDR_LWR_OUT_0_LWR_BASE_RW          GENMASK(31, 16)
#define PCEP_ADDR_LWR_OUT_0_LWR_BASE_RW_SET(x)\
	FIELD_PREP(PCEP_ADDR_LWR_OUT_0_LWR_BASE_RW, x)
#define PCEP_ADDR_LWR_OUT_0_LWR_BASE_RW_GET(x)\
	FIELD_GET(PCEP_ADDR_LWR_OUT_0_LWR_BASE_RW, x)

/*      PCIE_DM_EP:PF0_ATU_CAP:IATU_UPPER_BASE_ADDR_OFF_OUTBOUND_0 */
#define PCEP_ADDR_UPR_OUT_0       __REG(TARGET_PCEP,\
					0, 1, 3145728, 0, 1, 130852, 12, 0, 1, 4)

/*      PCIE_DM_EP:PF0_ATU_CAP:IATU_LIMIT_ADDR_OFF_OUTBOUND_0 */
#define PCEP_ADDR_LIM_OUT_0       __REG(TARGET_PCEP,\
					0, 1, 3145728, 0, 1, 130852, 16, 0, 1, 4)

#define PCEP_ADDR_LIM_OUT_0_LIMIT_ADDR_HW        GENMASK(15, 0)
#define PCEP_ADDR_LIM_OUT_0_LIMIT_ADDR_HW_SET(x)\
	FIELD_PREP(PCEP_ADDR_LIM_OUT_0_LIMIT_ADDR_HW, x)
#define PCEP_ADDR_LIM_OUT_0_LIMIT_ADDR_HW_GET(x)\
	FIELD_GET(PCEP_ADDR_LIM_OUT_0_LIMIT_ADDR_HW, x)

#define PCEP_ADDR_LIM_OUT_0_LIMIT_ADDR_RW        GENMASK(31, 16)
#define PCEP_ADDR_LIM_OUT_0_LIMIT_ADDR_RW_SET(x)\
	FIELD_PREP(PCEP_ADDR_LIM_OUT_0_LIMIT_ADDR_RW, x)
#define PCEP_ADDR_LIM_OUT_0_LIMIT_ADDR_RW_GET(x)\
	FIELD_GET(PCEP_ADDR_LIM_OUT_0_LIMIT_ADDR_RW, x)

/*      PCIE_DM_EP:PF0_ATU_CAP:IATU_LWR_TARGET_ADDR_OFF_OUTBOUND_0 */
#define PCEP_ADDR_LWR_TGT_OUT_0   __REG(TARGET_PCEP,\
					0, 1, 3145728, 0, 1, 130852, 20, 0, 1, 4)

/*      PCIE_DM_EP:PF0_ATU_CAP:IATU_UPPER_TARGET_ADDR_OFF_OUTBOUND_0 */
#define PCEP_ADDR_UPR_TGT_OUT_0   __REG(TARGET_PCEP,\
					0, 1, 3145728, 0, 1, 130852, 24, 0, 1, 4)

/*      PCIE_DM_EP:PF0_ATU_CAP:IATU_UPPR_LIMIT_ADDR_OFF_OUTBOUND_0 */
#define PCEP_ADDR_UPR_LIM_OUT_0   __REG(TARGET_PCEP,\
					0, 1, 3145728, 0, 1, 130852, 32, 0, 1, 4)

#define PCEP_ADDR_UPR_LIM_OUT_0_UPPR_LIMIT_ADDR_RW GENMASK(1, 0)
#define PCEP_ADDR_UPR_LIM_OUT_0_UPPR_LIMIT_ADDR_RW_SET(x)\
	FIELD_PREP(PCEP_ADDR_UPR_LIM_OUT_0_UPPR_LIMIT_ADDR_RW, x)
#define PCEP_ADDR_UPR_LIM_OUT_0_UPPR_LIMIT_ADDR_RW_GET(x)\
	FIELD_GET(PCEP_ADDR_UPR_LIM_OUT_0_UPPR_LIMIT_ADDR_RW, x)

#define PCEP_ADDR_UPR_LIM_OUT_0_UPPR_LIMIT_ADDR_HW GENMASK(31, 2)
#define PCEP_ADDR_UPR_LIM_OUT_0_UPPR_LIMIT_ADDR_HW_SET(x)\
	FIELD_PREP(PCEP_ADDR_UPR_LIM_OUT_0_UPPR_LIMIT_ADDR_HW, x)
#define PCEP_ADDR_UPR_LIM_OUT_0_UPPR_LIMIT_ADDR_HW_GET(x)\
	FIELD_GET(PCEP_ADDR_UPR_LIM_OUT_0_UPPR_LIMIT_ADDR_HW, x)

/*      PCS_10GBASE_R:PCS_10GBR_CFG:PCS_CFG */
#define PCS10G_BR_PCS_CFG(t)      __REG(TARGET_PCS10G_BR,\
					t, 12, 0, 0, 1, 56, 0, 0, 1, 4)

#define PCS10G_BR_PCS_CFG_PCS_ENA                BIT(31)
#define PCS10G_BR_PCS_CFG_PCS_ENA_SET(x)\
	FIELD_PREP(PCS10G_BR_PCS_CFG_PCS_ENA, x)
#define PCS10G_BR_PCS_CFG_PCS_ENA_GET(x)\
	FIELD_GET(PCS10G_BR_PCS_CFG_PCS_ENA, x)

#define PCS10G_BR_PCS_CFG_PMA_LOOPBACK_ENA       BIT(30)
#define PCS10G_BR_PCS_CFG_PMA_LOOPBACK_ENA_SET(x)\
	FIELD_PREP(PCS10G_BR_PCS_CFG_PMA_LOOPBACK_ENA, x)
#define PCS10G_BR_PCS_CFG_PMA_LOOPBACK_ENA_GET(x)\
	FIELD_GET(PCS10G_BR_PCS_CFG_PMA_LOOPBACK_ENA, x)

#define PCS10G_BR_PCS_CFG_SH_CNT_MAX             GENMASK(29, 24)
#define PCS10G_BR_PCS_CFG_SH_CNT_MAX_SET(x)\
	FIELD_PREP(PCS10G_BR_PCS_CFG_SH_CNT_MAX, x)
#define PCS10G_BR_PCS_CFG_SH_CNT_MAX_GET(x)\
	FIELD_GET(PCS10G_BR_PCS_CFG_SH_CNT_MAX, x)

#define PCS10G_BR_PCS_CFG_RX_DATA_FLIP           BIT(18)
#define PCS10G_BR_PCS_CFG_RX_DATA_FLIP_SET(x)\
	FIELD_PREP(PCS10G_BR_PCS_CFG_RX_DATA_FLIP, x)
#define PCS10G_BR_PCS_CFG_RX_DATA_FLIP_GET(x)\
	FIELD_GET(PCS10G_BR_PCS_CFG_RX_DATA_FLIP, x)

#define PCS10G_BR_PCS_CFG_RESYNC_ENA             BIT(15)
#define PCS10G_BR_PCS_CFG_RESYNC_ENA_SET(x)\
	FIELD_PREP(PCS10G_BR_PCS_CFG_RESYNC_ENA, x)
#define PCS10G_BR_PCS_CFG_RESYNC_ENA_GET(x)\
	FIELD_GET(PCS10G_BR_PCS_CFG_RESYNC_ENA, x)

#define PCS10G_BR_PCS_CFG_LF_GEN_DIS             BIT(14)
#define PCS10G_BR_PCS_CFG_LF_GEN_DIS_SET(x)\
	FIELD_PREP(PCS10G_BR_PCS_CFG_LF_GEN_DIS, x)
#define PCS10G_BR_PCS_CFG_LF_GEN_DIS_GET(x)\
	FIELD_GET(PCS10G_BR_PCS_CFG_LF_GEN_DIS, x)

#define PCS10G_BR_PCS_CFG_RX_TEST_MODE           BIT(13)
#define PCS10G_BR_PCS_CFG_RX_TEST_MODE_SET(x)\
	FIELD_PREP(PCS10G_BR_PCS_CFG_RX_TEST_MODE, x)
#define PCS10G_BR_PCS_CFG_RX_TEST_MODE_GET(x)\
	FIELD_GET(PCS10G_BR_PCS_CFG_RX_TEST_MODE, x)

#define PCS10G_BR_PCS_CFG_RX_SCR_DISABLE         BIT(12)
#define PCS10G_BR_PCS_CFG_RX_SCR_DISABLE_SET(x)\
	FIELD_PREP(PCS10G_BR_PCS_CFG_RX_SCR_DISABLE, x)
#define PCS10G_BR_PCS_CFG_RX_SCR_DISABLE_GET(x)\
	FIELD_GET(PCS10G_BR_PCS_CFG_RX_SCR_DISABLE, x)

#define PCS10G_BR_PCS_CFG_TX_DATA_FLIP           BIT(7)
#define PCS10G_BR_PCS_CFG_TX_DATA_FLIP_SET(x)\
	FIELD_PREP(PCS10G_BR_PCS_CFG_TX_DATA_FLIP, x)
#define PCS10G_BR_PCS_CFG_TX_DATA_FLIP_GET(x)\
	FIELD_GET(PCS10G_BR_PCS_CFG_TX_DATA_FLIP, x)

#define PCS10G_BR_PCS_CFG_AN_LINK_CTRL_ENA       BIT(6)
#define PCS10G_BR_PCS_CFG_AN_LINK_CTRL_ENA_SET(x)\
	FIELD_PREP(PCS10G_BR_PCS_CFG_AN_LINK_CTRL_ENA, x)
#define PCS10G_BR_PCS_CFG_AN_LINK_CTRL_ENA_GET(x)\
	FIELD_GET(PCS10G_BR_PCS_CFG_AN_LINK_CTRL_ENA, x)

#define PCS10G_BR_PCS_CFG_TX_TEST_MODE           BIT(4)
#define PCS10G_BR_PCS_CFG_TX_TEST_MODE_SET(x)\
	FIELD_PREP(PCS10G_BR_PCS_CFG_TX_TEST_MODE, x)
#define PCS10G_BR_PCS_CFG_TX_TEST_MODE_GET(x)\
	FIELD_GET(PCS10G_BR_PCS_CFG_TX_TEST_MODE, x)

#define PCS10G_BR_PCS_CFG_TX_SCR_DISABLE         BIT(3)
#define PCS10G_BR_PCS_CFG_TX_SCR_DISABLE_SET(x)\
	FIELD_PREP(PCS10G_BR_PCS_CFG_TX_SCR_DISABLE, x)
#define PCS10G_BR_PCS_CFG_TX_SCR_DISABLE_GET(x)\
	FIELD_GET(PCS10G_BR_PCS_CFG_TX_SCR_DISABLE, x)

/*      PCS_10GBASE_R:PCS_10GBR_CFG:PCS_SD_CFG */
#define PCS10G_BR_PCS_SD_CFG(t)   __REG(TARGET_PCS10G_BR,\
					t, 12, 0, 0, 1, 56, 4, 0, 1, 4)

#define PCS10G_BR_PCS_SD_CFG_SD_SEL              BIT(8)
#define PCS10G_BR_PCS_SD_CFG_SD_SEL_SET(x)\
	FIELD_PREP(PCS10G_BR_PCS_SD_CFG_SD_SEL, x)
#define PCS10G_BR_PCS_SD_CFG_SD_SEL_GET(x)\
	FIELD_GET(PCS10G_BR_PCS_SD_CFG_SD_SEL, x)

#define PCS10G_BR_PCS_SD_CFG_SD_POL              BIT(4)
#define PCS10G_BR_PCS_SD_CFG_SD_POL_SET(x)\
	FIELD_PREP(PCS10G_BR_PCS_SD_CFG_SD_POL, x)
#define PCS10G_BR_PCS_SD_CFG_SD_POL_GET(x)\
	FIELD_GET(PCS10G_BR_PCS_SD_CFG_SD_POL, x)

#define PCS10G_BR_PCS_SD_CFG_SD_ENA              BIT(0)
#define PCS10G_BR_PCS_SD_CFG_SD_ENA_SET(x)\
	FIELD_PREP(PCS10G_BR_PCS_SD_CFG_SD_ENA, x)
#define PCS10G_BR_PCS_SD_CFG_SD_ENA_GET(x)\
	FIELD_GET(PCS10G_BR_PCS_SD_CFG_SD_ENA, x)

/*      PCS_10GBASE_R:PCS_10GBR_CFG:PCS_CFG */
#define PCS25G_BR_PCS_CFG(t)      __REG(TARGET_PCS25G_BR,\
					t, 8, 0, 0, 1, 56, 0, 0, 1, 4)

#define PCS25G_BR_PCS_CFG_PCS_ENA                BIT(31)
#define PCS25G_BR_PCS_CFG_PCS_ENA_SET(x)\
	FIELD_PREP(PCS25G_BR_PCS_CFG_PCS_ENA, x)
#define PCS25G_BR_PCS_CFG_PCS_ENA_GET(x)\
	FIELD_GET(PCS25G_BR_PCS_CFG_PCS_ENA, x)

#define PCS25G_BR_PCS_CFG_PMA_LOOPBACK_ENA       BIT(30)
#define PCS25G_BR_PCS_CFG_PMA_LOOPBACK_ENA_SET(x)\
	FIELD_PREP(PCS25G_BR_PCS_CFG_PMA_LOOPBACK_ENA, x)
#define PCS25G_BR_PCS_CFG_PMA_LOOPBACK_ENA_GET(x)\
	FIELD_GET(PCS25G_BR_PCS_CFG_PMA_LOOPBACK_ENA, x)

#define PCS25G_BR_PCS_CFG_SH_CNT_MAX             GENMASK(29, 24)
#define PCS25G_BR_PCS_CFG_SH_CNT_MAX_SET(x)\
	FIELD_PREP(PCS25G_BR_PCS_CFG_SH_CNT_MAX, x)
#define PCS25G_BR_PCS_CFG_SH_CNT_MAX_GET(x)\
	FIELD_GET(PCS25G_BR_PCS_CFG_SH_CNT_MAX, x)

#define PCS25G_BR_PCS_CFG_RX_DATA_FLIP           BIT(18)
#define PCS25G_BR_PCS_CFG_RX_DATA_FLIP_SET(x)\
	FIELD_PREP(PCS25G_BR_PCS_CFG_RX_DATA_FLIP, x)
#define PCS25G_BR_PCS_CFG_RX_DATA_FLIP_GET(x)\
	FIELD_GET(PCS25G_BR_PCS_CFG_RX_DATA_FLIP, x)

#define PCS25G_BR_PCS_CFG_RESYNC_ENA             BIT(15)
#define PCS25G_BR_PCS_CFG_RESYNC_ENA_SET(x)\
	FIELD_PREP(PCS25G_BR_PCS_CFG_RESYNC_ENA, x)
#define PCS25G_BR_PCS_CFG_RESYNC_ENA_GET(x)\
	FIELD_GET(PCS25G_BR_PCS_CFG_RESYNC_ENA, x)

#define PCS25G_BR_PCS_CFG_LF_GEN_DIS             BIT(14)
#define PCS25G_BR_PCS_CFG_LF_GEN_DIS_SET(x)\
	FIELD_PREP(PCS25G_BR_PCS_CFG_LF_GEN_DIS, x)
#define PCS25G_BR_PCS_CFG_LF_GEN_DIS_GET(x)\
	FIELD_GET(PCS25G_BR_PCS_CFG_LF_GEN_DIS, x)

#define PCS25G_BR_PCS_CFG_RX_TEST_MODE           BIT(13)
#define PCS25G_BR_PCS_CFG_RX_TEST_MODE_SET(x)\
	FIELD_PREP(PCS25G_BR_PCS_CFG_RX_TEST_MODE, x)
#define PCS25G_BR_PCS_CFG_RX_TEST_MODE_GET(x)\
	FIELD_GET(PCS25G_BR_PCS_CFG_RX_TEST_MODE, x)

#define PCS25G_BR_PCS_CFG_RX_SCR_DISABLE         BIT(12)
#define PCS25G_BR_PCS_CFG_RX_SCR_DISABLE_SET(x)\
	FIELD_PREP(PCS25G_BR_PCS_CFG_RX_SCR_DISABLE, x)
#define PCS25G_BR_PCS_CFG_RX_SCR_DISABLE_GET(x)\
	FIELD_GET(PCS25G_BR_PCS_CFG_RX_SCR_DISABLE, x)

#define PCS25G_BR_PCS_CFG_TX_DATA_FLIP           BIT(7)
#define PCS25G_BR_PCS_CFG_TX_DATA_FLIP_SET(x)\
	FIELD_PREP(PCS25G_BR_PCS_CFG_TX_DATA_FLIP, x)
#define PCS25G_BR_PCS_CFG_TX_DATA_FLIP_GET(x)\
	FIELD_GET(PCS25G_BR_PCS_CFG_TX_DATA_FLIP, x)

#define PCS25G_BR_PCS_CFG_AN_LINK_CTRL_ENA       BIT(6)
#define PCS25G_BR_PCS_CFG_AN_LINK_CTRL_ENA_SET(x)\
	FIELD_PREP(PCS25G_BR_PCS_CFG_AN_LINK_CTRL_ENA, x)
#define PCS25G_BR_PCS_CFG_AN_LINK_CTRL_ENA_GET(x)\
	FIELD_GET(PCS25G_BR_PCS_CFG_AN_LINK_CTRL_ENA, x)

#define PCS25G_BR_PCS_CFG_TX_TEST_MODE           BIT(4)
#define PCS25G_BR_PCS_CFG_TX_TEST_MODE_SET(x)\
	FIELD_PREP(PCS25G_BR_PCS_CFG_TX_TEST_MODE, x)
#define PCS25G_BR_PCS_CFG_TX_TEST_MODE_GET(x)\
	FIELD_GET(PCS25G_BR_PCS_CFG_TX_TEST_MODE, x)

#define PCS25G_BR_PCS_CFG_TX_SCR_DISABLE         BIT(3)
#define PCS25G_BR_PCS_CFG_TX_SCR_DISABLE_SET(x)\
	FIELD_PREP(PCS25G_BR_PCS_CFG_TX_SCR_DISABLE, x)
#define PCS25G_BR_PCS_CFG_TX_SCR_DISABLE_GET(x)\
	FIELD_GET(PCS25G_BR_PCS_CFG_TX_SCR_DISABLE, x)

/*      PCS_10GBASE_R:PCS_10GBR_CFG:PCS_SD_CFG */
#define PCS25G_BR_PCS_SD_CFG(t)   __REG(TARGET_PCS25G_BR,\
					t, 8, 0, 0, 1, 56, 4, 0, 1, 4)

#define PCS25G_BR_PCS_SD_CFG_SD_SEL              BIT(8)
#define PCS25G_BR_PCS_SD_CFG_SD_SEL_SET(x)\
	FIELD_PREP(PCS25G_BR_PCS_SD_CFG_SD_SEL, x)
#define PCS25G_BR_PCS_SD_CFG_SD_SEL_GET(x)\
	FIELD_GET(PCS25G_BR_PCS_SD_CFG_SD_SEL, x)

#define PCS25G_BR_PCS_SD_CFG_SD_POL              BIT(4)
#define PCS25G_BR_PCS_SD_CFG_SD_POL_SET(x)\
	FIELD_PREP(PCS25G_BR_PCS_SD_CFG_SD_POL, x)
#define PCS25G_BR_PCS_SD_CFG_SD_POL_GET(x)\
	FIELD_GET(PCS25G_BR_PCS_SD_CFG_SD_POL, x)

#define PCS25G_BR_PCS_SD_CFG_SD_ENA              BIT(0)
#define PCS25G_BR_PCS_SD_CFG_SD_ENA_SET(x)\
	FIELD_PREP(PCS25G_BR_PCS_SD_CFG_SD_ENA, x)
#define PCS25G_BR_PCS_SD_CFG_SD_ENA_GET(x)\
	FIELD_GET(PCS25G_BR_PCS_SD_CFG_SD_ENA, x)

/*      PCS_10GBASE_R:PCS_10GBR_CFG:PCS_CFG */
#define PCS5G_BR_PCS_CFG(t)       __REG(TARGET_PCS5G_BR,\
					t, 13, 0, 0, 1, 56, 0, 0, 1, 4)

#define PCS5G_BR_PCS_CFG_PCS_ENA                 BIT(31)
#define PCS5G_BR_PCS_CFG_PCS_ENA_SET(x)\
	FIELD_PREP(PCS5G_BR_PCS_CFG_PCS_ENA, x)
#define PCS5G_BR_PCS_CFG_PCS_ENA_GET(x)\
	FIELD_GET(PCS5G_BR_PCS_CFG_PCS_ENA, x)

#define PCS5G_BR_PCS_CFG_PMA_LOOPBACK_ENA        BIT(30)
#define PCS5G_BR_PCS_CFG_PMA_LOOPBACK_ENA_SET(x)\
	FIELD_PREP(PCS5G_BR_PCS_CFG_PMA_LOOPBACK_ENA, x)
#define PCS5G_BR_PCS_CFG_PMA_LOOPBACK_ENA_GET(x)\
	FIELD_GET(PCS5G_BR_PCS_CFG_PMA_LOOPBACK_ENA, x)

#define PCS5G_BR_PCS_CFG_SH_CNT_MAX              GENMASK(29, 24)
#define PCS5G_BR_PCS_CFG_SH_CNT_MAX_SET(x)\
	FIELD_PREP(PCS5G_BR_PCS_CFG_SH_CNT_MAX, x)
#define PCS5G_BR_PCS_CFG_SH_CNT_MAX_GET(x)\
	FIELD_GET(PCS5G_BR_PCS_CFG_SH_CNT_MAX, x)

#define PCS5G_BR_PCS_CFG_RX_DATA_FLIP            BIT(18)
#define PCS5G_BR_PCS_CFG_RX_DATA_FLIP_SET(x)\
	FIELD_PREP(PCS5G_BR_PCS_CFG_RX_DATA_FLIP, x)
#define PCS5G_BR_PCS_CFG_RX_DATA_FLIP_GET(x)\
	FIELD_GET(PCS5G_BR_PCS_CFG_RX_DATA_FLIP, x)

#define PCS5G_BR_PCS_CFG_RESYNC_ENA              BIT(15)
#define PCS5G_BR_PCS_CFG_RESYNC_ENA_SET(x)\
	FIELD_PREP(PCS5G_BR_PCS_CFG_RESYNC_ENA, x)
#define PCS5G_BR_PCS_CFG_RESYNC_ENA_GET(x)\
	FIELD_GET(PCS5G_BR_PCS_CFG_RESYNC_ENA, x)

#define PCS5G_BR_PCS_CFG_LF_GEN_DIS              BIT(14)
#define PCS5G_BR_PCS_CFG_LF_GEN_DIS_SET(x)\
	FIELD_PREP(PCS5G_BR_PCS_CFG_LF_GEN_DIS, x)
#define PCS5G_BR_PCS_CFG_LF_GEN_DIS_GET(x)\
	FIELD_GET(PCS5G_BR_PCS_CFG_LF_GEN_DIS, x)

#define PCS5G_BR_PCS_CFG_RX_TEST_MODE            BIT(13)
#define PCS5G_BR_PCS_CFG_RX_TEST_MODE_SET(x)\
	FIELD_PREP(PCS5G_BR_PCS_CFG_RX_TEST_MODE, x)
#define PCS5G_BR_PCS_CFG_RX_TEST_MODE_GET(x)\
	FIELD_GET(PCS5G_BR_PCS_CFG_RX_TEST_MODE, x)

#define PCS5G_BR_PCS_CFG_RX_SCR_DISABLE          BIT(12)
#define PCS5G_BR_PCS_CFG_RX_SCR_DISABLE_SET(x)\
	FIELD_PREP(PCS5G_BR_PCS_CFG_RX_SCR_DISABLE, x)
#define PCS5G_BR_PCS_CFG_RX_SCR_DISABLE_GET(x)\
	FIELD_GET(PCS5G_BR_PCS_CFG_RX_SCR_DISABLE, x)

#define PCS5G_BR_PCS_CFG_TX_DATA_FLIP            BIT(7)
#define PCS5G_BR_PCS_CFG_TX_DATA_FLIP_SET(x)\
	FIELD_PREP(PCS5G_BR_PCS_CFG_TX_DATA_FLIP, x)
#define PCS5G_BR_PCS_CFG_TX_DATA_FLIP_GET(x)\
	FIELD_GET(PCS5G_BR_PCS_CFG_TX_DATA_FLIP, x)

#define PCS5G_BR_PCS_CFG_AN_LINK_CTRL_ENA        BIT(6)
#define PCS5G_BR_PCS_CFG_AN_LINK_CTRL_ENA_SET(x)\
	FIELD_PREP(PCS5G_BR_PCS_CFG_AN_LINK_CTRL_ENA, x)
#define PCS5G_BR_PCS_CFG_AN_LINK_CTRL_ENA_GET(x)\
	FIELD_GET(PCS5G_BR_PCS_CFG_AN_LINK_CTRL_ENA, x)

#define PCS5G_BR_PCS_CFG_TX_TEST_MODE            BIT(4)
#define PCS5G_BR_PCS_CFG_TX_TEST_MODE_SET(x)\
	FIELD_PREP(PCS5G_BR_PCS_CFG_TX_TEST_MODE, x)
#define PCS5G_BR_PCS_CFG_TX_TEST_MODE_GET(x)\
	FIELD_GET(PCS5G_BR_PCS_CFG_TX_TEST_MODE, x)

#define PCS5G_BR_PCS_CFG_TX_SCR_DISABLE          BIT(3)
#define PCS5G_BR_PCS_CFG_TX_SCR_DISABLE_SET(x)\
	FIELD_PREP(PCS5G_BR_PCS_CFG_TX_SCR_DISABLE, x)
#define PCS5G_BR_PCS_CFG_TX_SCR_DISABLE_GET(x)\
	FIELD_GET(PCS5G_BR_PCS_CFG_TX_SCR_DISABLE, x)

/*      PCS_10GBASE_R:PCS_10GBR_CFG:PCS_SD_CFG */
#define PCS5G_BR_PCS_SD_CFG(t)    __REG(TARGET_PCS5G_BR,\
					t, 13, 0, 0, 1, 56, 4, 0, 1, 4)

#define PCS5G_BR_PCS_SD_CFG_SD_SEL               BIT(8)
#define PCS5G_BR_PCS_SD_CFG_SD_SEL_SET(x)\
	FIELD_PREP(PCS5G_BR_PCS_SD_CFG_SD_SEL, x)
#define PCS5G_BR_PCS_SD_CFG_SD_SEL_GET(x)\
	FIELD_GET(PCS5G_BR_PCS_SD_CFG_SD_SEL, x)

#define PCS5G_BR_PCS_SD_CFG_SD_POL               BIT(4)
#define PCS5G_BR_PCS_SD_CFG_SD_POL_SET(x)\
	FIELD_PREP(PCS5G_BR_PCS_SD_CFG_SD_POL, x)
#define PCS5G_BR_PCS_SD_CFG_SD_POL_GET(x)\
	FIELD_GET(PCS5G_BR_PCS_SD_CFG_SD_POL, x)

#define PCS5G_BR_PCS_SD_CFG_SD_ENA               BIT(0)
#define PCS5G_BR_PCS_SD_CFG_SD_ENA_SET(x)\
	FIELD_PREP(PCS5G_BR_PCS_SD_CFG_SD_ENA, x)
#define PCS5G_BR_PCS_SD_CFG_SD_ENA_GET(x)\
	FIELD_GET(PCS5G_BR_PCS_SD_CFG_SD_ENA, x)

/*      PORT_CONF:HW_CFG:DEV5G_MODES */
#define PORT_CONF_DEV5G_MODES     __REG(TARGET_PORT_CONF,\
					0, 1, 0, 0, 1, 24, 0, 0, 1, 4)

#define PORT_CONF_DEV5G_MODES_DEV5G_D0_MODE      BIT(0)
#define PORT_CONF_DEV5G_MODES_DEV5G_D0_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV5G_MODES_DEV5G_D0_MODE, x)
#define PORT_CONF_DEV5G_MODES_DEV5G_D0_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV5G_MODES_DEV5G_D0_MODE, x)

#define PORT_CONF_DEV5G_MODES_DEV5G_D1_MODE      BIT(1)
#define PORT_CONF_DEV5G_MODES_DEV5G_D1_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV5G_MODES_DEV5G_D1_MODE, x)
#define PORT_CONF_DEV5G_MODES_DEV5G_D1_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV5G_MODES_DEV5G_D1_MODE, x)

#define PORT_CONF_DEV5G_MODES_DEV5G_D2_MODE      BIT(2)
#define PORT_CONF_DEV5G_MODES_DEV5G_D2_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV5G_MODES_DEV5G_D2_MODE, x)
#define PORT_CONF_DEV5G_MODES_DEV5G_D2_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV5G_MODES_DEV5G_D2_MODE, x)

#define PORT_CONF_DEV5G_MODES_DEV5G_D3_MODE      BIT(3)
#define PORT_CONF_DEV5G_MODES_DEV5G_D3_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV5G_MODES_DEV5G_D3_MODE, x)
#define PORT_CONF_DEV5G_MODES_DEV5G_D3_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV5G_MODES_DEV5G_D3_MODE, x)

#define PORT_CONF_DEV5G_MODES_DEV5G_D4_MODE      BIT(4)
#define PORT_CONF_DEV5G_MODES_DEV5G_D4_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV5G_MODES_DEV5G_D4_MODE, x)
#define PORT_CONF_DEV5G_MODES_DEV5G_D4_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV5G_MODES_DEV5G_D4_MODE, x)

#define PORT_CONF_DEV5G_MODES_DEV5G_D5_MODE      BIT(5)
#define PORT_CONF_DEV5G_MODES_DEV5G_D5_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV5G_MODES_DEV5G_D5_MODE, x)
#define PORT_CONF_DEV5G_MODES_DEV5G_D5_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV5G_MODES_DEV5G_D5_MODE, x)

#define PORT_CONF_DEV5G_MODES_DEV5G_D6_MODE      BIT(6)
#define PORT_CONF_DEV5G_MODES_DEV5G_D6_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV5G_MODES_DEV5G_D6_MODE, x)
#define PORT_CONF_DEV5G_MODES_DEV5G_D6_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV5G_MODES_DEV5G_D6_MODE, x)

#define PORT_CONF_DEV5G_MODES_DEV5G_D7_MODE      BIT(7)
#define PORT_CONF_DEV5G_MODES_DEV5G_D7_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV5G_MODES_DEV5G_D7_MODE, x)
#define PORT_CONF_DEV5G_MODES_DEV5G_D7_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV5G_MODES_DEV5G_D7_MODE, x)

#define PORT_CONF_DEV5G_MODES_DEV5G_D8_MODE      BIT(8)
#define PORT_CONF_DEV5G_MODES_DEV5G_D8_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV5G_MODES_DEV5G_D8_MODE, x)
#define PORT_CONF_DEV5G_MODES_DEV5G_D8_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV5G_MODES_DEV5G_D8_MODE, x)

#define PORT_CONF_DEV5G_MODES_DEV5G_D9_MODE      BIT(9)
#define PORT_CONF_DEV5G_MODES_DEV5G_D9_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV5G_MODES_DEV5G_D9_MODE, x)
#define PORT_CONF_DEV5G_MODES_DEV5G_D9_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV5G_MODES_DEV5G_D9_MODE, x)

#define PORT_CONF_DEV5G_MODES_DEV5G_D10_MODE     BIT(10)
#define PORT_CONF_DEV5G_MODES_DEV5G_D10_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV5G_MODES_DEV5G_D10_MODE, x)
#define PORT_CONF_DEV5G_MODES_DEV5G_D10_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV5G_MODES_DEV5G_D10_MODE, x)

#define PORT_CONF_DEV5G_MODES_DEV5G_D11_MODE     BIT(11)
#define PORT_CONF_DEV5G_MODES_DEV5G_D11_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV5G_MODES_DEV5G_D11_MODE, x)
#define PORT_CONF_DEV5G_MODES_DEV5G_D11_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV5G_MODES_DEV5G_D11_MODE, x)

#define PORT_CONF_DEV5G_MODES_DEV5G_D64_MODE     BIT(12)
#define PORT_CONF_DEV5G_MODES_DEV5G_D64_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV5G_MODES_DEV5G_D64_MODE, x)
#define PORT_CONF_DEV5G_MODES_DEV5G_D64_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV5G_MODES_DEV5G_D64_MODE, x)

/*      PORT_CONF:HW_CFG:DEV10G_MODES */
#define PORT_CONF_DEV10G_MODES    __REG(TARGET_PORT_CONF,\
					0, 1, 0, 0, 1, 24, 4, 0, 1, 4)

#define PORT_CONF_DEV10G_MODES_DEV10G_D12_MODE   BIT(0)
#define PORT_CONF_DEV10G_MODES_DEV10G_D12_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV10G_MODES_DEV10G_D12_MODE, x)
#define PORT_CONF_DEV10G_MODES_DEV10G_D12_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV10G_MODES_DEV10G_D12_MODE, x)

#define PORT_CONF_DEV10G_MODES_DEV10G_D13_MODE   BIT(1)
#define PORT_CONF_DEV10G_MODES_DEV10G_D13_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV10G_MODES_DEV10G_D13_MODE, x)
#define PORT_CONF_DEV10G_MODES_DEV10G_D13_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV10G_MODES_DEV10G_D13_MODE, x)

#define PORT_CONF_DEV10G_MODES_DEV10G_D14_MODE   BIT(2)
#define PORT_CONF_DEV10G_MODES_DEV10G_D14_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV10G_MODES_DEV10G_D14_MODE, x)
#define PORT_CONF_DEV10G_MODES_DEV10G_D14_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV10G_MODES_DEV10G_D14_MODE, x)

#define PORT_CONF_DEV10G_MODES_DEV10G_D15_MODE   BIT(3)
#define PORT_CONF_DEV10G_MODES_DEV10G_D15_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV10G_MODES_DEV10G_D15_MODE, x)
#define PORT_CONF_DEV10G_MODES_DEV10G_D15_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV10G_MODES_DEV10G_D15_MODE, x)

#define PORT_CONF_DEV10G_MODES_DEV10G_D48_MODE   BIT(4)
#define PORT_CONF_DEV10G_MODES_DEV10G_D48_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV10G_MODES_DEV10G_D48_MODE, x)
#define PORT_CONF_DEV10G_MODES_DEV10G_D48_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV10G_MODES_DEV10G_D48_MODE, x)

#define PORT_CONF_DEV10G_MODES_DEV10G_D49_MODE   BIT(5)
#define PORT_CONF_DEV10G_MODES_DEV10G_D49_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV10G_MODES_DEV10G_D49_MODE, x)
#define PORT_CONF_DEV10G_MODES_DEV10G_D49_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV10G_MODES_DEV10G_D49_MODE, x)

#define PORT_CONF_DEV10G_MODES_DEV10G_D50_MODE   BIT(6)
#define PORT_CONF_DEV10G_MODES_DEV10G_D50_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV10G_MODES_DEV10G_D50_MODE, x)
#define PORT_CONF_DEV10G_MODES_DEV10G_D50_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV10G_MODES_DEV10G_D50_MODE, x)

#define PORT_CONF_DEV10G_MODES_DEV10G_D51_MODE   BIT(7)
#define PORT_CONF_DEV10G_MODES_DEV10G_D51_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV10G_MODES_DEV10G_D51_MODE, x)
#define PORT_CONF_DEV10G_MODES_DEV10G_D51_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV10G_MODES_DEV10G_D51_MODE, x)

#define PORT_CONF_DEV10G_MODES_DEV10G_D52_MODE   BIT(8)
#define PORT_CONF_DEV10G_MODES_DEV10G_D52_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV10G_MODES_DEV10G_D52_MODE, x)
#define PORT_CONF_DEV10G_MODES_DEV10G_D52_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV10G_MODES_DEV10G_D52_MODE, x)

#define PORT_CONF_DEV10G_MODES_DEV10G_D53_MODE   BIT(9)
#define PORT_CONF_DEV10G_MODES_DEV10G_D53_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV10G_MODES_DEV10G_D53_MODE, x)
#define PORT_CONF_DEV10G_MODES_DEV10G_D53_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV10G_MODES_DEV10G_D53_MODE, x)

#define PORT_CONF_DEV10G_MODES_DEV10G_D54_MODE   BIT(10)
#define PORT_CONF_DEV10G_MODES_DEV10G_D54_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV10G_MODES_DEV10G_D54_MODE, x)
#define PORT_CONF_DEV10G_MODES_DEV10G_D54_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV10G_MODES_DEV10G_D54_MODE, x)

#define PORT_CONF_DEV10G_MODES_DEV10G_D55_MODE   BIT(11)
#define PORT_CONF_DEV10G_MODES_DEV10G_D55_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV10G_MODES_DEV10G_D55_MODE, x)
#define PORT_CONF_DEV10G_MODES_DEV10G_D55_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV10G_MODES_DEV10G_D55_MODE, x)

/*      PORT_CONF:HW_CFG:DEV25G_MODES */
#define PORT_CONF_DEV25G_MODES    __REG(TARGET_PORT_CONF,\
					0, 1, 0, 0, 1, 24, 8, 0, 1, 4)

#define PORT_CONF_DEV25G_MODES_DEV25G_D56_MODE   BIT(0)
#define PORT_CONF_DEV25G_MODES_DEV25G_D56_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV25G_MODES_DEV25G_D56_MODE, x)
#define PORT_CONF_DEV25G_MODES_DEV25G_D56_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV25G_MODES_DEV25G_D56_MODE, x)

#define PORT_CONF_DEV25G_MODES_DEV25G_D57_MODE   BIT(1)
#define PORT_CONF_DEV25G_MODES_DEV25G_D57_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV25G_MODES_DEV25G_D57_MODE, x)
#define PORT_CONF_DEV25G_MODES_DEV25G_D57_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV25G_MODES_DEV25G_D57_MODE, x)

#define PORT_CONF_DEV25G_MODES_DEV25G_D58_MODE   BIT(2)
#define PORT_CONF_DEV25G_MODES_DEV25G_D58_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV25G_MODES_DEV25G_D58_MODE, x)
#define PORT_CONF_DEV25G_MODES_DEV25G_D58_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV25G_MODES_DEV25G_D58_MODE, x)

#define PORT_CONF_DEV25G_MODES_DEV25G_D59_MODE   BIT(3)
#define PORT_CONF_DEV25G_MODES_DEV25G_D59_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV25G_MODES_DEV25G_D59_MODE, x)
#define PORT_CONF_DEV25G_MODES_DEV25G_D59_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV25G_MODES_DEV25G_D59_MODE, x)

#define PORT_CONF_DEV25G_MODES_DEV25G_D60_MODE   BIT(4)
#define PORT_CONF_DEV25G_MODES_DEV25G_D60_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV25G_MODES_DEV25G_D60_MODE, x)
#define PORT_CONF_DEV25G_MODES_DEV25G_D60_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV25G_MODES_DEV25G_D60_MODE, x)

#define PORT_CONF_DEV25G_MODES_DEV25G_D61_MODE   BIT(5)
#define PORT_CONF_DEV25G_MODES_DEV25G_D61_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV25G_MODES_DEV25G_D61_MODE, x)
#define PORT_CONF_DEV25G_MODES_DEV25G_D61_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV25G_MODES_DEV25G_D61_MODE, x)

#define PORT_CONF_DEV25G_MODES_DEV25G_D62_MODE   BIT(6)
#define PORT_CONF_DEV25G_MODES_DEV25G_D62_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV25G_MODES_DEV25G_D62_MODE, x)
#define PORT_CONF_DEV25G_MODES_DEV25G_D62_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV25G_MODES_DEV25G_D62_MODE, x)

#define PORT_CONF_DEV25G_MODES_DEV25G_D63_MODE   BIT(7)
#define PORT_CONF_DEV25G_MODES_DEV25G_D63_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_DEV25G_MODES_DEV25G_D63_MODE, x)
#define PORT_CONF_DEV25G_MODES_DEV25G_D63_MODE_GET(x)\
	FIELD_GET(PORT_CONF_DEV25G_MODES_DEV25G_D63_MODE, x)

/*      PORT_CONF:HW_CFG:QSGMII_ENA */
#define PORT_CONF_QSGMII_ENA      __REG(TARGET_PORT_CONF,\
					0, 1, 0, 0, 1, 24, 12, 0, 1, 4)

#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_0        BIT(0)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_0_SET(x)\
	FIELD_PREP(PORT_CONF_QSGMII_ENA_QSGMII_ENA_0, x)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_0_GET(x)\
	FIELD_GET(PORT_CONF_QSGMII_ENA_QSGMII_ENA_0, x)

#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_1        BIT(1)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_1_SET(x)\
	FIELD_PREP(PORT_CONF_QSGMII_ENA_QSGMII_ENA_1, x)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_1_GET(x)\
	FIELD_GET(PORT_CONF_QSGMII_ENA_QSGMII_ENA_1, x)

#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_2        BIT(2)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_2_SET(x)\
	FIELD_PREP(PORT_CONF_QSGMII_ENA_QSGMII_ENA_2, x)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_2_GET(x)\
	FIELD_GET(PORT_CONF_QSGMII_ENA_QSGMII_ENA_2, x)

#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_3        BIT(3)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_3_SET(x)\
	FIELD_PREP(PORT_CONF_QSGMII_ENA_QSGMII_ENA_3, x)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_3_GET(x)\
	FIELD_GET(PORT_CONF_QSGMII_ENA_QSGMII_ENA_3, x)

#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_4        BIT(4)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_4_SET(x)\
	FIELD_PREP(PORT_CONF_QSGMII_ENA_QSGMII_ENA_4, x)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_4_GET(x)\
	FIELD_GET(PORT_CONF_QSGMII_ENA_QSGMII_ENA_4, x)

#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_5        BIT(5)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_5_SET(x)\
	FIELD_PREP(PORT_CONF_QSGMII_ENA_QSGMII_ENA_5, x)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_5_GET(x)\
	FIELD_GET(PORT_CONF_QSGMII_ENA_QSGMII_ENA_5, x)

#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_6        BIT(6)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_6_SET(x)\
	FIELD_PREP(PORT_CONF_QSGMII_ENA_QSGMII_ENA_6, x)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_6_GET(x)\
	FIELD_GET(PORT_CONF_QSGMII_ENA_QSGMII_ENA_6, x)

#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_7        BIT(7)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_7_SET(x)\
	FIELD_PREP(PORT_CONF_QSGMII_ENA_QSGMII_ENA_7, x)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_7_GET(x)\
	FIELD_GET(PORT_CONF_QSGMII_ENA_QSGMII_ENA_7, x)

#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_8        BIT(8)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_8_SET(x)\
	FIELD_PREP(PORT_CONF_QSGMII_ENA_QSGMII_ENA_8, x)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_8_GET(x)\
	FIELD_GET(PORT_CONF_QSGMII_ENA_QSGMII_ENA_8, x)

#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_9        BIT(9)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_9_SET(x)\
	FIELD_PREP(PORT_CONF_QSGMII_ENA_QSGMII_ENA_9, x)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_9_GET(x)\
	FIELD_GET(PORT_CONF_QSGMII_ENA_QSGMII_ENA_9, x)

#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_10       BIT(10)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_10_SET(x)\
	FIELD_PREP(PORT_CONF_QSGMII_ENA_QSGMII_ENA_10, x)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_10_GET(x)\
	FIELD_GET(PORT_CONF_QSGMII_ENA_QSGMII_ENA_10, x)

#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_11       BIT(11)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_11_SET(x)\
	FIELD_PREP(PORT_CONF_QSGMII_ENA_QSGMII_ENA_11, x)
#define PORT_CONF_QSGMII_ENA_QSGMII_ENA_11_GET(x)\
	FIELD_GET(PORT_CONF_QSGMII_ENA_QSGMII_ENA_11, x)

/*      PORT_CONF:USGMII_CFG_STAT:USGMII_CFG */
#define PORT_CONF_USGMII_CFG(g)   __REG(TARGET_PORT_CONF,\
					0, 1, 72, g, 6, 8, 0, 0, 1, 4)

#define PORT_CONF_USGMII_CFG_BYPASS_SCRAM        BIT(9)
#define PORT_CONF_USGMII_CFG_BYPASS_SCRAM_SET(x)\
	FIELD_PREP(PORT_CONF_USGMII_CFG_BYPASS_SCRAM, x)
#define PORT_CONF_USGMII_CFG_BYPASS_SCRAM_GET(x)\
	FIELD_GET(PORT_CONF_USGMII_CFG_BYPASS_SCRAM, x)

#define PORT_CONF_USGMII_CFG_BYPASS_DESCRAM      BIT(8)
#define PORT_CONF_USGMII_CFG_BYPASS_DESCRAM_SET(x)\
	FIELD_PREP(PORT_CONF_USGMII_CFG_BYPASS_DESCRAM, x)
#define PORT_CONF_USGMII_CFG_BYPASS_DESCRAM_GET(x)\
	FIELD_GET(PORT_CONF_USGMII_CFG_BYPASS_DESCRAM, x)

#define PORT_CONF_USGMII_CFG_FLIP_LANES          BIT(7)
#define PORT_CONF_USGMII_CFG_FLIP_LANES_SET(x)\
	FIELD_PREP(PORT_CONF_USGMII_CFG_FLIP_LANES, x)
#define PORT_CONF_USGMII_CFG_FLIP_LANES_GET(x)\
	FIELD_GET(PORT_CONF_USGMII_CFG_FLIP_LANES, x)

#define PORT_CONF_USGMII_CFG_SHYST_DIS           BIT(6)
#define PORT_CONF_USGMII_CFG_SHYST_DIS_SET(x)\
	FIELD_PREP(PORT_CONF_USGMII_CFG_SHYST_DIS, x)
#define PORT_CONF_USGMII_CFG_SHYST_DIS_GET(x)\
	FIELD_GET(PORT_CONF_USGMII_CFG_SHYST_DIS, x)

#define PORT_CONF_USGMII_CFG_E_DET_ENA           BIT(5)
#define PORT_CONF_USGMII_CFG_E_DET_ENA_SET(x)\
	FIELD_PREP(PORT_CONF_USGMII_CFG_E_DET_ENA, x)
#define PORT_CONF_USGMII_CFG_E_DET_ENA_GET(x)\
	FIELD_GET(PORT_CONF_USGMII_CFG_E_DET_ENA, x)

#define PORT_CONF_USGMII_CFG_USE_I1_ENA          BIT(4)
#define PORT_CONF_USGMII_CFG_USE_I1_ENA_SET(x)\
	FIELD_PREP(PORT_CONF_USGMII_CFG_USE_I1_ENA, x)
#define PORT_CONF_USGMII_CFG_USE_I1_ENA_GET(x)\
	FIELD_GET(PORT_CONF_USGMII_CFG_USE_I1_ENA, x)

#define PORT_CONF_USGMII_CFG_QUAD_MODE           BIT(1)
#define PORT_CONF_USGMII_CFG_QUAD_MODE_SET(x)\
	FIELD_PREP(PORT_CONF_USGMII_CFG_QUAD_MODE, x)
#define PORT_CONF_USGMII_CFG_QUAD_MODE_GET(x)\
	FIELD_GET(PORT_CONF_USGMII_CFG_QUAD_MODE, x)

/*      DEVCPU_PTP:PTP_CFG:PTP_PIN_INTR */
#define PTP_PTP_PIN_INTR          __REG(TARGET_PTP,\
					0, 1, 320, 0, 1, 16, 0, 0, 1, 4)

#define PTP_PTP_PIN_INTR_INTR_PTP                GENMASK(4, 0)
#define PTP_PTP_PIN_INTR_INTR_PTP_SET(x)\
	FIELD_PREP(PTP_PTP_PIN_INTR_INTR_PTP, x)
#define PTP_PTP_PIN_INTR_INTR_PTP_GET(x)\
	FIELD_GET(PTP_PTP_PIN_INTR_INTR_PTP, x)

/*      DEVCPU_PTP:PTP_CFG:PTP_PIN_INTR_ENA */
#define PTP_PTP_PIN_INTR_ENA      __REG(TARGET_PTP,\
					0, 1, 320, 0, 1, 16, 4, 0, 1, 4)

#define PTP_PTP_PIN_INTR_ENA_INTR_PTP_ENA        GENMASK(4, 0)
#define PTP_PTP_PIN_INTR_ENA_INTR_PTP_ENA_SET(x)\
	FIELD_PREP(PTP_PTP_PIN_INTR_ENA_INTR_PTP_ENA, x)
#define PTP_PTP_PIN_INTR_ENA_INTR_PTP_ENA_GET(x)\
	FIELD_GET(PTP_PTP_PIN_INTR_ENA_INTR_PTP_ENA, x)

/*      DEVCPU_PTP:PTP_CFG:PTP_INTR_IDENT */
#define PTP_PTP_INTR_IDENT        __REG(TARGET_PTP,\
					0, 1, 320, 0, 1, 16, 8, 0, 1, 4)

#define PTP_PTP_INTR_IDENT_INTR_PTP_IDENT        GENMASK(4, 0)
#define PTP_PTP_INTR_IDENT_INTR_PTP_IDENT_SET(x)\
	FIELD_PREP(PTP_PTP_INTR_IDENT_INTR_PTP_IDENT, x)
#define PTP_PTP_INTR_IDENT_INTR_PTP_IDENT_GET(x)\
	FIELD_GET(PTP_PTP_INTR_IDENT_INTR_PTP_IDENT, x)

/*      DEVCPU_PTP:PTP_CFG:PTP_DOM_CFG */
#define PTP_PTP_DOM_CFG           __REG(TARGET_PTP,\
					0, 1, 320, 0, 1, 16, 12, 0, 1, 4)

#define PTP_PTP_DOM_CFG_PTP_ENA                  GENMASK(11, 9)
#define PTP_PTP_DOM_CFG_PTP_ENA_SET(x)\
	FIELD_PREP(PTP_PTP_DOM_CFG_PTP_ENA, x)
#define PTP_PTP_DOM_CFG_PTP_ENA_GET(x)\
	FIELD_GET(PTP_PTP_DOM_CFG_PTP_ENA, x)

#define PTP_PTP_DOM_CFG_PTP_HOLD                 GENMASK(8, 6)
#define PTP_PTP_DOM_CFG_PTP_HOLD_SET(x)\
	FIELD_PREP(PTP_PTP_DOM_CFG_PTP_HOLD, x)
#define PTP_PTP_DOM_CFG_PTP_HOLD_GET(x)\
	FIELD_GET(PTP_PTP_DOM_CFG_PTP_HOLD, x)

#define PTP_PTP_DOM_CFG_PTP_TOD_FREEZE           GENMASK(5, 3)
#define PTP_PTP_DOM_CFG_PTP_TOD_FREEZE_SET(x)\
	FIELD_PREP(PTP_PTP_DOM_CFG_PTP_TOD_FREEZE, x)
#define PTP_PTP_DOM_CFG_PTP_TOD_FREEZE_GET(x)\
	FIELD_GET(PTP_PTP_DOM_CFG_PTP_TOD_FREEZE, x)

#define PTP_PTP_DOM_CFG_PTP_CLKCFG_DIS           GENMASK(2, 0)
#define PTP_PTP_DOM_CFG_PTP_CLKCFG_DIS_SET(x)\
	FIELD_PREP(PTP_PTP_DOM_CFG_PTP_CLKCFG_DIS, x)
#define PTP_PTP_DOM_CFG_PTP_CLKCFG_DIS_GET(x)\
	FIELD_GET(PTP_PTP_DOM_CFG_PTP_CLKCFG_DIS, x)

/*      DEVCPU_PTP:PTP_TOD_DOMAINS:CLK_PER_CFG */
#define PTP_CLK_PER_CFG(g, r)     __REG(TARGET_PTP,\
					0, 1, 336, g, 3, 28, 0, r, 2, 4)

/*      DEVCPU_PTP:PTP_TOD_DOMAINS:PTP_CUR_NSEC */
#define PTP_PTP_CUR_NSEC(g)       __REG(TARGET_PTP,\
					0, 1, 336, g, 3, 28, 8, 0, 1, 4)

#define PTP_PTP_CUR_NSEC_PTP_CUR_NSEC            GENMASK(29, 0)
#define PTP_PTP_CUR_NSEC_PTP_CUR_NSEC_SET(x)\
	FIELD_PREP(PTP_PTP_CUR_NSEC_PTP_CUR_NSEC, x)
#define PTP_PTP_CUR_NSEC_PTP_CUR_NSEC_GET(x)\
	FIELD_GET(PTP_PTP_CUR_NSEC_PTP_CUR_NSEC, x)

/*      DEVCPU_PTP:PTP_TOD_DOMAINS:PTP_CUR_NSEC_FRAC */
#define PTP_PTP_CUR_NSEC_FRAC(g)  __REG(TARGET_PTP,\
					0, 1, 336, g, 3, 28, 12, 0, 1, 4)

#define PTP_PTP_CUR_NSEC_FRAC_PTP_CUR_NSEC_FRAC  GENMASK(7, 0)
#define PTP_PTP_CUR_NSEC_FRAC_PTP_CUR_NSEC_FRAC_SET(x)\
	FIELD_PREP(PTP_PTP_CUR_NSEC_FRAC_PTP_CUR_NSEC_FRAC, x)
#define PTP_PTP_CUR_NSEC_FRAC_PTP_CUR_NSEC_FRAC_GET(x)\
	FIELD_GET(PTP_PTP_CUR_NSEC_FRAC_PTP_CUR_NSEC_FRAC, x)

/*      DEVCPU_PTP:PTP_TOD_DOMAINS:PTP_CUR_SEC_LSB */
#define PTP_PTP_CUR_SEC_LSB(g)    __REG(TARGET_PTP,\
					0, 1, 336, g, 3, 28, 16, 0, 1, 4)

/*      DEVCPU_PTP:PTP_TOD_DOMAINS:PTP_CUR_SEC_MSB */
#define PTP_PTP_CUR_SEC_MSB(g)    __REG(TARGET_PTP,\
					0, 1, 336, g, 3, 28, 20, 0, 1, 4)

#define PTP_PTP_CUR_SEC_MSB_PTP_CUR_SEC_MSB      GENMASK(15, 0)
#define PTP_PTP_CUR_SEC_MSB_PTP_CUR_SEC_MSB_SET(x)\
	FIELD_PREP(PTP_PTP_CUR_SEC_MSB_PTP_CUR_SEC_MSB, x)
#define PTP_PTP_CUR_SEC_MSB_PTP_CUR_SEC_MSB_GET(x)\
	FIELD_GET(PTP_PTP_CUR_SEC_MSB_PTP_CUR_SEC_MSB, x)

/*      DEVCPU_PTP:PTP_TOD_DOMAINS:NTP_CUR_NSEC */
#define PTP_NTP_CUR_NSEC(g)       __REG(TARGET_PTP,\
					0, 1, 336, g, 3, 28, 24, 0, 1, 4)

/*      DEVCPU_PTP:PTP_PINS:PTP_PIN_CFG */
#define PTP_PTP_PIN_CFG(g)        __REG(TARGET_PTP,\
					0, 1, 0, g, 5, 64, 0, 0, 1, 4)

#define PTP_PTP_PIN_CFG_PTP_PIN_ACTION           GENMASK(28, 26)
#define PTP_PTP_PIN_CFG_PTP_PIN_ACTION_SET(x)\
	FIELD_PREP(PTP_PTP_PIN_CFG_PTP_PIN_ACTION, x)
#define PTP_PTP_PIN_CFG_PTP_PIN_ACTION_GET(x)\
	FIELD_GET(PTP_PTP_PIN_CFG_PTP_PIN_ACTION, x)

#define PTP_PTP_PIN_CFG_PTP_PIN_SYNC             GENMASK(25, 24)
#define PTP_PTP_PIN_CFG_PTP_PIN_SYNC_SET(x)\
	FIELD_PREP(PTP_PTP_PIN_CFG_PTP_PIN_SYNC, x)
#define PTP_PTP_PIN_CFG_PTP_PIN_SYNC_GET(x)\
	FIELD_GET(PTP_PTP_PIN_CFG_PTP_PIN_SYNC, x)

#define PTP_PTP_PIN_CFG_PTP_PIN_INV_POL          BIT(23)
#define PTP_PTP_PIN_CFG_PTP_PIN_INV_POL_SET(x)\
	FIELD_PREP(PTP_PTP_PIN_CFG_PTP_PIN_INV_POL, x)
#define PTP_PTP_PIN_CFG_PTP_PIN_INV_POL_GET(x)\
	FIELD_GET(PTP_PTP_PIN_CFG_PTP_PIN_INV_POL, x)

#define PTP_PTP_PIN_CFG_PTP_PIN_SELECT           GENMASK(22, 21)
#define PTP_PTP_PIN_CFG_PTP_PIN_SELECT_SET(x)\
	FIELD_PREP(PTP_PTP_PIN_CFG_PTP_PIN_SELECT, x)
#define PTP_PTP_PIN_CFG_PTP_PIN_SELECT_GET(x)\
	FIELD_GET(PTP_PTP_PIN_CFG_PTP_PIN_SELECT, x)

#define PTP_PTP_PIN_CFG_PTP_CLK_SELECT           GENMASK(20, 18)
#define PTP_PTP_PIN_CFG_PTP_CLK_SELECT_SET(x)\
	FIELD_PREP(PTP_PTP_PIN_CFG_PTP_CLK_SELECT, x)
#define PTP_PTP_PIN_CFG_PTP_CLK_SELECT_GET(x)\
	FIELD_GET(PTP_PTP_PIN_CFG_PTP_CLK_SELECT, x)

#define PTP_PTP_PIN_CFG_PTP_PIN_DOM              GENMASK(17, 16)
#define PTP_PTP_PIN_CFG_PTP_PIN_DOM_SET(x)\
	FIELD_PREP(PTP_PTP_PIN_CFG_PTP_PIN_DOM, x)
#define PTP_PTP_PIN_CFG_PTP_PIN_DOM_GET(x)\
	FIELD_GET(PTP_PTP_PIN_CFG_PTP_PIN_DOM, x)

#define PTP_PTP_PIN_CFG_PTP_PIN_OPT              GENMASK(15, 14)
#define PTP_PTP_PIN_CFG_PTP_PIN_OPT_SET(x)\
	FIELD_PREP(PTP_PTP_PIN_CFG_PTP_PIN_OPT, x)
#define PTP_PTP_PIN_CFG_PTP_PIN_OPT_GET(x)\
	FIELD_GET(PTP_PTP_PIN_CFG_PTP_PIN_OPT, x)

#define PTP_PTP_PIN_CFG_PTP_PIN_EMBEDDED_CLK     BIT(13)
#define PTP_PTP_PIN_CFG_PTP_PIN_EMBEDDED_CLK_SET(x)\
	FIELD_PREP(PTP_PTP_PIN_CFG_PTP_PIN_EMBEDDED_CLK, x)
#define PTP_PTP_PIN_CFG_PTP_PIN_EMBEDDED_CLK_GET(x)\
	FIELD_GET(PTP_PTP_PIN_CFG_PTP_PIN_EMBEDDED_CLK, x)

#define PTP_PTP_PIN_CFG_PTP_PIN_OUTP_OFS         GENMASK(12, 0)
#define PTP_PTP_PIN_CFG_PTP_PIN_OUTP_OFS_SET(x)\
	FIELD_PREP(PTP_PTP_PIN_CFG_PTP_PIN_OUTP_OFS, x)
#define PTP_PTP_PIN_CFG_PTP_PIN_OUTP_OFS_GET(x)\
	FIELD_GET(PTP_PTP_PIN_CFG_PTP_PIN_OUTP_OFS, x)

/*      DEVCPU_PTP:PTP_PINS:PTP_TOD_SEC_MSB */
#define PTP_PTP_TOD_SEC_MSB(g)    __REG(TARGET_PTP,\
					0, 1, 0, g, 5, 64, 4, 0, 1, 4)

#define PTP_PTP_TOD_SEC_MSB_PTP_TOD_SEC_MSB      GENMASK(15, 0)
#define PTP_PTP_TOD_SEC_MSB_PTP_TOD_SEC_MSB_SET(x)\
	FIELD_PREP(PTP_PTP_TOD_SEC_MSB_PTP_TOD_SEC_MSB, x)
#define PTP_PTP_TOD_SEC_MSB_PTP_TOD_SEC_MSB_GET(x)\
	FIELD_GET(PTP_PTP_TOD_SEC_MSB_PTP_TOD_SEC_MSB, x)

/*      DEVCPU_PTP:PTP_PINS:PTP_TOD_SEC_LSB */
#define PTP_PTP_TOD_SEC_LSB(g)    __REG(TARGET_PTP,\
					0, 1, 0, g, 5, 64, 8, 0, 1, 4)

/*      DEVCPU_PTP:PTP_PINS:PTP_TOD_NSEC */
#define PTP_PTP_TOD_NSEC(g)       __REG(TARGET_PTP,\
					0, 1, 0, g, 5, 64, 12, 0, 1, 4)

#define PTP_PTP_TOD_NSEC_PTP_TOD_NSEC            GENMASK(29, 0)
#define PTP_PTP_TOD_NSEC_PTP_TOD_NSEC_SET(x)\
	FIELD_PREP(PTP_PTP_TOD_NSEC_PTP_TOD_NSEC, x)
#define PTP_PTP_TOD_NSEC_PTP_TOD_NSEC_GET(x)\
	FIELD_GET(PTP_PTP_TOD_NSEC_PTP_TOD_NSEC, x)

/*      DEVCPU_PTP:PTP_PINS:PTP_TOD_NSEC_FRAC */
#define PTP_PTP_TOD_NSEC_FRAC(g)  __REG(TARGET_PTP,\
					0, 1, 0, g, 5, 64, 16, 0, 1, 4)

#define PTP_PTP_TOD_NSEC_FRAC_PTP_TOD_NSEC_FRAC  GENMASK(7, 0)
#define PTP_PTP_TOD_NSEC_FRAC_PTP_TOD_NSEC_FRAC_SET(x)\
	FIELD_PREP(PTP_PTP_TOD_NSEC_FRAC_PTP_TOD_NSEC_FRAC, x)
#define PTP_PTP_TOD_NSEC_FRAC_PTP_TOD_NSEC_FRAC_GET(x)\
	FIELD_GET(PTP_PTP_TOD_NSEC_FRAC_PTP_TOD_NSEC_FRAC, x)

/*      DEVCPU_PTP:PTP_PINS:NTP_NSEC */
#define PTP_NTP_NSEC(g)           __REG(TARGET_PTP,\
					0, 1, 0, g, 5, 64, 20, 0, 1, 4)

/*      DEVCPU_PTP:PTP_PINS:PIN_WF_HIGH_PERIOD */
#define PTP_PIN_WF_HIGH_PERIOD(g) __REG(TARGET_PTP,\
					0, 1, 0, g, 5, 64, 24, 0, 1, 4)

#define PTP_PIN_WF_HIGH_PERIOD_PIN_WFH           GENMASK(29, 0)
#define PTP_PIN_WF_HIGH_PERIOD_PIN_WFH_SET(x)\
	FIELD_PREP(PTP_PIN_WF_HIGH_PERIOD_PIN_WFH, x)
#define PTP_PIN_WF_HIGH_PERIOD_PIN_WFH_GET(x)\
	FIELD_GET(PTP_PIN_WF_HIGH_PERIOD_PIN_WFH, x)

/*      DEVCPU_PTP:PTP_PINS:PIN_WF_LOW_PERIOD */
#define PTP_PIN_WF_LOW_PERIOD(g)  __REG(TARGET_PTP,\
					0, 1, 0, g, 5, 64, 28, 0, 1, 4)

#define PTP_PIN_WF_LOW_PERIOD_PIN_WFL            GENMASK(29, 0)
#define PTP_PIN_WF_LOW_PERIOD_PIN_WFL_SET(x)\
	FIELD_PREP(PTP_PIN_WF_LOW_PERIOD_PIN_WFL, x)
#define PTP_PIN_WF_LOW_PERIOD_PIN_WFL_GET(x)\
	FIELD_GET(PTP_PIN_WF_LOW_PERIOD_PIN_WFL, x)

/*      DEVCPU_PTP:PTP_PINS:PIN_IOBOUNCH_DELAY */
#define PTP_PIN_IOBOUNCH_DELAY(g) __REG(TARGET_PTP,\
					0, 1, 0, g, 5, 64, 32, 0, 1, 4)

#define PTP_PIN_IOBOUNCH_DELAY_PIN_IOBOUNCH_VAL  GENMASK(18, 3)
#define PTP_PIN_IOBOUNCH_DELAY_PIN_IOBOUNCH_VAL_SET(x)\
	FIELD_PREP(PTP_PIN_IOBOUNCH_DELAY_PIN_IOBOUNCH_VAL, x)
#define PTP_PIN_IOBOUNCH_DELAY_PIN_IOBOUNCH_VAL_GET(x)\
	FIELD_GET(PTP_PIN_IOBOUNCH_DELAY_PIN_IOBOUNCH_VAL, x)

#define PTP_PIN_IOBOUNCH_DELAY_PIN_IOBOUNCH_CFG  GENMASK(2, 0)
#define PTP_PIN_IOBOUNCH_DELAY_PIN_IOBOUNCH_CFG_SET(x)\
	FIELD_PREP(PTP_PIN_IOBOUNCH_DELAY_PIN_IOBOUNCH_CFG, x)
#define PTP_PIN_IOBOUNCH_DELAY_PIN_IOBOUNCH_CFG_GET(x)\
	FIELD_GET(PTP_PIN_IOBOUNCH_DELAY_PIN_IOBOUNCH_CFG, x)

/*      DEVCPU_PTP:PHASE_DETECTOR_CTRL:PHAD_CTRL */
#define PTP_PHAD_CTRL(g)          __REG(TARGET_PTP,\
					0, 1, 420, g, 5, 8, 0, 0, 1, 4)

#define PTP_PHAD_CTRL_PHAD_ENA                   BIT(7)
#define PTP_PHAD_CTRL_PHAD_ENA_SET(x)\
	FIELD_PREP(PTP_PHAD_CTRL_PHAD_ENA, x)
#define PTP_PHAD_CTRL_PHAD_ENA_GET(x)\
	FIELD_GET(PTP_PHAD_CTRL_PHAD_ENA, x)

#define PTP_PHAD_CTRL_PHAD_FAILED                BIT(6)
#define PTP_PHAD_CTRL_PHAD_FAILED_SET(x)\
	FIELD_PREP(PTP_PHAD_CTRL_PHAD_FAILED, x)
#define PTP_PHAD_CTRL_PHAD_FAILED_GET(x)\
	FIELD_GET(PTP_PHAD_CTRL_PHAD_FAILED, x)

#define PTP_PHAD_CTRL_REDUCED_RES                GENMASK(5, 3)
#define PTP_PHAD_CTRL_REDUCED_RES_SET(x)\
	FIELD_PREP(PTP_PHAD_CTRL_REDUCED_RES, x)
#define PTP_PHAD_CTRL_REDUCED_RES_GET(x)\
	FIELD_GET(PTP_PHAD_CTRL_REDUCED_RES, x)

#define PTP_PHAD_CTRL_LOCK_ACC                   GENMASK(2, 0)
#define PTP_PHAD_CTRL_LOCK_ACC_SET(x)\
	FIELD_PREP(PTP_PHAD_CTRL_LOCK_ACC, x)
#define PTP_PHAD_CTRL_LOCK_ACC_GET(x)\
	FIELD_GET(PTP_PHAD_CTRL_LOCK_ACC, x)

/*      DEVCPU_PTP:PHASE_DETECTOR_CTRL:PHAD_CYC_STAT */
#define PTP_PHAD_CYC_STAT(g)      __REG(TARGET_PTP,\
					0, 1, 420, g, 5, 8, 4, 0, 1, 4)

/*      QFWD:SYSTEM:SWITCH_PORT_MODE */
#define QFWD_SWITCH_PORT_MODE(r)  __REG(TARGET_QFWD,\
					0, 1, 0, 0, 1, 340, 0, r, 70, 4)

#define QFWD_SWITCH_PORT_MODE_PORT_ENA           BIT(19)
#define QFWD_SWITCH_PORT_MODE_PORT_ENA_SET(x)\
	FIELD_PREP(QFWD_SWITCH_PORT_MODE_PORT_ENA, x)
#define QFWD_SWITCH_PORT_MODE_PORT_ENA_GET(x)\
	FIELD_GET(QFWD_SWITCH_PORT_MODE_PORT_ENA, x)

#define QFWD_SWITCH_PORT_MODE_FWD_URGENCY        GENMASK(18, 10)
#define QFWD_SWITCH_PORT_MODE_FWD_URGENCY_SET(x)\
	FIELD_PREP(QFWD_SWITCH_PORT_MODE_FWD_URGENCY, x)
#define QFWD_SWITCH_PORT_MODE_FWD_URGENCY_GET(x)\
	FIELD_GET(QFWD_SWITCH_PORT_MODE_FWD_URGENCY, x)

#define QFWD_SWITCH_PORT_MODE_YEL_RSRVD          GENMASK(9, 6)
#define QFWD_SWITCH_PORT_MODE_YEL_RSRVD_SET(x)\
	FIELD_PREP(QFWD_SWITCH_PORT_MODE_YEL_RSRVD, x)
#define QFWD_SWITCH_PORT_MODE_YEL_RSRVD_GET(x)\
	FIELD_GET(QFWD_SWITCH_PORT_MODE_YEL_RSRVD, x)

#define QFWD_SWITCH_PORT_MODE_INGRESS_DROP_MODE  BIT(5)
#define QFWD_SWITCH_PORT_MODE_INGRESS_DROP_MODE_SET(x)\
	FIELD_PREP(QFWD_SWITCH_PORT_MODE_INGRESS_DROP_MODE, x)
#define QFWD_SWITCH_PORT_MODE_INGRESS_DROP_MODE_GET(x)\
	FIELD_GET(QFWD_SWITCH_PORT_MODE_INGRESS_DROP_MODE, x)

#define QFWD_SWITCH_PORT_MODE_IGR_NO_SHARING     BIT(4)
#define QFWD_SWITCH_PORT_MODE_IGR_NO_SHARING_SET(x)\
	FIELD_PREP(QFWD_SWITCH_PORT_MODE_IGR_NO_SHARING, x)
#define QFWD_SWITCH_PORT_MODE_IGR_NO_SHARING_GET(x)\
	FIELD_GET(QFWD_SWITCH_PORT_MODE_IGR_NO_SHARING, x)

#define QFWD_SWITCH_PORT_MODE_EGR_NO_SHARING     BIT(3)
#define QFWD_SWITCH_PORT_MODE_EGR_NO_SHARING_SET(x)\
	FIELD_PREP(QFWD_SWITCH_PORT_MODE_EGR_NO_SHARING, x)
#define QFWD_SWITCH_PORT_MODE_EGR_NO_SHARING_GET(x)\
	FIELD_GET(QFWD_SWITCH_PORT_MODE_EGR_NO_SHARING, x)

#define QFWD_SWITCH_PORT_MODE_EGRESS_DROP_MODE   BIT(2)
#define QFWD_SWITCH_PORT_MODE_EGRESS_DROP_MODE_SET(x)\
	FIELD_PREP(QFWD_SWITCH_PORT_MODE_EGRESS_DROP_MODE, x)
#define QFWD_SWITCH_PORT_MODE_EGRESS_DROP_MODE_GET(x)\
	FIELD_GET(QFWD_SWITCH_PORT_MODE_EGRESS_DROP_MODE, x)

#define QFWD_SWITCH_PORT_MODE_EGRESS_RSRV_DIS    BIT(1)
#define QFWD_SWITCH_PORT_MODE_EGRESS_RSRV_DIS_SET(x)\
	FIELD_PREP(QFWD_SWITCH_PORT_MODE_EGRESS_RSRV_DIS, x)
#define QFWD_SWITCH_PORT_MODE_EGRESS_RSRV_DIS_GET(x)\
	FIELD_GET(QFWD_SWITCH_PORT_MODE_EGRESS_RSRV_DIS, x)

#define QFWD_SWITCH_PORT_MODE_LEARNALL_MORE      BIT(0)
#define QFWD_SWITCH_PORT_MODE_LEARNALL_MORE_SET(x)\
	FIELD_PREP(QFWD_SWITCH_PORT_MODE_LEARNALL_MORE, x)
#define QFWD_SWITCH_PORT_MODE_LEARNALL_MORE_GET(x)\
	FIELD_GET(QFWD_SWITCH_PORT_MODE_LEARNALL_MORE, x)

/*      QFWD:SYSTEM:FRAME_COPY_CFG */
#define QFWD_FRAME_COPY_CFG(r)\
	__REG(TARGET_QFWD, 0, 1, 0, 0, 1, 340, 284, r, 12, 4)

#define QFWD_FRAME_COPY_CFG_FRMC_PORT_VAL   GENMASK(12, 6)
#define QFWD_FRAME_COPY_CFG_FRMC_PORT_VAL_SET(x)\
	FIELD_PREP(QFWD_FRAME_COPY_CFG_FRMC_PORT_VAL, x)
#define QFWD_FRAME_COPY_CFG_FRMC_PORT_VAL_GET(x)\
	FIELD_GET(QFWD_FRAME_COPY_CFG_FRMC_PORT_VAL, x)

/*      QRES:RES_CTRL:RES_CFG */
#define QRES_RES_CFG(g)           __REG(TARGET_QRES,\
					0, 1, 0, g, 5120, 16, 0, 0, 1, 4)

#define QRES_RES_CFG_WM_HIGH                     GENMASK(11, 0)
#define QRES_RES_CFG_WM_HIGH_SET(x)\
	FIELD_PREP(QRES_RES_CFG_WM_HIGH, x)
#define QRES_RES_CFG_WM_HIGH_GET(x)\
	FIELD_GET(QRES_RES_CFG_WM_HIGH, x)

/*      QRES:RES_CTRL:RES_STAT */
#define QRES_RES_STAT(g)          __REG(TARGET_QRES,\
					0, 1, 0, g, 5120, 16, 4, 0, 1, 4)

#define QRES_RES_STAT_MAXUSE                     GENMASK(20, 0)
#define QRES_RES_STAT_MAXUSE_SET(x)\
	FIELD_PREP(QRES_RES_STAT_MAXUSE, x)
#define QRES_RES_STAT_MAXUSE_GET(x)\
	FIELD_GET(QRES_RES_STAT_MAXUSE, x)

/*      QRES:RES_CTRL:RES_STAT_CUR */
#define QRES_RES_STAT_CUR(g)      __REG(TARGET_QRES,\
					0, 1, 0, g, 5120, 16, 8, 0, 1, 4)

#define QRES_RES_STAT_CUR_INUSE                  GENMASK(20, 0)
#define QRES_RES_STAT_CUR_INUSE_SET(x)\
	FIELD_PREP(QRES_RES_STAT_CUR_INUSE, x)
#define QRES_RES_STAT_CUR_INUSE_GET(x)\
	FIELD_GET(QRES_RES_STAT_CUR_INUSE, x)

/*      DEVCPU_QS:XTR:XTR_GRP_CFG */
#define QS_XTR_GRP_CFG(r)         __REG(TARGET_QS,\
					0, 1, 0, 0, 1, 36, 0, r, 2, 4)

#define QS_XTR_GRP_CFG_MODE                      GENMASK(3, 2)
#define QS_XTR_GRP_CFG_MODE_SET(x)\
	FIELD_PREP(QS_XTR_GRP_CFG_MODE, x)
#define QS_XTR_GRP_CFG_MODE_GET(x)\
	FIELD_GET(QS_XTR_GRP_CFG_MODE, x)

#define QS_XTR_GRP_CFG_STATUS_WORD_POS           BIT(1)
#define QS_XTR_GRP_CFG_STATUS_WORD_POS_SET(x)\
	FIELD_PREP(QS_XTR_GRP_CFG_STATUS_WORD_POS, x)
#define QS_XTR_GRP_CFG_STATUS_WORD_POS_GET(x)\
	FIELD_GET(QS_XTR_GRP_CFG_STATUS_WORD_POS, x)

#define QS_XTR_GRP_CFG_BYTE_SWAP                 BIT(0)
#define QS_XTR_GRP_CFG_BYTE_SWAP_SET(x)\
	FIELD_PREP(QS_XTR_GRP_CFG_BYTE_SWAP, x)
#define QS_XTR_GRP_CFG_BYTE_SWAP_GET(x)\
	FIELD_GET(QS_XTR_GRP_CFG_BYTE_SWAP, x)

/*      DEVCPU_QS:XTR:XTR_RD */
#define QS_XTR_RD(r)              __REG(TARGET_QS,\
					0, 1, 0, 0, 1, 36, 8, r, 2, 4)

/*      DEVCPU_QS:XTR:XTR_FLUSH */
#define QS_XTR_FLUSH              __REG(TARGET_QS,\
					0, 1, 0, 0, 1, 36, 24, 0, 1, 4)

#define QS_XTR_FLUSH_FLUSH                       GENMASK(1, 0)
#define QS_XTR_FLUSH_FLUSH_SET(x)\
	FIELD_PREP(QS_XTR_FLUSH_FLUSH, x)
#define QS_XTR_FLUSH_FLUSH_GET(x)\
	FIELD_GET(QS_XTR_FLUSH_FLUSH, x)

/*      DEVCPU_QS:XTR:XTR_DATA_PRESENT */
#define QS_XTR_DATA_PRESENT       __REG(TARGET_QS,\
					0, 1, 0, 0, 1, 36, 28, 0, 1, 4)

#define QS_XTR_DATA_PRESENT_DATA_PRESENT         GENMASK(1, 0)
#define QS_XTR_DATA_PRESENT_DATA_PRESENT_SET(x)\
	FIELD_PREP(QS_XTR_DATA_PRESENT_DATA_PRESENT, x)
#define QS_XTR_DATA_PRESENT_DATA_PRESENT_GET(x)\
	FIELD_GET(QS_XTR_DATA_PRESENT_DATA_PRESENT, x)

/*      DEVCPU_QS:INJ:INJ_GRP_CFG */
#define QS_INJ_GRP_CFG(r)         __REG(TARGET_QS,\
					0, 1, 36, 0, 1, 40, 0, r, 2, 4)

#define QS_INJ_GRP_CFG_MODE                      GENMASK(3, 2)
#define QS_INJ_GRP_CFG_MODE_SET(x)\
	FIELD_PREP(QS_INJ_GRP_CFG_MODE, x)
#define QS_INJ_GRP_CFG_MODE_GET(x)\
	FIELD_GET(QS_INJ_GRP_CFG_MODE, x)

#define QS_INJ_GRP_CFG_BYTE_SWAP                 BIT(0)
#define QS_INJ_GRP_CFG_BYTE_SWAP_SET(x)\
	FIELD_PREP(QS_INJ_GRP_CFG_BYTE_SWAP, x)
#define QS_INJ_GRP_CFG_BYTE_SWAP_GET(x)\
	FIELD_GET(QS_INJ_GRP_CFG_BYTE_SWAP, x)

/*      DEVCPU_QS:INJ:INJ_WR */
#define QS_INJ_WR(r)              __REG(TARGET_QS,\
					0, 1, 36, 0, 1, 40, 8, r, 2, 4)

/*      DEVCPU_QS:INJ:INJ_CTRL */
#define QS_INJ_CTRL(r)            __REG(TARGET_QS,\
					0, 1, 36, 0, 1, 40, 16, r, 2, 4)

#define QS_INJ_CTRL_GAP_SIZE                     GENMASK(24, 21)
#define QS_INJ_CTRL_GAP_SIZE_SET(x)\
	FIELD_PREP(QS_INJ_CTRL_GAP_SIZE, x)
#define QS_INJ_CTRL_GAP_SIZE_GET(x)\
	FIELD_GET(QS_INJ_CTRL_GAP_SIZE, x)

#define QS_INJ_CTRL_ABORT                        BIT(20)
#define QS_INJ_CTRL_ABORT_SET(x)\
	FIELD_PREP(QS_INJ_CTRL_ABORT, x)
#define QS_INJ_CTRL_ABORT_GET(x)\
	FIELD_GET(QS_INJ_CTRL_ABORT, x)

#define QS_INJ_CTRL_EOF                          BIT(19)
#define QS_INJ_CTRL_EOF_SET(x)\
	FIELD_PREP(QS_INJ_CTRL_EOF, x)
#define QS_INJ_CTRL_EOF_GET(x)\
	FIELD_GET(QS_INJ_CTRL_EOF, x)

#define QS_INJ_CTRL_SOF                          BIT(18)
#define QS_INJ_CTRL_SOF_SET(x)\
	FIELD_PREP(QS_INJ_CTRL_SOF, x)
#define QS_INJ_CTRL_SOF_GET(x)\
	FIELD_GET(QS_INJ_CTRL_SOF, x)

#define QS_INJ_CTRL_VLD_BYTES                    GENMASK(17, 16)
#define QS_INJ_CTRL_VLD_BYTES_SET(x)\
	FIELD_PREP(QS_INJ_CTRL_VLD_BYTES, x)
#define QS_INJ_CTRL_VLD_BYTES_GET(x)\
	FIELD_GET(QS_INJ_CTRL_VLD_BYTES, x)

/*      DEVCPU_QS:INJ:INJ_STATUS */
#define QS_INJ_STATUS             __REG(TARGET_QS,\
					0, 1, 36, 0, 1, 40, 24, 0, 1, 4)

#define QS_INJ_STATUS_WMARK_REACHED              GENMASK(5, 4)
#define QS_INJ_STATUS_WMARK_REACHED_SET(x)\
	FIELD_PREP(QS_INJ_STATUS_WMARK_REACHED, x)
#define QS_INJ_STATUS_WMARK_REACHED_GET(x)\
	FIELD_GET(QS_INJ_STATUS_WMARK_REACHED, x)

#define QS_INJ_STATUS_FIFO_RDY                   GENMASK(3, 2)
#define QS_INJ_STATUS_FIFO_RDY_SET(x)\
	FIELD_PREP(QS_INJ_STATUS_FIFO_RDY, x)
#define QS_INJ_STATUS_FIFO_RDY_GET(x)\
	FIELD_GET(QS_INJ_STATUS_FIFO_RDY, x)

#define QS_INJ_STATUS_INJ_IN_PROGRESS            GENMASK(1, 0)
#define QS_INJ_STATUS_INJ_IN_PROGRESS_SET(x)\
	FIELD_PREP(QS_INJ_STATUS_INJ_IN_PROGRESS, x)
#define QS_INJ_STATUS_INJ_IN_PROGRESS_GET(x)\
	FIELD_GET(QS_INJ_STATUS_INJ_IN_PROGRESS, x)

/*      QSYS:PAUSE_CFG:PAUSE_CFG */
#define QSYS_PAUSE_CFG(r)         __REG(TARGET_QSYS,\
					0, 1, 544, 0, 1, 1128, 0, r, 70, 4)

#define QSYS_PAUSE_CFG_PAUSE_START               GENMASK(25, 14)
#define QSYS_PAUSE_CFG_PAUSE_START_SET(x)\
	FIELD_PREP(QSYS_PAUSE_CFG_PAUSE_START, x)
#define QSYS_PAUSE_CFG_PAUSE_START_GET(x)\
	FIELD_GET(QSYS_PAUSE_CFG_PAUSE_START, x)

#define QSYS_PAUSE_CFG_PAUSE_STOP                GENMASK(13, 2)
#define QSYS_PAUSE_CFG_PAUSE_STOP_SET(x)\
	FIELD_PREP(QSYS_PAUSE_CFG_PAUSE_STOP, x)
#define QSYS_PAUSE_CFG_PAUSE_STOP_GET(x)\
	FIELD_GET(QSYS_PAUSE_CFG_PAUSE_STOP, x)

#define QSYS_PAUSE_CFG_PAUSE_ENA                 BIT(1)
#define QSYS_PAUSE_CFG_PAUSE_ENA_SET(x)\
	FIELD_PREP(QSYS_PAUSE_CFG_PAUSE_ENA, x)
#define QSYS_PAUSE_CFG_PAUSE_ENA_GET(x)\
	FIELD_GET(QSYS_PAUSE_CFG_PAUSE_ENA, x)

#define QSYS_PAUSE_CFG_AGGRESSIVE_TAILDROP_ENA   BIT(0)
#define QSYS_PAUSE_CFG_AGGRESSIVE_TAILDROP_ENA_SET(x)\
	FIELD_PREP(QSYS_PAUSE_CFG_AGGRESSIVE_TAILDROP_ENA, x)
#define QSYS_PAUSE_CFG_AGGRESSIVE_TAILDROP_ENA_GET(x)\
	FIELD_GET(QSYS_PAUSE_CFG_AGGRESSIVE_TAILDROP_ENA, x)

/*      QSYS:PAUSE_CFG:ATOP */
#define QSYS_ATOP(r)              __REG(TARGET_QSYS,\
					0, 1, 544, 0, 1, 1128, 284, r, 70, 4)

#define QSYS_ATOP_ATOP                           GENMASK(11, 0)
#define QSYS_ATOP_ATOP_SET(x)\
	FIELD_PREP(QSYS_ATOP_ATOP, x)
#define QSYS_ATOP_ATOP_GET(x)\
	FIELD_GET(QSYS_ATOP_ATOP, x)

/*      QSYS:PAUSE_CFG:FWD_PRESSURE */
#define QSYS_FWD_PRESSURE(r)      __REG(TARGET_QSYS,\
					0, 1, 544, 0, 1, 1128, 564, r, 70, 4)

#define QSYS_FWD_PRESSURE_FWD_PRESSURE           GENMASK(11, 1)
#define QSYS_FWD_PRESSURE_FWD_PRESSURE_SET(x)\
	FIELD_PREP(QSYS_FWD_PRESSURE_FWD_PRESSURE, x)
#define QSYS_FWD_PRESSURE_FWD_PRESSURE_GET(x)\
	FIELD_GET(QSYS_FWD_PRESSURE_FWD_PRESSURE, x)

#define QSYS_FWD_PRESSURE_FWD_PRESSURE_DIS       BIT(0)
#define QSYS_FWD_PRESSURE_FWD_PRESSURE_DIS_SET(x)\
	FIELD_PREP(QSYS_FWD_PRESSURE_FWD_PRESSURE_DIS, x)
#define QSYS_FWD_PRESSURE_FWD_PRESSURE_DIS_GET(x)\
	FIELD_GET(QSYS_FWD_PRESSURE_FWD_PRESSURE_DIS, x)

/*      QSYS:PAUSE_CFG:ATOP_TOT_CFG */
#define QSYS_ATOP_TOT_CFG         __REG(TARGET_QSYS,\
					0, 1, 544, 0, 1, 1128, 844, 0, 1, 4)

#define QSYS_ATOP_TOT_CFG_ATOP_TOT               GENMASK(11, 0)
#define QSYS_ATOP_TOT_CFG_ATOP_TOT_SET(x)\
	FIELD_PREP(QSYS_ATOP_TOT_CFG_ATOP_TOT, x)
#define QSYS_ATOP_TOT_CFG_ATOP_TOT_GET(x)\
	FIELD_GET(QSYS_ATOP_TOT_CFG_ATOP_TOT, x)

/*      QSYS:CALCFG:CAL_AUTO */
#define QSYS_CAL_AUTO(r)          __REG(TARGET_QSYS,\
					0, 1, 2304, 0, 1, 40, 0, r, 7, 4)

#define QSYS_CAL_AUTO_CAL_AUTO                   GENMASK(29, 0)
#define QSYS_CAL_AUTO_CAL_AUTO_SET(x)\
	FIELD_PREP(QSYS_CAL_AUTO_CAL_AUTO, x)
#define QSYS_CAL_AUTO_CAL_AUTO_GET(x)\
	FIELD_GET(QSYS_CAL_AUTO_CAL_AUTO, x)

/*      QSYS:CALCFG:CAL_CTRL */
#define QSYS_CAL_CTRL             __REG(TARGET_QSYS,\
					0, 1, 2304, 0, 1, 40, 36, 0, 1, 4)

#define QSYS_CAL_CTRL_CAL_MODE                   GENMASK(14, 11)
#define QSYS_CAL_CTRL_CAL_MODE_SET(x)\
	FIELD_PREP(QSYS_CAL_CTRL_CAL_MODE, x)
#define QSYS_CAL_CTRL_CAL_MODE_GET(x)\
	FIELD_GET(QSYS_CAL_CTRL_CAL_MODE, x)

#define QSYS_CAL_CTRL_CAL_AUTO_GRANT_RATE        GENMASK(10, 1)
#define QSYS_CAL_CTRL_CAL_AUTO_GRANT_RATE_SET(x)\
	FIELD_PREP(QSYS_CAL_CTRL_CAL_AUTO_GRANT_RATE, x)
#define QSYS_CAL_CTRL_CAL_AUTO_GRANT_RATE_GET(x)\
	FIELD_GET(QSYS_CAL_CTRL_CAL_AUTO_GRANT_RATE, x)

#define QSYS_CAL_CTRL_CAL_AUTO_ERROR             BIT(0)
#define QSYS_CAL_CTRL_CAL_AUTO_ERROR_SET(x)\
	FIELD_PREP(QSYS_CAL_CTRL_CAL_AUTO_ERROR, x)
#define QSYS_CAL_CTRL_CAL_AUTO_ERROR_GET(x)\
	FIELD_GET(QSYS_CAL_CTRL_CAL_AUTO_ERROR, x)

/*      QSYS:RAM_CTRL:RAM_INIT */
#define QSYS_RAM_INIT             __REG(TARGET_QSYS,\
					0, 1, 2344, 0, 1, 4, 0, 0, 1, 4)

#define QSYS_RAM_INIT_RAM_INIT                   BIT(1)
#define QSYS_RAM_INIT_RAM_INIT_SET(x)\
	FIELD_PREP(QSYS_RAM_INIT_RAM_INIT, x)
#define QSYS_RAM_INIT_RAM_INIT_GET(x)\
	FIELD_GET(QSYS_RAM_INIT_RAM_INIT, x)

#define QSYS_RAM_INIT_RAM_CFG_HOOK               BIT(0)
#define QSYS_RAM_INIT_RAM_CFG_HOOK_SET(x)\
	FIELD_PREP(QSYS_RAM_INIT_RAM_CFG_HOOK, x)
#define QSYS_RAM_INIT_RAM_CFG_HOOK_GET(x)\
	FIELD_GET(QSYS_RAM_INIT_RAM_CFG_HOOK, x)

/*      REW:COMMON:OWN_UPSID */
#define REW_OWN_UPSID(r)          __REG(TARGET_REW,\
					0, 1, 387264, 0, 1, 1232, 0, r, 3, 4)

#define REW_OWN_UPSID_OWN_UPSID                  GENMASK(4, 0)
#define REW_OWN_UPSID_OWN_UPSID_SET(x)\
	FIELD_PREP(REW_OWN_UPSID_OWN_UPSID, x)
#define REW_OWN_UPSID_OWN_UPSID_GET(x)\
	FIELD_GET(REW_OWN_UPSID_OWN_UPSID, x)

/*      REW:COMMON:RTAG_ETAG_CTRL */
#define REW_RTAG_ETAG_CTRL(r)     __REG(TARGET_REW,\
					0, 1, 387264, 0, 1, 1232, 560, r, 70, 4)

#define REW_RTAG_ETAG_CTRL_IPE_TBL               GENMASK(9, 3)
#define REW_RTAG_ETAG_CTRL_IPE_TBL_SET(x)\
	FIELD_PREP(REW_RTAG_ETAG_CTRL_IPE_TBL, x)
#define REW_RTAG_ETAG_CTRL_IPE_TBL_GET(x)\
	FIELD_GET(REW_RTAG_ETAG_CTRL_IPE_TBL, x)

#define REW_RTAG_ETAG_CTRL_ES0_ISDX_KEY_ENA      GENMASK(2, 1)
#define REW_RTAG_ETAG_CTRL_ES0_ISDX_KEY_ENA_SET(x)\
	FIELD_PREP(REW_RTAG_ETAG_CTRL_ES0_ISDX_KEY_ENA, x)
#define REW_RTAG_ETAG_CTRL_ES0_ISDX_KEY_ENA_GET(x)\
	FIELD_GET(REW_RTAG_ETAG_CTRL_ES0_ISDX_KEY_ENA, x)

#define REW_RTAG_ETAG_CTRL_KEEP_ETAG             BIT(0)
#define REW_RTAG_ETAG_CTRL_KEEP_ETAG_SET(x)\
	FIELD_PREP(REW_RTAG_ETAG_CTRL_KEEP_ETAG, x)
#define REW_RTAG_ETAG_CTRL_KEEP_ETAG_GET(x)\
	FIELD_GET(REW_RTAG_ETAG_CTRL_KEEP_ETAG, x)

/*      REW:COMMON:ES0_CTRL */
#define REW_ES0_CTRL              __REG(TARGET_REW,\
					0, 1, 387264, 0, 1, 1232, 852, 0, 1, 4)

#define REW_ES0_CTRL_ES0_BY_RT_FWD               BIT(5)
#define REW_ES0_CTRL_ES0_BY_RT_FWD_SET(x)\
	FIELD_PREP(REW_ES0_CTRL_ES0_BY_RT_FWD, x)
#define REW_ES0_CTRL_ES0_BY_RT_FWD_GET(x)\
	FIELD_GET(REW_ES0_CTRL_ES0_BY_RT_FWD, x)

#define REW_ES0_CTRL_ES0_BY_RLEG                 BIT(4)
#define REW_ES0_CTRL_ES0_BY_RLEG_SET(x)\
	FIELD_PREP(REW_ES0_CTRL_ES0_BY_RLEG, x)
#define REW_ES0_CTRL_ES0_BY_RLEG_GET(x)\
	FIELD_GET(REW_ES0_CTRL_ES0_BY_RLEG, x)

#define REW_ES0_CTRL_ES0_DPORT_ENA               BIT(3)
#define REW_ES0_CTRL_ES0_DPORT_ENA_SET(x)\
	FIELD_PREP(REW_ES0_CTRL_ES0_DPORT_ENA, x)
#define REW_ES0_CTRL_ES0_DPORT_ENA_GET(x)\
	FIELD_GET(REW_ES0_CTRL_ES0_DPORT_ENA, x)

#define REW_ES0_CTRL_ES0_FRM_LBK_CFG             BIT(2)
#define REW_ES0_CTRL_ES0_FRM_LBK_CFG_SET(x)\
	FIELD_PREP(REW_ES0_CTRL_ES0_FRM_LBK_CFG, x)
#define REW_ES0_CTRL_ES0_FRM_LBK_CFG_GET(x)\
	FIELD_GET(REW_ES0_CTRL_ES0_FRM_LBK_CFG, x)

#define REW_ES0_CTRL_ES0_VD2_ENCAP_ID_ENA        BIT(1)
#define REW_ES0_CTRL_ES0_VD2_ENCAP_ID_ENA_SET(x)\
	FIELD_PREP(REW_ES0_CTRL_ES0_VD2_ENCAP_ID_ENA, x)
#define REW_ES0_CTRL_ES0_VD2_ENCAP_ID_ENA_GET(x)\
	FIELD_GET(REW_ES0_CTRL_ES0_VD2_ENCAP_ID_ENA, x)

#define REW_ES0_CTRL_ES0_LU_ENA                  BIT(0)
#define REW_ES0_CTRL_ES0_LU_ENA_SET(x)\
	FIELD_PREP(REW_ES0_CTRL_ES0_LU_ENA, x)
#define REW_ES0_CTRL_ES0_LU_ENA_GET(x)\
	FIELD_GET(REW_ES0_CTRL_ES0_LU_ENA, x)

/*      REW:PORT:PORT_VLAN_CFG */
#define REW_PORT_VLAN_CFG(g)      __REG(TARGET_REW,\
					0, 1, 360448, g, 70, 256, 0, 0, 1, 4)

#define REW_PORT_VLAN_CFG_PORT_PCP               GENMASK(15, 13)
#define REW_PORT_VLAN_CFG_PORT_PCP_SET(x)\
	FIELD_PREP(REW_PORT_VLAN_CFG_PORT_PCP, x)
#define REW_PORT_VLAN_CFG_PORT_PCP_GET(x)\
	FIELD_GET(REW_PORT_VLAN_CFG_PORT_PCP, x)

#define REW_PORT_VLAN_CFG_PORT_DEI               BIT(12)
#define REW_PORT_VLAN_CFG_PORT_DEI_SET(x)\
	FIELD_PREP(REW_PORT_VLAN_CFG_PORT_DEI, x)
#define REW_PORT_VLAN_CFG_PORT_DEI_GET(x)\
	FIELD_GET(REW_PORT_VLAN_CFG_PORT_DEI, x)

#define REW_PORT_VLAN_CFG_PORT_VID               GENMASK(11, 0)
#define REW_PORT_VLAN_CFG_PORT_VID_SET(x)\
	FIELD_PREP(REW_PORT_VLAN_CFG_PORT_VID, x)
#define REW_PORT_VLAN_CFG_PORT_VID_GET(x)\
	FIELD_GET(REW_PORT_VLAN_CFG_PORT_VID, x)

/*      REW:PORT:PCP_MAP_DE0 */
#define REW_PCP_MAP_DE0(g, r)     __REG(TARGET_REW,\
					0, 1, 360448, g, 70, 256, 4, r, 8, 4)

#define REW_PCP_MAP_DE0_PCP_DE0                  GENMASK(2, 0)
#define REW_PCP_MAP_DE0_PCP_DE0_SET(x)\
	FIELD_PREP(REW_PCP_MAP_DE0_PCP_DE0, x)
#define REW_PCP_MAP_DE0_PCP_DE0_GET(x)\
	FIELD_GET(REW_PCP_MAP_DE0_PCP_DE0, x)

/*      REW:PORT:PCP_MAP_DE1 */
#define REW_PCP_MAP_DE1(g, r)     __REG(TARGET_REW,\
					0, 1, 360448, g, 70, 256, 36, r, 8, 4)

#define REW_PCP_MAP_DE1_PCP_DE1                  GENMASK(2, 0)
#define REW_PCP_MAP_DE1_PCP_DE1_SET(x)\
	FIELD_PREP(REW_PCP_MAP_DE1_PCP_DE1, x)
#define REW_PCP_MAP_DE1_PCP_DE1_GET(x)\
	FIELD_GET(REW_PCP_MAP_DE1_PCP_DE1, x)

/*      REW:PORT:DEI_MAP_DE0 */
#define REW_DEI_MAP_DE0(g, r)     __REG(TARGET_REW,\
					0, 1, 360448, g, 70, 256, 68, r, 8, 4)

#define REW_DEI_MAP_DE0_DEI_DE0                  BIT(0)
#define REW_DEI_MAP_DE0_DEI_DE0_SET(x)\
	FIELD_PREP(REW_DEI_MAP_DE0_DEI_DE0, x)
#define REW_DEI_MAP_DE0_DEI_DE0_GET(x)\
	FIELD_GET(REW_DEI_MAP_DE0_DEI_DE0, x)

/*      REW:PORT:DEI_MAP_DE1 */
#define REW_DEI_MAP_DE1(g, r)     __REG(TARGET_REW,\
					0, 1, 360448, g, 70, 256, 100, r, 8, 4)

#define REW_DEI_MAP_DE1_DEI_DE1                  BIT(0)
#define REW_DEI_MAP_DE1_DEI_DE1_SET(x)\
	FIELD_PREP(REW_DEI_MAP_DE1_DEI_DE1, x)
#define REW_DEI_MAP_DE1_DEI_DE1_GET(x)\
	FIELD_GET(REW_DEI_MAP_DE1_DEI_DE1, x)

/*      REW:PORT:TAG_CTRL */
#define REW_TAG_CTRL(g)           __REG(TARGET_REW,\
					0, 1, 360448, g, 70, 256, 132, 0, 1, 4)

#define REW_TAG_CTRL_TAG_CFG_OBEY_WAS_TAGGED     BIT(13)
#define REW_TAG_CTRL_TAG_CFG_OBEY_WAS_TAGGED_SET(x)\
	FIELD_PREP(REW_TAG_CTRL_TAG_CFG_OBEY_WAS_TAGGED, x)
#define REW_TAG_CTRL_TAG_CFG_OBEY_WAS_TAGGED_GET(x)\
	FIELD_GET(REW_TAG_CTRL_TAG_CFG_OBEY_WAS_TAGGED, x)

#define REW_TAG_CTRL_TAG_CFG                     GENMASK(12, 11)
#define REW_TAG_CTRL_TAG_CFG_SET(x)\
	FIELD_PREP(REW_TAG_CTRL_TAG_CFG, x)
#define REW_TAG_CTRL_TAG_CFG_GET(x)\
	FIELD_GET(REW_TAG_CTRL_TAG_CFG, x)

#define REW_TAG_CTRL_TAG_TPID_CFG                GENMASK(10, 8)
#define REW_TAG_CTRL_TAG_TPID_CFG_SET(x)\
	FIELD_PREP(REW_TAG_CTRL_TAG_TPID_CFG, x)
#define REW_TAG_CTRL_TAG_TPID_CFG_GET(x)\
	FIELD_GET(REW_TAG_CTRL_TAG_TPID_CFG, x)

#define REW_TAG_CTRL_TAG_VID_CFG                 GENMASK(7, 6)
#define REW_TAG_CTRL_TAG_VID_CFG_SET(x)\
	FIELD_PREP(REW_TAG_CTRL_TAG_VID_CFG, x)
#define REW_TAG_CTRL_TAG_VID_CFG_GET(x)\
	FIELD_GET(REW_TAG_CTRL_TAG_VID_CFG, x)

#define REW_TAG_CTRL_TAG_PCP_CFG                 GENMASK(5, 3)
#define REW_TAG_CTRL_TAG_PCP_CFG_SET(x)\
	FIELD_PREP(REW_TAG_CTRL_TAG_PCP_CFG, x)
#define REW_TAG_CTRL_TAG_PCP_CFG_GET(x)\
	FIELD_GET(REW_TAG_CTRL_TAG_PCP_CFG, x)

#define REW_TAG_CTRL_TAG_DEI_CFG                 GENMASK(2, 0)
#define REW_TAG_CTRL_TAG_DEI_CFG_SET(x)\
	FIELD_PREP(REW_TAG_CTRL_TAG_DEI_CFG, x)
#define REW_TAG_CTRL_TAG_DEI_CFG_GET(x)\
	FIELD_GET(REW_TAG_CTRL_TAG_DEI_CFG, x)

/*      REW:PORT:DSCP_MAP */
#define REW_DSCP_MAP(g)           __REG(TARGET_REW,\
					0, 1, 360448, g, 70, 256, 136, 0, 1, 4)

#define REW_DSCP_MAP_DSCP_UPDATE_ENA             BIT(1)
#define REW_DSCP_MAP_DSCP_UPDATE_ENA_SET(x)\
	FIELD_PREP(REW_DSCP_MAP_DSCP_UPDATE_ENA, x)
#define REW_DSCP_MAP_DSCP_UPDATE_ENA_GET(x)\
	FIELD_GET(REW_DSCP_MAP_DSCP_UPDATE_ENA, x)

#define REW_DSCP_MAP_DSCP_REMAP_ENA              BIT(0)
#define REW_DSCP_MAP_DSCP_REMAP_ENA_SET(x)\
	FIELD_PREP(REW_DSCP_MAP_DSCP_REMAP_ENA, x)
#define REW_DSCP_MAP_DSCP_REMAP_ENA_GET(x)\
	FIELD_GET(REW_DSCP_MAP_DSCP_REMAP_ENA, x)

/*      REW:PTP_CTRL:PTP_TWOSTEP_CTRL */
#define REW_PTP_TWOSTEP_CTRL      __REG(TARGET_REW,\
					0, 1, 378368, 0, 1, 40, 0, 0, 1, 4)

#define REW_PTP_TWOSTEP_CTRL_PTP_OVWR_ENA        BIT(12)
#define REW_PTP_TWOSTEP_CTRL_PTP_OVWR_ENA_SET(x)\
	FIELD_PREP(REW_PTP_TWOSTEP_CTRL_PTP_OVWR_ENA, x)
#define REW_PTP_TWOSTEP_CTRL_PTP_OVWR_ENA_GET(x)\
	FIELD_GET(REW_PTP_TWOSTEP_CTRL_PTP_OVWR_ENA, x)

#define REW_PTP_TWOSTEP_CTRL_PTP_NXT             BIT(11)
#define REW_PTP_TWOSTEP_CTRL_PTP_NXT_SET(x)\
	FIELD_PREP(REW_PTP_TWOSTEP_CTRL_PTP_NXT, x)
#define REW_PTP_TWOSTEP_CTRL_PTP_NXT_GET(x)\
	FIELD_GET(REW_PTP_TWOSTEP_CTRL_PTP_NXT, x)

#define REW_PTP_TWOSTEP_CTRL_PTP_VLD             BIT(10)
#define REW_PTP_TWOSTEP_CTRL_PTP_VLD_SET(x)\
	FIELD_PREP(REW_PTP_TWOSTEP_CTRL_PTP_VLD, x)
#define REW_PTP_TWOSTEP_CTRL_PTP_VLD_GET(x)\
	FIELD_GET(REW_PTP_TWOSTEP_CTRL_PTP_VLD, x)

#define REW_PTP_TWOSTEP_CTRL_STAMP_TX            BIT(9)
#define REW_PTP_TWOSTEP_CTRL_STAMP_TX_SET(x)\
	FIELD_PREP(REW_PTP_TWOSTEP_CTRL_STAMP_TX, x)
#define REW_PTP_TWOSTEP_CTRL_STAMP_TX_GET(x)\
	FIELD_GET(REW_PTP_TWOSTEP_CTRL_STAMP_TX, x)

#define REW_PTP_TWOSTEP_CTRL_STAMP_PORT          GENMASK(8, 1)
#define REW_PTP_TWOSTEP_CTRL_STAMP_PORT_SET(x)\
	FIELD_PREP(REW_PTP_TWOSTEP_CTRL_STAMP_PORT, x)
#define REW_PTP_TWOSTEP_CTRL_STAMP_PORT_GET(x)\
	FIELD_GET(REW_PTP_TWOSTEP_CTRL_STAMP_PORT, x)

#define REW_PTP_TWOSTEP_CTRL_PTP_OVFL            BIT(0)
#define REW_PTP_TWOSTEP_CTRL_PTP_OVFL_SET(x)\
	FIELD_PREP(REW_PTP_TWOSTEP_CTRL_PTP_OVFL, x)
#define REW_PTP_TWOSTEP_CTRL_PTP_OVFL_GET(x)\
	FIELD_GET(REW_PTP_TWOSTEP_CTRL_PTP_OVFL, x)

/*      REW:PTP_CTRL:PTP_TWOSTEP_STAMP */
#define REW_PTP_TWOSTEP_STAMP     __REG(TARGET_REW,\
					0, 1, 378368, 0, 1, 40, 4, 0, 1, 4)

#define REW_PTP_TWOSTEP_STAMP_STAMP_NSEC         GENMASK(29, 0)
#define REW_PTP_TWOSTEP_STAMP_STAMP_NSEC_SET(x)\
	FIELD_PREP(REW_PTP_TWOSTEP_STAMP_STAMP_NSEC, x)
#define REW_PTP_TWOSTEP_STAMP_STAMP_NSEC_GET(x)\
	FIELD_GET(REW_PTP_TWOSTEP_STAMP_STAMP_NSEC, x)

/*      REW:PTP_CTRL:PTP_TWOSTEP_STAMP_SUBNS */
#define REW_PTP_TWOSTEP_STAMP_SUBNS __REG(TARGET_REW,\
					0, 1, 378368, 0, 1, 40, 8, 0, 1, 4)

#define REW_PTP_TWOSTEP_STAMP_SUBNS_STAMP_SUB_NSEC GENMASK(7, 0)
#define REW_PTP_TWOSTEP_STAMP_SUBNS_STAMP_SUB_NSEC_SET(x)\
	FIELD_PREP(REW_PTP_TWOSTEP_STAMP_SUBNS_STAMP_SUB_NSEC, x)
#define REW_PTP_TWOSTEP_STAMP_SUBNS_STAMP_SUB_NSEC_GET(x)\
	FIELD_GET(REW_PTP_TWOSTEP_STAMP_SUBNS_STAMP_SUB_NSEC, x)

/*      REW:PTP_CTRL:PTP_RSRV_NOT_ZERO */
#define REW_PTP_RSRV_NOT_ZERO     __REG(TARGET_REW,\
					0, 1, 378368, 0, 1, 40, 12, 0, 1, 4)

/*      REW:PTP_CTRL:PTP_RSRV_NOT_ZERO1 */
#define REW_PTP_RSRV_NOT_ZERO1    __REG(TARGET_REW,\
					0, 1, 378368, 0, 1, 40, 16, 0, 1, 4)

/*      REW:PTP_CTRL:PTP_RSRV_NOT_ZERO2 */
#define REW_PTP_RSRV_NOT_ZERO2    __REG(TARGET_REW,\
					0, 1, 378368, 0, 1, 40, 20, 0, 1, 4)

#define REW_PTP_RSRV_NOT_ZERO2_PTP_RSRV_NOT_ZERO2 GENMASK(5, 0)
#define REW_PTP_RSRV_NOT_ZERO2_PTP_RSRV_NOT_ZERO2_SET(x)\
	FIELD_PREP(REW_PTP_RSRV_NOT_ZERO2_PTP_RSRV_NOT_ZERO2, x)
#define REW_PTP_RSRV_NOT_ZERO2_PTP_RSRV_NOT_ZERO2_GET(x)\
	FIELD_GET(REW_PTP_RSRV_NOT_ZERO2_PTP_RSRV_NOT_ZERO2, x)

/*      REW:PTP_CTRL:PTP_GEN_STAMP_FMT */
#define REW_PTP_GEN_STAMP_FMT(r)  __REG(TARGET_REW,\
					0, 1, 378368, 0, 1, 40, 24, r, 4, 4)

#define REW_PTP_GEN_STAMP_FMT_RT_OFS             GENMASK(6, 2)
#define REW_PTP_GEN_STAMP_FMT_RT_OFS_SET(x)\
	FIELD_PREP(REW_PTP_GEN_STAMP_FMT_RT_OFS, x)
#define REW_PTP_GEN_STAMP_FMT_RT_OFS_GET(x)\
	FIELD_GET(REW_PTP_GEN_STAMP_FMT_RT_OFS, x)

#define REW_PTP_GEN_STAMP_FMT_RT_FMT             GENMASK(1, 0)
#define REW_PTP_GEN_STAMP_FMT_RT_FMT_SET(x)\
	FIELD_PREP(REW_PTP_GEN_STAMP_FMT_RT_FMT, x)
#define REW_PTP_GEN_STAMP_FMT_RT_FMT_GET(x)\
	FIELD_GET(REW_PTP_GEN_STAMP_FMT_RT_FMT, x)

/*      REW:RAM_CTRL:RAM_INIT */
#define REW_RAM_INIT              __REG(TARGET_REW,\
					0, 1, 378696, 0, 1, 4, 0, 0, 1, 4)

#define REW_RAM_INIT_RAM_INIT                    BIT(1)
#define REW_RAM_INIT_RAM_INIT_SET(x)\
	FIELD_PREP(REW_RAM_INIT_RAM_INIT, x)
#define REW_RAM_INIT_RAM_INIT_GET(x)\
	FIELD_GET(REW_RAM_INIT_RAM_INIT, x)

#define REW_RAM_INIT_RAM_CFG_HOOK                BIT(0)
#define REW_RAM_INIT_RAM_CFG_HOOK_SET(x)\
	FIELD_PREP(REW_RAM_INIT_RAM_CFG_HOOK, x)
#define REW_RAM_INIT_RAM_CFG_HOOK_GET(x)\
	FIELD_GET(REW_RAM_INIT_RAM_CFG_HOOK, x)

/*      VCAP_ES0:VCAP_CORE_CFG:VCAP_UPDATE_CTRL */
#define VCAP_ES0_CTRL             __REG(TARGET_VCAP_ES0,\
					0, 1, 0, 0, 1, 8, 0, 0, 1, 4)

#define VCAP_ES0_CTRL_UPDATE_CMD                 GENMASK(24, 22)
#define VCAP_ES0_CTRL_UPDATE_CMD_SET(x)\
	FIELD_PREP(VCAP_ES0_CTRL_UPDATE_CMD, x)
#define VCAP_ES0_CTRL_UPDATE_CMD_GET(x)\
	FIELD_GET(VCAP_ES0_CTRL_UPDATE_CMD, x)

#define VCAP_ES0_CTRL_UPDATE_ENTRY_DIS           BIT(21)
#define VCAP_ES0_CTRL_UPDATE_ENTRY_DIS_SET(x)\
	FIELD_PREP(VCAP_ES0_CTRL_UPDATE_ENTRY_DIS, x)
#define VCAP_ES0_CTRL_UPDATE_ENTRY_DIS_GET(x)\
	FIELD_GET(VCAP_ES0_CTRL_UPDATE_ENTRY_DIS, x)

#define VCAP_ES0_CTRL_UPDATE_ACTION_DIS          BIT(20)
#define VCAP_ES0_CTRL_UPDATE_ACTION_DIS_SET(x)\
	FIELD_PREP(VCAP_ES0_CTRL_UPDATE_ACTION_DIS, x)
#define VCAP_ES0_CTRL_UPDATE_ACTION_DIS_GET(x)\
	FIELD_GET(VCAP_ES0_CTRL_UPDATE_ACTION_DIS, x)

#define VCAP_ES0_CTRL_UPDATE_CNT_DIS             BIT(19)
#define VCAP_ES0_CTRL_UPDATE_CNT_DIS_SET(x)\
	FIELD_PREP(VCAP_ES0_CTRL_UPDATE_CNT_DIS, x)
#define VCAP_ES0_CTRL_UPDATE_CNT_DIS_GET(x)\
	FIELD_GET(VCAP_ES0_CTRL_UPDATE_CNT_DIS, x)

#define VCAP_ES0_CTRL_UPDATE_ADDR                GENMASK(18, 3)
#define VCAP_ES0_CTRL_UPDATE_ADDR_SET(x)\
	FIELD_PREP(VCAP_ES0_CTRL_UPDATE_ADDR, x)
#define VCAP_ES0_CTRL_UPDATE_ADDR_GET(x)\
	FIELD_GET(VCAP_ES0_CTRL_UPDATE_ADDR, x)

#define VCAP_ES0_CTRL_UPDATE_SHOT                BIT(2)
#define VCAP_ES0_CTRL_UPDATE_SHOT_SET(x)\
	FIELD_PREP(VCAP_ES0_CTRL_UPDATE_SHOT, x)
#define VCAP_ES0_CTRL_UPDATE_SHOT_GET(x)\
	FIELD_GET(VCAP_ES0_CTRL_UPDATE_SHOT, x)

#define VCAP_ES0_CTRL_CLEAR_CACHE                BIT(1)
#define VCAP_ES0_CTRL_CLEAR_CACHE_SET(x)\
	FIELD_PREP(VCAP_ES0_CTRL_CLEAR_CACHE, x)
#define VCAP_ES0_CTRL_CLEAR_CACHE_GET(x)\
	FIELD_GET(VCAP_ES0_CTRL_CLEAR_CACHE, x)

#define VCAP_ES0_CTRL_MV_TRAFFIC_IGN             BIT(0)
#define VCAP_ES0_CTRL_MV_TRAFFIC_IGN_SET(x)\
	FIELD_PREP(VCAP_ES0_CTRL_MV_TRAFFIC_IGN, x)
#define VCAP_ES0_CTRL_MV_TRAFFIC_IGN_GET(x)\
	FIELD_GET(VCAP_ES0_CTRL_MV_TRAFFIC_IGN, x)

/*      VCAP_ES0:VCAP_CORE_CFG:VCAP_MV_CFG */
#define VCAP_ES0_CFG              __REG(TARGET_VCAP_ES0,\
					0, 1, 0, 0, 1, 8, 4, 0, 1, 4)

#define VCAP_ES0_CFG_MV_NUM_POS                  GENMASK(31, 16)
#define VCAP_ES0_CFG_MV_NUM_POS_SET(x)\
	FIELD_PREP(VCAP_ES0_CFG_MV_NUM_POS, x)
#define VCAP_ES0_CFG_MV_NUM_POS_GET(x)\
	FIELD_GET(VCAP_ES0_CFG_MV_NUM_POS, x)

#define VCAP_ES0_CFG_MV_SIZE                     GENMASK(15, 0)
#define VCAP_ES0_CFG_MV_SIZE_SET(x)\
	FIELD_PREP(VCAP_ES0_CFG_MV_SIZE, x)
#define VCAP_ES0_CFG_MV_SIZE_GET(x)\
	FIELD_GET(VCAP_ES0_CFG_MV_SIZE, x)

/*      VCAP_ES0:VCAP_CORE_CACHE:VCAP_ENTRY_DAT */
#define VCAP_ES0_VCAP_ENTRY_DAT(r) __REG(TARGET_VCAP_ES0,\
					0, 1, 8, 0, 1, 904, 0, r, 64, 4)

/*      VCAP_ES0:VCAP_CORE_CACHE:VCAP_MASK_DAT */
#define VCAP_ES0_VCAP_MASK_DAT(r) __REG(TARGET_VCAP_ES0,\
					0, 1, 8, 0, 1, 904, 256, r, 64, 4)

/*      VCAP_ES0:VCAP_CORE_CACHE:VCAP_ACTION_DAT */
#define VCAP_ES0_VCAP_ACTION_DAT(r) __REG(TARGET_VCAP_ES0,\
					0, 1, 8, 0, 1, 904, 512, r, 64, 4)

/*      VCAP_ES0:VCAP_CORE_CACHE:VCAP_CNT_DAT */
#define VCAP_ES0_VCAP_CNT_DAT(r)  __REG(TARGET_VCAP_ES0,\
					0, 1, 8, 0, 1, 904, 768, r, 32, 4)

/*      VCAP_ES0:VCAP_CORE_CACHE:VCAP_CNT_FW_DAT */
#define VCAP_ES0_VCAP_CNT_FW_DAT  __REG(TARGET_VCAP_ES0,\
					0, 1, 8, 0, 1, 904, 896, 0, 1, 4)

/*      VCAP_ES0:VCAP_CORE_CACHE:VCAP_TG_DAT */
#define VCAP_ES0_VCAP_TG_DAT      __REG(TARGET_VCAP_ES0,\
					0, 1, 8, 0, 1, 904, 900, 0, 1, 4)

/*      VCAP_ES0:VCAP_CORE_MAP:VCAP_CORE_IDX */
#define VCAP_ES0_IDX              __REG(TARGET_VCAP_ES0,\
					0, 1, 912, 0, 1, 8, 0, 0, 1, 4)

#define VCAP_ES0_IDX_CORE_IDX                    GENMASK(3, 0)
#define VCAP_ES0_IDX_CORE_IDX_SET(x)\
	FIELD_PREP(VCAP_ES0_IDX_CORE_IDX, x)
#define VCAP_ES0_IDX_CORE_IDX_GET(x)\
	FIELD_GET(VCAP_ES0_IDX_CORE_IDX, x)

/*      VCAP_ES0:VCAP_CORE_MAP:VCAP_CORE_MAP */
#define VCAP_ES0_MAP              __REG(TARGET_VCAP_ES0,\
					0, 1, 912, 0, 1, 8, 4, 0, 1, 4)

#define VCAP_ES0_MAP_CORE_MAP                    GENMASK(2, 0)
#define VCAP_ES0_MAP_CORE_MAP_SET(x)\
	FIELD_PREP(VCAP_ES0_MAP_CORE_MAP, x)
#define VCAP_ES0_MAP_CORE_MAP_GET(x)\
	FIELD_GET(VCAP_ES0_MAP_CORE_MAP, x)

/*      VCAP_ES0:VCAP_CORE_STICKY:VCAP_STICKY */
#define VCAP_ES0_VCAP_STICKY      __REG(TARGET_VCAP_ES0,\
					0, 1, 920, 0, 1, 4, 0, 0, 1, 4)

#define VCAP_ES0_VCAP_STICKY_VCAP_ROW_DELETED_STICKY BIT(0)
#define VCAP_ES0_VCAP_STICKY_VCAP_ROW_DELETED_STICKY_SET(x)\
	FIELD_PREP(VCAP_ES0_VCAP_STICKY_VCAP_ROW_DELETED_STICKY, x)
#define VCAP_ES0_VCAP_STICKY_VCAP_ROW_DELETED_STICKY_GET(x)\
	FIELD_GET(VCAP_ES0_VCAP_STICKY_VCAP_ROW_DELETED_STICKY, x)

/*      VCAP_ES0:VCAP_CONST:VCAP_VER */
#define VCAP_ES0_VCAP_VER         __REG(TARGET_VCAP_ES0,\
					0, 1, 924, 0, 1, 40, 0, 0, 1, 4)

/*      VCAP_ES0:VCAP_CONST:ENTRY_WIDTH */
#define VCAP_ES0_ENTRY_WIDTH      __REG(TARGET_VCAP_ES0,\
					0, 1, 924, 0, 1, 40, 4, 0, 1, 4)

/*      VCAP_ES0:VCAP_CONST:ENTRY_CNT */
#define VCAP_ES0_ENTRY_CNT        __REG(TARGET_VCAP_ES0,\
					0, 1, 924, 0, 1, 40, 8, 0, 1, 4)

/*      VCAP_ES0:VCAP_CONST:ENTRY_SWCNT */
#define VCAP_ES0_ENTRY_SWCNT      __REG(TARGET_VCAP_ES0,\
					0, 1, 924, 0, 1, 40, 12, 0, 1, 4)

/*      VCAP_ES0:VCAP_CONST:ENTRY_TG_WIDTH */
#define VCAP_ES0_ENTRY_TG_WIDTH   __REG(TARGET_VCAP_ES0,\
					0, 1, 924, 0, 1, 40, 16, 0, 1, 4)

/*      VCAP_ES0:VCAP_CONST:ACTION_DEF_CNT */
#define VCAP_ES0_ACTION_DEF_CNT   __REG(TARGET_VCAP_ES0,\
					0, 1, 924, 0, 1, 40, 20, 0, 1, 4)

/*      VCAP_ES0:VCAP_CONST:ACTION_WIDTH */
#define VCAP_ES0_ACTION_WIDTH     __REG(TARGET_VCAP_ES0,\
					0, 1, 924, 0, 1, 40, 24, 0, 1, 4)

/*      VCAP_ES0:VCAP_CONST:CNT_WIDTH */
#define VCAP_ES0_CNT_WIDTH        __REG(TARGET_VCAP_ES0,\
					0, 1, 924, 0, 1, 40, 28, 0, 1, 4)

/*      VCAP_ES0:VCAP_CONST:CORE_CNT */
#define VCAP_ES0_CORE_CNT         __REG(TARGET_VCAP_ES0,\
					0, 1, 924, 0, 1, 40, 32, 0, 1, 4)

/*      VCAP_ES0:VCAP_CONST:IF_CNT */
#define VCAP_ES0_IF_CNT           __REG(TARGET_VCAP_ES0,\
					0, 1, 924, 0, 1, 40, 36, 0, 1, 4)

/*      VCAP_ES2:VCAP_CORE_CFG:VCAP_UPDATE_CTRL */
#define VCAP_ES2_CTRL             __REG(TARGET_VCAP_ES2,\
					0, 1, 0, 0, 1, 8, 0, 0, 1, 4)

#define VCAP_ES2_CTRL_UPDATE_CMD                 GENMASK(24, 22)
#define VCAP_ES2_CTRL_UPDATE_CMD_SET(x)\
	FIELD_PREP(VCAP_ES2_CTRL_UPDATE_CMD, x)
#define VCAP_ES2_CTRL_UPDATE_CMD_GET(x)\
	FIELD_GET(VCAP_ES2_CTRL_UPDATE_CMD, x)

#define VCAP_ES2_CTRL_UPDATE_ENTRY_DIS           BIT(21)
#define VCAP_ES2_CTRL_UPDATE_ENTRY_DIS_SET(x)\
	FIELD_PREP(VCAP_ES2_CTRL_UPDATE_ENTRY_DIS, x)
#define VCAP_ES2_CTRL_UPDATE_ENTRY_DIS_GET(x)\
	FIELD_GET(VCAP_ES2_CTRL_UPDATE_ENTRY_DIS, x)

#define VCAP_ES2_CTRL_UPDATE_ACTION_DIS          BIT(20)
#define VCAP_ES2_CTRL_UPDATE_ACTION_DIS_SET(x)\
	FIELD_PREP(VCAP_ES2_CTRL_UPDATE_ACTION_DIS, x)
#define VCAP_ES2_CTRL_UPDATE_ACTION_DIS_GET(x)\
	FIELD_GET(VCAP_ES2_CTRL_UPDATE_ACTION_DIS, x)

#define VCAP_ES2_CTRL_UPDATE_CNT_DIS             BIT(19)
#define VCAP_ES2_CTRL_UPDATE_CNT_DIS_SET(x)\
	FIELD_PREP(VCAP_ES2_CTRL_UPDATE_CNT_DIS, x)
#define VCAP_ES2_CTRL_UPDATE_CNT_DIS_GET(x)\
	FIELD_GET(VCAP_ES2_CTRL_UPDATE_CNT_DIS, x)

#define VCAP_ES2_CTRL_UPDATE_ADDR                GENMASK(18, 3)
#define VCAP_ES2_CTRL_UPDATE_ADDR_SET(x)\
	FIELD_PREP(VCAP_ES2_CTRL_UPDATE_ADDR, x)
#define VCAP_ES2_CTRL_UPDATE_ADDR_GET(x)\
	FIELD_GET(VCAP_ES2_CTRL_UPDATE_ADDR, x)

#define VCAP_ES2_CTRL_UPDATE_SHOT                BIT(2)
#define VCAP_ES2_CTRL_UPDATE_SHOT_SET(x)\
	FIELD_PREP(VCAP_ES2_CTRL_UPDATE_SHOT, x)
#define VCAP_ES2_CTRL_UPDATE_SHOT_GET(x)\
	FIELD_GET(VCAP_ES2_CTRL_UPDATE_SHOT, x)

#define VCAP_ES2_CTRL_CLEAR_CACHE                BIT(1)
#define VCAP_ES2_CTRL_CLEAR_CACHE_SET(x)\
	FIELD_PREP(VCAP_ES2_CTRL_CLEAR_CACHE, x)
#define VCAP_ES2_CTRL_CLEAR_CACHE_GET(x)\
	FIELD_GET(VCAP_ES2_CTRL_CLEAR_CACHE, x)

#define VCAP_ES2_CTRL_MV_TRAFFIC_IGN             BIT(0)
#define VCAP_ES2_CTRL_MV_TRAFFIC_IGN_SET(x)\
	FIELD_PREP(VCAP_ES2_CTRL_MV_TRAFFIC_IGN, x)
#define VCAP_ES2_CTRL_MV_TRAFFIC_IGN_GET(x)\
	FIELD_GET(VCAP_ES2_CTRL_MV_TRAFFIC_IGN, x)

/*      VCAP_ES2:VCAP_CORE_CFG:VCAP_MV_CFG */
#define VCAP_ES2_CFG              __REG(TARGET_VCAP_ES2,\
					0, 1, 0, 0, 1, 8, 4, 0, 1, 4)

#define VCAP_ES2_CFG_MV_NUM_POS                  GENMASK(31, 16)
#define VCAP_ES2_CFG_MV_NUM_POS_SET(x)\
	FIELD_PREP(VCAP_ES2_CFG_MV_NUM_POS, x)
#define VCAP_ES2_CFG_MV_NUM_POS_GET(x)\
	FIELD_GET(VCAP_ES2_CFG_MV_NUM_POS, x)

#define VCAP_ES2_CFG_MV_SIZE                     GENMASK(15, 0)
#define VCAP_ES2_CFG_MV_SIZE_SET(x)\
	FIELD_PREP(VCAP_ES2_CFG_MV_SIZE, x)
#define VCAP_ES2_CFG_MV_SIZE_GET(x)\
	FIELD_GET(VCAP_ES2_CFG_MV_SIZE, x)

/*      VCAP_ES2:VCAP_CORE_CACHE:VCAP_ENTRY_DAT */
#define VCAP_ES2_VCAP_ENTRY_DAT(r) __REG(TARGET_VCAP_ES2,\
					0, 1, 8, 0, 1, 904, 0, r, 64, 4)

/*      VCAP_ES2:VCAP_CORE_CACHE:VCAP_MASK_DAT */
#define VCAP_ES2_VCAP_MASK_DAT(r) __REG(TARGET_VCAP_ES2,\
					0, 1, 8, 0, 1, 904, 256, r, 64, 4)

/*      VCAP_ES2:VCAP_CORE_CACHE:VCAP_ACTION_DAT */
#define VCAP_ES2_VCAP_ACTION_DAT(r) __REG(TARGET_VCAP_ES2,\
					0, 1, 8, 0, 1, 904, 512, r, 64, 4)

/*      VCAP_ES2:VCAP_CORE_CACHE:VCAP_CNT_DAT */
#define VCAP_ES2_VCAP_CNT_DAT(r)  __REG(TARGET_VCAP_ES2,\
					0, 1, 8, 0, 1, 904, 768, r, 32, 4)

/*      VCAP_ES2:VCAP_CORE_CACHE:VCAP_CNT_FW_DAT */
#define VCAP_ES2_VCAP_CNT_FW_DAT  __REG(TARGET_VCAP_ES2,\
					0, 1, 8, 0, 1, 904, 896, 0, 1, 4)

/*      VCAP_ES2:VCAP_CORE_CACHE:VCAP_TG_DAT */
#define VCAP_ES2_VCAP_TG_DAT      __REG(TARGET_VCAP_ES2,\
					0, 1, 8, 0, 1, 904, 900, 0, 1, 4)

/*      VCAP_ES2:VCAP_CORE_MAP:VCAP_CORE_IDX */
#define VCAP_ES2_IDX              __REG(TARGET_VCAP_ES2,\
					0, 1, 912, 0, 1, 8, 0, 0, 1, 4)

#define VCAP_ES2_IDX_CORE_IDX                    GENMASK(3, 0)
#define VCAP_ES2_IDX_CORE_IDX_SET(x)\
	FIELD_PREP(VCAP_ES2_IDX_CORE_IDX, x)
#define VCAP_ES2_IDX_CORE_IDX_GET(x)\
	FIELD_GET(VCAP_ES2_IDX_CORE_IDX, x)

/*      VCAP_ES2:VCAP_CORE_MAP:VCAP_CORE_MAP */
#define VCAP_ES2_MAP              __REG(TARGET_VCAP_ES2,\
					0, 1, 912, 0, 1, 8, 4, 0, 1, 4)

#define VCAP_ES2_MAP_CORE_MAP                    GENMASK(2, 0)
#define VCAP_ES2_MAP_CORE_MAP_SET(x)\
	FIELD_PREP(VCAP_ES2_MAP_CORE_MAP, x)
#define VCAP_ES2_MAP_CORE_MAP_GET(x)\
	FIELD_GET(VCAP_ES2_MAP_CORE_MAP, x)

/*      VCAP_ES2:VCAP_CORE_STICKY:VCAP_STICKY */
#define VCAP_ES2_VCAP_STICKY      __REG(TARGET_VCAP_ES2,\
					0, 1, 920, 0, 1, 4, 0, 0, 1, 4)

#define VCAP_ES2_VCAP_STICKY_VCAP_ROW_DELETED_STICKY BIT(0)
#define VCAP_ES2_VCAP_STICKY_VCAP_ROW_DELETED_STICKY_SET(x)\
	FIELD_PREP(VCAP_ES2_VCAP_STICKY_VCAP_ROW_DELETED_STICKY, x)
#define VCAP_ES2_VCAP_STICKY_VCAP_ROW_DELETED_STICKY_GET(x)\
	FIELD_GET(VCAP_ES2_VCAP_STICKY_VCAP_ROW_DELETED_STICKY, x)

/*      VCAP_ES2:VCAP_CONST:VCAP_VER */
#define VCAP_ES2_VCAP_VER         __REG(TARGET_VCAP_ES2,\
					0, 1, 924, 0, 1, 40, 0, 0, 1, 4)

/*      VCAP_ES2:VCAP_CONST:ENTRY_WIDTH */
#define VCAP_ES2_ENTRY_WIDTH      __REG(TARGET_VCAP_ES2,\
					0, 1, 924, 0, 1, 40, 4, 0, 1, 4)

/*      VCAP_ES2:VCAP_CONST:ENTRY_CNT */
#define VCAP_ES2_ENTRY_CNT        __REG(TARGET_VCAP_ES2,\
					0, 1, 924, 0, 1, 40, 8, 0, 1, 4)

/*      VCAP_ES2:VCAP_CONST:ENTRY_SWCNT */
#define VCAP_ES2_ENTRY_SWCNT      __REG(TARGET_VCAP_ES2,\
					0, 1, 924, 0, 1, 40, 12, 0, 1, 4)

/*      VCAP_ES2:VCAP_CONST:ENTRY_TG_WIDTH */
#define VCAP_ES2_ENTRY_TG_WIDTH   __REG(TARGET_VCAP_ES2,\
					0, 1, 924, 0, 1, 40, 16, 0, 1, 4)

/*      VCAP_ES2:VCAP_CONST:ACTION_DEF_CNT */
#define VCAP_ES2_ACTION_DEF_CNT   __REG(TARGET_VCAP_ES2,\
					0, 1, 924, 0, 1, 40, 20, 0, 1, 4)

/*      VCAP_ES2:VCAP_CONST:ACTION_WIDTH */
#define VCAP_ES2_ACTION_WIDTH     __REG(TARGET_VCAP_ES2,\
					0, 1, 924, 0, 1, 40, 24, 0, 1, 4)

/*      VCAP_ES2:VCAP_CONST:CNT_WIDTH */
#define VCAP_ES2_CNT_WIDTH        __REG(TARGET_VCAP_ES2,\
					0, 1, 924, 0, 1, 40, 28, 0, 1, 4)

/*      VCAP_ES2:VCAP_CONST:CORE_CNT */
#define VCAP_ES2_CORE_CNT         __REG(TARGET_VCAP_ES2,\
					0, 1, 924, 0, 1, 40, 32, 0, 1, 4)

/*      VCAP_ES2:VCAP_CONST:IF_CNT */
#define VCAP_ES2_IF_CNT           __REG(TARGET_VCAP_ES2,\
					0, 1, 924, 0, 1, 40, 36, 0, 1, 4)

/*      VCAP_SUPER:VCAP_CORE_CFG:VCAP_UPDATE_CTRL */
#define VCAP_SUPER_CTRL           __REG(TARGET_VCAP_SUPER,\
					0, 1, 0, 0, 1, 8, 0, 0, 1, 4)

#define VCAP_SUPER_CTRL_UPDATE_CMD               GENMASK(24, 22)
#define VCAP_SUPER_CTRL_UPDATE_CMD_SET(x)\
	FIELD_PREP(VCAP_SUPER_CTRL_UPDATE_CMD, x)
#define VCAP_SUPER_CTRL_UPDATE_CMD_GET(x)\
	FIELD_GET(VCAP_SUPER_CTRL_UPDATE_CMD, x)

#define VCAP_SUPER_CTRL_UPDATE_ENTRY_DIS         BIT(21)
#define VCAP_SUPER_CTRL_UPDATE_ENTRY_DIS_SET(x)\
	FIELD_PREP(VCAP_SUPER_CTRL_UPDATE_ENTRY_DIS, x)
#define VCAP_SUPER_CTRL_UPDATE_ENTRY_DIS_GET(x)\
	FIELD_GET(VCAP_SUPER_CTRL_UPDATE_ENTRY_DIS, x)

#define VCAP_SUPER_CTRL_UPDATE_ACTION_DIS        BIT(20)
#define VCAP_SUPER_CTRL_UPDATE_ACTION_DIS_SET(x)\
	FIELD_PREP(VCAP_SUPER_CTRL_UPDATE_ACTION_DIS, x)
#define VCAP_SUPER_CTRL_UPDATE_ACTION_DIS_GET(x)\
	FIELD_GET(VCAP_SUPER_CTRL_UPDATE_ACTION_DIS, x)

#define VCAP_SUPER_CTRL_UPDATE_CNT_DIS           BIT(19)
#define VCAP_SUPER_CTRL_UPDATE_CNT_DIS_SET(x)\
	FIELD_PREP(VCAP_SUPER_CTRL_UPDATE_CNT_DIS, x)
#define VCAP_SUPER_CTRL_UPDATE_CNT_DIS_GET(x)\
	FIELD_GET(VCAP_SUPER_CTRL_UPDATE_CNT_DIS, x)

#define VCAP_SUPER_CTRL_UPDATE_ADDR              GENMASK(18, 3)
#define VCAP_SUPER_CTRL_UPDATE_ADDR_SET(x)\
	FIELD_PREP(VCAP_SUPER_CTRL_UPDATE_ADDR, x)
#define VCAP_SUPER_CTRL_UPDATE_ADDR_GET(x)\
	FIELD_GET(VCAP_SUPER_CTRL_UPDATE_ADDR, x)

#define VCAP_SUPER_CTRL_UPDATE_SHOT              BIT(2)
#define VCAP_SUPER_CTRL_UPDATE_SHOT_SET(x)\
	FIELD_PREP(VCAP_SUPER_CTRL_UPDATE_SHOT, x)
#define VCAP_SUPER_CTRL_UPDATE_SHOT_GET(x)\
	FIELD_GET(VCAP_SUPER_CTRL_UPDATE_SHOT, x)

#define VCAP_SUPER_CTRL_CLEAR_CACHE              BIT(1)
#define VCAP_SUPER_CTRL_CLEAR_CACHE_SET(x)\
	FIELD_PREP(VCAP_SUPER_CTRL_CLEAR_CACHE, x)
#define VCAP_SUPER_CTRL_CLEAR_CACHE_GET(x)\
	FIELD_GET(VCAP_SUPER_CTRL_CLEAR_CACHE, x)

#define VCAP_SUPER_CTRL_MV_TRAFFIC_IGN           BIT(0)
#define VCAP_SUPER_CTRL_MV_TRAFFIC_IGN_SET(x)\
	FIELD_PREP(VCAP_SUPER_CTRL_MV_TRAFFIC_IGN, x)
#define VCAP_SUPER_CTRL_MV_TRAFFIC_IGN_GET(x)\
	FIELD_GET(VCAP_SUPER_CTRL_MV_TRAFFIC_IGN, x)

/*      VCAP_SUPER:VCAP_CORE_CFG:VCAP_MV_CFG */
#define VCAP_SUPER_CFG            __REG(TARGET_VCAP_SUPER,\
					0, 1, 0, 0, 1, 8, 4, 0, 1, 4)

#define VCAP_SUPER_CFG_MV_NUM_POS                GENMASK(31, 16)
#define VCAP_SUPER_CFG_MV_NUM_POS_SET(x)\
	FIELD_PREP(VCAP_SUPER_CFG_MV_NUM_POS, x)
#define VCAP_SUPER_CFG_MV_NUM_POS_GET(x)\
	FIELD_GET(VCAP_SUPER_CFG_MV_NUM_POS, x)

#define VCAP_SUPER_CFG_MV_SIZE                   GENMASK(15, 0)
#define VCAP_SUPER_CFG_MV_SIZE_SET(x)\
	FIELD_PREP(VCAP_SUPER_CFG_MV_SIZE, x)
#define VCAP_SUPER_CFG_MV_SIZE_GET(x)\
	FIELD_GET(VCAP_SUPER_CFG_MV_SIZE, x)

/*      VCAP_SUPER:VCAP_CORE_CACHE:VCAP_ENTRY_DAT */
#define VCAP_SUPER_VCAP_ENTRY_DAT(r) __REG(TARGET_VCAP_SUPER,\
					0, 1, 8, 0, 1, 904, 0, r, 64, 4)

/*      VCAP_SUPER:VCAP_CORE_CACHE:VCAP_MASK_DAT */
#define VCAP_SUPER_VCAP_MASK_DAT(r) __REG(TARGET_VCAP_SUPER,\
					0, 1, 8, 0, 1, 904, 256, r, 64, 4)

/*      VCAP_SUPER:VCAP_CORE_CACHE:VCAP_ACTION_DAT */
#define VCAP_SUPER_VCAP_ACTION_DAT(r) __REG(TARGET_VCAP_SUPER,\
					0, 1, 8, 0, 1, 904, 512, r, 64, 4)

/*      VCAP_SUPER:VCAP_CORE_CACHE:VCAP_CNT_DAT */
#define VCAP_SUPER_VCAP_CNT_DAT(r) __REG(TARGET_VCAP_SUPER,\
					0, 1, 8, 0, 1, 904, 768, r, 32, 4)

/*      VCAP_SUPER:VCAP_CORE_CACHE:VCAP_CNT_FW_DAT */
#define VCAP_SUPER_VCAP_CNT_FW_DAT __REG(TARGET_VCAP_SUPER,\
					0, 1, 8, 0, 1, 904, 896, 0, 1, 4)

/*      VCAP_SUPER:VCAP_CORE_CACHE:VCAP_TG_DAT */
#define VCAP_SUPER_VCAP_TG_DAT    __REG(TARGET_VCAP_SUPER,\
					0, 1, 8, 0, 1, 904, 900, 0, 1, 4)

/*      VCAP_SUPER:VCAP_CORE_MAP:VCAP_CORE_IDX */
#define VCAP_SUPER_IDX            __REG(TARGET_VCAP_SUPER,\
					0, 1, 912, 0, 1, 8, 0, 0, 1, 4)

#define VCAP_SUPER_IDX_CORE_IDX                  GENMASK(3, 0)
#define VCAP_SUPER_IDX_CORE_IDX_SET(x)\
	FIELD_PREP(VCAP_SUPER_IDX_CORE_IDX, x)
#define VCAP_SUPER_IDX_CORE_IDX_GET(x)\
	FIELD_GET(VCAP_SUPER_IDX_CORE_IDX, x)

/*      VCAP_SUPER:VCAP_CORE_MAP:VCAP_CORE_MAP */
#define VCAP_SUPER_MAP            __REG(TARGET_VCAP_SUPER,\
					0, 1, 912, 0, 1, 8, 4, 0, 1, 4)

#define VCAP_SUPER_MAP_CORE_MAP                  GENMASK(2, 0)
#define VCAP_SUPER_MAP_CORE_MAP_SET(x)\
	FIELD_PREP(VCAP_SUPER_MAP_CORE_MAP, x)
#define VCAP_SUPER_MAP_CORE_MAP_GET(x)\
	FIELD_GET(VCAP_SUPER_MAP_CORE_MAP, x)

/*      VCAP_SUPER:VCAP_CONST:VCAP_VER */
#define VCAP_SUPER_VCAP_VER       __REG(TARGET_VCAP_SUPER,\
					0, 1, 924, 0, 1, 40, 0, 0, 1, 4)

/*      VCAP_SUPER:VCAP_CONST:ENTRY_WIDTH */
#define VCAP_SUPER_ENTRY_WIDTH    __REG(TARGET_VCAP_SUPER,\
					0, 1, 924, 0, 1, 40, 4, 0, 1, 4)

/*      VCAP_SUPER:VCAP_CONST:ENTRY_CNT */
#define VCAP_SUPER_ENTRY_CNT      __REG(TARGET_VCAP_SUPER,\
					0, 1, 924, 0, 1, 40, 8, 0, 1, 4)

/*      VCAP_SUPER:VCAP_CONST:ENTRY_SWCNT */
#define VCAP_SUPER_ENTRY_SWCNT    __REG(TARGET_VCAP_SUPER,\
					0, 1, 924, 0, 1, 40, 12, 0, 1, 4)

/*      VCAP_SUPER:VCAP_CONST:ENTRY_TG_WIDTH */
#define VCAP_SUPER_ENTRY_TG_WIDTH __REG(TARGET_VCAP_SUPER,\
					0, 1, 924, 0, 1, 40, 16, 0, 1, 4)

/*      VCAP_SUPER:VCAP_CONST:ACTION_DEF_CNT */
#define VCAP_SUPER_ACTION_DEF_CNT __REG(TARGET_VCAP_SUPER,\
					0, 1, 924, 0, 1, 40, 20, 0, 1, 4)

/*      VCAP_SUPER:VCAP_CONST:ACTION_WIDTH */
#define VCAP_SUPER_ACTION_WIDTH   __REG(TARGET_VCAP_SUPER,\
					0, 1, 924, 0, 1, 40, 24, 0, 1, 4)

/*      VCAP_SUPER:VCAP_CONST:CNT_WIDTH */
#define VCAP_SUPER_CNT_WIDTH      __REG(TARGET_VCAP_SUPER,\
					0, 1, 924, 0, 1, 40, 28, 0, 1, 4)

/*      VCAP_SUPER:VCAP_CONST:CORE_CNT */
#define VCAP_SUPER_CORE_CNT       __REG(TARGET_VCAP_SUPER,\
					0, 1, 924, 0, 1, 40, 32, 0, 1, 4)

/*      VCAP_SUPER:VCAP_CONST:IF_CNT */
#define VCAP_SUPER_IF_CNT         __REG(TARGET_VCAP_SUPER,\
					0, 1, 924, 0, 1, 40, 36, 0, 1, 4)

/*      VCAP_SUPER:RAM_CTRL:RAM_INIT */
#define VCAP_SUPER_RAM_INIT       __REG(TARGET_VCAP_SUPER,\
					0, 1, 1120, 0, 1, 4, 0, 0, 1, 4)

#define VCAP_SUPER_RAM_INIT_RAM_INIT             BIT(1)
#define VCAP_SUPER_RAM_INIT_RAM_INIT_SET(x)\
	FIELD_PREP(VCAP_SUPER_RAM_INIT_RAM_INIT, x)
#define VCAP_SUPER_RAM_INIT_RAM_INIT_GET(x)\
	FIELD_GET(VCAP_SUPER_RAM_INIT_RAM_INIT, x)

#define VCAP_SUPER_RAM_INIT_RAM_CFG_HOOK         BIT(0)
#define VCAP_SUPER_RAM_INIT_RAM_CFG_HOOK_SET(x)\
	FIELD_PREP(VCAP_SUPER_RAM_INIT_RAM_CFG_HOOK, x)
#define VCAP_SUPER_RAM_INIT_RAM_CFG_HOOK_GET(x)\
	FIELD_GET(VCAP_SUPER_RAM_INIT_RAM_CFG_HOOK, x)

/*      VOP:RAM_CTRL:RAM_INIT */
#define VOP_RAM_INIT              __REG(TARGET_VOP,\
					0, 1, 279176, 0, 1, 4, 0, 0, 1, 4)

#define VOP_RAM_INIT_RAM_INIT                    BIT(1)
#define VOP_RAM_INIT_RAM_INIT_SET(x)\
	FIELD_PREP(VOP_RAM_INIT_RAM_INIT, x)
#define VOP_RAM_INIT_RAM_INIT_GET(x)\
	FIELD_GET(VOP_RAM_INIT_RAM_INIT, x)

#define VOP_RAM_INIT_RAM_CFG_HOOK                BIT(0)
#define VOP_RAM_INIT_RAM_CFG_HOOK_SET(x)\
	FIELD_PREP(VOP_RAM_INIT_RAM_CFG_HOOK, x)
#define VOP_RAM_INIT_RAM_CFG_HOOK_GET(x)\
	FIELD_GET(VOP_RAM_INIT_RAM_CFG_HOOK, x)

/*      XQS:SYSTEM:STAT_CFG */
#define XQS_STAT_CFG              __REG(TARGET_XQS,\
					0, 1, 6768, 0, 1, 872, 860, 0, 1, 4)

#define XQS_STAT_CFG_STAT_CLEAR_SHOT             GENMASK(21, 18)
#define XQS_STAT_CFG_STAT_CLEAR_SHOT_SET(x)\
	FIELD_PREP(XQS_STAT_CFG_STAT_CLEAR_SHOT, x)
#define XQS_STAT_CFG_STAT_CLEAR_SHOT_GET(x)\
	FIELD_GET(XQS_STAT_CFG_STAT_CLEAR_SHOT, x)

#define XQS_STAT_CFG_STAT_VIEW                   GENMASK(17, 5)
#define XQS_STAT_CFG_STAT_VIEW_SET(x)\
	FIELD_PREP(XQS_STAT_CFG_STAT_VIEW, x)
#define XQS_STAT_CFG_STAT_VIEW_GET(x)\
	FIELD_GET(XQS_STAT_CFG_STAT_VIEW, x)

#define XQS_STAT_CFG_STAT_SRV_PKT_ONLY           BIT(4)
#define XQS_STAT_CFG_STAT_SRV_PKT_ONLY_SET(x)\
	FIELD_PREP(XQS_STAT_CFG_STAT_SRV_PKT_ONLY, x)
#define XQS_STAT_CFG_STAT_SRV_PKT_ONLY_GET(x)\
	FIELD_GET(XQS_STAT_CFG_STAT_SRV_PKT_ONLY, x)

#define XQS_STAT_CFG_STAT_WRAP_DIS               GENMASK(3, 0)
#define XQS_STAT_CFG_STAT_WRAP_DIS_SET(x)\
	FIELD_PREP(XQS_STAT_CFG_STAT_WRAP_DIS, x)
#define XQS_STAT_CFG_STAT_WRAP_DIS_GET(x)\
	FIELD_GET(XQS_STAT_CFG_STAT_WRAP_DIS, x)

/*      XQS:QLIMIT_SHR:QLIMIT_SHR_TOP_CFG */
#define XQS_QLIMIT_SHR_TOP_CFG(g) __REG(TARGET_XQS,\
					0, 1, 7936, g, 4, 48, 0, 0, 1, 4)

#define XQS_QLIMIT_SHR_TOP_CFG_QLIMIT_SHR_TOP    GENMASK(14, 0)
#define XQS_QLIMIT_SHR_TOP_CFG_QLIMIT_SHR_TOP_SET(x)\
	FIELD_PREP(XQS_QLIMIT_SHR_TOP_CFG_QLIMIT_SHR_TOP, x)
#define XQS_QLIMIT_SHR_TOP_CFG_QLIMIT_SHR_TOP_GET(x)\
	FIELD_GET(XQS_QLIMIT_SHR_TOP_CFG_QLIMIT_SHR_TOP, x)

/*      XQS:QLIMIT_SHR:QLIMIT_SHR_ATOP_CFG */
#define XQS_QLIMIT_SHR_ATOP_CFG(g) __REG(TARGET_XQS,\
					0, 1, 7936, g, 4, 48, 4, 0, 1, 4)

#define XQS_QLIMIT_SHR_ATOP_CFG_QLIMIT_SHR_ATOP  GENMASK(14, 0)
#define XQS_QLIMIT_SHR_ATOP_CFG_QLIMIT_SHR_ATOP_SET(x)\
	FIELD_PREP(XQS_QLIMIT_SHR_ATOP_CFG_QLIMIT_SHR_ATOP, x)
#define XQS_QLIMIT_SHR_ATOP_CFG_QLIMIT_SHR_ATOP_GET(x)\
	FIELD_GET(XQS_QLIMIT_SHR_ATOP_CFG_QLIMIT_SHR_ATOP, x)

/*      XQS:QLIMIT_SHR:QLIMIT_SHR_CTOP_CFG */
#define XQS_QLIMIT_SHR_CTOP_CFG(g) __REG(TARGET_XQS,\
					0, 1, 7936, g, 4, 48, 8, 0, 1, 4)

#define XQS_QLIMIT_SHR_CTOP_CFG_QLIMIT_SHR_CTOP  GENMASK(14, 0)
#define XQS_QLIMIT_SHR_CTOP_CFG_QLIMIT_SHR_CTOP_SET(x)\
	FIELD_PREP(XQS_QLIMIT_SHR_CTOP_CFG_QLIMIT_SHR_CTOP, x)
#define XQS_QLIMIT_SHR_CTOP_CFG_QLIMIT_SHR_CTOP_GET(x)\
	FIELD_GET(XQS_QLIMIT_SHR_CTOP_CFG_QLIMIT_SHR_CTOP, x)

/*      XQS:QLIMIT_SHR:QLIMIT_SHR_QLIM_CFG */
#define XQS_QLIMIT_SHR_QLIM_CFG(g) __REG(TARGET_XQS,\
					0, 1, 7936, g, 4, 48, 12, 0, 1, 4)

#define XQS_QLIMIT_SHR_QLIM_CFG_QLIMIT_SHR_QLIM  GENMASK(14, 0)
#define XQS_QLIMIT_SHR_QLIM_CFG_QLIMIT_SHR_QLIM_SET(x)\
	FIELD_PREP(XQS_QLIMIT_SHR_QLIM_CFG_QLIMIT_SHR_QLIM, x)
#define XQS_QLIMIT_SHR_QLIM_CFG_QLIMIT_SHR_QLIM_GET(x)\
	FIELD_GET(XQS_QLIMIT_SHR_QLIM_CFG_QLIMIT_SHR_QLIM, x)

/*      XQS:STAT:CNT */
#define XQS_CNT(g)                __REG(TARGET_XQS,\
					0, 1, 0, g, 1024, 4, 0, 0, 1, 4)

#endif /* _SPARX5_MAIN_REGS_H_ */
