/********************************
 * adapted from font_sun12x22.c *
 * by Jurriaan Kalkman 06-2005  *
 ********************************/

#include <linux/font.h>

#define FONTDATAMAX 9216

static const struct font_data fontdata_10x18 = {
	{ 0, 0, FONTDATAMAX, 0 }, {
	/* 0 0x00 '^@' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 1 0x01 '^A' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x3f, 0x80, /* 0011111110 */
	0x40, 0x40, /* 0100000001 */
	0x5b, 0x40, /* 0101101101 */
	0x40, 0x40, /* 0100000001 */
	0x44, 0x40, /* 0100010001 */
	0x44, 0x40, /* 0100010001 */
	0x51, 0x40, /* 0101000101 */
	0x4e, 0x40, /* 0100111001 */
	0x40, 0x40, /* 0100000001 */
	0x3f, 0x80, /* 0011111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 2 0x02 '^B' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x3f, 0x80, /* 0011111110 */
	0x7f, 0xc0, /* 0111111111 */
	0x64, 0xc0, /* 0110010011 */
	0x7f, 0xc0, /* 0111111111 */
	0x7b, 0xc0, /* 0111101111 */
	0x7b, 0xc0, /* 0111101111 */
	0x6e, 0xc0, /* 0110111011 */
	0x71, 0xc0, /* 0111000111 */
	0x7f, 0xc0, /* 0111111111 */
	0x3f, 0x80, /* 0011111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 3 0x03 '^C' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x11, 0x00, /* 0001000100 */
	0x3b, 0x80, /* 0011101110 */
	0x7f, 0xc0, /* 0111111111 */
	0x3f, 0x80, /* 0011111110 */
	0x3f, 0x80, /* 0011111110 */
	0x1f, 0x00, /* 0001111100 */
	0x1f, 0x00, /* 0001111100 */
	0x0e, 0x00, /* 0000111000 */
	0x0e, 0x00, /* 0000111000 */
	0x04, 0x00, /* 0000010000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 4 0x04 '^D' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x04, 0x00, /* 0000010000 */
	0x0e, 0x00, /* 0000111000 */
	0x0e, 0x00, /* 0000111000 */
	0x1f, 0x00, /* 0001111100 */
	0x1f, 0x00, /* 0001111100 */
	0x3f, 0x80, /* 0011111110 */
	0x1f, 0x00, /* 0001111100 */
	0x1f, 0x00, /* 0001111100 */
	0x0e, 0x00, /* 0000111000 */
	0x0e, 0x00, /* 0000111000 */
	0x04, 0x00, /* 0000010000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 5 0x05 '^E' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x1e, 0x00, /* 0001111000 */
	0x0c, 0x00, /* 0000110000 */
	0x31, 0x80, /* 0011000110 */
	0x7b, 0xc0, /* 0111101111 */
	0x35, 0x80, /* 0011010110 */
	0x04, 0x00, /* 0000010000 */
	0x0e, 0x00, /* 0000111000 */
	0x1f, 0x00, /* 0001111100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 6 0x06 '^F' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x04, 0x00, /* 0000010000 */
	0x0e, 0x00, /* 0000111000 */
	0x1f, 0x00, /* 0001111100 */
	0x1f, 0x00, /* 0001111100 */
	0x3f, 0x80, /* 0011111110 */
	0x7f, 0xc0, /* 0111111111 */
	0x7f, 0xc0, /* 0111111111 */
	0x35, 0x80, /* 0011010110 */
	0x04, 0x00, /* 0000010000 */
	0x0e, 0x00, /* 0000111000 */
	0x1f, 0x00, /* 0001111100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 7 0x07 '^G' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x1e, 0x00, /* 0001111000 */
	0x1e, 0x00, /* 0001111000 */
	0x3f, 0x00, /* 0011111100 */
	0x3f, 0x00, /* 0011111100 */
	0x1e, 0x00, /* 0001111000 */
	0x1e, 0x00, /* 0001111000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 8 0x08 '^H' */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xf3, 0xc0, /* 1111001111 */
	0xe1, 0xc0, /* 1110000111 */
	0xe1, 0xc0, /* 1110000111 */
	0xc0, 0xc0, /* 1100000011 */
	0xc0, 0xc0, /* 1100000011 */
	0xe1, 0xc0, /* 1110000111 */
	0xe1, 0xc0, /* 1110000111 */
	0xf3, 0xc0, /* 1111001111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */

	/* 9 0x09 '^I' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x12, 0x00, /* 0001001000 */
	0x12, 0x00, /* 0001001000 */
	0x21, 0x00, /* 0010000100 */
	0x21, 0x00, /* 0010000100 */
	0x12, 0x00, /* 0001001000 */
	0x12, 0x00, /* 0001001000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 10 0x0a '^J' */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xf3, 0xc0, /* 1111001111 */
	0xed, 0xc0, /* 1110110111 */
	0xed, 0xc0, /* 1110110111 */
	0xde, 0xc0, /* 1101111011 */
	0xde, 0xc0, /* 1101111011 */
	0xed, 0xc0, /* 1110110111 */
	0xed, 0xc0, /* 1110110111 */
	0xf3, 0xc0, /* 1111001111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */

	/* 11 0x0b '^K' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0f, 0xc0, /* 0000111111 */
	0x0f, 0xc0, /* 0000111111 */
	0x03, 0xc0, /* 0000001111 */
	0x06, 0xc0, /* 0000011011 */
	0x0c, 0xc0, /* 0000110011 */
	0x3c, 0x00, /* 0011110000 */
	0x66, 0x00, /* 0110011000 */
	0xc3, 0x00, /* 1100001100 */
	0xc3, 0x00, /* 1100001100 */
	0xc3, 0x00, /* 1100001100 */
	0x66, 0x00, /* 0110011000 */
	0x3c, 0x00, /* 0011110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 12 0x0c '^L' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x1e, 0x00, /* 0001111000 */
	0x33, 0x00, /* 0011001100 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x33, 0x00, /* 0011001100 */
	0x1e, 0x00, /* 0001111000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x3f, 0x00, /* 0011111100 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 13 0x0d '^M' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0f, 0x80, /* 0000111110 */
	0x08, 0x80, /* 0000100010 */
	0x0f, 0x80, /* 0000111110 */
	0x08, 0x00, /* 0000100000 */
	0x08, 0x00, /* 0000100000 */
	0x08, 0x00, /* 0000100000 */
	0x08, 0x00, /* 0000100000 */
	0x08, 0x00, /* 0000100000 */
	0x08, 0x00, /* 0000100000 */
	0x38, 0x00, /* 0011100000 */
	0x78, 0x00, /* 0111100000 */
	0x30, 0x00, /* 0011000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 14 0x0e '^N' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x1f, 0x80, /* 0001111110 */
	0x10, 0x80, /* 0001000010 */
	0x1f, 0x80, /* 0001111110 */
	0x10, 0x80, /* 0001000010 */
	0x10, 0x80, /* 0001000010 */
	0x10, 0x80, /* 0001000010 */
	0x10, 0x80, /* 0001000010 */
	0x13, 0x80, /* 0001001110 */
	0x17, 0x80, /* 0001011110 */
	0x73, 0x00, /* 0111001100 */
	0xf0, 0x00, /* 1111000000 */
	0x60, 0x00, /* 0110000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 15 0x0f '^O' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x04, 0x00, /* 0000010000 */
	0x24, 0x80, /* 0010010010 */
	0x15, 0x00, /* 0001010100 */
	0x55, 0x40, /* 0101010101 */
	0x3f, 0x80, /* 0011111110 */
	0x0e, 0x00, /* 0000111000 */
	0x00, 0x00, /* 0000000000 */
	0x0e, 0x00, /* 0000111000 */
	0x3f, 0x80, /* 0011111110 */
	0x55, 0x40, /* 0101010101 */
	0x15, 0x00, /* 0001010100 */
	0x24, 0x80, /* 0010010010 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 16 0x10 '^P' */
	0x00, 0x80, /* 0000000010 */
	0x01, 0x80, /* 0000000110 */
	0x03, 0x80, /* 0000001110 */
	0x07, 0x80, /* 0000011110 */
	0x0f, 0x80, /* 0000111110 */
	0x1f, 0x80, /* 0001111110 */
	0x3f, 0x80, /* 0011111110 */
	0x7f, 0x80, /* 0111111110 */
	0xff, 0x80, /* 1111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x3f, 0x80, /* 0011111110 */
	0x1f, 0x80, /* 0001111110 */
	0x0f, 0x80, /* 0000111110 */
	0x07, 0x80, /* 0000011110 */
	0x03, 0x80, /* 0000001110 */
	0x01, 0x80, /* 0000000110 */
	0x00, 0x80, /* 0000000010 */
	0x00, 0x00, /* 0000000000 */

	/* 17 0x11 '^Q' */
	0x40, 0x00, /* 0100000000 */
	0x60, 0x00, /* 0110000000 */
	0x70, 0x00, /* 0111000000 */
	0x78, 0x00, /* 0111100000 */
	0x7c, 0x00, /* 0111110000 */
	0x7e, 0x00, /* 0111111000 */
	0x7f, 0x00, /* 0111111100 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0xc0, /* 0111111111 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x00, /* 0111111100 */
	0x7e, 0x00, /* 0111111000 */
	0x7c, 0x00, /* 0111110000 */
	0x78, 0x00, /* 0111100000 */
	0x70, 0x00, /* 0111000000 */
	0x60, 0x00, /* 0110000000 */
	0x40, 0x00, /* 0100000000 */
	0x00, 0x00, /* 0000000000 */

	/* 18 0x12 '^R' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x1e, 0x00, /* 0001111000 */
	0x3f, 0x00, /* 0011111100 */
	0x7f, 0x80, /* 0111111110 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x7f, 0x80, /* 0111111110 */
	0x3f, 0x00, /* 0011111100 */
	0x1e, 0x00, /* 0001111000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 19 0x13 '^S' */
	0x00, 0x00, /* 0000000000 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 20 0x14 '^T' */
	0x00, 0x00, /* 0000000000 */
	0x1f, 0xc0, /* 0001111111 */
	0x39, 0x80, /* 0011100110 */
	0x79, 0x80, /* 0111100110 */
	0x79, 0x80, /* 0111100110 */
	0x79, 0x80, /* 0111100110 */
	0x39, 0x80, /* 0011100110 */
	0x19, 0x80, /* 0001100110 */
	0x19, 0x80, /* 0001100110 */
	0x19, 0x80, /* 0001100110 */
	0x19, 0x80, /* 0001100110 */
	0x19, 0x80, /* 0001100110 */
	0x19, 0x80, /* 0001100110 */
	0x39, 0xc0, /* 0011100111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 21 0x15 '^U' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x3e, 0x00, /* 0011111000 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x3e, 0x00, /* 0011111000 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x3e, 0x00, /* 0011111000 */
	0x03, 0x00, /* 0000001100 */
	0x03, 0x00, /* 0000001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x3e, 0x00, /* 0011111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 22 0x16 '^V' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 23 0x17 '^W' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x1e, 0x00, /* 0001111000 */
	0x3f, 0x00, /* 0011111100 */
	0x7f, 0x80, /* 0111111110 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x7f, 0x80, /* 0111111110 */
	0x3f, 0x00, /* 0011111100 */
	0x1e, 0x00, /* 0001111000 */
	0x0c, 0x00, /* 0000110000 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 24 0x18 '^X' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x1e, 0x00, /* 0001111000 */
	0x3f, 0x00, /* 0011111100 */
	0x7f, 0x80, /* 0111111110 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 25 0x19 '^Y' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x7f, 0x80, /* 0111111110 */
	0x3f, 0x00, /* 0011111100 */
	0x1e, 0x00, /* 0001111000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 26 0x1a '^Z' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x04, 0x00, /* 0000010000 */
	0x06, 0x00, /* 0000011000 */
	0x07, 0x00, /* 0000011100 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x07, 0x00, /* 0000011100 */
	0x06, 0x00, /* 0000011000 */
	0x04, 0x00, /* 0000010000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 27 0x1b '^[' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x08, 0x00, /* 0000100000 */
	0x18, 0x00, /* 0001100000 */
	0x38, 0x00, /* 0011100000 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x38, 0x00, /* 0011100000 */
	0x18, 0x00, /* 0001100000 */
	0x08, 0x00, /* 0000100000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 28 0x1c '^\' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 29 0x1d '^]' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x12, 0x00, /* 0001001000 */
	0x33, 0x00, /* 0011001100 */
	0x73, 0x80, /* 0111001110 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0x73, 0x80, /* 0111001110 */
	0x33, 0x00, /* 0011001100 */
	0x12, 0x00, /* 0001001000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 30 0x1e '^^' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x04, 0x00, /* 0000010000 */
	0x04, 0x00, /* 0000010000 */
	0x0e, 0x00, /* 0000111000 */
	0x0e, 0x00, /* 0000111000 */
	0x1f, 0x00, /* 0001111100 */
	0x1f, 0x00, /* 0001111100 */
	0x3f, 0x80, /* 0011111110 */
	0x3f, 0x80, /* 0011111110 */
	0x7f, 0xc0, /* 0111111111 */
	0x7f, 0xc0, /* 0111111111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 31 0x1f '^_' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x7f, 0xc0, /* 0111111111 */
	0x7f, 0xc0, /* 0111111111 */
	0x3f, 0x80, /* 0011111110 */
	0x3f, 0x80, /* 0011111110 */
	0x1f, 0x00, /* 0001111100 */
	0x1f, 0x00, /* 0001111100 */
	0x0e, 0x00, /* 0000111000 */
	0x0e, 0x00, /* 0000111000 */
	0x04, 0x00, /* 0000010000 */
	0x04, 0x00, /* 0000010000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 32 0x20 ' ' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 33 0x21 '!' */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 34 0x22 '"' */
	0x00, 0x00, /* 0000000000 */
	0x63, 0x00, /* 0110001100 */
	0xf7, 0x80, /* 1111011110 */
	0xf7, 0x80, /* 1111011110 */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x63, 0x00, /* 0110001100 */
	0x42, 0x00, /* 0100001000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 35 0x23 '#' */
	0x00, 0x00, /* 0000000000 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 36 0x24 '$' */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x3e, 0x00, /* 0011111000 */
	0x3f, 0x00, /* 0011111100 */
	0x6f, 0x80, /* 0110111110 */
	0x6d, 0x80, /* 0110110110 */
	0x6c, 0x80, /* 0110110010 */
	0x3c, 0x00, /* 0011110000 */
	0x0f, 0x00, /* 0000111100 */
	0x0d, 0x80, /* 0000110110 */
	0x4d, 0x80, /* 0100110110 */
	0x6d, 0x80, /* 0110110110 */
	0x7f, 0x00, /* 0111111100 */
	0x3e, 0x00, /* 0011111000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 37 0x25 '%' */
	0x00, 0x00, /* 0000000000 */
	0x31, 0x80, /* 0011000110 */
	0x7b, 0x00, /* 0111101100 */
	0x7b, 0x00, /* 0111101100 */
	0x36, 0x00, /* 0011011000 */
	0x06, 0x00, /* 0000011000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x18, 0x00, /* 0001100000 */
	0x1b, 0x00, /* 0001101100 */
	0x37, 0x80, /* 0011011110 */
	0x37, 0x80, /* 0011011110 */
	0x63, 0x00, /* 0110001100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 38 0x26 '&' */
	0x00, 0x00, /* 0000000000 */
	0x07, 0x00, /* 0000011100 */
	0x0f, 0x80, /* 0000111110 */
	0x19, 0x80, /* 0001100110 */
	0x19, 0x80, /* 0001100110 */
	0x0f, 0x80, /* 0000111110 */
	0x1e, 0x00, /* 0001111000 */
	0x3e, 0x00, /* 0011111000 */
	0x76, 0x00, /* 0111011000 */
	0x66, 0x40, /* 0110011001 */
	0x63, 0xc0, /* 0110001111 */
	0x63, 0x80, /* 0110001110 */
	0x63, 0x00, /* 0110001100 */
	0x3f, 0x80, /* 0011111110 */
	0x1c, 0xc0, /* 0001110011 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 39 0x27 ''' */
	0x00, 0x00, /* 0000000000 */
	0x30, 0x00, /* 0011000000 */
	0x78, 0x00, /* 0111100000 */
	0x78, 0x00, /* 0111100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x30, 0x00, /* 0011000000 */
	0x20, 0x00, /* 0010000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 40 0x28 '(' */
	0x00, 0x00, /* 0000000000 */
	0x03, 0x00, /* 0000001100 */
	0x06, 0x00, /* 0000011000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x06, 0x00, /* 0000011000 */
	0x03, 0x00, /* 0000001100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 41 0x29 ')' */
	0x00, 0x00, /* 0000000000 */
	0x30, 0x00, /* 0011000000 */
	0x18, 0x00, /* 0001100000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x18, 0x00, /* 0001100000 */
	0x30, 0x00, /* 0011000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 42 0x2a '*' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x4c, 0x80, /* 0100110010 */
	0x6d, 0x80, /* 0110110110 */
	0x3f, 0x00, /* 0011111100 */
	0x7f, 0x80, /* 0111111110 */
	0x3f, 0x00, /* 0011111100 */
	0x6d, 0x80, /* 0110110110 */
	0x4c, 0x80, /* 0100110010 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 43 0x2b '+' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 44 0x2c ',' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x30, 0x00, /* 0011000000 */
	0x78, 0x00, /* 0111100000 */
	0x78, 0x00, /* 0111100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x30, 0x00, /* 0011000000 */
	0x60, 0x00, /* 0110000000 */
	0x40, 0x00, /* 0100000000 */

	/* 45 0x2d '-' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 46 0x2e '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x18, 0x00, /* 0001100000 */
	0x3c, 0x00, /* 0011110000 */
	0x3c, 0x00, /* 0011110000 */
	0x18, 0x00, /* 0001100000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 47 0x2f '/' */
	0x00, 0x00, /* 0000000000 */
	0x01, 0x80, /* 0000000110 */
	0x01, 0x80, /* 0000000110 */
	0x03, 0x00, /* 0000001100 */
	0x03, 0x00, /* 0000001100 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 48 0x30 '0' */
	0x00, 0x00, /* 0000000000 */
	0x0e, 0x00, /* 0000111000 */
	0x1f, 0x00, /* 0001111100 */
	0x23, 0x00, /* 0010001100 */
	0x61, 0x80, /* 0110000110 */
	0x63, 0x80, /* 0110001110 */
	0x65, 0x80, /* 0110010110 */
	0x65, 0x80, /* 0110010110 */
	0x69, 0x80, /* 0110100110 */
	0x69, 0x80, /* 0110100110 */
	0x71, 0x80, /* 0111000110 */
	0x61, 0x00, /* 0110000100 */
	0x31, 0x00, /* 0011000100 */
	0x3e, 0x00, /* 0011111000 */
	0x1c, 0x00, /* 0001110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 49 0x31 '1' */
	0x00, 0x00, /* 0000000000 */
	0x04, 0x00, /* 0000010000 */
	0x0c, 0x00, /* 0000110000 */
	0x1c, 0x00, /* 0001110000 */
	0x3c, 0x00, /* 0011110000 */
	0x6c, 0x00, /* 0110110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x7f, 0x80, /* 0111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 50 0x32 '2' */
	0x00, 0x00, /* 0000000000 */
	0x1e, 0x00, /* 0001111000 */
	0x3f, 0x00, /* 0011111100 */
	0x63, 0x80, /* 0110001110 */
	0x41, 0x80, /* 0100000110 */
	0x01, 0x80, /* 0000000110 */
	0x01, 0x80, /* 0000000110 */
	0x03, 0x00, /* 0000001100 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x0c, 0x00, /* 0000110000 */
	0x18, 0x00, /* 0001100000 */
	0x30, 0x80, /* 0011000010 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 51 0x33 '3' */
	0x00, 0x00, /* 0000000000 */
	0x1c, 0x00, /* 0001110000 */
	0x3e, 0x00, /* 0011111000 */
	0x47, 0x00, /* 0100011100 */
	0x03, 0x00, /* 0000001100 */
	0x07, 0x00, /* 0000011100 */
	0x06, 0x00, /* 0000011000 */
	0x0e, 0x00, /* 0000111000 */
	0x07, 0x00, /* 0000011100 */
	0x03, 0x00, /* 0000001100 */
	0x01, 0x80, /* 0000000110 */
	0x41, 0x80, /* 0100000110 */
	0x61, 0x80, /* 0110000110 */
	0x3f, 0x00, /* 0011111100 */
	0x1e, 0x00, /* 0001111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 52 0x34 '4' */
	0x00, 0x00, /* 0000000000 */
	0x06, 0x00, /* 0000011000 */
	0x0e, 0x00, /* 0000111000 */
	0x1e, 0x00, /* 0001111000 */
	0x36, 0x00, /* 0011011000 */
	0x36, 0x00, /* 0011011000 */
	0x66, 0x00, /* 0110011000 */
	0x66, 0x00, /* 0110011000 */
	0xc6, 0x00, /* 1100011000 */
	0xc6, 0x00, /* 1100011000 */
	0xff, 0x80, /* 1111111110 */
	0xff, 0x80, /* 1111111110 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 53 0x35 '5' */
	0x00, 0x00, /* 0000000000 */
	0x1f, 0x00, /* 0001111100 */
	0x1f, 0x00, /* 0001111100 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x60, 0x00, /* 0110000000 */
	0x7e, 0x00, /* 0111111000 */
	0x67, 0x00, /* 0110011100 */
	0x03, 0x80, /* 0000001110 */
	0x01, 0x80, /* 0000000110 */
	0x01, 0x80, /* 0000000110 */
	0x01, 0x80, /* 0000000110 */
	0x41, 0x80, /* 0100000110 */
	0x63, 0x00, /* 0110001100 */
	0x3e, 0x00, /* 0011111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 54 0x36 '6' */
	0x00, 0x00, /* 0000000000 */
	0x06, 0x00, /* 0000011000 */
	0x0c, 0x00, /* 0000110000 */
	0x18, 0x00, /* 0001100000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x60, 0x00, /* 0110000000 */
	0x6e, 0x00, /* 0110111000 */
	0x7f, 0x00, /* 0111111100 */
	0x73, 0x80, /* 0111001110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x71, 0x00, /* 0111000100 */
	0x3e, 0x00, /* 0011111000 */
	0x1c, 0x00, /* 0001110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 55 0x37 '7' */
	0x00, 0x00, /* 0000000000 */
	0x1f, 0x80, /* 0001111110 */
	0x3f, 0x80, /* 0011111110 */
	0x61, 0x80, /* 0110000110 */
	0x01, 0x80, /* 0000000110 */
	0x03, 0x00, /* 0000001100 */
	0x03, 0x00, /* 0000001100 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 56 0x38 '8' */
	0x00, 0x00, /* 0000000000 */
	0x1e, 0x00, /* 0001111000 */
	0x23, 0x00, /* 0010001100 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x31, 0x00, /* 0011000100 */
	0x1a, 0x00, /* 0001101000 */
	0x0c, 0x00, /* 0000110000 */
	0x16, 0x00, /* 0001011000 */
	0x23, 0x00, /* 0010001100 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x31, 0x00, /* 0011000100 */
	0x1e, 0x00, /* 0001111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 57 0x39 '9' */
	0x00, 0x00, /* 0000000000 */
	0x0e, 0x00, /* 0000111000 */
	0x17, 0x00, /* 0001011100 */
	0x23, 0x80, /* 0010001110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x73, 0x80, /* 0111001110 */
	0x3d, 0x80, /* 0011110110 */
	0x19, 0x80, /* 0001100110 */
	0x01, 0x80, /* 0000000110 */
	0x03, 0x00, /* 0000001100 */
	0x03, 0x00, /* 0000001100 */
	0x06, 0x00, /* 0000011000 */
	0x0c, 0x00, /* 0000110000 */
	0x18, 0x00, /* 0001100000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 58 0x3a ':' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x18, 0x00, /* 0001100000 */
	0x3c, 0x00, /* 0011110000 */
	0x3c, 0x00, /* 0011110000 */
	0x18, 0x00, /* 0001100000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x18, 0x00, /* 0001100000 */
	0x3c, 0x00, /* 0011110000 */
	0x3c, 0x00, /* 0011110000 */
	0x18, 0x00, /* 0001100000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 59 0x3b ';' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x18, 0x00, /* 0001100000 */
	0x3c, 0x00, /* 0011110000 */
	0x3c, 0x00, /* 0011110000 */
	0x18, 0x00, /* 0001100000 */
	0x00, 0x00, /* 0000000000 */
	0x18, 0x00, /* 0001100000 */
	0x3c, 0x00, /* 0011110000 */
	0x3c, 0x00, /* 0011110000 */
	0x0c, 0x00, /* 0000110000 */
	0x18, 0x00, /* 0001100000 */
	0x30, 0x00, /* 0011000000 */
	0x20, 0x00, /* 0010000000 */

	/* 60 0x3c '<' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x03, 0x00, /* 0000001100 */
	0x06, 0x00, /* 0000011000 */
	0x0c, 0x00, /* 0000110000 */
	0x18, 0x00, /* 0001100000 */
	0x30, 0x00, /* 0011000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x30, 0x00, /* 0011000000 */
	0x18, 0x00, /* 0001100000 */
	0x0c, 0x00, /* 0000110000 */
	0x06, 0x00, /* 0000011000 */
	0x03, 0x00, /* 0000001100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 61 0x3d '=' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 62 0x3e '>' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x30, 0x00, /* 0011000000 */
	0x18, 0x00, /* 0001100000 */
	0x0c, 0x00, /* 0000110000 */
	0x06, 0x00, /* 0000011000 */
	0x03, 0x00, /* 0000001100 */
	0x01, 0x80, /* 0000000110 */
	0x01, 0x80, /* 0000000110 */
	0x03, 0x00, /* 0000001100 */
	0x06, 0x00, /* 0000011000 */
	0x0c, 0x00, /* 0000110000 */
	0x18, 0x00, /* 0001100000 */
	0x30, 0x00, /* 0011000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 63 0x3f '?' */
	0x00, 0x00, /* 0000000000 */
	0x0e, 0x00, /* 0000111000 */
	0x1f, 0x00, /* 0001111100 */
	0x3b, 0x80, /* 0011101110 */
	0x21, 0x80, /* 0010000110 */
	0x01, 0x80, /* 0000000110 */
	0x03, 0x00, /* 0000001100 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 64 0x40 '@' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0e, 0x00, /* 0000111000 */
	0x3f, 0x00, /* 0011111100 */
	0x31, 0x80, /* 0011000110 */
	0x65, 0x80, /* 0110010110 */
	0x6d, 0x80, /* 0110110110 */
	0x6d, 0x80, /* 0110110110 */
	0x6d, 0x80, /* 0110110110 */
	0x6d, 0x80, /* 0110110110 */
	0x6f, 0x80, /* 0110111110 */
	0x60, 0x00, /* 0110000000 */
	0x31, 0x80, /* 0011000110 */
	0x3f, 0x80, /* 0011111110 */
	0x0f, 0x00, /* 0000111100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 65 0x41 'A' */
	0x00, 0x00, /* 0000000000 */
	0x04, 0x00, /* 0000010000 */
	0x04, 0x00, /* 0000010000 */
	0x0e, 0x00, /* 0000111000 */
	0x0e, 0x00, /* 0000111000 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x19, 0x80, /* 0001100110 */
	0x31, 0x80, /* 0011000110 */
	0x3f, 0x80, /* 0011111110 */
	0x31, 0x80, /* 0011000110 */
	0x61, 0x80, /* 0110000110 */
	0x60, 0xc0, /* 0110000011 */
	0x60, 0xc0, /* 0110000011 */
	0xf1, 0xc0, /* 1111000111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 66 0x42 'B' */
	0x00, 0x00, /* 0000000000 */
	0xfc, 0x00, /* 1111110000 */
	0x62, 0x00, /* 0110001000 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x66, 0x00, /* 0110011000 */
	0x7e, 0x00, /* 0111111000 */
	0x63, 0x00, /* 0110001100 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x63, 0x00, /* 0110001100 */
	0xfe, 0x00, /* 1111111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 67 0x43 'C' */
	0x00, 0x00, /* 0000000000 */
	0x0f, 0x00, /* 0000111100 */
	0x11, 0x80, /* 0001000110 */
	0x20, 0x80, /* 0010000010 */
	0x20, 0x00, /* 0010000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x20, 0x00, /* 0010000000 */
	0x30, 0x80, /* 0011000010 */
	0x19, 0x00, /* 0001100100 */
	0x0e, 0x00, /* 0000111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 68 0x44 'D' */
	0x00, 0x00, /* 0000000000 */
	0xfc, 0x00, /* 1111110000 */
	0x67, 0x00, /* 0110011100 */
	0x63, 0x00, /* 0110001100 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x00, /* 0110000100 */
	0x66, 0x00, /* 0110011000 */
	0xf8, 0x00, /* 1111100000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 69 0x45 'E' */
	0x00, 0x00, /* 0000000000 */
	0x7f, 0x80, /* 0111111110 */
	0x30, 0x80, /* 0011000010 */
	0x30, 0x80, /* 0011000010 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x31, 0x00, /* 0011000100 */
	0x3f, 0x00, /* 0011111100 */
	0x31, 0x00, /* 0011000100 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x80, /* 0011000010 */
	0x30, 0x80, /* 0011000010 */
	0x7f, 0x80, /* 0111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 70 0x46 'F' */
	0x00, 0x00, /* 0000000000 */
	0x7f, 0x80, /* 0111111110 */
	0x30, 0x80, /* 0011000010 */
	0x30, 0x80, /* 0011000010 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x31, 0x00, /* 0011000100 */
	0x3f, 0x00, /* 0011111100 */
	0x31, 0x00, /* 0011000100 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x78, 0x00, /* 0111100000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 71 0x47 'G' */
	0x00, 0x00, /* 0000000000 */
	0x0f, 0x00, /* 0000111100 */
	0x11, 0x80, /* 0001000110 */
	0x20, 0x80, /* 0010000010 */
	0x20, 0x00, /* 0010000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x67, 0xc0, /* 0110011111 */
	0x61, 0x80, /* 0110000110 */
	0x21, 0x80, /* 0010000110 */
	0x31, 0x80, /* 0011000110 */
	0x19, 0x80, /* 0001100110 */
	0x0e, 0x00, /* 0000111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 72 0x48 'H' */
	0x00, 0x00, /* 0000000000 */
	0xf3, 0xc0, /* 1111001111 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x7f, 0x80, /* 0111111110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0xf3, 0xc0, /* 1111001111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 73 0x49 'I' */
	0x00, 0x00, /* 0000000000 */
	0x3f, 0x00, /* 0011111100 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x3f, 0x00, /* 0011111100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 74 0x4a 'J' */
	0x00, 0x00, /* 0000000000 */
	0x3f, 0x00, /* 0011111100 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x08, 0x00, /* 0000100000 */
	0x70, 0x00, /* 0111000000 */
	0x60, 0x00, /* 0110000000 */
	0x00, 0x00, /* 0000000000 */

	/* 75 0x4b 'K' */
	0x00, 0x00, /* 0000000000 */
	0xf1, 0x80, /* 1111000110 */
	0x63, 0x00, /* 0110001100 */
	0x66, 0x00, /* 0110011000 */
	0x6c, 0x00, /* 0110110000 */
	0x78, 0x00, /* 0111100000 */
	0x70, 0x00, /* 0111000000 */
	0x70, 0x00, /* 0111000000 */
	0x78, 0x00, /* 0111100000 */
	0x78, 0x00, /* 0111100000 */
	0x6c, 0x00, /* 0110110000 */
	0x66, 0x00, /* 0110011000 */
	0x63, 0x00, /* 0110001100 */
	0x61, 0x80, /* 0110000110 */
	0xf0, 0xc0, /* 1111000011 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 76 0x4c 'L' */
	0x00, 0x00, /* 0000000000 */
	0x78, 0x00, /* 0111100000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x80, /* 0011000010 */
	0x30, 0x80, /* 0011000010 */
	0x7f, 0x80, /* 0111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 77 0x4d 'M' */
	0x00, 0x00, /* 0000000000 */
	0xe0, 0xc0, /* 1110000011 */
	0x61, 0x80, /* 0110000110 */
	0x73, 0x80, /* 0111001110 */
	0x73, 0x80, /* 0111001110 */
	0x6d, 0x80, /* 0110110110 */
	0x6d, 0x80, /* 0110110110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0xf3, 0xc0, /* 1111001111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 78 0x4e 'N' */
	0x00, 0x00, /* 0000000000 */
	0xf3, 0xc0, /* 1111001111 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x71, 0x80, /* 0111000110 */
	0x79, 0x80, /* 0111100110 */
	0x79, 0x80, /* 0111100110 */
	0x6d, 0x80, /* 0110110110 */
	0x6d, 0x80, /* 0110110110 */
	0x67, 0x80, /* 0110011110 */
	0x67, 0x80, /* 0110011110 */
	0x63, 0x80, /* 0110001110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0xf3, 0xc0, /* 1111001111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 79 0x4f 'O' */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x17, 0x00, /* 0001011100 */
	0x23, 0x00, /* 0010001100 */
	0x21, 0x80, /* 0010000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x21, 0x00, /* 0010000100 */
	0x31, 0x00, /* 0011000100 */
	0x1a, 0x00, /* 0001101000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 80 0x50 'P' */
	0x00, 0x00, /* 0000000000 */
	0xfe, 0x00, /* 1111111000 */
	0x63, 0x00, /* 0110001100 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x63, 0x00, /* 0110001100 */
	0x7e, 0x00, /* 0111111000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0xf0, 0x00, /* 1111000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 81 0x51 'Q' */
	0x00, 0x00, /* 0000000000 */
	0x0e, 0x00, /* 0000111000 */
	0x13, 0x00, /* 0001001100 */
	0x23, 0x00, /* 0010001100 */
	0x21, 0x80, /* 0010000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x31, 0x80, /* 0011000110 */
	0x3b, 0x00, /* 0011101100 */
	0x1e, 0x00, /* 0001111000 */
	0x0c, 0x00, /* 0000110000 */
	0x1e, 0x00, /* 0001111000 */
	0x26, 0x00, /* 0010011000 */
	0x03, 0x80, /* 0000001110 */
	0x00, 0x00, /* 0000000000 */

	/* 82 0x52 'R' */
	0x00, 0x00, /* 0000000000 */
	0xfe, 0x00, /* 1111111000 */
	0x63, 0x00, /* 0110001100 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x00, /* 0110000100 */
	0x7e, 0x00, /* 0111111000 */
	0x78, 0x00, /* 0111100000 */
	0x6c, 0x00, /* 0110110000 */
	0x6e, 0x00, /* 0110111000 */
	0x67, 0x00, /* 0110011100 */
	0x63, 0x80, /* 0110001110 */
	0x61, 0xc0, /* 0110000111 */
	0xf0, 0xc0, /* 1111000011 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 83 0x53 'S' */
	0x00, 0x00, /* 0000000000 */
	0x1f, 0x00, /* 0001111100 */
	0x31, 0x80, /* 0011000110 */
	0x60, 0x80, /* 0110000010 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x30, 0x00, /* 0011000000 */
	0x18, 0x00, /* 0001100000 */
	0x0c, 0x00, /* 0000110000 */
	0x06, 0x00, /* 0000011000 */
	0x03, 0x00, /* 0000001100 */
	0x01, 0x80, /* 0000000110 */
	0x41, 0x80, /* 0100000110 */
	0x63, 0x00, /* 0110001100 */
	0x3e, 0x00, /* 0011111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 84 0x54 'T' */
	0x00, 0x00, /* 0000000000 */
	0x7f, 0x80, /* 0111111110 */
	0x4c, 0x80, /* 0100110010 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x3f, 0x00, /* 0011111100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 85 0x55 'U' */
	0x00, 0x00, /* 0000000000 */
	0xf3, 0xc0, /* 1111001111 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x73, 0x00, /* 0111001100 */
	0x3f, 0x00, /* 0011111100 */
	0x1e, 0x00, /* 0001111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 86 0x56 'V' */
	0x00, 0x00, /* 0000000000 */
	0xe1, 0xc0, /* 1110000111 */
	0xc0, 0xc0, /* 1100000011 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x12, 0x00, /* 0001001000 */
	0x1e, 0x00, /* 0001111000 */
	0x1e, 0x00, /* 0001111000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 87 0x57 'W' */
	0x00, 0x00, /* 0000000000 */
	0xe1, 0xc0, /* 1110000111 */
	0xc0, 0xc0, /* 1100000011 */
	0xc0, 0xc0, /* 1100000011 */
	0xc0, 0xc0, /* 1100000011 */
	0xe0, 0xc0, /* 1110000011 */
	0x61, 0x80, /* 0110000110 */
	0x6d, 0x80, /* 0110110110 */
	0x6d, 0x80, /* 0110110110 */
	0x7f, 0x80, /* 0111111110 */
	0x77, 0x00, /* 0111011100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 88 0x58 'X' */
	0x00, 0x00, /* 0000000000 */
	0xf7, 0x80, /* 1111011110 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x36, 0x00, /* 0011011000 */
	0x36, 0x00, /* 0011011000 */
	0x36, 0x00, /* 0011011000 */
	0x1c, 0x00, /* 0001110000 */
	0x1c, 0x00, /* 0001110000 */
	0x36, 0x00, /* 0011011000 */
	0x36, 0x00, /* 0011011000 */
	0x36, 0x00, /* 0011011000 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0xf7, 0x80, /* 1111011110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 89 0x59 'Y' */
	0x00, 0x00, /* 0000000000 */
	0xf3, 0xc0, /* 1111001111 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x1e, 0x00, /* 0001111000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x1e, 0x00, /* 0001111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 90 0x5a 'Z' */
	0x00, 0x00, /* 0000000000 */
	0x3f, 0x80, /* 0011111110 */
	0x21, 0x80, /* 0010000110 */
	0x01, 0x80, /* 0000000110 */
	0x03, 0x00, /* 0000001100 */
	0x03, 0x00, /* 0000001100 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x80, /* 0011000010 */
	0x3f, 0x80, /* 0011111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 91 0x5b '[' */
	0x00, 0x00, /* 0000000000 */
	0x1f, 0x00, /* 0001111100 */
	0x1f, 0x00, /* 0001111100 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x1f, 0x00, /* 0001111100 */
	0x1f, 0x00, /* 0001111100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 92 0x5c '\' */
	0x00, 0x00, /* 0000000000 */
	0xc0, 0x00, /* 1100000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x03, 0x00, /* 0000001100 */
	0x03, 0x00, /* 0000001100 */
	0x01, 0x80, /* 0000000110 */
	0x01, 0x80, /* 0000000110 */
	0x00, 0xc0, /* 0000000011 */
	0x00, 0x00, /* 0000000000 */

	/* 93 0x5d ']' */
	0x00, 0x00, /* 0000000000 */
	0x3e, 0x00, /* 0011111000 */
	0x3e, 0x00, /* 0011111000 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x3e, 0x00, /* 0011111000 */
	0x3e, 0x00, /* 0011111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 94 0x5e '^' */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x1e, 0x00, /* 0001111000 */
	0x33, 0x00, /* 0011001100 */
	0x61, 0x80, /* 0110000110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 95 0x5f '_' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0x00, 0x00, /* 0000000000 */

	/* 96 0x60 '`' */
	0x04, 0x00, /* 0000010000 */
	0x0c, 0x00, /* 0000110000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x1e, 0x00, /* 0001111000 */
	0x1e, 0x00, /* 0001111000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 97 0x61 'a' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x1f, 0x00, /* 0001111100 */
	0x31, 0x80, /* 0011000110 */
	0x21, 0x80, /* 0010000110 */
	0x07, 0x80, /* 0000011110 */
	0x39, 0x80, /* 0011100110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x73, 0x80, /* 0111001110 */
	0x3d, 0xc0, /* 0011110111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 98 0x62 'b' */
	0x20, 0x00, /* 0010000000 */
	0x60, 0x00, /* 0110000000 */
	0xe0, 0x00, /* 1110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x66, 0x00, /* 0110011000 */
	0x6f, 0x00, /* 0110111100 */
	0x73, 0x80, /* 0111001110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x71, 0x80, /* 0111000110 */
	0x7b, 0x00, /* 0111101100 */
	0x4e, 0x00, /* 0100111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 99 0x63 'c' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x1e, 0x00, /* 0001111000 */
	0x37, 0x00, /* 0011011100 */
	0x23, 0x00, /* 0010001100 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x71, 0x00, /* 0111000100 */
	0x33, 0x00, /* 0011001100 */
	0x1e, 0x00, /* 0001111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 100 0x64 'd' */
	0x01, 0x80, /* 0000000110 */
	0x03, 0x80, /* 0000001110 */
	0x01, 0x80, /* 0000000110 */
	0x01, 0x80, /* 0000000110 */
	0x01, 0x80, /* 0000000110 */
	0x0d, 0x80, /* 0000110110 */
	0x37, 0x80, /* 0011011110 */
	0x23, 0x80, /* 0010001110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x73, 0x80, /* 0111001110 */
	0x35, 0x80, /* 0011010110 */
	0x19, 0xc0, /* 0001100111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 101 0x65 'e' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x33, 0x00, /* 0011001100 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x7f, 0x80, /* 0111111110 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x30, 0x00, /* 0011000000 */
	0x19, 0x80, /* 0001100110 */
	0x0e, 0x00, /* 0000111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 102 0x66 'f' */
	0x07, 0x00, /* 0000011100 */
	0x09, 0x80, /* 0000100110 */
	0x09, 0x80, /* 0000100110 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x7f, 0x00, /* 0111111100 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x3c, 0x00, /* 0011110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 103 0x67 'g' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x1c, 0x80, /* 0001110010 */
	0x37, 0x80, /* 0011011110 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x36, 0x00, /* 0011011000 */
	0x3c, 0x00, /* 0011110000 */
	0x60, 0x00, /* 0110000000 */
	0x7f, 0x00, /* 0111111100 */
	0x3f, 0x80, /* 0011111110 */
	0x21, 0x80, /* 0010000110 */
	0x40, 0x80, /* 0100000010 */
	0x7f, 0x00, /* 0111111100 */
	0x3e, 0x00, /* 0011111000 */

	/* 104 0x68 'h' */
	0x10, 0x00, /* 0001000000 */
	0x30, 0x00, /* 0011000000 */
	0x70, 0x00, /* 0111000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x37, 0x00, /* 0011011100 */
	0x3b, 0x80, /* 0011101110 */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x7b, 0xc0, /* 0111101111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 105 0x69 'i' */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x3c, 0x00, /* 0011110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x3f, 0x00, /* 0011111100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 106 0x6a 'j' */
	0x00, 0x00, /* 0000000000 */
	0x01, 0x80, /* 0000000110 */
	0x01, 0x80, /* 0000000110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x07, 0x80, /* 0000011110 */
	0x01, 0x80, /* 0000000110 */
	0x01, 0x80, /* 0000000110 */
	0x01, 0x80, /* 0000000110 */
	0x01, 0x80, /* 0000000110 */
	0x01, 0x80, /* 0000000110 */
	0x01, 0x80, /* 0000000110 */
	0x01, 0x80, /* 0000000110 */
	0x41, 0x80, /* 0100000110 */
	0x61, 0x80, /* 0110000110 */
	0x71, 0x80, /* 0111000110 */
	0x3f, 0x00, /* 0011111100 */
	0x1c, 0x00, /* 0001110000 */

	/* 107 0x6b 'k' */
	0x60, 0x00, /* 0110000000 */
	0xe0, 0x00, /* 1110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x63, 0x80, /* 0110001110 */
	0x66, 0x00, /* 0110011000 */
	0x6c, 0x00, /* 0110110000 */
	0x78, 0x00, /* 0111100000 */
	0x70, 0x00, /* 0111000000 */
	0x78, 0x00, /* 0111100000 */
	0x6c, 0x00, /* 0110110000 */
	0x6e, 0x00, /* 0110111000 */
	0x67, 0x00, /* 0110011100 */
	0xf3, 0x80, /* 1111001110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 108 0x6c 'l' */
	0x3c, 0x00, /* 0011110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x3f, 0x00, /* 0011111100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 109 0x6d 'm' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0xdb, 0x80, /* 1101101110 */
	0x6d, 0x80, /* 0110110110 */
	0x6d, 0x80, /* 0110110110 */
	0x6d, 0x80, /* 0110110110 */
	0x6d, 0x80, /* 0110110110 */
	0x6d, 0x80, /* 0110110110 */
	0x6d, 0x80, /* 0110110110 */
	0x6d, 0x80, /* 0110110110 */
	0x6d, 0x80, /* 0110110110 */
	0xed, 0xc0, /* 1110110111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 110 0x6e 'n' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x6f, 0x00, /* 0110111100 */
	0x7b, 0x80, /* 0111101110 */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x7b, 0xc0, /* 0111101111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 111 0x6f 'o' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x3c, 0x00, /* 0011110000 */
	0x66, 0x00, /* 0110011000 */
	0xc3, 0x00, /* 1100001100 */
	0xc1, 0x80, /* 1100000110 */
	0xc1, 0x80, /* 1100000110 */
	0xc1, 0x80, /* 1100000110 */
	0xc1, 0x80, /* 1100000110 */
	0xe1, 0x80, /* 1110000110 */
	0x73, 0x00, /* 0111001100 */
	0x3c, 0x00, /* 0011110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 112 0x70 'p' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0xde, 0x00, /* 1101111000 */
	0x76, 0x00, /* 0111011000 */
	0x63, 0x00, /* 0110001100 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x71, 0x80, /* 0111000110 */
	0x7b, 0x00, /* 0111101100 */
	0x7e, 0x00, /* 0111111000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0xf0, 0x00, /* 1111000000 */

	/* 113 0x71 'q' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0e, 0xc0, /* 0000111011 */
	0x1b, 0x80, /* 0001101110 */
	0x33, 0x80, /* 0011001110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x71, 0x80, /* 0111000110 */
	0x3b, 0x80, /* 0011101110 */
	0x1f, 0x80, /* 0001111110 */
	0x01, 0x80, /* 0000000110 */
	0x01, 0x80, /* 0000000110 */
	0x03, 0xc0, /* 0000001111 */

	/* 114 0x72 'r' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x73, 0x00, /* 0111001100 */
	0x35, 0x80, /* 0011010110 */
	0x39, 0x80, /* 0011100110 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x78, 0x00, /* 0111100000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 115 0x73 's' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x3f, 0x00, /* 0011111100 */
	0x63, 0x00, /* 0110001100 */
	0x61, 0x00, /* 0110000100 */
	0x70, 0x00, /* 0111000000 */
	0x38, 0x00, /* 0011100000 */
	0x0e, 0x00, /* 0000111000 */
	0x07, 0x00, /* 0000011100 */
	0x43, 0x00, /* 0100001100 */
	0x63, 0x00, /* 0110001100 */
	0x7e, 0x00, /* 0111111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 116 0x74 't' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x08, 0x00, /* 0000100000 */
	0x08, 0x00, /* 0000100000 */
	0x18, 0x00, /* 0001100000 */
	0x7f, 0x80, /* 0111111110 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x1c, 0x80, /* 0001110010 */
	0x0f, 0x00, /* 0000111100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 117 0x75 'u' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0xf7, 0x80, /* 1111011110 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x77, 0x00, /* 0111011100 */
	0x3d, 0x80, /* 0011110110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 118 0x76 'v' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0xf1, 0xc0, /* 1111000111 */
	0x60, 0xc0, /* 0110000011 */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x19, 0x80, /* 0001100110 */
	0x1b, 0x00, /* 0001101100 */
	0x0f, 0x00, /* 0000111100 */
	0x0f, 0x00, /* 0000111100 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 119 0x77 'w' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0xe3, 0xc0, /* 1110001111 */
	0xc1, 0x80, /* 1100000110 */
	0xc1, 0x80, /* 1100000110 */
	0xc1, 0x80, /* 1100000110 */
	0xc1, 0x80, /* 1100000110 */
	0x6b, 0x00, /* 0110101100 */
	0x6b, 0x00, /* 0110101100 */
	0x7e, 0x00, /* 0111111000 */
	0x36, 0x00, /* 0011011000 */
	0x36, 0x00, /* 0011011000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 120 0x78 'x' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0xf7, 0x80, /* 1111011110 */
	0x63, 0x00, /* 0110001100 */
	0x36, 0x00, /* 0011011000 */
	0x36, 0x00, /* 0011011000 */
	0x1c, 0x00, /* 0001110000 */
	0x1c, 0x00, /* 0001110000 */
	0x36, 0x00, /* 0011011000 */
	0x66, 0x00, /* 0110011000 */
	0x63, 0x00, /* 0110001100 */
	0xf7, 0x80, /* 1111011110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 121 0x79 'y' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0xf3, 0xc0, /* 1111001111 */
	0x61, 0x80, /* 0110000110 */
	0x33, 0x00, /* 0011001100 */
	0x1b, 0x00, /* 0001101100 */
	0x1e, 0x00, /* 0001111000 */
	0x0e, 0x00, /* 0000111000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x18, 0x00, /* 0001100000 */
	0x78, 0x00, /* 0111100000 */
	0x70, 0x00, /* 0111000000 */

	/* 122 0x7a 'z' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x7f, 0x80, /* 0111111110 */
	0x61, 0x80, /* 0110000110 */
	0x43, 0x00, /* 0100001100 */
	0x06, 0x00, /* 0000011000 */
	0x0c, 0x00, /* 0000110000 */
	0x18, 0x00, /* 0001100000 */
	0x30, 0x00, /* 0011000000 */
	0x60, 0x80, /* 0110000010 */
	0x61, 0x80, /* 0110000110 */
	0x7f, 0x80, /* 0111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 123 0x7b '{' */
	0x07, 0x00, /* 0000011100 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x18, 0x00, /* 0001100000 */
	0x70, 0x00, /* 0111000000 */
	0x18, 0x00, /* 0001100000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x07, 0x00, /* 0000011100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 124 0x7c '|' */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */

	/* 125 0x7d '}' */
	0x38, 0x00, /* 0011100000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x06, 0x00, /* 0000011000 */
	0x03, 0x80, /* 0000001110 */
	0x06, 0x00, /* 0000011000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x38, 0x00, /* 0011100000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 126 0x7e '~' */
	0x00, 0x00, /* 0000000000 */
	0x18, 0x80, /* 0001100010 */
	0x3d, 0x80, /* 0011110110 */
	0x6f, 0x00, /* 0110111100 */
	0x46, 0x00, /* 0100011000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 127 0x7f '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x12, 0x00, /* 0001001000 */
	0x21, 0x00, /* 0010000100 */
	0x40, 0x80, /* 0100000010 */
	0x40, 0x80, /* 0100000010 */
	0x40, 0x80, /* 0100000010 */
	0x7f, 0x80, /* 0111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 128 0x80 '.' */
	0x00, 0x00, /* 0000000000 */
	0x1f, 0x00, /* 0001111100 */
	0x21, 0x80, /* 0010000110 */
	0x40, 0x80, /* 0100000010 */
	0x40, 0x00, /* 0100000000 */
	0x40, 0x00, /* 0100000000 */
	0x40, 0x00, /* 0100000000 */
	0x40, 0x00, /* 0100000000 */
	0x40, 0x00, /* 0100000000 */
	0x40, 0x00, /* 0100000000 */
	0x60, 0x80, /* 0110000010 */
	0x31, 0x00, /* 0011000100 */
	0x1e, 0x00, /* 0001111000 */
	0x08, 0x00, /* 0000100000 */
	0x04, 0x00, /* 0000010000 */
	0x02, 0x00, /* 0000001000 */
	0x02, 0x00, /* 0000001000 */
	0x1c, 0x00, /* 0001110000 */

	/* 129 0x81 '.' */
	0x00, 0x00, /* 0000000000 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x7b, 0x80, /* 0111101110 */
	0x31, 0x00, /* 0011000100 */
	0x31, 0x00, /* 0011000100 */
	0x31, 0x00, /* 0011000100 */
	0x31, 0x00, /* 0011000100 */
	0x31, 0x00, /* 0011000100 */
	0x31, 0x00, /* 0011000100 */
	0x31, 0x00, /* 0011000100 */
	0x3b, 0x00, /* 0011101100 */
	0x1c, 0x80, /* 0001110010 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 130 0x82 '.' */
	0x00, 0x00, /* 0000000000 */
	0x01, 0x00, /* 0000000100 */
	0x02, 0x00, /* 0000001000 */
	0x04, 0x00, /* 0000010000 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x33, 0x00, /* 0011001100 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x7f, 0x80, /* 0111111110 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x30, 0x00, /* 0011000000 */
	0x19, 0x80, /* 0001100110 */
	0x0e, 0x00, /* 0000111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 131 0x83 '.' */
	0x04, 0x00, /* 0000010000 */
	0x0e, 0x00, /* 0000111000 */
	0x1b, 0x00, /* 0001101100 */
	0x31, 0x80, /* 0011000110 */
	0x00, 0x00, /* 0000000000 */
	0x1f, 0x00, /* 0001111100 */
	0x31, 0x80, /* 0011000110 */
	0x21, 0x80, /* 0010000110 */
	0x07, 0x80, /* 0000011110 */
	0x39, 0x80, /* 0011100110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x73, 0x80, /* 0111001110 */
	0x3d, 0xc0, /* 0011110111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 132 0x84 '.' */
	0x00, 0x00, /* 0000000000 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x1f, 0x00, /* 0001111100 */
	0x31, 0x80, /* 0011000110 */
	0x21, 0x80, /* 0010000110 */
	0x07, 0x80, /* 0000011110 */
	0x39, 0x80, /* 0011100110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x73, 0x80, /* 0111001110 */
	0x3d, 0xc0, /* 0011110111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 133 0x85 '.' */
	0x00, 0x00, /* 0000000000 */
	0x18, 0x00, /* 0001100000 */
	0x0c, 0x00, /* 0000110000 */
	0x06, 0x00, /* 0000011000 */
	0x00, 0x00, /* 0000000000 */
	0x1f, 0x00, /* 0001111100 */
	0x31, 0x80, /* 0011000110 */
	0x21, 0x80, /* 0010000110 */
	0x07, 0x80, /* 0000011110 */
	0x39, 0x80, /* 0011100110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x73, 0x80, /* 0111001110 */
	0x3d, 0xc0, /* 0011110111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 134 0x86 '.' */
	0x00, 0x00, /* 0000000000 */
	0x0e, 0x00, /* 0000111000 */
	0x1b, 0x00, /* 0001101100 */
	0x0e, 0x00, /* 0000111000 */
	0x00, 0x00, /* 0000000000 */
	0x1f, 0x00, /* 0001111100 */
	0x31, 0x80, /* 0011000110 */
	0x21, 0x80, /* 0010000110 */
	0x07, 0x80, /* 0000011110 */
	0x39, 0x80, /* 0011100110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x73, 0x80, /* 0111001110 */
	0x3d, 0xc0, /* 0011110111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 135 0x87 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x1f, 0x00, /* 0001111100 */
	0x31, 0x80, /* 0011000110 */
	0x20, 0x80, /* 0010000010 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x70, 0x80, /* 0111000010 */
	0x30, 0x80, /* 0011000010 */
	0x1f, 0x00, /* 0001111100 */
	0x04, 0x00, /* 0000010000 */
	0x02, 0x00, /* 0000001000 */
	0x01, 0x00, /* 0000000100 */
	0x0e, 0x00, /* 0000111000 */

	/* 136 0x88 '.' */
	0x04, 0x00, /* 0000010000 */
	0x0e, 0x00, /* 0000111000 */
	0x1b, 0x00, /* 0001101100 */
	0x31, 0x80, /* 0011000110 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x33, 0x00, /* 0011001100 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x7f, 0x80, /* 0111111110 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x30, 0x00, /* 0011000000 */
	0x19, 0x80, /* 0001100110 */
	0x0e, 0x00, /* 0000111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 137 0x89 '.' */
	0x00, 0x00, /* 0000000000 */
	0x36, 0x00, /* 0011011000 */
	0x36, 0x00, /* 0011011000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x33, 0x00, /* 0011001100 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x7f, 0x80, /* 0111111110 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x30, 0x00, /* 0011000000 */
	0x19, 0x80, /* 0001100110 */
	0x0e, 0x00, /* 0000111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 138 0x8a '.' */
	0x00, 0x00, /* 0000000000 */
	0x30, 0x00, /* 0011000000 */
	0x18, 0x00, /* 0001100000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x33, 0x00, /* 0011001100 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x7f, 0x80, /* 0111111110 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x30, 0x00, /* 0011000000 */
	0x19, 0x80, /* 0001100110 */
	0x0e, 0x00, /* 0000111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 139 0x8b '.' */
	0x00, 0x00, /* 0000000000 */
	0x36, 0x00, /* 0011011000 */
	0x36, 0x00, /* 0011011000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x3c, 0x00, /* 0011110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x3f, 0x00, /* 0011111100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 140 0x8c '.' */
	0x08, 0x00, /* 0000100000 */
	0x1c, 0x00, /* 0001110000 */
	0x36, 0x00, /* 0011011000 */
	0x63, 0x00, /* 0110001100 */
	0x00, 0x00, /* 0000000000 */
	0x3c, 0x00, /* 0011110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x3f, 0x00, /* 0011111100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 141 0x8d '.' */
	0x00, 0x00, /* 0000000000 */
	0x30, 0x00, /* 0011000000 */
	0x18, 0x00, /* 0001100000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x3c, 0x00, /* 0011110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x3f, 0x00, /* 0011111100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 142 0x8e '.' */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x04, 0x00, /* 0000010000 */
	0x04, 0x00, /* 0000010000 */
	0x0e, 0x00, /* 0000111000 */
	0x0e, 0x00, /* 0000111000 */
	0x0e, 0x00, /* 0000111000 */
	0x19, 0x00, /* 0001100100 */
	0x19, 0x00, /* 0001100100 */
	0x3f, 0x00, /* 0011111100 */
	0x31, 0x00, /* 0011000100 */
	0x31, 0x00, /* 0011000100 */
	0x60, 0x80, /* 0110000010 */
	0x60, 0x80, /* 0110000010 */
	0xf3, 0xc0, /* 1111001111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 143 0x8f '.' */
	0x04, 0x00, /* 0000010000 */
	0x0a, 0x00, /* 0000101000 */
	0x0a, 0x00, /* 0000101000 */
	0x04, 0x00, /* 0000010000 */
	0x0e, 0x00, /* 0000111000 */
	0x0e, 0x00, /* 0000111000 */
	0x0e, 0x00, /* 0000111000 */
	0x19, 0x00, /* 0001100100 */
	0x19, 0x00, /* 0001100100 */
	0x3f, 0x00, /* 0011111100 */
	0x31, 0x00, /* 0011000100 */
	0x31, 0x00, /* 0011000100 */
	0x60, 0x80, /* 0110000010 */
	0x60, 0x80, /* 0110000010 */
	0xf3, 0xc0, /* 1111001111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 144 0x90 '.' */
	0x03, 0x00, /* 0000001100 */
	0x06, 0x00, /* 0000011000 */
	0x0c, 0x00, /* 0000110000 */
	0x7f, 0x80, /* 0111111110 */
	0x30, 0x80, /* 0011000010 */
	0x30, 0x80, /* 0011000010 */
	0x30, 0x00, /* 0011000000 */
	0x31, 0x00, /* 0011000100 */
	0x3f, 0x00, /* 0011111100 */
	0x31, 0x00, /* 0011000100 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x80, /* 0011000010 */
	0x30, 0x80, /* 0011000010 */
	0x7f, 0x80, /* 0111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 145 0x91 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x3b, 0x80, /* 0011101110 */
	0x6c, 0xc0, /* 0110110011 */
	0x4c, 0xc0, /* 0100110011 */
	0x0c, 0xc0, /* 0000110011 */
	0x3f, 0xc0, /* 0011111111 */
	0x6c, 0x00, /* 0110110000 */
	0xcc, 0x00, /* 1100110000 */
	0xcc, 0x00, /* 1100110000 */
	0xee, 0xc0, /* 1110111011 */
	0x7b, 0x80, /* 0111101110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 146 0x92 '.' */
	0x00, 0x00, /* 0000000000 */
	0x07, 0xc0, /* 0000011111 */
	0x0e, 0x40, /* 0000111001 */
	0x0e, 0x40, /* 0000111001 */
	0x0e, 0x00, /* 0000111000 */
	0x16, 0x00, /* 0001011000 */
	0x16, 0x80, /* 0001011010 */
	0x17, 0x80, /* 0001011110 */
	0x16, 0x80, /* 0001011010 */
	0x3e, 0x00, /* 0011111000 */
	0x26, 0x00, /* 0010011000 */
	0x26, 0x00, /* 0010011000 */
	0x46, 0x40, /* 0100011001 */
	0x46, 0x40, /* 0100011001 */
	0xef, 0xc0, /* 1110111111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 147 0x93 '.' */
	0x00, 0x00, /* 0000000000 */
	0x08, 0x00, /* 0000100000 */
	0x1c, 0x00, /* 0001110000 */
	0x36, 0x00, /* 0011011000 */
	0x00, 0x00, /* 0000000000 */
	0x3c, 0x00, /* 0011110000 */
	0x66, 0x00, /* 0110011000 */
	0xc3, 0x00, /* 1100001100 */
	0xc1, 0x80, /* 1100000110 */
	0xc1, 0x80, /* 1100000110 */
	0xc1, 0x80, /* 1100000110 */
	0xc1, 0x80, /* 1100000110 */
	0xe1, 0x80, /* 1110000110 */
	0x73, 0x00, /* 0111001100 */
	0x3c, 0x00, /* 0011110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 148 0x94 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x00, 0x00, /* 0000000000 */
	0x3c, 0x00, /* 0011110000 */
	0x66, 0x00, /* 0110011000 */
	0xc3, 0x00, /* 1100001100 */
	0xc1, 0x80, /* 1100000110 */
	0xc1, 0x80, /* 1100000110 */
	0xc1, 0x80, /* 1100000110 */
	0xc1, 0x80, /* 1100000110 */
	0xe1, 0x80, /* 1110000110 */
	0x73, 0x00, /* 0111001100 */
	0x3c, 0x00, /* 0011110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 149 0x95 '.' */
	0x00, 0x00, /* 0000000000 */
	0x18, 0x00, /* 0001100000 */
	0x0c, 0x00, /* 0000110000 */
	0x06, 0x00, /* 0000011000 */
	0x00, 0x00, /* 0000000000 */
	0x3c, 0x00, /* 0011110000 */
	0x66, 0x00, /* 0110011000 */
	0xc3, 0x00, /* 1100001100 */
	0xc1, 0x80, /* 1100000110 */
	0xc1, 0x80, /* 1100000110 */
	0xc1, 0x80, /* 1100000110 */
	0xc1, 0x80, /* 1100000110 */
	0xe1, 0x80, /* 1110000110 */
	0x73, 0x00, /* 0111001100 */
	0x3c, 0x00, /* 0011110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 150 0x96 '.' */
	0x08, 0x00, /* 0000100000 */
	0x1c, 0x00, /* 0001110000 */
	0x36, 0x00, /* 0011011000 */
	0x63, 0x00, /* 0110001100 */
	0x00, 0x00, /* 0000000000 */
	0xf7, 0x80, /* 1111011110 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x77, 0x00, /* 0111011100 */
	0x3d, 0x80, /* 0011110110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 151 0x97 '.' */
	0x00, 0x00, /* 0000000000 */
	0x60, 0x00, /* 0110000000 */
	0x30, 0x00, /* 0011000000 */
	0x18, 0x00, /* 0001100000 */
	0x00, 0x00, /* 0000000000 */
	0xf7, 0x80, /* 1111011110 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x77, 0x00, /* 0111011100 */
	0x3d, 0x80, /* 0011110110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 152 0x98 '.' */
	0x00, 0x00, /* 0000000000 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0xf3, 0xc0, /* 1111001111 */
	0x61, 0x80, /* 0110000110 */
	0x33, 0x00, /* 0011001100 */
	0x1b, 0x00, /* 0001101100 */
	0x1e, 0x00, /* 0001111000 */
	0x0e, 0x00, /* 0000111000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x18, 0x00, /* 0001100000 */
	0x78, 0x00, /* 0111100000 */
	0x70, 0x00, /* 0111000000 */

	/* 153 0x99 '.' */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x0c, 0x00, /* 0000110000 */
	0x17, 0x00, /* 0001011100 */
	0x23, 0x00, /* 0010001100 */
	0x21, 0x80, /* 0010000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x21, 0x00, /* 0010000100 */
	0x31, 0x00, /* 0011000100 */
	0x1a, 0x00, /* 0001101000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 154 0x9a '.' */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x00, 0x00, /* 0000000000 */
	0xf1, 0xc0, /* 1111000111 */
	0x60, 0x80, /* 0110000010 */
	0x60, 0x80, /* 0110000010 */
	0x60, 0x80, /* 0110000010 */
	0x60, 0x80, /* 0110000010 */
	0x60, 0x80, /* 0110000010 */
	0x60, 0x80, /* 0110000010 */
	0x60, 0x80, /* 0110000010 */
	0x60, 0x80, /* 0110000010 */
	0x71, 0x00, /* 0111000100 */
	0x3f, 0x00, /* 0011111100 */
	0x1e, 0x00, /* 0001111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 155 0x9b '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x1f, 0x80, /* 0001111110 */
	0x36, 0x80, /* 0011011010 */
	0x26, 0x00, /* 0010011000 */
	0x66, 0x00, /* 0110011000 */
	0x66, 0x00, /* 0110011000 */
	0x66, 0x00, /* 0110011000 */
	0x66, 0x00, /* 0110011000 */
	0x76, 0x00, /* 0111011000 */
	0x36, 0x80, /* 0011011010 */
	0x1f, 0x80, /* 0001111110 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x00, 0x00, /* 0000000000 */

	/* 156 0x9c '.' */
	0x00, 0x00, /* 0000000000 */
	0x1e, 0x00, /* 0001111000 */
	0x3b, 0x00, /* 0011101100 */
	0x33, 0x00, /* 0011001100 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x7e, 0x00, /* 0111111000 */
	0x7e, 0x00, /* 0111111000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x7c, 0x80, /* 0111110010 */
	0x7f, 0x80, /* 0111111110 */
	0x43, 0x00, /* 0100001100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 157 0x9d '.' */
	0x00, 0x00, /* 0000000000 */
	0x40, 0x80, /* 0100000010 */
	0x40, 0x80, /* 0100000010 */
	0x21, 0x00, /* 0010000100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x1e, 0x00, /* 0001111000 */
	0x0c, 0x00, /* 0000110000 */
	0x3f, 0x00, /* 0011111100 */
	0x0c, 0x00, /* 0000110000 */
	0x3f, 0x00, /* 0011111100 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 158 0x9e '.' */
	0x00, 0x00, /* 0000000000 */
	0xbf, 0x00, /* 1011111100 */
	0x40, 0x80, /* 0100000010 */
	0x40, 0x80, /* 0100000010 */
	0x7f, 0x00, /* 0111111100 */
	0x40, 0x00, /* 0100000000 */
	0x48, 0x00, /* 0100100000 */
	0x48, 0x00, /* 0100100000 */
	0x5e, 0x00, /* 0101111000 */
	0x48, 0x00, /* 0100100000 */
	0x48, 0x00, /* 0100100000 */
	0x48, 0x00, /* 0100100000 */
	0x48, 0x80, /* 0100100010 */
	0x47, 0x00, /* 0100011100 */
	0xe0, 0x00, /* 1110000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 159 0x9f '.' */
	0x00, 0x00, /* 0000000000 */
	0x03, 0x00, /* 0000001100 */
	0x04, 0x80, /* 0000010010 */
	0x08, 0x00, /* 0000100000 */
	0x08, 0x00, /* 0000100000 */
	0x08, 0x00, /* 0000100000 */
	0x08, 0x00, /* 0000100000 */
	0x09, 0x00, /* 0000100100 */
	0x3e, 0x00, /* 0011111000 */
	0x48, 0x00, /* 0100100000 */
	0x08, 0x00, /* 0000100000 */
	0x08, 0x00, /* 0000100000 */
	0x08, 0x00, /* 0000100000 */
	0x08, 0x00, /* 0000100000 */
	0x08, 0x00, /* 0000100000 */
	0x90, 0x00, /* 1001000000 */
	0x60, 0x00, /* 0110000000 */
	0x00, 0x00, /* 0000000000 */

	/* 160 0xa0 '.' */
	0x00, 0x00, /* 0000000000 */
	0x03, 0x00, /* 0000001100 */
	0x06, 0x00, /* 0000011000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x1f, 0x00, /* 0001111100 */
	0x31, 0x80, /* 0011000110 */
	0x21, 0x80, /* 0010000110 */
	0x07, 0x80, /* 0000011110 */
	0x39, 0x80, /* 0011100110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x73, 0x80, /* 0111001110 */
	0x3d, 0xc0, /* 0011110111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 161 0xa1 '.' */
	0x00, 0x00, /* 0000000000 */
	0x03, 0x00, /* 0000001100 */
	0x06, 0x00, /* 0000011000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x3c, 0x00, /* 0011110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x3f, 0x00, /* 0011111100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 162 0xa2 '.' */
	0x00, 0x00, /* 0000000000 */
	0x06, 0x00, /* 0000011000 */
	0x0c, 0x00, /* 0000110000 */
	0x18, 0x00, /* 0001100000 */
	0x00, 0x00, /* 0000000000 */
	0x3c, 0x00, /* 0011110000 */
	0x66, 0x00, /* 0110011000 */
	0xc3, 0x00, /* 1100001100 */
	0xc1, 0x80, /* 1100000110 */
	0xc1, 0x80, /* 1100000110 */
	0xc1, 0x80, /* 1100000110 */
	0xc1, 0x80, /* 1100000110 */
	0xe1, 0x80, /* 1110000110 */
	0x73, 0x00, /* 0111001100 */
	0x3c, 0x00, /* 0011110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 163 0xa3 '.' */
	0x00, 0x00, /* 0000000000 */
	0x06, 0x00, /* 0000011000 */
	0x0c, 0x00, /* 0000110000 */
	0x18, 0x00, /* 0001100000 */
	0x00, 0x00, /* 0000000000 */
	0xf7, 0x80, /* 1111011110 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x77, 0x00, /* 0111011100 */
	0x3d, 0x80, /* 0011110110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 164 0xa4 '.' */
	0x00, 0x00, /* 0000000000 */
	0x38, 0x80, /* 0011100010 */
	0x7f, 0x80, /* 0111111110 */
	0x47, 0x00, /* 0100011100 */
	0x00, 0x00, /* 0000000000 */
	0x6f, 0x00, /* 0110111100 */
	0x7b, 0x80, /* 0111101110 */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x7b, 0xc0, /* 0111101111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 165 0xa5 '.' */
	0x00, 0x00, /* 0000000000 */
	0x38, 0x80, /* 0011100010 */
	0x7f, 0x80, /* 0111111110 */
	0x47, 0x00, /* 0100011100 */
	0x00, 0x00, /* 0000000000 */
	0xe3, 0xc0, /* 1110001111 */
	0x71, 0x80, /* 0111000110 */
	0x79, 0x80, /* 0111100110 */
	0x79, 0x80, /* 0111100110 */
	0x6d, 0x80, /* 0110110110 */
	0x6d, 0x80, /* 0110110110 */
	0x67, 0x80, /* 0110011110 */
	0x63, 0x80, /* 0110001110 */
	0x61, 0x80, /* 0110000110 */
	0xf0, 0xc0, /* 1111000011 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 166 0xa6 '.' */
	0x00, 0x00, /* 0000000000 */
	0x3e, 0x00, /* 0011111000 */
	0x63, 0x00, /* 0110001100 */
	0x03, 0x00, /* 0000001100 */
	0x0f, 0x00, /* 0000111100 */
	0x33, 0x00, /* 0011001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x67, 0x00, /* 0110011100 */
	0x3b, 0x80, /* 0011101110 */
	0x00, 0x00, /* 0000000000 */
	0x7f, 0x80, /* 0111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 167 0xa7 '.' */
	0x00, 0x00, /* 0000000000 */
	0x0e, 0x00, /* 0000111000 */
	0x33, 0x00, /* 0011001100 */
	0x21, 0x80, /* 0010000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x00, /* 0110000100 */
	0x33, 0x00, /* 0011001100 */
	0x1c, 0x00, /* 0001110000 */
	0x00, 0x00, /* 0000000000 */
	0x7f, 0x80, /* 0111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 168 0xa8 '.' */
	0x00, 0x00, /* 0000000000 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x00, 0x00, /* 0000000000 */
	0x06, 0x00, /* 0000011000 */
	0x06, 0x00, /* 0000011000 */
	0x0c, 0x00, /* 0000110000 */
	0x18, 0x00, /* 0001100000 */
	0x30, 0x00, /* 0011000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x80, /* 0110000010 */
	0x73, 0x80, /* 0111001110 */
	0x3f, 0x00, /* 0011111100 */
	0x1e, 0x00, /* 0001111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 169 0xa9 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 170 0xaa '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x01, 0x80, /* 0000000110 */
	0x01, 0x80, /* 0000000110 */
	0x01, 0x80, /* 0000000110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 171 0xab '.' */
	0x00, 0x00, /* 0000000000 */
	0x20, 0x00, /* 0010000000 */
	0x60, 0x00, /* 0110000000 */
	0x20, 0x00, /* 0010000000 */
	0x20, 0x80, /* 0010000010 */
	0x21, 0x00, /* 0010000100 */
	0x22, 0x00, /* 0010001000 */
	0x74, 0x00, /* 0111010000 */
	0x08, 0x00, /* 0000100000 */
	0x17, 0x00, /* 0001011100 */
	0x28, 0x80, /* 0010100010 */
	0x43, 0x00, /* 0100001100 */
	0x04, 0x00, /* 0000010000 */
	0x08, 0x00, /* 0000100000 */
	0x0f, 0x80, /* 0000111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 172 0xac '.' */
	0x00, 0x00, /* 0000000000 */
	0x20, 0x00, /* 0010000000 */
	0x60, 0x00, /* 0110000000 */
	0x20, 0x00, /* 0010000000 */
	0x20, 0x80, /* 0010000010 */
	0x21, 0x00, /* 0010000100 */
	0x22, 0x00, /* 0010001000 */
	0x74, 0x00, /* 0111010000 */
	0x09, 0x00, /* 0000100100 */
	0x13, 0x00, /* 0001001100 */
	0x25, 0x00, /* 0010010100 */
	0x49, 0x00, /* 0100100100 */
	0x1f, 0x80, /* 0001111110 */
	0x01, 0x00, /* 0000000100 */
	0x01, 0x00, /* 0000000100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 173 0xad '.' */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 174 0xae '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0d, 0x80, /* 0000110110 */
	0x1b, 0x00, /* 0001101100 */
	0x36, 0x00, /* 0011011000 */
	0x6c, 0x00, /* 0110110000 */
	0xd8, 0x00, /* 1101100000 */
	0x6c, 0x00, /* 0110110000 */
	0x36, 0x00, /* 0011011000 */
	0x1b, 0x00, /* 0001101100 */
	0x0d, 0x80, /* 0000110110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 175 0xaf '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x6c, 0x00, /* 0110110000 */
	0x36, 0x00, /* 0011011000 */
	0x1b, 0x00, /* 0001101100 */
	0x0d, 0x80, /* 0000110110 */
	0x06, 0xc0, /* 0000011011 */
	0x0d, 0x80, /* 0000110110 */
	0x1b, 0x00, /* 0001101100 */
	0x36, 0x00, /* 0011011000 */
	0x6c, 0x00, /* 0110110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 176 0xb0 '.' */
	0xc3, 0x00, /* 1100001100 */
	0x41, 0x00, /* 0100000100 */
	0x18, 0x40, /* 0001100001 */
	0x10, 0x40, /* 0001000001 */
	0xc3, 0x00, /* 1100001100 */
	0x41, 0x00, /* 0100000100 */
	0x18, 0x40, /* 0001100001 */
	0x10, 0x40, /* 0001000001 */
	0xc3, 0x00, /* 1100001100 */
	0x41, 0x00, /* 0100000100 */
	0x18, 0x40, /* 0001100001 */
	0x10, 0x40, /* 0001000001 */
	0xc3, 0x00, /* 1100001100 */
	0x41, 0x00, /* 0100000100 */
	0x18, 0x40, /* 0001100001 */
	0x10, 0x40, /* 0001000001 */
	0xc3, 0x00, /* 1100001100 */
	0x41, 0x00, /* 0100000100 */

	/* 177 0xb1 '.' */
	0x11, 0x00, /* 0001000100 */
	0xbb, 0x80, /* 1011101110 */
	0x11, 0x00, /* 0001000100 */
	0x44, 0x40, /* 0100010001 */
	0xee, 0xc0, /* 1110111011 */
	0x44, 0x40, /* 0100010001 */
	0x11, 0x00, /* 0001000100 */
	0xbb, 0x80, /* 1011101110 */
	0x11, 0x00, /* 0001000100 */
	0x44, 0x40, /* 0100010001 */
	0xee, 0xc0, /* 1110111011 */
	0x44, 0x40, /* 0100010001 */
	0x11, 0x00, /* 0001000100 */
	0xbb, 0x80, /* 1011101110 */
	0x11, 0x00, /* 0001000100 */
	0x44, 0x40, /* 0100010001 */
	0xee, 0xc0, /* 1110111011 */
	0x44, 0x40, /* 0100010001 */

	/* 178 0xb2 '.' */
	0x3c, 0xc0, /* 0011110011 */
	0xbe, 0xc0, /* 1011111011 */
	0xe7, 0x80, /* 1110011110 */
	0xef, 0x80, /* 1110111110 */
	0x3c, 0xc0, /* 0011110011 */
	0xbe, 0xc0, /* 1011111011 */
	0xe7, 0x80, /* 1110011110 */
	0xef, 0x80, /* 1110111110 */
	0x3c, 0xc0, /* 0011110011 */
	0xbe, 0xc0, /* 1011111011 */
	0xe7, 0x80, /* 1110011110 */
	0xef, 0x80, /* 1110111110 */
	0x3c, 0xc0, /* 0011110011 */
	0xbe, 0xc0, /* 1011111011 */
	0xe7, 0x80, /* 1110011110 */
	0xef, 0x80, /* 1110111110 */
	0x3c, 0xc0, /* 0011110011 */
	0xbe, 0xc0, /* 1011111011 */

	/* 179 0xb3 '.' */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */

	/* 180 0xb4 '.' */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0xfc, 0x00, /* 1111110000 */
	0xfc, 0x00, /* 1111110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */

	/* 181 0xb5 '.' */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0xfc, 0x00, /* 1111110000 */
	0xfc, 0x00, /* 1111110000 */
	0x0c, 0x00, /* 0000110000 */
	0xfc, 0x00, /* 1111110000 */
	0xfc, 0x00, /* 1111110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */

	/* 182 0xb6 '.' */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0xfb, 0x00, /* 1111101100 */
	0xfb, 0x00, /* 1111101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */

	/* 183 0xb7 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0xff, 0x00, /* 1111111100 */
	0xff, 0x00, /* 1111111100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */

	/* 184 0xb8 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0xfc, 0x00, /* 1111110000 */
	0xfc, 0x00, /* 1111110000 */
	0x0c, 0x00, /* 0000110000 */
	0xfc, 0x00, /* 1111110000 */
	0xfc, 0x00, /* 1111110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */

	/* 185 0xb9 '.' */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0xfb, 0x00, /* 1111101100 */
	0xfb, 0x00, /* 1111101100 */
	0x03, 0x00, /* 0000001100 */
	0xfb, 0x00, /* 1111101100 */
	0xfb, 0x00, /* 1111101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */

	/* 186 0xba '.' */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */

	/* 187 0xbb '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0xff, 0x00, /* 1111111100 */
	0xff, 0x00, /* 1111111100 */
	0x03, 0x00, /* 0000001100 */
	0xfb, 0x00, /* 1111101100 */
	0xfb, 0x00, /* 1111101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */

	/* 188 0xbc '.' */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0xfb, 0x00, /* 1111101100 */
	0xfb, 0x00, /* 1111101100 */
	0x03, 0x00, /* 0000001100 */
	0xff, 0x00, /* 1111111100 */
	0xff, 0x00, /* 1111111100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 189 0xbd '.' */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0xff, 0x00, /* 1111111100 */
	0xff, 0x00, /* 1111111100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 190 0xbe '.' */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0xfc, 0x00, /* 1111110000 */
	0xfc, 0x00, /* 1111110000 */
	0x0c, 0x00, /* 0000110000 */
	0xfc, 0x00, /* 1111110000 */
	0xfc, 0x00, /* 1111110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 191 0xbf '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0xfc, 0x00, /* 1111110000 */
	0xfc, 0x00, /* 1111110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */

	/* 192 0xc0 '.' */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0f, 0xc0, /* 0000111111 */
	0x0f, 0xc0, /* 0000111111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 193 0xc1 '.' */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 194 0xc2 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */

	/* 195 0xc3 '.' */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0f, 0xc0, /* 0000111111 */
	0x0f, 0xc0, /* 0000111111 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */

	/* 196 0xc4 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 197 0xc5 '.' */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */

	/* 198 0xc6 '.' */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0f, 0xc0, /* 0000111111 */
	0x0f, 0xc0, /* 0000111111 */
	0x0c, 0x00, /* 0000110000 */
	0x0f, 0xc0, /* 0000111111 */
	0x0f, 0xc0, /* 0000111111 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */

	/* 199 0xc7 '.' */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0xc0, /* 0001101111 */
	0x1b, 0xc0, /* 0001101111 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */

	/* 200 0xc8 '.' */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0xc0, /* 0001101111 */
	0x1b, 0xc0, /* 0001101111 */
	0x18, 0x00, /* 0001100000 */
	0x1f, 0xc0, /* 0001111111 */
	0x1f, 0xc0, /* 0001111111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 201 0xc9 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x1f, 0xc0, /* 0001111111 */
	0x1f, 0xc0, /* 0001111111 */
	0x18, 0x00, /* 0001100000 */
	0x1b, 0xc0, /* 0001101111 */
	0x1b, 0xc0, /* 0001101111 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */

	/* 202 0xca '.' */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0xfb, 0xc0, /* 1111101111 */
	0xfb, 0xc0, /* 1111101111 */
	0x00, 0x00, /* 0000000000 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 203 0xcb '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0x00, 0x00, /* 0000000000 */
	0xfb, 0xc0, /* 1111101111 */
	0xfb, 0xc0, /* 1111101111 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */

	/* 204 0xcc '.' */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0xc0, /* 0001101111 */
	0x1b, 0xc0, /* 0001101111 */
	0x18, 0x00, /* 0001100000 */
	0x1b, 0xc0, /* 0001101111 */
	0x1b, 0xc0, /* 0001101111 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */

	/* 205 0xcd '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0x00, 0x00, /* 0000000000 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 206 0xce '.' */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0xfb, 0xc0, /* 1111101111 */
	0xfb, 0xc0, /* 1111101111 */
	0x00, 0x00, /* 0000000000 */
	0xfb, 0xc0, /* 1111101111 */
	0xfb, 0xc0, /* 1111101111 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */

	/* 207 0xcf '.' */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0x00, 0x00, /* 0000000000 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 208 0xd0 '.' */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 209 0xd1 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0x00, 0x00, /* 0000000000 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */

	/* 210 0xd2 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */

	/* 211 0xd3 '.' */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1f, 0xc0, /* 0001111111 */
	0x1f, 0xc0, /* 0001111111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 212 0xd4 '.' */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0f, 0xc0, /* 0000111111 */
	0x0f, 0xc0, /* 0000111111 */
	0x0c, 0x00, /* 0000110000 */
	0x0f, 0xc0, /* 0000111111 */
	0x0f, 0xc0, /* 0000111111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 213 0xd5 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0f, 0xc0, /* 0000111111 */
	0x0f, 0xc0, /* 0000111111 */
	0x0c, 0x00, /* 0000110000 */
	0x0f, 0xc0, /* 0000111111 */
	0x0f, 0xc0, /* 0000111111 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */

	/* 214 0xd6 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x1f, 0xc0, /* 0001111111 */
	0x1f, 0xc0, /* 0001111111 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */

	/* 215 0xd7 '.' */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */
	0x1b, 0x00, /* 0001101100 */

	/* 216 0xd8 '.' */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0x0c, 0x00, /* 0000110000 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */

	/* 217 0xd9 '.' */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0xfc, 0x00, /* 1111110000 */
	0xfc, 0x00, /* 1111110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 218 0xda '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0f, 0xc0, /* 0000111111 */
	0x0f, 0xc0, /* 0000111111 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */

	/* 219 0xdb '.' */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */

	/* 220 0xdc '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */

	/* 221 0xdd '.' */
	0xf8, 0x00, /* 1111100000 */
	0xf8, 0x00, /* 1111100000 */
	0xf8, 0x00, /* 1111100000 */
	0xf8, 0x00, /* 1111100000 */
	0xf8, 0x00, /* 1111100000 */
	0xf8, 0x00, /* 1111100000 */
	0xf8, 0x00, /* 1111100000 */
	0xf8, 0x00, /* 1111100000 */
	0xf8, 0x00, /* 1111100000 */
	0xf8, 0x00, /* 1111100000 */
	0xf8, 0x00, /* 1111100000 */
	0xf8, 0x00, /* 1111100000 */
	0xf8, 0x00, /* 1111100000 */
	0xf8, 0x00, /* 1111100000 */
	0xf8, 0x00, /* 1111100000 */
	0xf8, 0x00, /* 1111100000 */
	0xf8, 0x00, /* 1111100000 */
	0xf8, 0x00, /* 1111100000 */

	/* 222 0xde '.' */
	0x07, 0xc0, /* 0000011111 */
	0x07, 0xc0, /* 0000011111 */
	0x07, 0xc0, /* 0000011111 */
	0x07, 0xc0, /* 0000011111 */
	0x07, 0xc0, /* 0000011111 */
	0x07, 0xc0, /* 0000011111 */
	0x07, 0xc0, /* 0000011111 */
	0x07, 0xc0, /* 0000011111 */
	0x07, 0xc0, /* 0000011111 */
	0x07, 0xc0, /* 0000011111 */
	0x07, 0xc0, /* 0000011111 */
	0x07, 0xc0, /* 0000011111 */
	0x07, 0xc0, /* 0000011111 */
	0x07, 0xc0, /* 0000011111 */
	0x07, 0xc0, /* 0000011111 */
	0x07, 0xc0, /* 0000011111 */
	0x07, 0xc0, /* 0000011111 */
	0x07, 0xc0, /* 0000011111 */

	/* 223 0xdf '.' */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0xff, 0xc0, /* 1111111111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 224 0xe0 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x1c, 0x80, /* 0001110010 */
	0x35, 0x80, /* 0011010110 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x63, 0x00, /* 0110001100 */
	0x37, 0x80, /* 0011011110 */
	0x1c, 0x80, /* 0001110010 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 225 0xe1 '.' */
	0x00, 0x00, /* 0000000000 */
	0x1e, 0x00, /* 0001111000 */
	0x33, 0x00, /* 0011001100 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x63, 0x00, /* 0110001100 */
	0x6f, 0x00, /* 0110111100 */
	0x63, 0x00, /* 0110001100 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x63, 0x00, /* 0110001100 */
	0x6e, 0x00, /* 0110111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 226 0xe2 '.' */
	0x00, 0x00, /* 0000000000 */
	0x7f, 0x80, /* 0111111110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 227 0xe3 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x7f, 0x80, /* 0111111110 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 228 0xe4 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0xff, 0x80, /* 1111111110 */
	0x60, 0x00, /* 0110000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x18, 0x00, /* 0001100000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x80, /* 0011000010 */
	0x61, 0x80, /* 0110000110 */
	0xff, 0x80, /* 1111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 229 0xe5 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x1f, 0xc0, /* 0001111111 */
	0x36, 0x00, /* 0011011000 */
	0x63, 0x00, /* 0110001100 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x33, 0x00, /* 0011001100 */
	0x3e, 0x00, /* 0011111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 230 0xe6 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x73, 0x80, /* 0111001110 */
	0x6d, 0x80, /* 0110110110 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0xc0, 0x00, /* 1100000000 */

	/* 231 0xe7 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x01, 0x80, /* 0000000110 */
	0x36, 0x40, /* 0011011001 */
	0x5e, 0x00, /* 0101111000 */
	0x8c, 0x00, /* 1000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 232 0xe8 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x7f, 0x80, /* 0111111110 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x1e, 0x00, /* 0001111000 */
	0x33, 0x00, /* 0011001100 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x33, 0x00, /* 0011001100 */
	0x1e, 0x00, /* 0001111000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x7f, 0x80, /* 0111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 233 0xe9 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0e, 0x00, /* 0000111000 */
	0x1f, 0x00, /* 0001111100 */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x60, 0xc0, /* 0110000011 */
	0x7f, 0xc0, /* 0111111111 */
	0x7f, 0xc0, /* 0111111111 */
	0x60, 0xc0, /* 0110000011 */
	0x31, 0x80, /* 0011000110 */
	0x31, 0x80, /* 0011000110 */
	0x1f, 0x00, /* 0001111100 */
	0x0e, 0x00, /* 0000111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 234 0xea '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x1e, 0x00, /* 0001111000 */
	0x33, 0x00, /* 0011001100 */
	0x61, 0x80, /* 0110000110 */
	0xc0, 0xc0, /* 1100000011 */
	0xc0, 0xc0, /* 1100000011 */
	0xc0, 0xc0, /* 1100000011 */
	0x61, 0x80, /* 0110000110 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0xf3, 0xc0, /* 1111001111 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 235 0xeb '.' */
	0x00, 0x00, /* 0000000000 */
	0x07, 0x00, /* 0000011100 */
	0x1f, 0x80, /* 0001111110 */
	0x30, 0xc0, /* 0011000011 */
	0x30, 0x00, /* 0011000000 */
	0x18, 0x00, /* 0001100000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x3e, 0x00, /* 0011111000 */
	0x66, 0x00, /* 0110011000 */
	0xc3, 0x00, /* 1100001100 */
	0xc3, 0x00, /* 1100001100 */
	0xc3, 0x00, /* 1100001100 */
	0x66, 0x00, /* 0110011000 */
	0x3c, 0x00, /* 0011110000 */
	0x18, 0x00, /* 0001100000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 236 0xec '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x33, 0x00, /* 0011001100 */
	0x6d, 0x80, /* 0110110110 */
	0xcc, 0xc0, /* 1100110011 */
	0xcc, 0xc0, /* 1100110011 */
	0xcc, 0xc0, /* 1100110011 */
	0xcc, 0xc0, /* 1100110011 */
	0x6d, 0x80, /* 0110110110 */
	0x33, 0x00, /* 0011001100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 237 0xed '.' */
	0x00, 0x00, /* 0000000000 */
	0x01, 0x80, /* 0000000110 */
	0x01, 0x80, /* 0000000110 */
	0x03, 0x00, /* 0000001100 */
	0x03, 0x00, /* 0000001100 */
	0x37, 0x00, /* 0011011100 */
	0x6d, 0x80, /* 0110110110 */
	0xcc, 0xc0, /* 1100110011 */
	0xcc, 0xc0, /* 1100110011 */
	0xcc, 0xc0, /* 1100110011 */
	0xcc, 0xc0, /* 1100110011 */
	0x6d, 0x80, /* 0110110110 */
	0x3b, 0x00, /* 0011101100 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x60, 0x00, /* 0110000000 */
	0x60, 0x00, /* 0110000000 */
	0x00, 0x00, /* 0000000000 */

	/* 238 0xee '.' */
	0x00, 0x00, /* 0000000000 */
	0x03, 0x80, /* 0000001110 */
	0x0e, 0x00, /* 0000111000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x3f, 0x80, /* 0011111110 */
	0x3f, 0x80, /* 0011111110 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x18, 0x00, /* 0001100000 */
	0x18, 0x00, /* 0001100000 */
	0x0e, 0x00, /* 0000111000 */
	0x03, 0x80, /* 0000001110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 239 0xef '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x1e, 0x00, /* 0001111000 */
	0x33, 0x00, /* 0011001100 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x61, 0x80, /* 0110000110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 240 0xf0 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 241 0xf1 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 242 0xf2 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0xe0, 0x00, /* 1110000000 */
	0x38, 0x00, /* 0011100000 */
	0x0e, 0x00, /* 0000111000 */
	0x03, 0x80, /* 0000001110 */
	0x0e, 0x00, /* 0000111000 */
	0x38, 0x00, /* 0011100000 */
	0xe0, 0x00, /* 1110000000 */
	0x00, 0x00, /* 0000000000 */
	0xff, 0x00, /* 1111111100 */
	0xff, 0x00, /* 1111111100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 243 0xf3 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x03, 0x80, /* 0000001110 */
	0x0e, 0x00, /* 0000111000 */
	0x38, 0x00, /* 0011100000 */
	0xe0, 0x00, /* 1110000000 */
	0x38, 0x00, /* 0011100000 */
	0x0e, 0x00, /* 0000111000 */
	0x03, 0x80, /* 0000001110 */
	0x00, 0x00, /* 0000000000 */
	0xff, 0x80, /* 1111111110 */
	0xff, 0x80, /* 1111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 244 0xf4 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x1e, 0x00, /* 0001111000 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x30, 0x00, /* 0011000000 */
	0x00, 0x00, /* 0000000000 */

	/* 245 0xf5 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x1e, 0x00, /* 0001111000 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x03, 0x00, /* 0000001100 */
	0x03, 0x00, /* 0000001100 */
	0x03, 0x00, /* 0000001100 */
	0x03, 0x00, /* 0000001100 */
	0x03, 0x00, /* 0000001100 */
	0x03, 0x00, /* 0000001100 */
	0x03, 0x00, /* 0000001100 */
	0x03, 0x00, /* 0000001100 */
	0x03, 0x00, /* 0000001100 */
	0x03, 0x00, /* 0000001100 */
	0x03, 0x00, /* 0000001100 */
	0x03, 0x00, /* 0000001100 */
	0x00, 0x00, /* 0000000000 */

	/* 246 0xf6 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 247 0xf7 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x38, 0x00, /* 0011100000 */
	0x6c, 0x00, /* 0110110000 */
	0x06, 0xc0, /* 0000011011 */
	0x03, 0x80, /* 0000001110 */
	0x38, 0x00, /* 0011100000 */
	0x6c, 0x00, /* 0110110000 */
	0x06, 0xc0, /* 0000011011 */
	0x03, 0x80, /* 0000001110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 248 0xf8 '.' */
	0x00, 0x00, /* 0000000000 */
	0x1e, 0x00, /* 0001111000 */
	0x33, 0x00, /* 0011001100 */
	0x33, 0x00, /* 0011001100 */
	0x1e, 0x00, /* 0001111000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 249 0xf9 '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x1e, 0x00, /* 0001111000 */
	0x1e, 0x00, /* 0001111000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 250 0xfa '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 251 0xfb '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x0f, 0xc0, /* 0000111111 */
	0x0f, 0xc0, /* 0000111111 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0x0c, 0x00, /* 0000110000 */
	0xcc, 0x00, /* 1100110000 */
	0x6c, 0x00, /* 0110110000 */
	0x3c, 0x00, /* 0011110000 */
	0x1c, 0x00, /* 0001110000 */
	0x0c, 0x00, /* 0000110000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 252 0xfc '.' */
	0x00, 0x00, /* 0000000000 */
	0x27, 0x00, /* 0010011100 */
	0x7b, 0x00, /* 0111101100 */
	0x31, 0x00, /* 0011000100 */
	0x31, 0x00, /* 0011000100 */
	0x31, 0x00, /* 0011000100 */
	0x7b, 0x80, /* 0111101110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 253 0xfd '.' */
	0x00, 0x00, /* 0000000000 */
	0x1e, 0x00, /* 0001111000 */
	0x3f, 0x00, /* 0011111100 */
	0x63, 0x00, /* 0110001100 */
	0x43, 0x00, /* 0100001100 */
	0x06, 0x00, /* 0000011000 */
	0x0c, 0x00, /* 0000110000 */
	0x18, 0x00, /* 0001100000 */
	0x30, 0x80, /* 0011000010 */
	0x7f, 0x80, /* 0111111110 */
	0x7f, 0x80, /* 0111111110 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 254 0xfe '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x3f, 0x00, /* 0011111100 */
	0x3f, 0x00, /* 0011111100 */
	0x3f, 0x00, /* 0011111100 */
	0x3f, 0x00, /* 0011111100 */
	0x3f, 0x00, /* 0011111100 */
	0x3f, 0x00, /* 0011111100 */
	0x3f, 0x00, /* 0011111100 */
	0x3f, 0x00, /* 0011111100 */
	0x3f, 0x00, /* 0011111100 */
	0x3f, 0x00, /* 0011111100 */
	0x3f, 0x00, /* 0011111100 */
	0x3f, 0x00, /* 0011111100 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */

	/* 255 0xff '.' */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
	0x00, 0x00, /* 0000000000 */
} };


const struct font_desc font_10x18 = {
	.idx	= FONT10x18_IDX,
	.name	= "10x18",
	.width	= 10,
	.height	= 18,
	.data	= fontdata_10x18.data,
#ifdef __sparc__
	.pref	= 5,
#else
	.pref	= -1,
#endif
};
