/*
 * Hardware definitions for TI OMAP1510 processor.
 *
 * Cleanup for Linux-2.6 by Dirk Behme <dirk.behme@de.bosch.com>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * You should have received a copy of the  GNU General Public License along
 * with this program; if not, write  to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __ASM_ARCH_OMAP15XX_H
#define __ASM_ARCH_OMAP15XX_H

/*
 * ----------------------------------------------------------------------------
 * Base addresses
 * ----------------------------------------------------------------------------
 */

/* Syntax: XX_BASE = Virtual base address, XX_START = Physical base address */

#define OMAP1510_DSP_BASE	0xE0000000
#define OMAP1510_DSP_SIZE	0x28000
#define OMAP1510_DSP_START	0xE0000000

#define OMAP1510_DSPREG_BASE	0xE1000000
#define OMAP1510_DSPREG_SIZE	SZ_128K
#define OMAP1510_DSPREG_START	0xE1000000

#define OMAP1510_DSP_MMU_BASE	(0xfffed200)

/*
 * ---------------------------------------------------------------------------
 *  OMAP-1510 FPGA
 * ---------------------------------------------------------------------------
 */
#define OMAP1510_FPGA_BASE		0xE8000000		/* VA */
#define OMAP1510_FPGA_SIZE		SZ_4K
#define OMAP1510_FPGA_START		0x08000000		/* PA */

/* Revision */
#define OMAP1510_FPGA_REV_LOW			IOMEM(OMAP1510_FPGA_BASE + 0x0)
#define OMAP1510_FPGA_REV_HIGH			IOMEM(OMAP1510_FPGA_BASE + 0x1)
#define OMAP1510_FPGA_LCD_PANEL_CONTROL		IOMEM(OMAP1510_FPGA_BASE + 0x2)
#define OMAP1510_FPGA_LED_DIGIT			IOMEM(OMAP1510_FPGA_BASE + 0x3)
#define INNOVATOR_FPGA_HID_SPI			IOMEM(OMAP1510_FPGA_BASE + 0x4)
#define OMAP1510_FPGA_POWER			IOMEM(OMAP1510_FPGA_BASE + 0x5)

/* Interrupt status */
#define OMAP1510_FPGA_ISR_LO			IOMEM(OMAP1510_FPGA_BASE + 0x6)
#define OMAP1510_FPGA_ISR_HI			IOMEM(OMAP1510_FPGA_BASE + 0x7)

/* Interrupt mask */
#define OMAP1510_FPGA_IMR_LO			IOMEM(OMAP1510_FPGA_BASE + 0x8)
#define OMAP1510_FPGA_IMR_HI			IOMEM(OMAP1510_FPGA_BASE + 0x9)

/* Reset registers */
#define OMAP1510_FPGA_HOST_RESET		IOMEM(OMAP1510_FPGA_BASE + 0xa)
#define OMAP1510_FPGA_RST			IOMEM(OMAP1510_FPGA_BASE + 0xb)

#define OMAP1510_FPGA_AUDIO			IOMEM(OMAP1510_FPGA_BASE + 0xc)
#define OMAP1510_FPGA_DIP			IOMEM(OMAP1510_FPGA_BASE + 0xe)
#define OMAP1510_FPGA_FPGA_IO			IOMEM(OMAP1510_FPGA_BASE + 0xf)
#define OMAP1510_FPGA_UART1			IOMEM(OMAP1510_FPGA_BASE + 0x14)
#define OMAP1510_FPGA_UART2			IOMEM(OMAP1510_FPGA_BASE + 0x15)
#define OMAP1510_FPGA_OMAP1510_STATUS		IOMEM(OMAP1510_FPGA_BASE + 0x16)
#define OMAP1510_FPGA_BOARD_REV			IOMEM(OMAP1510_FPGA_BASE + 0x18)
#define INNOVATOR_FPGA_CAM_USB_CONTROL		IOMEM(OMAP1510_FPGA_BASE + 0x20c)
#define OMAP1510P1_PPT_DATA			IOMEM(OMAP1510_FPGA_BASE + 0x100)
#define OMAP1510P1_PPT_STATUS			IOMEM(OMAP1510_FPGA_BASE + 0x101)
#define OMAP1510P1_PPT_CONTROL			IOMEM(OMAP1510_FPGA_BASE + 0x102)

#define OMAP1510_FPGA_TOUCHSCREEN		IOMEM(OMAP1510_FPGA_BASE + 0x204)

#define INNOVATOR_FPGA_INFO			IOMEM(OMAP1510_FPGA_BASE + 0x205)
#define INNOVATOR_FPGA_LCD_BRIGHT_LO		IOMEM(OMAP1510_FPGA_BASE + 0x206)
#define INNOVATOR_FPGA_LCD_BRIGHT_HI		IOMEM(OMAP1510_FPGA_BASE + 0x207)
#define INNOVATOR_FPGA_LED_GRN_LO		IOMEM(OMAP1510_FPGA_BASE + 0x208)
#define INNOVATOR_FPGA_LED_GRN_HI		IOMEM(OMAP1510_FPGA_BASE + 0x209)
#define INNOVATOR_FPGA_LED_RED_LO		IOMEM(OMAP1510_FPGA_BASE + 0x20a)
#define INNOVATOR_FPGA_LED_RED_HI		IOMEM(OMAP1510_FPGA_BASE + 0x20b)
#define INNOVATOR_FPGA_EXP_CONTROL		IOMEM(OMAP1510_FPGA_BASE + 0x20d)
#define INNOVATOR_FPGA_ISR2			IOMEM(OMAP1510_FPGA_BASE + 0x20e)
#define INNOVATOR_FPGA_IMR2			IOMEM(OMAP1510_FPGA_BASE + 0x210)

#define OMAP1510_FPGA_ETHR_START		(OMAP1510_FPGA_START + 0x300)

/*
 * Power up Giga UART driver, turn on HID clock.
 * Turn off BT power, since we're not using it and it
 * draws power.
 */
#define OMAP1510_FPGA_RESET_VALUE		0x42

#define OMAP1510_FPGA_PCR_IF_PD0		(1 << 7)
#define OMAP1510_FPGA_PCR_COM2_EN		(1 << 6)
#define OMAP1510_FPGA_PCR_COM1_EN		(1 << 5)
#define OMAP1510_FPGA_PCR_EXP_PD0		(1 << 4)
#define OMAP1510_FPGA_PCR_EXP_PD1		(1 << 3)
#define OMAP1510_FPGA_PCR_48MHZ_CLK		(1 << 2)
#define OMAP1510_FPGA_PCR_4MHZ_CLK		(1 << 1)
#define OMAP1510_FPGA_PCR_RSRVD_BIT0		(1 << 0)

/*
 * Innovator/OMAP1510 FPGA HID register bit definitions
 */
#define OMAP1510_FPGA_HID_SCLK	(1<<0)	/* output */
#define OMAP1510_FPGA_HID_MOSI	(1<<1)	/* output */
#define OMAP1510_FPGA_HID_nSS	(1<<2)	/* output 0/1 chip idle/select */
#define OMAP1510_FPGA_HID_nHSUS	(1<<3)	/* output 0/1 host active/suspended */
#define OMAP1510_FPGA_HID_MISO	(1<<4)	/* input */
#define OMAP1510_FPGA_HID_ATN	(1<<5)	/* input  0/1 chip idle/ATN */
#define OMAP1510_FPGA_HID_rsrvd	(1<<6)
#define OMAP1510_FPGA_HID_RESETn (1<<7)	/* output - 0/1 USAR reset/run */

/* The FPGA IRQ is cascaded through GPIO_13 */
#define OMAP1510_INT_FPGA		(IH_GPIO_BASE + 13)

/* IRQ Numbers for interrupts muxed through the FPGA */
#define OMAP1510_INT_FPGA_ATN		(OMAP_FPGA_IRQ_BASE + 0)
#define OMAP1510_INT_FPGA_ACK		(OMAP_FPGA_IRQ_BASE + 1)
#define OMAP1510_INT_FPGA2		(OMAP_FPGA_IRQ_BASE + 2)
#define OMAP1510_INT_FPGA3		(OMAP_FPGA_IRQ_BASE + 3)
#define OMAP1510_INT_FPGA4		(OMAP_FPGA_IRQ_BASE + 4)
#define OMAP1510_INT_FPGA5		(OMAP_FPGA_IRQ_BASE + 5)
#define OMAP1510_INT_FPGA6		(OMAP_FPGA_IRQ_BASE + 6)
#define OMAP1510_INT_FPGA7		(OMAP_FPGA_IRQ_BASE + 7)
#define OMAP1510_INT_FPGA8		(OMAP_FPGA_IRQ_BASE + 8)
#define OMAP1510_INT_FPGA9		(OMAP_FPGA_IRQ_BASE + 9)
#define OMAP1510_INT_FPGA10		(OMAP_FPGA_IRQ_BASE + 10)
#define OMAP1510_INT_FPGA11		(OMAP_FPGA_IRQ_BASE + 11)
#define OMAP1510_INT_FPGA12		(OMAP_FPGA_IRQ_BASE + 12)
#define OMAP1510_INT_ETHER		(OMAP_FPGA_IRQ_BASE + 13)
#define OMAP1510_INT_FPGAUART1		(OMAP_FPGA_IRQ_BASE + 14)
#define OMAP1510_INT_FPGAUART2		(OMAP_FPGA_IRQ_BASE + 15)
#define OMAP1510_INT_FPGA_TS		(OMAP_FPGA_IRQ_BASE + 16)
#define OMAP1510_INT_FPGA17		(OMAP_FPGA_IRQ_BASE + 17)
#define OMAP1510_INT_FPGA_CAM		(OMAP_FPGA_IRQ_BASE + 18)
#define OMAP1510_INT_FPGA_RTC_A		(OMAP_FPGA_IRQ_BASE + 19)
#define OMAP1510_INT_FPGA_RTC_B		(OMAP_FPGA_IRQ_BASE + 20)
#define OMAP1510_INT_FPGA_CD		(OMAP_FPGA_IRQ_BASE + 21)
#define OMAP1510_INT_FPGA22		(OMAP_FPGA_IRQ_BASE + 22)
#define OMAP1510_INT_FPGA23		(OMAP_FPGA_IRQ_BASE + 23)

#endif /*  __ASM_ARCH_OMAP15XX_H */

