/*############################################################################*/
/*#                                                                          #*/
/*#  Convex hulls of the loudspeaker layouts used in the point source panner #*/
/*#                                                                          #*/
/*#  Copyright © 2025 Peter Stitt                                            #*/
/*#                                                                          #*/
/*#  Filename:      LoudspeakerLayoutHulls.h                                 #*/
/*#  Version:       0.1                                                      #*/
/*#  Date:          10/09/2025                                               #*/
/*#  Author(s):     Peter Stitt                                              #*/
/*#  Licence:       LGPL + proprietary                                       #*/
/*#                                                                          #*/
/*############################################################################*/

#ifndef SPATIALAUDIO_LOUDSPEAKER_LAYOUT_HULLS_H
#define SPATIALAUDIO_LOUDSPEAKER_LAYOUT_HULLS_H

#include <vector>

namespace spaudio {

    /*
        Presets of supported output layouts used in the point source panner
    */
    // 0 = FL, 1 = FR, 2 = BL, 3 = BR
    const std::vector<std::vector<unsigned int>> HULL_0_4_0 = {
    {4, 12, 6},{6, 12, 7},{8, 10, 13},{10, 11, 13},
    {4, 5, 12},{5, 7, 12},{8, 13, 9},{9, 13, 11},
    {0, 4, 6, 2},{2, 6, 7, 3},{0, 2, 10, 8},{2, 3, 11, 10},
    {0, 1, 5, 4},{1, 3, 7, 5},{0, 8, 9, 1},{1, 9, 11, 3} };

    const std::vector<std::vector<unsigned int>> HULL_0_5_0 = {
    {5, 15, 8},{8, 15, 9},{5, 7, 15},{10, 13, 16},
    {11, 16, 14},{13, 14, 16},{10, 16, 12},{11, 12, 16},
    {6, 9, 15},{6, 15, 7},{3, 8, 9, 4},{0, 2, 7, 5},
    {0, 5, 8, 3},{0, 3, 13, 10},{3, 4, 14, 13},{0, 10, 12, 2},
    {1, 11, 14, 4},{1, 4, 9, 6},{1, 2, 12, 11},{1, 6, 7, 2} };

    const std::vector<std::vector<unsigned int>> HULL_2_5_0 = {
    {2, 5, 6},{5, 15, 6},{7, 14, 10},{10, 14, 11},
    {7, 9, 14},{5, 12, 15},{0, 5, 2},{6, 15, 13},
    {12, 13, 15},{8, 11, 14},{8, 14, 9},{1, 2, 6},
    {3, 10, 11, 4},{0, 2, 9, 7},{0, 7, 10, 3},{0, 3, 12, 5},
    {3, 4, 13, 12},{1, 6, 13, 4},{1, 4, 11, 8},{1, 8, 9, 2} };

    const std::vector<std::vector<unsigned int>> HULL_4_5_0 = {
    {2, 5, 6},{5, 15, 6},{9, 14, 12},{12, 14, 13},
    {9, 11, 14},{5, 7, 15},{0, 5, 2},{6, 15, 8},
    {7, 8, 15},{10, 13, 14},{10, 14, 11},{1, 2, 6},
    {3, 12, 13, 4},{0, 2, 11, 9},{0, 9, 12, 3},{0, 3, 7, 5},
    {3, 4, 8, 7},{1, 6, 8, 4},{1, 4, 13, 10},{1, 10, 11, 2} };

    const std::vector<std::vector<unsigned int>> HULL_4_5_1 = {
    {0, 10, 3},{10, 12, 11},{0, 2, 9},{9, 11, 12},
    {9, 12, 10},{0, 9, 10},{6, 13, 8},{7, 8, 13},
    {5, 13, 6},{5, 7, 13},{0, 5, 2},{2, 5, 6},
    {1, 11, 9},{1, 4, 11},{1, 2, 6},{1, 9, 2},
    {3, 10, 11, 4},{3, 4, 8, 7},{0, 3, 7, 5},{1, 6, 8, 4} };

    const std::vector<std::vector<unsigned int>> HULL_3_7_0 = {
    {4, 9, 6},{0, 3, 4},{3, 5, 9},{3, 9, 4},
    {6, 9, 8},{15, 17, 16},{2, 4, 6},{0, 4, 2},
    {14, 16, 17},{12, 14, 17},{10, 12, 17},{10, 17, 11},
    {1, 5, 3},{0, 1, 3},{11, 17, 13},{13, 17, 15},
    {5, 7, 9},{7, 8, 9},{6, 8, 16, 14},{2, 6, 14, 12},
    {0, 2, 12, 10},{0, 10, 11, 1},{1, 11, 13, 5},{5, 13, 15, 7},
    {7, 15, 16, 8} };

    const std::vector<std::vector<unsigned int>> HULL_4_9_0 = {
    {16, 22, 18},{18, 22, 19},{2, 7, 8},{7, 23, 8},
    {7, 9, 23},{4, 8, 10},{8, 23, 10},{9, 10, 23},
    {14, 17, 22},{17, 19, 22},{13, 22, 16},{1, 8, 4},
    {3, 9, 7},{3, 5, 9},{4, 10, 6},{0, 3, 7},
    {2, 8, 12},{1, 12, 8},{14, 22, 21},{15, 21, 22},
    {2, 11, 7},{0, 7, 11},{13, 20, 22},{15, 22, 20},
    {1, 4, 17, 14},{3, 16, 18, 5},{4, 6, 19, 17},{5, 18, 19, 6},
    {5, 6, 10, 9},{0, 13, 16, 3},{1, 14, 21, 12},{2, 12, 21, 15},
    {0, 11, 20, 13},{2, 15, 20, 11} };

    const std::vector<std::vector<unsigned int>> HULL_4_9_0_wide = {
    {16, 22, 18},{18, 22, 19},{4, 8, 10},{8, 23, 10},
    {9, 10, 23},{17, 19, 22},{17, 22, 21},{4, 12, 8},
    {16, 20, 22},{13, 22, 20},{13, 15, 22},{4, 10, 6},
    {3, 5, 9},{1, 2, 8},{1, 8, 12},{2, 7, 8},
    {7, 23, 8},{3, 7, 11},{7, 9, 23},{3, 9, 7},
    {14, 21, 22},{14, 22, 15},{0, 7, 2},{0, 11, 7},
    {4, 17, 21, 12},{4, 6, 19, 17},{5, 18, 19, 6},{5, 6, 10, 9},
    {3, 16, 18, 5},{3, 11, 20, 16},{1, 12, 21, 14},{1, 14, 15, 2},
    {0, 2, 15, 13},{0, 13, 20, 11} };

    const std::vector<std::vector<unsigned int>> HULL_4_9_0_wideL = {
    {16, 22, 18},{18, 22, 19},{2, 7, 8},{7, 23, 8},
    {7, 9, 23},{4, 8, 10},{8, 23, 10},{9, 10, 23},
    {14, 17, 22},{17, 19, 22},{1, 8, 4},{3, 9, 7},
    {3, 5, 9},{4, 10, 6},{13, 15, 22},{0, 7, 2},
    {2, 8, 12},{1, 12, 8},{14, 22, 21},{15, 21, 22},
    {3, 7, 11},{0, 11, 7},{16, 20, 22},{13, 22, 20},
    {1, 4, 17, 14},{3, 16, 18, 5},{4, 6, 19, 17},{5, 18, 19, 6},
    {5, 6, 10, 9},{0, 2, 15, 13},{1, 14, 21, 12},{2, 12, 21, 15},
    {3, 11, 20, 16},{0, 13, 20, 11} };

    const std::vector<std::vector<unsigned int>> HULL_4_9_0_wideR = {
    {16, 22, 18},{18, 22, 19},{13, 22, 16},{4, 8, 10},
    {8, 23, 10},{9, 10, 23},{17, 19, 22},{17, 22, 21},
    {4, 12, 8},{2, 7, 8},{7, 23, 8},{7, 9, 23},
    {4, 10, 6},{13, 20, 22},{15, 22, 20},{14, 21, 22},
    {14, 22, 15},{3, 9, 7},{3, 5, 9},{0, 3, 7},
    {1, 2, 8},{1, 8, 12},{2, 11, 7},{0, 7, 11},
    {4, 17, 21, 12},{4, 6, 19, 17},{5, 18, 19, 6},{5, 6, 10, 9},
    {3, 16, 18, 5},{0, 13, 16, 3},{1, 14, 15, 2},{1, 12, 21, 14},
    {2, 15, 20, 11},{0, 11, 20, 13} };

    const std::vector<std::vector<unsigned int>> HULL_9_10_3 = {
    {23, 24, 27},{19, 21, 27},{23, 27, 26},{21, 26, 27},
    {13, 18, 15},{11, 12, 13},{2, 6, 19},{6, 21, 19},
    {2, 12, 6},{6, 12, 11},{13, 15, 17},{11, 13, 17},
    {22, 27, 24},{19, 27, 20},{13, 14, 18},{10, 13, 12},
    {1, 21, 6},{1, 9, 26},{1, 26, 21},{1, 6, 11},
    {1, 17, 9},{1, 11, 17},{22, 25, 27},{20, 27, 25},
    {13, 16, 14},{10, 16, 13},{0, 25, 8},{0, 20, 25},
    {0, 8, 16},{0, 16, 10},{0, 5, 20},{2, 19, 5},
    {5, 19, 20},{0, 10, 5},{2, 5, 12},{5, 10, 12},
    {4, 7, 24, 23},{4, 15, 18, 7},{4, 23, 26, 9},{4, 9, 17, 15},
    {3, 8, 25, 22},{3, 22, 24, 7},{3, 7, 18, 14},{3, 14, 16, 8} };

    const std::vector<std::vector<unsigned int>> HULL_0_7_0 = {
    {10, 21, 12},{12, 21, 13},{17, 19, 22},{19, 20, 22},
    {8, 11, 21},{11, 13, 21},{7, 21, 10},{15, 16, 22},
    {15, 22, 18},{18, 22, 20},{8, 21, 9},{7, 9, 21},
    {14, 17, 22},{14, 22, 16},{1, 4, 11, 8},{1, 2, 16, 15},
    {4, 6, 13, 11},{5, 12, 13, 6},{5, 6, 20, 19},{1, 15, 18, 4},
    {4, 18, 20, 6},{1, 8, 9, 2},{3, 10, 12, 5},{3, 5, 19, 17},
    {0, 7, 10, 3},{0, 2, 9, 7},{0, 3, 17, 14},{0, 14, 16, 2} };

    const std::vector<std::vector<unsigned int>> HULL_4_7_0 = {
    {14, 18, 16},{16, 18, 17},{2, 7, 8},{7, 19, 8},
    {7, 9, 19},{4, 8, 10},{8, 19, 10},{9, 10, 19},
    {12, 15, 18},{15, 17, 18},{11, 18, 14},{1, 2, 8},
    {1, 8, 4},{3, 9, 7},{3, 5, 9},{4, 10, 6},
    {12, 18, 13},{11, 13, 18},{0, 7, 2},{0, 3, 7},
    {1, 4, 15, 12},{3, 14, 16, 5},{4, 6, 17, 15},{5, 16, 17, 6},
    {5, 6, 10, 9},{1, 12, 13, 2},{0, 2, 13, 11},{0, 11, 14, 3} };

    const std::vector<std::vector<unsigned int>> HULL_2_7_0 = {
    {12, 20, 14},{14, 20, 15},{2, 7, 8},{7, 21, 8},
    {18, 19, 21},{10, 13, 20},{13, 15, 20},{9, 20, 12},
    {1, 2, 8},{1, 8, 4},{8, 21, 17},{17, 21, 19},
    {4, 8, 17},{10, 20, 11},{9, 11, 20},{0, 7, 2},
    {0, 3, 7},{3, 16, 7},{16, 18, 21},{7, 16, 21},
    {1, 4, 13, 10},{3, 12, 14, 5},{4, 6, 15, 13},{5, 14, 15, 6},
    {5, 6, 19, 18},{4, 17, 19, 6},{1, 10, 11, 2},{0, 2, 11, 9},
    {0, 9, 12, 3},{3, 5, 18, 16} };

    const std::vector<std::vector<unsigned int>> HULL_9_10_5 = {
    {9, 23, 21},{21, 23, 25},{23, 24, 25},{19, 21, 25},
    {13, 18, 15},{4, 23, 9},{11, 12, 13},{2, 6, 19},
    {6, 21, 19},{2, 12, 6},{6, 12, 11},{13, 15, 17},
    {11, 13, 17},{22, 25, 24},{19, 25, 20},{20, 25, 22},
    {8, 20, 22},{13, 14, 18},{10, 13, 12},{1, 9, 21},
    {1, 21, 6},{1, 6, 11},{1, 17, 9},{1, 11, 17},
    {3, 8, 22},{13, 16, 14},{10, 16, 13},{0, 20, 8},
    {0, 8, 16},{0, 16, 10},{0, 5, 20},{2, 19, 5},
    {5, 19, 20},{0, 10, 5},{2, 5, 12},{5, 10, 12},
    {4, 7, 24, 23},{4, 15, 18, 7},{4, 9, 17, 15},{3, 22, 24, 7},
    {3, 7, 18, 14},{3, 14, 16, 8} };

}

#endif // SPATIALAUDIO_LOUDSPEAKER_LAYOUT_HULLS_H
