#-*- coding: utf-8 -*-

# Copyright 2014 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import os, glob, sys
from os import path
import time, datetime
import pickle
from calculate.core.datavars import DataVarsCore
from calculate.lib.cl_lang import setLocalTranslate
from calculate.core.server.gen_pid import (search_worked_process,
    get_pid_info,
    ProcessMode)
import logging
setLocalTranslate('cl_core3',sys.modules[__name__])

def restart():
    """
    Функция отслеживает необходимость перезапуска демона и
    перезапускает init.d/calculate-core
    """
    def check_running(ob):
        return any(pid for pid in get_pid_info(ob)
                    if (pid.get("mode",'') == ProcessMode.CoreDaemon))
#    cert_live = 10080
    # Get value of period and lifetime session from DataVars
    ob = DataVarsCore()
    ob.importCore()

    if not ob.flIniFile():
        return

    restart_file = ob.Get('cl_core_restart_path')
    service_name = "calculate-core"
    if path.exists(restart_file):
        os.unlink(restart_file)
    logger = logging.getLogger('soaplib.wsgi')

    while True:
        if path.exists(restart_file) and not check_running(ob):
            # Частота проверки
            os.system('/etc/init.d/%s restart &>/dev/null &'%service_name)
            return
        if check_running(ob):
            logger.warn(str([pid for pid in get_pid_info(ob)
                    if (pid.get("mode",'') == ProcessMode.CoreDaemon)]))
        time.sleep(1)
