#-*- coding: utf-8 -*-

# Copyright 2013 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import sys
from calculate.core.server.func import Action,Tasks
from calculate.lib.cl_lang import setLocalTranslate,getLazyLocalTranslate
from calculate.lib.datavars import VariableError
from calculate.lib.cl_template import TemplatesError
from calculate.lib.utils.files import FilesError

setLocalTranslate('cl_install3',sys.modules[__name__])
__ = getLazyLocalTranslate(_)

class ClCoreCustomAction(Action):
    """
    Действие для настройки параметров видео
    """
    # ошибки, которые отображаются без подробностей
    native_error = (FilesError, TemplatesError,VariableError)

    successMessage = __("Action successfully completed!")
    failedMessage = __("Failed to perform action!")
    interruptMessage = __("Action manually interrupted")

    def __init__(self):
        # список задач для дейсвия
        self.tasks = [
         {'name':'apply_templates',
          # наложить шаблоны на текущий дистрибутив, включая clt шаблоны
          # без использования фильтров по clt шаблонам
          'method':'UpdateConfigs.applyTemplates(None,False,'\
                   'None,None)',
          },
          {'name':'failed_action',
           'error':__("Action {ac_custom_name} not found"),
           'condition':lambda Get:not filter(
                lambda x:x and x[0] == 'ac_custom_name' and \
                         x[1] == Get('ac_custom_name'),
                Get('cl_used_action'))
          }
          ]

        Action.__init__(self)
