#-*- coding: utf-8 -*-

# Copyright 2010 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import sys
from calculate.core.server.func import Action
from calculate.lib.cl_lang import setLocalTranslate, getLazyLocalTranslate
from calculate.lib.utils.files import FilesError
from calculate.lib.datavars import VariableError, DataVarsError
from calculate.lib.cl_template import TemplatesError

setLocalTranslate('cl_core3', sys.modules[__name__])
__ = getLazyLocalTranslate(_)

class ClCoreSetupAction(Action):
    """
    Действие настройка пакета для пользователя и системы
    """
    # ошибки, которые отображаются без подробностей
    native_error = (FilesError,TemplatesError,VariableError,DataVarsError)
    templateTaskMessage = __("System are being configured")
    successMessage = __("System configured!")
    failedMessage = __("Failed to configure the system!")
    interruptMessage = __("Configuration manually interrupted")

    tasks = [
         {'name':'system_rm_package',
          # наложить шаблоны удаления пакета
          'method':'UpdateConfigs.updateSystemConfig(cl_core_pkg_name,'
                        '"",cl_core_pkg_slot,cl_core_pkg_category,cl_core_pkg_path,'
                        'cl_core_pkg_root_set,cl_verbose_set,cl_dispatch_conf,'
                        'cl_template_path_use,cl_ebuild_phase,'
                        'cl_template_clt_set)',
          'condition':lambda dv:(dv.Get('cl_core_pkg_system_set') == 'on' and
                         dv.Get('cl_ebuild_phase') in ('prerm','postrm'))
         },
         {'name':'system_setup_package',
          # наложить шаблоны настройки пакета
          'method':'UpdateConfigs.updateSystemConfig(cl_core_pkg_name,'
                        'cl_core_pkg_version,cl_core_pkg_slot,'
                        'cl_core_pkg_category,cl_core_pkg_path,'
                        'cl_core_pkg_root_set,cl_verbose_set,cl_dispatch_conf,'
                        'cl_template_path_use,cl_ebuild_phase,'
                        'cl_template_clt_set)',
          'condition':lambda dv:(dv.Get('cl_core_pkg_system_set') == 'on' and
                         not dv.Get('cl_ebuild_phase') in ('prerm','postrm'))
         },
         {'name':'user_setup_package',
          # наложить шаблоны настройки пакета
          'method':'UpdateConfigs.updateDesktopConfig(cl_core_pkg_name,'
                        'cl_core_pkg_version,cl_core_pkg_slot,'
                        'cl_core_pkg_category,cl_core_pkg_path,'
                        'cl_core_pkg_root_set,cl_verbose_set,cl_dispatch_conf,'
                        'cl_template_path_use,cl_ebuild_phase,'
                        'cl_template_clt_set)',
          'condition':lambda dv:(dv.Get('cl_core_pkg_desktop_set') == 'on' and
                        not dv.Get('cl_ebuild_phase') in ("preinst","prerm"))
          }
         ]
