/*
 * Copyright (C) 2017  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef _dce_12_0_OFFSET_HEADER
#define _dce_12_0_OFFSET_HEADER



// addressBlock: dce_dc_dispdec_VGA_MEM_WRITE_PAGE_ADDR
// base address: 0x48
#define mmdispdec_VGA_MEM_WRITE_PAGE_ADDR                                                              0x0012
#define mmdispdec_VGA_MEM_WRITE_PAGE_ADDR_BASE_IDX                                                     0


// addressBlock: dce_dc_dispdec_VGA_MEM_READ_PAGE_ADDR
// base address: 0x4c
#define mmdispdec_VGA_MEM_READ_PAGE_ADDR                                                               0x0014
#define mmdispdec_VGA_MEM_READ_PAGE_ADDR_BASE_IDX                                                      0


// addressBlock: dce_dc_dc_perfmon0_dispdec
// base address: 0x0
#define mmDC_PERFMON0_PERFCOUNTER_CNTL                                                                 0x0020
#define mmDC_PERFMON0_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON0_PERFCOUNTER_CNTL2                                                                0x0021
#define mmDC_PERFMON0_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON0_PERFCOUNTER_STATE                                                                0x0022
#define mmDC_PERFMON0_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON0_PERFMON_CNTL                                                                     0x0023
#define mmDC_PERFMON0_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON0_PERFMON_CNTL2                                                                    0x0024
#define mmDC_PERFMON0_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON0_PERFMON_CVALUE_INT_MISC                                                          0x0025
#define mmDC_PERFMON0_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON0_PERFMON_CVALUE_LOW                                                               0x0026
#define mmDC_PERFMON0_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON0_PERFMON_HI                                                                       0x0027
#define mmDC_PERFMON0_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON0_PERFMON_LOW                                                                      0x0028
#define mmDC_PERFMON0_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dc_perfmon13_dispdec
// base address: 0x30
#define mmDC_PERFMON13_PERFCOUNTER_CNTL                                                                0x002c
#define mmDC_PERFMON13_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define mmDC_PERFMON13_PERFCOUNTER_CNTL2                                                               0x002d
#define mmDC_PERFMON13_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define mmDC_PERFMON13_PERFCOUNTER_STATE                                                               0x002e
#define mmDC_PERFMON13_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define mmDC_PERFMON13_PERFMON_CNTL                                                                    0x002f
#define mmDC_PERFMON13_PERFMON_CNTL_BASE_IDX                                                           2
#define mmDC_PERFMON13_PERFMON_CNTL2                                                                   0x0030
#define mmDC_PERFMON13_PERFMON_CNTL2_BASE_IDX                                                          2
#define mmDC_PERFMON13_PERFMON_CVALUE_INT_MISC                                                         0x0031
#define mmDC_PERFMON13_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define mmDC_PERFMON13_PERFMON_CVALUE_LOW                                                              0x0032
#define mmDC_PERFMON13_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define mmDC_PERFMON13_PERFMON_HI                                                                      0x0033
#define mmDC_PERFMON13_PERFMON_HI_BASE_IDX                                                             2
#define mmDC_PERFMON13_PERFMON_LOW                                                                     0x0034
#define mmDC_PERFMON13_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_dc_displaypllregs_dispdec
// base address: 0x0
#define mmPPLL_VREG_CFG                                                                                0x0038
#define mmPPLL_VREG_CFG_BASE_IDX                                                                       2
#define mmPPLL_MODE_CNTL                                                                               0x0039
#define mmPPLL_MODE_CNTL_BASE_IDX                                                                      2
#define mmPPLL_FREQ_CTRL0                                                                              0x003a
#define mmPPLL_FREQ_CTRL0_BASE_IDX                                                                     2
#define mmPPLL_FREQ_CTRL1                                                                              0x003b
#define mmPPLL_FREQ_CTRL1_BASE_IDX                                                                     2
#define mmPPLL_FREQ_CTRL2                                                                              0x003c
#define mmPPLL_FREQ_CTRL2_BASE_IDX                                                                     2
#define mmPPLL_FREQ_CTRL3                                                                              0x003d
#define mmPPLL_FREQ_CTRL3_BASE_IDX                                                                     2
#define mmPPLL_BW_CTRL_COARSE                                                                          0x003e
#define mmPPLL_BW_CTRL_COARSE_BASE_IDX                                                                 2
#define mmPPLL_BW_CTRL_FINE                                                                            0x0040
#define mmPPLL_BW_CTRL_FINE_BASE_IDX                                                                   2
#define mmPPLL_CAL_CTRL                                                                                0x0041
#define mmPPLL_CAL_CTRL_BASE_IDX                                                                       2
#define mmPPLL_LOOP_CTRL                                                                               0x0042
#define mmPPLL_LOOP_CTRL_BASE_IDX                                                                      2
#define mmPPLL_REFCLK_CNTL                                                                             0x0050
#define mmPPLL_REFCLK_CNTL_BASE_IDX                                                                    2
#define mmPPLL_CLKOUT_CNTL                                                                             0x0051
#define mmPPLL_CLKOUT_CNTL_BASE_IDX                                                                    2
#define mmPPLL_DFT_CNTL                                                                                0x0052
#define mmPPLL_DFT_CNTL_BASE_IDX                                                                       2
#define mmPPLL_ANALOG_CNTL                                                                             0x0053
#define mmPPLL_ANALOG_CNTL_BASE_IDX                                                                    2
#define mmPPLL_POSTDIV                                                                                 0x0054
#define mmPPLL_POSTDIV_BASE_IDX                                                                        2
#define mmPPLL_OBSERVE0                                                                                0x0059
#define mmPPLL_OBSERVE0_BASE_IDX                                                                       2
#define mmPPLL_OBSERVE1                                                                                0x005a
#define mmPPLL_OBSERVE1_BASE_IDX                                                                       2
#define mmPPLL_UPDATE_CNTL                                                                             0x005c
#define mmPPLL_UPDATE_CNTL_BASE_IDX                                                                    2
#define mmPPLL_OBSERVE0_OUT                                                                            0x005d
#define mmPPLL_OBSERVE0_OUT_BASE_IDX                                                                   2


// addressBlock: dce_dc_dccg_pll0_dispdec
// base address: 0x0
#define mmPLL_MACRO_CNTL_RESERVED0                                                                     0x0038
#define mmPLL_MACRO_CNTL_RESERVED0_BASE_IDX                                                            2
#define mmPLL_MACRO_CNTL_RESERVED1                                                                     0x0039
#define mmPLL_MACRO_CNTL_RESERVED1_BASE_IDX                                                            2
#define mmPLL_MACRO_CNTL_RESERVED2                                                                     0x003a
#define mmPLL_MACRO_CNTL_RESERVED2_BASE_IDX                                                            2
#define mmPLL_MACRO_CNTL_RESERVED3                                                                     0x003b
#define mmPLL_MACRO_CNTL_RESERVED3_BASE_IDX                                                            2
#define mmPLL_MACRO_CNTL_RESERVED4                                                                     0x003c
#define mmPLL_MACRO_CNTL_RESERVED4_BASE_IDX                                                            2
#define mmPLL_MACRO_CNTL_RESERVED5                                                                     0x003d
#define mmPLL_MACRO_CNTL_RESERVED5_BASE_IDX                                                            2
#define mmPLL_MACRO_CNTL_RESERVED6                                                                     0x003e
#define mmPLL_MACRO_CNTL_RESERVED6_BASE_IDX                                                            2
#define mmPLL_MACRO_CNTL_RESERVED7                                                                     0x003f
#define mmPLL_MACRO_CNTL_RESERVED7_BASE_IDX                                                            2
#define mmPLL_MACRO_CNTL_RESERVED8                                                                     0x0040
#define mmPLL_MACRO_CNTL_RESERVED8_BASE_IDX                                                            2
#define mmPLL_MACRO_CNTL_RESERVED9                                                                     0x0041
#define mmPLL_MACRO_CNTL_RESERVED9_BASE_IDX                                                            2
#define mmPLL_MACRO_CNTL_RESERVED10                                                                    0x0042
#define mmPLL_MACRO_CNTL_RESERVED10_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED11                                                                    0x0043
#define mmPLL_MACRO_CNTL_RESERVED11_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED12                                                                    0x0044
#define mmPLL_MACRO_CNTL_RESERVED12_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED13                                                                    0x0045
#define mmPLL_MACRO_CNTL_RESERVED13_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED14                                                                    0x0046
#define mmPLL_MACRO_CNTL_RESERVED14_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED15                                                                    0x0047
#define mmPLL_MACRO_CNTL_RESERVED15_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED16                                                                    0x0048
#define mmPLL_MACRO_CNTL_RESERVED16_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED17                                                                    0x0049
#define mmPLL_MACRO_CNTL_RESERVED17_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED18                                                                    0x004a
#define mmPLL_MACRO_CNTL_RESERVED18_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED19                                                                    0x004b
#define mmPLL_MACRO_CNTL_RESERVED19_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED20                                                                    0x004c
#define mmPLL_MACRO_CNTL_RESERVED20_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED21                                                                    0x004d
#define mmPLL_MACRO_CNTL_RESERVED21_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED22                                                                    0x004e
#define mmPLL_MACRO_CNTL_RESERVED22_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED23                                                                    0x004f
#define mmPLL_MACRO_CNTL_RESERVED23_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED24                                                                    0x0050
#define mmPLL_MACRO_CNTL_RESERVED24_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED25                                                                    0x0051
#define mmPLL_MACRO_CNTL_RESERVED25_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED26                                                                    0x0052
#define mmPLL_MACRO_CNTL_RESERVED26_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED27                                                                    0x0053
#define mmPLL_MACRO_CNTL_RESERVED27_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED28                                                                    0x0054
#define mmPLL_MACRO_CNTL_RESERVED28_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED29                                                                    0x0055
#define mmPLL_MACRO_CNTL_RESERVED29_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED30                                                                    0x0056
#define mmPLL_MACRO_CNTL_RESERVED30_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED31                                                                    0x0057
#define mmPLL_MACRO_CNTL_RESERVED31_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED32                                                                    0x0058
#define mmPLL_MACRO_CNTL_RESERVED32_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED33                                                                    0x0059
#define mmPLL_MACRO_CNTL_RESERVED33_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED34                                                                    0x005a
#define mmPLL_MACRO_CNTL_RESERVED34_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED35                                                                    0x005b
#define mmPLL_MACRO_CNTL_RESERVED35_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED36                                                                    0x005c
#define mmPLL_MACRO_CNTL_RESERVED36_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED37                                                                    0x005d
#define mmPLL_MACRO_CNTL_RESERVED37_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED38                                                                    0x005e
#define mmPLL_MACRO_CNTL_RESERVED38_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED39                                                                    0x005f
#define mmPLL_MACRO_CNTL_RESERVED39_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED40                                                                    0x0060
#define mmPLL_MACRO_CNTL_RESERVED40_BASE_IDX                                                           2
#define mmPLL_MACRO_CNTL_RESERVED41                                                                    0x0061
#define mmPLL_MACRO_CNTL_RESERVED41_BASE_IDX                                                           2


// addressBlock: dce_dc_dc_perfmon1_dispdec
// base address: 0x598
#define mmDC_PERFMON1_PERFCOUNTER_CNTL                                                                 0x0186
#define mmDC_PERFMON1_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON1_PERFCOUNTER_CNTL2                                                                0x0187
#define mmDC_PERFMON1_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON1_PERFCOUNTER_STATE                                                                0x0188
#define mmDC_PERFMON1_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON1_PERFMON_CNTL                                                                     0x0189
#define mmDC_PERFMON1_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON1_PERFMON_CNTL2                                                                    0x018a
#define mmDC_PERFMON1_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON1_PERFMON_CVALUE_INT_MISC                                                          0x018b
#define mmDC_PERFMON1_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON1_PERFMON_CVALUE_LOW                                                               0x018c
#define mmDC_PERFMON1_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON1_PERFMON_HI                                                                       0x018d
#define mmDC_PERFMON1_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON1_PERFMON_LOW                                                                      0x018e
#define mmDC_PERFMON1_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_mcif_wb0_dispdec
// base address: 0x0
#define mmMCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL                                                           0x0272
#define mmMCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL_BASE_IDX                                                  2
#define mmMCIF_WB0_MCIF_WB_BUFMGR_CUR_LINE_R                                                           0x0273
#define mmMCIF_WB0_MCIF_WB_BUFMGR_CUR_LINE_R_BASE_IDX                                                  2
#define mmMCIF_WB0_MCIF_WB_BUFMGR_STATUS                                                               0x0274
#define mmMCIF_WB0_MCIF_WB_BUFMGR_STATUS_BASE_IDX                                                      2
#define mmMCIF_WB0_MCIF_WB_BUF_PITCH                                                                   0x0275
#define mmMCIF_WB0_MCIF_WB_BUF_PITCH_BASE_IDX                                                          2
#define mmMCIF_WB0_MCIF_WB_BUF_1_STATUS                                                                0x0276
#define mmMCIF_WB0_MCIF_WB_BUF_1_STATUS_BASE_IDX                                                       2
#define mmMCIF_WB0_MCIF_WB_BUF_1_STATUS2                                                               0x0277
#define mmMCIF_WB0_MCIF_WB_BUF_1_STATUS2_BASE_IDX                                                      2
#define mmMCIF_WB0_MCIF_WB_BUF_2_STATUS                                                                0x0278
#define mmMCIF_WB0_MCIF_WB_BUF_2_STATUS_BASE_IDX                                                       2
#define mmMCIF_WB0_MCIF_WB_BUF_2_STATUS2                                                               0x0279
#define mmMCIF_WB0_MCIF_WB_BUF_2_STATUS2_BASE_IDX                                                      2
#define mmMCIF_WB0_MCIF_WB_BUF_3_STATUS                                                                0x027a
#define mmMCIF_WB0_MCIF_WB_BUF_3_STATUS_BASE_IDX                                                       2
#define mmMCIF_WB0_MCIF_WB_BUF_3_STATUS2                                                               0x027b
#define mmMCIF_WB0_MCIF_WB_BUF_3_STATUS2_BASE_IDX                                                      2
#define mmMCIF_WB0_MCIF_WB_BUF_4_STATUS                                                                0x027c
#define mmMCIF_WB0_MCIF_WB_BUF_4_STATUS_BASE_IDX                                                       2
#define mmMCIF_WB0_MCIF_WB_BUF_4_STATUS2                                                               0x027d
#define mmMCIF_WB0_MCIF_WB_BUF_4_STATUS2_BASE_IDX                                                      2
#define mmMCIF_WB0_MCIF_WB_ARBITRATION_CONTROL                                                         0x027e
#define mmMCIF_WB0_MCIF_WB_ARBITRATION_CONTROL_BASE_IDX                                                2
#define mmMCIF_WB0_MCIF_WB_SCLK_CHANGE                                                                 0x027f
#define mmMCIF_WB0_MCIF_WB_SCLK_CHANGE_BASE_IDX                                                        2
#define mmMCIF_WB0_MCIF_WB_BUF_1_ADDR_Y                                                                0x0282
#define mmMCIF_WB0_MCIF_WB_BUF_1_ADDR_Y_BASE_IDX                                                       2
#define mmMCIF_WB0_MCIF_WB_BUF_1_ADDR_Y_OFFSET                                                         0x0283
#define mmMCIF_WB0_MCIF_WB_BUF_1_ADDR_Y_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB0_MCIF_WB_BUF_1_ADDR_C                                                                0x0284
#define mmMCIF_WB0_MCIF_WB_BUF_1_ADDR_C_BASE_IDX                                                       2
#define mmMCIF_WB0_MCIF_WB_BUF_1_ADDR_C_OFFSET                                                         0x0285
#define mmMCIF_WB0_MCIF_WB_BUF_1_ADDR_C_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB0_MCIF_WB_BUF_2_ADDR_Y                                                                0x0286
#define mmMCIF_WB0_MCIF_WB_BUF_2_ADDR_Y_BASE_IDX                                                       2
#define mmMCIF_WB0_MCIF_WB_BUF_2_ADDR_Y_OFFSET                                                         0x0287
#define mmMCIF_WB0_MCIF_WB_BUF_2_ADDR_Y_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB0_MCIF_WB_BUF_2_ADDR_C                                                                0x0288
#define mmMCIF_WB0_MCIF_WB_BUF_2_ADDR_C_BASE_IDX                                                       2
#define mmMCIF_WB0_MCIF_WB_BUF_2_ADDR_C_OFFSET                                                         0x0289
#define mmMCIF_WB0_MCIF_WB_BUF_2_ADDR_C_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB0_MCIF_WB_BUF_3_ADDR_Y                                                                0x028a
#define mmMCIF_WB0_MCIF_WB_BUF_3_ADDR_Y_BASE_IDX                                                       2
#define mmMCIF_WB0_MCIF_WB_BUF_3_ADDR_Y_OFFSET                                                         0x028b
#define mmMCIF_WB0_MCIF_WB_BUF_3_ADDR_Y_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB0_MCIF_WB_BUF_3_ADDR_C                                                                0x028c
#define mmMCIF_WB0_MCIF_WB_BUF_3_ADDR_C_BASE_IDX                                                       2
#define mmMCIF_WB0_MCIF_WB_BUF_3_ADDR_C_OFFSET                                                         0x028d
#define mmMCIF_WB0_MCIF_WB_BUF_3_ADDR_C_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB0_MCIF_WB_BUF_4_ADDR_Y                                                                0x028e
#define mmMCIF_WB0_MCIF_WB_BUF_4_ADDR_Y_BASE_IDX                                                       2
#define mmMCIF_WB0_MCIF_WB_BUF_4_ADDR_Y_OFFSET                                                         0x028f
#define mmMCIF_WB0_MCIF_WB_BUF_4_ADDR_Y_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB0_MCIF_WB_BUF_4_ADDR_C                                                                0x0290
#define mmMCIF_WB0_MCIF_WB_BUF_4_ADDR_C_BASE_IDX                                                       2
#define mmMCIF_WB0_MCIF_WB_BUF_4_ADDR_C_OFFSET                                                         0x0291
#define mmMCIF_WB0_MCIF_WB_BUF_4_ADDR_C_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL                                                          0x0292
#define mmMCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL_BASE_IDX                                                 2
#define mmMCIF_WB0_MCIF_WB_NB_PSTATE_LATENCY_WATERMARK                                                 0x0293
#define mmMCIF_WB0_MCIF_WB_NB_PSTATE_LATENCY_WATERMARK_BASE_IDX                                        2
#define mmMCIF_WB0_MCIF_WB_NB_PSTATE_CONTROL                                                           0x0294
#define mmMCIF_WB0_MCIF_WB_NB_PSTATE_CONTROL_BASE_IDX                                                  2
#define mmMCIF_WB0_MCIF_WB_WATERMARK                                                                   0x0295
#define mmMCIF_WB0_MCIF_WB_WATERMARK_BASE_IDX                                                          2
#define mmMCIF_WB0_MCIF_WB_CLOCK_GATER_CONTROL                                                         0x0296
#define mmMCIF_WB0_MCIF_WB_CLOCK_GATER_CONTROL_BASE_IDX                                                2
#define mmMCIF_WB0_MCIF_WB_WARM_UP_CNTL                                                                0x0297
#define mmMCIF_WB0_MCIF_WB_WARM_UP_CNTL_BASE_IDX                                                       2
#define mmMCIF_WB0_MCIF_WB_SELF_REFRESH_CONTROL                                                        0x0298
#define mmMCIF_WB0_MCIF_WB_SELF_REFRESH_CONTROL_BASE_IDX                                               2
#define mmMCIF_WB0_MULTI_LEVEL_QOS_CTRL                                                                0x0299
#define mmMCIF_WB0_MULTI_LEVEL_QOS_CTRL_BASE_IDX                                                       2
#define mmMCIF_WB0_MCIF_WB_BUF_LUMA_SIZE                                                               0x029b
#define mmMCIF_WB0_MCIF_WB_BUF_LUMA_SIZE_BASE_IDX                                                      2
#define mmMCIF_WB0_MCIF_WB_BUF_CHROMA_SIZE                                                             0x029c
#define mmMCIF_WB0_MCIF_WB_BUF_CHROMA_SIZE_BASE_IDX                                                    2


// addressBlock: dce_dc_mcif_wb1_dispdec
// base address: 0x100
#define mmMCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL                                                           0x02b2
#define mmMCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL_BASE_IDX                                                  2
#define mmMCIF_WB1_MCIF_WB_BUFMGR_CUR_LINE_R                                                           0x02b3
#define mmMCIF_WB1_MCIF_WB_BUFMGR_CUR_LINE_R_BASE_IDX                                                  2
#define mmMCIF_WB1_MCIF_WB_BUFMGR_STATUS                                                               0x02b4
#define mmMCIF_WB1_MCIF_WB_BUFMGR_STATUS_BASE_IDX                                                      2
#define mmMCIF_WB1_MCIF_WB_BUF_PITCH                                                                   0x02b5
#define mmMCIF_WB1_MCIF_WB_BUF_PITCH_BASE_IDX                                                          2
#define mmMCIF_WB1_MCIF_WB_BUF_1_STATUS                                                                0x02b6
#define mmMCIF_WB1_MCIF_WB_BUF_1_STATUS_BASE_IDX                                                       2
#define mmMCIF_WB1_MCIF_WB_BUF_1_STATUS2                                                               0x02b7
#define mmMCIF_WB1_MCIF_WB_BUF_1_STATUS2_BASE_IDX                                                      2
#define mmMCIF_WB1_MCIF_WB_BUF_2_STATUS                                                                0x02b8
#define mmMCIF_WB1_MCIF_WB_BUF_2_STATUS_BASE_IDX                                                       2
#define mmMCIF_WB1_MCIF_WB_BUF_2_STATUS2                                                               0x02b9
#define mmMCIF_WB1_MCIF_WB_BUF_2_STATUS2_BASE_IDX                                                      2
#define mmMCIF_WB1_MCIF_WB_BUF_3_STATUS                                                                0x02ba
#define mmMCIF_WB1_MCIF_WB_BUF_3_STATUS_BASE_IDX                                                       2
#define mmMCIF_WB1_MCIF_WB_BUF_3_STATUS2                                                               0x02bb
#define mmMCIF_WB1_MCIF_WB_BUF_3_STATUS2_BASE_IDX                                                      2
#define mmMCIF_WB1_MCIF_WB_BUF_4_STATUS                                                                0x02bc
#define mmMCIF_WB1_MCIF_WB_BUF_4_STATUS_BASE_IDX                                                       2
#define mmMCIF_WB1_MCIF_WB_BUF_4_STATUS2                                                               0x02bd
#define mmMCIF_WB1_MCIF_WB_BUF_4_STATUS2_BASE_IDX                                                      2
#define mmMCIF_WB1_MCIF_WB_ARBITRATION_CONTROL                                                         0x02be
#define mmMCIF_WB1_MCIF_WB_ARBITRATION_CONTROL_BASE_IDX                                                2
#define mmMCIF_WB1_MCIF_WB_SCLK_CHANGE                                                                 0x02bf
#define mmMCIF_WB1_MCIF_WB_SCLK_CHANGE_BASE_IDX                                                        2
#define mmMCIF_WB1_MCIF_WB_BUF_1_ADDR_Y                                                                0x02c2
#define mmMCIF_WB1_MCIF_WB_BUF_1_ADDR_Y_BASE_IDX                                                       2
#define mmMCIF_WB1_MCIF_WB_BUF_1_ADDR_Y_OFFSET                                                         0x02c3
#define mmMCIF_WB1_MCIF_WB_BUF_1_ADDR_Y_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB1_MCIF_WB_BUF_1_ADDR_C                                                                0x02c4
#define mmMCIF_WB1_MCIF_WB_BUF_1_ADDR_C_BASE_IDX                                                       2
#define mmMCIF_WB1_MCIF_WB_BUF_1_ADDR_C_OFFSET                                                         0x02c5
#define mmMCIF_WB1_MCIF_WB_BUF_1_ADDR_C_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB1_MCIF_WB_BUF_2_ADDR_Y                                                                0x02c6
#define mmMCIF_WB1_MCIF_WB_BUF_2_ADDR_Y_BASE_IDX                                                       2
#define mmMCIF_WB1_MCIF_WB_BUF_2_ADDR_Y_OFFSET                                                         0x02c7
#define mmMCIF_WB1_MCIF_WB_BUF_2_ADDR_Y_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB1_MCIF_WB_BUF_2_ADDR_C                                                                0x02c8
#define mmMCIF_WB1_MCIF_WB_BUF_2_ADDR_C_BASE_IDX                                                       2
#define mmMCIF_WB1_MCIF_WB_BUF_2_ADDR_C_OFFSET                                                         0x02c9
#define mmMCIF_WB1_MCIF_WB_BUF_2_ADDR_C_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB1_MCIF_WB_BUF_3_ADDR_Y                                                                0x02ca
#define mmMCIF_WB1_MCIF_WB_BUF_3_ADDR_Y_BASE_IDX                                                       2
#define mmMCIF_WB1_MCIF_WB_BUF_3_ADDR_Y_OFFSET                                                         0x02cb
#define mmMCIF_WB1_MCIF_WB_BUF_3_ADDR_Y_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB1_MCIF_WB_BUF_3_ADDR_C                                                                0x02cc
#define mmMCIF_WB1_MCIF_WB_BUF_3_ADDR_C_BASE_IDX                                                       2
#define mmMCIF_WB1_MCIF_WB_BUF_3_ADDR_C_OFFSET                                                         0x02cd
#define mmMCIF_WB1_MCIF_WB_BUF_3_ADDR_C_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB1_MCIF_WB_BUF_4_ADDR_Y                                                                0x02ce
#define mmMCIF_WB1_MCIF_WB_BUF_4_ADDR_Y_BASE_IDX                                                       2
#define mmMCIF_WB1_MCIF_WB_BUF_4_ADDR_Y_OFFSET                                                         0x02cf
#define mmMCIF_WB1_MCIF_WB_BUF_4_ADDR_Y_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB1_MCIF_WB_BUF_4_ADDR_C                                                                0x02d0
#define mmMCIF_WB1_MCIF_WB_BUF_4_ADDR_C_BASE_IDX                                                       2
#define mmMCIF_WB1_MCIF_WB_BUF_4_ADDR_C_OFFSET                                                         0x02d1
#define mmMCIF_WB1_MCIF_WB_BUF_4_ADDR_C_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL                                                          0x02d2
#define mmMCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL_BASE_IDX                                                 2
#define mmMCIF_WB1_MCIF_WB_NB_PSTATE_LATENCY_WATERMARK                                                 0x02d3
#define mmMCIF_WB1_MCIF_WB_NB_PSTATE_LATENCY_WATERMARK_BASE_IDX                                        2
#define mmMCIF_WB1_MCIF_WB_NB_PSTATE_CONTROL                                                           0x02d4
#define mmMCIF_WB1_MCIF_WB_NB_PSTATE_CONTROL_BASE_IDX                                                  2
#define mmMCIF_WB1_MCIF_WB_WATERMARK                                                                   0x02d5
#define mmMCIF_WB1_MCIF_WB_WATERMARK_BASE_IDX                                                          2
#define mmMCIF_WB1_MCIF_WB_CLOCK_GATER_CONTROL                                                         0x02d6
#define mmMCIF_WB1_MCIF_WB_CLOCK_GATER_CONTROL_BASE_IDX                                                2
#define mmMCIF_WB1_MCIF_WB_WARM_UP_CNTL                                                                0x02d7
#define mmMCIF_WB1_MCIF_WB_WARM_UP_CNTL_BASE_IDX                                                       2
#define mmMCIF_WB1_MCIF_WB_SELF_REFRESH_CONTROL                                                        0x02d8
#define mmMCIF_WB1_MCIF_WB_SELF_REFRESH_CONTROL_BASE_IDX                                               2
#define mmMCIF_WB1_MULTI_LEVEL_QOS_CTRL                                                                0x02d9
#define mmMCIF_WB1_MULTI_LEVEL_QOS_CTRL_BASE_IDX                                                       2
#define mmMCIF_WB1_MCIF_WB_BUF_LUMA_SIZE                                                               0x02db
#define mmMCIF_WB1_MCIF_WB_BUF_LUMA_SIZE_BASE_IDX                                                      2
#define mmMCIF_WB1_MCIF_WB_BUF_CHROMA_SIZE                                                             0x02dc
#define mmMCIF_WB1_MCIF_WB_BUF_CHROMA_SIZE_BASE_IDX                                                    2


// addressBlock: dce_dc_mcif_wb2_dispdec
// base address: 0x200
#define mmMCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL                                                           0x02f2
#define mmMCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL_BASE_IDX                                                  2
#define mmMCIF_WB2_MCIF_WB_BUFMGR_CUR_LINE_R                                                           0x02f3
#define mmMCIF_WB2_MCIF_WB_BUFMGR_CUR_LINE_R_BASE_IDX                                                  2
#define mmMCIF_WB2_MCIF_WB_BUFMGR_STATUS                                                               0x02f4
#define mmMCIF_WB2_MCIF_WB_BUFMGR_STATUS_BASE_IDX                                                      2
#define mmMCIF_WB2_MCIF_WB_BUF_PITCH                                                                   0x02f5
#define mmMCIF_WB2_MCIF_WB_BUF_PITCH_BASE_IDX                                                          2
#define mmMCIF_WB2_MCIF_WB_BUF_1_STATUS                                                                0x02f6
#define mmMCIF_WB2_MCIF_WB_BUF_1_STATUS_BASE_IDX                                                       2
#define mmMCIF_WB2_MCIF_WB_BUF_1_STATUS2                                                               0x02f7
#define mmMCIF_WB2_MCIF_WB_BUF_1_STATUS2_BASE_IDX                                                      2
#define mmMCIF_WB2_MCIF_WB_BUF_2_STATUS                                                                0x02f8
#define mmMCIF_WB2_MCIF_WB_BUF_2_STATUS_BASE_IDX                                                       2
#define mmMCIF_WB2_MCIF_WB_BUF_2_STATUS2                                                               0x02f9
#define mmMCIF_WB2_MCIF_WB_BUF_2_STATUS2_BASE_IDX                                                      2
#define mmMCIF_WB2_MCIF_WB_BUF_3_STATUS                                                                0x02fa
#define mmMCIF_WB2_MCIF_WB_BUF_3_STATUS_BASE_IDX                                                       2
#define mmMCIF_WB2_MCIF_WB_BUF_3_STATUS2                                                               0x02fb
#define mmMCIF_WB2_MCIF_WB_BUF_3_STATUS2_BASE_IDX                                                      2
#define mmMCIF_WB2_MCIF_WB_BUF_4_STATUS                                                                0x02fc
#define mmMCIF_WB2_MCIF_WB_BUF_4_STATUS_BASE_IDX                                                       2
#define mmMCIF_WB2_MCIF_WB_BUF_4_STATUS2                                                               0x02fd
#define mmMCIF_WB2_MCIF_WB_BUF_4_STATUS2_BASE_IDX                                                      2
#define mmMCIF_WB2_MCIF_WB_ARBITRATION_CONTROL                                                         0x02fe
#define mmMCIF_WB2_MCIF_WB_ARBITRATION_CONTROL_BASE_IDX                                                2
#define mmMCIF_WB2_MCIF_WB_SCLK_CHANGE                                                                 0x02ff
#define mmMCIF_WB2_MCIF_WB_SCLK_CHANGE_BASE_IDX                                                        2
#define mmMCIF_WB2_MCIF_WB_BUF_1_ADDR_Y                                                                0x0302
#define mmMCIF_WB2_MCIF_WB_BUF_1_ADDR_Y_BASE_IDX                                                       2
#define mmMCIF_WB2_MCIF_WB_BUF_1_ADDR_Y_OFFSET                                                         0x0303
#define mmMCIF_WB2_MCIF_WB_BUF_1_ADDR_Y_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB2_MCIF_WB_BUF_1_ADDR_C                                                                0x0304
#define mmMCIF_WB2_MCIF_WB_BUF_1_ADDR_C_BASE_IDX                                                       2
#define mmMCIF_WB2_MCIF_WB_BUF_1_ADDR_C_OFFSET                                                         0x0305
#define mmMCIF_WB2_MCIF_WB_BUF_1_ADDR_C_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB2_MCIF_WB_BUF_2_ADDR_Y                                                                0x0306
#define mmMCIF_WB2_MCIF_WB_BUF_2_ADDR_Y_BASE_IDX                                                       2
#define mmMCIF_WB2_MCIF_WB_BUF_2_ADDR_Y_OFFSET                                                         0x0307
#define mmMCIF_WB2_MCIF_WB_BUF_2_ADDR_Y_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB2_MCIF_WB_BUF_2_ADDR_C                                                                0x0308
#define mmMCIF_WB2_MCIF_WB_BUF_2_ADDR_C_BASE_IDX                                                       2
#define mmMCIF_WB2_MCIF_WB_BUF_2_ADDR_C_OFFSET                                                         0x0309
#define mmMCIF_WB2_MCIF_WB_BUF_2_ADDR_C_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB2_MCIF_WB_BUF_3_ADDR_Y                                                                0x030a
#define mmMCIF_WB2_MCIF_WB_BUF_3_ADDR_Y_BASE_IDX                                                       2
#define mmMCIF_WB2_MCIF_WB_BUF_3_ADDR_Y_OFFSET                                                         0x030b
#define mmMCIF_WB2_MCIF_WB_BUF_3_ADDR_Y_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB2_MCIF_WB_BUF_3_ADDR_C                                                                0x030c
#define mmMCIF_WB2_MCIF_WB_BUF_3_ADDR_C_BASE_IDX                                                       2
#define mmMCIF_WB2_MCIF_WB_BUF_3_ADDR_C_OFFSET                                                         0x030d
#define mmMCIF_WB2_MCIF_WB_BUF_3_ADDR_C_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB2_MCIF_WB_BUF_4_ADDR_Y                                                                0x030e
#define mmMCIF_WB2_MCIF_WB_BUF_4_ADDR_Y_BASE_IDX                                                       2
#define mmMCIF_WB2_MCIF_WB_BUF_4_ADDR_Y_OFFSET                                                         0x030f
#define mmMCIF_WB2_MCIF_WB_BUF_4_ADDR_Y_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB2_MCIF_WB_BUF_4_ADDR_C                                                                0x0310
#define mmMCIF_WB2_MCIF_WB_BUF_4_ADDR_C_BASE_IDX                                                       2
#define mmMCIF_WB2_MCIF_WB_BUF_4_ADDR_C_OFFSET                                                         0x0311
#define mmMCIF_WB2_MCIF_WB_BUF_4_ADDR_C_OFFSET_BASE_IDX                                                2
#define mmMCIF_WB2_MCIF_WB_BUFMGR_VCE_CONTROL                                                          0x0312
#define mmMCIF_WB2_MCIF_WB_BUFMGR_VCE_CONTROL_BASE_IDX                                                 2
#define mmMCIF_WB2_MCIF_WB_NB_PSTATE_LATENCY_WATERMARK                                                 0x0313
#define mmMCIF_WB2_MCIF_WB_NB_PSTATE_LATENCY_WATERMARK_BASE_IDX                                        2
#define mmMCIF_WB2_MCIF_WB_NB_PSTATE_CONTROL                                                           0x0314
#define mmMCIF_WB2_MCIF_WB_NB_PSTATE_CONTROL_BASE_IDX                                                  2
#define mmMCIF_WB2_MCIF_WB_WATERMARK                                                                   0x0315
#define mmMCIF_WB2_MCIF_WB_WATERMARK_BASE_IDX                                                          2
#define mmMCIF_WB2_MCIF_WB_CLOCK_GATER_CONTROL                                                         0x0316
#define mmMCIF_WB2_MCIF_WB_CLOCK_GATER_CONTROL_BASE_IDX                                                2
#define mmMCIF_WB2_MCIF_WB_WARM_UP_CNTL                                                                0x0317
#define mmMCIF_WB2_MCIF_WB_WARM_UP_CNTL_BASE_IDX                                                       2
#define mmMCIF_WB2_MCIF_WB_SELF_REFRESH_CONTROL                                                        0x0318
#define mmMCIF_WB2_MCIF_WB_SELF_REFRESH_CONTROL_BASE_IDX                                               2
#define mmMCIF_WB2_MULTI_LEVEL_QOS_CTRL                                                                0x0319
#define mmMCIF_WB2_MULTI_LEVEL_QOS_CTRL_BASE_IDX                                                       2
#define mmMCIF_WB2_MCIF_WB_BUF_LUMA_SIZE                                                               0x031b
#define mmMCIF_WB2_MCIF_WB_BUF_LUMA_SIZE_BASE_IDX                                                      2
#define mmMCIF_WB2_MCIF_WB_BUF_CHROMA_SIZE                                                             0x031c
#define mmMCIF_WB2_MCIF_WB_BUF_CHROMA_SIZE_BASE_IDX                                                    2


// addressBlock: dce_dc_cwb0_dispdec
// base address: 0x0
#define mmCWB0_CWB_CTRL                                                                                0x0332
#define mmCWB0_CWB_CTRL_BASE_IDX                                                                       2
#define mmCWB0_CWB_FENCE_PAR0                                                                          0x0334
#define mmCWB0_CWB_FENCE_PAR0_BASE_IDX                                                                 2
#define mmCWB0_CWB_FENCE_PAR1                                                                          0x0335
#define mmCWB0_CWB_FENCE_PAR1_BASE_IDX                                                                 2
#define mmCWB0_CWB_CRC_CTRL                                                                            0x0339
#define mmCWB0_CWB_CRC_CTRL_BASE_IDX                                                                   2
#define mmCWB0_CWB_CRC_RED_GREEN_MASK                                                                  0x033a
#define mmCWB0_CWB_CRC_RED_GREEN_MASK_BASE_IDX                                                         2
#define mmCWB0_CWB_CRC_BLUE_MASK                                                                       0x033b
#define mmCWB0_CWB_CRC_BLUE_MASK_BASE_IDX                                                              2
#define mmCWB0_CWB_CRC_RED_GREEN_RESULT                                                                0x033c
#define mmCWB0_CWB_CRC_RED_GREEN_RESULT_BASE_IDX                                                       2
#define mmCWB0_CWB_CRC_BLUE_RESULT                                                                     0x033d
#define mmCWB0_CWB_CRC_BLUE_RESULT_BASE_IDX                                                            2


// addressBlock: dce_dc_cwb1_dispdec
// base address: 0x60
#define mmCWB1_CWB_CTRL                                                                                0x034a
#define mmCWB1_CWB_CTRL_BASE_IDX                                                                       2
#define mmCWB1_CWB_FENCE_PAR0                                                                          0x034c
#define mmCWB1_CWB_FENCE_PAR0_BASE_IDX                                                                 2
#define mmCWB1_CWB_FENCE_PAR1                                                                          0x034d
#define mmCWB1_CWB_FENCE_PAR1_BASE_IDX                                                                 2
#define mmCWB1_CWB_CRC_CTRL                                                                            0x0351
#define mmCWB1_CWB_CRC_CTRL_BASE_IDX                                                                   2
#define mmCWB1_CWB_CRC_RED_GREEN_MASK                                                                  0x0352
#define mmCWB1_CWB_CRC_RED_GREEN_MASK_BASE_IDX                                                         2
#define mmCWB1_CWB_CRC_BLUE_MASK                                                                       0x0353
#define mmCWB1_CWB_CRC_BLUE_MASK_BASE_IDX                                                              2
#define mmCWB1_CWB_CRC_RED_GREEN_RESULT                                                                0x0354
#define mmCWB1_CWB_CRC_RED_GREEN_RESULT_BASE_IDX                                                       2
#define mmCWB1_CWB_CRC_BLUE_RESULT                                                                     0x0355
#define mmCWB1_CWB_CRC_BLUE_RESULT_BASE_IDX                                                            2


// addressBlock: dce_dc_dc_perfmon9_dispdec
// base address: 0xd08
#define mmDC_PERFMON9_PERFCOUNTER_CNTL                                                                 0x0362
#define mmDC_PERFMON9_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON9_PERFCOUNTER_CNTL2                                                                0x0363
#define mmDC_PERFMON9_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON9_PERFCOUNTER_STATE                                                                0x0364
#define mmDC_PERFMON9_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON9_PERFMON_CNTL                                                                     0x0365
#define mmDC_PERFMON9_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON9_PERFMON_CNTL2                                                                    0x0366
#define mmDC_PERFMON9_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON9_PERFMON_CVALUE_INT_MISC                                                          0x0367
#define mmDC_PERFMON9_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON9_PERFMON_CVALUE_LOW                                                               0x0368
#define mmDC_PERFMON9_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON9_PERFMON_HI                                                                       0x0369
#define mmDC_PERFMON9_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON9_PERFMON_LOW                                                                      0x036a
#define mmDC_PERFMON9_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dispdec
// base address: 0x0
#define mmVGA_MEM_WRITE_PAGE_ADDR                                                                      0x0000
#define mmVGA_MEM_WRITE_PAGE_ADDR_BASE_IDX                                                             0
#define mmVGA_MEM_READ_PAGE_ADDR                                                                       0x0001
#define mmVGA_MEM_READ_PAGE_ADDR_BASE_IDX                                                              0
#define mmVGA_RENDER_CONTROL                                                                           0x0000
#define mmVGA_RENDER_CONTROL_BASE_IDX                                                                  1
#define mmVGA_SEQUENCER_RESET_CONTROL                                                                  0x0001
#define mmVGA_SEQUENCER_RESET_CONTROL_BASE_IDX                                                         1
#define mmVGA_MODE_CONTROL                                                                             0x0002
#define mmVGA_MODE_CONTROL_BASE_IDX                                                                    1
#define mmVGA_SURFACE_PITCH_SELECT                                                                     0x0003
#define mmVGA_SURFACE_PITCH_SELECT_BASE_IDX                                                            1
#define mmVGA_MEMORY_BASE_ADDRESS                                                                      0x0004
#define mmVGA_MEMORY_BASE_ADDRESS_BASE_IDX                                                             1
#define mmVGA_DISPBUF1_SURFACE_ADDR                                                                    0x0006
#define mmVGA_DISPBUF1_SURFACE_ADDR_BASE_IDX                                                           1
#define mmVGA_DISPBUF2_SURFACE_ADDR                                                                    0x0008
#define mmVGA_DISPBUF2_SURFACE_ADDR_BASE_IDX                                                           1
#define mmVGA_MEMORY_BASE_ADDRESS_HIGH                                                                 0x0009
#define mmVGA_MEMORY_BASE_ADDRESS_HIGH_BASE_IDX                                                        1
#define mmVGA_HDP_CONTROL                                                                              0x000a
#define mmVGA_HDP_CONTROL_BASE_IDX                                                                     1
#define mmVGA_CACHE_CONTROL                                                                            0x000b
#define mmVGA_CACHE_CONTROL_BASE_IDX                                                                   1
#define mmD1VGA_CONTROL                                                                                0x000c
#define mmD1VGA_CONTROL_BASE_IDX                                                                       1
#define mmD2VGA_CONTROL                                                                                0x000e
#define mmD2VGA_CONTROL_BASE_IDX                                                                       1
#define mmVGA_STATUS                                                                                   0x0010
#define mmVGA_STATUS_BASE_IDX                                                                          1
#define mmVGA_INTERRUPT_CONTROL                                                                        0x0011
#define mmVGA_INTERRUPT_CONTROL_BASE_IDX                                                               1
#define mmVGA_STATUS_CLEAR                                                                             0x0012
#define mmVGA_STATUS_CLEAR_BASE_IDX                                                                    1
#define mmVGA_INTERRUPT_STATUS                                                                         0x0013
#define mmVGA_INTERRUPT_STATUS_BASE_IDX                                                                1
#define mmVGA_MAIN_CONTROL                                                                             0x0014
#define mmVGA_MAIN_CONTROL_BASE_IDX                                                                    1
#define mmVGA_TEST_CONTROL                                                                             0x0015
#define mmVGA_TEST_CONTROL_BASE_IDX                                                                    1
#define mmVGA_QOS_CTRL                                                                                 0x0018
#define mmVGA_QOS_CTRL_BASE_IDX                                                                        1
#define mmCRTC8_IDX                                                                                    0x002d
#define mmCRTC8_IDX_BASE_IDX                                                                           1
#define mmCRTC8_DATA                                                                                   0x002d
#define mmCRTC8_DATA_BASE_IDX                                                                          1
#define mmGENFC_WT                                                                                     0x002e
#define mmGENFC_WT_BASE_IDX                                                                            1
#define mmGENS1                                                                                        0x002e
#define mmGENS1_BASE_IDX                                                                               1
#define mmATTRDW                                                                                       0x0030
#define mmATTRDW_BASE_IDX                                                                              1
#define mmATTRX                                                                                        0x0030
#define mmATTRX_BASE_IDX                                                                               1
#define mmATTRDR                                                                                       0x0030
#define mmATTRDR_BASE_IDX                                                                              1
#define mmGENMO_WT                                                                                     0x0030
#define mmGENMO_WT_BASE_IDX                                                                            1
#define mmGENS0                                                                                        0x0030
#define mmGENS0_BASE_IDX                                                                               1
#define mmGENENB                                                                                       0x0030
#define mmGENENB_BASE_IDX                                                                              1
#define mmSEQ8_IDX                                                                                     0x0031
#define mmSEQ8_IDX_BASE_IDX                                                                            1
#define mmSEQ8_DATA                                                                                    0x0031
#define mmSEQ8_DATA_BASE_IDX                                                                           1
#define mmDAC_MASK                                                                                     0x0031
#define mmDAC_MASK_BASE_IDX                                                                            1
#define mmDAC_R_INDEX                                                                                  0x0031
#define mmDAC_R_INDEX_BASE_IDX                                                                         1
#define mmDAC_W_INDEX                                                                                  0x0032
#define mmDAC_W_INDEX_BASE_IDX                                                                         1
#define mmDAC_DATA                                                                                     0x0032
#define mmDAC_DATA_BASE_IDX                                                                            1
#define mmGENFC_RD                                                                                     0x0032
#define mmGENFC_RD_BASE_IDX                                                                            1
#define mmGENMO_RD                                                                                     0x0033
#define mmGENMO_RD_BASE_IDX                                                                            1
#define mmGRPH8_IDX                                                                                    0x0033
#define mmGRPH8_IDX_BASE_IDX                                                                           1
#define mmGRPH8_DATA                                                                                   0x0033
#define mmGRPH8_DATA_BASE_IDX                                                                          1
#define mmCRTC8_IDX_1                                                                                  0x0035
#define mmCRTC8_IDX_1_BASE_IDX                                                                         1
#define mmCRTC8_DATA_1                                                                                 0x0035
#define mmCRTC8_DATA_1_BASE_IDX                                                                        1
#define mmGENFC_WT_1                                                                                   0x0036
#define mmGENFC_WT_1_BASE_IDX                                                                          1
#define mmGENS1_1                                                                                      0x0036
#define mmGENS1_1_BASE_IDX                                                                             1
#define mmD3VGA_CONTROL                                                                                0x0038
#define mmD3VGA_CONTROL_BASE_IDX                                                                       1
#define mmD4VGA_CONTROL                                                                                0x0039
#define mmD4VGA_CONTROL_BASE_IDX                                                                       1
#define mmD5VGA_CONTROL                                                                                0x003a
#define mmD5VGA_CONTROL_BASE_IDX                                                                       1
#define mmD6VGA_CONTROL                                                                                0x003b
#define mmD6VGA_CONTROL_BASE_IDX                                                                       1
#define mmVGA_SOURCE_SELECT                                                                            0x003c
#define mmVGA_SOURCE_SELECT_BASE_IDX                                                                   1
#define mmPHYPLLA_PIXCLK_RESYNC_CNTL                                                                   0x0040
#define mmPHYPLLA_PIXCLK_RESYNC_CNTL_BASE_IDX                                                          1
#define mmPHYPLLB_PIXCLK_RESYNC_CNTL                                                                   0x0041
#define mmPHYPLLB_PIXCLK_RESYNC_CNTL_BASE_IDX                                                          1
#define mmPHYPLLC_PIXCLK_RESYNC_CNTL                                                                   0x0042
#define mmPHYPLLC_PIXCLK_RESYNC_CNTL_BASE_IDX                                                          1
#define mmPHYPLLD_PIXCLK_RESYNC_CNTL                                                                   0x0043
#define mmPHYPLLD_PIXCLK_RESYNC_CNTL_BASE_IDX                                                          1
#define mmDCFEV0_CRTC_PIXEL_RATE_CNTL                                                                  0x0044
#define mmDCFEV0_CRTC_PIXEL_RATE_CNTL_BASE_IDX                                                         1
#define mmDCFEV1_CRTC_PIXEL_RATE_CNTL                                                                  0x0045
#define mmDCFEV1_CRTC_PIXEL_RATE_CNTL_BASE_IDX                                                         1
#define mmSYMCLKLPA_CLOCK_ENABLE                                                                       0x0046
#define mmSYMCLKLPA_CLOCK_ENABLE_BASE_IDX                                                              1
#define mmSYMCLKLPB_CLOCK_ENABLE                                                                       0x0047
#define mmSYMCLKLPB_CLOCK_ENABLE_BASE_IDX                                                              1
#define mmDPREFCLK_CGTT_BLK_CTRL_REG                                                                   0x0048
#define mmDPREFCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                          1
#define mmREFCLK_CNTL                                                                                  0x0049
#define mmREFCLK_CNTL_BASE_IDX                                                                         1
#define mmMIPI_CLK_CNTL                                                                                0x004a
#define mmMIPI_CLK_CNTL_BASE_IDX                                                                       1
#define mmREFCLK_CGTT_BLK_CTRL_REG                                                                     0x004b
#define mmREFCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                            1
#define mmPHYPLLE_PIXCLK_RESYNC_CNTL                                                                   0x004c
#define mmPHYPLLE_PIXCLK_RESYNC_CNTL_BASE_IDX                                                          1
#define mmDCCG_PERFMON_CNTL2                                                                           0x004e
#define mmDCCG_PERFMON_CNTL2_BASE_IDX                                                                  1
#define mmDSICLK_CGTT_BLK_CTRL_REG                                                                     0x004f
#define mmDSICLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                            1
#define mmDCCG_CBUS_WRCMD_DELAY                                                                        0x0050
#define mmDCCG_CBUS_WRCMD_DELAY_BASE_IDX                                                               1
#define mmDCCG_DS_DTO_INCR                                                                             0x0053
#define mmDCCG_DS_DTO_INCR_BASE_IDX                                                                    1
#define mmDCCG_DS_DTO_MODULO                                                                           0x0054
#define mmDCCG_DS_DTO_MODULO_BASE_IDX                                                                  1
#define mmDCCG_DS_CNTL                                                                                 0x0055
#define mmDCCG_DS_CNTL_BASE_IDX                                                                        1
#define mmDCCG_DS_HW_CAL_INTERVAL                                                                      0x0056
#define mmDCCG_DS_HW_CAL_INTERVAL_BASE_IDX                                                             1
#define mmSYMCLKG_CLOCK_ENABLE                                                                         0x0057
#define mmSYMCLKG_CLOCK_ENABLE_BASE_IDX                                                                1
#define mmDPREFCLK_CNTL                                                                                0x0058
#define mmDPREFCLK_CNTL_BASE_IDX                                                                       1
#define mmAOMCLK0_CNTL                                                                                 0x0059
#define mmAOMCLK0_CNTL_BASE_IDX                                                                        1
#define mmAOMCLK1_CNTL                                                                                 0x005a
#define mmAOMCLK1_CNTL_BASE_IDX                                                                        1
#define mmAOMCLK2_CNTL                                                                                 0x005b
#define mmAOMCLK2_CNTL_BASE_IDX                                                                        1
#define mmDCCG_AUDIO_DTO2_PHASE                                                                        0x005c
#define mmDCCG_AUDIO_DTO2_PHASE_BASE_IDX                                                               1
#define mmDCCG_AUDIO_DTO2_MODULO                                                                       0x005d
#define mmDCCG_AUDIO_DTO2_MODULO_BASE_IDX                                                              1
#define mmDCE_VERSION                                                                                  0x005e
#define mmDCE_VERSION_BASE_IDX                                                                         1
#define mmPHYPLLG_PIXCLK_RESYNC_CNTL                                                                   0x005f
#define mmPHYPLLG_PIXCLK_RESYNC_CNTL_BASE_IDX                                                          1
#define mmDCCG_GTC_CNTL                                                                                0x0060
#define mmDCCG_GTC_CNTL_BASE_IDX                                                                       1
#define mmDCCG_GTC_DTO_INCR                                                                            0x0061
#define mmDCCG_GTC_DTO_INCR_BASE_IDX                                                                   1
#define mmDCCG_GTC_DTO_MODULO                                                                          0x0062
#define mmDCCG_GTC_DTO_MODULO_BASE_IDX                                                                 1
#define mmDCCG_GTC_CURRENT                                                                             0x0063
#define mmDCCG_GTC_CURRENT_BASE_IDX                                                                    1
#define mmDENTIST_DISPCLK_CNTL                                                                         0x0064
#define mmDENTIST_DISPCLK_CNTL_BASE_IDX                                                                1
#define mmMIPI_DTO_CNTL                                                                                0x0065
#define mmMIPI_DTO_CNTL_BASE_IDX                                                                       1
#define mmMIPI_DTO_PHASE                                                                               0x0066
#define mmMIPI_DTO_PHASE_BASE_IDX                                                                      1
#define mmMIPI_DTO_MODULO                                                                              0x0067
#define mmMIPI_DTO_MODULO_BASE_IDX                                                                     1
#define mmDAC_CLK_ENABLE                                                                               0x0068
#define mmDAC_CLK_ENABLE_BASE_IDX                                                                      1
#define mmDVO_CLK_ENABLE                                                                               0x0069
#define mmDVO_CLK_ENABLE_BASE_IDX                                                                      1
#define mmAVSYNC_COUNTER_WRITE                                                                         0x006a
#define mmAVSYNC_COUNTER_WRITE_BASE_IDX                                                                1
#define mmAVSYNC_COUNTER_CONTROL                                                                       0x006b
#define mmAVSYNC_COUNTER_CONTROL_BASE_IDX                                                              1
#define mmDMCU_SMU_INTERRUPT_CNTL                                                                      0x006c
#define mmDMCU_SMU_INTERRUPT_CNTL_BASE_IDX                                                             1
#define mmSMU_CONTROL                                                                                  0x006d
#define mmSMU_CONTROL_BASE_IDX                                                                         1
#define mmSMU_INTERRUPT_CONTROL                                                                        0x006e
#define mmSMU_INTERRUPT_CONTROL_BASE_IDX                                                               1
#define mmAVSYNC_COUNTER_READ                                                                          0x006f
#define mmAVSYNC_COUNTER_READ_BASE_IDX                                                                 1
#define mmMILLISECOND_TIME_BASE_DIV                                                                    0x0070
#define mmMILLISECOND_TIME_BASE_DIV_BASE_IDX                                                           1
#define mmDISPCLK_FREQ_CHANGE_CNTL                                                                     0x0071
#define mmDISPCLK_FREQ_CHANGE_CNTL_BASE_IDX                                                            1
#define mmDC_MEM_GLOBAL_PWR_REQ_CNTL                                                                   0x0072
#define mmDC_MEM_GLOBAL_PWR_REQ_CNTL_BASE_IDX                                                          1
#define mmDCCG_PERFMON_CNTL                                                                            0x0073
#define mmDCCG_PERFMON_CNTL_BASE_IDX                                                                   1
#define mmDCCG_GATE_DISABLE_CNTL                                                                       0x0074
#define mmDCCG_GATE_DISABLE_CNTL_BASE_IDX                                                              1
#define mmDISPCLK_CGTT_BLK_CTRL_REG                                                                    0x0075
#define mmDISPCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                           1
#define mmSCLK_CGTT_BLK_CTRL_REG                                                                       0x0076
#define mmSCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                              1
#define mmDCCG_CAC_STATUS                                                                              0x0077
#define mmDCCG_CAC_STATUS_BASE_IDX                                                                     1
#define mmPIXCLK1_RESYNC_CNTL                                                                          0x0078
#define mmPIXCLK1_RESYNC_CNTL_BASE_IDX                                                                 1
#define mmPIXCLK2_RESYNC_CNTL                                                                          0x0079
#define mmPIXCLK2_RESYNC_CNTL_BASE_IDX                                                                 1
#define mmPIXCLK0_RESYNC_CNTL                                                                          0x007a
#define mmPIXCLK0_RESYNC_CNTL_BASE_IDX                                                                 1
#define mmMICROSECOND_TIME_BASE_DIV                                                                    0x007b
#define mmMICROSECOND_TIME_BASE_DIV_BASE_IDX                                                           1
#define mmDCCG_GATE_DISABLE_CNTL2                                                                      0x007c
#define mmDCCG_GATE_DISABLE_CNTL2_BASE_IDX                                                             1
#define mmSYMCLK_CGTT_BLK_CTRL_REG                                                                     0x007d
#define mmSYMCLK_CGTT_BLK_CTRL_REG_BASE_IDX                                                            1
#define mmPHYPLLF_PIXCLK_RESYNC_CNTL                                                                   0x007e
#define mmPHYPLLF_PIXCLK_RESYNC_CNTL_BASE_IDX                                                          1
#define mmDCCG_DISP_CNTL_REG                                                                           0x007f
#define mmDCCG_DISP_CNTL_REG_BASE_IDX                                                                  1
#define mmCRTC0_PIXEL_RATE_CNTL                                                                        0x0080
#define mmCRTC0_PIXEL_RATE_CNTL_BASE_IDX                                                               1
#define mmDP_DTO0_PHASE                                                                                0x0081
#define mmDP_DTO0_PHASE_BASE_IDX                                                                       1
#define mmDP_DTO0_MODULO                                                                               0x0082
#define mmDP_DTO0_MODULO_BASE_IDX                                                                      1
#define mmCRTC0_PHYPLL_PIXEL_RATE_CNTL                                                                 0x0083
#define mmCRTC0_PHYPLL_PIXEL_RATE_CNTL_BASE_IDX                                                        1
#define mmCRTC1_PIXEL_RATE_CNTL                                                                        0x0084
#define mmCRTC1_PIXEL_RATE_CNTL_BASE_IDX                                                               1
#define mmDP_DTO1_PHASE                                                                                0x0085
#define mmDP_DTO1_PHASE_BASE_IDX                                                                       1
#define mmDP_DTO1_MODULO                                                                               0x0086
#define mmDP_DTO1_MODULO_BASE_IDX                                                                      1
#define mmCRTC1_PHYPLL_PIXEL_RATE_CNTL                                                                 0x0087
#define mmCRTC1_PHYPLL_PIXEL_RATE_CNTL_BASE_IDX                                                        1
#define mmCRTC2_PIXEL_RATE_CNTL                                                                        0x0088
#define mmCRTC2_PIXEL_RATE_CNTL_BASE_IDX                                                               1
#define mmDP_DTO2_PHASE                                                                                0x0089
#define mmDP_DTO2_PHASE_BASE_IDX                                                                       1
#define mmDP_DTO2_MODULO                                                                               0x008a
#define mmDP_DTO2_MODULO_BASE_IDX                                                                      1
#define mmCRTC2_PHYPLL_PIXEL_RATE_CNTL                                                                 0x008b
#define mmCRTC2_PHYPLL_PIXEL_RATE_CNTL_BASE_IDX                                                        1
#define mmCRTC3_PIXEL_RATE_CNTL                                                                        0x008c
#define mmCRTC3_PIXEL_RATE_CNTL_BASE_IDX                                                               1
#define mmDP_DTO3_PHASE                                                                                0x008d
#define mmDP_DTO3_PHASE_BASE_IDX                                                                       1
#define mmDP_DTO3_MODULO                                                                               0x008e
#define mmDP_DTO3_MODULO_BASE_IDX                                                                      1
#define mmCRTC3_PHYPLL_PIXEL_RATE_CNTL                                                                 0x008f
#define mmCRTC3_PHYPLL_PIXEL_RATE_CNTL_BASE_IDX                                                        1
#define mmCRTC4_PIXEL_RATE_CNTL                                                                        0x0090
#define mmCRTC4_PIXEL_RATE_CNTL_BASE_IDX                                                               1
#define mmDP_DTO4_PHASE                                                                                0x0091
#define mmDP_DTO4_PHASE_BASE_IDX                                                                       1
#define mmDP_DTO4_MODULO                                                                               0x0092
#define mmDP_DTO4_MODULO_BASE_IDX                                                                      1
#define mmCRTC4_PHYPLL_PIXEL_RATE_CNTL                                                                 0x0093
#define mmCRTC4_PHYPLL_PIXEL_RATE_CNTL_BASE_IDX                                                        1
#define mmCRTC5_PIXEL_RATE_CNTL                                                                        0x0094
#define mmCRTC5_PIXEL_RATE_CNTL_BASE_IDX                                                               1
#define mmDP_DTO5_PHASE                                                                                0x0095
#define mmDP_DTO5_PHASE_BASE_IDX                                                                       1
#define mmDP_DTO5_MODULO                                                                               0x0096
#define mmDP_DTO5_MODULO_BASE_IDX                                                                      1
#define mmCRTC5_PHYPLL_PIXEL_RATE_CNTL                                                                 0x0097
#define mmCRTC5_PHYPLL_PIXEL_RATE_CNTL_BASE_IDX                                                        1
#define mmDCCG_SOFT_RESET                                                                              0x009f
#define mmDCCG_SOFT_RESET_BASE_IDX                                                                     1
#define mmSYMCLKA_CLOCK_ENABLE                                                                         0x00a0
#define mmSYMCLKA_CLOCK_ENABLE_BASE_IDX                                                                1
#define mmSYMCLKB_CLOCK_ENABLE                                                                         0x00a1
#define mmSYMCLKB_CLOCK_ENABLE_BASE_IDX                                                                1
#define mmSYMCLKC_CLOCK_ENABLE                                                                         0x00a2
#define mmSYMCLKC_CLOCK_ENABLE_BASE_IDX                                                                1
#define mmSYMCLKD_CLOCK_ENABLE                                                                         0x00a3
#define mmSYMCLKD_CLOCK_ENABLE_BASE_IDX                                                                1
#define mmSYMCLKE_CLOCK_ENABLE                                                                         0x00a4
#define mmSYMCLKE_CLOCK_ENABLE_BASE_IDX                                                                1
#define mmSYMCLKF_CLOCK_ENABLE                                                                         0x00a5
#define mmSYMCLKF_CLOCK_ENABLE_BASE_IDX                                                                1
#define mmDVOACLKD_CNTL                                                                                0x00a8
#define mmDVOACLKD_CNTL_BASE_IDX                                                                       1
#define mmDVOACLKC_MVP_CNTL                                                                            0x00a9
#define mmDVOACLKC_MVP_CNTL_BASE_IDX                                                                   1
#define mmDVOACLKC_CNTL                                                                                0x00aa
#define mmDVOACLKC_CNTL_BASE_IDX                                                                       1
#define mmDCCG_AUDIO_DTO_SOURCE                                                                        0x00ab
#define mmDCCG_AUDIO_DTO_SOURCE_BASE_IDX                                                               1
#define mmDCCG_AUDIO_DTO0_PHASE                                                                        0x00ac
#define mmDCCG_AUDIO_DTO0_PHASE_BASE_IDX                                                               1
#define mmDCCG_AUDIO_DTO0_MODULE                                                                       0x00ad
#define mmDCCG_AUDIO_DTO0_MODULE_BASE_IDX                                                              1
#define mmDCCG_AUDIO_DTO1_PHASE                                                                        0x00ae
#define mmDCCG_AUDIO_DTO1_PHASE_BASE_IDX                                                               1
#define mmDCCG_AUDIO_DTO1_MODULE                                                                       0x00af
#define mmDCCG_AUDIO_DTO1_MODULE_BASE_IDX                                                              1
#define mmDCCG_TEST_CLK_SEL                                                                            0x00be
#define mmDCCG_TEST_CLK_SEL_BASE_IDX                                                                   1
#define mmFBC_CNTL                                                                                     0x0062
#define mmFBC_CNTL_BASE_IDX                                                                            2
#define mmFBC_IDLE_FORCE_CLEAR_MASK                                                                    0x0064
#define mmFBC_IDLE_FORCE_CLEAR_MASK_BASE_IDX                                                           2
#define mmFBC_START_STOP_DELAY                                                                         0x0065
#define mmFBC_START_STOP_DELAY_BASE_IDX                                                                2
#define mmFBC_COMP_CNTL                                                                                0x0066
#define mmFBC_COMP_CNTL_BASE_IDX                                                                       2
#define mmFBC_COMP_MODE                                                                                0x0067
#define mmFBC_COMP_MODE_BASE_IDX                                                                       2
#define mmFBC_IND_LUT0                                                                                 0x006b
#define mmFBC_IND_LUT0_BASE_IDX                                                                        2
#define mmFBC_IND_LUT1                                                                                 0x006c
#define mmFBC_IND_LUT1_BASE_IDX                                                                        2
#define mmFBC_IND_LUT2                                                                                 0x006d
#define mmFBC_IND_LUT2_BASE_IDX                                                                        2
#define mmFBC_IND_LUT3                                                                                 0x006e
#define mmFBC_IND_LUT3_BASE_IDX                                                                        2
#define mmFBC_IND_LUT4                                                                                 0x006f
#define mmFBC_IND_LUT4_BASE_IDX                                                                        2
#define mmFBC_IND_LUT5                                                                                 0x0070
#define mmFBC_IND_LUT5_BASE_IDX                                                                        2
#define mmFBC_IND_LUT6                                                                                 0x0071
#define mmFBC_IND_LUT6_BASE_IDX                                                                        2
#define mmFBC_IND_LUT7                                                                                 0x0072
#define mmFBC_IND_LUT7_BASE_IDX                                                                        2
#define mmFBC_IND_LUT8                                                                                 0x0073
#define mmFBC_IND_LUT8_BASE_IDX                                                                        2
#define mmFBC_IND_LUT9                                                                                 0x0074
#define mmFBC_IND_LUT9_BASE_IDX                                                                        2
#define mmFBC_IND_LUT10                                                                                0x0075
#define mmFBC_IND_LUT10_BASE_IDX                                                                       2
#define mmFBC_IND_LUT11                                                                                0x0076
#define mmFBC_IND_LUT11_BASE_IDX                                                                       2
#define mmFBC_IND_LUT12                                                                                0x0077
#define mmFBC_IND_LUT12_BASE_IDX                                                                       2
#define mmFBC_IND_LUT13                                                                                0x0078
#define mmFBC_IND_LUT13_BASE_IDX                                                                       2
#define mmFBC_IND_LUT14                                                                                0x0079
#define mmFBC_IND_LUT14_BASE_IDX                                                                       2
#define mmFBC_IND_LUT15                                                                                0x007a
#define mmFBC_IND_LUT15_BASE_IDX                                                                       2
#define mmFBC_CSM_REGION_OFFSET_01                                                                     0x007b
#define mmFBC_CSM_REGION_OFFSET_01_BASE_IDX                                                            2
#define mmFBC_CSM_REGION_OFFSET_23                                                                     0x007c
#define mmFBC_CSM_REGION_OFFSET_23_BASE_IDX                                                            2
#define mmFBC_CLIENT_REGION_MASK                                                                       0x007d
#define mmFBC_CLIENT_REGION_MASK_BASE_IDX                                                              2
#define mmFBC_DEBUG_COMP                                                                               0x007e
#define mmFBC_DEBUG_COMP_BASE_IDX                                                                      2
#define mmFBC_MISC                                                                                     0x0084
#define mmFBC_MISC_BASE_IDX                                                                            2
#define mmFBC_STATUS                                                                                   0x0085
#define mmFBC_STATUS_BASE_IDX                                                                          2
#define mmFBC_ALPHA_CNTL                                                                               0x0088
#define mmFBC_ALPHA_CNTL_BASE_IDX                                                                      2
#define mmFBC_ALPHA_RGB_OVERRIDE                                                                       0x0089
#define mmFBC_ALPHA_RGB_OVERRIDE_BASE_IDX                                                              2
#define mmPIPE0_PG_CONFIG                                                                              0x008e
#define mmPIPE0_PG_CONFIG_BASE_IDX                                                                     2
#define mmPIPE0_PG_ENABLE                                                                              0x008f
#define mmPIPE0_PG_ENABLE_BASE_IDX                                                                     2
#define mmPIPE0_PG_STATUS                                                                              0x0090
#define mmPIPE0_PG_STATUS_BASE_IDX                                                                     2
#define mmPIPE1_PG_CONFIG                                                                              0x0091
#define mmPIPE1_PG_CONFIG_BASE_IDX                                                                     2
#define mmPIPE1_PG_ENABLE                                                                              0x0092
#define mmPIPE1_PG_ENABLE_BASE_IDX                                                                     2
#define mmPIPE1_PG_STATUS                                                                              0x0093
#define mmPIPE1_PG_STATUS_BASE_IDX                                                                     2
#define mmPIPE2_PG_CONFIG                                                                              0x0094
#define mmPIPE2_PG_CONFIG_BASE_IDX                                                                     2
#define mmPIPE2_PG_ENABLE                                                                              0x0095
#define mmPIPE2_PG_ENABLE_BASE_IDX                                                                     2
#define mmPIPE2_PG_STATUS                                                                              0x0096
#define mmPIPE2_PG_STATUS_BASE_IDX                                                                     2
#define mmPIPE3_PG_CONFIG                                                                              0x0097
#define mmPIPE3_PG_CONFIG_BASE_IDX                                                                     2
#define mmPIPE3_PG_ENABLE                                                                              0x0098
#define mmPIPE3_PG_ENABLE_BASE_IDX                                                                     2
#define mmPIPE3_PG_STATUS                                                                              0x0099
#define mmPIPE3_PG_STATUS_BASE_IDX                                                                     2
#define mmPIPE4_PG_CONFIG                                                                              0x009a
#define mmPIPE4_PG_CONFIG_BASE_IDX                                                                     2
#define mmPIPE4_PG_ENABLE                                                                              0x009b
#define mmPIPE4_PG_ENABLE_BASE_IDX                                                                     2
#define mmPIPE4_PG_STATUS                                                                              0x009c
#define mmPIPE4_PG_STATUS_BASE_IDX                                                                     2
#define mmPIPE5_PG_CONFIG                                                                              0x009d
#define mmPIPE5_PG_CONFIG_BASE_IDX                                                                     2
#define mmPIPE5_PG_ENABLE                                                                              0x009e
#define mmPIPE5_PG_ENABLE_BASE_IDX                                                                     2
#define mmPIPE5_PG_STATUS                                                                              0x009f
#define mmPIPE5_PG_STATUS_BASE_IDX                                                                     2
#define mmDSI_PG_CONFIG                                                                                0x00a0
#define mmDSI_PG_CONFIG_BASE_IDX                                                                       2
#define mmDSI_PG_ENABLE                                                                                0x00a1
#define mmDSI_PG_ENABLE_BASE_IDX                                                                       2
#define mmDSI_PG_STATUS                                                                                0x00a2
#define mmDSI_PG_STATUS_BASE_IDX                                                                       2
#define mmDCFEV0_PG_CONFIG                                                                             0x00a3
#define mmDCFEV0_PG_CONFIG_BASE_IDX                                                                    2
#define mmDCFEV0_PG_ENABLE                                                                             0x00a4
#define mmDCFEV0_PG_ENABLE_BASE_IDX                                                                    2
#define mmDCFEV0_PG_STATUS                                                                             0x00a5
#define mmDCFEV0_PG_STATUS_BASE_IDX                                                                    2
#define mmDCPG_INTERRUPT_STATUS                                                                        0x00a6
#define mmDCPG_INTERRUPT_STATUS_BASE_IDX                                                               2
#define mmDCPG_INTERRUPT_CONTROL                                                                       0x00a7
#define mmDCPG_INTERRUPT_CONTROL_BASE_IDX                                                              2
#define mmDCPG_INTERRUPT_CONTROL2                                                                      0x00a8
#define mmDCPG_INTERRUPT_CONTROL2_BASE_IDX                                                             2
#define mmDCFEV1_PG_CONFIG                                                                             0x00a9
#define mmDCFEV1_PG_CONFIG_BASE_IDX                                                                    2
#define mmDCFEV1_PG_ENABLE                                                                             0x00aa
#define mmDCFEV1_PG_ENABLE_BASE_IDX                                                                    2
#define mmDCFEV1_PG_STATUS                                                                             0x00ab
#define mmDCFEV1_PG_STATUS_BASE_IDX                                                                    2
#define mmDC_IP_REQUEST_CNTL                                                                           0x00ac
#define mmDC_IP_REQUEST_CNTL_BASE_IDX                                                                  2
#define mmDC_PGCNTL_STATUS_REG                                                                         0x00ad
#define mmDC_PGCNTL_STATUS_REG_BASE_IDX                                                                2
#define mmDMIFV_STATUS                                                                                 0x00c3
#define mmDMIFV_STATUS_BASE_IDX                                                                        2
#define mmDMIF_CONTROL                                                                                 0x00c4
#define mmDMIF_CONTROL_BASE_IDX                                                                        2
#define mmDMIF_STATUS                                                                                  0x00c5
#define mmDMIF_STATUS_BASE_IDX                                                                         2
#define mmDMIF_ARBITRATION_CONTROL                                                                     0x00c7
#define mmDMIF_ARBITRATION_CONTROL_BASE_IDX                                                            2
#define mmPIPE0_ARBITRATION_CONTROL3                                                                   0x00c8
#define mmPIPE0_ARBITRATION_CONTROL3_BASE_IDX                                                          2
#define mmPIPE1_ARBITRATION_CONTROL3                                                                   0x00c9
#define mmPIPE1_ARBITRATION_CONTROL3_BASE_IDX                                                          2
#define mmPIPE2_ARBITRATION_CONTROL3                                                                   0x00ca
#define mmPIPE2_ARBITRATION_CONTROL3_BASE_IDX                                                          2
#define mmPIPE3_ARBITRATION_CONTROL3                                                                   0x00cb
#define mmPIPE3_ARBITRATION_CONTROL3_BASE_IDX                                                          2
#define mmPIPE4_ARBITRATION_CONTROL3                                                                   0x00cc
#define mmPIPE4_ARBITRATION_CONTROL3_BASE_IDX                                                          2
#define mmPIPE5_ARBITRATION_CONTROL3                                                                   0x00cd
#define mmPIPE5_ARBITRATION_CONTROL3_BASE_IDX                                                          2
#define mmDMIF_P_VMID                                                                                  0x00ce
#define mmDMIF_P_VMID_BASE_IDX                                                                         2
#define mmDMIF_ADDR_CALC                                                                               0x00d1
#define mmDMIF_ADDR_CALC_BASE_IDX                                                                      2
#define mmDMIF_STATUS2                                                                                 0x00d2
#define mmDMIF_STATUS2_BASE_IDX                                                                        2
#define mmPIPE0_MAX_REQUESTS                                                                           0x00d3
#define mmPIPE0_MAX_REQUESTS_BASE_IDX                                                                  2
#define mmPIPE1_MAX_REQUESTS                                                                           0x00d4
#define mmPIPE1_MAX_REQUESTS_BASE_IDX                                                                  2
#define mmPIPE2_MAX_REQUESTS                                                                           0x00d5
#define mmPIPE2_MAX_REQUESTS_BASE_IDX                                                                  2
#define mmPIPE3_MAX_REQUESTS                                                                           0x00d6
#define mmPIPE3_MAX_REQUESTS_BASE_IDX                                                                  2
#define mmPIPE4_MAX_REQUESTS                                                                           0x00d7
#define mmPIPE4_MAX_REQUESTS_BASE_IDX                                                                  2
#define mmPIPE5_MAX_REQUESTS                                                                           0x00d8
#define mmPIPE5_MAX_REQUESTS_BASE_IDX                                                                  2
#define mmLOW_POWER_TILING_CONTROL                                                                     0x00d9
#define mmLOW_POWER_TILING_CONTROL_BASE_IDX                                                            2
#define mmMCIF_CONTROL                                                                                 0x00da
#define mmMCIF_CONTROL_BASE_IDX                                                                        2
#define mmMCIF_WRITE_COMBINE_CONTROL                                                                   0x00db
#define mmMCIF_WRITE_COMBINE_CONTROL_BASE_IDX                                                          2
#define mmMCIF_PHASE0_OUTSTANDING_COUNTER                                                              0x00de
#define mmMCIF_PHASE0_OUTSTANDING_COUNTER_BASE_IDX                                                     2
#define mmCC_DC_PIPE_DIS                                                                               0x00e0
#define mmCC_DC_PIPE_DIS_BASE_IDX                                                                      2
#define mmSMU_WM_CONTROL                                                                               0x00e1
#define mmSMU_WM_CONTROL_BASE_IDX                                                                      2
#define mmRBBMIF_TIMEOUT                                                                               0x00e2
#define mmRBBMIF_TIMEOUT_BASE_IDX                                                                      2
#define mmRBBMIF_STATUS                                                                                0x00e3
#define mmRBBMIF_STATUS_BASE_IDX                                                                       2
#define mmRBBMIF_TIMEOUT_DIS                                                                           0x00e4
#define mmRBBMIF_TIMEOUT_DIS_BASE_IDX                                                                  2
#define mmDCI_MEM_PWR_STATUS                                                                           0x00e5
#define mmDCI_MEM_PWR_STATUS_BASE_IDX                                                                  2
#define mmDCI_MEM_PWR_STATUS2                                                                          0x00e6
#define mmDCI_MEM_PWR_STATUS2_BASE_IDX                                                                 2
#define mmDCI_CLK_CNTL                                                                                 0x00e7
#define mmDCI_CLK_CNTL_BASE_IDX                                                                        2
#define mmDCI_CLK_CNTL2                                                                                0x00e8
#define mmDCI_CLK_CNTL2_BASE_IDX                                                                       2
#define mmDCI_MEM_PWR_CNTL                                                                             0x00e9
#define mmDCI_MEM_PWR_CNTL_BASE_IDX                                                                    2
#define mmDCI_MEM_PWR_CNTL2                                                                            0x00ea
#define mmDCI_MEM_PWR_CNTL2_BASE_IDX                                                                   2
#define mmDCI_MEM_PWR_CNTL3                                                                            0x00eb
#define mmDCI_MEM_PWR_CNTL3_BASE_IDX                                                                   2
#define mmPIPE0_DMIF_BUFFER_CONTROL                                                                    0x00ef
#define mmPIPE0_DMIF_BUFFER_CONTROL_BASE_IDX                                                           2
#define mmPIPE1_DMIF_BUFFER_CONTROL                                                                    0x00f0
#define mmPIPE1_DMIF_BUFFER_CONTROL_BASE_IDX                                                           2
#define mmPIPE2_DMIF_BUFFER_CONTROL                                                                    0x00f1
#define mmPIPE2_DMIF_BUFFER_CONTROL_BASE_IDX                                                           2
#define mmPIPE3_DMIF_BUFFER_CONTROL                                                                    0x00f2
#define mmPIPE3_DMIF_BUFFER_CONTROL_BASE_IDX                                                           2
#define mmPIPE4_DMIF_BUFFER_CONTROL                                                                    0x00f3
#define mmPIPE4_DMIF_BUFFER_CONTROL_BASE_IDX                                                           2
#define mmPIPE5_DMIF_BUFFER_CONTROL                                                                    0x00f4
#define mmPIPE5_DMIF_BUFFER_CONTROL_BASE_IDX                                                           2
#define mmRBBMIF_STATUS_FLAG                                                                           0x00f5
#define mmRBBMIF_STATUS_FLAG_BASE_IDX                                                                  2
#define mmDCI_SOFT_RESET                                                                               0x00f6
#define mmDCI_SOFT_RESET_BASE_IDX                                                                      2
#define mmDMIF_URG_OVERRIDE                                                                            0x00f7
#define mmDMIF_URG_OVERRIDE_BASE_IDX                                                                   2
#define mmPIPE6_ARBITRATION_CONTROL3                                                                   0x00f8
#define mmPIPE6_ARBITRATION_CONTROL3_BASE_IDX                                                          2
#define mmPIPE7_ARBITRATION_CONTROL3                                                                   0x00f9
#define mmPIPE7_ARBITRATION_CONTROL3_BASE_IDX                                                          2
#define mmPIPE6_MAX_REQUESTS                                                                           0x00fa
#define mmPIPE6_MAX_REQUESTS_BASE_IDX                                                                  2
#define mmPIPE7_MAX_REQUESTS                                                                           0x00fb
#define mmPIPE7_MAX_REQUESTS_BASE_IDX                                                                  2
#define mmDVMM_REG_RD_STATUS                                                                           0x00fc
#define mmDVMM_REG_RD_STATUS_BASE_IDX                                                                  2
#define mmDVMM_REG_RD_DATA                                                                             0x00fd
#define mmDVMM_REG_RD_DATA_BASE_IDX                                                                    2
#define mmDVMM_PTE_REQ                                                                                 0x00fe
#define mmDVMM_PTE_REQ_BASE_IDX                                                                        2
#define mmDVMM_CNTL                                                                                    0x00ff
#define mmDVMM_CNTL_BASE_IDX                                                                           2
#define mmDVMM_FAULT_STATUS                                                                            0x0100
#define mmDVMM_FAULT_STATUS_BASE_IDX                                                                   2
#define mmDVMM_FAULT_ADDR                                                                              0x0101
#define mmDVMM_FAULT_ADDR_BASE_IDX                                                                     2
#define mmFMON_CTRL                                                                                    0x0102
#define mmFMON_CTRL_BASE_IDX                                                                           2
#define mmDVMM_PTE_PGMEM_CONTROL                                                                       0x0103
#define mmDVMM_PTE_PGMEM_CONTROL_BASE_IDX                                                              2
#define mmDVMM_PTE_PGMEM_STATE                                                                         0x0104
#define mmDVMM_PTE_PGMEM_STATE_BASE_IDX                                                                2
#define mmMCIF_PHASE1_OUTSTANDING_COUNTER                                                              0x0105
#define mmMCIF_PHASE1_OUTSTANDING_COUNTER_BASE_IDX                                                     2
#define mmMCIF_PHASE2_OUTSTANDING_COUNTER                                                              0x0106
#define mmMCIF_PHASE2_OUTSTANDING_COUNTER_BASE_IDX                                                     2
#define mmMCIF_WB_PHASE0_OUTSTANDING_COUNTER                                                           0x0107
#define mmMCIF_WB_PHASE0_OUTSTANDING_COUNTER_BASE_IDX                                                  2
#define mmMCIF_WB_PHASE1_OUTSTANDING_COUNTER                                                           0x0108
#define mmMCIF_WB_PHASE1_OUTSTANDING_COUNTER_BASE_IDX                                                  2
#define mmDCI_MEM_PWR_CNTL4                                                                            0x0109
#define mmDCI_MEM_PWR_CNTL4_BASE_IDX                                                                   2
#define mmMCIF_WB_MISC_CTRL                                                                            0x010a
#define mmMCIF_WB_MISC_CTRL_BASE_IDX                                                                   2
#define mmDCI_MEM_PWR_STATUS3                                                                          0x010b
#define mmDCI_MEM_PWR_STATUS3_BASE_IDX                                                                 2
#define mmDMIF_CURSOR_CONTROL                                                                          0x010c
#define mmDMIF_CURSOR_CONTROL_BASE_IDX                                                                 2
#define mmDMIF_CURSOR_MEM_CONTROL                                                                      0x010d
#define mmDMIF_CURSOR_MEM_CONTROL_BASE_IDX                                                             2
#define mmDCHUB_FB_LOCATION                                                                            0x0126
#define mmDCHUB_FB_LOCATION_BASE_IDX                                                                   2
#define mmDCHUB_FB_OFFSET                                                                              0x0127
#define mmDCHUB_FB_OFFSET_BASE_IDX                                                                     2
#define mmDCHUB_AGP_BASE                                                                               0x0128
#define mmDCHUB_AGP_BASE_BASE_IDX                                                                      2
#define mmDCHUB_AGP_BOT                                                                                0x0129
#define mmDCHUB_AGP_BOT_BASE_IDX                                                                       2
#define mmDCHUB_AGP_TOP                                                                                0x012a
#define mmDCHUB_AGP_TOP_BASE_IDX                                                                       2
#define mmDCHUB_DRAM_APER_BASE                                                                         0x012b
#define mmDCHUB_DRAM_APER_BASE_BASE_IDX                                                                2
#define mmDCHUB_DRAM_APER_DEF                                                                          0x012c
#define mmDCHUB_DRAM_APER_DEF_BASE_IDX                                                                 2
#define mmDCHUB_DRAM_APER_TOP                                                                          0x012d
#define mmDCHUB_DRAM_APER_TOP_BASE_IDX                                                                 2
#define mmDCHUB_CONTROL_STATUS                                                                         0x012e
#define mmDCHUB_CONTROL_STATUS_BASE_IDX                                                                2
#define mmWB_ENABLE                                                                                    0x0212
#define mmWB_ENABLE_BASE_IDX                                                                           2
#define mmWB_EC_CONFIG                                                                                 0x0213
#define mmWB_EC_CONFIG_BASE_IDX                                                                        2
#define mmCNV_MODE                                                                                     0x0214
#define mmCNV_MODE_BASE_IDX                                                                            2
#define mmCNV_WINDOW_START                                                                             0x0215
#define mmCNV_WINDOW_START_BASE_IDX                                                                    2
#define mmCNV_WINDOW_SIZE                                                                              0x0216
#define mmCNV_WINDOW_SIZE_BASE_IDX                                                                     2
#define mmCNV_UPDATE                                                                                   0x0217
#define mmCNV_UPDATE_BASE_IDX                                                                          2
#define mmCNV_SOURCE_SIZE                                                                              0x0218
#define mmCNV_SOURCE_SIZE_BASE_IDX                                                                     2
#define mmCNV_CSC_CONTROL                                                                              0x0219
#define mmCNV_CSC_CONTROL_BASE_IDX                                                                     2
#define mmCNV_CSC_C11_C12                                                                              0x021a
#define mmCNV_CSC_C11_C12_BASE_IDX                                                                     2
#define mmCNV_CSC_C13_C14                                                                              0x021b
#define mmCNV_CSC_C13_C14_BASE_IDX                                                                     2
#define mmCNV_CSC_C21_C22                                                                              0x021c
#define mmCNV_CSC_C21_C22_BASE_IDX                                                                     2
#define mmCNV_CSC_C23_C24                                                                              0x021d
#define mmCNV_CSC_C23_C24_BASE_IDX                                                                     2
#define mmCNV_CSC_C31_C32                                                                              0x021e
#define mmCNV_CSC_C31_C32_BASE_IDX                                                                     2
#define mmCNV_CSC_C33_C34                                                                              0x021f
#define mmCNV_CSC_C33_C34_BASE_IDX                                                                     2
#define mmCNV_CSC_ROUND_OFFSET_R                                                                       0x0220
#define mmCNV_CSC_ROUND_OFFSET_R_BASE_IDX                                                              2
#define mmCNV_CSC_ROUND_OFFSET_G                                                                       0x0221
#define mmCNV_CSC_ROUND_OFFSET_G_BASE_IDX                                                              2
#define mmCNV_CSC_ROUND_OFFSET_B                                                                       0x0222
#define mmCNV_CSC_ROUND_OFFSET_B_BASE_IDX                                                              2
#define mmCNV_CSC_CLAMP_R                                                                              0x0223
#define mmCNV_CSC_CLAMP_R_BASE_IDX                                                                     2
#define mmCNV_CSC_CLAMP_G                                                                              0x0224
#define mmCNV_CSC_CLAMP_G_BASE_IDX                                                                     2
#define mmCNV_CSC_CLAMP_B                                                                              0x0225
#define mmCNV_CSC_CLAMP_B_BASE_IDX                                                                     2
#define mmCNV_TEST_CNTL                                                                                0x0226
#define mmCNV_TEST_CNTL_BASE_IDX                                                                       2
#define mmCNV_TEST_CRC_RED                                                                             0x0227
#define mmCNV_TEST_CRC_RED_BASE_IDX                                                                    2
#define mmCNV_TEST_CRC_GREEN                                                                           0x0228
#define mmCNV_TEST_CRC_GREEN_BASE_IDX                                                                  2
#define mmCNV_TEST_CRC_BLUE                                                                            0x0229
#define mmCNV_TEST_CRC_BLUE_BASE_IDX                                                                   2
#define mmCNV_INPUT_SELECT                                                                             0x022d
#define mmCNV_INPUT_SELECT_BASE_IDX                                                                    2
#define mmWB_SOFT_RESET                                                                                0x0230
#define mmWB_SOFT_RESET_BASE_IDX                                                                       2
#define mmWB_WARM_UP_MODE_CTL1                                                                         0x0231
#define mmWB_WARM_UP_MODE_CTL1_BASE_IDX                                                                2
#define mmWB_WARM_UP_MODE_CTL2                                                                         0x0232
#define mmWB_WARM_UP_MODE_CTL2_BASE_IDX                                                                2
#define mmWBSCL_COEF_RAM_SELECT                                                                        0x0242
#define mmWBSCL_COEF_RAM_SELECT_BASE_IDX                                                               2
#define mmWBSCL_COEF_RAM_TAP_DATA                                                                      0x0243
#define mmWBSCL_COEF_RAM_TAP_DATA_BASE_IDX                                                             2
#define mmWBSCL_MODE                                                                                   0x0244
#define mmWBSCL_MODE_BASE_IDX                                                                          2
#define mmWBSCL_TAP_CONTROL                                                                            0x0245
#define mmWBSCL_TAP_CONTROL_BASE_IDX                                                                   2
#define mmWBSCL_DEST_SIZE                                                                              0x0246
#define mmWBSCL_DEST_SIZE_BASE_IDX                                                                     2
#define mmWBSCL_HORZ_FILTER_SCALE_RATIO                                                                0x0247
#define mmWBSCL_HORZ_FILTER_SCALE_RATIO_BASE_IDX                                                       2
#define mmWBSCL_HORZ_FILTER_INIT_Y_RGB                                                                 0x0248
#define mmWBSCL_HORZ_FILTER_INIT_Y_RGB_BASE_IDX                                                        2
#define mmWBSCL_HORZ_FILTER_INIT_CBCR                                                                  0x0249
#define mmWBSCL_HORZ_FILTER_INIT_CBCR_BASE_IDX                                                         2
#define mmWBSCL_VERT_FILTER_SCALE_RATIO                                                                0x024a
#define mmWBSCL_VERT_FILTER_SCALE_RATIO_BASE_IDX                                                       2
#define mmWBSCL_VERT_FILTER_INIT_Y_RGB                                                                 0x024b
#define mmWBSCL_VERT_FILTER_INIT_Y_RGB_BASE_IDX                                                        2
#define mmWBSCL_VERT_FILTER_INIT_CBCR                                                                  0x024c
#define mmWBSCL_VERT_FILTER_INIT_CBCR_BASE_IDX                                                         2
#define mmWBSCL_ROUND_OFFSET                                                                           0x024d
#define mmWBSCL_ROUND_OFFSET_BASE_IDX                                                                  2
#define mmWBSCL_CLAMP                                                                                  0x024e
#define mmWBSCL_CLAMP_BASE_IDX                                                                         2
#define mmWBSCL_OVERFLOW_STATUS                                                                        0x024f
#define mmWBSCL_OVERFLOW_STATUS_BASE_IDX                                                               2
#define mmWBSCL_COEF_RAM_CONFLICT_STATUS                                                               0x0250
#define mmWBSCL_COEF_RAM_CONFLICT_STATUS_BASE_IDX                                                      2
#define mmWBSCL_OUTSIDE_PIX_STRATEGY                                                                   0x0251
#define mmWBSCL_OUTSIDE_PIX_STRATEGY_BASE_IDX                                                          2
#define mmWBSCL_TEST_CNTL                                                                              0x0252
#define mmWBSCL_TEST_CNTL_BASE_IDX                                                                     2
#define mmWBSCL_TEST_CRC_RED                                                                           0x0253
#define mmWBSCL_TEST_CRC_RED_BASE_IDX                                                                  2
#define mmWBSCL_TEST_CRC_GREEN                                                                         0x0254
#define mmWBSCL_TEST_CRC_GREEN_BASE_IDX                                                                2
#define mmWBSCL_TEST_CRC_BLUE                                                                          0x0255
#define mmWBSCL_TEST_CRC_BLUE_BASE_IDX                                                                 2
#define mmWBSCL_BACKPRESSURE_CNT_EN                                                                    0x0256
#define mmWBSCL_BACKPRESSURE_CNT_EN_BASE_IDX                                                           2
#define mmWB_MCIF_BACKPRESSURE_CNT                                                                     0x0257
#define mmWB_MCIF_BACKPRESSURE_CNT_BASE_IDX                                                            2
#define mmWBSCL_RAM_SHUTDOWN                                                                           0x025a
#define mmWBSCL_RAM_SHUTDOWN_BASE_IDX                                                                  2
#define mmDMCU_CTRL                                                                                    0x03b6
#define mmDMCU_CTRL_BASE_IDX                                                                           2
#define mmDMCU_STATUS                                                                                  0x03b7
#define mmDMCU_STATUS_BASE_IDX                                                                         2
#define mmDMCU_PC_START_ADDR                                                                           0x03b8
#define mmDMCU_PC_START_ADDR_BASE_IDX                                                                  2
#define mmDMCU_FW_START_ADDR                                                                           0x03b9
#define mmDMCU_FW_START_ADDR_BASE_IDX                                                                  2
#define mmDMCU_FW_END_ADDR                                                                             0x03ba
#define mmDMCU_FW_END_ADDR_BASE_IDX                                                                    2
#define mmDMCU_FW_ISR_START_ADDR                                                                       0x03bb
#define mmDMCU_FW_ISR_START_ADDR_BASE_IDX                                                              2
#define mmDMCU_FW_CS_HI                                                                                0x03bc
#define mmDMCU_FW_CS_HI_BASE_IDX                                                                       2
#define mmDMCU_FW_CS_LO                                                                                0x03bd
#define mmDMCU_FW_CS_LO_BASE_IDX                                                                       2
#define mmDMCU_RAM_ACCESS_CTRL                                                                         0x03be
#define mmDMCU_RAM_ACCESS_CTRL_BASE_IDX                                                                2
#define mmDMCU_ERAM_WR_CTRL                                                                            0x03bf
#define mmDMCU_ERAM_WR_CTRL_BASE_IDX                                                                   2
#define mmDMCU_ERAM_WR_DATA                                                                            0x03c0
#define mmDMCU_ERAM_WR_DATA_BASE_IDX                                                                   2
#define mmDMCU_ERAM_RD_CTRL                                                                            0x03c1
#define mmDMCU_ERAM_RD_CTRL_BASE_IDX                                                                   2
#define mmDMCU_ERAM_RD_DATA                                                                            0x03c2
#define mmDMCU_ERAM_RD_DATA_BASE_IDX                                                                   2
#define mmDMCU_IRAM_WR_CTRL                                                                            0x03c3
#define mmDMCU_IRAM_WR_CTRL_BASE_IDX                                                                   2
#define mmDMCU_IRAM_WR_DATA                                                                            0x03c4
#define mmDMCU_IRAM_WR_DATA_BASE_IDX                                                                   2
#define mmDMCU_IRAM_RD_CTRL                                                                            0x03c5
#define mmDMCU_IRAM_RD_CTRL_BASE_IDX                                                                   2
#define mmDMCU_IRAM_RD_DATA                                                                            0x03c6
#define mmDMCU_IRAM_RD_DATA_BASE_IDX                                                                   2
#define mmDMCU_EVENT_TRIGGER                                                                           0x03c7
#define mmDMCU_EVENT_TRIGGER_BASE_IDX                                                                  2
#define mmDMCU_UC_INTERNAL_INT_STATUS                                                                  0x03c8
#define mmDMCU_UC_INTERNAL_INT_STATUS_BASE_IDX                                                         2
#define mmDMCU_SS_INTERRUPT_CNTL_STATUS                                                                0x03c9
#define mmDMCU_SS_INTERRUPT_CNTL_STATUS_BASE_IDX                                                       2
#define mmDMCU_INTERRUPT_STATUS                                                                        0x03ca
#define mmDMCU_INTERRUPT_STATUS_BASE_IDX                                                               2
#define mmDMCU_INTERRUPT_TO_HOST_EN_MASK                                                               0x03cb
#define mmDMCU_INTERRUPT_TO_HOST_EN_MASK_BASE_IDX                                                      2
#define mmDMCU_INTERRUPT_TO_UC_EN_MASK                                                                 0x03cc
#define mmDMCU_INTERRUPT_TO_UC_EN_MASK_BASE_IDX                                                        2
#define mmDMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL                                                            0x03cd
#define mmDMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_BASE_IDX                                                   2
#define mmDC_DMCU_SCRATCH                                                                              0x03ce
#define mmDC_DMCU_SCRATCH_BASE_IDX                                                                     2
#define mmDMCU_INT_CNT                                                                                 0x03cf
#define mmDMCU_INT_CNT_BASE_IDX                                                                        2
#define mmDMCU_FW_CHECKSUM_SMPL_BYTE_POS                                                               0x03d0
#define mmDMCU_FW_CHECKSUM_SMPL_BYTE_POS_BASE_IDX                                                      2
#define mmDMCU_UC_CLK_GATING_CNTL                                                                      0x03d1
#define mmDMCU_UC_CLK_GATING_CNTL_BASE_IDX                                                             2
#define mmMASTER_COMM_DATA_REG1                                                                        0x03d2
#define mmMASTER_COMM_DATA_REG1_BASE_IDX                                                               2
#define mmMASTER_COMM_DATA_REG2                                                                        0x03d3
#define mmMASTER_COMM_DATA_REG2_BASE_IDX                                                               2
#define mmMASTER_COMM_DATA_REG3                                                                        0x03d4
#define mmMASTER_COMM_DATA_REG3_BASE_IDX                                                               2
#define mmMASTER_COMM_CMD_REG                                                                          0x03d5
#define mmMASTER_COMM_CMD_REG_BASE_IDX                                                                 2
#define mmMASTER_COMM_CNTL_REG                                                                         0x03d6
#define mmMASTER_COMM_CNTL_REG_BASE_IDX                                                                2
#define mmSLAVE_COMM_DATA_REG1                                                                         0x03d7
#define mmSLAVE_COMM_DATA_REG1_BASE_IDX                                                                2
#define mmSLAVE_COMM_DATA_REG2                                                                         0x03d8
#define mmSLAVE_COMM_DATA_REG2_BASE_IDX                                                                2
#define mmSLAVE_COMM_DATA_REG3                                                                         0x03d9
#define mmSLAVE_COMM_DATA_REG3_BASE_IDX                                                                2
#define mmSLAVE_COMM_CMD_REG                                                                           0x03da
#define mmSLAVE_COMM_CMD_REG_BASE_IDX                                                                  2
#define mmSLAVE_COMM_CNTL_REG                                                                          0x03db
#define mmSLAVE_COMM_CNTL_REG_BASE_IDX                                                                 2
#define mmBL1_PWM_AMBIENT_LIGHT_LEVEL                                                                  0x03de
#define mmBL1_PWM_AMBIENT_LIGHT_LEVEL_BASE_IDX                                                         2
#define mmBL1_PWM_USER_LEVEL                                                                           0x03df
#define mmBL1_PWM_USER_LEVEL_BASE_IDX                                                                  2
#define mmBL1_PWM_TARGET_ABM_LEVEL                                                                     0x03e0
#define mmBL1_PWM_TARGET_ABM_LEVEL_BASE_IDX                                                            2
#define mmBL1_PWM_CURRENT_ABM_LEVEL                                                                    0x03e1
#define mmBL1_PWM_CURRENT_ABM_LEVEL_BASE_IDX                                                           2
#define mmBL1_PWM_FINAL_DUTY_CYCLE                                                                     0x03e2
#define mmBL1_PWM_FINAL_DUTY_CYCLE_BASE_IDX                                                            2
#define mmBL1_PWM_MINIMUM_DUTY_CYCLE                                                                   0x03e3
#define mmBL1_PWM_MINIMUM_DUTY_CYCLE_BASE_IDX                                                          2
#define mmBL1_PWM_ABM_CNTL                                                                             0x03e4
#define mmBL1_PWM_ABM_CNTL_BASE_IDX                                                                    2
#define mmBL1_PWM_BL_UPDATE_SAMPLE_RATE                                                                0x03e5
#define mmBL1_PWM_BL_UPDATE_SAMPLE_RATE_BASE_IDX                                                       2
#define mmBL1_PWM_GRP2_REG_LOCK                                                                        0x03e6
#define mmBL1_PWM_GRP2_REG_LOCK_BASE_IDX                                                               2
#define mmDMCU_INTERRUPT_TO_UC_EN_MASK_1                                                               0x03e7
#define mmDMCU_INTERRUPT_TO_UC_EN_MASK_1_BASE_IDX                                                      2
#define mmDMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1                                                          0x03e8
#define mmDMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1_BASE_IDX                                                 2
#define mmDMCU_INTERRUPT_STATUS_1                                                                      0x03e9
#define mmDMCU_INTERRUPT_STATUS_1_BASE_IDX                                                             2
#define mmDMCU_DPRX_INTERRUPT_STATUS1                                                                  0x03ea
#define mmDMCU_DPRX_INTERRUPT_STATUS1_BASE_IDX                                                         2
#define mmDMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1                                                           0x03eb
#define mmDMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1_BASE_IDX                                                  2
#define mmDMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1                                                      0x03ec
#define mmDMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1_BASE_IDX                                             2
#define mmDC_ABM1_CNTL                                                                                 0x03ee
#define mmDC_ABM1_CNTL_BASE_IDX                                                                        2
#define mmDC_ABM1_IPCSC_COEFF_SEL                                                                      0x03ef
#define mmDC_ABM1_IPCSC_COEFF_SEL_BASE_IDX                                                             2
#define mmDC_ABM1_ACE_OFFSET_SLOPE_0                                                                   0x03f0
#define mmDC_ABM1_ACE_OFFSET_SLOPE_0_BASE_IDX                                                          2
#define mmDC_ABM1_ACE_OFFSET_SLOPE_1                                                                   0x03f1
#define mmDC_ABM1_ACE_OFFSET_SLOPE_1_BASE_IDX                                                          2
#define mmDC_ABM1_ACE_OFFSET_SLOPE_2                                                                   0x03f2
#define mmDC_ABM1_ACE_OFFSET_SLOPE_2_BASE_IDX                                                          2
#define mmDC_ABM1_ACE_OFFSET_SLOPE_3                                                                   0x03f3
#define mmDC_ABM1_ACE_OFFSET_SLOPE_3_BASE_IDX                                                          2
#define mmDC_ABM1_ACE_OFFSET_SLOPE_4                                                                   0x03f4
#define mmDC_ABM1_ACE_OFFSET_SLOPE_4_BASE_IDX                                                          2
#define mmDC_ABM1_ACE_THRES_12                                                                         0x03f5
#define mmDC_ABM1_ACE_THRES_12_BASE_IDX                                                                2
#define mmDC_ABM1_ACE_THRES_34                                                                         0x03f6
#define mmDC_ABM1_ACE_THRES_34_BASE_IDX                                                                2
#define mmDC_ABM1_ACE_CNTL_MISC                                                                        0x03f7
#define mmDC_ABM1_ACE_CNTL_MISC_BASE_IDX                                                               2
#define mmDMCU_PERFMON_INTERRUPT_STATUS5                                                               0x03f8
#define mmDMCU_PERFMON_INTERRUPT_STATUS5_BASE_IDX                                                      2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5                                                        0x03f9
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5_BASE_IDX                                               2
#define mmDMCU_PERFMON_INTERRUPT_STATUS1                                                               0x03fa
#define mmDMCU_PERFMON_INTERRUPT_STATUS1_BASE_IDX                                                      2
#define mmDMCU_PERFMON_INTERRUPT_STATUS2                                                               0x03fb
#define mmDMCU_PERFMON_INTERRUPT_STATUS2_BASE_IDX                                                      2
#define mmDMCU_PERFMON_INTERRUPT_STATUS3                                                               0x03fc
#define mmDMCU_PERFMON_INTERRUPT_STATUS3_BASE_IDX                                                      2
#define mmDMCU_PERFMON_INTERRUPT_STATUS4                                                               0x03fd
#define mmDMCU_PERFMON_INTERRUPT_STATUS4_BASE_IDX                                                      2
#define mmDC_ABM1_HGLS_REG_READ_PROGRESS                                                               0x0400
#define mmDC_ABM1_HGLS_REG_READ_PROGRESS_BASE_IDX                                                      2
#define mmDC_ABM1_HG_MISC_CTRL                                                                         0x0401
#define mmDC_ABM1_HG_MISC_CTRL_BASE_IDX                                                                2
#define mmDC_ABM1_LS_SUM_OF_LUMA                                                                       0x0402
#define mmDC_ABM1_LS_SUM_OF_LUMA_BASE_IDX                                                              2
#define mmDC_ABM1_LS_MIN_MAX_LUMA                                                                      0x0403
#define mmDC_ABM1_LS_MIN_MAX_LUMA_BASE_IDX                                                             2
#define mmDC_ABM1_LS_FILTERED_MIN_MAX_LUMA                                                             0x0404
#define mmDC_ABM1_LS_FILTERED_MIN_MAX_LUMA_BASE_IDX                                                    2
#define mmDC_ABM1_LS_PIXEL_COUNT                                                                       0x0405
#define mmDC_ABM1_LS_PIXEL_COUNT_BASE_IDX                                                              2
#define mmDC_ABM1_LS_OVR_SCAN_BIN                                                                      0x0406
#define mmDC_ABM1_LS_OVR_SCAN_BIN_BASE_IDX                                                             2
#define mmDC_ABM1_LS_MIN_MAX_PIXEL_VALUE_THRES                                                         0x0407
#define mmDC_ABM1_LS_MIN_MAX_PIXEL_VALUE_THRES_BASE_IDX                                                2
#define mmDC_ABM1_LS_MIN_PIXEL_VALUE_COUNT                                                             0x0408
#define mmDC_ABM1_LS_MIN_PIXEL_VALUE_COUNT_BASE_IDX                                                    2
#define mmDC_ABM1_LS_MAX_PIXEL_VALUE_COUNT                                                             0x0409
#define mmDC_ABM1_LS_MAX_PIXEL_VALUE_COUNT_BASE_IDX                                                    2
#define mmDC_ABM1_HG_SAMPLE_RATE                                                                       0x040a
#define mmDC_ABM1_HG_SAMPLE_RATE_BASE_IDX                                                              2
#define mmDC_ABM1_LS_SAMPLE_RATE                                                                       0x040b
#define mmDC_ABM1_LS_SAMPLE_RATE_BASE_IDX                                                              2
#define mmDC_ABM1_HG_BIN_1_32_SHIFT_FLAG                                                               0x040c
#define mmDC_ABM1_HG_BIN_1_32_SHIFT_FLAG_BASE_IDX                                                      2
#define mmDC_ABM1_HG_BIN_1_8_SHIFT_INDEX                                                               0x040d
#define mmDC_ABM1_HG_BIN_1_8_SHIFT_INDEX_BASE_IDX                                                      2
#define mmDC_ABM1_HG_BIN_9_16_SHIFT_INDEX                                                              0x040e
#define mmDC_ABM1_HG_BIN_9_16_SHIFT_INDEX_BASE_IDX                                                     2
#define mmDC_ABM1_HG_BIN_17_24_SHIFT_INDEX                                                             0x040f
#define mmDC_ABM1_HG_BIN_17_24_SHIFT_INDEX_BASE_IDX                                                    2
#define mmDC_ABM1_HG_BIN_25_32_SHIFT_INDEX                                                             0x0410
#define mmDC_ABM1_HG_BIN_25_32_SHIFT_INDEX_BASE_IDX                                                    2
#define mmDC_ABM1_HG_RESULT_1                                                                          0x0411
#define mmDC_ABM1_HG_RESULT_1_BASE_IDX                                                                 2
#define mmDC_ABM1_HG_RESULT_2                                                                          0x0412
#define mmDC_ABM1_HG_RESULT_2_BASE_IDX                                                                 2
#define mmDC_ABM1_HG_RESULT_3                                                                          0x0413
#define mmDC_ABM1_HG_RESULT_3_BASE_IDX                                                                 2
#define mmDC_ABM1_HG_RESULT_4                                                                          0x0414
#define mmDC_ABM1_HG_RESULT_4_BASE_IDX                                                                 2
#define mmDC_ABM1_HG_RESULT_5                                                                          0x0415
#define mmDC_ABM1_HG_RESULT_5_BASE_IDX                                                                 2
#define mmDC_ABM1_HG_RESULT_6                                                                          0x0416
#define mmDC_ABM1_HG_RESULT_6_BASE_IDX                                                                 2
#define mmDC_ABM1_HG_RESULT_7                                                                          0x0417
#define mmDC_ABM1_HG_RESULT_7_BASE_IDX                                                                 2
#define mmDC_ABM1_HG_RESULT_8                                                                          0x0418
#define mmDC_ABM1_HG_RESULT_8_BASE_IDX                                                                 2
#define mmDC_ABM1_HG_RESULT_9                                                                          0x0419
#define mmDC_ABM1_HG_RESULT_9_BASE_IDX                                                                 2
#define mmDC_ABM1_HG_RESULT_10                                                                         0x041a
#define mmDC_ABM1_HG_RESULT_10_BASE_IDX                                                                2
#define mmDC_ABM1_HG_RESULT_11                                                                         0x041b
#define mmDC_ABM1_HG_RESULT_11_BASE_IDX                                                                2
#define mmDC_ABM1_HG_RESULT_12                                                                         0x041c
#define mmDC_ABM1_HG_RESULT_12_BASE_IDX                                                                2
#define mmDC_ABM1_HG_RESULT_13                                                                         0x041d
#define mmDC_ABM1_HG_RESULT_13_BASE_IDX                                                                2
#define mmDC_ABM1_HG_RESULT_14                                                                         0x041e
#define mmDC_ABM1_HG_RESULT_14_BASE_IDX                                                                2
#define mmDC_ABM1_HG_RESULT_15                                                                         0x041f
#define mmDC_ABM1_HG_RESULT_15_BASE_IDX                                                                2
#define mmDC_ABM1_HG_RESULT_16                                                                         0x0420
#define mmDC_ABM1_HG_RESULT_16_BASE_IDX                                                                2
#define mmDC_ABM1_HG_RESULT_17                                                                         0x0421
#define mmDC_ABM1_HG_RESULT_17_BASE_IDX                                                                2
#define mmDC_ABM1_HG_RESULT_18                                                                         0x0422
#define mmDC_ABM1_HG_RESULT_18_BASE_IDX                                                                2
#define mmDC_ABM1_HG_RESULT_19                                                                         0x0423
#define mmDC_ABM1_HG_RESULT_19_BASE_IDX                                                                2
#define mmDC_ABM1_HG_RESULT_20                                                                         0x0424
#define mmDC_ABM1_HG_RESULT_20_BASE_IDX                                                                2
#define mmDC_ABM1_HG_RESULT_21                                                                         0x0425
#define mmDC_ABM1_HG_RESULT_21_BASE_IDX                                                                2
#define mmDC_ABM1_HG_RESULT_22                                                                         0x0426
#define mmDC_ABM1_HG_RESULT_22_BASE_IDX                                                                2
#define mmDC_ABM1_HG_RESULT_23                                                                         0x0427
#define mmDC_ABM1_HG_RESULT_23_BASE_IDX                                                                2
#define mmDC_ABM1_HG_RESULT_24                                                                         0x0428
#define mmDC_ABM1_HG_RESULT_24_BASE_IDX                                                                2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5                                                   0x0429
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5_BASE_IDX                                          2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1                                                        0x042a
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1_BASE_IDX                                               2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2                                                        0x042b
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2_BASE_IDX                                               2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3                                                        0x042c
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3_BASE_IDX                                               2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4                                                        0x042d
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4_BASE_IDX                                               2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1                                                   0x042e
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1_BASE_IDX                                          2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2                                                   0x042f
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2_BASE_IDX                                          2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3                                                   0x0430
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3_BASE_IDX                                          2
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4                                                   0x0431
#define mmDMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4_BASE_IDX                                          2
#define mmDC_ABM1_OVERSCAN_PIXEL_VALUE                                                                 0x0451
#define mmDC_ABM1_OVERSCAN_PIXEL_VALUE_BASE_IDX                                                        2
#define mmDC_ABM1_BL_MASTER_LOCK                                                                       0x0452
#define mmDC_ABM1_BL_MASTER_LOCK_BASE_IDX                                                              2
#define mmAZALIA_CONTROLLER_CLOCK_GATING                                                               0x04bc
#define mmAZALIA_CONTROLLER_CLOCK_GATING_BASE_IDX                                                      2
#define mmAZALIA_AUDIO_DTO                                                                             0x04bd
#define mmAZALIA_AUDIO_DTO_BASE_IDX                                                                    2
#define mmAZALIA_AUDIO_DTO_CONTROL                                                                     0x04be
#define mmAZALIA_AUDIO_DTO_CONTROL_BASE_IDX                                                            2
#define mmAZALIA_SOCCLK_CONTROL                                                                        0x04bf
#define mmAZALIA_SOCCLK_CONTROL_BASE_IDX                                                               2
#define mmAZALIA_UNDERFLOW_FILLER_SAMPLE                                                               0x04c0
#define mmAZALIA_UNDERFLOW_FILLER_SAMPLE_BASE_IDX                                                      2
#define mmAZALIA_DATA_DMA_CONTROL                                                                      0x04c1
#define mmAZALIA_DATA_DMA_CONTROL_BASE_IDX                                                             2
#define mmAZALIA_BDL_DMA_CONTROL                                                                       0x04c2
#define mmAZALIA_BDL_DMA_CONTROL_BASE_IDX                                                              2
#define mmAZALIA_RIRB_AND_DP_CONTROL                                                                   0x04c3
#define mmAZALIA_RIRB_AND_DP_CONTROL_BASE_IDX                                                          2
#define mmAZALIA_CORB_DMA_CONTROL                                                                      0x04c4
#define mmAZALIA_CORB_DMA_CONTROL_BASE_IDX                                                             2
#define mmAZALIA_APPLICATION_POSITION_IN_CYCLIC_BUFFER                                                 0x04cb
#define mmAZALIA_APPLICATION_POSITION_IN_CYCLIC_BUFFER_BASE_IDX                                        2
#define mmAZALIA_CYCLIC_BUFFER_SYNC                                                                    0x04cc
#define mmAZALIA_CYCLIC_BUFFER_SYNC_BASE_IDX                                                           2
#define mmAZALIA_GLOBAL_CAPABILITIES                                                                   0x04cd
#define mmAZALIA_GLOBAL_CAPABILITIES_BASE_IDX                                                          2
#define mmAZALIA_OUTPUT_PAYLOAD_CAPABILITY                                                             0x04ce
#define mmAZALIA_OUTPUT_PAYLOAD_CAPABILITY_BASE_IDX                                                    2
#define mmAZALIA_OUTPUT_STREAM_ARBITER_CONTROL                                                         0x04cf
#define mmAZALIA_OUTPUT_STREAM_ARBITER_CONTROL_BASE_IDX                                                2
#define mmAZALIA_INPUT_PAYLOAD_CAPABILITY                                                              0x04d0
#define mmAZALIA_INPUT_PAYLOAD_CAPABILITY_BASE_IDX                                                     2
#define mmAZALIA_INPUT_CRC0_CONTROL0                                                                   0x04d3
#define mmAZALIA_INPUT_CRC0_CONTROL0_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC0_CONTROL1                                                                   0x04d4
#define mmAZALIA_INPUT_CRC0_CONTROL1_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC0_CONTROL2                                                                   0x04d5
#define mmAZALIA_INPUT_CRC0_CONTROL2_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC0_CONTROL3                                                                   0x04d6
#define mmAZALIA_INPUT_CRC0_CONTROL3_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC0_RESULT                                                                     0x04d7
#define mmAZALIA_INPUT_CRC0_RESULT_BASE_IDX                                                            2
#define mmAZALIA_INPUT_CRC1_CONTROL0                                                                   0x04d8
#define mmAZALIA_INPUT_CRC1_CONTROL0_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC1_CONTROL1                                                                   0x04d9
#define mmAZALIA_INPUT_CRC1_CONTROL1_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC1_CONTROL2                                                                   0x04da
#define mmAZALIA_INPUT_CRC1_CONTROL2_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC1_CONTROL3                                                                   0x04db
#define mmAZALIA_INPUT_CRC1_CONTROL3_BASE_IDX                                                          2
#define mmAZALIA_INPUT_CRC1_RESULT                                                                     0x04dc
#define mmAZALIA_INPUT_CRC1_RESULT_BASE_IDX                                                            2
#define mmAZALIA_CRC0_CONTROL0                                                                         0x04dd
#define mmAZALIA_CRC0_CONTROL0_BASE_IDX                                                                2
#define mmAZALIA_CRC0_CONTROL1                                                                         0x04de
#define mmAZALIA_CRC0_CONTROL1_BASE_IDX                                                                2
#define mmAZALIA_CRC0_CONTROL2                                                                         0x04df
#define mmAZALIA_CRC0_CONTROL2_BASE_IDX                                                                2
#define mmAZALIA_CRC0_CONTROL3                                                                         0x04e0
#define mmAZALIA_CRC0_CONTROL3_BASE_IDX                                                                2
#define mmAZALIA_CRC0_RESULT                                                                           0x04e1
#define mmAZALIA_CRC0_RESULT_BASE_IDX                                                                  2
#define mmAZALIA_CRC1_CONTROL0                                                                         0x04e2
#define mmAZALIA_CRC1_CONTROL0_BASE_IDX                                                                2
#define mmAZALIA_CRC1_CONTROL1                                                                         0x04e3
#define mmAZALIA_CRC1_CONTROL1_BASE_IDX                                                                2
#define mmAZALIA_CRC1_CONTROL2                                                                         0x04e4
#define mmAZALIA_CRC1_CONTROL2_BASE_IDX                                                                2
#define mmAZALIA_CRC1_CONTROL3                                                                         0x04e5
#define mmAZALIA_CRC1_CONTROL3_BASE_IDX                                                                2
#define mmAZALIA_CRC1_RESULT                                                                           0x04e6
#define mmAZALIA_CRC1_RESULT_BASE_IDX                                                                  2
#define mmAZALIA_MEM_PWR_CTRL                                                                          0x04e8
#define mmAZALIA_MEM_PWR_CTRL_BASE_IDX                                                                 2
#define mmAZALIA_MEM_PWR_STATUS                                                                        0x04e9
#define mmAZALIA_MEM_PWR_STATUS_BASE_IDX                                                               2
#define mmAZALIA_F0_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID                                          0x0500
#define mmAZALIA_F0_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID_BASE_IDX                                 2
#define mmAZALIA_F0_CODEC_ROOT_PARAMETER_REVISION_ID                                                   0x0501
#define mmAZALIA_F0_CODEC_ROOT_PARAMETER_REVISION_ID_BASE_IDX                                          2
#define mmAZALIA_F0_CODEC_CHANNEL_COUNT_CONTROL                                                        0x0502
#define mmAZALIA_F0_CODEC_CHANNEL_COUNT_CONTROL_BASE_IDX                                               2
#define mmAZALIA_F0_CODEC_RESYNC_FIFO_CONTROL                                                          0x0503
#define mmAZALIA_F0_CODEC_RESYNC_FIFO_CONTROL_BASE_IDX                                                 2
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_GROUP_TYPE                                                0x0504
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_GROUP_TYPE_BASE_IDX                                       2
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES                                      0x0505
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES_BASE_IDX                             2
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS                                            0x0506
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS_BASE_IDX                                   2
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES                                              0x0507
#define mmAZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES_BASE_IDX                                     2
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE                                                 0x0508
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE_BASE_IDX                                        2
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_RESET                                                       0x0509
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_RESET_BASE_IDX                                              2
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID                                       0x050a
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID_BASE_IDX                              2
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_CONVERTER_SYNCHRONIZATION                                   0x050b
#define mmAZALIA_F0_CODEC_FUNCTION_CONTROL_CONVERTER_SYNCHRONIZATION_BASE_IDX                          2
#define mmCC_RCU_DC_AUDIO_PORT_CONNECTIVITY                                                            0x050c
#define mmCC_RCU_DC_AUDIO_PORT_CONNECTIVITY_BASE_IDX                                                   2
#define mmCC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY                                                      0x050d
#define mmCC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY_BASE_IDX                                             2
#define mmAZALIA_F0_GTC_GROUP_OFFSET0                                                                  0x050f
#define mmAZALIA_F0_GTC_GROUP_OFFSET0_BASE_IDX                                                         2
#define mmAZALIA_F0_GTC_GROUP_OFFSET1                                                                  0x0510
#define mmAZALIA_F0_GTC_GROUP_OFFSET1_BASE_IDX                                                         2
#define mmAZALIA_F0_GTC_GROUP_OFFSET2                                                                  0x0511
#define mmAZALIA_F0_GTC_GROUP_OFFSET2_BASE_IDX                                                         2
#define mmAZALIA_F0_GTC_GROUP_OFFSET3                                                                  0x0512
#define mmAZALIA_F0_GTC_GROUP_OFFSET3_BASE_IDX                                                         2
#define mmAZALIA_F0_GTC_GROUP_OFFSET4                                                                  0x0513
#define mmAZALIA_F0_GTC_GROUP_OFFSET4_BASE_IDX                                                         2
#define mmAZALIA_F0_GTC_GROUP_OFFSET5                                                                  0x0514
#define mmAZALIA_F0_GTC_GROUP_OFFSET5_BASE_IDX                                                         2
#define mmAZALIA_F0_GTC_GROUP_OFFSET6                                                                  0x0515
#define mmAZALIA_F0_GTC_GROUP_OFFSET6_BASE_IDX                                                         2
#define mmREG_DC_AUDIO_PORT_CONNECTIVITY                                                               0x0516
#define mmREG_DC_AUDIO_PORT_CONNECTIVITY_BASE_IDX                                                      2
#define mmREG_DC_AUDIO_INPUT_PORT_CONNECTIVITY                                                         0x0517
#define mmREG_DC_AUDIO_INPUT_PORT_CONNECTIVITY_BASE_IDX                                                2
#define mmDAC_ENABLE                                                                                   0x155a
#define mmDAC_ENABLE_BASE_IDX                                                                          2
#define mmDAC_SOURCE_SELECT                                                                            0x155b
#define mmDAC_SOURCE_SELECT_BASE_IDX                                                                   2
#define mmDAC_CRC_EN                                                                                   0x155c
#define mmDAC_CRC_EN_BASE_IDX                                                                          2
#define mmDAC_CRC_CONTROL                                                                              0x155d
#define mmDAC_CRC_CONTROL_BASE_IDX                                                                     2
#define mmDAC_CRC_SIG_RGB_MASK                                                                         0x155e
#define mmDAC_CRC_SIG_RGB_MASK_BASE_IDX                                                                2
#define mmDAC_CRC_SIG_CONTROL_MASK                                                                     0x155f
#define mmDAC_CRC_SIG_CONTROL_MASK_BASE_IDX                                                            2
#define mmDAC_CRC_SIG_RGB                                                                              0x1560
#define mmDAC_CRC_SIG_RGB_BASE_IDX                                                                     2
#define mmDAC_CRC_SIG_CONTROL                                                                          0x1561
#define mmDAC_CRC_SIG_CONTROL_BASE_IDX                                                                 2
#define mmDAC_SYNC_TRISTATE_CONTROL                                                                    0x1562
#define mmDAC_SYNC_TRISTATE_CONTROL_BASE_IDX                                                           2
#define mmDAC_STEREOSYNC_SELECT                                                                        0x1563
#define mmDAC_STEREOSYNC_SELECT_BASE_IDX                                                               2
#define mmDAC_AUTODETECT_CONTROL                                                                       0x1564
#define mmDAC_AUTODETECT_CONTROL_BASE_IDX                                                              2
#define mmDAC_AUTODETECT_CONTROL2                                                                      0x1565
#define mmDAC_AUTODETECT_CONTROL2_BASE_IDX                                                             2
#define mmDAC_AUTODETECT_CONTROL3                                                                      0x1566
#define mmDAC_AUTODETECT_CONTROL3_BASE_IDX                                                             2
#define mmDAC_AUTODETECT_STATUS                                                                        0x1567
#define mmDAC_AUTODETECT_STATUS_BASE_IDX                                                               2
#define mmDAC_AUTODETECT_INT_CONTROL                                                                   0x1568
#define mmDAC_AUTODETECT_INT_CONTROL_BASE_IDX                                                          2
#define mmDAC_FORCE_OUTPUT_CNTL                                                                        0x1569
#define mmDAC_FORCE_OUTPUT_CNTL_BASE_IDX                                                               2
#define mmDAC_FORCE_DATA                                                                               0x156a
#define mmDAC_FORCE_DATA_BASE_IDX                                                                      2
#define mmDAC_POWERDOWN                                                                                0x156b
#define mmDAC_POWERDOWN_BASE_IDX                                                                       2
#define mmDAC_CONTROL                                                                                  0x156c
#define mmDAC_CONTROL_BASE_IDX                                                                         2
#define mmDAC_COMPARATOR_ENABLE                                                                        0x156d
#define mmDAC_COMPARATOR_ENABLE_BASE_IDX                                                               2
#define mmDAC_COMPARATOR_OUTPUT                                                                        0x156e
#define mmDAC_COMPARATOR_OUTPUT_BASE_IDX                                                               2
#define mmDAC_PWR_CNTL                                                                                 0x156f
#define mmDAC_PWR_CNTL_BASE_IDX                                                                        2
#define mmDAC_DFT_CONFIG                                                                               0x1570
#define mmDAC_DFT_CONFIG_BASE_IDX                                                                      2
#define mmDAC_FIFO_STATUS                                                                              0x1571
#define mmDAC_FIFO_STATUS_BASE_IDX                                                                     2
#define mmDC_I2C_CONTROL                                                                               0x1584
#define mmDC_I2C_CONTROL_BASE_IDX                                                                      2
#define mmDC_I2C_ARBITRATION                                                                           0x1585
#define mmDC_I2C_ARBITRATION_BASE_IDX                                                                  2
#define mmDC_I2C_INTERRUPT_CONTROL                                                                     0x1586
#define mmDC_I2C_INTERRUPT_CONTROL_BASE_IDX                                                            2
#define mmDC_I2C_SW_STATUS                                                                             0x1587
#define mmDC_I2C_SW_STATUS_BASE_IDX                                                                    2
#define mmDC_I2C_DDC1_HW_STATUS                                                                        0x1588
#define mmDC_I2C_DDC1_HW_STATUS_BASE_IDX                                                               2
#define mmDC_I2C_DDC2_HW_STATUS                                                                        0x1589
#define mmDC_I2C_DDC2_HW_STATUS_BASE_IDX                                                               2
#define mmDC_I2C_DDC3_HW_STATUS                                                                        0x158a
#define mmDC_I2C_DDC3_HW_STATUS_BASE_IDX                                                               2
#define mmDC_I2C_DDC4_HW_STATUS                                                                        0x158b
#define mmDC_I2C_DDC4_HW_STATUS_BASE_IDX                                                               2
#define mmDC_I2C_DDC5_HW_STATUS                                                                        0x158c
#define mmDC_I2C_DDC5_HW_STATUS_BASE_IDX                                                               2
#define mmDC_I2C_DDC6_HW_STATUS                                                                        0x158d
#define mmDC_I2C_DDC6_HW_STATUS_BASE_IDX                                                               2
#define mmDC_I2C_DDC1_SPEED                                                                            0x158e
#define mmDC_I2C_DDC1_SPEED_BASE_IDX                                                                   2
#define mmDC_I2C_DDC1_SETUP                                                                            0x158f
#define mmDC_I2C_DDC1_SETUP_BASE_IDX                                                                   2
#define mmDC_I2C_DDC2_SPEED                                                                            0x1590
#define mmDC_I2C_DDC2_SPEED_BASE_IDX                                                                   2
#define mmDC_I2C_DDC2_SETUP                                                                            0x1591
#define mmDC_I2C_DDC2_SETUP_BASE_IDX                                                                   2
#define mmDC_I2C_DDC3_SPEED                                                                            0x1592
#define mmDC_I2C_DDC3_SPEED_BASE_IDX                                                                   2
#define mmDC_I2C_DDC3_SETUP                                                                            0x1593
#define mmDC_I2C_DDC3_SETUP_BASE_IDX                                                                   2
#define mmDC_I2C_DDC4_SPEED                                                                            0x1594
#define mmDC_I2C_DDC4_SPEED_BASE_IDX                                                                   2
#define mmDC_I2C_DDC4_SETUP                                                                            0x1595
#define mmDC_I2C_DDC4_SETUP_BASE_IDX                                                                   2
#define mmDC_I2C_DDC5_SPEED                                                                            0x1596
#define mmDC_I2C_DDC5_SPEED_BASE_IDX                                                                   2
#define mmDC_I2C_DDC5_SETUP                                                                            0x1597
#define mmDC_I2C_DDC5_SETUP_BASE_IDX                                                                   2
#define mmDC_I2C_DDC6_SPEED                                                                            0x1598
#define mmDC_I2C_DDC6_SPEED_BASE_IDX                                                                   2
#define mmDC_I2C_DDC6_SETUP                                                                            0x1599
#define mmDC_I2C_DDC6_SETUP_BASE_IDX                                                                   2
#define mmDC_I2C_TRANSACTION0                                                                          0x159a
#define mmDC_I2C_TRANSACTION0_BASE_IDX                                                                 2
#define mmDC_I2C_TRANSACTION1                                                                          0x159b
#define mmDC_I2C_TRANSACTION1_BASE_IDX                                                                 2
#define mmDC_I2C_TRANSACTION2                                                                          0x159c
#define mmDC_I2C_TRANSACTION2_BASE_IDX                                                                 2
#define mmDC_I2C_TRANSACTION3                                                                          0x159d
#define mmDC_I2C_TRANSACTION3_BASE_IDX                                                                 2
#define mmDC_I2C_DATA                                                                                  0x159e
#define mmDC_I2C_DATA_BASE_IDX                                                                         2
#define mmDC_I2C_DDCVGA_HW_STATUS                                                                      0x159f
#define mmDC_I2C_DDCVGA_HW_STATUS_BASE_IDX                                                             2
#define mmDC_I2C_DDCVGA_SPEED                                                                          0x15a0
#define mmDC_I2C_DDCVGA_SPEED_BASE_IDX                                                                 2
#define mmDC_I2C_DDCVGA_SETUP                                                                          0x15a1
#define mmDC_I2C_DDCVGA_SETUP_BASE_IDX                                                                 2
#define mmDC_I2C_EDID_DETECT_CTRL                                                                      0x15a2
#define mmDC_I2C_EDID_DETECT_CTRL_BASE_IDX                                                             2
#define mmDC_I2C_READ_REQUEST_INTERRUPT                                                                0x15a3
#define mmDC_I2C_READ_REQUEST_INTERRUPT_BASE_IDX                                                       2
#define mmGENERIC_I2C_CONTROL                                                                          0x15a4
#define mmGENERIC_I2C_CONTROL_BASE_IDX                                                                 2
#define mmGENERIC_I2C_INTERRUPT_CONTROL                                                                0x15a5
#define mmGENERIC_I2C_INTERRUPT_CONTROL_BASE_IDX                                                       2
#define mmGENERIC_I2C_STATUS                                                                           0x15a6
#define mmGENERIC_I2C_STATUS_BASE_IDX                                                                  2
#define mmGENERIC_I2C_SPEED                                                                            0x15a7
#define mmGENERIC_I2C_SPEED_BASE_IDX                                                                   2
#define mmGENERIC_I2C_SETUP                                                                            0x15a8
#define mmGENERIC_I2C_SETUP_BASE_IDX                                                                   2
#define mmGENERIC_I2C_TRANSACTION                                                                      0x15a9
#define mmGENERIC_I2C_TRANSACTION_BASE_IDX                                                             2
#define mmGENERIC_I2C_DATA                                                                             0x15aa
#define mmGENERIC_I2C_DATA_BASE_IDX                                                                    2
#define mmGENERIC_I2C_PIN_SELECTION                                                                    0x15ab
#define mmGENERIC_I2C_PIN_SELECTION_BASE_IDX                                                           2
#define mmDCO_SCRATCH0                                                                                 0x15b6
#define mmDCO_SCRATCH0_BASE_IDX                                                                        2
#define mmDCO_SCRATCH1                                                                                 0x15b7
#define mmDCO_SCRATCH1_BASE_IDX                                                                        2
#define mmDCO_SCRATCH2                                                                                 0x15b8
#define mmDCO_SCRATCH2_BASE_IDX                                                                        2
#define mmDCO_SCRATCH3                                                                                 0x15b9
#define mmDCO_SCRATCH3_BASE_IDX                                                                        2
#define mmDCO_SCRATCH4                                                                                 0x15ba
#define mmDCO_SCRATCH4_BASE_IDX                                                                        2
#define mmDCO_SCRATCH5                                                                                 0x15bb
#define mmDCO_SCRATCH5_BASE_IDX                                                                        2
#define mmDCO_SCRATCH6                                                                                 0x15bc
#define mmDCO_SCRATCH6_BASE_IDX                                                                        2
#define mmDCO_SCRATCH7                                                                                 0x15bd
#define mmDCO_SCRATCH7_BASE_IDX                                                                        2
#define mmDCE_VCE_CONTROL                                                                              0x15be
#define mmDCE_VCE_CONTROL_BASE_IDX                                                                     2
#define mmDISP_INTERRUPT_STATUS                                                                        0x15bf
#define mmDISP_INTERRUPT_STATUS_BASE_IDX                                                               2
#define mmDISP_INTERRUPT_STATUS_CONTINUE                                                               0x15c0
#define mmDISP_INTERRUPT_STATUS_CONTINUE_BASE_IDX                                                      2
#define mmDISP_INTERRUPT_STATUS_CONTINUE2                                                              0x15c1
#define mmDISP_INTERRUPT_STATUS_CONTINUE2_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE3                                                              0x15c2
#define mmDISP_INTERRUPT_STATUS_CONTINUE3_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE4                                                              0x15c3
#define mmDISP_INTERRUPT_STATUS_CONTINUE4_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE5                                                              0x15c4
#define mmDISP_INTERRUPT_STATUS_CONTINUE5_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE6                                                              0x15c5
#define mmDISP_INTERRUPT_STATUS_CONTINUE6_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE7                                                              0x15c6
#define mmDISP_INTERRUPT_STATUS_CONTINUE7_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE8                                                              0x15c7
#define mmDISP_INTERRUPT_STATUS_CONTINUE8_BASE_IDX                                                     2
#define mmDISP_INTERRUPT_STATUS_CONTINUE9                                                              0x15c8
#define mmDISP_INTERRUPT_STATUS_CONTINUE9_BASE_IDX                                                     2
#define mmDCO_MEM_PWR_STATUS                                                                           0x15c9
#define mmDCO_MEM_PWR_STATUS_BASE_IDX                                                                  2
#define mmDCO_MEM_PWR_CTRL                                                                             0x15ca
#define mmDCO_MEM_PWR_CTRL_BASE_IDX                                                                    2
#define mmDCO_MEM_PWR_CTRL2                                                                            0x15cb
#define mmDCO_MEM_PWR_CTRL2_BASE_IDX                                                                   2
#define mmDCO_CLK_CNTL                                                                                 0x15cc
#define mmDCO_CLK_CNTL_BASE_IDX                                                                        2
#define mmDCO_POWER_MANAGEMENT_CNTL                                                                    0x15d0
#define mmDCO_POWER_MANAGEMENT_CNTL_BASE_IDX                                                           2
#define mmDIG_SOFT_RESET_2                                                                             0x15d2
#define mmDIG_SOFT_RESET_2_BASE_IDX                                                                    2
#define mmDCO_STEREOSYNC_SEL                                                                           0x15d6
#define mmDCO_STEREOSYNC_SEL_BASE_IDX                                                                  2
#define mmDCO_SOFT_RESET                                                                               0x15d9
#define mmDCO_SOFT_RESET_BASE_IDX                                                                      2
#define mmDIG_SOFT_RESET                                                                               0x15da
#define mmDIG_SOFT_RESET_BASE_IDX                                                                      2
#define mmDCO_MEM_PWR_STATUS1                                                                          0x15dc
#define mmDCO_MEM_PWR_STATUS1_BASE_IDX                                                                 2
#define mmDISP_INTERRUPT_STATUS_CONTINUE10                                                             0x15dd
#define mmDISP_INTERRUPT_STATUS_CONTINUE10_BASE_IDX                                                    2
#define mmDCO_CLK_CNTL2                                                                                0x15de
#define mmDCO_CLK_CNTL2_BASE_IDX                                                                       2
#define mmDCO_CLK_CNTL3                                                                                0x15df
#define mmDCO_CLK_CNTL3_BASE_IDX                                                                       2
#define mmDCO_HDMI_RXSTATUS_TIMER_CONTROL                                                              0x15eb
#define mmDCO_HDMI_RXSTATUS_TIMER_CONTROL_BASE_IDX                                                     2
#define mmDCO_PSP_INTERRUPT_STATUS                                                                     0x15ec
#define mmDCO_PSP_INTERRUPT_STATUS_BASE_IDX                                                            2
#define mmDCO_PSP_INTERRUPT_CLEAR                                                                      0x15ed
#define mmDCO_PSP_INTERRUPT_CLEAR_BASE_IDX                                                             2
#define mmDCO_GENERIC_INTERRUPT_MESSAGE                                                                0x15ee
#define mmDCO_GENERIC_INTERRUPT_MESSAGE_BASE_IDX                                                       2
#define mmDCO_GENERIC_INTERRUPT_CLEAR                                                                  0x15ef
#define mmDCO_GENERIC_INTERRUPT_CLEAR_BASE_IDX                                                         2
#define mmFMT_MEMORY0_CONTROL                                                                          0x15f0
#define mmFMT_MEMORY0_CONTROL_BASE_IDX                                                                 2
#define mmFMT_MEMORY1_CONTROL                                                                          0x15f1
#define mmFMT_MEMORY1_CONTROL_BASE_IDX                                                                 2
#define mmFMT_MEMORY2_CONTROL                                                                          0x15f2
#define mmFMT_MEMORY2_CONTROL_BASE_IDX                                                                 2
#define mmFMT_MEMORY3_CONTROL                                                                          0x15f3
#define mmFMT_MEMORY3_CONTROL_BASE_IDX                                                                 2
#define mmFMT_MEMORY4_CONTROL                                                                          0x15f4
#define mmFMT_MEMORY4_CONTROL_BASE_IDX                                                                 2
#define mmFMT_MEMORY5_CONTROL                                                                          0x15f5
#define mmFMT_MEMORY5_CONTROL_BASE_IDX                                                                 2
#define mmDISP_INTERRUPT_STATUS_CONTINUE11                                                             0x15f6
#define mmDISP_INTERRUPT_STATUS_CONTINUE11_BASE_IDX                                                    2
#define mmDC_GENERICA                                                                                  0x207e
#define mmDC_GENERICA_BASE_IDX                                                                         2
#define mmDC_GENERICB                                                                                  0x207f
#define mmDC_GENERICB_BASE_IDX                                                                         2
#define mmDC_PAD_EXTERN_SIG                                                                            0x2080
#define mmDC_PAD_EXTERN_SIG_BASE_IDX                                                                   2
#define mmDC_REF_CLK_CNTL                                                                              0x2081
#define mmDC_REF_CLK_CNTL_BASE_IDX                                                                     2
#define mmDC_GPIO_DEBUG                                                                                0x2082
#define mmDC_GPIO_DEBUG_BASE_IDX                                                                       2
#define mmUNIPHYA_LINK_CNTL                                                                            0x2083
#define mmUNIPHYA_LINK_CNTL_BASE_IDX                                                                   2
#define mmUNIPHYA_CHANNEL_XBAR_CNTL                                                                    0x2084
#define mmUNIPHYA_CHANNEL_XBAR_CNTL_BASE_IDX                                                           2
#define mmUNIPHYB_LINK_CNTL                                                                            0x2085
#define mmUNIPHYB_LINK_CNTL_BASE_IDX                                                                   2
#define mmUNIPHYB_CHANNEL_XBAR_CNTL                                                                    0x2086
#define mmUNIPHYB_CHANNEL_XBAR_CNTL_BASE_IDX                                                           2
#define mmUNIPHYC_LINK_CNTL                                                                            0x2087
#define mmUNIPHYC_LINK_CNTL_BASE_IDX                                                                   2
#define mmUNIPHYC_CHANNEL_XBAR_CNTL                                                                    0x2088
#define mmUNIPHYC_CHANNEL_XBAR_CNTL_BASE_IDX                                                           2
#define mmUNIPHYD_LINK_CNTL                                                                            0x2089
#define mmUNIPHYD_LINK_CNTL_BASE_IDX                                                                   2
#define mmUNIPHYD_CHANNEL_XBAR_CNTL                                                                    0x208a
#define mmUNIPHYD_CHANNEL_XBAR_CNTL_BASE_IDX                                                           2
#define mmUNIPHYE_LINK_CNTL                                                                            0x208b
#define mmUNIPHYE_LINK_CNTL_BASE_IDX                                                                   2
#define mmUNIPHYE_CHANNEL_XBAR_CNTL                                                                    0x208c
#define mmUNIPHYE_CHANNEL_XBAR_CNTL_BASE_IDX                                                           2
#define mmUNIPHYF_LINK_CNTL                                                                            0x208d
#define mmUNIPHYF_LINK_CNTL_BASE_IDX                                                                   2
#define mmUNIPHYF_CHANNEL_XBAR_CNTL                                                                    0x208e
#define mmUNIPHYF_CHANNEL_XBAR_CNTL_BASE_IDX                                                           2
#define mmUNIPHYG_LINK_CNTL                                                                            0x208f
#define mmUNIPHYG_LINK_CNTL_BASE_IDX                                                                   2
#define mmUNIPHYG_CHANNEL_XBAR_CNTL                                                                    0x2090
#define mmUNIPHYG_CHANNEL_XBAR_CNTL_BASE_IDX                                                           2
#define mmDCIO_WRCMD_DELAY                                                                             0x2094
#define mmDCIO_WRCMD_DELAY_BASE_IDX                                                                    2
#define mmDC_PINSTRAPS                                                                                 0x2096
#define mmDC_PINSTRAPS_BASE_IDX                                                                        2
#define mmCC_DC_MISC_STRAPS                                                                            0x2097
#define mmCC_DC_MISC_STRAPS_BASE_IDX                                                                   2
#define mmDC_DVODATA_CONFIG                                                                            0x2098
#define mmDC_DVODATA_CONFIG_BASE_IDX                                                                   2
#define mmLVTMA_PWRSEQ_CNTL                                                                            0x2099
#define mmLVTMA_PWRSEQ_CNTL_BASE_IDX                                                                   2
#define mmLVTMA_PWRSEQ_STATE                                                                           0x209a
#define mmLVTMA_PWRSEQ_STATE_BASE_IDX                                                                  2
#define mmLVTMA_PWRSEQ_REF_DIV                                                                         0x209b
#define mmLVTMA_PWRSEQ_REF_DIV_BASE_IDX                                                                2
#define mmLVTMA_PWRSEQ_DELAY1                                                                          0x209c
#define mmLVTMA_PWRSEQ_DELAY1_BASE_IDX                                                                 2
#define mmLVTMA_PWRSEQ_DELAY2                                                                          0x209d
#define mmLVTMA_PWRSEQ_DELAY2_BASE_IDX                                                                 2
#define mmBL_PWM_CNTL                                                                                  0x209e
#define mmBL_PWM_CNTL_BASE_IDX                                                                         2
#define mmBL_PWM_CNTL2                                                                                 0x209f
#define mmBL_PWM_CNTL2_BASE_IDX                                                                        2
#define mmBL_PWM_PERIOD_CNTL                                                                           0x20a0
#define mmBL_PWM_PERIOD_CNTL_BASE_IDX                                                                  2
#define mmBL_PWM_GRP1_REG_LOCK                                                                         0x20a1
#define mmBL_PWM_GRP1_REG_LOCK_BASE_IDX                                                                2
#define mmDCIO_GSL_GENLK_PAD_CNTL                                                                      0x20a2
#define mmDCIO_GSL_GENLK_PAD_CNTL_BASE_IDX                                                             2
#define mmDCIO_GSL_SWAPLOCK_PAD_CNTL                                                                   0x20a3
#define mmDCIO_GSL_SWAPLOCK_PAD_CNTL_BASE_IDX                                                          2
#define mmDCIO_GSL0_CNTL                                                                               0x20a4
#define mmDCIO_GSL0_CNTL_BASE_IDX                                                                      2
#define mmDCIO_GSL1_CNTL                                                                               0x20a5
#define mmDCIO_GSL1_CNTL_BASE_IDX                                                                      2
#define mmDCIO_GSL2_CNTL                                                                               0x20a6
#define mmDCIO_GSL2_CNTL_BASE_IDX                                                                      2
#define mmDC_GPU_TIMER_START_POSITION_V_UPDATE                                                         0x20a7
#define mmDC_GPU_TIMER_START_POSITION_V_UPDATE_BASE_IDX                                                2
#define mmDC_GPU_TIMER_START_POSITION_P_FLIP                                                           0x20a8
#define mmDC_GPU_TIMER_START_POSITION_P_FLIP_BASE_IDX                                                  2
#define mmDC_GPU_TIMER_READ                                                                            0x20a9
#define mmDC_GPU_TIMER_READ_BASE_IDX                                                                   2
#define mmDC_GPU_TIMER_READ_CNTL                                                                       0x20aa
#define mmDC_GPU_TIMER_READ_CNTL_BASE_IDX                                                              2
#define mmDCIO_CLOCK_CNTL                                                                              0x20ab
#define mmDCIO_CLOCK_CNTL_BASE_IDX                                                                     2
#define mmDCO_DCFE_EXT_VSYNC_CNTL                                                                      0x20ae
#define mmDCO_DCFE_EXT_VSYNC_CNTL_BASE_IDX                                                             2
#define mmDCIO_SOFT_RESET                                                                              0x20b4
#define mmDCIO_SOFT_RESET_BASE_IDX                                                                     2
#define mmDCIO_DPHY_SEL                                                                                0x20b5
#define mmDCIO_DPHY_SEL_BASE_IDX                                                                       2
#define mmUNIPHY_IMPCAL_LINKA                                                                          0x20b6
#define mmUNIPHY_IMPCAL_LINKA_BASE_IDX                                                                 2
#define mmUNIPHY_IMPCAL_LINKB                                                                          0x20b7
#define mmUNIPHY_IMPCAL_LINKB_BASE_IDX                                                                 2
#define mmUNIPHY_IMPCAL_PERIOD                                                                         0x20b8
#define mmUNIPHY_IMPCAL_PERIOD_BASE_IDX                                                                2
#define mmAUXP_IMPCAL                                                                                  0x20b9
#define mmAUXP_IMPCAL_BASE_IDX                                                                         2
#define mmAUXN_IMPCAL                                                                                  0x20ba
#define mmAUXN_IMPCAL_BASE_IDX                                                                         2
#define mmDCIO_IMPCAL_CNTL                                                                             0x20bb
#define mmDCIO_IMPCAL_CNTL_BASE_IDX                                                                    2
#define mmUNIPHY_IMPCAL_PSW_AB                                                                         0x20bc
#define mmUNIPHY_IMPCAL_PSW_AB_BASE_IDX                                                                2
#define mmUNIPHY_IMPCAL_LINKC                                                                          0x20bd
#define mmUNIPHY_IMPCAL_LINKC_BASE_IDX                                                                 2
#define mmUNIPHY_IMPCAL_LINKD                                                                          0x20be
#define mmUNIPHY_IMPCAL_LINKD_BASE_IDX                                                                 2
#define mmDCIO_IMPCAL_CNTL_CD                                                                          0x20bf
#define mmDCIO_IMPCAL_CNTL_CD_BASE_IDX                                                                 2
#define mmUNIPHY_IMPCAL_PSW_CD                                                                         0x20c0
#define mmUNIPHY_IMPCAL_PSW_CD_BASE_IDX                                                                2
#define mmUNIPHY_IMPCAL_LINKE                                                                          0x20c1
#define mmUNIPHY_IMPCAL_LINKE_BASE_IDX                                                                 2
#define mmUNIPHY_IMPCAL_LINKF                                                                          0x20c2
#define mmUNIPHY_IMPCAL_LINKF_BASE_IDX                                                                 2
#define mmDCIO_IMPCAL_CNTL_EF                                                                          0x20c3
#define mmDCIO_IMPCAL_CNTL_EF_BASE_IDX                                                                 2
#define mmUNIPHY_IMPCAL_PSW_EF                                                                         0x20c4
#define mmUNIPHY_IMPCAL_PSW_EF_BASE_IDX                                                                2
#define mmUNIPHYLPA_LINK_CNTL                                                                          0x20c5
#define mmUNIPHYLPA_LINK_CNTL_BASE_IDX                                                                 2
#define mmUNIPHYLPB_LINK_CNTL                                                                          0x20c6
#define mmUNIPHYLPB_LINK_CNTL_BASE_IDX                                                                 2
#define mmUNIPHYLPA_CHANNEL_XBAR_CNTL                                                                  0x20c7
#define mmUNIPHYLPA_CHANNEL_XBAR_CNTL_BASE_IDX                                                         2
#define mmUNIPHYLPB_CHANNEL_XBAR_CNTL                                                                  0x20c8
#define mmUNIPHYLPB_CHANNEL_XBAR_CNTL_BASE_IDX                                                         2
#define mmDCIO_DPCS_TX_INTERRUPT                                                                       0x20c9
#define mmDCIO_DPCS_TX_INTERRUPT_BASE_IDX                                                              2
#define mmDCIO_DPCS_RX_INTERRUPT                                                                       0x20ca
#define mmDCIO_DPCS_RX_INTERRUPT_BASE_IDX                                                              2
#define mmDCIO_SEMAPHORE0                                                                              0x20cb
#define mmDCIO_SEMAPHORE0_BASE_IDX                                                                     2
#define mmDCIO_SEMAPHORE1                                                                              0x20cc
#define mmDCIO_SEMAPHORE1_BASE_IDX                                                                     2
#define mmDCIO_SEMAPHORE2                                                                              0x20cd
#define mmDCIO_SEMAPHORE2_BASE_IDX                                                                     2
#define mmDCIO_SEMAPHORE3                                                                              0x20ce
#define mmDCIO_SEMAPHORE3_BASE_IDX                                                                     2
#define mmDCIO_SEMAPHORE4                                                                              0x20cf
#define mmDCIO_SEMAPHORE4_BASE_IDX                                                                     2
#define mmDCIO_SEMAPHORE5                                                                              0x20d0
#define mmDCIO_SEMAPHORE5_BASE_IDX                                                                     2
#define mmDCIO_SEMAPHORE6                                                                              0x20d1
#define mmDCIO_SEMAPHORE6_BASE_IDX                                                                     2
#define mmDCIO_SEMAPHORE7                                                                              0x20d2
#define mmDCIO_SEMAPHORE7_BASE_IDX                                                                     2
#define mmDC_GPIO_GENERIC_MASK                                                                         0x20de
#define mmDC_GPIO_GENERIC_MASK_BASE_IDX                                                                2
#define mmDC_GPIO_GENERIC_A                                                                            0x20df
#define mmDC_GPIO_GENERIC_A_BASE_IDX                                                                   2
#define mmDC_GPIO_GENERIC_EN                                                                           0x20e0
#define mmDC_GPIO_GENERIC_EN_BASE_IDX                                                                  2
#define mmDC_GPIO_GENERIC_Y                                                                            0x20e1
#define mmDC_GPIO_GENERIC_Y_BASE_IDX                                                                   2
#define mmDC_GPIO_DVODATA_MASK                                                                         0x20e2
#define mmDC_GPIO_DVODATA_MASK_BASE_IDX                                                                2
#define mmDC_GPIO_DVODATA_A                                                                            0x20e3
#define mmDC_GPIO_DVODATA_A_BASE_IDX                                                                   2
#define mmDC_GPIO_DVODATA_EN                                                                           0x20e4
#define mmDC_GPIO_DVODATA_EN_BASE_IDX                                                                  2
#define mmDC_GPIO_DVODATA_Y                                                                            0x20e5
#define mmDC_GPIO_DVODATA_Y_BASE_IDX                                                                   2
#define mmDC_GPIO_DDC1_MASK                                                                            0x20e6
#define mmDC_GPIO_DDC1_MASK_BASE_IDX                                                                   2
#define mmDC_GPIO_DDC1_A                                                                               0x20e7
#define mmDC_GPIO_DDC1_A_BASE_IDX                                                                      2
#define mmDC_GPIO_DDC1_EN                                                                              0x20e8
#define mmDC_GPIO_DDC1_EN_BASE_IDX                                                                     2
#define mmDC_GPIO_DDC1_Y                                                                               0x20e9
#define mmDC_GPIO_DDC1_Y_BASE_IDX                                                                      2
#define mmDC_GPIO_DDC2_MASK                                                                            0x20ea
#define mmDC_GPIO_DDC2_MASK_BASE_IDX                                                                   2
#define mmDC_GPIO_DDC2_A                                                                               0x20eb
#define mmDC_GPIO_DDC2_A_BASE_IDX                                                                      2
#define mmDC_GPIO_DDC2_EN                                                                              0x20ec
#define mmDC_GPIO_DDC2_EN_BASE_IDX                                                                     2
#define mmDC_GPIO_DDC2_Y                                                                               0x20ed
#define mmDC_GPIO_DDC2_Y_BASE_IDX                                                                      2
#define mmDC_GPIO_DDC3_MASK                                                                            0x20ee
#define mmDC_GPIO_DDC3_MASK_BASE_IDX                                                                   2
#define mmDC_GPIO_DDC3_A                                                                               0x20ef
#define mmDC_GPIO_DDC3_A_BASE_IDX                                                                      2
#define mmDC_GPIO_DDC3_EN                                                                              0x20f0
#define mmDC_GPIO_DDC3_EN_BASE_IDX                                                                     2
#define mmDC_GPIO_DDC3_Y                                                                               0x20f1
#define mmDC_GPIO_DDC3_Y_BASE_IDX                                                                      2
#define mmDC_GPIO_DDC4_MASK                                                                            0x20f2
#define mmDC_GPIO_DDC4_MASK_BASE_IDX                                                                   2
#define mmDC_GPIO_DDC4_A                                                                               0x20f3
#define mmDC_GPIO_DDC4_A_BASE_IDX                                                                      2
#define mmDC_GPIO_DDC4_EN                                                                              0x20f4
#define mmDC_GPIO_DDC4_EN_BASE_IDX                                                                     2
#define mmDC_GPIO_DDC4_Y                                                                               0x20f5
#define mmDC_GPIO_DDC4_Y_BASE_IDX                                                                      2
#define mmDC_GPIO_DDC5_MASK                                                                            0x20f6
#define mmDC_GPIO_DDC5_MASK_BASE_IDX                                                                   2
#define mmDC_GPIO_DDC5_A                                                                               0x20f7
#define mmDC_GPIO_DDC5_A_BASE_IDX                                                                      2
#define mmDC_GPIO_DDC5_EN                                                                              0x20f8
#define mmDC_GPIO_DDC5_EN_BASE_IDX                                                                     2
#define mmDC_GPIO_DDC5_Y                                                                               0x20f9
#define mmDC_GPIO_DDC5_Y_BASE_IDX                                                                      2
#define mmDC_GPIO_DDC6_MASK                                                                            0x20fa
#define mmDC_GPIO_DDC6_MASK_BASE_IDX                                                                   2
#define mmDC_GPIO_DDC6_A                                                                               0x20fb
#define mmDC_GPIO_DDC6_A_BASE_IDX                                                                      2
#define mmDC_GPIO_DDC6_EN                                                                              0x20fc
#define mmDC_GPIO_DDC6_EN_BASE_IDX                                                                     2
#define mmDC_GPIO_DDC6_Y                                                                               0x20fd
#define mmDC_GPIO_DDC6_Y_BASE_IDX                                                                      2
#define mmDC_GPIO_DDCVGA_MASK                                                                          0x20fe
#define mmDC_GPIO_DDCVGA_MASK_BASE_IDX                                                                 2
#define mmDC_GPIO_DDCVGA_A                                                                             0x20ff
#define mmDC_GPIO_DDCVGA_A_BASE_IDX                                                                    2
#define mmDC_GPIO_DDCVGA_EN                                                                            0x2100
#define mmDC_GPIO_DDCVGA_EN_BASE_IDX                                                                   2
#define mmDC_GPIO_DDCVGA_Y                                                                             0x2101
#define mmDC_GPIO_DDCVGA_Y_BASE_IDX                                                                    2
#define mmDC_GPIO_SYNCA_MASK                                                                           0x2102
#define mmDC_GPIO_SYNCA_MASK_BASE_IDX                                                                  2
#define mmDC_GPIO_SYNCA_A                                                                              0x2103
#define mmDC_GPIO_SYNCA_A_BASE_IDX                                                                     2
#define mmDC_GPIO_SYNCA_EN                                                                             0x2104
#define mmDC_GPIO_SYNCA_EN_BASE_IDX                                                                    2
#define mmDC_GPIO_SYNCA_Y                                                                              0x2105
#define mmDC_GPIO_SYNCA_Y_BASE_IDX                                                                     2
#define mmDC_GPIO_GENLK_MASK                                                                           0x2106
#define mmDC_GPIO_GENLK_MASK_BASE_IDX                                                                  2
#define mmDC_GPIO_GENLK_A                                                                              0x2107
#define mmDC_GPIO_GENLK_A_BASE_IDX                                                                     2
#define mmDC_GPIO_GENLK_EN                                                                             0x2108
#define mmDC_GPIO_GENLK_EN_BASE_IDX                                                                    2
#define mmDC_GPIO_GENLK_Y                                                                              0x2109
#define mmDC_GPIO_GENLK_Y_BASE_IDX                                                                     2
#define mmDC_GPIO_HPD_MASK                                                                             0x210a
#define mmDC_GPIO_HPD_MASK_BASE_IDX                                                                    2
#define mmDC_GPIO_HPD_A                                                                                0x210b
#define mmDC_GPIO_HPD_A_BASE_IDX                                                                       2
#define mmDC_GPIO_HPD_EN                                                                               0x210c
#define mmDC_GPIO_HPD_EN_BASE_IDX                                                                      2
#define mmDC_GPIO_HPD_Y                                                                                0x210d
#define mmDC_GPIO_HPD_Y_BASE_IDX                                                                       2
#define mmDC_GPIO_PWRSEQ_MASK                                                                          0x210e
#define mmDC_GPIO_PWRSEQ_MASK_BASE_IDX                                                                 2
#define mmDC_GPIO_PWRSEQ_A                                                                             0x210f
#define mmDC_GPIO_PWRSEQ_A_BASE_IDX                                                                    2
#define mmDC_GPIO_PWRSEQ_EN                                                                            0x2110
#define mmDC_GPIO_PWRSEQ_EN_BASE_IDX                                                                   2
#define mmDC_GPIO_PWRSEQ_Y                                                                             0x2111
#define mmDC_GPIO_PWRSEQ_Y_BASE_IDX                                                                    2
#define mmDC_GPIO_PAD_STRENGTH_1                                                                       0x2112
#define mmDC_GPIO_PAD_STRENGTH_1_BASE_IDX                                                              2
#define mmDC_GPIO_PAD_STRENGTH_2                                                                       0x2113
#define mmDC_GPIO_PAD_STRENGTH_2_BASE_IDX                                                              2
#define mmPHY_AUX_CNTL                                                                                 0x2115
#define mmPHY_AUX_CNTL_BASE_IDX                                                                        2
#define mmDC_GPIO_I2CPAD_MASK                                                                          0x2116
#define mmDC_GPIO_I2CPAD_MASK_BASE_IDX                                                                 2
#define mmDC_GPIO_I2CPAD_A                                                                             0x2117
#define mmDC_GPIO_I2CPAD_A_BASE_IDX                                                                    2
#define mmDC_GPIO_I2CPAD_EN                                                                            0x2118
#define mmDC_GPIO_I2CPAD_EN_BASE_IDX                                                                   2
#define mmDC_GPIO_I2CPAD_Y                                                                             0x2119
#define mmDC_GPIO_I2CPAD_Y_BASE_IDX                                                                    2
#define mmDC_GPIO_I2CPAD_STRENGTH                                                                      0x211a
#define mmDC_GPIO_I2CPAD_STRENGTH_BASE_IDX                                                             2
#define mmDVO_STRENGTH_CONTROL                                                                         0x211b
#define mmDVO_STRENGTH_CONTROL_BASE_IDX                                                                2
#define mmDVO_VREF_CONTROL                                                                             0x211c
#define mmDVO_VREF_CONTROL_BASE_IDX                                                                    2
#define mmDVO_SKEW_ADJUST                                                                              0x211d
#define mmDVO_SKEW_ADJUST_BASE_IDX                                                                     2
#define mmDC_GPIO_I2S_SPDIF_MASK                                                                       0x2126
#define mmDC_GPIO_I2S_SPDIF_MASK_BASE_IDX                                                              2
#define mmDC_GPIO_I2S_SPDIF_A                                                                          0x2127
#define mmDC_GPIO_I2S_SPDIF_A_BASE_IDX                                                                 2
#define mmDC_GPIO_I2S_SPDIF_EN                                                                         0x2128
#define mmDC_GPIO_I2S_SPDIF_EN_BASE_IDX                                                                2
#define mmDC_GPIO_I2S_SPDIF_Y                                                                          0x2129
#define mmDC_GPIO_I2S_SPDIF_Y_BASE_IDX                                                                 2
#define mmDC_GPIO_I2S_SPDIF_STRENGTH                                                                   0x212a
#define mmDC_GPIO_I2S_SPDIF_STRENGTH_BASE_IDX                                                          2
#define mmDC_GPIO_TX12_EN                                                                              0x212b
#define mmDC_GPIO_TX12_EN_BASE_IDX                                                                     2
#define mmDC_GPIO_AUX_CTRL_0                                                                           0x212c
#define mmDC_GPIO_AUX_CTRL_0_BASE_IDX                                                                  2
#define mmDC_GPIO_AUX_CTRL_1                                                                           0x212d
#define mmDC_GPIO_AUX_CTRL_1_BASE_IDX                                                                  2
#define mmDC_GPIO_AUX_CTRL_2                                                                           0x212e
#define mmDC_GPIO_AUX_CTRL_2_BASE_IDX                                                                  2
#define mmDC_GPIO_RXEN                                                                                 0x212f
#define mmDC_GPIO_RXEN_BASE_IDX                                                                        2
#define mmBPHYC_DAC_MACRO_CNTL                                                                         0x2136
#define mmBPHYC_DAC_MACRO_CNTL_BASE_IDX                                                                2
#define mmDAC_MACRO_CNTL_RESERVED0                                                                     0x2136
#define mmDAC_MACRO_CNTL_RESERVED0_BASE_IDX                                                            2
#define mmBPHYC_DAC_AUTO_CALIB_CONTROL                                                                 0x2137
#define mmBPHYC_DAC_AUTO_CALIB_CONTROL_BASE_IDX                                                        2
#define mmDAC_MACRO_CNTL_RESERVED1                                                                     0x2137
#define mmDAC_MACRO_CNTL_RESERVED1_BASE_IDX                                                            2
#define mmDAC_MACRO_CNTL_RESERVED2                                                                     0x2138
#define mmDAC_MACRO_CNTL_RESERVED2_BASE_IDX                                                            2
#define mmDAC_MACRO_CNTL_RESERVED3                                                                     0x2139
#define mmDAC_MACRO_CNTL_RESERVED3_BASE_IDX                                                            2
#define mmDISP_DSI_DUAL_CTRL                                                                           0x277e
#define mmDISP_DSI_DUAL_CTRL_BASE_IDX                                                                  2
#define mmDPHY_MACRO_CNTL_RESERVED0                                                                    0x283e
#define mmDPHY_MACRO_CNTL_RESERVED0_BASE_IDX                                                           2
#define mmDPHY_MACRO_CNTL_RESERVED1                                                                    0x283f
#define mmDPHY_MACRO_CNTL_RESERVED1_BASE_IDX                                                           2
#define mmDPHY_MACRO_CNTL_RESERVED2                                                                    0x2840
#define mmDPHY_MACRO_CNTL_RESERVED2_BASE_IDX                                                           2
#define mmDPHY_MACRO_CNTL_RESERVED3                                                                    0x2841
#define mmDPHY_MACRO_CNTL_RESERVED3_BASE_IDX                                                           2
#define mmDPHY_MACRO_CNTL_RESERVED4                                                                    0x2842
#define mmDPHY_MACRO_CNTL_RESERVED4_BASE_IDX                                                           2
#define mmDPHY_MACRO_CNTL_RESERVED5                                                                    0x2843
#define mmDPHY_MACRO_CNTL_RESERVED5_BASE_IDX                                                           2
#define mmDPHY_MACRO_CNTL_RESERVED6                                                                    0x2844
#define mmDPHY_MACRO_CNTL_RESERVED6_BASE_IDX                                                           2
#define mmDPHY_MACRO_CNTL_RESERVED7                                                                    0x2845
#define mmDPHY_MACRO_CNTL_RESERVED7_BASE_IDX                                                           2
#define mmDPHY_MACRO_CNTL_RESERVED8                                                                    0x2846
#define mmDPHY_MACRO_CNTL_RESERVED8_BASE_IDX                                                           2
#define mmDPHY_MACRO_CNTL_RESERVED9                                                                    0x2847
#define mmDPHY_MACRO_CNTL_RESERVED9_BASE_IDX                                                           2
#define mmDPHY_MACRO_CNTL_RESERVED10                                                                   0x2848
#define mmDPHY_MACRO_CNTL_RESERVED10_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED11                                                                   0x2849
#define mmDPHY_MACRO_CNTL_RESERVED11_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED12                                                                   0x284a
#define mmDPHY_MACRO_CNTL_RESERVED12_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED13                                                                   0x284b
#define mmDPHY_MACRO_CNTL_RESERVED13_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED14                                                                   0x284c
#define mmDPHY_MACRO_CNTL_RESERVED14_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED15                                                                   0x284d
#define mmDPHY_MACRO_CNTL_RESERVED15_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED16                                                                   0x284e
#define mmDPHY_MACRO_CNTL_RESERVED16_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED17                                                                   0x284f
#define mmDPHY_MACRO_CNTL_RESERVED17_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED18                                                                   0x2850
#define mmDPHY_MACRO_CNTL_RESERVED18_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED19                                                                   0x2851
#define mmDPHY_MACRO_CNTL_RESERVED19_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED20                                                                   0x2852
#define mmDPHY_MACRO_CNTL_RESERVED20_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED21                                                                   0x2853
#define mmDPHY_MACRO_CNTL_RESERVED21_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED22                                                                   0x2854
#define mmDPHY_MACRO_CNTL_RESERVED22_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED23                                                                   0x2855
#define mmDPHY_MACRO_CNTL_RESERVED23_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED24                                                                   0x2856
#define mmDPHY_MACRO_CNTL_RESERVED24_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED25                                                                   0x2857
#define mmDPHY_MACRO_CNTL_RESERVED25_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED26                                                                   0x2858
#define mmDPHY_MACRO_CNTL_RESERVED26_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED27                                                                   0x2859
#define mmDPHY_MACRO_CNTL_RESERVED27_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED28                                                                   0x285a
#define mmDPHY_MACRO_CNTL_RESERVED28_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED29                                                                   0x285b
#define mmDPHY_MACRO_CNTL_RESERVED29_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED30                                                                   0x285c
#define mmDPHY_MACRO_CNTL_RESERVED30_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED31                                                                   0x285d
#define mmDPHY_MACRO_CNTL_RESERVED31_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED32                                                                   0x285e
#define mmDPHY_MACRO_CNTL_RESERVED32_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED33                                                                   0x285f
#define mmDPHY_MACRO_CNTL_RESERVED33_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED34                                                                   0x2860
#define mmDPHY_MACRO_CNTL_RESERVED34_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED35                                                                   0x2861
#define mmDPHY_MACRO_CNTL_RESERVED35_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED36                                                                   0x2862
#define mmDPHY_MACRO_CNTL_RESERVED36_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED37                                                                   0x2863
#define mmDPHY_MACRO_CNTL_RESERVED37_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED38                                                                   0x2864
#define mmDPHY_MACRO_CNTL_RESERVED38_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED39                                                                   0x2865
#define mmDPHY_MACRO_CNTL_RESERVED39_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED40                                                                   0x2866
#define mmDPHY_MACRO_CNTL_RESERVED40_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED41                                                                   0x2867
#define mmDPHY_MACRO_CNTL_RESERVED41_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED42                                                                   0x2868
#define mmDPHY_MACRO_CNTL_RESERVED42_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED43                                                                   0x2869
#define mmDPHY_MACRO_CNTL_RESERVED43_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED44                                                                   0x286a
#define mmDPHY_MACRO_CNTL_RESERVED44_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED45                                                                   0x286b
#define mmDPHY_MACRO_CNTL_RESERVED45_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED46                                                                   0x286c
#define mmDPHY_MACRO_CNTL_RESERVED46_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED47                                                                   0x286d
#define mmDPHY_MACRO_CNTL_RESERVED47_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED48                                                                   0x286e
#define mmDPHY_MACRO_CNTL_RESERVED48_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED49                                                                   0x286f
#define mmDPHY_MACRO_CNTL_RESERVED49_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED50                                                                   0x2870
#define mmDPHY_MACRO_CNTL_RESERVED50_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED51                                                                   0x2871
#define mmDPHY_MACRO_CNTL_RESERVED51_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED52                                                                   0x2872
#define mmDPHY_MACRO_CNTL_RESERVED52_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED53                                                                   0x2873
#define mmDPHY_MACRO_CNTL_RESERVED53_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED54                                                                   0x2874
#define mmDPHY_MACRO_CNTL_RESERVED54_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED55                                                                   0x2875
#define mmDPHY_MACRO_CNTL_RESERVED55_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED56                                                                   0x2876
#define mmDPHY_MACRO_CNTL_RESERVED56_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED57                                                                   0x2877
#define mmDPHY_MACRO_CNTL_RESERVED57_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED58                                                                   0x2878
#define mmDPHY_MACRO_CNTL_RESERVED58_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED59                                                                   0x2879
#define mmDPHY_MACRO_CNTL_RESERVED59_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED60                                                                   0x287a
#define mmDPHY_MACRO_CNTL_RESERVED60_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED61                                                                   0x287b
#define mmDPHY_MACRO_CNTL_RESERVED61_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED62                                                                   0x287c
#define mmDPHY_MACRO_CNTL_RESERVED62_BASE_IDX                                                          2
#define mmDPHY_MACRO_CNTL_RESERVED63                                                                   0x287d
#define mmDPHY_MACRO_CNTL_RESERVED63_BASE_IDX                                                          2
#define mmDPRX_AUX_REFERENCE_PULSE_DIV                                                                 0x2a7e
#define mmDPRX_AUX_REFERENCE_PULSE_DIV_BASE_IDX                                                        2
#define mmDPRX_AUX_CONTROL                                                                             0x2a7f
#define mmDPRX_AUX_CONTROL_BASE_IDX                                                                    2
#define mmDPRX_AUX_HPD_CONTROL1                                                                        0x2a80
#define mmDPRX_AUX_HPD_CONTROL1_BASE_IDX                                                               2
#define mmDPRX_AUX_HPD_CONTROL2                                                                        0x2a81
#define mmDPRX_AUX_HPD_CONTROL2_BASE_IDX                                                               2
#define mmDPRX_AUX_RX_STATUS                                                                           0x2a82
#define mmDPRX_AUX_RX_STATUS_BASE_IDX                                                                  2
#define mmDPRX_AUX_RX_ERROR_MASK                                                                       0x2a83
#define mmDPRX_AUX_RX_ERROR_MASK_BASE_IDX                                                              2
#define mmDPRX_AUX_DPHY_TX_REF_CONTROL                                                                 0x2a84
#define mmDPRX_AUX_DPHY_TX_REF_CONTROL_BASE_IDX                                                        2
#define mmDPRX_AUX_DPHY_TX_CONTROL                                                                     0x2a85
#define mmDPRX_AUX_DPHY_TX_CONTROL_BASE_IDX                                                            2
#define mmDPRX_AUX_DPHY_RX_CONTROL0                                                                    0x2a86
#define mmDPRX_AUX_DPHY_RX_CONTROL0_BASE_IDX                                                           2
#define mmDPRX_AUX_DPHY_RX_CONTROL1                                                                    0x2a87
#define mmDPRX_AUX_DPHY_RX_CONTROL1_BASE_IDX                                                           2
#define mmDPRX_AUX_DPHY_TX_STATUS                                                                      0x2a88
#define mmDPRX_AUX_DPHY_TX_STATUS_BASE_IDX                                                             2
#define mmDPRX_AUX_DPHY_RX_STATUS                                                                      0x2a89
#define mmDPRX_AUX_DPHY_RX_STATUS_BASE_IDX                                                             2
#define mmDPRX_AUX_DMCU_HW_INT_STATUS                                                                  0x2a8a
#define mmDPRX_AUX_DMCU_HW_INT_STATUS_BASE_IDX                                                         2
#define mmDPRX_AUX_DMCU_HW_INT_ACK                                                                     0x2a8b
#define mmDPRX_AUX_DMCU_HW_INT_ACK_BASE_IDX                                                            2
#define mmDPRX_AUX_CPU_TO_DMCU_INTERRUPT1                                                              0x2a8c
#define mmDPRX_AUX_CPU_TO_DMCU_INTERRUPT1_BASE_IDX                                                     2
#define mmDPRX_AUX_CPU_TO_DMCU_INTERRUPT2                                                              0x2a8d
#define mmDPRX_AUX_CPU_TO_DMCU_INTERRUPT2_BASE_IDX                                                     2
#define mmDPRX_AUX_DMCU_TO_CPU_INTERRUPT1                                                              0x2a8e
#define mmDPRX_AUX_DMCU_TO_CPU_INTERRUPT1_BASE_IDX                                                     2
#define mmDPRX_AUX_DMCU_TO_CPU_INTERRUPT2                                                              0x2a8f
#define mmDPRX_AUX_DMCU_TO_CPU_INTERRUPT2_BASE_IDX                                                     2
#define mmDPRX_AUX_AUX_BUF_INDEX                                                                       0x2a90
#define mmDPRX_AUX_AUX_BUF_INDEX_BASE_IDX                                                              2
#define mmDPRX_AUX_AUX_BUF_DATA                                                                        0x2a91
#define mmDPRX_AUX_AUX_BUF_DATA_BASE_IDX                                                               2
#define mmDPRX_AUX_EDID_INDEX                                                                          0x2a92
#define mmDPRX_AUX_EDID_INDEX_BASE_IDX                                                                 2
#define mmDPRX_AUX_EDID_DATA                                                                           0x2a93
#define mmDPRX_AUX_EDID_DATA_BASE_IDX                                                                  2
#define mmDPRX_AUX_DPCD_INDEX1                                                                         0x2a94
#define mmDPRX_AUX_DPCD_INDEX1_BASE_IDX                                                                2
#define mmDPRX_AUX_DPCD_DATA1                                                                          0x2a95
#define mmDPRX_AUX_DPCD_DATA1_BASE_IDX                                                                 2
#define mmDPRX_AUX_DPCD_INDEX2                                                                         0x2a96
#define mmDPRX_AUX_DPCD_INDEX2_BASE_IDX                                                                2
#define mmDPRX_AUX_DPCD_DATA2                                                                          0x2a97
#define mmDPRX_AUX_DPCD_DATA2_BASE_IDX                                                                 2
#define mmDPRX_AUX_MSG_INDEX1                                                                          0x2a98
#define mmDPRX_AUX_MSG_INDEX1_BASE_IDX                                                                 2
#define mmDPRX_AUX_MSG_DATA1                                                                           0x2a99
#define mmDPRX_AUX_MSG_DATA1_BASE_IDX                                                                  2
#define mmDPRX_AUX_MSG_INDEX2                                                                          0x2a9a
#define mmDPRX_AUX_MSG_INDEX2_BASE_IDX                                                                 2
#define mmDPRX_AUX_MSG_DATA2                                                                           0x2a9b
#define mmDPRX_AUX_MSG_DATA2_BASE_IDX                                                                  2
#define mmDPRX_AUX_KSV_INDEX1                                                                          0x2a9c
#define mmDPRX_AUX_KSV_INDEX1_BASE_IDX                                                                 2
#define mmDPRX_AUX_KSV_DATA1                                                                           0x2a9d
#define mmDPRX_AUX_KSV_DATA1_BASE_IDX                                                                  2
#define mmDPRX_AUX_KSV_INDEX2                                                                          0x2a9e
#define mmDPRX_AUX_KSV_INDEX2_BASE_IDX                                                                 2
#define mmDPRX_AUX_KSV_DATA2                                                                           0x2a9f
#define mmDPRX_AUX_KSV_DATA2_BASE_IDX                                                                  2
#define mmDPRX_AUX_MSG_TIMEOUT_CONTROL                                                                 0x2aa0
#define mmDPRX_AUX_MSG_TIMEOUT_CONTROL_BASE_IDX                                                        2
#define mmDPRX_AUX_MSG_BUF_CONTROL1                                                                    0x2aa1
#define mmDPRX_AUX_MSG_BUF_CONTROL1_BASE_IDX                                                           2
#define mmDPRX_AUX_MSG_BUF_CONTROL2                                                                    0x2aa2
#define mmDPRX_AUX_MSG_BUF_CONTROL2_BASE_IDX                                                           2
#define mmDPRX_AUX_SCRATCH1                                                                            0x2aa3
#define mmDPRX_AUX_SCRATCH1_BASE_IDX                                                                   2
#define mmDPRX_AUX_SCRATCH2                                                                            0x2aa4
#define mmDPRX_AUX_SCRATCH2_BASE_IDX                                                                   2
#define mmDPRX_AUX_MSG1_PENDING                                                                        0x2aa5
#define mmDPRX_AUX_MSG1_PENDING_BASE_IDX                                                               2
#define mmDPRX_AUX_MSG2_PENDING                                                                        0x2aa6
#define mmDPRX_AUX_MSG2_PENDING_BASE_IDX                                                               2
#define mmDPRX_AUX_MSG3_PENDING                                                                        0x2aa7
#define mmDPRX_AUX_MSG3_PENDING_BASE_IDX                                                               2
#define mmDPRX_AUX_MSG4_PENDING                                                                        0x2aa8
#define mmDPRX_AUX_MSG4_PENDING_BASE_IDX                                                               2
#define mmDPRX_DPHY_DPCD_LANE_COUNT_SET                                                                0x2afe
#define mmDPRX_DPHY_DPCD_LANE_COUNT_SET_BASE_IDX                                                       2
#define mmDPRX_DPHY_DPCD_TRAINING_PATTERN_SET                                                          0x2aff
#define mmDPRX_DPHY_DPCD_TRAINING_PATTERN_SET_BASE_IDX                                                 2
#define mmDPRX_DPHY_DPCD_MSTM_CTRL                                                                     0x2b00
#define mmDPRX_DPHY_DPCD_MSTM_CTRL_BASE_IDX                                                            2
#define mmDPRX_DPHY_DPCD_LINK_QUAL_LANE0_SET                                                           0x2b01
#define mmDPRX_DPHY_DPCD_LINK_QUAL_LANE0_SET_BASE_IDX                                                  2
#define mmDPRX_DPHY_DPCD_LINK_QUAL_LANE0_STATUS                                                        0x2b02
#define mmDPRX_DPHY_DPCD_LINK_QUAL_LANE0_STATUS_BASE_IDX                                               2
#define mmDPRX_DPHY_DPCD_LINK_QUAL_LANE1_SET                                                           0x2b03
#define mmDPRX_DPHY_DPCD_LINK_QUAL_LANE1_SET_BASE_IDX                                                  2
#define mmDPRX_DPHY_DPCD_LINK_QUAL_LANE1_STATUS                                                        0x2b04
#define mmDPRX_DPHY_DPCD_LINK_QUAL_LANE1_STATUS_BASE_IDX                                               2
#define mmDPRX_DPHY_DPCD_LINK_QUAL_LANE2_SET                                                           0x2b05
#define mmDPRX_DPHY_DPCD_LINK_QUAL_LANE2_SET_BASE_IDX                                                  2
#define mmDPRX_DPHY_DPCD_LINK_QUAL_LANE2_STATUS                                                        0x2b06
#define mmDPRX_DPHY_DPCD_LINK_QUAL_LANE2_STATUS_BASE_IDX                                               2
#define mmDPRX_DPHY_DPCD_LINK_QUAL_LANE3_SET                                                           0x2b07
#define mmDPRX_DPHY_DPCD_LINK_QUAL_LANE3_SET_BASE_IDX                                                  2
#define mmDPRX_DPHY_DPCD_LINK_QUAL_LANE3_STATUS                                                        0x2b08
#define mmDPRX_DPHY_DPCD_LINK_QUAL_LANE3_STATUS_BASE_IDX                                               2
#define mmDPRX_DPHY_READY                                                                              0x2b09
#define mmDPRX_DPHY_READY_BASE_IDX                                                                     2
#define mmDPRX_DPHY_COMMA_STATUS                                                                       0x2b0b
#define mmDPRX_DPHY_COMMA_STATUS_BASE_IDX                                                              2
#define mmDPRX_DPHY_LANE_ALIGN_ERROR_STATUS_UPDATED                                                    0x2b0c
#define mmDPRX_DPHY_LANE_ALIGN_ERROR_STATUS_UPDATED_BASE_IDX                                           2
#define mmDPRX_DPHY_LANE_ALIGN_STATUS_UPDATED                                                          0x2b0d
#define mmDPRX_DPHY_LANE_ALIGN_STATUS_UPDATED_BASE_IDX                                                 2
#define mmDPRX_DPHY_ERROR_THRESH_A_LANE0                                                               0x2b0f
#define mmDPRX_DPHY_ERROR_THRESH_A_LANE0_BASE_IDX                                                      2
#define mmDPRX_DPHY_ERROR_COUNT_A_LANE0                                                                0x2b11
#define mmDPRX_DPHY_ERROR_COUNT_A_LANE0_BASE_IDX                                                       2
#define mmDPRX_DPHY_ERROR_COUNT_B_LANE0                                                                0x2b12
#define mmDPRX_DPHY_ERROR_COUNT_B_LANE0_BASE_IDX                                                       2
#define mmDPRX_DPHY_ERROR_COUNT_C_LANE0                                                                0x2b13
#define mmDPRX_DPHY_ERROR_COUNT_C_LANE0_BASE_IDX                                                       2
#define mmDPRX_DPHY_ERROR_THRESH_A_LANE1                                                               0x2b14
#define mmDPRX_DPHY_ERROR_THRESH_A_LANE1_BASE_IDX                                                      2
#define mmDPRX_DPHY_ERROR_COUNT_A_LANE1                                                                0x2b16
#define mmDPRX_DPHY_ERROR_COUNT_A_LANE1_BASE_IDX                                                       2
#define mmDPRX_DPHY_ERROR_COUNT_B_LANE1                                                                0x2b17
#define mmDPRX_DPHY_ERROR_COUNT_B_LANE1_BASE_IDX                                                       2
#define mmDPRX_DPHY_ERROR_COUNT_C_LANE1                                                                0x2b18
#define mmDPRX_DPHY_ERROR_COUNT_C_LANE1_BASE_IDX                                                       2
#define mmDPRX_DPHY_ERROR_THRESH_A_LANE2                                                               0x2b19
#define mmDPRX_DPHY_ERROR_THRESH_A_LANE2_BASE_IDX                                                      2
#define mmDPRX_DPHY_ERROR_COUNT_A_LANE2                                                                0x2b1b
#define mmDPRX_DPHY_ERROR_COUNT_A_LANE2_BASE_IDX                                                       2
#define mmDPRX_DPHY_ERROR_COUNT_B_LANE2                                                                0x2b1c
#define mmDPRX_DPHY_ERROR_COUNT_B_LANE2_BASE_IDX                                                       2
#define mmDPRX_DPHY_ERROR_COUNT_C_LANE2                                                                0x2b1d
#define mmDPRX_DPHY_ERROR_COUNT_C_LANE2_BASE_IDX                                                       2
#define mmDPRX_DPHY_ERROR_THRESH_A_LANE3                                                               0x2b1e
#define mmDPRX_DPHY_ERROR_THRESH_A_LANE3_BASE_IDX                                                      2
#define mmDPRX_DPHY_ERROR_COUNT_A_LANE3                                                                0x2b20
#define mmDPRX_DPHY_ERROR_COUNT_A_LANE3_BASE_IDX                                                       2
#define mmDPRX_DPHY_ERROR_COUNT_B_LANE3                                                                0x2b21
#define mmDPRX_DPHY_ERROR_COUNT_B_LANE3_BASE_IDX                                                       2
#define mmDPRX_DPHY_ERROR_COUNT_C_LANE3                                                                0x2b22
#define mmDPRX_DPHY_ERROR_COUNT_C_LANE3_BASE_IDX                                                       2
#define mmDPRX_DPHY_BS_ERROR_THRESH_GLOBAL                                                             0x2b24
#define mmDPRX_DPHY_BS_ERROR_THRESH_GLOBAL_BASE_IDX                                                    2
#define mmDPRX_DPHY_SR_ERROR_COUNT_A                                                                   0x2b25
#define mmDPRX_DPHY_SR_ERROR_COUNT_A_BASE_IDX                                                          2
#define mmDPRX_DPHY_BS_ERROR_COUNT_A                                                                   0x2b27
#define mmDPRX_DPHY_BS_ERROR_COUNT_A_BASE_IDX                                                          2
#define mmDPRX_DPHY_BS_ERROR_COUNT_B                                                                   0x2b28
#define mmDPRX_DPHY_BS_ERROR_COUNT_B_BASE_IDX                                                          2
#define mmDPRX_DPHY_LANESETUP0                                                                         0x2b2d
#define mmDPRX_DPHY_LANESETUP0_BASE_IDX                                                                2
#define mmDPRX_DPHY_LANESETUP1                                                                         0x2b2e
#define mmDPRX_DPHY_LANESETUP1_BASE_IDX                                                                2
#define mmDPRX_DPHY_LFSRADV                                                                            0x2b31
#define mmDPRX_DPHY_LFSRADV_BASE_IDX                                                                   2
#define mmDPRX_DPHY_SEVENSYMBOLWINDOW_ERROR_DETECT                                                     0x2b32
#define mmDPRX_DPHY_SEVENSYMBOLWINDOW_ERROR_DETECT_BASE_IDX                                            2
#define mmDPRX_DPHY_SET_ENABLE                                                                         0x2b33
#define mmDPRX_DPHY_SET_ENABLE_BASE_IDX                                                                2
#define mmDPRX_DPHY_ECF_LSB                                                                            0x2b34
#define mmDPRX_DPHY_ECF_LSB_BASE_IDX                                                                   2
#define mmDPRX_DPHY_ECF_MSB                                                                            0x2b35
#define mmDPRX_DPHY_ECF_MSB_BASE_IDX                                                                   2
#define mmDPRX_DPHY_ENHANCED_FRAME_EN                                                                  0x2b36
#define mmDPRX_DPHY_ENHANCED_FRAME_EN_BASE_IDX                                                         2
#define mmDPRX_DPHY_MTP_HEADER_COUNT_FORCE                                                             0x2b3c
#define mmDPRX_DPHY_MTP_HEADER_COUNT_FORCE_BASE_IDX                                                    2
#define mmDPRX_DPHY_DYNAMIC_DESKEW_DATA                                                                0x2b3d
#define mmDPRX_DPHY_DYNAMIC_DESKEW_DATA_BASE_IDX                                                       2
#define mmDPRX_DPHY_DYNAMIC_DESKEW_CONTROL                                                             0x2b3e
#define mmDPRX_DPHY_DYNAMIC_DESKEW_CONTROL_BASE_IDX                                                    2
#define mmDPRX_DPHY_BYPASS                                                                             0x2b3f
#define mmDPRX_DPHY_BYPASS_BASE_IDX                                                                    2
#define mmDPRX_DPHY_INT_RESET                                                                          0x2b40
#define mmDPRX_DPHY_INT_RESET_BASE_IDX                                                                 2
#define mmDPRX_DPHY_BS_INTERVAL_ERROR_THRESH_EXCEEDED_STATUS                                           0x2b41
#define mmDPRX_DPHY_BS_INTERVAL_ERROR_THRESH_EXCEEDED_STATUS_BASE_IDX                                  2
#define mmDPRX_DPHY_SYMBOL_ERROR_THRESH_EXCEEDED_STATUS                                                0x2b43
#define mmDPRX_DPHY_SYMBOL_ERROR_THRESH_EXCEEDED_STATUS_BASE_IDX                                       2
#define mmDPRX_DPHY_DISPARITY_ERROR_THRESH_EXCEEDED_STATUS                                             0x2b44
#define mmDPRX_DPHY_DISPARITY_ERROR_THRESH_EXCEEDED_STATUS_BASE_IDX                                    2
#define mmDPRX_DPHY_TEST_PATTERN_ERROR_THRESH_EXCEEDED_STATUS                                          0x2b46
#define mmDPRX_DPHY_TEST_PATTERN_ERROR_THRESH_EXCEEDED_STATUS_BASE_IDX                                 2
#define mmDPRX_DPHY_DETECT_SR_LOCK_STATUS                                                              0x2b48
#define mmDPRX_DPHY_DETECT_SR_LOCK_STATUS_BASE_IDX                                                     2
#define mmDPRX_DPHY_LOSS_OF_ALIGN_STATUS                                                               0x2b49
#define mmDPRX_DPHY_LOSS_OF_ALIGN_STATUS_BASE_IDX                                                      2
#define mmDPRX_DPHY_LOSS_OF_DESKEW_STATUS                                                              0x2b4a
#define mmDPRX_DPHY_LOSS_OF_DESKEW_STATUS_BASE_IDX                                                     2
#define mmDPRX_DPHY_EXCESSIVE_ERROR_STATUS                                                             0x2b4b
#define mmDPRX_DPHY_EXCESSIVE_ERROR_STATUS_BASE_IDX                                                    2
#define mmDPRX_DPHY_DESKEW_FIFO_OVERFLOW_STATUS                                                        0x2b4c
#define mmDPRX_DPHY_DESKEW_FIFO_OVERFLOW_STATUS_BASE_IDX                                               2
#define mmDPRX_DPHY_SPARE                                                                              0x2b4d
#define mmDPRX_DPHY_SPARE_BASE_IDX                                                                     2
#define mmDCRX_GATE_DISABLE_CNTL                                                                       0x2b6e
#define mmDCRX_GATE_DISABLE_CNTL_BASE_IDX                                                              2
#define mmDCRX_SOFT_RESET                                                                              0x2b6f
#define mmDCRX_SOFT_RESET_BASE_IDX                                                                     2
#define mmDCRX_LIGHT_SLEEP_CNTL                                                                        0x2b70
#define mmDCRX_LIGHT_SLEEP_CNTL_BASE_IDX                                                               2
#define mmDCRX_DISPCLK_GATE_CNTL                                                                       0x2b73
#define mmDCRX_DISPCLK_GATE_CNTL_BASE_IDX                                                              2
#define mmDCRX_CLK_CNTL                                                                                0x2b74
#define mmDCRX_CLK_CNTL_BASE_IDX                                                                       2
#define mmDCRX_TEST_CLK_CNTL                                                                           0x2b75
#define mmDCRX_TEST_CLK_CNTL_BASE_IDX                                                                  2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED0                                                                0x2c06
#define mmDCRX_PHY_MACRO_CNTL_RESERVED0_BASE_IDX                                                       2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED1                                                                0x2c07
#define mmDCRX_PHY_MACRO_CNTL_RESERVED1_BASE_IDX                                                       2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED2                                                                0x2c08
#define mmDCRX_PHY_MACRO_CNTL_RESERVED2_BASE_IDX                                                       2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED3                                                                0x2c09
#define mmDCRX_PHY_MACRO_CNTL_RESERVED3_BASE_IDX                                                       2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED4                                                                0x2c0a
#define mmDCRX_PHY_MACRO_CNTL_RESERVED4_BASE_IDX                                                       2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED5                                                                0x2c0b
#define mmDCRX_PHY_MACRO_CNTL_RESERVED5_BASE_IDX                                                       2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED6                                                                0x2c0c
#define mmDCRX_PHY_MACRO_CNTL_RESERVED6_BASE_IDX                                                       2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED7                                                                0x2c0d
#define mmDCRX_PHY_MACRO_CNTL_RESERVED7_BASE_IDX                                                       2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED8                                                                0x2c0e
#define mmDCRX_PHY_MACRO_CNTL_RESERVED8_BASE_IDX                                                       2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED9                                                                0x2c0f
#define mmDCRX_PHY_MACRO_CNTL_RESERVED9_BASE_IDX                                                       2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED10                                                               0x2c10
#define mmDCRX_PHY_MACRO_CNTL_RESERVED10_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED11                                                               0x2c11
#define mmDCRX_PHY_MACRO_CNTL_RESERVED11_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED12                                                               0x2c12
#define mmDCRX_PHY_MACRO_CNTL_RESERVED12_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED13                                                               0x2c13
#define mmDCRX_PHY_MACRO_CNTL_RESERVED13_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED14                                                               0x2c14
#define mmDCRX_PHY_MACRO_CNTL_RESERVED14_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED15                                                               0x2c15
#define mmDCRX_PHY_MACRO_CNTL_RESERVED15_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED16                                                               0x2c16
#define mmDCRX_PHY_MACRO_CNTL_RESERVED16_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED17                                                               0x2c17
#define mmDCRX_PHY_MACRO_CNTL_RESERVED17_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED18                                                               0x2c18
#define mmDCRX_PHY_MACRO_CNTL_RESERVED18_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED19                                                               0x2c19
#define mmDCRX_PHY_MACRO_CNTL_RESERVED19_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED20                                                               0x2c1a
#define mmDCRX_PHY_MACRO_CNTL_RESERVED20_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED21                                                               0x2c1b
#define mmDCRX_PHY_MACRO_CNTL_RESERVED21_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED22                                                               0x2c1c
#define mmDCRX_PHY_MACRO_CNTL_RESERVED22_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED23                                                               0x2c1d
#define mmDCRX_PHY_MACRO_CNTL_RESERVED23_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED24                                                               0x2c1e
#define mmDCRX_PHY_MACRO_CNTL_RESERVED24_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED25                                                               0x2c1f
#define mmDCRX_PHY_MACRO_CNTL_RESERVED25_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED26                                                               0x2c20
#define mmDCRX_PHY_MACRO_CNTL_RESERVED26_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED27                                                               0x2c21
#define mmDCRX_PHY_MACRO_CNTL_RESERVED27_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED28                                                               0x2c22
#define mmDCRX_PHY_MACRO_CNTL_RESERVED28_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED29                                                               0x2c23
#define mmDCRX_PHY_MACRO_CNTL_RESERVED29_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED30                                                               0x2c24
#define mmDCRX_PHY_MACRO_CNTL_RESERVED30_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED31                                                               0x2c25
#define mmDCRX_PHY_MACRO_CNTL_RESERVED31_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED32                                                               0x2c26
#define mmDCRX_PHY_MACRO_CNTL_RESERVED32_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED33                                                               0x2c27
#define mmDCRX_PHY_MACRO_CNTL_RESERVED33_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED34                                                               0x2c28
#define mmDCRX_PHY_MACRO_CNTL_RESERVED34_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED35                                                               0x2c29
#define mmDCRX_PHY_MACRO_CNTL_RESERVED35_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED36                                                               0x2c2a
#define mmDCRX_PHY_MACRO_CNTL_RESERVED36_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED37                                                               0x2c2b
#define mmDCRX_PHY_MACRO_CNTL_RESERVED37_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED38                                                               0x2c2c
#define mmDCRX_PHY_MACRO_CNTL_RESERVED38_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED39                                                               0x2c2d
#define mmDCRX_PHY_MACRO_CNTL_RESERVED39_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED40                                                               0x2c2e
#define mmDCRX_PHY_MACRO_CNTL_RESERVED40_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED41                                                               0x2c2f
#define mmDCRX_PHY_MACRO_CNTL_RESERVED41_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED42                                                               0x2c30
#define mmDCRX_PHY_MACRO_CNTL_RESERVED42_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED43                                                               0x2c31
#define mmDCRX_PHY_MACRO_CNTL_RESERVED43_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED44                                                               0x2c32
#define mmDCRX_PHY_MACRO_CNTL_RESERVED44_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED45                                                               0x2c33
#define mmDCRX_PHY_MACRO_CNTL_RESERVED45_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED46                                                               0x2c34
#define mmDCRX_PHY_MACRO_CNTL_RESERVED46_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED47                                                               0x2c35
#define mmDCRX_PHY_MACRO_CNTL_RESERVED47_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED48                                                               0x2c36
#define mmDCRX_PHY_MACRO_CNTL_RESERVED48_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED49                                                               0x2c37
#define mmDCRX_PHY_MACRO_CNTL_RESERVED49_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED50                                                               0x2c38
#define mmDCRX_PHY_MACRO_CNTL_RESERVED50_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED51                                                               0x2c39
#define mmDCRX_PHY_MACRO_CNTL_RESERVED51_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED52                                                               0x2c3a
#define mmDCRX_PHY_MACRO_CNTL_RESERVED52_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED53                                                               0x2c3b
#define mmDCRX_PHY_MACRO_CNTL_RESERVED53_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED54                                                               0x2c3c
#define mmDCRX_PHY_MACRO_CNTL_RESERVED54_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED55                                                               0x2c3d
#define mmDCRX_PHY_MACRO_CNTL_RESERVED55_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED56                                                               0x2c3e
#define mmDCRX_PHY_MACRO_CNTL_RESERVED56_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED57                                                               0x2c3f
#define mmDCRX_PHY_MACRO_CNTL_RESERVED57_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED58                                                               0x2c40
#define mmDCRX_PHY_MACRO_CNTL_RESERVED58_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED59                                                               0x2c41
#define mmDCRX_PHY_MACRO_CNTL_RESERVED59_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED60                                                               0x2c42
#define mmDCRX_PHY_MACRO_CNTL_RESERVED60_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED61                                                               0x2c43
#define mmDCRX_PHY_MACRO_CNTL_RESERVED61_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED62                                                               0x2c44
#define mmDCRX_PHY_MACRO_CNTL_RESERVED62_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED63                                                               0x2c45
#define mmDCRX_PHY_MACRO_CNTL_RESERVED63_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED64                                                               0x2c46
#define mmDCRX_PHY_MACRO_CNTL_RESERVED64_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED65                                                               0x2c47
#define mmDCRX_PHY_MACRO_CNTL_RESERVED65_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED66                                                               0x2c48
#define mmDCRX_PHY_MACRO_CNTL_RESERVED66_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED67                                                               0x2c49
#define mmDCRX_PHY_MACRO_CNTL_RESERVED67_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED68                                                               0x2c4a
#define mmDCRX_PHY_MACRO_CNTL_RESERVED68_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED69                                                               0x2c4b
#define mmDCRX_PHY_MACRO_CNTL_RESERVED69_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED70                                                               0x2c4c
#define mmDCRX_PHY_MACRO_CNTL_RESERVED70_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED71                                                               0x2c4d
#define mmDCRX_PHY_MACRO_CNTL_RESERVED71_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED72                                                               0x2c4e
#define mmDCRX_PHY_MACRO_CNTL_RESERVED72_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED73                                                               0x2c4f
#define mmDCRX_PHY_MACRO_CNTL_RESERVED73_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED74                                                               0x2c50
#define mmDCRX_PHY_MACRO_CNTL_RESERVED74_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED75                                                               0x2c51
#define mmDCRX_PHY_MACRO_CNTL_RESERVED75_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED76                                                               0x2c52
#define mmDCRX_PHY_MACRO_CNTL_RESERVED76_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED77                                                               0x2c53
#define mmDCRX_PHY_MACRO_CNTL_RESERVED77_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED78                                                               0x2c54
#define mmDCRX_PHY_MACRO_CNTL_RESERVED78_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED79                                                               0x2c55
#define mmDCRX_PHY_MACRO_CNTL_RESERVED79_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED80                                                               0x2c56
#define mmDCRX_PHY_MACRO_CNTL_RESERVED80_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED81                                                               0x2c57
#define mmDCRX_PHY_MACRO_CNTL_RESERVED81_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED82                                                               0x2c58
#define mmDCRX_PHY_MACRO_CNTL_RESERVED82_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED83                                                               0x2c59
#define mmDCRX_PHY_MACRO_CNTL_RESERVED83_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED84                                                               0x2c5a
#define mmDCRX_PHY_MACRO_CNTL_RESERVED84_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED85                                                               0x2c5b
#define mmDCRX_PHY_MACRO_CNTL_RESERVED85_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED86                                                               0x2c5c
#define mmDCRX_PHY_MACRO_CNTL_RESERVED86_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED87                                                               0x2c5d
#define mmDCRX_PHY_MACRO_CNTL_RESERVED87_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED88                                                               0x2c5e
#define mmDCRX_PHY_MACRO_CNTL_RESERVED88_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED89                                                               0x2c5f
#define mmDCRX_PHY_MACRO_CNTL_RESERVED89_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED90                                                               0x2c60
#define mmDCRX_PHY_MACRO_CNTL_RESERVED90_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED91                                                               0x2c61
#define mmDCRX_PHY_MACRO_CNTL_RESERVED91_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED92                                                               0x2c62
#define mmDCRX_PHY_MACRO_CNTL_RESERVED92_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED93                                                               0x2c63
#define mmDCRX_PHY_MACRO_CNTL_RESERVED93_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED94                                                               0x2c64
#define mmDCRX_PHY_MACRO_CNTL_RESERVED94_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED95                                                               0x2c65
#define mmDCRX_PHY_MACRO_CNTL_RESERVED95_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED96                                                               0x2c66
#define mmDCRX_PHY_MACRO_CNTL_RESERVED96_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED97                                                               0x2c67
#define mmDCRX_PHY_MACRO_CNTL_RESERVED97_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED98                                                               0x2c68
#define mmDCRX_PHY_MACRO_CNTL_RESERVED98_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED99                                                               0x2c69
#define mmDCRX_PHY_MACRO_CNTL_RESERVED99_BASE_IDX                                                      2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED100                                                              0x2c6a
#define mmDCRX_PHY_MACRO_CNTL_RESERVED100_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED101                                                              0x2c6b
#define mmDCRX_PHY_MACRO_CNTL_RESERVED101_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED102                                                              0x2c6c
#define mmDCRX_PHY_MACRO_CNTL_RESERVED102_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED103                                                              0x2c6d
#define mmDCRX_PHY_MACRO_CNTL_RESERVED103_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED104                                                              0x2c6e
#define mmDCRX_PHY_MACRO_CNTL_RESERVED104_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED105                                                              0x2c6f
#define mmDCRX_PHY_MACRO_CNTL_RESERVED105_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED106                                                              0x2c70
#define mmDCRX_PHY_MACRO_CNTL_RESERVED106_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED107                                                              0x2c71
#define mmDCRX_PHY_MACRO_CNTL_RESERVED107_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED108                                                              0x2c72
#define mmDCRX_PHY_MACRO_CNTL_RESERVED108_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED109                                                              0x2c73
#define mmDCRX_PHY_MACRO_CNTL_RESERVED109_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED110                                                              0x2c74
#define mmDCRX_PHY_MACRO_CNTL_RESERVED110_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED111                                                              0x2c75
#define mmDCRX_PHY_MACRO_CNTL_RESERVED111_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED112                                                              0x2c76
#define mmDCRX_PHY_MACRO_CNTL_RESERVED112_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED113                                                              0x2c77
#define mmDCRX_PHY_MACRO_CNTL_RESERVED113_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED114                                                              0x2c78
#define mmDCRX_PHY_MACRO_CNTL_RESERVED114_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED115                                                              0x2c79
#define mmDCRX_PHY_MACRO_CNTL_RESERVED115_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED116                                                              0x2c7a
#define mmDCRX_PHY_MACRO_CNTL_RESERVED116_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED117                                                              0x2c7b
#define mmDCRX_PHY_MACRO_CNTL_RESERVED117_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED118                                                              0x2c7c
#define mmDCRX_PHY_MACRO_CNTL_RESERVED118_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED119                                                              0x2c7d
#define mmDCRX_PHY_MACRO_CNTL_RESERVED119_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED120                                                              0x2c7e
#define mmDCRX_PHY_MACRO_CNTL_RESERVED120_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED121                                                              0x2c7f
#define mmDCRX_PHY_MACRO_CNTL_RESERVED121_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED122                                                              0x2c80
#define mmDCRX_PHY_MACRO_CNTL_RESERVED122_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED123                                                              0x2c81
#define mmDCRX_PHY_MACRO_CNTL_RESERVED123_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED124                                                              0x2c82
#define mmDCRX_PHY_MACRO_CNTL_RESERVED124_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED125                                                              0x2c83
#define mmDCRX_PHY_MACRO_CNTL_RESERVED125_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED126                                                              0x2c84
#define mmDCRX_PHY_MACRO_CNTL_RESERVED126_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED127                                                              0x2c85
#define mmDCRX_PHY_MACRO_CNTL_RESERVED127_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED128                                                              0x2c86
#define mmDCRX_PHY_MACRO_CNTL_RESERVED128_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED129                                                              0x2c87
#define mmDCRX_PHY_MACRO_CNTL_RESERVED129_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED130                                                              0x2c88
#define mmDCRX_PHY_MACRO_CNTL_RESERVED130_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED131                                                              0x2c89
#define mmDCRX_PHY_MACRO_CNTL_RESERVED131_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED132                                                              0x2c8a
#define mmDCRX_PHY_MACRO_CNTL_RESERVED132_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED133                                                              0x2c8b
#define mmDCRX_PHY_MACRO_CNTL_RESERVED133_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED134                                                              0x2c8c
#define mmDCRX_PHY_MACRO_CNTL_RESERVED134_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED135                                                              0x2c8d
#define mmDCRX_PHY_MACRO_CNTL_RESERVED135_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED136                                                              0x2c8e
#define mmDCRX_PHY_MACRO_CNTL_RESERVED136_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED137                                                              0x2c8f
#define mmDCRX_PHY_MACRO_CNTL_RESERVED137_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED138                                                              0x2c90
#define mmDCRX_PHY_MACRO_CNTL_RESERVED138_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED139                                                              0x2c91
#define mmDCRX_PHY_MACRO_CNTL_RESERVED139_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED140                                                              0x2c92
#define mmDCRX_PHY_MACRO_CNTL_RESERVED140_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED141                                                              0x2c93
#define mmDCRX_PHY_MACRO_CNTL_RESERVED141_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED142                                                              0x2c94
#define mmDCRX_PHY_MACRO_CNTL_RESERVED142_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED143                                                              0x2c95
#define mmDCRX_PHY_MACRO_CNTL_RESERVED143_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED144                                                              0x2c96
#define mmDCRX_PHY_MACRO_CNTL_RESERVED144_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED145                                                              0x2c97
#define mmDCRX_PHY_MACRO_CNTL_RESERVED145_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED146                                                              0x2c98
#define mmDCRX_PHY_MACRO_CNTL_RESERVED146_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED147                                                              0x2c99
#define mmDCRX_PHY_MACRO_CNTL_RESERVED147_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED148                                                              0x2c9a
#define mmDCRX_PHY_MACRO_CNTL_RESERVED148_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED149                                                              0x2c9b
#define mmDCRX_PHY_MACRO_CNTL_RESERVED149_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED150                                                              0x2c9c
#define mmDCRX_PHY_MACRO_CNTL_RESERVED150_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED151                                                              0x2c9d
#define mmDCRX_PHY_MACRO_CNTL_RESERVED151_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED152                                                              0x2c9e
#define mmDCRX_PHY_MACRO_CNTL_RESERVED152_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED153                                                              0x2c9f
#define mmDCRX_PHY_MACRO_CNTL_RESERVED153_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED154                                                              0x2ca0
#define mmDCRX_PHY_MACRO_CNTL_RESERVED154_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED155                                                              0x2ca1
#define mmDCRX_PHY_MACRO_CNTL_RESERVED155_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED156                                                              0x2ca2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED156_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED157                                                              0x2ca3
#define mmDCRX_PHY_MACRO_CNTL_RESERVED157_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED158                                                              0x2ca4
#define mmDCRX_PHY_MACRO_CNTL_RESERVED158_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED159                                                              0x2ca5
#define mmDCRX_PHY_MACRO_CNTL_RESERVED159_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED160                                                              0x2ca6
#define mmDCRX_PHY_MACRO_CNTL_RESERVED160_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED161                                                              0x2ca7
#define mmDCRX_PHY_MACRO_CNTL_RESERVED161_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED162                                                              0x2ca8
#define mmDCRX_PHY_MACRO_CNTL_RESERVED162_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED163                                                              0x2ca9
#define mmDCRX_PHY_MACRO_CNTL_RESERVED163_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED164                                                              0x2caa
#define mmDCRX_PHY_MACRO_CNTL_RESERVED164_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED165                                                              0x2cab
#define mmDCRX_PHY_MACRO_CNTL_RESERVED165_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED166                                                              0x2cac
#define mmDCRX_PHY_MACRO_CNTL_RESERVED166_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED167                                                              0x2cad
#define mmDCRX_PHY_MACRO_CNTL_RESERVED167_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED168                                                              0x2cae
#define mmDCRX_PHY_MACRO_CNTL_RESERVED168_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED169                                                              0x2caf
#define mmDCRX_PHY_MACRO_CNTL_RESERVED169_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED170                                                              0x2cb0
#define mmDCRX_PHY_MACRO_CNTL_RESERVED170_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED171                                                              0x2cb1
#define mmDCRX_PHY_MACRO_CNTL_RESERVED171_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED172                                                              0x2cb2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED172_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED173                                                              0x2cb3
#define mmDCRX_PHY_MACRO_CNTL_RESERVED173_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED174                                                              0x2cb4
#define mmDCRX_PHY_MACRO_CNTL_RESERVED174_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED175                                                              0x2cb5
#define mmDCRX_PHY_MACRO_CNTL_RESERVED175_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED176                                                              0x2cb6
#define mmDCRX_PHY_MACRO_CNTL_RESERVED176_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED177                                                              0x2cb7
#define mmDCRX_PHY_MACRO_CNTL_RESERVED177_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED178                                                              0x2cb8
#define mmDCRX_PHY_MACRO_CNTL_RESERVED178_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED179                                                              0x2cb9
#define mmDCRX_PHY_MACRO_CNTL_RESERVED179_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED180                                                              0x2cba
#define mmDCRX_PHY_MACRO_CNTL_RESERVED180_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED181                                                              0x2cbb
#define mmDCRX_PHY_MACRO_CNTL_RESERVED181_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED182                                                              0x2cbc
#define mmDCRX_PHY_MACRO_CNTL_RESERVED182_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED183                                                              0x2cbd
#define mmDCRX_PHY_MACRO_CNTL_RESERVED183_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED184                                                              0x2cbe
#define mmDCRX_PHY_MACRO_CNTL_RESERVED184_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED185                                                              0x2cbf
#define mmDCRX_PHY_MACRO_CNTL_RESERVED185_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED186                                                              0x2cc0
#define mmDCRX_PHY_MACRO_CNTL_RESERVED186_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED187                                                              0x2cc1
#define mmDCRX_PHY_MACRO_CNTL_RESERVED187_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED188                                                              0x2cc2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED188_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED189                                                              0x2cc3
#define mmDCRX_PHY_MACRO_CNTL_RESERVED189_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED190                                                              0x2cc4
#define mmDCRX_PHY_MACRO_CNTL_RESERVED190_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED191                                                              0x2cc5
#define mmDCRX_PHY_MACRO_CNTL_RESERVED191_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED192                                                              0x2cc6
#define mmDCRX_PHY_MACRO_CNTL_RESERVED192_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED193                                                              0x2cc7
#define mmDCRX_PHY_MACRO_CNTL_RESERVED193_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED194                                                              0x2cc8
#define mmDCRX_PHY_MACRO_CNTL_RESERVED194_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED195                                                              0x2cc9
#define mmDCRX_PHY_MACRO_CNTL_RESERVED195_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED196                                                              0x2cca
#define mmDCRX_PHY_MACRO_CNTL_RESERVED196_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED197                                                              0x2ccb
#define mmDCRX_PHY_MACRO_CNTL_RESERVED197_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED198                                                              0x2ccc
#define mmDCRX_PHY_MACRO_CNTL_RESERVED198_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED199                                                              0x2ccd
#define mmDCRX_PHY_MACRO_CNTL_RESERVED199_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED200                                                              0x2cce
#define mmDCRX_PHY_MACRO_CNTL_RESERVED200_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED201                                                              0x2ccf
#define mmDCRX_PHY_MACRO_CNTL_RESERVED201_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED202                                                              0x2cd0
#define mmDCRX_PHY_MACRO_CNTL_RESERVED202_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED203                                                              0x2cd1
#define mmDCRX_PHY_MACRO_CNTL_RESERVED203_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED204                                                              0x2cd2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED204_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED205                                                              0x2cd3
#define mmDCRX_PHY_MACRO_CNTL_RESERVED205_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED206                                                              0x2cd4
#define mmDCRX_PHY_MACRO_CNTL_RESERVED206_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED207                                                              0x2cd5
#define mmDCRX_PHY_MACRO_CNTL_RESERVED207_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED208                                                              0x2cd6
#define mmDCRX_PHY_MACRO_CNTL_RESERVED208_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED209                                                              0x2cd7
#define mmDCRX_PHY_MACRO_CNTL_RESERVED209_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED210                                                              0x2cd8
#define mmDCRX_PHY_MACRO_CNTL_RESERVED210_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED211                                                              0x2cd9
#define mmDCRX_PHY_MACRO_CNTL_RESERVED211_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED212                                                              0x2cda
#define mmDCRX_PHY_MACRO_CNTL_RESERVED212_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED213                                                              0x2cdb
#define mmDCRX_PHY_MACRO_CNTL_RESERVED213_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED214                                                              0x2cdc
#define mmDCRX_PHY_MACRO_CNTL_RESERVED214_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED215                                                              0x2cdd
#define mmDCRX_PHY_MACRO_CNTL_RESERVED215_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED216                                                              0x2cde
#define mmDCRX_PHY_MACRO_CNTL_RESERVED216_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED217                                                              0x2cdf
#define mmDCRX_PHY_MACRO_CNTL_RESERVED217_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED218                                                              0x2ce0
#define mmDCRX_PHY_MACRO_CNTL_RESERVED218_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED219                                                              0x2ce1
#define mmDCRX_PHY_MACRO_CNTL_RESERVED219_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED220                                                              0x2ce2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED220_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED221                                                              0x2ce3
#define mmDCRX_PHY_MACRO_CNTL_RESERVED221_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED222                                                              0x2ce4
#define mmDCRX_PHY_MACRO_CNTL_RESERVED222_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED223                                                              0x2ce5
#define mmDCRX_PHY_MACRO_CNTL_RESERVED223_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED224                                                              0x2ce6
#define mmDCRX_PHY_MACRO_CNTL_RESERVED224_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED225                                                              0x2ce7
#define mmDCRX_PHY_MACRO_CNTL_RESERVED225_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED226                                                              0x2ce8
#define mmDCRX_PHY_MACRO_CNTL_RESERVED226_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED227                                                              0x2ce9
#define mmDCRX_PHY_MACRO_CNTL_RESERVED227_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED228                                                              0x2cea
#define mmDCRX_PHY_MACRO_CNTL_RESERVED228_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED229                                                              0x2ceb
#define mmDCRX_PHY_MACRO_CNTL_RESERVED229_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED230                                                              0x2cec
#define mmDCRX_PHY_MACRO_CNTL_RESERVED230_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED231                                                              0x2ced
#define mmDCRX_PHY_MACRO_CNTL_RESERVED231_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED232                                                              0x2cee
#define mmDCRX_PHY_MACRO_CNTL_RESERVED232_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED233                                                              0x2cef
#define mmDCRX_PHY_MACRO_CNTL_RESERVED233_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED234                                                              0x2cf0
#define mmDCRX_PHY_MACRO_CNTL_RESERVED234_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED235                                                              0x2cf1
#define mmDCRX_PHY_MACRO_CNTL_RESERVED235_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED236                                                              0x2cf2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED236_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED237                                                              0x2cf3
#define mmDCRX_PHY_MACRO_CNTL_RESERVED237_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED238                                                              0x2cf4
#define mmDCRX_PHY_MACRO_CNTL_RESERVED238_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED239                                                              0x2cf5
#define mmDCRX_PHY_MACRO_CNTL_RESERVED239_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED240                                                              0x2cf6
#define mmDCRX_PHY_MACRO_CNTL_RESERVED240_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED241                                                              0x2cf7
#define mmDCRX_PHY_MACRO_CNTL_RESERVED241_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED242                                                              0x2cf8
#define mmDCRX_PHY_MACRO_CNTL_RESERVED242_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED243                                                              0x2cf9
#define mmDCRX_PHY_MACRO_CNTL_RESERVED243_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED244                                                              0x2cfa
#define mmDCRX_PHY_MACRO_CNTL_RESERVED244_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED245                                                              0x2cfb
#define mmDCRX_PHY_MACRO_CNTL_RESERVED245_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED246                                                              0x2cfc
#define mmDCRX_PHY_MACRO_CNTL_RESERVED246_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED247                                                              0x2cfd
#define mmDCRX_PHY_MACRO_CNTL_RESERVED247_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED248                                                              0x2cfe
#define mmDCRX_PHY_MACRO_CNTL_RESERVED248_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED249                                                              0x2cff
#define mmDCRX_PHY_MACRO_CNTL_RESERVED249_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED250                                                              0x2d00
#define mmDCRX_PHY_MACRO_CNTL_RESERVED250_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED251                                                              0x2d01
#define mmDCRX_PHY_MACRO_CNTL_RESERVED251_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED252                                                              0x2d02
#define mmDCRX_PHY_MACRO_CNTL_RESERVED252_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED253                                                              0x2d03
#define mmDCRX_PHY_MACRO_CNTL_RESERVED253_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED254                                                              0x2d04
#define mmDCRX_PHY_MACRO_CNTL_RESERVED254_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED255                                                              0x2d05
#define mmDCRX_PHY_MACRO_CNTL_RESERVED255_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED256                                                              0x2d06
#define mmDCRX_PHY_MACRO_CNTL_RESERVED256_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED257                                                              0x2d07
#define mmDCRX_PHY_MACRO_CNTL_RESERVED257_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED258                                                              0x2d08
#define mmDCRX_PHY_MACRO_CNTL_RESERVED258_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED259                                                              0x2d09
#define mmDCRX_PHY_MACRO_CNTL_RESERVED259_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED260                                                              0x2d0a
#define mmDCRX_PHY_MACRO_CNTL_RESERVED260_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED261                                                              0x2d0b
#define mmDCRX_PHY_MACRO_CNTL_RESERVED261_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED262                                                              0x2d0c
#define mmDCRX_PHY_MACRO_CNTL_RESERVED262_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED263                                                              0x2d0d
#define mmDCRX_PHY_MACRO_CNTL_RESERVED263_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED264                                                              0x2d0e
#define mmDCRX_PHY_MACRO_CNTL_RESERVED264_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED265                                                              0x2d0f
#define mmDCRX_PHY_MACRO_CNTL_RESERVED265_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED266                                                              0x2d10
#define mmDCRX_PHY_MACRO_CNTL_RESERVED266_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED267                                                              0x2d11
#define mmDCRX_PHY_MACRO_CNTL_RESERVED267_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED268                                                              0x2d12
#define mmDCRX_PHY_MACRO_CNTL_RESERVED268_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED269                                                              0x2d13
#define mmDCRX_PHY_MACRO_CNTL_RESERVED269_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED270                                                              0x2d14
#define mmDCRX_PHY_MACRO_CNTL_RESERVED270_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED271                                                              0x2d15
#define mmDCRX_PHY_MACRO_CNTL_RESERVED271_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED272                                                              0x2d16
#define mmDCRX_PHY_MACRO_CNTL_RESERVED272_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED273                                                              0x2d17
#define mmDCRX_PHY_MACRO_CNTL_RESERVED273_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED274                                                              0x2d18
#define mmDCRX_PHY_MACRO_CNTL_RESERVED274_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED275                                                              0x2d19
#define mmDCRX_PHY_MACRO_CNTL_RESERVED275_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED276                                                              0x2d1a
#define mmDCRX_PHY_MACRO_CNTL_RESERVED276_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED277                                                              0x2d1b
#define mmDCRX_PHY_MACRO_CNTL_RESERVED277_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED278                                                              0x2d1c
#define mmDCRX_PHY_MACRO_CNTL_RESERVED278_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED279                                                              0x2d1d
#define mmDCRX_PHY_MACRO_CNTL_RESERVED279_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED280                                                              0x2d1e
#define mmDCRX_PHY_MACRO_CNTL_RESERVED280_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED281                                                              0x2d1f
#define mmDCRX_PHY_MACRO_CNTL_RESERVED281_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED282                                                              0x2d20
#define mmDCRX_PHY_MACRO_CNTL_RESERVED282_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED283                                                              0x2d21
#define mmDCRX_PHY_MACRO_CNTL_RESERVED283_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED284                                                              0x2d22
#define mmDCRX_PHY_MACRO_CNTL_RESERVED284_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED285                                                              0x2d23
#define mmDCRX_PHY_MACRO_CNTL_RESERVED285_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED286                                                              0x2d24
#define mmDCRX_PHY_MACRO_CNTL_RESERVED286_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED287                                                              0x2d25
#define mmDCRX_PHY_MACRO_CNTL_RESERVED287_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED288                                                              0x2d26
#define mmDCRX_PHY_MACRO_CNTL_RESERVED288_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED289                                                              0x2d27
#define mmDCRX_PHY_MACRO_CNTL_RESERVED289_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED290                                                              0x2d28
#define mmDCRX_PHY_MACRO_CNTL_RESERVED290_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED291                                                              0x2d29
#define mmDCRX_PHY_MACRO_CNTL_RESERVED291_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED292                                                              0x2d2a
#define mmDCRX_PHY_MACRO_CNTL_RESERVED292_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED293                                                              0x2d2b
#define mmDCRX_PHY_MACRO_CNTL_RESERVED293_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED294                                                              0x2d2c
#define mmDCRX_PHY_MACRO_CNTL_RESERVED294_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED295                                                              0x2d2d
#define mmDCRX_PHY_MACRO_CNTL_RESERVED295_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED296                                                              0x2d2e
#define mmDCRX_PHY_MACRO_CNTL_RESERVED296_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED297                                                              0x2d2f
#define mmDCRX_PHY_MACRO_CNTL_RESERVED297_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED298                                                              0x2d30
#define mmDCRX_PHY_MACRO_CNTL_RESERVED298_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED299                                                              0x2d31
#define mmDCRX_PHY_MACRO_CNTL_RESERVED299_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED300                                                              0x2d32
#define mmDCRX_PHY_MACRO_CNTL_RESERVED300_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED301                                                              0x2d33
#define mmDCRX_PHY_MACRO_CNTL_RESERVED301_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED302                                                              0x2d34
#define mmDCRX_PHY_MACRO_CNTL_RESERVED302_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED303                                                              0x2d35
#define mmDCRX_PHY_MACRO_CNTL_RESERVED303_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED304                                                              0x2d36
#define mmDCRX_PHY_MACRO_CNTL_RESERVED304_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED305                                                              0x2d37
#define mmDCRX_PHY_MACRO_CNTL_RESERVED305_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED306                                                              0x2d38
#define mmDCRX_PHY_MACRO_CNTL_RESERVED306_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED307                                                              0x2d39
#define mmDCRX_PHY_MACRO_CNTL_RESERVED307_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED308                                                              0x2d3a
#define mmDCRX_PHY_MACRO_CNTL_RESERVED308_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED309                                                              0x2d3b
#define mmDCRX_PHY_MACRO_CNTL_RESERVED309_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED310                                                              0x2d3c
#define mmDCRX_PHY_MACRO_CNTL_RESERVED310_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED311                                                              0x2d3d
#define mmDCRX_PHY_MACRO_CNTL_RESERVED311_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED312                                                              0x2d3e
#define mmDCRX_PHY_MACRO_CNTL_RESERVED312_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED313                                                              0x2d3f
#define mmDCRX_PHY_MACRO_CNTL_RESERVED313_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED314                                                              0x2d40
#define mmDCRX_PHY_MACRO_CNTL_RESERVED314_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED315                                                              0x2d41
#define mmDCRX_PHY_MACRO_CNTL_RESERVED315_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED316                                                              0x2d42
#define mmDCRX_PHY_MACRO_CNTL_RESERVED316_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED317                                                              0x2d43
#define mmDCRX_PHY_MACRO_CNTL_RESERVED317_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED318                                                              0x2d44
#define mmDCRX_PHY_MACRO_CNTL_RESERVED318_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED319                                                              0x2d45
#define mmDCRX_PHY_MACRO_CNTL_RESERVED319_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED320                                                              0x2d46
#define mmDCRX_PHY_MACRO_CNTL_RESERVED320_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED321                                                              0x2d47
#define mmDCRX_PHY_MACRO_CNTL_RESERVED321_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED322                                                              0x2d48
#define mmDCRX_PHY_MACRO_CNTL_RESERVED322_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED323                                                              0x2d49
#define mmDCRX_PHY_MACRO_CNTL_RESERVED323_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED324                                                              0x2d4a
#define mmDCRX_PHY_MACRO_CNTL_RESERVED324_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED325                                                              0x2d4b
#define mmDCRX_PHY_MACRO_CNTL_RESERVED325_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED326                                                              0x2d4c
#define mmDCRX_PHY_MACRO_CNTL_RESERVED326_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED327                                                              0x2d4d
#define mmDCRX_PHY_MACRO_CNTL_RESERVED327_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED328                                                              0x2d4e
#define mmDCRX_PHY_MACRO_CNTL_RESERVED328_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED329                                                              0x2d4f
#define mmDCRX_PHY_MACRO_CNTL_RESERVED329_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED330                                                              0x2d50
#define mmDCRX_PHY_MACRO_CNTL_RESERVED330_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED331                                                              0x2d51
#define mmDCRX_PHY_MACRO_CNTL_RESERVED331_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED332                                                              0x2d52
#define mmDCRX_PHY_MACRO_CNTL_RESERVED332_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED333                                                              0x2d53
#define mmDCRX_PHY_MACRO_CNTL_RESERVED333_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED334                                                              0x2d54
#define mmDCRX_PHY_MACRO_CNTL_RESERVED334_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED335                                                              0x2d55
#define mmDCRX_PHY_MACRO_CNTL_RESERVED335_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED336                                                              0x2d56
#define mmDCRX_PHY_MACRO_CNTL_RESERVED336_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED337                                                              0x2d57
#define mmDCRX_PHY_MACRO_CNTL_RESERVED337_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED338                                                              0x2d58
#define mmDCRX_PHY_MACRO_CNTL_RESERVED338_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED339                                                              0x2d59
#define mmDCRX_PHY_MACRO_CNTL_RESERVED339_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED340                                                              0x2d5a
#define mmDCRX_PHY_MACRO_CNTL_RESERVED340_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED341                                                              0x2d5b
#define mmDCRX_PHY_MACRO_CNTL_RESERVED341_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED342                                                              0x2d5c
#define mmDCRX_PHY_MACRO_CNTL_RESERVED342_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED343                                                              0x2d5d
#define mmDCRX_PHY_MACRO_CNTL_RESERVED343_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED344                                                              0x2d5e
#define mmDCRX_PHY_MACRO_CNTL_RESERVED344_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED345                                                              0x2d5f
#define mmDCRX_PHY_MACRO_CNTL_RESERVED345_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED346                                                              0x2d60
#define mmDCRX_PHY_MACRO_CNTL_RESERVED346_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED347                                                              0x2d61
#define mmDCRX_PHY_MACRO_CNTL_RESERVED347_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED348                                                              0x2d62
#define mmDCRX_PHY_MACRO_CNTL_RESERVED348_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED349                                                              0x2d63
#define mmDCRX_PHY_MACRO_CNTL_RESERVED349_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED350                                                              0x2d64
#define mmDCRX_PHY_MACRO_CNTL_RESERVED350_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED351                                                              0x2d65
#define mmDCRX_PHY_MACRO_CNTL_RESERVED351_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED352                                                              0x2d66
#define mmDCRX_PHY_MACRO_CNTL_RESERVED352_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED353                                                              0x2d67
#define mmDCRX_PHY_MACRO_CNTL_RESERVED353_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED354                                                              0x2d68
#define mmDCRX_PHY_MACRO_CNTL_RESERVED354_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED355                                                              0x2d69
#define mmDCRX_PHY_MACRO_CNTL_RESERVED355_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED356                                                              0x2d6a
#define mmDCRX_PHY_MACRO_CNTL_RESERVED356_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED357                                                              0x2d6b
#define mmDCRX_PHY_MACRO_CNTL_RESERVED357_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED358                                                              0x2d6c
#define mmDCRX_PHY_MACRO_CNTL_RESERVED358_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED359                                                              0x2d6d
#define mmDCRX_PHY_MACRO_CNTL_RESERVED359_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED360                                                              0x2d6e
#define mmDCRX_PHY_MACRO_CNTL_RESERVED360_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED361                                                              0x2d6f
#define mmDCRX_PHY_MACRO_CNTL_RESERVED361_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED362                                                              0x2d70
#define mmDCRX_PHY_MACRO_CNTL_RESERVED362_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED363                                                              0x2d71
#define mmDCRX_PHY_MACRO_CNTL_RESERVED363_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED364                                                              0x2d72
#define mmDCRX_PHY_MACRO_CNTL_RESERVED364_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED365                                                              0x2d73
#define mmDCRX_PHY_MACRO_CNTL_RESERVED365_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED366                                                              0x2d74
#define mmDCRX_PHY_MACRO_CNTL_RESERVED366_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED367                                                              0x2d75
#define mmDCRX_PHY_MACRO_CNTL_RESERVED367_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED368                                                              0x2d76
#define mmDCRX_PHY_MACRO_CNTL_RESERVED368_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED369                                                              0x2d77
#define mmDCRX_PHY_MACRO_CNTL_RESERVED369_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED370                                                              0x2d78
#define mmDCRX_PHY_MACRO_CNTL_RESERVED370_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED371                                                              0x2d79
#define mmDCRX_PHY_MACRO_CNTL_RESERVED371_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED372                                                              0x2d7a
#define mmDCRX_PHY_MACRO_CNTL_RESERVED372_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED373                                                              0x2d7b
#define mmDCRX_PHY_MACRO_CNTL_RESERVED373_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED374                                                              0x2d7c
#define mmDCRX_PHY_MACRO_CNTL_RESERVED374_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED375                                                              0x2d7d
#define mmDCRX_PHY_MACRO_CNTL_RESERVED375_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED376                                                              0x2d7e
#define mmDCRX_PHY_MACRO_CNTL_RESERVED376_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED377                                                              0x2d7f
#define mmDCRX_PHY_MACRO_CNTL_RESERVED377_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED378                                                              0x2d80
#define mmDCRX_PHY_MACRO_CNTL_RESERVED378_BASE_IDX                                                     2
#define mmDCRX_PHY_MACRO_CNTL_RESERVED379                                                              0x2d81
#define mmDCRX_PHY_MACRO_CNTL_RESERVED379_BASE_IDX                                                     2
#define mmI2S0_CNTL                                                                                    0x2d82
#define mmI2S0_CNTL_BASE_IDX                                                                           2
#define mmSPDIF0_CNTL                                                                                  0x2d83
#define mmSPDIF0_CNTL_BASE_IDX                                                                         2
#define mmI2S1_CNTL                                                                                    0x2d84
#define mmI2S1_CNTL_BASE_IDX                                                                           2
#define mmSPDIF1_CNTL                                                                                  0x2d85
#define mmSPDIF1_CNTL_BASE_IDX                                                                         2
#define mmI2S0_STATUS                                                                                  0x2d86
#define mmI2S0_STATUS_BASE_IDX                                                                         2
#define mmI2S1_STATUS                                                                                  0x2d87
#define mmI2S1_STATUS_BASE_IDX                                                                         2
#define mmI2S0_CRC_TEST_CNTL                                                                           0x2d8a
#define mmI2S0_CRC_TEST_CNTL_BASE_IDX                                                                  2
#define mmI2S0_CRC_TEST_DATA_01                                                                        0x2d8b
#define mmI2S0_CRC_TEST_DATA_01_BASE_IDX                                                               2
#define mmI2S0_CRC_TEST_DATA_23                                                                        0x2d8c
#define mmI2S0_CRC_TEST_DATA_23_BASE_IDX                                                               2
#define mmI2S1_CRC_TEST_CNTL                                                                           0x2d8d
#define mmI2S1_CRC_TEST_CNTL_BASE_IDX                                                                  2
#define mmI2S1_CRC_TEST_DATA_0                                                                         0x2d8e
#define mmI2S1_CRC_TEST_DATA_0_BASE_IDX                                                                2
#define mmSPDIF0_CRC_TEST_CNTL                                                                         0x2d8f
#define mmSPDIF0_CRC_TEST_CNTL_BASE_IDX                                                                2
#define mmSPDIF0_CRC_TEST_DATA_0                                                                       0x2d90
#define mmSPDIF0_CRC_TEST_DATA_0_BASE_IDX                                                              2
#define mmSPDIF1_CRC_TEST_CNTL                                                                         0x2d91
#define mmSPDIF1_CRC_TEST_CNTL_BASE_IDX                                                                2
#define mmSPDIF1_CRC_TEST_DATA                                                                         0x2d92
#define mmSPDIF1_CRC_TEST_DATA_BASE_IDX                                                                2
#define mmCRC_I2S_CONT_REPEAT_NUM                                                                      0x2d93
#define mmCRC_I2S_CONT_REPEAT_NUM_BASE_IDX                                                             2
#define mmCRC_SPDIF_CONT_REPEAT_NUM                                                                    0x2d94
#define mmCRC_SPDIF_CONT_REPEAT_NUM_BASE_IDX                                                           2
#define mmZCAL_MACRO_CNTL_RESERVED0                                                                    0x2d96
#define mmZCAL_MACRO_CNTL_RESERVED0_BASE_IDX                                                           2
#define mmZCAL_MACRO_CNTL_RESERVED1                                                                    0x2d97
#define mmZCAL_MACRO_CNTL_RESERVED1_BASE_IDX                                                           2
#define mmZCAL_MACRO_CNTL_RESERVED2                                                                    0x2d98
#define mmZCAL_MACRO_CNTL_RESERVED2_BASE_IDX                                                           2
#define mmZCAL_MACRO_CNTL_RESERVED3                                                                    0x2d99
#define mmZCAL_MACRO_CNTL_RESERVED3_BASE_IDX                                                           2
#define mmZCAL_MACRO_CNTL_RESERVED4                                                                    0x2d9a
#define mmZCAL_MACRO_CNTL_RESERVED4_BASE_IDX                                                           2


// addressBlock: dce_dc_azf0stream0_dispdec
// base address: 0x0
#define mmAZF0STREAM0_AZALIA_STREAM_INDEX                                                              0x0458
#define mmAZF0STREAM0_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM0_AZALIA_STREAM_DATA                                                               0x0459
#define mmAZF0STREAM0_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_azf0stream1_dispdec
// base address: 0x8
#define mmAZF0STREAM1_AZALIA_STREAM_INDEX                                                              0x045a
#define mmAZF0STREAM1_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM1_AZALIA_STREAM_DATA                                                               0x045b
#define mmAZF0STREAM1_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_azf0stream2_dispdec
// base address: 0x10
#define mmAZF0STREAM2_AZALIA_STREAM_INDEX                                                              0x045c
#define mmAZF0STREAM2_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM2_AZALIA_STREAM_DATA                                                               0x045d
#define mmAZF0STREAM2_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_azf0stream3_dispdec
// base address: 0x18
#define mmAZF0STREAM3_AZALIA_STREAM_INDEX                                                              0x045e
#define mmAZF0STREAM3_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM3_AZALIA_STREAM_DATA                                                               0x045f
#define mmAZF0STREAM3_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_azf0stream4_dispdec
// base address: 0x20
#define mmAZF0STREAM4_AZALIA_STREAM_INDEX                                                              0x0460
#define mmAZF0STREAM4_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM4_AZALIA_STREAM_DATA                                                               0x0461
#define mmAZF0STREAM4_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_azf0stream5_dispdec
// base address: 0x28
#define mmAZF0STREAM5_AZALIA_STREAM_INDEX                                                              0x0462
#define mmAZF0STREAM5_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM5_AZALIA_STREAM_DATA                                                               0x0463
#define mmAZF0STREAM5_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_azf0stream6_dispdec
// base address: 0x30
#define mmAZF0STREAM6_AZALIA_STREAM_INDEX                                                              0x0464
#define mmAZF0STREAM6_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM6_AZALIA_STREAM_DATA                                                               0x0465
#define mmAZF0STREAM6_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_azf0stream7_dispdec
// base address: 0x38
#define mmAZF0STREAM7_AZALIA_STREAM_INDEX                                                              0x0466
#define mmAZF0STREAM7_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM7_AZALIA_STREAM_DATA                                                               0x0467
#define mmAZF0STREAM7_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_azf0endpoint0_dispdec
// base address: 0x0
#define mmAZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x0480
#define mmAZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x0481
#define mmAZF0ENDPOINT0_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_azf0endpoint1_dispdec
// base address: 0x18
#define mmAZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x0486
#define mmAZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x0487
#define mmAZF0ENDPOINT1_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_azf0endpoint2_dispdec
// base address: 0x30
#define mmAZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x048c
#define mmAZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x048d
#define mmAZF0ENDPOINT2_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_azf0endpoint3_dispdec
// base address: 0x48
#define mmAZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x0492
#define mmAZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x0493
#define mmAZF0ENDPOINT3_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_azf0endpoint4_dispdec
// base address: 0x60
#define mmAZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x0498
#define mmAZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x0499
#define mmAZF0ENDPOINT4_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_azf0endpoint5_dispdec
// base address: 0x78
#define mmAZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x049e
#define mmAZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x049f
#define mmAZF0ENDPOINT5_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_azf0endpoint6_dispdec
// base address: 0x90
#define mmAZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x04a4
#define mmAZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x04a5
#define mmAZF0ENDPOINT6_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_azf0endpoint7_dispdec
// base address: 0xa8
#define mmAZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_INDEX                                                 0x04aa
#define mmAZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_INDEX_BASE_IDX                                        2
#define mmAZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_DATA                                                  0x04ab
#define mmAZF0ENDPOINT7_AZALIA_F0_CODEC_ENDPOINT_DATA_BASE_IDX                                         2


// addressBlock: dce_dc_azf0stream8_dispdec
// base address: 0x320
#define mmAZF0STREAM8_AZALIA_STREAM_INDEX                                                              0x0520
#define mmAZF0STREAM8_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM8_AZALIA_STREAM_DATA                                                               0x0521
#define mmAZF0STREAM8_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_azf0stream9_dispdec
// base address: 0x328
#define mmAZF0STREAM9_AZALIA_STREAM_INDEX                                                              0x0522
#define mmAZF0STREAM9_AZALIA_STREAM_INDEX_BASE_IDX                                                     2
#define mmAZF0STREAM9_AZALIA_STREAM_DATA                                                               0x0523
#define mmAZF0STREAM9_AZALIA_STREAM_DATA_BASE_IDX                                                      2


// addressBlock: dce_dc_azf0stream10_dispdec
// base address: 0x330
#define mmAZF0STREAM10_AZALIA_STREAM_INDEX                                                             0x0524
#define mmAZF0STREAM10_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define mmAZF0STREAM10_AZALIA_STREAM_DATA                                                              0x0525
#define mmAZF0STREAM10_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_azf0stream11_dispdec
// base address: 0x338
#define mmAZF0STREAM11_AZALIA_STREAM_INDEX                                                             0x0526
#define mmAZF0STREAM11_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define mmAZF0STREAM11_AZALIA_STREAM_DATA                                                              0x0527
#define mmAZF0STREAM11_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_azf0stream12_dispdec
// base address: 0x340
#define mmAZF0STREAM12_AZALIA_STREAM_INDEX                                                             0x0528
#define mmAZF0STREAM12_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define mmAZF0STREAM12_AZALIA_STREAM_DATA                                                              0x0529
#define mmAZF0STREAM12_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_azf0stream13_dispdec
// base address: 0x348
#define mmAZF0STREAM13_AZALIA_STREAM_INDEX                                                             0x052a
#define mmAZF0STREAM13_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define mmAZF0STREAM13_AZALIA_STREAM_DATA                                                              0x052b
#define mmAZF0STREAM13_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_azf0stream14_dispdec
// base address: 0x350
#define mmAZF0STREAM14_AZALIA_STREAM_INDEX                                                             0x052c
#define mmAZF0STREAM14_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define mmAZF0STREAM14_AZALIA_STREAM_DATA                                                              0x052d
#define mmAZF0STREAM14_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_azf0stream15_dispdec
// base address: 0x358
#define mmAZF0STREAM15_AZALIA_STREAM_INDEX                                                             0x052e
#define mmAZF0STREAM15_AZALIA_STREAM_INDEX_BASE_IDX                                                    2
#define mmAZF0STREAM15_AZALIA_STREAM_DATA                                                              0x052f
#define mmAZF0STREAM15_AZALIA_STREAM_DATA_BASE_IDX                                                     2


// addressBlock: dce_dc_azf0inputendpoint0_dispdec
// base address: 0x0
#define mmAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x0534
#define mmAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x0535
#define mmAZF0INPUTENDPOINT0_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_azf0inputendpoint1_dispdec
// base address: 0x10
#define mmAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x0538
#define mmAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x0539
#define mmAZF0INPUTENDPOINT1_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_azf0inputendpoint2_dispdec
// base address: 0x20
#define mmAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x053c
#define mmAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x053d
#define mmAZF0INPUTENDPOINT2_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_azf0inputendpoint3_dispdec
// base address: 0x30
#define mmAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x0540
#define mmAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x0541
#define mmAZF0INPUTENDPOINT3_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_azf0inputendpoint4_dispdec
// base address: 0x40
#define mmAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x0544
#define mmAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x0545
#define mmAZF0INPUTENDPOINT4_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_azf0inputendpoint5_dispdec
// base address: 0x50
#define mmAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x0548
#define mmAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x0549
#define mmAZF0INPUTENDPOINT5_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_azf0inputendpoint6_dispdec
// base address: 0x60
#define mmAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x054c
#define mmAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x054d
#define mmAZF0INPUTENDPOINT6_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_azf0inputendpoint7_dispdec
// base address: 0x70
#define mmAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX                                      0x0550
#define mmAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_INDEX_BASE_IDX                             2
#define mmAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA                                       0x0551
#define mmAZF0INPUTENDPOINT7_AZALIA_F0_CODEC_INPUT_ENDPOINT_DATA_BASE_IDX                              2


// addressBlock: dce_dc_dcp0_dispdec
// base address: 0x0
#define mmDCP0_GRPH_ENABLE                                                                             0x055a
#define mmDCP0_GRPH_ENABLE_BASE_IDX                                                                    2
#define mmDCP0_GRPH_CONTROL                                                                            0x055b
#define mmDCP0_GRPH_CONTROL_BASE_IDX                                                                   2
#define mmDCP0_GRPH_LUT_10BIT_BYPASS                                                                   0x055c
#define mmDCP0_GRPH_LUT_10BIT_BYPASS_BASE_IDX                                                          2
#define mmDCP0_GRPH_SWAP_CNTL                                                                          0x055d
#define mmDCP0_GRPH_SWAP_CNTL_BASE_IDX                                                                 2
#define mmDCP0_GRPH_PRIMARY_SURFACE_ADDRESS                                                            0x055e
#define mmDCP0_GRPH_PRIMARY_SURFACE_ADDRESS_BASE_IDX                                                   2
#define mmDCP0_GRPH_SECONDARY_SURFACE_ADDRESS                                                          0x055f
#define mmDCP0_GRPH_SECONDARY_SURFACE_ADDRESS_BASE_IDX                                                 2
#define mmDCP0_GRPH_PITCH                                                                              0x0560
#define mmDCP0_GRPH_PITCH_BASE_IDX                                                                     2
#define mmDCP0_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH                                                       0x0561
#define mmDCP0_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                              2
#define mmDCP0_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH                                                     0x0562
#define mmDCP0_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                            2
#define mmDCP0_GRPH_SURFACE_OFFSET_X                                                                   0x0563
#define mmDCP0_GRPH_SURFACE_OFFSET_X_BASE_IDX                                                          2
#define mmDCP0_GRPH_SURFACE_OFFSET_Y                                                                   0x0564
#define mmDCP0_GRPH_SURFACE_OFFSET_Y_BASE_IDX                                                          2
#define mmDCP0_GRPH_X_START                                                                            0x0565
#define mmDCP0_GRPH_X_START_BASE_IDX                                                                   2
#define mmDCP0_GRPH_Y_START                                                                            0x0566
#define mmDCP0_GRPH_Y_START_BASE_IDX                                                                   2
#define mmDCP0_GRPH_X_END                                                                              0x0567
#define mmDCP0_GRPH_X_END_BASE_IDX                                                                     2
#define mmDCP0_GRPH_Y_END                                                                              0x0568
#define mmDCP0_GRPH_Y_END_BASE_IDX                                                                     2
#define mmDCP0_INPUT_GAMMA_CONTROL                                                                     0x0569
#define mmDCP0_INPUT_GAMMA_CONTROL_BASE_IDX                                                            2
#define mmDCP0_GRPH_UPDATE                                                                             0x056a
#define mmDCP0_GRPH_UPDATE_BASE_IDX                                                                    2
#define mmDCP0_GRPH_FLIP_CONTROL                                                                       0x056b
#define mmDCP0_GRPH_FLIP_CONTROL_BASE_IDX                                                              2
#define mmDCP0_GRPH_SURFACE_ADDRESS_INUSE                                                              0x056c
#define mmDCP0_GRPH_SURFACE_ADDRESS_INUSE_BASE_IDX                                                     2
#define mmDCP0_GRPH_DFQ_CONTROL                                                                        0x056d
#define mmDCP0_GRPH_DFQ_CONTROL_BASE_IDX                                                               2
#define mmDCP0_GRPH_DFQ_STATUS                                                                         0x056e
#define mmDCP0_GRPH_DFQ_STATUS_BASE_IDX                                                                2
#define mmDCP0_GRPH_INTERRUPT_STATUS                                                                   0x056f
#define mmDCP0_GRPH_INTERRUPT_STATUS_BASE_IDX                                                          2
#define mmDCP0_GRPH_INTERRUPT_CONTROL                                                                  0x0570
#define mmDCP0_GRPH_INTERRUPT_CONTROL_BASE_IDX                                                         2
#define mmDCP0_GRPH_SURFACE_ADDRESS_HIGH_INUSE                                                         0x0571
#define mmDCP0_GRPH_SURFACE_ADDRESS_HIGH_INUSE_BASE_IDX                                                2
#define mmDCP0_GRPH_COMPRESS_SURFACE_ADDRESS                                                           0x0572
#define mmDCP0_GRPH_COMPRESS_SURFACE_ADDRESS_BASE_IDX                                                  2
#define mmDCP0_GRPH_COMPRESS_PITCH                                                                     0x0573
#define mmDCP0_GRPH_COMPRESS_PITCH_BASE_IDX                                                            2
#define mmDCP0_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH                                                      0x0574
#define mmDCP0_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH_BASE_IDX                                             2
#define mmDCP0_GRPH_PIPE_OUTSTANDING_REQUEST_LIMIT                                                     0x0575
#define mmDCP0_GRPH_PIPE_OUTSTANDING_REQUEST_LIMIT_BASE_IDX                                            2
#define mmDCP0_PRESCALE_GRPH_CONTROL                                                                   0x0576
#define mmDCP0_PRESCALE_GRPH_CONTROL_BASE_IDX                                                          2
#define mmDCP0_PRESCALE_VALUES_GRPH_R                                                                  0x0577
#define mmDCP0_PRESCALE_VALUES_GRPH_R_BASE_IDX                                                         2
#define mmDCP0_PRESCALE_VALUES_GRPH_G                                                                  0x0578
#define mmDCP0_PRESCALE_VALUES_GRPH_G_BASE_IDX                                                         2
#define mmDCP0_PRESCALE_VALUES_GRPH_B                                                                  0x0579
#define mmDCP0_PRESCALE_VALUES_GRPH_B_BASE_IDX                                                         2
#define mmDCP0_INPUT_CSC_CONTROL                                                                       0x057a
#define mmDCP0_INPUT_CSC_CONTROL_BASE_IDX                                                              2
#define mmDCP0_INPUT_CSC_C11_C12                                                                       0x057b
#define mmDCP0_INPUT_CSC_C11_C12_BASE_IDX                                                              2
#define mmDCP0_INPUT_CSC_C13_C14                                                                       0x057c
#define mmDCP0_INPUT_CSC_C13_C14_BASE_IDX                                                              2
#define mmDCP0_INPUT_CSC_C21_C22                                                                       0x057d
#define mmDCP0_INPUT_CSC_C21_C22_BASE_IDX                                                              2
#define mmDCP0_INPUT_CSC_C23_C24                                                                       0x057e
#define mmDCP0_INPUT_CSC_C23_C24_BASE_IDX                                                              2
#define mmDCP0_INPUT_CSC_C31_C32                                                                       0x057f
#define mmDCP0_INPUT_CSC_C31_C32_BASE_IDX                                                              2
#define mmDCP0_INPUT_CSC_C33_C34                                                                       0x0580
#define mmDCP0_INPUT_CSC_C33_C34_BASE_IDX                                                              2
#define mmDCP0_OUTPUT_CSC_CONTROL                                                                      0x0581
#define mmDCP0_OUTPUT_CSC_CONTROL_BASE_IDX                                                             2
#define mmDCP0_OUTPUT_CSC_C11_C12                                                                      0x0582
#define mmDCP0_OUTPUT_CSC_C11_C12_BASE_IDX                                                             2
#define mmDCP0_OUTPUT_CSC_C13_C14                                                                      0x0583
#define mmDCP0_OUTPUT_CSC_C13_C14_BASE_IDX                                                             2
#define mmDCP0_OUTPUT_CSC_C21_C22                                                                      0x0584
#define mmDCP0_OUTPUT_CSC_C21_C22_BASE_IDX                                                             2
#define mmDCP0_OUTPUT_CSC_C23_C24                                                                      0x0585
#define mmDCP0_OUTPUT_CSC_C23_C24_BASE_IDX                                                             2
#define mmDCP0_OUTPUT_CSC_C31_C32                                                                      0x0586
#define mmDCP0_OUTPUT_CSC_C31_C32_BASE_IDX                                                             2
#define mmDCP0_OUTPUT_CSC_C33_C34                                                                      0x0587
#define mmDCP0_OUTPUT_CSC_C33_C34_BASE_IDX                                                             2
#define mmDCP0_COMM_MATRIXA_TRANS_C11_C12                                                              0x0588
#define mmDCP0_COMM_MATRIXA_TRANS_C11_C12_BASE_IDX                                                     2
#define mmDCP0_COMM_MATRIXA_TRANS_C13_C14                                                              0x0589
#define mmDCP0_COMM_MATRIXA_TRANS_C13_C14_BASE_IDX                                                     2
#define mmDCP0_COMM_MATRIXA_TRANS_C21_C22                                                              0x058a
#define mmDCP0_COMM_MATRIXA_TRANS_C21_C22_BASE_IDX                                                     2
#define mmDCP0_COMM_MATRIXA_TRANS_C23_C24                                                              0x058b
#define mmDCP0_COMM_MATRIXA_TRANS_C23_C24_BASE_IDX                                                     2
#define mmDCP0_COMM_MATRIXA_TRANS_C31_C32                                                              0x058c
#define mmDCP0_COMM_MATRIXA_TRANS_C31_C32_BASE_IDX                                                     2
#define mmDCP0_COMM_MATRIXA_TRANS_C33_C34                                                              0x058d
#define mmDCP0_COMM_MATRIXA_TRANS_C33_C34_BASE_IDX                                                     2
#define mmDCP0_COMM_MATRIXB_TRANS_C11_C12                                                              0x058e
#define mmDCP0_COMM_MATRIXB_TRANS_C11_C12_BASE_IDX                                                     2
#define mmDCP0_COMM_MATRIXB_TRANS_C13_C14                                                              0x058f
#define mmDCP0_COMM_MATRIXB_TRANS_C13_C14_BASE_IDX                                                     2
#define mmDCP0_COMM_MATRIXB_TRANS_C21_C22                                                              0x0590
#define mmDCP0_COMM_MATRIXB_TRANS_C21_C22_BASE_IDX                                                     2
#define mmDCP0_COMM_MATRIXB_TRANS_C23_C24                                                              0x0591
#define mmDCP0_COMM_MATRIXB_TRANS_C23_C24_BASE_IDX                                                     2
#define mmDCP0_COMM_MATRIXB_TRANS_C31_C32                                                              0x0592
#define mmDCP0_COMM_MATRIXB_TRANS_C31_C32_BASE_IDX                                                     2
#define mmDCP0_COMM_MATRIXB_TRANS_C33_C34                                                              0x0593
#define mmDCP0_COMM_MATRIXB_TRANS_C33_C34_BASE_IDX                                                     2
#define mmDCP0_DENORM_CONTROL                                                                          0x0594
#define mmDCP0_DENORM_CONTROL_BASE_IDX                                                                 2
#define mmDCP0_OUT_ROUND_CONTROL                                                                       0x0595
#define mmDCP0_OUT_ROUND_CONTROL_BASE_IDX                                                              2
#define mmDCP0_OUT_CLAMP_CONTROL_R_CR                                                                  0x0596
#define mmDCP0_OUT_CLAMP_CONTROL_R_CR_BASE_IDX                                                         2
#define mmDCP0_OUT_CLAMP_CONTROL_G_Y                                                                   0x0597
#define mmDCP0_OUT_CLAMP_CONTROL_G_Y_BASE_IDX                                                          2
#define mmDCP0_OUT_CLAMP_CONTROL_B_CB                                                                  0x0598
#define mmDCP0_OUT_CLAMP_CONTROL_B_CB_BASE_IDX                                                         2
#define mmDCP0_KEY_CONTROL                                                                             0x0599
#define mmDCP0_KEY_CONTROL_BASE_IDX                                                                    2
#define mmDCP0_KEY_RANGE_ALPHA                                                                         0x059a
#define mmDCP0_KEY_RANGE_ALPHA_BASE_IDX                                                                2
#define mmDCP0_KEY_RANGE_RED                                                                           0x059b
#define mmDCP0_KEY_RANGE_RED_BASE_IDX                                                                  2
#define mmDCP0_KEY_RANGE_GREEN                                                                         0x059c
#define mmDCP0_KEY_RANGE_GREEN_BASE_IDX                                                                2
#define mmDCP0_KEY_RANGE_BLUE                                                                          0x059d
#define mmDCP0_KEY_RANGE_BLUE_BASE_IDX                                                                 2
#define mmDCP0_DEGAMMA_CONTROL                                                                         0x059e
#define mmDCP0_DEGAMMA_CONTROL_BASE_IDX                                                                2
#define mmDCP0_GAMUT_REMAP_CONTROL                                                                     0x059f
#define mmDCP0_GAMUT_REMAP_CONTROL_BASE_IDX                                                            2
#define mmDCP0_GAMUT_REMAP_C11_C12                                                                     0x05a0
#define mmDCP0_GAMUT_REMAP_C11_C12_BASE_IDX                                                            2
#define mmDCP0_GAMUT_REMAP_C13_C14                                                                     0x05a1
#define mmDCP0_GAMUT_REMAP_C13_C14_BASE_IDX                                                            2
#define mmDCP0_GAMUT_REMAP_C21_C22                                                                     0x05a2
#define mmDCP0_GAMUT_REMAP_C21_C22_BASE_IDX                                                            2
#define mmDCP0_GAMUT_REMAP_C23_C24                                                                     0x05a3
#define mmDCP0_GAMUT_REMAP_C23_C24_BASE_IDX                                                            2
#define mmDCP0_GAMUT_REMAP_C31_C32                                                                     0x05a4
#define mmDCP0_GAMUT_REMAP_C31_C32_BASE_IDX                                                            2
#define mmDCP0_GAMUT_REMAP_C33_C34                                                                     0x05a5
#define mmDCP0_GAMUT_REMAP_C33_C34_BASE_IDX                                                            2
#define mmDCP0_DCP_SPATIAL_DITHER_CNTL                                                                 0x05a6
#define mmDCP0_DCP_SPATIAL_DITHER_CNTL_BASE_IDX                                                        2
#define mmDCP0_DCP_RANDOM_SEEDS                                                                        0x05a7
#define mmDCP0_DCP_RANDOM_SEEDS_BASE_IDX                                                               2
#define mmDCP0_DCP_FP_CONVERTED_FIELD                                                                  0x05a8
#define mmDCP0_DCP_FP_CONVERTED_FIELD_BASE_IDX                                                         2
#define mmDCP0_CUR_CONTROL                                                                             0x05a9
#define mmDCP0_CUR_CONTROL_BASE_IDX                                                                    2
#define mmDCP0_CUR_SURFACE_ADDRESS                                                                     0x05aa
#define mmDCP0_CUR_SURFACE_ADDRESS_BASE_IDX                                                            2
#define mmDCP0_CUR_SIZE                                                                                0x05ab
#define mmDCP0_CUR_SIZE_BASE_IDX                                                                       2
#define mmDCP0_CUR_SURFACE_ADDRESS_HIGH                                                                0x05ac
#define mmDCP0_CUR_SURFACE_ADDRESS_HIGH_BASE_IDX                                                       2
#define mmDCP0_CUR_POSITION                                                                            0x05ad
#define mmDCP0_CUR_POSITION_BASE_IDX                                                                   2
#define mmDCP0_CUR_HOT_SPOT                                                                            0x05ae
#define mmDCP0_CUR_HOT_SPOT_BASE_IDX                                                                   2
#define mmDCP0_CUR_COLOR1                                                                              0x05af
#define mmDCP0_CUR_COLOR1_BASE_IDX                                                                     2
#define mmDCP0_CUR_COLOR2                                                                              0x05b0
#define mmDCP0_CUR_COLOR2_BASE_IDX                                                                     2
#define mmDCP0_CUR_UPDATE                                                                              0x05b1
#define mmDCP0_CUR_UPDATE_BASE_IDX                                                                     2
#define mmDCP0_CUR_REQUEST_FILTER_CNTL                                                                 0x05bb
#define mmDCP0_CUR_REQUEST_FILTER_CNTL_BASE_IDX                                                        2
#define mmDCP0_CUR_STEREO_CONTROL                                                                      0x05bc
#define mmDCP0_CUR_STEREO_CONTROL_BASE_IDX                                                             2
#define mmDCP0_DC_LUT_RW_MODE                                                                          0x05be
#define mmDCP0_DC_LUT_RW_MODE_BASE_IDX                                                                 2
#define mmDCP0_DC_LUT_RW_INDEX                                                                         0x05bf
#define mmDCP0_DC_LUT_RW_INDEX_BASE_IDX                                                                2
#define mmDCP0_DC_LUT_SEQ_COLOR                                                                        0x05c0
#define mmDCP0_DC_LUT_SEQ_COLOR_BASE_IDX                                                               2
#define mmDCP0_DC_LUT_PWL_DATA                                                                         0x05c1
#define mmDCP0_DC_LUT_PWL_DATA_BASE_IDX                                                                2
#define mmDCP0_DC_LUT_30_COLOR                                                                         0x05c2
#define mmDCP0_DC_LUT_30_COLOR_BASE_IDX                                                                2
#define mmDCP0_DC_LUT_VGA_ACCESS_ENABLE                                                                0x05c3
#define mmDCP0_DC_LUT_VGA_ACCESS_ENABLE_BASE_IDX                                                       2
#define mmDCP0_DC_LUT_WRITE_EN_MASK                                                                    0x05c4
#define mmDCP0_DC_LUT_WRITE_EN_MASK_BASE_IDX                                                           2
#define mmDCP0_DC_LUT_AUTOFILL                                                                         0x05c5
#define mmDCP0_DC_LUT_AUTOFILL_BASE_IDX                                                                2
#define mmDCP0_DC_LUT_CONTROL                                                                          0x05c6
#define mmDCP0_DC_LUT_CONTROL_BASE_IDX                                                                 2
#define mmDCP0_DC_LUT_BLACK_OFFSET_BLUE                                                                0x05c7
#define mmDCP0_DC_LUT_BLACK_OFFSET_BLUE_BASE_IDX                                                       2
#define mmDCP0_DC_LUT_BLACK_OFFSET_GREEN                                                               0x05c8
#define mmDCP0_DC_LUT_BLACK_OFFSET_GREEN_BASE_IDX                                                      2
#define mmDCP0_DC_LUT_BLACK_OFFSET_RED                                                                 0x05c9
#define mmDCP0_DC_LUT_BLACK_OFFSET_RED_BASE_IDX                                                        2
#define mmDCP0_DC_LUT_WHITE_OFFSET_BLUE                                                                0x05ca
#define mmDCP0_DC_LUT_WHITE_OFFSET_BLUE_BASE_IDX                                                       2
#define mmDCP0_DC_LUT_WHITE_OFFSET_GREEN                                                               0x05cb
#define mmDCP0_DC_LUT_WHITE_OFFSET_GREEN_BASE_IDX                                                      2
#define mmDCP0_DC_LUT_WHITE_OFFSET_RED                                                                 0x05cc
#define mmDCP0_DC_LUT_WHITE_OFFSET_RED_BASE_IDX                                                        2
#define mmDCP0_DCP_CRC_CONTROL                                                                         0x05cd
#define mmDCP0_DCP_CRC_CONTROL_BASE_IDX                                                                2
#define mmDCP0_DCP_CRC_MASK                                                                            0x05ce
#define mmDCP0_DCP_CRC_MASK_BASE_IDX                                                                   2
#define mmDCP0_DCP_CRC_CURRENT                                                                         0x05cf
#define mmDCP0_DCP_CRC_CURRENT_BASE_IDX                                                                2
#define mmDCP0_DVMM_PTE_CONTROL                                                                        0x05d0
#define mmDCP0_DVMM_PTE_CONTROL_BASE_IDX                                                               2
#define mmDCP0_DCP_CRC_LAST                                                                            0x05d1
#define mmDCP0_DCP_CRC_LAST_BASE_IDX                                                                   2
#define mmDCP0_DVMM_PTE_ARB_CONTROL                                                                    0x05d2
#define mmDCP0_DVMM_PTE_ARB_CONTROL_BASE_IDX                                                           2
#define mmDCP0_GRPH_FLIP_RATE_CNTL                                                                     0x05d4
#define mmDCP0_GRPH_FLIP_RATE_CNTL_BASE_IDX                                                            2
#define mmDCP0_DCP_GSL_CONTROL                                                                         0x05d5
#define mmDCP0_DCP_GSL_CONTROL_BASE_IDX                                                                2
#define mmDCP0_DCP_LB_DATA_GAP_BETWEEN_CHUNK                                                           0x05d6
#define mmDCP0_DCP_LB_DATA_GAP_BETWEEN_CHUNK_BASE_IDX                                                  2
#define mmDCP0_GRPH_STEREOSYNC_FLIP                                                                    0x05dc
#define mmDCP0_GRPH_STEREOSYNC_FLIP_BASE_IDX                                                           2
#define mmDCP0_HW_ROTATION                                                                             0x05de
#define mmDCP0_HW_ROTATION_BASE_IDX                                                                    2
#define mmDCP0_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL                                                      0x05df
#define mmDCP0_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL_BASE_IDX                                             2
#define mmDCP0_REGAMMA_CONTROL                                                                         0x05e0
#define mmDCP0_REGAMMA_CONTROL_BASE_IDX                                                                2
#define mmDCP0_REGAMMA_LUT_INDEX                                                                       0x05e1
#define mmDCP0_REGAMMA_LUT_INDEX_BASE_IDX                                                              2
#define mmDCP0_REGAMMA_LUT_DATA                                                                        0x05e2
#define mmDCP0_REGAMMA_LUT_DATA_BASE_IDX                                                               2
#define mmDCP0_REGAMMA_LUT_WRITE_EN_MASK                                                               0x05e3
#define mmDCP0_REGAMMA_LUT_WRITE_EN_MASK_BASE_IDX                                                      2
#define mmDCP0_REGAMMA_CNTLA_START_CNTL                                                                0x05e4
#define mmDCP0_REGAMMA_CNTLA_START_CNTL_BASE_IDX                                                       2
#define mmDCP0_REGAMMA_CNTLA_SLOPE_CNTL                                                                0x05e5
#define mmDCP0_REGAMMA_CNTLA_SLOPE_CNTL_BASE_IDX                                                       2
#define mmDCP0_REGAMMA_CNTLA_END_CNTL1                                                                 0x05e6
#define mmDCP0_REGAMMA_CNTLA_END_CNTL1_BASE_IDX                                                        2
#define mmDCP0_REGAMMA_CNTLA_END_CNTL2                                                                 0x05e7
#define mmDCP0_REGAMMA_CNTLA_END_CNTL2_BASE_IDX                                                        2
#define mmDCP0_REGAMMA_CNTLA_REGION_0_1                                                                0x05e8
#define mmDCP0_REGAMMA_CNTLA_REGION_0_1_BASE_IDX                                                       2
#define mmDCP0_REGAMMA_CNTLA_REGION_2_3                                                                0x05e9
#define mmDCP0_REGAMMA_CNTLA_REGION_2_3_BASE_IDX                                                       2
#define mmDCP0_REGAMMA_CNTLA_REGION_4_5                                                                0x05ea
#define mmDCP0_REGAMMA_CNTLA_REGION_4_5_BASE_IDX                                                       2
#define mmDCP0_REGAMMA_CNTLA_REGION_6_7                                                                0x05eb
#define mmDCP0_REGAMMA_CNTLA_REGION_6_7_BASE_IDX                                                       2
#define mmDCP0_REGAMMA_CNTLA_REGION_8_9                                                                0x05ec
#define mmDCP0_REGAMMA_CNTLA_REGION_8_9_BASE_IDX                                                       2
#define mmDCP0_REGAMMA_CNTLA_REGION_10_11                                                              0x05ed
#define mmDCP0_REGAMMA_CNTLA_REGION_10_11_BASE_IDX                                                     2
#define mmDCP0_REGAMMA_CNTLA_REGION_12_13                                                              0x05ee
#define mmDCP0_REGAMMA_CNTLA_REGION_12_13_BASE_IDX                                                     2
#define mmDCP0_REGAMMA_CNTLA_REGION_14_15                                                              0x05ef
#define mmDCP0_REGAMMA_CNTLA_REGION_14_15_BASE_IDX                                                     2
#define mmDCP0_REGAMMA_CNTLB_START_CNTL                                                                0x05f0
#define mmDCP0_REGAMMA_CNTLB_START_CNTL_BASE_IDX                                                       2
#define mmDCP0_REGAMMA_CNTLB_SLOPE_CNTL                                                                0x05f1
#define mmDCP0_REGAMMA_CNTLB_SLOPE_CNTL_BASE_IDX                                                       2
#define mmDCP0_REGAMMA_CNTLB_END_CNTL1                                                                 0x05f2
#define mmDCP0_REGAMMA_CNTLB_END_CNTL1_BASE_IDX                                                        2
#define mmDCP0_REGAMMA_CNTLB_END_CNTL2                                                                 0x05f3
#define mmDCP0_REGAMMA_CNTLB_END_CNTL2_BASE_IDX                                                        2
#define mmDCP0_REGAMMA_CNTLB_REGION_0_1                                                                0x05f4
#define mmDCP0_REGAMMA_CNTLB_REGION_0_1_BASE_IDX                                                       2
#define mmDCP0_REGAMMA_CNTLB_REGION_2_3                                                                0x05f5
#define mmDCP0_REGAMMA_CNTLB_REGION_2_3_BASE_IDX                                                       2
#define mmDCP0_REGAMMA_CNTLB_REGION_4_5                                                                0x05f6
#define mmDCP0_REGAMMA_CNTLB_REGION_4_5_BASE_IDX                                                       2
#define mmDCP0_REGAMMA_CNTLB_REGION_6_7                                                                0x05f7
#define mmDCP0_REGAMMA_CNTLB_REGION_6_7_BASE_IDX                                                       2
#define mmDCP0_REGAMMA_CNTLB_REGION_8_9                                                                0x05f8
#define mmDCP0_REGAMMA_CNTLB_REGION_8_9_BASE_IDX                                                       2
#define mmDCP0_REGAMMA_CNTLB_REGION_10_11                                                              0x05f9
#define mmDCP0_REGAMMA_CNTLB_REGION_10_11_BASE_IDX                                                     2
#define mmDCP0_REGAMMA_CNTLB_REGION_12_13                                                              0x05fa
#define mmDCP0_REGAMMA_CNTLB_REGION_12_13_BASE_IDX                                                     2
#define mmDCP0_REGAMMA_CNTLB_REGION_14_15                                                              0x05fb
#define mmDCP0_REGAMMA_CNTLB_REGION_14_15_BASE_IDX                                                     2
#define mmDCP0_ALPHA_CONTROL                                                                           0x05fc
#define mmDCP0_ALPHA_CONTROL_BASE_IDX                                                                  2
#define mmDCP0_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS                                                      0x05fd
#define mmDCP0_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_BASE_IDX                                             2
#define mmDCP0_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH                                                 0x05fe
#define mmDCP0_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH_BASE_IDX                                        2
#define mmDCP0_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS                                                    0x05ff
#define mmDCP0_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS_BASE_IDX                                           2
#define mmDCP0_GRPH_XDMA_FLIP_TIMEOUT                                                                  0x0600
#define mmDCP0_GRPH_XDMA_FLIP_TIMEOUT_BASE_IDX                                                         2
#define mmDCP0_GRPH_XDMA_FLIP_AVG_DELAY                                                                0x0601
#define mmDCP0_GRPH_XDMA_FLIP_AVG_DELAY_BASE_IDX                                                       2
#define mmDCP0_GRPH_SURFACE_COUNTER_CONTROL                                                            0x0602
#define mmDCP0_GRPH_SURFACE_COUNTER_CONTROL_BASE_IDX                                                   2
#define mmDCP0_GRPH_SURFACE_COUNTER_OUTPUT                                                             0x0603
#define mmDCP0_GRPH_SURFACE_COUNTER_OUTPUT_BASE_IDX                                                    2


// addressBlock: dce_dc_lb0_dispdec
// base address: 0x0
#define mmLB0_LB_DATA_FORMAT                                                                           0x061a
#define mmLB0_LB_DATA_FORMAT_BASE_IDX                                                                  2
#define mmLB0_LB_MEMORY_CTRL                                                                           0x061b
#define mmLB0_LB_MEMORY_CTRL_BASE_IDX                                                                  2
#define mmLB0_LB_MEMORY_SIZE_STATUS                                                                    0x061c
#define mmLB0_LB_MEMORY_SIZE_STATUS_BASE_IDX                                                           2
#define mmLB0_LB_DESKTOP_HEIGHT                                                                        0x061d
#define mmLB0_LB_DESKTOP_HEIGHT_BASE_IDX                                                               2
#define mmLB0_LB_VLINE_START_END                                                                       0x061e
#define mmLB0_LB_VLINE_START_END_BASE_IDX                                                              2
#define mmLB0_LB_VLINE2_START_END                                                                      0x061f
#define mmLB0_LB_VLINE2_START_END_BASE_IDX                                                             2
#define mmLB0_LB_V_COUNTER                                                                             0x0620
#define mmLB0_LB_V_COUNTER_BASE_IDX                                                                    2
#define mmLB0_LB_SNAPSHOT_V_COUNTER                                                                    0x0621
#define mmLB0_LB_SNAPSHOT_V_COUNTER_BASE_IDX                                                           2
#define mmLB0_LB_INTERRUPT_MASK                                                                        0x0622
#define mmLB0_LB_INTERRUPT_MASK_BASE_IDX                                                               2
#define mmLB0_LB_VLINE_STATUS                                                                          0x0623
#define mmLB0_LB_VLINE_STATUS_BASE_IDX                                                                 2
#define mmLB0_LB_VLINE2_STATUS                                                                         0x0624
#define mmLB0_LB_VLINE2_STATUS_BASE_IDX                                                                2
#define mmLB0_LB_VBLANK_STATUS                                                                         0x0625
#define mmLB0_LB_VBLANK_STATUS_BASE_IDX                                                                2
#define mmLB0_LB_SYNC_RESET_SEL                                                                        0x0626
#define mmLB0_LB_SYNC_RESET_SEL_BASE_IDX                                                               2
#define mmLB0_LB_BLACK_KEYER_R_CR                                                                      0x0627
#define mmLB0_LB_BLACK_KEYER_R_CR_BASE_IDX                                                             2
#define mmLB0_LB_BLACK_KEYER_G_Y                                                                       0x0628
#define mmLB0_LB_BLACK_KEYER_G_Y_BASE_IDX                                                              2
#define mmLB0_LB_BLACK_KEYER_B_CB                                                                      0x0629
#define mmLB0_LB_BLACK_KEYER_B_CB_BASE_IDX                                                             2
#define mmLB0_LB_KEYER_COLOR_CTRL                                                                      0x062a
#define mmLB0_LB_KEYER_COLOR_CTRL_BASE_IDX                                                             2
#define mmLB0_LB_KEYER_COLOR_R_CR                                                                      0x062b
#define mmLB0_LB_KEYER_COLOR_R_CR_BASE_IDX                                                             2
#define mmLB0_LB_KEYER_COLOR_G_Y                                                                       0x062c
#define mmLB0_LB_KEYER_COLOR_G_Y_BASE_IDX                                                              2
#define mmLB0_LB_KEYER_COLOR_B_CB                                                                      0x062d
#define mmLB0_LB_KEYER_COLOR_B_CB_BASE_IDX                                                             2
#define mmLB0_LB_KEYER_COLOR_REP_R_CR                                                                  0x062e
#define mmLB0_LB_KEYER_COLOR_REP_R_CR_BASE_IDX                                                         2
#define mmLB0_LB_KEYER_COLOR_REP_G_Y                                                                   0x062f
#define mmLB0_LB_KEYER_COLOR_REP_G_Y_BASE_IDX                                                          2
#define mmLB0_LB_KEYER_COLOR_REP_B_CB                                                                  0x0630
#define mmLB0_LB_KEYER_COLOR_REP_B_CB_BASE_IDX                                                         2
#define mmLB0_LB_BUFFER_LEVEL_STATUS                                                                   0x0631
#define mmLB0_LB_BUFFER_LEVEL_STATUS_BASE_IDX                                                          2
#define mmLB0_LB_BUFFER_URGENCY_CTRL                                                                   0x0632
#define mmLB0_LB_BUFFER_URGENCY_CTRL_BASE_IDX                                                          2
#define mmLB0_LB_BUFFER_URGENCY_STATUS                                                                 0x0633
#define mmLB0_LB_BUFFER_URGENCY_STATUS_BASE_IDX                                                        2
#define mmLB0_LB_BUFFER_STATUS                                                                         0x0634
#define mmLB0_LB_BUFFER_STATUS_BASE_IDX                                                                2
#define mmLB0_LB_NO_OUTSTANDING_REQ_STATUS                                                             0x0635
#define mmLB0_LB_NO_OUTSTANDING_REQ_STATUS_BASE_IDX                                                    2
#define mmLB0_MVP_AFR_FLIP_MODE                                                                        0x0636
#define mmLB0_MVP_AFR_FLIP_MODE_BASE_IDX                                                               2
#define mmLB0_MVP_AFR_FLIP_FIFO_CNTL                                                                   0x0637
#define mmLB0_MVP_AFR_FLIP_FIFO_CNTL_BASE_IDX                                                          2
#define mmLB0_MVP_FLIP_LINE_NUM_INSERT                                                                 0x0638
#define mmLB0_MVP_FLIP_LINE_NUM_INSERT_BASE_IDX                                                        2
#define mmLB0_DC_MVP_LB_CONTROL                                                                        0x0639
#define mmLB0_DC_MVP_LB_CONTROL_BASE_IDX                                                               2


// addressBlock: dce_dc_dcfe0_dispdec
// base address: 0x0
#define mmDCFE0_DCFE_CLOCK_CONTROL                                                                     0x065a
#define mmDCFE0_DCFE_CLOCK_CONTROL_BASE_IDX                                                            2
#define mmDCFE0_DCFE_SOFT_RESET                                                                        0x065b
#define mmDCFE0_DCFE_SOFT_RESET_BASE_IDX                                                               2
#define mmDCFE0_DCFE_MEM_PWR_CTRL                                                                      0x065d
#define mmDCFE0_DCFE_MEM_PWR_CTRL_BASE_IDX                                                             2
#define mmDCFE0_DCFE_MEM_PWR_CTRL2                                                                     0x065e
#define mmDCFE0_DCFE_MEM_PWR_CTRL2_BASE_IDX                                                            2
#define mmDCFE0_DCFE_MEM_PWR_STATUS                                                                    0x065f
#define mmDCFE0_DCFE_MEM_PWR_STATUS_BASE_IDX                                                           2
#define mmDCFE0_DCFE_MISC                                                                              0x0660
#define mmDCFE0_DCFE_MISC_BASE_IDX                                                                     2
#define mmDCFE0_DCFE_FLUSH                                                                             0x0661
#define mmDCFE0_DCFE_FLUSH_BASE_IDX                                                                    2


// addressBlock: dce_dc_dc_perfmon3_dispdec
// base address: 0x1938
#define mmDC_PERFMON3_PERFCOUNTER_CNTL                                                                 0x066e
#define mmDC_PERFMON3_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON3_PERFCOUNTER_CNTL2                                                                0x066f
#define mmDC_PERFMON3_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON3_PERFCOUNTER_STATE                                                                0x0670
#define mmDC_PERFMON3_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON3_PERFMON_CNTL                                                                     0x0671
#define mmDC_PERFMON3_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON3_PERFMON_CNTL2                                                                    0x0672
#define mmDC_PERFMON3_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON3_PERFMON_CVALUE_INT_MISC                                                          0x0673
#define mmDC_PERFMON3_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON3_PERFMON_CVALUE_LOW                                                               0x0674
#define mmDC_PERFMON3_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON3_PERFMON_HI                                                                       0x0675
#define mmDC_PERFMON3_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON3_PERFMON_LOW                                                                      0x0676
#define mmDC_PERFMON3_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dmif_pg0_dispdec
// base address: 0x0
#define mmDMIF_PG0_DPG_PIPE_ARBITRATION_CONTROL1                                                       0x067a
#define mmDMIF_PG0_DPG_PIPE_ARBITRATION_CONTROL1_BASE_IDX                                              2
#define mmDMIF_PG0_DPG_PIPE_ARBITRATION_CONTROL2                                                       0x067b
#define mmDMIF_PG0_DPG_PIPE_ARBITRATION_CONTROL2_BASE_IDX                                              2
#define mmDMIF_PG0_DPG_WATERMARK_MASK_CONTROL                                                          0x067c
#define mmDMIF_PG0_DPG_WATERMARK_MASK_CONTROL_BASE_IDX                                                 2
#define mmDMIF_PG0_DPG_PIPE_URGENCY_CONTROL                                                            0x067d
#define mmDMIF_PG0_DPG_PIPE_URGENCY_CONTROL_BASE_IDX                                                   2
#define mmDMIF_PG0_DPG_PIPE_URGENT_LEVEL_CONTROL                                                       0x067e
#define mmDMIF_PG0_DPG_PIPE_URGENT_LEVEL_CONTROL_BASE_IDX                                              2
#define mmDMIF_PG0_DPG_PIPE_STUTTER_CONTROL                                                            0x067f
#define mmDMIF_PG0_DPG_PIPE_STUTTER_CONTROL_BASE_IDX                                                   2
#define mmDMIF_PG0_DPG_PIPE_STUTTER_CONTROL2                                                           0x0680
#define mmDMIF_PG0_DPG_PIPE_STUTTER_CONTROL2_BASE_IDX                                                  2
#define mmDMIF_PG0_DPG_PIPE_LOW_POWER_CONTROL                                                          0x0681
#define mmDMIF_PG0_DPG_PIPE_LOW_POWER_CONTROL_BASE_IDX                                                 2
#define mmDMIF_PG0_DPG_REPEATER_PROGRAM                                                                0x0682
#define mmDMIF_PG0_DPG_REPEATER_PROGRAM_BASE_IDX                                                       2
#define mmDMIF_PG0_DPG_CHK_PRE_PROC_CNTL                                                               0x0686
#define mmDMIF_PG0_DPG_CHK_PRE_PROC_CNTL_BASE_IDX                                                      2
#define mmDMIF_PG0_DPG_DVMM_STATUS                                                                     0x0687
#define mmDMIF_PG0_DPG_DVMM_STATUS_BASE_IDX                                                            2


// addressBlock: dce_dc_scl0_dispdec
// base address: 0x0
#define mmSCL0_SCL_COEF_RAM_SELECT                                                                     0x069a
#define mmSCL0_SCL_COEF_RAM_SELECT_BASE_IDX                                                            2
#define mmSCL0_SCL_COEF_RAM_TAP_DATA                                                                   0x069b
#define mmSCL0_SCL_COEF_RAM_TAP_DATA_BASE_IDX                                                          2
#define mmSCL0_SCL_MODE                                                                                0x069c
#define mmSCL0_SCL_MODE_BASE_IDX                                                                       2
#define mmSCL0_SCL_TAP_CONTROL                                                                         0x069d
#define mmSCL0_SCL_TAP_CONTROL_BASE_IDX                                                                2
#define mmSCL0_SCL_CONTROL                                                                             0x069e
#define mmSCL0_SCL_CONTROL_BASE_IDX                                                                    2
#define mmSCL0_SCL_BYPASS_CONTROL                                                                      0x069f
#define mmSCL0_SCL_BYPASS_CONTROL_BASE_IDX                                                             2
#define mmSCL0_SCL_MANUAL_REPLICATE_CONTROL                                                            0x06a0
#define mmSCL0_SCL_MANUAL_REPLICATE_CONTROL_BASE_IDX                                                   2
#define mmSCL0_SCL_AUTOMATIC_MODE_CONTROL                                                              0x06a1
#define mmSCL0_SCL_AUTOMATIC_MODE_CONTROL_BASE_IDX                                                     2
#define mmSCL0_SCL_HORZ_FILTER_CONTROL                                                                 0x06a2
#define mmSCL0_SCL_HORZ_FILTER_CONTROL_BASE_IDX                                                        2
#define mmSCL0_SCL_HORZ_FILTER_SCALE_RATIO                                                             0x06a3
#define mmSCL0_SCL_HORZ_FILTER_SCALE_RATIO_BASE_IDX                                                    2
#define mmSCL0_SCL_HORZ_FILTER_INIT                                                                    0x06a4
#define mmSCL0_SCL_HORZ_FILTER_INIT_BASE_IDX                                                           2
#define mmSCL0_SCL_VERT_FILTER_CONTROL                                                                 0x06a5
#define mmSCL0_SCL_VERT_FILTER_CONTROL_BASE_IDX                                                        2
#define mmSCL0_SCL_VERT_FILTER_SCALE_RATIO                                                             0x06a6
#define mmSCL0_SCL_VERT_FILTER_SCALE_RATIO_BASE_IDX                                                    2
#define mmSCL0_SCL_VERT_FILTER_INIT                                                                    0x06a7
#define mmSCL0_SCL_VERT_FILTER_INIT_BASE_IDX                                                           2
#define mmSCL0_SCL_VERT_FILTER_INIT_BOT                                                                0x06a8
#define mmSCL0_SCL_VERT_FILTER_INIT_BOT_BASE_IDX                                                       2
#define mmSCL0_SCL_ROUND_OFFSET                                                                        0x06a9
#define mmSCL0_SCL_ROUND_OFFSET_BASE_IDX                                                               2
#define mmSCL0_SCL_UPDATE                                                                              0x06aa
#define mmSCL0_SCL_UPDATE_BASE_IDX                                                                     2
#define mmSCL0_SCL_F_SHARP_CONTROL                                                                     0x06ab
#define mmSCL0_SCL_F_SHARP_CONTROL_BASE_IDX                                                            2
#define mmSCL0_SCL_ALU_CONTROL                                                                         0x06ac
#define mmSCL0_SCL_ALU_CONTROL_BASE_IDX                                                                2
#define mmSCL0_SCL_COEF_RAM_CONFLICT_STATUS                                                            0x06ad
#define mmSCL0_SCL_COEF_RAM_CONFLICT_STATUS_BASE_IDX                                                   2
#define mmSCL0_VIEWPORT_START_SECONDARY                                                                0x06ae
#define mmSCL0_VIEWPORT_START_SECONDARY_BASE_IDX                                                       2
#define mmSCL0_VIEWPORT_START                                                                          0x06af
#define mmSCL0_VIEWPORT_START_BASE_IDX                                                                 2
#define mmSCL0_VIEWPORT_SIZE                                                                           0x06b0
#define mmSCL0_VIEWPORT_SIZE_BASE_IDX                                                                  2
#define mmSCL0_EXT_OVERSCAN_LEFT_RIGHT                                                                 0x06b1
#define mmSCL0_EXT_OVERSCAN_LEFT_RIGHT_BASE_IDX                                                        2
#define mmSCL0_EXT_OVERSCAN_TOP_BOTTOM                                                                 0x06b2
#define mmSCL0_EXT_OVERSCAN_TOP_BOTTOM_BASE_IDX                                                        2
#define mmSCL0_SCL_MODE_CHANGE_DET1                                                                    0x06b3
#define mmSCL0_SCL_MODE_CHANGE_DET1_BASE_IDX                                                           2
#define mmSCL0_SCL_MODE_CHANGE_DET2                                                                    0x06b4
#define mmSCL0_SCL_MODE_CHANGE_DET2_BASE_IDX                                                           2
#define mmSCL0_SCL_MODE_CHANGE_DET3                                                                    0x06b5
#define mmSCL0_SCL_MODE_CHANGE_DET3_BASE_IDX                                                           2
#define mmSCL0_SCL_MODE_CHANGE_MASK                                                                    0x06b6
#define mmSCL0_SCL_MODE_CHANGE_MASK_BASE_IDX                                                           2


// addressBlock: dce_dc_blnd0_dispdec
// base address: 0x0
#define mmBLND0_BLND_CONTROL                                                                           0x06c7
#define mmBLND0_BLND_CONTROL_BASE_IDX                                                                  2
#define mmBLND0_BLND_SM_CONTROL2                                                                       0x06c8
#define mmBLND0_BLND_SM_CONTROL2_BASE_IDX                                                              2
#define mmBLND0_BLND_CONTROL2                                                                          0x06c9
#define mmBLND0_BLND_CONTROL2_BASE_IDX                                                                 2
#define mmBLND0_BLND_UPDATE                                                                            0x06ca
#define mmBLND0_BLND_UPDATE_BASE_IDX                                                                   2
#define mmBLND0_BLND_UNDERFLOW_INTERRUPT                                                               0x06cb
#define mmBLND0_BLND_UNDERFLOW_INTERRUPT_BASE_IDX                                                      2
#define mmBLND0_BLND_V_UPDATE_LOCK                                                                     0x06cc
#define mmBLND0_BLND_V_UPDATE_LOCK_BASE_IDX                                                            2
#define mmBLND0_BLND_REG_UPDATE_STATUS                                                                 0x06cd
#define mmBLND0_BLND_REG_UPDATE_STATUS_BASE_IDX                                                        2


// addressBlock: dce_dc_crtc0_dispdec
// base address: 0x0
#define mmCRTC0_CRTC_H_BLANK_EARLY_NUM                                                                 0x06d2
#define mmCRTC0_CRTC_H_BLANK_EARLY_NUM_BASE_IDX                                                        2
#define mmCRTC0_CRTC_H_TOTAL                                                                           0x06d3
#define mmCRTC0_CRTC_H_TOTAL_BASE_IDX                                                                  2
#define mmCRTC0_CRTC_H_BLANK_START_END                                                                 0x06d4
#define mmCRTC0_CRTC_H_BLANK_START_END_BASE_IDX                                                        2
#define mmCRTC0_CRTC_H_SYNC_A                                                                          0x06d5
#define mmCRTC0_CRTC_H_SYNC_A_BASE_IDX                                                                 2
#define mmCRTC0_CRTC_H_SYNC_A_CNTL                                                                     0x06d6
#define mmCRTC0_CRTC_H_SYNC_A_CNTL_BASE_IDX                                                            2
#define mmCRTC0_CRTC_H_SYNC_B                                                                          0x06d7
#define mmCRTC0_CRTC_H_SYNC_B_BASE_IDX                                                                 2
#define mmCRTC0_CRTC_H_SYNC_B_CNTL                                                                     0x06d8
#define mmCRTC0_CRTC_H_SYNC_B_CNTL_BASE_IDX                                                            2
#define mmCRTC0_CRTC_VBI_END                                                                           0x06d9
#define mmCRTC0_CRTC_VBI_END_BASE_IDX                                                                  2
#define mmCRTC0_CRTC_V_TOTAL                                                                           0x06da
#define mmCRTC0_CRTC_V_TOTAL_BASE_IDX                                                                  2
#define mmCRTC0_CRTC_V_TOTAL_MIN                                                                       0x06db
#define mmCRTC0_CRTC_V_TOTAL_MIN_BASE_IDX                                                              2
#define mmCRTC0_CRTC_V_TOTAL_MAX                                                                       0x06dc
#define mmCRTC0_CRTC_V_TOTAL_MAX_BASE_IDX                                                              2
#define mmCRTC0_CRTC_V_TOTAL_CONTROL                                                                   0x06dd
#define mmCRTC0_CRTC_V_TOTAL_CONTROL_BASE_IDX                                                          2
#define mmCRTC0_CRTC_V_TOTAL_INT_STATUS                                                                0x06de
#define mmCRTC0_CRTC_V_TOTAL_INT_STATUS_BASE_IDX                                                       2
#define mmCRTC0_CRTC_VSYNC_NOM_INT_STATUS                                                              0x06df
#define mmCRTC0_CRTC_VSYNC_NOM_INT_STATUS_BASE_IDX                                                     2
#define mmCRTC0_CRTC_V_BLANK_START_END                                                                 0x06e0
#define mmCRTC0_CRTC_V_BLANK_START_END_BASE_IDX                                                        2
#define mmCRTC0_CRTC_V_SYNC_A                                                                          0x06e1
#define mmCRTC0_CRTC_V_SYNC_A_BASE_IDX                                                                 2
#define mmCRTC0_CRTC_V_SYNC_A_CNTL                                                                     0x06e2
#define mmCRTC0_CRTC_V_SYNC_A_CNTL_BASE_IDX                                                            2
#define mmCRTC0_CRTC_V_SYNC_B                                                                          0x06e3
#define mmCRTC0_CRTC_V_SYNC_B_BASE_IDX                                                                 2
#define mmCRTC0_CRTC_V_SYNC_B_CNTL                                                                     0x06e4
#define mmCRTC0_CRTC_V_SYNC_B_CNTL_BASE_IDX                                                            2
#define mmCRTC0_CRTC_DTMTEST_CNTL                                                                      0x06e5
#define mmCRTC0_CRTC_DTMTEST_CNTL_BASE_IDX                                                             2
#define mmCRTC0_CRTC_DTMTEST_STATUS_POSITION                                                           0x06e6
#define mmCRTC0_CRTC_DTMTEST_STATUS_POSITION_BASE_IDX                                                  2
#define mmCRTC0_CRTC_TRIGA_CNTL                                                                        0x06e7
#define mmCRTC0_CRTC_TRIGA_CNTL_BASE_IDX                                                               2
#define mmCRTC0_CRTC_TRIGA_MANUAL_TRIG                                                                 0x06e8
#define mmCRTC0_CRTC_TRIGA_MANUAL_TRIG_BASE_IDX                                                        2
#define mmCRTC0_CRTC_TRIGB_CNTL                                                                        0x06e9
#define mmCRTC0_CRTC_TRIGB_CNTL_BASE_IDX                                                               2
#define mmCRTC0_CRTC_TRIGB_MANUAL_TRIG                                                                 0x06ea
#define mmCRTC0_CRTC_TRIGB_MANUAL_TRIG_BASE_IDX                                                        2
#define mmCRTC0_CRTC_FORCE_COUNT_NOW_CNTL                                                              0x06eb
#define mmCRTC0_CRTC_FORCE_COUNT_NOW_CNTL_BASE_IDX                                                     2
#define mmCRTC0_CRTC_FLOW_CONTROL                                                                      0x06ec
#define mmCRTC0_CRTC_FLOW_CONTROL_BASE_IDX                                                             2
#define mmCRTC0_CRTC_STEREO_FORCE_NEXT_EYE                                                             0x06ed
#define mmCRTC0_CRTC_STEREO_FORCE_NEXT_EYE_BASE_IDX                                                    2
#define mmCRTC0_CRTC_AVSYNC_COUNTER                                                                    0x06ee
#define mmCRTC0_CRTC_AVSYNC_COUNTER_BASE_IDX                                                           2
#define mmCRTC0_CRTC_CONTROL                                                                           0x06ef
#define mmCRTC0_CRTC_CONTROL_BASE_IDX                                                                  2
#define mmCRTC0_CRTC_BLANK_CONTROL                                                                     0x06f0
#define mmCRTC0_CRTC_BLANK_CONTROL_BASE_IDX                                                            2
#define mmCRTC0_CRTC_INTERLACE_CONTROL                                                                 0x06f1
#define mmCRTC0_CRTC_INTERLACE_CONTROL_BASE_IDX                                                        2
#define mmCRTC0_CRTC_INTERLACE_STATUS                                                                  0x06f2
#define mmCRTC0_CRTC_INTERLACE_STATUS_BASE_IDX                                                         2
#define mmCRTC0_CRTC_FIELD_INDICATION_CONTROL                                                          0x06f3
#define mmCRTC0_CRTC_FIELD_INDICATION_CONTROL_BASE_IDX                                                 2
#define mmCRTC0_CRTC_PIXEL_DATA_READBACK0                                                              0x06f4
#define mmCRTC0_CRTC_PIXEL_DATA_READBACK0_BASE_IDX                                                     2
#define mmCRTC0_CRTC_PIXEL_DATA_READBACK1                                                              0x06f5
#define mmCRTC0_CRTC_PIXEL_DATA_READBACK1_BASE_IDX                                                     2
#define mmCRTC0_CRTC_STATUS                                                                            0x06f6
#define mmCRTC0_CRTC_STATUS_BASE_IDX                                                                   2
#define mmCRTC0_CRTC_STATUS_POSITION                                                                   0x06f7
#define mmCRTC0_CRTC_STATUS_POSITION_BASE_IDX                                                          2
#define mmCRTC0_CRTC_NOM_VERT_POSITION                                                                 0x06f8
#define mmCRTC0_CRTC_NOM_VERT_POSITION_BASE_IDX                                                        2
#define mmCRTC0_CRTC_STATUS_FRAME_COUNT                                                                0x06f9
#define mmCRTC0_CRTC_STATUS_FRAME_COUNT_BASE_IDX                                                       2
#define mmCRTC0_CRTC_STATUS_VF_COUNT                                                                   0x06fa
#define mmCRTC0_CRTC_STATUS_VF_COUNT_BASE_IDX                                                          2
#define mmCRTC0_CRTC_STATUS_HV_COUNT                                                                   0x06fb
#define mmCRTC0_CRTC_STATUS_HV_COUNT_BASE_IDX                                                          2
#define mmCRTC0_CRTC_COUNT_CONTROL                                                                     0x06fc
#define mmCRTC0_CRTC_COUNT_CONTROL_BASE_IDX                                                            2
#define mmCRTC0_CRTC_COUNT_RESET                                                                       0x06fd
#define mmCRTC0_CRTC_COUNT_RESET_BASE_IDX                                                              2
#define mmCRTC0_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE                                                      0x06fe
#define mmCRTC0_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE_BASE_IDX                                             2
#define mmCRTC0_CRTC_VERT_SYNC_CONTROL                                                                 0x06ff
#define mmCRTC0_CRTC_VERT_SYNC_CONTROL_BASE_IDX                                                        2
#define mmCRTC0_CRTC_STEREO_STATUS                                                                     0x0700
#define mmCRTC0_CRTC_STEREO_STATUS_BASE_IDX                                                            2
#define mmCRTC0_CRTC_STEREO_CONTROL                                                                    0x0701
#define mmCRTC0_CRTC_STEREO_CONTROL_BASE_IDX                                                           2
#define mmCRTC0_CRTC_SNAPSHOT_STATUS                                                                   0x0702
#define mmCRTC0_CRTC_SNAPSHOT_STATUS_BASE_IDX                                                          2
#define mmCRTC0_CRTC_SNAPSHOT_CONTROL                                                                  0x0703
#define mmCRTC0_CRTC_SNAPSHOT_CONTROL_BASE_IDX                                                         2
#define mmCRTC0_CRTC_SNAPSHOT_POSITION                                                                 0x0704
#define mmCRTC0_CRTC_SNAPSHOT_POSITION_BASE_IDX                                                        2
#define mmCRTC0_CRTC_SNAPSHOT_FRAME                                                                    0x0705
#define mmCRTC0_CRTC_SNAPSHOT_FRAME_BASE_IDX                                                           2
#define mmCRTC0_CRTC_START_LINE_CONTROL                                                                0x0706
#define mmCRTC0_CRTC_START_LINE_CONTROL_BASE_IDX                                                       2
#define mmCRTC0_CRTC_INTERRUPT_CONTROL                                                                 0x0707
#define mmCRTC0_CRTC_INTERRUPT_CONTROL_BASE_IDX                                                        2
#define mmCRTC0_CRTC_UPDATE_LOCK                                                                       0x0708
#define mmCRTC0_CRTC_UPDATE_LOCK_BASE_IDX                                                              2
#define mmCRTC0_CRTC_DOUBLE_BUFFER_CONTROL                                                             0x0709
#define mmCRTC0_CRTC_DOUBLE_BUFFER_CONTROL_BASE_IDX                                                    2
#define mmCRTC0_CRTC_VGA_PARAMETER_CAPTURE_MODE                                                        0x070a
#define mmCRTC0_CRTC_VGA_PARAMETER_CAPTURE_MODE_BASE_IDX                                               2
#define mmCRTC0_CRTC_TEST_PATTERN_CONTROL                                                              0x070b
#define mmCRTC0_CRTC_TEST_PATTERN_CONTROL_BASE_IDX                                                     2
#define mmCRTC0_CRTC_TEST_PATTERN_PARAMETERS                                                           0x070c
#define mmCRTC0_CRTC_TEST_PATTERN_PARAMETERS_BASE_IDX                                                  2
#define mmCRTC0_CRTC_TEST_PATTERN_COLOR                                                                0x070d
#define mmCRTC0_CRTC_TEST_PATTERN_COLOR_BASE_IDX                                                       2
#define mmCRTC0_CRTC_MASTER_UPDATE_LOCK                                                                0x070e
#define mmCRTC0_CRTC_MASTER_UPDATE_LOCK_BASE_IDX                                                       2
#define mmCRTC0_CRTC_MASTER_UPDATE_MODE                                                                0x070f
#define mmCRTC0_CRTC_MASTER_UPDATE_MODE_BASE_IDX                                                       2
#define mmCRTC0_CRTC_MVP_INBAND_CNTL_INSERT                                                            0x0710
#define mmCRTC0_CRTC_MVP_INBAND_CNTL_INSERT_BASE_IDX                                                   2
#define mmCRTC0_CRTC_MVP_INBAND_CNTL_INSERT_TIMER                                                      0x0711
#define mmCRTC0_CRTC_MVP_INBAND_CNTL_INSERT_TIMER_BASE_IDX                                             2
#define mmCRTC0_CRTC_MVP_STATUS                                                                        0x0712
#define mmCRTC0_CRTC_MVP_STATUS_BASE_IDX                                                               2
#define mmCRTC0_CRTC_MASTER_EN                                                                         0x0713
#define mmCRTC0_CRTC_MASTER_EN_BASE_IDX                                                                2
#define mmCRTC0_CRTC_ALLOW_STOP_OFF_V_CNT                                                              0x0714
#define mmCRTC0_CRTC_ALLOW_STOP_OFF_V_CNT_BASE_IDX                                                     2
#define mmCRTC0_CRTC_V_UPDATE_INT_STATUS                                                               0x0715
#define mmCRTC0_CRTC_V_UPDATE_INT_STATUS_BASE_IDX                                                      2
#define mmCRTC0_CRTC_OVERSCAN_COLOR                                                                    0x0717
#define mmCRTC0_CRTC_OVERSCAN_COLOR_BASE_IDX                                                           2
#define mmCRTC0_CRTC_OVERSCAN_COLOR_EXT                                                                0x0718
#define mmCRTC0_CRTC_OVERSCAN_COLOR_EXT_BASE_IDX                                                       2
#define mmCRTC0_CRTC_BLANK_DATA_COLOR                                                                  0x0719
#define mmCRTC0_CRTC_BLANK_DATA_COLOR_BASE_IDX                                                         2
#define mmCRTC0_CRTC_BLANK_DATA_COLOR_EXT                                                              0x071a
#define mmCRTC0_CRTC_BLANK_DATA_COLOR_EXT_BASE_IDX                                                     2
#define mmCRTC0_CRTC_BLACK_COLOR                                                                       0x071b
#define mmCRTC0_CRTC_BLACK_COLOR_BASE_IDX                                                              2
#define mmCRTC0_CRTC_BLACK_COLOR_EXT                                                                   0x071c
#define mmCRTC0_CRTC_BLACK_COLOR_EXT_BASE_IDX                                                          2
#define mmCRTC0_CRTC_VERTICAL_INTERRUPT0_POSITION                                                      0x071d
#define mmCRTC0_CRTC_VERTICAL_INTERRUPT0_POSITION_BASE_IDX                                             2
#define mmCRTC0_CRTC_VERTICAL_INTERRUPT0_CONTROL                                                       0x071e
#define mmCRTC0_CRTC_VERTICAL_INTERRUPT0_CONTROL_BASE_IDX                                              2
#define mmCRTC0_CRTC_VERTICAL_INTERRUPT1_POSITION                                                      0x071f
#define mmCRTC0_CRTC_VERTICAL_INTERRUPT1_POSITION_BASE_IDX                                             2
#define mmCRTC0_CRTC_VERTICAL_INTERRUPT1_CONTROL                                                       0x0720
#define mmCRTC0_CRTC_VERTICAL_INTERRUPT1_CONTROL_BASE_IDX                                              2
#define mmCRTC0_CRTC_VERTICAL_INTERRUPT2_POSITION                                                      0x0721
#define mmCRTC0_CRTC_VERTICAL_INTERRUPT2_POSITION_BASE_IDX                                             2
#define mmCRTC0_CRTC_VERTICAL_INTERRUPT2_CONTROL                                                       0x0722
#define mmCRTC0_CRTC_VERTICAL_INTERRUPT2_CONTROL_BASE_IDX                                              2
#define mmCRTC0_CRTC_CRC_CNTL                                                                          0x0723
#define mmCRTC0_CRTC_CRC_CNTL_BASE_IDX                                                                 2
#define mmCRTC0_CRTC_CRC0_WINDOWA_X_CONTROL                                                            0x0724
#define mmCRTC0_CRTC_CRC0_WINDOWA_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC0_CRTC_CRC0_WINDOWA_Y_CONTROL                                                            0x0725
#define mmCRTC0_CRTC_CRC0_WINDOWA_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC0_CRTC_CRC0_WINDOWB_X_CONTROL                                                            0x0726
#define mmCRTC0_CRTC_CRC0_WINDOWB_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC0_CRTC_CRC0_WINDOWB_Y_CONTROL                                                            0x0727
#define mmCRTC0_CRTC_CRC0_WINDOWB_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC0_CRTC_CRC0_DATA_RG                                                                      0x0728
#define mmCRTC0_CRTC_CRC0_DATA_RG_BASE_IDX                                                             2
#define mmCRTC0_CRTC_CRC0_DATA_B                                                                       0x0729
#define mmCRTC0_CRTC_CRC0_DATA_B_BASE_IDX                                                              2
#define mmCRTC0_CRTC_CRC1_WINDOWA_X_CONTROL                                                            0x072a
#define mmCRTC0_CRTC_CRC1_WINDOWA_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC0_CRTC_CRC1_WINDOWA_Y_CONTROL                                                            0x072b
#define mmCRTC0_CRTC_CRC1_WINDOWA_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC0_CRTC_CRC1_WINDOWB_X_CONTROL                                                            0x072c
#define mmCRTC0_CRTC_CRC1_WINDOWB_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC0_CRTC_CRC1_WINDOWB_Y_CONTROL                                                            0x072d
#define mmCRTC0_CRTC_CRC1_WINDOWB_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC0_CRTC_CRC1_DATA_RG                                                                      0x072e
#define mmCRTC0_CRTC_CRC1_DATA_RG_BASE_IDX                                                             2
#define mmCRTC0_CRTC_CRC1_DATA_B                                                                       0x072f
#define mmCRTC0_CRTC_CRC1_DATA_B_BASE_IDX                                                              2
#define mmCRTC0_CRTC_EXT_TIMING_SYNC_CONTROL                                                           0x0730
#define mmCRTC0_CRTC_EXT_TIMING_SYNC_CONTROL_BASE_IDX                                                  2
#define mmCRTC0_CRTC_EXT_TIMING_SYNC_WINDOW_START                                                      0x0731
#define mmCRTC0_CRTC_EXT_TIMING_SYNC_WINDOW_START_BASE_IDX                                             2
#define mmCRTC0_CRTC_EXT_TIMING_SYNC_WINDOW_END                                                        0x0732
#define mmCRTC0_CRTC_EXT_TIMING_SYNC_WINDOW_END_BASE_IDX                                               2
#define mmCRTC0_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL                                            0x0733
#define mmCRTC0_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_BASE_IDX                                   2
#define mmCRTC0_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL                                                 0x0734
#define mmCRTC0_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL_BASE_IDX                                        2
#define mmCRTC0_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL                                          0x0735
#define mmCRTC0_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL_BASE_IDX                                 2
#define mmCRTC0_CRTC_STATIC_SCREEN_CONTROL                                                             0x0736
#define mmCRTC0_CRTC_STATIC_SCREEN_CONTROL_BASE_IDX                                                    2
#define mmCRTC0_CRTC_3D_STRUCTURE_CONTROL                                                              0x0737
#define mmCRTC0_CRTC_3D_STRUCTURE_CONTROL_BASE_IDX                                                     2
#define mmCRTC0_CRTC_GSL_VSYNC_GAP                                                                     0x0738
#define mmCRTC0_CRTC_GSL_VSYNC_GAP_BASE_IDX                                                            2
#define mmCRTC0_CRTC_GSL_WINDOW                                                                        0x0739
#define mmCRTC0_CRTC_GSL_WINDOW_BASE_IDX                                                               2
#define mmCRTC0_CRTC_GSL_CONTROL                                                                       0x073a
#define mmCRTC0_CRTC_GSL_CONTROL_BASE_IDX                                                              2
#define mmCRTC0_CRTC_RANGE_TIMING_INT_STATUS                                                           0x073d
#define mmCRTC0_CRTC_RANGE_TIMING_INT_STATUS_BASE_IDX                                                  2
#define mmCRTC0_CRTC_DRR_CONTROL                                                                       0x073e
#define mmCRTC0_CRTC_DRR_CONTROL_BASE_IDX                                                              2


// addressBlock: dce_dc_fmt0_dispdec
// base address: 0x0
#define mmFMT0_FMT_CLAMP_COMPONENT_R                                                                   0x0742
#define mmFMT0_FMT_CLAMP_COMPONENT_R_BASE_IDX                                                          2
#define mmFMT0_FMT_CLAMP_COMPONENT_G                                                                   0x0743
#define mmFMT0_FMT_CLAMP_COMPONENT_G_BASE_IDX                                                          2
#define mmFMT0_FMT_CLAMP_COMPONENT_B                                                                   0x0744
#define mmFMT0_FMT_CLAMP_COMPONENT_B_BASE_IDX                                                          2
#define mmFMT0_FMT_DYNAMIC_EXP_CNTL                                                                    0x0745
#define mmFMT0_FMT_DYNAMIC_EXP_CNTL_BASE_IDX                                                           2
#define mmFMT0_FMT_CONTROL                                                                             0x0746
#define mmFMT0_FMT_CONTROL_BASE_IDX                                                                    2
#define mmFMT0_FMT_BIT_DEPTH_CONTROL                                                                   0x0747
#define mmFMT0_FMT_BIT_DEPTH_CONTROL_BASE_IDX                                                          2
#define mmFMT0_FMT_DITHER_RAND_R_SEED                                                                  0x0748
#define mmFMT0_FMT_DITHER_RAND_R_SEED_BASE_IDX                                                         2
#define mmFMT0_FMT_DITHER_RAND_G_SEED                                                                  0x0749
#define mmFMT0_FMT_DITHER_RAND_G_SEED_BASE_IDX                                                         2
#define mmFMT0_FMT_DITHER_RAND_B_SEED                                                                  0x074a
#define mmFMT0_FMT_DITHER_RAND_B_SEED_BASE_IDX                                                         2
#define mmFMT0_FMT_CLAMP_CNTL                                                                          0x074e
#define mmFMT0_FMT_CLAMP_CNTL_BASE_IDX                                                                 2
#define mmFMT0_FMT_CRC_CNTL                                                                            0x074f
#define mmFMT0_FMT_CRC_CNTL_BASE_IDX                                                                   2
#define mmFMT0_FMT_CRC_SIG_RED_GREEN_MASK                                                              0x0750
#define mmFMT0_FMT_CRC_SIG_RED_GREEN_MASK_BASE_IDX                                                     2
#define mmFMT0_FMT_CRC_SIG_BLUE_CONTROL_MASK                                                           0x0751
#define mmFMT0_FMT_CRC_SIG_BLUE_CONTROL_MASK_BASE_IDX                                                  2
#define mmFMT0_FMT_CRC_SIG_RED_GREEN                                                                   0x0752
#define mmFMT0_FMT_CRC_SIG_RED_GREEN_BASE_IDX                                                          2
#define mmFMT0_FMT_CRC_SIG_BLUE_CONTROL                                                                0x0753
#define mmFMT0_FMT_CRC_SIG_BLUE_CONTROL_BASE_IDX                                                       2
#define mmFMT0_FMT_SIDE_BY_SIDE_STEREO_CONTROL                                                         0x0754
#define mmFMT0_FMT_SIDE_BY_SIDE_STEREO_CONTROL_BASE_IDX                                                2
#define mmFMT0_FMT_420_HBLANK_EARLY_START                                                              0x0755
#define mmFMT0_FMT_420_HBLANK_EARLY_START_BASE_IDX                                                     2


// addressBlock: dce_dc_dcp1_dispdec
// base address: 0x800
#define mmDCP1_GRPH_ENABLE                                                                             0x075a
#define mmDCP1_GRPH_ENABLE_BASE_IDX                                                                    2
#define mmDCP1_GRPH_CONTROL                                                                            0x075b
#define mmDCP1_GRPH_CONTROL_BASE_IDX                                                                   2
#define mmDCP1_GRPH_LUT_10BIT_BYPASS                                                                   0x075c
#define mmDCP1_GRPH_LUT_10BIT_BYPASS_BASE_IDX                                                          2
#define mmDCP1_GRPH_SWAP_CNTL                                                                          0x075d
#define mmDCP1_GRPH_SWAP_CNTL_BASE_IDX                                                                 2
#define mmDCP1_GRPH_PRIMARY_SURFACE_ADDRESS                                                            0x075e
#define mmDCP1_GRPH_PRIMARY_SURFACE_ADDRESS_BASE_IDX                                                   2
#define mmDCP1_GRPH_SECONDARY_SURFACE_ADDRESS                                                          0x075f
#define mmDCP1_GRPH_SECONDARY_SURFACE_ADDRESS_BASE_IDX                                                 2
#define mmDCP1_GRPH_PITCH                                                                              0x0760
#define mmDCP1_GRPH_PITCH_BASE_IDX                                                                     2
#define mmDCP1_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH                                                       0x0761
#define mmDCP1_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                              2
#define mmDCP1_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH                                                     0x0762
#define mmDCP1_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                            2
#define mmDCP1_GRPH_SURFACE_OFFSET_X                                                                   0x0763
#define mmDCP1_GRPH_SURFACE_OFFSET_X_BASE_IDX                                                          2
#define mmDCP1_GRPH_SURFACE_OFFSET_Y                                                                   0x0764
#define mmDCP1_GRPH_SURFACE_OFFSET_Y_BASE_IDX                                                          2
#define mmDCP1_GRPH_X_START                                                                            0x0765
#define mmDCP1_GRPH_X_START_BASE_IDX                                                                   2
#define mmDCP1_GRPH_Y_START                                                                            0x0766
#define mmDCP1_GRPH_Y_START_BASE_IDX                                                                   2
#define mmDCP1_GRPH_X_END                                                                              0x0767
#define mmDCP1_GRPH_X_END_BASE_IDX                                                                     2
#define mmDCP1_GRPH_Y_END                                                                              0x0768
#define mmDCP1_GRPH_Y_END_BASE_IDX                                                                     2
#define mmDCP1_INPUT_GAMMA_CONTROL                                                                     0x0769
#define mmDCP1_INPUT_GAMMA_CONTROL_BASE_IDX                                                            2
#define mmDCP1_GRPH_UPDATE                                                                             0x076a
#define mmDCP1_GRPH_UPDATE_BASE_IDX                                                                    2
#define mmDCP1_GRPH_FLIP_CONTROL                                                                       0x076b
#define mmDCP1_GRPH_FLIP_CONTROL_BASE_IDX                                                              2
#define mmDCP1_GRPH_SURFACE_ADDRESS_INUSE                                                              0x076c
#define mmDCP1_GRPH_SURFACE_ADDRESS_INUSE_BASE_IDX                                                     2
#define mmDCP1_GRPH_DFQ_CONTROL                                                                        0x076d
#define mmDCP1_GRPH_DFQ_CONTROL_BASE_IDX                                                               2
#define mmDCP1_GRPH_DFQ_STATUS                                                                         0x076e
#define mmDCP1_GRPH_DFQ_STATUS_BASE_IDX                                                                2
#define mmDCP1_GRPH_INTERRUPT_STATUS                                                                   0x076f
#define mmDCP1_GRPH_INTERRUPT_STATUS_BASE_IDX                                                          2
#define mmDCP1_GRPH_INTERRUPT_CONTROL                                                                  0x0770
#define mmDCP1_GRPH_INTERRUPT_CONTROL_BASE_IDX                                                         2
#define mmDCP1_GRPH_SURFACE_ADDRESS_HIGH_INUSE                                                         0x0771
#define mmDCP1_GRPH_SURFACE_ADDRESS_HIGH_INUSE_BASE_IDX                                                2
#define mmDCP1_GRPH_COMPRESS_SURFACE_ADDRESS                                                           0x0772
#define mmDCP1_GRPH_COMPRESS_SURFACE_ADDRESS_BASE_IDX                                                  2
#define mmDCP1_GRPH_COMPRESS_PITCH                                                                     0x0773
#define mmDCP1_GRPH_COMPRESS_PITCH_BASE_IDX                                                            2
#define mmDCP1_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH                                                      0x0774
#define mmDCP1_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH_BASE_IDX                                             2
#define mmDCP1_GRPH_PIPE_OUTSTANDING_REQUEST_LIMIT                                                     0x0775
#define mmDCP1_GRPH_PIPE_OUTSTANDING_REQUEST_LIMIT_BASE_IDX                                            2
#define mmDCP1_PRESCALE_GRPH_CONTROL                                                                   0x0776
#define mmDCP1_PRESCALE_GRPH_CONTROL_BASE_IDX                                                          2
#define mmDCP1_PRESCALE_VALUES_GRPH_R                                                                  0x0777
#define mmDCP1_PRESCALE_VALUES_GRPH_R_BASE_IDX                                                         2
#define mmDCP1_PRESCALE_VALUES_GRPH_G                                                                  0x0778
#define mmDCP1_PRESCALE_VALUES_GRPH_G_BASE_IDX                                                         2
#define mmDCP1_PRESCALE_VALUES_GRPH_B                                                                  0x0779
#define mmDCP1_PRESCALE_VALUES_GRPH_B_BASE_IDX                                                         2
#define mmDCP1_INPUT_CSC_CONTROL                                                                       0x077a
#define mmDCP1_INPUT_CSC_CONTROL_BASE_IDX                                                              2
#define mmDCP1_INPUT_CSC_C11_C12                                                                       0x077b
#define mmDCP1_INPUT_CSC_C11_C12_BASE_IDX                                                              2
#define mmDCP1_INPUT_CSC_C13_C14                                                                       0x077c
#define mmDCP1_INPUT_CSC_C13_C14_BASE_IDX                                                              2
#define mmDCP1_INPUT_CSC_C21_C22                                                                       0x077d
#define mmDCP1_INPUT_CSC_C21_C22_BASE_IDX                                                              2
#define mmDCP1_INPUT_CSC_C23_C24                                                                       0x077e
#define mmDCP1_INPUT_CSC_C23_C24_BASE_IDX                                                              2
#define mmDCP1_INPUT_CSC_C31_C32                                                                       0x077f
#define mmDCP1_INPUT_CSC_C31_C32_BASE_IDX                                                              2
#define mmDCP1_INPUT_CSC_C33_C34                                                                       0x0780
#define mmDCP1_INPUT_CSC_C33_C34_BASE_IDX                                                              2
#define mmDCP1_OUTPUT_CSC_CONTROL                                                                      0x0781
#define mmDCP1_OUTPUT_CSC_CONTROL_BASE_IDX                                                             2
#define mmDCP1_OUTPUT_CSC_C11_C12                                                                      0x0782
#define mmDCP1_OUTPUT_CSC_C11_C12_BASE_IDX                                                             2
#define mmDCP1_OUTPUT_CSC_C13_C14                                                                      0x0783
#define mmDCP1_OUTPUT_CSC_C13_C14_BASE_IDX                                                             2
#define mmDCP1_OUTPUT_CSC_C21_C22                                                                      0x0784
#define mmDCP1_OUTPUT_CSC_C21_C22_BASE_IDX                                                             2
#define mmDCP1_OUTPUT_CSC_C23_C24                                                                      0x0785
#define mmDCP1_OUTPUT_CSC_C23_C24_BASE_IDX                                                             2
#define mmDCP1_OUTPUT_CSC_C31_C32                                                                      0x0786
#define mmDCP1_OUTPUT_CSC_C31_C32_BASE_IDX                                                             2
#define mmDCP1_OUTPUT_CSC_C33_C34                                                                      0x0787
#define mmDCP1_OUTPUT_CSC_C33_C34_BASE_IDX                                                             2
#define mmDCP1_COMM_MATRIXA_TRANS_C11_C12                                                              0x0788
#define mmDCP1_COMM_MATRIXA_TRANS_C11_C12_BASE_IDX                                                     2
#define mmDCP1_COMM_MATRIXA_TRANS_C13_C14                                                              0x0789
#define mmDCP1_COMM_MATRIXA_TRANS_C13_C14_BASE_IDX                                                     2
#define mmDCP1_COMM_MATRIXA_TRANS_C21_C22                                                              0x078a
#define mmDCP1_COMM_MATRIXA_TRANS_C21_C22_BASE_IDX                                                     2
#define mmDCP1_COMM_MATRIXA_TRANS_C23_C24                                                              0x078b
#define mmDCP1_COMM_MATRIXA_TRANS_C23_C24_BASE_IDX                                                     2
#define mmDCP1_COMM_MATRIXA_TRANS_C31_C32                                                              0x078c
#define mmDCP1_COMM_MATRIXA_TRANS_C31_C32_BASE_IDX                                                     2
#define mmDCP1_COMM_MATRIXA_TRANS_C33_C34                                                              0x078d
#define mmDCP1_COMM_MATRIXA_TRANS_C33_C34_BASE_IDX                                                     2
#define mmDCP1_COMM_MATRIXB_TRANS_C11_C12                                                              0x078e
#define mmDCP1_COMM_MATRIXB_TRANS_C11_C12_BASE_IDX                                                     2
#define mmDCP1_COMM_MATRIXB_TRANS_C13_C14                                                              0x078f
#define mmDCP1_COMM_MATRIXB_TRANS_C13_C14_BASE_IDX                                                     2
#define mmDCP1_COMM_MATRIXB_TRANS_C21_C22                                                              0x0790
#define mmDCP1_COMM_MATRIXB_TRANS_C21_C22_BASE_IDX                                                     2
#define mmDCP1_COMM_MATRIXB_TRANS_C23_C24                                                              0x0791
#define mmDCP1_COMM_MATRIXB_TRANS_C23_C24_BASE_IDX                                                     2
#define mmDCP1_COMM_MATRIXB_TRANS_C31_C32                                                              0x0792
#define mmDCP1_COMM_MATRIXB_TRANS_C31_C32_BASE_IDX                                                     2
#define mmDCP1_COMM_MATRIXB_TRANS_C33_C34                                                              0x0793
#define mmDCP1_COMM_MATRIXB_TRANS_C33_C34_BASE_IDX                                                     2
#define mmDCP1_DENORM_CONTROL                                                                          0x0794
#define mmDCP1_DENORM_CONTROL_BASE_IDX                                                                 2
#define mmDCP1_OUT_ROUND_CONTROL                                                                       0x0795
#define mmDCP1_OUT_ROUND_CONTROL_BASE_IDX                                                              2
#define mmDCP1_OUT_CLAMP_CONTROL_R_CR                                                                  0x0796
#define mmDCP1_OUT_CLAMP_CONTROL_R_CR_BASE_IDX                                                         2
#define mmDCP1_OUT_CLAMP_CONTROL_G_Y                                                                   0x0797
#define mmDCP1_OUT_CLAMP_CONTROL_G_Y_BASE_IDX                                                          2
#define mmDCP1_OUT_CLAMP_CONTROL_B_CB                                                                  0x0798
#define mmDCP1_OUT_CLAMP_CONTROL_B_CB_BASE_IDX                                                         2
#define mmDCP1_KEY_CONTROL                                                                             0x0799
#define mmDCP1_KEY_CONTROL_BASE_IDX                                                                    2
#define mmDCP1_KEY_RANGE_ALPHA                                                                         0x079a
#define mmDCP1_KEY_RANGE_ALPHA_BASE_IDX                                                                2
#define mmDCP1_KEY_RANGE_RED                                                                           0x079b
#define mmDCP1_KEY_RANGE_RED_BASE_IDX                                                                  2
#define mmDCP1_KEY_RANGE_GREEN                                                                         0x079c
#define mmDCP1_KEY_RANGE_GREEN_BASE_IDX                                                                2
#define mmDCP1_KEY_RANGE_BLUE                                                                          0x079d
#define mmDCP1_KEY_RANGE_BLUE_BASE_IDX                                                                 2
#define mmDCP1_DEGAMMA_CONTROL                                                                         0x079e
#define mmDCP1_DEGAMMA_CONTROL_BASE_IDX                                                                2
#define mmDCP1_GAMUT_REMAP_CONTROL                                                                     0x079f
#define mmDCP1_GAMUT_REMAP_CONTROL_BASE_IDX                                                            2
#define mmDCP1_GAMUT_REMAP_C11_C12                                                                     0x07a0
#define mmDCP1_GAMUT_REMAP_C11_C12_BASE_IDX                                                            2
#define mmDCP1_GAMUT_REMAP_C13_C14                                                                     0x07a1
#define mmDCP1_GAMUT_REMAP_C13_C14_BASE_IDX                                                            2
#define mmDCP1_GAMUT_REMAP_C21_C22                                                                     0x07a2
#define mmDCP1_GAMUT_REMAP_C21_C22_BASE_IDX                                                            2
#define mmDCP1_GAMUT_REMAP_C23_C24                                                                     0x07a3
#define mmDCP1_GAMUT_REMAP_C23_C24_BASE_IDX                                                            2
#define mmDCP1_GAMUT_REMAP_C31_C32                                                                     0x07a4
#define mmDCP1_GAMUT_REMAP_C31_C32_BASE_IDX                                                            2
#define mmDCP1_GAMUT_REMAP_C33_C34                                                                     0x07a5
#define mmDCP1_GAMUT_REMAP_C33_C34_BASE_IDX                                                            2
#define mmDCP1_DCP_SPATIAL_DITHER_CNTL                                                                 0x07a6
#define mmDCP1_DCP_SPATIAL_DITHER_CNTL_BASE_IDX                                                        2
#define mmDCP1_DCP_RANDOM_SEEDS                                                                        0x07a7
#define mmDCP1_DCP_RANDOM_SEEDS_BASE_IDX                                                               2
#define mmDCP1_DCP_FP_CONVERTED_FIELD                                                                  0x07a8
#define mmDCP1_DCP_FP_CONVERTED_FIELD_BASE_IDX                                                         2
#define mmDCP1_CUR_CONTROL                                                                             0x07a9
#define mmDCP1_CUR_CONTROL_BASE_IDX                                                                    2
#define mmDCP1_CUR_SURFACE_ADDRESS                                                                     0x07aa
#define mmDCP1_CUR_SURFACE_ADDRESS_BASE_IDX                                                            2
#define mmDCP1_CUR_SIZE                                                                                0x07ab
#define mmDCP1_CUR_SIZE_BASE_IDX                                                                       2
#define mmDCP1_CUR_SURFACE_ADDRESS_HIGH                                                                0x07ac
#define mmDCP1_CUR_SURFACE_ADDRESS_HIGH_BASE_IDX                                                       2
#define mmDCP1_CUR_POSITION                                                                            0x07ad
#define mmDCP1_CUR_POSITION_BASE_IDX                                                                   2
#define mmDCP1_CUR_HOT_SPOT                                                                            0x07ae
#define mmDCP1_CUR_HOT_SPOT_BASE_IDX                                                                   2
#define mmDCP1_CUR_COLOR1                                                                              0x07af
#define mmDCP1_CUR_COLOR1_BASE_IDX                                                                     2
#define mmDCP1_CUR_COLOR2                                                                              0x07b0
#define mmDCP1_CUR_COLOR2_BASE_IDX                                                                     2
#define mmDCP1_CUR_UPDATE                                                                              0x07b1
#define mmDCP1_CUR_UPDATE_BASE_IDX                                                                     2
#define mmDCP1_CUR_REQUEST_FILTER_CNTL                                                                 0x07bb
#define mmDCP1_CUR_REQUEST_FILTER_CNTL_BASE_IDX                                                        2
#define mmDCP1_CUR_STEREO_CONTROL                                                                      0x07bc
#define mmDCP1_CUR_STEREO_CONTROL_BASE_IDX                                                             2
#define mmDCP1_DC_LUT_RW_MODE                                                                          0x07be
#define mmDCP1_DC_LUT_RW_MODE_BASE_IDX                                                                 2
#define mmDCP1_DC_LUT_RW_INDEX                                                                         0x07bf
#define mmDCP1_DC_LUT_RW_INDEX_BASE_IDX                                                                2
#define mmDCP1_DC_LUT_SEQ_COLOR                                                                        0x07c0
#define mmDCP1_DC_LUT_SEQ_COLOR_BASE_IDX                                                               2
#define mmDCP1_DC_LUT_PWL_DATA                                                                         0x07c1
#define mmDCP1_DC_LUT_PWL_DATA_BASE_IDX                                                                2
#define mmDCP1_DC_LUT_30_COLOR                                                                         0x07c2
#define mmDCP1_DC_LUT_30_COLOR_BASE_IDX                                                                2
#define mmDCP1_DC_LUT_VGA_ACCESS_ENABLE                                                                0x07c3
#define mmDCP1_DC_LUT_VGA_ACCESS_ENABLE_BASE_IDX                                                       2
#define mmDCP1_DC_LUT_WRITE_EN_MASK                                                                    0x07c4
#define mmDCP1_DC_LUT_WRITE_EN_MASK_BASE_IDX                                                           2
#define mmDCP1_DC_LUT_AUTOFILL                                                                         0x07c5
#define mmDCP1_DC_LUT_AUTOFILL_BASE_IDX                                                                2
#define mmDCP1_DC_LUT_CONTROL                                                                          0x07c6
#define mmDCP1_DC_LUT_CONTROL_BASE_IDX                                                                 2
#define mmDCP1_DC_LUT_BLACK_OFFSET_BLUE                                                                0x07c7
#define mmDCP1_DC_LUT_BLACK_OFFSET_BLUE_BASE_IDX                                                       2
#define mmDCP1_DC_LUT_BLACK_OFFSET_GREEN                                                               0x07c8
#define mmDCP1_DC_LUT_BLACK_OFFSET_GREEN_BASE_IDX                                                      2
#define mmDCP1_DC_LUT_BLACK_OFFSET_RED                                                                 0x07c9
#define mmDCP1_DC_LUT_BLACK_OFFSET_RED_BASE_IDX                                                        2
#define mmDCP1_DC_LUT_WHITE_OFFSET_BLUE                                                                0x07ca
#define mmDCP1_DC_LUT_WHITE_OFFSET_BLUE_BASE_IDX                                                       2
#define mmDCP1_DC_LUT_WHITE_OFFSET_GREEN                                                               0x07cb
#define mmDCP1_DC_LUT_WHITE_OFFSET_GREEN_BASE_IDX                                                      2
#define mmDCP1_DC_LUT_WHITE_OFFSET_RED                                                                 0x07cc
#define mmDCP1_DC_LUT_WHITE_OFFSET_RED_BASE_IDX                                                        2
#define mmDCP1_DCP_CRC_CONTROL                                                                         0x07cd
#define mmDCP1_DCP_CRC_CONTROL_BASE_IDX                                                                2
#define mmDCP1_DCP_CRC_MASK                                                                            0x07ce
#define mmDCP1_DCP_CRC_MASK_BASE_IDX                                                                   2
#define mmDCP1_DCP_CRC_CURRENT                                                                         0x07cf
#define mmDCP1_DCP_CRC_CURRENT_BASE_IDX                                                                2
#define mmDCP1_DVMM_PTE_CONTROL                                                                        0x07d0
#define mmDCP1_DVMM_PTE_CONTROL_BASE_IDX                                                               2
#define mmDCP1_DCP_CRC_LAST                                                                            0x07d1
#define mmDCP1_DCP_CRC_LAST_BASE_IDX                                                                   2
#define mmDCP1_DVMM_PTE_ARB_CONTROL                                                                    0x07d2
#define mmDCP1_DVMM_PTE_ARB_CONTROL_BASE_IDX                                                           2
#define mmDCP1_GRPH_FLIP_RATE_CNTL                                                                     0x07d4
#define mmDCP1_GRPH_FLIP_RATE_CNTL_BASE_IDX                                                            2
#define mmDCP1_DCP_GSL_CONTROL                                                                         0x07d5
#define mmDCP1_DCP_GSL_CONTROL_BASE_IDX                                                                2
#define mmDCP1_DCP_LB_DATA_GAP_BETWEEN_CHUNK                                                           0x07d6
#define mmDCP1_DCP_LB_DATA_GAP_BETWEEN_CHUNK_BASE_IDX                                                  2
#define mmDCP1_GRPH_STEREOSYNC_FLIP                                                                    0x07dc
#define mmDCP1_GRPH_STEREOSYNC_FLIP_BASE_IDX                                                           2
#define mmDCP1_HW_ROTATION                                                                             0x07de
#define mmDCP1_HW_ROTATION_BASE_IDX                                                                    2
#define mmDCP1_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL                                                      0x07df
#define mmDCP1_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL_BASE_IDX                                             2
#define mmDCP1_REGAMMA_CONTROL                                                                         0x07e0
#define mmDCP1_REGAMMA_CONTROL_BASE_IDX                                                                2
#define mmDCP1_REGAMMA_LUT_INDEX                                                                       0x07e1
#define mmDCP1_REGAMMA_LUT_INDEX_BASE_IDX                                                              2
#define mmDCP1_REGAMMA_LUT_DATA                                                                        0x07e2
#define mmDCP1_REGAMMA_LUT_DATA_BASE_IDX                                                               2
#define mmDCP1_REGAMMA_LUT_WRITE_EN_MASK                                                               0x07e3
#define mmDCP1_REGAMMA_LUT_WRITE_EN_MASK_BASE_IDX                                                      2
#define mmDCP1_REGAMMA_CNTLA_START_CNTL                                                                0x07e4
#define mmDCP1_REGAMMA_CNTLA_START_CNTL_BASE_IDX                                                       2
#define mmDCP1_REGAMMA_CNTLA_SLOPE_CNTL                                                                0x07e5
#define mmDCP1_REGAMMA_CNTLA_SLOPE_CNTL_BASE_IDX                                                       2
#define mmDCP1_REGAMMA_CNTLA_END_CNTL1                                                                 0x07e6
#define mmDCP1_REGAMMA_CNTLA_END_CNTL1_BASE_IDX                                                        2
#define mmDCP1_REGAMMA_CNTLA_END_CNTL2                                                                 0x07e7
#define mmDCP1_REGAMMA_CNTLA_END_CNTL2_BASE_IDX                                                        2
#define mmDCP1_REGAMMA_CNTLA_REGION_0_1                                                                0x07e8
#define mmDCP1_REGAMMA_CNTLA_REGION_0_1_BASE_IDX                                                       2
#define mmDCP1_REGAMMA_CNTLA_REGION_2_3                                                                0x07e9
#define mmDCP1_REGAMMA_CNTLA_REGION_2_3_BASE_IDX                                                       2
#define mmDCP1_REGAMMA_CNTLA_REGION_4_5                                                                0x07ea
#define mmDCP1_REGAMMA_CNTLA_REGION_4_5_BASE_IDX                                                       2
#define mmDCP1_REGAMMA_CNTLA_REGION_6_7                                                                0x07eb
#define mmDCP1_REGAMMA_CNTLA_REGION_6_7_BASE_IDX                                                       2
#define mmDCP1_REGAMMA_CNTLA_REGION_8_9                                                                0x07ec
#define mmDCP1_REGAMMA_CNTLA_REGION_8_9_BASE_IDX                                                       2
#define mmDCP1_REGAMMA_CNTLA_REGION_10_11                                                              0x07ed
#define mmDCP1_REGAMMA_CNTLA_REGION_10_11_BASE_IDX                                                     2
#define mmDCP1_REGAMMA_CNTLA_REGION_12_13                                                              0x07ee
#define mmDCP1_REGAMMA_CNTLA_REGION_12_13_BASE_IDX                                                     2
#define mmDCP1_REGAMMA_CNTLA_REGION_14_15                                                              0x07ef
#define mmDCP1_REGAMMA_CNTLA_REGION_14_15_BASE_IDX                                                     2
#define mmDCP1_REGAMMA_CNTLB_START_CNTL                                                                0x07f0
#define mmDCP1_REGAMMA_CNTLB_START_CNTL_BASE_IDX                                                       2
#define mmDCP1_REGAMMA_CNTLB_SLOPE_CNTL                                                                0x07f1
#define mmDCP1_REGAMMA_CNTLB_SLOPE_CNTL_BASE_IDX                                                       2
#define mmDCP1_REGAMMA_CNTLB_END_CNTL1                                                                 0x07f2
#define mmDCP1_REGAMMA_CNTLB_END_CNTL1_BASE_IDX                                                        2
#define mmDCP1_REGAMMA_CNTLB_END_CNTL2                                                                 0x07f3
#define mmDCP1_REGAMMA_CNTLB_END_CNTL2_BASE_IDX                                                        2
#define mmDCP1_REGAMMA_CNTLB_REGION_0_1                                                                0x07f4
#define mmDCP1_REGAMMA_CNTLB_REGION_0_1_BASE_IDX                                                       2
#define mmDCP1_REGAMMA_CNTLB_REGION_2_3                                                                0x07f5
#define mmDCP1_REGAMMA_CNTLB_REGION_2_3_BASE_IDX                                                       2
#define mmDCP1_REGAMMA_CNTLB_REGION_4_5                                                                0x07f6
#define mmDCP1_REGAMMA_CNTLB_REGION_4_5_BASE_IDX                                                       2
#define mmDCP1_REGAMMA_CNTLB_REGION_6_7                                                                0x07f7
#define mmDCP1_REGAMMA_CNTLB_REGION_6_7_BASE_IDX                                                       2
#define mmDCP1_REGAMMA_CNTLB_REGION_8_9                                                                0x07f8
#define mmDCP1_REGAMMA_CNTLB_REGION_8_9_BASE_IDX                                                       2
#define mmDCP1_REGAMMA_CNTLB_REGION_10_11                                                              0x07f9
#define mmDCP1_REGAMMA_CNTLB_REGION_10_11_BASE_IDX                                                     2
#define mmDCP1_REGAMMA_CNTLB_REGION_12_13                                                              0x07fa
#define mmDCP1_REGAMMA_CNTLB_REGION_12_13_BASE_IDX                                                     2
#define mmDCP1_REGAMMA_CNTLB_REGION_14_15                                                              0x07fb
#define mmDCP1_REGAMMA_CNTLB_REGION_14_15_BASE_IDX                                                     2
#define mmDCP1_ALPHA_CONTROL                                                                           0x07fc
#define mmDCP1_ALPHA_CONTROL_BASE_IDX                                                                  2
#define mmDCP1_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS                                                      0x07fd
#define mmDCP1_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_BASE_IDX                                             2
#define mmDCP1_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH                                                 0x07fe
#define mmDCP1_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH_BASE_IDX                                        2
#define mmDCP1_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS                                                    0x07ff
#define mmDCP1_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS_BASE_IDX                                           2
#define mmDCP1_GRPH_XDMA_FLIP_TIMEOUT                                                                  0x0800
#define mmDCP1_GRPH_XDMA_FLIP_TIMEOUT_BASE_IDX                                                         2
#define mmDCP1_GRPH_XDMA_FLIP_AVG_DELAY                                                                0x0801
#define mmDCP1_GRPH_XDMA_FLIP_AVG_DELAY_BASE_IDX                                                       2
#define mmDCP1_GRPH_SURFACE_COUNTER_CONTROL                                                            0x0802
#define mmDCP1_GRPH_SURFACE_COUNTER_CONTROL_BASE_IDX                                                   2
#define mmDCP1_GRPH_SURFACE_COUNTER_OUTPUT                                                             0x0803
#define mmDCP1_GRPH_SURFACE_COUNTER_OUTPUT_BASE_IDX                                                    2


// addressBlock: dce_dc_lb1_dispdec
// base address: 0x800
#define mmLB1_LB_DATA_FORMAT                                                                           0x081a
#define mmLB1_LB_DATA_FORMAT_BASE_IDX                                                                  2
#define mmLB1_LB_MEMORY_CTRL                                                                           0x081b
#define mmLB1_LB_MEMORY_CTRL_BASE_IDX                                                                  2
#define mmLB1_LB_MEMORY_SIZE_STATUS                                                                    0x081c
#define mmLB1_LB_MEMORY_SIZE_STATUS_BASE_IDX                                                           2
#define mmLB1_LB_DESKTOP_HEIGHT                                                                        0x081d
#define mmLB1_LB_DESKTOP_HEIGHT_BASE_IDX                                                               2
#define mmLB1_LB_VLINE_START_END                                                                       0x081e
#define mmLB1_LB_VLINE_START_END_BASE_IDX                                                              2
#define mmLB1_LB_VLINE2_START_END                                                                      0x081f
#define mmLB1_LB_VLINE2_START_END_BASE_IDX                                                             2
#define mmLB1_LB_V_COUNTER                                                                             0x0820
#define mmLB1_LB_V_COUNTER_BASE_IDX                                                                    2
#define mmLB1_LB_SNAPSHOT_V_COUNTER                                                                    0x0821
#define mmLB1_LB_SNAPSHOT_V_COUNTER_BASE_IDX                                                           2
#define mmLB1_LB_INTERRUPT_MASK                                                                        0x0822
#define mmLB1_LB_INTERRUPT_MASK_BASE_IDX                                                               2
#define mmLB1_LB_VLINE_STATUS                                                                          0x0823
#define mmLB1_LB_VLINE_STATUS_BASE_IDX                                                                 2
#define mmLB1_LB_VLINE2_STATUS                                                                         0x0824
#define mmLB1_LB_VLINE2_STATUS_BASE_IDX                                                                2
#define mmLB1_LB_VBLANK_STATUS                                                                         0x0825
#define mmLB1_LB_VBLANK_STATUS_BASE_IDX                                                                2
#define mmLB1_LB_SYNC_RESET_SEL                                                                        0x0826
#define mmLB1_LB_SYNC_RESET_SEL_BASE_IDX                                                               2
#define mmLB1_LB_BLACK_KEYER_R_CR                                                                      0x0827
#define mmLB1_LB_BLACK_KEYER_R_CR_BASE_IDX                                                             2
#define mmLB1_LB_BLACK_KEYER_G_Y                                                                       0x0828
#define mmLB1_LB_BLACK_KEYER_G_Y_BASE_IDX                                                              2
#define mmLB1_LB_BLACK_KEYER_B_CB                                                                      0x0829
#define mmLB1_LB_BLACK_KEYER_B_CB_BASE_IDX                                                             2
#define mmLB1_LB_KEYER_COLOR_CTRL                                                                      0x082a
#define mmLB1_LB_KEYER_COLOR_CTRL_BASE_IDX                                                             2
#define mmLB1_LB_KEYER_COLOR_R_CR                                                                      0x082b
#define mmLB1_LB_KEYER_COLOR_R_CR_BASE_IDX                                                             2
#define mmLB1_LB_KEYER_COLOR_G_Y                                                                       0x082c
#define mmLB1_LB_KEYER_COLOR_G_Y_BASE_IDX                                                              2
#define mmLB1_LB_KEYER_COLOR_B_CB                                                                      0x082d
#define mmLB1_LB_KEYER_COLOR_B_CB_BASE_IDX                                                             2
#define mmLB1_LB_KEYER_COLOR_REP_R_CR                                                                  0x082e
#define mmLB1_LB_KEYER_COLOR_REP_R_CR_BASE_IDX                                                         2
#define mmLB1_LB_KEYER_COLOR_REP_G_Y                                                                   0x082f
#define mmLB1_LB_KEYER_COLOR_REP_G_Y_BASE_IDX                                                          2
#define mmLB1_LB_KEYER_COLOR_REP_B_CB                                                                  0x0830
#define mmLB1_LB_KEYER_COLOR_REP_B_CB_BASE_IDX                                                         2
#define mmLB1_LB_BUFFER_LEVEL_STATUS                                                                   0x0831
#define mmLB1_LB_BUFFER_LEVEL_STATUS_BASE_IDX                                                          2
#define mmLB1_LB_BUFFER_URGENCY_CTRL                                                                   0x0832
#define mmLB1_LB_BUFFER_URGENCY_CTRL_BASE_IDX                                                          2
#define mmLB1_LB_BUFFER_URGENCY_STATUS                                                                 0x0833
#define mmLB1_LB_BUFFER_URGENCY_STATUS_BASE_IDX                                                        2
#define mmLB1_LB_BUFFER_STATUS                                                                         0x0834
#define mmLB1_LB_BUFFER_STATUS_BASE_IDX                                                                2
#define mmLB1_LB_NO_OUTSTANDING_REQ_STATUS                                                             0x0835
#define mmLB1_LB_NO_OUTSTANDING_REQ_STATUS_BASE_IDX                                                    2
#define mmLB1_MVP_AFR_FLIP_MODE                                                                        0x0836
#define mmLB1_MVP_AFR_FLIP_MODE_BASE_IDX                                                               2
#define mmLB1_MVP_AFR_FLIP_FIFO_CNTL                                                                   0x0837
#define mmLB1_MVP_AFR_FLIP_FIFO_CNTL_BASE_IDX                                                          2
#define mmLB1_MVP_FLIP_LINE_NUM_INSERT                                                                 0x0838
#define mmLB1_MVP_FLIP_LINE_NUM_INSERT_BASE_IDX                                                        2
#define mmLB1_DC_MVP_LB_CONTROL                                                                        0x0839
#define mmLB1_DC_MVP_LB_CONTROL_BASE_IDX                                                               2


// addressBlock: dce_dc_dcfe1_dispdec
// base address: 0x800
#define mmDCFE1_DCFE_CLOCK_CONTROL                                                                     0x085a
#define mmDCFE1_DCFE_CLOCK_CONTROL_BASE_IDX                                                            2
#define mmDCFE1_DCFE_SOFT_RESET                                                                        0x085b
#define mmDCFE1_DCFE_SOFT_RESET_BASE_IDX                                                               2
#define mmDCFE1_DCFE_MEM_PWR_CTRL                                                                      0x085d
#define mmDCFE1_DCFE_MEM_PWR_CTRL_BASE_IDX                                                             2
#define mmDCFE1_DCFE_MEM_PWR_CTRL2                                                                     0x085e
#define mmDCFE1_DCFE_MEM_PWR_CTRL2_BASE_IDX                                                            2
#define mmDCFE1_DCFE_MEM_PWR_STATUS                                                                    0x085f
#define mmDCFE1_DCFE_MEM_PWR_STATUS_BASE_IDX                                                           2
#define mmDCFE1_DCFE_MISC                                                                              0x0860
#define mmDCFE1_DCFE_MISC_BASE_IDX                                                                     2
#define mmDCFE1_DCFE_FLUSH                                                                             0x0861
#define mmDCFE1_DCFE_FLUSH_BASE_IDX                                                                    2


// addressBlock: dce_dc_dc_perfmon4_dispdec
// base address: 0x2138
#define mmDC_PERFMON4_PERFCOUNTER_CNTL                                                                 0x086e
#define mmDC_PERFMON4_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON4_PERFCOUNTER_CNTL2                                                                0x086f
#define mmDC_PERFMON4_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON4_PERFCOUNTER_STATE                                                                0x0870
#define mmDC_PERFMON4_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON4_PERFMON_CNTL                                                                     0x0871
#define mmDC_PERFMON4_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON4_PERFMON_CNTL2                                                                    0x0872
#define mmDC_PERFMON4_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON4_PERFMON_CVALUE_INT_MISC                                                          0x0873
#define mmDC_PERFMON4_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON4_PERFMON_CVALUE_LOW                                                               0x0874
#define mmDC_PERFMON4_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON4_PERFMON_HI                                                                       0x0875
#define mmDC_PERFMON4_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON4_PERFMON_LOW                                                                      0x0876
#define mmDC_PERFMON4_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dmif_pg1_dispdec
// base address: 0x800
#define mmDMIF_PG1_DPG_PIPE_ARBITRATION_CONTROL1                                                       0x087a
#define mmDMIF_PG1_DPG_PIPE_ARBITRATION_CONTROL1_BASE_IDX                                              2
#define mmDMIF_PG1_DPG_PIPE_ARBITRATION_CONTROL2                                                       0x087b
#define mmDMIF_PG1_DPG_PIPE_ARBITRATION_CONTROL2_BASE_IDX                                              2
#define mmDMIF_PG1_DPG_WATERMARK_MASK_CONTROL                                                          0x087c
#define mmDMIF_PG1_DPG_WATERMARK_MASK_CONTROL_BASE_IDX                                                 2
#define mmDMIF_PG1_DPG_PIPE_URGENCY_CONTROL                                                            0x087d
#define mmDMIF_PG1_DPG_PIPE_URGENCY_CONTROL_BASE_IDX                                                   2
#define mmDMIF_PG1_DPG_PIPE_URGENT_LEVEL_CONTROL                                                       0x087e
#define mmDMIF_PG1_DPG_PIPE_URGENT_LEVEL_CONTROL_BASE_IDX                                              2
#define mmDMIF_PG1_DPG_PIPE_STUTTER_CONTROL                                                            0x087f
#define mmDMIF_PG1_DPG_PIPE_STUTTER_CONTROL_BASE_IDX                                                   2
#define mmDMIF_PG1_DPG_PIPE_STUTTER_CONTROL2                                                           0x0880
#define mmDMIF_PG1_DPG_PIPE_STUTTER_CONTROL2_BASE_IDX                                                  2
#define mmDMIF_PG1_DPG_PIPE_LOW_POWER_CONTROL                                                          0x0881
#define mmDMIF_PG1_DPG_PIPE_LOW_POWER_CONTROL_BASE_IDX                                                 2
#define mmDMIF_PG1_DPG_REPEATER_PROGRAM                                                                0x0882
#define mmDMIF_PG1_DPG_REPEATER_PROGRAM_BASE_IDX                                                       2
#define mmDMIF_PG1_DPG_CHK_PRE_PROC_CNTL                                                               0x0886
#define mmDMIF_PG1_DPG_CHK_PRE_PROC_CNTL_BASE_IDX                                                      2
#define mmDMIF_PG1_DPG_DVMM_STATUS                                                                     0x0887
#define mmDMIF_PG1_DPG_DVMM_STATUS_BASE_IDX                                                            2


// addressBlock: dce_dc_scl1_dispdec
// base address: 0x800
#define mmSCL1_SCL_COEF_RAM_SELECT                                                                     0x089a
#define mmSCL1_SCL_COEF_RAM_SELECT_BASE_IDX                                                            2
#define mmSCL1_SCL_COEF_RAM_TAP_DATA                                                                   0x089b
#define mmSCL1_SCL_COEF_RAM_TAP_DATA_BASE_IDX                                                          2
#define mmSCL1_SCL_MODE                                                                                0x089c
#define mmSCL1_SCL_MODE_BASE_IDX                                                                       2
#define mmSCL1_SCL_TAP_CONTROL                                                                         0x089d
#define mmSCL1_SCL_TAP_CONTROL_BASE_IDX                                                                2
#define mmSCL1_SCL_CONTROL                                                                             0x089e
#define mmSCL1_SCL_CONTROL_BASE_IDX                                                                    2
#define mmSCL1_SCL_BYPASS_CONTROL                                                                      0x089f
#define mmSCL1_SCL_BYPASS_CONTROL_BASE_IDX                                                             2
#define mmSCL1_SCL_MANUAL_REPLICATE_CONTROL                                                            0x08a0
#define mmSCL1_SCL_MANUAL_REPLICATE_CONTROL_BASE_IDX                                                   2
#define mmSCL1_SCL_AUTOMATIC_MODE_CONTROL                                                              0x08a1
#define mmSCL1_SCL_AUTOMATIC_MODE_CONTROL_BASE_IDX                                                     2
#define mmSCL1_SCL_HORZ_FILTER_CONTROL                                                                 0x08a2
#define mmSCL1_SCL_HORZ_FILTER_CONTROL_BASE_IDX                                                        2
#define mmSCL1_SCL_HORZ_FILTER_SCALE_RATIO                                                             0x08a3
#define mmSCL1_SCL_HORZ_FILTER_SCALE_RATIO_BASE_IDX                                                    2
#define mmSCL1_SCL_HORZ_FILTER_INIT                                                                    0x08a4
#define mmSCL1_SCL_HORZ_FILTER_INIT_BASE_IDX                                                           2
#define mmSCL1_SCL_VERT_FILTER_CONTROL                                                                 0x08a5
#define mmSCL1_SCL_VERT_FILTER_CONTROL_BASE_IDX                                                        2
#define mmSCL1_SCL_VERT_FILTER_SCALE_RATIO                                                             0x08a6
#define mmSCL1_SCL_VERT_FILTER_SCALE_RATIO_BASE_IDX                                                    2
#define mmSCL1_SCL_VERT_FILTER_INIT                                                                    0x08a7
#define mmSCL1_SCL_VERT_FILTER_INIT_BASE_IDX                                                           2
#define mmSCL1_SCL_VERT_FILTER_INIT_BOT                                                                0x08a8
#define mmSCL1_SCL_VERT_FILTER_INIT_BOT_BASE_IDX                                                       2
#define mmSCL1_SCL_ROUND_OFFSET                                                                        0x08a9
#define mmSCL1_SCL_ROUND_OFFSET_BASE_IDX                                                               2
#define mmSCL1_SCL_UPDATE                                                                              0x08aa
#define mmSCL1_SCL_UPDATE_BASE_IDX                                                                     2
#define mmSCL1_SCL_F_SHARP_CONTROL                                                                     0x08ab
#define mmSCL1_SCL_F_SHARP_CONTROL_BASE_IDX                                                            2
#define mmSCL1_SCL_ALU_CONTROL                                                                         0x08ac
#define mmSCL1_SCL_ALU_CONTROL_BASE_IDX                                                                2
#define mmSCL1_SCL_COEF_RAM_CONFLICT_STATUS                                                            0x08ad
#define mmSCL1_SCL_COEF_RAM_CONFLICT_STATUS_BASE_IDX                                                   2
#define mmSCL1_VIEWPORT_START_SECONDARY                                                                0x08ae
#define mmSCL1_VIEWPORT_START_SECONDARY_BASE_IDX                                                       2
#define mmSCL1_VIEWPORT_START                                                                          0x08af
#define mmSCL1_VIEWPORT_START_BASE_IDX                                                                 2
#define mmSCL1_VIEWPORT_SIZE                                                                           0x08b0
#define mmSCL1_VIEWPORT_SIZE_BASE_IDX                                                                  2
#define mmSCL1_EXT_OVERSCAN_LEFT_RIGHT                                                                 0x08b1
#define mmSCL1_EXT_OVERSCAN_LEFT_RIGHT_BASE_IDX                                                        2
#define mmSCL1_EXT_OVERSCAN_TOP_BOTTOM                                                                 0x08b2
#define mmSCL1_EXT_OVERSCAN_TOP_BOTTOM_BASE_IDX                                                        2
#define mmSCL1_SCL_MODE_CHANGE_DET1                                                                    0x08b3
#define mmSCL1_SCL_MODE_CHANGE_DET1_BASE_IDX                                                           2
#define mmSCL1_SCL_MODE_CHANGE_DET2                                                                    0x08b4
#define mmSCL1_SCL_MODE_CHANGE_DET2_BASE_IDX                                                           2
#define mmSCL1_SCL_MODE_CHANGE_DET3                                                                    0x08b5
#define mmSCL1_SCL_MODE_CHANGE_DET3_BASE_IDX                                                           2
#define mmSCL1_SCL_MODE_CHANGE_MASK                                                                    0x08b6
#define mmSCL1_SCL_MODE_CHANGE_MASK_BASE_IDX                                                           2


// addressBlock: dce_dc_blnd1_dispdec
// base address: 0x800
#define mmBLND1_BLND_CONTROL                                                                           0x08c7
#define mmBLND1_BLND_CONTROL_BASE_IDX                                                                  2
#define mmBLND1_BLND_SM_CONTROL2                                                                       0x08c8
#define mmBLND1_BLND_SM_CONTROL2_BASE_IDX                                                              2
#define mmBLND1_BLND_CONTROL2                                                                          0x08c9
#define mmBLND1_BLND_CONTROL2_BASE_IDX                                                                 2
#define mmBLND1_BLND_UPDATE                                                                            0x08ca
#define mmBLND1_BLND_UPDATE_BASE_IDX                                                                   2
#define mmBLND1_BLND_UNDERFLOW_INTERRUPT                                                               0x08cb
#define mmBLND1_BLND_UNDERFLOW_INTERRUPT_BASE_IDX                                                      2
#define mmBLND1_BLND_V_UPDATE_LOCK                                                                     0x08cc
#define mmBLND1_BLND_V_UPDATE_LOCK_BASE_IDX                                                            2
#define mmBLND1_BLND_REG_UPDATE_STATUS                                                                 0x08cd
#define mmBLND1_BLND_REG_UPDATE_STATUS_BASE_IDX                                                        2


// addressBlock: dce_dc_crtc1_dispdec
// base address: 0x800
#define mmCRTC1_CRTC_H_BLANK_EARLY_NUM                                                                 0x08d2
#define mmCRTC1_CRTC_H_BLANK_EARLY_NUM_BASE_IDX                                                        2
#define mmCRTC1_CRTC_H_TOTAL                                                                           0x08d3
#define mmCRTC1_CRTC_H_TOTAL_BASE_IDX                                                                  2
#define mmCRTC1_CRTC_H_BLANK_START_END                                                                 0x08d4
#define mmCRTC1_CRTC_H_BLANK_START_END_BASE_IDX                                                        2
#define mmCRTC1_CRTC_H_SYNC_A                                                                          0x08d5
#define mmCRTC1_CRTC_H_SYNC_A_BASE_IDX                                                                 2
#define mmCRTC1_CRTC_H_SYNC_A_CNTL                                                                     0x08d6
#define mmCRTC1_CRTC_H_SYNC_A_CNTL_BASE_IDX                                                            2
#define mmCRTC1_CRTC_H_SYNC_B                                                                          0x08d7
#define mmCRTC1_CRTC_H_SYNC_B_BASE_IDX                                                                 2
#define mmCRTC1_CRTC_H_SYNC_B_CNTL                                                                     0x08d8
#define mmCRTC1_CRTC_H_SYNC_B_CNTL_BASE_IDX                                                            2
#define mmCRTC1_CRTC_VBI_END                                                                           0x08d9
#define mmCRTC1_CRTC_VBI_END_BASE_IDX                                                                  2
#define mmCRTC1_CRTC_V_TOTAL                                                                           0x08da
#define mmCRTC1_CRTC_V_TOTAL_BASE_IDX                                                                  2
#define mmCRTC1_CRTC_V_TOTAL_MIN                                                                       0x08db
#define mmCRTC1_CRTC_V_TOTAL_MIN_BASE_IDX                                                              2
#define mmCRTC1_CRTC_V_TOTAL_MAX                                                                       0x08dc
#define mmCRTC1_CRTC_V_TOTAL_MAX_BASE_IDX                                                              2
#define mmCRTC1_CRTC_V_TOTAL_CONTROL                                                                   0x08dd
#define mmCRTC1_CRTC_V_TOTAL_CONTROL_BASE_IDX                                                          2
#define mmCRTC1_CRTC_V_TOTAL_INT_STATUS                                                                0x08de
#define mmCRTC1_CRTC_V_TOTAL_INT_STATUS_BASE_IDX                                                       2
#define mmCRTC1_CRTC_VSYNC_NOM_INT_STATUS                                                              0x08df
#define mmCRTC1_CRTC_VSYNC_NOM_INT_STATUS_BASE_IDX                                                     2
#define mmCRTC1_CRTC_V_BLANK_START_END                                                                 0x08e0
#define mmCRTC1_CRTC_V_BLANK_START_END_BASE_IDX                                                        2
#define mmCRTC1_CRTC_V_SYNC_A                                                                          0x08e1
#define mmCRTC1_CRTC_V_SYNC_A_BASE_IDX                                                                 2
#define mmCRTC1_CRTC_V_SYNC_A_CNTL                                                                     0x08e2
#define mmCRTC1_CRTC_V_SYNC_A_CNTL_BASE_IDX                                                            2
#define mmCRTC1_CRTC_V_SYNC_B                                                                          0x08e3
#define mmCRTC1_CRTC_V_SYNC_B_BASE_IDX                                                                 2
#define mmCRTC1_CRTC_V_SYNC_B_CNTL                                                                     0x08e4
#define mmCRTC1_CRTC_V_SYNC_B_CNTL_BASE_IDX                                                            2
#define mmCRTC1_CRTC_DTMTEST_CNTL                                                                      0x08e5
#define mmCRTC1_CRTC_DTMTEST_CNTL_BASE_IDX                                                             2
#define mmCRTC1_CRTC_DTMTEST_STATUS_POSITION                                                           0x08e6
#define mmCRTC1_CRTC_DTMTEST_STATUS_POSITION_BASE_IDX                                                  2
#define mmCRTC1_CRTC_TRIGA_CNTL                                                                        0x08e7
#define mmCRTC1_CRTC_TRIGA_CNTL_BASE_IDX                                                               2
#define mmCRTC1_CRTC_TRIGA_MANUAL_TRIG                                                                 0x08e8
#define mmCRTC1_CRTC_TRIGA_MANUAL_TRIG_BASE_IDX                                                        2
#define mmCRTC1_CRTC_TRIGB_CNTL                                                                        0x08e9
#define mmCRTC1_CRTC_TRIGB_CNTL_BASE_IDX                                                               2
#define mmCRTC1_CRTC_TRIGB_MANUAL_TRIG                                                                 0x08ea
#define mmCRTC1_CRTC_TRIGB_MANUAL_TRIG_BASE_IDX                                                        2
#define mmCRTC1_CRTC_FORCE_COUNT_NOW_CNTL                                                              0x08eb
#define mmCRTC1_CRTC_FORCE_COUNT_NOW_CNTL_BASE_IDX                                                     2
#define mmCRTC1_CRTC_FLOW_CONTROL                                                                      0x08ec
#define mmCRTC1_CRTC_FLOW_CONTROL_BASE_IDX                                                             2
#define mmCRTC1_CRTC_STEREO_FORCE_NEXT_EYE                                                             0x08ed
#define mmCRTC1_CRTC_STEREO_FORCE_NEXT_EYE_BASE_IDX                                                    2
#define mmCRTC1_CRTC_AVSYNC_COUNTER                                                                    0x08ee
#define mmCRTC1_CRTC_AVSYNC_COUNTER_BASE_IDX                                                           2
#define mmCRTC1_CRTC_CONTROL                                                                           0x08ef
#define mmCRTC1_CRTC_CONTROL_BASE_IDX                                                                  2
#define mmCRTC1_CRTC_BLANK_CONTROL                                                                     0x08f0
#define mmCRTC1_CRTC_BLANK_CONTROL_BASE_IDX                                                            2
#define mmCRTC1_CRTC_INTERLACE_CONTROL                                                                 0x08f1
#define mmCRTC1_CRTC_INTERLACE_CONTROL_BASE_IDX                                                        2
#define mmCRTC1_CRTC_INTERLACE_STATUS                                                                  0x08f2
#define mmCRTC1_CRTC_INTERLACE_STATUS_BASE_IDX                                                         2
#define mmCRTC1_CRTC_FIELD_INDICATION_CONTROL                                                          0x08f3
#define mmCRTC1_CRTC_FIELD_INDICATION_CONTROL_BASE_IDX                                                 2
#define mmCRTC1_CRTC_PIXEL_DATA_READBACK0                                                              0x08f4
#define mmCRTC1_CRTC_PIXEL_DATA_READBACK0_BASE_IDX                                                     2
#define mmCRTC1_CRTC_PIXEL_DATA_READBACK1                                                              0x08f5
#define mmCRTC1_CRTC_PIXEL_DATA_READBACK1_BASE_IDX                                                     2
#define mmCRTC1_CRTC_STATUS                                                                            0x08f6
#define mmCRTC1_CRTC_STATUS_BASE_IDX                                                                   2
#define mmCRTC1_CRTC_STATUS_POSITION                                                                   0x08f7
#define mmCRTC1_CRTC_STATUS_POSITION_BASE_IDX                                                          2
#define mmCRTC1_CRTC_NOM_VERT_POSITION                                                                 0x08f8
#define mmCRTC1_CRTC_NOM_VERT_POSITION_BASE_IDX                                                        2
#define mmCRTC1_CRTC_STATUS_FRAME_COUNT                                                                0x08f9
#define mmCRTC1_CRTC_STATUS_FRAME_COUNT_BASE_IDX                                                       2
#define mmCRTC1_CRTC_STATUS_VF_COUNT                                                                   0x08fa
#define mmCRTC1_CRTC_STATUS_VF_COUNT_BASE_IDX                                                          2
#define mmCRTC1_CRTC_STATUS_HV_COUNT                                                                   0x08fb
#define mmCRTC1_CRTC_STATUS_HV_COUNT_BASE_IDX                                                          2
#define mmCRTC1_CRTC_COUNT_CONTROL                                                                     0x08fc
#define mmCRTC1_CRTC_COUNT_CONTROL_BASE_IDX                                                            2
#define mmCRTC1_CRTC_COUNT_RESET                                                                       0x08fd
#define mmCRTC1_CRTC_COUNT_RESET_BASE_IDX                                                              2
#define mmCRTC1_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE                                                      0x08fe
#define mmCRTC1_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE_BASE_IDX                                             2
#define mmCRTC1_CRTC_VERT_SYNC_CONTROL                                                                 0x08ff
#define mmCRTC1_CRTC_VERT_SYNC_CONTROL_BASE_IDX                                                        2
#define mmCRTC1_CRTC_STEREO_STATUS                                                                     0x0900
#define mmCRTC1_CRTC_STEREO_STATUS_BASE_IDX                                                            2
#define mmCRTC1_CRTC_STEREO_CONTROL                                                                    0x0901
#define mmCRTC1_CRTC_STEREO_CONTROL_BASE_IDX                                                           2
#define mmCRTC1_CRTC_SNAPSHOT_STATUS                                                                   0x0902
#define mmCRTC1_CRTC_SNAPSHOT_STATUS_BASE_IDX                                                          2
#define mmCRTC1_CRTC_SNAPSHOT_CONTROL                                                                  0x0903
#define mmCRTC1_CRTC_SNAPSHOT_CONTROL_BASE_IDX                                                         2
#define mmCRTC1_CRTC_SNAPSHOT_POSITION                                                                 0x0904
#define mmCRTC1_CRTC_SNAPSHOT_POSITION_BASE_IDX                                                        2
#define mmCRTC1_CRTC_SNAPSHOT_FRAME                                                                    0x0905
#define mmCRTC1_CRTC_SNAPSHOT_FRAME_BASE_IDX                                                           2
#define mmCRTC1_CRTC_START_LINE_CONTROL                                                                0x0906
#define mmCRTC1_CRTC_START_LINE_CONTROL_BASE_IDX                                                       2
#define mmCRTC1_CRTC_INTERRUPT_CONTROL                                                                 0x0907
#define mmCRTC1_CRTC_INTERRUPT_CONTROL_BASE_IDX                                                        2
#define mmCRTC1_CRTC_UPDATE_LOCK                                                                       0x0908
#define mmCRTC1_CRTC_UPDATE_LOCK_BASE_IDX                                                              2
#define mmCRTC1_CRTC_DOUBLE_BUFFER_CONTROL                                                             0x0909
#define mmCRTC1_CRTC_DOUBLE_BUFFER_CONTROL_BASE_IDX                                                    2
#define mmCRTC1_CRTC_VGA_PARAMETER_CAPTURE_MODE                                                        0x090a
#define mmCRTC1_CRTC_VGA_PARAMETER_CAPTURE_MODE_BASE_IDX                                               2
#define mmCRTC1_CRTC_TEST_PATTERN_CONTROL                                                              0x090b
#define mmCRTC1_CRTC_TEST_PATTERN_CONTROL_BASE_IDX                                                     2
#define mmCRTC1_CRTC_TEST_PATTERN_PARAMETERS                                                           0x090c
#define mmCRTC1_CRTC_TEST_PATTERN_PARAMETERS_BASE_IDX                                                  2
#define mmCRTC1_CRTC_TEST_PATTERN_COLOR                                                                0x090d
#define mmCRTC1_CRTC_TEST_PATTERN_COLOR_BASE_IDX                                                       2
#define mmCRTC1_CRTC_MASTER_UPDATE_LOCK                                                                0x090e
#define mmCRTC1_CRTC_MASTER_UPDATE_LOCK_BASE_IDX                                                       2
#define mmCRTC1_CRTC_MASTER_UPDATE_MODE                                                                0x090f
#define mmCRTC1_CRTC_MASTER_UPDATE_MODE_BASE_IDX                                                       2
#define mmCRTC1_CRTC_MVP_INBAND_CNTL_INSERT                                                            0x0910
#define mmCRTC1_CRTC_MVP_INBAND_CNTL_INSERT_BASE_IDX                                                   2
#define mmCRTC1_CRTC_MVP_INBAND_CNTL_INSERT_TIMER                                                      0x0911
#define mmCRTC1_CRTC_MVP_INBAND_CNTL_INSERT_TIMER_BASE_IDX                                             2
#define mmCRTC1_CRTC_MVP_STATUS                                                                        0x0912
#define mmCRTC1_CRTC_MVP_STATUS_BASE_IDX                                                               2
#define mmCRTC1_CRTC_MASTER_EN                                                                         0x0913
#define mmCRTC1_CRTC_MASTER_EN_BASE_IDX                                                                2
#define mmCRTC1_CRTC_ALLOW_STOP_OFF_V_CNT                                                              0x0914
#define mmCRTC1_CRTC_ALLOW_STOP_OFF_V_CNT_BASE_IDX                                                     2
#define mmCRTC1_CRTC_V_UPDATE_INT_STATUS                                                               0x0915
#define mmCRTC1_CRTC_V_UPDATE_INT_STATUS_BASE_IDX                                                      2
#define mmCRTC1_CRTC_OVERSCAN_COLOR                                                                    0x0917
#define mmCRTC1_CRTC_OVERSCAN_COLOR_BASE_IDX                                                           2
#define mmCRTC1_CRTC_OVERSCAN_COLOR_EXT                                                                0x0918
#define mmCRTC1_CRTC_OVERSCAN_COLOR_EXT_BASE_IDX                                                       2
#define mmCRTC1_CRTC_BLANK_DATA_COLOR                                                                  0x0919
#define mmCRTC1_CRTC_BLANK_DATA_COLOR_BASE_IDX                                                         2
#define mmCRTC1_CRTC_BLANK_DATA_COLOR_EXT                                                              0x091a
#define mmCRTC1_CRTC_BLANK_DATA_COLOR_EXT_BASE_IDX                                                     2
#define mmCRTC1_CRTC_BLACK_COLOR                                                                       0x091b
#define mmCRTC1_CRTC_BLACK_COLOR_BASE_IDX                                                              2
#define mmCRTC1_CRTC_BLACK_COLOR_EXT                                                                   0x091c
#define mmCRTC1_CRTC_BLACK_COLOR_EXT_BASE_IDX                                                          2
#define mmCRTC1_CRTC_VERTICAL_INTERRUPT0_POSITION                                                      0x091d
#define mmCRTC1_CRTC_VERTICAL_INTERRUPT0_POSITION_BASE_IDX                                             2
#define mmCRTC1_CRTC_VERTICAL_INTERRUPT0_CONTROL                                                       0x091e
#define mmCRTC1_CRTC_VERTICAL_INTERRUPT0_CONTROL_BASE_IDX                                              2
#define mmCRTC1_CRTC_VERTICAL_INTERRUPT1_POSITION                                                      0x091f
#define mmCRTC1_CRTC_VERTICAL_INTERRUPT1_POSITION_BASE_IDX                                             2
#define mmCRTC1_CRTC_VERTICAL_INTERRUPT1_CONTROL                                                       0x0920
#define mmCRTC1_CRTC_VERTICAL_INTERRUPT1_CONTROL_BASE_IDX                                              2
#define mmCRTC1_CRTC_VERTICAL_INTERRUPT2_POSITION                                                      0x0921
#define mmCRTC1_CRTC_VERTICAL_INTERRUPT2_POSITION_BASE_IDX                                             2
#define mmCRTC1_CRTC_VERTICAL_INTERRUPT2_CONTROL                                                       0x0922
#define mmCRTC1_CRTC_VERTICAL_INTERRUPT2_CONTROL_BASE_IDX                                              2
#define mmCRTC1_CRTC_CRC_CNTL                                                                          0x0923
#define mmCRTC1_CRTC_CRC_CNTL_BASE_IDX                                                                 2
#define mmCRTC1_CRTC_CRC0_WINDOWA_X_CONTROL                                                            0x0924
#define mmCRTC1_CRTC_CRC0_WINDOWA_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC1_CRTC_CRC0_WINDOWA_Y_CONTROL                                                            0x0925
#define mmCRTC1_CRTC_CRC0_WINDOWA_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC1_CRTC_CRC0_WINDOWB_X_CONTROL                                                            0x0926
#define mmCRTC1_CRTC_CRC0_WINDOWB_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC1_CRTC_CRC0_WINDOWB_Y_CONTROL                                                            0x0927
#define mmCRTC1_CRTC_CRC0_WINDOWB_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC1_CRTC_CRC0_DATA_RG                                                                      0x0928
#define mmCRTC1_CRTC_CRC0_DATA_RG_BASE_IDX                                                             2
#define mmCRTC1_CRTC_CRC0_DATA_B                                                                       0x0929
#define mmCRTC1_CRTC_CRC0_DATA_B_BASE_IDX                                                              2
#define mmCRTC1_CRTC_CRC1_WINDOWA_X_CONTROL                                                            0x092a
#define mmCRTC1_CRTC_CRC1_WINDOWA_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC1_CRTC_CRC1_WINDOWA_Y_CONTROL                                                            0x092b
#define mmCRTC1_CRTC_CRC1_WINDOWA_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC1_CRTC_CRC1_WINDOWB_X_CONTROL                                                            0x092c
#define mmCRTC1_CRTC_CRC1_WINDOWB_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC1_CRTC_CRC1_WINDOWB_Y_CONTROL                                                            0x092d
#define mmCRTC1_CRTC_CRC1_WINDOWB_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC1_CRTC_CRC1_DATA_RG                                                                      0x092e
#define mmCRTC1_CRTC_CRC1_DATA_RG_BASE_IDX                                                             2
#define mmCRTC1_CRTC_CRC1_DATA_B                                                                       0x092f
#define mmCRTC1_CRTC_CRC1_DATA_B_BASE_IDX                                                              2
#define mmCRTC1_CRTC_EXT_TIMING_SYNC_CONTROL                                                           0x0930
#define mmCRTC1_CRTC_EXT_TIMING_SYNC_CONTROL_BASE_IDX                                                  2
#define mmCRTC1_CRTC_EXT_TIMING_SYNC_WINDOW_START                                                      0x0931
#define mmCRTC1_CRTC_EXT_TIMING_SYNC_WINDOW_START_BASE_IDX                                             2
#define mmCRTC1_CRTC_EXT_TIMING_SYNC_WINDOW_END                                                        0x0932
#define mmCRTC1_CRTC_EXT_TIMING_SYNC_WINDOW_END_BASE_IDX                                               2
#define mmCRTC1_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL                                            0x0933
#define mmCRTC1_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_BASE_IDX                                   2
#define mmCRTC1_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL                                                 0x0934
#define mmCRTC1_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL_BASE_IDX                                        2
#define mmCRTC1_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL                                          0x0935
#define mmCRTC1_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL_BASE_IDX                                 2
#define mmCRTC1_CRTC_STATIC_SCREEN_CONTROL                                                             0x0936
#define mmCRTC1_CRTC_STATIC_SCREEN_CONTROL_BASE_IDX                                                    2
#define mmCRTC1_CRTC_3D_STRUCTURE_CONTROL                                                              0x0937
#define mmCRTC1_CRTC_3D_STRUCTURE_CONTROL_BASE_IDX                                                     2
#define mmCRTC1_CRTC_GSL_VSYNC_GAP                                                                     0x0938
#define mmCRTC1_CRTC_GSL_VSYNC_GAP_BASE_IDX                                                            2
#define mmCRTC1_CRTC_GSL_WINDOW                                                                        0x0939
#define mmCRTC1_CRTC_GSL_WINDOW_BASE_IDX                                                               2
#define mmCRTC1_CRTC_GSL_CONTROL                                                                       0x093a
#define mmCRTC1_CRTC_GSL_CONTROL_BASE_IDX                                                              2
#define mmCRTC1_CRTC_RANGE_TIMING_INT_STATUS                                                           0x093d
#define mmCRTC1_CRTC_RANGE_TIMING_INT_STATUS_BASE_IDX                                                  2
#define mmCRTC1_CRTC_DRR_CONTROL                                                                       0x093e
#define mmCRTC1_CRTC_DRR_CONTROL_BASE_IDX                                                              2


// addressBlock: dce_dc_fmt1_dispdec
// base address: 0x800
#define mmFMT1_FMT_CLAMP_COMPONENT_R                                                                   0x0942
#define mmFMT1_FMT_CLAMP_COMPONENT_R_BASE_IDX                                                          2
#define mmFMT1_FMT_CLAMP_COMPONENT_G                                                                   0x0943
#define mmFMT1_FMT_CLAMP_COMPONENT_G_BASE_IDX                                                          2
#define mmFMT1_FMT_CLAMP_COMPONENT_B                                                                   0x0944
#define mmFMT1_FMT_CLAMP_COMPONENT_B_BASE_IDX                                                          2
#define mmFMT1_FMT_DYNAMIC_EXP_CNTL                                                                    0x0945
#define mmFMT1_FMT_DYNAMIC_EXP_CNTL_BASE_IDX                                                           2
#define mmFMT1_FMT_CONTROL                                                                             0x0946
#define mmFMT1_FMT_CONTROL_BASE_IDX                                                                    2
#define mmFMT1_FMT_BIT_DEPTH_CONTROL                                                                   0x0947
#define mmFMT1_FMT_BIT_DEPTH_CONTROL_BASE_IDX                                                          2
#define mmFMT1_FMT_DITHER_RAND_R_SEED                                                                  0x0948
#define mmFMT1_FMT_DITHER_RAND_R_SEED_BASE_IDX                                                         2
#define mmFMT1_FMT_DITHER_RAND_G_SEED                                                                  0x0949
#define mmFMT1_FMT_DITHER_RAND_G_SEED_BASE_IDX                                                         2
#define mmFMT1_FMT_DITHER_RAND_B_SEED                                                                  0x094a
#define mmFMT1_FMT_DITHER_RAND_B_SEED_BASE_IDX                                                         2
#define mmFMT1_FMT_CLAMP_CNTL                                                                          0x094e
#define mmFMT1_FMT_CLAMP_CNTL_BASE_IDX                                                                 2
#define mmFMT1_FMT_CRC_CNTL                                                                            0x094f
#define mmFMT1_FMT_CRC_CNTL_BASE_IDX                                                                   2
#define mmFMT1_FMT_CRC_SIG_RED_GREEN_MASK                                                              0x0950
#define mmFMT1_FMT_CRC_SIG_RED_GREEN_MASK_BASE_IDX                                                     2
#define mmFMT1_FMT_CRC_SIG_BLUE_CONTROL_MASK                                                           0x0951
#define mmFMT1_FMT_CRC_SIG_BLUE_CONTROL_MASK_BASE_IDX                                                  2
#define mmFMT1_FMT_CRC_SIG_RED_GREEN                                                                   0x0952
#define mmFMT1_FMT_CRC_SIG_RED_GREEN_BASE_IDX                                                          2
#define mmFMT1_FMT_CRC_SIG_BLUE_CONTROL                                                                0x0953
#define mmFMT1_FMT_CRC_SIG_BLUE_CONTROL_BASE_IDX                                                       2
#define mmFMT1_FMT_SIDE_BY_SIDE_STEREO_CONTROL                                                         0x0954
#define mmFMT1_FMT_SIDE_BY_SIDE_STEREO_CONTROL_BASE_IDX                                                2
#define mmFMT1_FMT_420_HBLANK_EARLY_START                                                              0x0955
#define mmFMT1_FMT_420_HBLANK_EARLY_START_BASE_IDX                                                     2


// addressBlock: dce_dc_dcp2_dispdec
// base address: 0x1000
#define mmDCP2_GRPH_ENABLE                                                                             0x095a
#define mmDCP2_GRPH_ENABLE_BASE_IDX                                                                    2
#define mmDCP2_GRPH_CONTROL                                                                            0x095b
#define mmDCP2_GRPH_CONTROL_BASE_IDX                                                                   2
#define mmDCP2_GRPH_LUT_10BIT_BYPASS                                                                   0x095c
#define mmDCP2_GRPH_LUT_10BIT_BYPASS_BASE_IDX                                                          2
#define mmDCP2_GRPH_SWAP_CNTL                                                                          0x095d
#define mmDCP2_GRPH_SWAP_CNTL_BASE_IDX                                                                 2
#define mmDCP2_GRPH_PRIMARY_SURFACE_ADDRESS                                                            0x095e
#define mmDCP2_GRPH_PRIMARY_SURFACE_ADDRESS_BASE_IDX                                                   2
#define mmDCP2_GRPH_SECONDARY_SURFACE_ADDRESS                                                          0x095f
#define mmDCP2_GRPH_SECONDARY_SURFACE_ADDRESS_BASE_IDX                                                 2
#define mmDCP2_GRPH_PITCH                                                                              0x0960
#define mmDCP2_GRPH_PITCH_BASE_IDX                                                                     2
#define mmDCP2_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH                                                       0x0961
#define mmDCP2_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                              2
#define mmDCP2_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH                                                     0x0962
#define mmDCP2_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                            2
#define mmDCP2_GRPH_SURFACE_OFFSET_X                                                                   0x0963
#define mmDCP2_GRPH_SURFACE_OFFSET_X_BASE_IDX                                                          2
#define mmDCP2_GRPH_SURFACE_OFFSET_Y                                                                   0x0964
#define mmDCP2_GRPH_SURFACE_OFFSET_Y_BASE_IDX                                                          2
#define mmDCP2_GRPH_X_START                                                                            0x0965
#define mmDCP2_GRPH_X_START_BASE_IDX                                                                   2
#define mmDCP2_GRPH_Y_START                                                                            0x0966
#define mmDCP2_GRPH_Y_START_BASE_IDX                                                                   2
#define mmDCP2_GRPH_X_END                                                                              0x0967
#define mmDCP2_GRPH_X_END_BASE_IDX                                                                     2
#define mmDCP2_GRPH_Y_END                                                                              0x0968
#define mmDCP2_GRPH_Y_END_BASE_IDX                                                                     2
#define mmDCP2_INPUT_GAMMA_CONTROL                                                                     0x0969
#define mmDCP2_INPUT_GAMMA_CONTROL_BASE_IDX                                                            2
#define mmDCP2_GRPH_UPDATE                                                                             0x096a
#define mmDCP2_GRPH_UPDATE_BASE_IDX                                                                    2
#define mmDCP2_GRPH_FLIP_CONTROL                                                                       0x096b
#define mmDCP2_GRPH_FLIP_CONTROL_BASE_IDX                                                              2
#define mmDCP2_GRPH_SURFACE_ADDRESS_INUSE                                                              0x096c
#define mmDCP2_GRPH_SURFACE_ADDRESS_INUSE_BASE_IDX                                                     2
#define mmDCP2_GRPH_DFQ_CONTROL                                                                        0x096d
#define mmDCP2_GRPH_DFQ_CONTROL_BASE_IDX                                                               2
#define mmDCP2_GRPH_DFQ_STATUS                                                                         0x096e
#define mmDCP2_GRPH_DFQ_STATUS_BASE_IDX                                                                2
#define mmDCP2_GRPH_INTERRUPT_STATUS                                                                   0x096f
#define mmDCP2_GRPH_INTERRUPT_STATUS_BASE_IDX                                                          2
#define mmDCP2_GRPH_INTERRUPT_CONTROL                                                                  0x0970
#define mmDCP2_GRPH_INTERRUPT_CONTROL_BASE_IDX                                                         2
#define mmDCP2_GRPH_SURFACE_ADDRESS_HIGH_INUSE                                                         0x0971
#define mmDCP2_GRPH_SURFACE_ADDRESS_HIGH_INUSE_BASE_IDX                                                2
#define mmDCP2_GRPH_COMPRESS_SURFACE_ADDRESS                                                           0x0972
#define mmDCP2_GRPH_COMPRESS_SURFACE_ADDRESS_BASE_IDX                                                  2
#define mmDCP2_GRPH_COMPRESS_PITCH                                                                     0x0973
#define mmDCP2_GRPH_COMPRESS_PITCH_BASE_IDX                                                            2
#define mmDCP2_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH                                                      0x0974
#define mmDCP2_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH_BASE_IDX                                             2
#define mmDCP2_GRPH_PIPE_OUTSTANDING_REQUEST_LIMIT                                                     0x0975
#define mmDCP2_GRPH_PIPE_OUTSTANDING_REQUEST_LIMIT_BASE_IDX                                            2
#define mmDCP2_PRESCALE_GRPH_CONTROL                                                                   0x0976
#define mmDCP2_PRESCALE_GRPH_CONTROL_BASE_IDX                                                          2
#define mmDCP2_PRESCALE_VALUES_GRPH_R                                                                  0x0977
#define mmDCP2_PRESCALE_VALUES_GRPH_R_BASE_IDX                                                         2
#define mmDCP2_PRESCALE_VALUES_GRPH_G                                                                  0x0978
#define mmDCP2_PRESCALE_VALUES_GRPH_G_BASE_IDX                                                         2
#define mmDCP2_PRESCALE_VALUES_GRPH_B                                                                  0x0979
#define mmDCP2_PRESCALE_VALUES_GRPH_B_BASE_IDX                                                         2
#define mmDCP2_INPUT_CSC_CONTROL                                                                       0x097a
#define mmDCP2_INPUT_CSC_CONTROL_BASE_IDX                                                              2
#define mmDCP2_INPUT_CSC_C11_C12                                                                       0x097b
#define mmDCP2_INPUT_CSC_C11_C12_BASE_IDX                                                              2
#define mmDCP2_INPUT_CSC_C13_C14                                                                       0x097c
#define mmDCP2_INPUT_CSC_C13_C14_BASE_IDX                                                              2
#define mmDCP2_INPUT_CSC_C21_C22                                                                       0x097d
#define mmDCP2_INPUT_CSC_C21_C22_BASE_IDX                                                              2
#define mmDCP2_INPUT_CSC_C23_C24                                                                       0x097e
#define mmDCP2_INPUT_CSC_C23_C24_BASE_IDX                                                              2
#define mmDCP2_INPUT_CSC_C31_C32                                                                       0x097f
#define mmDCP2_INPUT_CSC_C31_C32_BASE_IDX                                                              2
#define mmDCP2_INPUT_CSC_C33_C34                                                                       0x0980
#define mmDCP2_INPUT_CSC_C33_C34_BASE_IDX                                                              2
#define mmDCP2_OUTPUT_CSC_CONTROL                                                                      0x0981
#define mmDCP2_OUTPUT_CSC_CONTROL_BASE_IDX                                                             2
#define mmDCP2_OUTPUT_CSC_C11_C12                                                                      0x0982
#define mmDCP2_OUTPUT_CSC_C11_C12_BASE_IDX                                                             2
#define mmDCP2_OUTPUT_CSC_C13_C14                                                                      0x0983
#define mmDCP2_OUTPUT_CSC_C13_C14_BASE_IDX                                                             2
#define mmDCP2_OUTPUT_CSC_C21_C22                                                                      0x0984
#define mmDCP2_OUTPUT_CSC_C21_C22_BASE_IDX                                                             2
#define mmDCP2_OUTPUT_CSC_C23_C24                                                                      0x0985
#define mmDCP2_OUTPUT_CSC_C23_C24_BASE_IDX                                                             2
#define mmDCP2_OUTPUT_CSC_C31_C32                                                                      0x0986
#define mmDCP2_OUTPUT_CSC_C31_C32_BASE_IDX                                                             2
#define mmDCP2_OUTPUT_CSC_C33_C34                                                                      0x0987
#define mmDCP2_OUTPUT_CSC_C33_C34_BASE_IDX                                                             2
#define mmDCP2_COMM_MATRIXA_TRANS_C11_C12                                                              0x0988
#define mmDCP2_COMM_MATRIXA_TRANS_C11_C12_BASE_IDX                                                     2
#define mmDCP2_COMM_MATRIXA_TRANS_C13_C14                                                              0x0989
#define mmDCP2_COMM_MATRIXA_TRANS_C13_C14_BASE_IDX                                                     2
#define mmDCP2_COMM_MATRIXA_TRANS_C21_C22                                                              0x098a
#define mmDCP2_COMM_MATRIXA_TRANS_C21_C22_BASE_IDX                                                     2
#define mmDCP2_COMM_MATRIXA_TRANS_C23_C24                                                              0x098b
#define mmDCP2_COMM_MATRIXA_TRANS_C23_C24_BASE_IDX                                                     2
#define mmDCP2_COMM_MATRIXA_TRANS_C31_C32                                                              0x098c
#define mmDCP2_COMM_MATRIXA_TRANS_C31_C32_BASE_IDX                                                     2
#define mmDCP2_COMM_MATRIXA_TRANS_C33_C34                                                              0x098d
#define mmDCP2_COMM_MATRIXA_TRANS_C33_C34_BASE_IDX                                                     2
#define mmDCP2_COMM_MATRIXB_TRANS_C11_C12                                                              0x098e
#define mmDCP2_COMM_MATRIXB_TRANS_C11_C12_BASE_IDX                                                     2
#define mmDCP2_COMM_MATRIXB_TRANS_C13_C14                                                              0x098f
#define mmDCP2_COMM_MATRIXB_TRANS_C13_C14_BASE_IDX                                                     2
#define mmDCP2_COMM_MATRIXB_TRANS_C21_C22                                                              0x0990
#define mmDCP2_COMM_MATRIXB_TRANS_C21_C22_BASE_IDX                                                     2
#define mmDCP2_COMM_MATRIXB_TRANS_C23_C24                                                              0x0991
#define mmDCP2_COMM_MATRIXB_TRANS_C23_C24_BASE_IDX                                                     2
#define mmDCP2_COMM_MATRIXB_TRANS_C31_C32                                                              0x0992
#define mmDCP2_COMM_MATRIXB_TRANS_C31_C32_BASE_IDX                                                     2
#define mmDCP2_COMM_MATRIXB_TRANS_C33_C34                                                              0x0993
#define mmDCP2_COMM_MATRIXB_TRANS_C33_C34_BASE_IDX                                                     2
#define mmDCP2_DENORM_CONTROL                                                                          0x0994
#define mmDCP2_DENORM_CONTROL_BASE_IDX                                                                 2
#define mmDCP2_OUT_ROUND_CONTROL                                                                       0x0995
#define mmDCP2_OUT_ROUND_CONTROL_BASE_IDX                                                              2
#define mmDCP2_OUT_CLAMP_CONTROL_R_CR                                                                  0x0996
#define mmDCP2_OUT_CLAMP_CONTROL_R_CR_BASE_IDX                                                         2
#define mmDCP2_OUT_CLAMP_CONTROL_G_Y                                                                   0x0997
#define mmDCP2_OUT_CLAMP_CONTROL_G_Y_BASE_IDX                                                          2
#define mmDCP2_OUT_CLAMP_CONTROL_B_CB                                                                  0x0998
#define mmDCP2_OUT_CLAMP_CONTROL_B_CB_BASE_IDX                                                         2
#define mmDCP2_KEY_CONTROL                                                                             0x0999
#define mmDCP2_KEY_CONTROL_BASE_IDX                                                                    2
#define mmDCP2_KEY_RANGE_ALPHA                                                                         0x099a
#define mmDCP2_KEY_RANGE_ALPHA_BASE_IDX                                                                2
#define mmDCP2_KEY_RANGE_RED                                                                           0x099b
#define mmDCP2_KEY_RANGE_RED_BASE_IDX                                                                  2
#define mmDCP2_KEY_RANGE_GREEN                                                                         0x099c
#define mmDCP2_KEY_RANGE_GREEN_BASE_IDX                                                                2
#define mmDCP2_KEY_RANGE_BLUE                                                                          0x099d
#define mmDCP2_KEY_RANGE_BLUE_BASE_IDX                                                                 2
#define mmDCP2_DEGAMMA_CONTROL                                                                         0x099e
#define mmDCP2_DEGAMMA_CONTROL_BASE_IDX                                                                2
#define mmDCP2_GAMUT_REMAP_CONTROL                                                                     0x099f
#define mmDCP2_GAMUT_REMAP_CONTROL_BASE_IDX                                                            2
#define mmDCP2_GAMUT_REMAP_C11_C12                                                                     0x09a0
#define mmDCP2_GAMUT_REMAP_C11_C12_BASE_IDX                                                            2
#define mmDCP2_GAMUT_REMAP_C13_C14                                                                     0x09a1
#define mmDCP2_GAMUT_REMAP_C13_C14_BASE_IDX                                                            2
#define mmDCP2_GAMUT_REMAP_C21_C22                                                                     0x09a2
#define mmDCP2_GAMUT_REMAP_C21_C22_BASE_IDX                                                            2
#define mmDCP2_GAMUT_REMAP_C23_C24                                                                     0x09a3
#define mmDCP2_GAMUT_REMAP_C23_C24_BASE_IDX                                                            2
#define mmDCP2_GAMUT_REMAP_C31_C32                                                                     0x09a4
#define mmDCP2_GAMUT_REMAP_C31_C32_BASE_IDX                                                            2
#define mmDCP2_GAMUT_REMAP_C33_C34                                                                     0x09a5
#define mmDCP2_GAMUT_REMAP_C33_C34_BASE_IDX                                                            2
#define mmDCP2_DCP_SPATIAL_DITHER_CNTL                                                                 0x09a6
#define mmDCP2_DCP_SPATIAL_DITHER_CNTL_BASE_IDX                                                        2
#define mmDCP2_DCP_RANDOM_SEEDS                                                                        0x09a7
#define mmDCP2_DCP_RANDOM_SEEDS_BASE_IDX                                                               2
#define mmDCP2_DCP_FP_CONVERTED_FIELD                                                                  0x09a8
#define mmDCP2_DCP_FP_CONVERTED_FIELD_BASE_IDX                                                         2
#define mmDCP2_CUR_CONTROL                                                                             0x09a9
#define mmDCP2_CUR_CONTROL_BASE_IDX                                                                    2
#define mmDCP2_CUR_SURFACE_ADDRESS                                                                     0x09aa
#define mmDCP2_CUR_SURFACE_ADDRESS_BASE_IDX                                                            2
#define mmDCP2_CUR_SIZE                                                                                0x09ab
#define mmDCP2_CUR_SIZE_BASE_IDX                                                                       2
#define mmDCP2_CUR_SURFACE_ADDRESS_HIGH                                                                0x09ac
#define mmDCP2_CUR_SURFACE_ADDRESS_HIGH_BASE_IDX                                                       2
#define mmDCP2_CUR_POSITION                                                                            0x09ad
#define mmDCP2_CUR_POSITION_BASE_IDX                                                                   2
#define mmDCP2_CUR_HOT_SPOT                                                                            0x09ae
#define mmDCP2_CUR_HOT_SPOT_BASE_IDX                                                                   2
#define mmDCP2_CUR_COLOR1                                                                              0x09af
#define mmDCP2_CUR_COLOR1_BASE_IDX                                                                     2
#define mmDCP2_CUR_COLOR2                                                                              0x09b0
#define mmDCP2_CUR_COLOR2_BASE_IDX                                                                     2
#define mmDCP2_CUR_UPDATE                                                                              0x09b1
#define mmDCP2_CUR_UPDATE_BASE_IDX                                                                     2
#define mmDCP2_CUR_REQUEST_FILTER_CNTL                                                                 0x09bb
#define mmDCP2_CUR_REQUEST_FILTER_CNTL_BASE_IDX                                                        2
#define mmDCP2_CUR_STEREO_CONTROL                                                                      0x09bc
#define mmDCP2_CUR_STEREO_CONTROL_BASE_IDX                                                             2
#define mmDCP2_DC_LUT_RW_MODE                                                                          0x09be
#define mmDCP2_DC_LUT_RW_MODE_BASE_IDX                                                                 2
#define mmDCP2_DC_LUT_RW_INDEX                                                                         0x09bf
#define mmDCP2_DC_LUT_RW_INDEX_BASE_IDX                                                                2
#define mmDCP2_DC_LUT_SEQ_COLOR                                                                        0x09c0
#define mmDCP2_DC_LUT_SEQ_COLOR_BASE_IDX                                                               2
#define mmDCP2_DC_LUT_PWL_DATA                                                                         0x09c1
#define mmDCP2_DC_LUT_PWL_DATA_BASE_IDX                                                                2
#define mmDCP2_DC_LUT_30_COLOR                                                                         0x09c2
#define mmDCP2_DC_LUT_30_COLOR_BASE_IDX                                                                2
#define mmDCP2_DC_LUT_VGA_ACCESS_ENABLE                                                                0x09c3
#define mmDCP2_DC_LUT_VGA_ACCESS_ENABLE_BASE_IDX                                                       2
#define mmDCP2_DC_LUT_WRITE_EN_MASK                                                                    0x09c4
#define mmDCP2_DC_LUT_WRITE_EN_MASK_BASE_IDX                                                           2
#define mmDCP2_DC_LUT_AUTOFILL                                                                         0x09c5
#define mmDCP2_DC_LUT_AUTOFILL_BASE_IDX                                                                2
#define mmDCP2_DC_LUT_CONTROL                                                                          0x09c6
#define mmDCP2_DC_LUT_CONTROL_BASE_IDX                                                                 2
#define mmDCP2_DC_LUT_BLACK_OFFSET_BLUE                                                                0x09c7
#define mmDCP2_DC_LUT_BLACK_OFFSET_BLUE_BASE_IDX                                                       2
#define mmDCP2_DC_LUT_BLACK_OFFSET_GREEN                                                               0x09c8
#define mmDCP2_DC_LUT_BLACK_OFFSET_GREEN_BASE_IDX                                                      2
#define mmDCP2_DC_LUT_BLACK_OFFSET_RED                                                                 0x09c9
#define mmDCP2_DC_LUT_BLACK_OFFSET_RED_BASE_IDX                                                        2
#define mmDCP2_DC_LUT_WHITE_OFFSET_BLUE                                                                0x09ca
#define mmDCP2_DC_LUT_WHITE_OFFSET_BLUE_BASE_IDX                                                       2
#define mmDCP2_DC_LUT_WHITE_OFFSET_GREEN                                                               0x09cb
#define mmDCP2_DC_LUT_WHITE_OFFSET_GREEN_BASE_IDX                                                      2
#define mmDCP2_DC_LUT_WHITE_OFFSET_RED                                                                 0x09cc
#define mmDCP2_DC_LUT_WHITE_OFFSET_RED_BASE_IDX                                                        2
#define mmDCP2_DCP_CRC_CONTROL                                                                         0x09cd
#define mmDCP2_DCP_CRC_CONTROL_BASE_IDX                                                                2
#define mmDCP2_DCP_CRC_MASK                                                                            0x09ce
#define mmDCP2_DCP_CRC_MASK_BASE_IDX                                                                   2
#define mmDCP2_DCP_CRC_CURRENT                                                                         0x09cf
#define mmDCP2_DCP_CRC_CURRENT_BASE_IDX                                                                2
#define mmDCP2_DVMM_PTE_CONTROL                                                                        0x09d0
#define mmDCP2_DVMM_PTE_CONTROL_BASE_IDX                                                               2
#define mmDCP2_DCP_CRC_LAST                                                                            0x09d1
#define mmDCP2_DCP_CRC_LAST_BASE_IDX                                                                   2
#define mmDCP2_DVMM_PTE_ARB_CONTROL                                                                    0x09d2
#define mmDCP2_DVMM_PTE_ARB_CONTROL_BASE_IDX                                                           2
#define mmDCP2_GRPH_FLIP_RATE_CNTL                                                                     0x09d4
#define mmDCP2_GRPH_FLIP_RATE_CNTL_BASE_IDX                                                            2
#define mmDCP2_DCP_GSL_CONTROL                                                                         0x09d5
#define mmDCP2_DCP_GSL_CONTROL_BASE_IDX                                                                2
#define mmDCP2_DCP_LB_DATA_GAP_BETWEEN_CHUNK                                                           0x09d6
#define mmDCP2_DCP_LB_DATA_GAP_BETWEEN_CHUNK_BASE_IDX                                                  2
#define mmDCP2_GRPH_STEREOSYNC_FLIP                                                                    0x09dc
#define mmDCP2_GRPH_STEREOSYNC_FLIP_BASE_IDX                                                           2
#define mmDCP2_HW_ROTATION                                                                             0x09de
#define mmDCP2_HW_ROTATION_BASE_IDX                                                                    2
#define mmDCP2_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL                                                      0x09df
#define mmDCP2_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL_BASE_IDX                                             2
#define mmDCP2_REGAMMA_CONTROL                                                                         0x09e0
#define mmDCP2_REGAMMA_CONTROL_BASE_IDX                                                                2
#define mmDCP2_REGAMMA_LUT_INDEX                                                                       0x09e1
#define mmDCP2_REGAMMA_LUT_INDEX_BASE_IDX                                                              2
#define mmDCP2_REGAMMA_LUT_DATA                                                                        0x09e2
#define mmDCP2_REGAMMA_LUT_DATA_BASE_IDX                                                               2
#define mmDCP2_REGAMMA_LUT_WRITE_EN_MASK                                                               0x09e3
#define mmDCP2_REGAMMA_LUT_WRITE_EN_MASK_BASE_IDX                                                      2
#define mmDCP2_REGAMMA_CNTLA_START_CNTL                                                                0x09e4
#define mmDCP2_REGAMMA_CNTLA_START_CNTL_BASE_IDX                                                       2
#define mmDCP2_REGAMMA_CNTLA_SLOPE_CNTL                                                                0x09e5
#define mmDCP2_REGAMMA_CNTLA_SLOPE_CNTL_BASE_IDX                                                       2
#define mmDCP2_REGAMMA_CNTLA_END_CNTL1                                                                 0x09e6
#define mmDCP2_REGAMMA_CNTLA_END_CNTL1_BASE_IDX                                                        2
#define mmDCP2_REGAMMA_CNTLA_END_CNTL2                                                                 0x09e7
#define mmDCP2_REGAMMA_CNTLA_END_CNTL2_BASE_IDX                                                        2
#define mmDCP2_REGAMMA_CNTLA_REGION_0_1                                                                0x09e8
#define mmDCP2_REGAMMA_CNTLA_REGION_0_1_BASE_IDX                                                       2
#define mmDCP2_REGAMMA_CNTLA_REGION_2_3                                                                0x09e9
#define mmDCP2_REGAMMA_CNTLA_REGION_2_3_BASE_IDX                                                       2
#define mmDCP2_REGAMMA_CNTLA_REGION_4_5                                                                0x09ea
#define mmDCP2_REGAMMA_CNTLA_REGION_4_5_BASE_IDX                                                       2
#define mmDCP2_REGAMMA_CNTLA_REGION_6_7                                                                0x09eb
#define mmDCP2_REGAMMA_CNTLA_REGION_6_7_BASE_IDX                                                       2
#define mmDCP2_REGAMMA_CNTLA_REGION_8_9                                                                0x09ec
#define mmDCP2_REGAMMA_CNTLA_REGION_8_9_BASE_IDX                                                       2
#define mmDCP2_REGAMMA_CNTLA_REGION_10_11                                                              0x09ed
#define mmDCP2_REGAMMA_CNTLA_REGION_10_11_BASE_IDX                                                     2
#define mmDCP2_REGAMMA_CNTLA_REGION_12_13                                                              0x09ee
#define mmDCP2_REGAMMA_CNTLA_REGION_12_13_BASE_IDX                                                     2
#define mmDCP2_REGAMMA_CNTLA_REGION_14_15                                                              0x09ef
#define mmDCP2_REGAMMA_CNTLA_REGION_14_15_BASE_IDX                                                     2
#define mmDCP2_REGAMMA_CNTLB_START_CNTL                                                                0x09f0
#define mmDCP2_REGAMMA_CNTLB_START_CNTL_BASE_IDX                                                       2
#define mmDCP2_REGAMMA_CNTLB_SLOPE_CNTL                                                                0x09f1
#define mmDCP2_REGAMMA_CNTLB_SLOPE_CNTL_BASE_IDX                                                       2
#define mmDCP2_REGAMMA_CNTLB_END_CNTL1                                                                 0x09f2
#define mmDCP2_REGAMMA_CNTLB_END_CNTL1_BASE_IDX                                                        2
#define mmDCP2_REGAMMA_CNTLB_END_CNTL2                                                                 0x09f3
#define mmDCP2_REGAMMA_CNTLB_END_CNTL2_BASE_IDX                                                        2
#define mmDCP2_REGAMMA_CNTLB_REGION_0_1                                                                0x09f4
#define mmDCP2_REGAMMA_CNTLB_REGION_0_1_BASE_IDX                                                       2
#define mmDCP2_REGAMMA_CNTLB_REGION_2_3                                                                0x09f5
#define mmDCP2_REGAMMA_CNTLB_REGION_2_3_BASE_IDX                                                       2
#define mmDCP2_REGAMMA_CNTLB_REGION_4_5                                                                0x09f6
#define mmDCP2_REGAMMA_CNTLB_REGION_4_5_BASE_IDX                                                       2
#define mmDCP2_REGAMMA_CNTLB_REGION_6_7                                                                0x09f7
#define mmDCP2_REGAMMA_CNTLB_REGION_6_7_BASE_IDX                                                       2
#define mmDCP2_REGAMMA_CNTLB_REGION_8_9                                                                0x09f8
#define mmDCP2_REGAMMA_CNTLB_REGION_8_9_BASE_IDX                                                       2
#define mmDCP2_REGAMMA_CNTLB_REGION_10_11                                                              0x09f9
#define mmDCP2_REGAMMA_CNTLB_REGION_10_11_BASE_IDX                                                     2
#define mmDCP2_REGAMMA_CNTLB_REGION_12_13                                                              0x09fa
#define mmDCP2_REGAMMA_CNTLB_REGION_12_13_BASE_IDX                                                     2
#define mmDCP2_REGAMMA_CNTLB_REGION_14_15                                                              0x09fb
#define mmDCP2_REGAMMA_CNTLB_REGION_14_15_BASE_IDX                                                     2
#define mmDCP2_ALPHA_CONTROL                                                                           0x09fc
#define mmDCP2_ALPHA_CONTROL_BASE_IDX                                                                  2
#define mmDCP2_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS                                                      0x09fd
#define mmDCP2_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_BASE_IDX                                             2
#define mmDCP2_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH                                                 0x09fe
#define mmDCP2_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH_BASE_IDX                                        2
#define mmDCP2_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS                                                    0x09ff
#define mmDCP2_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS_BASE_IDX                                           2
#define mmDCP2_GRPH_XDMA_FLIP_TIMEOUT                                                                  0x0a00
#define mmDCP2_GRPH_XDMA_FLIP_TIMEOUT_BASE_IDX                                                         2
#define mmDCP2_GRPH_XDMA_FLIP_AVG_DELAY                                                                0x0a01
#define mmDCP2_GRPH_XDMA_FLIP_AVG_DELAY_BASE_IDX                                                       2
#define mmDCP2_GRPH_SURFACE_COUNTER_CONTROL                                                            0x0a02
#define mmDCP2_GRPH_SURFACE_COUNTER_CONTROL_BASE_IDX                                                   2
#define mmDCP2_GRPH_SURFACE_COUNTER_OUTPUT                                                             0x0a03
#define mmDCP2_GRPH_SURFACE_COUNTER_OUTPUT_BASE_IDX                                                    2


// addressBlock: dce_dc_lb2_dispdec
// base address: 0x1000
#define mmLB2_LB_DATA_FORMAT                                                                           0x0a1a
#define mmLB2_LB_DATA_FORMAT_BASE_IDX                                                                  2
#define mmLB2_LB_MEMORY_CTRL                                                                           0x0a1b
#define mmLB2_LB_MEMORY_CTRL_BASE_IDX                                                                  2
#define mmLB2_LB_MEMORY_SIZE_STATUS                                                                    0x0a1c
#define mmLB2_LB_MEMORY_SIZE_STATUS_BASE_IDX                                                           2
#define mmLB2_LB_DESKTOP_HEIGHT                                                                        0x0a1d
#define mmLB2_LB_DESKTOP_HEIGHT_BASE_IDX                                                               2
#define mmLB2_LB_VLINE_START_END                                                                       0x0a1e
#define mmLB2_LB_VLINE_START_END_BASE_IDX                                                              2
#define mmLB2_LB_VLINE2_START_END                                                                      0x0a1f
#define mmLB2_LB_VLINE2_START_END_BASE_IDX                                                             2
#define mmLB2_LB_V_COUNTER                                                                             0x0a20
#define mmLB2_LB_V_COUNTER_BASE_IDX                                                                    2
#define mmLB2_LB_SNAPSHOT_V_COUNTER                                                                    0x0a21
#define mmLB2_LB_SNAPSHOT_V_COUNTER_BASE_IDX                                                           2
#define mmLB2_LB_INTERRUPT_MASK                                                                        0x0a22
#define mmLB2_LB_INTERRUPT_MASK_BASE_IDX                                                               2
#define mmLB2_LB_VLINE_STATUS                                                                          0x0a23
#define mmLB2_LB_VLINE_STATUS_BASE_IDX                                                                 2
#define mmLB2_LB_VLINE2_STATUS                                                                         0x0a24
#define mmLB2_LB_VLINE2_STATUS_BASE_IDX                                                                2
#define mmLB2_LB_VBLANK_STATUS                                                                         0x0a25
#define mmLB2_LB_VBLANK_STATUS_BASE_IDX                                                                2
#define mmLB2_LB_SYNC_RESET_SEL                                                                        0x0a26
#define mmLB2_LB_SYNC_RESET_SEL_BASE_IDX                                                               2
#define mmLB2_LB_BLACK_KEYER_R_CR                                                                      0x0a27
#define mmLB2_LB_BLACK_KEYER_R_CR_BASE_IDX                                                             2
#define mmLB2_LB_BLACK_KEYER_G_Y                                                                       0x0a28
#define mmLB2_LB_BLACK_KEYER_G_Y_BASE_IDX                                                              2
#define mmLB2_LB_BLACK_KEYER_B_CB                                                                      0x0a29
#define mmLB2_LB_BLACK_KEYER_B_CB_BASE_IDX                                                             2
#define mmLB2_LB_KEYER_COLOR_CTRL                                                                      0x0a2a
#define mmLB2_LB_KEYER_COLOR_CTRL_BASE_IDX                                                             2
#define mmLB2_LB_KEYER_COLOR_R_CR                                                                      0x0a2b
#define mmLB2_LB_KEYER_COLOR_R_CR_BASE_IDX                                                             2
#define mmLB2_LB_KEYER_COLOR_G_Y                                                                       0x0a2c
#define mmLB2_LB_KEYER_COLOR_G_Y_BASE_IDX                                                              2
#define mmLB2_LB_KEYER_COLOR_B_CB                                                                      0x0a2d
#define mmLB2_LB_KEYER_COLOR_B_CB_BASE_IDX                                                             2
#define mmLB2_LB_KEYER_COLOR_REP_R_CR                                                                  0x0a2e
#define mmLB2_LB_KEYER_COLOR_REP_R_CR_BASE_IDX                                                         2
#define mmLB2_LB_KEYER_COLOR_REP_G_Y                                                                   0x0a2f
#define mmLB2_LB_KEYER_COLOR_REP_G_Y_BASE_IDX                                                          2
#define mmLB2_LB_KEYER_COLOR_REP_B_CB                                                                  0x0a30
#define mmLB2_LB_KEYER_COLOR_REP_B_CB_BASE_IDX                                                         2
#define mmLB2_LB_BUFFER_LEVEL_STATUS                                                                   0x0a31
#define mmLB2_LB_BUFFER_LEVEL_STATUS_BASE_IDX                                                          2
#define mmLB2_LB_BUFFER_URGENCY_CTRL                                                                   0x0a32
#define mmLB2_LB_BUFFER_URGENCY_CTRL_BASE_IDX                                                          2
#define mmLB2_LB_BUFFER_URGENCY_STATUS                                                                 0x0a33
#define mmLB2_LB_BUFFER_URGENCY_STATUS_BASE_IDX                                                        2
#define mmLB2_LB_BUFFER_STATUS                                                                         0x0a34
#define mmLB2_LB_BUFFER_STATUS_BASE_IDX                                                                2
#define mmLB2_LB_NO_OUTSTANDING_REQ_STATUS                                                             0x0a35
#define mmLB2_LB_NO_OUTSTANDING_REQ_STATUS_BASE_IDX                                                    2
#define mmLB2_MVP_AFR_FLIP_MODE                                                                        0x0a36
#define mmLB2_MVP_AFR_FLIP_MODE_BASE_IDX                                                               2
#define mmLB2_MVP_AFR_FLIP_FIFO_CNTL                                                                   0x0a37
#define mmLB2_MVP_AFR_FLIP_FIFO_CNTL_BASE_IDX                                                          2
#define mmLB2_MVP_FLIP_LINE_NUM_INSERT                                                                 0x0a38
#define mmLB2_MVP_FLIP_LINE_NUM_INSERT_BASE_IDX                                                        2
#define mmLB2_DC_MVP_LB_CONTROL                                                                        0x0a39
#define mmLB2_DC_MVP_LB_CONTROL_BASE_IDX                                                               2


// addressBlock: dce_dc_dcfe2_dispdec
// base address: 0x1000
#define mmDCFE2_DCFE_CLOCK_CONTROL                                                                     0x0a5a
#define mmDCFE2_DCFE_CLOCK_CONTROL_BASE_IDX                                                            2
#define mmDCFE2_DCFE_SOFT_RESET                                                                        0x0a5b
#define mmDCFE2_DCFE_SOFT_RESET_BASE_IDX                                                               2
#define mmDCFE2_DCFE_MEM_PWR_CTRL                                                                      0x0a5d
#define mmDCFE2_DCFE_MEM_PWR_CTRL_BASE_IDX                                                             2
#define mmDCFE2_DCFE_MEM_PWR_CTRL2                                                                     0x0a5e
#define mmDCFE2_DCFE_MEM_PWR_CTRL2_BASE_IDX                                                            2
#define mmDCFE2_DCFE_MEM_PWR_STATUS                                                                    0x0a5f
#define mmDCFE2_DCFE_MEM_PWR_STATUS_BASE_IDX                                                           2
#define mmDCFE2_DCFE_MISC                                                                              0x0a60
#define mmDCFE2_DCFE_MISC_BASE_IDX                                                                     2
#define mmDCFE2_DCFE_FLUSH                                                                             0x0a61
#define mmDCFE2_DCFE_FLUSH_BASE_IDX                                                                    2


// addressBlock: dce_dc_dc_perfmon5_dispdec
// base address: 0x2938
#define mmDC_PERFMON5_PERFCOUNTER_CNTL                                                                 0x0a6e
#define mmDC_PERFMON5_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON5_PERFCOUNTER_CNTL2                                                                0x0a6f
#define mmDC_PERFMON5_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON5_PERFCOUNTER_STATE                                                                0x0a70
#define mmDC_PERFMON5_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON5_PERFMON_CNTL                                                                     0x0a71
#define mmDC_PERFMON5_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON5_PERFMON_CNTL2                                                                    0x0a72
#define mmDC_PERFMON5_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON5_PERFMON_CVALUE_INT_MISC                                                          0x0a73
#define mmDC_PERFMON5_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON5_PERFMON_CVALUE_LOW                                                               0x0a74
#define mmDC_PERFMON5_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON5_PERFMON_HI                                                                       0x0a75
#define mmDC_PERFMON5_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON5_PERFMON_LOW                                                                      0x0a76
#define mmDC_PERFMON5_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dmif_pg2_dispdec
// base address: 0x1000
#define mmDMIF_PG2_DPG_PIPE_ARBITRATION_CONTROL1                                                       0x0a7a
#define mmDMIF_PG2_DPG_PIPE_ARBITRATION_CONTROL1_BASE_IDX                                              2
#define mmDMIF_PG2_DPG_PIPE_ARBITRATION_CONTROL2                                                       0x0a7b
#define mmDMIF_PG2_DPG_PIPE_ARBITRATION_CONTROL2_BASE_IDX                                              2
#define mmDMIF_PG2_DPG_WATERMARK_MASK_CONTROL                                                          0x0a7c
#define mmDMIF_PG2_DPG_WATERMARK_MASK_CONTROL_BASE_IDX                                                 2
#define mmDMIF_PG2_DPG_PIPE_URGENCY_CONTROL                                                            0x0a7d
#define mmDMIF_PG2_DPG_PIPE_URGENCY_CONTROL_BASE_IDX                                                   2
#define mmDMIF_PG2_DPG_PIPE_URGENT_LEVEL_CONTROL                                                       0x0a7e
#define mmDMIF_PG2_DPG_PIPE_URGENT_LEVEL_CONTROL_BASE_IDX                                              2
#define mmDMIF_PG2_DPG_PIPE_STUTTER_CONTROL                                                            0x0a7f
#define mmDMIF_PG2_DPG_PIPE_STUTTER_CONTROL_BASE_IDX                                                   2
#define mmDMIF_PG2_DPG_PIPE_STUTTER_CONTROL2                                                           0x0a80
#define mmDMIF_PG2_DPG_PIPE_STUTTER_CONTROL2_BASE_IDX                                                  2
#define mmDMIF_PG2_DPG_PIPE_LOW_POWER_CONTROL                                                          0x0a81
#define mmDMIF_PG2_DPG_PIPE_LOW_POWER_CONTROL_BASE_IDX                                                 2
#define mmDMIF_PG2_DPG_REPEATER_PROGRAM                                                                0x0a82
#define mmDMIF_PG2_DPG_REPEATER_PROGRAM_BASE_IDX                                                       2
#define mmDMIF_PG2_DPG_CHK_PRE_PROC_CNTL                                                               0x0a86
#define mmDMIF_PG2_DPG_CHK_PRE_PROC_CNTL_BASE_IDX                                                      2
#define mmDMIF_PG2_DPG_DVMM_STATUS                                                                     0x0a87
#define mmDMIF_PG2_DPG_DVMM_STATUS_BASE_IDX                                                            2


// addressBlock: dce_dc_scl2_dispdec
// base address: 0x1000
#define mmSCL2_SCL_COEF_RAM_SELECT                                                                     0x0a9a
#define mmSCL2_SCL_COEF_RAM_SELECT_BASE_IDX                                                            2
#define mmSCL2_SCL_COEF_RAM_TAP_DATA                                                                   0x0a9b
#define mmSCL2_SCL_COEF_RAM_TAP_DATA_BASE_IDX                                                          2
#define mmSCL2_SCL_MODE                                                                                0x0a9c
#define mmSCL2_SCL_MODE_BASE_IDX                                                                       2
#define mmSCL2_SCL_TAP_CONTROL                                                                         0x0a9d
#define mmSCL2_SCL_TAP_CONTROL_BASE_IDX                                                                2
#define mmSCL2_SCL_CONTROL                                                                             0x0a9e
#define mmSCL2_SCL_CONTROL_BASE_IDX                                                                    2
#define mmSCL2_SCL_BYPASS_CONTROL                                                                      0x0a9f
#define mmSCL2_SCL_BYPASS_CONTROL_BASE_IDX                                                             2
#define mmSCL2_SCL_MANUAL_REPLICATE_CONTROL                                                            0x0aa0
#define mmSCL2_SCL_MANUAL_REPLICATE_CONTROL_BASE_IDX                                                   2
#define mmSCL2_SCL_AUTOMATIC_MODE_CONTROL                                                              0x0aa1
#define mmSCL2_SCL_AUTOMATIC_MODE_CONTROL_BASE_IDX                                                     2
#define mmSCL2_SCL_HORZ_FILTER_CONTROL                                                                 0x0aa2
#define mmSCL2_SCL_HORZ_FILTER_CONTROL_BASE_IDX                                                        2
#define mmSCL2_SCL_HORZ_FILTER_SCALE_RATIO                                                             0x0aa3
#define mmSCL2_SCL_HORZ_FILTER_SCALE_RATIO_BASE_IDX                                                    2
#define mmSCL2_SCL_HORZ_FILTER_INIT                                                                    0x0aa4
#define mmSCL2_SCL_HORZ_FILTER_INIT_BASE_IDX                                                           2
#define mmSCL2_SCL_VERT_FILTER_CONTROL                                                                 0x0aa5
#define mmSCL2_SCL_VERT_FILTER_CONTROL_BASE_IDX                                                        2
#define mmSCL2_SCL_VERT_FILTER_SCALE_RATIO                                                             0x0aa6
#define mmSCL2_SCL_VERT_FILTER_SCALE_RATIO_BASE_IDX                                                    2
#define mmSCL2_SCL_VERT_FILTER_INIT                                                                    0x0aa7
#define mmSCL2_SCL_VERT_FILTER_INIT_BASE_IDX                                                           2
#define mmSCL2_SCL_VERT_FILTER_INIT_BOT                                                                0x0aa8
#define mmSCL2_SCL_VERT_FILTER_INIT_BOT_BASE_IDX                                                       2
#define mmSCL2_SCL_ROUND_OFFSET                                                                        0x0aa9
#define mmSCL2_SCL_ROUND_OFFSET_BASE_IDX                                                               2
#define mmSCL2_SCL_UPDATE                                                                              0x0aaa
#define mmSCL2_SCL_UPDATE_BASE_IDX                                                                     2
#define mmSCL2_SCL_F_SHARP_CONTROL                                                                     0x0aab
#define mmSCL2_SCL_F_SHARP_CONTROL_BASE_IDX                                                            2
#define mmSCL2_SCL_ALU_CONTROL                                                                         0x0aac
#define mmSCL2_SCL_ALU_CONTROL_BASE_IDX                                                                2
#define mmSCL2_SCL_COEF_RAM_CONFLICT_STATUS                                                            0x0aad
#define mmSCL2_SCL_COEF_RAM_CONFLICT_STATUS_BASE_IDX                                                   2
#define mmSCL2_VIEWPORT_START_SECONDARY                                                                0x0aae
#define mmSCL2_VIEWPORT_START_SECONDARY_BASE_IDX                                                       2
#define mmSCL2_VIEWPORT_START                                                                          0x0aaf
#define mmSCL2_VIEWPORT_START_BASE_IDX                                                                 2
#define mmSCL2_VIEWPORT_SIZE                                                                           0x0ab0
#define mmSCL2_VIEWPORT_SIZE_BASE_IDX                                                                  2
#define mmSCL2_EXT_OVERSCAN_LEFT_RIGHT                                                                 0x0ab1
#define mmSCL2_EXT_OVERSCAN_LEFT_RIGHT_BASE_IDX                                                        2
#define mmSCL2_EXT_OVERSCAN_TOP_BOTTOM                                                                 0x0ab2
#define mmSCL2_EXT_OVERSCAN_TOP_BOTTOM_BASE_IDX                                                        2
#define mmSCL2_SCL_MODE_CHANGE_DET1                                                                    0x0ab3
#define mmSCL2_SCL_MODE_CHANGE_DET1_BASE_IDX                                                           2
#define mmSCL2_SCL_MODE_CHANGE_DET2                                                                    0x0ab4
#define mmSCL2_SCL_MODE_CHANGE_DET2_BASE_IDX                                                           2
#define mmSCL2_SCL_MODE_CHANGE_DET3                                                                    0x0ab5
#define mmSCL2_SCL_MODE_CHANGE_DET3_BASE_IDX                                                           2
#define mmSCL2_SCL_MODE_CHANGE_MASK                                                                    0x0ab6
#define mmSCL2_SCL_MODE_CHANGE_MASK_BASE_IDX                                                           2


// addressBlock: dce_dc_blnd2_dispdec
// base address: 0x1000
#define mmBLND2_BLND_CONTROL                                                                           0x0ac7
#define mmBLND2_BLND_CONTROL_BASE_IDX                                                                  2
#define mmBLND2_BLND_SM_CONTROL2                                                                       0x0ac8
#define mmBLND2_BLND_SM_CONTROL2_BASE_IDX                                                              2
#define mmBLND2_BLND_CONTROL2                                                                          0x0ac9
#define mmBLND2_BLND_CONTROL2_BASE_IDX                                                                 2
#define mmBLND2_BLND_UPDATE                                                                            0x0aca
#define mmBLND2_BLND_UPDATE_BASE_IDX                                                                   2
#define mmBLND2_BLND_UNDERFLOW_INTERRUPT                                                               0x0acb
#define mmBLND2_BLND_UNDERFLOW_INTERRUPT_BASE_IDX                                                      2
#define mmBLND2_BLND_V_UPDATE_LOCK                                                                     0x0acc
#define mmBLND2_BLND_V_UPDATE_LOCK_BASE_IDX                                                            2
#define mmBLND2_BLND_REG_UPDATE_STATUS                                                                 0x0acd
#define mmBLND2_BLND_REG_UPDATE_STATUS_BASE_IDX                                                        2


// addressBlock: dce_dc_crtc2_dispdec
// base address: 0x1000
#define mmCRTC2_CRTC_H_BLANK_EARLY_NUM                                                                 0x0ad2
#define mmCRTC2_CRTC_H_BLANK_EARLY_NUM_BASE_IDX                                                        2
#define mmCRTC2_CRTC_H_TOTAL                                                                           0x0ad3
#define mmCRTC2_CRTC_H_TOTAL_BASE_IDX                                                                  2
#define mmCRTC2_CRTC_H_BLANK_START_END                                                                 0x0ad4
#define mmCRTC2_CRTC_H_BLANK_START_END_BASE_IDX                                                        2
#define mmCRTC2_CRTC_H_SYNC_A                                                                          0x0ad5
#define mmCRTC2_CRTC_H_SYNC_A_BASE_IDX                                                                 2
#define mmCRTC2_CRTC_H_SYNC_A_CNTL                                                                     0x0ad6
#define mmCRTC2_CRTC_H_SYNC_A_CNTL_BASE_IDX                                                            2
#define mmCRTC2_CRTC_H_SYNC_B                                                                          0x0ad7
#define mmCRTC2_CRTC_H_SYNC_B_BASE_IDX                                                                 2
#define mmCRTC2_CRTC_H_SYNC_B_CNTL                                                                     0x0ad8
#define mmCRTC2_CRTC_H_SYNC_B_CNTL_BASE_IDX                                                            2
#define mmCRTC2_CRTC_VBI_END                                                                           0x0ad9
#define mmCRTC2_CRTC_VBI_END_BASE_IDX                                                                  2
#define mmCRTC2_CRTC_V_TOTAL                                                                           0x0ada
#define mmCRTC2_CRTC_V_TOTAL_BASE_IDX                                                                  2
#define mmCRTC2_CRTC_V_TOTAL_MIN                                                                       0x0adb
#define mmCRTC2_CRTC_V_TOTAL_MIN_BASE_IDX                                                              2
#define mmCRTC2_CRTC_V_TOTAL_MAX                                                                       0x0adc
#define mmCRTC2_CRTC_V_TOTAL_MAX_BASE_IDX                                                              2
#define mmCRTC2_CRTC_V_TOTAL_CONTROL                                                                   0x0add
#define mmCRTC2_CRTC_V_TOTAL_CONTROL_BASE_IDX                                                          2
#define mmCRTC2_CRTC_V_TOTAL_INT_STATUS                                                                0x0ade
#define mmCRTC2_CRTC_V_TOTAL_INT_STATUS_BASE_IDX                                                       2
#define mmCRTC2_CRTC_VSYNC_NOM_INT_STATUS                                                              0x0adf
#define mmCRTC2_CRTC_VSYNC_NOM_INT_STATUS_BASE_IDX                                                     2
#define mmCRTC2_CRTC_V_BLANK_START_END                                                                 0x0ae0
#define mmCRTC2_CRTC_V_BLANK_START_END_BASE_IDX                                                        2
#define mmCRTC2_CRTC_V_SYNC_A                                                                          0x0ae1
#define mmCRTC2_CRTC_V_SYNC_A_BASE_IDX                                                                 2
#define mmCRTC2_CRTC_V_SYNC_A_CNTL                                                                     0x0ae2
#define mmCRTC2_CRTC_V_SYNC_A_CNTL_BASE_IDX                                                            2
#define mmCRTC2_CRTC_V_SYNC_B                                                                          0x0ae3
#define mmCRTC2_CRTC_V_SYNC_B_BASE_IDX                                                                 2
#define mmCRTC2_CRTC_V_SYNC_B_CNTL                                                                     0x0ae4
#define mmCRTC2_CRTC_V_SYNC_B_CNTL_BASE_IDX                                                            2
#define mmCRTC2_CRTC_DTMTEST_CNTL                                                                      0x0ae5
#define mmCRTC2_CRTC_DTMTEST_CNTL_BASE_IDX                                                             2
#define mmCRTC2_CRTC_DTMTEST_STATUS_POSITION                                                           0x0ae6
#define mmCRTC2_CRTC_DTMTEST_STATUS_POSITION_BASE_IDX                                                  2
#define mmCRTC2_CRTC_TRIGA_CNTL                                                                        0x0ae7
#define mmCRTC2_CRTC_TRIGA_CNTL_BASE_IDX                                                               2
#define mmCRTC2_CRTC_TRIGA_MANUAL_TRIG                                                                 0x0ae8
#define mmCRTC2_CRTC_TRIGA_MANUAL_TRIG_BASE_IDX                                                        2
#define mmCRTC2_CRTC_TRIGB_CNTL                                                                        0x0ae9
#define mmCRTC2_CRTC_TRIGB_CNTL_BASE_IDX                                                               2
#define mmCRTC2_CRTC_TRIGB_MANUAL_TRIG                                                                 0x0aea
#define mmCRTC2_CRTC_TRIGB_MANUAL_TRIG_BASE_IDX                                                        2
#define mmCRTC2_CRTC_FORCE_COUNT_NOW_CNTL                                                              0x0aeb
#define mmCRTC2_CRTC_FORCE_COUNT_NOW_CNTL_BASE_IDX                                                     2
#define mmCRTC2_CRTC_FLOW_CONTROL                                                                      0x0aec
#define mmCRTC2_CRTC_FLOW_CONTROL_BASE_IDX                                                             2
#define mmCRTC2_CRTC_STEREO_FORCE_NEXT_EYE                                                             0x0aed
#define mmCRTC2_CRTC_STEREO_FORCE_NEXT_EYE_BASE_IDX                                                    2
#define mmCRTC2_CRTC_AVSYNC_COUNTER                                                                    0x0aee
#define mmCRTC2_CRTC_AVSYNC_COUNTER_BASE_IDX                                                           2
#define mmCRTC2_CRTC_CONTROL                                                                           0x0aef
#define mmCRTC2_CRTC_CONTROL_BASE_IDX                                                                  2
#define mmCRTC2_CRTC_BLANK_CONTROL                                                                     0x0af0
#define mmCRTC2_CRTC_BLANK_CONTROL_BASE_IDX                                                            2
#define mmCRTC2_CRTC_INTERLACE_CONTROL                                                                 0x0af1
#define mmCRTC2_CRTC_INTERLACE_CONTROL_BASE_IDX                                                        2
#define mmCRTC2_CRTC_INTERLACE_STATUS                                                                  0x0af2
#define mmCRTC2_CRTC_INTERLACE_STATUS_BASE_IDX                                                         2
#define mmCRTC2_CRTC_FIELD_INDICATION_CONTROL                                                          0x0af3
#define mmCRTC2_CRTC_FIELD_INDICATION_CONTROL_BASE_IDX                                                 2
#define mmCRTC2_CRTC_PIXEL_DATA_READBACK0                                                              0x0af4
#define mmCRTC2_CRTC_PIXEL_DATA_READBACK0_BASE_IDX                                                     2
#define mmCRTC2_CRTC_PIXEL_DATA_READBACK1                                                              0x0af5
#define mmCRTC2_CRTC_PIXEL_DATA_READBACK1_BASE_IDX                                                     2
#define mmCRTC2_CRTC_STATUS                                                                            0x0af6
#define mmCRTC2_CRTC_STATUS_BASE_IDX                                                                   2
#define mmCRTC2_CRTC_STATUS_POSITION                                                                   0x0af7
#define mmCRTC2_CRTC_STATUS_POSITION_BASE_IDX                                                          2
#define mmCRTC2_CRTC_NOM_VERT_POSITION                                                                 0x0af8
#define mmCRTC2_CRTC_NOM_VERT_POSITION_BASE_IDX                                                        2
#define mmCRTC2_CRTC_STATUS_FRAME_COUNT                                                                0x0af9
#define mmCRTC2_CRTC_STATUS_FRAME_COUNT_BASE_IDX                                                       2
#define mmCRTC2_CRTC_STATUS_VF_COUNT                                                                   0x0afa
#define mmCRTC2_CRTC_STATUS_VF_COUNT_BASE_IDX                                                          2
#define mmCRTC2_CRTC_STATUS_HV_COUNT                                                                   0x0afb
#define mmCRTC2_CRTC_STATUS_HV_COUNT_BASE_IDX                                                          2
#define mmCRTC2_CRTC_COUNT_CONTROL                                                                     0x0afc
#define mmCRTC2_CRTC_COUNT_CONTROL_BASE_IDX                                                            2
#define mmCRTC2_CRTC_COUNT_RESET                                                                       0x0afd
#define mmCRTC2_CRTC_COUNT_RESET_BASE_IDX                                                              2
#define mmCRTC2_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE                                                      0x0afe
#define mmCRTC2_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE_BASE_IDX                                             2
#define mmCRTC2_CRTC_VERT_SYNC_CONTROL                                                                 0x0aff
#define mmCRTC2_CRTC_VERT_SYNC_CONTROL_BASE_IDX                                                        2
#define mmCRTC2_CRTC_STEREO_STATUS                                                                     0x0b00
#define mmCRTC2_CRTC_STEREO_STATUS_BASE_IDX                                                            2
#define mmCRTC2_CRTC_STEREO_CONTROL                                                                    0x0b01
#define mmCRTC2_CRTC_STEREO_CONTROL_BASE_IDX                                                           2
#define mmCRTC2_CRTC_SNAPSHOT_STATUS                                                                   0x0b02
#define mmCRTC2_CRTC_SNAPSHOT_STATUS_BASE_IDX                                                          2
#define mmCRTC2_CRTC_SNAPSHOT_CONTROL                                                                  0x0b03
#define mmCRTC2_CRTC_SNAPSHOT_CONTROL_BASE_IDX                                                         2
#define mmCRTC2_CRTC_SNAPSHOT_POSITION                                                                 0x0b04
#define mmCRTC2_CRTC_SNAPSHOT_POSITION_BASE_IDX                                                        2
#define mmCRTC2_CRTC_SNAPSHOT_FRAME                                                                    0x0b05
#define mmCRTC2_CRTC_SNAPSHOT_FRAME_BASE_IDX                                                           2
#define mmCRTC2_CRTC_START_LINE_CONTROL                                                                0x0b06
#define mmCRTC2_CRTC_START_LINE_CONTROL_BASE_IDX                                                       2
#define mmCRTC2_CRTC_INTERRUPT_CONTROL                                                                 0x0b07
#define mmCRTC2_CRTC_INTERRUPT_CONTROL_BASE_IDX                                                        2
#define mmCRTC2_CRTC_UPDATE_LOCK                                                                       0x0b08
#define mmCRTC2_CRTC_UPDATE_LOCK_BASE_IDX                                                              2
#define mmCRTC2_CRTC_DOUBLE_BUFFER_CONTROL                                                             0x0b09
#define mmCRTC2_CRTC_DOUBLE_BUFFER_CONTROL_BASE_IDX                                                    2
#define mmCRTC2_CRTC_VGA_PARAMETER_CAPTURE_MODE                                                        0x0b0a
#define mmCRTC2_CRTC_VGA_PARAMETER_CAPTURE_MODE_BASE_IDX                                               2
#define mmCRTC2_CRTC_TEST_PATTERN_CONTROL                                                              0x0b0b
#define mmCRTC2_CRTC_TEST_PATTERN_CONTROL_BASE_IDX                                                     2
#define mmCRTC2_CRTC_TEST_PATTERN_PARAMETERS                                                           0x0b0c
#define mmCRTC2_CRTC_TEST_PATTERN_PARAMETERS_BASE_IDX                                                  2
#define mmCRTC2_CRTC_TEST_PATTERN_COLOR                                                                0x0b0d
#define mmCRTC2_CRTC_TEST_PATTERN_COLOR_BASE_IDX                                                       2
#define mmCRTC2_CRTC_MASTER_UPDATE_LOCK                                                                0x0b0e
#define mmCRTC2_CRTC_MASTER_UPDATE_LOCK_BASE_IDX                                                       2
#define mmCRTC2_CRTC_MASTER_UPDATE_MODE                                                                0x0b0f
#define mmCRTC2_CRTC_MASTER_UPDATE_MODE_BASE_IDX                                                       2
#define mmCRTC2_CRTC_MVP_INBAND_CNTL_INSERT                                                            0x0b10
#define mmCRTC2_CRTC_MVP_INBAND_CNTL_INSERT_BASE_IDX                                                   2
#define mmCRTC2_CRTC_MVP_INBAND_CNTL_INSERT_TIMER                                                      0x0b11
#define mmCRTC2_CRTC_MVP_INBAND_CNTL_INSERT_TIMER_BASE_IDX                                             2
#define mmCRTC2_CRTC_MVP_STATUS                                                                        0x0b12
#define mmCRTC2_CRTC_MVP_STATUS_BASE_IDX                                                               2
#define mmCRTC2_CRTC_MASTER_EN                                                                         0x0b13
#define mmCRTC2_CRTC_MASTER_EN_BASE_IDX                                                                2
#define mmCRTC2_CRTC_ALLOW_STOP_OFF_V_CNT                                                              0x0b14
#define mmCRTC2_CRTC_ALLOW_STOP_OFF_V_CNT_BASE_IDX                                                     2
#define mmCRTC2_CRTC_V_UPDATE_INT_STATUS                                                               0x0b15
#define mmCRTC2_CRTC_V_UPDATE_INT_STATUS_BASE_IDX                                                      2
#define mmCRTC2_CRTC_OVERSCAN_COLOR                                                                    0x0b17
#define mmCRTC2_CRTC_OVERSCAN_COLOR_BASE_IDX                                                           2
#define mmCRTC2_CRTC_OVERSCAN_COLOR_EXT                                                                0x0b18
#define mmCRTC2_CRTC_OVERSCAN_COLOR_EXT_BASE_IDX                                                       2
#define mmCRTC2_CRTC_BLANK_DATA_COLOR                                                                  0x0b19
#define mmCRTC2_CRTC_BLANK_DATA_COLOR_BASE_IDX                                                         2
#define mmCRTC2_CRTC_BLANK_DATA_COLOR_EXT                                                              0x0b1a
#define mmCRTC2_CRTC_BLANK_DATA_COLOR_EXT_BASE_IDX                                                     2
#define mmCRTC2_CRTC_BLACK_COLOR                                                                       0x0b1b
#define mmCRTC2_CRTC_BLACK_COLOR_BASE_IDX                                                              2
#define mmCRTC2_CRTC_BLACK_COLOR_EXT                                                                   0x0b1c
#define mmCRTC2_CRTC_BLACK_COLOR_EXT_BASE_IDX                                                          2
#define mmCRTC2_CRTC_VERTICAL_INTERRUPT0_POSITION                                                      0x0b1d
#define mmCRTC2_CRTC_VERTICAL_INTERRUPT0_POSITION_BASE_IDX                                             2
#define mmCRTC2_CRTC_VERTICAL_INTERRUPT0_CONTROL                                                       0x0b1e
#define mmCRTC2_CRTC_VERTICAL_INTERRUPT0_CONTROL_BASE_IDX                                              2
#define mmCRTC2_CRTC_VERTICAL_INTERRUPT1_POSITION                                                      0x0b1f
#define mmCRTC2_CRTC_VERTICAL_INTERRUPT1_POSITION_BASE_IDX                                             2
#define mmCRTC2_CRTC_VERTICAL_INTERRUPT1_CONTROL                                                       0x0b20
#define mmCRTC2_CRTC_VERTICAL_INTERRUPT1_CONTROL_BASE_IDX                                              2
#define mmCRTC2_CRTC_VERTICAL_INTERRUPT2_POSITION                                                      0x0b21
#define mmCRTC2_CRTC_VERTICAL_INTERRUPT2_POSITION_BASE_IDX                                             2
#define mmCRTC2_CRTC_VERTICAL_INTERRUPT2_CONTROL                                                       0x0b22
#define mmCRTC2_CRTC_VERTICAL_INTERRUPT2_CONTROL_BASE_IDX                                              2
#define mmCRTC2_CRTC_CRC_CNTL                                                                          0x0b23
#define mmCRTC2_CRTC_CRC_CNTL_BASE_IDX                                                                 2
#define mmCRTC2_CRTC_CRC0_WINDOWA_X_CONTROL                                                            0x0b24
#define mmCRTC2_CRTC_CRC0_WINDOWA_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC2_CRTC_CRC0_WINDOWA_Y_CONTROL                                                            0x0b25
#define mmCRTC2_CRTC_CRC0_WINDOWA_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC2_CRTC_CRC0_WINDOWB_X_CONTROL                                                            0x0b26
#define mmCRTC2_CRTC_CRC0_WINDOWB_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC2_CRTC_CRC0_WINDOWB_Y_CONTROL                                                            0x0b27
#define mmCRTC2_CRTC_CRC0_WINDOWB_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC2_CRTC_CRC0_DATA_RG                                                                      0x0b28
#define mmCRTC2_CRTC_CRC0_DATA_RG_BASE_IDX                                                             2
#define mmCRTC2_CRTC_CRC0_DATA_B                                                                       0x0b29
#define mmCRTC2_CRTC_CRC0_DATA_B_BASE_IDX                                                              2
#define mmCRTC2_CRTC_CRC1_WINDOWA_X_CONTROL                                                            0x0b2a
#define mmCRTC2_CRTC_CRC1_WINDOWA_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC2_CRTC_CRC1_WINDOWA_Y_CONTROL                                                            0x0b2b
#define mmCRTC2_CRTC_CRC1_WINDOWA_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC2_CRTC_CRC1_WINDOWB_X_CONTROL                                                            0x0b2c
#define mmCRTC2_CRTC_CRC1_WINDOWB_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC2_CRTC_CRC1_WINDOWB_Y_CONTROL                                                            0x0b2d
#define mmCRTC2_CRTC_CRC1_WINDOWB_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC2_CRTC_CRC1_DATA_RG                                                                      0x0b2e
#define mmCRTC2_CRTC_CRC1_DATA_RG_BASE_IDX                                                             2
#define mmCRTC2_CRTC_CRC1_DATA_B                                                                       0x0b2f
#define mmCRTC2_CRTC_CRC1_DATA_B_BASE_IDX                                                              2
#define mmCRTC2_CRTC_EXT_TIMING_SYNC_CONTROL                                                           0x0b30
#define mmCRTC2_CRTC_EXT_TIMING_SYNC_CONTROL_BASE_IDX                                                  2
#define mmCRTC2_CRTC_EXT_TIMING_SYNC_WINDOW_START                                                      0x0b31
#define mmCRTC2_CRTC_EXT_TIMING_SYNC_WINDOW_START_BASE_IDX                                             2
#define mmCRTC2_CRTC_EXT_TIMING_SYNC_WINDOW_END                                                        0x0b32
#define mmCRTC2_CRTC_EXT_TIMING_SYNC_WINDOW_END_BASE_IDX                                               2
#define mmCRTC2_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL                                            0x0b33
#define mmCRTC2_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_BASE_IDX                                   2
#define mmCRTC2_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL                                                 0x0b34
#define mmCRTC2_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL_BASE_IDX                                        2
#define mmCRTC2_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL                                          0x0b35
#define mmCRTC2_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL_BASE_IDX                                 2
#define mmCRTC2_CRTC_STATIC_SCREEN_CONTROL                                                             0x0b36
#define mmCRTC2_CRTC_STATIC_SCREEN_CONTROL_BASE_IDX                                                    2
#define mmCRTC2_CRTC_3D_STRUCTURE_CONTROL                                                              0x0b37
#define mmCRTC2_CRTC_3D_STRUCTURE_CONTROL_BASE_IDX                                                     2
#define mmCRTC2_CRTC_GSL_VSYNC_GAP                                                                     0x0b38
#define mmCRTC2_CRTC_GSL_VSYNC_GAP_BASE_IDX                                                            2
#define mmCRTC2_CRTC_GSL_WINDOW                                                                        0x0b39
#define mmCRTC2_CRTC_GSL_WINDOW_BASE_IDX                                                               2
#define mmCRTC2_CRTC_GSL_CONTROL                                                                       0x0b3a
#define mmCRTC2_CRTC_GSL_CONTROL_BASE_IDX                                                              2
#define mmCRTC2_CRTC_RANGE_TIMING_INT_STATUS                                                           0x0b3d
#define mmCRTC2_CRTC_RANGE_TIMING_INT_STATUS_BASE_IDX                                                  2
#define mmCRTC2_CRTC_DRR_CONTROL                                                                       0x0b3e
#define mmCRTC2_CRTC_DRR_CONTROL_BASE_IDX                                                              2


// addressBlock: dce_dc_fmt2_dispdec
// base address: 0x1000
#define mmFMT2_FMT_CLAMP_COMPONENT_R                                                                   0x0b42
#define mmFMT2_FMT_CLAMP_COMPONENT_R_BASE_IDX                                                          2
#define mmFMT2_FMT_CLAMP_COMPONENT_G                                                                   0x0b43
#define mmFMT2_FMT_CLAMP_COMPONENT_G_BASE_IDX                                                          2
#define mmFMT2_FMT_CLAMP_COMPONENT_B                                                                   0x0b44
#define mmFMT2_FMT_CLAMP_COMPONENT_B_BASE_IDX                                                          2
#define mmFMT2_FMT_DYNAMIC_EXP_CNTL                                                                    0x0b45
#define mmFMT2_FMT_DYNAMIC_EXP_CNTL_BASE_IDX                                                           2
#define mmFMT2_FMT_CONTROL                                                                             0x0b46
#define mmFMT2_FMT_CONTROL_BASE_IDX                                                                    2
#define mmFMT2_FMT_BIT_DEPTH_CONTROL                                                                   0x0b47
#define mmFMT2_FMT_BIT_DEPTH_CONTROL_BASE_IDX                                                          2
#define mmFMT2_FMT_DITHER_RAND_R_SEED                                                                  0x0b48
#define mmFMT2_FMT_DITHER_RAND_R_SEED_BASE_IDX                                                         2
#define mmFMT2_FMT_DITHER_RAND_G_SEED                                                                  0x0b49
#define mmFMT2_FMT_DITHER_RAND_G_SEED_BASE_IDX                                                         2
#define mmFMT2_FMT_DITHER_RAND_B_SEED                                                                  0x0b4a
#define mmFMT2_FMT_DITHER_RAND_B_SEED_BASE_IDX                                                         2
#define mmFMT2_FMT_CLAMP_CNTL                                                                          0x0b4e
#define mmFMT2_FMT_CLAMP_CNTL_BASE_IDX                                                                 2
#define mmFMT2_FMT_CRC_CNTL                                                                            0x0b4f
#define mmFMT2_FMT_CRC_CNTL_BASE_IDX                                                                   2
#define mmFMT2_FMT_CRC_SIG_RED_GREEN_MASK                                                              0x0b50
#define mmFMT2_FMT_CRC_SIG_RED_GREEN_MASK_BASE_IDX                                                     2
#define mmFMT2_FMT_CRC_SIG_BLUE_CONTROL_MASK                                                           0x0b51
#define mmFMT2_FMT_CRC_SIG_BLUE_CONTROL_MASK_BASE_IDX                                                  2
#define mmFMT2_FMT_CRC_SIG_RED_GREEN                                                                   0x0b52
#define mmFMT2_FMT_CRC_SIG_RED_GREEN_BASE_IDX                                                          2
#define mmFMT2_FMT_CRC_SIG_BLUE_CONTROL                                                                0x0b53
#define mmFMT2_FMT_CRC_SIG_BLUE_CONTROL_BASE_IDX                                                       2
#define mmFMT2_FMT_SIDE_BY_SIDE_STEREO_CONTROL                                                         0x0b54
#define mmFMT2_FMT_SIDE_BY_SIDE_STEREO_CONTROL_BASE_IDX                                                2
#define mmFMT2_FMT_420_HBLANK_EARLY_START                                                              0x0b55
#define mmFMT2_FMT_420_HBLANK_EARLY_START_BASE_IDX                                                     2


// addressBlock: dce_dc_dcp3_dispdec
// base address: 0x1800
#define mmDCP3_GRPH_ENABLE                                                                             0x0b5a
#define mmDCP3_GRPH_ENABLE_BASE_IDX                                                                    2
#define mmDCP3_GRPH_CONTROL                                                                            0x0b5b
#define mmDCP3_GRPH_CONTROL_BASE_IDX                                                                   2
#define mmDCP3_GRPH_LUT_10BIT_BYPASS                                                                   0x0b5c
#define mmDCP3_GRPH_LUT_10BIT_BYPASS_BASE_IDX                                                          2
#define mmDCP3_GRPH_SWAP_CNTL                                                                          0x0b5d
#define mmDCP3_GRPH_SWAP_CNTL_BASE_IDX                                                                 2
#define mmDCP3_GRPH_PRIMARY_SURFACE_ADDRESS                                                            0x0b5e
#define mmDCP3_GRPH_PRIMARY_SURFACE_ADDRESS_BASE_IDX                                                   2
#define mmDCP3_GRPH_SECONDARY_SURFACE_ADDRESS                                                          0x0b5f
#define mmDCP3_GRPH_SECONDARY_SURFACE_ADDRESS_BASE_IDX                                                 2
#define mmDCP3_GRPH_PITCH                                                                              0x0b60
#define mmDCP3_GRPH_PITCH_BASE_IDX                                                                     2
#define mmDCP3_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH                                                       0x0b61
#define mmDCP3_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                              2
#define mmDCP3_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH                                                     0x0b62
#define mmDCP3_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                            2
#define mmDCP3_GRPH_SURFACE_OFFSET_X                                                                   0x0b63
#define mmDCP3_GRPH_SURFACE_OFFSET_X_BASE_IDX                                                          2
#define mmDCP3_GRPH_SURFACE_OFFSET_Y                                                                   0x0b64
#define mmDCP3_GRPH_SURFACE_OFFSET_Y_BASE_IDX                                                          2
#define mmDCP3_GRPH_X_START                                                                            0x0b65
#define mmDCP3_GRPH_X_START_BASE_IDX                                                                   2
#define mmDCP3_GRPH_Y_START                                                                            0x0b66
#define mmDCP3_GRPH_Y_START_BASE_IDX                                                                   2
#define mmDCP3_GRPH_X_END                                                                              0x0b67
#define mmDCP3_GRPH_X_END_BASE_IDX                                                                     2
#define mmDCP3_GRPH_Y_END                                                                              0x0b68
#define mmDCP3_GRPH_Y_END_BASE_IDX                                                                     2
#define mmDCP3_INPUT_GAMMA_CONTROL                                                                     0x0b69
#define mmDCP3_INPUT_GAMMA_CONTROL_BASE_IDX                                                            2
#define mmDCP3_GRPH_UPDATE                                                                             0x0b6a
#define mmDCP3_GRPH_UPDATE_BASE_IDX                                                                    2
#define mmDCP3_GRPH_FLIP_CONTROL                                                                       0x0b6b
#define mmDCP3_GRPH_FLIP_CONTROL_BASE_IDX                                                              2
#define mmDCP3_GRPH_SURFACE_ADDRESS_INUSE                                                              0x0b6c
#define mmDCP3_GRPH_SURFACE_ADDRESS_INUSE_BASE_IDX                                                     2
#define mmDCP3_GRPH_DFQ_CONTROL                                                                        0x0b6d
#define mmDCP3_GRPH_DFQ_CONTROL_BASE_IDX                                                               2
#define mmDCP3_GRPH_DFQ_STATUS                                                                         0x0b6e
#define mmDCP3_GRPH_DFQ_STATUS_BASE_IDX                                                                2
#define mmDCP3_GRPH_INTERRUPT_STATUS                                                                   0x0b6f
#define mmDCP3_GRPH_INTERRUPT_STATUS_BASE_IDX                                                          2
#define mmDCP3_GRPH_INTERRUPT_CONTROL                                                                  0x0b70
#define mmDCP3_GRPH_INTERRUPT_CONTROL_BASE_IDX                                                         2
#define mmDCP3_GRPH_SURFACE_ADDRESS_HIGH_INUSE                                                         0x0b71
#define mmDCP3_GRPH_SURFACE_ADDRESS_HIGH_INUSE_BASE_IDX                                                2
#define mmDCP3_GRPH_COMPRESS_SURFACE_ADDRESS                                                           0x0b72
#define mmDCP3_GRPH_COMPRESS_SURFACE_ADDRESS_BASE_IDX                                                  2
#define mmDCP3_GRPH_COMPRESS_PITCH                                                                     0x0b73
#define mmDCP3_GRPH_COMPRESS_PITCH_BASE_IDX                                                            2
#define mmDCP3_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH                                                      0x0b74
#define mmDCP3_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH_BASE_IDX                                             2
#define mmDCP3_GRPH_PIPE_OUTSTANDING_REQUEST_LIMIT                                                     0x0b75
#define mmDCP3_GRPH_PIPE_OUTSTANDING_REQUEST_LIMIT_BASE_IDX                                            2
#define mmDCP3_PRESCALE_GRPH_CONTROL                                                                   0x0b76
#define mmDCP3_PRESCALE_GRPH_CONTROL_BASE_IDX                                                          2
#define mmDCP3_PRESCALE_VALUES_GRPH_R                                                                  0x0b77
#define mmDCP3_PRESCALE_VALUES_GRPH_R_BASE_IDX                                                         2
#define mmDCP3_PRESCALE_VALUES_GRPH_G                                                                  0x0b78
#define mmDCP3_PRESCALE_VALUES_GRPH_G_BASE_IDX                                                         2
#define mmDCP3_PRESCALE_VALUES_GRPH_B                                                                  0x0b79
#define mmDCP3_PRESCALE_VALUES_GRPH_B_BASE_IDX                                                         2
#define mmDCP3_INPUT_CSC_CONTROL                                                                       0x0b7a
#define mmDCP3_INPUT_CSC_CONTROL_BASE_IDX                                                              2
#define mmDCP3_INPUT_CSC_C11_C12                                                                       0x0b7b
#define mmDCP3_INPUT_CSC_C11_C12_BASE_IDX                                                              2
#define mmDCP3_INPUT_CSC_C13_C14                                                                       0x0b7c
#define mmDCP3_INPUT_CSC_C13_C14_BASE_IDX                                                              2
#define mmDCP3_INPUT_CSC_C21_C22                                                                       0x0b7d
#define mmDCP3_INPUT_CSC_C21_C22_BASE_IDX                                                              2
#define mmDCP3_INPUT_CSC_C23_C24                                                                       0x0b7e
#define mmDCP3_INPUT_CSC_C23_C24_BASE_IDX                                                              2
#define mmDCP3_INPUT_CSC_C31_C32                                                                       0x0b7f
#define mmDCP3_INPUT_CSC_C31_C32_BASE_IDX                                                              2
#define mmDCP3_INPUT_CSC_C33_C34                                                                       0x0b80
#define mmDCP3_INPUT_CSC_C33_C34_BASE_IDX                                                              2
#define mmDCP3_OUTPUT_CSC_CONTROL                                                                      0x0b81
#define mmDCP3_OUTPUT_CSC_CONTROL_BASE_IDX                                                             2
#define mmDCP3_OUTPUT_CSC_C11_C12                                                                      0x0b82
#define mmDCP3_OUTPUT_CSC_C11_C12_BASE_IDX                                                             2
#define mmDCP3_OUTPUT_CSC_C13_C14                                                                      0x0b83
#define mmDCP3_OUTPUT_CSC_C13_C14_BASE_IDX                                                             2
#define mmDCP3_OUTPUT_CSC_C21_C22                                                                      0x0b84
#define mmDCP3_OUTPUT_CSC_C21_C22_BASE_IDX                                                             2
#define mmDCP3_OUTPUT_CSC_C23_C24                                                                      0x0b85
#define mmDCP3_OUTPUT_CSC_C23_C24_BASE_IDX                                                             2
#define mmDCP3_OUTPUT_CSC_C31_C32                                                                      0x0b86
#define mmDCP3_OUTPUT_CSC_C31_C32_BASE_IDX                                                             2
#define mmDCP3_OUTPUT_CSC_C33_C34                                                                      0x0b87
#define mmDCP3_OUTPUT_CSC_C33_C34_BASE_IDX                                                             2
#define mmDCP3_COMM_MATRIXA_TRANS_C11_C12                                                              0x0b88
#define mmDCP3_COMM_MATRIXA_TRANS_C11_C12_BASE_IDX                                                     2
#define mmDCP3_COMM_MATRIXA_TRANS_C13_C14                                                              0x0b89
#define mmDCP3_COMM_MATRIXA_TRANS_C13_C14_BASE_IDX                                                     2
#define mmDCP3_COMM_MATRIXA_TRANS_C21_C22                                                              0x0b8a
#define mmDCP3_COMM_MATRIXA_TRANS_C21_C22_BASE_IDX                                                     2
#define mmDCP3_COMM_MATRIXA_TRANS_C23_C24                                                              0x0b8b
#define mmDCP3_COMM_MATRIXA_TRANS_C23_C24_BASE_IDX                                                     2
#define mmDCP3_COMM_MATRIXA_TRANS_C31_C32                                                              0x0b8c
#define mmDCP3_COMM_MATRIXA_TRANS_C31_C32_BASE_IDX                                                     2
#define mmDCP3_COMM_MATRIXA_TRANS_C33_C34                                                              0x0b8d
#define mmDCP3_COMM_MATRIXA_TRANS_C33_C34_BASE_IDX                                                     2
#define mmDCP3_COMM_MATRIXB_TRANS_C11_C12                                                              0x0b8e
#define mmDCP3_COMM_MATRIXB_TRANS_C11_C12_BASE_IDX                                                     2
#define mmDCP3_COMM_MATRIXB_TRANS_C13_C14                                                              0x0b8f
#define mmDCP3_COMM_MATRIXB_TRANS_C13_C14_BASE_IDX                                                     2
#define mmDCP3_COMM_MATRIXB_TRANS_C21_C22                                                              0x0b90
#define mmDCP3_COMM_MATRIXB_TRANS_C21_C22_BASE_IDX                                                     2
#define mmDCP3_COMM_MATRIXB_TRANS_C23_C24                                                              0x0b91
#define mmDCP3_COMM_MATRIXB_TRANS_C23_C24_BASE_IDX                                                     2
#define mmDCP3_COMM_MATRIXB_TRANS_C31_C32                                                              0x0b92
#define mmDCP3_COMM_MATRIXB_TRANS_C31_C32_BASE_IDX                                                     2
#define mmDCP3_COMM_MATRIXB_TRANS_C33_C34                                                              0x0b93
#define mmDCP3_COMM_MATRIXB_TRANS_C33_C34_BASE_IDX                                                     2
#define mmDCP3_DENORM_CONTROL                                                                          0x0b94
#define mmDCP3_DENORM_CONTROL_BASE_IDX                                                                 2
#define mmDCP3_OUT_ROUND_CONTROL                                                                       0x0b95
#define mmDCP3_OUT_ROUND_CONTROL_BASE_IDX                                                              2
#define mmDCP3_OUT_CLAMP_CONTROL_R_CR                                                                  0x0b96
#define mmDCP3_OUT_CLAMP_CONTROL_R_CR_BASE_IDX                                                         2
#define mmDCP3_OUT_CLAMP_CONTROL_G_Y                                                                   0x0b97
#define mmDCP3_OUT_CLAMP_CONTROL_G_Y_BASE_IDX                                                          2
#define mmDCP3_OUT_CLAMP_CONTROL_B_CB                                                                  0x0b98
#define mmDCP3_OUT_CLAMP_CONTROL_B_CB_BASE_IDX                                                         2
#define mmDCP3_KEY_CONTROL                                                                             0x0b99
#define mmDCP3_KEY_CONTROL_BASE_IDX                                                                    2
#define mmDCP3_KEY_RANGE_ALPHA                                                                         0x0b9a
#define mmDCP3_KEY_RANGE_ALPHA_BASE_IDX                                                                2
#define mmDCP3_KEY_RANGE_RED                                                                           0x0b9b
#define mmDCP3_KEY_RANGE_RED_BASE_IDX                                                                  2
#define mmDCP3_KEY_RANGE_GREEN                                                                         0x0b9c
#define mmDCP3_KEY_RANGE_GREEN_BASE_IDX                                                                2
#define mmDCP3_KEY_RANGE_BLUE                                                                          0x0b9d
#define mmDCP3_KEY_RANGE_BLUE_BASE_IDX                                                                 2
#define mmDCP3_DEGAMMA_CONTROL                                                                         0x0b9e
#define mmDCP3_DEGAMMA_CONTROL_BASE_IDX                                                                2
#define mmDCP3_GAMUT_REMAP_CONTROL                                                                     0x0b9f
#define mmDCP3_GAMUT_REMAP_CONTROL_BASE_IDX                                                            2
#define mmDCP3_GAMUT_REMAP_C11_C12                                                                     0x0ba0
#define mmDCP3_GAMUT_REMAP_C11_C12_BASE_IDX                                                            2
#define mmDCP3_GAMUT_REMAP_C13_C14                                                                     0x0ba1
#define mmDCP3_GAMUT_REMAP_C13_C14_BASE_IDX                                                            2
#define mmDCP3_GAMUT_REMAP_C21_C22                                                                     0x0ba2
#define mmDCP3_GAMUT_REMAP_C21_C22_BASE_IDX                                                            2
#define mmDCP3_GAMUT_REMAP_C23_C24                                                                     0x0ba3
#define mmDCP3_GAMUT_REMAP_C23_C24_BASE_IDX                                                            2
#define mmDCP3_GAMUT_REMAP_C31_C32                                                                     0x0ba4
#define mmDCP3_GAMUT_REMAP_C31_C32_BASE_IDX                                                            2
#define mmDCP3_GAMUT_REMAP_C33_C34                                                                     0x0ba5
#define mmDCP3_GAMUT_REMAP_C33_C34_BASE_IDX                                                            2
#define mmDCP3_DCP_SPATIAL_DITHER_CNTL                                                                 0x0ba6
#define mmDCP3_DCP_SPATIAL_DITHER_CNTL_BASE_IDX                                                        2
#define mmDCP3_DCP_RANDOM_SEEDS                                                                        0x0ba7
#define mmDCP3_DCP_RANDOM_SEEDS_BASE_IDX                                                               2
#define mmDCP3_DCP_FP_CONVERTED_FIELD                                                                  0x0ba8
#define mmDCP3_DCP_FP_CONVERTED_FIELD_BASE_IDX                                                         2
#define mmDCP3_CUR_CONTROL                                                                             0x0ba9
#define mmDCP3_CUR_CONTROL_BASE_IDX                                                                    2
#define mmDCP3_CUR_SURFACE_ADDRESS                                                                     0x0baa
#define mmDCP3_CUR_SURFACE_ADDRESS_BASE_IDX                                                            2
#define mmDCP3_CUR_SIZE                                                                                0x0bab
#define mmDCP3_CUR_SIZE_BASE_IDX                                                                       2
#define mmDCP3_CUR_SURFACE_ADDRESS_HIGH                                                                0x0bac
#define mmDCP3_CUR_SURFACE_ADDRESS_HIGH_BASE_IDX                                                       2
#define mmDCP3_CUR_POSITION                                                                            0x0bad
#define mmDCP3_CUR_POSITION_BASE_IDX                                                                   2
#define mmDCP3_CUR_HOT_SPOT                                                                            0x0bae
#define mmDCP3_CUR_HOT_SPOT_BASE_IDX                                                                   2
#define mmDCP3_CUR_COLOR1                                                                              0x0baf
#define mmDCP3_CUR_COLOR1_BASE_IDX                                                                     2
#define mmDCP3_CUR_COLOR2                                                                              0x0bb0
#define mmDCP3_CUR_COLOR2_BASE_IDX                                                                     2
#define mmDCP3_CUR_UPDATE                                                                              0x0bb1
#define mmDCP3_CUR_UPDATE_BASE_IDX                                                                     2
#define mmDCP3_CUR_REQUEST_FILTER_CNTL                                                                 0x0bbb
#define mmDCP3_CUR_REQUEST_FILTER_CNTL_BASE_IDX                                                        2
#define mmDCP3_CUR_STEREO_CONTROL                                                                      0x0bbc
#define mmDCP3_CUR_STEREO_CONTROL_BASE_IDX                                                             2
#define mmDCP3_DC_LUT_RW_MODE                                                                          0x0bbe
#define mmDCP3_DC_LUT_RW_MODE_BASE_IDX                                                                 2
#define mmDCP3_DC_LUT_RW_INDEX                                                                         0x0bbf
#define mmDCP3_DC_LUT_RW_INDEX_BASE_IDX                                                                2
#define mmDCP3_DC_LUT_SEQ_COLOR                                                                        0x0bc0
#define mmDCP3_DC_LUT_SEQ_COLOR_BASE_IDX                                                               2
#define mmDCP3_DC_LUT_PWL_DATA                                                                         0x0bc1
#define mmDCP3_DC_LUT_PWL_DATA_BASE_IDX                                                                2
#define mmDCP3_DC_LUT_30_COLOR                                                                         0x0bc2
#define mmDCP3_DC_LUT_30_COLOR_BASE_IDX                                                                2
#define mmDCP3_DC_LUT_VGA_ACCESS_ENABLE                                                                0x0bc3
#define mmDCP3_DC_LUT_VGA_ACCESS_ENABLE_BASE_IDX                                                       2
#define mmDCP3_DC_LUT_WRITE_EN_MASK                                                                    0x0bc4
#define mmDCP3_DC_LUT_WRITE_EN_MASK_BASE_IDX                                                           2
#define mmDCP3_DC_LUT_AUTOFILL                                                                         0x0bc5
#define mmDCP3_DC_LUT_AUTOFILL_BASE_IDX                                                                2
#define mmDCP3_DC_LUT_CONTROL                                                                          0x0bc6
#define mmDCP3_DC_LUT_CONTROL_BASE_IDX                                                                 2
#define mmDCP3_DC_LUT_BLACK_OFFSET_BLUE                                                                0x0bc7
#define mmDCP3_DC_LUT_BLACK_OFFSET_BLUE_BASE_IDX                                                       2
#define mmDCP3_DC_LUT_BLACK_OFFSET_GREEN                                                               0x0bc8
#define mmDCP3_DC_LUT_BLACK_OFFSET_GREEN_BASE_IDX                                                      2
#define mmDCP3_DC_LUT_BLACK_OFFSET_RED                                                                 0x0bc9
#define mmDCP3_DC_LUT_BLACK_OFFSET_RED_BASE_IDX                                                        2
#define mmDCP3_DC_LUT_WHITE_OFFSET_BLUE                                                                0x0bca
#define mmDCP3_DC_LUT_WHITE_OFFSET_BLUE_BASE_IDX                                                       2
#define mmDCP3_DC_LUT_WHITE_OFFSET_GREEN                                                               0x0bcb
#define mmDCP3_DC_LUT_WHITE_OFFSET_GREEN_BASE_IDX                                                      2
#define mmDCP3_DC_LUT_WHITE_OFFSET_RED                                                                 0x0bcc
#define mmDCP3_DC_LUT_WHITE_OFFSET_RED_BASE_IDX                                                        2
#define mmDCP3_DCP_CRC_CONTROL                                                                         0x0bcd
#define mmDCP3_DCP_CRC_CONTROL_BASE_IDX                                                                2
#define mmDCP3_DCP_CRC_MASK                                                                            0x0bce
#define mmDCP3_DCP_CRC_MASK_BASE_IDX                                                                   2
#define mmDCP3_DCP_CRC_CURRENT                                                                         0x0bcf
#define mmDCP3_DCP_CRC_CURRENT_BASE_IDX                                                                2
#define mmDCP3_DVMM_PTE_CONTROL                                                                        0x0bd0
#define mmDCP3_DVMM_PTE_CONTROL_BASE_IDX                                                               2
#define mmDCP3_DCP_CRC_LAST                                                                            0x0bd1
#define mmDCP3_DCP_CRC_LAST_BASE_IDX                                                                   2
#define mmDCP3_DVMM_PTE_ARB_CONTROL                                                                    0x0bd2
#define mmDCP3_DVMM_PTE_ARB_CONTROL_BASE_IDX                                                           2
#define mmDCP3_GRPH_FLIP_RATE_CNTL                                                                     0x0bd4
#define mmDCP3_GRPH_FLIP_RATE_CNTL_BASE_IDX                                                            2
#define mmDCP3_DCP_GSL_CONTROL                                                                         0x0bd5
#define mmDCP3_DCP_GSL_CONTROL_BASE_IDX                                                                2
#define mmDCP3_DCP_LB_DATA_GAP_BETWEEN_CHUNK                                                           0x0bd6
#define mmDCP3_DCP_LB_DATA_GAP_BETWEEN_CHUNK_BASE_IDX                                                  2
#define mmDCP3_GRPH_STEREOSYNC_FLIP                                                                    0x0bdc
#define mmDCP3_GRPH_STEREOSYNC_FLIP_BASE_IDX                                                           2
#define mmDCP3_HW_ROTATION                                                                             0x0bde
#define mmDCP3_HW_ROTATION_BASE_IDX                                                                    2
#define mmDCP3_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL                                                      0x0bdf
#define mmDCP3_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL_BASE_IDX                                             2
#define mmDCP3_REGAMMA_CONTROL                                                                         0x0be0
#define mmDCP3_REGAMMA_CONTROL_BASE_IDX                                                                2
#define mmDCP3_REGAMMA_LUT_INDEX                                                                       0x0be1
#define mmDCP3_REGAMMA_LUT_INDEX_BASE_IDX                                                              2
#define mmDCP3_REGAMMA_LUT_DATA                                                                        0x0be2
#define mmDCP3_REGAMMA_LUT_DATA_BASE_IDX                                                               2
#define mmDCP3_REGAMMA_LUT_WRITE_EN_MASK                                                               0x0be3
#define mmDCP3_REGAMMA_LUT_WRITE_EN_MASK_BASE_IDX                                                      2
#define mmDCP3_REGAMMA_CNTLA_START_CNTL                                                                0x0be4
#define mmDCP3_REGAMMA_CNTLA_START_CNTL_BASE_IDX                                                       2
#define mmDCP3_REGAMMA_CNTLA_SLOPE_CNTL                                                                0x0be5
#define mmDCP3_REGAMMA_CNTLA_SLOPE_CNTL_BASE_IDX                                                       2
#define mmDCP3_REGAMMA_CNTLA_END_CNTL1                                                                 0x0be6
#define mmDCP3_REGAMMA_CNTLA_END_CNTL1_BASE_IDX                                                        2
#define mmDCP3_REGAMMA_CNTLA_END_CNTL2                                                                 0x0be7
#define mmDCP3_REGAMMA_CNTLA_END_CNTL2_BASE_IDX                                                        2
#define mmDCP3_REGAMMA_CNTLA_REGION_0_1                                                                0x0be8
#define mmDCP3_REGAMMA_CNTLA_REGION_0_1_BASE_IDX                                                       2
#define mmDCP3_REGAMMA_CNTLA_REGION_2_3                                                                0x0be9
#define mmDCP3_REGAMMA_CNTLA_REGION_2_3_BASE_IDX                                                       2
#define mmDCP3_REGAMMA_CNTLA_REGION_4_5                                                                0x0bea
#define mmDCP3_REGAMMA_CNTLA_REGION_4_5_BASE_IDX                                                       2
#define mmDCP3_REGAMMA_CNTLA_REGION_6_7                                                                0x0beb
#define mmDCP3_REGAMMA_CNTLA_REGION_6_7_BASE_IDX                                                       2
#define mmDCP3_REGAMMA_CNTLA_REGION_8_9                                                                0x0bec
#define mmDCP3_REGAMMA_CNTLA_REGION_8_9_BASE_IDX                                                       2
#define mmDCP3_REGAMMA_CNTLA_REGION_10_11                                                              0x0bed
#define mmDCP3_REGAMMA_CNTLA_REGION_10_11_BASE_IDX                                                     2
#define mmDCP3_REGAMMA_CNTLA_REGION_12_13                                                              0x0bee
#define mmDCP3_REGAMMA_CNTLA_REGION_12_13_BASE_IDX                                                     2
#define mmDCP3_REGAMMA_CNTLA_REGION_14_15                                                              0x0bef
#define mmDCP3_REGAMMA_CNTLA_REGION_14_15_BASE_IDX                                                     2
#define mmDCP3_REGAMMA_CNTLB_START_CNTL                                                                0x0bf0
#define mmDCP3_REGAMMA_CNTLB_START_CNTL_BASE_IDX                                                       2
#define mmDCP3_REGAMMA_CNTLB_SLOPE_CNTL                                                                0x0bf1
#define mmDCP3_REGAMMA_CNTLB_SLOPE_CNTL_BASE_IDX                                                       2
#define mmDCP3_REGAMMA_CNTLB_END_CNTL1                                                                 0x0bf2
#define mmDCP3_REGAMMA_CNTLB_END_CNTL1_BASE_IDX                                                        2
#define mmDCP3_REGAMMA_CNTLB_END_CNTL2                                                                 0x0bf3
#define mmDCP3_REGAMMA_CNTLB_END_CNTL2_BASE_IDX                                                        2
#define mmDCP3_REGAMMA_CNTLB_REGION_0_1                                                                0x0bf4
#define mmDCP3_REGAMMA_CNTLB_REGION_0_1_BASE_IDX                                                       2
#define mmDCP3_REGAMMA_CNTLB_REGION_2_3                                                                0x0bf5
#define mmDCP3_REGAMMA_CNTLB_REGION_2_3_BASE_IDX                                                       2
#define mmDCP3_REGAMMA_CNTLB_REGION_4_5                                                                0x0bf6
#define mmDCP3_REGAMMA_CNTLB_REGION_4_5_BASE_IDX                                                       2
#define mmDCP3_REGAMMA_CNTLB_REGION_6_7                                                                0x0bf7
#define mmDCP3_REGAMMA_CNTLB_REGION_6_7_BASE_IDX                                                       2
#define mmDCP3_REGAMMA_CNTLB_REGION_8_9                                                                0x0bf8
#define mmDCP3_REGAMMA_CNTLB_REGION_8_9_BASE_IDX                                                       2
#define mmDCP3_REGAMMA_CNTLB_REGION_10_11                                                              0x0bf9
#define mmDCP3_REGAMMA_CNTLB_REGION_10_11_BASE_IDX                                                     2
#define mmDCP3_REGAMMA_CNTLB_REGION_12_13                                                              0x0bfa
#define mmDCP3_REGAMMA_CNTLB_REGION_12_13_BASE_IDX                                                     2
#define mmDCP3_REGAMMA_CNTLB_REGION_14_15                                                              0x0bfb
#define mmDCP3_REGAMMA_CNTLB_REGION_14_15_BASE_IDX                                                     2
#define mmDCP3_ALPHA_CONTROL                                                                           0x0bfc
#define mmDCP3_ALPHA_CONTROL_BASE_IDX                                                                  2
#define mmDCP3_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS                                                      0x0bfd
#define mmDCP3_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_BASE_IDX                                             2
#define mmDCP3_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH                                                 0x0bfe
#define mmDCP3_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH_BASE_IDX                                        2
#define mmDCP3_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS                                                    0x0bff
#define mmDCP3_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS_BASE_IDX                                           2
#define mmDCP3_GRPH_XDMA_FLIP_TIMEOUT                                                                  0x0c00
#define mmDCP3_GRPH_XDMA_FLIP_TIMEOUT_BASE_IDX                                                         2
#define mmDCP3_GRPH_XDMA_FLIP_AVG_DELAY                                                                0x0c01
#define mmDCP3_GRPH_XDMA_FLIP_AVG_DELAY_BASE_IDX                                                       2
#define mmDCP3_GRPH_SURFACE_COUNTER_CONTROL                                                            0x0c02
#define mmDCP3_GRPH_SURFACE_COUNTER_CONTROL_BASE_IDX                                                   2
#define mmDCP3_GRPH_SURFACE_COUNTER_OUTPUT                                                             0x0c03
#define mmDCP3_GRPH_SURFACE_COUNTER_OUTPUT_BASE_IDX                                                    2


// addressBlock: dce_dc_lb3_dispdec
// base address: 0x1800
#define mmLB3_LB_DATA_FORMAT                                                                           0x0c1a
#define mmLB3_LB_DATA_FORMAT_BASE_IDX                                                                  2
#define mmLB3_LB_MEMORY_CTRL                                                                           0x0c1b
#define mmLB3_LB_MEMORY_CTRL_BASE_IDX                                                                  2
#define mmLB3_LB_MEMORY_SIZE_STATUS                                                                    0x0c1c
#define mmLB3_LB_MEMORY_SIZE_STATUS_BASE_IDX                                                           2
#define mmLB3_LB_DESKTOP_HEIGHT                                                                        0x0c1d
#define mmLB3_LB_DESKTOP_HEIGHT_BASE_IDX                                                               2
#define mmLB3_LB_VLINE_START_END                                                                       0x0c1e
#define mmLB3_LB_VLINE_START_END_BASE_IDX                                                              2
#define mmLB3_LB_VLINE2_START_END                                                                      0x0c1f
#define mmLB3_LB_VLINE2_START_END_BASE_IDX                                                             2
#define mmLB3_LB_V_COUNTER                                                                             0x0c20
#define mmLB3_LB_V_COUNTER_BASE_IDX                                                                    2
#define mmLB3_LB_SNAPSHOT_V_COUNTER                                                                    0x0c21
#define mmLB3_LB_SNAPSHOT_V_COUNTER_BASE_IDX                                                           2
#define mmLB3_LB_INTERRUPT_MASK                                                                        0x0c22
#define mmLB3_LB_INTERRUPT_MASK_BASE_IDX                                                               2
#define mmLB3_LB_VLINE_STATUS                                                                          0x0c23
#define mmLB3_LB_VLINE_STATUS_BASE_IDX                                                                 2
#define mmLB3_LB_VLINE2_STATUS                                                                         0x0c24
#define mmLB3_LB_VLINE2_STATUS_BASE_IDX                                                                2
#define mmLB3_LB_VBLANK_STATUS                                                                         0x0c25
#define mmLB3_LB_VBLANK_STATUS_BASE_IDX                                                                2
#define mmLB3_LB_SYNC_RESET_SEL                                                                        0x0c26
#define mmLB3_LB_SYNC_RESET_SEL_BASE_IDX                                                               2
#define mmLB3_LB_BLACK_KEYER_R_CR                                                                      0x0c27
#define mmLB3_LB_BLACK_KEYER_R_CR_BASE_IDX                                                             2
#define mmLB3_LB_BLACK_KEYER_G_Y                                                                       0x0c28
#define mmLB3_LB_BLACK_KEYER_G_Y_BASE_IDX                                                              2
#define mmLB3_LB_BLACK_KEYER_B_CB                                                                      0x0c29
#define mmLB3_LB_BLACK_KEYER_B_CB_BASE_IDX                                                             2
#define mmLB3_LB_KEYER_COLOR_CTRL                                                                      0x0c2a
#define mmLB3_LB_KEYER_COLOR_CTRL_BASE_IDX                                                             2
#define mmLB3_LB_KEYER_COLOR_R_CR                                                                      0x0c2b
#define mmLB3_LB_KEYER_COLOR_R_CR_BASE_IDX                                                             2
#define mmLB3_LB_KEYER_COLOR_G_Y                                                                       0x0c2c
#define mmLB3_LB_KEYER_COLOR_G_Y_BASE_IDX                                                              2
#define mmLB3_LB_KEYER_COLOR_B_CB                                                                      0x0c2d
#define mmLB3_LB_KEYER_COLOR_B_CB_BASE_IDX                                                             2
#define mmLB3_LB_KEYER_COLOR_REP_R_CR                                                                  0x0c2e
#define mmLB3_LB_KEYER_COLOR_REP_R_CR_BASE_IDX                                                         2
#define mmLB3_LB_KEYER_COLOR_REP_G_Y                                                                   0x0c2f
#define mmLB3_LB_KEYER_COLOR_REP_G_Y_BASE_IDX                                                          2
#define mmLB3_LB_KEYER_COLOR_REP_B_CB                                                                  0x0c30
#define mmLB3_LB_KEYER_COLOR_REP_B_CB_BASE_IDX                                                         2
#define mmLB3_LB_BUFFER_LEVEL_STATUS                                                                   0x0c31
#define mmLB3_LB_BUFFER_LEVEL_STATUS_BASE_IDX                                                          2
#define mmLB3_LB_BUFFER_URGENCY_CTRL                                                                   0x0c32
#define mmLB3_LB_BUFFER_URGENCY_CTRL_BASE_IDX                                                          2
#define mmLB3_LB_BUFFER_URGENCY_STATUS                                                                 0x0c33
#define mmLB3_LB_BUFFER_URGENCY_STATUS_BASE_IDX                                                        2
#define mmLB3_LB_BUFFER_STATUS                                                                         0x0c34
#define mmLB3_LB_BUFFER_STATUS_BASE_IDX                                                                2
#define mmLB3_LB_NO_OUTSTANDING_REQ_STATUS                                                             0x0c35
#define mmLB3_LB_NO_OUTSTANDING_REQ_STATUS_BASE_IDX                                                    2
#define mmLB3_MVP_AFR_FLIP_MODE                                                                        0x0c36
#define mmLB3_MVP_AFR_FLIP_MODE_BASE_IDX                                                               2
#define mmLB3_MVP_AFR_FLIP_FIFO_CNTL                                                                   0x0c37
#define mmLB3_MVP_AFR_FLIP_FIFO_CNTL_BASE_IDX                                                          2
#define mmLB3_MVP_FLIP_LINE_NUM_INSERT                                                                 0x0c38
#define mmLB3_MVP_FLIP_LINE_NUM_INSERT_BASE_IDX                                                        2
#define mmLB3_DC_MVP_LB_CONTROL                                                                        0x0c39
#define mmLB3_DC_MVP_LB_CONTROL_BASE_IDX                                                               2


// addressBlock: dce_dc_dcfe3_dispdec
// base address: 0x1800
#define mmDCFE3_DCFE_CLOCK_CONTROL                                                                     0x0c5a
#define mmDCFE3_DCFE_CLOCK_CONTROL_BASE_IDX                                                            2
#define mmDCFE3_DCFE_SOFT_RESET                                                                        0x0c5b
#define mmDCFE3_DCFE_SOFT_RESET_BASE_IDX                                                               2
#define mmDCFE3_DCFE_MEM_PWR_CTRL                                                                      0x0c5d
#define mmDCFE3_DCFE_MEM_PWR_CTRL_BASE_IDX                                                             2
#define mmDCFE3_DCFE_MEM_PWR_CTRL2                                                                     0x0c5e
#define mmDCFE3_DCFE_MEM_PWR_CTRL2_BASE_IDX                                                            2
#define mmDCFE3_DCFE_MEM_PWR_STATUS                                                                    0x0c5f
#define mmDCFE3_DCFE_MEM_PWR_STATUS_BASE_IDX                                                           2
#define mmDCFE3_DCFE_MISC                                                                              0x0c60
#define mmDCFE3_DCFE_MISC_BASE_IDX                                                                     2
#define mmDCFE3_DCFE_FLUSH                                                                             0x0c61
#define mmDCFE3_DCFE_FLUSH_BASE_IDX                                                                    2


// addressBlock: dce_dc_dc_perfmon6_dispdec
// base address: 0x3138
#define mmDC_PERFMON6_PERFCOUNTER_CNTL                                                                 0x0c6e
#define mmDC_PERFMON6_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON6_PERFCOUNTER_CNTL2                                                                0x0c6f
#define mmDC_PERFMON6_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON6_PERFCOUNTER_STATE                                                                0x0c70
#define mmDC_PERFMON6_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON6_PERFMON_CNTL                                                                     0x0c71
#define mmDC_PERFMON6_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON6_PERFMON_CNTL2                                                                    0x0c72
#define mmDC_PERFMON6_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON6_PERFMON_CVALUE_INT_MISC                                                          0x0c73
#define mmDC_PERFMON6_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON6_PERFMON_CVALUE_LOW                                                               0x0c74
#define mmDC_PERFMON6_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON6_PERFMON_HI                                                                       0x0c75
#define mmDC_PERFMON6_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON6_PERFMON_LOW                                                                      0x0c76
#define mmDC_PERFMON6_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dmif_pg3_dispdec
// base address: 0x1800
#define mmDMIF_PG3_DPG_PIPE_ARBITRATION_CONTROL1                                                       0x0c7a
#define mmDMIF_PG3_DPG_PIPE_ARBITRATION_CONTROL1_BASE_IDX                                              2
#define mmDMIF_PG3_DPG_PIPE_ARBITRATION_CONTROL2                                                       0x0c7b
#define mmDMIF_PG3_DPG_PIPE_ARBITRATION_CONTROL2_BASE_IDX                                              2
#define mmDMIF_PG3_DPG_WATERMARK_MASK_CONTROL                                                          0x0c7c
#define mmDMIF_PG3_DPG_WATERMARK_MASK_CONTROL_BASE_IDX                                                 2
#define mmDMIF_PG3_DPG_PIPE_URGENCY_CONTROL                                                            0x0c7d
#define mmDMIF_PG3_DPG_PIPE_URGENCY_CONTROL_BASE_IDX                                                   2
#define mmDMIF_PG3_DPG_PIPE_URGENT_LEVEL_CONTROL                                                       0x0c7e
#define mmDMIF_PG3_DPG_PIPE_URGENT_LEVEL_CONTROL_BASE_IDX                                              2
#define mmDMIF_PG3_DPG_PIPE_STUTTER_CONTROL                                                            0x0c7f
#define mmDMIF_PG3_DPG_PIPE_STUTTER_CONTROL_BASE_IDX                                                   2
#define mmDMIF_PG3_DPG_PIPE_STUTTER_CONTROL2                                                           0x0c80
#define mmDMIF_PG3_DPG_PIPE_STUTTER_CONTROL2_BASE_IDX                                                  2
#define mmDMIF_PG3_DPG_PIPE_LOW_POWER_CONTROL                                                          0x0c81
#define mmDMIF_PG3_DPG_PIPE_LOW_POWER_CONTROL_BASE_IDX                                                 2
#define mmDMIF_PG3_DPG_REPEATER_PROGRAM                                                                0x0c82
#define mmDMIF_PG3_DPG_REPEATER_PROGRAM_BASE_IDX                                                       2
#define mmDMIF_PG3_DPG_CHK_PRE_PROC_CNTL                                                               0x0c86
#define mmDMIF_PG3_DPG_CHK_PRE_PROC_CNTL_BASE_IDX                                                      2
#define mmDMIF_PG3_DPG_DVMM_STATUS                                                                     0x0c87
#define mmDMIF_PG3_DPG_DVMM_STATUS_BASE_IDX                                                            2


// addressBlock: dce_dc_scl3_dispdec
// base address: 0x1800
#define mmSCL3_SCL_COEF_RAM_SELECT                                                                     0x0c9a
#define mmSCL3_SCL_COEF_RAM_SELECT_BASE_IDX                                                            2
#define mmSCL3_SCL_COEF_RAM_TAP_DATA                                                                   0x0c9b
#define mmSCL3_SCL_COEF_RAM_TAP_DATA_BASE_IDX                                                          2
#define mmSCL3_SCL_MODE                                                                                0x0c9c
#define mmSCL3_SCL_MODE_BASE_IDX                                                                       2
#define mmSCL3_SCL_TAP_CONTROL                                                                         0x0c9d
#define mmSCL3_SCL_TAP_CONTROL_BASE_IDX                                                                2
#define mmSCL3_SCL_CONTROL                                                                             0x0c9e
#define mmSCL3_SCL_CONTROL_BASE_IDX                                                                    2
#define mmSCL3_SCL_BYPASS_CONTROL                                                                      0x0c9f
#define mmSCL3_SCL_BYPASS_CONTROL_BASE_IDX                                                             2
#define mmSCL3_SCL_MANUAL_REPLICATE_CONTROL                                                            0x0ca0
#define mmSCL3_SCL_MANUAL_REPLICATE_CONTROL_BASE_IDX                                                   2
#define mmSCL3_SCL_AUTOMATIC_MODE_CONTROL                                                              0x0ca1
#define mmSCL3_SCL_AUTOMATIC_MODE_CONTROL_BASE_IDX                                                     2
#define mmSCL3_SCL_HORZ_FILTER_CONTROL                                                                 0x0ca2
#define mmSCL3_SCL_HORZ_FILTER_CONTROL_BASE_IDX                                                        2
#define mmSCL3_SCL_HORZ_FILTER_SCALE_RATIO                                                             0x0ca3
#define mmSCL3_SCL_HORZ_FILTER_SCALE_RATIO_BASE_IDX                                                    2
#define mmSCL3_SCL_HORZ_FILTER_INIT                                                                    0x0ca4
#define mmSCL3_SCL_HORZ_FILTER_INIT_BASE_IDX                                                           2
#define mmSCL3_SCL_VERT_FILTER_CONTROL                                                                 0x0ca5
#define mmSCL3_SCL_VERT_FILTER_CONTROL_BASE_IDX                                                        2
#define mmSCL3_SCL_VERT_FILTER_SCALE_RATIO                                                             0x0ca6
#define mmSCL3_SCL_VERT_FILTER_SCALE_RATIO_BASE_IDX                                                    2
#define mmSCL3_SCL_VERT_FILTER_INIT                                                                    0x0ca7
#define mmSCL3_SCL_VERT_FILTER_INIT_BASE_IDX                                                           2
#define mmSCL3_SCL_VERT_FILTER_INIT_BOT                                                                0x0ca8
#define mmSCL3_SCL_VERT_FILTER_INIT_BOT_BASE_IDX                                                       2
#define mmSCL3_SCL_ROUND_OFFSET                                                                        0x0ca9
#define mmSCL3_SCL_ROUND_OFFSET_BASE_IDX                                                               2
#define mmSCL3_SCL_UPDATE                                                                              0x0caa
#define mmSCL3_SCL_UPDATE_BASE_IDX                                                                     2
#define mmSCL3_SCL_F_SHARP_CONTROL                                                                     0x0cab
#define mmSCL3_SCL_F_SHARP_CONTROL_BASE_IDX                                                            2
#define mmSCL3_SCL_ALU_CONTROL                                                                         0x0cac
#define mmSCL3_SCL_ALU_CONTROL_BASE_IDX                                                                2
#define mmSCL3_SCL_COEF_RAM_CONFLICT_STATUS                                                            0x0cad
#define mmSCL3_SCL_COEF_RAM_CONFLICT_STATUS_BASE_IDX                                                   2
#define mmSCL3_VIEWPORT_START_SECONDARY                                                                0x0cae
#define mmSCL3_VIEWPORT_START_SECONDARY_BASE_IDX                                                       2
#define mmSCL3_VIEWPORT_START                                                                          0x0caf
#define mmSCL3_VIEWPORT_START_BASE_IDX                                                                 2
#define mmSCL3_VIEWPORT_SIZE                                                                           0x0cb0
#define mmSCL3_VIEWPORT_SIZE_BASE_IDX                                                                  2
#define mmSCL3_EXT_OVERSCAN_LEFT_RIGHT                                                                 0x0cb1
#define mmSCL3_EXT_OVERSCAN_LEFT_RIGHT_BASE_IDX                                                        2
#define mmSCL3_EXT_OVERSCAN_TOP_BOTTOM                                                                 0x0cb2
#define mmSCL3_EXT_OVERSCAN_TOP_BOTTOM_BASE_IDX                                                        2
#define mmSCL3_SCL_MODE_CHANGE_DET1                                                                    0x0cb3
#define mmSCL3_SCL_MODE_CHANGE_DET1_BASE_IDX                                                           2
#define mmSCL3_SCL_MODE_CHANGE_DET2                                                                    0x0cb4
#define mmSCL3_SCL_MODE_CHANGE_DET2_BASE_IDX                                                           2
#define mmSCL3_SCL_MODE_CHANGE_DET3                                                                    0x0cb5
#define mmSCL3_SCL_MODE_CHANGE_DET3_BASE_IDX                                                           2
#define mmSCL3_SCL_MODE_CHANGE_MASK                                                                    0x0cb6
#define mmSCL3_SCL_MODE_CHANGE_MASK_BASE_IDX                                                           2


// addressBlock: dce_dc_blnd3_dispdec
// base address: 0x1800
#define mmBLND3_BLND_CONTROL                                                                           0x0cc7
#define mmBLND3_BLND_CONTROL_BASE_IDX                                                                  2
#define mmBLND3_BLND_SM_CONTROL2                                                                       0x0cc8
#define mmBLND3_BLND_SM_CONTROL2_BASE_IDX                                                              2
#define mmBLND3_BLND_CONTROL2                                                                          0x0cc9
#define mmBLND3_BLND_CONTROL2_BASE_IDX                                                                 2
#define mmBLND3_BLND_UPDATE                                                                            0x0cca
#define mmBLND3_BLND_UPDATE_BASE_IDX                                                                   2
#define mmBLND3_BLND_UNDERFLOW_INTERRUPT                                                               0x0ccb
#define mmBLND3_BLND_UNDERFLOW_INTERRUPT_BASE_IDX                                                      2
#define mmBLND3_BLND_V_UPDATE_LOCK                                                                     0x0ccc
#define mmBLND3_BLND_V_UPDATE_LOCK_BASE_IDX                                                            2
#define mmBLND3_BLND_REG_UPDATE_STATUS                                                                 0x0ccd
#define mmBLND3_BLND_REG_UPDATE_STATUS_BASE_IDX                                                        2


// addressBlock: dce_dc_crtc3_dispdec
// base address: 0x1800
#define mmCRTC3_CRTC_H_BLANK_EARLY_NUM                                                                 0x0cd2
#define mmCRTC3_CRTC_H_BLANK_EARLY_NUM_BASE_IDX                                                        2
#define mmCRTC3_CRTC_H_TOTAL                                                                           0x0cd3
#define mmCRTC3_CRTC_H_TOTAL_BASE_IDX                                                                  2
#define mmCRTC3_CRTC_H_BLANK_START_END                                                                 0x0cd4
#define mmCRTC3_CRTC_H_BLANK_START_END_BASE_IDX                                                        2
#define mmCRTC3_CRTC_H_SYNC_A                                                                          0x0cd5
#define mmCRTC3_CRTC_H_SYNC_A_BASE_IDX                                                                 2
#define mmCRTC3_CRTC_H_SYNC_A_CNTL                                                                     0x0cd6
#define mmCRTC3_CRTC_H_SYNC_A_CNTL_BASE_IDX                                                            2
#define mmCRTC3_CRTC_H_SYNC_B                                                                          0x0cd7
#define mmCRTC3_CRTC_H_SYNC_B_BASE_IDX                                                                 2
#define mmCRTC3_CRTC_H_SYNC_B_CNTL                                                                     0x0cd8
#define mmCRTC3_CRTC_H_SYNC_B_CNTL_BASE_IDX                                                            2
#define mmCRTC3_CRTC_VBI_END                                                                           0x0cd9
#define mmCRTC3_CRTC_VBI_END_BASE_IDX                                                                  2
#define mmCRTC3_CRTC_V_TOTAL                                                                           0x0cda
#define mmCRTC3_CRTC_V_TOTAL_BASE_IDX                                                                  2
#define mmCRTC3_CRTC_V_TOTAL_MIN                                                                       0x0cdb
#define mmCRTC3_CRTC_V_TOTAL_MIN_BASE_IDX                                                              2
#define mmCRTC3_CRTC_V_TOTAL_MAX                                                                       0x0cdc
#define mmCRTC3_CRTC_V_TOTAL_MAX_BASE_IDX                                                              2
#define mmCRTC3_CRTC_V_TOTAL_CONTROL                                                                   0x0cdd
#define mmCRTC3_CRTC_V_TOTAL_CONTROL_BASE_IDX                                                          2
#define mmCRTC3_CRTC_V_TOTAL_INT_STATUS                                                                0x0cde
#define mmCRTC3_CRTC_V_TOTAL_INT_STATUS_BASE_IDX                                                       2
#define mmCRTC3_CRTC_VSYNC_NOM_INT_STATUS                                                              0x0cdf
#define mmCRTC3_CRTC_VSYNC_NOM_INT_STATUS_BASE_IDX                                                     2
#define mmCRTC3_CRTC_V_BLANK_START_END                                                                 0x0ce0
#define mmCRTC3_CRTC_V_BLANK_START_END_BASE_IDX                                                        2
#define mmCRTC3_CRTC_V_SYNC_A                                                                          0x0ce1
#define mmCRTC3_CRTC_V_SYNC_A_BASE_IDX                                                                 2
#define mmCRTC3_CRTC_V_SYNC_A_CNTL                                                                     0x0ce2
#define mmCRTC3_CRTC_V_SYNC_A_CNTL_BASE_IDX                                                            2
#define mmCRTC3_CRTC_V_SYNC_B                                                                          0x0ce3
#define mmCRTC3_CRTC_V_SYNC_B_BASE_IDX                                                                 2
#define mmCRTC3_CRTC_V_SYNC_B_CNTL                                                                     0x0ce4
#define mmCRTC3_CRTC_V_SYNC_B_CNTL_BASE_IDX                                                            2
#define mmCRTC3_CRTC_DTMTEST_CNTL                                                                      0x0ce5
#define mmCRTC3_CRTC_DTMTEST_CNTL_BASE_IDX                                                             2
#define mmCRTC3_CRTC_DTMTEST_STATUS_POSITION                                                           0x0ce6
#define mmCRTC3_CRTC_DTMTEST_STATUS_POSITION_BASE_IDX                                                  2
#define mmCRTC3_CRTC_TRIGA_CNTL                                                                        0x0ce7
#define mmCRTC3_CRTC_TRIGA_CNTL_BASE_IDX                                                               2
#define mmCRTC3_CRTC_TRIGA_MANUAL_TRIG                                                                 0x0ce8
#define mmCRTC3_CRTC_TRIGA_MANUAL_TRIG_BASE_IDX                                                        2
#define mmCRTC3_CRTC_TRIGB_CNTL                                                                        0x0ce9
#define mmCRTC3_CRTC_TRIGB_CNTL_BASE_IDX                                                               2
#define mmCRTC3_CRTC_TRIGB_MANUAL_TRIG                                                                 0x0cea
#define mmCRTC3_CRTC_TRIGB_MANUAL_TRIG_BASE_IDX                                                        2
#define mmCRTC3_CRTC_FORCE_COUNT_NOW_CNTL                                                              0x0ceb
#define mmCRTC3_CRTC_FORCE_COUNT_NOW_CNTL_BASE_IDX                                                     2
#define mmCRTC3_CRTC_FLOW_CONTROL                                                                      0x0cec
#define mmCRTC3_CRTC_FLOW_CONTROL_BASE_IDX                                                             2
#define mmCRTC3_CRTC_STEREO_FORCE_NEXT_EYE                                                             0x0ced
#define mmCRTC3_CRTC_STEREO_FORCE_NEXT_EYE_BASE_IDX                                                    2
#define mmCRTC3_CRTC_AVSYNC_COUNTER                                                                    0x0cee
#define mmCRTC3_CRTC_AVSYNC_COUNTER_BASE_IDX                                                           2
#define mmCRTC3_CRTC_CONTROL                                                                           0x0cef
#define mmCRTC3_CRTC_CONTROL_BASE_IDX                                                                  2
#define mmCRTC3_CRTC_BLANK_CONTROL                                                                     0x0cf0
#define mmCRTC3_CRTC_BLANK_CONTROL_BASE_IDX                                                            2
#define mmCRTC3_CRTC_INTERLACE_CONTROL                                                                 0x0cf1
#define mmCRTC3_CRTC_INTERLACE_CONTROL_BASE_IDX                                                        2
#define mmCRTC3_CRTC_INTERLACE_STATUS                                                                  0x0cf2
#define mmCRTC3_CRTC_INTERLACE_STATUS_BASE_IDX                                                         2
#define mmCRTC3_CRTC_FIELD_INDICATION_CONTROL                                                          0x0cf3
#define mmCRTC3_CRTC_FIELD_INDICATION_CONTROL_BASE_IDX                                                 2
#define mmCRTC3_CRTC_PIXEL_DATA_READBACK0                                                              0x0cf4
#define mmCRTC3_CRTC_PIXEL_DATA_READBACK0_BASE_IDX                                                     2
#define mmCRTC3_CRTC_PIXEL_DATA_READBACK1                                                              0x0cf5
#define mmCRTC3_CRTC_PIXEL_DATA_READBACK1_BASE_IDX                                                     2
#define mmCRTC3_CRTC_STATUS                                                                            0x0cf6
#define mmCRTC3_CRTC_STATUS_BASE_IDX                                                                   2
#define mmCRTC3_CRTC_STATUS_POSITION                                                                   0x0cf7
#define mmCRTC3_CRTC_STATUS_POSITION_BASE_IDX                                                          2
#define mmCRTC3_CRTC_NOM_VERT_POSITION                                                                 0x0cf8
#define mmCRTC3_CRTC_NOM_VERT_POSITION_BASE_IDX                                                        2
#define mmCRTC3_CRTC_STATUS_FRAME_COUNT                                                                0x0cf9
#define mmCRTC3_CRTC_STATUS_FRAME_COUNT_BASE_IDX                                                       2
#define mmCRTC3_CRTC_STATUS_VF_COUNT                                                                   0x0cfa
#define mmCRTC3_CRTC_STATUS_VF_COUNT_BASE_IDX                                                          2
#define mmCRTC3_CRTC_STATUS_HV_COUNT                                                                   0x0cfb
#define mmCRTC3_CRTC_STATUS_HV_COUNT_BASE_IDX                                                          2
#define mmCRTC3_CRTC_COUNT_CONTROL                                                                     0x0cfc
#define mmCRTC3_CRTC_COUNT_CONTROL_BASE_IDX                                                            2
#define mmCRTC3_CRTC_COUNT_RESET                                                                       0x0cfd
#define mmCRTC3_CRTC_COUNT_RESET_BASE_IDX                                                              2
#define mmCRTC3_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE                                                      0x0cfe
#define mmCRTC3_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE_BASE_IDX                                             2
#define mmCRTC3_CRTC_VERT_SYNC_CONTROL                                                                 0x0cff
#define mmCRTC3_CRTC_VERT_SYNC_CONTROL_BASE_IDX                                                        2
#define mmCRTC3_CRTC_STEREO_STATUS                                                                     0x0d00
#define mmCRTC3_CRTC_STEREO_STATUS_BASE_IDX                                                            2
#define mmCRTC3_CRTC_STEREO_CONTROL                                                                    0x0d01
#define mmCRTC3_CRTC_STEREO_CONTROL_BASE_IDX                                                           2
#define mmCRTC3_CRTC_SNAPSHOT_STATUS                                                                   0x0d02
#define mmCRTC3_CRTC_SNAPSHOT_STATUS_BASE_IDX                                                          2
#define mmCRTC3_CRTC_SNAPSHOT_CONTROL                                                                  0x0d03
#define mmCRTC3_CRTC_SNAPSHOT_CONTROL_BASE_IDX                                                         2
#define mmCRTC3_CRTC_SNAPSHOT_POSITION                                                                 0x0d04
#define mmCRTC3_CRTC_SNAPSHOT_POSITION_BASE_IDX                                                        2
#define mmCRTC3_CRTC_SNAPSHOT_FRAME                                                                    0x0d05
#define mmCRTC3_CRTC_SNAPSHOT_FRAME_BASE_IDX                                                           2
#define mmCRTC3_CRTC_START_LINE_CONTROL                                                                0x0d06
#define mmCRTC3_CRTC_START_LINE_CONTROL_BASE_IDX                                                       2
#define mmCRTC3_CRTC_INTERRUPT_CONTROL                                                                 0x0d07
#define mmCRTC3_CRTC_INTERRUPT_CONTROL_BASE_IDX                                                        2
#define mmCRTC3_CRTC_UPDATE_LOCK                                                                       0x0d08
#define mmCRTC3_CRTC_UPDATE_LOCK_BASE_IDX                                                              2
#define mmCRTC3_CRTC_DOUBLE_BUFFER_CONTROL                                                             0x0d09
#define mmCRTC3_CRTC_DOUBLE_BUFFER_CONTROL_BASE_IDX                                                    2
#define mmCRTC3_CRTC_VGA_PARAMETER_CAPTURE_MODE                                                        0x0d0a
#define mmCRTC3_CRTC_VGA_PARAMETER_CAPTURE_MODE_BASE_IDX                                               2
#define mmCRTC3_CRTC_TEST_PATTERN_CONTROL                                                              0x0d0b
#define mmCRTC3_CRTC_TEST_PATTERN_CONTROL_BASE_IDX                                                     2
#define mmCRTC3_CRTC_TEST_PATTERN_PARAMETERS                                                           0x0d0c
#define mmCRTC3_CRTC_TEST_PATTERN_PARAMETERS_BASE_IDX                                                  2
#define mmCRTC3_CRTC_TEST_PATTERN_COLOR                                                                0x0d0d
#define mmCRTC3_CRTC_TEST_PATTERN_COLOR_BASE_IDX                                                       2
#define mmCRTC3_CRTC_MASTER_UPDATE_LOCK                                                                0x0d0e
#define mmCRTC3_CRTC_MASTER_UPDATE_LOCK_BASE_IDX                                                       2
#define mmCRTC3_CRTC_MASTER_UPDATE_MODE                                                                0x0d0f
#define mmCRTC3_CRTC_MASTER_UPDATE_MODE_BASE_IDX                                                       2
#define mmCRTC3_CRTC_MVP_INBAND_CNTL_INSERT                                                            0x0d10
#define mmCRTC3_CRTC_MVP_INBAND_CNTL_INSERT_BASE_IDX                                                   2
#define mmCRTC3_CRTC_MVP_INBAND_CNTL_INSERT_TIMER                                                      0x0d11
#define mmCRTC3_CRTC_MVP_INBAND_CNTL_INSERT_TIMER_BASE_IDX                                             2
#define mmCRTC3_CRTC_MVP_STATUS                                                                        0x0d12
#define mmCRTC3_CRTC_MVP_STATUS_BASE_IDX                                                               2
#define mmCRTC3_CRTC_MASTER_EN                                                                         0x0d13
#define mmCRTC3_CRTC_MASTER_EN_BASE_IDX                                                                2
#define mmCRTC3_CRTC_ALLOW_STOP_OFF_V_CNT                                                              0x0d14
#define mmCRTC3_CRTC_ALLOW_STOP_OFF_V_CNT_BASE_IDX                                                     2
#define mmCRTC3_CRTC_V_UPDATE_INT_STATUS                                                               0x0d15
#define mmCRTC3_CRTC_V_UPDATE_INT_STATUS_BASE_IDX                                                      2
#define mmCRTC3_CRTC_OVERSCAN_COLOR                                                                    0x0d17
#define mmCRTC3_CRTC_OVERSCAN_COLOR_BASE_IDX                                                           2
#define mmCRTC3_CRTC_OVERSCAN_COLOR_EXT                                                                0x0d18
#define mmCRTC3_CRTC_OVERSCAN_COLOR_EXT_BASE_IDX                                                       2
#define mmCRTC3_CRTC_BLANK_DATA_COLOR                                                                  0x0d19
#define mmCRTC3_CRTC_BLANK_DATA_COLOR_BASE_IDX                                                         2
#define mmCRTC3_CRTC_BLANK_DATA_COLOR_EXT                                                              0x0d1a
#define mmCRTC3_CRTC_BLANK_DATA_COLOR_EXT_BASE_IDX                                                     2
#define mmCRTC3_CRTC_BLACK_COLOR                                                                       0x0d1b
#define mmCRTC3_CRTC_BLACK_COLOR_BASE_IDX                                                              2
#define mmCRTC3_CRTC_BLACK_COLOR_EXT                                                                   0x0d1c
#define mmCRTC3_CRTC_BLACK_COLOR_EXT_BASE_IDX                                                          2
#define mmCRTC3_CRTC_VERTICAL_INTERRUPT0_POSITION                                                      0x0d1d
#define mmCRTC3_CRTC_VERTICAL_INTERRUPT0_POSITION_BASE_IDX                                             2
#define mmCRTC3_CRTC_VERTICAL_INTERRUPT0_CONTROL                                                       0x0d1e
#define mmCRTC3_CRTC_VERTICAL_INTERRUPT0_CONTROL_BASE_IDX                                              2
#define mmCRTC3_CRTC_VERTICAL_INTERRUPT1_POSITION                                                      0x0d1f
#define mmCRTC3_CRTC_VERTICAL_INTERRUPT1_POSITION_BASE_IDX                                             2
#define mmCRTC3_CRTC_VERTICAL_INTERRUPT1_CONTROL                                                       0x0d20
#define mmCRTC3_CRTC_VERTICAL_INTERRUPT1_CONTROL_BASE_IDX                                              2
#define mmCRTC3_CRTC_VERTICAL_INTERRUPT2_POSITION                                                      0x0d21
#define mmCRTC3_CRTC_VERTICAL_INTERRUPT2_POSITION_BASE_IDX                                             2
#define mmCRTC3_CRTC_VERTICAL_INTERRUPT2_CONTROL                                                       0x0d22
#define mmCRTC3_CRTC_VERTICAL_INTERRUPT2_CONTROL_BASE_IDX                                              2
#define mmCRTC3_CRTC_CRC_CNTL                                                                          0x0d23
#define mmCRTC3_CRTC_CRC_CNTL_BASE_IDX                                                                 2
#define mmCRTC3_CRTC_CRC0_WINDOWA_X_CONTROL                                                            0x0d24
#define mmCRTC3_CRTC_CRC0_WINDOWA_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC3_CRTC_CRC0_WINDOWA_Y_CONTROL                                                            0x0d25
#define mmCRTC3_CRTC_CRC0_WINDOWA_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC3_CRTC_CRC0_WINDOWB_X_CONTROL                                                            0x0d26
#define mmCRTC3_CRTC_CRC0_WINDOWB_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC3_CRTC_CRC0_WINDOWB_Y_CONTROL                                                            0x0d27
#define mmCRTC3_CRTC_CRC0_WINDOWB_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC3_CRTC_CRC0_DATA_RG                                                                      0x0d28
#define mmCRTC3_CRTC_CRC0_DATA_RG_BASE_IDX                                                             2
#define mmCRTC3_CRTC_CRC0_DATA_B                                                                       0x0d29
#define mmCRTC3_CRTC_CRC0_DATA_B_BASE_IDX                                                              2
#define mmCRTC3_CRTC_CRC1_WINDOWA_X_CONTROL                                                            0x0d2a
#define mmCRTC3_CRTC_CRC1_WINDOWA_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC3_CRTC_CRC1_WINDOWA_Y_CONTROL                                                            0x0d2b
#define mmCRTC3_CRTC_CRC1_WINDOWA_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC3_CRTC_CRC1_WINDOWB_X_CONTROL                                                            0x0d2c
#define mmCRTC3_CRTC_CRC1_WINDOWB_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC3_CRTC_CRC1_WINDOWB_Y_CONTROL                                                            0x0d2d
#define mmCRTC3_CRTC_CRC1_WINDOWB_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC3_CRTC_CRC1_DATA_RG                                                                      0x0d2e
#define mmCRTC3_CRTC_CRC1_DATA_RG_BASE_IDX                                                             2
#define mmCRTC3_CRTC_CRC1_DATA_B                                                                       0x0d2f
#define mmCRTC3_CRTC_CRC1_DATA_B_BASE_IDX                                                              2
#define mmCRTC3_CRTC_EXT_TIMING_SYNC_CONTROL                                                           0x0d30
#define mmCRTC3_CRTC_EXT_TIMING_SYNC_CONTROL_BASE_IDX                                                  2
#define mmCRTC3_CRTC_EXT_TIMING_SYNC_WINDOW_START                                                      0x0d31
#define mmCRTC3_CRTC_EXT_TIMING_SYNC_WINDOW_START_BASE_IDX                                             2
#define mmCRTC3_CRTC_EXT_TIMING_SYNC_WINDOW_END                                                        0x0d32
#define mmCRTC3_CRTC_EXT_TIMING_SYNC_WINDOW_END_BASE_IDX                                               2
#define mmCRTC3_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL                                            0x0d33
#define mmCRTC3_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_BASE_IDX                                   2
#define mmCRTC3_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL                                                 0x0d34
#define mmCRTC3_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL_BASE_IDX                                        2
#define mmCRTC3_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL                                          0x0d35
#define mmCRTC3_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL_BASE_IDX                                 2
#define mmCRTC3_CRTC_STATIC_SCREEN_CONTROL                                                             0x0d36
#define mmCRTC3_CRTC_STATIC_SCREEN_CONTROL_BASE_IDX                                                    2
#define mmCRTC3_CRTC_3D_STRUCTURE_CONTROL                                                              0x0d37
#define mmCRTC3_CRTC_3D_STRUCTURE_CONTROL_BASE_IDX                                                     2
#define mmCRTC3_CRTC_GSL_VSYNC_GAP                                                                     0x0d38
#define mmCRTC3_CRTC_GSL_VSYNC_GAP_BASE_IDX                                                            2
#define mmCRTC3_CRTC_GSL_WINDOW                                                                        0x0d39
#define mmCRTC3_CRTC_GSL_WINDOW_BASE_IDX                                                               2
#define mmCRTC3_CRTC_GSL_CONTROL                                                                       0x0d3a
#define mmCRTC3_CRTC_GSL_CONTROL_BASE_IDX                                                              2
#define mmCRTC3_CRTC_RANGE_TIMING_INT_STATUS                                                           0x0d3d
#define mmCRTC3_CRTC_RANGE_TIMING_INT_STATUS_BASE_IDX                                                  2
#define mmCRTC3_CRTC_DRR_CONTROL                                                                       0x0d3e
#define mmCRTC3_CRTC_DRR_CONTROL_BASE_IDX                                                              2


// addressBlock: dce_dc_fmt3_dispdec
// base address: 0x1800
#define mmFMT3_FMT_CLAMP_COMPONENT_R                                                                   0x0d42
#define mmFMT3_FMT_CLAMP_COMPONENT_R_BASE_IDX                                                          2
#define mmFMT3_FMT_CLAMP_COMPONENT_G                                                                   0x0d43
#define mmFMT3_FMT_CLAMP_COMPONENT_G_BASE_IDX                                                          2
#define mmFMT3_FMT_CLAMP_COMPONENT_B                                                                   0x0d44
#define mmFMT3_FMT_CLAMP_COMPONENT_B_BASE_IDX                                                          2
#define mmFMT3_FMT_DYNAMIC_EXP_CNTL                                                                    0x0d45
#define mmFMT3_FMT_DYNAMIC_EXP_CNTL_BASE_IDX                                                           2
#define mmFMT3_FMT_CONTROL                                                                             0x0d46
#define mmFMT3_FMT_CONTROL_BASE_IDX                                                                    2
#define mmFMT3_FMT_BIT_DEPTH_CONTROL                                                                   0x0d47
#define mmFMT3_FMT_BIT_DEPTH_CONTROL_BASE_IDX                                                          2
#define mmFMT3_FMT_DITHER_RAND_R_SEED                                                                  0x0d48
#define mmFMT3_FMT_DITHER_RAND_R_SEED_BASE_IDX                                                         2
#define mmFMT3_FMT_DITHER_RAND_G_SEED                                                                  0x0d49
#define mmFMT3_FMT_DITHER_RAND_G_SEED_BASE_IDX                                                         2
#define mmFMT3_FMT_DITHER_RAND_B_SEED                                                                  0x0d4a
#define mmFMT3_FMT_DITHER_RAND_B_SEED_BASE_IDX                                                         2
#define mmFMT3_FMT_CLAMP_CNTL                                                                          0x0d4e
#define mmFMT3_FMT_CLAMP_CNTL_BASE_IDX                                                                 2
#define mmFMT3_FMT_CRC_CNTL                                                                            0x0d4f
#define mmFMT3_FMT_CRC_CNTL_BASE_IDX                                                                   2
#define mmFMT3_FMT_CRC_SIG_RED_GREEN_MASK                                                              0x0d50
#define mmFMT3_FMT_CRC_SIG_RED_GREEN_MASK_BASE_IDX                                                     2
#define mmFMT3_FMT_CRC_SIG_BLUE_CONTROL_MASK                                                           0x0d51
#define mmFMT3_FMT_CRC_SIG_BLUE_CONTROL_MASK_BASE_IDX                                                  2
#define mmFMT3_FMT_CRC_SIG_RED_GREEN                                                                   0x0d52
#define mmFMT3_FMT_CRC_SIG_RED_GREEN_BASE_IDX                                                          2
#define mmFMT3_FMT_CRC_SIG_BLUE_CONTROL                                                                0x0d53
#define mmFMT3_FMT_CRC_SIG_BLUE_CONTROL_BASE_IDX                                                       2
#define mmFMT3_FMT_SIDE_BY_SIDE_STEREO_CONTROL                                                         0x0d54
#define mmFMT3_FMT_SIDE_BY_SIDE_STEREO_CONTROL_BASE_IDX                                                2
#define mmFMT3_FMT_420_HBLANK_EARLY_START                                                              0x0d55
#define mmFMT3_FMT_420_HBLANK_EARLY_START_BASE_IDX                                                     2


// addressBlock: dce_dc_dcp4_dispdec
// base address: 0x2000
#define mmDCP4_GRPH_ENABLE                                                                             0x0d5a
#define mmDCP4_GRPH_ENABLE_BASE_IDX                                                                    2
#define mmDCP4_GRPH_CONTROL                                                                            0x0d5b
#define mmDCP4_GRPH_CONTROL_BASE_IDX                                                                   2
#define mmDCP4_GRPH_LUT_10BIT_BYPASS                                                                   0x0d5c
#define mmDCP4_GRPH_LUT_10BIT_BYPASS_BASE_IDX                                                          2
#define mmDCP4_GRPH_SWAP_CNTL                                                                          0x0d5d
#define mmDCP4_GRPH_SWAP_CNTL_BASE_IDX                                                                 2
#define mmDCP4_GRPH_PRIMARY_SURFACE_ADDRESS                                                            0x0d5e
#define mmDCP4_GRPH_PRIMARY_SURFACE_ADDRESS_BASE_IDX                                                   2
#define mmDCP4_GRPH_SECONDARY_SURFACE_ADDRESS                                                          0x0d5f
#define mmDCP4_GRPH_SECONDARY_SURFACE_ADDRESS_BASE_IDX                                                 2
#define mmDCP4_GRPH_PITCH                                                                              0x0d60
#define mmDCP4_GRPH_PITCH_BASE_IDX                                                                     2
#define mmDCP4_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH                                                       0x0d61
#define mmDCP4_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                              2
#define mmDCP4_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH                                                     0x0d62
#define mmDCP4_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                            2
#define mmDCP4_GRPH_SURFACE_OFFSET_X                                                                   0x0d63
#define mmDCP4_GRPH_SURFACE_OFFSET_X_BASE_IDX                                                          2
#define mmDCP4_GRPH_SURFACE_OFFSET_Y                                                                   0x0d64
#define mmDCP4_GRPH_SURFACE_OFFSET_Y_BASE_IDX                                                          2
#define mmDCP4_GRPH_X_START                                                                            0x0d65
#define mmDCP4_GRPH_X_START_BASE_IDX                                                                   2
#define mmDCP4_GRPH_Y_START                                                                            0x0d66
#define mmDCP4_GRPH_Y_START_BASE_IDX                                                                   2
#define mmDCP4_GRPH_X_END                                                                              0x0d67
#define mmDCP4_GRPH_X_END_BASE_IDX                                                                     2
#define mmDCP4_GRPH_Y_END                                                                              0x0d68
#define mmDCP4_GRPH_Y_END_BASE_IDX                                                                     2
#define mmDCP4_INPUT_GAMMA_CONTROL                                                                     0x0d69
#define mmDCP4_INPUT_GAMMA_CONTROL_BASE_IDX                                                            2
#define mmDCP4_GRPH_UPDATE                                                                             0x0d6a
#define mmDCP4_GRPH_UPDATE_BASE_IDX                                                                    2
#define mmDCP4_GRPH_FLIP_CONTROL                                                                       0x0d6b
#define mmDCP4_GRPH_FLIP_CONTROL_BASE_IDX                                                              2
#define mmDCP4_GRPH_SURFACE_ADDRESS_INUSE                                                              0x0d6c
#define mmDCP4_GRPH_SURFACE_ADDRESS_INUSE_BASE_IDX                                                     2
#define mmDCP4_GRPH_DFQ_CONTROL                                                                        0x0d6d
#define mmDCP4_GRPH_DFQ_CONTROL_BASE_IDX                                                               2
#define mmDCP4_GRPH_DFQ_STATUS                                                                         0x0d6e
#define mmDCP4_GRPH_DFQ_STATUS_BASE_IDX                                                                2
#define mmDCP4_GRPH_INTERRUPT_STATUS                                                                   0x0d6f
#define mmDCP4_GRPH_INTERRUPT_STATUS_BASE_IDX                                                          2
#define mmDCP4_GRPH_INTERRUPT_CONTROL                                                                  0x0d70
#define mmDCP4_GRPH_INTERRUPT_CONTROL_BASE_IDX                                                         2
#define mmDCP4_GRPH_SURFACE_ADDRESS_HIGH_INUSE                                                         0x0d71
#define mmDCP4_GRPH_SURFACE_ADDRESS_HIGH_INUSE_BASE_IDX                                                2
#define mmDCP4_GRPH_COMPRESS_SURFACE_ADDRESS                                                           0x0d72
#define mmDCP4_GRPH_COMPRESS_SURFACE_ADDRESS_BASE_IDX                                                  2
#define mmDCP4_GRPH_COMPRESS_PITCH                                                                     0x0d73
#define mmDCP4_GRPH_COMPRESS_PITCH_BASE_IDX                                                            2
#define mmDCP4_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH                                                      0x0d74
#define mmDCP4_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH_BASE_IDX                                             2
#define mmDCP4_GRPH_PIPE_OUTSTANDING_REQUEST_LIMIT                                                     0x0d75
#define mmDCP4_GRPH_PIPE_OUTSTANDING_REQUEST_LIMIT_BASE_IDX                                            2
#define mmDCP4_PRESCALE_GRPH_CONTROL                                                                   0x0d76
#define mmDCP4_PRESCALE_GRPH_CONTROL_BASE_IDX                                                          2
#define mmDCP4_PRESCALE_VALUES_GRPH_R                                                                  0x0d77
#define mmDCP4_PRESCALE_VALUES_GRPH_R_BASE_IDX                                                         2
#define mmDCP4_PRESCALE_VALUES_GRPH_G                                                                  0x0d78
#define mmDCP4_PRESCALE_VALUES_GRPH_G_BASE_IDX                                                         2
#define mmDCP4_PRESCALE_VALUES_GRPH_B                                                                  0x0d79
#define mmDCP4_PRESCALE_VALUES_GRPH_B_BASE_IDX                                                         2
#define mmDCP4_INPUT_CSC_CONTROL                                                                       0x0d7a
#define mmDCP4_INPUT_CSC_CONTROL_BASE_IDX                                                              2
#define mmDCP4_INPUT_CSC_C11_C12                                                                       0x0d7b
#define mmDCP4_INPUT_CSC_C11_C12_BASE_IDX                                                              2
#define mmDCP4_INPUT_CSC_C13_C14                                                                       0x0d7c
#define mmDCP4_INPUT_CSC_C13_C14_BASE_IDX                                                              2
#define mmDCP4_INPUT_CSC_C21_C22                                                                       0x0d7d
#define mmDCP4_INPUT_CSC_C21_C22_BASE_IDX                                                              2
#define mmDCP4_INPUT_CSC_C23_C24                                                                       0x0d7e
#define mmDCP4_INPUT_CSC_C23_C24_BASE_IDX                                                              2
#define mmDCP4_INPUT_CSC_C31_C32                                                                       0x0d7f
#define mmDCP4_INPUT_CSC_C31_C32_BASE_IDX                                                              2
#define mmDCP4_INPUT_CSC_C33_C34                                                                       0x0d80
#define mmDCP4_INPUT_CSC_C33_C34_BASE_IDX                                                              2
#define mmDCP4_OUTPUT_CSC_CONTROL                                                                      0x0d81
#define mmDCP4_OUTPUT_CSC_CONTROL_BASE_IDX                                                             2
#define mmDCP4_OUTPUT_CSC_C11_C12                                                                      0x0d82
#define mmDCP4_OUTPUT_CSC_C11_C12_BASE_IDX                                                             2
#define mmDCP4_OUTPUT_CSC_C13_C14                                                                      0x0d83
#define mmDCP4_OUTPUT_CSC_C13_C14_BASE_IDX                                                             2
#define mmDCP4_OUTPUT_CSC_C21_C22                                                                      0x0d84
#define mmDCP4_OUTPUT_CSC_C21_C22_BASE_IDX                                                             2
#define mmDCP4_OUTPUT_CSC_C23_C24                                                                      0x0d85
#define mmDCP4_OUTPUT_CSC_C23_C24_BASE_IDX                                                             2
#define mmDCP4_OUTPUT_CSC_C31_C32                                                                      0x0d86
#define mmDCP4_OUTPUT_CSC_C31_C32_BASE_IDX                                                             2
#define mmDCP4_OUTPUT_CSC_C33_C34                                                                      0x0d87
#define mmDCP4_OUTPUT_CSC_C33_C34_BASE_IDX                                                             2
#define mmDCP4_COMM_MATRIXA_TRANS_C11_C12                                                              0x0d88
#define mmDCP4_COMM_MATRIXA_TRANS_C11_C12_BASE_IDX                                                     2
#define mmDCP4_COMM_MATRIXA_TRANS_C13_C14                                                              0x0d89
#define mmDCP4_COMM_MATRIXA_TRANS_C13_C14_BASE_IDX                                                     2
#define mmDCP4_COMM_MATRIXA_TRANS_C21_C22                                                              0x0d8a
#define mmDCP4_COMM_MATRIXA_TRANS_C21_C22_BASE_IDX                                                     2
#define mmDCP4_COMM_MATRIXA_TRANS_C23_C24                                                              0x0d8b
#define mmDCP4_COMM_MATRIXA_TRANS_C23_C24_BASE_IDX                                                     2
#define mmDCP4_COMM_MATRIXA_TRANS_C31_C32                                                              0x0d8c
#define mmDCP4_COMM_MATRIXA_TRANS_C31_C32_BASE_IDX                                                     2
#define mmDCP4_COMM_MATRIXA_TRANS_C33_C34                                                              0x0d8d
#define mmDCP4_COMM_MATRIXA_TRANS_C33_C34_BASE_IDX                                                     2
#define mmDCP4_COMM_MATRIXB_TRANS_C11_C12                                                              0x0d8e
#define mmDCP4_COMM_MATRIXB_TRANS_C11_C12_BASE_IDX                                                     2
#define mmDCP4_COMM_MATRIXB_TRANS_C13_C14                                                              0x0d8f
#define mmDCP4_COMM_MATRIXB_TRANS_C13_C14_BASE_IDX                                                     2
#define mmDCP4_COMM_MATRIXB_TRANS_C21_C22                                                              0x0d90
#define mmDCP4_COMM_MATRIXB_TRANS_C21_C22_BASE_IDX                                                     2
#define mmDCP4_COMM_MATRIXB_TRANS_C23_C24                                                              0x0d91
#define mmDCP4_COMM_MATRIXB_TRANS_C23_C24_BASE_IDX                                                     2
#define mmDCP4_COMM_MATRIXB_TRANS_C31_C32                                                              0x0d92
#define mmDCP4_COMM_MATRIXB_TRANS_C31_C32_BASE_IDX                                                     2
#define mmDCP4_COMM_MATRIXB_TRANS_C33_C34                                                              0x0d93
#define mmDCP4_COMM_MATRIXB_TRANS_C33_C34_BASE_IDX                                                     2
#define mmDCP4_DENORM_CONTROL                                                                          0x0d94
#define mmDCP4_DENORM_CONTROL_BASE_IDX                                                                 2
#define mmDCP4_OUT_ROUND_CONTROL                                                                       0x0d95
#define mmDCP4_OUT_ROUND_CONTROL_BASE_IDX                                                              2
#define mmDCP4_OUT_CLAMP_CONTROL_R_CR                                                                  0x0d96
#define mmDCP4_OUT_CLAMP_CONTROL_R_CR_BASE_IDX                                                         2
#define mmDCP4_OUT_CLAMP_CONTROL_G_Y                                                                   0x0d97
#define mmDCP4_OUT_CLAMP_CONTROL_G_Y_BASE_IDX                                                          2
#define mmDCP4_OUT_CLAMP_CONTROL_B_CB                                                                  0x0d98
#define mmDCP4_OUT_CLAMP_CONTROL_B_CB_BASE_IDX                                                         2
#define mmDCP4_KEY_CONTROL                                                                             0x0d99
#define mmDCP4_KEY_CONTROL_BASE_IDX                                                                    2
#define mmDCP4_KEY_RANGE_ALPHA                                                                         0x0d9a
#define mmDCP4_KEY_RANGE_ALPHA_BASE_IDX                                                                2
#define mmDCP4_KEY_RANGE_RED                                                                           0x0d9b
#define mmDCP4_KEY_RANGE_RED_BASE_IDX                                                                  2
#define mmDCP4_KEY_RANGE_GREEN                                                                         0x0d9c
#define mmDCP4_KEY_RANGE_GREEN_BASE_IDX                                                                2
#define mmDCP4_KEY_RANGE_BLUE                                                                          0x0d9d
#define mmDCP4_KEY_RANGE_BLUE_BASE_IDX                                                                 2
#define mmDCP4_DEGAMMA_CONTROL                                                                         0x0d9e
#define mmDCP4_DEGAMMA_CONTROL_BASE_IDX                                                                2
#define mmDCP4_GAMUT_REMAP_CONTROL                                                                     0x0d9f
#define mmDCP4_GAMUT_REMAP_CONTROL_BASE_IDX                                                            2
#define mmDCP4_GAMUT_REMAP_C11_C12                                                                     0x0da0
#define mmDCP4_GAMUT_REMAP_C11_C12_BASE_IDX                                                            2
#define mmDCP4_GAMUT_REMAP_C13_C14                                                                     0x0da1
#define mmDCP4_GAMUT_REMAP_C13_C14_BASE_IDX                                                            2
#define mmDCP4_GAMUT_REMAP_C21_C22                                                                     0x0da2
#define mmDCP4_GAMUT_REMAP_C21_C22_BASE_IDX                                                            2
#define mmDCP4_GAMUT_REMAP_C23_C24                                                                     0x0da3
#define mmDCP4_GAMUT_REMAP_C23_C24_BASE_IDX                                                            2
#define mmDCP4_GAMUT_REMAP_C31_C32                                                                     0x0da4
#define mmDCP4_GAMUT_REMAP_C31_C32_BASE_IDX                                                            2
#define mmDCP4_GAMUT_REMAP_C33_C34                                                                     0x0da5
#define mmDCP4_GAMUT_REMAP_C33_C34_BASE_IDX                                                            2
#define mmDCP4_DCP_SPATIAL_DITHER_CNTL                                                                 0x0da6
#define mmDCP4_DCP_SPATIAL_DITHER_CNTL_BASE_IDX                                                        2
#define mmDCP4_DCP_RANDOM_SEEDS                                                                        0x0da7
#define mmDCP4_DCP_RANDOM_SEEDS_BASE_IDX                                                               2
#define mmDCP4_DCP_FP_CONVERTED_FIELD                                                                  0x0da8
#define mmDCP4_DCP_FP_CONVERTED_FIELD_BASE_IDX                                                         2
#define mmDCP4_CUR_CONTROL                                                                             0x0da9
#define mmDCP4_CUR_CONTROL_BASE_IDX                                                                    2
#define mmDCP4_CUR_SURFACE_ADDRESS                                                                     0x0daa
#define mmDCP4_CUR_SURFACE_ADDRESS_BASE_IDX                                                            2
#define mmDCP4_CUR_SIZE                                                                                0x0dab
#define mmDCP4_CUR_SIZE_BASE_IDX                                                                       2
#define mmDCP4_CUR_SURFACE_ADDRESS_HIGH                                                                0x0dac
#define mmDCP4_CUR_SURFACE_ADDRESS_HIGH_BASE_IDX                                                       2
#define mmDCP4_CUR_POSITION                                                                            0x0dad
#define mmDCP4_CUR_POSITION_BASE_IDX                                                                   2
#define mmDCP4_CUR_HOT_SPOT                                                                            0x0dae
#define mmDCP4_CUR_HOT_SPOT_BASE_IDX                                                                   2
#define mmDCP4_CUR_COLOR1                                                                              0x0daf
#define mmDCP4_CUR_COLOR1_BASE_IDX                                                                     2
#define mmDCP4_CUR_COLOR2                                                                              0x0db0
#define mmDCP4_CUR_COLOR2_BASE_IDX                                                                     2
#define mmDCP4_CUR_UPDATE                                                                              0x0db1
#define mmDCP4_CUR_UPDATE_BASE_IDX                                                                     2
#define mmDCP4_CUR_REQUEST_FILTER_CNTL                                                                 0x0dbb
#define mmDCP4_CUR_REQUEST_FILTER_CNTL_BASE_IDX                                                        2
#define mmDCP4_CUR_STEREO_CONTROL                                                                      0x0dbc
#define mmDCP4_CUR_STEREO_CONTROL_BASE_IDX                                                             2
#define mmDCP4_DC_LUT_RW_MODE                                                                          0x0dbe
#define mmDCP4_DC_LUT_RW_MODE_BASE_IDX                                                                 2
#define mmDCP4_DC_LUT_RW_INDEX                                                                         0x0dbf
#define mmDCP4_DC_LUT_RW_INDEX_BASE_IDX                                                                2
#define mmDCP4_DC_LUT_SEQ_COLOR                                                                        0x0dc0
#define mmDCP4_DC_LUT_SEQ_COLOR_BASE_IDX                                                               2
#define mmDCP4_DC_LUT_PWL_DATA                                                                         0x0dc1
#define mmDCP4_DC_LUT_PWL_DATA_BASE_IDX                                                                2
#define mmDCP4_DC_LUT_30_COLOR                                                                         0x0dc2
#define mmDCP4_DC_LUT_30_COLOR_BASE_IDX                                                                2
#define mmDCP4_DC_LUT_VGA_ACCESS_ENABLE                                                                0x0dc3
#define mmDCP4_DC_LUT_VGA_ACCESS_ENABLE_BASE_IDX                                                       2
#define mmDCP4_DC_LUT_WRITE_EN_MASK                                                                    0x0dc4
#define mmDCP4_DC_LUT_WRITE_EN_MASK_BASE_IDX                                                           2
#define mmDCP4_DC_LUT_AUTOFILL                                                                         0x0dc5
#define mmDCP4_DC_LUT_AUTOFILL_BASE_IDX                                                                2
#define mmDCP4_DC_LUT_CONTROL                                                                          0x0dc6
#define mmDCP4_DC_LUT_CONTROL_BASE_IDX                                                                 2
#define mmDCP4_DC_LUT_BLACK_OFFSET_BLUE                                                                0x0dc7
#define mmDCP4_DC_LUT_BLACK_OFFSET_BLUE_BASE_IDX                                                       2
#define mmDCP4_DC_LUT_BLACK_OFFSET_GREEN                                                               0x0dc8
#define mmDCP4_DC_LUT_BLACK_OFFSET_GREEN_BASE_IDX                                                      2
#define mmDCP4_DC_LUT_BLACK_OFFSET_RED                                                                 0x0dc9
#define mmDCP4_DC_LUT_BLACK_OFFSET_RED_BASE_IDX                                                        2
#define mmDCP4_DC_LUT_WHITE_OFFSET_BLUE                                                                0x0dca
#define mmDCP4_DC_LUT_WHITE_OFFSET_BLUE_BASE_IDX                                                       2
#define mmDCP4_DC_LUT_WHITE_OFFSET_GREEN                                                               0x0dcb
#define mmDCP4_DC_LUT_WHITE_OFFSET_GREEN_BASE_IDX                                                      2
#define mmDCP4_DC_LUT_WHITE_OFFSET_RED                                                                 0x0dcc
#define mmDCP4_DC_LUT_WHITE_OFFSET_RED_BASE_IDX                                                        2
#define mmDCP4_DCP_CRC_CONTROL                                                                         0x0dcd
#define mmDCP4_DCP_CRC_CONTROL_BASE_IDX                                                                2
#define mmDCP4_DCP_CRC_MASK                                                                            0x0dce
#define mmDCP4_DCP_CRC_MASK_BASE_IDX                                                                   2
#define mmDCP4_DCP_CRC_CURRENT                                                                         0x0dcf
#define mmDCP4_DCP_CRC_CURRENT_BASE_IDX                                                                2
#define mmDCP4_DVMM_PTE_CONTROL                                                                        0x0dd0
#define mmDCP4_DVMM_PTE_CONTROL_BASE_IDX                                                               2
#define mmDCP4_DCP_CRC_LAST                                                                            0x0dd1
#define mmDCP4_DCP_CRC_LAST_BASE_IDX                                                                   2
#define mmDCP4_DVMM_PTE_ARB_CONTROL                                                                    0x0dd2
#define mmDCP4_DVMM_PTE_ARB_CONTROL_BASE_IDX                                                           2
#define mmDCP4_GRPH_FLIP_RATE_CNTL                                                                     0x0dd4
#define mmDCP4_GRPH_FLIP_RATE_CNTL_BASE_IDX                                                            2
#define mmDCP4_DCP_GSL_CONTROL                                                                         0x0dd5
#define mmDCP4_DCP_GSL_CONTROL_BASE_IDX                                                                2
#define mmDCP4_DCP_LB_DATA_GAP_BETWEEN_CHUNK                                                           0x0dd6
#define mmDCP4_DCP_LB_DATA_GAP_BETWEEN_CHUNK_BASE_IDX                                                  2
#define mmDCP4_GRPH_STEREOSYNC_FLIP                                                                    0x0ddc
#define mmDCP4_GRPH_STEREOSYNC_FLIP_BASE_IDX                                                           2
#define mmDCP4_HW_ROTATION                                                                             0x0dde
#define mmDCP4_HW_ROTATION_BASE_IDX                                                                    2
#define mmDCP4_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL                                                      0x0ddf
#define mmDCP4_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL_BASE_IDX                                             2
#define mmDCP4_REGAMMA_CONTROL                                                                         0x0de0
#define mmDCP4_REGAMMA_CONTROL_BASE_IDX                                                                2
#define mmDCP4_REGAMMA_LUT_INDEX                                                                       0x0de1
#define mmDCP4_REGAMMA_LUT_INDEX_BASE_IDX                                                              2
#define mmDCP4_REGAMMA_LUT_DATA                                                                        0x0de2
#define mmDCP4_REGAMMA_LUT_DATA_BASE_IDX                                                               2
#define mmDCP4_REGAMMA_LUT_WRITE_EN_MASK                                                               0x0de3
#define mmDCP4_REGAMMA_LUT_WRITE_EN_MASK_BASE_IDX                                                      2
#define mmDCP4_REGAMMA_CNTLA_START_CNTL                                                                0x0de4
#define mmDCP4_REGAMMA_CNTLA_START_CNTL_BASE_IDX                                                       2
#define mmDCP4_REGAMMA_CNTLA_SLOPE_CNTL                                                                0x0de5
#define mmDCP4_REGAMMA_CNTLA_SLOPE_CNTL_BASE_IDX                                                       2
#define mmDCP4_REGAMMA_CNTLA_END_CNTL1                                                                 0x0de6
#define mmDCP4_REGAMMA_CNTLA_END_CNTL1_BASE_IDX                                                        2
#define mmDCP4_REGAMMA_CNTLA_END_CNTL2                                                                 0x0de7
#define mmDCP4_REGAMMA_CNTLA_END_CNTL2_BASE_IDX                                                        2
#define mmDCP4_REGAMMA_CNTLA_REGION_0_1                                                                0x0de8
#define mmDCP4_REGAMMA_CNTLA_REGION_0_1_BASE_IDX                                                       2
#define mmDCP4_REGAMMA_CNTLA_REGION_2_3                                                                0x0de9
#define mmDCP4_REGAMMA_CNTLA_REGION_2_3_BASE_IDX                                                       2
#define mmDCP4_REGAMMA_CNTLA_REGION_4_5                                                                0x0dea
#define mmDCP4_REGAMMA_CNTLA_REGION_4_5_BASE_IDX                                                       2
#define mmDCP4_REGAMMA_CNTLA_REGION_6_7                                                                0x0deb
#define mmDCP4_REGAMMA_CNTLA_REGION_6_7_BASE_IDX                                                       2
#define mmDCP4_REGAMMA_CNTLA_REGION_8_9                                                                0x0dec
#define mmDCP4_REGAMMA_CNTLA_REGION_8_9_BASE_IDX                                                       2
#define mmDCP4_REGAMMA_CNTLA_REGION_10_11                                                              0x0ded
#define mmDCP4_REGAMMA_CNTLA_REGION_10_11_BASE_IDX                                                     2
#define mmDCP4_REGAMMA_CNTLA_REGION_12_13                                                              0x0dee
#define mmDCP4_REGAMMA_CNTLA_REGION_12_13_BASE_IDX                                                     2
#define mmDCP4_REGAMMA_CNTLA_REGION_14_15                                                              0x0def
#define mmDCP4_REGAMMA_CNTLA_REGION_14_15_BASE_IDX                                                     2
#define mmDCP4_REGAMMA_CNTLB_START_CNTL                                                                0x0df0
#define mmDCP4_REGAMMA_CNTLB_START_CNTL_BASE_IDX                                                       2
#define mmDCP4_REGAMMA_CNTLB_SLOPE_CNTL                                                                0x0df1
#define mmDCP4_REGAMMA_CNTLB_SLOPE_CNTL_BASE_IDX                                                       2
#define mmDCP4_REGAMMA_CNTLB_END_CNTL1                                                                 0x0df2
#define mmDCP4_REGAMMA_CNTLB_END_CNTL1_BASE_IDX                                                        2
#define mmDCP4_REGAMMA_CNTLB_END_CNTL2                                                                 0x0df3
#define mmDCP4_REGAMMA_CNTLB_END_CNTL2_BASE_IDX                                                        2
#define mmDCP4_REGAMMA_CNTLB_REGION_0_1                                                                0x0df4
#define mmDCP4_REGAMMA_CNTLB_REGION_0_1_BASE_IDX                                                       2
#define mmDCP4_REGAMMA_CNTLB_REGION_2_3                                                                0x0df5
#define mmDCP4_REGAMMA_CNTLB_REGION_2_3_BASE_IDX                                                       2
#define mmDCP4_REGAMMA_CNTLB_REGION_4_5                                                                0x0df6
#define mmDCP4_REGAMMA_CNTLB_REGION_4_5_BASE_IDX                                                       2
#define mmDCP4_REGAMMA_CNTLB_REGION_6_7                                                                0x0df7
#define mmDCP4_REGAMMA_CNTLB_REGION_6_7_BASE_IDX                                                       2
#define mmDCP4_REGAMMA_CNTLB_REGION_8_9                                                                0x0df8
#define mmDCP4_REGAMMA_CNTLB_REGION_8_9_BASE_IDX                                                       2
#define mmDCP4_REGAMMA_CNTLB_REGION_10_11                                                              0x0df9
#define mmDCP4_REGAMMA_CNTLB_REGION_10_11_BASE_IDX                                                     2
#define mmDCP4_REGAMMA_CNTLB_REGION_12_13                                                              0x0dfa
#define mmDCP4_REGAMMA_CNTLB_REGION_12_13_BASE_IDX                                                     2
#define mmDCP4_REGAMMA_CNTLB_REGION_14_15                                                              0x0dfb
#define mmDCP4_REGAMMA_CNTLB_REGION_14_15_BASE_IDX                                                     2
#define mmDCP4_ALPHA_CONTROL                                                                           0x0dfc
#define mmDCP4_ALPHA_CONTROL_BASE_IDX                                                                  2
#define mmDCP4_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS                                                      0x0dfd
#define mmDCP4_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_BASE_IDX                                             2
#define mmDCP4_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH                                                 0x0dfe
#define mmDCP4_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH_BASE_IDX                                        2
#define mmDCP4_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS                                                    0x0dff
#define mmDCP4_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS_BASE_IDX                                           2
#define mmDCP4_GRPH_XDMA_FLIP_TIMEOUT                                                                  0x0e00
#define mmDCP4_GRPH_XDMA_FLIP_TIMEOUT_BASE_IDX                                                         2
#define mmDCP4_GRPH_XDMA_FLIP_AVG_DELAY                                                                0x0e01
#define mmDCP4_GRPH_XDMA_FLIP_AVG_DELAY_BASE_IDX                                                       2
#define mmDCP4_GRPH_SURFACE_COUNTER_CONTROL                                                            0x0e02
#define mmDCP4_GRPH_SURFACE_COUNTER_CONTROL_BASE_IDX                                                   2
#define mmDCP4_GRPH_SURFACE_COUNTER_OUTPUT                                                             0x0e03
#define mmDCP4_GRPH_SURFACE_COUNTER_OUTPUT_BASE_IDX                                                    2


// addressBlock: dce_dc_lb4_dispdec
// base address: 0x2000
#define mmLB4_LB_DATA_FORMAT                                                                           0x0e1a
#define mmLB4_LB_DATA_FORMAT_BASE_IDX                                                                  2
#define mmLB4_LB_MEMORY_CTRL                                                                           0x0e1b
#define mmLB4_LB_MEMORY_CTRL_BASE_IDX                                                                  2
#define mmLB4_LB_MEMORY_SIZE_STATUS                                                                    0x0e1c
#define mmLB4_LB_MEMORY_SIZE_STATUS_BASE_IDX                                                           2
#define mmLB4_LB_DESKTOP_HEIGHT                                                                        0x0e1d
#define mmLB4_LB_DESKTOP_HEIGHT_BASE_IDX                                                               2
#define mmLB4_LB_VLINE_START_END                                                                       0x0e1e
#define mmLB4_LB_VLINE_START_END_BASE_IDX                                                              2
#define mmLB4_LB_VLINE2_START_END                                                                      0x0e1f
#define mmLB4_LB_VLINE2_START_END_BASE_IDX                                                             2
#define mmLB4_LB_V_COUNTER                                                                             0x0e20
#define mmLB4_LB_V_COUNTER_BASE_IDX                                                                    2
#define mmLB4_LB_SNAPSHOT_V_COUNTER                                                                    0x0e21
#define mmLB4_LB_SNAPSHOT_V_COUNTER_BASE_IDX                                                           2
#define mmLB4_LB_INTERRUPT_MASK                                                                        0x0e22
#define mmLB4_LB_INTERRUPT_MASK_BASE_IDX                                                               2
#define mmLB4_LB_VLINE_STATUS                                                                          0x0e23
#define mmLB4_LB_VLINE_STATUS_BASE_IDX                                                                 2
#define mmLB4_LB_VLINE2_STATUS                                                                         0x0e24
#define mmLB4_LB_VLINE2_STATUS_BASE_IDX                                                                2
#define mmLB4_LB_VBLANK_STATUS                                                                         0x0e25
#define mmLB4_LB_VBLANK_STATUS_BASE_IDX                                                                2
#define mmLB4_LB_SYNC_RESET_SEL                                                                        0x0e26
#define mmLB4_LB_SYNC_RESET_SEL_BASE_IDX                                                               2
#define mmLB4_LB_BLACK_KEYER_R_CR                                                                      0x0e27
#define mmLB4_LB_BLACK_KEYER_R_CR_BASE_IDX                                                             2
#define mmLB4_LB_BLACK_KEYER_G_Y                                                                       0x0e28
#define mmLB4_LB_BLACK_KEYER_G_Y_BASE_IDX                                                              2
#define mmLB4_LB_BLACK_KEYER_B_CB                                                                      0x0e29
#define mmLB4_LB_BLACK_KEYER_B_CB_BASE_IDX                                                             2
#define mmLB4_LB_KEYER_COLOR_CTRL                                                                      0x0e2a
#define mmLB4_LB_KEYER_COLOR_CTRL_BASE_IDX                                                             2
#define mmLB4_LB_KEYER_COLOR_R_CR                                                                      0x0e2b
#define mmLB4_LB_KEYER_COLOR_R_CR_BASE_IDX                                                             2
#define mmLB4_LB_KEYER_COLOR_G_Y                                                                       0x0e2c
#define mmLB4_LB_KEYER_COLOR_G_Y_BASE_IDX                                                              2
#define mmLB4_LB_KEYER_COLOR_B_CB                                                                      0x0e2d
#define mmLB4_LB_KEYER_COLOR_B_CB_BASE_IDX                                                             2
#define mmLB4_LB_KEYER_COLOR_REP_R_CR                                                                  0x0e2e
#define mmLB4_LB_KEYER_COLOR_REP_R_CR_BASE_IDX                                                         2
#define mmLB4_LB_KEYER_COLOR_REP_G_Y                                                                   0x0e2f
#define mmLB4_LB_KEYER_COLOR_REP_G_Y_BASE_IDX                                                          2
#define mmLB4_LB_KEYER_COLOR_REP_B_CB                                                                  0x0e30
#define mmLB4_LB_KEYER_COLOR_REP_B_CB_BASE_IDX                                                         2
#define mmLB4_LB_BUFFER_LEVEL_STATUS                                                                   0x0e31
#define mmLB4_LB_BUFFER_LEVEL_STATUS_BASE_IDX                                                          2
#define mmLB4_LB_BUFFER_URGENCY_CTRL                                                                   0x0e32
#define mmLB4_LB_BUFFER_URGENCY_CTRL_BASE_IDX                                                          2
#define mmLB4_LB_BUFFER_URGENCY_STATUS                                                                 0x0e33
#define mmLB4_LB_BUFFER_URGENCY_STATUS_BASE_IDX                                                        2
#define mmLB4_LB_BUFFER_STATUS                                                                         0x0e34
#define mmLB4_LB_BUFFER_STATUS_BASE_IDX                                                                2
#define mmLB4_LB_NO_OUTSTANDING_REQ_STATUS                                                             0x0e35
#define mmLB4_LB_NO_OUTSTANDING_REQ_STATUS_BASE_IDX                                                    2
#define mmLB4_MVP_AFR_FLIP_MODE                                                                        0x0e36
#define mmLB4_MVP_AFR_FLIP_MODE_BASE_IDX                                                               2
#define mmLB4_MVP_AFR_FLIP_FIFO_CNTL                                                                   0x0e37
#define mmLB4_MVP_AFR_FLIP_FIFO_CNTL_BASE_IDX                                                          2
#define mmLB4_MVP_FLIP_LINE_NUM_INSERT                                                                 0x0e38
#define mmLB4_MVP_FLIP_LINE_NUM_INSERT_BASE_IDX                                                        2
#define mmLB4_DC_MVP_LB_CONTROL                                                                        0x0e39
#define mmLB4_DC_MVP_LB_CONTROL_BASE_IDX                                                               2


// addressBlock: dce_dc_dcfe4_dispdec
// base address: 0x2000
#define mmDCFE4_DCFE_CLOCK_CONTROL                                                                     0x0e5a
#define mmDCFE4_DCFE_CLOCK_CONTROL_BASE_IDX                                                            2
#define mmDCFE4_DCFE_SOFT_RESET                                                                        0x0e5b
#define mmDCFE4_DCFE_SOFT_RESET_BASE_IDX                                                               2
#define mmDCFE4_DCFE_MEM_PWR_CTRL                                                                      0x0e5d
#define mmDCFE4_DCFE_MEM_PWR_CTRL_BASE_IDX                                                             2
#define mmDCFE4_DCFE_MEM_PWR_CTRL2                                                                     0x0e5e
#define mmDCFE4_DCFE_MEM_PWR_CTRL2_BASE_IDX                                                            2
#define mmDCFE4_DCFE_MEM_PWR_STATUS                                                                    0x0e5f
#define mmDCFE4_DCFE_MEM_PWR_STATUS_BASE_IDX                                                           2
#define mmDCFE4_DCFE_MISC                                                                              0x0e60
#define mmDCFE4_DCFE_MISC_BASE_IDX                                                                     2
#define mmDCFE4_DCFE_FLUSH                                                                             0x0e61
#define mmDCFE4_DCFE_FLUSH_BASE_IDX                                                                    2


// addressBlock: dce_dc_dc_perfmon7_dispdec
// base address: 0x3938
#define mmDC_PERFMON7_PERFCOUNTER_CNTL                                                                 0x0e6e
#define mmDC_PERFMON7_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON7_PERFCOUNTER_CNTL2                                                                0x0e6f
#define mmDC_PERFMON7_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON7_PERFCOUNTER_STATE                                                                0x0e70
#define mmDC_PERFMON7_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON7_PERFMON_CNTL                                                                     0x0e71
#define mmDC_PERFMON7_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON7_PERFMON_CNTL2                                                                    0x0e72
#define mmDC_PERFMON7_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON7_PERFMON_CVALUE_INT_MISC                                                          0x0e73
#define mmDC_PERFMON7_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON7_PERFMON_CVALUE_LOW                                                               0x0e74
#define mmDC_PERFMON7_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON7_PERFMON_HI                                                                       0x0e75
#define mmDC_PERFMON7_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON7_PERFMON_LOW                                                                      0x0e76
#define mmDC_PERFMON7_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dmif_pg4_dispdec
// base address: 0x2000
#define mmDMIF_PG4_DPG_PIPE_ARBITRATION_CONTROL1                                                       0x0e7a
#define mmDMIF_PG4_DPG_PIPE_ARBITRATION_CONTROL1_BASE_IDX                                              2
#define mmDMIF_PG4_DPG_PIPE_ARBITRATION_CONTROL2                                                       0x0e7b
#define mmDMIF_PG4_DPG_PIPE_ARBITRATION_CONTROL2_BASE_IDX                                              2
#define mmDMIF_PG4_DPG_WATERMARK_MASK_CONTROL                                                          0x0e7c
#define mmDMIF_PG4_DPG_WATERMARK_MASK_CONTROL_BASE_IDX                                                 2
#define mmDMIF_PG4_DPG_PIPE_URGENCY_CONTROL                                                            0x0e7d
#define mmDMIF_PG4_DPG_PIPE_URGENCY_CONTROL_BASE_IDX                                                   2
#define mmDMIF_PG4_DPG_PIPE_URGENT_LEVEL_CONTROL                                                       0x0e7e
#define mmDMIF_PG4_DPG_PIPE_URGENT_LEVEL_CONTROL_BASE_IDX                                              2
#define mmDMIF_PG4_DPG_PIPE_STUTTER_CONTROL                                                            0x0e7f
#define mmDMIF_PG4_DPG_PIPE_STUTTER_CONTROL_BASE_IDX                                                   2
#define mmDMIF_PG4_DPG_PIPE_STUTTER_CONTROL2                                                           0x0e80
#define mmDMIF_PG4_DPG_PIPE_STUTTER_CONTROL2_BASE_IDX                                                  2
#define mmDMIF_PG4_DPG_PIPE_LOW_POWER_CONTROL                                                          0x0e81
#define mmDMIF_PG4_DPG_PIPE_LOW_POWER_CONTROL_BASE_IDX                                                 2
#define mmDMIF_PG4_DPG_REPEATER_PROGRAM                                                                0x0e82
#define mmDMIF_PG4_DPG_REPEATER_PROGRAM_BASE_IDX                                                       2
#define mmDMIF_PG4_DPG_CHK_PRE_PROC_CNTL                                                               0x0e86
#define mmDMIF_PG4_DPG_CHK_PRE_PROC_CNTL_BASE_IDX                                                      2
#define mmDMIF_PG4_DPG_DVMM_STATUS                                                                     0x0e87
#define mmDMIF_PG4_DPG_DVMM_STATUS_BASE_IDX                                                            2


// addressBlock: dce_dc_scl4_dispdec
// base address: 0x2000
#define mmSCL4_SCL_COEF_RAM_SELECT                                                                     0x0e9a
#define mmSCL4_SCL_COEF_RAM_SELECT_BASE_IDX                                                            2
#define mmSCL4_SCL_COEF_RAM_TAP_DATA                                                                   0x0e9b
#define mmSCL4_SCL_COEF_RAM_TAP_DATA_BASE_IDX                                                          2
#define mmSCL4_SCL_MODE                                                                                0x0e9c
#define mmSCL4_SCL_MODE_BASE_IDX                                                                       2
#define mmSCL4_SCL_TAP_CONTROL                                                                         0x0e9d
#define mmSCL4_SCL_TAP_CONTROL_BASE_IDX                                                                2
#define mmSCL4_SCL_CONTROL                                                                             0x0e9e
#define mmSCL4_SCL_CONTROL_BASE_IDX                                                                    2
#define mmSCL4_SCL_BYPASS_CONTROL                                                                      0x0e9f
#define mmSCL4_SCL_BYPASS_CONTROL_BASE_IDX                                                             2
#define mmSCL4_SCL_MANUAL_REPLICATE_CONTROL                                                            0x0ea0
#define mmSCL4_SCL_MANUAL_REPLICATE_CONTROL_BASE_IDX                                                   2
#define mmSCL4_SCL_AUTOMATIC_MODE_CONTROL                                                              0x0ea1
#define mmSCL4_SCL_AUTOMATIC_MODE_CONTROL_BASE_IDX                                                     2
#define mmSCL4_SCL_HORZ_FILTER_CONTROL                                                                 0x0ea2
#define mmSCL4_SCL_HORZ_FILTER_CONTROL_BASE_IDX                                                        2
#define mmSCL4_SCL_HORZ_FILTER_SCALE_RATIO                                                             0x0ea3
#define mmSCL4_SCL_HORZ_FILTER_SCALE_RATIO_BASE_IDX                                                    2
#define mmSCL4_SCL_HORZ_FILTER_INIT                                                                    0x0ea4
#define mmSCL4_SCL_HORZ_FILTER_INIT_BASE_IDX                                                           2
#define mmSCL4_SCL_VERT_FILTER_CONTROL                                                                 0x0ea5
#define mmSCL4_SCL_VERT_FILTER_CONTROL_BASE_IDX                                                        2
#define mmSCL4_SCL_VERT_FILTER_SCALE_RATIO                                                             0x0ea6
#define mmSCL4_SCL_VERT_FILTER_SCALE_RATIO_BASE_IDX                                                    2
#define mmSCL4_SCL_VERT_FILTER_INIT                                                                    0x0ea7
#define mmSCL4_SCL_VERT_FILTER_INIT_BASE_IDX                                                           2
#define mmSCL4_SCL_VERT_FILTER_INIT_BOT                                                                0x0ea8
#define mmSCL4_SCL_VERT_FILTER_INIT_BOT_BASE_IDX                                                       2
#define mmSCL4_SCL_ROUND_OFFSET                                                                        0x0ea9
#define mmSCL4_SCL_ROUND_OFFSET_BASE_IDX                                                               2
#define mmSCL4_SCL_UPDATE                                                                              0x0eaa
#define mmSCL4_SCL_UPDATE_BASE_IDX                                                                     2
#define mmSCL4_SCL_F_SHARP_CONTROL                                                                     0x0eab
#define mmSCL4_SCL_F_SHARP_CONTROL_BASE_IDX                                                            2
#define mmSCL4_SCL_ALU_CONTROL                                                                         0x0eac
#define mmSCL4_SCL_ALU_CONTROL_BASE_IDX                                                                2
#define mmSCL4_SCL_COEF_RAM_CONFLICT_STATUS                                                            0x0ead
#define mmSCL4_SCL_COEF_RAM_CONFLICT_STATUS_BASE_IDX                                                   2
#define mmSCL4_VIEWPORT_START_SECONDARY                                                                0x0eae
#define mmSCL4_VIEWPORT_START_SECONDARY_BASE_IDX                                                       2
#define mmSCL4_VIEWPORT_START                                                                          0x0eaf
#define mmSCL4_VIEWPORT_START_BASE_IDX                                                                 2
#define mmSCL4_VIEWPORT_SIZE                                                                           0x0eb0
#define mmSCL4_VIEWPORT_SIZE_BASE_IDX                                                                  2
#define mmSCL4_EXT_OVERSCAN_LEFT_RIGHT                                                                 0x0eb1
#define mmSCL4_EXT_OVERSCAN_LEFT_RIGHT_BASE_IDX                                                        2
#define mmSCL4_EXT_OVERSCAN_TOP_BOTTOM                                                                 0x0eb2
#define mmSCL4_EXT_OVERSCAN_TOP_BOTTOM_BASE_IDX                                                        2
#define mmSCL4_SCL_MODE_CHANGE_DET1                                                                    0x0eb3
#define mmSCL4_SCL_MODE_CHANGE_DET1_BASE_IDX                                                           2
#define mmSCL4_SCL_MODE_CHANGE_DET2                                                                    0x0eb4
#define mmSCL4_SCL_MODE_CHANGE_DET2_BASE_IDX                                                           2
#define mmSCL4_SCL_MODE_CHANGE_DET3                                                                    0x0eb5
#define mmSCL4_SCL_MODE_CHANGE_DET3_BASE_IDX                                                           2
#define mmSCL4_SCL_MODE_CHANGE_MASK                                                                    0x0eb6
#define mmSCL4_SCL_MODE_CHANGE_MASK_BASE_IDX                                                           2


// addressBlock: dce_dc_blnd4_dispdec
// base address: 0x2000
#define mmBLND4_BLND_CONTROL                                                                           0x0ec7
#define mmBLND4_BLND_CONTROL_BASE_IDX                                                                  2
#define mmBLND4_BLND_SM_CONTROL2                                                                       0x0ec8
#define mmBLND4_BLND_SM_CONTROL2_BASE_IDX                                                              2
#define mmBLND4_BLND_CONTROL2                                                                          0x0ec9
#define mmBLND4_BLND_CONTROL2_BASE_IDX                                                                 2
#define mmBLND4_BLND_UPDATE                                                                            0x0eca
#define mmBLND4_BLND_UPDATE_BASE_IDX                                                                   2
#define mmBLND4_BLND_UNDERFLOW_INTERRUPT                                                               0x0ecb
#define mmBLND4_BLND_UNDERFLOW_INTERRUPT_BASE_IDX                                                      2
#define mmBLND4_BLND_V_UPDATE_LOCK                                                                     0x0ecc
#define mmBLND4_BLND_V_UPDATE_LOCK_BASE_IDX                                                            2
#define mmBLND4_BLND_REG_UPDATE_STATUS                                                                 0x0ecd
#define mmBLND4_BLND_REG_UPDATE_STATUS_BASE_IDX                                                        2


// addressBlock: dce_dc_crtc4_dispdec
// base address: 0x2000
#define mmCRTC4_CRTC_H_BLANK_EARLY_NUM                                                                 0x0ed2
#define mmCRTC4_CRTC_H_BLANK_EARLY_NUM_BASE_IDX                                                        2
#define mmCRTC4_CRTC_H_TOTAL                                                                           0x0ed3
#define mmCRTC4_CRTC_H_TOTAL_BASE_IDX                                                                  2
#define mmCRTC4_CRTC_H_BLANK_START_END                                                                 0x0ed4
#define mmCRTC4_CRTC_H_BLANK_START_END_BASE_IDX                                                        2
#define mmCRTC4_CRTC_H_SYNC_A                                                                          0x0ed5
#define mmCRTC4_CRTC_H_SYNC_A_BASE_IDX                                                                 2
#define mmCRTC4_CRTC_H_SYNC_A_CNTL                                                                     0x0ed6
#define mmCRTC4_CRTC_H_SYNC_A_CNTL_BASE_IDX                                                            2
#define mmCRTC4_CRTC_H_SYNC_B                                                                          0x0ed7
#define mmCRTC4_CRTC_H_SYNC_B_BASE_IDX                                                                 2
#define mmCRTC4_CRTC_H_SYNC_B_CNTL                                                                     0x0ed8
#define mmCRTC4_CRTC_H_SYNC_B_CNTL_BASE_IDX                                                            2
#define mmCRTC4_CRTC_VBI_END                                                                           0x0ed9
#define mmCRTC4_CRTC_VBI_END_BASE_IDX                                                                  2
#define mmCRTC4_CRTC_V_TOTAL                                                                           0x0eda
#define mmCRTC4_CRTC_V_TOTAL_BASE_IDX                                                                  2
#define mmCRTC4_CRTC_V_TOTAL_MIN                                                                       0x0edb
#define mmCRTC4_CRTC_V_TOTAL_MIN_BASE_IDX                                                              2
#define mmCRTC4_CRTC_V_TOTAL_MAX                                                                       0x0edc
#define mmCRTC4_CRTC_V_TOTAL_MAX_BASE_IDX                                                              2
#define mmCRTC4_CRTC_V_TOTAL_CONTROL                                                                   0x0edd
#define mmCRTC4_CRTC_V_TOTAL_CONTROL_BASE_IDX                                                          2
#define mmCRTC4_CRTC_V_TOTAL_INT_STATUS                                                                0x0ede
#define mmCRTC4_CRTC_V_TOTAL_INT_STATUS_BASE_IDX                                                       2
#define mmCRTC4_CRTC_VSYNC_NOM_INT_STATUS                                                              0x0edf
#define mmCRTC4_CRTC_VSYNC_NOM_INT_STATUS_BASE_IDX                                                     2
#define mmCRTC4_CRTC_V_BLANK_START_END                                                                 0x0ee0
#define mmCRTC4_CRTC_V_BLANK_START_END_BASE_IDX                                                        2
#define mmCRTC4_CRTC_V_SYNC_A                                                                          0x0ee1
#define mmCRTC4_CRTC_V_SYNC_A_BASE_IDX                                                                 2
#define mmCRTC4_CRTC_V_SYNC_A_CNTL                                                                     0x0ee2
#define mmCRTC4_CRTC_V_SYNC_A_CNTL_BASE_IDX                                                            2
#define mmCRTC4_CRTC_V_SYNC_B                                                                          0x0ee3
#define mmCRTC4_CRTC_V_SYNC_B_BASE_IDX                                                                 2
#define mmCRTC4_CRTC_V_SYNC_B_CNTL                                                                     0x0ee4
#define mmCRTC4_CRTC_V_SYNC_B_CNTL_BASE_IDX                                                            2
#define mmCRTC4_CRTC_DTMTEST_CNTL                                                                      0x0ee5
#define mmCRTC4_CRTC_DTMTEST_CNTL_BASE_IDX                                                             2
#define mmCRTC4_CRTC_DTMTEST_STATUS_POSITION                                                           0x0ee6
#define mmCRTC4_CRTC_DTMTEST_STATUS_POSITION_BASE_IDX                                                  2
#define mmCRTC4_CRTC_TRIGA_CNTL                                                                        0x0ee7
#define mmCRTC4_CRTC_TRIGA_CNTL_BASE_IDX                                                               2
#define mmCRTC4_CRTC_TRIGA_MANUAL_TRIG                                                                 0x0ee8
#define mmCRTC4_CRTC_TRIGA_MANUAL_TRIG_BASE_IDX                                                        2
#define mmCRTC4_CRTC_TRIGB_CNTL                                                                        0x0ee9
#define mmCRTC4_CRTC_TRIGB_CNTL_BASE_IDX                                                               2
#define mmCRTC4_CRTC_TRIGB_MANUAL_TRIG                                                                 0x0eea
#define mmCRTC4_CRTC_TRIGB_MANUAL_TRIG_BASE_IDX                                                        2
#define mmCRTC4_CRTC_FORCE_COUNT_NOW_CNTL                                                              0x0eeb
#define mmCRTC4_CRTC_FORCE_COUNT_NOW_CNTL_BASE_IDX                                                     2
#define mmCRTC4_CRTC_FLOW_CONTROL                                                                      0x0eec
#define mmCRTC4_CRTC_FLOW_CONTROL_BASE_IDX                                                             2
#define mmCRTC4_CRTC_STEREO_FORCE_NEXT_EYE                                                             0x0eed
#define mmCRTC4_CRTC_STEREO_FORCE_NEXT_EYE_BASE_IDX                                                    2
#define mmCRTC4_CRTC_AVSYNC_COUNTER                                                                    0x0eee
#define mmCRTC4_CRTC_AVSYNC_COUNTER_BASE_IDX                                                           2
#define mmCRTC4_CRTC_CONTROL                                                                           0x0eef
#define mmCRTC4_CRTC_CONTROL_BASE_IDX                                                                  2
#define mmCRTC4_CRTC_BLANK_CONTROL                                                                     0x0ef0
#define mmCRTC4_CRTC_BLANK_CONTROL_BASE_IDX                                                            2
#define mmCRTC4_CRTC_INTERLACE_CONTROL                                                                 0x0ef1
#define mmCRTC4_CRTC_INTERLACE_CONTROL_BASE_IDX                                                        2
#define mmCRTC4_CRTC_INTERLACE_STATUS                                                                  0x0ef2
#define mmCRTC4_CRTC_INTERLACE_STATUS_BASE_IDX                                                         2
#define mmCRTC4_CRTC_FIELD_INDICATION_CONTROL                                                          0x0ef3
#define mmCRTC4_CRTC_FIELD_INDICATION_CONTROL_BASE_IDX                                                 2
#define mmCRTC4_CRTC_PIXEL_DATA_READBACK0                                                              0x0ef4
#define mmCRTC4_CRTC_PIXEL_DATA_READBACK0_BASE_IDX                                                     2
#define mmCRTC4_CRTC_PIXEL_DATA_READBACK1                                                              0x0ef5
#define mmCRTC4_CRTC_PIXEL_DATA_READBACK1_BASE_IDX                                                     2
#define mmCRTC4_CRTC_STATUS                                                                            0x0ef6
#define mmCRTC4_CRTC_STATUS_BASE_IDX                                                                   2
#define mmCRTC4_CRTC_STATUS_POSITION                                                                   0x0ef7
#define mmCRTC4_CRTC_STATUS_POSITION_BASE_IDX                                                          2
#define mmCRTC4_CRTC_NOM_VERT_POSITION                                                                 0x0ef8
#define mmCRTC4_CRTC_NOM_VERT_POSITION_BASE_IDX                                                        2
#define mmCRTC4_CRTC_STATUS_FRAME_COUNT                                                                0x0ef9
#define mmCRTC4_CRTC_STATUS_FRAME_COUNT_BASE_IDX                                                       2
#define mmCRTC4_CRTC_STATUS_VF_COUNT                                                                   0x0efa
#define mmCRTC4_CRTC_STATUS_VF_COUNT_BASE_IDX                                                          2
#define mmCRTC4_CRTC_STATUS_HV_COUNT                                                                   0x0efb
#define mmCRTC4_CRTC_STATUS_HV_COUNT_BASE_IDX                                                          2
#define mmCRTC4_CRTC_COUNT_CONTROL                                                                     0x0efc
#define mmCRTC4_CRTC_COUNT_CONTROL_BASE_IDX                                                            2
#define mmCRTC4_CRTC_COUNT_RESET                                                                       0x0efd
#define mmCRTC4_CRTC_COUNT_RESET_BASE_IDX                                                              2
#define mmCRTC4_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE                                                      0x0efe
#define mmCRTC4_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE_BASE_IDX                                             2
#define mmCRTC4_CRTC_VERT_SYNC_CONTROL                                                                 0x0eff
#define mmCRTC4_CRTC_VERT_SYNC_CONTROL_BASE_IDX                                                        2
#define mmCRTC4_CRTC_STEREO_STATUS                                                                     0x0f00
#define mmCRTC4_CRTC_STEREO_STATUS_BASE_IDX                                                            2
#define mmCRTC4_CRTC_STEREO_CONTROL                                                                    0x0f01
#define mmCRTC4_CRTC_STEREO_CONTROL_BASE_IDX                                                           2
#define mmCRTC4_CRTC_SNAPSHOT_STATUS                                                                   0x0f02
#define mmCRTC4_CRTC_SNAPSHOT_STATUS_BASE_IDX                                                          2
#define mmCRTC4_CRTC_SNAPSHOT_CONTROL                                                                  0x0f03
#define mmCRTC4_CRTC_SNAPSHOT_CONTROL_BASE_IDX                                                         2
#define mmCRTC4_CRTC_SNAPSHOT_POSITION                                                                 0x0f04
#define mmCRTC4_CRTC_SNAPSHOT_POSITION_BASE_IDX                                                        2
#define mmCRTC4_CRTC_SNAPSHOT_FRAME                                                                    0x0f05
#define mmCRTC4_CRTC_SNAPSHOT_FRAME_BASE_IDX                                                           2
#define mmCRTC4_CRTC_START_LINE_CONTROL                                                                0x0f06
#define mmCRTC4_CRTC_START_LINE_CONTROL_BASE_IDX                                                       2
#define mmCRTC4_CRTC_INTERRUPT_CONTROL                                                                 0x0f07
#define mmCRTC4_CRTC_INTERRUPT_CONTROL_BASE_IDX                                                        2
#define mmCRTC4_CRTC_UPDATE_LOCK                                                                       0x0f08
#define mmCRTC4_CRTC_UPDATE_LOCK_BASE_IDX                                                              2
#define mmCRTC4_CRTC_DOUBLE_BUFFER_CONTROL                                                             0x0f09
#define mmCRTC4_CRTC_DOUBLE_BUFFER_CONTROL_BASE_IDX                                                    2
#define mmCRTC4_CRTC_VGA_PARAMETER_CAPTURE_MODE                                                        0x0f0a
#define mmCRTC4_CRTC_VGA_PARAMETER_CAPTURE_MODE_BASE_IDX                                               2
#define mmCRTC4_CRTC_TEST_PATTERN_CONTROL                                                              0x0f0b
#define mmCRTC4_CRTC_TEST_PATTERN_CONTROL_BASE_IDX                                                     2
#define mmCRTC4_CRTC_TEST_PATTERN_PARAMETERS                                                           0x0f0c
#define mmCRTC4_CRTC_TEST_PATTERN_PARAMETERS_BASE_IDX                                                  2
#define mmCRTC4_CRTC_TEST_PATTERN_COLOR                                                                0x0f0d
#define mmCRTC4_CRTC_TEST_PATTERN_COLOR_BASE_IDX                                                       2
#define mmCRTC4_CRTC_MASTER_UPDATE_LOCK                                                                0x0f0e
#define mmCRTC4_CRTC_MASTER_UPDATE_LOCK_BASE_IDX                                                       2
#define mmCRTC4_CRTC_MASTER_UPDATE_MODE                                                                0x0f0f
#define mmCRTC4_CRTC_MASTER_UPDATE_MODE_BASE_IDX                                                       2
#define mmCRTC4_CRTC_MVP_INBAND_CNTL_INSERT                                                            0x0f10
#define mmCRTC4_CRTC_MVP_INBAND_CNTL_INSERT_BASE_IDX                                                   2
#define mmCRTC4_CRTC_MVP_INBAND_CNTL_INSERT_TIMER                                                      0x0f11
#define mmCRTC4_CRTC_MVP_INBAND_CNTL_INSERT_TIMER_BASE_IDX                                             2
#define mmCRTC4_CRTC_MVP_STATUS                                                                        0x0f12
#define mmCRTC4_CRTC_MVP_STATUS_BASE_IDX                                                               2
#define mmCRTC4_CRTC_MASTER_EN                                                                         0x0f13
#define mmCRTC4_CRTC_MASTER_EN_BASE_IDX                                                                2
#define mmCRTC4_CRTC_ALLOW_STOP_OFF_V_CNT                                                              0x0f14
#define mmCRTC4_CRTC_ALLOW_STOP_OFF_V_CNT_BASE_IDX                                                     2
#define mmCRTC4_CRTC_V_UPDATE_INT_STATUS                                                               0x0f15
#define mmCRTC4_CRTC_V_UPDATE_INT_STATUS_BASE_IDX                                                      2
#define mmCRTC4_CRTC_OVERSCAN_COLOR                                                                    0x0f17
#define mmCRTC4_CRTC_OVERSCAN_COLOR_BASE_IDX                                                           2
#define mmCRTC4_CRTC_OVERSCAN_COLOR_EXT                                                                0x0f18
#define mmCRTC4_CRTC_OVERSCAN_COLOR_EXT_BASE_IDX                                                       2
#define mmCRTC4_CRTC_BLANK_DATA_COLOR                                                                  0x0f19
#define mmCRTC4_CRTC_BLANK_DATA_COLOR_BASE_IDX                                                         2
#define mmCRTC4_CRTC_BLANK_DATA_COLOR_EXT                                                              0x0f1a
#define mmCRTC4_CRTC_BLANK_DATA_COLOR_EXT_BASE_IDX                                                     2
#define mmCRTC4_CRTC_BLACK_COLOR                                                                       0x0f1b
#define mmCRTC4_CRTC_BLACK_COLOR_BASE_IDX                                                              2
#define mmCRTC4_CRTC_BLACK_COLOR_EXT                                                                   0x0f1c
#define mmCRTC4_CRTC_BLACK_COLOR_EXT_BASE_IDX                                                          2
#define mmCRTC4_CRTC_VERTICAL_INTERRUPT0_POSITION                                                      0x0f1d
#define mmCRTC4_CRTC_VERTICAL_INTERRUPT0_POSITION_BASE_IDX                                             2
#define mmCRTC4_CRTC_VERTICAL_INTERRUPT0_CONTROL                                                       0x0f1e
#define mmCRTC4_CRTC_VERTICAL_INTERRUPT0_CONTROL_BASE_IDX                                              2
#define mmCRTC4_CRTC_VERTICAL_INTERRUPT1_POSITION                                                      0x0f1f
#define mmCRTC4_CRTC_VERTICAL_INTERRUPT1_POSITION_BASE_IDX                                             2
#define mmCRTC4_CRTC_VERTICAL_INTERRUPT1_CONTROL                                                       0x0f20
#define mmCRTC4_CRTC_VERTICAL_INTERRUPT1_CONTROL_BASE_IDX                                              2
#define mmCRTC4_CRTC_VERTICAL_INTERRUPT2_POSITION                                                      0x0f21
#define mmCRTC4_CRTC_VERTICAL_INTERRUPT2_POSITION_BASE_IDX                                             2
#define mmCRTC4_CRTC_VERTICAL_INTERRUPT2_CONTROL                                                       0x0f22
#define mmCRTC4_CRTC_VERTICAL_INTERRUPT2_CONTROL_BASE_IDX                                              2
#define mmCRTC4_CRTC_CRC_CNTL                                                                          0x0f23
#define mmCRTC4_CRTC_CRC_CNTL_BASE_IDX                                                                 2
#define mmCRTC4_CRTC_CRC0_WINDOWA_X_CONTROL                                                            0x0f24
#define mmCRTC4_CRTC_CRC0_WINDOWA_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC4_CRTC_CRC0_WINDOWA_Y_CONTROL                                                            0x0f25
#define mmCRTC4_CRTC_CRC0_WINDOWA_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC4_CRTC_CRC0_WINDOWB_X_CONTROL                                                            0x0f26
#define mmCRTC4_CRTC_CRC0_WINDOWB_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC4_CRTC_CRC0_WINDOWB_Y_CONTROL                                                            0x0f27
#define mmCRTC4_CRTC_CRC0_WINDOWB_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC4_CRTC_CRC0_DATA_RG                                                                      0x0f28
#define mmCRTC4_CRTC_CRC0_DATA_RG_BASE_IDX                                                             2
#define mmCRTC4_CRTC_CRC0_DATA_B                                                                       0x0f29
#define mmCRTC4_CRTC_CRC0_DATA_B_BASE_IDX                                                              2
#define mmCRTC4_CRTC_CRC1_WINDOWA_X_CONTROL                                                            0x0f2a
#define mmCRTC4_CRTC_CRC1_WINDOWA_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC4_CRTC_CRC1_WINDOWA_Y_CONTROL                                                            0x0f2b
#define mmCRTC4_CRTC_CRC1_WINDOWA_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC4_CRTC_CRC1_WINDOWB_X_CONTROL                                                            0x0f2c
#define mmCRTC4_CRTC_CRC1_WINDOWB_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC4_CRTC_CRC1_WINDOWB_Y_CONTROL                                                            0x0f2d
#define mmCRTC4_CRTC_CRC1_WINDOWB_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC4_CRTC_CRC1_DATA_RG                                                                      0x0f2e
#define mmCRTC4_CRTC_CRC1_DATA_RG_BASE_IDX                                                             2
#define mmCRTC4_CRTC_CRC1_DATA_B                                                                       0x0f2f
#define mmCRTC4_CRTC_CRC1_DATA_B_BASE_IDX                                                              2
#define mmCRTC4_CRTC_EXT_TIMING_SYNC_CONTROL                                                           0x0f30
#define mmCRTC4_CRTC_EXT_TIMING_SYNC_CONTROL_BASE_IDX                                                  2
#define mmCRTC4_CRTC_EXT_TIMING_SYNC_WINDOW_START                                                      0x0f31
#define mmCRTC4_CRTC_EXT_TIMING_SYNC_WINDOW_START_BASE_IDX                                             2
#define mmCRTC4_CRTC_EXT_TIMING_SYNC_WINDOW_END                                                        0x0f32
#define mmCRTC4_CRTC_EXT_TIMING_SYNC_WINDOW_END_BASE_IDX                                               2
#define mmCRTC4_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL                                            0x0f33
#define mmCRTC4_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_BASE_IDX                                   2
#define mmCRTC4_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL                                                 0x0f34
#define mmCRTC4_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL_BASE_IDX                                        2
#define mmCRTC4_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL                                          0x0f35
#define mmCRTC4_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL_BASE_IDX                                 2
#define mmCRTC4_CRTC_STATIC_SCREEN_CONTROL                                                             0x0f36
#define mmCRTC4_CRTC_STATIC_SCREEN_CONTROL_BASE_IDX                                                    2
#define mmCRTC4_CRTC_3D_STRUCTURE_CONTROL                                                              0x0f37
#define mmCRTC4_CRTC_3D_STRUCTURE_CONTROL_BASE_IDX                                                     2
#define mmCRTC4_CRTC_GSL_VSYNC_GAP                                                                     0x0f38
#define mmCRTC4_CRTC_GSL_VSYNC_GAP_BASE_IDX                                                            2
#define mmCRTC4_CRTC_GSL_WINDOW                                                                        0x0f39
#define mmCRTC4_CRTC_GSL_WINDOW_BASE_IDX                                                               2
#define mmCRTC4_CRTC_GSL_CONTROL                                                                       0x0f3a
#define mmCRTC4_CRTC_GSL_CONTROL_BASE_IDX                                                              2
#define mmCRTC4_CRTC_RANGE_TIMING_INT_STATUS                                                           0x0f3d
#define mmCRTC4_CRTC_RANGE_TIMING_INT_STATUS_BASE_IDX                                                  2
#define mmCRTC4_CRTC_DRR_CONTROL                                                                       0x0f3e
#define mmCRTC4_CRTC_DRR_CONTROL_BASE_IDX                                                              2


// addressBlock: dce_dc_fmt4_dispdec
// base address: 0x2000
#define mmFMT4_FMT_CLAMP_COMPONENT_R                                                                   0x0f42
#define mmFMT4_FMT_CLAMP_COMPONENT_R_BASE_IDX                                                          2
#define mmFMT4_FMT_CLAMP_COMPONENT_G                                                                   0x0f43
#define mmFMT4_FMT_CLAMP_COMPONENT_G_BASE_IDX                                                          2
#define mmFMT4_FMT_CLAMP_COMPONENT_B                                                                   0x0f44
#define mmFMT4_FMT_CLAMP_COMPONENT_B_BASE_IDX                                                          2
#define mmFMT4_FMT_DYNAMIC_EXP_CNTL                                                                    0x0f45
#define mmFMT4_FMT_DYNAMIC_EXP_CNTL_BASE_IDX                                                           2
#define mmFMT4_FMT_CONTROL                                                                             0x0f46
#define mmFMT4_FMT_CONTROL_BASE_IDX                                                                    2
#define mmFMT4_FMT_BIT_DEPTH_CONTROL                                                                   0x0f47
#define mmFMT4_FMT_BIT_DEPTH_CONTROL_BASE_IDX                                                          2
#define mmFMT4_FMT_DITHER_RAND_R_SEED                                                                  0x0f48
#define mmFMT4_FMT_DITHER_RAND_R_SEED_BASE_IDX                                                         2
#define mmFMT4_FMT_DITHER_RAND_G_SEED                                                                  0x0f49
#define mmFMT4_FMT_DITHER_RAND_G_SEED_BASE_IDX                                                         2
#define mmFMT4_FMT_DITHER_RAND_B_SEED                                                                  0x0f4a
#define mmFMT4_FMT_DITHER_RAND_B_SEED_BASE_IDX                                                         2
#define mmFMT4_FMT_CLAMP_CNTL                                                                          0x0f4e
#define mmFMT4_FMT_CLAMP_CNTL_BASE_IDX                                                                 2
#define mmFMT4_FMT_CRC_CNTL                                                                            0x0f4f
#define mmFMT4_FMT_CRC_CNTL_BASE_IDX                                                                   2
#define mmFMT4_FMT_CRC_SIG_RED_GREEN_MASK                                                              0x0f50
#define mmFMT4_FMT_CRC_SIG_RED_GREEN_MASK_BASE_IDX                                                     2
#define mmFMT4_FMT_CRC_SIG_BLUE_CONTROL_MASK                                                           0x0f51
#define mmFMT4_FMT_CRC_SIG_BLUE_CONTROL_MASK_BASE_IDX                                                  2
#define mmFMT4_FMT_CRC_SIG_RED_GREEN                                                                   0x0f52
#define mmFMT4_FMT_CRC_SIG_RED_GREEN_BASE_IDX                                                          2
#define mmFMT4_FMT_CRC_SIG_BLUE_CONTROL                                                                0x0f53
#define mmFMT4_FMT_CRC_SIG_BLUE_CONTROL_BASE_IDX                                                       2
#define mmFMT4_FMT_SIDE_BY_SIDE_STEREO_CONTROL                                                         0x0f54
#define mmFMT4_FMT_SIDE_BY_SIDE_STEREO_CONTROL_BASE_IDX                                                2
#define mmFMT4_FMT_420_HBLANK_EARLY_START                                                              0x0f55
#define mmFMT4_FMT_420_HBLANK_EARLY_START_BASE_IDX                                                     2


// addressBlock: dce_dc_dcp5_dispdec
// base address: 0x2800
#define mmDCP5_GRPH_ENABLE                                                                             0x0f5a
#define mmDCP5_GRPH_ENABLE_BASE_IDX                                                                    2
#define mmDCP5_GRPH_CONTROL                                                                            0x0f5b
#define mmDCP5_GRPH_CONTROL_BASE_IDX                                                                   2
#define mmDCP5_GRPH_LUT_10BIT_BYPASS                                                                   0x0f5c
#define mmDCP5_GRPH_LUT_10BIT_BYPASS_BASE_IDX                                                          2
#define mmDCP5_GRPH_SWAP_CNTL                                                                          0x0f5d
#define mmDCP5_GRPH_SWAP_CNTL_BASE_IDX                                                                 2
#define mmDCP5_GRPH_PRIMARY_SURFACE_ADDRESS                                                            0x0f5e
#define mmDCP5_GRPH_PRIMARY_SURFACE_ADDRESS_BASE_IDX                                                   2
#define mmDCP5_GRPH_SECONDARY_SURFACE_ADDRESS                                                          0x0f5f
#define mmDCP5_GRPH_SECONDARY_SURFACE_ADDRESS_BASE_IDX                                                 2
#define mmDCP5_GRPH_PITCH                                                                              0x0f60
#define mmDCP5_GRPH_PITCH_BASE_IDX                                                                     2
#define mmDCP5_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH                                                       0x0f61
#define mmDCP5_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                              2
#define mmDCP5_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH                                                     0x0f62
#define mmDCP5_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH_BASE_IDX                                            2
#define mmDCP5_GRPH_SURFACE_OFFSET_X                                                                   0x0f63
#define mmDCP5_GRPH_SURFACE_OFFSET_X_BASE_IDX                                                          2
#define mmDCP5_GRPH_SURFACE_OFFSET_Y                                                                   0x0f64
#define mmDCP5_GRPH_SURFACE_OFFSET_Y_BASE_IDX                                                          2
#define mmDCP5_GRPH_X_START                                                                            0x0f65
#define mmDCP5_GRPH_X_START_BASE_IDX                                                                   2
#define mmDCP5_GRPH_Y_START                                                                            0x0f66
#define mmDCP5_GRPH_Y_START_BASE_IDX                                                                   2
#define mmDCP5_GRPH_X_END                                                                              0x0f67
#define mmDCP5_GRPH_X_END_BASE_IDX                                                                     2
#define mmDCP5_GRPH_Y_END                                                                              0x0f68
#define mmDCP5_GRPH_Y_END_BASE_IDX                                                                     2
#define mmDCP5_INPUT_GAMMA_CONTROL                                                                     0x0f69
#define mmDCP5_INPUT_GAMMA_CONTROL_BASE_IDX                                                            2
#define mmDCP5_GRPH_UPDATE                                                                             0x0f6a
#define mmDCP5_GRPH_UPDATE_BASE_IDX                                                                    2
#define mmDCP5_GRPH_FLIP_CONTROL                                                                       0x0f6b
#define mmDCP5_GRPH_FLIP_CONTROL_BASE_IDX                                                              2
#define mmDCP5_GRPH_SURFACE_ADDRESS_INUSE                                                              0x0f6c
#define mmDCP5_GRPH_SURFACE_ADDRESS_INUSE_BASE_IDX                                                     2
#define mmDCP5_GRPH_DFQ_CONTROL                                                                        0x0f6d
#define mmDCP5_GRPH_DFQ_CONTROL_BASE_IDX                                                               2
#define mmDCP5_GRPH_DFQ_STATUS                                                                         0x0f6e
#define mmDCP5_GRPH_DFQ_STATUS_BASE_IDX                                                                2
#define mmDCP5_GRPH_INTERRUPT_STATUS                                                                   0x0f6f
#define mmDCP5_GRPH_INTERRUPT_STATUS_BASE_IDX                                                          2
#define mmDCP5_GRPH_INTERRUPT_CONTROL                                                                  0x0f70
#define mmDCP5_GRPH_INTERRUPT_CONTROL_BASE_IDX                                                         2
#define mmDCP5_GRPH_SURFACE_ADDRESS_HIGH_INUSE                                                         0x0f71
#define mmDCP5_GRPH_SURFACE_ADDRESS_HIGH_INUSE_BASE_IDX                                                2
#define mmDCP5_GRPH_COMPRESS_SURFACE_ADDRESS                                                           0x0f72
#define mmDCP5_GRPH_COMPRESS_SURFACE_ADDRESS_BASE_IDX                                                  2
#define mmDCP5_GRPH_COMPRESS_PITCH                                                                     0x0f73
#define mmDCP5_GRPH_COMPRESS_PITCH_BASE_IDX                                                            2
#define mmDCP5_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH                                                      0x0f74
#define mmDCP5_GRPH_COMPRESS_SURFACE_ADDRESS_HIGH_BASE_IDX                                             2
#define mmDCP5_GRPH_PIPE_OUTSTANDING_REQUEST_LIMIT                                                     0x0f75
#define mmDCP5_GRPH_PIPE_OUTSTANDING_REQUEST_LIMIT_BASE_IDX                                            2
#define mmDCP5_PRESCALE_GRPH_CONTROL                                                                   0x0f76
#define mmDCP5_PRESCALE_GRPH_CONTROL_BASE_IDX                                                          2
#define mmDCP5_PRESCALE_VALUES_GRPH_R                                                                  0x0f77
#define mmDCP5_PRESCALE_VALUES_GRPH_R_BASE_IDX                                                         2
#define mmDCP5_PRESCALE_VALUES_GRPH_G                                                                  0x0f78
#define mmDCP5_PRESCALE_VALUES_GRPH_G_BASE_IDX                                                         2
#define mmDCP5_PRESCALE_VALUES_GRPH_B                                                                  0x0f79
#define mmDCP5_PRESCALE_VALUES_GRPH_B_BASE_IDX                                                         2
#define mmDCP5_INPUT_CSC_CONTROL                                                                       0x0f7a
#define mmDCP5_INPUT_CSC_CONTROL_BASE_IDX                                                              2
#define mmDCP5_INPUT_CSC_C11_C12                                                                       0x0f7b
#define mmDCP5_INPUT_CSC_C11_C12_BASE_IDX                                                              2
#define mmDCP5_INPUT_CSC_C13_C14                                                                       0x0f7c
#define mmDCP5_INPUT_CSC_C13_C14_BASE_IDX                                                              2
#define mmDCP5_INPUT_CSC_C21_C22                                                                       0x0f7d
#define mmDCP5_INPUT_CSC_C21_C22_BASE_IDX                                                              2
#define mmDCP5_INPUT_CSC_C23_C24                                                                       0x0f7e
#define mmDCP5_INPUT_CSC_C23_C24_BASE_IDX                                                              2
#define mmDCP5_INPUT_CSC_C31_C32                                                                       0x0f7f
#define mmDCP5_INPUT_CSC_C31_C32_BASE_IDX                                                              2
#define mmDCP5_INPUT_CSC_C33_C34                                                                       0x0f80
#define mmDCP5_INPUT_CSC_C33_C34_BASE_IDX                                                              2
#define mmDCP5_OUTPUT_CSC_CONTROL                                                                      0x0f81
#define mmDCP5_OUTPUT_CSC_CONTROL_BASE_IDX                                                             2
#define mmDCP5_OUTPUT_CSC_C11_C12                                                                      0x0f82
#define mmDCP5_OUTPUT_CSC_C11_C12_BASE_IDX                                                             2
#define mmDCP5_OUTPUT_CSC_C13_C14                                                                      0x0f83
#define mmDCP5_OUTPUT_CSC_C13_C14_BASE_IDX                                                             2
#define mmDCP5_OUTPUT_CSC_C21_C22                                                                      0x0f84
#define mmDCP5_OUTPUT_CSC_C21_C22_BASE_IDX                                                             2
#define mmDCP5_OUTPUT_CSC_C23_C24                                                                      0x0f85
#define mmDCP5_OUTPUT_CSC_C23_C24_BASE_IDX                                                             2
#define mmDCP5_OUTPUT_CSC_C31_C32                                                                      0x0f86
#define mmDCP5_OUTPUT_CSC_C31_C32_BASE_IDX                                                             2
#define mmDCP5_OUTPUT_CSC_C33_C34                                                                      0x0f87
#define mmDCP5_OUTPUT_CSC_C33_C34_BASE_IDX                                                             2
#define mmDCP5_COMM_MATRIXA_TRANS_C11_C12                                                              0x0f88
#define mmDCP5_COMM_MATRIXA_TRANS_C11_C12_BASE_IDX                                                     2
#define mmDCP5_COMM_MATRIXA_TRANS_C13_C14                                                              0x0f89
#define mmDCP5_COMM_MATRIXA_TRANS_C13_C14_BASE_IDX                                                     2
#define mmDCP5_COMM_MATRIXA_TRANS_C21_C22                                                              0x0f8a
#define mmDCP5_COMM_MATRIXA_TRANS_C21_C22_BASE_IDX                                                     2
#define mmDCP5_COMM_MATRIXA_TRANS_C23_C24                                                              0x0f8b
#define mmDCP5_COMM_MATRIXA_TRANS_C23_C24_BASE_IDX                                                     2
#define mmDCP5_COMM_MATRIXA_TRANS_C31_C32                                                              0x0f8c
#define mmDCP5_COMM_MATRIXA_TRANS_C31_C32_BASE_IDX                                                     2
#define mmDCP5_COMM_MATRIXA_TRANS_C33_C34                                                              0x0f8d
#define mmDCP5_COMM_MATRIXA_TRANS_C33_C34_BASE_IDX                                                     2
#define mmDCP5_COMM_MATRIXB_TRANS_C11_C12                                                              0x0f8e
#define mmDCP5_COMM_MATRIXB_TRANS_C11_C12_BASE_IDX                                                     2
#define mmDCP5_COMM_MATRIXB_TRANS_C13_C14                                                              0x0f8f
#define mmDCP5_COMM_MATRIXB_TRANS_C13_C14_BASE_IDX                                                     2
#define mmDCP5_COMM_MATRIXB_TRANS_C21_C22                                                              0x0f90
#define mmDCP5_COMM_MATRIXB_TRANS_C21_C22_BASE_IDX                                                     2
#define mmDCP5_COMM_MATRIXB_TRANS_C23_C24                                                              0x0f91
#define mmDCP5_COMM_MATRIXB_TRANS_C23_C24_BASE_IDX                                                     2
#define mmDCP5_COMM_MATRIXB_TRANS_C31_C32                                                              0x0f92
#define mmDCP5_COMM_MATRIXB_TRANS_C31_C32_BASE_IDX                                                     2
#define mmDCP5_COMM_MATRIXB_TRANS_C33_C34                                                              0x0f93
#define mmDCP5_COMM_MATRIXB_TRANS_C33_C34_BASE_IDX                                                     2
#define mmDCP5_DENORM_CONTROL                                                                          0x0f94
#define mmDCP5_DENORM_CONTROL_BASE_IDX                                                                 2
#define mmDCP5_OUT_ROUND_CONTROL                                                                       0x0f95
#define mmDCP5_OUT_ROUND_CONTROL_BASE_IDX                                                              2
#define mmDCP5_OUT_CLAMP_CONTROL_R_CR                                                                  0x0f96
#define mmDCP5_OUT_CLAMP_CONTROL_R_CR_BASE_IDX                                                         2
#define mmDCP5_OUT_CLAMP_CONTROL_G_Y                                                                   0x0f97
#define mmDCP5_OUT_CLAMP_CONTROL_G_Y_BASE_IDX                                                          2
#define mmDCP5_OUT_CLAMP_CONTROL_B_CB                                                                  0x0f98
#define mmDCP5_OUT_CLAMP_CONTROL_B_CB_BASE_IDX                                                         2
#define mmDCP5_KEY_CONTROL                                                                             0x0f99
#define mmDCP5_KEY_CONTROL_BASE_IDX                                                                    2
#define mmDCP5_KEY_RANGE_ALPHA                                                                         0x0f9a
#define mmDCP5_KEY_RANGE_ALPHA_BASE_IDX                                                                2
#define mmDCP5_KEY_RANGE_RED                                                                           0x0f9b
#define mmDCP5_KEY_RANGE_RED_BASE_IDX                                                                  2
#define mmDCP5_KEY_RANGE_GREEN                                                                         0x0f9c
#define mmDCP5_KEY_RANGE_GREEN_BASE_IDX                                                                2
#define mmDCP5_KEY_RANGE_BLUE                                                                          0x0f9d
#define mmDCP5_KEY_RANGE_BLUE_BASE_IDX                                                                 2
#define mmDCP5_DEGAMMA_CONTROL                                                                         0x0f9e
#define mmDCP5_DEGAMMA_CONTROL_BASE_IDX                                                                2
#define mmDCP5_GAMUT_REMAP_CONTROL                                                                     0x0f9f
#define mmDCP5_GAMUT_REMAP_CONTROL_BASE_IDX                                                            2
#define mmDCP5_GAMUT_REMAP_C11_C12                                                                     0x0fa0
#define mmDCP5_GAMUT_REMAP_C11_C12_BASE_IDX                                                            2
#define mmDCP5_GAMUT_REMAP_C13_C14                                                                     0x0fa1
#define mmDCP5_GAMUT_REMAP_C13_C14_BASE_IDX                                                            2
#define mmDCP5_GAMUT_REMAP_C21_C22                                                                     0x0fa2
#define mmDCP5_GAMUT_REMAP_C21_C22_BASE_IDX                                                            2
#define mmDCP5_GAMUT_REMAP_C23_C24                                                                     0x0fa3
#define mmDCP5_GAMUT_REMAP_C23_C24_BASE_IDX                                                            2
#define mmDCP5_GAMUT_REMAP_C31_C32                                                                     0x0fa4
#define mmDCP5_GAMUT_REMAP_C31_C32_BASE_IDX                                                            2
#define mmDCP5_GAMUT_REMAP_C33_C34                                                                     0x0fa5
#define mmDCP5_GAMUT_REMAP_C33_C34_BASE_IDX                                                            2
#define mmDCP5_DCP_SPATIAL_DITHER_CNTL                                                                 0x0fa6
#define mmDCP5_DCP_SPATIAL_DITHER_CNTL_BASE_IDX                                                        2
#define mmDCP5_DCP_RANDOM_SEEDS                                                                        0x0fa7
#define mmDCP5_DCP_RANDOM_SEEDS_BASE_IDX                                                               2
#define mmDCP5_DCP_FP_CONVERTED_FIELD                                                                  0x0fa8
#define mmDCP5_DCP_FP_CONVERTED_FIELD_BASE_IDX                                                         2
#define mmDCP5_CUR_CONTROL                                                                             0x0fa9
#define mmDCP5_CUR_CONTROL_BASE_IDX                                                                    2
#define mmDCP5_CUR_SURFACE_ADDRESS                                                                     0x0faa
#define mmDCP5_CUR_SURFACE_ADDRESS_BASE_IDX                                                            2
#define mmDCP5_CUR_SIZE                                                                                0x0fab
#define mmDCP5_CUR_SIZE_BASE_IDX                                                                       2
#define mmDCP5_CUR_SURFACE_ADDRESS_HIGH                                                                0x0fac
#define mmDCP5_CUR_SURFACE_ADDRESS_HIGH_BASE_IDX                                                       2
#define mmDCP5_CUR_POSITION                                                                            0x0fad
#define mmDCP5_CUR_POSITION_BASE_IDX                                                                   2
#define mmDCP5_CUR_HOT_SPOT                                                                            0x0fae
#define mmDCP5_CUR_HOT_SPOT_BASE_IDX                                                                   2
#define mmDCP5_CUR_COLOR1                                                                              0x0faf
#define mmDCP5_CUR_COLOR1_BASE_IDX                                                                     2
#define mmDCP5_CUR_COLOR2                                                                              0x0fb0
#define mmDCP5_CUR_COLOR2_BASE_IDX                                                                     2
#define mmDCP5_CUR_UPDATE                                                                              0x0fb1
#define mmDCP5_CUR_UPDATE_BASE_IDX                                                                     2
#define mmDCP5_CUR_REQUEST_FILTER_CNTL                                                                 0x0fbb
#define mmDCP5_CUR_REQUEST_FILTER_CNTL_BASE_IDX                                                        2
#define mmDCP5_CUR_STEREO_CONTROL                                                                      0x0fbc
#define mmDCP5_CUR_STEREO_CONTROL_BASE_IDX                                                             2
#define mmDCP5_DC_LUT_RW_MODE                                                                          0x0fbe
#define mmDCP5_DC_LUT_RW_MODE_BASE_IDX                                                                 2
#define mmDCP5_DC_LUT_RW_INDEX                                                                         0x0fbf
#define mmDCP5_DC_LUT_RW_INDEX_BASE_IDX                                                                2
#define mmDCP5_DC_LUT_SEQ_COLOR                                                                        0x0fc0
#define mmDCP5_DC_LUT_SEQ_COLOR_BASE_IDX                                                               2
#define mmDCP5_DC_LUT_PWL_DATA                                                                         0x0fc1
#define mmDCP5_DC_LUT_PWL_DATA_BASE_IDX                                                                2
#define mmDCP5_DC_LUT_30_COLOR                                                                         0x0fc2
#define mmDCP5_DC_LUT_30_COLOR_BASE_IDX                                                                2
#define mmDCP5_DC_LUT_VGA_ACCESS_ENABLE                                                                0x0fc3
#define mmDCP5_DC_LUT_VGA_ACCESS_ENABLE_BASE_IDX                                                       2
#define mmDCP5_DC_LUT_WRITE_EN_MASK                                                                    0x0fc4
#define mmDCP5_DC_LUT_WRITE_EN_MASK_BASE_IDX                                                           2
#define mmDCP5_DC_LUT_AUTOFILL                                                                         0x0fc5
#define mmDCP5_DC_LUT_AUTOFILL_BASE_IDX                                                                2
#define mmDCP5_DC_LUT_CONTROL                                                                          0x0fc6
#define mmDCP5_DC_LUT_CONTROL_BASE_IDX                                                                 2
#define mmDCP5_DC_LUT_BLACK_OFFSET_BLUE                                                                0x0fc7
#define mmDCP5_DC_LUT_BLACK_OFFSET_BLUE_BASE_IDX                                                       2
#define mmDCP5_DC_LUT_BLACK_OFFSET_GREEN                                                               0x0fc8
#define mmDCP5_DC_LUT_BLACK_OFFSET_GREEN_BASE_IDX                                                      2
#define mmDCP5_DC_LUT_BLACK_OFFSET_RED                                                                 0x0fc9
#define mmDCP5_DC_LUT_BLACK_OFFSET_RED_BASE_IDX                                                        2
#define mmDCP5_DC_LUT_WHITE_OFFSET_BLUE                                                                0x0fca
#define mmDCP5_DC_LUT_WHITE_OFFSET_BLUE_BASE_IDX                                                       2
#define mmDCP5_DC_LUT_WHITE_OFFSET_GREEN                                                               0x0fcb
#define mmDCP5_DC_LUT_WHITE_OFFSET_GREEN_BASE_IDX                                                      2
#define mmDCP5_DC_LUT_WHITE_OFFSET_RED                                                                 0x0fcc
#define mmDCP5_DC_LUT_WHITE_OFFSET_RED_BASE_IDX                                                        2
#define mmDCP5_DCP_CRC_CONTROL                                                                         0x0fcd
#define mmDCP5_DCP_CRC_CONTROL_BASE_IDX                                                                2
#define mmDCP5_DCP_CRC_MASK                                                                            0x0fce
#define mmDCP5_DCP_CRC_MASK_BASE_IDX                                                                   2
#define mmDCP5_DCP_CRC_CURRENT                                                                         0x0fcf
#define mmDCP5_DCP_CRC_CURRENT_BASE_IDX                                                                2
#define mmDCP5_DVMM_PTE_CONTROL                                                                        0x0fd0
#define mmDCP5_DVMM_PTE_CONTROL_BASE_IDX                                                               2
#define mmDCP5_DCP_CRC_LAST                                                                            0x0fd1
#define mmDCP5_DCP_CRC_LAST_BASE_IDX                                                                   2
#define mmDCP5_DVMM_PTE_ARB_CONTROL                                                                    0x0fd2
#define mmDCP5_DVMM_PTE_ARB_CONTROL_BASE_IDX                                                           2
#define mmDCP5_GRPH_FLIP_RATE_CNTL                                                                     0x0fd4
#define mmDCP5_GRPH_FLIP_RATE_CNTL_BASE_IDX                                                            2
#define mmDCP5_DCP_GSL_CONTROL                                                                         0x0fd5
#define mmDCP5_DCP_GSL_CONTROL_BASE_IDX                                                                2
#define mmDCP5_DCP_LB_DATA_GAP_BETWEEN_CHUNK                                                           0x0fd6
#define mmDCP5_DCP_LB_DATA_GAP_BETWEEN_CHUNK_BASE_IDX                                                  2
#define mmDCP5_GRPH_STEREOSYNC_FLIP                                                                    0x0fdc
#define mmDCP5_GRPH_STEREOSYNC_FLIP_BASE_IDX                                                           2
#define mmDCP5_HW_ROTATION                                                                             0x0fde
#define mmDCP5_HW_ROTATION_BASE_IDX                                                                    2
#define mmDCP5_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL                                                      0x0fdf
#define mmDCP5_GRPH_XDMA_CACHE_UNDERFLOW_DET_CNTL_BASE_IDX                                             2
#define mmDCP5_REGAMMA_CONTROL                                                                         0x0fe0
#define mmDCP5_REGAMMA_CONTROL_BASE_IDX                                                                2
#define mmDCP5_REGAMMA_LUT_INDEX                                                                       0x0fe1
#define mmDCP5_REGAMMA_LUT_INDEX_BASE_IDX                                                              2
#define mmDCP5_REGAMMA_LUT_DATA                                                                        0x0fe2
#define mmDCP5_REGAMMA_LUT_DATA_BASE_IDX                                                               2
#define mmDCP5_REGAMMA_LUT_WRITE_EN_MASK                                                               0x0fe3
#define mmDCP5_REGAMMA_LUT_WRITE_EN_MASK_BASE_IDX                                                      2
#define mmDCP5_REGAMMA_CNTLA_START_CNTL                                                                0x0fe4
#define mmDCP5_REGAMMA_CNTLA_START_CNTL_BASE_IDX                                                       2
#define mmDCP5_REGAMMA_CNTLA_SLOPE_CNTL                                                                0x0fe5
#define mmDCP5_REGAMMA_CNTLA_SLOPE_CNTL_BASE_IDX                                                       2
#define mmDCP5_REGAMMA_CNTLA_END_CNTL1                                                                 0x0fe6
#define mmDCP5_REGAMMA_CNTLA_END_CNTL1_BASE_IDX                                                        2
#define mmDCP5_REGAMMA_CNTLA_END_CNTL2                                                                 0x0fe7
#define mmDCP5_REGAMMA_CNTLA_END_CNTL2_BASE_IDX                                                        2
#define mmDCP5_REGAMMA_CNTLA_REGION_0_1                                                                0x0fe8
#define mmDCP5_REGAMMA_CNTLA_REGION_0_1_BASE_IDX                                                       2
#define mmDCP5_REGAMMA_CNTLA_REGION_2_3                                                                0x0fe9
#define mmDCP5_REGAMMA_CNTLA_REGION_2_3_BASE_IDX                                                       2
#define mmDCP5_REGAMMA_CNTLA_REGION_4_5                                                                0x0fea
#define mmDCP5_REGAMMA_CNTLA_REGION_4_5_BASE_IDX                                                       2
#define mmDCP5_REGAMMA_CNTLA_REGION_6_7                                                                0x0feb
#define mmDCP5_REGAMMA_CNTLA_REGION_6_7_BASE_IDX                                                       2
#define mmDCP5_REGAMMA_CNTLA_REGION_8_9                                                                0x0fec
#define mmDCP5_REGAMMA_CNTLA_REGION_8_9_BASE_IDX                                                       2
#define mmDCP5_REGAMMA_CNTLA_REGION_10_11                                                              0x0fed
#define mmDCP5_REGAMMA_CNTLA_REGION_10_11_BASE_IDX                                                     2
#define mmDCP5_REGAMMA_CNTLA_REGION_12_13                                                              0x0fee
#define mmDCP5_REGAMMA_CNTLA_REGION_12_13_BASE_IDX                                                     2
#define mmDCP5_REGAMMA_CNTLA_REGION_14_15                                                              0x0fef
#define mmDCP5_REGAMMA_CNTLA_REGION_14_15_BASE_IDX                                                     2
#define mmDCP5_REGAMMA_CNTLB_START_CNTL                                                                0x0ff0
#define mmDCP5_REGAMMA_CNTLB_START_CNTL_BASE_IDX                                                       2
#define mmDCP5_REGAMMA_CNTLB_SLOPE_CNTL                                                                0x0ff1
#define mmDCP5_REGAMMA_CNTLB_SLOPE_CNTL_BASE_IDX                                                       2
#define mmDCP5_REGAMMA_CNTLB_END_CNTL1                                                                 0x0ff2
#define mmDCP5_REGAMMA_CNTLB_END_CNTL1_BASE_IDX                                                        2
#define mmDCP5_REGAMMA_CNTLB_END_CNTL2                                                                 0x0ff3
#define mmDCP5_REGAMMA_CNTLB_END_CNTL2_BASE_IDX                                                        2
#define mmDCP5_REGAMMA_CNTLB_REGION_0_1                                                                0x0ff4
#define mmDCP5_REGAMMA_CNTLB_REGION_0_1_BASE_IDX                                                       2
#define mmDCP5_REGAMMA_CNTLB_REGION_2_3                                                                0x0ff5
#define mmDCP5_REGAMMA_CNTLB_REGION_2_3_BASE_IDX                                                       2
#define mmDCP5_REGAMMA_CNTLB_REGION_4_5                                                                0x0ff6
#define mmDCP5_REGAMMA_CNTLB_REGION_4_5_BASE_IDX                                                       2
#define mmDCP5_REGAMMA_CNTLB_REGION_6_7                                                                0x0ff7
#define mmDCP5_REGAMMA_CNTLB_REGION_6_7_BASE_IDX                                                       2
#define mmDCP5_REGAMMA_CNTLB_REGION_8_9                                                                0x0ff8
#define mmDCP5_REGAMMA_CNTLB_REGION_8_9_BASE_IDX                                                       2
#define mmDCP5_REGAMMA_CNTLB_REGION_10_11                                                              0x0ff9
#define mmDCP5_REGAMMA_CNTLB_REGION_10_11_BASE_IDX                                                     2
#define mmDCP5_REGAMMA_CNTLB_REGION_12_13                                                              0x0ffa
#define mmDCP5_REGAMMA_CNTLB_REGION_12_13_BASE_IDX                                                     2
#define mmDCP5_REGAMMA_CNTLB_REGION_14_15                                                              0x0ffb
#define mmDCP5_REGAMMA_CNTLB_REGION_14_15_BASE_IDX                                                     2
#define mmDCP5_ALPHA_CONTROL                                                                           0x0ffc
#define mmDCP5_ALPHA_CONTROL_BASE_IDX                                                                  2
#define mmDCP5_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS                                                      0x0ffd
#define mmDCP5_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_BASE_IDX                                             2
#define mmDCP5_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH                                                 0x0ffe
#define mmDCP5_GRPH_XDMA_RECOVERY_SURFACE_ADDRESS_HIGH_BASE_IDX                                        2
#define mmDCP5_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS                                                    0x0fff
#define mmDCP5_GRPH_XDMA_CACHE_UNDERFLOW_DET_STATUS_BASE_IDX                                           2
#define mmDCP5_GRPH_XDMA_FLIP_TIMEOUT                                                                  0x1000
#define mmDCP5_GRPH_XDMA_FLIP_TIMEOUT_BASE_IDX                                                         2
#define mmDCP5_GRPH_XDMA_FLIP_AVG_DELAY                                                                0x1001
#define mmDCP5_GRPH_XDMA_FLIP_AVG_DELAY_BASE_IDX                                                       2
#define mmDCP5_GRPH_SURFACE_COUNTER_CONTROL                                                            0x1002
#define mmDCP5_GRPH_SURFACE_COUNTER_CONTROL_BASE_IDX                                                   2
#define mmDCP5_GRPH_SURFACE_COUNTER_OUTPUT                                                             0x1003
#define mmDCP5_GRPH_SURFACE_COUNTER_OUTPUT_BASE_IDX                                                    2


// addressBlock: dce_dc_lb5_dispdec
// base address: 0x2800
#define mmLB5_LB_DATA_FORMAT                                                                           0x101a
#define mmLB5_LB_DATA_FORMAT_BASE_IDX                                                                  2
#define mmLB5_LB_MEMORY_CTRL                                                                           0x101b
#define mmLB5_LB_MEMORY_CTRL_BASE_IDX                                                                  2
#define mmLB5_LB_MEMORY_SIZE_STATUS                                                                    0x101c
#define mmLB5_LB_MEMORY_SIZE_STATUS_BASE_IDX                                                           2
#define mmLB5_LB_DESKTOP_HEIGHT                                                                        0x101d
#define mmLB5_LB_DESKTOP_HEIGHT_BASE_IDX                                                               2
#define mmLB5_LB_VLINE_START_END                                                                       0x101e
#define mmLB5_LB_VLINE_START_END_BASE_IDX                                                              2
#define mmLB5_LB_VLINE2_START_END                                                                      0x101f
#define mmLB5_LB_VLINE2_START_END_BASE_IDX                                                             2
#define mmLB5_LB_V_COUNTER                                                                             0x1020
#define mmLB5_LB_V_COUNTER_BASE_IDX                                                                    2
#define mmLB5_LB_SNAPSHOT_V_COUNTER                                                                    0x1021
#define mmLB5_LB_SNAPSHOT_V_COUNTER_BASE_IDX                                                           2
#define mmLB5_LB_INTERRUPT_MASK                                                                        0x1022
#define mmLB5_LB_INTERRUPT_MASK_BASE_IDX                                                               2
#define mmLB5_LB_VLINE_STATUS                                                                          0x1023
#define mmLB5_LB_VLINE_STATUS_BASE_IDX                                                                 2
#define mmLB5_LB_VLINE2_STATUS                                                                         0x1024
#define mmLB5_LB_VLINE2_STATUS_BASE_IDX                                                                2
#define mmLB5_LB_VBLANK_STATUS                                                                         0x1025
#define mmLB5_LB_VBLANK_STATUS_BASE_IDX                                                                2
#define mmLB5_LB_SYNC_RESET_SEL                                                                        0x1026
#define mmLB5_LB_SYNC_RESET_SEL_BASE_IDX                                                               2
#define mmLB5_LB_BLACK_KEYER_R_CR                                                                      0x1027
#define mmLB5_LB_BLACK_KEYER_R_CR_BASE_IDX                                                             2
#define mmLB5_LB_BLACK_KEYER_G_Y                                                                       0x1028
#define mmLB5_LB_BLACK_KEYER_G_Y_BASE_IDX                                                              2
#define mmLB5_LB_BLACK_KEYER_B_CB                                                                      0x1029
#define mmLB5_LB_BLACK_KEYER_B_CB_BASE_IDX                                                             2
#define mmLB5_LB_KEYER_COLOR_CTRL                                                                      0x102a
#define mmLB5_LB_KEYER_COLOR_CTRL_BASE_IDX                                                             2
#define mmLB5_LB_KEYER_COLOR_R_CR                                                                      0x102b
#define mmLB5_LB_KEYER_COLOR_R_CR_BASE_IDX                                                             2
#define mmLB5_LB_KEYER_COLOR_G_Y                                                                       0x102c
#define mmLB5_LB_KEYER_COLOR_G_Y_BASE_IDX                                                              2
#define mmLB5_LB_KEYER_COLOR_B_CB                                                                      0x102d
#define mmLB5_LB_KEYER_COLOR_B_CB_BASE_IDX                                                             2
#define mmLB5_LB_KEYER_COLOR_REP_R_CR                                                                  0x102e
#define mmLB5_LB_KEYER_COLOR_REP_R_CR_BASE_IDX                                                         2
#define mmLB5_LB_KEYER_COLOR_REP_G_Y                                                                   0x102f
#define mmLB5_LB_KEYER_COLOR_REP_G_Y_BASE_IDX                                                          2
#define mmLB5_LB_KEYER_COLOR_REP_B_CB                                                                  0x1030
#define mmLB5_LB_KEYER_COLOR_REP_B_CB_BASE_IDX                                                         2
#define mmLB5_LB_BUFFER_LEVEL_STATUS                                                                   0x1031
#define mmLB5_LB_BUFFER_LEVEL_STATUS_BASE_IDX                                                          2
#define mmLB5_LB_BUFFER_URGENCY_CTRL                                                                   0x1032
#define mmLB5_LB_BUFFER_URGENCY_CTRL_BASE_IDX                                                          2
#define mmLB5_LB_BUFFER_URGENCY_STATUS                                                                 0x1033
#define mmLB5_LB_BUFFER_URGENCY_STATUS_BASE_IDX                                                        2
#define mmLB5_LB_BUFFER_STATUS                                                                         0x1034
#define mmLB5_LB_BUFFER_STATUS_BASE_IDX                                                                2
#define mmLB5_LB_NO_OUTSTANDING_REQ_STATUS                                                             0x1035
#define mmLB5_LB_NO_OUTSTANDING_REQ_STATUS_BASE_IDX                                                    2
#define mmLB5_MVP_AFR_FLIP_MODE                                                                        0x1036
#define mmLB5_MVP_AFR_FLIP_MODE_BASE_IDX                                                               2
#define mmLB5_MVP_AFR_FLIP_FIFO_CNTL                                                                   0x1037
#define mmLB5_MVP_AFR_FLIP_FIFO_CNTL_BASE_IDX                                                          2
#define mmLB5_MVP_FLIP_LINE_NUM_INSERT                                                                 0x1038
#define mmLB5_MVP_FLIP_LINE_NUM_INSERT_BASE_IDX                                                        2
#define mmLB5_DC_MVP_LB_CONTROL                                                                        0x1039
#define mmLB5_DC_MVP_LB_CONTROL_BASE_IDX                                                               2


// addressBlock: dce_dc_dcfe5_dispdec
// base address: 0x2800
#define mmDCFE5_DCFE_CLOCK_CONTROL                                                                     0x105a
#define mmDCFE5_DCFE_CLOCK_CONTROL_BASE_IDX                                                            2
#define mmDCFE5_DCFE_SOFT_RESET                                                                        0x105b
#define mmDCFE5_DCFE_SOFT_RESET_BASE_IDX                                                               2
#define mmDCFE5_DCFE_MEM_PWR_CTRL                                                                      0x105d
#define mmDCFE5_DCFE_MEM_PWR_CTRL_BASE_IDX                                                             2
#define mmDCFE5_DCFE_MEM_PWR_CTRL2                                                                     0x105e
#define mmDCFE5_DCFE_MEM_PWR_CTRL2_BASE_IDX                                                            2
#define mmDCFE5_DCFE_MEM_PWR_STATUS                                                                    0x105f
#define mmDCFE5_DCFE_MEM_PWR_STATUS_BASE_IDX                                                           2
#define mmDCFE5_DCFE_MISC                                                                              0x1060
#define mmDCFE5_DCFE_MISC_BASE_IDX                                                                     2
#define mmDCFE5_DCFE_FLUSH                                                                             0x1061
#define mmDCFE5_DCFE_FLUSH_BASE_IDX                                                                    2


// addressBlock: dce_dc_dc_perfmon8_dispdec
// base address: 0x4138
#define mmDC_PERFMON8_PERFCOUNTER_CNTL                                                                 0x106e
#define mmDC_PERFMON8_PERFCOUNTER_CNTL_BASE_IDX                                                        2
#define mmDC_PERFMON8_PERFCOUNTER_CNTL2                                                                0x106f
#define mmDC_PERFMON8_PERFCOUNTER_CNTL2_BASE_IDX                                                       2
#define mmDC_PERFMON8_PERFCOUNTER_STATE                                                                0x1070
#define mmDC_PERFMON8_PERFCOUNTER_STATE_BASE_IDX                                                       2
#define mmDC_PERFMON8_PERFMON_CNTL                                                                     0x1071
#define mmDC_PERFMON8_PERFMON_CNTL_BASE_IDX                                                            2
#define mmDC_PERFMON8_PERFMON_CNTL2                                                                    0x1072
#define mmDC_PERFMON8_PERFMON_CNTL2_BASE_IDX                                                           2
#define mmDC_PERFMON8_PERFMON_CVALUE_INT_MISC                                                          0x1073
#define mmDC_PERFMON8_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                 2
#define mmDC_PERFMON8_PERFMON_CVALUE_LOW                                                               0x1074
#define mmDC_PERFMON8_PERFMON_CVALUE_LOW_BASE_IDX                                                      2
#define mmDC_PERFMON8_PERFMON_HI                                                                       0x1075
#define mmDC_PERFMON8_PERFMON_HI_BASE_IDX                                                              2
#define mmDC_PERFMON8_PERFMON_LOW                                                                      0x1076
#define mmDC_PERFMON8_PERFMON_LOW_BASE_IDX                                                             2


// addressBlock: dce_dc_dmif_pg5_dispdec
// base address: 0x2800
#define mmDMIF_PG5_DPG_PIPE_ARBITRATION_CONTROL1                                                       0x107a
#define mmDMIF_PG5_DPG_PIPE_ARBITRATION_CONTROL1_BASE_IDX                                              2
#define mmDMIF_PG5_DPG_PIPE_ARBITRATION_CONTROL2                                                       0x107b
#define mmDMIF_PG5_DPG_PIPE_ARBITRATION_CONTROL2_BASE_IDX                                              2
#define mmDMIF_PG5_DPG_WATERMARK_MASK_CONTROL                                                          0x107c
#define mmDMIF_PG5_DPG_WATERMARK_MASK_CONTROL_BASE_IDX                                                 2
#define mmDMIF_PG5_DPG_PIPE_URGENCY_CONTROL                                                            0x107d
#define mmDMIF_PG5_DPG_PIPE_URGENCY_CONTROL_BASE_IDX                                                   2
#define mmDMIF_PG5_DPG_PIPE_URGENT_LEVEL_CONTROL                                                       0x107e
#define mmDMIF_PG5_DPG_PIPE_URGENT_LEVEL_CONTROL_BASE_IDX                                              2
#define mmDMIF_PG5_DPG_PIPE_STUTTER_CONTROL                                                            0x107f
#define mmDMIF_PG5_DPG_PIPE_STUTTER_CONTROL_BASE_IDX                                                   2
#define mmDMIF_PG5_DPG_PIPE_STUTTER_CONTROL2                                                           0x1080
#define mmDMIF_PG5_DPG_PIPE_STUTTER_CONTROL2_BASE_IDX                                                  2
#define mmDMIF_PG5_DPG_PIPE_LOW_POWER_CONTROL                                                          0x1081
#define mmDMIF_PG5_DPG_PIPE_LOW_POWER_CONTROL_BASE_IDX                                                 2
#define mmDMIF_PG5_DPG_REPEATER_PROGRAM                                                                0x1082
#define mmDMIF_PG5_DPG_REPEATER_PROGRAM_BASE_IDX                                                       2
#define mmDMIF_PG5_DPG_CHK_PRE_PROC_CNTL                                                               0x1086
#define mmDMIF_PG5_DPG_CHK_PRE_PROC_CNTL_BASE_IDX                                                      2
#define mmDMIF_PG5_DPG_DVMM_STATUS                                                                     0x1087
#define mmDMIF_PG5_DPG_DVMM_STATUS_BASE_IDX                                                            2


// addressBlock: dce_dc_scl5_dispdec
// base address: 0x2800
#define mmSCL5_SCL_COEF_RAM_SELECT                                                                     0x109a
#define mmSCL5_SCL_COEF_RAM_SELECT_BASE_IDX                                                            2
#define mmSCL5_SCL_COEF_RAM_TAP_DATA                                                                   0x109b
#define mmSCL5_SCL_COEF_RAM_TAP_DATA_BASE_IDX                                                          2
#define mmSCL5_SCL_MODE                                                                                0x109c
#define mmSCL5_SCL_MODE_BASE_IDX                                                                       2
#define mmSCL5_SCL_TAP_CONTROL                                                                         0x109d
#define mmSCL5_SCL_TAP_CONTROL_BASE_IDX                                                                2
#define mmSCL5_SCL_CONTROL                                                                             0x109e
#define mmSCL5_SCL_CONTROL_BASE_IDX                                                                    2
#define mmSCL5_SCL_BYPASS_CONTROL                                                                      0x109f
#define mmSCL5_SCL_BYPASS_CONTROL_BASE_IDX                                                             2
#define mmSCL5_SCL_MANUAL_REPLICATE_CONTROL                                                            0x10a0
#define mmSCL5_SCL_MANUAL_REPLICATE_CONTROL_BASE_IDX                                                   2
#define mmSCL5_SCL_AUTOMATIC_MODE_CONTROL                                                              0x10a1
#define mmSCL5_SCL_AUTOMATIC_MODE_CONTROL_BASE_IDX                                                     2
#define mmSCL5_SCL_HORZ_FILTER_CONTROL                                                                 0x10a2
#define mmSCL5_SCL_HORZ_FILTER_CONTROL_BASE_IDX                                                        2
#define mmSCL5_SCL_HORZ_FILTER_SCALE_RATIO                                                             0x10a3
#define mmSCL5_SCL_HORZ_FILTER_SCALE_RATIO_BASE_IDX                                                    2
#define mmSCL5_SCL_HORZ_FILTER_INIT                                                                    0x10a4
#define mmSCL5_SCL_HORZ_FILTER_INIT_BASE_IDX                                                           2
#define mmSCL5_SCL_VERT_FILTER_CONTROL                                                                 0x10a5
#define mmSCL5_SCL_VERT_FILTER_CONTROL_BASE_IDX                                                        2
#define mmSCL5_SCL_VERT_FILTER_SCALE_RATIO                                                             0x10a6
#define mmSCL5_SCL_VERT_FILTER_SCALE_RATIO_BASE_IDX                                                    2
#define mmSCL5_SCL_VERT_FILTER_INIT                                                                    0x10a7
#define mmSCL5_SCL_VERT_FILTER_INIT_BASE_IDX                                                           2
#define mmSCL5_SCL_VERT_FILTER_INIT_BOT                                                                0x10a8
#define mmSCL5_SCL_VERT_FILTER_INIT_BOT_BASE_IDX                                                       2
#define mmSCL5_SCL_ROUND_OFFSET                                                                        0x10a9
#define mmSCL5_SCL_ROUND_OFFSET_BASE_IDX                                                               2
#define mmSCL5_SCL_UPDATE                                                                              0x10aa
#define mmSCL5_SCL_UPDATE_BASE_IDX                                                                     2
#define mmSCL5_SCL_F_SHARP_CONTROL                                                                     0x10ab
#define mmSCL5_SCL_F_SHARP_CONTROL_BASE_IDX                                                            2
#define mmSCL5_SCL_ALU_CONTROL                                                                         0x10ac
#define mmSCL5_SCL_ALU_CONTROL_BASE_IDX                                                                2
#define mmSCL5_SCL_COEF_RAM_CONFLICT_STATUS                                                            0x10ad
#define mmSCL5_SCL_COEF_RAM_CONFLICT_STATUS_BASE_IDX                                                   2
#define mmSCL5_VIEWPORT_START_SECONDARY                                                                0x10ae
#define mmSCL5_VIEWPORT_START_SECONDARY_BASE_IDX                                                       2
#define mmSCL5_VIEWPORT_START                                                                          0x10af
#define mmSCL5_VIEWPORT_START_BASE_IDX                                                                 2
#define mmSCL5_VIEWPORT_SIZE                                                                           0x10b0
#define mmSCL5_VIEWPORT_SIZE_BASE_IDX                                                                  2
#define mmSCL5_EXT_OVERSCAN_LEFT_RIGHT                                                                 0x10b1
#define mmSCL5_EXT_OVERSCAN_LEFT_RIGHT_BASE_IDX                                                        2
#define mmSCL5_EXT_OVERSCAN_TOP_BOTTOM                                                                 0x10b2
#define mmSCL5_EXT_OVERSCAN_TOP_BOTTOM_BASE_IDX                                                        2
#define mmSCL5_SCL_MODE_CHANGE_DET1                                                                    0x10b3
#define mmSCL5_SCL_MODE_CHANGE_DET1_BASE_IDX                                                           2
#define mmSCL5_SCL_MODE_CHANGE_DET2                                                                    0x10b4
#define mmSCL5_SCL_MODE_CHANGE_DET2_BASE_IDX                                                           2
#define mmSCL5_SCL_MODE_CHANGE_DET3                                                                    0x10b5
#define mmSCL5_SCL_MODE_CHANGE_DET3_BASE_IDX                                                           2
#define mmSCL5_SCL_MODE_CHANGE_MASK                                                                    0x10b6
#define mmSCL5_SCL_MODE_CHANGE_MASK_BASE_IDX                                                           2


// addressBlock: dce_dc_blnd5_dispdec
// base address: 0x2800
#define mmBLND5_BLND_CONTROL                                                                           0x10c7
#define mmBLND5_BLND_CONTROL_BASE_IDX                                                                  2
#define mmBLND5_BLND_SM_CONTROL2                                                                       0x10c8
#define mmBLND5_BLND_SM_CONTROL2_BASE_IDX                                                              2
#define mmBLND5_BLND_CONTROL2                                                                          0x10c9
#define mmBLND5_BLND_CONTROL2_BASE_IDX                                                                 2
#define mmBLND5_BLND_UPDATE                                                                            0x10ca
#define mmBLND5_BLND_UPDATE_BASE_IDX                                                                   2
#define mmBLND5_BLND_UNDERFLOW_INTERRUPT                                                               0x10cb
#define mmBLND5_BLND_UNDERFLOW_INTERRUPT_BASE_IDX                                                      2
#define mmBLND5_BLND_V_UPDATE_LOCK                                                                     0x10cc
#define mmBLND5_BLND_V_UPDATE_LOCK_BASE_IDX                                                            2
#define mmBLND5_BLND_REG_UPDATE_STATUS                                                                 0x10cd
#define mmBLND5_BLND_REG_UPDATE_STATUS_BASE_IDX                                                        2


// addressBlock: dce_dc_crtc5_dispdec
// base address: 0x2800
#define mmCRTC5_CRTC_H_BLANK_EARLY_NUM                                                                 0x10d2
#define mmCRTC5_CRTC_H_BLANK_EARLY_NUM_BASE_IDX                                                        2
#define mmCRTC5_CRTC_H_TOTAL                                                                           0x10d3
#define mmCRTC5_CRTC_H_TOTAL_BASE_IDX                                                                  2
#define mmCRTC5_CRTC_H_BLANK_START_END                                                                 0x10d4
#define mmCRTC5_CRTC_H_BLANK_START_END_BASE_IDX                                                        2
#define mmCRTC5_CRTC_H_SYNC_A                                                                          0x10d5
#define mmCRTC5_CRTC_H_SYNC_A_BASE_IDX                                                                 2
#define mmCRTC5_CRTC_H_SYNC_A_CNTL                                                                     0x10d6
#define mmCRTC5_CRTC_H_SYNC_A_CNTL_BASE_IDX                                                            2
#define mmCRTC5_CRTC_H_SYNC_B                                                                          0x10d7
#define mmCRTC5_CRTC_H_SYNC_B_BASE_IDX                                                                 2
#define mmCRTC5_CRTC_H_SYNC_B_CNTL                                                                     0x10d8
#define mmCRTC5_CRTC_H_SYNC_B_CNTL_BASE_IDX                                                            2
#define mmCRTC5_CRTC_VBI_END                                                                           0x10d9
#define mmCRTC5_CRTC_VBI_END_BASE_IDX                                                                  2
#define mmCRTC5_CRTC_V_TOTAL                                                                           0x10da
#define mmCRTC5_CRTC_V_TOTAL_BASE_IDX                                                                  2
#define mmCRTC5_CRTC_V_TOTAL_MIN                                                                       0x10db
#define mmCRTC5_CRTC_V_TOTAL_MIN_BASE_IDX                                                              2
#define mmCRTC5_CRTC_V_TOTAL_MAX                                                                       0x10dc
#define mmCRTC5_CRTC_V_TOTAL_MAX_BASE_IDX                                                              2
#define mmCRTC5_CRTC_V_TOTAL_CONTROL                                                                   0x10dd
#define mmCRTC5_CRTC_V_TOTAL_CONTROL_BASE_IDX                                                          2
#define mmCRTC5_CRTC_V_TOTAL_INT_STATUS                                                                0x10de
#define mmCRTC5_CRTC_V_TOTAL_INT_STATUS_BASE_IDX                                                       2
#define mmCRTC5_CRTC_VSYNC_NOM_INT_STATUS                                                              0x10df
#define mmCRTC5_CRTC_VSYNC_NOM_INT_STATUS_BASE_IDX                                                     2
#define mmCRTC5_CRTC_V_BLANK_START_END                                                                 0x10e0
#define mmCRTC5_CRTC_V_BLANK_START_END_BASE_IDX                                                        2
#define mmCRTC5_CRTC_V_SYNC_A                                                                          0x10e1
#define mmCRTC5_CRTC_V_SYNC_A_BASE_IDX                                                                 2
#define mmCRTC5_CRTC_V_SYNC_A_CNTL                                                                     0x10e2
#define mmCRTC5_CRTC_V_SYNC_A_CNTL_BASE_IDX                                                            2
#define mmCRTC5_CRTC_V_SYNC_B                                                                          0x10e3
#define mmCRTC5_CRTC_V_SYNC_B_BASE_IDX                                                                 2
#define mmCRTC5_CRTC_V_SYNC_B_CNTL                                                                     0x10e4
#define mmCRTC5_CRTC_V_SYNC_B_CNTL_BASE_IDX                                                            2
#define mmCRTC5_CRTC_DTMTEST_CNTL                                                                      0x10e5
#define mmCRTC5_CRTC_DTMTEST_CNTL_BASE_IDX                                                             2
#define mmCRTC5_CRTC_DTMTEST_STATUS_POSITION                                                           0x10e6
#define mmCRTC5_CRTC_DTMTEST_STATUS_POSITION_BASE_IDX                                                  2
#define mmCRTC5_CRTC_TRIGA_CNTL                                                                        0x10e7
#define mmCRTC5_CRTC_TRIGA_CNTL_BASE_IDX                                                               2
#define mmCRTC5_CRTC_TRIGA_MANUAL_TRIG                                                                 0x10e8
#define mmCRTC5_CRTC_TRIGA_MANUAL_TRIG_BASE_IDX                                                        2
#define mmCRTC5_CRTC_TRIGB_CNTL                                                                        0x10e9
#define mmCRTC5_CRTC_TRIGB_CNTL_BASE_IDX                                                               2
#define mmCRTC5_CRTC_TRIGB_MANUAL_TRIG                                                                 0x10ea
#define mmCRTC5_CRTC_TRIGB_MANUAL_TRIG_BASE_IDX                                                        2
#define mmCRTC5_CRTC_FORCE_COUNT_NOW_CNTL                                                              0x10eb
#define mmCRTC5_CRTC_FORCE_COUNT_NOW_CNTL_BASE_IDX                                                     2
#define mmCRTC5_CRTC_FLOW_CONTROL                                                                      0x10ec
#define mmCRTC5_CRTC_FLOW_CONTROL_BASE_IDX                                                             2
#define mmCRTC5_CRTC_STEREO_FORCE_NEXT_EYE                                                             0x10ed
#define mmCRTC5_CRTC_STEREO_FORCE_NEXT_EYE_BASE_IDX                                                    2
#define mmCRTC5_CRTC_AVSYNC_COUNTER                                                                    0x10ee
#define mmCRTC5_CRTC_AVSYNC_COUNTER_BASE_IDX                                                           2
#define mmCRTC5_CRTC_CONTROL                                                                           0x10ef
#define mmCRTC5_CRTC_CONTROL_BASE_IDX                                                                  2
#define mmCRTC5_CRTC_BLANK_CONTROL                                                                     0x10f0
#define mmCRTC5_CRTC_BLANK_CONTROL_BASE_IDX                                                            2
#define mmCRTC5_CRTC_INTERLACE_CONTROL                                                                 0x10f1
#define mmCRTC5_CRTC_INTERLACE_CONTROL_BASE_IDX                                                        2
#define mmCRTC5_CRTC_INTERLACE_STATUS                                                                  0x10f2
#define mmCRTC5_CRTC_INTERLACE_STATUS_BASE_IDX                                                         2
#define mmCRTC5_CRTC_FIELD_INDICATION_CONTROL                                                          0x10f3
#define mmCRTC5_CRTC_FIELD_INDICATION_CONTROL_BASE_IDX                                                 2
#define mmCRTC5_CRTC_PIXEL_DATA_READBACK0                                                              0x10f4
#define mmCRTC5_CRTC_PIXEL_DATA_READBACK0_BASE_IDX                                                     2
#define mmCRTC5_CRTC_PIXEL_DATA_READBACK1                                                              0x10f5
#define mmCRTC5_CRTC_PIXEL_DATA_READBACK1_BASE_IDX                                                     2
#define mmCRTC5_CRTC_STATUS                                                                            0x10f6
#define mmCRTC5_CRTC_STATUS_BASE_IDX                                                                   2
#define mmCRTC5_CRTC_STATUS_POSITION                                                                   0x10f7
#define mmCRTC5_CRTC_STATUS_POSITION_BASE_IDX                                                          2
#define mmCRTC5_CRTC_NOM_VERT_POSITION                                                                 0x10f8
#define mmCRTC5_CRTC_NOM_VERT_POSITION_BASE_IDX                                                        2
#define mmCRTC5_CRTC_STATUS_FRAME_COUNT                                                                0x10f9
#define mmCRTC5_CRTC_STATUS_FRAME_COUNT_BASE_IDX                                                       2
#define mmCRTC5_CRTC_STATUS_VF_COUNT                                                                   0x10fa
#define mmCRTC5_CRTC_STATUS_VF_COUNT_BASE_IDX                                                          2
#define mmCRTC5_CRTC_STATUS_HV_COUNT                                                                   0x10fb
#define mmCRTC5_CRTC_STATUS_HV_COUNT_BASE_IDX                                                          2
#define mmCRTC5_CRTC_COUNT_CONTROL                                                                     0x10fc
#define mmCRTC5_CRTC_COUNT_CONTROL_BASE_IDX                                                            2
#define mmCRTC5_CRTC_COUNT_RESET                                                                       0x10fd
#define mmCRTC5_CRTC_COUNT_RESET_BASE_IDX                                                              2
#define mmCRTC5_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE                                                      0x10fe
#define mmCRTC5_CRTC_MANUAL_FORCE_VSYNC_NEXT_LINE_BASE_IDX                                             2
#define mmCRTC5_CRTC_VERT_SYNC_CONTROL                                                                 0x10ff
#define mmCRTC5_CRTC_VERT_SYNC_CONTROL_BASE_IDX                                                        2
#define mmCRTC5_CRTC_STEREO_STATUS                                                                     0x1100
#define mmCRTC5_CRTC_STEREO_STATUS_BASE_IDX                                                            2
#define mmCRTC5_CRTC_STEREO_CONTROL                                                                    0x1101
#define mmCRTC5_CRTC_STEREO_CONTROL_BASE_IDX                                                           2
#define mmCRTC5_CRTC_SNAPSHOT_STATUS                                                                   0x1102
#define mmCRTC5_CRTC_SNAPSHOT_STATUS_BASE_IDX                                                          2
#define mmCRTC5_CRTC_SNAPSHOT_CONTROL                                                                  0x1103
#define mmCRTC5_CRTC_SNAPSHOT_CONTROL_BASE_IDX                                                         2
#define mmCRTC5_CRTC_SNAPSHOT_POSITION                                                                 0x1104
#define mmCRTC5_CRTC_SNAPSHOT_POSITION_BASE_IDX                                                        2
#define mmCRTC5_CRTC_SNAPSHOT_FRAME                                                                    0x1105
#define mmCRTC5_CRTC_SNAPSHOT_FRAME_BASE_IDX                                                           2
#define mmCRTC5_CRTC_START_LINE_CONTROL                                                                0x1106
#define mmCRTC5_CRTC_START_LINE_CONTROL_BASE_IDX                                                       2
#define mmCRTC5_CRTC_INTERRUPT_CONTROL                                                                 0x1107
#define mmCRTC5_CRTC_INTERRUPT_CONTROL_BASE_IDX                                                        2
#define mmCRTC5_CRTC_UPDATE_LOCK                                                                       0x1108
#define mmCRTC5_CRTC_UPDATE_LOCK_BASE_IDX                                                              2
#define mmCRTC5_CRTC_DOUBLE_BUFFER_CONTROL                                                             0x1109
#define mmCRTC5_CRTC_DOUBLE_BUFFER_CONTROL_BASE_IDX                                                    2
#define mmCRTC5_CRTC_VGA_PARAMETER_CAPTURE_MODE                                                        0x110a
#define mmCRTC5_CRTC_VGA_PARAMETER_CAPTURE_MODE_BASE_IDX                                               2
#define mmCRTC5_CRTC_TEST_PATTERN_CONTROL                                                              0x110b
#define mmCRTC5_CRTC_TEST_PATTERN_CONTROL_BASE_IDX                                                     2
#define mmCRTC5_CRTC_TEST_PATTERN_PARAMETERS                                                           0x110c
#define mmCRTC5_CRTC_TEST_PATTERN_PARAMETERS_BASE_IDX                                                  2
#define mmCRTC5_CRTC_TEST_PATTERN_COLOR                                                                0x110d
#define mmCRTC5_CRTC_TEST_PATTERN_COLOR_BASE_IDX                                                       2
#define mmCRTC5_CRTC_MASTER_UPDATE_LOCK                                                                0x110e
#define mmCRTC5_CRTC_MASTER_UPDATE_LOCK_BASE_IDX                                                       2
#define mmCRTC5_CRTC_MASTER_UPDATE_MODE                                                                0x110f
#define mmCRTC5_CRTC_MASTER_UPDATE_MODE_BASE_IDX                                                       2
#define mmCRTC5_CRTC_MVP_INBAND_CNTL_INSERT                                                            0x1110
#define mmCRTC5_CRTC_MVP_INBAND_CNTL_INSERT_BASE_IDX                                                   2
#define mmCRTC5_CRTC_MVP_INBAND_CNTL_INSERT_TIMER                                                      0x1111
#define mmCRTC5_CRTC_MVP_INBAND_CNTL_INSERT_TIMER_BASE_IDX                                             2
#define mmCRTC5_CRTC_MVP_STATUS                                                                        0x1112
#define mmCRTC5_CRTC_MVP_STATUS_BASE_IDX                                                               2
#define mmCRTC5_CRTC_MASTER_EN                                                                         0x1113
#define mmCRTC5_CRTC_MASTER_EN_BASE_IDX                                                                2
#define mmCRTC5_CRTC_ALLOW_STOP_OFF_V_CNT                                                              0x1114
#define mmCRTC5_CRTC_ALLOW_STOP_OFF_V_CNT_BASE_IDX                                                     2
#define mmCRTC5_CRTC_V_UPDATE_INT_STATUS                                                               0x1115
#define mmCRTC5_CRTC_V_UPDATE_INT_STATUS_BASE_IDX                                                      2
#define mmCRTC5_CRTC_OVERSCAN_COLOR                                                                    0x1117
#define mmCRTC5_CRTC_OVERSCAN_COLOR_BASE_IDX                                                           2
#define mmCRTC5_CRTC_OVERSCAN_COLOR_EXT                                                                0x1118
#define mmCRTC5_CRTC_OVERSCAN_COLOR_EXT_BASE_IDX                                                       2
#define mmCRTC5_CRTC_BLANK_DATA_COLOR                                                                  0x1119
#define mmCRTC5_CRTC_BLANK_DATA_COLOR_BASE_IDX                                                         2
#define mmCRTC5_CRTC_BLANK_DATA_COLOR_EXT                                                              0x111a
#define mmCRTC5_CRTC_BLANK_DATA_COLOR_EXT_BASE_IDX                                                     2
#define mmCRTC5_CRTC_BLACK_COLOR                                                                       0x111b
#define mmCRTC5_CRTC_BLACK_COLOR_BASE_IDX                                                              2
#define mmCRTC5_CRTC_BLACK_COLOR_EXT                                                                   0x111c
#define mmCRTC5_CRTC_BLACK_COLOR_EXT_BASE_IDX                                                          2
#define mmCRTC5_CRTC_VERTICAL_INTERRUPT0_POSITION                                                      0x111d
#define mmCRTC5_CRTC_VERTICAL_INTERRUPT0_POSITION_BASE_IDX                                             2
#define mmCRTC5_CRTC_VERTICAL_INTERRUPT0_CONTROL                                                       0x111e
#define mmCRTC5_CRTC_VERTICAL_INTERRUPT0_CONTROL_BASE_IDX                                              2
#define mmCRTC5_CRTC_VERTICAL_INTERRUPT1_POSITION                                                      0x111f
#define mmCRTC5_CRTC_VERTICAL_INTERRUPT1_POSITION_BASE_IDX                                             2
#define mmCRTC5_CRTC_VERTICAL_INTERRUPT1_CONTROL                                                       0x1120
#define mmCRTC5_CRTC_VERTICAL_INTERRUPT1_CONTROL_BASE_IDX                                              2
#define mmCRTC5_CRTC_VERTICAL_INTERRUPT2_POSITION                                                      0x1121
#define mmCRTC5_CRTC_VERTICAL_INTERRUPT2_POSITION_BASE_IDX                                             2
#define mmCRTC5_CRTC_VERTICAL_INTERRUPT2_CONTROL                                                       0x1122
#define mmCRTC5_CRTC_VERTICAL_INTERRUPT2_CONTROL_BASE_IDX                                              2
#define mmCRTC5_CRTC_CRC_CNTL                                                                          0x1123
#define mmCRTC5_CRTC_CRC_CNTL_BASE_IDX                                                                 2
#define mmCRTC5_CRTC_CRC0_WINDOWA_X_CONTROL                                                            0x1124
#define mmCRTC5_CRTC_CRC0_WINDOWA_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC5_CRTC_CRC0_WINDOWA_Y_CONTROL                                                            0x1125
#define mmCRTC5_CRTC_CRC0_WINDOWA_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC5_CRTC_CRC0_WINDOWB_X_CONTROL                                                            0x1126
#define mmCRTC5_CRTC_CRC0_WINDOWB_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC5_CRTC_CRC0_WINDOWB_Y_CONTROL                                                            0x1127
#define mmCRTC5_CRTC_CRC0_WINDOWB_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC5_CRTC_CRC0_DATA_RG                                                                      0x1128
#define mmCRTC5_CRTC_CRC0_DATA_RG_BASE_IDX                                                             2
#define mmCRTC5_CRTC_CRC0_DATA_B                                                                       0x1129
#define mmCRTC5_CRTC_CRC0_DATA_B_BASE_IDX                                                              2
#define mmCRTC5_CRTC_CRC1_WINDOWA_X_CONTROL                                                            0x112a
#define mmCRTC5_CRTC_CRC1_WINDOWA_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC5_CRTC_CRC1_WINDOWA_Y_CONTROL                                                            0x112b
#define mmCRTC5_CRTC_CRC1_WINDOWA_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC5_CRTC_CRC1_WINDOWB_X_CONTROL                                                            0x112c
#define mmCRTC5_CRTC_CRC1_WINDOWB_X_CONTROL_BASE_IDX                                                   2
#define mmCRTC5_CRTC_CRC1_WINDOWB_Y_CONTROL                                                            0x112d
#define mmCRTC5_CRTC_CRC1_WINDOWB_Y_CONTROL_BASE_IDX                                                   2
#define mmCRTC5_CRTC_CRC1_DATA_RG                                                                      0x112e
#define mmCRTC5_CRTC_CRC1_DATA_RG_BASE_IDX                                                             2
#define mmCRTC5_CRTC_CRC1_DATA_B                                                                       0x112f
#define mmCRTC5_CRTC_CRC1_DATA_B_BASE_IDX                                                              2
#define mmCRTC5_CRTC_EXT_TIMING_SYNC_CONTROL                                                           0x1130
#define mmCRTC5_CRTC_EXT_TIMING_SYNC_CONTROL_BASE_IDX                                                  2
#define mmCRTC5_CRTC_EXT_TIMING_SYNC_WINDOW_START                                                      0x1131
#define mmCRTC5_CRTC_EXT_TIMING_SYNC_WINDOW_START_BASE_IDX                                             2
#define mmCRTC5_CRTC_EXT_TIMING_SYNC_WINDOW_END                                                        0x1132
#define mmCRTC5_CRTC_EXT_TIMING_SYNC_WINDOW_END_BASE_IDX                                               2
#define mmCRTC5_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL                                            0x1133
#define mmCRTC5_CRTC_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_BASE_IDX                                   2
#define mmCRTC5_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL                                                 0x1134
#define mmCRTC5_CRTC_EXT_TIMING_SYNC_INTERRUPT_CONTROL_BASE_IDX                                        2
#define mmCRTC5_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL                                          0x1135
#define mmCRTC5_CRTC_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL_BASE_IDX                                 2
#define mmCRTC5_CRTC_STATIC_SCREEN_CONTROL                                                             0x1136
#define mmCRTC5_CRTC_STATIC_SCREEN_CONTROL_BASE_IDX                                                    2
#define mmCRTC5_CRTC_3D_STRUCTURE_CONTROL                                                              0x1137
#define mmCRTC5_CRTC_3D_STRUCTURE_CONTROL_BASE_IDX                                                     2
#define mmCRTC5_CRTC_GSL_VSYNC_GAP                                                                     0x1138
#define mmCRTC5_CRTC_GSL_VSYNC_GAP_BASE_IDX                                                            2
#define mmCRTC5_CRTC_GSL_WINDOW                                                                        0x1139
#define mmCRTC5_CRTC_GSL_WINDOW_BASE_IDX                                                               2
#define mmCRTC5_CRTC_GSL_CONTROL                                                                       0x113a
#define mmCRTC5_CRTC_GSL_CONTROL_BASE_IDX                                                              2
#define mmCRTC5_CRTC_RANGE_TIMING_INT_STATUS                                                           0x113d
#define mmCRTC5_CRTC_RANGE_TIMING_INT_STATUS_BASE_IDX                                                  2
#define mmCRTC5_CRTC_DRR_CONTROL                                                                       0x113e
#define mmCRTC5_CRTC_DRR_CONTROL_BASE_IDX                                                              2


// addressBlock: dce_dc_fmt5_dispdec
// base address: 0x2800
#define mmFMT5_FMT_CLAMP_COMPONENT_R                                                                   0x1142
#define mmFMT5_FMT_CLAMP_COMPONENT_R_BASE_IDX                                                          2
#define mmFMT5_FMT_CLAMP_COMPONENT_G                                                                   0x1143
#define mmFMT5_FMT_CLAMP_COMPONENT_G_BASE_IDX                                                          2
#define mmFMT5_FMT_CLAMP_COMPONENT_B                                                                   0x1144
#define mmFMT5_FMT_CLAMP_COMPONENT_B_BASE_IDX                                                          2
#define mmFMT5_FMT_DYNAMIC_EXP_CNTL                                                                    0x1145
#define mmFMT5_FMT_DYNAMIC_EXP_CNTL_BASE_IDX                                                           2
#define mmFMT5_FMT_CONTROL                                                                             0x1146
#define mmFMT5_FMT_CONTROL_BASE_IDX                                                                    2
#define mmFMT5_FMT_BIT_DEPTH_CONTROL                                                                   0x1147
#define mmFMT5_FMT_BIT_DEPTH_CONTROL_BASE_IDX                                                          2
#define mmFMT5_FMT_DITHER_RAND_R_SEED                                                                  0x1148
#define mmFMT5_FMT_DITHER_RAND_R_SEED_BASE_IDX                                                         2
#define mmFMT5_FMT_DITHER_RAND_G_SEED                                                                  0x1149
#define mmFMT5_FMT_DITHER_RAND_G_SEED_BASE_IDX                                                         2
#define mmFMT5_FMT_DITHER_RAND_B_SEED                                                                  0x114a
#define mmFMT5_FMT_DITHER_RAND_B_SEED_BASE_IDX                                                         2
#define mmFMT5_FMT_CLAMP_CNTL                                                                          0x114e
#define mmFMT5_FMT_CLAMP_CNTL_BASE_IDX                                                                 2
#define mmFMT5_FMT_CRC_CNTL                                                                            0x114f
#define mmFMT5_FMT_CRC_CNTL_BASE_IDX                                                                   2
#define mmFMT5_FMT_CRC_SIG_RED_GREEN_MASK                                                              0x1150
#define mmFMT5_FMT_CRC_SIG_RED_GREEN_MASK_BASE_IDX                                                     2
#define mmFMT5_FMT_CRC_SIG_BLUE_CONTROL_MASK                                                           0x1151
#define mmFMT5_FMT_CRC_SIG_BLUE_CONTROL_MASK_BASE_IDX                                                  2
#define mmFMT5_FMT_CRC_SIG_RED_GREEN                                                                   0x1152
#define mmFMT5_FMT_CRC_SIG_RED_GREEN_BASE_IDX                                                          2
#define mmFMT5_FMT_CRC_SIG_BLUE_CONTROL                                                                0x1153
#define mmFMT5_FMT_CRC_SIG_BLUE_CONTROL_BASE_IDX                                                       2
#define mmFMT5_FMT_SIDE_BY_SIDE_STEREO_CONTROL                                                         0x1154
#define mmFMT5_FMT_SIDE_BY_SIDE_STEREO_CONTROL_BASE_IDX                                                2
#define mmFMT5_FMT_420_HBLANK_EARLY_START                                                              0x1155
#define mmFMT5_FMT_420_HBLANK_EARLY_START_BASE_IDX                                                     2


// addressBlock: dce_dc_unp0_dispdec
// base address: 0x0
#define mmUNP0_UNP_GRPH_ENABLE                                                                         0x115a
#define mmUNP0_UNP_GRPH_ENABLE_BASE_IDX                                                                2
#define mmUNP0_UNP_GRPH_CONTROL                                                                        0x115b
#define mmUNP0_UNP_GRPH_CONTROL_BASE_IDX                                                               2
#define mmUNP0_UNP_GRPH_CONTROL_C                                                                      0x115c
#define mmUNP0_UNP_GRPH_CONTROL_C_BASE_IDX                                                             2
#define mmUNP0_UNP_GRPH_CONTROL_EXP                                                                    0x115d
#define mmUNP0_UNP_GRPH_CONTROL_EXP_BASE_IDX                                                           2
#define mmUNP0_UNP_GRPH_SWAP_CNTL                                                                      0x115e
#define mmUNP0_UNP_GRPH_SWAP_CNTL_BASE_IDX                                                             2
#define mmUNP0_UNP_GRPH_PRIMARY_SURFACE_ADDRESS_L                                                      0x115f
#define mmUNP0_UNP_GRPH_PRIMARY_SURFACE_ADDRESS_L_BASE_IDX                                             2
#define mmUNP0_UNP_GRPH_PRIMARY_SURFACE_ADDRESS_C                                                      0x1160
#define mmUNP0_UNP_GRPH_PRIMARY_SURFACE_ADDRESS_C_BASE_IDX                                             2
#define mmUNP0_UNP_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH_L                                                 0x1161
#define mmUNP0_UNP_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH_L_BASE_IDX                                        2
#define mmUNP0_UNP_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH_C                                                 0x1162
#define mmUNP0_UNP_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                        2
#define mmUNP0_UNP_GRPH_PRIMARY_BOTTOM_SURFACE_ADDRESS_L                                               0x1163
#define mmUNP0_UNP_GRPH_PRIMARY_BOTTOM_SURFACE_ADDRESS_L_BASE_IDX                                      2
#define mmUNP0_UNP_GRPH_PRIMARY_BOTTOM_SURFACE_ADDRESS_C                                               0x1164
#define mmUNP0_UNP_GRPH_PRIMARY_BOTTOM_SURFACE_ADDRESS_C_BASE_IDX                                      2
#define mmUNP0_UNP_GRPH_PRIMARY_BOTTOM_SURFACE_ADDRESS_HIGH_L                                          0x1165
#define mmUNP0_UNP_GRPH_PRIMARY_BOTTOM_SURFACE_ADDRESS_HIGH_L_BASE_IDX                                 2
#define mmUNP0_UNP_GRPH_PRIMARY_BOTTOM_SURFACE_ADDRESS_HIGH_C                                          0x1166
#define mmUNP0_UNP_GRPH_PRIMARY_BOTTOM_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                 2
#define mmUNP0_UNP_GRPH_SECONDARY_SURFACE_ADDRESS_L                                                    0x1167
#define mmUNP0_UNP_GRPH_SECONDARY_SURFACE_ADDRESS_L_BASE_IDX                                           2
#define mmUNP0_UNP_GRPH_SECONDARY_SURFACE_ADDRESS_C                                                    0x1168
#define mmUNP0_UNP_GRPH_SECONDARY_SURFACE_ADDRESS_C_BASE_IDX                                           2
#define mmUNP0_UNP_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH_L                                               0x1169
#define mmUNP0_UNP_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH_L_BASE_IDX                                      2
#define mmUNP0_UNP_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH_C                                               0x116a
#define mmUNP0_UNP_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                      2
#define mmUNP0_UNP_GRPH_SECONDARY_BOTTOM_SURFACE_ADDRESS_L                                             0x116b
#define mmUNP0_UNP_GRPH_SECONDARY_BOTTOM_SURFACE_ADDRESS_L_BASE_IDX                                    2
#define mmUNP0_UNP_GRPH_SECONDARY_BOTTOM_SURFACE_ADDRESS_C                                             0x116c
#define mmUNP0_UNP_GRPH_SECONDARY_BOTTOM_SURFACE_ADDRESS_C_BASE_IDX                                    2
#define mmUNP0_UNP_GRPH_SECONDARY_BOTTOM_SURFACE_ADDRESS_HIGH_L                                        0x116d
#define mmUNP0_UNP_GRPH_SECONDARY_BOTTOM_SURFACE_ADDRESS_HIGH_L_BASE_IDX                               2
#define mmUNP0_UNP_GRPH_SECONDARY_BOTTOM_SURFACE_ADDRESS_HIGH_C                                        0x116e
#define mmUNP0_UNP_GRPH_SECONDARY_BOTTOM_SURFACE_ADDRESS_HIGH_C_BASE_IDX                               2
#define mmUNP0_UNP_GRPH_PITCH_L                                                                        0x116f
#define mmUNP0_UNP_GRPH_PITCH_L_BASE_IDX                                                               2
#define mmUNP0_UNP_GRPH_PITCH_C                                                                        0x1170
#define mmUNP0_UNP_GRPH_PITCH_C_BASE_IDX                                                               2
#define mmUNP0_UNP_GRPH_SURFACE_OFFSET_X_L                                                             0x1171
#define mmUNP0_UNP_GRPH_SURFACE_OFFSET_X_L_BASE_IDX                                                    2
#define mmUNP0_UNP_GRPH_SURFACE_OFFSET_X_C                                                             0x1172
#define mmUNP0_UNP_GRPH_SURFACE_OFFSET_X_C_BASE_IDX                                                    2
#define mmUNP0_UNP_GRPH_SURFACE_OFFSET_Y_L                                                             0x1173
#define mmUNP0_UNP_GRPH_SURFACE_OFFSET_Y_L_BASE_IDX                                                    2
#define mmUNP0_UNP_GRPH_SURFACE_OFFSET_Y_C                                                             0x1174
#define mmUNP0_UNP_GRPH_SURFACE_OFFSET_Y_C_BASE_IDX                                                    2
#define mmUNP0_UNP_GRPH_X_START_L                                                                      0x1175
#define mmUNP0_UNP_GRPH_X_START_L_BASE_IDX                                                             2
#define mmUNP0_UNP_GRPH_X_START_C                                                                      0x1176
#define mmUNP0_UNP_GRPH_X_START_C_BASE_IDX                                                             2
#define mmUNP0_UNP_GRPH_Y_START_L                                                                      0x1177
#define mmUNP0_UNP_GRPH_Y_START_L_BASE_IDX                                                             2
#define mmUNP0_UNP_GRPH_Y_START_C                                                                      0x1178
#define mmUNP0_UNP_GRPH_Y_START_C_BASE_IDX                                                             2
#define mmUNP0_UNP_GRPH_X_END_L                                                                        0x1179
#define mmUNP0_UNP_GRPH_X_END_L_BASE_IDX                                                               2
#define mmUNP0_UNP_GRPH_X_END_C                                                                        0x117a
#define mmUNP0_UNP_GRPH_X_END_C_BASE_IDX                                                               2
#define mmUNP0_UNP_GRPH_Y_END_L                                                                        0x117b
#define mmUNP0_UNP_GRPH_Y_END_L_BASE_IDX                                                               2
#define mmUNP0_UNP_GRPH_Y_END_C                                                                        0x117c
#define mmUNP0_UNP_GRPH_Y_END_C_BASE_IDX                                                               2
#define mmUNP0_UNP_GRPH_UPDATE                                                                         0x117d
#define mmUNP0_UNP_GRPH_UPDATE_BASE_IDX                                                                2
#define mmUNP0_UNP_PIPE_OUTSTANDING_REQUEST_LIMIT                                                      0x117e
#define mmUNP0_UNP_PIPE_OUTSTANDING_REQUEST_LIMIT_BASE_IDX                                             2
#define mmUNP0_UNP_GRPH_SURFACE_ADDRESS_INUSE_L                                                        0x117f
#define mmUNP0_UNP_GRPH_SURFACE_ADDRESS_INUSE_L_BASE_IDX                                               2
#define mmUNP0_UNP_GRPH_SURFACE_ADDRESS_INUSE_C                                                        0x1180
#define mmUNP0_UNP_GRPH_SURFACE_ADDRESS_INUSE_C_BASE_IDX                                               2
#define mmUNP0_UNP_GRPH_SURFACE_ADDRESS_HIGH_INUSE_L                                                   0x1181
#define mmUNP0_UNP_GRPH_SURFACE_ADDRESS_HIGH_INUSE_L_BASE_IDX                                          2
#define mmUNP0_UNP_GRPH_SURFACE_ADDRESS_HIGH_INUSE_C                                                   0x1182
#define mmUNP0_UNP_GRPH_SURFACE_ADDRESS_HIGH_INUSE_C_BASE_IDX                                          2
#define mmUNP0_UNP_DVMM_PTE_CONTROL                                                                    0x1183
#define mmUNP0_UNP_DVMM_PTE_CONTROL_BASE_IDX                                                           2
#define mmUNP0_UNP_DVMM_PTE_CONTROL_C                                                                  0x1184
#define mmUNP0_UNP_DVMM_PTE_CONTROL_C_BASE_IDX                                                         2
#define mmUNP0_UNP_DVMM_PTE_ARB_CONTROL                                                                0x1185
#define mmUNP0_UNP_DVMM_PTE_ARB_CONTROL_BASE_IDX                                                       2
#define mmUNP0_UNP_DVMM_PTE_ARB_CONTROL_C                                                              0x1186
#define mmUNP0_UNP_DVMM_PTE_ARB_CONTROL_C_BASE_IDX                                                     2
#define mmUNP0_UNP_GRPH_INTERRUPT_STATUS                                                               0x1187
#define mmUNP0_UNP_GRPH_INTERRUPT_STATUS_BASE_IDX                                                      2
#define mmUNP0_UNP_GRPH_INTERRUPT_CONTROL                                                              0x1188
#define mmUNP0_UNP_GRPH_INTERRUPT_CONTROL_BASE_IDX                                                     2
#define mmUNP0_UNP_GRPH_STEREOSYNC_FLIP                                                                0x1189
#define mmUNP0_UNP_GRPH_STEREOSYNC_FLIP_BASE_IDX                                                       2
#define mmUNP0_UNP_FLIP_CONTROL                                                                        0x118a
#define mmUNP0_UNP_FLIP_CONTROL_BASE_IDX                                                               2
#define mmUNP0_UNP_CRC_CONTROL                                                                         0x118b
#define mmUNP0_UNP_CRC_CONTROL_BASE_IDX                                                                2
#define mmUNP0_UNP_CRC_MASK                                                                            0x118c
#define mmUNP0_UNP_CRC_MASK_BASE_IDX                                                                   2
#define mmUNP0_UNP_CRC_CURRENT                                                                         0x118d
#define mmUNP0_UNP_CRC_CURRENT_BASE_IDX                                                                2
#define mmUNP0_UNP_CRC_LAST                                                                            0x118e
#define mmUNP0_UNP_CRC_LAST_BASE_IDX                                                                   2
#define mmUNP0_UNP_LB_DATA_GAP_BETWEEN_CHUNK                                                           0x118f
#define mmUNP0_UNP_LB_DATA_GAP_BETWEEN_CHUNK_BASE_IDX                                                  2
#define mmUNP0_UNP_HW_ROTATION                                                                         0x1190
#define mmUNP0_UNP_HW_ROTATION_BASE_IDX                                                                2


// addressBlock: dce_dc_lbv0_dispdec
// base address: 0x0
#define mmLBV0_LBV_DATA_FORMAT                                                                         0x1196
#define mmLBV0_LBV_DATA_FORMAT_BASE_IDX                                                                2
#define mmLBV0_LBV_MEMORY_CTRL                                                                         0x1197
#define mmLBV0_LBV_MEMORY_CTRL_BASE_IDX                                                                2
#define mmLBV0_LBV_MEMORY_SIZE_STATUS                                                                  0x1198
#define mmLBV0_LBV_MEMORY_SIZE_STATUS_BASE_IDX                                                         2
#define mmLBV0_LBV_DESKTOP_HEIGHT                                                                      0x1199
#define mmLBV0_LBV_DESKTOP_HEIGHT_BASE_IDX                                                             2
#define mmLBV0_LBV_VLINE_START_END                                                                     0x119a
#define mmLBV0_LBV_VLINE_START_END_BASE_IDX                                                            2
#define mmLBV0_LBV_VLINE2_START_END                                                                    0x119b
#define mmLBV0_LBV_VLINE2_START_END_BASE_IDX                                                           2
#define mmLBV0_LBV_V_COUNTER                                                                           0x119c
#define mmLBV0_LBV_V_COUNTER_BASE_IDX                                                                  2
#define mmLBV0_LBV_SNAPSHOT_V_COUNTER                                                                  0x119d
#define mmLBV0_LBV_SNAPSHOT_V_COUNTER_BASE_IDX                                                         2
#define mmLBV0_LBV_V_COUNTER_CHROMA                                                                    0x119e
#define mmLBV0_LBV_V_COUNTER_CHROMA_BASE_IDX                                                           2
#define mmLBV0_LBV_SNAPSHOT_V_COUNTER_CHROMA                                                           0x119f
#define mmLBV0_LBV_SNAPSHOT_V_COUNTER_CHROMA_BASE_IDX                                                  2
#define mmLBV0_LBV_INTERRUPT_MASK                                                                      0x11a0
#define mmLBV0_LBV_INTERRUPT_MASK_BASE_IDX                                                             2
#define mmLBV0_LBV_VLINE_STATUS                                                                        0x11a1
#define mmLBV0_LBV_VLINE_STATUS_BASE_IDX                                                               2
#define mmLBV0_LBV_VLINE2_STATUS                                                                       0x11a2
#define mmLBV0_LBV_VLINE2_STATUS_BASE_IDX                                                              2
#define mmLBV0_LBV_VBLANK_STATUS                                                                       0x11a3
#define mmLBV0_LBV_VBLANK_STATUS_BASE_IDX                                                              2
#define mmLBV0_LBV_SYNC_RESET_SEL                                                                      0x11a4
#define mmLBV0_LBV_SYNC_RESET_SEL_BASE_IDX                                                             2
#define mmLBV0_LBV_BLACK_KEYER_R_CR                                                                    0x11a5
#define mmLBV0_LBV_BLACK_KEYER_R_CR_BASE_IDX                                                           2
#define mmLBV0_LBV_BLACK_KEYER_G_Y                                                                     0x11a6
#define mmLBV0_LBV_BLACK_KEYER_G_Y_BASE_IDX                                                            2
#define mmLBV0_LBV_BLACK_KEYER_B_CB                                                                    0x11a7
#define mmLBV0_LBV_BLACK_KEYER_B_CB_BASE_IDX                                                           2
#define mmLBV0_LBV_KEYER_COLOR_CTRL                                                                    0x11a8
#define mmLBV0_LBV_KEYER_COLOR_CTRL_BASE_IDX                                                           2
#define mmLBV0_LBV_KEYER_COLOR_R_CR                                                                    0x11a9
#define mmLBV0_LBV_KEYER_COLOR_R_CR_BASE_IDX                                                           2
#define mmLBV0_LBV_KEYER_COLOR_G_Y                                                                     0x11aa
#define mmLBV0_LBV_KEYER_COLOR_G_Y_BASE_IDX                                                            2
#define mmLBV0_LBV_KEYER_COLOR_B_CB                                                                    0x11ab
#define mmLBV0_LBV_KEYER_COLOR_B_CB_BASE_IDX                                                           2
#define mmLBV0_LBV_KEYER_COLOR_REP_R_CR                                                                0x11ac
#define mmLBV0_LBV_KEYER_COLOR_REP_R_CR_BASE_IDX                                                       2
#define mmLBV0_LBV_KEYER_COLOR_REP_G_Y                                                                 0x11ad
#define mmLBV0_LBV_KEYER_COLOR_REP_G_Y_BASE_IDX                                                        2
#define mmLBV0_LBV_KEYER_COLOR_REP_B_CB                                                                0x11ae
#define mmLBV0_LBV_KEYER_COLOR_REP_B_CB_BASE_IDX                                                       2
#define mmLBV0_LBV_BUFFER_LEVEL_STATUS                                                                 0x11af
#define mmLBV0_LBV_BUFFER_LEVEL_STATUS_BASE_IDX                                                        2
#define mmLBV0_LBV_BUFFER_URGENCY_CTRL                                                                 0x11b0
#define mmLBV0_LBV_BUFFER_URGENCY_CTRL_BASE_IDX                                                        2
#define mmLBV0_LBV_BUFFER_URGENCY_STATUS                                                               0x11b1
#define mmLBV0_LBV_BUFFER_URGENCY_STATUS_BASE_IDX                                                      2
#define mmLBV0_LBV_BUFFER_STATUS                                                                       0x11b2
#define mmLBV0_LBV_BUFFER_STATUS_BASE_IDX                                                              2
#define mmLBV0_LBV_NO_OUTSTANDING_REQ_STATUS                                                           0x11b3
#define mmLBV0_LBV_NO_OUTSTANDING_REQ_STATUS_BASE_IDX                                                  2


// addressBlock: dce_dc_sclv0_dispdec
// base address: 0x0
#define mmSCLV0_SCLV_COEF_RAM_SELECT                                                                   0x11ca
#define mmSCLV0_SCLV_COEF_RAM_SELECT_BASE_IDX                                                          2
#define mmSCLV0_SCLV_COEF_RAM_TAP_DATA                                                                 0x11cb
#define mmSCLV0_SCLV_COEF_RAM_TAP_DATA_BASE_IDX                                                        2
#define mmSCLV0_SCLV_MODE                                                                              0x11cc
#define mmSCLV0_SCLV_MODE_BASE_IDX                                                                     2
#define mmSCLV0_SCLV_TAP_CONTROL                                                                       0x11cd
#define mmSCLV0_SCLV_TAP_CONTROL_BASE_IDX                                                              2
#define mmSCLV0_SCLV_CONTROL                                                                           0x11ce
#define mmSCLV0_SCLV_CONTROL_BASE_IDX                                                                  2
#define mmSCLV0_SCLV_MANUAL_REPLICATE_CONTROL                                                          0x11cf
#define mmSCLV0_SCLV_MANUAL_REPLICATE_CONTROL_BASE_IDX                                                 2
#define mmSCLV0_SCLV_AUTOMATIC_MODE_CONTROL                                                            0x11d0
#define mmSCLV0_SCLV_AUTOMATIC_MODE_CONTROL_BASE_IDX                                                   2
#define mmSCLV0_SCLV_HORZ_FILTER_CONTROL                                                               0x11d1
#define mmSCLV0_SCLV_HORZ_FILTER_CONTROL_BASE_IDX                                                      2
#define mmSCLV0_SCLV_HORZ_FILTER_SCALE_RATIO                                                           0x11d2
#define mmSCLV0_SCLV_HORZ_FILTER_SCALE_RATIO_BASE_IDX                                                  2
#define mmSCLV0_SCLV_HORZ_FILTER_INIT                                                                  0x11d3
#define mmSCLV0_SCLV_HORZ_FILTER_INIT_BASE_IDX                                                         2
#define mmSCLV0_SCLV_HORZ_FILTER_SCALE_RATIO_C                                                         0x11d4
#define mmSCLV0_SCLV_HORZ_FILTER_SCALE_RATIO_C_BASE_IDX                                                2
#define mmSCLV0_SCLV_HORZ_FILTER_INIT_C                                                                0x11d5
#define mmSCLV0_SCLV_HORZ_FILTER_INIT_C_BASE_IDX                                                       2
#define mmSCLV0_SCLV_VERT_FILTER_CONTROL                                                               0x11d6
#define mmSCLV0_SCLV_VERT_FILTER_CONTROL_BASE_IDX                                                      2
#define mmSCLV0_SCLV_VERT_FILTER_SCALE_RATIO                                                           0x11d7
#define mmSCLV0_SCLV_VERT_FILTER_SCALE_RATIO_BASE_IDX                                                  2
#define mmSCLV0_SCLV_VERT_FILTER_INIT                                                                  0x11d8
#define mmSCLV0_SCLV_VERT_FILTER_INIT_BASE_IDX                                                         2
#define mmSCLV0_SCLV_VERT_FILTER_INIT_BOT                                                              0x11d9
#define mmSCLV0_SCLV_VERT_FILTER_INIT_BOT_BASE_IDX                                                     2
#define mmSCLV0_SCLV_VERT_FILTER_SCALE_RATIO_C                                                         0x11da
#define mmSCLV0_SCLV_VERT_FILTER_SCALE_RATIO_C_BASE_IDX                                                2
#define mmSCLV0_SCLV_VERT_FILTER_INIT_C                                                                0x11db
#define mmSCLV0_SCLV_VERT_FILTER_INIT_C_BASE_IDX                                                       2
#define mmSCLV0_SCLV_VERT_FILTER_INIT_BOT_C                                                            0x11dc
#define mmSCLV0_SCLV_VERT_FILTER_INIT_BOT_C_BASE_IDX                                                   2
#define mmSCLV0_SCLV_ROUND_OFFSET                                                                      0x11dd
#define mmSCLV0_SCLV_ROUND_OFFSET_BASE_IDX                                                             2
#define mmSCLV0_SCLV_UPDATE                                                                            0x11de
#define mmSCLV0_SCLV_UPDATE_BASE_IDX                                                                   2
#define mmSCLV0_SCLV_ALU_CONTROL                                                                       0x11df
#define mmSCLV0_SCLV_ALU_CONTROL_BASE_IDX                                                              2
#define mmSCLV0_SCLV_VIEWPORT_START                                                                    0x11e0
#define mmSCLV0_SCLV_VIEWPORT_START_BASE_IDX                                                           2
#define mmSCLV0_SCLV_VIEWPORT_START_SECONDARY                                                          0x11e1
#define mmSCLV0_SCLV_VIEWPORT_START_SECONDARY_BASE_IDX                                                 2
#define mmSCLV0_SCLV_VIEWPORT_SIZE                                                                     0x11e2
#define mmSCLV0_SCLV_VIEWPORT_SIZE_BASE_IDX                                                            2
#define mmSCLV0_SCLV_VIEWPORT_START_C                                                                  0x11e3
#define mmSCLV0_SCLV_VIEWPORT_START_C_BASE_IDX                                                         2
#define mmSCLV0_SCLV_VIEWPORT_START_SECONDARY_C                                                        0x11e4
#define mmSCLV0_SCLV_VIEWPORT_START_SECONDARY_C_BASE_IDX                                               2
#define mmSCLV0_SCLV_VIEWPORT_SIZE_C                                                                   0x11e5
#define mmSCLV0_SCLV_VIEWPORT_SIZE_C_BASE_IDX                                                          2
#define mmSCLV0_SCLV_EXT_OVERSCAN_LEFT_RIGHT                                                           0x11e6
#define mmSCLV0_SCLV_EXT_OVERSCAN_LEFT_RIGHT_BASE_IDX                                                  2
#define mmSCLV0_SCLV_EXT_OVERSCAN_TOP_BOTTOM                                                           0x11e7
#define mmSCLV0_SCLV_EXT_OVERSCAN_TOP_BOTTOM_BASE_IDX                                                  2
#define mmSCLV0_SCLV_MODE_CHANGE_DET1                                                                  0x11e8
#define mmSCLV0_SCLV_MODE_CHANGE_DET1_BASE_IDX                                                         2
#define mmSCLV0_SCLV_MODE_CHANGE_DET2                                                                  0x11e9
#define mmSCLV0_SCLV_MODE_CHANGE_DET2_BASE_IDX                                                         2
#define mmSCLV0_SCLV_MODE_CHANGE_DET3                                                                  0x11ea
#define mmSCLV0_SCLV_MODE_CHANGE_DET3_BASE_IDX                                                         2
#define mmSCLV0_SCLV_MODE_CHANGE_MASK                                                                  0x11eb
#define mmSCLV0_SCLV_MODE_CHANGE_MASK_BASE_IDX                                                         2
#define mmSCLV0_SCLV_HORZ_FILTER_INIT_BOT                                                              0x11ec
#define mmSCLV0_SCLV_HORZ_FILTER_INIT_BOT_BASE_IDX                                                     2
#define mmSCLV0_SCLV_HORZ_FILTER_INIT_BOT_C                                                            0x11ed
#define mmSCLV0_SCLV_HORZ_FILTER_INIT_BOT_C_BASE_IDX                                                   2


// addressBlock: dce_dc_col_man0_dispdec
// base address: 0x0
#define mmCOL_MAN0_COL_MAN_UPDATE                                                                      0x11fe
#define mmCOL_MAN0_COL_MAN_UPDATE_BASE_IDX                                                             2
#define mmCOL_MAN0_COL_MAN_INPUT_CSC_CONTROL                                                           0x11ff
#define mmCOL_MAN0_COL_MAN_INPUT_CSC_CONTROL_BASE_IDX                                                  2
#define mmCOL_MAN0_INPUT_CSC_C11_C12_A                                                                 0x1200
#define mmCOL_MAN0_INPUT_CSC_C11_C12_A_BASE_IDX                                                        2
#define mmCOL_MAN0_INPUT_CSC_C13_C14_A                                                                 0x1201
#define mmCOL_MAN0_INPUT_CSC_C13_C14_A_BASE_IDX                                                        2
#define mmCOL_MAN0_INPUT_CSC_C21_C22_A                                                                 0x1202
#define mmCOL_MAN0_INPUT_CSC_C21_C22_A_BASE_IDX                                                        2
#define mmCOL_MAN0_INPUT_CSC_C23_C24_A                                                                 0x1203
#define mmCOL_MAN0_INPUT_CSC_C23_C24_A_BASE_IDX                                                        2
#define mmCOL_MAN0_INPUT_CSC_C31_C32_A                                                                 0x1204
#define mmCOL_MAN0_INPUT_CSC_C31_C32_A_BASE_IDX                                                        2
#define mmCOL_MAN0_INPUT_CSC_C33_C34_A                                                                 0x1205
#define mmCOL_MAN0_INPUT_CSC_C33_C34_A_BASE_IDX                                                        2
#define mmCOL_MAN0_INPUT_CSC_C11_C12_B                                                                 0x1206
#define mmCOL_MAN0_INPUT_CSC_C11_C12_B_BASE_IDX                                                        2
#define mmCOL_MAN0_INPUT_CSC_C13_C14_B                                                                 0x1207
#define mmCOL_MAN0_INPUT_CSC_C13_C14_B_BASE_IDX                                                        2
#define mmCOL_MAN0_INPUT_CSC_C21_C22_B                                                                 0x1208
#define mmCOL_MAN0_INPUT_CSC_C21_C22_B_BASE_IDX                                                        2
#define mmCOL_MAN0_INPUT_CSC_C23_C24_B                                                                 0x1209
#define mmCOL_MAN0_INPUT_CSC_C23_C24_B_BASE_IDX                                                        2
#define mmCOL_MAN0_INPUT_CSC_C31_C32_B                                                                 0x120a
#define mmCOL_MAN0_INPUT_CSC_C31_C32_B_BASE_IDX                                                        2
#define mmCOL_MAN0_INPUT_CSC_C33_C34_B                                                                 0x120b
#define mmCOL_MAN0_INPUT_CSC_C33_C34_B_BASE_IDX                                                        2
#define mmCOL_MAN0_PRESCALE_CONTROL                                                                    0x120c
#define mmCOL_MAN0_PRESCALE_CONTROL_BASE_IDX                                                           2
#define mmCOL_MAN0_PRESCALE_VALUES_R                                                                   0x120d
#define mmCOL_MAN0_PRESCALE_VALUES_R_BASE_IDX                                                          2
#define mmCOL_MAN0_PRESCALE_VALUES_G                                                                   0x120e
#define mmCOL_MAN0_PRESCALE_VALUES_G_BASE_IDX                                                          2
#define mmCOL_MAN0_PRESCALE_VALUES_B                                                                   0x120f
#define mmCOL_MAN0_PRESCALE_VALUES_B_BASE_IDX                                                          2
#define mmCOL_MAN0_COL_MAN_OUTPUT_CSC_CONTROL                                                          0x1210
#define mmCOL_MAN0_COL_MAN_OUTPUT_CSC_CONTROL_BASE_IDX                                                 2
#define mmCOL_MAN0_OUTPUT_CSC_C11_C12_A                                                                0x1211
#define mmCOL_MAN0_OUTPUT_CSC_C11_C12_A_BASE_IDX                                                       2
#define mmCOL_MAN0_OUTPUT_CSC_C13_C14_A                                                                0x1212
#define mmCOL_MAN0_OUTPUT_CSC_C13_C14_A_BASE_IDX                                                       2
#define mmCOL_MAN0_OUTPUT_CSC_C21_C22_A                                                                0x1213
#define mmCOL_MAN0_OUTPUT_CSC_C21_C22_A_BASE_IDX                                                       2
#define mmCOL_MAN0_OUTPUT_CSC_C23_C24_A                                                                0x1214
#define mmCOL_MAN0_OUTPUT_CSC_C23_C24_A_BASE_IDX                                                       2
#define mmCOL_MAN0_OUTPUT_CSC_C31_C32_A                                                                0x1215
#define mmCOL_MAN0_OUTPUT_CSC_C31_C32_A_BASE_IDX                                                       2
#define mmCOL_MAN0_OUTPUT_CSC_C33_C34_A                                                                0x1216
#define mmCOL_MAN0_OUTPUT_CSC_C33_C34_A_BASE_IDX                                                       2
#define mmCOL_MAN0_OUTPUT_CSC_C11_C12_B                                                                0x1217
#define mmCOL_MAN0_OUTPUT_CSC_C11_C12_B_BASE_IDX                                                       2
#define mmCOL_MAN0_OUTPUT_CSC_C13_C14_B                                                                0x1218
#define mmCOL_MAN0_OUTPUT_CSC_C13_C14_B_BASE_IDX                                                       2
#define mmCOL_MAN0_OUTPUT_CSC_C21_C22_B                                                                0x1219
#define mmCOL_MAN0_OUTPUT_CSC_C21_C22_B_BASE_IDX                                                       2
#define mmCOL_MAN0_OUTPUT_CSC_C23_C24_B                                                                0x121a
#define mmCOL_MAN0_OUTPUT_CSC_C23_C24_B_BASE_IDX                                                       2
#define mmCOL_MAN0_OUTPUT_CSC_C31_C32_B                                                                0x121b
#define mmCOL_MAN0_OUTPUT_CSC_C31_C32_B_BASE_IDX                                                       2
#define mmCOL_MAN0_OUTPUT_CSC_C33_C34_B                                                                0x121c
#define mmCOL_MAN0_OUTPUT_CSC_C33_C34_B_BASE_IDX                                                       2
#define mmCOL_MAN0_DENORM_CLAMP_CONTROL                                                                0x121d
#define mmCOL_MAN0_DENORM_CLAMP_CONTROL_BASE_IDX                                                       2
#define mmCOL_MAN0_DENORM_CLAMP_RANGE_R_CR                                                             0x121e
#define mmCOL_MAN0_DENORM_CLAMP_RANGE_R_CR_BASE_IDX                                                    2
#define mmCOL_MAN0_DENORM_CLAMP_RANGE_G_Y                                                              0x121f
#define mmCOL_MAN0_DENORM_CLAMP_RANGE_G_Y_BASE_IDX                                                     2
#define mmCOL_MAN0_DENORM_CLAMP_RANGE_B_CB                                                             0x1220
#define mmCOL_MAN0_DENORM_CLAMP_RANGE_B_CB_BASE_IDX                                                    2
#define mmCOL_MAN0_COL_MAN_FP_CONVERTED_FIELD                                                          0x1221
#define mmCOL_MAN0_COL_MAN_FP_CONVERTED_FIELD_BASE_IDX                                                 2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CONTROL                                                             0x1222
#define mmCOL_MAN0_COL_MAN_REGAMMA_CONTROL_BASE_IDX                                                    2
#define mmCOL_MAN0_COL_MAN_REGAMMA_LUT_INDEX                                                           0x1223
#define mmCOL_MAN0_COL_MAN_REGAMMA_LUT_INDEX_BASE_IDX                                                  2
#define mmCOL_MAN0_COL_MAN_REGAMMA_LUT_DATA                                                            0x1224
#define mmCOL_MAN0_COL_MAN_REGAMMA_LUT_DATA_BASE_IDX                                                   2
#define mmCOL_MAN0_COL_MAN_REGAMMA_LUT_WRITE_EN_MASK                                                   0x1225
#define mmCOL_MAN0_COL_MAN_REGAMMA_LUT_WRITE_EN_MASK_BASE_IDX                                          2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_START_CNTL                                                    0x1226
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_START_CNTL_BASE_IDX                                           2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_SLOPE_CNTL                                                    0x1227
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_SLOPE_CNTL_BASE_IDX                                           2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_END_CNTL1                                                     0x1228
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_END_CNTL1_BASE_IDX                                            2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_END_CNTL2                                                     0x1229
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_END_CNTL2_BASE_IDX                                            2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_REGION_0_1                                                    0x122a
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_REGION_0_1_BASE_IDX                                           2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_REGION_2_3                                                    0x122b
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_REGION_2_3_BASE_IDX                                           2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_REGION_4_5                                                    0x122c
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_REGION_4_5_BASE_IDX                                           2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_REGION_6_7                                                    0x122d
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_REGION_6_7_BASE_IDX                                           2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_REGION_8_9                                                    0x122e
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_REGION_8_9_BASE_IDX                                           2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_REGION_10_11                                                  0x122f
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_REGION_10_11_BASE_IDX                                         2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_REGION_12_13                                                  0x1230
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_REGION_12_13_BASE_IDX                                         2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_REGION_14_15                                                  0x1231
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLA_REGION_14_15_BASE_IDX                                         2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_START_CNTL                                                    0x1232
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_START_CNTL_BASE_IDX                                           2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_SLOPE_CNTL                                                    0x1233
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_SLOPE_CNTL_BASE_IDX                                           2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_END_CNTL1                                                     0x1234
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_END_CNTL1_BASE_IDX                                            2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_END_CNTL2                                                     0x1235
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_END_CNTL2_BASE_IDX                                            2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_REGION_0_1                                                    0x1236
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_REGION_0_1_BASE_IDX                                           2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_REGION_2_3                                                    0x1237
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_REGION_2_3_BASE_IDX                                           2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_REGION_4_5                                                    0x1238
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_REGION_4_5_BASE_IDX                                           2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_REGION_6_7                                                    0x1239
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_REGION_6_7_BASE_IDX                                           2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_REGION_8_9                                                    0x123a
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_REGION_8_9_BASE_IDX                                           2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_REGION_10_11                                                  0x123b
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_REGION_10_11_BASE_IDX                                         2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_REGION_12_13                                                  0x123c
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_REGION_12_13_BASE_IDX                                         2
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_REGION_14_15                                                  0x123d
#define mmCOL_MAN0_COL_MAN_REGAMMA_CNTLB_REGION_14_15_BASE_IDX                                         2
#define mmCOL_MAN0_PACK_FIFO_ERROR                                                                     0x123e
#define mmCOL_MAN0_PACK_FIFO_ERROR_BASE_IDX                                                            2
#define mmCOL_MAN0_OUTPUT_FIFO_ERROR                                                                   0x123f
#define mmCOL_MAN0_OUTPUT_FIFO_ERROR_BASE_IDX                                                          2
#define mmCOL_MAN0_INPUT_GAMMA_LUT_AUTOFILL                                                            0x1240
#define mmCOL_MAN0_INPUT_GAMMA_LUT_AUTOFILL_BASE_IDX                                                   2
#define mmCOL_MAN0_INPUT_GAMMA_LUT_RW_INDEX                                                            0x1241
#define mmCOL_MAN0_INPUT_GAMMA_LUT_RW_INDEX_BASE_IDX                                                   2
#define mmCOL_MAN0_INPUT_GAMMA_LUT_SEQ_COLOR                                                           0x1242
#define mmCOL_MAN0_INPUT_GAMMA_LUT_SEQ_COLOR_BASE_IDX                                                  2
#define mmCOL_MAN0_INPUT_GAMMA_LUT_PWL_DATA                                                            0x1243
#define mmCOL_MAN0_INPUT_GAMMA_LUT_PWL_DATA_BASE_IDX                                                   2
#define mmCOL_MAN0_INPUT_GAMMA_LUT_30_COLOR                                                            0x1244
#define mmCOL_MAN0_INPUT_GAMMA_LUT_30_COLOR_BASE_IDX                                                   2
#define mmCOL_MAN0_COL_MAN_INPUT_GAMMA_CONTROL1                                                        0x1245
#define mmCOL_MAN0_COL_MAN_INPUT_GAMMA_CONTROL1_BASE_IDX                                               2
#define mmCOL_MAN0_COL_MAN_INPUT_GAMMA_CONTROL2                                                        0x1246
#define mmCOL_MAN0_COL_MAN_INPUT_GAMMA_CONTROL2_BASE_IDX                                               2
#define mmCOL_MAN0_INPUT_GAMMA_BW_OFFSETS_B                                                            0x1247
#define mmCOL_MAN0_INPUT_GAMMA_BW_OFFSETS_B_BASE_IDX                                                   2
#define mmCOL_MAN0_INPUT_GAMMA_BW_OFFSETS_G                                                            0x1248
#define mmCOL_MAN0_INPUT_GAMMA_BW_OFFSETS_G_BASE_IDX                                                   2
#define mmCOL_MAN0_INPUT_GAMMA_BW_OFFSETS_R                                                            0x1249
#define mmCOL_MAN0_INPUT_GAMMA_BW_OFFSETS_R_BASE_IDX                                                   2
#define mmCOL_MAN0_COL_MAN_DEGAMMA_CONTROL                                                             0x124a
#define mmCOL_MAN0_COL_MAN_DEGAMMA_CONTROL_BASE_IDX                                                    2
#define mmCOL_MAN0_COL_MAN_GAMUT_REMAP_CONTROL                                                         0x124b
#define mmCOL_MAN0_COL_MAN_GAMUT_REMAP_CONTROL_BASE_IDX                                                2
#define mmCOL_MAN0_COL_MAN_GAMUT_REMAP_C11_C12                                                         0x124c
#define mmCOL_MAN0_COL_MAN_GAMUT_REMAP_C11_C12_BASE_IDX                                                2
#define mmCOL_MAN0_COL_MAN_GAMUT_REMAP_C13_C14                                                         0x124d
#define mmCOL_MAN0_COL_MAN_GAMUT_REMAP_C13_C14_BASE_IDX                                                2
#define mmCOL_MAN0_COL_MAN_GAMUT_REMAP_C21_C22                                                         0x124e
#define mmCOL_MAN0_COL_MAN_GAMUT_REMAP_C21_C22_BASE_IDX                                                2
#define mmCOL_MAN0_COL_MAN_GAMUT_REMAP_C23_C24                                                         0x124f
#define mmCOL_MAN0_COL_MAN_GAMUT_REMAP_C23_C24_BASE_IDX                                                2
#define mmCOL_MAN0_COL_MAN_GAMUT_REMAP_C31_C32                                                         0x1250
#define mmCOL_MAN0_COL_MAN_GAMUT_REMAP_C31_C32_BASE_IDX                                                2
#define mmCOL_MAN0_COL_MAN_GAMUT_REMAP_C33_C34                                                         0x1251
#define mmCOL_MAN0_COL_MAN_GAMUT_REMAP_C33_C34_BASE_IDX                                                2


// addressBlock: dce_dc_dcfev0_dispdec
// base address: 0x0
#define mmDCFEV0_DCFEV_CLOCK_CONTROL                                                                   0x127e
#define mmDCFEV0_DCFEV_CLOCK_CONTROL_BASE_IDX                                                          2
#define mmDCFEV0_DCFEV_SOFT_RESET                                                                      0x127f
#define mmDCFEV0_DCFEV_SOFT_RESET_BASE_IDX                                                             2
#define mmDCFEV0_DCFEV_DMIFV_CLOCK_CONTROL                                                             0x1280
#define mmDCFEV0_DCFEV_DMIFV_CLOCK_CONTROL_BASE_IDX                                                    2
#define mmDCFEV0_DCFEV_DMIFV_MEM_PWR_CTRL                                                              0x1282
#define mmDCFEV0_DCFEV_DMIFV_MEM_PWR_CTRL_BASE_IDX                                                     2
#define mmDCFEV0_DCFEV_DMIFV_MEM_PWR_STATUS                                                            0x1283
#define mmDCFEV0_DCFEV_DMIFV_MEM_PWR_STATUS_BASE_IDX                                                   2
#define mmDCFEV0_DCFEV_MEM_PWR_CTRL                                                                    0x1284
#define mmDCFEV0_DCFEV_MEM_PWR_CTRL_BASE_IDX                                                           2
#define mmDCFEV0_DCFEV_MEM_PWR_CTRL2                                                                   0x1285
#define mmDCFEV0_DCFEV_MEM_PWR_CTRL2_BASE_IDX                                                          2
#define mmDCFEV0_DCFEV_MEM_PWR_STATUS                                                                  0x1286
#define mmDCFEV0_DCFEV_MEM_PWR_STATUS_BASE_IDX                                                         2
#define mmDCFEV0_DCFEV_L_FLUSH                                                                         0x1287
#define mmDCFEV0_DCFEV_L_FLUSH_BASE_IDX                                                                2
#define mmDCFEV0_DCFEV_C_FLUSH                                                                         0x1288
#define mmDCFEV0_DCFEV_C_FLUSH_BASE_IDX                                                                2
#define mmDCFEV0_DCFEV_MISC                                                                            0x128a
#define mmDCFEV0_DCFEV_MISC_BASE_IDX                                                                   2


// addressBlock: dce_dc_dc_perfmon11_dispdec
// base address: 0x49c8
#define mmDC_PERFMON11_PERFCOUNTER_CNTL                                                                0x1292
#define mmDC_PERFMON11_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define mmDC_PERFMON11_PERFCOUNTER_CNTL2                                                               0x1293
#define mmDC_PERFMON11_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define mmDC_PERFMON11_PERFCOUNTER_STATE                                                               0x1294
#define mmDC_PERFMON11_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define mmDC_PERFMON11_PERFMON_CNTL                                                                    0x1295
#define mmDC_PERFMON11_PERFMON_CNTL_BASE_IDX                                                           2
#define mmDC_PERFMON11_PERFMON_CNTL2                                                                   0x1296
#define mmDC_PERFMON11_PERFMON_CNTL2_BASE_IDX                                                          2
#define mmDC_PERFMON11_PERFMON_CVALUE_INT_MISC                                                         0x1297
#define mmDC_PERFMON11_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define mmDC_PERFMON11_PERFMON_CVALUE_LOW                                                              0x1298
#define mmDC_PERFMON11_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define mmDC_PERFMON11_PERFMON_HI                                                                      0x1299
#define mmDC_PERFMON11_PERFMON_HI_BASE_IDX                                                             2
#define mmDC_PERFMON11_PERFMON_LOW                                                                     0x129a
#define mmDC_PERFMON11_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_dmifv_pg0_dispdec
// base address: 0x0
#define mmDMIFV_PG0_DPGV0_PIPE_ARBITRATION_CONTROL1                                                    0x129e
#define mmDMIFV_PG0_DPGV0_PIPE_ARBITRATION_CONTROL1_BASE_IDX                                           2
#define mmDMIFV_PG0_DPGV0_PIPE_ARBITRATION_CONTROL2                                                    0x129f
#define mmDMIFV_PG0_DPGV0_PIPE_ARBITRATION_CONTROL2_BASE_IDX                                           2
#define mmDMIFV_PG0_DPGV0_WATERMARK_MASK_CONTROL                                                       0x12a0
#define mmDMIFV_PG0_DPGV0_WATERMARK_MASK_CONTROL_BASE_IDX                                              2
#define mmDMIFV_PG0_DPGV0_PIPE_URGENCY_CONTROL                                                         0x12a1
#define mmDMIFV_PG0_DPGV0_PIPE_URGENCY_CONTROL_BASE_IDX                                                2
#define mmDMIFV_PG0_DPGV0_PIPE_DPM_CONTROL                                                             0x12a2
#define mmDMIFV_PG0_DPGV0_PIPE_DPM_CONTROL_BASE_IDX                                                    2
#define mmDMIFV_PG0_DPGV0_PIPE_STUTTER_CONTROL                                                         0x12a3
#define mmDMIFV_PG0_DPGV0_PIPE_STUTTER_CONTROL_BASE_IDX                                                2
#define mmDMIFV_PG0_DPGV0_PIPE_NB_PSTATE_CHANGE_CONTROL                                                0x12a4
#define mmDMIFV_PG0_DPGV0_PIPE_NB_PSTATE_CHANGE_CONTROL_BASE_IDX                                       2
#define mmDMIFV_PG0_DPGV0_PIPE_STUTTER_CONTROL_NONLPTCH                                                0x12a5
#define mmDMIFV_PG0_DPGV0_PIPE_STUTTER_CONTROL_NONLPTCH_BASE_IDX                                       2
#define mmDMIFV_PG0_DPGV0_REPEATER_PROGRAM                                                             0x12a6
#define mmDMIFV_PG0_DPGV0_REPEATER_PROGRAM_BASE_IDX                                                    2
#define mmDMIFV_PG0_DPGV0_CHK_PRE_PROC_CNTL                                                            0x12aa
#define mmDMIFV_PG0_DPGV0_CHK_PRE_PROC_CNTL_BASE_IDX                                                   2
#define mmDMIFV_PG0_DPGV1_PIPE_ARBITRATION_CONTROL1                                                    0x12ab
#define mmDMIFV_PG0_DPGV1_PIPE_ARBITRATION_CONTROL1_BASE_IDX                                           2
#define mmDMIFV_PG0_DPGV1_PIPE_ARBITRATION_CONTROL2                                                    0x12ac
#define mmDMIFV_PG0_DPGV1_PIPE_ARBITRATION_CONTROL2_BASE_IDX                                           2
#define mmDMIFV_PG0_DPGV1_WATERMARK_MASK_CONTROL                                                       0x12ad
#define mmDMIFV_PG0_DPGV1_WATERMARK_MASK_CONTROL_BASE_IDX                                              2
#define mmDMIFV_PG0_DPGV1_PIPE_URGENCY_CONTROL                                                         0x12ae
#define mmDMIFV_PG0_DPGV1_PIPE_URGENCY_CONTROL_BASE_IDX                                                2
#define mmDMIFV_PG0_DPGV1_PIPE_DPM_CONTROL                                                             0x12af
#define mmDMIFV_PG0_DPGV1_PIPE_DPM_CONTROL_BASE_IDX                                                    2
#define mmDMIFV_PG0_DPGV1_PIPE_STUTTER_CONTROL                                                         0x12b0
#define mmDMIFV_PG0_DPGV1_PIPE_STUTTER_CONTROL_BASE_IDX                                                2
#define mmDMIFV_PG0_DPGV1_PIPE_NB_PSTATE_CHANGE_CONTROL                                                0x12b1
#define mmDMIFV_PG0_DPGV1_PIPE_NB_PSTATE_CHANGE_CONTROL_BASE_IDX                                       2
#define mmDMIFV_PG0_DPGV1_PIPE_STUTTER_CONTROL_NONLPTCH                                                0x12b2
#define mmDMIFV_PG0_DPGV1_PIPE_STUTTER_CONTROL_NONLPTCH_BASE_IDX                                       2
#define mmDMIFV_PG0_DPGV1_REPEATER_PROGRAM                                                             0x12b3
#define mmDMIFV_PG0_DPGV1_REPEATER_PROGRAM_BASE_IDX                                                    2
#define mmDMIFV_PG0_DPGV1_CHK_PRE_PROC_CNTL                                                            0x12b7
#define mmDMIFV_PG0_DPGV1_CHK_PRE_PROC_CNTL_BASE_IDX                                                   2


// addressBlock: dce_dc_blndv0_dispdec
// base address: 0x0
#define mmBLNDV0_BLNDV_CONTROL                                                                         0x12db
#define mmBLNDV0_BLNDV_CONTROL_BASE_IDX                                                                2
#define mmBLNDV0_BLNDV_SM_CONTROL2                                                                     0x12dc
#define mmBLNDV0_BLNDV_SM_CONTROL2_BASE_IDX                                                            2
#define mmBLNDV0_BLNDV_CONTROL2                                                                        0x12dd
#define mmBLNDV0_BLNDV_CONTROL2_BASE_IDX                                                               2
#define mmBLNDV0_BLNDV_UPDATE                                                                          0x12de
#define mmBLNDV0_BLNDV_UPDATE_BASE_IDX                                                                 2
#define mmBLNDV0_BLNDV_UNDERFLOW_INTERRUPT                                                             0x12df
#define mmBLNDV0_BLNDV_UNDERFLOW_INTERRUPT_BASE_IDX                                                    2
#define mmBLNDV0_BLNDV_V_UPDATE_LOCK                                                                   0x12e0
#define mmBLNDV0_BLNDV_V_UPDATE_LOCK_BASE_IDX                                                          2
#define mmBLNDV0_BLNDV_REG_UPDATE_STATUS                                                               0x12e1
#define mmBLNDV0_BLNDV_REG_UPDATE_STATUS_BASE_IDX                                                      2


// addressBlock: dce_dc_crtcv0_dispdec
// base address: 0x0
#define mmCRTCV0_CRTCV_H_BLANK_EARLY_NUM                                                               0x12e6
#define mmCRTCV0_CRTCV_H_BLANK_EARLY_NUM_BASE_IDX                                                      2
#define mmCRTCV0_CRTCV_H_TOTAL                                                                         0x12e7
#define mmCRTCV0_CRTCV_H_TOTAL_BASE_IDX                                                                2
#define mmCRTCV0_CRTCV_H_BLANK_START_END                                                               0x12e8
#define mmCRTCV0_CRTCV_H_BLANK_START_END_BASE_IDX                                                      2
#define mmCRTCV0_CRTCV_H_SYNC_A                                                                        0x12e9
#define mmCRTCV0_CRTCV_H_SYNC_A_BASE_IDX                                                               2
#define mmCRTCV0_CRTCV_H_SYNC_A_CNTL                                                                   0x12ea
#define mmCRTCV0_CRTCV_H_SYNC_A_CNTL_BASE_IDX                                                          2
#define mmCRTCV0_CRTCV_H_SYNC_B                                                                        0x12eb
#define mmCRTCV0_CRTCV_H_SYNC_B_BASE_IDX                                                               2
#define mmCRTCV0_CRTCV_H_SYNC_B_CNTL                                                                   0x12ec
#define mmCRTCV0_CRTCV_H_SYNC_B_CNTL_BASE_IDX                                                          2
#define mmCRTCV0_CRTCV_VBI_END                                                                         0x12ed
#define mmCRTCV0_CRTCV_VBI_END_BASE_IDX                                                                2
#define mmCRTCV0_CRTCV_V_TOTAL                                                                         0x12ee
#define mmCRTCV0_CRTCV_V_TOTAL_BASE_IDX                                                                2
#define mmCRTCV0_CRTCV_V_TOTAL_MIN                                                                     0x12ef
#define mmCRTCV0_CRTCV_V_TOTAL_MIN_BASE_IDX                                                            2
#define mmCRTCV0_CRTCV_V_TOTAL_MAX                                                                     0x12f0
#define mmCRTCV0_CRTCV_V_TOTAL_MAX_BASE_IDX                                                            2
#define mmCRTCV0_CRTCV_V_TOTAL_CONTROL                                                                 0x12f1
#define mmCRTCV0_CRTCV_V_TOTAL_CONTROL_BASE_IDX                                                        2
#define mmCRTCV0_CRTCV_V_TOTAL_INT_STATUS                                                              0x12f2
#define mmCRTCV0_CRTCV_V_TOTAL_INT_STATUS_BASE_IDX                                                     2
#define mmCRTCV0_CRTCV_VSYNC_NOM_INT_STATUS                                                            0x12f3
#define mmCRTCV0_CRTCV_VSYNC_NOM_INT_STATUS_BASE_IDX                                                   2
#define mmCRTCV0_CRTCV_V_BLANK_START_END                                                               0x12f4
#define mmCRTCV0_CRTCV_V_BLANK_START_END_BASE_IDX                                                      2
#define mmCRTCV0_CRTCV_V_SYNC_A                                                                        0x12f5
#define mmCRTCV0_CRTCV_V_SYNC_A_BASE_IDX                                                               2
#define mmCRTCV0_CRTCV_V_SYNC_A_CNTL                                                                   0x12f6
#define mmCRTCV0_CRTCV_V_SYNC_A_CNTL_BASE_IDX                                                          2
#define mmCRTCV0_CRTCV_V_SYNC_B                                                                        0x12f7
#define mmCRTCV0_CRTCV_V_SYNC_B_BASE_IDX                                                               2
#define mmCRTCV0_CRTCV_V_SYNC_B_CNTL                                                                   0x12f8
#define mmCRTCV0_CRTCV_V_SYNC_B_CNTL_BASE_IDX                                                          2
#define mmCRTCV0_CRTCV_DTMTEST_CNTL                                                                    0x12f9
#define mmCRTCV0_CRTCV_DTMTEST_CNTL_BASE_IDX                                                           2
#define mmCRTCV0_CRTCV_DTMTEST_STATUS_POSITION                                                         0x12fa
#define mmCRTCV0_CRTCV_DTMTEST_STATUS_POSITION_BASE_IDX                                                2
#define mmCRTCV0_CRTCV_TRIGA_CNTL                                                                      0x12fb
#define mmCRTCV0_CRTCV_TRIGA_CNTL_BASE_IDX                                                             2
#define mmCRTCV0_CRTCV_TRIGA_MANUAL_TRIG                                                               0x12fc
#define mmCRTCV0_CRTCV_TRIGA_MANUAL_TRIG_BASE_IDX                                                      2
#define mmCRTCV0_CRTCV_TRIGB_CNTL                                                                      0x12fd
#define mmCRTCV0_CRTCV_TRIGB_CNTL_BASE_IDX                                                             2
#define mmCRTCV0_CRTCV_TRIGB_MANUAL_TRIG                                                               0x12fe
#define mmCRTCV0_CRTCV_TRIGB_MANUAL_TRIG_BASE_IDX                                                      2
#define mmCRTCV0_CRTCV_FORCE_COUNT_NOW_CNTL                                                            0x12ff
#define mmCRTCV0_CRTCV_FORCE_COUNT_NOW_CNTL_BASE_IDX                                                   2
#define mmCRTCV0_CRTCV_FLOW_CONTROL                                                                    0x1300
#define mmCRTCV0_CRTCV_FLOW_CONTROL_BASE_IDX                                                           2
#define mmCRTCV0_CRTCV_STEREO_FORCE_NEXT_EYE                                                           0x1301
#define mmCRTCV0_CRTCV_STEREO_FORCE_NEXT_EYE_BASE_IDX                                                  2
#define mmCRTCV0_CRTCV_AVSYNC_COUNTER                                                                  0x1302
#define mmCRTCV0_CRTCV_AVSYNC_COUNTER_BASE_IDX                                                         2
#define mmCRTCV0_CRTCV_CONTROL                                                                         0x1303
#define mmCRTCV0_CRTCV_CONTROL_BASE_IDX                                                                2
#define mmCRTCV0_CRTCV_BLANK_CONTROL                                                                   0x1304
#define mmCRTCV0_CRTCV_BLANK_CONTROL_BASE_IDX                                                          2
#define mmCRTCV0_CRTCV_INTERLACE_CONTROL                                                               0x1305
#define mmCRTCV0_CRTCV_INTERLACE_CONTROL_BASE_IDX                                                      2
#define mmCRTCV0_CRTCV_INTERLACE_STATUS                                                                0x1306
#define mmCRTCV0_CRTCV_INTERLACE_STATUS_BASE_IDX                                                       2
#define mmCRTCV0_CRTCV_FIELD_INDICATION_CONTROL                                                        0x1307
#define mmCRTCV0_CRTCV_FIELD_INDICATION_CONTROL_BASE_IDX                                               2
#define mmCRTCV0_CRTCV_PIXEL_DATA_READBACK0                                                            0x1308
#define mmCRTCV0_CRTCV_PIXEL_DATA_READBACK0_BASE_IDX                                                   2
#define mmCRTCV0_CRTCV_PIXEL_DATA_READBACK1                                                            0x1309
#define mmCRTCV0_CRTCV_PIXEL_DATA_READBACK1_BASE_IDX                                                   2
#define mmCRTCV0_CRTCV_STATUS                                                                          0x130a
#define mmCRTCV0_CRTCV_STATUS_BASE_IDX                                                                 2
#define mmCRTCV0_CRTCV_STATUS_POSITION                                                                 0x130b
#define mmCRTCV0_CRTCV_STATUS_POSITION_BASE_IDX                                                        2
#define mmCRTCV0_CRTCV_NOM_VERT_POSITION                                                               0x130c
#define mmCRTCV0_CRTCV_NOM_VERT_POSITION_BASE_IDX                                                      2
#define mmCRTCV0_CRTCV_STATUS_FRAME_COUNT                                                              0x130d
#define mmCRTCV0_CRTCV_STATUS_FRAME_COUNT_BASE_IDX                                                     2
#define mmCRTCV0_CRTCV_STATUS_VF_COUNT                                                                 0x130e
#define mmCRTCV0_CRTCV_STATUS_VF_COUNT_BASE_IDX                                                        2
#define mmCRTCV0_CRTCV_STATUS_HV_COUNT                                                                 0x130f
#define mmCRTCV0_CRTCV_STATUS_HV_COUNT_BASE_IDX                                                        2
#define mmCRTCV0_CRTCV_COUNT_CONTROL                                                                   0x1310
#define mmCRTCV0_CRTCV_COUNT_CONTROL_BASE_IDX                                                          2
#define mmCRTCV0_CRTCV_COUNT_RESET                                                                     0x1311
#define mmCRTCV0_CRTCV_COUNT_RESET_BASE_IDX                                                            2
#define mmCRTCV0_CRTCV_MANUAL_FORCE_VSYNC_NEXT_LINE                                                    0x1312
#define mmCRTCV0_CRTCV_MANUAL_FORCE_VSYNC_NEXT_LINE_BASE_IDX                                           2
#define mmCRTCV0_CRTCV_VERT_SYNC_CONTROL                                                               0x1313
#define mmCRTCV0_CRTCV_VERT_SYNC_CONTROL_BASE_IDX                                                      2
#define mmCRTCV0_CRTCV_STEREO_STATUS                                                                   0x1314
#define mmCRTCV0_CRTCV_STEREO_STATUS_BASE_IDX                                                          2
#define mmCRTCV0_CRTCV_STEREO_CONTROL                                                                  0x1315
#define mmCRTCV0_CRTCV_STEREO_CONTROL_BASE_IDX                                                         2
#define mmCRTCV0_CRTCV_SNAPSHOT_STATUS                                                                 0x1316
#define mmCRTCV0_CRTCV_SNAPSHOT_STATUS_BASE_IDX                                                        2
#define mmCRTCV0_CRTCV_SNAPSHOT_CONTROL                                                                0x1317
#define mmCRTCV0_CRTCV_SNAPSHOT_CONTROL_BASE_IDX                                                       2
#define mmCRTCV0_CRTCV_SNAPSHOT_POSITION                                                               0x1318
#define mmCRTCV0_CRTCV_SNAPSHOT_POSITION_BASE_IDX                                                      2
#define mmCRTCV0_CRTCV_SNAPSHOT_FRAME                                                                  0x1319
#define mmCRTCV0_CRTCV_SNAPSHOT_FRAME_BASE_IDX                                                         2
#define mmCRTCV0_CRTCV_START_LINE_CONTROL                                                              0x131a
#define mmCRTCV0_CRTCV_START_LINE_CONTROL_BASE_IDX                                                     2
#define mmCRTCV0_CRTCV_INTERRUPT_CONTROL                                                               0x131b
#define mmCRTCV0_CRTCV_INTERRUPT_CONTROL_BASE_IDX                                                      2
#define mmCRTCV0_CRTCV_UPDATE_LOCK                                                                     0x131c
#define mmCRTCV0_CRTCV_UPDATE_LOCK_BASE_IDX                                                            2
#define mmCRTCV0_CRTCV_DOUBLE_BUFFER_CONTROL                                                           0x131d
#define mmCRTCV0_CRTCV_DOUBLE_BUFFER_CONTROL_BASE_IDX                                                  2
#define mmCRTCV0_CRTCV_VGA_PARAMETER_CAPTURE_MODE                                                      0x131e
#define mmCRTCV0_CRTCV_VGA_PARAMETER_CAPTURE_MODE_BASE_IDX                                             2
#define mmCRTCV0_CRTCV_TEST_PATTERN_CONTROL                                                            0x131f
#define mmCRTCV0_CRTCV_TEST_PATTERN_CONTROL_BASE_IDX                                                   2
#define mmCRTCV0_CRTCV_TEST_PATTERN_PARAMETERS                                                         0x1320
#define mmCRTCV0_CRTCV_TEST_PATTERN_PARAMETERS_BASE_IDX                                                2
#define mmCRTCV0_CRTCV_TEST_PATTERN_COLOR                                                              0x1321
#define mmCRTCV0_CRTCV_TEST_PATTERN_COLOR_BASE_IDX                                                     2
#define mmCRTCV0_CRTCV_MASTER_UPDATE_LOCK                                                              0x1322
#define mmCRTCV0_CRTCV_MASTER_UPDATE_LOCK_BASE_IDX                                                     2
#define mmCRTCV0_CRTCV_MASTER_UPDATE_MODE                                                              0x1323
#define mmCRTCV0_CRTCV_MASTER_UPDATE_MODE_BASE_IDX                                                     2
#define mmCRTCV0_CRTCV_MVP_INBAND_CNTL_INSERT                                                          0x1324
#define mmCRTCV0_CRTCV_MVP_INBAND_CNTL_INSERT_BASE_IDX                                                 2
#define mmCRTCV0_CRTCV_MVP_INBAND_CNTL_INSERT_TIMER                                                    0x1325
#define mmCRTCV0_CRTCV_MVP_INBAND_CNTL_INSERT_TIMER_BASE_IDX                                           2
#define mmCRTCV0_CRTCV_MVP_STATUS                                                                      0x1326
#define mmCRTCV0_CRTCV_MVP_STATUS_BASE_IDX                                                             2
#define mmCRTCV0_CRTCV_MASTER_EN                                                                       0x1327
#define mmCRTCV0_CRTCV_MASTER_EN_BASE_IDX                                                              2
#define mmCRTCV0_CRTCV_ALLOW_STOP_OFF_V_CNT                                                            0x1328
#define mmCRTCV0_CRTCV_ALLOW_STOP_OFF_V_CNT_BASE_IDX                                                   2
#define mmCRTCV0_CRTCV_V_UPDATE_INT_STATUS                                                             0x1329
#define mmCRTCV0_CRTCV_V_UPDATE_INT_STATUS_BASE_IDX                                                    2
#define mmCRTCV0_CRTCV_OVERSCAN_COLOR                                                                  0x132b
#define mmCRTCV0_CRTCV_OVERSCAN_COLOR_BASE_IDX                                                         2
#define mmCRTCV0_CRTCV_OVERSCAN_COLOR_EXT                                                              0x132c
#define mmCRTCV0_CRTCV_OVERSCAN_COLOR_EXT_BASE_IDX                                                     2
#define mmCRTCV0_CRTCV_BLANK_DATA_COLOR                                                                0x132d
#define mmCRTCV0_CRTCV_BLANK_DATA_COLOR_BASE_IDX                                                       2
#define mmCRTCV0_CRTCV_BLANK_DATA_COLOR_EXT                                                            0x132e
#define mmCRTCV0_CRTCV_BLANK_DATA_COLOR_EXT_BASE_IDX                                                   2
#define mmCRTCV0_CRTCV_BLACK_COLOR                                                                     0x132f
#define mmCRTCV0_CRTCV_BLACK_COLOR_BASE_IDX                                                            2
#define mmCRTCV0_CRTCV_BLACK_COLOR_EXT                                                                 0x1330
#define mmCRTCV0_CRTCV_BLACK_COLOR_EXT_BASE_IDX                                                        2
#define mmCRTCV0_CRTCV_VERTICAL_INTERRUPT0_POSITION                                                    0x1331
#define mmCRTCV0_CRTCV_VERTICAL_INTERRUPT0_POSITION_BASE_IDX                                           2
#define mmCRTCV0_CRTCV_VERTICAL_INTERRUPT0_CONTROL                                                     0x1332
#define mmCRTCV0_CRTCV_VERTICAL_INTERRUPT0_CONTROL_BASE_IDX                                            2
#define mmCRTCV0_CRTCV_VERTICAL_INTERRUPT1_POSITION                                                    0x1333
#define mmCRTCV0_CRTCV_VERTICAL_INTERRUPT1_POSITION_BASE_IDX                                           2
#define mmCRTCV0_CRTCV_VERTICAL_INTERRUPT1_CONTROL                                                     0x1334
#define mmCRTCV0_CRTCV_VERTICAL_INTERRUPT1_CONTROL_BASE_IDX                                            2
#define mmCRTCV0_CRTCV_VERTICAL_INTERRUPT2_POSITION                                                    0x1335
#define mmCRTCV0_CRTCV_VERTICAL_INTERRUPT2_POSITION_BASE_IDX                                           2
#define mmCRTCV0_CRTCV_VERTICAL_INTERRUPT2_CONTROL                                                     0x1336
#define mmCRTCV0_CRTCV_VERTICAL_INTERRUPT2_CONTROL_BASE_IDX                                            2
#define mmCRTCV0_CRTCV_CRC_CNTL                                                                        0x1337
#define mmCRTCV0_CRTCV_CRC_CNTL_BASE_IDX                                                               2
#define mmCRTCV0_CRTCV_CRC0_WINDOWA_X_CONTROL                                                          0x1338
#define mmCRTCV0_CRTCV_CRC0_WINDOWA_X_CONTROL_BASE_IDX                                                 2
#define mmCRTCV0_CRTCV_CRC0_WINDOWA_Y_CONTROL                                                          0x1339
#define mmCRTCV0_CRTCV_CRC0_WINDOWA_Y_CONTROL_BASE_IDX                                                 2
#define mmCRTCV0_CRTCV_CRC0_WINDOWB_X_CONTROL                                                          0x133a
#define mmCRTCV0_CRTCV_CRC0_WINDOWB_X_CONTROL_BASE_IDX                                                 2
#define mmCRTCV0_CRTCV_CRC0_WINDOWB_Y_CONTROL                                                          0x133b
#define mmCRTCV0_CRTCV_CRC0_WINDOWB_Y_CONTROL_BASE_IDX                                                 2
#define mmCRTCV0_CRTCV_CRC0_DATA_RG                                                                    0x133c
#define mmCRTCV0_CRTCV_CRC0_DATA_RG_BASE_IDX                                                           2
#define mmCRTCV0_CRTCV_CRC0_DATA_B                                                                     0x133d
#define mmCRTCV0_CRTCV_CRC0_DATA_B_BASE_IDX                                                            2
#define mmCRTCV0_CRTCV_CRC1_WINDOWA_X_CONTROL                                                          0x133e
#define mmCRTCV0_CRTCV_CRC1_WINDOWA_X_CONTROL_BASE_IDX                                                 2
#define mmCRTCV0_CRTCV_CRC1_WINDOWA_Y_CONTROL                                                          0x133f
#define mmCRTCV0_CRTCV_CRC1_WINDOWA_Y_CONTROL_BASE_IDX                                                 2
#define mmCRTCV0_CRTCV_CRC1_WINDOWB_X_CONTROL                                                          0x1340
#define mmCRTCV0_CRTCV_CRC1_WINDOWB_X_CONTROL_BASE_IDX                                                 2
#define mmCRTCV0_CRTCV_CRC1_WINDOWB_Y_CONTROL                                                          0x1341
#define mmCRTCV0_CRTCV_CRC1_WINDOWB_Y_CONTROL_BASE_IDX                                                 2
#define mmCRTCV0_CRTCV_CRC1_DATA_RG                                                                    0x1342
#define mmCRTCV0_CRTCV_CRC1_DATA_RG_BASE_IDX                                                           2
#define mmCRTCV0_CRTCV_CRC1_DATA_B                                                                     0x1343
#define mmCRTCV0_CRTCV_CRC1_DATA_B_BASE_IDX                                                            2
#define mmCRTCV0_CRTCV_EXT_TIMING_SYNC_CONTROL                                                         0x1344
#define mmCRTCV0_CRTCV_EXT_TIMING_SYNC_CONTROL_BASE_IDX                                                2
#define mmCRTCV0_CRTCV_EXT_TIMING_SYNC_WINDOW_START                                                    0x1345
#define mmCRTCV0_CRTCV_EXT_TIMING_SYNC_WINDOW_START_BASE_IDX                                           2
#define mmCRTCV0_CRTCV_EXT_TIMING_SYNC_WINDOW_END                                                      0x1346
#define mmCRTCV0_CRTCV_EXT_TIMING_SYNC_WINDOW_END_BASE_IDX                                             2
#define mmCRTCV0_CRTCV_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL                                          0x1347
#define mmCRTCV0_CRTCV_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_BASE_IDX                                 2
#define mmCRTCV0_CRTCV_EXT_TIMING_SYNC_INTERRUPT_CONTROL                                               0x1348
#define mmCRTCV0_CRTCV_EXT_TIMING_SYNC_INTERRUPT_CONTROL_BASE_IDX                                      2
#define mmCRTCV0_CRTCV_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL                                        0x1349
#define mmCRTCV0_CRTCV_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL_BASE_IDX                               2
#define mmCRTCV0_CRTCV_STATIC_SCREEN_CONTROL                                                           0x134a
#define mmCRTCV0_CRTCV_STATIC_SCREEN_CONTROL_BASE_IDX                                                  2
#define mmCRTCV0_CRTCV_3D_STRUCTURE_CONTROL                                                            0x134b
#define mmCRTCV0_CRTCV_3D_STRUCTURE_CONTROL_BASE_IDX                                                   2
#define mmCRTCV0_CRTCV_GSL_VSYNC_GAP                                                                   0x134c
#define mmCRTCV0_CRTCV_GSL_VSYNC_GAP_BASE_IDX                                                          2
#define mmCRTCV0_CRTCV_GSL_WINDOW                                                                      0x134d
#define mmCRTCV0_CRTCV_GSL_WINDOW_BASE_IDX                                                             2
#define mmCRTCV0_CRTCV_GSL_CONTROL                                                                     0x134e
#define mmCRTCV0_CRTCV_GSL_CONTROL_BASE_IDX                                                            2


// addressBlock: dce_dc_unp1_dispdec
// base address: 0x800
#define mmUNP1_UNP_GRPH_ENABLE                                                                         0x135a
#define mmUNP1_UNP_GRPH_ENABLE_BASE_IDX                                                                2
#define mmUNP1_UNP_GRPH_CONTROL                                                                        0x135b
#define mmUNP1_UNP_GRPH_CONTROL_BASE_IDX                                                               2
#define mmUNP1_UNP_GRPH_CONTROL_C                                                                      0x135c
#define mmUNP1_UNP_GRPH_CONTROL_C_BASE_IDX                                                             2
#define mmUNP1_UNP_GRPH_CONTROL_EXP                                                                    0x135d
#define mmUNP1_UNP_GRPH_CONTROL_EXP_BASE_IDX                                                           2
#define mmUNP1_UNP_GRPH_SWAP_CNTL                                                                      0x135e
#define mmUNP1_UNP_GRPH_SWAP_CNTL_BASE_IDX                                                             2
#define mmUNP1_UNP_GRPH_PRIMARY_SURFACE_ADDRESS_L                                                      0x135f
#define mmUNP1_UNP_GRPH_PRIMARY_SURFACE_ADDRESS_L_BASE_IDX                                             2
#define mmUNP1_UNP_GRPH_PRIMARY_SURFACE_ADDRESS_C                                                      0x1360
#define mmUNP1_UNP_GRPH_PRIMARY_SURFACE_ADDRESS_C_BASE_IDX                                             2
#define mmUNP1_UNP_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH_L                                                 0x1361
#define mmUNP1_UNP_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH_L_BASE_IDX                                        2
#define mmUNP1_UNP_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH_C                                                 0x1362
#define mmUNP1_UNP_GRPH_PRIMARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                        2
#define mmUNP1_UNP_GRPH_PRIMARY_BOTTOM_SURFACE_ADDRESS_L                                               0x1363
#define mmUNP1_UNP_GRPH_PRIMARY_BOTTOM_SURFACE_ADDRESS_L_BASE_IDX                                      2
#define mmUNP1_UNP_GRPH_PRIMARY_BOTTOM_SURFACE_ADDRESS_C                                               0x1364
#define mmUNP1_UNP_GRPH_PRIMARY_BOTTOM_SURFACE_ADDRESS_C_BASE_IDX                                      2
#define mmUNP1_UNP_GRPH_PRIMARY_BOTTOM_SURFACE_ADDRESS_HIGH_L                                          0x1365
#define mmUNP1_UNP_GRPH_PRIMARY_BOTTOM_SURFACE_ADDRESS_HIGH_L_BASE_IDX                                 2
#define mmUNP1_UNP_GRPH_PRIMARY_BOTTOM_SURFACE_ADDRESS_HIGH_C                                          0x1366
#define mmUNP1_UNP_GRPH_PRIMARY_BOTTOM_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                 2
#define mmUNP1_UNP_GRPH_SECONDARY_SURFACE_ADDRESS_L                                                    0x1367
#define mmUNP1_UNP_GRPH_SECONDARY_SURFACE_ADDRESS_L_BASE_IDX                                           2
#define mmUNP1_UNP_GRPH_SECONDARY_SURFACE_ADDRESS_C                                                    0x1368
#define mmUNP1_UNP_GRPH_SECONDARY_SURFACE_ADDRESS_C_BASE_IDX                                           2
#define mmUNP1_UNP_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH_L                                               0x1369
#define mmUNP1_UNP_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH_L_BASE_IDX                                      2
#define mmUNP1_UNP_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH_C                                               0x136a
#define mmUNP1_UNP_GRPH_SECONDARY_SURFACE_ADDRESS_HIGH_C_BASE_IDX                                      2
#define mmUNP1_UNP_GRPH_SECONDARY_BOTTOM_SURFACE_ADDRESS_L                                             0x136b
#define mmUNP1_UNP_GRPH_SECONDARY_BOTTOM_SURFACE_ADDRESS_L_BASE_IDX                                    2
#define mmUNP1_UNP_GRPH_SECONDARY_BOTTOM_SURFACE_ADDRESS_C                                             0x136c
#define mmUNP1_UNP_GRPH_SECONDARY_BOTTOM_SURFACE_ADDRESS_C_BASE_IDX                                    2
#define mmUNP1_UNP_GRPH_SECONDARY_BOTTOM_SURFACE_ADDRESS_HIGH_L                                        0x136d
#define mmUNP1_UNP_GRPH_SECONDARY_BOTTOM_SURFACE_ADDRESS_HIGH_L_BASE_IDX                               2
#define mmUNP1_UNP_GRPH_SECONDARY_BOTTOM_SURFACE_ADDRESS_HIGH_C                                        0x136e
#define mmUNP1_UNP_GRPH_SECONDARY_BOTTOM_SURFACE_ADDRESS_HIGH_C_BASE_IDX                               2
#define mmUNP1_UNP_GRPH_PITCH_L                                                                        0x136f
#define mmUNP1_UNP_GRPH_PITCH_L_BASE_IDX                                                               2
#define mmUNP1_UNP_GRPH_PITCH_C                                                                        0x1370
#define mmUNP1_UNP_GRPH_PITCH_C_BASE_IDX                                                               2
#define mmUNP1_UNP_GRPH_SURFACE_OFFSET_X_L                                                             0x1371
#define mmUNP1_UNP_GRPH_SURFACE_OFFSET_X_L_BASE_IDX                                                    2
#define mmUNP1_UNP_GRPH_SURFACE_OFFSET_X_C                                                             0x1372
#define mmUNP1_UNP_GRPH_SURFACE_OFFSET_X_C_BASE_IDX                                                    2
#define mmUNP1_UNP_GRPH_SURFACE_OFFSET_Y_L                                                             0x1373
#define mmUNP1_UNP_GRPH_SURFACE_OFFSET_Y_L_BASE_IDX                                                    2
#define mmUNP1_UNP_GRPH_SURFACE_OFFSET_Y_C                                                             0x1374
#define mmUNP1_UNP_GRPH_SURFACE_OFFSET_Y_C_BASE_IDX                                                    2
#define mmUNP1_UNP_GRPH_X_START_L                                                                      0x1375
#define mmUNP1_UNP_GRPH_X_START_L_BASE_IDX                                                             2
#define mmUNP1_UNP_GRPH_X_START_C                                                                      0x1376
#define mmUNP1_UNP_GRPH_X_START_C_BASE_IDX                                                             2
#define mmUNP1_UNP_GRPH_Y_START_L                                                                      0x1377
#define mmUNP1_UNP_GRPH_Y_START_L_BASE_IDX                                                             2
#define mmUNP1_UNP_GRPH_Y_START_C                                                                      0x1378
#define mmUNP1_UNP_GRPH_Y_START_C_BASE_IDX                                                             2
#define mmUNP1_UNP_GRPH_X_END_L                                                                        0x1379
#define mmUNP1_UNP_GRPH_X_END_L_BASE_IDX                                                               2
#define mmUNP1_UNP_GRPH_X_END_C                                                                        0x137a
#define mmUNP1_UNP_GRPH_X_END_C_BASE_IDX                                                               2
#define mmUNP1_UNP_GRPH_Y_END_L                                                                        0x137b
#define mmUNP1_UNP_GRPH_Y_END_L_BASE_IDX                                                               2
#define mmUNP1_UNP_GRPH_Y_END_C                                                                        0x137c
#define mmUNP1_UNP_GRPH_Y_END_C_BASE_IDX                                                               2
#define mmUNP1_UNP_GRPH_UPDATE                                                                         0x137d
#define mmUNP1_UNP_GRPH_UPDATE_BASE_IDX                                                                2
#define mmUNP1_UNP_PIPE_OUTSTANDING_REQUEST_LIMIT                                                      0x137e
#define mmUNP1_UNP_PIPE_OUTSTANDING_REQUEST_LIMIT_BASE_IDX                                             2
#define mmUNP1_UNP_GRPH_SURFACE_ADDRESS_INUSE_L                                                        0x137f
#define mmUNP1_UNP_GRPH_SURFACE_ADDRESS_INUSE_L_BASE_IDX                                               2
#define mmUNP1_UNP_GRPH_SURFACE_ADDRESS_INUSE_C                                                        0x1380
#define mmUNP1_UNP_GRPH_SURFACE_ADDRESS_INUSE_C_BASE_IDX                                               2
#define mmUNP1_UNP_GRPH_SURFACE_ADDRESS_HIGH_INUSE_L                                                   0x1381
#define mmUNP1_UNP_GRPH_SURFACE_ADDRESS_HIGH_INUSE_L_BASE_IDX                                          2
#define mmUNP1_UNP_GRPH_SURFACE_ADDRESS_HIGH_INUSE_C                                                   0x1382
#define mmUNP1_UNP_GRPH_SURFACE_ADDRESS_HIGH_INUSE_C_BASE_IDX                                          2
#define mmUNP1_UNP_DVMM_PTE_CONTROL                                                                    0x1383
#define mmUNP1_UNP_DVMM_PTE_CONTROL_BASE_IDX                                                           2
#define mmUNP1_UNP_DVMM_PTE_CONTROL_C                                                                  0x1384
#define mmUNP1_UNP_DVMM_PTE_CONTROL_C_BASE_IDX                                                         2
#define mmUNP1_UNP_DVMM_PTE_ARB_CONTROL                                                                0x1385
#define mmUNP1_UNP_DVMM_PTE_ARB_CONTROL_BASE_IDX                                                       2
#define mmUNP1_UNP_DVMM_PTE_ARB_CONTROL_C                                                              0x1386
#define mmUNP1_UNP_DVMM_PTE_ARB_CONTROL_C_BASE_IDX                                                     2
#define mmUNP1_UNP_GRPH_INTERRUPT_STATUS                                                               0x1387
#define mmUNP1_UNP_GRPH_INTERRUPT_STATUS_BASE_IDX                                                      2
#define mmUNP1_UNP_GRPH_INTERRUPT_CONTROL                                                              0x1388
#define mmUNP1_UNP_GRPH_INTERRUPT_CONTROL_BASE_IDX                                                     2
#define mmUNP1_UNP_GRPH_STEREOSYNC_FLIP                                                                0x1389
#define mmUNP1_UNP_GRPH_STEREOSYNC_FLIP_BASE_IDX                                                       2
#define mmUNP1_UNP_FLIP_CONTROL                                                                        0x138a
#define mmUNP1_UNP_FLIP_CONTROL_BASE_IDX                                                               2
#define mmUNP1_UNP_CRC_CONTROL                                                                         0x138b
#define mmUNP1_UNP_CRC_CONTROL_BASE_IDX                                                                2
#define mmUNP1_UNP_CRC_MASK                                                                            0x138c
#define mmUNP1_UNP_CRC_MASK_BASE_IDX                                                                   2
#define mmUNP1_UNP_CRC_CURRENT                                                                         0x138d
#define mmUNP1_UNP_CRC_CURRENT_BASE_IDX                                                                2
#define mmUNP1_UNP_CRC_LAST                                                                            0x138e
#define mmUNP1_UNP_CRC_LAST_BASE_IDX                                                                   2
#define mmUNP1_UNP_LB_DATA_GAP_BETWEEN_CHUNK                                                           0x138f
#define mmUNP1_UNP_LB_DATA_GAP_BETWEEN_CHUNK_BASE_IDX                                                  2
#define mmUNP1_UNP_HW_ROTATION                                                                         0x1390
#define mmUNP1_UNP_HW_ROTATION_BASE_IDX                                                                2


// addressBlock: dce_dc_lbv1_dispdec
// base address: 0x800
#define mmLBV1_LBV_DATA_FORMAT                                                                         0x1396
#define mmLBV1_LBV_DATA_FORMAT_BASE_IDX                                                                2
#define mmLBV1_LBV_MEMORY_CTRL                                                                         0x1397
#define mmLBV1_LBV_MEMORY_CTRL_BASE_IDX                                                                2
#define mmLBV1_LBV_MEMORY_SIZE_STATUS                                                                  0x1398
#define mmLBV1_LBV_MEMORY_SIZE_STATUS_BASE_IDX                                                         2
#define mmLBV1_LBV_DESKTOP_HEIGHT                                                                      0x1399
#define mmLBV1_LBV_DESKTOP_HEIGHT_BASE_IDX                                                             2
#define mmLBV1_LBV_VLINE_START_END                                                                     0x139a
#define mmLBV1_LBV_VLINE_START_END_BASE_IDX                                                            2
#define mmLBV1_LBV_VLINE2_START_END                                                                    0x139b
#define mmLBV1_LBV_VLINE2_START_END_BASE_IDX                                                           2
#define mmLBV1_LBV_V_COUNTER                                                                           0x139c
#define mmLBV1_LBV_V_COUNTER_BASE_IDX                                                                  2
#define mmLBV1_LBV_SNAPSHOT_V_COUNTER                                                                  0x139d
#define mmLBV1_LBV_SNAPSHOT_V_COUNTER_BASE_IDX                                                         2
#define mmLBV1_LBV_V_COUNTER_CHROMA                                                                    0x139e
#define mmLBV1_LBV_V_COUNTER_CHROMA_BASE_IDX                                                           2
#define mmLBV1_LBV_SNAPSHOT_V_COUNTER_CHROMA                                                           0x139f
#define mmLBV1_LBV_SNAPSHOT_V_COUNTER_CHROMA_BASE_IDX                                                  2
#define mmLBV1_LBV_INTERRUPT_MASK                                                                      0x13a0
#define mmLBV1_LBV_INTERRUPT_MASK_BASE_IDX                                                             2
#define mmLBV1_LBV_VLINE_STATUS                                                                        0x13a1
#define mmLBV1_LBV_VLINE_STATUS_BASE_IDX                                                               2
#define mmLBV1_LBV_VLINE2_STATUS                                                                       0x13a2
#define mmLBV1_LBV_VLINE2_STATUS_BASE_IDX                                                              2
#define mmLBV1_LBV_VBLANK_STATUS                                                                       0x13a3
#define mmLBV1_LBV_VBLANK_STATUS_BASE_IDX                                                              2
#define mmLBV1_LBV_SYNC_RESET_SEL                                                                      0x13a4
#define mmLBV1_LBV_SYNC_RESET_SEL_BASE_IDX                                                             2
#define mmLBV1_LBV_BLACK_KEYER_R_CR                                                                    0x13a5
#define mmLBV1_LBV_BLACK_KEYER_R_CR_BASE_IDX                                                           2
#define mmLBV1_LBV_BLACK_KEYER_G_Y                                                                     0x13a6
#define mmLBV1_LBV_BLACK_KEYER_G_Y_BASE_IDX                                                            2
#define mmLBV1_LBV_BLACK_KEYER_B_CB                                                                    0x13a7
#define mmLBV1_LBV_BLACK_KEYER_B_CB_BASE_IDX                                                           2
#define mmLBV1_LBV_KEYER_COLOR_CTRL                                                                    0x13a8
#define mmLBV1_LBV_KEYER_COLOR_CTRL_BASE_IDX                                                           2
#define mmLBV1_LBV_KEYER_COLOR_R_CR                                                                    0x13a9
#define mmLBV1_LBV_KEYER_COLOR_R_CR_BASE_IDX                                                           2
#define mmLBV1_LBV_KEYER_COLOR_G_Y                                                                     0x13aa
#define mmLBV1_LBV_KEYER_COLOR_G_Y_BASE_IDX                                                            2
#define mmLBV1_LBV_KEYER_COLOR_B_CB                                                                    0x13ab
#define mmLBV1_LBV_KEYER_COLOR_B_CB_BASE_IDX                                                           2
#define mmLBV1_LBV_KEYER_COLOR_REP_R_CR                                                                0x13ac
#define mmLBV1_LBV_KEYER_COLOR_REP_R_CR_BASE_IDX                                                       2
#define mmLBV1_LBV_KEYER_COLOR_REP_G_Y                                                                 0x13ad
#define mmLBV1_LBV_KEYER_COLOR_REP_G_Y_BASE_IDX                                                        2
#define mmLBV1_LBV_KEYER_COLOR_REP_B_CB                                                                0x13ae
#define mmLBV1_LBV_KEYER_COLOR_REP_B_CB_BASE_IDX                                                       2
#define mmLBV1_LBV_BUFFER_LEVEL_STATUS                                                                 0x13af
#define mmLBV1_LBV_BUFFER_LEVEL_STATUS_BASE_IDX                                                        2
#define mmLBV1_LBV_BUFFER_URGENCY_CTRL                                                                 0x13b0
#define mmLBV1_LBV_BUFFER_URGENCY_CTRL_BASE_IDX                                                        2
#define mmLBV1_LBV_BUFFER_URGENCY_STATUS                                                               0x13b1
#define mmLBV1_LBV_BUFFER_URGENCY_STATUS_BASE_IDX                                                      2
#define mmLBV1_LBV_BUFFER_STATUS                                                                       0x13b2
#define mmLBV1_LBV_BUFFER_STATUS_BASE_IDX                                                              2
#define mmLBV1_LBV_NO_OUTSTANDING_REQ_STATUS                                                           0x13b3
#define mmLBV1_LBV_NO_OUTSTANDING_REQ_STATUS_BASE_IDX                                                  2


// addressBlock: dce_dc_sclv1_dispdec
// base address: 0x800
#define mmSCLV1_SCLV_COEF_RAM_SELECT                                                                   0x13ca
#define mmSCLV1_SCLV_COEF_RAM_SELECT_BASE_IDX                                                          2
#define mmSCLV1_SCLV_COEF_RAM_TAP_DATA                                                                 0x13cb
#define mmSCLV1_SCLV_COEF_RAM_TAP_DATA_BASE_IDX                                                        2
#define mmSCLV1_SCLV_MODE                                                                              0x13cc
#define mmSCLV1_SCLV_MODE_BASE_IDX                                                                     2
#define mmSCLV1_SCLV_TAP_CONTROL                                                                       0x13cd
#define mmSCLV1_SCLV_TAP_CONTROL_BASE_IDX                                                              2
#define mmSCLV1_SCLV_CONTROL                                                                           0x13ce
#define mmSCLV1_SCLV_CONTROL_BASE_IDX                                                                  2
#define mmSCLV1_SCLV_MANUAL_REPLICATE_CONTROL                                                          0x13cf
#define mmSCLV1_SCLV_MANUAL_REPLICATE_CONTROL_BASE_IDX                                                 2
#define mmSCLV1_SCLV_AUTOMATIC_MODE_CONTROL                                                            0x13d0
#define mmSCLV1_SCLV_AUTOMATIC_MODE_CONTROL_BASE_IDX                                                   2
#define mmSCLV1_SCLV_HORZ_FILTER_CONTROL                                                               0x13d1
#define mmSCLV1_SCLV_HORZ_FILTER_CONTROL_BASE_IDX                                                      2
#define mmSCLV1_SCLV_HORZ_FILTER_SCALE_RATIO                                                           0x13d2
#define mmSCLV1_SCLV_HORZ_FILTER_SCALE_RATIO_BASE_IDX                                                  2
#define mmSCLV1_SCLV_HORZ_FILTER_INIT                                                                  0x13d3
#define mmSCLV1_SCLV_HORZ_FILTER_INIT_BASE_IDX                                                         2
#define mmSCLV1_SCLV_HORZ_FILTER_SCALE_RATIO_C                                                         0x13d4
#define mmSCLV1_SCLV_HORZ_FILTER_SCALE_RATIO_C_BASE_IDX                                                2
#define mmSCLV1_SCLV_HORZ_FILTER_INIT_C                                                                0x13d5
#define mmSCLV1_SCLV_HORZ_FILTER_INIT_C_BASE_IDX                                                       2
#define mmSCLV1_SCLV_VERT_FILTER_CONTROL                                                               0x13d6
#define mmSCLV1_SCLV_VERT_FILTER_CONTROL_BASE_IDX                                                      2
#define mmSCLV1_SCLV_VERT_FILTER_SCALE_RATIO                                                           0x13d7
#define mmSCLV1_SCLV_VERT_FILTER_SCALE_RATIO_BASE_IDX                                                  2
#define mmSCLV1_SCLV_VERT_FILTER_INIT                                                                  0x13d8
#define mmSCLV1_SCLV_VERT_FILTER_INIT_BASE_IDX                                                         2
#define mmSCLV1_SCLV_VERT_FILTER_INIT_BOT                                                              0x13d9
#define mmSCLV1_SCLV_VERT_FILTER_INIT_BOT_BASE_IDX                                                     2
#define mmSCLV1_SCLV_VERT_FILTER_SCALE_RATIO_C                                                         0x13da
#define mmSCLV1_SCLV_VERT_FILTER_SCALE_RATIO_C_BASE_IDX                                                2
#define mmSCLV1_SCLV_VERT_FILTER_INIT_C                                                                0x13db
#define mmSCLV1_SCLV_VERT_FILTER_INIT_C_BASE_IDX                                                       2
#define mmSCLV1_SCLV_VERT_FILTER_INIT_BOT_C                                                            0x13dc
#define mmSCLV1_SCLV_VERT_FILTER_INIT_BOT_C_BASE_IDX                                                   2
#define mmSCLV1_SCLV_ROUND_OFFSET                                                                      0x13dd
#define mmSCLV1_SCLV_ROUND_OFFSET_BASE_IDX                                                             2
#define mmSCLV1_SCLV_UPDATE                                                                            0x13de
#define mmSCLV1_SCLV_UPDATE_BASE_IDX                                                                   2
#define mmSCLV1_SCLV_ALU_CONTROL                                                                       0x13df
#define mmSCLV1_SCLV_ALU_CONTROL_BASE_IDX                                                              2
#define mmSCLV1_SCLV_VIEWPORT_START                                                                    0x13e0
#define mmSCLV1_SCLV_VIEWPORT_START_BASE_IDX                                                           2
#define mmSCLV1_SCLV_VIEWPORT_START_SECONDARY                                                          0x13e1
#define mmSCLV1_SCLV_VIEWPORT_START_SECONDARY_BASE_IDX                                                 2
#define mmSCLV1_SCLV_VIEWPORT_SIZE                                                                     0x13e2
#define mmSCLV1_SCLV_VIEWPORT_SIZE_BASE_IDX                                                            2
#define mmSCLV1_SCLV_VIEWPORT_START_C                                                                  0x13e3
#define mmSCLV1_SCLV_VIEWPORT_START_C_BASE_IDX                                                         2
#define mmSCLV1_SCLV_VIEWPORT_START_SECONDARY_C                                                        0x13e4
#define mmSCLV1_SCLV_VIEWPORT_START_SECONDARY_C_BASE_IDX                                               2
#define mmSCLV1_SCLV_VIEWPORT_SIZE_C                                                                   0x13e5
#define mmSCLV1_SCLV_VIEWPORT_SIZE_C_BASE_IDX                                                          2
#define mmSCLV1_SCLV_EXT_OVERSCAN_LEFT_RIGHT                                                           0x13e6
#define mmSCLV1_SCLV_EXT_OVERSCAN_LEFT_RIGHT_BASE_IDX                                                  2
#define mmSCLV1_SCLV_EXT_OVERSCAN_TOP_BOTTOM                                                           0x13e7
#define mmSCLV1_SCLV_EXT_OVERSCAN_TOP_BOTTOM_BASE_IDX                                                  2
#define mmSCLV1_SCLV_MODE_CHANGE_DET1                                                                  0x13e8
#define mmSCLV1_SCLV_MODE_CHANGE_DET1_BASE_IDX                                                         2
#define mmSCLV1_SCLV_MODE_CHANGE_DET2                                                                  0x13e9
#define mmSCLV1_SCLV_MODE_CHANGE_DET2_BASE_IDX                                                         2
#define mmSCLV1_SCLV_MODE_CHANGE_DET3                                                                  0x13ea
#define mmSCLV1_SCLV_MODE_CHANGE_DET3_BASE_IDX                                                         2
#define mmSCLV1_SCLV_MODE_CHANGE_MASK                                                                  0x13eb
#define mmSCLV1_SCLV_MODE_CHANGE_MASK_BASE_IDX                                                         2
#define mmSCLV1_SCLV_HORZ_FILTER_INIT_BOT                                                              0x13ec
#define mmSCLV1_SCLV_HORZ_FILTER_INIT_BOT_BASE_IDX                                                     2
#define mmSCLV1_SCLV_HORZ_FILTER_INIT_BOT_C                                                            0x13ed
#define mmSCLV1_SCLV_HORZ_FILTER_INIT_BOT_C_BASE_IDX                                                   2


// addressBlock: dce_dc_col_man1_dispdec
// base address: 0x800
#define mmCOL_MAN1_COL_MAN_UPDATE                                                                      0x13fe
#define mmCOL_MAN1_COL_MAN_UPDATE_BASE_IDX                                                             2
#define mmCOL_MAN1_COL_MAN_INPUT_CSC_CONTROL                                                           0x13ff
#define mmCOL_MAN1_COL_MAN_INPUT_CSC_CONTROL_BASE_IDX                                                  2
#define mmCOL_MAN1_INPUT_CSC_C11_C12_A                                                                 0x1400
#define mmCOL_MAN1_INPUT_CSC_C11_C12_A_BASE_IDX                                                        2
#define mmCOL_MAN1_INPUT_CSC_C13_C14_A                                                                 0x1401
#define mmCOL_MAN1_INPUT_CSC_C13_C14_A_BASE_IDX                                                        2
#define mmCOL_MAN1_INPUT_CSC_C21_C22_A                                                                 0x1402
#define mmCOL_MAN1_INPUT_CSC_C21_C22_A_BASE_IDX                                                        2
#define mmCOL_MAN1_INPUT_CSC_C23_C24_A                                                                 0x1403
#define mmCOL_MAN1_INPUT_CSC_C23_C24_A_BASE_IDX                                                        2
#define mmCOL_MAN1_INPUT_CSC_C31_C32_A                                                                 0x1404
#define mmCOL_MAN1_INPUT_CSC_C31_C32_A_BASE_IDX                                                        2
#define mmCOL_MAN1_INPUT_CSC_C33_C34_A                                                                 0x1405
#define mmCOL_MAN1_INPUT_CSC_C33_C34_A_BASE_IDX                                                        2
#define mmCOL_MAN1_INPUT_CSC_C11_C12_B                                                                 0x1406
#define mmCOL_MAN1_INPUT_CSC_C11_C12_B_BASE_IDX                                                        2
#define mmCOL_MAN1_INPUT_CSC_C13_C14_B                                                                 0x1407
#define mmCOL_MAN1_INPUT_CSC_C13_C14_B_BASE_IDX                                                        2
#define mmCOL_MAN1_INPUT_CSC_C21_C22_B                                                                 0x1408
#define mmCOL_MAN1_INPUT_CSC_C21_C22_B_BASE_IDX                                                        2
#define mmCOL_MAN1_INPUT_CSC_C23_C24_B                                                                 0x1409
#define mmCOL_MAN1_INPUT_CSC_C23_C24_B_BASE_IDX                                                        2
#define mmCOL_MAN1_INPUT_CSC_C31_C32_B                                                                 0x140a
#define mmCOL_MAN1_INPUT_CSC_C31_C32_B_BASE_IDX                                                        2
#define mmCOL_MAN1_INPUT_CSC_C33_C34_B                                                                 0x140b
#define mmCOL_MAN1_INPUT_CSC_C33_C34_B_BASE_IDX                                                        2
#define mmCOL_MAN1_PRESCALE_CONTROL                                                                    0x140c
#define mmCOL_MAN1_PRESCALE_CONTROL_BASE_IDX                                                           2
#define mmCOL_MAN1_PRESCALE_VALUES_R                                                                   0x140d
#define mmCOL_MAN1_PRESCALE_VALUES_R_BASE_IDX                                                          2
#define mmCOL_MAN1_PRESCALE_VALUES_G                                                                   0x140e
#define mmCOL_MAN1_PRESCALE_VALUES_G_BASE_IDX                                                          2
#define mmCOL_MAN1_PRESCALE_VALUES_B                                                                   0x140f
#define mmCOL_MAN1_PRESCALE_VALUES_B_BASE_IDX                                                          2
#define mmCOL_MAN1_COL_MAN_OUTPUT_CSC_CONTROL                                                          0x1410
#define mmCOL_MAN1_COL_MAN_OUTPUT_CSC_CONTROL_BASE_IDX                                                 2
#define mmCOL_MAN1_OUTPUT_CSC_C11_C12_A                                                                0x1411
#define mmCOL_MAN1_OUTPUT_CSC_C11_C12_A_BASE_IDX                                                       2
#define mmCOL_MAN1_OUTPUT_CSC_C13_C14_A                                                                0x1412
#define mmCOL_MAN1_OUTPUT_CSC_C13_C14_A_BASE_IDX                                                       2
#define mmCOL_MAN1_OUTPUT_CSC_C21_C22_A                                                                0x1413
#define mmCOL_MAN1_OUTPUT_CSC_C21_C22_A_BASE_IDX                                                       2
#define mmCOL_MAN1_OUTPUT_CSC_C23_C24_A                                                                0x1414
#define mmCOL_MAN1_OUTPUT_CSC_C23_C24_A_BASE_IDX                                                       2
#define mmCOL_MAN1_OUTPUT_CSC_C31_C32_A                                                                0x1415
#define mmCOL_MAN1_OUTPUT_CSC_C31_C32_A_BASE_IDX                                                       2
#define mmCOL_MAN1_OUTPUT_CSC_C33_C34_A                                                                0x1416
#define mmCOL_MAN1_OUTPUT_CSC_C33_C34_A_BASE_IDX                                                       2
#define mmCOL_MAN1_OUTPUT_CSC_C11_C12_B                                                                0x1417
#define mmCOL_MAN1_OUTPUT_CSC_C11_C12_B_BASE_IDX                                                       2
#define mmCOL_MAN1_OUTPUT_CSC_C13_C14_B                                                                0x1418
#define mmCOL_MAN1_OUTPUT_CSC_C13_C14_B_BASE_IDX                                                       2
#define mmCOL_MAN1_OUTPUT_CSC_C21_C22_B                                                                0x1419
#define mmCOL_MAN1_OUTPUT_CSC_C21_C22_B_BASE_IDX                                                       2
#define mmCOL_MAN1_OUTPUT_CSC_C23_C24_B                                                                0x141a
#define mmCOL_MAN1_OUTPUT_CSC_C23_C24_B_BASE_IDX                                                       2
#define mmCOL_MAN1_OUTPUT_CSC_C31_C32_B                                                                0x141b
#define mmCOL_MAN1_OUTPUT_CSC_C31_C32_B_BASE_IDX                                                       2
#define mmCOL_MAN1_OUTPUT_CSC_C33_C34_B                                                                0x141c
#define mmCOL_MAN1_OUTPUT_CSC_C33_C34_B_BASE_IDX                                                       2
#define mmCOL_MAN1_DENORM_CLAMP_CONTROL                                                                0x141d
#define mmCOL_MAN1_DENORM_CLAMP_CONTROL_BASE_IDX                                                       2
#define mmCOL_MAN1_DENORM_CLAMP_RANGE_R_CR                                                             0x141e
#define mmCOL_MAN1_DENORM_CLAMP_RANGE_R_CR_BASE_IDX                                                    2
#define mmCOL_MAN1_DENORM_CLAMP_RANGE_G_Y                                                              0x141f
#define mmCOL_MAN1_DENORM_CLAMP_RANGE_G_Y_BASE_IDX                                                     2
#define mmCOL_MAN1_DENORM_CLAMP_RANGE_B_CB                                                             0x1420
#define mmCOL_MAN1_DENORM_CLAMP_RANGE_B_CB_BASE_IDX                                                    2
#define mmCOL_MAN1_COL_MAN_FP_CONVERTED_FIELD                                                          0x1421
#define mmCOL_MAN1_COL_MAN_FP_CONVERTED_FIELD_BASE_IDX                                                 2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CONTROL                                                             0x1422
#define mmCOL_MAN1_COL_MAN_REGAMMA_CONTROL_BASE_IDX                                                    2
#define mmCOL_MAN1_COL_MAN_REGAMMA_LUT_INDEX                                                           0x1423
#define mmCOL_MAN1_COL_MAN_REGAMMA_LUT_INDEX_BASE_IDX                                                  2
#define mmCOL_MAN1_COL_MAN_REGAMMA_LUT_DATA                                                            0x1424
#define mmCOL_MAN1_COL_MAN_REGAMMA_LUT_DATA_BASE_IDX                                                   2
#define mmCOL_MAN1_COL_MAN_REGAMMA_LUT_WRITE_EN_MASK                                                   0x1425
#define mmCOL_MAN1_COL_MAN_REGAMMA_LUT_WRITE_EN_MASK_BASE_IDX                                          2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_START_CNTL                                                    0x1426
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_START_CNTL_BASE_IDX                                           2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_SLOPE_CNTL                                                    0x1427
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_SLOPE_CNTL_BASE_IDX                                           2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_END_CNTL1                                                     0x1428
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_END_CNTL1_BASE_IDX                                            2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_END_CNTL2                                                     0x1429
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_END_CNTL2_BASE_IDX                                            2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_REGION_0_1                                                    0x142a
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_REGION_0_1_BASE_IDX                                           2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_REGION_2_3                                                    0x142b
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_REGION_2_3_BASE_IDX                                           2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_REGION_4_5                                                    0x142c
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_REGION_4_5_BASE_IDX                                           2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_REGION_6_7                                                    0x142d
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_REGION_6_7_BASE_IDX                                           2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_REGION_8_9                                                    0x142e
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_REGION_8_9_BASE_IDX                                           2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_REGION_10_11                                                  0x142f
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_REGION_10_11_BASE_IDX                                         2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_REGION_12_13                                                  0x1430
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_REGION_12_13_BASE_IDX                                         2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_REGION_14_15                                                  0x1431
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLA_REGION_14_15_BASE_IDX                                         2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_START_CNTL                                                    0x1432
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_START_CNTL_BASE_IDX                                           2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_SLOPE_CNTL                                                    0x1433
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_SLOPE_CNTL_BASE_IDX                                           2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_END_CNTL1                                                     0x1434
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_END_CNTL1_BASE_IDX                                            2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_END_CNTL2                                                     0x1435
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_END_CNTL2_BASE_IDX                                            2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_REGION_0_1                                                    0x1436
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_REGION_0_1_BASE_IDX                                           2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_REGION_2_3                                                    0x1437
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_REGION_2_3_BASE_IDX                                           2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_REGION_4_5                                                    0x1438
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_REGION_4_5_BASE_IDX                                           2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_REGION_6_7                                                    0x1439
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_REGION_6_7_BASE_IDX                                           2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_REGION_8_9                                                    0x143a
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_REGION_8_9_BASE_IDX                                           2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_REGION_10_11                                                  0x143b
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_REGION_10_11_BASE_IDX                                         2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_REGION_12_13                                                  0x143c
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_REGION_12_13_BASE_IDX                                         2
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_REGION_14_15                                                  0x143d
#define mmCOL_MAN1_COL_MAN_REGAMMA_CNTLB_REGION_14_15_BASE_IDX                                         2
#define mmCOL_MAN1_PACK_FIFO_ERROR                                                                     0x143e
#define mmCOL_MAN1_PACK_FIFO_ERROR_BASE_IDX                                                            2
#define mmCOL_MAN1_OUTPUT_FIFO_ERROR                                                                   0x143f
#define mmCOL_MAN1_OUTPUT_FIFO_ERROR_BASE_IDX                                                          2
#define mmCOL_MAN1_INPUT_GAMMA_LUT_AUTOFILL                                                            0x1440
#define mmCOL_MAN1_INPUT_GAMMA_LUT_AUTOFILL_BASE_IDX                                                   2
#define mmCOL_MAN1_INPUT_GAMMA_LUT_RW_INDEX                                                            0x1441
#define mmCOL_MAN1_INPUT_GAMMA_LUT_RW_INDEX_BASE_IDX                                                   2
#define mmCOL_MAN1_INPUT_GAMMA_LUT_SEQ_COLOR                                                           0x1442
#define mmCOL_MAN1_INPUT_GAMMA_LUT_SEQ_COLOR_BASE_IDX                                                  2
#define mmCOL_MAN1_INPUT_GAMMA_LUT_PWL_DATA                                                            0x1443
#define mmCOL_MAN1_INPUT_GAMMA_LUT_PWL_DATA_BASE_IDX                                                   2
#define mmCOL_MAN1_INPUT_GAMMA_LUT_30_COLOR                                                            0x1444
#define mmCOL_MAN1_INPUT_GAMMA_LUT_30_COLOR_BASE_IDX                                                   2
#define mmCOL_MAN1_COL_MAN_INPUT_GAMMA_CONTROL1                                                        0x1445
#define mmCOL_MAN1_COL_MAN_INPUT_GAMMA_CONTROL1_BASE_IDX                                               2
#define mmCOL_MAN1_COL_MAN_INPUT_GAMMA_CONTROL2                                                        0x1446
#define mmCOL_MAN1_COL_MAN_INPUT_GAMMA_CONTROL2_BASE_IDX                                               2
#define mmCOL_MAN1_INPUT_GAMMA_BW_OFFSETS_B                                                            0x1447
#define mmCOL_MAN1_INPUT_GAMMA_BW_OFFSETS_B_BASE_IDX                                                   2
#define mmCOL_MAN1_INPUT_GAMMA_BW_OFFSETS_G                                                            0x1448
#define mmCOL_MAN1_INPUT_GAMMA_BW_OFFSETS_G_BASE_IDX                                                   2
#define mmCOL_MAN1_INPUT_GAMMA_BW_OFFSETS_R                                                            0x1449
#define mmCOL_MAN1_INPUT_GAMMA_BW_OFFSETS_R_BASE_IDX                                                   2
#define mmCOL_MAN1_COL_MAN_DEGAMMA_CONTROL                                                             0x144a
#define mmCOL_MAN1_COL_MAN_DEGAMMA_CONTROL_BASE_IDX                                                    2
#define mmCOL_MAN1_COL_MAN_GAMUT_REMAP_CONTROL                                                         0x144b
#define mmCOL_MAN1_COL_MAN_GAMUT_REMAP_CONTROL_BASE_IDX                                                2
#define mmCOL_MAN1_COL_MAN_GAMUT_REMAP_C11_C12                                                         0x144c
#define mmCOL_MAN1_COL_MAN_GAMUT_REMAP_C11_C12_BASE_IDX                                                2
#define mmCOL_MAN1_COL_MAN_GAMUT_REMAP_C13_C14                                                         0x144d
#define mmCOL_MAN1_COL_MAN_GAMUT_REMAP_C13_C14_BASE_IDX                                                2
#define mmCOL_MAN1_COL_MAN_GAMUT_REMAP_C21_C22                                                         0x144e
#define mmCOL_MAN1_COL_MAN_GAMUT_REMAP_C21_C22_BASE_IDX                                                2
#define mmCOL_MAN1_COL_MAN_GAMUT_REMAP_C23_C24                                                         0x144f
#define mmCOL_MAN1_COL_MAN_GAMUT_REMAP_C23_C24_BASE_IDX                                                2
#define mmCOL_MAN1_COL_MAN_GAMUT_REMAP_C31_C32                                                         0x1450
#define mmCOL_MAN1_COL_MAN_GAMUT_REMAP_C31_C32_BASE_IDX                                                2
#define mmCOL_MAN1_COL_MAN_GAMUT_REMAP_C33_C34                                                         0x1451
#define mmCOL_MAN1_COL_MAN_GAMUT_REMAP_C33_C34_BASE_IDX                                                2


// addressBlock: dce_dc_dcfev1_dispdec
// base address: 0x800
#define mmDCFEV1_DCFEV_CLOCK_CONTROL                                                                   0x147e
#define mmDCFEV1_DCFEV_CLOCK_CONTROL_BASE_IDX                                                          2
#define mmDCFEV1_DCFEV_SOFT_RESET                                                                      0x147f
#define mmDCFEV1_DCFEV_SOFT_RESET_BASE_IDX                                                             2
#define mmDCFEV1_DCFEV_DMIFV_CLOCK_CONTROL                                                             0x1480
#define mmDCFEV1_DCFEV_DMIFV_CLOCK_CONTROL_BASE_IDX                                                    2
#define mmDCFEV1_DCFEV_DMIFV_MEM_PWR_CTRL                                                              0x1482
#define mmDCFEV1_DCFEV_DMIFV_MEM_PWR_CTRL_BASE_IDX                                                     2
#define mmDCFEV1_DCFEV_DMIFV_MEM_PWR_STATUS                                                            0x1483
#define mmDCFEV1_DCFEV_DMIFV_MEM_PWR_STATUS_BASE_IDX                                                   2
#define mmDCFEV1_DCFEV_MEM_PWR_CTRL                                                                    0x1484
#define mmDCFEV1_DCFEV_MEM_PWR_CTRL_BASE_IDX                                                           2
#define mmDCFEV1_DCFEV_MEM_PWR_CTRL2                                                                   0x1485
#define mmDCFEV1_DCFEV_MEM_PWR_CTRL2_BASE_IDX                                                          2
#define mmDCFEV1_DCFEV_MEM_PWR_STATUS                                                                  0x1486
#define mmDCFEV1_DCFEV_MEM_PWR_STATUS_BASE_IDX                                                         2
#define mmDCFEV1_DCFEV_L_FLUSH                                                                         0x1487
#define mmDCFEV1_DCFEV_L_FLUSH_BASE_IDX                                                                2
#define mmDCFEV1_DCFEV_C_FLUSH                                                                         0x1488
#define mmDCFEV1_DCFEV_C_FLUSH_BASE_IDX                                                                2
#define mmDCFEV1_DCFEV_MISC                                                                            0x148a
#define mmDCFEV1_DCFEV_MISC_BASE_IDX                                                                   2


// addressBlock: dce_dc_dc_perfmon12_dispdec
// base address: 0x51c8
#define mmDC_PERFMON12_PERFCOUNTER_CNTL                                                                0x1492
#define mmDC_PERFMON12_PERFCOUNTER_CNTL_BASE_IDX                                                       2
#define mmDC_PERFMON12_PERFCOUNTER_CNTL2                                                               0x1493
#define mmDC_PERFMON12_PERFCOUNTER_CNTL2_BASE_IDX                                                      2
#define mmDC_PERFMON12_PERFCOUNTER_STATE                                                               0x1494
#define mmDC_PERFMON12_PERFCOUNTER_STATE_BASE_IDX                                                      2
#define mmDC_PERFMON12_PERFMON_CNTL                                                                    0x1495
#define mmDC_PERFMON12_PERFMON_CNTL_BASE_IDX                                                           2
#define mmDC_PERFMON12_PERFMON_CNTL2                                                                   0x1496
#define mmDC_PERFMON12_PERFMON_CNTL2_BASE_IDX                                                          2
#define mmDC_PERFMON12_PERFMON_CVALUE_INT_MISC                                                         0x1497
#define mmDC_PERFMON12_PERFMON_CVALUE_INT_MISC_BASE_IDX                                                2
#define mmDC_PERFMON12_PERFMON_CVALUE_LOW                                                              0x1498
#define mmDC_PERFMON12_PERFMON_CVALUE_LOW_BASE_IDX                                                     2
#define mmDC_PERFMON12_PERFMON_HI                                                                      0x1499
#define mmDC_PERFMON12_PERFMON_HI_BASE_IDX                                                             2
#define mmDC_PERFMON12_PERFMON_LOW                                                                     0x149a
#define mmDC_PERFMON12_PERFMON_LOW_BASE_IDX                                                            2


// addressBlock: dce_dc_dmifv_pg1_dispdec
// base address: 0x800
#define mmDMIFV_PG1_DPGV0_PIPE_ARBITRATION_CONTROL1                                                    0x149e
#define mmDMIFV_PG1_DPGV0_PIPE_ARBITRATION_CONTROL1_BASE_IDX                                           2
#define mmDMIFV_PG1_DPGV0_PIPE_ARBITRATION_CONTROL2                                                    0x149f
#define mmDMIFV_PG1_DPGV0_PIPE_ARBITRATION_CONTROL2_BASE_IDX                                           2
#define mmDMIFV_PG1_DPGV0_WATERMARK_MASK_CONTROL                                                       0x14a0
#define mmDMIFV_PG1_DPGV0_WATERMARK_MASK_CONTROL_BASE_IDX                                              2
#define mmDMIFV_PG1_DPGV0_PIPE_URGENCY_CONTROL                                                         0x14a1
#define mmDMIFV_PG1_DPGV0_PIPE_URGENCY_CONTROL_BASE_IDX                                                2
#define mmDMIFV_PG1_DPGV0_PIPE_DPM_CONTROL                                                             0x14a2
#define mmDMIFV_PG1_DPGV0_PIPE_DPM_CONTROL_BASE_IDX                                                    2
#define mmDMIFV_PG1_DPGV0_PIPE_STUTTER_CONTROL                                                         0x14a3
#define mmDMIFV_PG1_DPGV0_PIPE_STUTTER_CONTROL_BASE_IDX                                                2
#define mmDMIFV_PG1_DPGV0_PIPE_NB_PSTATE_CHANGE_CONTROL                                                0x14a4
#define mmDMIFV_PG1_DPGV0_PIPE_NB_PSTATE_CHANGE_CONTROL_BASE_IDX                                       2
#define mmDMIFV_PG1_DPGV0_PIPE_STUTTER_CONTROL_NONLPTCH                                                0x14a5
#define mmDMIFV_PG1_DPGV0_PIPE_STUTTER_CONTROL_NONLPTCH_BASE_IDX                                       2
#define mmDMIFV_PG1_DPGV0_REPEATER_PROGRAM                                                             0x14a6
#define mmDMIFV_PG1_DPGV0_REPEATER_PROGRAM_BASE_IDX                                                    2
#define mmDMIFV_PG1_DPGV0_CHK_PRE_PROC_CNTL                                                            0x14aa
#define mmDMIFV_PG1_DPGV0_CHK_PRE_PROC_CNTL_BASE_IDX                                                   2
#define mmDMIFV_PG1_DPGV1_PIPE_ARBITRATION_CONTROL1                                                    0x14ab
#define mmDMIFV_PG1_DPGV1_PIPE_ARBITRATION_CONTROL1_BASE_IDX                                           2
#define mmDMIFV_PG1_DPGV1_PIPE_ARBITRATION_CONTROL2                                                    0x14ac
#define mmDMIFV_PG1_DPGV1_PIPE_ARBITRATION_CONTROL2_BASE_IDX                                           2
#define mmDMIFV_PG1_DPGV1_WATERMARK_MASK_CONTROL                                                       0x14ad
#define mmDMIFV_PG1_DPGV1_WATERMARK_MASK_CONTROL_BASE_IDX                                              2
#define mmDMIFV_PG1_DPGV1_PIPE_URGENCY_CONTROL                                                         0x14ae
#define mmDMIFV_PG1_DPGV1_PIPE_URGENCY_CONTROL_BASE_IDX                                                2
#define mmDMIFV_PG1_DPGV1_PIPE_DPM_CONTROL                                                             0x14af
#define mmDMIFV_PG1_DPGV1_PIPE_DPM_CONTROL_BASE_IDX                                                    2
#define mmDMIFV_PG1_DPGV1_PIPE_STUTTER_CONTROL                                                         0x14b0
#define mmDMIFV_PG1_DPGV1_PIPE_STUTTER_CONTROL_BASE_IDX                                                2
#define mmDMIFV_PG1_DPGV1_PIPE_NB_PSTATE_CHANGE_CONTROL                                                0x14b1
#define mmDMIFV_PG1_DPGV1_PIPE_NB_PSTATE_CHANGE_CONTROL_BASE_IDX                                       2
#define mmDMIFV_PG1_DPGV1_PIPE_STUTTER_CONTROL_NONLPTCH                                                0x14b2
#define mmDMIFV_PG1_DPGV1_PIPE_STUTTER_CONTROL_NONLPTCH_BASE_IDX                                       2
#define mmDMIFV_PG1_DPGV1_REPEATER_PROGRAM                                                             0x14b3
#define mmDMIFV_PG1_DPGV1_REPEATER_PROGRAM_BASE_IDX                                                    2
#define mmDMIFV_PG1_DPGV1_CHK_PRE_PROC_CNTL                                                            0x14b7
#define mmDMIFV_PG1_DPGV1_CHK_PRE_PROC_CNTL_BASE_IDX                                                   2


// addressBlock: dce_dc_blndv1_dispdec
// base address: 0x800
#define mmBLNDV1_BLNDV_CONTROL                                                                         0x14db
#define mmBLNDV1_BLNDV_CONTROL_BASE_IDX                                                                2
#define mmBLNDV1_BLNDV_SM_CONTROL2                                                                     0x14dc
#define mmBLNDV1_BLNDV_SM_CONTROL2_BASE_IDX                                                            2
#define mmBLNDV1_BLNDV_CONTROL2                                                                        0x14dd
#define mmBLNDV1_BLNDV_CONTROL2_BASE_IDX                                                               2
#define mmBLNDV1_BLNDV_UPDATE                                                                          0x14de
#define mmBLNDV1_BLNDV_UPDATE_BASE_IDX                                                                 2
#define mmBLNDV1_BLNDV_UNDERFLOW_INTERRUPT                                                             0x14df
#define mmBLNDV1_BLNDV_UNDERFLOW_INTERRUPT_BASE_IDX                                                    2
#define mmBLNDV1_BLNDV_V_UPDATE_LOCK                                                                   0x14e0
#define mmBLNDV1_BLNDV_V_UPDATE_LOCK_BASE_IDX                                                          2
#define mmBLNDV1_BLNDV_REG_UPDATE_STATUS                                                               0x14e1
#define mmBLNDV1_BLNDV_REG_UPDATE_STATUS_BASE_IDX                                                      2


// addressBlock: dce_dc_crtcv1_dispdec
// base address: 0x800
#define mmCRTCV1_CRTCV_H_BLANK_EARLY_NUM                                                               0x14e6
#define mmCRTCV1_CRTCV_H_BLANK_EARLY_NUM_BASE_IDX                                                      2
#define mmCRTCV1_CRTCV_H_TOTAL                                                                         0x14e7
#define mmCRTCV1_CRTCV_H_TOTAL_BASE_IDX                                                                2
#define mmCRTCV1_CRTCV_H_BLANK_START_END                                                               0x14e8
#define mmCRTCV1_CRTCV_H_BLANK_START_END_BASE_IDX                                                      2
#define mmCRTCV1_CRTCV_H_SYNC_A                                                                        0x14e9
#define mmCRTCV1_CRTCV_H_SYNC_A_BASE_IDX                                                               2
#define mmCRTCV1_CRTCV_H_SYNC_A_CNTL                                                                   0x14ea
#define mmCRTCV1_CRTCV_H_SYNC_A_CNTL_BASE_IDX                                                          2
#define mmCRTCV1_CRTCV_H_SYNC_B                                                                        0x14eb
#define mmCRTCV1_CRTCV_H_SYNC_B_BASE_IDX                                                               2
#define mmCRTCV1_CRTCV_H_SYNC_B_CNTL                                                                   0x14ec
#define mmCRTCV1_CRTCV_H_SYNC_B_CNTL_BASE_IDX                                                          2
#define mmCRTCV1_CRTCV_VBI_END                                                                         0x14ed
#define mmCRTCV1_CRTCV_VBI_END_BASE_IDX                                                                2
#define mmCRTCV1_CRTCV_V_TOTAL                                                                         0x14ee
#define mmCRTCV1_CRTCV_V_TOTAL_BASE_IDX                                                                2
#define mmCRTCV1_CRTCV_V_TOTAL_MIN                                                                     0x14ef
#define mmCRTCV1_CRTCV_V_TOTAL_MIN_BASE_IDX                                                            2
#define mmCRTCV1_CRTCV_V_TOTAL_MAX                                                                     0x14f0
#define mmCRTCV1_CRTCV_V_TOTAL_MAX_BASE_IDX                                                            2
#define mmCRTCV1_CRTCV_V_TOTAL_CONTROL                                                                 0x14f1
#define mmCRTCV1_CRTCV_V_TOTAL_CONTROL_BASE_IDX                                                        2
#define mmCRTCV1_CRTCV_V_TOTAL_INT_STATUS                                                              0x14f2
#define mmCRTCV1_CRTCV_V_TOTAL_INT_STATUS_BASE_IDX                                                     2
#define mmCRTCV1_CRTCV_VSYNC_NOM_INT_STATUS                                                            0x14f3
#define mmCRTCV1_CRTCV_VSYNC_NOM_INT_STATUS_BASE_IDX                                                   2
#define mmCRTCV1_CRTCV_V_BLANK_START_END                                                               0x14f4
#define mmCRTCV1_CRTCV_V_BLANK_START_END_BASE_IDX                                                      2
#define mmCRTCV1_CRTCV_V_SYNC_A                                                                        0x14f5
#define mmCRTCV1_CRTCV_V_SYNC_A_BASE_IDX                                                               2
#define mmCRTCV1_CRTCV_V_SYNC_A_CNTL                                                                   0x14f6
#define mmCRTCV1_CRTCV_V_SYNC_A_CNTL_BASE_IDX                                                          2
#define mmCRTCV1_CRTCV_V_SYNC_B                                                                        0x14f7
#define mmCRTCV1_CRTCV_V_SYNC_B_BASE_IDX                                                               2
#define mmCRTCV1_CRTCV_V_SYNC_B_CNTL                                                                   0x14f8
#define mmCRTCV1_CRTCV_V_SYNC_B_CNTL_BASE_IDX                                                          2
#define mmCRTCV1_CRTCV_DTMTEST_CNTL                                                                    0x14f9
#define mmCRTCV1_CRTCV_DTMTEST_CNTL_BASE_IDX                                                           2
#define mmCRTCV1_CRTCV_DTMTEST_STATUS_POSITION                                                         0x14fa
#define mmCRTCV1_CRTCV_DTMTEST_STATUS_POSITION_BASE_IDX                                                2
#define mmCRTCV1_CRTCV_TRIGA_CNTL                                                                      0x14fb
#define mmCRTCV1_CRTCV_TRIGA_CNTL_BASE_IDX                                                             2
#define mmCRTCV1_CRTCV_TRIGA_MANUAL_TRIG                                                               0x14fc
#define mmCRTCV1_CRTCV_TRIGA_MANUAL_TRIG_BASE_IDX                                                      2
#define mmCRTCV1_CRTCV_TRIGB_CNTL                                                                      0x14fd
#define mmCRTCV1_CRTCV_TRIGB_CNTL_BASE_IDX                                                             2
#define mmCRTCV1_CRTCV_TRIGB_MANUAL_TRIG                                                               0x14fe
#define mmCRTCV1_CRTCV_TRIGB_MANUAL_TRIG_BASE_IDX                                                      2
#define mmCRTCV1_CRTCV_FORCE_COUNT_NOW_CNTL                                                            0x14ff
#define mmCRTCV1_CRTCV_FORCE_COUNT_NOW_CNTL_BASE_IDX                                                   2
#define mmCRTCV1_CRTCV_FLOW_CONTROL                                                                    0x1500
#define mmCRTCV1_CRTCV_FLOW_CONTROL_BASE_IDX                                                           2
#define mmCRTCV1_CRTCV_STEREO_FORCE_NEXT_EYE                                                           0x1501
#define mmCRTCV1_CRTCV_STEREO_FORCE_NEXT_EYE_BASE_IDX                                                  2
#define mmCRTCV1_CRTCV_AVSYNC_COUNTER                                                                  0x1502
#define mmCRTCV1_CRTCV_AVSYNC_COUNTER_BASE_IDX                                                         2
#define mmCRTCV1_CRTCV_CONTROL                                                                         0x1503
#define mmCRTCV1_CRTCV_CONTROL_BASE_IDX                                                                2
#define mmCRTCV1_CRTCV_BLANK_CONTROL                                                                   0x1504
#define mmCRTCV1_CRTCV_BLANK_CONTROL_BASE_IDX                                                          2
#define mmCRTCV1_CRTCV_INTERLACE_CONTROL                                                               0x1505
#define mmCRTCV1_CRTCV_INTERLACE_CONTROL_BASE_IDX                                                      2
#define mmCRTCV1_CRTCV_INTERLACE_STATUS                                                                0x1506
#define mmCRTCV1_CRTCV_INTERLACE_STATUS_BASE_IDX                                                       2
#define mmCRTCV1_CRTCV_FIELD_INDICATION_CONTROL                                                        0x1507
#define mmCRTCV1_CRTCV_FIELD_INDICATION_CONTROL_BASE_IDX                                               2
#define mmCRTCV1_CRTCV_PIXEL_DATA_READBACK0                                                            0x1508
#define mmCRTCV1_CRTCV_PIXEL_DATA_READBACK0_BASE_IDX                                                   2
#define mmCRTCV1_CRTCV_PIXEL_DATA_READBACK1                                                            0x1509
#define mmCRTCV1_CRTCV_PIXEL_DATA_READBACK1_BASE_IDX                                                   2
#define mmCRTCV1_CRTCV_STATUS                                                                          0x150a
#define mmCRTCV1_CRTCV_STATUS_BASE_IDX                                                                 2
#define mmCRTCV1_CRTCV_STATUS_POSITION                                                                 0x150b
#define mmCRTCV1_CRTCV_STATUS_POSITION_BASE_IDX                                                        2
#define mmCRTCV1_CRTCV_NOM_VERT_POSITION                                                               0x150c
#define mmCRTCV1_CRTCV_NOM_VERT_POSITION_BASE_IDX                                                      2
#define mmCRTCV1_CRTCV_STATUS_FRAME_COUNT                                                              0x150d
#define mmCRTCV1_CRTCV_STATUS_FRAME_COUNT_BASE_IDX                                                     2
#define mmCRTCV1_CRTCV_STATUS_VF_COUNT                                                                 0x150e
#define mmCRTCV1_CRTCV_STATUS_VF_COUNT_BASE_IDX                                                        2
#define mmCRTCV1_CRTCV_STATUS_HV_COUNT                                                                 0x150f
#define mmCRTCV1_CRTCV_STATUS_HV_COUNT_BASE_IDX                                                        2
#define mmCRTCV1_CRTCV_COUNT_CONTROL                                                                   0x1510
#define mmCRTCV1_CRTCV_COUNT_CONTROL_BASE_IDX                                                          2
#define mmCRTCV1_CRTCV_COUNT_RESET                                                                     0x1511
#define mmCRTCV1_CRTCV_COUNT_RESET_BASE_IDX                                                            2
#define mmCRTCV1_CRTCV_MANUAL_FORCE_VSYNC_NEXT_LINE                                                    0x1512
#define mmCRTCV1_CRTCV_MANUAL_FORCE_VSYNC_NEXT_LINE_BASE_IDX                                           2
#define mmCRTCV1_CRTCV_VERT_SYNC_CONTROL                                                               0x1513
#define mmCRTCV1_CRTCV_VERT_SYNC_CONTROL_BASE_IDX                                                      2
#define mmCRTCV1_CRTCV_STEREO_STATUS                                                                   0x1514
#define mmCRTCV1_CRTCV_STEREO_STATUS_BASE_IDX                                                          2
#define mmCRTCV1_CRTCV_STEREO_CONTROL                                                                  0x1515
#define mmCRTCV1_CRTCV_STEREO_CONTROL_BASE_IDX                                                         2
#define mmCRTCV1_CRTCV_SNAPSHOT_STATUS                                                                 0x1516
#define mmCRTCV1_CRTCV_SNAPSHOT_STATUS_BASE_IDX                                                        2
#define mmCRTCV1_CRTCV_SNAPSHOT_CONTROL                                                                0x1517
#define mmCRTCV1_CRTCV_SNAPSHOT_CONTROL_BASE_IDX                                                       2
#define mmCRTCV1_CRTCV_SNAPSHOT_POSITION                                                               0x1518
#define mmCRTCV1_CRTCV_SNAPSHOT_POSITION_BASE_IDX                                                      2
#define mmCRTCV1_CRTCV_SNAPSHOT_FRAME                                                                  0x1519
#define mmCRTCV1_CRTCV_SNAPSHOT_FRAME_BASE_IDX                                                         2
#define mmCRTCV1_CRTCV_START_LINE_CONTROL                                                              0x151a
#define mmCRTCV1_CRTCV_START_LINE_CONTROL_BASE_IDX                                                     2
#define mmCRTCV1_CRTCV_INTERRUPT_CONTROL                                                               0x151b
#define mmCRTCV1_CRTCV_INTERRUPT_CONTROL_BASE_IDX                                                      2
#define mmCRTCV1_CRTCV_UPDATE_LOCK                                                                     0x151c
#define mmCRTCV1_CRTCV_UPDATE_LOCK_BASE_IDX                                                            2
#define mmCRTCV1_CRTCV_DOUBLE_BUFFER_CONTROL                                                           0x151d
#define mmCRTCV1_CRTCV_DOUBLE_BUFFER_CONTROL_BASE_IDX                                                  2
#define mmCRTCV1_CRTCV_VGA_PARAMETER_CAPTURE_MODE                                                      0x151e
#define mmCRTCV1_CRTCV_VGA_PARAMETER_CAPTURE_MODE_BASE_IDX                                             2
#define mmCRTCV1_CRTCV_TEST_PATTERN_CONTROL                                                            0x151f
#define mmCRTCV1_CRTCV_TEST_PATTERN_CONTROL_BASE_IDX                                                   2
#define mmCRTCV1_CRTCV_TEST_PATTERN_PARAMETERS                                                         0x1520
#define mmCRTCV1_CRTCV_TEST_PATTERN_PARAMETERS_BASE_IDX                                                2
#define mmCRTCV1_CRTCV_TEST_PATTERN_COLOR                                                              0x1521
#define mmCRTCV1_CRTCV_TEST_PATTERN_COLOR_BASE_IDX                                                     2
#define mmCRTCV1_CRTCV_MASTER_UPDATE_LOCK                                                              0x1522
#define mmCRTCV1_CRTCV_MASTER_UPDATE_LOCK_BASE_IDX                                                     2
#define mmCRTCV1_CRTCV_MASTER_UPDATE_MODE                                                              0x1523
#define mmCRTCV1_CRTCV_MASTER_UPDATE_MODE_BASE_IDX                                                     2
#define mmCRTCV1_CRTCV_MVP_INBAND_CNTL_INSERT                                                          0x1524
#define mmCRTCV1_CRTCV_MVP_INBAND_CNTL_INSERT_BASE_IDX                                                 2
#define mmCRTCV1_CRTCV_MVP_INBAND_CNTL_INSERT_TIMER                                                    0x1525
#define mmCRTCV1_CRTCV_MVP_INBAND_CNTL_INSERT_TIMER_BASE_IDX                                           2
#define mmCRTCV1_CRTCV_MVP_STATUS                                                                      0x1526
#define mmCRTCV1_CRTCV_MVP_STATUS_BASE_IDX                                                             2
#define mmCRTCV1_CRTCV_MASTER_EN                                                                       0x1527
#define mmCRTCV1_CRTCV_MASTER_EN_BASE_IDX                                                              2
#define mmCRTCV1_CRTCV_ALLOW_STOP_OFF_V_CNT                                                            0x1528
#define mmCRTCV1_CRTCV_ALLOW_STOP_OFF_V_CNT_BASE_IDX                                                   2
#define mmCRTCV1_CRTCV_V_UPDATE_INT_STATUS                                                             0x1529
#define mmCRTCV1_CRTCV_V_UPDATE_INT_STATUS_BASE_IDX                                                    2
#define mmCRTCV1_CRTCV_OVERSCAN_COLOR                                                                  0x152b
#define mmCRTCV1_CRTCV_OVERSCAN_COLOR_BASE_IDX                                                         2
#define mmCRTCV1_CRTCV_OVERSCAN_COLOR_EXT                                                              0x152c
#define mmCRTCV1_CRTCV_OVERSCAN_COLOR_EXT_BASE_IDX                                                     2
#define mmCRTCV1_CRTCV_BLANK_DATA_COLOR                                                                0x152d
#define mmCRTCV1_CRTCV_BLANK_DATA_COLOR_BASE_IDX                                                       2
#define mmCRTCV1_CRTCV_BLANK_DATA_COLOR_EXT                                                            0x152e
#define mmCRTCV1_CRTCV_BLANK_DATA_COLOR_EXT_BASE_IDX                                                   2
#define mmCRTCV1_CRTCV_BLACK_COLOR                                                                     0x152f
#define mmCRTCV1_CRTCV_BLACK_COLOR_BASE_IDX                                                            2
#define mmCRTCV1_CRTCV_BLACK_COLOR_EXT                                                                 0x1530
#define mmCRTCV1_CRTCV_BLACK_COLOR_EXT_BASE_IDX                                                        2
#define mmCRTCV1_CRTCV_VERTICAL_INTERRUPT0_POSITION                                                    0x1531
#define mmCRTCV1_CRTCV_VERTICAL_INTERRUPT0_POSITION_BASE_IDX                                           2
#define mmCRTCV1_CRTCV_VERTICAL_INTERRUPT0_CONTROL                                                     0x1532
#define mmCRTCV1_CRTCV_VERTICAL_INTERRUPT0_CONTROL_BASE_IDX                                            2
#define mmCRTCV1_CRTCV_VERTICAL_INTERRUPT1_POSITION                                                    0x1533
#define mmCRTCV1_CRTCV_VERTICAL_INTERRUPT1_POSITION_BASE_IDX                                           2
#define mmCRTCV1_CRTCV_VERTICAL_INTERRUPT1_CONTROL                                                     0x1534
#define mmCRTCV1_CRTCV_VERTICAL_INTERRUPT1_CONTROL_BASE_IDX                                            2
#define mmCRTCV1_CRTCV_VERTICAL_INTERRUPT2_POSITION                                                    0x1535
#define mmCRTCV1_CRTCV_VERTICAL_INTERRUPT2_POSITION_BASE_IDX                                           2
#define mmCRTCV1_CRTCV_VERTICAL_INTERRUPT2_CONTROL                                                     0x1536
#define mmCRTCV1_CRTCV_VERTICAL_INTERRUPT2_CONTROL_BASE_IDX                                            2
#define mmCRTCV1_CRTCV_CRC_CNTL                                                                        0x1537
#define mmCRTCV1_CRTCV_CRC_CNTL_BASE_IDX                                                               2
#define mmCRTCV1_CRTCV_CRC0_WINDOWA_X_CONTROL                                                          0x1538
#define mmCRTCV1_CRTCV_CRC0_WINDOWA_X_CONTROL_BASE_IDX                                                 2
#define mmCRTCV1_CRTCV_CRC0_WINDOWA_Y_CONTROL                                                          0x1539
#define mmCRTCV1_CRTCV_CRC0_WINDOWA_Y_CONTROL_BASE_IDX                                                 2
#define mmCRTCV1_CRTCV_CRC0_WINDOWB_X_CONTROL                                                          0x153a
#define mmCRTCV1_CRTCV_CRC0_WINDOWB_X_CONTROL_BASE_IDX                                                 2
#define mmCRTCV1_CRTCV_CRC0_WINDOWB_Y_CONTROL                                                          0x153b
#define mmCRTCV1_CRTCV_CRC0_WINDOWB_Y_CONTROL_BASE_IDX                                                 2
#define mmCRTCV1_CRTCV_CRC0_DATA_RG                                                                    0x153c
#define mmCRTCV1_CRTCV_CRC0_DATA_RG_BASE_IDX                                                           2
#define mmCRTCV1_CRTCV_CRC0_DATA_B                                                                     0x153d
#define mmCRTCV1_CRTCV_CRC0_DATA_B_BASE_IDX                                                            2
#define mmCRTCV1_CRTCV_CRC1_WINDOWA_X_CONTROL                                                          0x153e
#define mmCRTCV1_CRTCV_CRC1_WINDOWA_X_CONTROL_BASE_IDX                                                 2
#define mmCRTCV1_CRTCV_CRC1_WINDOWA_Y_CONTROL                                                          0x153f
#define mmCRTCV1_CRTCV_CRC1_WINDOWA_Y_CONTROL_BASE_IDX                                                 2
#define mmCRTCV1_CRTCV_CRC1_WINDOWB_X_CONTROL                                                          0x1540
#define mmCRTCV1_CRTCV_CRC1_WINDOWB_X_CONTROL_BASE_IDX                                                 2
#define mmCRTCV1_CRTCV_CRC1_WINDOWB_Y_CONTROL                                                          0x1541
#define mmCRTCV1_CRTCV_CRC1_WINDOWB_Y_CONTROL_BASE_IDX                                                 2
#define mmCRTCV1_CRTCV_CRC1_DATA_RG                                                                    0x1542
#define mmCRTCV1_CRTCV_CRC1_DATA_RG_BASE_IDX                                                           2
#define mmCRTCV1_CRTCV_CRC1_DATA_B                                                                     0x1543
#define mmCRTCV1_CRTCV_CRC1_DATA_B_BASE_IDX                                                            2
#define mmCRTCV1_CRTCV_EXT_TIMING_SYNC_CONTROL                                                         0x1544
#define mmCRTCV1_CRTCV_EXT_TIMING_SYNC_CONTROL_BASE_IDX                                                2
#define mmCRTCV1_CRTCV_EXT_TIMING_SYNC_WINDOW_START                                                    0x1545
#define mmCRTCV1_CRTCV_EXT_TIMING_SYNC_WINDOW_START_BASE_IDX                                           2
#define mmCRTCV1_CRTCV_EXT_TIMING_SYNC_WINDOW_END                                                      0x1546
#define mmCRTCV1_CRTCV_EXT_TIMING_SYNC_WINDOW_END_BASE_IDX                                             2
#define mmCRTCV1_CRTCV_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL                                          0x1547
#define mmCRTCV1_CRTCV_EXT_TIMING_SYNC_LOSS_INTERRUPT_CONTROL_BASE_IDX                                 2
#define mmCRTCV1_CRTCV_EXT_TIMING_SYNC_INTERRUPT_CONTROL                                               0x1548
#define mmCRTCV1_CRTCV_EXT_TIMING_SYNC_INTERRUPT_CONTROL_BASE_IDX                                      2
#define mmCRTCV1_CRTCV_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL                                        0x1549
#define mmCRTCV1_CRTCV_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_CONTROL_BASE_IDX                               2
#define mmCRTCV1_CRTCV_STATIC_SCREEN_CONTROL                                                           0x154a
#define mmCRTCV1_CRTCV_STATIC_SCREEN_CONTROL_BASE_IDX                                                  2
#define mmCRTCV1_CRTCV_3D_STRUCTURE_CONTROL                                                            0x154b
#define mmCRTCV1_CRTCV_3D_STRUCTURE_CONTROL_BASE_IDX                                                   2
#define mmCRTCV1_CRTCV_GSL_VSYNC_GAP                                                                   0x154c
#define mmCRTCV1_CRTCV_GSL_VSYNC_GAP_BASE_IDX                                                          2
#define mmCRTCV1_CRTCV_GSL_WINDOW                                                                      0x154d
#define mmCRTCV1_CRTCV_GSL_WINDOW_BASE_IDX                                                             2
#define mmCRTCV1_CRTCV_GSL_CONTROL                                                                     0x154e
#define mmCRTCV1_CRTCV_GSL_CONTROL_BASE_IDX                                                            2


// addressBlock: dce_dc_hpd0_dispdec
// base address: 0x0
#define mmHPD0_DC_HPD_INT_STATUS                                                                       0x1600
#define mmHPD0_DC_HPD_INT_STATUS_BASE_IDX                                                              2
#define mmHPD0_DC_HPD_INT_CONTROL                                                                      0x1601
#define mmHPD0_DC_HPD_INT_CONTROL_BASE_IDX                                                             2
#define mmHPD0_DC_HPD_CONTROL                                                                          0x1602
#define mmHPD0_DC_HPD_CONTROL_BASE_IDX                                                                 2
#define mmHPD0_DC_HPD_FAST_TRAIN_CNTL                                                                  0x1603
#define mmHPD0_DC_HPD_FAST_TRAIN_CNTL_BASE_IDX                                                         2
#define mmHPD0_DC_HPD_TOGGLE_FILT_CNTL                                                                 0x1604
#define mmHPD0_DC_HPD_TOGGLE_FILT_CNTL_BASE_IDX                                                        2


// addressBlock: dce_dc_hpd1_dispdec
// base address: 0x20
#define mmHPD1_DC_HPD_INT_STATUS                                                                       0x1608
#define mmHPD1_DC_HPD_INT_STATUS_BASE_IDX                                                              2
#define mmHPD1_DC_HPD_INT_CONTROL                                                                      0x1609
#define mmHPD1_DC_HPD_INT_CONTROL_BASE_IDX                                                             2
#define mmHPD1_DC_HPD_CONTROL                                                                          0x160a
#define mmHPD1_DC_HPD_CONTROL_BASE_IDX                                                                 2
#define mmHPD1_DC_HPD_FAST_TRAIN_CNTL                                                                  0x160b
#define mmHPD1_DC_HPD_FAST_TRAIN_CNTL_BASE_IDX                                                         2
#define mmHPD1_DC_HPD_TOGGLE_FILT_CNTL                                                                 0x160c
#define mmHPD1_DC_HPD_TOGGLE_FILT_CNTL_BASE_IDX                                                        2


// addressBlock: dce_dc_hpd2_dispdec
// base address: 0x40
#define mmHPD2_DC_HPD_INT_STATUS                                                                       0x1610
#define mmHPD2_DC_HPD_INT_STATUS_BASE_IDX                                                              2
#define mmHPD2_DC_HPD_INT_CONTROL                                                                      0x1611
#define mmHPD2_DC_HPD_INT_CONTROL_BASE_IDX                                                             2
#define mmHPD2_DC_HPD_CONTROL                                                                          0x1612
#define mmHPD2_DC_HPD_CONTROL_BASE_IDX                                                                 2
#define mmHPD2_DC_HPD_FAST_TRAIN_CNTL                                                                  0x1613
#define mmHPD2_DC_HPD_FAST_TRAIN_CNTL_BASE_IDX                                                         2
#define mmHPD2_DC_HPD_TOGGLE_FILT_CNTL                                                                 0x1614
#define mmHPD2_DC_HPD_TOGGLE_FILT_CNTL_BASE_IDX                                                        2


// addressBlock: dce_dc_hpd3_dispdec
// base address: 0x60
#define mmHPD3_DC_HPD_INT_STATUS                                                                       0x1618
#define mmHPD3_DC_HPD_INT_STATUS_BASE_IDX                                                              2
#define mmHPD3_DC_HPD_INT_CONTROL                                                                      0x1619
#define mmHPD3_DC_HPD_INT_CONTROL_BASE_IDX                                                             2
#define mmHPD3_DC_HPD_CONTROL                     