#!/usr/bin/env python2
# -*- coding: utf-8 -*-

# setup.py --- Setup script for calculate-lib

# Copyright 2008-2010 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import sys, os
from distutils.core import setup
from distutils.command.build_scripts import build_scripts
from distutils.command.install_scripts import install_scripts

__version__ = "3.1.9"
__app__ = "calculate-lib"

module_name = "calculate.lib"

setup(
    name = __app__,
    version = __version__,
    description = "The library for Calculate 3",
    author = "Mir Calculate Ltd.",
    author_email = "support@calculate.ru",
    url = "http://calculate-linux.org",
    license = "http://www.apache.org/licenses/LICENSE-2.0",
    scripts = [],
    packages=['calculate',
              module_name,
              module_name + '.client',
              module_name + '.format',
              module_name + '.server',
              module_name + '.variables',
              module_name + '.mod',
              module_name + '.utils',
              module_name + '.utils.colortext'],
    data_files = [("/etc/calculate", []),
                  ("/var/calculate/remote", []),
                  ("/var/log/calculate", [])]
)
