#-*- coding: utf-8 -*-

# Copyright 2010-2012 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import soaplib, sys, time, os
import threading

from soaplib.serializers.primitive import String, Integer, Any, Boolean
from soaplib.serializers.clazz import Array, ClassSerializer
from soaplib.service import rpc, DefinitionBase
from calculate.core.server.api_types import ReturnedMessage
from calculate.core.server.api_types import ChoiceValue, Table, Option, Field, \
                                           GroupField, ViewInfo, ViewParams
from calculate.lib.datavars import VariableError,DataVarsError

#from cl_install import Install,DataVarsInstall
import cl_install
from calculate.lib.cl_lang import setLocalTranslate,getLazyLocalTranslate
from calculate.core.server.decorators import Dec
core_method = Dec.core_method
setLocalTranslate('cl_install3',sys.modules[__name__])
import traceback
from functools import wraps,WRAPPER_ASSIGNMENTS

__ = getLazyLocalTranslate(_)

class InstallInfo(ClassSerializer):
    """Parameters for method install"""
    cl_image_filename = String
    cl_image_linux_shortname = String
    cl_image_arch_machine = String
    cl_image_linux_ver = String
    cl_image_linux_build = String

    os_install_disk_single = String
    os_location_data = Array(Array(String))
    os_install_mbr = Array(String)
    os_install_root_type = String
    os_install_scratch = Boolean
    cl_uuid_set = Boolean
    os_install_kernel_scheduler = String

    os_install_locale_lang = String
    os_install_clock_timezone = String

    cl_migrate_root_pwd = String
    cl_migrate_data = Array(Array(String))
    cl_autologin = String
    os_install_net_fqdn = String
    os_install_net_data = Array(Array(String))
    os_install_net_route_data = Array(Array(String))
    os_install_net_conf = String
    os_install_net_dns = String
    os_install_net_dns_search = String
    os_install_ntp = String
    os_install_x11_video_drv = String
    os_install_x11_resolution = String
    os_install_x11_composite = Boolean
    os_install_fb_resolution = String

    cl_autopartition_device = Array(String)
    cl_autopartition_scheme = Array(String)
    cl_autopartition_set = Boolean
    cl_autopartition_table = String
    cl_autopartition_root_size = String

    cl_live = Boolean
    cl_templates_locate = Array(String)

    os_install_pxe = Boolean
    os_install_pxe_path = String

    Default = Array(String)
    CheckOnly = Boolean
    CheckAll = Boolean

class catchExcept:
    def __init__(self,f):
        self.f = f
        self.func_name = f.func_name
        self.func_code = f.func_code
        self.__doc__ = f.__doc__
        self.__name__ = f.__name__
    
    def __call__(self,*args,**kwargs):
        try:
            return self.f(*args,**kwargs)
        except BaseException as e:
            view = ViewInfo(groups=[])
            group = GroupField(name=_("Error"),last=True)
            group.fields = []
            group.fields.append(Field(
                    name = "error",
                    label = str(e),
                    default = 'color:red;',
                    element = "error"))
            view.groups.append(group)
            if not isinstance(VariableError,DataVarsError,InstallError):
                for i in apply(traceback.format_exception, sys.exc_info()):
                    print i,

            return view

class Wsdl:
    from calculate.core.server.baseClass import Basic
    from calculate.core.server.decorators import Dec

    def installCommon(self,sid,info,methodname,initfunc,
                      installFunc="installSystem"):
        """
        Install common method
        """
        try:
            dv = self.get_cache(sid,methodname,"vars")
            if not dv:
                dv = initfunc()
            else:
                if methodname == "install":
                    self.fixInstallLocalization(sid,dv)
                dv.processRefresh()
            if info:
                checkonly = info.CheckOnly
                checkall = info.CheckAll
            else:
                checkonly = False
                checkall = False
            errors = map(lambda x:ReturnedMessage(**x),
                     dv.checkGroups(info,allvars=checkall or \
                                         not checkonly))
            if errors:
                return errors
            if checkonly:
                returnmess = ReturnedMessage(type = '', message = None)
                return [returnmess]
            install_meth = type("CommonInstall",(self.Common,
                                cl_install.Install, object), {})
            pid = self.startprocess(sid, target=install_meth,
                            method=installFunc,\
                            method_name=methodname or "install",
                            args_proc = (dv,))
            returnmess = ReturnedMessage(type = 'pid', message = pid)
            returnmess.type = "pid"
            returnmess.message = pid
            dv = self.clear_cache(sid,methodname)
            return [returnmess]
        finally:
            if dv:
                self.set_cache(sid,methodname,"vars",dv,smart=False)
        return []

    @rpc(Integer, InstallInfo, _returns = Array(ReturnedMessage))
    @core_method(category=__('Installation'),title=__("System install"),
        image='calculate-install,system-installer,applications-other,'
              'drive-harddisk',
        gui=True,command='cl-install',
        rights=['install'])
    def install ( self, sid, info):
        return self.installCommon(sid,info,'install',self.install_vars)

    def install_vars(self,dv=None):
        if not dv:
            dv = cl_install.DataVarsInstall()
            dv.importInstall()
            dv.flIniFile()
            dv.Set('cl_action','system',True)
        dv.addGroup(_("Language and locale"),
            image="welcome",
            normal=('os_install_locale_lang','os_install_clock_timezone'))
        dv.addGroup(_("Distribution"),
            normal=('cl_image_filename',),
            expert=('cl_image_linux_shortname', 'cl_image_arch_machine'))
        dv.addGroup(_("Allocate drive space"),
            normal=('cl_autopartition_set',),
            expert=('cl_autopartition_scheme','cl_autopartition_device',
                    'cl_autopartition_table','cl_autopartition_root_size'),
            expert_label=_("Click to set up autopartition options"))
        dv.addGroup(_("Mount points"),
            normal=('os_location_data',),
            brief=('os_location_data','os_install_mbr'),
            expert=('os_install_scratch','cl_uuid_set',
                    'os_install_root_type','os_install_mbr',
                    'os_install_kernel_scheduler'))
        dv.addGroup(_("Network settings"),
            normal=('os_install_net_conf','os_install_net_data',
                    'os_install_net_fqdn','os_install_ntp'),
            expert=('os_install_net_dns','os_install_net_dns_search',
                    'os_install_net_route_data',))
        dv.addGroup(_("Users"),
            normal=('cl_migrate_root_pwd','cl_migrate_data','cl_autologin'),
            hide=('cl_migrate_data',),
            brief=('cl_migrate_user',))
        dv.addGroup(_("Video"),
            normal=('os_install_x11_video_drv','os_install_x11_composite',
                    'os_install_x11_resolution','os_install_fb_resolution'))
        dv.addBrief(next_label=_("Installation"),image="finish")
        return dv

    def fixInstallLocalization(self,sid,dv):
        """
        Fix localization on change lang in install method
        """
        curThread = threading.currentThread()
        curThread.lang = dv.Get('os_install_locale_lang')
        currentLang = self.get_cache(sid,"install","lang")
        if currentLang != curThread.lang:
            dv.clearGroups()
            self.install_vars(dv)
            dv.reinit()
            return True
        else:
            return False

    @rpc(Integer, ViewParams, _returns = ViewInfo)
    @catchExcept
    def install_view (self, sid, params):
        dv = self.get_cache(sid,"install","vars")
        if not dv:
            dv = self.install_vars()
            langChanged = False
        else:
            langChanged = self.fixInstallLocalization(sid,dv)
            lang = dv.Get('os_install_locale_lang')
            self.set_cache(sid,"install","lang",lang,smart=False)
            dv.processRefresh()
        self.set_cache(sid, 'install', "vars",dv,smart=False)
        view = ViewInfo(dv,step=params.step,
                           expert=params.expert,
                           brief=params.brief,
                           has_brief=True,
                           allsteps=langChanged,
                           brief_label=_("Start installing"))
        return view

    def install_flash_vars(self):
        dv = cl_install.DataVarsInstall()
        dv.importInstall()
        dv.flIniFile()
        dv.Set('cl_action','system',True)
        dv.Set('cl_install_type','flash')
        dv.addGroup(_("Flash install"),
            normal=('os_install_disk_single','cl_image_filename'),
            expert=('os_location_data',),
            next_label=_("Install"))
        return dv

    @rpc(Integer, InstallInfo, _returns = Array(ReturnedMessage))
    @core_method(category=__('Installation'),title=__('Flash install'),
        image='drive-removable-media-usb-pendrive,media-flash',
        gui=True, rights=['install'])
    def install_flash ( self, sid, info):
        """
        Install to flash
        """
        return self.installCommon(sid,info,'install_flash',
                                  self.install_flash_vars)

    @rpc(Integer, ViewParams,_returns = ViewInfo)
    @catchExcept
    def install_flash_view (self, sid, params):
        dv = self.get_cache(sid,"install_flash","vars")
        if not dv:
            dv = self.install_flash_vars()
        else:
            dv.processRefresh()
        self.set_cache(sid, 'install_flash', "vars",dv,smart=False)
        view = ViewInfo(dv,step=params.step,
                           expert=params.expert,
                           brief=params.brief)
        return view

    def install_pxe_vars(self):
        dv = cl_install.DataVarsInstall()
        dv.importInstall()
        dv.flIniFile()
        dv.Set('cl_action','system',True)
        dv.Set('os_install_pxe','on',True)
        dv.addGroup(None,
            normal=('cl_image_filename',),
            expert=('os_install_pxe_path',),
            next_label=_("Install"))
        return dv

    @rpc(Integer, InstallInfo, _returns = Array(ReturnedMessage))
    @core_method(category=__('Installation'),title=__('PXE install'),
        image='network-server',command='cl-install-pxe',
        gui=True, rights=['installpxe'])
    def install_pxe ( self, sid, info):
        """
        Install to flash
        """
        return self.installCommon(sid,info,'install_pxe',
                                  self.install_pxe_vars)

    @rpc(Integer, ViewParams,_returns = ViewInfo)
    @catchExcept
    def install_pxe_view (self, sid, params):
        dv = self.get_cache(sid,"install_pxe","vars")
        if not dv:
            dv = self.install_pxe_vars()
        else:
            dv.processRefresh()
        self.set_cache(sid, 'install_pxe', "vars",dv,smart=False)
        view = ViewInfo(dv,step=params.step,
                           expert=params.expert,
                           brief=params.brief)
        return view

    def setup_network_vars(self):
        dv = cl_install.DataVarsInstall()
        dv.importInstall()
        dv.flIniFile()
        dv.Set('cl_action','merge',True)
        dv.Set('cl_belong_pkg',[None],True)
        dv.Set('cl_setup','network',True)
        dv.addGroup(None,
            normal=('os_install_net_conf','os_install_net_data',
                    'os_install_net_fqdn','os_install_ntp'),
            expert=('os_install_net_dns','os_install_net_dns_search',
                    'os_install_net_route_data',),
            next_label=_("Save"))
        return dv

    @rpc(Integer, InstallInfo, _returns = Array(ReturnedMessage))
    @core_method(category=__('Configuration'),title=__('Network'),
        image='network-idle,preferences-system-network',
        command="cl-setup-network",
        gui=True, rights=['setup'])
    def setup_network ( self, sid, info):
        """
        Setup network
        """
        return self.installCommon(sid,info,'setup_network',
                                  self.setup_network_vars,
                                  installFunc="setupSystem")

    @rpc(Integer, ViewParams,_returns = ViewInfo)
    @catchExcept
    def setup_network_view (self, sid, params):
        dv = self.get_cache(sid,"setup_network","vars")
        if not dv:
            dv = self.setup_network_vars()
        else:
            dv.processRefresh()
        self.set_cache(sid, 'setup_network', "vars",dv,smart=False)
        view = ViewInfo(dv,step=params.step,
                           expert=params.expert,
                           brief=params.brief)
        return view

    def setup_video_vars(self):
        dv = cl_install.DataVarsInstall()
        dv.importInstall()
        dv.flIniFile()
        dv.Set('cl_action','merge',True)
        dv.Set('cl_belong_pkg',[None],True)
        dv.Set('cl_setup','video',True)
        dv.addGroup(None,
            normal=('os_install_x11_video_drv', 'os_install_x11_resolution',
                    'os_install_x11_composite', 'os_install_fb_resolution'),
            next_label=_("Save"))
        return dv

    @rpc(Integer, InstallInfo, _returns = Array(ReturnedMessage))
    @core_method(category=__('Configuration'),title=__('Video'),
        image='gnome-multimedia,video-display',
        command="cl-setup-video",
        gui=True, rights=['setup'])
    def setup_video ( self, sid, info):
        """
        Setup video
        """
        return self.installCommon(sid,info,'setup_video',
                                  self.setup_video_vars,
                                  installFunc="setupSystem")

    @rpc(Integer, ViewParams,_returns = ViewInfo)
    @catchExcept
    def setup_video_view (self, sid, params):
        dv = self.get_cache(sid,"setup_video","vars")
        if not dv:
            dv = self.setup_video_vars()
        else:
            dv.processRefresh()
        self.set_cache(sid, 'setup_video', "vars",dv,smart=False)
        view = ViewInfo(dv,step=params.step,
                           expert=params.expert,
                           brief=params.brief)
        return view

    def setup_locale_vars(self):
        dv = cl_install.DataVarsInstall()
        dv.importInstall()
        dv.flIniFile()
        dv.Set('cl_action','merge',True)
        dv.Set('cl_belong_pkg',[None],True)
        dv.Set('cl_setup','locale',True)
        dv.addGroup(None,
            normal=('os_install_locale_lang',
                    'os_install_clock_timezone'),
            next_label=_("Save"))
        return dv

    @rpc(Integer, InstallInfo, _returns = Array(ReturnedMessage))
    @core_method(category=__('Configuration'),title=__('Locale'),
        image='locale,preferences-desktop-locale',
        command="cl-setup-locale",
        gui=True, rights=['setup'])
    def setup_locale ( self, sid, info):
        """
        Setup locale
        """
        return self.installCommon(sid,info,'setup_locale',
                                  self.setup_locale_vars,
                                  installFunc="setupSystem")

    @rpc(Integer, ViewParams,_returns = ViewInfo)
    @catchExcept
    def setup_locale_view (self, sid, params):
        dv = self.get_cache(sid,"setup_locale","vars")
        if not dv:
            dv = self.setup_locale_vars()
        else:
            dv.processRefresh()
        self.set_cache(sid, 'setup_locale', "vars",dv,smart=False)
        view = ViewInfo(dv,step=params.step,
                           expert=params.expert,
                           brief=params.brief)
        return view

    def setup_boot_vars(self):
        dv = cl_install.DataVarsInstall()
        dv.importInstall()
        dv.flIniFile()
        dv.Set('cl_action','merge',True)
        dv.Set('cl_belong_pkg',[None],True)
        dv.Set('cl_setup','boot',True)
        dv.addGroup(None,
            normal=('os_install_mbr',
                    'os_install_kernel_scheduler'),
            next_label=_("Save"))
        return dv

    @rpc(Integer, InstallInfo, _returns = Array(ReturnedMessage))
    @core_method(category=__('Configuration'),title=__('Boot'),
        image='stock_save,drive-harddisk',command="cl-setup-boot",
        gui=True, rights=['setup'])
    def setup_boot ( self, sid, info):
        """
        Setup locale
        """
        return self.installCommon(sid,info,'setup_boot',
                                  self.setup_boot_vars,
                                  installFunc="setupSystem")

    @rpc(Integer, ViewParams,_returns = ViewInfo)
    @catchExcept
    def setup_boot_view (self, sid, params):
        dv = self.get_cache(sid,"setup_boot","vars")
        if not dv:
            dv = self.setup_boot_vars()
        else:
            dv.processRefresh()
        self.set_cache(sid, 'setup_boot', "vars",dv,smart=False)
        view = ViewInfo(dv,step=params.step,
                           expert=params.expert,
                           brief=params.brief)
        return view

    def setup_system_vars(self):
        dv = cl_install.DataVarsInstall()
        dv.importInstall()
        dv.flIniFile()
        dv.Set('cl_action','merge',True)
        dv.addGroup(None,
            normal=("cl_live",),
            expert=('cl_templates_locate',),
            next_label=_("Reconfigure"))
        return dv

    @rpc(Integer, InstallInfo, _returns = Array(ReturnedMessage))
    @core_method(category=__('Configuration'),title=__('System'),
        image='system,computer',command="cl-setup-system",
        gui=True, rights=['setup'])
    def setup_system ( self, sid, info):
        """
        Setup system
        """
        return self.installCommon(sid,info,'setup_system',
                                  self.setup_system_vars,
                                  installFunc="setupSystem")

    @rpc(Integer, ViewParams,_returns = ViewInfo)
    @catchExcept
    def setup_system_view (self, sid, params):
        dv = self.get_cache(sid,"setup_system","vars")
        if not dv:
            dv = self.setup_system_vars()
        else:
            dv.processRefresh()
        self.set_cache(sid, 'setup_system', "vars",dv,smart=False)
        view = ViewInfo(dv,step=params.step,
                           expert=params.expert,
                           brief=params.brief)
        return view
