import os
import sys
import re
from os import path
from calculate.lib.datavars import Variable,VariableError,ReadonlyVariable, \
                    ReadonlyTableVariable,FieldValue
from calculate.lib.utils.files import readLinesFile,process
from itertools import *

from calculate.lib.cl_lang import setLocalTranslate
setLocalTranslate('cl_desktop3',sys.modules[__name__])

class VariableUrJidHost(ReadonlyVariable):
    """
    Jabber host for user
    """
    def get(self):
        userJid = self.Get("ur_jid")
        if userJid:
            return userJid.partition('@')[2]
        return ""

class VariableUrDomainSet(ReadonlyVariable):
    """
    Flag for determining domain user or local
    """
    def getUserDataInFile(self, login, filePasswd):
        return filter(lambda x: x[0]==login,
               map(lambda x: x.strip().split(':'),
               readLinesFile(filePasswd)))

    def get(self):
        ret = "off"
        userName = self.Get("ur_login")
        if userName:
            try:
                passwdUserData = self.getUserDataInFile(userName, "/etc/passwd")
            except:
                return ret
            if passwdUserData:
                passwdUserData = passwdUserData[0]
                try:
                    cacheUserData = self.getUserDataInFile(userName,
                        "/var/lib/calculate/calculate-client/cache/passwd")
                except:
                    return ret
                if cacheUserData:
                    cacheUserData = cacheUserData[0]
                    if cacheUserData == passwdUserData:
                        ret = "on"
            else:
                ret = "on"
        return ret

class VariableClDesktopXsession(ReadonlyVariable):
    """
    User current X session
    """
    def get(self):
        envXsessionFile = "/etc/env.d/90xsession"
        xsession = os.environ.get("XSESSION",None)
        desktopSession = os.environ.get("DESKTOP_SESSION",None)
        if not xsession:
            if os.path.exists(envXsessionFile):
                xsession = \
                    map(lambda x:x.partition("=")[2].strip("'\""),
                    filter(lambda x:x.startswith("XSESSION="),
                    filter(lambda x:not x.startswith("#"),
                    open(envXsessionFile,"r"))))
                if xsession:
                    xsession = xsession[-1]
        if xsession:
            if desktopSession and \
                any(x in desktopSession.lower()
                    for x in ("kde","xfce","gnome")):
                xsession = desktopSession
            if "kde" in xsession.lower():
                return "kde"
            elif "gnome" in xsession.lower():
                return "gnome"
            elif "xfce" in xsession.lower():
                return "xfce"
            else:
                return xsession.lower()
        return ""

class VariableClDesktopGstData(ReadonlyVariable):
    """
    GStreamer data
    """
    def get(self):
        # try import gst
        try:
            copyargv = sys.argv
            sys.argv = []
            olderr = os.dup(sys.stderr.fileno())
            os.close(sys.stderr.fileno())
            import gst
            import gst.interfaces
        except ImportError:
            gst = None
        finally:
            sys.argv= copyargv
            os.dup2(olderr,sys.stderr.fileno())
        if gst is None:
            return {}

        outdata = {}
        try:
            pipeline = "alsamixer"
            alsamixer = gst.element_factory_make(pipeline)
            res = alsamixer.set_state(gst.STATE_PAUSED)
            if res == gst.STATE_CHANGE_SUCCESS:
                outdata['device_name'] = alsamixer.get_property("device-name")
                outdata['long_name'] = alsamixer.get_factory().get_longname()
                outdata['internal_name'] = filter(str.isalnum,
                                "%s (%s)"%(outdata['device_name'],
                                           outdata['long_name']))
                outdata['channels'] = []
                for t in alsamixer.list_tracks():
                    if t.flags & gst.interfaces.MIXER_TRACK_OUTPUT:
                        if t.flags & gst.interfaces.MIXER_TRACK_MASTER or \
                            any(x in t.label 
                                for x in ("Wave","Front","LFE","Center",
                                          "Head","Side","Speaker",
                                          "Surround","PCM")):
                            outdata['channels'].append(t.label)
                            if t.flags & gst.interfaces.MIXER_TRACK_MASTER:
                                outdata['master_channel'] = t.label
        except:
            pass
        return outdata

class VariableClDesktopGstCard(ReadonlyVariable):
    """
    Internal card name for xfce mixer
    """
    def get(self):
        return self.Get('cl_desktop_gst_data').get('internal_name','')

class VariableClDesktopGstMasterchannel(ReadonlyVariable):
    """
    Master track name
    """
    def get(self):
        return self.Get('cl_desktop_gst_data').get('master_channel','')


class VariableClDesktopXfceMixer(ReadonlyVariable):
    """
    List of channel for xfce-perchannel mixer
    """
    def get(self):
        return "\n".join(
               map(lambda x:'      <value type="string" value="%s" />'%x,
               self.Get('cl_desktop_gst_data').get('channels',[])))

class VariableClDesktopOnlineData(ReadonlyTableVariable):
    """
    Information about online users
    """
    source = ['cl_desktop_online_user',
              'cl_desktop_online_display']

    reDisplay = re.compile(r"^\(?:(\d+\.?\d*)")

    def _getDisplay(self,*args):
        """
        Get DISPLAY from args
        """
        for arg in map(self.reDisplay.search,args):
            if arg:
                return arg.group(1)
        return ""

    def get(self,hr=False):
        xSession = 0
        foundTwoSession = False
        resWho = process("who")
        xData = [[]]
        if resWho.success():
            listProcessing = lambda x: (x[0], x[1], x[-1]) \
                             if len(x)>=5 else []
            xData = map(lambda x:x[1].next(),
                    groupby(
                    sorted(
                    filter(lambda x: x[0]!="root",
                    map(lambda x: (x[0],self._getDisplay(x[1],x[2])),
                    filter(lambda x: x and\
                              (x[2].startswith("(:") or \
                               x[1].startswith(":")),
                    map(lambda x: listProcessing(\
                    filter(lambda y: y, x.split())),
                    resWho)))),
                    key=lambda x:x[0]),
                    lambda x:x[0]))
        return xData

    setValue = Variable.setValue

class VariableClDesktopOnlineUser(FieldValue,ReadonlyVariable):
    """
    User name
    """
    type = "list"
    source_variable = "cl_desktop_online_data"
    column = 0

class VariableClDesktopOnlineDisplay(FieldValue,ReadonlyVariable):
    """
    Display for user
    """
    type = "list"
    source_variable = "cl_desktop_online_data"
    column = 1
