#-*- coding: utf-8 -*-

#Copyright 2008 Calculate Pack, http://www.calculate-linux.ru
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

#Допустимые ключи значений
#   mode -     режим переменной r-не переназначается из командной строки,
#              w-переназначается из командной строки
#   type     - тип переменной состоит из двух элементов(что это и для чего
#              это)
#   value    - дефолтное значение переменной
#   select   - список допустимых значений переменной
#   official - флаг того, что данная переменная служебная и не отображается
#              при печати списка значений переменных
#   printval - печатное значение переменной(значение выводимое при печати
#              списка значений переменных)

class Data:
    #базовый суффикс LDAP
    #Vl soft_ldap_base
    ld_base_dn = {}

    #bind суффикс LDAP
    #Vl soft_ldap_bind
    ld_bind_dn = {}

    #пользователь только для чтения
    #Vl soft_ldap_bindname
    ld_bind_login = {'value':'proxyuser'}

    #hash пароля для пользователя для чтения
    #Vl soft_ldap_bindpw_hash
    ld_bind_hash = {}

    #пароль для пользователя для чтения
    #Vl soft_ldap_bindpw
    ld_bind_pw = {'value':'calculate'}

    #алгоритм шифрования паролей
    #Vl soft_ldap_hash_encrypt
    ld_encrypt = {'value':'{SSHA}'}

    #имя для базового суффикса LDAP
    #Vl soft_ldap_root
    ld_base_root = {'value':'calculate'}

    #временный пользователь root для инициализации базы данных
    #V soft_ldap_admin_tmp
    ld_temp_dn = {}

    #hash пароля временного root
    #V soft_ldap_adminpw_tmp_hash
    ld_temp_hash = {}

    #пароль временного пользователя root
    #V soft_ldap_adminpw_tmp
    ld_temp_pw = {}

    #DN пользователя root
    #V soft_ldap_admin
    ld_admin_dn = {}

    #имя пользователя root для LDAP
    #V soft_ldap_adminname
    ld_admin_login = {'value':'ldapadmin'}

    #hash пароля root
    #V soft_ldap_adminpw_hash
    ld_admin_hash = {}

    #пароль root
    #V soft_ldap_adminpw
    ld_admin_pw = {}

    #имя samba домена
    #V soft_samba_domain
    sr_samba_domain = {'mode':"w",'value':'Calculate'}

    #netbios имя samba домена
    #V soft_samba_netbios
    sr_samba_netbios = {'mode':"w"}

    #Логин LDAP пользователя
    #V soft_ldap_user_login
    ur_name = {'mode':"w"}

    #Полное имя LDAP пользователя
    #V soft_ldap_user_full_name
    ur_fio = {'mode':"w"}

    #ID LDAP пользователя (номер пользователя)
    #V soft_ldap_user_id
    ur_id = {'mode':"w"}

    #GID LDAP пользователя (номер группы пользователя)
    #V soft_ldap_user_gid
    ur_gid = {'mode':"w"}

    #Домашняя директория LDAP пользователя
    #V soft_ldap_user_home
    ur_home_path = {'mode':"w"}

    #Оболочка LDAP пользователя
    #V soft_ldap_user_shell
    ur_shell = {'mode':"w"}

    #Хеш пароля LDAP пользователя
    #V soft_ldap_user_pw_hash
    ur_hash = {'mode':"w"}

    #Название группы
    #V soft_ldap_group_name
    ur_group = {'mode':"w"}

    #ID группы
    #V soft_ldap_group_id
    ur_group_id = {'mode':"w"}

    #Полное имя группы
    #V soft_ldap_group_desc
    ur_group_comment = {'mode':"w"}

    # Видимость пользователя с другого компьютера
    #V soft_ldap_user_visible
    ur_visible = {'mode':"w"}

    #Организация пользователя
    ur_organization = {'mode':'w'}

    #Сигнатура пользователя
    ur_signature = {'mode':'w'}

    # имя компьютера с настроенным сервисом Mail
    sr_mail_host = {}

    # шифрование при получении - ''/ssl/tls
    sr_mail_crypt = {'mode':"w",'value':'tls'}
    # порт получения
    sr_mail_port = {'mode':"w",'value':'143'}
    # тип получения - pop3/imap/all
    sr_mail_type = {'mode':"w",'value':'imap'}
    # шифрование отправки - ''/ssl/tls
    sr_mail_send_crypt = {'mode':"w"}
    # порт отправки
    sr_mail_send_port = {'mode':"w",'value':'25'}
    # хост отправки
    sr_mail_send_host = {'mode':"w"}

    # имя компьютера с настроенным сервисом Samba
    sr_samba_host = {}

    # имя компьютера с настроенным сервисом Jabber
    sr_jabber_host = {}

    # шифрование при получении - ''/ssl
    sr_jabber_crypt = {'mode':"w",'value':'ssl'}

    # порт jabber сервиса
    sr_jabber_port = {'mode':"w",'value':'5223'}

    # включение хранения истории сообщений jabber сервиса
    # по умолчанию выключено
    sr_jabber_history = {'mode':"w",
                         'value':'off'}

    #Логин компьютера
    #V soft_ldap_machine_login
    sr_samba_machine_login = {'mode':"w"}

    #ID LDAP компьютера (номер компьютера)
    #V soft_ldap_machine_id
    sr_samba_machine_id = {'mode':"w"}

    #GID LDAP компьютера (номер первичной группы компьютера)
    #V soft_ldap_machine_gid
    sr_samba_machine_gid = {'mode':"w"}

    #Название первичной группы компьютера
    #V soft_ldap_machine_group_name
    sr_samba_machine_group = {'mode':"w",
                              'value':'Computers'}

    #-----------------------------------------------------
    #Все сервисы Unix
    #-----------------------------------------------------
    #Имя для всех сервисов
    #V soft_ldap_sevices_dn_name
    ld_services= {'value' : 'Services'}

    #DN всех сервисов
    #V soft_ldap_sevices_dn
    ld_services_dn =  {}

    #Настроен или нет сервис LDAP
    #V soft_ldap_setup
    sr_ldap_set = {'mode':"w",'value':'off'}

    #имя устанавливаемого сервиса
    #V soft_ldap_setup_name
    cl_pass_service = {'mode':"w"}

    #проход при наложении профилей 1,2,3,4,5 и.т д
    #V setup_pass_parser
    cl_pass_step = {'mode':"w"}

    #директория куда будут записаны данные удаленных пользователей
    #V soft_ldap_delete_user_dir
    sr_deleted_path = {'mode':"w",
                        'value':'/var/calculate/server-backup/deleted'}

    #-----------------------------------------------------
    #Сервис Unix
    #-----------------------------------------------------
    #DN администратора сервиса Unix (он, же DN сервиса)
    #V soft_ldap_admin_unix
    ld_unix_dn = {}

    #имя администратора сервиса Unix
    #V soft_ldap_admin_unix_name
    ld_unix_login = {'value':'Unix'}

    #пароль администратора сервиса Unix
    #V soft_ldap_admin_unixpw
    ld_unix_pw = {}

    #hash пароля администратора сервиса Unix
    #V soft_ldap_admin_unixpw_hash
    ld_unix_hash = {}

    #Настроен или нет сервис Unix
    #V soft_unix_setup
    sr_unix_set = {'mode':"w",
                   'value':'off'}

    #-----------------------------------------------------
    #Сервис Samba
    #-----------------------------------------------------
    #DN администратора сервиса Samba (он, же DN сервиса)
    #V soft_ldap_admin_samba
    ld_samba_dn = {}

    #имя администратора сервиса Samba
    #V soft_ldap_admin_samba_name
    ld_samba_login = {'value':'Samba'}

    #пароль администратора сервиса Samba
    #V soft_ldap_admin_sambapw
    ld_samba_pw = {}

    #hash пароля администратора сервиса Samba
    #V soft_ldap_admin_sambapw_hash
    ld_samba_hash = {}

    # Директория настроек пользователя windows
    #V soft_samba_winprofile_path
    sr_samba_winprof_path = {\
                    'value':'/var/calculate/server-data/samba/profiles/win'}

    # Директория хранения настроек пользователя linux
    #V soft_samba_linprofile_path
    sr_samba_linprof_path = {\
                    'value':'/var/calculate/server-data/samba/profiles/unix'}

    # Домашняя директория
    #V soft_samba_home_path
    sr_samba_home_path = {\
                    'value':'/var/calculate/server-data/samba/home'}

    # Директория netlogon
    #V soft_samba_winlogon_path
    sr_samba_winlogon_path = {\
                    'value':'/var/calculate/server-data/samba/netlogon'}

    # Директория share
    #V soft_samba_share_path
    sr_samba_share_path = {\
                    'value':'/var/calculate/server-data/samba/share'}

    # Настроен или нет сервис Samba
    #V soft_samba_setup
    sr_samba_set = {'mode':"w",
                    'value':'off'}

    #-----------------------------------------------------
    #Сервис Mail
    #-----------------------------------------------------
    #DN администратора сервиса Mail (он, же DN сервиса)
    #V soft_ldap_admin_mail
    ld_mail_dn = {}

    #имя администратора сервиса Mail
    #V soft_ldap_admin_mail_name
    ld_mail_login = {'value':'Mail'}

    #пароль администратора сервиса Mail
    #V soft_ldap_admin_mailpw
    ld_mail_pw = {}

    #hash пароля администратора сервиса Mail
    #V soft_ldap_admin_mailpw_hash
    ld_mail_hash = {}

    #почтовый релей
    # Пример заполнения:
    #    value:', 212.113.122.130'
    #soft_ldap_mail_relay
    sr_mail_relay = {}

    # Директория хранения писем
    #V soft_ldap_mail_path
    sr_mail_path = {'value':'/var/calculate/server-data/mail'}

    #Настроен или нет сервис Mail
    #V soft_mail_setup
    sr_mail_set = {'mode':"w",
                   'value':'off'}

    #-----------------------------------------------------
    #Сервис Jabber
    #-----------------------------------------------------
    #DN администратора сервиса Jabber (он, же DN сервиса)
    #V soft_ldap_admin_jabber
    ld_jabber_dn = {}

    #имя администратора сервиса Jabber
    #V soft_ldap_admin_jabber_name
    ld_jabber_login = {'value':'Jabber'}

    #пароль администратора сервиса Jabber
    #V soft_ldap_admin_jabberpw
    ld_jabber_pw = {}

    #hash пароля администратора сервиса Jabber
    #V soft_ldap_admin_jabberpw_hash
    ld_jabber_hash = {}

    #Настроен или нет сервис Jabber
    #V soft_jabber_setup
    sr_jabber_set = {'mode':"w",
                   'value':'off'}

    #-----------------------------------------------------
    #Сервис FTP
    #-----------------------------------------------------
    # имя компьютера с настроенным сервисом FTP
    cl_remote_ftp = {}

    #DN администратора сервиса FTP (он, же DN сервиса)
    #V soft_ldap_admin_ftp
    ld_ftp_dn = {}

    #имя администратора сервиса FTP
    #V soft_ldap_admin_ftp_name
    ld_ftp_login = {'value':'Ftp'}

    #пароль администратора сервиса FTP
    #V soft_ldap_admin_ftppw
    ld_ftp_pw = {}

    #hash пароля администратора сервиса FTP
    #V soft_ldap_admin_ftppw_hash
    ld_ftp_hash = {}

    #Настроен или нет сервис FTP
    #V soft_ftp_setup
    sr_ftp_set = {'mode':"w",
                   'value':'off'}

    # Директория для ftp
    sr_ftp_path = {'value':'/var/calculate/server-data/ftp'}

    ##список накладываемых профилей при установке, наложении профилей
    #setup_path_profinstall
    cl_profile_path = {}

    #путь к директории относительно которой происходит наложение профилей на
    #файлы системы
    #setup_path_install
    cl_root_path = {'value':'/'}

    # Calculate плюс версия калкулэйта для записи в заголовок файла
    # объединяемого с профилем
    #setup_name
    cl_ver = {'value':'Calculate-server 2.0.6'}

    #DN LDAP ветки, в котором будут находится служебные ветки
    ld_ldap_dn = {}
    #имя LDAP ветки 
    ld_ldap_login = {'value':'LDAP'}

    #Репликация
    # имя компьютера c включенной репликацией
    ld_repl_host = {}
    #Включена или нет репликация
    ld_repl_set  = {'mode':"w",'value':'off'}
    # DN ветки репликации
    ld_repl_dn = {}
    # имя ветки репликации
    ld_repl_login = {'value':'Replication'}
    # пароль ветки репликации
    ld_repl_pw = {}
    # хеш пароля ветки репликации
    ld_repl_hash = {}
    #DN ветки хранения последнего посещенного сервера
    ld_repl_worked_dn = {}
    #имя ветки 
    ld_repl_worked_login = {'value':'Worked'}
    #DN ветки хранения аттрибутов доступа пользователя
    ld_repl_access_dn = {}
