#-*- coding: utf-8 -*-

#Copyright 2008 Calculate Pack, http://www.calculate-linux.ru
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
import os
import cl_base
import cl_utils

class fillVars(object, cl_base.glob_attr):

    def getHash(self, password, encrypt):
        """Получить хеш пароля

        password - пароль
        encrypt - алгоритм шифрования, например '{SSHA}'
        """
        runStr='%s slappasswd -s %s -h %s'%\
                (self.path_env, password, encrypt)
        res=self._runos(runStr)
        if res:
            return res.strip()
        print "Error generate hash (slappasswd)"
        exit(1)

    def get_cl_profile_path(self):
        """список накладываемых профилей при установке, наложении профилей"""
        profpath = []
        profPaths = ['/usr/lib/calculate/calculate-server/profile',
                     '/var/calculate/remote/server-profile',
                     '/var/calculate/server-profile']
        for profPath in profPaths:
            if os.path.exists(profPath):
               profpath.append(profPath)
        return profpath

    def get_ld_base_dn(self):
        """базовый DN LDAP"""
        return "dc=%s"%(self.Get('ld_base_root'))

    def get_ld_bind_dn(self):
        """bind DN LDAP"""
        return "cn=%s,%s"% (self.Get('ld_bind_login'),
                self.Get('ld_base_dn'))

    def get_ld_bind_hash(self):
        """hash пароля для пользователя для чтения"""
        return self.getHash(self.Get('ld_bind_pw'), self.Get('ld_encrypt'))

    def get_ld_temp_dn(self):
        #DN временного пользователя root (для инициализации базы данных)
        return "cn=ldaproot,%s"%self.Get('ld_base_dn')

    def get_ld_temp_pw(self):
        """пароль временного пользователя root"""
        return cl_utils.genpassword().strip()

    def get_ld_temp_hash(self):
        """hash пароля временного root"""
        return self.getHash(self.Get('ld_temp_pw'), self.Get('ld_encrypt'))

    def get_ld_admin_dn(self):
        """DN  пользователя root"""
        return "cn=%s,%s"% (self.Get('ld_admin_login'),self.Get('ld_base_dn'))

    def get_ld_admin_hash(self):
        """hash пароля root"""
        return self.getHash(self.Get('ld_admin_pw'), self.Get('ld_encrypt'))

    def get_ld_admin_pw(self):
        """пароль root"""
        return cl_utils.genpassword().strip()

    def get_ld_services_dn(self):
        """DN для всех сервисов"""
        return "ou=%s,%s"%(self.Get('ld_services'), self.Get('ld_base_dn'))

    def get_ld_unix_dn(self):
        """DN сервиса Unix"""
        return "ou=%s,%s" %(self.Get('ld_unix_login'),
            self.Get('ld_services_dn'))

    def get_ld_unix_pw(self):
        """пароль администратора сервиса Unix"""
        return cl_utils.genpassword().strip()

    def get_ld_unix_hash(self):
        """hash пароля администратора сервиса Unix"""
        return self.getHash(self.Get('ld_unix_pw'), self.Get('ld_encrypt'))

    def get_ld_samba_dn(self):
        """DN сервиса Samba"""
        return "ou=%s,%s" %(self.Get('ld_samba_login'),
            self.Get('ld_services_dn'))

    def get_ld_samba_pw(self):
        """пароль администратора сервиса Samba"""
        return cl_utils.genpassword().strip()

    def get_ld_samba_hash(self):
        """hash пароля администратора сервиса Samba"""
        return self.getHash(self.Get('ld_samba_pw'), self.Get('ld_encrypt'))

    def get_sr_samba_netbios(self):
        """netbios имя samba домена"""
        return self.Get('os_net_hostname')

    def get_ld_mail_dn(self):
        """DN сервиса Mail"""
        return "ou=%s,%s" %(self.Get('ld_mail_login'),
            self.Get('ld_services_dn'))

    def get_ld_mail_pw(self):
        """пароль администратора сервиса Mail"""
        return cl_utils.genpassword().strip()

    def get_ld_mail_hash(self):
        """hash пароля администратора сервиса Mail"""
        return self.getHash(self.Get('ld_mail_pw'), self.Get('ld_encrypt'))

    def get_ld_jabber_dn(self):
        """DN сервиса Jabber"""
        return "ou=%s,%s" %(self.Get('ld_jabber_login'),
            self.Get('ld_services_dn'))

    def get_ld_jabber_pw(self):
        """пароль администратора сервиса Jabber"""
        return cl_utils.genpassword().strip()

    def get_ld_jabber_hash(self):
        """hash пароля администратора сервиса Jabber"""
        return self.getHash(self.Get('ld_jabber_pw'), self.Get('ld_encrypt'))

    def get_ld_ftp_dn(self):
        """DN сервиса FTP"""
        return "ou=%s,%s" %(self.Get('ld_ftp_login'),
            self.Get('ld_services_dn'))

    def get_ld_ftp_pw(self):
        """пароль администратора сервиса FTP"""
        return cl_utils.genpassword().strip()

    def get_ld_ftp_hash(self):
        """hash пароля администратора сервиса FTP"""
        return self.getHash(self.Get('ld_ftp_pw'), self.Get('ld_encrypt'))

    def get_sr_mail_host(self):
        """имя компьютера с настроенным сервисом Mail"""
        fullHostName = "%s.%s"%(self.Get('os_net_hostname'),
                               self.Get('os_net_domain'))
        if fullHostName:
            return fullHostName
        else:
            return ""

    def get_sr_jabber_host(self):
        """имя компьютера с настроенным сервисом Jabber"""
        fullHostName = "%s.%s"%(self.Get('os_net_hostname'),
                               self.Get('os_net_domain'))
        if fullHostName:
            return fullHostName
        else:
            return ""

    def get_ld_repl_host(self):
        """имя компьютера c включенной репликацией"""
        fullHostName = "%s.%s"%(self.Get('os_net_hostname'),
                               self.Get('os_net_domain'))
        if fullHostName:
            return fullHostName
        else:
            return ""

    def get_ld_repl_pw(self):
        """пароль ветки репликации"""
        return cl_utils.genpassword().strip()

    def get_ld_repl_hash(self):
        """hash пароля ветки репликации"""
        return self.getHash(self.Get('ld_repl_pw'),
                            self.Get('ld_encrypt'))

    def get_ld_ldap_dn(self):
        """DN основной служебной ветки LDAP"""
        return "ou=%s,%s"%(self.Get('ld_ldap_login'),
                           self.Get('ld_services_dn'))

    def get_ld_repl_dn(self):
        """DN ветки репликации"""
        return "ou=%s,%s"%(self.Get('ld_repl_login'), self.Get('ld_ldap_dn'))

    def get_ld_repl_worked_dn(self):
        """DN ветки хранения последнего посещенного сервера"""
        return "ou=%s,%s" %(self.Get('ld_repl_worked_login'),
                            self.Get('ld_repl_dn'))
