# -*- coding: utf-8 -*-
from abc import ABCMeta, abstractmethod

class abs_api:
    __metaclass__ = ABCMeta

    @abstractmethod
    def getServiceName(self):
        '''Get name service'''

    @abstractmethod
    def isSetup(self):
        '''Is setup service (True/False)'''

    @abstractmethod
    def isStart(self):
        '''Is run server (True/False)'''

    @abstractmethod
    def start(self):
        '''Start server'''

    @abstractmethod
    def restart(self):
        '''Restart server'''

    @abstractmethod
    def stop(self):
        '''Stop server'''

    @abstractmethod
    def isRunlevel(self):
        '''Is server in run level (True/False)'''

    @abstractmethod
    def addRunlevel(self):
        '''Add daemon to runlevel'''

    @abstractmethod
    def delRunlevel(self):
        '''Add daemon to runlevel'''

    @abstractmethod
    def getRunPrioritet(self):
        '''Get run daemon prioritet 0-100
        users 50-70
        '''
